/* -*- mode: c; c-basic-offset: 4; indent-tabs-mode: nil -*- */
/* plugins/preauth/pkinit/pkinit_constants.c */
/*
 * Copyright (C) 2011,2021 by the Massachusetts Institute of Technology.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * * Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 *
 * * Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in
 *   the documentation and/or other materials provided with the
 *   distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "pkinit.h"

/* RFC 8636 id-pkinit-kdf-ah-sha1: iso(1) identified-organization(3) dod(6)
 * internet(1) security(5) kerberosv5(2) pkinit(3) kdf(6) sha1(1) */
static char sha1_oid[8] = { 0x2B, 0x06, 0x01, 0x05, 0x02, 0x03, 0x06, 0x01 };
/* RFC 8636 id-pkinit-kdf-ah-sha256: iso(1) identified-organization(3) dod(6)
 * internet(1) security(5) kerberosv5(2) pkinit(3) kdf(6) sha256(2) */
static char sha256_oid[8] = { 0x2B, 0x06, 0x01, 0x05, 0x02, 0x03, 0x06, 0x02 };
/* RFC 8636 id-pkinit-kdf-ah-sha512: iso(1) identified-organization(3) dod(6)
 * internet(1) security(5) kerberosv5(2) pkinit(3) kdf(6) sha512(3) */
static char sha512_oid[8] = { 0x2B, 0x06, 0x01, 0x05, 0x02, 0x03, 0x06, 0x03 };

const krb5_data sha1_id = { KV5M_DATA, sizeof(sha1_oid), sha1_oid };
const krb5_data sha256_id = { KV5M_DATA, sizeof(sha256_oid), sha256_oid };
const krb5_data sha512_id = { KV5M_DATA, sizeof(sha512_oid), sha512_oid };

krb5_data const * const supported_kdf_alg_ids[] = {
    &sha256_id,
    &sha1_id,
    &sha512_id,
    NULL
};

/* RFC 4055 sha256WithRSAEncryption: iso(1) member-body(2) us(840)
 * rsadsi(113549) pkcs(1) 1 11 */
static char sha256WithRSAEncr_oid[9] = {
    0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x0b
};
/* RFC 4055 sha256WithRSAEncryption: iso(1) member-body(2) us(840)
 * rsadsi(113549) pkcs(1) 1 13 */
static char sha512WithRSAEncr_oid[9] = {
    0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x0d
};

const krb5_data sha256WithRSAEncr_id = {
    KV5M_DATA, sizeof(sha256WithRSAEncr_oid), sha256WithRSAEncr_oid
};
const krb5_data sha512WithRSAEncr_id = {
    KV5M_DATA, sizeof(sha512WithRSAEncr_oid), sha512WithRSAEncr_oid
};

krb5_data const * const supported_cms_algs[] = {
    &sha512WithRSAEncr_id,
    &sha256WithRSAEncr_id,
    NULL
};

/* RFC 2412 section E.2 (well-known group 2) parameters, DER-encoded as
 * DomainParameters (RFC 3279 section 2.3.3). */
static const uint8_t o1024[] = {
    0x30, 0x82, 0x01, 0x0A, 0x02, 0x81, 0x81, 0x00,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xC9, 0x0F, 0xDA, 0xA2, 0x21, 0x68, 0xC2, 0x34,
    0xC4, 0xC6, 0x62, 0x8B, 0x80, 0xDC, 0x1C, 0xD1,
    0x29, 0x02, 0x4E, 0x08, 0x8A, 0x67, 0xCC, 0x74,
    0x02, 0x0B, 0xBE, 0xA6, 0x3B, 0x13, 0x9B, 0x22,
    0x51, 0x4A, 0x08, 0x79, 0x8E, 0x34, 0x04, 0xDD,
    0xEF, 0x95, 0x19, 0xB3, 0xCD, 0x3A, 0x43, 0x1B,
    0x30, 0x2B, 0x0A, 0x6D, 0xF2, 0x5F, 0x14, 0x37,
    0x4F, 0xE1, 0x35, 0x6D, 0x6D, 0x51, 0xC2, 0x45,
    0xE4, 0x85, 0xB5, 0x76, 0x62, 0x5E, 0x7E, 0xC6,
    0xF4, 0x4C, 0x42, 0xE9, 0xA6, 0x37, 0xED, 0x6B,
    0x0B, 0xFF, 0x5C, 0xB6, 0xF4, 0x06, 0xB7, 0xED,
    0xEE, 0x38, 0x6B, 0xFB, 0x5A, 0x89, 0x9F, 0xA5,
    0xAE, 0x9F, 0x24, 0x11, 0x7C, 0x4B, 0x1F, 0xE6,
    0x49, 0x28, 0x66, 0x51, 0xEC, 0xE6, 0x53, 0x81,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0x02, 0x01, 0x02, 0x02, 0x81, 0x80, 0x7F, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE4, 0x87,
    0xED, 0x51, 0x10, 0xB4, 0x61, 0x1A, 0x62, 0x63,
    0x31, 0x45, 0xC0, 0x6E, 0x0E, 0x68, 0x94, 0x81,
    0x27, 0x04, 0x45, 0x33, 0xE6, 0x3A, 0x01, 0x05,
    0xDF, 0x53, 0x1D, 0x89, 0xCD, 0x91, 0x28, 0xA5,
    0x04, 0x3C, 0xC7, 0x1A, 0x02, 0x6E, 0xF7, 0xCA,
    0x8C, 0xD9, 0xE6, 0x9D, 0x21, 0x8D, 0x98, 0x15,
    0x85, 0x36, 0xF9, 0x2F, 0x8A, 0x1B, 0xA7, 0xF0,
    0x9A, 0xB6, 0xB6, 0xA8, 0xE1, 0x22, 0xF2, 0x42,
    0xDA, 0xBB, 0x31, 0x2F, 0x3F, 0x63, 0x7A, 0x26,
    0x21, 0x74, 0xD3, 0x1B, 0xF6, 0xB5, 0x85, 0xFF,
    0xAE, 0x5B, 0x7A, 0x03, 0x5B, 0xF6, 0xF7, 0x1C,
    0x35, 0xFD, 0xAD, 0x44, 0xCF, 0xD2, 0xD7, 0x4F,
    0x92, 0x08, 0xBE, 0x25, 0x8F, 0xF3, 0x24, 0x94,
    0x33, 0x28, 0xF6, 0x73, 0x29, 0xC0, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
};

/* RFC 3526 section 3 (2048-bit MODP Group), RFC 3279 encoding */
static const uint8_t o2048[] = {
    0x30, 0x82, 0x02, 0x0C, 0x02, 0x82, 0x01, 0x01,
    0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xC9, 0x0F, 0xDA, 0xA2, 0x21, 0x68, 0xC2,
    0x34, 0xC4, 0xC6, 0x62, 0x8B, 0x80, 0xDC, 0x1C,
    0xD1, 0x29, 0x02, 0x4E, 0x08, 0x8A, 0x67, 0xCC,
    0x74, 0x02, 0x0B, 0xBE, 0xA6, 0x3B, 0x13, 0x9B,
    0x22, 0x51, 0x4A, 0x08, 0x79, 0x8E, 0x34, 0x04,
    0xDD, 0xEF, 0x95, 0x19, 0xB3, 0xCD, 0x3A, 0x43,
    0x1B, 0x30, 0x2B, 0x0A, 0x6D, 0xF2, 0x5F, 0x14,
    0x37, 0x4F, 0xE1, 0x35, 0x6D, 0x6D, 0x51, 0xC2,
    0x45, 0xE4, 0x85, 0xB5, 0x76, 0x62, 0x5E, 0x7E,
    0xC6, 0xF4, 0x4C, 0x42, 0xE9, 0xA6, 0x37, 0xED,
    0x6B, 0x0B, 0xFF, 0x5C, 0xB6, 0xF4, 0x06, 0xB7,
    0xED, 0xEE, 0x38, 0x6B, 0xFB, 0x5A, 0x89, 0x9F,
    0xA5, 0xAE, 0x9F, 0x24, 0x11, 0x7C, 0x4B, 0x1F,
    0xE6, 0x49, 0x28, 0x66, 0x51, 0xEC, 0xE4, 0x5B,
    0x3D, 0xC2, 0x00, 0x7C, 0xB8, 0xA1, 0x63, 0xBF,
    0x05, 0x98, 0xDA, 0x48, 0x36, 0x1C, 0x55, 0xD3,
    0x9A, 0x69, 0x16, 0x3F, 0xA8, 0xFD, 0x24, 0xCF,
    0x5F, 0x83, 0x65, 0x5D, 0x23, 0xDC, 0xA3, 0xAD,
    0x96, 0x1C, 0x62, 0xF3, 0x56, 0x20, 0x85, 0x52,
    0xBB, 0x9E, 0xD5, 0x29, 0x07, 0x70, 0x96, 0x96,
    0x6D, 0x67, 0x0C, 0x35, 0x4E, 0x4A, 0xBC, 0x98,
    0x04, 0xF1, 0x74, 0x6C, 0x08, 0xCA, 0x18, 0x21,
    0x7C, 0x32, 0x90, 0x5E, 0x46, 0x2E, 0x36, 0xCE,
    0x3B, 0xE3, 0x9E, 0x77, 0x2C, 0x18, 0x0E, 0x86,
    0x03, 0x9B, 0x27, 0x83, 0xA2, 0xEC, 0x07, 0xA2,
    0x8F, 0xB5, 0xC5, 0x5D, 0xF0, 0x6F, 0x4C, 0x52,
    0xC9, 0xDE, 0x2B, 0xCB, 0xF6, 0x95, 0x58, 0x17,
    0x18, 0x39, 0x95, 0x49, 0x7C, 0xEA, 0x95, 0x6A,
    0xE5, 0x15, 0xD2, 0x26, 0x18, 0x98, 0xFA, 0x05,
    0x10, 0x15, 0x72, 0x8E, 0x5A, 0x8A, 0xAC, 0xAA,
    0x68, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0x02, 0x01, 0x02, 0x02, 0x82, 0x01, 0x00,
    0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xE4, 0x87, 0xED, 0x51, 0x10, 0xB4, 0x61, 0x1A,
    0x62, 0x63, 0x31, 0x45, 0xC0, 0x6E, 0x0E, 0x68,
    0x94, 0x81, 0x27, 0x04, 0x45, 0x33, 0xE6, 0x3A,
    0x01, 0x05, 0xDF, 0x53, 0x1D, 0x89, 0xCD, 0x91,
    0x28, 0xA5, 0x04, 0x3C, 0xC7, 0x1A, 0x02, 0x6E,
    0xF7, 0xCA, 0x8C, 0xD9, 0xE6, 0x9D, 0x21, 0x8D,
    0x98, 0x15, 0x85, 0x36, 0xF9, 0x2F, 0x8A, 0x1B,
    0xA7, 0xF0, 0x9A, 0xB6, 0xB6, 0xA8, 0xE1, 0x22,
    0xF2, 0x42, 0xDA, 0xBB, 0x31, 0x2F, 0x3F, 0x63,
    0x7A, 0x26, 0x21, 0x74, 0xD3, 0x1B, 0xF6, 0xB5,
    0x85, 0xFF, 0xAE, 0x5B, 0x7A, 0x03, 0x5B, 0xF6,
    0xF7, 0x1C, 0x35, 0xFD, 0xAD, 0x44, 0xCF, 0xD2,
    0xD7, 0x4F, 0x92, 0x08, 0xBE, 0x25, 0x8F, 0xF3,
    0x24, 0x94, 0x33, 0x28, 0xF6, 0x72, 0x2D, 0x9E,
    0xE1, 0x00, 0x3E, 0x5C, 0x50, 0xB1, 0xDF, 0x82,
    0xCC, 0x6D, 0x24, 0x1B, 0x0E, 0x2A, 0xE9, 0xCD,
    0x34, 0x8B, 0x1F, 0xD4, 0x7E, 0x92, 0x67, 0xAF,
    0xC1, 0xB2, 0xAE, 0x91, 0xEE, 0x51, 0xD6, 0xCB,
    0x0E, 0x31, 0x79, 0xAB, 0x10, 0x42, 0xA9, 0x5D,
    0xCF, 0x6A, 0x94, 0x83, 0xB8, 0x4B, 0x4B, 0x36,
    0xB3, 0x86, 0x1A, 0xA7, 0x25, 0x5E, 0x4C, 0x02,
    0x78, 0xBA, 0x36, 0x04, 0x65, 0x0C, 0x10, 0xBE,
    0x19, 0x48, 0x2F, 0x23, 0x17, 0x1B, 0x67, 0x1D,
    0xF1, 0xCF, 0x3B, 0x96, 0x0C, 0x07, 0x43, 0x01,
    0xCD, 0x93, 0xC1, 0xD1, 0x76, 0x03, 0xD1, 0x47,
    0xDA, 0xE2, 0xAE, 0xF8, 0x37, 0xA6, 0x29, 0x64,
    0xEF, 0x15, 0xE5, 0xFB, 0x4A, 0xAC, 0x0B, 0x8C,
    0x1C, 0xCA, 0xA4, 0xBE, 0x75, 0x4A, 0xB5, 0x72,
    0x8A, 0xE9, 0x13, 0x0C, 0x4C, 0x7D, 0x02, 0x88,
    0x0A, 0xB9, 0x47, 0x2D, 0x45, 0x56, 0x55, 0x34,
    0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
};

/* RFC 3526 section 5 (4096-bit MODP Group), RFC 3279 encoding */
static const uint8_t o4096[] = {
    0x30, 0x82, 0x04, 0x0C, 0x02, 0x82, 0x02, 0x01,
    0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xC9, 0x0F, 0xDA, 0xA2, 0x21, 0x68, 0xC2,
    0x34, 0xC4, 0xC6, 0x62, 0x8B, 0x80, 0xDC, 0x1C,
    0xD1, 0x29, 0x02, 0x4E, 0x08, 0x8A, 0x67, 0xCC,
    0x74, 0x02, 0x0B, 0xBE, 0xA6, 0x3B, 0x13, 0x9B,
    0x22, 0x51, 0x4A, 0x08, 0x79, 0x8E, 0x34, 0x04,
    0xDD, 0xEF, 0x95, 0x19, 0xB3, 0xCD, 0x3A, 0x43,
    0x1B, 0x30, 0x2B, 0x0A, 0x6D, 0xF2, 0x5F, 0x14,
    0x37, 0x4F, 0xE1, 0x35, 0x6D, 0x6D, 0x51, 0xC2,
    0x45, 0xE4, 0x85, 0xB5, 0x76, 0x62, 0x5E, 0x7E,
    0xC6, 0xF4, 0x4C, 0x42, 0xE9, 0xA6, 0x37, 0xED,
    0x6B, 0x0B, 0xFF, 0x5C, 0xB6, 0xF4, 0x06, 0xB7,
    0xED, 0xEE, 0x38, 0x6B, 0xFB, 0x5A, 0x89, 0x9F,
    0xA5, 0xAE, 0x9F, 0x24, 0x11, 0x7C, 0x4B, 0x1F,
    0xE6, 0x49, 0x28, 0x66, 0x51, 0xEC, 0xE4, 0x5B,
    0x3D, 0xC2, 0x00, 0x7C, 0xB8, 0xA1, 0x63, 0xBF,
    0x05, 0x98, 0xDA, 0x48, 0x36, 0x1C, 0x55, 0xD3,
    0x9A, 0x69, 0x16, 0x3F, 0xA8, 0xFD, 0x24, 0xCF,
    0x5F, 0x83, 0x65, 0x5D, 0x23, 0xDC, 0xA3, 0xAD,
    0x96, 0x1C, 0x62, 0xF3, 0x56, 0x20, 0x85, 0x52,
    0xBB, 0x9E, 0xD5, 0x29, 0x07, 0x70, 0x96, 0x96,
    0x6D, 0x67, 0x0C, 0x35, 0x4E, 0x4A, 0xBC, 0x98,
    0x04, 0xF1, 0x74, 0x6C, 0x08, 0xCA, 0x18, 0x21,
    0x7C, 0x32, 0x90, 0x5E, 0x46, 0x2E, 0x36, 0xCE,
    0x3B, 0xE3, 0x9E, 0x77, 0x2C, 0x18, 0x0E, 0x86,
    0x03, 0x9B, 0x27, 0x83, 0xA2, 0xEC, 0x07, 0xA2,
    0x8F, 0xB5, 0xC5, 0x5D, 0xF0, 0x6F, 0x4C, 0x52,
    0xC9, 0xDE, 0x2B, 0xCB, 0xF6, 0x95, 0x58, 0x17,
    0x18, 0x39, 0x95, 0x49, 0x7C, 0xEA, 0x95, 0x6A,
    0xE5, 0x15, 0xD2, 0x26, 0x18, 0x98, 0xFA, 0x05,
    0x10, 0x15, 0x72, 0x8E, 0x5A, 0x8A, 0xAA, 0xC4,
    0x2D, 0xAD, 0x33, 0x17, 0x0D, 0x04, 0x50, 0x7A,
    0x33, 0xA8, 0x55, 0x21, 0xAB, 0xDF, 0x1C, 0xBA,
    0x64, 0xEC, 0xFB, 0x85, 0x04, 0x58, 0xDB, 0xEF,
    0x0A, 0x8A, 0xEA, 0x71, 0x57, 0x5D, 0x06, 0x0C,
    0x7D, 0xB3, 0x97, 0x0F, 0x85, 0xA6, 0xE1, 0xE4,
    0xC7, 0xAB, 0xF5, 0xAE, 0x8C, 0xDB, 0x09, 0x33,
    0xD7, 0x1E, 0x8C, 0x94, 0xE0, 0x4A, 0x25, 0x61,
    0x9D, 0xCE, 0xE3, 0xD2, 0x26, 0x1A, 0xD2, 0xEE,
    0x6B, 0xF1, 0x2F, 0xFA, 0x06, 0xD9, 0x8A, 0x08,
    0x64, 0xD8, 0x76, 0x02, 0x73, 0x3E, 0xC8, 0x6A,
    0x64, 0x52, 0x1F, 0x2B, 0x18, 0x17, 0x7B, 0x20,
    0x0C, 0xBB, 0xE1, 0x17, 0x57, 0x7A, 0x61, 0x5D,
    0x6C, 0x77, 0x09, 0x88, 0xC0, 0xBA, 0xD9, 0x46,
    0xE2, 0x08, 0xE2, 0x4F, 0xA0, 0x74, 0xE5, 0xAB,
    0x31, 0x43, 0xDB, 0x5B, 0xFC, 0xE0, 0xFD, 0x10,
    0x8E, 0x4B, 0x82, 0xD1, 0x20, 0xA9, 0x21, 0x08,
    0x01, 0x1A, 0x72, 0x3C, 0x12, 0xA7, 0x87, 0xE6,
    0xD7, 0x88, 0x71, 0x9A, 0x10, 0xBD, 0xBA, 0x5B,
    0x26, 0x99, 0xC3, 0x27, 0x18, 0x6A, 0xF4, 0xE2,
    0x3C, 0x1A, 0x94, 0x68, 0x34, 0xB6, 0x15, 0x0B,
    0xDA, 0x25, 0x83, 0xE9, 0xCA, 0x2A, 0xD4, 0x4C,
    0xE8, 0xDB, 0xBB, 0xC2, 0xDB, 0x04, 0xDE, 0x8E,
    0xF9, 0x2E, 0x8E, 0xFC, 0x14, 0x1F, 0xBE, 0xCA,
    0xA6, 0x28, 0x7C, 0x59, 0x47, 0x4E, 0x6B, 0xC0,
    0x5D, 0x99, 0xB2, 0x96, 0x4F, 0xA0, 0x90, 0xC3,
    0xA2, 0x23, 0x3B, 0xA1, 0x86, 0x51, 0x5B, 0xE7,
    0xED, 0x1F, 0x61, 0x29, 0x70, 0xCE, 0xE2, 0xD7,
    0xAF, 0xB8, 0x1B, 0xDD, 0x76, 0x21, 0x70, 0x48,
    0x1C, 0xD0, 0x06, 0x91, 0x27, 0xD5, 0xB0, 0x5A,
    0xA9, 0x93, 0xB4, 0xEA, 0x98, 0x8D, 0x8F, 0xDD,
    0xC1, 0x86, 0xFF, 0xB7, 0xDC, 0x90, 0xA6, 0xC0,
    0x8F, 0x4D, 0xF4, 0x35, 0xC9, 0x34, 0x06, 0x31,
    0x99, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0x02, 0x01, 0x02, 0x02, 0x82, 0x02, 0x00,
    0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xE4, 0x87, 0xED, 0x51, 0x10, 0xB4, 0x61, 0x1A,
    0x62, 0x63, 0x31, 0x45, 0xC0, 0x6E, 0x0E, 0x68,
    0x94, 0x81, 0x27, 0x04, 0x45, 0x33, 0xE6, 0x3A,
    0x01, 0x05, 0xDF, 0x53, 0x1D, 0x89, 0xCD, 0x91,
    0x28, 0xA5, 0x04, 0x3C, 0xC7, 0x1A, 0x02, 0x6E,
    0xF7, 0xCA, 0x8C, 0xD9, 0xE6, 0x9D, 0x21, 0x8D,
    0x98, 0x15, 0x85, 0x36, 0xF9, 0x2F, 0x8A, 0x1B,
    0xA7, 0xF0, 0x9A, 0xB6, 0xB6, 0xA8, 0xE1, 0x22,
    0xF2, 0x42, 0xDA, 0xBB, 0x31, 0x2F, 0x3F, 0x63,
    0x7A, 0x26, 0x21, 0x74, 0xD3, 0x1B, 0xF6, 0xB5,
    0x85, 0xFF, 0xAE, 0x5B, 0x7A, 0x03, 0x5B, 0xF6,
    0xF7, 0x1C, 0x35, 0xFD, 0xAD, 0x44, 0xCF, 0xD2,
    0xD7, 0x4F, 0x92, 0x08, 0xBE, 0x25, 0x8F, 0xF3,
    0x24, 0x94, 0x33, 0x28, 0xF6, 0x72, 0x2D, 0x9E,
    0xE1, 0x00, 0x3E, 0x5C, 0x50, 0xB1, 0xDF, 0x82,
    0xCC, 0x6D, 0x24, 0x1B, 0x0E, 0x2A, 0xE9, 0xCD,
    0x34, 0x8B, 0x1F, 0xD4, 0x7E, 0x92, 0x67, 0xAF,
    0xC1, 0xB2, 0xAE, 0x91, 0xEE, 0x51, 0xD6, 0xCB,
    0x0E, 0x31, 0x79, 0xAB, 0x10, 0x42, 0xA9, 0x5D,
    0xCF, 0x6A, 0x94, 0x83, 0xB8, 0x4B, 0x4B, 0x36,
    0xB3, 0x86, 0x1A, 0xA7, 0x25, 0x5E, 0x4C, 0x02,
    0x78, 0xBA, 0x36, 0x04, 0x65, 0x0C, 0x10, 0xBE,
    0x19, 0x48, 0x2F, 0x23, 0x17, 0x1B, 0x67, 0x1D,
    0xF1, 0xCF, 0x3B, 0x96, 0x0C, 0x07, 0x43, 0x01,
    0xCD, 0x93, 0xC1, 0xD1, 0x76, 0x03, 0xD1, 0x47,
    0xDA, 0xE2, 0xAE, 0xF8, 0x37, 0xA6, 0x29, 0x64,
    0xEF, 0x15, 0xE5, 0xFB, 0x4A, 0xAC, 0x0B, 0x8C,
    0x1C, 0xCA, 0xA4, 0xBE, 0x75, 0x4A, 0xB5, 0x72,
    0x8A, 0xE9, 0x13, 0x0C, 0x4C, 0x7D, 0x02, 0x88,
    0x0A, 0xB9, 0x47, 0x2D, 0x45, 0x55, 0x62, 0x16,
    0xD6, 0x99, 0x8B, 0x86, 0x82, 0x28, 0x3D, 0x19,
    0xD4, 0x2A, 0x90, 0xD5, 0xEF, 0x8E, 0x5D, 0x32,
    0x76, 0x7D, 0xC2, 0x82, 0x2C, 0x6D, 0xF7, 0x85,
    0x45, 0x75, 0x38, 0xAB, 0xAE, 0x83, 0x06, 0x3E,
    0xD9, 0xCB, 0x87, 0xC2, 0xD3, 0x70, 0xF2, 0x63,
    0xD5, 0xFA, 0xD7, 0x46, 0x6D, 0x84, 0x99, 0xEB,
    0x8F, 0x46, 0x4A, 0x70, 0x25, 0x12, 0xB0, 0xCE,
    0xE7, 0x71, 0xE9, 0x13, 0x0D, 0x69, 0x77, 0x35,
    0xF8, 0x97, 0xFD, 0x03, 0x6C, 0xC5, 0x04, 0x32,
    0x6C, 0x3B, 0x01, 0x39, 0x9F, 0x64, 0x35, 0x32,
    0x29, 0x0F, 0x95, 0x8C, 0x0B, 0xBD, 0x90, 0x06,
    0x5D, 0xF0, 0x8B, 0xAB, 0xBD, 0x30, 0xAE, 0xB6,
    0x3B, 0x84, 0xC4, 0x60, 0x5D, 0x6C, 0xA3, 0x71,
    0x04, 0x71, 0x27, 0xD0, 0x3A, 0x72, 0xD5, 0x98,
    0xA1, 0xED, 0xAD, 0xFE, 0x70, 0x7E, 0x88, 0x47,
    0x25, 0xC1, 0x68, 0x90, 0x54, 0x90, 0x84, 0x00,
    0x8D, 0x39, 0x1E, 0x09, 0x53, 0xC3, 0xF3, 0x6B,
    0xC4, 0x38, 0xCD, 0x08, 0x5E, 0xDD, 0x2D, 0x93,
    0x4C, 0xE1, 0x93, 0x8C, 0x35, 0x7A, 0x71, 0x1E,
    0x0D, 0x4A, 0x34, 0x1A, 0x5B, 0x0A, 0x85, 0xED,
    0x12, 0xC1, 0xF4, 0xE5, 0x15, 0x6A, 0x26, 0x74,
    0x6D, 0xDD, 0xE1, 0x6D, 0x82, 0x6F, 0x47, 0x7C,
    0x97, 0x47, 0x7E, 0x0A, 0x0F, 0xDF, 0x65, 0x53,
    0x14, 0x3E, 0x2C, 0xA3, 0xA7, 0x35, 0xE0, 0x2E,
    0xCC, 0xD9, 0x4B, 0x27, 0xD0, 0x48, 0x61, 0xD1,
    0x11, 0x9D, 0xD0, 0xC3, 0x28, 0xAD, 0xF3, 0xF6,
    0x8F, 0xB0, 0x94, 0xB8, 0x67, 0x71, 0x6B, 0xD7,
    0xDC, 0x0D, 0xEE, 0xBB, 0x10, 0xB8, 0x24, 0x0E,
    0x68, 0x03, 0x48, 0x93, 0xEA, 0xD8, 0x2D, 0x54,
    0xC9, 0xDA, 0x75, 0x4C, 0x46, 0xC7, 0xEE, 0xE0,
    0xC3, 0x7F, 0xDB, 0xEE, 0x48, 0x53, 0x60, 0x47,
    0xA6, 0xFA, 0x1A, 0xE4, 0x9A, 0x03, 0x18, 0xCC,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
};

const krb5_data oakley_1024 = { KV5M_DATA, sizeof(o1024), (char *)o1024 };
const krb5_data oakley_2048 = { KV5M_DATA, sizeof(o2048), (char *)o2048 };
const krb5_data oakley_4096 = { KV5M_DATA, sizeof(o4096), (char *)o4096 };
