/*
 * Copyright 2023 Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) OR AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 */
#ifndef _gc_12_0_0_SH_MASK_HEADER
#define _gc_12_0_0_SH_MASK_HEADER


// addressBlock: gc_gfx_cpwd_sdma0_sdmadec
//SDMA0_DEC_START
#define SDMA0_DEC_START__START__SHIFT                                                                         0x0
#define SDMA0_DEC_START__START_MASK                                                                           0xFFFFFFFFL
//SDMA0_MCU_MISC_CNTL
#define SDMA0_MCU_MISC_CNTL__MCU_WAKEUP__SHIFT                                                                0x0
#define SDMA0_MCU_MISC_CNTL__MCU_WAKEUP_MASK                                                                  0x00000001L
//SDMA0_UCODE_REV
#define SDMA0_UCODE_REV__CL__SHIFT                                                                            0x0
#define SDMA0_UCODE_REV__VARIANT_ID__SHIFT                                                                    0x1c
#define SDMA0_UCODE_REV__CL_MASK                                                                              0x0FFFFFFFL
#define SDMA0_UCODE_REV__VARIANT_ID_MASK                                                                      0xF0000000L
//SDMA0_GLOBAL_TIMESTAMP_LO
#define SDMA0_GLOBAL_TIMESTAMP_LO__DATA__SHIFT                                                                0x0
#define SDMA0_GLOBAL_TIMESTAMP_LO__DATA_MASK                                                                  0xFFFFFFFFL
//SDMA0_GLOBAL_TIMESTAMP_HI
#define SDMA0_GLOBAL_TIMESTAMP_HI__DATA__SHIFT                                                                0x0
#define SDMA0_GLOBAL_TIMESTAMP_HI__DATA_MASK                                                                  0xFFFFFFFFL
//SDMA0_POWER_CNTL
#define SDMA0_POWER_CNTL__LS_ENABLE__SHIFT                                                                    0x8
#define SDMA0_POWER_CNTL__LS_ENABLE_MASK                                                                      0x00000100L
//SDMA0_CNTL
#define SDMA0_CNTL__TRAP_ENABLE__SHIFT                                                                        0x0
#define SDMA0_CNTL__RESERVED__SHIFT                                                                           0x2
#define SDMA0_CNTL__DATA_SWAP_ENABLE__SHIFT                                                                   0x3
#define SDMA0_CNTL__FENCE_SWAP_ENABLE__SHIFT                                                                  0x4
#define SDMA0_CNTL__MIDCMD_PREEMPT_ENABLE__SHIFT                                                              0x5
#define SDMA0_CNTL__PIO_DONE_ACK_ENABLE__SHIFT                                                                0x6
#define SDMA0_CNTL__TMZ_MIDCMD_PREEMPT_ENABLE__SHIFT                                                          0x8
#define SDMA0_CNTL__MIDCMD_EXPIRE_ENABLE__SHIFT                                                               0x9
#define SDMA0_CNTL__CP_MES_INT_ENABLE__SHIFT                                                                  0xa
#define SDMA0_CNTL__PAGE_RETRY_TIMEOUT_INT_ENABLE__SHIFT                                                      0xb
#define SDMA0_CNTL__PAGE_NULL_INT_ENABLE__SHIFT                                                               0xc
#define SDMA0_CNTL__PAGE_FAULT_INT_ENABLE__SHIFT                                                              0xd
#define SDMA0_CNTL__CH_PERFCNT_ENABLE__SHIFT                                                                  0x10
#define SDMA0_CNTL__MIDCMD_WORLDSWITCH_ENABLE__SHIFT                                                          0x11
#define SDMA0_CNTL__CTXEMPTY_INT_ENABLE__SHIFT                                                                0x1c
#define SDMA0_CNTL__FROZEN_INT_ENABLE__SHIFT                                                                  0x1d
#define SDMA0_CNTL__IB_PREEMPT_INT_ENABLE__SHIFT                                                              0x1e
#define SDMA0_CNTL__RB_PREEMPT_INT_ENABLE__SHIFT                                                              0x1f
#define SDMA0_CNTL__TRAP_ENABLE_MASK                                                                          0x00000001L
#define SDMA0_CNTL__RESERVED_MASK                                                                             0x00000004L
#define SDMA0_CNTL__DATA_SWAP_ENABLE_MASK                                                                     0x00000008L
#define SDMA0_CNTL__FENCE_SWAP_ENABLE_MASK                                                                    0x00000010L
#define SDMA0_CNTL__MIDCMD_PREEMPT_ENABLE_MASK                                                                0x00000020L
#define SDMA0_CNTL__PIO_DONE_ACK_ENABLE_MASK                                                                  0x00000040L
#define SDMA0_CNTL__TMZ_MIDCMD_PREEMPT_ENABLE_MASK                                                            0x00000100L
#define SDMA0_CNTL__MIDCMD_EXPIRE_ENABLE_MASK                                                                 0x00000200L
#define SDMA0_CNTL__CP_MES_INT_ENABLE_MASK                                                                    0x00000400L
#define SDMA0_CNTL__PAGE_RETRY_TIMEOUT_INT_ENABLE_MASK                                                        0x00000800L
#define SDMA0_CNTL__PAGE_NULL_INT_ENABLE_MASK                                                                 0x00001000L
#define SDMA0_CNTL__PAGE_FAULT_INT_ENABLE_MASK                                                                0x00002000L
#define SDMA0_CNTL__CH_PERFCNT_ENABLE_MASK                                                                    0x00010000L
#define SDMA0_CNTL__MIDCMD_WORLDSWITCH_ENABLE_MASK                                                            0x00020000L
#define SDMA0_CNTL__CTXEMPTY_INT_ENABLE_MASK                                                                  0x10000000L
#define SDMA0_CNTL__FROZEN_INT_ENABLE_MASK                                                                    0x20000000L
#define SDMA0_CNTL__IB_PREEMPT_INT_ENABLE_MASK                                                                0x40000000L
#define SDMA0_CNTL__RB_PREEMPT_INT_ENABLE_MASK                                                                0x80000000L
//SDMA0_CHICKEN_BITS
#define SDMA0_CHICKEN_BITS__SRBM_POLL_RETRYING__SHIFT                                                         0x5
#define SDMA0_CHICKEN_BITS__RD_BURST__SHIFT                                                                   0x6
#define SDMA0_CHICKEN_BITS__WR_BURST__SHIFT                                                                   0x8
#define SDMA0_CHICKEN_BITS__COMBINE_256B_WAIT_CYCLE__SHIFT                                                    0xa
#define SDMA0_CHICKEN_BITS__WR_COMBINE_256B_ENABLE__SHIFT                                                     0xe
#define SDMA0_CHICKEN_BITS__RD_COMBINE_256B_ENABLE__SHIFT                                                     0xf
#define SDMA0_CHICKEN_BITS__COPY_OVERLAP_ENABLE__SHIFT                                                        0x10
#define SDMA0_CHICKEN_BITS__RAW_CHECK_ENABLE__SHIFT                                                           0x11
#define SDMA0_CHICKEN_BITS__T2L_256B_ENABLE__SHIFT                                                            0x12
#define SDMA0_CHICKEN_BITS__SOFT_OVERRIDE_GCR_FGCG__SHIFT                                                     0x13
#define SDMA0_CHICKEN_BITS__SOFT_OVERRIDE_GRBM_FGCG__SHIFT                                                    0x14
#define SDMA0_CHICKEN_BITS__SOFT_OVERRIDE_CH_FGCG__SHIFT                                                      0x15
#define SDMA0_CHICKEN_BITS__SOFT_OVERRIDE_UTCL2_INVREQ_FGCG__SHIFT                                            0x16
#define SDMA0_CHICKEN_BITS__SOFT_OVERRIDE_UTCL1_FGCG__SHIFT                                                   0x17
#define SDMA0_CHICKEN_BITS__CG_STATUS_OUTPUT__SHIFT                                                           0x18
#define SDMA0_CHICKEN_BITS__SW_FREEZE_ENABLE__SHIFT                                                           0x19
#define SDMA0_CHICKEN_BITS__DRAM_ECC_COPY_MODE_CNTL__SHIFT                                                    0x1a
#define SDMA0_CHICKEN_BITS__SOFT_OVERRIDE_REG_ADDR_CHECK__SHIFT                                               0x1b
#define SDMA0_CHICKEN_BITS__RESERVED__SHIFT                                                                   0x1c
#define SDMA0_CHICKEN_BITS__SRBM_POLL_RETRYING_MASK                                                           0x00000020L
#define SDMA0_CHICKEN_BITS__RD_BURST_MASK                                                                     0x000000C0L
#define SDMA0_CHICKEN_BITS__WR_BURST_MASK                                                                     0x00000300L
#define SDMA0_CHICKEN_BITS__COMBINE_256B_WAIT_CYCLE_MASK                                                      0x00003C00L
#define SDMA0_CHICKEN_BITS__WR_COMBINE_256B_ENABLE_MASK                                                       0x00004000L
#define SDMA0_CHICKEN_BITS__RD_COMBINE_256B_ENABLE_MASK                                                       0x00008000L
#define SDMA0_CHICKEN_BITS__COPY_OVERLAP_ENABLE_MASK                                                          0x00010000L
#define SDMA0_CHICKEN_BITS__RAW_CHECK_ENABLE_MASK                                                             0x00020000L
#define SDMA0_CHICKEN_BITS__T2L_256B_ENABLE_MASK                                                              0x00040000L
#define SDMA0_CHICKEN_BITS__SOFT_OVERRIDE_GCR_FGCG_MASK                                                       0x00080000L
#define SDMA0_CHICKEN_BITS__SOFT_OVERRIDE_GRBM_FGCG_MASK                                                      0x00100000L
#define SDMA0_CHICKEN_BITS__SOFT_OVERRIDE_CH_FGCG_MASK                                                        0x00200000L
#define SDMA0_CHICKEN_BITS__SOFT_OVERRIDE_UTCL2_INVREQ_FGCG_MASK                                              0x00400000L
#define SDMA0_CHICKEN_BITS__SOFT_OVERRIDE_UTCL1_FGCG_MASK                                                     0x00800000L
#define SDMA0_CHICKEN_BITS__CG_STATUS_OUTPUT_MASK                                                             0x01000000L
#define SDMA0_CHICKEN_BITS__SW_FREEZE_ENABLE_MASK                                                             0x02000000L
#define SDMA0_CHICKEN_BITS__DRAM_ECC_COPY_MODE_CNTL_MASK                                                      0x04000000L
#define SDMA0_CHICKEN_BITS__SOFT_OVERRIDE_REG_ADDR_CHECK_MASK                                                 0x08000000L
#define SDMA0_CHICKEN_BITS__RESERVED_MASK                                                                     0xF0000000L
//SDMA0_CACHE_CNTL
#define SDMA0_CACHE_CNTL__RD_MALL_POLICY__SHIFT                                                               0x0
#define SDMA0_CACHE_CNTL__WR_MALL_POLICY__SHIFT                                                               0x2
#define SDMA0_CACHE_CNTL__RD_MALL_POLICY_MASK                                                                 0x00000003L
#define SDMA0_CACHE_CNTL__WR_MALL_POLICY_MASK                                                                 0x0000000CL
//SDMA0_RB_RPTR_FETCH
#define SDMA0_RB_RPTR_FETCH__OFFSET__SHIFT                                                                    0x2
#define SDMA0_RB_RPTR_FETCH__OFFSET_MASK                                                                      0xFFFFFFFCL
//SDMA0_RB_RPTR_FETCH_HI
#define SDMA0_RB_RPTR_FETCH_HI__OFFSET__SHIFT                                                                 0x0
#define SDMA0_RB_RPTR_FETCH_HI__OFFSET_MASK                                                                   0xFFFFFFFFL
//SDMA0_IB_OFFSET_FETCH
#define SDMA0_IB_OFFSET_FETCH__OFFSET__SHIFT                                                                  0x2
#define SDMA0_IB_OFFSET_FETCH__OFFSET_MASK                                                                    0x003FFFFCL
//SDMA0_PROGRAM
#define SDMA0_PROGRAM__STREAM__SHIFT                                                                          0x0
#define SDMA0_PROGRAM__STREAM_MASK                                                                            0xFFFFFFFFL
//SDMA0_STATUS_REG
#define SDMA0_STATUS_REG__IDLE__SHIFT                                                                         0x0
#define SDMA0_STATUS_REG__REG_IDLE__SHIFT                                                                     0x1
#define SDMA0_STATUS_REG__RB_EMPTY__SHIFT                                                                     0x2
#define SDMA0_STATUS_REG__RB_FULL__SHIFT                                                                      0x3
#define SDMA0_STATUS_REG__RB_CMD_IDLE__SHIFT                                                                  0x4
#define SDMA0_STATUS_REG__RB_CMD_FULL__SHIFT                                                                  0x5
#define SDMA0_STATUS_REG__IB_CMD_IDLE__SHIFT                                                                  0x6
#define SDMA0_STATUS_REG__IB_CMD_FULL__SHIFT                                                                  0x7
#define SDMA0_STATUS_REG__BLOCK_IDLE__SHIFT                                                                   0x8
#define SDMA0_STATUS_REG__INSIDE_IB__SHIFT                                                                    0x9
#define SDMA0_STATUS_REG__FETCH_IDLE__SHIFT                                                                   0xa
#define SDMA0_STATUS_REG__CGCG_FENCE__SHIFT                                                                   0xb
#define SDMA0_STATUS_REG__PACKET_READY__SHIFT                                                                 0xc
#define SDMA0_STATUS_REG__MC_WR_IDLE__SHIFT                                                                   0xd
#define SDMA0_STATUS_REG__SRBM_IDLE__SHIFT                                                                    0xe
#define SDMA0_STATUS_REG__CONTEXT_EMPTY__SHIFT                                                                0xf
#define SDMA0_STATUS_REG__DELTA_RPTR_FULL__SHIFT                                                              0x10
#define SDMA0_STATUS_REG__RB_MC_RREQ_IDLE__SHIFT                                                              0x11
#define SDMA0_STATUS_REG__IB_MC_RREQ_IDLE__SHIFT                                                              0x12
#define SDMA0_STATUS_REG__MC_RD_IDLE__SHIFT                                                                   0x13
#define SDMA0_STATUS_REG__DELTA_RPTR_EMPTY__SHIFT                                                             0x14
#define SDMA0_STATUS_REG__EXEC_ENG_IDLE__SHIFT                                                                0x19
#define SDMA0_STATUS_REG__PROC_CNTL_IDLE__SHIFT                                                               0x1a
#define SDMA0_STATUS_REG__UCODE_INIT_DONE__SHIFT                                                              0x1b
#define SDMA0_STATUS_REG__RESERVED__SHIFT                                                                     0x1d
#define SDMA0_STATUS_REG__INT_IDLE__SHIFT                                                                     0x1e
#define SDMA0_STATUS_REG__INT_REQ_STALL__SHIFT                                                                0x1f
#define SDMA0_STATUS_REG__IDLE_MASK                                                                           0x00000001L
#define SDMA0_STATUS_REG__REG_IDLE_MASK                                                                       0x00000002L
#define SDMA0_STATUS_REG__RB_EMPTY_MASK                                                                       0x00000004L
#define SDMA0_STATUS_REG__RB_FULL_MASK                                                                        0x00000008L
#define SDMA0_STATUS_REG__RB_CMD_IDLE_MASK                                                                    0x00000010L
#define SDMA0_STATUS_REG__RB_CMD_FULL_MASK                                                                    0x00000020L
#define SDMA0_STATUS_REG__IB_CMD_IDLE_MASK                                                                    0x00000040L
#define SDMA0_STATUS_REG__IB_CMD_FULL_MASK                                                                    0x00000080L
#define SDMA0_STATUS_REG__BLOCK_IDLE_MASK                                                                     0x00000100L
#define SDMA0_STATUS_REG__INSIDE_IB_MASK                                                                      0x00000200L
#define SDMA0_STATUS_REG__FETCH_IDLE_MASK                                                                     0x00000400L
#define SDMA0_STATUS_REG__CGCG_FENCE_MASK                                                                     0x00000800L
#define SDMA0_STATUS_REG__PACKET_READY_MASK                                                                   0x00001000L
#define SDMA0_STATUS_REG__MC_WR_IDLE_MASK                                                                     0x00002000L
#define SDMA0_STATUS_REG__SRBM_IDLE_MASK                                                                      0x00004000L
#define SDMA0_STATUS_REG__CONTEXT_EMPTY_MASK                                                                  0x00008000L
#define SDMA0_STATUS_REG__DELTA_RPTR_FULL_MASK                                                                0x00010000L
#define SDMA0_STATUS_REG__RB_MC_RREQ_IDLE_MASK                                                                0x00020000L
#define SDMA0_STATUS_REG__IB_MC_RREQ_IDLE_MASK                                                                0x00040000L
#define SDMA0_STATUS_REG__MC_RD_IDLE_MASK                                                                     0x00080000L
#define SDMA0_STATUS_REG__DELTA_RPTR_EMPTY_MASK                                                               0x00100000L
#define SDMA0_STATUS_REG__EXEC_ENG_IDLE_MASK                                                                  0x02000000L
#define SDMA0_STATUS_REG__PROC_CNTL_IDLE_MASK                                                                 0x04000000L
#define SDMA0_STATUS_REG__UCODE_INIT_DONE_MASK                                                                0x08000000L
#define SDMA0_STATUS_REG__RESERVED_MASK                                                                       0x20000000L
#define SDMA0_STATUS_REG__INT_IDLE_MASK                                                                       0x40000000L
#define SDMA0_STATUS_REG__INT_REQ_STALL_MASK                                                                  0x80000000L
//SDMA0_STATUS1_REG
#define SDMA0_STATUS1_REG__CE_WREQ_IDLE__SHIFT                                                                0x0
#define SDMA0_STATUS1_REG__CE_WR_IDLE__SHIFT                                                                  0x1
#define SDMA0_STATUS1_REG__CE_SPLIT_IDLE__SHIFT                                                               0x2
#define SDMA0_STATUS1_REG__CE_RREQ_IDLE__SHIFT                                                                0x3
#define SDMA0_STATUS1_REG__CE_OUT_IDLE__SHIFT                                                                 0x4
#define SDMA0_STATUS1_REG__CE_IN_IDLE__SHIFT                                                                  0x5
#define SDMA0_STATUS1_REG__CE_DST_IDLE__SHIFT                                                                 0x6
#define SDMA0_STATUS1_REG__RESERVED_8_7__SHIFT                                                                0x7
#define SDMA0_STATUS1_REG__CE_CMD_IDLE__SHIFT                                                                 0x9
#define SDMA0_STATUS1_REG__CE_AFIFO_FULL__SHIFT                                                               0xa
#define SDMA0_STATUS1_REG__CE_INFO_FULL__SHIFT                                                                0xb
#define SDMA0_STATUS1_REG__CE_INFO1_FULL__SHIFT                                                               0xc
#define SDMA0_STATUS1_REG__EX_START__SHIFT                                                                    0xd
#define SDMA0_STATUS1_REG__CE_RD_STALL__SHIFT                                                                 0xf
#define SDMA0_STATUS1_REG__CE_WR_STALL__SHIFT                                                                 0x10
#define SDMA0_STATUS1_REG__SEC_INTR_STATUS__SHIFT                                                             0x11
#define SDMA0_STATUS1_REG__WPTR_POLL_IDLE__SHIFT                                                              0x12
#define SDMA0_STATUS1_REG__SDMA_IDLE__SHIFT                                                                   0x13
#define SDMA0_STATUS1_REG__IC_FETCH_IDLE__SHIFT                                                               0x14
#define SDMA0_STATUS1_REG__IC_FETCH_PAGE_FAULT__SHIFT                                                         0x15
#define SDMA0_STATUS1_REG__IC_FETCH_PAGE_RETRY_TIMEOUT__SHIFT                                                 0x16
#define SDMA0_STATUS1_REG__IC_FETCH_PAGE_NULL__SHIFT                                                          0x17
#define SDMA0_STATUS1_REG__MCU_FW_STACK_OVERFLOW__SHIFT                                                       0x18
#define SDMA0_STATUS1_REG__CE_WREQ_IDLE_MASK                                                                  0x00000001L
#define SDMA0_STATUS1_REG__CE_WR_IDLE_MASK                                                                    0x00000002L
#define SDMA0_STATUS1_REG__CE_SPLIT_IDLE_MASK                                                                 0x00000004L
#define SDMA0_STATUS1_REG__CE_RREQ_IDLE_MASK                                                                  0x00000008L
#define SDMA0_STATUS1_REG__CE_OUT_IDLE_MASK                                                                   0x00000010L
#define SDMA0_STATUS1_REG__CE_IN_IDLE_MASK                                                                    0x00000020L
#define SDMA0_STATUS1_REG__CE_DST_IDLE_MASK                                                                   0x00000040L
#define SDMA0_STATUS1_REG__RESERVED_8_7_MASK                                                                  0x00000180L
#define SDMA0_STATUS1_REG__CE_CMD_IDLE_MASK                                                                   0x00000200L
#define SDMA0_STATUS1_REG__CE_AFIFO_FULL_MASK                                                                 0x00000400L
#define SDMA0_STATUS1_REG__CE_INFO_FULL_MASK                                                                  0x00000800L
#define SDMA0_STATUS1_REG__CE_INFO1_FULL_MASK                                                                 0x00001000L
#define SDMA0_STATUS1_REG__EX_START_MASK                                                                      0x00002000L
#define SDMA0_STATUS1_REG__CE_RD_STALL_MASK                                                                   0x00008000L
#define SDMA0_STATUS1_REG__CE_WR_STALL_MASK                                                                   0x00010000L
#define SDMA0_STATUS1_REG__SEC_INTR_STATUS_MASK                                                               0x00020000L
#define SDMA0_STATUS1_REG__WPTR_POLL_IDLE_MASK                                                                0x00040000L
#define SDMA0_STATUS1_REG__SDMA_IDLE_MASK                                                                     0x00080000L
#define SDMA0_STATUS1_REG__IC_FETCH_IDLE_MASK                                                                 0x00100000L
#define SDMA0_STATUS1_REG__IC_FETCH_PAGE_FAULT_MASK                                                           0x00200000L
#define SDMA0_STATUS1_REG__IC_FETCH_PAGE_RETRY_TIMEOUT_MASK                                                   0x00400000L
#define SDMA0_STATUS1_REG__IC_FETCH_PAGE_NULL_MASK                                                            0x00800000L
#define SDMA0_STATUS1_REG__MCU_FW_STACK_OVERFLOW_MASK                                                         0x03000000L
//SDMA0_CNTL1
#define SDMA0_CNTL1__WPTR_POLL_FREQUENCY__SHIFT                                                               0x2
#define SDMA0_CNTL1__WPTR_POLL_FREQUENCY_MASK                                                                 0x0000FFFCL
//SDMA0_HBM_PAGE_CONFIG
#define SDMA0_HBM_PAGE_CONFIG__PAGE_SIZE_EXPONENT__SHIFT                                                      0x0
#define SDMA0_HBM_PAGE_CONFIG__PAGE_SIZE_EXPONENT_MASK                                                        0x00000003L
//SDMA0_FREEZE
#define SDMA0_FREEZE__PREEMPT__SHIFT                                                                          0x0
#define SDMA0_FREEZE__FROZEN__SHIFT                                                                           0x5
#define SDMA0_FREEZE__MCU_FREEZE__SHIFT                                                                       0x6
#define SDMA0_FREEZE__IMU_FSM_STATE__SHIFT                                                                    0x8
#define SDMA0_FREEZE__EXTERNAL_FROZEN__SHIFT                                                                  0xc
#define SDMA0_FREEZE__PREEMPT_MASK                                                                            0x00000001L
#define SDMA0_FREEZE__FROZEN_MASK                                                                             0x00000020L
#define SDMA0_FREEZE__MCU_FREEZE_MASK                                                                         0x00000040L
#define SDMA0_FREEZE__IMU_FSM_STATE_MASK                                                                      0x00000300L
#define SDMA0_FREEZE__EXTERNAL_FROZEN_MASK                                                                    0x00001000L
//SDMA0_PROCESS_QUANTUM0
#define SDMA0_PROCESS_QUANTUM0__PROCESS0_QUANTUM__SHIFT                                                       0x0
#define SDMA0_PROCESS_QUANTUM0__PROCESS1_QUANTUM__SHIFT                                                       0x8
#define SDMA0_PROCESS_QUANTUM0__PROCESS2_QUANTUM__SHIFT                                                       0x10
#define SDMA0_PROCESS_QUANTUM0__PROCESS3_QUANTUM__SHIFT                                                       0x18
#define SDMA0_PROCESS_QUANTUM0__PROCESS0_QUANTUM_MASK                                                         0x000000FFL
#define SDMA0_PROCESS_QUANTUM0__PROCESS1_QUANTUM_MASK                                                         0x0000FF00L
#define SDMA0_PROCESS_QUANTUM0__PROCESS2_QUANTUM_MASK                                                         0x00FF0000L
#define SDMA0_PROCESS_QUANTUM0__PROCESS3_QUANTUM_MASK                                                         0xFF000000L
//SDMA0_PROCESS_QUANTUM1
#define SDMA0_PROCESS_QUANTUM1__PROCESS4_QUANTUM__SHIFT                                                       0x0
#define SDMA0_PROCESS_QUANTUM1__PROCESS5_QUANTUM__SHIFT                                                       0x8
#define SDMA0_PROCESS_QUANTUM1__PROCESS6_QUANTUM__SHIFT                                                       0x10
#define SDMA0_PROCESS_QUANTUM1__PROCESS7_QUANTUM__SHIFT                                                       0x18
#define SDMA0_PROCESS_QUANTUM1__PROCESS4_QUANTUM_MASK                                                         0x000000FFL
#define SDMA0_PROCESS_QUANTUM1__PROCESS5_QUANTUM_MASK                                                         0x0000FF00L
#define SDMA0_PROCESS_QUANTUM1__PROCESS6_QUANTUM_MASK                                                         0x00FF0000L
#define SDMA0_PROCESS_QUANTUM1__PROCESS7_QUANTUM_MASK                                                         0xFF000000L
//SDMA0_WATCHDOG_CNTL
#define SDMA0_WATCHDOG_CNTL__QUEUE_HANG_COUNT__SHIFT                                                          0x0
#define SDMA0_WATCHDOG_CNTL__CMD_TIMEOUT_COUNT__SHIFT                                                         0x8
#define SDMA0_WATCHDOG_CNTL__QUEUE_HANG_COUNT_MASK                                                            0x000000FFL
#define SDMA0_WATCHDOG_CNTL__CMD_TIMEOUT_COUNT_MASK                                                           0x0000FF00L
//SDMA0_QUEUE_STATUS0
#define SDMA0_QUEUE_STATUS0__QUEUE0_STATUS__SHIFT                                                             0x0
#define SDMA0_QUEUE_STATUS0__QUEUE1_STATUS__SHIFT                                                             0x4
#define SDMA0_QUEUE_STATUS0__QUEUE2_STATUS__SHIFT                                                             0x8
#define SDMA0_QUEUE_STATUS0__QUEUE3_STATUS__SHIFT                                                             0xc
#define SDMA0_QUEUE_STATUS0__QUEUE4_STATUS__SHIFT                                                             0x10
#define SDMA0_QUEUE_STATUS0__QUEUE5_STATUS__SHIFT                                                             0x14
#define SDMA0_QUEUE_STATUS0__QUEUE6_STATUS__SHIFT                                                             0x18
#define SDMA0_QUEUE_STATUS0__QUEUE7_STATUS__SHIFT                                                             0x1c
#define SDMA0_QUEUE_STATUS0__QUEUE0_STATUS_MASK                                                               0x0000000FL
#define SDMA0_QUEUE_STATUS0__QUEUE1_STATUS_MASK                                                               0x000000F0L
#define SDMA0_QUEUE_STATUS0__QUEUE2_STATUS_MASK                                                               0x00000F00L
#define SDMA0_QUEUE_STATUS0__QUEUE3_STATUS_MASK                                                               0x0000F000L
#define SDMA0_QUEUE_STATUS0__QUEUE4_STATUS_MASK                                                               0x000F0000L
#define SDMA0_QUEUE_STATUS0__QUEUE5_STATUS_MASK                                                               0x00F00000L
#define SDMA0_QUEUE_STATUS0__QUEUE6_STATUS_MASK                                                               0x0F000000L
#define SDMA0_QUEUE_STATUS0__QUEUE7_STATUS_MASK                                                               0xF0000000L
//SDMA0_EDC_CONFIG
#define SDMA0_EDC_CONFIG__DIS_EDC__SHIFT                                                                      0x1
#define SDMA0_EDC_CONFIG__ECC_INT_ENABLE__SHIFT                                                               0x2
#define SDMA0_EDC_CONFIG__DIS_EDC_MASK                                                                        0x00000002L
#define SDMA0_EDC_CONFIG__ECC_INT_ENABLE_MASK                                                                 0x00000004L
//SDMA0_ID
#define SDMA0_ID__DEVICE_ID__SHIFT                                                                            0x0
#define SDMA0_ID__DEVICE_ID_MASK                                                                              0x000000FFL
//SDMA0_VERSION
#define SDMA0_VERSION__MINVER__SHIFT                                                                          0x0
#define SDMA0_VERSION__MAJVER__SHIFT                                                                          0x8
#define SDMA0_VERSION__REV__SHIFT                                                                             0x10
#define SDMA0_VERSION__MINVER_MASK                                                                            0x0000007FL
#define SDMA0_VERSION__MAJVER_MASK                                                                            0x00007F00L
#define SDMA0_VERSION__REV_MASK                                                                               0x003F0000L
//SDMA0_STATUS2_REG
#define SDMA0_STATUS2_REG__ID__SHIFT                                                                          0x0
#define SDMA0_STATUS2_REG__TH0MCU_INSTR_PTR__SHIFT                                                            0x2
#define SDMA0_STATUS2_REG__CMD_OP__SHIFT                                                                      0x10
#define SDMA0_STATUS2_REG__ID_MASK                                                                            0x00000003L
#define SDMA0_STATUS2_REG__TH0MCU_INSTR_PTR_MASK                                                              0x0000FFFCL
#define SDMA0_STATUS2_REG__CMD_OP_MASK                                                                        0xFFFF0000L
//SDMA0_ATOMIC_CNTL
#define SDMA0_ATOMIC_CNTL__LOOP_TIMER__SHIFT                                                                  0x0
#define SDMA0_ATOMIC_CNTL__ATOMIC_RTN_INT_ENABLE__SHIFT                                                       0x1f
#define SDMA0_ATOMIC_CNTL__LOOP_TIMER_MASK                                                                    0x7FFFFFFFL
#define SDMA0_ATOMIC_CNTL__ATOMIC_RTN_INT_ENABLE_MASK                                                         0x80000000L
//SDMA0_ATOMIC_PREOP_LO
#define SDMA0_ATOMIC_PREOP_LO__DATA__SHIFT                                                                    0x0
#define SDMA0_ATOMIC_PREOP_LO__DATA_MASK                                                                      0xFFFFFFFFL
//SDMA0_ATOMIC_PREOP_HI
#define SDMA0_ATOMIC_PREOP_HI__DATA__SHIFT                                                                    0x0
#define SDMA0_ATOMIC_PREOP_HI__DATA_MASK                                                                      0xFFFFFFFFL
//SDMA0_DCC_CNTL
#define SDMA0_DCC_CNTL__DCC_FORCE_BYPASS__SHIFT                                                               0x0
#define SDMA0_DCC_CNTL__DCC_RD_NOPTE_OVERRIDE_0__SHIFT                                                        0x1
#define SDMA0_DCC_CNTL__DCC_RD_NOPTE_COMP_EN_0__SHIFT                                                         0x2
#define SDMA0_DCC_CNTL__DCC_WR_NOPTE_OVERRIDE_0__SHIFT                                                        0x3
#define SDMA0_DCC_CNTL__DCC_WR_NOPTE_COMP_EN_0__SHIFT                                                         0x4
#define SDMA0_DCC_CNTL__DCC_RD_NOPTE_OVERRIDE_1__SHIFT                                                        0x5
#define SDMA0_DCC_CNTL__DCC_RD_NOPTE_COMP_EN_1__SHIFT                                                         0x6
#define SDMA0_DCC_CNTL__DCC_WR_NOPTE_OVERRIDE_1__SHIFT                                                        0x7
#define SDMA0_DCC_CNTL__DCC_WR_NOPTE_COMP_EN_1__SHIFT                                                         0x8
#define SDMA0_DCC_CNTL__DCC_RD_NOPTE_OVERRIDE_2__SHIFT                                                        0x9
#define SDMA0_DCC_CNTL__DCC_RD_NOPTE_COMP_EN_2__SHIFT                                                         0xa
#define SDMA0_DCC_CNTL__DCC_WR_NOPTE_OVERRIDE_2__SHIFT                                                        0xb
#define SDMA0_DCC_CNTL__DCC_WR_NOPTE_COMP_EN_2__SHIFT                                                         0xc
#define SDMA0_DCC_CNTL__DCC_RD_NOPTE_OVERRIDE_3__SHIFT                                                        0xd
#define SDMA0_DCC_CNTL__DCC_RD_NOPTE_COMP_EN_3__SHIFT                                                         0xe
#define SDMA0_DCC_CNTL__DCC_WR_NOPTE_OVERRIDE_3__SHIFT                                                        0xf
#define SDMA0_DCC_CNTL__DCC_WR_NOPTE_COMP_EN_3__SHIFT                                                         0x10
#define SDMA0_DCC_CNTL__DCC_FORCE_BYPASS_MASK                                                                 0x00000001L
#define SDMA0_DCC_CNTL__DCC_RD_NOPTE_OVERRIDE_0_MASK                                                          0x00000002L
#define SDMA0_DCC_CNTL__DCC_RD_NOPTE_COMP_EN_0_MASK                                                           0x00000004L
#define SDMA0_DCC_CNTL__DCC_WR_NOPTE_OVERRIDE_0_MASK                                                          0x00000008L
#define SDMA0_DCC_CNTL__DCC_WR_NOPTE_COMP_EN_0_MASK                                                           0x00000010L
#define SDMA0_DCC_CNTL__DCC_RD_NOPTE_OVERRIDE_1_MASK                                                          0x00000020L
#define SDMA0_DCC_CNTL__DCC_RD_NOPTE_COMP_EN_1_MASK                                                           0x00000040L
#define SDMA0_DCC_CNTL__DCC_WR_NOPTE_OVERRIDE_1_MASK                                                          0x00000080L
#define SDMA0_DCC_CNTL__DCC_WR_NOPTE_COMP_EN_1_MASK                                                           0x00000100L
#define SDMA0_DCC_CNTL__DCC_RD_NOPTE_OVERRIDE_2_MASK                                                          0x00000200L
#define SDMA0_DCC_CNTL__DCC_RD_NOPTE_COMP_EN_2_MASK                                                           0x00000400L
#define SDMA0_DCC_CNTL__DCC_WR_NOPTE_OVERRIDE_2_MASK                                                          0x00000800L
#define SDMA0_DCC_CNTL__DCC_WR_NOPTE_COMP_EN_2_MASK                                                           0x00001000L
#define SDMA0_DCC_CNTL__DCC_RD_NOPTE_OVERRIDE_3_MASK                                                          0x00002000L
#define SDMA0_DCC_CNTL__DCC_RD_NOPTE_COMP_EN_3_MASK                                                           0x00004000L
#define SDMA0_DCC_CNTL__DCC_WR_NOPTE_OVERRIDE_3_MASK                                                          0x00008000L
#define SDMA0_DCC_CNTL__DCC_WR_NOPTE_COMP_EN_3_MASK                                                           0x00010000L
//SDMA0_UTCL1_CNTL
#define SDMA0_UTCL1_CNTL__REDO_DELAY__SHIFT                                                                   0x0
#define SDMA0_UTCL1_CNTL__PAGE_WAIT_DELAY__SHIFT                                                              0x5
#define SDMA0_UTCL1_CNTL__RESP_MODE__SHIFT                                                                    0x9
#define SDMA0_UTCL1_CNTL__FORCE_INVALIDATION__SHIFT                                                           0xe
#define SDMA0_UTCL1_CNTL__FORCE_INVREQ_HEAVY__SHIFT                                                           0xf
#define SDMA0_UTCL1_CNTL__WR_EXE_PERMS_CTRL__SHIFT                                                            0x10
#define SDMA0_UTCL1_CNTL__RD_EXE_PERMS_CTRL__SHIFT                                                            0x11
#define SDMA0_UTCL1_CNTL__INVACK_DELAY__SHIFT                                                                 0x12
#define SDMA0_UTCL1_CNTL__REQL2_CREDIT__SHIFT                                                                 0x18
#define SDMA0_UTCL1_CNTL__REDO_DELAY_MASK                                                                     0x0000001FL
#define SDMA0_UTCL1_CNTL__PAGE_WAIT_DELAY_MASK                                                                0x000001E0L
#define SDMA0_UTCL1_CNTL__RESP_MODE_MASK                                                                      0x00000600L
#define SDMA0_UTCL1_CNTL__FORCE_INVALIDATION_MASK                                                             0x00004000L
#define SDMA0_UTCL1_CNTL__FORCE_INVREQ_HEAVY_MASK                                                             0x00008000L
#define SDMA0_UTCL1_CNTL__WR_EXE_PERMS_CTRL_MASK                                                              0x00010000L
#define SDMA0_UTCL1_CNTL__RD_EXE_PERMS_CTRL_MASK                                                              0x00020000L
#define SDMA0_UTCL1_CNTL__INVACK_DELAY_MASK                                                                   0x003C0000L
#define SDMA0_UTCL1_CNTL__REQL2_CREDIT_MASK                                                                   0x3F000000L
//SDMA0_UTCL1_WATERMK
#define SDMA0_UTCL1_WATERMK__WR_REQ_FIFO_WATERMK__SHIFT                                                       0x0
#define SDMA0_UTCL1_WATERMK__WR_REQ_FIFO_DEPTH_STEP__SHIFT                                                    0x4
#define SDMA0_UTCL1_WATERMK__RD_REQ_FIFO_WATERMK__SHIFT                                                       0x6
#define SDMA0_UTCL1_WATERMK__RD_REQ_FIFO_DEPTH_STEP__SHIFT                                                    0xa
#define SDMA0_UTCL1_WATERMK__WR_PAGE_FIFO_WATERMK__SHIFT                                                      0xc
#define SDMA0_UTCL1_WATERMK__WR_PAGE_FIFO_DEPTH_STEP__SHIFT                                                   0x10
#define SDMA0_UTCL1_WATERMK__RD_PAGE_FIFO_WATERMK__SHIFT                                                      0x12
#define SDMA0_UTCL1_WATERMK__RD_PAGE_FIFO_DEPTH_STEP__SHIFT                                                   0x16
#define SDMA0_UTCL1_WATERMK__WR_REQ_FIFO_WATERMK_MASK                                                         0x0000000FL
#define SDMA0_UTCL1_WATERMK__WR_REQ_FIFO_DEPTH_STEP_MASK                                                      0x00000030L
#define SDMA0_UTCL1_WATERMK__RD_REQ_FIFO_WATERMK_MASK                                                         0x000003C0L
#define SDMA0_UTCL1_WATERMK__RD_REQ_FIFO_DEPTH_STEP_MASK                                                      0x00000C00L
#define SDMA0_UTCL1_WATERMK__WR_PAGE_FIFO_WATERMK_MASK                                                        0x0000F000L
#define SDMA0_UTCL1_WATERMK__WR_PAGE_FIFO_DEPTH_STEP_MASK                                                     0x00030000L
#define SDMA0_UTCL1_WATERMK__RD_PAGE_FIFO_WATERMK_MASK                                                        0x003C0000L
#define SDMA0_UTCL1_WATERMK__RD_PAGE_FIFO_DEPTH_STEP_MASK                                                     0x00C00000L
//SDMA0_UTCL1_TIMEOUT
#define SDMA0_UTCL1_TIMEOUT__XNACK_LIMIT__SHIFT                                                               0x0
#define SDMA0_UTCL1_TIMEOUT__XNACK_LIMIT_MASK                                                                 0x0000FFFFL
//SDMA0_UTCL1_PAGE
#define SDMA0_UTCL1_PAGE__INVALID_ADDR__SHIFT                                                                 0x0
#define SDMA0_UTCL1_PAGE__REQ_TYPE__SHIFT                                                                     0x1
#define SDMA0_UTCL1_PAGE__USE_MTYPE__SHIFT                                                                    0x6
#define SDMA0_UTCL1_PAGE__USE_PT_SNOOP__SHIFT                                                                 0xa
#define SDMA0_UTCL1_PAGE__USE_IO__SHIFT                                                                       0xb
#define SDMA0_UTCL1_PAGE__RD_L2_POLICY__SHIFT                                                                 0xc
#define SDMA0_UTCL1_PAGE__WR_L2_POLICY__SHIFT                                                                 0xe
#define SDMA0_UTCL1_PAGE__DMA_PAGE_SIZE__SHIFT                                                                0x10
#define SDMA0_UTCL1_PAGE__USE_BC__SHIFT                                                                       0x16
#define SDMA0_UTCL1_PAGE__ADDR_IS_PA__SHIFT                                                                   0x17
#define SDMA0_UTCL1_PAGE__INVALID_ADDR_MASK                                                                   0x00000001L
#define SDMA0_UTCL1_PAGE__REQ_TYPE_MASK                                                                       0x0000001EL
#define SDMA0_UTCL1_PAGE__USE_MTYPE_MASK                                                                      0x000003C0L
#define SDMA0_UTCL1_PAGE__USE_PT_SNOOP_MASK                                                                   0x00000400L
#define SDMA0_UTCL1_PAGE__USE_IO_MASK                                                                         0x00000800L
#define SDMA0_UTCL1_PAGE__RD_L2_POLICY_MASK                                                                   0x00003000L
#define SDMA0_UTCL1_PAGE__WR_L2_POLICY_MASK                                                                   0x0000C000L
#define SDMA0_UTCL1_PAGE__DMA_PAGE_SIZE_MASK                                                                  0x003F0000L
#define SDMA0_UTCL1_PAGE__USE_BC_MASK                                                                         0x00400000L
#define SDMA0_UTCL1_PAGE__ADDR_IS_PA_MASK                                                                     0x00800000L
//SDMA0_EXTERNAL_FROZEN
#define SDMA0_EXTERNAL_FROZEN__THRESHOLD__SHIFT                                                               0x0
#define SDMA0_EXTERNAL_FROZEN__THRESHOLD_MASK                                                                 0x0000FFFFL
//SDMA0_UTCL1_RD_STATUS
#define SDMA0_UTCL1_RD_STATUS__CE_RD_DATA_FIFO_EMPTY__SHIFT                                                   0x0
#define SDMA0_UTCL1_RD_STATUS__CE_RD_VA_REQ_SEND_FIFO_EMPTY__SHIFT                                            0x1
#define SDMA0_UTCL1_RD_STATUS__CE_RD_REG_ENTRY_EMPTY__SHIFT                                                   0x2
#define SDMA0_UTCL1_RD_STATUS__CE_RD_PAGE_FIFO_EMPTY__SHIFT                                                   0x3
#define SDMA0_UTCL1_RD_STATUS__CE_RD_REQ_FIFO_EMPTY__SHIFT                                                    0x4
#define SDMA0_UTCL1_RD_STATUS__RD_VA_FIFO_EMPTY__SHIFT                                                        0x5
#define SDMA0_UTCL1_RD_STATUS__CE_RD_VA_REQ_SEND_FIFO_FULL__SHIFT                                             0x7
#define SDMA0_UTCL1_RD_STATUS__CE_RD_REG_ENTRY_FULL__SHIFT                                                    0x8
#define SDMA0_UTCL1_RD_STATUS__CE_RD_PAGE_FIFO_FULL__SHIFT                                                    0x9
#define SDMA0_UTCL1_RD_STATUS__CE_RD_REQ_FIFO_FULL__SHIFT                                                     0xa
#define SDMA0_UTCL1_RD_STATUS__RD_VA_FIFO_FULL__SHIFT                                                         0xb
#define SDMA0_UTCL1_RD_STATUS__L2_INTF_RD_IDLE__SHIFT                                                         0x10
#define SDMA0_UTCL1_RD_STATUS__RD_REQRET_IDLE__SHIFT                                                          0x11
#define SDMA0_UTCL1_RD_STATUS__RD_REQ_IDLE__SHIFT                                                             0x12
#define SDMA0_UTCL1_RD_STATUS__CE_RD_DATA_FIFO_EMPTY_MASK                                                     0x00000001L
#define SDMA0_UTCL1_RD_STATUS__CE_RD_VA_REQ_SEND_FIFO_EMPTY_MASK                                              0x00000002L
#define SDMA0_UTCL1_RD_STATUS__CE_RD_REG_ENTRY_EMPTY_MASK                                                     0x00000004L
#define SDMA0_UTCL1_RD_STATUS__CE_RD_PAGE_FIFO_EMPTY_MASK                                                     0x00000008L
#define SDMA0_UTCL1_RD_STATUS__CE_RD_REQ_FIFO_EMPTY_MASK                                                      0x00000010L
#define SDMA0_UTCL1_RD_STATUS__RD_VA_FIFO_EMPTY_MASK                                                          0x00000020L
#define SDMA0_UTCL1_RD_STATUS__CE_RD_VA_REQ_SEND_FIFO_FULL_MASK                                               0x00000080L
#define SDMA0_UTCL1_RD_STATUS__CE_RD_REG_ENTRY_FULL_MASK                                                      0x00000100L
#define SDMA0_UTCL1_RD_STATUS__CE_RD_PAGE_FIFO_FULL_MASK                                                      0x00000200L
#define SDMA0_UTCL1_RD_STATUS__CE_RD_REQ_FIFO_FULL_MASK                                                       0x00000400L
#define SDMA0_UTCL1_RD_STATUS__RD_VA_FIFO_FULL_MASK                                                           0x00000800L
#define SDMA0_UTCL1_RD_STATUS__L2_INTF_RD_IDLE_MASK                                                           0x00010000L
#define SDMA0_UTCL1_RD_STATUS__RD_REQRET_IDLE_MASK                                                            0x00020000L
#define SDMA0_UTCL1_RD_STATUS__RD_REQ_IDLE_MASK                                                               0x00040000L
//SDMA0_UTCL1_WR_STATUS
#define SDMA0_UTCL1_WR_STATUS__CE_WR_DATA_FIFO_EMPTY__SHIFT                                                   0x0
#define SDMA0_UTCL1_WR_STATUS__CE_WR_VA_REQ_SEND_FIFO_EMPTY__SHIFT                                            0x1
#define SDMA0_UTCL1_WR_STATUS__CE_WR_REG_ENTRY_EMPTY__SHIFT                                                   0x2
#define SDMA0_UTCL1_WR_STATUS__CE_WR_PAGE_FIFO_EMPTY__SHIFT                                                   0x3
#define SDMA0_UTCL1_WR_STATUS__CE_WR_REQ_FIFO_EMPTY__SHIFT                                                    0x4
#define SDMA0_UTCL1_WR_STATUS__WR_VA_FIFO_EMPTY__SHIFT                                                        0x5
#define SDMA0_UTCL1_WR_STATUS__CE_WR_DATA_FIFO_FULL__SHIFT                                                    0x6
#define SDMA0_UTCL1_WR_STATUS__CE_WR_VA_REQ_SEND_FIFO_FULL__SHIFT                                             0x7
#define SDMA0_UTCL1_WR_STATUS__CE_WR_REG_ENTRY_FULL__SHIFT                                                    0x8
#define SDMA0_UTCL1_WR_STATUS__CE_WR_PAGE_FIFO_FULL__SHIFT                                                    0x9
#define SDMA0_UTCL1_WR_STATUS__CE_WR_REQ_FIFO_FULL__SHIFT                                                     0xa
#define SDMA0_UTCL1_WR_STATUS__WR_VA_FIFO_FULL__SHIFT                                                         0xb
#define SDMA0_UTCL1_WR_STATUS__L2_INTF_WR_IDLE__SHIFT                                                         0x10
#define SDMA0_UTCL1_WR_STATUS__WR_REQRET_IDLE__SHIFT                                                          0x11
#define SDMA0_UTCL1_WR_STATUS__WR_REQ_IDLE__SHIFT                                                             0x12
#define SDMA0_UTCL1_WR_STATUS__CE_WR_DATA_FIFO_EMPTY_MASK                                                     0x00000001L
#define SDMA0_UTCL1_WR_STATUS__CE_WR_VA_REQ_SEND_FIFO_EMPTY_MASK                                              0x00000002L
#define SDMA0_UTCL1_WR_STATUS__CE_WR_REG_ENTRY_EMPTY_MASK                                                     0x00000004L
#define SDMA0_UTCL1_WR_STATUS__CE_WR_PAGE_FIFO_EMPTY_MASK                                                     0x00000008L
#define SDMA0_UTCL1_WR_STATUS__CE_WR_REQ_FIFO_EMPTY_MASK                                                      0x00000010L
#define SDMA0_UTCL1_WR_STATUS__WR_VA_FIFO_EMPTY_MASK                                                          0x00000020L
#define SDMA0_UTCL1_WR_STATUS__CE_WR_DATA_FIFO_FULL_MASK                                                      0x00000040L
#define SDMA0_UTCL1_WR_STATUS__CE_WR_VA_REQ_SEND_FIFO_FULL_MASK                                               0x00000080L
#define SDMA0_UTCL1_WR_STATUS__CE_WR_REG_ENTRY_FULL_MASK                                                      0x00000100L
#define SDMA0_UTCL1_WR_STATUS__CE_WR_PAGE_FIFO_FULL_MASK                                                      0x00000200L
#define SDMA0_UTCL1_WR_STATUS__CE_WR_REQ_FIFO_FULL_MASK                                                       0x00000400L
#define SDMA0_UTCL1_WR_STATUS__WR_VA_FIFO_FULL_MASK                                                           0x00000800L
#define SDMA0_UTCL1_WR_STATUS__L2_INTF_WR_IDLE_MASK                                                           0x00010000L
#define SDMA0_UTCL1_WR_STATUS__WR_REQRET_IDLE_MASK                                                            0x00020000L
#define SDMA0_UTCL1_WR_STATUS__WR_REQ_IDLE_MASK                                                               0x00040000L
//SDMA0_UTCL1_INV0
#define SDMA0_UTCL1_INV0__INV_PROC_BUSY__SHIFT                                                                0x0
#define SDMA0_UTCL1_INV0__GPUVM_FRAG_SIZE__SHIFT                                                              0x1
#define SDMA0_UTCL1_INV0__GPUVM_VMID__SHIFT                                                                   0x7
#define SDMA0_UTCL1_INV0__GPUVM_MODE__SHIFT                                                                   0xb
#define SDMA0_UTCL1_INV0__GPUVM_HIGH__SHIFT                                                                   0xd
#define SDMA0_UTCL1_INV0__GPUVM_TAG__SHIFT                                                                    0xe
#define SDMA0_UTCL1_INV0__GPUVM_VMID_HIGH__SHIFT                                                              0x12
#define SDMA0_UTCL1_INV0__GPUVM_VMID_LOW__SHIFT                                                               0x16
#define SDMA0_UTCL1_INV0__INV_TYPE__SHIFT                                                                     0x1a
#define SDMA0_UTCL1_INV0__INV_PROC_BUSY_MASK                                                                  0x00000001L
#define SDMA0_UTCL1_INV0__GPUVM_FRAG_SIZE_MASK                                                                0x0000007EL
#define SDMA0_UTCL1_INV0__GPUVM_VMID_MASK                                                                     0x00000780L
#define SDMA0_UTCL1_INV0__GPUVM_MODE_MASK                                                                     0x00001800L
#define SDMA0_UTCL1_INV0__GPUVM_HIGH_MASK                                                                     0x00002000L
#define SDMA0_UTCL1_INV0__GPUVM_TAG_MASK                                                                      0x0003C000L
#define SDMA0_UTCL1_INV0__GPUVM_VMID_HIGH_MASK                                                                0x003C0000L
#define SDMA0_UTCL1_INV0__GPUVM_VMID_LOW_MASK                                                                 0x03C00000L
#define SDMA0_UTCL1_INV0__INV_TYPE_MASK                                                                       0x0C000000L
//SDMA0_UTCL1_INV1
#define SDMA0_UTCL1_INV1__INV_ADDR_LO__SHIFT                                                                  0x0
#define SDMA0_UTCL1_INV1__INV_ADDR_LO_MASK                                                                    0xFFFFFFFFL
//SDMA0_UTCL1_INV2
#define SDMA0_UTCL1_INV2__CPF_VMID__SHIFT                                                                     0x0
#define SDMA0_UTCL1_INV2__CPF_FLUSH_TYPE__SHIFT                                                               0x10
#define SDMA0_UTCL1_INV2__CPF_FRAG_SIZE__SHIFT                                                                0x11
#define SDMA0_UTCL1_INV2__CPF_VMID_MASK                                                                       0x0000FFFFL
#define SDMA0_UTCL1_INV2__CPF_FLUSH_TYPE_MASK                                                                 0x00010000L
#define SDMA0_UTCL1_INV2__CPF_FRAG_SIZE_MASK                                                                  0x007E0000L
//SDMA0_UTCL1_RD_XNACK0
#define SDMA0_UTCL1_RD_XNACK0__XNACK_FAULT_ADDR_LO__SHIFT                                                     0x0
#define SDMA0_UTCL1_RD_XNACK0__XNACK_FAULT_ADDR_LO_MASK                                                       0xFFFFFFFFL
//SDMA0_UTCL1_RD_XNACK1
#define SDMA0_UTCL1_RD_XNACK1__XNACK_FAULT_ADDR_HI__SHIFT                                                     0x0
#define SDMA0_UTCL1_RD_XNACK1__XNACK_FAULT_VMID__SHIFT                                                        0x4
#define SDMA0_UTCL1_RD_XNACK1__XNACK_FAULT_VECTOR__SHIFT                                                      0x8
#define SDMA0_UTCL1_RD_XNACK1__XNACK_NULL_VECTOR__SHIFT                                                       0xb
#define SDMA0_UTCL1_RD_XNACK1__XNACK_TIMEOUT_VECTOR__SHIFT                                                    0xe
#define SDMA0_UTCL1_RD_XNACK1__XNACK_FAULT_FLAG__SHIFT                                                        0x11
#define SDMA0_UTCL1_RD_XNACK1__XNACK_NULL_FLAG__SHIFT                                                         0x12
#define SDMA0_UTCL1_RD_XNACK1__XNACK_TIMEOUT_FLAG__SHIFT                                                      0x13
#define SDMA0_UTCL1_RD_XNACK1__XNACK_FAULT_ADDR_HI_MASK                                                       0x0000000FL
#define SDMA0_UTCL1_RD_XNACK1__XNACK_FAULT_VMID_MASK                                                          0x000000F0L
#define SDMA0_UTCL1_RD_XNACK1__XNACK_FAULT_VECTOR_MASK                                                        0x00000700L
#define SDMA0_UTCL1_RD_XNACK1__XNACK_NULL_VECTOR_MASK                                                         0x00003800L
#define SDMA0_UTCL1_RD_XNACK1__XNACK_TIMEOUT_VECTOR_MASK                                                      0x0001C000L
#define SDMA0_UTCL1_RD_XNACK1__XNACK_FAULT_FLAG_MASK                                                          0x00020000L
#define SDMA0_UTCL1_RD_XNACK1__XNACK_NULL_FLAG_MASK                                                           0x00040000L
#define SDMA0_UTCL1_RD_XNACK1__XNACK_TIMEOUT_FLAG_MASK                                                        0x00080000L
//SDMA0_UTCL1_WR_XNACK0
#define SDMA0_UTCL1_WR_XNACK0__XNACK_FAULT_ADDR_LO__SHIFT                                                     0x0
#define SDMA0_UTCL1_WR_XNACK0__XNACK_FAULT_ADDR_LO_MASK                                                       0xFFFFFFFFL
//SDMA0_UTCL1_WR_XNACK1
#define SDMA0_UTCL1_WR_XNACK1__XNACK_FAULT_ADDR_HI__SHIFT                                                     0x0
#define SDMA0_UTCL1_WR_XNACK1__XNACK_FAULT_VMID__SHIFT                                                        0x4
#define SDMA0_UTCL1_WR_XNACK1__XNACK_FAULT_VECTOR__SHIFT                                                      0x8
#define SDMA0_UTCL1_WR_XNACK1__XNACK_NULL_VECTOR__SHIFT                                                       0xb
#define SDMA0_UTCL1_WR_XNACK1__XNACK_TIMEOUT_VECTOR__SHIFT                                                    0xe
#define SDMA0_UTCL1_WR_XNACK1__XNACK_FAULT_FLAG__SHIFT                                                        0x11
#define SDMA0_UTCL1_WR_XNACK1__XNACK_NULL_FLAG__SHIFT                                                         0x12
#define SDMA0_UTCL1_WR_XNACK1__XNACK_TIMEOUT_FLAG__SHIFT                                                      0x13
#define SDMA0_UTCL1_WR_XNACK1__XNACK_FAULT_ADDR_HI_MASK                                                       0x0000000FL
#define SDMA0_UTCL1_WR_XNACK1__XNACK_FAULT_VMID_MASK                                                          0x000000F0L
#define SDMA0_UTCL1_WR_XNACK1__XNACK_FAULT_VECTOR_MASK                                                        0x00000700L
#define SDMA0_UTCL1_WR_XNACK1__XNACK_NULL_VECTOR_MASK                                                         0x00003800L
#define SDMA0_UTCL1_WR_XNACK1__XNACK_TIMEOUT_VECTOR_MASK                                                      0x0001C000L
#define SDMA0_UTCL1_WR_XNACK1__XNACK_FAULT_FLAG_MASK                                                          0x00020000L
#define SDMA0_UTCL1_WR_XNACK1__XNACK_NULL_FLAG_MASK                                                           0x00040000L
#define SDMA0_UTCL1_WR_XNACK1__XNACK_TIMEOUT_FLAG_MASK                                                        0x00080000L
//SDMA0_RELAX_ORDERING_LUT
#define SDMA0_RELAX_ORDERING_LUT__RESERVED0__SHIFT                                                            0x0
#define SDMA0_RELAX_ORDERING_LUT__COPY__SHIFT                                                                 0x1
#define SDMA0_RELAX_ORDERING_LUT__WRITE__SHIFT                                                                0x2
#define SDMA0_RELAX_ORDERING_LUT__RESERVED3__SHIFT                                                            0x3
#define SDMA0_RELAX_ORDERING_LUT__RESERVED4__SHIFT                                                            0x4
#define SDMA0_RELAX_ORDERING_LUT__FENCE__SHIFT                                                                0x5
#define SDMA0_RELAX_ORDERING_LUT__RESERVED76__SHIFT                                                           0x6
#define SDMA0_RELAX_ORDERING_LUT__POLL_MEM__SHIFT                                                             0x8
#define SDMA0_RELAX_ORDERING_LUT__COND_EXE__SHIFT                                                             0x9
#define SDMA0_RELAX_ORDERING_LUT__ATOMIC__SHIFT                                                               0xa
#define SDMA0_RELAX_ORDERING_LUT__CONST_FILL__SHIFT                                                           0xb
#define SDMA0_RELAX_ORDERING_LUT__PTEPDE__SHIFT                                                               0xc
#define SDMA0_RELAX_ORDERING_LUT__TIMESTAMP__SHIFT                                                            0xd
#define SDMA0_RELAX_ORDERING_LUT__RESERVED__SHIFT                                                             0xe
#define SDMA0_RELAX_ORDERING_LUT__RB_PREEMPT__SHIFT                                                           0x1a
#define SDMA0_RELAX_ORDERING_LUT__WORLD_SWITCH__SHIFT                                                         0x1b
#define SDMA0_RELAX_ORDERING_LUT__RPTR_WRB__SHIFT                                                             0x1c
#define SDMA0_RELAX_ORDERING_LUT__WPTR_POLL__SHIFT                                                            0x1d
#define SDMA0_RELAX_ORDERING_LUT__IB_FETCH__SHIFT                                                             0x1e
#define SDMA0_RELAX_ORDERING_LUT__RB_FETCH__SHIFT                                                             0x1f
#define SDMA0_RELAX_ORDERING_LUT__RESERVED0_MASK                                                              0x00000001L
#define SDMA0_RELAX_ORDERING_LUT__COPY_MASK                                                                   0x00000002L
#define SDMA0_RELAX_ORDERING_LUT__WRITE_MASK                                                                  0x00000004L
#define SDMA0_RELAX_ORDERING_LUT__RESERVED3_MASK                                                              0x00000008L
#define SDMA0_RELAX_ORDERING_LUT__RESERVED4_MASK                                                              0x00000010L
#define SDMA0_RELAX_ORDERING_LUT__FENCE_MASK                                                                  0x00000020L
#define SDMA0_RELAX_ORDERING_LUT__RESERVED76_MASK                                                             0x000000C0L
#define SDMA0_RELAX_ORDERING_LUT__POLL_MEM_MASK                                                               0x00000100L
#define SDMA0_RELAX_ORDERING_LUT__COND_EXE_MASK                                                               0x00000200L
#define SDMA0_RELAX_ORDERING_LUT__ATOMIC_MASK                                                                 0x00000400L
#define SDMA0_RELAX_ORDERING_LUT__CONST_FILL_MASK                                                             0x00000800L
#define SDMA0_RELAX_ORDERING_LUT__PTEPDE_MASK                                                                 0x00001000L
#define SDMA0_RELAX_ORDERING_LUT__TIMESTAMP_MASK                                                              0x00002000L
#define SDMA0_RELAX_ORDERING_LUT__RESERVED_MASK                                                               0x03FFC000L
#define SDMA0_RELAX_ORDERING_LUT__RB_PREEMPT_MASK                                                             0x04000000L
#define SDMA0_RELAX_ORDERING_LUT__WORLD_SWITCH_MASK                                                           0x08000000L
#define SDMA0_RELAX_ORDERING_LUT__RPTR_WRB_MASK                                                               0x10000000L
#define SDMA0_RELAX_ORDERING_LUT__WPTR_POLL_MASK                                                              0x20000000L
#define SDMA0_RELAX_ORDERING_LUT__IB_FETCH_MASK                                                               0x40000000L
#define SDMA0_RELAX_ORDERING_LUT__RB_FETCH_MASK                                                               0x80000000L
//SDMA0_CHICKEN_BITS_2
#define SDMA0_CHICKEN_BITS_2__MCU_CMD_PROC_DELAY__SHIFT                                                       0x0
#define SDMA0_CHICKEN_BITS_2__MCU_SEND_POSTCODE_EN__SHIFT                                                     0x4
#define SDMA0_CHICKEN_BITS_2__RESERVED_7_6__SHIFT                                                             0x6
#define SDMA0_CHICKEN_BITS_2__WPTR_POLL_OUTSTANDING__SHIFT                                                    0x8
#define SDMA0_CHICKEN_BITS_2__RESERVED_14_12__SHIFT                                                           0xc
#define SDMA0_CHICKEN_BITS_2__RESERVED_15__SHIFT                                                              0xf
#define SDMA0_CHICKEN_BITS_2__RB_FIFO_WATERMARK__SHIFT                                                        0x10
#define SDMA0_CHICKEN_BITS_2__IB_FIFO_WATERMARK__SHIFT                                                        0x12
#define SDMA0_CHICKEN_BITS_2__RESERVED_22_20__SHIFT                                                           0x14
#define SDMA0_CHICKEN_BITS_2__CH_RD_WATERMARK__SHIFT                                                          0x17
#define SDMA0_CHICKEN_BITS_2__CH_WR_WATERMARK__SHIFT                                                          0x19
#define SDMA0_CHICKEN_BITS_2__CH_WR_WATERMARK_LSB__SHIFT                                                      0x1e
#define SDMA0_CHICKEN_BITS_2__PIO_VFID_SOURCE__SHIFT                                                          0x1f
#define SDMA0_CHICKEN_BITS_2__MCU_CMD_PROC_DELAY_MASK                                                         0x0000000FL
#define SDMA0_CHICKEN_BITS_2__MCU_SEND_POSTCODE_EN_MASK                                                       0x00000010L
#define SDMA0_CHICKEN_BITS_2__RESERVED_7_6_MASK                                                               0x000000C0L
#define SDMA0_CHICKEN_BITS_2__WPTR_POLL_OUTSTANDING_MASK                                                      0x00000F00L
#define SDMA0_CHICKEN_BITS_2__RESERVED_14_12_MASK                                                             0x00007000L
#define SDMA0_CHICKEN_BITS_2__RESERVED_15_MASK                                                                0x00008000L
#define SDMA0_CHICKEN_BITS_2__RB_FIFO_WATERMARK_MASK                                                          0x00030000L
#define SDMA0_CHICKEN_BITS_2__IB_FIFO_WATERMARK_MASK                                                          0x000C0000L
#define SDMA0_CHICKEN_BITS_2__RESERVED_22_20_MASK                                                             0x00700000L
#define SDMA0_CHICKEN_BITS_2__CH_RD_WATERMARK_MASK                                                            0x01800000L
#define SDMA0_CHICKEN_BITS_2__CH_WR_WATERMARK_MASK                                                            0x3E000000L
#define SDMA0_CHICKEN_BITS_2__CH_WR_WATERMARK_LSB_MASK                                                        0x40000000L
#define SDMA0_CHICKEN_BITS_2__PIO_VFID_SOURCE_MASK                                                            0x80000000L
//SDMA0_STATUS3_REG
#define SDMA0_STATUS3_REG__PREV_VM_CMD__SHIFT                                                                 0x10
#define SDMA0_STATUS3_REG__EXCEPTION_IDLE__SHIFT                                                              0x14
#define SDMA0_STATUS3_REG__AQL_PREV_CMD_IDLE__SHIFT                                                           0x15
#define SDMA0_STATUS3_REG__TLBI_IDLE__SHIFT                                                                   0x16
#define SDMA0_STATUS3_REG__GCR_IDLE__SHIFT                                                                    0x17
#define SDMA0_STATUS3_REG__INVREQ_IDLE__SHIFT                                                                 0x18
#define SDMA0_STATUS3_REG__QUEUE_ID_MATCH__SHIFT                                                              0x19
#define SDMA0_STATUS3_REG__INT_QUEUE_ID__SHIFT                                                                0x1a
#define SDMA0_STATUS3_REG__TMZ_MTYPE_STATUS__SHIFT                                                            0x1e
#define SDMA0_STATUS3_REG__PREV_VM_CMD_MASK                                                                   0x000F0000L
#define SDMA0_STATUS3_REG__EXCEPTION_IDLE_MASK                                                                0x00100000L
#define SDMA0_STATUS3_REG__AQL_PREV_CMD_IDLE_MASK                                                             0x00200000L
#define SDMA0_STATUS3_REG__TLBI_IDLE_MASK                                                                     0x00400000L
#define SDMA0_STATUS3_REG__GCR_IDLE_MASK                                                                      0x00800000L
#define SDMA0_STATUS3_REG__INVREQ_IDLE_MASK                                                                   0x01000000L
#define SDMA0_STATUS3_REG__QUEUE_ID_MATCH_MASK                                                                0x02000000L
#define SDMA0_STATUS3_REG__INT_QUEUE_ID_MASK                                                                  0x3C000000L
#define SDMA0_STATUS3_REG__TMZ_MTYPE_STATUS_MASK                                                              0xC0000000L
//SDMA0_GLOBAL_QUANTUM
#define SDMA0_GLOBAL_QUANTUM__GLOBAL_FOCUS_QUANTUM__SHIFT                                                     0x0
#define SDMA0_GLOBAL_QUANTUM__GLOBAL_NORMAL_QUANTUM__SHIFT                                                    0x8
#define SDMA0_GLOBAL_QUANTUM__GLOBAL_FOCUS_QUANTUM_MASK                                                       0x000000FFL
#define SDMA0_GLOBAL_QUANTUM__GLOBAL_NORMAL_QUANTUM_MASK                                                      0x0000FF00L
//SDMA0_ERROR_LOG
#define SDMA0_ERROR_LOG__OVERRIDE__SHIFT                                                                      0x0
#define SDMA0_ERROR_LOG__STATUS__SHIFT                                                                        0x10
#define SDMA0_ERROR_LOG__OVERRIDE_MASK                                                                        0x0000FFFFL
#define SDMA0_ERROR_LOG__STATUS_MASK                                                                          0xFFFF0000L
//SDMA0_PUB_DUMMY_REG0
#define SDMA0_PUB_DUMMY_REG0__VALUE__SHIFT                                                                    0x0
#define SDMA0_PUB_DUMMY_REG0__VALUE_MASK                                                                      0xFFFFFFFFL
//SDMA0_PUB_DUMMY_REG1
#define SDMA0_PUB_DUMMY_REG1__VALUE__SHIFT                                                                    0x0
#define SDMA0_PUB_DUMMY_REG1__VALUE_MASK                                                                      0xFFFFFFFFL
//SDMA0_PUB_DUMMY_REG2
#define SDMA0_PUB_DUMMY_REG2__VALUE__SHIFT                                                                    0x0
#define SDMA0_PUB_DUMMY_REG2__VALUE_MASK                                                                      0xFFFFFFFFL
//SDMA0_PUB_DUMMY_REG3
#define SDMA0_PUB_DUMMY_REG3__VALUE__SHIFT                                                                    0x0
#define SDMA0_PUB_DUMMY_REG3__VALUE_MASK                                                                      0xFFFFFFFFL
//SDMA0_MCU_COUNTER
#define SDMA0_MCU_COUNTER__VALUE__SHIFT                                                                       0x0
#define SDMA0_MCU_COUNTER__VALUE_MASK                                                                         0xFFFFFFFFL
//SDMA0_CRD_CNTL
#define SDMA0_CRD_CNTL__CH_WRREQ_CREDIT__SHIFT                                                                0x13
#define SDMA0_CRD_CNTL__CH_RDREQ_CREDIT__SHIFT                                                                0x19
#define SDMA0_CRD_CNTL__CH_WRREQ_CREDIT_MASK                                                                  0x01F80000L
#define SDMA0_CRD_CNTL__CH_RDREQ_CREDIT_MASK                                                                  0x7E000000L
//SDMA0_RLC_CGCG_CTRL
#define SDMA0_RLC_CGCG_CTRL__CGCG_INT_ENABLE__SHIFT                                                           0x1
#define SDMA0_RLC_CGCG_CTRL__MCU_CGCG_ALLOW__SHIFT                                                            0x4
#define SDMA0_RLC_CGCG_CTRL__CGCG_IDLE_HYSTERESIS__SHIFT                                                      0x10
#define SDMA0_RLC_CGCG_CTRL__CGCG_INT_ENABLE_MASK                                                             0x00000002L
#define SDMA0_RLC_CGCG_CTRL__MCU_CGCG_ALLOW_MASK                                                              0x00000010L
#define SDMA0_RLC_CGCG_CTRL__CGCG_IDLE_HYSTERESIS_MASK                                                        0xFFFF0000L
//SDMA0_GPU_IOV_VIOLATION_LOG
#define SDMA0_GPU_IOV_VIOLATION_LOG__VIOLATION_STATUS__SHIFT                                                  0x0
#define SDMA0_GPU_IOV_VIOLATION_LOG__MULTIPLE_VIOLATION_STATUS__SHIFT                                         0x1
#define SDMA0_GPU_IOV_VIOLATION_LOG__ADDRESS__SHIFT                                                           0x2
#define SDMA0_GPU_IOV_VIOLATION_LOG__WRITE_OPERATION__SHIFT                                                   0x14
#define SDMA0_GPU_IOV_VIOLATION_LOG__VF__SHIFT                                                                0x15
#define SDMA0_GPU_IOV_VIOLATION_LOG__VFID__SHIFT                                                              0x16
#define SDMA0_GPU_IOV_VIOLATION_LOG__VIOLATION_STATUS_MASK                                                    0x00000001L
#define SDMA0_GPU_IOV_VIOLATION_LOG__MULTIPLE_VIOLATION_STATUS_MASK                                           0x00000002L
#define SDMA0_GPU_IOV_VIOLATION_LOG__ADDRESS_MASK                                                             0x000FFFFCL
#define SDMA0_GPU_IOV_VIOLATION_LOG__WRITE_OPERATION_MASK                                                     0x00100000L
#define SDMA0_GPU_IOV_VIOLATION_LOG__VF_MASK                                                                  0x00200000L
#define SDMA0_GPU_IOV_VIOLATION_LOG__VFID_MASK                                                                0x07C00000L
//SDMA0_AQL_STATUS
#define SDMA0_AQL_STATUS__COMPLETE_SIGNAL_EMPTY__SHIFT                                                        0x0
#define SDMA0_AQL_STATUS__INVALID_CMD_EMPTY__SHIFT                                                            0x1
#define SDMA0_AQL_STATUS__COMPLETE_SIGNAL_EMPTY_MASK                                                          0x00000001L
#define SDMA0_AQL_STATUS__INVALID_CMD_EMPTY_MASK                                                              0x00000002L
//SDMA0_TLBI_GCR_CNTL
#define SDMA0_TLBI_GCR_CNTL__TLBI_CMD_DW__SHIFT                                                               0x0
#define SDMA0_TLBI_GCR_CNTL__GCR_CMD_DW__SHIFT                                                                0x4
#define SDMA0_TLBI_GCR_CNTL__TLBI_CREDIT__SHIFT                                                               0x10
#define SDMA0_TLBI_GCR_CNTL__GCR_CREDIT__SHIFT                                                                0x18
#define SDMA0_TLBI_GCR_CNTL__TLBI_CMD_DW_MASK                                                                 0x0000000FL
#define SDMA0_TLBI_GCR_CNTL__GCR_CMD_DW_MASK                                                                  0x000000F0L
#define SDMA0_TLBI_GCR_CNTL__TLBI_CREDIT_MASK                                                                 0x00FF0000L
#define SDMA0_TLBI_GCR_CNTL__GCR_CREDIT_MASK                                                                  0xFF000000L
//SDMA0_INT_STATUS
#define SDMA0_INT_STATUS__DATA__SHIFT                                                                         0x0
#define SDMA0_INT_STATUS__DATA_MASK                                                                           0xFFFFFFFFL
//SDMA0_GPU_IOV_VIOLATION_LOG2
#define SDMA0_GPU_IOV_VIOLATION_LOG2__INITIATOR_ID__SHIFT                                                     0x0
#define SDMA0_GPU_IOV_VIOLATION_LOG2__INITIATOR_ID_MASK                                                       0x000003FFL
//SDMA0_INVALID_ADDR_LO
#define SDMA0_INVALID_ADDR_LO__VALUE__SHIFT                                                                   0x0
#define SDMA0_INVALID_ADDR_LO__VALUE_MASK                                                                     0xFFFFFFFFL
//SDMA0_INVALID_ADDR_HI
#define SDMA0_INVALID_ADDR_HI__VALUE__SHIFT                                                                   0x0
#define SDMA0_INVALID_ADDR_HI__VALUE_MASK                                                                     0xFFFFFFFFL
//SDMA0_INVALID_ADDR_SRC
#define SDMA0_INVALID_ADDR_SRC__ID__SHIFT                                                                     0x0
#define SDMA0_INVALID_ADDR_SRC__ID_MASK                                                                       0x0000001FL
//SDMA0_CLOCK_GATING_STATUS
#define SDMA0_CLOCK_GATING_STATUS__PTR_MGCG_CLK_STATUS__SHIFT                                                 0x8
#define SDMA0_CLOCK_GATING_STATUS__PIO_MGCG_CLK_STATUS__SHIFT                                                 0x9
#define SDMA0_CLOCK_GATING_STATUS__MCU_MGCG_CLK_STATUS__SHIFT                                                 0xa
#define SDMA0_CLOCK_GATING_STATUS__COPY_ENG_MGCG_CLK_STATUS__SHIFT                                            0xb
#define SDMA0_CLOCK_GATING_STATUS__SERVE_ENG_MGCG_CLK_STATUS__SHIFT                                           0xc
#define SDMA0_CLOCK_GATING_STATUS__CMD_FETCH_MGCG_CLK_STATUS__SHIFT                                           0xd
#define SDMA0_CLOCK_GATING_STATUS__GU_MEMREQ_MGCG_CLK_STATUS__SHIFT                                           0xe
#define SDMA0_CLOCK_GATING_STATUS__INV_MGCG_CLK_STATUS__SHIFT                                                 0xf
#define SDMA0_CLOCK_GATING_STATUS__GU_CACHE_MGCG_CLK_STATUS__SHIFT                                            0x10
#define SDMA0_CLOCK_GATING_STATUS__IC_CACHE_MGCG_CLK_STATUS__SHIFT                                            0x11
#define SDMA0_CLOCK_GATING_STATUS__MEM_CHNL_MGCG_CLK_STATUS__SHIFT                                            0x12
#define SDMA0_CLOCK_GATING_STATUS__MEM_CHNL_CESE_MGCG_CLK_STATUS__SHIFT                                       0x13
#define SDMA0_CLOCK_GATING_STATUS__PTR_MGCG_CLK_STATUS_MASK                                                   0x00000100L
#define SDMA0_CLOCK_GATING_STATUS__PIO_MGCG_CLK_STATUS_MASK                                                   0x00000200L
#define SDMA0_CLOCK_GATING_STATUS__MCU_MGCG_CLK_STATUS_MASK                                                   0x00000400L
#define SDMA0_CLOCK_GATING_STATUS__COPY_ENG_MGCG_CLK_STATUS_MASK                                              0x00000800L
#define SDMA0_CLOCK_GATING_STATUS__SERVE_ENG_MGCG_CLK_STATUS_MASK                                             0x00001000L
#define SDMA0_CLOCK_GATING_STATUS__CMD_FETCH_MGCG_CLK_STATUS_MASK                                             0x00002000L
#define SDMA0_CLOCK_GATING_STATUS__GU_MEMREQ_MGCG_CLK_STATUS_MASK                                             0x00004000L
#define SDMA0_CLOCK_GATING_STATUS__INV_MGCG_CLK_STATUS_MASK                                                   0x00008000L
#define SDMA0_CLOCK_GATING_STATUS__GU_CACHE_MGCG_CLK_STATUS_MASK                                              0x00010000L
#define SDMA0_CLOCK_GATING_STATUS__IC_CACHE_MGCG_CLK_STATUS_MASK                                              0x00020000L
#define SDMA0_CLOCK_GATING_STATUS__MEM_CHNL_MGCG_CLK_STATUS_MASK                                              0x00040000L
#define SDMA0_CLOCK_GATING_STATUS__MEM_CHNL_CESE_MGCG_CLK_STATUS_MASK                                         0x00080000L
//SDMA0_STATUS4_REG
#define SDMA0_STATUS4_REG__IDLE__SHIFT                                                                        0x0
#define SDMA0_STATUS4_REG__IH_OUTSTANDING__SHIFT                                                              0x2
#define SDMA0_STATUS4_REG__RESERVED__SHIFT                                                                    0x3
#define SDMA0_STATUS4_REG__CH_RD_OUTSTANDING__SHIFT                                                           0x4
#define SDMA0_STATUS4_REG__CH_WR_OUTSTANDING__SHIFT                                                           0x5
#define SDMA0_STATUS4_REG__GCR_OUTSTANDING__SHIFT                                                             0x6
#define SDMA0_STATUS4_REG__TLBI_OUTSTANDING__SHIFT                                                            0x7
#define SDMA0_STATUS4_REG__UTCL2_RD_OUTSTANDING__SHIFT                                                        0x8
#define SDMA0_STATUS4_REG__UTCL2_WR_OUTSTANDING__SHIFT                                                        0x9
#define SDMA0_STATUS4_REG__REG_POLLING__SHIFT                                                                 0xa
#define SDMA0_STATUS4_REG__MEM_POLLING__SHIFT                                                                 0xb
#define SDMA0_STATUS4_REG__RESERVED_13_12__SHIFT                                                              0xc
#define SDMA0_STATUS4_REG__RESERVED_15_14__SHIFT                                                              0xe
#define SDMA0_STATUS4_REG__ACTIVE_QUEUE_ID__SHIFT                                                             0x10
#define SDMA0_STATUS4_REG__SRIOV_WATING_RLCV_CMD__SHIFT                                                       0x14
#define SDMA0_STATUS4_REG__SRIOV_SDMA_EXECUTING_CMD__SHIFT                                                    0x15
#define SDMA0_STATUS4_REG__UTCL2_RD_XNACK_FAULT__SHIFT                                                        0x16
#define SDMA0_STATUS4_REG__UTCL2_RD_XNACK_NULL__SHIFT                                                         0x17
#define SDMA0_STATUS4_REG__UTCL2_RD_XNACK_TIMEOUT__SHIFT                                                      0x18
#define SDMA0_STATUS4_REG__UTCL2_WR_XNACK_FAULT__SHIFT                                                        0x19
#define SDMA0_STATUS4_REG__UTCL2_WR_XNACK_NULL__SHIFT                                                         0x1a
#define SDMA0_STATUS4_REG__UTCL2_WR_XNACK_TIMEOUT__SHIFT                                                      0x1b
#define SDMA0_STATUS4_REG__IDLE_MASK                                                                          0x00000001L
#define SDMA0_STATUS4_REG__IH_OUTSTANDING_MASK                                                                0x00000004L
#define SDMA0_STATUS4_REG__RESERVED_MASK                                                                      0x00000008L
#define SDMA0_STATUS4_REG__CH_RD_OUTSTANDING_MASK                                                             0x00000010L
#define SDMA0_STATUS4_REG__CH_WR_OUTSTANDING_MASK                                                             0x00000020L
#define SDMA0_STATUS4_REG__GCR_OUTSTANDING_MASK                                                               0x00000040L
#define SDMA0_STATUS4_REG__TLBI_OUTSTANDING_MASK                                                              0x00000080L
#define SDMA0_STATUS4_REG__UTCL2_RD_OUTSTANDING_MASK                                                          0x00000100L
#define SDMA0_STATUS4_REG__UTCL2_WR_OUTSTANDING_MASK                                                          0x00000200L
#define SDMA0_STATUS4_REG__REG_POLLING_MASK                                                                   0x00000400L
#define SDMA0_STATUS4_REG__MEM_POLLING_MASK                                                                   0x00000800L
#define SDMA0_STATUS4_REG__RESERVED_13_12_MASK                                                                0x00003000L
#define SDMA0_STATUS4_REG__RESERVED_15_14_MASK                                                                0x0000C000L
#define SDMA0_STATUS4_REG__ACTIVE_QUEUE_ID_MASK                                                               0x000F0000L
#define SDMA0_STATUS4_REG__SRIOV_WATING_RLCV_CMD_MASK                                                         0x00100000L
#define SDMA0_STATUS4_REG__SRIOV_SDMA_EXECUTING_CMD_MASK                                                      0x00200000L
#define SDMA0_STATUS4_REG__UTCL2_RD_XNACK_FAULT_MASK                                                          0x00400000L
#define SDMA0_STATUS4_REG__UTCL2_RD_XNACK_NULL_MASK                                                           0x00800000L
#define SDMA0_STATUS4_REG__UTCL2_RD_XNACK_TIMEOUT_MASK                                                        0x01000000L
#define SDMA0_STATUS4_REG__UTCL2_WR_XNACK_FAULT_MASK                                                          0x02000000L
#define SDMA0_STATUS4_REG__UTCL2_WR_XNACK_NULL_MASK                                                           0x04000000L
#define SDMA0_STATUS4_REG__UTCL2_WR_XNACK_TIMEOUT_MASK                                                        0x08000000L
//SDMA0_SCRATCH_RAM_DATA
#define SDMA0_SCRATCH_RAM_DATA__DATA__SHIFT                                                                   0x0
#define SDMA0_SCRATCH_RAM_DATA__DATA_MASK                                                                     0xFFFFFFFFL
//SDMA0_SCRATCH_RAM_ADDR
#define SDMA0_SCRATCH_RAM_ADDR__ADDR__SHIFT                                                                   0x0
#define SDMA0_SCRATCH_RAM_ADDR__ADDR_MASK                                                                     0x0000007FL
//SDMA0_TIMESTAMP_CNTL
#define SDMA0_TIMESTAMP_CNTL__CAPTURE__SHIFT                                                                  0x0
#define SDMA0_TIMESTAMP_CNTL__CAPTURE_MASK                                                                    0x00000001L
//SDMA0_STATUS5_REG
#define SDMA0_STATUS5_REG__QUEUE0_RB_ENABLE_STATUS__SHIFT                                                     0x0
#define SDMA0_STATUS5_REG__QUEUE1_RB_ENABLE_STATUS__SHIFT                                                     0x1
#define SDMA0_STATUS5_REG__QUEUE2_RB_ENABLE_STATUS__SHIFT                                                     0x2
#define SDMA0_STATUS5_REG__QUEUE3_RB_ENABLE_STATUS__SHIFT                                                     0x3
#define SDMA0_STATUS5_REG__QUEUE4_RB_ENABLE_STATUS__SHIFT                                                     0x4
#define SDMA0_STATUS5_REG__QUEUE5_RB_ENABLE_STATUS__SHIFT                                                     0x5
#define SDMA0_STATUS5_REG__QUEUE6_RB_ENABLE_STATUS__SHIFT                                                     0x6
#define SDMA0_STATUS5_REG__QUEUE7_RB_ENABLE_STATUS__SHIFT                                                     0x7
#define SDMA0_STATUS5_REG__ACTIVE_QUEUE_ID__SHIFT                                                             0x10
#define SDMA0_STATUS5_REG__QUEUE0_WPTR_POLL_PAGE_EXCEPTION__SHIFT                                             0x14
#define SDMA0_STATUS5_REG__QUEUE1_WPTR_POLL_PAGE_EXCEPTION__SHIFT                                             0x15
#define SDMA0_STATUS5_REG__QUEUE2_WPTR_POLL_PAGE_EXCEPTION__SHIFT                                             0x16
#define SDMA0_STATUS5_REG__QUEUE3_WPTR_POLL_PAGE_EXCEPTION__SHIFT                                             0x17
#define SDMA0_STATUS5_REG__QUEUE4_WPTR_POLL_PAGE_EXCEPTION__SHIFT                                             0x18
#define SDMA0_STATUS5_REG__QUEUE5_WPTR_POLL_PAGE_EXCEPTION__SHIFT                                             0x19
#define SDMA0_STATUS5_REG__QUEUE6_WPTR_POLL_PAGE_EXCEPTION__SHIFT                                             0x1a
#define SDMA0_STATUS5_REG__QUEUE7_WPTR_POLL_PAGE_EXCEPTION__SHIFT                                             0x1b
#define SDMA0_STATUS5_REG__QUEUE0_RB_ENABLE_STATUS_MASK                                                       0x00000001L
#define SDMA0_STATUS5_REG__QUEUE1_RB_ENABLE_STATUS_MASK                                                       0x00000002L
#define SDMA0_STATUS5_REG__QUEUE2_RB_ENABLE_STATUS_MASK                                                       0x00000004L
#define SDMA0_STATUS5_REG__QUEUE3_RB_ENABLE_STATUS_MASK                                                       0x00000008L
#define SDMA0_STATUS5_REG__QUEUE4_RB_ENABLE_STATUS_MASK                                                       0x00000010L
#define SDMA0_STATUS5_REG__QUEUE5_RB_ENABLE_STATUS_MASK                                                       0x00000020L
#define SDMA0_STATUS5_REG__QUEUE6_RB_ENABLE_STATUS_MASK                                                       0x00000040L
#define SDMA0_STATUS5_REG__QUEUE7_RB_ENABLE_STATUS_MASK                                                       0x00000080L
#define SDMA0_STATUS5_REG__ACTIVE_QUEUE_ID_MASK                                                               0x000F0000L
#define SDMA0_STATUS5_REG__QUEUE0_WPTR_POLL_PAGE_EXCEPTION_MASK                                               0x00100000L
#define SDMA0_STATUS5_REG__QUEUE1_WPTR_POLL_PAGE_EXCEPTION_MASK                                               0x00200000L
#define SDMA0_STATUS5_REG__QUEUE2_WPTR_POLL_PAGE_EXCEPTION_MASK                                               0x00400000L
#define SDMA0_STATUS5_REG__QUEUE3_WPTR_POLL_PAGE_EXCEPTION_MASK                                               0x00800000L
#define SDMA0_STATUS5_REG__QUEUE4_WPTR_POLL_PAGE_EXCEPTION_MASK                                               0x01000000L
#define SDMA0_STATUS5_REG__QUEUE5_WPTR_POLL_PAGE_EXCEPTION_MASK                                               0x02000000L
#define SDMA0_STATUS5_REG__QUEUE6_WPTR_POLL_PAGE_EXCEPTION_MASK                                               0x04000000L
#define SDMA0_STATUS5_REG__QUEUE7_WPTR_POLL_PAGE_EXCEPTION_MASK                                               0x08000000L
//SDMA0_QUEUE_RESET_REQ
#define SDMA0_QUEUE_RESET_REQ__QUEUE0_RESET__SHIFT                                                            0x0
#define SDMA0_QUEUE_RESET_REQ__QUEUE1_RESET__SHIFT                                                            0x1
#define SDMA0_QUEUE_RESET_REQ__QUEUE2_RESET__SHIFT                                                            0x2
#define SDMA0_QUEUE_RESET_REQ__QUEUE3_RESET__SHIFT                                                            0x3
#define SDMA0_QUEUE_RESET_REQ__QUEUE4_RESET__SHIFT                                                            0x4
#define SDMA0_QUEUE_RESET_REQ__QUEUE5_RESET__SHIFT                                                            0x5
#define SDMA0_QUEUE_RESET_REQ__QUEUE6_RESET__SHIFT                                                            0x6
#define SDMA0_QUEUE_RESET_REQ__QUEUE7_RESET__SHIFT                                                            0x7
#define SDMA0_QUEUE_RESET_REQ__RESERVED__SHIFT                                                                0x8
#define SDMA0_QUEUE_RESET_REQ__QUEUE0_RESET_MASK                                                              0x00000001L
#define SDMA0_QUEUE_RESET_REQ__QUEUE1_RESET_MASK                                                              0x00000002L
#define SDMA0_QUEUE_RESET_REQ__QUEUE2_RESET_MASK                                                              0x00000004L
#define SDMA0_QUEUE_RESET_REQ__QUEUE3_RESET_MASK                                                              0x00000008L
#define SDMA0_QUEUE_RESET_REQ__QUEUE4_RESET_MASK                                                              0x00000010L
#define SDMA0_QUEUE_RESET_REQ__QUEUE5_RESET_MASK                                                              0x00000020L
#define SDMA0_QUEUE_RESET_REQ__QUEUE6_RESET_MASK                                                              0x00000040L
#define SDMA0_QUEUE_RESET_REQ__QUEUE7_RESET_MASK                                                              0x00000080L
#define SDMA0_QUEUE_RESET_REQ__RESERVED_MASK                                                                  0xFFFFFF00L
//SDMA0_STATUS6_REG
#define SDMA0_STATUS6_REG__ID__SHIFT                                                                          0x0
#define SDMA0_STATUS6_REG__TH1MCU_INSTR_PTR__SHIFT                                                            0x2
#define SDMA0_STATUS6_REG__TH1_EXCEPTION__SHIFT                                                               0x10
#define SDMA0_STATUS6_REG__ID_MASK                                                                            0x00000003L
#define SDMA0_STATUS6_REG__TH1MCU_INSTR_PTR_MASK                                                              0x0000FFFCL
#define SDMA0_STATUS6_REG__TH1_EXCEPTION_MASK                                                                 0xFFFF0000L
//SDMA0_STATUS7_REG
#define SDMA0_STATUS7_REG__BLT_REQ_DROP__SHIFT                                                                0x0
#define SDMA0_STATUS7_REG__BLT_REQ_DROP_MASK                                                                  0x00000001L
//SDMA0_STATUS8_REG
#define SDMA0_STATUS8_REG__LD_CTXSW_COND__SHIFT                                                               0x0
#define SDMA0_STATUS8_REG__LD_CTXSW_COND_MASK                                                                 0xFFFFFFFFL
//SDMA0_CE_CTRL
#define SDMA0_CE_CTRL__RD_LUT_WATERMARK__SHIFT                                                                0x0
#define SDMA0_CE_CTRL__RD_LUT_DEPTH__SHIFT                                                                    0x3
#define SDMA0_CE_CTRL__WR_AFIFO_WATERMARK__SHIFT                                                              0x5
#define SDMA0_CE_CTRL__RESERVED__SHIFT                                                                        0x9
#define SDMA0_CE_CTRL__RD_LUT_WATERMARK_MASK                                                                  0x00000007L
#define SDMA0_CE_CTRL__RD_LUT_DEPTH_MASK                                                                      0x00000018L
#define SDMA0_CE_CTRL__WR_AFIFO_WATERMARK_MASK                                                                0x000000E0L
#define SDMA0_CE_CTRL__RESERVED_MASK                                                                          0xFFFFFE00L
//SDMA0_FED_STATUS
#define SDMA0_FED_STATUS__RB_FETCH_ECC__SHIFT                                                                 0x0
#define SDMA0_FED_STATUS__IB_FETCH_ECC__SHIFT                                                                 0x1
#define SDMA0_FED_STATUS__MCU_DATA_ECC__SHIFT                                                                 0x2
#define SDMA0_FED_STATUS__WPTR_POLL_ECC__SHIFT                                                                0x3
#define SDMA0_FED_STATUS__COPY_DATA_ECC__SHIFT                                                                0x4
#define SDMA0_FED_STATUS__INSTR_FETCH_ECC__SHIFT                                                              0x5
#define SDMA0_FED_STATUS__ATOMIC_ECC__SHIFT                                                                   0x6
#define SDMA0_FED_STATUS__RB_FETCH_ECC_MASK                                                                   0x00000001L
#define SDMA0_FED_STATUS__IB_FETCH_ECC_MASK                                                                   0x00000002L
#define SDMA0_FED_STATUS__MCU_DATA_ECC_MASK                                                                   0x00000004L
#define SDMA0_FED_STATUS__WPTR_POLL_ECC_MASK                                                                  0x00000008L
#define SDMA0_FED_STATUS__COPY_DATA_ECC_MASK                                                                  0x00000010L
#define SDMA0_FED_STATUS__INSTR_FETCH_ECC_MASK                                                                0x00000020L
#define SDMA0_FED_STATUS__ATOMIC_ECC_MASK                                                                     0x00000040L
//SDMA0_QUEUE0_RB_CNTL
#define SDMA0_QUEUE0_RB_CNTL__RB_ENABLE__SHIFT                                                                0x0
#define SDMA0_QUEUE0_RB_CNTL__RB_SIZE__SHIFT                                                                  0x1
#define SDMA0_QUEUE0_RB_CNTL__WPTR_POLL_ENABLE__SHIFT                                                         0x8
#define SDMA0_QUEUE0_RB_CNTL__RB_SWAP_ENABLE__SHIFT                                                           0x9
#define SDMA0_QUEUE0_RB_CNTL__WPTR_POLL_SWAP_ENABLE__SHIFT                                                    0xa
#define SDMA0_QUEUE0_RB_CNTL__MCU_WPTR_POLL_ENABLE__SHIFT                                                     0xb
#define SDMA0_QUEUE0_RB_CNTL__RPTR_WRITEBACK_ENABLE__SHIFT                                                    0xc
#define SDMA0_QUEUE0_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE__SHIFT                                               0xd
#define SDMA0_QUEUE0_RB_CNTL__RPTR_WRITEBACK_TIMER__SHIFT                                                     0x10
#define SDMA0_QUEUE0_RB_CNTL__RB_PRIV__SHIFT                                                                  0x17
#define SDMA0_QUEUE0_RB_CNTL__RB_VMID__SHIFT                                                                  0x18
#define SDMA0_QUEUE0_RB_CNTL__RB_ENABLE_MASK                                                                  0x00000001L
#define SDMA0_QUEUE0_RB_CNTL__RB_SIZE_MASK                                                                    0x0000003EL
#define SDMA0_QUEUE0_RB_CNTL__WPTR_POLL_ENABLE_MASK                                                           0x00000100L
#define SDMA0_QUEUE0_RB_CNTL__RB_SWAP_ENABLE_MASK                                                             0x00000200L
#define SDMA0_QUEUE0_RB_CNTL__WPTR_POLL_SWAP_ENABLE_MASK                                                      0x00000400L
#define SDMA0_QUEUE0_RB_CNTL__MCU_WPTR_POLL_ENABLE_MASK                                                       0x00000800L
#define SDMA0_QUEUE0_RB_CNTL__RPTR_WRITEBACK_ENABLE_MASK                                                      0x00001000L
#define SDMA0_QUEUE0_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE_MASK                                                 0x00002000L
#define SDMA0_QUEUE0_RB_CNTL__RPTR_WRITEBACK_TIMER_MASK                                                       0x001F0000L
#define SDMA0_QUEUE0_RB_CNTL__RB_PRIV_MASK                                                                    0x00800000L
#define SDMA0_QUEUE0_RB_CNTL__RB_VMID_MASK                                                                    0x0F000000L
//SDMA0_QUEUE0_RB_BASE
#define SDMA0_QUEUE0_RB_BASE__ADDR__SHIFT                                                                     0x0
#define SDMA0_QUEUE0_RB_BASE__ADDR_MASK                                                                       0xFFFFFFFFL
//SDMA0_QUEUE0_RB_BASE_HI
#define SDMA0_QUEUE0_RB_BASE_HI__ADDR__SHIFT                                                                  0x0
#define SDMA0_QUEUE0_RB_BASE_HI__ADDR_MASK                                                                    0x00FFFFFFL
//SDMA0_QUEUE0_RB_RPTR
#define SDMA0_QUEUE0_RB_RPTR__OFFSET__SHIFT                                                                   0x0
#define SDMA0_QUEUE0_RB_RPTR__OFFSET_MASK                                                                     0xFFFFFFFFL
//SDMA0_QUEUE0_RB_RPTR_HI
#define SDMA0_QUEUE0_RB_RPTR_HI__OFFSET__SHIFT                                                                0x0
#define SDMA0_QUEUE0_RB_RPTR_HI__OFFSET_MASK                                                                  0xFFFFFFFFL
//SDMA0_QUEUE0_RB_WPTR
#define SDMA0_QUEUE0_RB_WPTR__OFFSET__SHIFT                                                                   0x0
#define SDMA0_QUEUE0_RB_WPTR__OFFSET_MASK                                                                     0xFFFFFFFFL
//SDMA0_QUEUE0_RB_WPTR_HI
#define SDMA0_QUEUE0_RB_WPTR_HI__OFFSET__SHIFT                                                                0x0
#define SDMA0_QUEUE0_RB_WPTR_HI__OFFSET_MASK                                                                  0xFFFFFFFFL
//SDMA0_QUEUE0_RB_RPTR_ADDR_LO
#define SDMA0_QUEUE0_RB_RPTR_ADDR_LO__ADDR__SHIFT                                                             0x2
#define SDMA0_QUEUE0_RB_RPTR_ADDR_LO__ADDR_MASK                                                               0xFFFFFFFCL
//SDMA0_QUEUE0_RB_RPTR_ADDR_HI
#define SDMA0_QUEUE0_RB_RPTR_ADDR_HI__ADDR__SHIFT                                                             0x0
#define SDMA0_QUEUE0_RB_RPTR_ADDR_HI__ADDR_MASK                                                               0xFFFFFFFFL
//SDMA0_QUEUE0_IB_CNTL
#define SDMA0_QUEUE0_IB_CNTL__IB_ENABLE__SHIFT                                                                0x0
#define SDMA0_QUEUE0_IB_CNTL__IB_SWAP_ENABLE__SHIFT                                                           0x4
#define SDMA0_QUEUE0_IB_CNTL__SWITCH_INSIDE_IB__SHIFT                                                         0x8
#define SDMA0_QUEUE0_IB_CNTL__CMD_VMID__SHIFT                                                                 0x10
#define SDMA0_QUEUE0_IB_CNTL__IB_ENABLE_MASK                                                                  0x00000001L
#define SDMA0_QUEUE0_IB_CNTL__IB_SWAP_ENABLE_MASK                                                             0x00000010L
#define SDMA0_QUEUE0_IB_CNTL__SWITCH_INSIDE_IB_MASK                                                           0x00000100L
#define SDMA0_QUEUE0_IB_CNTL__CMD_VMID_MASK                                                                   0x000F0000L
//SDMA0_QUEUE0_IB_RPTR
#define SDMA0_QUEUE0_IB_RPTR__OFFSET__SHIFT                                                                   0x2
#define SDMA0_QUEUE0_IB_RPTR__OFFSET_MASK                                                                     0x003FFFFCL
//SDMA0_QUEUE0_IB_OFFSET
#define SDMA0_QUEUE0_IB_OFFSET__OFFSET__SHIFT                                                                 0x2
#define SDMA0_QUEUE0_IB_OFFSET__OFFSET_MASK                                                                   0x003FFFFCL
//SDMA0_QUEUE0_IB_BASE_LO
#define SDMA0_QUEUE0_IB_BASE_LO__ADDR__SHIFT                                                                  0x2
#define SDMA0_QUEUE0_IB_BASE_LO__ADDR_MASK                                                                    0xFFFFFFFCL
//SDMA0_QUEUE0_IB_BASE_HI
#define SDMA0_QUEUE0_IB_BASE_HI__ADDR__SHIFT                                                                  0x0
#define SDMA0_QUEUE0_IB_BASE_HI__ADDR_MASK                                                                    0xFFFFFFFFL
//SDMA0_QUEUE0_IB_SIZE
#define SDMA0_QUEUE0_IB_SIZE__SIZE__SHIFT                                                                     0x0
#define SDMA0_QUEUE0_IB_SIZE__SIZE_MASK                                                                       0x000FFFFFL
//SDMA0_QUEUE0_DOORBELL
#define SDMA0_QUEUE0_DOORBELL__ENABLE__SHIFT                                                                  0x1c
#define SDMA0_QUEUE0_DOORBELL__CAPTURED__SHIFT                                                                0x1e
#define SDMA0_QUEUE0_DOORBELL__ENABLE_MASK                                                                    0x10000000L
#define SDMA0_QUEUE0_DOORBELL__CAPTURED_MASK                                                                  0x40000000L
//SDMA0_QUEUE0_DOORBELL_LOG
#define SDMA0_QUEUE0_DOORBELL_LOG__BE_ERROR__SHIFT                                                            0x0
#define SDMA0_QUEUE0_DOORBELL_LOG__DATA__SHIFT                                                                0x2
#define SDMA0_QUEUE0_DOORBELL_LOG__BE_ERROR_MASK                                                              0x00000001L
#define SDMA0_QUEUE0_DOORBELL_LOG__DATA_MASK                                                                  0xFFFFFFFCL
//SDMA0_QUEUE0_DOORBELL_OFFSET
#define SDMA0_QUEUE0_DOORBELL_OFFSET__OFFSET__SHIFT                                                           0x2
#define SDMA0_QUEUE0_DOORBELL_OFFSET__OFFSET_MASK                                                             0x0FFFFFFCL
//SDMA0_QUEUE0_CSA_ADDR_LO
#define SDMA0_QUEUE0_CSA_ADDR_LO__ADDR__SHIFT                                                                 0x2
#define SDMA0_QUEUE0_CSA_ADDR_LO__ADDR_MASK                                                                   0xFFFFFFFCL
//SDMA0_QUEUE0_CSA_ADDR_HI
#define SDMA0_QUEUE0_CSA_ADDR_HI__ADDR__SHIFT                                                                 0x0
#define SDMA0_QUEUE0_CSA_ADDR_HI__ADDR_MASK                                                                   0xFFFFFFFFL
//SDMA0_QUEUE0_SCHEDULE_CNTL
#define SDMA0_QUEUE0_SCHEDULE_CNTL__GLOBAL_ID__SHIFT                                                          0x0
#define SDMA0_QUEUE0_SCHEDULE_CNTL__PROCESS_ID__SHIFT                                                         0x2
#define SDMA0_QUEUE0_SCHEDULE_CNTL__LOCAL_ID__SHIFT                                                           0x6
#define SDMA0_QUEUE0_SCHEDULE_CNTL__CONTEXT_QUANTUM__SHIFT                                                    0x8
#define SDMA0_QUEUE0_SCHEDULE_CNTL__GLOBAL_ID_MASK                                                            0x00000003L
#define SDMA0_QUEUE0_SCHEDULE_CNTL__PROCESS_ID_MASK                                                           0x0000001CL
#define SDMA0_QUEUE0_SCHEDULE_CNTL__LOCAL_ID_MASK                                                             0x000000C0L
#define SDMA0_QUEUE0_SCHEDULE_CNTL__CONTEXT_QUANTUM_MASK                                                      0x0000FF00L
//SDMA0_QUEUE0_IB_SUB_REMAIN
#define SDMA0_QUEUE0_IB_SUB_REMAIN__SIZE__SHIFT                                                               0x0
#define SDMA0_QUEUE0_IB_SUB_REMAIN__SIZE_MASK                                                                 0x00003FFFL
//SDMA0_QUEUE0_PREEMPT
#define SDMA0_QUEUE0_PREEMPT__IB_PREEMPT__SHIFT                                                               0x0
#define SDMA0_QUEUE0_PREEMPT__IB_PREEMPT_MASK                                                                 0x00000001L
//SDMA0_QUEUE0_DUMMY_REG
#define SDMA0_QUEUE0_DUMMY_REG__DUMMY__SHIFT                                                                  0x0
#define SDMA0_QUEUE0_DUMMY_REG__DUMMY_MASK                                                                    0xFFFFFFFFL
//SDMA0_QUEUE0_RB_WPTR_POLL_ADDR_LO
#define SDMA0_QUEUE0_RB_WPTR_POLL_ADDR_LO__ADDR__SHIFT                                                        0x2
#define SDMA0_QUEUE0_RB_WPTR_POLL_ADDR_LO__ADDR_MASK                                                          0xFFFFFFFCL
//SDMA0_QUEUE0_RB_WPTR_POLL_ADDR_HI
#define SDMA0_QUEUE0_RB_WPTR_POLL_ADDR_HI__ADDR__SHIFT                                                        0x0
#define SDMA0_QUEUE0_RB_WPTR_POLL_ADDR_HI__ADDR_MASK                                                          0xFFFFFFFFL
//SDMA0_QUEUE0_RB_AQL_CNTL
#define SDMA0_QUEUE0_RB_AQL_CNTL__AQL_ENABLE__SHIFT                                                           0x0
#define SDMA0_QUEUE0_RB_AQL_CNTL__AQL_PACKET_SIZE__SHIFT                                                      0x1
#define SDMA0_QUEUE0_RB_AQL_CNTL__PACKET_STEP__SHIFT                                                          0x8
#define SDMA0_QUEUE0_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE__SHIFT                                                0x10
#define SDMA0_QUEUE0_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE__SHIFT                                          0x11
#define SDMA0_QUEUE0_RB_AQL_CNTL__OVERLAP_ENABLE__SHIFT                                                       0x12
#define SDMA0_QUEUE0_RB_AQL_CNTL__AQL_ENABLE_MASK                                                             0x00000001L
#define SDMA0_QUEUE0_RB_AQL_CNTL__AQL_PACKET_SIZE_MASK                                                        0x000000FEL
#define SDMA0_QUEUE0_RB_AQL_CNTL__PACKET_STEP_MASK                                                            0x0000FF00L
#define SDMA0_QUEUE0_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE_MASK                                                  0x00010000L
#define SDMA0_QUEUE0_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE_MASK                                            0x00020000L
#define SDMA0_QUEUE0_RB_AQL_CNTL__OVERLAP_ENABLE_MASK                                                         0x00040000L
//SDMA0_QUEUE0_MINOR_PTR_UPDATE
#define SDMA0_QUEUE0_MINOR_PTR_UPDATE__ENABLE__SHIFT                                                          0x0
#define SDMA0_QUEUE0_MINOR_PTR_UPDATE__ENABLE_MASK                                                            0x00000001L
//SDMA0_QUEUE0_CONTEXT_SWITCH_STATUS
#define SDMA0_QUEUE0_CONTEXT_SWITCH_STATUS__RB_PREEMPT_STATUS__SHIFT                                          0x0
#define SDMA0_QUEUE0_CONTEXT_SWITCH_STATUS__VM_HOLE_EXCEPTION__SHIFT                                          0x1
#define SDMA0_QUEUE0_CONTEXT_SWITCH_STATUS__PAGE_EXCEPTION__SHIFT                                             0x2
#define SDMA0_QUEUE0_CONTEXT_SWITCH_STATUS__QUEUE_HANG_EXCEPTION__SHIFT                                       0x5
#define SDMA0_QUEUE0_CONTEXT_SWITCH_STATUS__DOORBELL_ERROR_EXCEPTION__SHIFT                                   0x6
#define SDMA0_QUEUE0_CONTEXT_SWITCH_STATUS__SRAM_ECC_EXCEPTION__SHIFT                                         0x7
#define SDMA0_QUEUE0_CONTEXT_SWITCH_STATUS__DRAM_ECC_EXCEPTION__SHIFT                                         0x8
#define SDMA0_QUEUE0_CONTEXT_SWITCH_STATUS__WPTR_LT_RPTR_EXCEPTION__SHIFT                                     0x9
#define SDMA0_QUEUE0_CONTEXT_SWITCH_STATUS__RB_PREEMPT_STATUS_MASK                                            0x00000001L
#define SDMA0_QUEUE0_CONTEXT_SWITCH_STATUS__VM_HOLE_EXCEPTION_MASK                                            0x00000002L
#define SDMA0_QUEUE0_CONTEXT_SWITCH_STATUS__PAGE_EXCEPTION_MASK                                               0x00000004L
#define SDMA0_QUEUE0_CONTEXT_SWITCH_STATUS__QUEUE_HANG_EXCEPTION_MASK                                         0x00000020L
#define SDMA0_QUEUE0_CONTEXT_SWITCH_STATUS__DOORBELL_ERROR_EXCEPTION_MASK                                     0x00000040L
#define SDMA0_QUEUE0_CONTEXT_SWITCH_STATUS__SRAM_ECC_EXCEPTION_MASK                                           0x00000080L
#define SDMA0_QUEUE0_CONTEXT_SWITCH_STATUS__DRAM_ECC_EXCEPTION_MASK                                           0x00000100L
#define SDMA0_QUEUE0_CONTEXT_SWITCH_STATUS__WPTR_LT_RPTR_EXCEPTION_MASK                                       0x00000200L
//SDMA0_QUEUE0_MIDCMD_CNTL
#define SDMA0_QUEUE0_MIDCMD_CNTL__DATA_VALID__SHIFT                                                           0x0
#define SDMA0_QUEUE0_MIDCMD_CNTL__COPY_MODE__SHIFT                                                            0x1
#define SDMA0_QUEUE0_MIDCMD_CNTL__SPLIT_STATE__SHIFT                                                          0x4
#define SDMA0_QUEUE0_MIDCMD_CNTL__ALLOW_PREEMPT__SHIFT                                                        0x8
#define SDMA0_QUEUE0_MIDCMD_CNTL__DATA_VALID_MASK                                                             0x00000001L
#define SDMA0_QUEUE0_MIDCMD_CNTL__COPY_MODE_MASK                                                              0x00000002L
#define SDMA0_QUEUE0_MIDCMD_CNTL__SPLIT_STATE_MASK                                                            0x000000F0L
#define SDMA0_QUEUE0_MIDCMD_CNTL__ALLOW_PREEMPT_MASK                                                          0x00000100L
//SDMA0_QUEUE0_MIDCMD_DATA0
#define SDMA0_QUEUE0_MIDCMD_DATA0__DATA0__SHIFT                                                               0x0
#define SDMA0_QUEUE0_MIDCMD_DATA0__DATA0_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE0_MIDCMD_DATA1
#define SDMA0_QUEUE0_MIDCMD_DATA1__DATA1__SHIFT                                                               0x0
#define SDMA0_QUEUE0_MIDCMD_DATA1__DATA1_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE0_MIDCMD_DATA2
#define SDMA0_QUEUE0_MIDCMD_DATA2__DATA2__SHIFT                                                               0x0
#define SDMA0_QUEUE0_MIDCMD_DATA2__DATA2_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE0_MIDCMD_DATA3
#define SDMA0_QUEUE0_MIDCMD_DATA3__DATA3__SHIFT                                                               0x0
#define SDMA0_QUEUE0_MIDCMD_DATA3__DATA3_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE0_MIDCMD_DATA4
#define SDMA0_QUEUE0_MIDCMD_DATA4__DATA4__SHIFT                                                               0x0
#define SDMA0_QUEUE0_MIDCMD_DATA4__DATA4_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE0_MIDCMD_DATA5
#define SDMA0_QUEUE0_MIDCMD_DATA5__DATA5__SHIFT                                                               0x0
#define SDMA0_QUEUE0_MIDCMD_DATA5__DATA5_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE0_MIDCMD_DATA6
#define SDMA0_QUEUE0_MIDCMD_DATA6__DATA6__SHIFT                                                               0x0
#define SDMA0_QUEUE0_MIDCMD_DATA6__DATA6_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE0_MIDCMD_DATA7
#define SDMA0_QUEUE0_MIDCMD_DATA7__DATA7__SHIFT                                                               0x0
#define SDMA0_QUEUE0_MIDCMD_DATA7__DATA7_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE0_MIDCMD_DATA8
#define SDMA0_QUEUE0_MIDCMD_DATA8__DATA8__SHIFT                                                               0x0
#define SDMA0_QUEUE0_MIDCMD_DATA8__DATA8_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE0_MIDCMD_DATA9
#define SDMA0_QUEUE0_MIDCMD_DATA9__DATA9__SHIFT                                                               0x0
#define SDMA0_QUEUE0_MIDCMD_DATA9__DATA9_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE0_MIDCMD_DATA10
#define SDMA0_QUEUE0_MIDCMD_DATA10__DATA10__SHIFT                                                             0x0
#define SDMA0_QUEUE0_MIDCMD_DATA10__DATA10_MASK                                                               0xFFFFFFFFL
//SDMA0_QUEUE0_WAIT_UNSATISFIED_THD
#define SDMA0_QUEUE0_WAIT_UNSATISFIED_THD__THRESHOLD__SHIFT                                                   0x0
#define SDMA0_QUEUE0_WAIT_UNSATISFIED_THD__THRESHOLD_MASK                                                     0x0000001FL
//SDMA0_QUEUE0_MQD_BASE_ADDR_LO
#define SDMA0_QUEUE0_MQD_BASE_ADDR_LO__BASE_ADDR_LO__SHIFT                                                    0x2
#define SDMA0_QUEUE0_MQD_BASE_ADDR_LO__BASE_ADDR_LO_MASK                                                      0xFFFFFFFCL
//SDMA0_QUEUE0_MQD_BASE_ADDR_HI
#define SDMA0_QUEUE0_MQD_BASE_ADDR_HI__BASE_ADDR_HI__SHIFT                                                    0x0
#define SDMA0_QUEUE0_MQD_BASE_ADDR_HI__BASE_ADDR_HI_MASK                                                      0xFFFFFFFFL
//SDMA0_QUEUE0_MQD_CONTROL
#define SDMA0_QUEUE0_MQD_CONTROL__VMID__SHIFT                                                                 0x0
#define SDMA0_QUEUE0_MQD_CONTROL__VMID_MASK                                                                   0x0000000FL
//SDMA0_QUEUE0_DEQUEUE_REQUEST
#define SDMA0_QUEUE0_DEQUEUE_REQUEST__DEQUEUE_REQ__SHIFT                                                      0x0
#define SDMA0_QUEUE0_DEQUEUE_REQUEST__DEQUEUE_REQ_MASK                                                        0x00000001L
//SDMA0_QUEUE0_CONTEXT_STATUS
#define SDMA0_QUEUE0_CONTEXT_STATUS__SELECTED__SHIFT                                                          0x0
#define SDMA0_QUEUE0_CONTEXT_STATUS__USE_IB__SHIFT                                                            0x1
#define SDMA0_QUEUE0_CONTEXT_STATUS__IDLE__SHIFT                                                              0x2
#define SDMA0_QUEUE0_CONTEXT_STATUS__EXPIRED__SHIFT                                                           0x3
#define SDMA0_QUEUE0_CONTEXT_STATUS__EXCEPTION__SHIFT                                                         0x4
#define SDMA0_QUEUE0_CONTEXT_STATUS__CTXSW_ABLE__SHIFT                                                        0x7
#define SDMA0_QUEUE0_CONTEXT_STATUS__VF_STATUS__SHIFT                                                         0x8
#define SDMA0_QUEUE0_CONTEXT_STATUS__PRIV_EXCEPTION__SHIFT                                                    0x9
#define SDMA0_QUEUE0_CONTEXT_STATUS__PREEMPT_DISABLE__SHIFT                                                   0xa
#define SDMA0_QUEUE0_CONTEXT_STATUS__RPTR_WB_IDLE__SHIFT                                                      0xb
#define SDMA0_QUEUE0_CONTEXT_STATUS__WPTR_UPDATE_PENDING__SHIFT                                               0xc
#define SDMA0_QUEUE0_CONTEXT_STATUS__WPTR_UPDATE_FAIL_COUNT__SHIFT                                            0x10
#define SDMA0_QUEUE0_CONTEXT_STATUS__SELECTED_MASK                                                            0x00000001L
#define SDMA0_QUEUE0_CONTEXT_STATUS__USE_IB_MASK                                                              0x00000002L
#define SDMA0_QUEUE0_CONTEXT_STATUS__IDLE_MASK                                                                0x00000004L
#define SDMA0_QUEUE0_CONTEXT_STATUS__EXPIRED_MASK                                                             0x00000008L
#define SDMA0_QUEUE0_CONTEXT_STATUS__EXCEPTION_MASK                                                           0x00000070L
#define SDMA0_QUEUE0_CONTEXT_STATUS__CTXSW_ABLE_MASK                                                          0x00000080L
#define SDMA0_QUEUE0_CONTEXT_STATUS__VF_STATUS_MASK                                                           0x00000100L
#define SDMA0_QUEUE0_CONTEXT_STATUS__PRIV_EXCEPTION_MASK                                                      0x00000200L
#define SDMA0_QUEUE0_CONTEXT_STATUS__PREEMPT_DISABLE_MASK                                                     0x00000400L
#define SDMA0_QUEUE0_CONTEXT_STATUS__RPTR_WB_IDLE_MASK                                                        0x00000800L
#define SDMA0_QUEUE0_CONTEXT_STATUS__WPTR_UPDATE_PENDING_MASK                                                 0x00001000L
#define SDMA0_QUEUE0_CONTEXT_STATUS__WPTR_UPDATE_FAIL_COUNT_MASK                                              0x00FF0000L
//SDMA0_QUEUE1_RB_CNTL
#define SDMA0_QUEUE1_RB_CNTL__RB_ENABLE__SHIFT                                                                0x0
#define SDMA0_QUEUE1_RB_CNTL__RB_SIZE__SHIFT                                                                  0x1
#define SDMA0_QUEUE1_RB_CNTL__WPTR_POLL_ENABLE__SHIFT                                                         0x8
#define SDMA0_QUEUE1_RB_CNTL__RB_SWAP_ENABLE__SHIFT                                                           0x9
#define SDMA0_QUEUE1_RB_CNTL__WPTR_POLL_SWAP_ENABLE__SHIFT                                                    0xa
#define SDMA0_QUEUE1_RB_CNTL__MCU_WPTR_POLL_ENABLE__SHIFT                                                     0xb
#define SDMA0_QUEUE1_RB_CNTL__RPTR_WRITEBACK_ENABLE__SHIFT                                                    0xc
#define SDMA0_QUEUE1_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE__SHIFT                                               0xd
#define SDMA0_QUEUE1_RB_CNTL__RPTR_WRITEBACK_TIMER__SHIFT                                                     0x10
#define SDMA0_QUEUE1_RB_CNTL__RB_PRIV__SHIFT                                                                  0x17
#define SDMA0_QUEUE1_RB_CNTL__RB_VMID__SHIFT                                                                  0x18
#define SDMA0_QUEUE1_RB_CNTL__RB_ENABLE_MASK                                                                  0x00000001L
#define SDMA0_QUEUE1_RB_CNTL__RB_SIZE_MASK                                                                    0x0000003EL
#define SDMA0_QUEUE1_RB_CNTL__WPTR_POLL_ENABLE_MASK                                                           0x00000100L
#define SDMA0_QUEUE1_RB_CNTL__RB_SWAP_ENABLE_MASK                                                             0x00000200L
#define SDMA0_QUEUE1_RB_CNTL__WPTR_POLL_SWAP_ENABLE_MASK                                                      0x00000400L
#define SDMA0_QUEUE1_RB_CNTL__MCU_WPTR_POLL_ENABLE_MASK                                                       0x00000800L
#define SDMA0_QUEUE1_RB_CNTL__RPTR_WRITEBACK_ENABLE_MASK                                                      0x00001000L
#define SDMA0_QUEUE1_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE_MASK                                                 0x00002000L
#define SDMA0_QUEUE1_RB_CNTL__RPTR_WRITEBACK_TIMER_MASK                                                       0x001F0000L
#define SDMA0_QUEUE1_RB_CNTL__RB_PRIV_MASK                                                                    0x00800000L
#define SDMA0_QUEUE1_RB_CNTL__RB_VMID_MASK                                                                    0x0F000000L
//SDMA0_QUEUE1_RB_BASE
#define SDMA0_QUEUE1_RB_BASE__ADDR__SHIFT                                                                     0x0
#define SDMA0_QUEUE1_RB_BASE__ADDR_MASK                                                                       0xFFFFFFFFL
//SDMA0_QUEUE1_RB_BASE_HI
#define SDMA0_QUEUE1_RB_BASE_HI__ADDR__SHIFT                                                                  0x0
#define SDMA0_QUEUE1_RB_BASE_HI__ADDR_MASK                                                                    0x00FFFFFFL
//SDMA0_QUEUE1_RB_RPTR
#define SDMA0_QUEUE1_RB_RPTR__OFFSET__SHIFT                                                                   0x0
#define SDMA0_QUEUE1_RB_RPTR__OFFSET_MASK                                                                     0xFFFFFFFFL
//SDMA0_QUEUE1_RB_RPTR_HI
#define SDMA0_QUEUE1_RB_RPTR_HI__OFFSET__SHIFT                                                                0x0
#define SDMA0_QUEUE1_RB_RPTR_HI__OFFSET_MASK                                                                  0xFFFFFFFFL
//SDMA0_QUEUE1_RB_WPTR
#define SDMA0_QUEUE1_RB_WPTR__OFFSET__SHIFT                                                                   0x0
#define SDMA0_QUEUE1_RB_WPTR__OFFSET_MASK                                                                     0xFFFFFFFFL
//SDMA0_QUEUE1_RB_WPTR_HI
#define SDMA0_QUEUE1_RB_WPTR_HI__OFFSET__SHIFT                                                                0x0
#define SDMA0_QUEUE1_RB_WPTR_HI__OFFSET_MASK                                                                  0xFFFFFFFFL
//SDMA0_QUEUE1_RB_RPTR_ADDR_LO
#define SDMA0_QUEUE1_RB_RPTR_ADDR_LO__ADDR__SHIFT                                                             0x2
#define SDMA0_QUEUE1_RB_RPTR_ADDR_LO__ADDR_MASK                                                               0xFFFFFFFCL
//SDMA0_QUEUE1_RB_RPTR_ADDR_HI
#define SDMA0_QUEUE1_RB_RPTR_ADDR_HI__ADDR__SHIFT                                                             0x0
#define SDMA0_QUEUE1_RB_RPTR_ADDR_HI__ADDR_MASK                                                               0xFFFFFFFFL
//SDMA0_QUEUE1_IB_CNTL
#define SDMA0_QUEUE1_IB_CNTL__IB_ENABLE__SHIFT                                                                0x0
#define SDMA0_QUEUE1_IB_CNTL__IB_SWAP_ENABLE__SHIFT                                                           0x4
#define SDMA0_QUEUE1_IB_CNTL__SWITCH_INSIDE_IB__SHIFT                                                         0x8
#define SDMA0_QUEUE1_IB_CNTL__CMD_VMID__SHIFT                                                                 0x10
#define SDMA0_QUEUE1_IB_CNTL__IB_ENABLE_MASK                                                                  0x00000001L
#define SDMA0_QUEUE1_IB_CNTL__IB_SWAP_ENABLE_MASK                                                             0x00000010L
#define SDMA0_QUEUE1_IB_CNTL__SWITCH_INSIDE_IB_MASK                                                           0x00000100L
#define SDMA0_QUEUE1_IB_CNTL__CMD_VMID_MASK                                                                   0x000F0000L
//SDMA0_QUEUE1_IB_RPTR
#define SDMA0_QUEUE1_IB_RPTR__OFFSET__SHIFT                                                                   0x2
#define SDMA0_QUEUE1_IB_RPTR__OFFSET_MASK                                                                     0x003FFFFCL
//SDMA0_QUEUE1_IB_OFFSET
#define SDMA0_QUEUE1_IB_OFFSET__OFFSET__SHIFT                                                                 0x2
#define SDMA0_QUEUE1_IB_OFFSET__OFFSET_MASK                                                                   0x003FFFFCL
//SDMA0_QUEUE1_IB_BASE_LO
#define SDMA0_QUEUE1_IB_BASE_LO__ADDR__SHIFT                                                                  0x2
#define SDMA0_QUEUE1_IB_BASE_LO__ADDR_MASK                                                                    0xFFFFFFFCL
//SDMA0_QUEUE1_IB_BASE_HI
#define SDMA0_QUEUE1_IB_BASE_HI__ADDR__SHIFT                                                                  0x0
#define SDMA0_QUEUE1_IB_BASE_HI__ADDR_MASK                                                                    0xFFFFFFFFL
//SDMA0_QUEUE1_IB_SIZE
#define SDMA0_QUEUE1_IB_SIZE__SIZE__SHIFT                                                                     0x0
#define SDMA0_QUEUE1_IB_SIZE__SIZE_MASK                                                                       0x000FFFFFL
//SDMA0_QUEUE1_DOORBELL
#define SDMA0_QUEUE1_DOORBELL__ENABLE__SHIFT                                                                  0x1c
#define SDMA0_QUEUE1_DOORBELL__CAPTURED__SHIFT                                                                0x1e
#define SDMA0_QUEUE1_DOORBELL__ENABLE_MASK                                                                    0x10000000L
#define SDMA0_QUEUE1_DOORBELL__CAPTURED_MASK                                                                  0x40000000L
//SDMA0_QUEUE1_DOORBELL_LOG
#define SDMA0_QUEUE1_DOORBELL_LOG__BE_ERROR__SHIFT                                                            0x0
#define SDMA0_QUEUE1_DOORBELL_LOG__DATA__SHIFT                                                                0x2
#define SDMA0_QUEUE1_DOORBELL_LOG__BE_ERROR_MASK                                                              0x00000001L
#define SDMA0_QUEUE1_DOORBELL_LOG__DATA_MASK                                                                  0xFFFFFFFCL
//SDMA0_QUEUE1_DOORBELL_OFFSET
#define SDMA0_QUEUE1_DOORBELL_OFFSET__OFFSET__SHIFT                                                           0x2
#define SDMA0_QUEUE1_DOORBELL_OFFSET__OFFSET_MASK                                                             0x0FFFFFFCL
//SDMA0_QUEUE1_CSA_ADDR_LO
#define SDMA0_QUEUE1_CSA_ADDR_LO__ADDR__SHIFT                                                                 0x2
#define SDMA0_QUEUE1_CSA_ADDR_LO__ADDR_MASK                                                                   0xFFFFFFFCL
//SDMA0_QUEUE1_CSA_ADDR_HI
#define SDMA0_QUEUE1_CSA_ADDR_HI__ADDR__SHIFT                                                                 0x0
#define SDMA0_QUEUE1_CSA_ADDR_HI__ADDR_MASK                                                                   0xFFFFFFFFL
//SDMA0_QUEUE1_SCHEDULE_CNTL
#define SDMA0_QUEUE1_SCHEDULE_CNTL__GLOBAL_ID__SHIFT                                                          0x0
#define SDMA0_QUEUE1_SCHEDULE_CNTL__PROCESS_ID__SHIFT                                                         0x2
#define SDMA0_QUEUE1_SCHEDULE_CNTL__LOCAL_ID__SHIFT                                                           0x6
#define SDMA0_QUEUE1_SCHEDULE_CNTL__CONTEXT_QUANTUM__SHIFT                                                    0x8
#define SDMA0_QUEUE1_SCHEDULE_CNTL__GLOBAL_ID_MASK                                                            0x00000003L
#define SDMA0_QUEUE1_SCHEDULE_CNTL__PROCESS_ID_MASK                                                           0x0000001CL
#define SDMA0_QUEUE1_SCHEDULE_CNTL__LOCAL_ID_MASK                                                             0x000000C0L
#define SDMA0_QUEUE1_SCHEDULE_CNTL__CONTEXT_QUANTUM_MASK                                                      0x0000FF00L
//SDMA0_QUEUE1_IB_SUB_REMAIN
#define SDMA0_QUEUE1_IB_SUB_REMAIN__SIZE__SHIFT                                                               0x0
#define SDMA0_QUEUE1_IB_SUB_REMAIN__SIZE_MASK                                                                 0x00003FFFL
//SDMA0_QUEUE1_PREEMPT
#define SDMA0_QUEUE1_PREEMPT__IB_PREEMPT__SHIFT                                                               0x0
#define SDMA0_QUEUE1_PREEMPT__IB_PREEMPT_MASK                                                                 0x00000001L
//SDMA0_QUEUE1_DUMMY_REG
#define SDMA0_QUEUE1_DUMMY_REG__DUMMY__SHIFT                                                                  0x0
#define SDMA0_QUEUE1_DUMMY_REG__DUMMY_MASK                                                                    0xFFFFFFFFL
//SDMA0_QUEUE1_RB_WPTR_POLL_ADDR_LO
#define SDMA0_QUEUE1_RB_WPTR_POLL_ADDR_LO__ADDR__SHIFT                                                        0x2
#define SDMA0_QUEUE1_RB_WPTR_POLL_ADDR_LO__ADDR_MASK                                                          0xFFFFFFFCL
//SDMA0_QUEUE1_RB_WPTR_POLL_ADDR_HI
#define SDMA0_QUEUE1_RB_WPTR_POLL_ADDR_HI__ADDR__SHIFT                                                        0x0
#define SDMA0_QUEUE1_RB_WPTR_POLL_ADDR_HI__ADDR_MASK                                                          0xFFFFFFFFL
//SDMA0_QUEUE1_RB_AQL_CNTL
#define SDMA0_QUEUE1_RB_AQL_CNTL__AQL_ENABLE__SHIFT                                                           0x0
#define SDMA0_QUEUE1_RB_AQL_CNTL__AQL_PACKET_SIZE__SHIFT                                                      0x1
#define SDMA0_QUEUE1_RB_AQL_CNTL__PACKET_STEP__SHIFT                                                          0x8
#define SDMA0_QUEUE1_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE__SHIFT                                                0x10
#define SDMA0_QUEUE1_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE__SHIFT                                          0x11
#define SDMA0_QUEUE1_RB_AQL_CNTL__OVERLAP_ENABLE__SHIFT                                                       0x12
#define SDMA0_QUEUE1_RB_AQL_CNTL__AQL_ENABLE_MASK                                                             0x00000001L
#define SDMA0_QUEUE1_RB_AQL_CNTL__AQL_PACKET_SIZE_MASK                                                        0x000000FEL
#define SDMA0_QUEUE1_RB_AQL_CNTL__PACKET_STEP_MASK                                                            0x0000FF00L
#define SDMA0_QUEUE1_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE_MASK                                                  0x00010000L
#define SDMA0_QUEUE1_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE_MASK                                            0x00020000L
#define SDMA0_QUEUE1_RB_AQL_CNTL__OVERLAP_ENABLE_MASK                                                         0x00040000L
//SDMA0_QUEUE1_MINOR_PTR_UPDATE
#define SDMA0_QUEUE1_MINOR_PTR_UPDATE__ENABLE__SHIFT                                                          0x0
#define SDMA0_QUEUE1_MINOR_PTR_UPDATE__ENABLE_MASK                                                            0x00000001L
//SDMA0_QUEUE1_CONTEXT_SWITCH_STATUS
#define SDMA0_QUEUE1_CONTEXT_SWITCH_STATUS__RB_PREEMPT_STATUS__SHIFT                                          0x0
#define SDMA0_QUEUE1_CONTEXT_SWITCH_STATUS__VM_HOLE_EXCEPTION__SHIFT                                          0x1
#define SDMA0_QUEUE1_CONTEXT_SWITCH_STATUS__PAGE_EXCEPTION__SHIFT                                             0x2
#define SDMA0_QUEUE1_CONTEXT_SWITCH_STATUS__QUEUE_HANG_EXCEPTION__SHIFT                                       0x5
#define SDMA0_QUEUE1_CONTEXT_SWITCH_STATUS__DOORBELL_ERROR_EXCEPTION__SHIFT                                   0x6
#define SDMA0_QUEUE1_CONTEXT_SWITCH_STATUS__SRAM_ECC_EXCEPTION__SHIFT                                         0x7
#define SDMA0_QUEUE1_CONTEXT_SWITCH_STATUS__DRAM_ECC_EXCEPTION__SHIFT                                         0x8
#define SDMA0_QUEUE1_CONTEXT_SWITCH_STATUS__WPTR_LT_RPTR_EXCEPTION__SHIFT                                     0x9
#define SDMA0_QUEUE1_CONTEXT_SWITCH_STATUS__RB_PREEMPT_STATUS_MASK                                            0x00000001L
#define SDMA0_QUEUE1_CONTEXT_SWITCH_STATUS__VM_HOLE_EXCEPTION_MASK                                            0x00000002L
#define SDMA0_QUEUE1_CONTEXT_SWITCH_STATUS__PAGE_EXCEPTION_MASK                                               0x00000004L
#define SDMA0_QUEUE1_CONTEXT_SWITCH_STATUS__QUEUE_HANG_EXCEPTION_MASK                                         0x00000020L
#define SDMA0_QUEUE1_CONTEXT_SWITCH_STATUS__DOORBELL_ERROR_EXCEPTION_MASK                                     0x00000040L
#define SDMA0_QUEUE1_CONTEXT_SWITCH_STATUS__SRAM_ECC_EXCEPTION_MASK                                           0x00000080L
#define SDMA0_QUEUE1_CONTEXT_SWITCH_STATUS__DRAM_ECC_EXCEPTION_MASK                                           0x00000100L
#define SDMA0_QUEUE1_CONTEXT_SWITCH_STATUS__WPTR_LT_RPTR_EXCEPTION_MASK                                       0x00000200L
//SDMA0_QUEUE1_MIDCMD_CNTL
#define SDMA0_QUEUE1_MIDCMD_CNTL__DATA_VALID__SHIFT                                                           0x0
#define SDMA0_QUEUE1_MIDCMD_CNTL__COPY_MODE__SHIFT                                                            0x1
#define SDMA0_QUEUE1_MIDCMD_CNTL__SPLIT_STATE__SHIFT                                                          0x4
#define SDMA0_QUEUE1_MIDCMD_CNTL__ALLOW_PREEMPT__SHIFT                                                        0x8
#define SDMA0_QUEUE1_MIDCMD_CNTL__DATA_VALID_MASK                                                             0x00000001L
#define SDMA0_QUEUE1_MIDCMD_CNTL__COPY_MODE_MASK                                                              0x00000002L
#define SDMA0_QUEUE1_MIDCMD_CNTL__SPLIT_STATE_MASK                                                            0x000000F0L
#define SDMA0_QUEUE1_MIDCMD_CNTL__ALLOW_PREEMPT_MASK                                                          0x00000100L
//SDMA0_QUEUE1_MIDCMD_DATA0
#define SDMA0_QUEUE1_MIDCMD_DATA0__DATA0__SHIFT                                                               0x0
#define SDMA0_QUEUE1_MIDCMD_DATA0__DATA0_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE1_MIDCMD_DATA1
#define SDMA0_QUEUE1_MIDCMD_DATA1__DATA1__SHIFT                                                               0x0
#define SDMA0_QUEUE1_MIDCMD_DATA1__DATA1_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE1_MIDCMD_DATA2
#define SDMA0_QUEUE1_MIDCMD_DATA2__DATA2__SHIFT                                                               0x0
#define SDMA0_QUEUE1_MIDCMD_DATA2__DATA2_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE1_MIDCMD_DATA3
#define SDMA0_QUEUE1_MIDCMD_DATA3__DATA3__SHIFT                                                               0x0
#define SDMA0_QUEUE1_MIDCMD_DATA3__DATA3_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE1_MIDCMD_DATA4
#define SDMA0_QUEUE1_MIDCMD_DATA4__DATA4__SHIFT                                                               0x0
#define SDMA0_QUEUE1_MIDCMD_DATA4__DATA4_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE1_MIDCMD_DATA5
#define SDMA0_QUEUE1_MIDCMD_DATA5__DATA5__SHIFT                                                               0x0
#define SDMA0_QUEUE1_MIDCMD_DATA5__DATA5_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE1_MIDCMD_DATA6
#define SDMA0_QUEUE1_MIDCMD_DATA6__DATA6__SHIFT                                                               0x0
#define SDMA0_QUEUE1_MIDCMD_DATA6__DATA6_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE1_MIDCMD_DATA7
#define SDMA0_QUEUE1_MIDCMD_DATA7__DATA7__SHIFT                                                               0x0
#define SDMA0_QUEUE1_MIDCMD_DATA7__DATA7_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE1_MIDCMD_DATA8
#define SDMA0_QUEUE1_MIDCMD_DATA8__DATA8__SHIFT                                                               0x0
#define SDMA0_QUEUE1_MIDCMD_DATA8__DATA8_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE1_MIDCMD_DATA9
#define SDMA0_QUEUE1_MIDCMD_DATA9__DATA9__SHIFT                                                               0x0
#define SDMA0_QUEUE1_MIDCMD_DATA9__DATA9_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE1_MIDCMD_DATA10
#define SDMA0_QUEUE1_MIDCMD_DATA10__DATA10__SHIFT                                                             0x0
#define SDMA0_QUEUE1_MIDCMD_DATA10__DATA10_MASK                                                               0xFFFFFFFFL
//SDMA0_QUEUE1_WAIT_UNSATISFIED_THD
#define SDMA0_QUEUE1_WAIT_UNSATISFIED_THD__THRESHOLD__SHIFT                                                   0x0
#define SDMA0_QUEUE1_WAIT_UNSATISFIED_THD__THRESHOLD_MASK                                                     0x0000001FL
//SDMA0_QUEUE1_MQD_BASE_ADDR_LO
#define SDMA0_QUEUE1_MQD_BASE_ADDR_LO__BASE_ADDR_LO__SHIFT                                                    0x2
#define SDMA0_QUEUE1_MQD_BASE_ADDR_LO__BASE_ADDR_LO_MASK                                                      0xFFFFFFFCL
//SDMA0_QUEUE1_MQD_BASE_ADDR_HI
#define SDMA0_QUEUE1_MQD_BASE_ADDR_HI__BASE_ADDR_HI__SHIFT                                                    0x0
#define SDMA0_QUEUE1_MQD_BASE_ADDR_HI__BASE_ADDR_HI_MASK                                                      0xFFFFFFFFL
//SDMA0_QUEUE1_MQD_CONTROL
#define SDMA0_QUEUE1_MQD_CONTROL__VMID__SHIFT                                                                 0x0
#define SDMA0_QUEUE1_MQD_CONTROL__VMID_MASK                                                                   0x0000000FL
//SDMA0_QUEUE1_DEQUEUE_REQUEST
#define SDMA0_QUEUE1_DEQUEUE_REQUEST__DEQUEUE_REQ__SHIFT                                                      0x0
#define SDMA0_QUEUE1_DEQUEUE_REQUEST__DEQUEUE_REQ_MASK                                                        0x00000001L
//SDMA0_QUEUE1_CONTEXT_STATUS
#define SDMA0_QUEUE1_CONTEXT_STATUS__SELECTED__SHIFT                                                          0x0
#define SDMA0_QUEUE1_CONTEXT_STATUS__USE_IB__SHIFT                                                            0x1
#define SDMA0_QUEUE1_CONTEXT_STATUS__IDLE__SHIFT                                                              0x2
#define SDMA0_QUEUE1_CONTEXT_STATUS__EXPIRED__SHIFT                                                           0x3
#define SDMA0_QUEUE1_CONTEXT_STATUS__EXCEPTION__SHIFT                                                         0x4
#define SDMA0_QUEUE1_CONTEXT_STATUS__CTXSW_ABLE__SHIFT                                                        0x7
#define SDMA0_QUEUE1_CONTEXT_STATUS__VF_STATUS__SHIFT                                                         0x8
#define SDMA0_QUEUE1_CONTEXT_STATUS__PRIV_EXCEPTION__SHIFT                                                    0x9
#define SDMA0_QUEUE1_CONTEXT_STATUS__PREEMPT_DISABLE__SHIFT                                                   0xa
#define SDMA0_QUEUE1_CONTEXT_STATUS__RPTR_WB_IDLE__SHIFT                                                      0xb
#define SDMA0_QUEUE1_CONTEXT_STATUS__WPTR_UPDATE_PENDING__SHIFT                                               0xc
#define SDMA0_QUEUE1_CONTEXT_STATUS__WPTR_UPDATE_FAIL_COUNT__SHIFT                                            0x10
#define SDMA0_QUEUE1_CONTEXT_STATUS__SELECTED_MASK                                                            0x00000001L
#define SDMA0_QUEUE1_CONTEXT_STATUS__USE_IB_MASK                                                              0x00000002L
#define SDMA0_QUEUE1_CONTEXT_STATUS__IDLE_MASK                                                                0x00000004L
#define SDMA0_QUEUE1_CONTEXT_STATUS__EXPIRED_MASK                                                             0x00000008L
#define SDMA0_QUEUE1_CONTEXT_STATUS__EXCEPTION_MASK                                                           0x00000070L
#define SDMA0_QUEUE1_CONTEXT_STATUS__CTXSW_ABLE_MASK                                                          0x00000080L
#define SDMA0_QUEUE1_CONTEXT_STATUS__VF_STATUS_MASK                                                           0x00000100L
#define SDMA0_QUEUE1_CONTEXT_STATUS__PRIV_EXCEPTION_MASK                                                      0x00000200L
#define SDMA0_QUEUE1_CONTEXT_STATUS__PREEMPT_DISABLE_MASK                                                     0x00000400L
#define SDMA0_QUEUE1_CONTEXT_STATUS__RPTR_WB_IDLE_MASK                                                        0x00000800L
#define SDMA0_QUEUE1_CONTEXT_STATUS__WPTR_UPDATE_PENDING_MASK                                                 0x00001000L
#define SDMA0_QUEUE1_CONTEXT_STATUS__WPTR_UPDATE_FAIL_COUNT_MASK                                              0x00FF0000L
//SDMA0_QUEUE2_RB_CNTL
#define SDMA0_QUEUE2_RB_CNTL__RB_ENABLE__SHIFT                                                                0x0
#define SDMA0_QUEUE2_RB_CNTL__RB_SIZE__SHIFT                                                                  0x1
#define SDMA0_QUEUE2_RB_CNTL__WPTR_POLL_ENABLE__SHIFT                                                         0x8
#define SDMA0_QUEUE2_RB_CNTL__RB_SWAP_ENABLE__SHIFT                                                           0x9
#define SDMA0_QUEUE2_RB_CNTL__WPTR_POLL_SWAP_ENABLE__SHIFT                                                    0xa
#define SDMA0_QUEUE2_RB_CNTL__MCU_WPTR_POLL_ENABLE__SHIFT                                                     0xb
#define SDMA0_QUEUE2_RB_CNTL__RPTR_WRITEBACK_ENABLE__SHIFT                                                    0xc
#define SDMA0_QUEUE2_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE__SHIFT                                               0xd
#define SDMA0_QUEUE2_RB_CNTL__RPTR_WRITEBACK_TIMER__SHIFT                                                     0x10
#define SDMA0_QUEUE2_RB_CNTL__RB_PRIV__SHIFT                                                                  0x17
#define SDMA0_QUEUE2_RB_CNTL__RB_VMID__SHIFT                                                                  0x18
#define SDMA0_QUEUE2_RB_CNTL__RB_ENABLE_MASK                                                                  0x00000001L
#define SDMA0_QUEUE2_RB_CNTL__RB_SIZE_MASK                                                                    0x0000003EL
#define SDMA0_QUEUE2_RB_CNTL__WPTR_POLL_ENABLE_MASK                                                           0x00000100L
#define SDMA0_QUEUE2_RB_CNTL__RB_SWAP_ENABLE_MASK                                                             0x00000200L
#define SDMA0_QUEUE2_RB_CNTL__WPTR_POLL_SWAP_ENABLE_MASK                                                      0x00000400L
#define SDMA0_QUEUE2_RB_CNTL__MCU_WPTR_POLL_ENABLE_MASK                                                       0x00000800L
#define SDMA0_QUEUE2_RB_CNTL__RPTR_WRITEBACK_ENABLE_MASK                                                      0x00001000L
#define SDMA0_QUEUE2_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE_MASK                                                 0x00002000L
#define SDMA0_QUEUE2_RB_CNTL__RPTR_WRITEBACK_TIMER_MASK                                                       0x001F0000L
#define SDMA0_QUEUE2_RB_CNTL__RB_PRIV_MASK                                                                    0x00800000L
#define SDMA0_QUEUE2_RB_CNTL__RB_VMID_MASK                                                                    0x0F000000L
//SDMA0_QUEUE2_RB_BASE
#define SDMA0_QUEUE2_RB_BASE__ADDR__SHIFT                                                                     0x0
#define SDMA0_QUEUE2_RB_BASE__ADDR_MASK                                                                       0xFFFFFFFFL
//SDMA0_QUEUE2_RB_BASE_HI
#define SDMA0_QUEUE2_RB_BASE_HI__ADDR__SHIFT                                                                  0x0
#define SDMA0_QUEUE2_RB_BASE_HI__ADDR_MASK                                                                    0x00FFFFFFL
//SDMA0_QUEUE2_RB_RPTR
#define SDMA0_QUEUE2_RB_RPTR__OFFSET__SHIFT                                                                   0x0
#define SDMA0_QUEUE2_RB_RPTR__OFFSET_MASK                                                                     0xFFFFFFFFL
//SDMA0_QUEUE2_RB_RPTR_HI
#define SDMA0_QUEUE2_RB_RPTR_HI__OFFSET__SHIFT                                                                0x0
#define SDMA0_QUEUE2_RB_RPTR_HI__OFFSET_MASK                                                                  0xFFFFFFFFL
//SDMA0_QUEUE2_RB_WPTR
#define SDMA0_QUEUE2_RB_WPTR__OFFSET__SHIFT                                                                   0x0
#define SDMA0_QUEUE2_RB_WPTR__OFFSET_MASK                                                                     0xFFFFFFFFL
//SDMA0_QUEUE2_RB_WPTR_HI
#define SDMA0_QUEUE2_RB_WPTR_HI__OFFSET__SHIFT                                                                0x0
#define SDMA0_QUEUE2_RB_WPTR_HI__OFFSET_MASK                                                                  0xFFFFFFFFL
//SDMA0_QUEUE2_RB_RPTR_ADDR_LO
#define SDMA0_QUEUE2_RB_RPTR_ADDR_LO__ADDR__SHIFT                                                             0x2
#define SDMA0_QUEUE2_RB_RPTR_ADDR_LO__ADDR_MASK                                                               0xFFFFFFFCL
//SDMA0_QUEUE2_RB_RPTR_ADDR_HI
#define SDMA0_QUEUE2_RB_RPTR_ADDR_HI__ADDR__SHIFT                                                             0x0
#define SDMA0_QUEUE2_RB_RPTR_ADDR_HI__ADDR_MASK                                                               0xFFFFFFFFL
//SDMA0_QUEUE2_IB_CNTL
#define SDMA0_QUEUE2_IB_CNTL__IB_ENABLE__SHIFT                                                                0x0
#define SDMA0_QUEUE2_IB_CNTL__IB_SWAP_ENABLE__SHIFT                                                           0x4
#define SDMA0_QUEUE2_IB_CNTL__SWITCH_INSIDE_IB__SHIFT                                                         0x8
#define SDMA0_QUEUE2_IB_CNTL__CMD_VMID__SHIFT                                                                 0x10
#define SDMA0_QUEUE2_IB_CNTL__IB_ENABLE_MASK                                                                  0x00000001L
#define SDMA0_QUEUE2_IB_CNTL__IB_SWAP_ENABLE_MASK                                                             0x00000010L
#define SDMA0_QUEUE2_IB_CNTL__SWITCH_INSIDE_IB_MASK                                                           0x00000100L
#define SDMA0_QUEUE2_IB_CNTL__CMD_VMID_MASK                                                                   0x000F0000L
//SDMA0_QUEUE2_IB_RPTR
#define SDMA0_QUEUE2_IB_RPTR__OFFSET__SHIFT                                                                   0x2
#define SDMA0_QUEUE2_IB_RPTR__OFFSET_MASK                                                                     0x003FFFFCL
//SDMA0_QUEUE2_IB_OFFSET
#define SDMA0_QUEUE2_IB_OFFSET__OFFSET__SHIFT                                                                 0x2
#define SDMA0_QUEUE2_IB_OFFSET__OFFSET_MASK                                                                   0x003FFFFCL
//SDMA0_QUEUE2_IB_BASE_LO
#define SDMA0_QUEUE2_IB_BASE_LO__ADDR__SHIFT                                                                  0x2
#define SDMA0_QUEUE2_IB_BASE_LO__ADDR_MASK                                                                    0xFFFFFFFCL
//SDMA0_QUEUE2_IB_BASE_HI
#define SDMA0_QUEUE2_IB_BASE_HI__ADDR__SHIFT                                                                  0x0
#define SDMA0_QUEUE2_IB_BASE_HI__ADDR_MASK                                                                    0xFFFFFFFFL
//SDMA0_QUEUE2_IB_SIZE
#define SDMA0_QUEUE2_IB_SIZE__SIZE__SHIFT                                                                     0x0
#define SDMA0_QUEUE2_IB_SIZE__SIZE_MASK                                                                       0x000FFFFFL
//SDMA0_QUEUE2_DOORBELL
#define SDMA0_QUEUE2_DOORBELL__ENABLE__SHIFT                                                                  0x1c
#define SDMA0_QUEUE2_DOORBELL__CAPTURED__SHIFT                                                                0x1e
#define SDMA0_QUEUE2_DOORBELL__ENABLE_MASK                                                                    0x10000000L
#define SDMA0_QUEUE2_DOORBELL__CAPTURED_MASK                                                                  0x40000000L
//SDMA0_QUEUE2_DOORBELL_LOG
#define SDMA0_QUEUE2_DOORBELL_LOG__BE_ERROR__SHIFT                                                            0x0
#define SDMA0_QUEUE2_DOORBELL_LOG__DATA__SHIFT                                                                0x2
#define SDMA0_QUEUE2_DOORBELL_LOG__BE_ERROR_MASK                                                              0x00000001L
#define SDMA0_QUEUE2_DOORBELL_LOG__DATA_MASK                                                                  0xFFFFFFFCL
//SDMA0_QUEUE2_DOORBELL_OFFSET
#define SDMA0_QUEUE2_DOORBELL_OFFSET__OFFSET__SHIFT                                                           0x2
#define SDMA0_QUEUE2_DOORBELL_OFFSET__OFFSET_MASK                                                             0x0FFFFFFCL
//SDMA0_QUEUE2_CSA_ADDR_LO
#define SDMA0_QUEUE2_CSA_ADDR_LO__ADDR__SHIFT                                                                 0x2
#define SDMA0_QUEUE2_CSA_ADDR_LO__ADDR_MASK                                                                   0xFFFFFFFCL
//SDMA0_QUEUE2_CSA_ADDR_HI
#define SDMA0_QUEUE2_CSA_ADDR_HI__ADDR__SHIFT                                                                 0x0
#define SDMA0_QUEUE2_CSA_ADDR_HI__ADDR_MASK                                                                   0xFFFFFFFFL
//SDMA0_QUEUE2_SCHEDULE_CNTL
#define SDMA0_QUEUE2_SCHEDULE_CNTL__GLOBAL_ID__SHIFT                                                          0x0
#define SDMA0_QUEUE2_SCHEDULE_CNTL__PROCESS_ID__SHIFT                                                         0x2
#define SDMA0_QUEUE2_SCHEDULE_CNTL__LOCAL_ID__SHIFT                                                           0x6
#define SDMA0_QUEUE2_SCHEDULE_CNTL__CONTEXT_QUANTUM__SHIFT                                                    0x8
#define SDMA0_QUEUE2_SCHEDULE_CNTL__GLOBAL_ID_MASK                                                            0x00000003L
#define SDMA0_QUEUE2_SCHEDULE_CNTL__PROCESS_ID_MASK                                                           0x0000001CL
#define SDMA0_QUEUE2_SCHEDULE_CNTL__LOCAL_ID_MASK                                                             0x000000C0L
#define SDMA0_QUEUE2_SCHEDULE_CNTL__CONTEXT_QUANTUM_MASK                                                      0x0000FF00L
//SDMA0_QUEUE2_IB_SUB_REMAIN
#define SDMA0_QUEUE2_IB_SUB_REMAIN__SIZE__SHIFT                                                               0x0
#define SDMA0_QUEUE2_IB_SUB_REMAIN__SIZE_MASK                                                                 0x00003FFFL
//SDMA0_QUEUE2_PREEMPT
#define SDMA0_QUEUE2_PREEMPT__IB_PREEMPT__SHIFT                                                               0x0
#define SDMA0_QUEUE2_PREEMPT__IB_PREEMPT_MASK                                                                 0x00000001L
//SDMA0_QUEUE2_DUMMY_REG
#define SDMA0_QUEUE2_DUMMY_REG__DUMMY__SHIFT                                                                  0x0
#define SDMA0_QUEUE2_DUMMY_REG__DUMMY_MASK                                                                    0xFFFFFFFFL
//SDMA0_QUEUE2_RB_WPTR_POLL_ADDR_LO
#define SDMA0_QUEUE2_RB_WPTR_POLL_ADDR_LO__ADDR__SHIFT                                                        0x2
#define SDMA0_QUEUE2_RB_WPTR_POLL_ADDR_LO__ADDR_MASK                                                          0xFFFFFFFCL
//SDMA0_QUEUE2_RB_WPTR_POLL_ADDR_HI
#define SDMA0_QUEUE2_RB_WPTR_POLL_ADDR_HI__ADDR__SHIFT                                                        0x0
#define SDMA0_QUEUE2_RB_WPTR_POLL_ADDR_HI__ADDR_MASK                                                          0xFFFFFFFFL
//SDMA0_QUEUE2_RB_AQL_CNTL
#define SDMA0_QUEUE2_RB_AQL_CNTL__AQL_ENABLE__SHIFT                                                           0x0
#define SDMA0_QUEUE2_RB_AQL_CNTL__AQL_PACKET_SIZE__SHIFT                                                      0x1
#define SDMA0_QUEUE2_RB_AQL_CNTL__PACKET_STEP__SHIFT                                                          0x8
#define SDMA0_QUEUE2_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE__SHIFT                                                0x10
#define SDMA0_QUEUE2_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE__SHIFT                                          0x11
#define SDMA0_QUEUE2_RB_AQL_CNTL__OVERLAP_ENABLE__SHIFT                                                       0x12
#define SDMA0_QUEUE2_RB_AQL_CNTL__AQL_ENABLE_MASK                                                             0x00000001L
#define SDMA0_QUEUE2_RB_AQL_CNTL__AQL_PACKET_SIZE_MASK                                                        0x000000FEL
#define SDMA0_QUEUE2_RB_AQL_CNTL__PACKET_STEP_MASK                                                            0x0000FF00L
#define SDMA0_QUEUE2_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE_MASK                                                  0x00010000L
#define SDMA0_QUEUE2_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE_MASK                                            0x00020000L
#define SDMA0_QUEUE2_RB_AQL_CNTL__OVERLAP_ENABLE_MASK                                                         0x00040000L
//SDMA0_QUEUE2_MINOR_PTR_UPDATE
#define SDMA0_QUEUE2_MINOR_PTR_UPDATE__ENABLE__SHIFT                                                          0x0
#define SDMA0_QUEUE2_MINOR_PTR_UPDATE__ENABLE_MASK                                                            0x00000001L
//SDMA0_QUEUE2_CONTEXT_SWITCH_STATUS
#define SDMA0_QUEUE2_CONTEXT_SWITCH_STATUS__RB_PREEMPT_STATUS__SHIFT                                          0x0
#define SDMA0_QUEUE2_CONTEXT_SWITCH_STATUS__VM_HOLE_EXCEPTION__SHIFT                                          0x1
#define SDMA0_QUEUE2_CONTEXT_SWITCH_STATUS__PAGE_EXCEPTION__SHIFT                                             0x2
#define SDMA0_QUEUE2_CONTEXT_SWITCH_STATUS__QUEUE_HANG_EXCEPTION__SHIFT                                       0x5
#define SDMA0_QUEUE2_CONTEXT_SWITCH_STATUS__DOORBELL_ERROR_EXCEPTION__SHIFT                                   0x6
#define SDMA0_QUEUE2_CONTEXT_SWITCH_STATUS__SRAM_ECC_EXCEPTION__SHIFT                                         0x7
#define SDMA0_QUEUE2_CONTEXT_SWITCH_STATUS__DRAM_ECC_EXCEPTION__SHIFT                                         0x8
#define SDMA0_QUEUE2_CONTEXT_SWITCH_STATUS__WPTR_LT_RPTR_EXCEPTION__SHIFT                                     0x9
#define SDMA0_QUEUE2_CONTEXT_SWITCH_STATUS__RB_PREEMPT_STATUS_MASK                                            0x00000001L
#define SDMA0_QUEUE2_CONTEXT_SWITCH_STATUS__VM_HOLE_EXCEPTION_MASK                                            0x00000002L
#define SDMA0_QUEUE2_CONTEXT_SWITCH_STATUS__PAGE_EXCEPTION_MASK                                               0x00000004L
#define SDMA0_QUEUE2_CONTEXT_SWITCH_STATUS__QUEUE_HANG_EXCEPTION_MASK                                         0x00000020L
#define SDMA0_QUEUE2_CONTEXT_SWITCH_STATUS__DOORBELL_ERROR_EXCEPTION_MASK                                     0x00000040L
#define SDMA0_QUEUE2_CONTEXT_SWITCH_STATUS__SRAM_ECC_EXCEPTION_MASK                                           0x00000080L
#define SDMA0_QUEUE2_CONTEXT_SWITCH_STATUS__DRAM_ECC_EXCEPTION_MASK                                           0x00000100L
#define SDMA0_QUEUE2_CONTEXT_SWITCH_STATUS__WPTR_LT_RPTR_EXCEPTION_MASK                                       0x00000200L
//SDMA0_QUEUE2_MIDCMD_CNTL
#define SDMA0_QUEUE2_MIDCMD_CNTL__DATA_VALID__SHIFT                                                           0x0
#define SDMA0_QUEUE2_MIDCMD_CNTL__COPY_MODE__SHIFT                                                            0x1
#define SDMA0_QUEUE2_MIDCMD_CNTL__SPLIT_STATE__SHIFT                                                          0x4
#define SDMA0_QUEUE2_MIDCMD_CNTL__ALLOW_PREEMPT__SHIFT                                                        0x8
#define SDMA0_QUEUE2_MIDCMD_CNTL__DATA_VALID_MASK                                                             0x00000001L
#define SDMA0_QUEUE2_MIDCMD_CNTL__COPY_MODE_MASK                                                              0x00000002L
#define SDMA0_QUEUE2_MIDCMD_CNTL__SPLIT_STATE_MASK                                                            0x000000F0L
#define SDMA0_QUEUE2_MIDCMD_CNTL__ALLOW_PREEMPT_MASK                                                          0x00000100L
//SDMA0_QUEUE2_MIDCMD_DATA0
#define SDMA0_QUEUE2_MIDCMD_DATA0__DATA0__SHIFT                                                               0x0
#define SDMA0_QUEUE2_MIDCMD_DATA0__DATA0_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE2_MIDCMD_DATA1
#define SDMA0_QUEUE2_MIDCMD_DATA1__DATA1__SHIFT                                                               0x0
#define SDMA0_QUEUE2_MIDCMD_DATA1__DATA1_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE2_MIDCMD_DATA2
#define SDMA0_QUEUE2_MIDCMD_DATA2__DATA2__SHIFT                                                               0x0
#define SDMA0_QUEUE2_MIDCMD_DATA2__DATA2_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE2_MIDCMD_DATA3
#define SDMA0_QUEUE2_MIDCMD_DATA3__DATA3__SHIFT                                                               0x0
#define SDMA0_QUEUE2_MIDCMD_DATA3__DATA3_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE2_MIDCMD_DATA4
#define SDMA0_QUEUE2_MIDCMD_DATA4__DATA4__SHIFT                                                               0x0
#define SDMA0_QUEUE2_MIDCMD_DATA4__DATA4_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE2_MIDCMD_DATA5
#define SDMA0_QUEUE2_MIDCMD_DATA5__DATA5__SHIFT                                                               0x0
#define SDMA0_QUEUE2_MIDCMD_DATA5__DATA5_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE2_MIDCMD_DATA6
#define SDMA0_QUEUE2_MIDCMD_DATA6__DATA6__SHIFT                                                               0x0
#define SDMA0_QUEUE2_MIDCMD_DATA6__DATA6_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE2_MIDCMD_DATA7
#define SDMA0_QUEUE2_MIDCMD_DATA7__DATA7__SHIFT                                                               0x0
#define SDMA0_QUEUE2_MIDCMD_DATA7__DATA7_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE2_MIDCMD_DATA8
#define SDMA0_QUEUE2_MIDCMD_DATA8__DATA8__SHIFT                                                               0x0
#define SDMA0_QUEUE2_MIDCMD_DATA8__DATA8_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE2_MIDCMD_DATA9
#define SDMA0_QUEUE2_MIDCMD_DATA9__DATA9__SHIFT                                                               0x0
#define SDMA0_QUEUE2_MIDCMD_DATA9__DATA9_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE2_MIDCMD_DATA10
#define SDMA0_QUEUE2_MIDCMD_DATA10__DATA10__SHIFT                                                             0x0
#define SDMA0_QUEUE2_MIDCMD_DATA10__DATA10_MASK                                                               0xFFFFFFFFL
//SDMA0_QUEUE2_WAIT_UNSATISFIED_THD
#define SDMA0_QUEUE2_WAIT_UNSATISFIED_THD__THRESHOLD__SHIFT                                                   0x0
#define SDMA0_QUEUE2_WAIT_UNSATISFIED_THD__THRESHOLD_MASK                                                     0x0000001FL
//SDMA0_QUEUE2_MQD_BASE_ADDR_LO
#define SDMA0_QUEUE2_MQD_BASE_ADDR_LO__BASE_ADDR_LO__SHIFT                                                    0x2
#define SDMA0_QUEUE2_MQD_BASE_ADDR_LO__BASE_ADDR_LO_MASK                                                      0xFFFFFFFCL
//SDMA0_QUEUE2_MQD_BASE_ADDR_HI
#define SDMA0_QUEUE2_MQD_BASE_ADDR_HI__BASE_ADDR_HI__SHIFT                                                    0x0
#define SDMA0_QUEUE2_MQD_BASE_ADDR_HI__BASE_ADDR_HI_MASK                                                      0xFFFFFFFFL
//SDMA0_QUEUE2_MQD_CONTROL
#define SDMA0_QUEUE2_MQD_CONTROL__VMID__SHIFT                                                                 0x0
#define SDMA0_QUEUE2_MQD_CONTROL__VMID_MASK                                                                   0x0000000FL
//SDMA0_QUEUE2_DEQUEUE_REQUEST
#define SDMA0_QUEUE2_DEQUEUE_REQUEST__DEQUEUE_REQ__SHIFT                                                      0x0
#define SDMA0_QUEUE2_DEQUEUE_REQUEST__DEQUEUE_REQ_MASK                                                        0x00000001L
//SDMA0_QUEUE2_CONTEXT_STATUS
#define SDMA0_QUEUE2_CONTEXT_STATUS__SELECTED__SHIFT                                                          0x0
#define SDMA0_QUEUE2_CONTEXT_STATUS__USE_IB__SHIFT                                                            0x1
#define SDMA0_QUEUE2_CONTEXT_STATUS__IDLE__SHIFT                                                              0x2
#define SDMA0_QUEUE2_CONTEXT_STATUS__EXPIRED__SHIFT                                                           0x3
#define SDMA0_QUEUE2_CONTEXT_STATUS__EXCEPTION__SHIFT                                                         0x4
#define SDMA0_QUEUE2_CONTEXT_STATUS__CTXSW_ABLE__SHIFT                                                        0x7
#define SDMA0_QUEUE2_CONTEXT_STATUS__VF_STATUS__SHIFT                                                         0x8
#define SDMA0_QUEUE2_CONTEXT_STATUS__PRIV_EXCEPTION__SHIFT                                                    0x9
#define SDMA0_QUEUE2_CONTEXT_STATUS__PREEMPT_DISABLE__SHIFT                                                   0xa
#define SDMA0_QUEUE2_CONTEXT_STATUS__RPTR_WB_IDLE__SHIFT                                                      0xb
#define SDMA0_QUEUE2_CONTEXT_STATUS__WPTR_UPDATE_PENDING__SHIFT                                               0xc
#define SDMA0_QUEUE2_CONTEXT_STATUS__WPTR_UPDATE_FAIL_COUNT__SHIFT                                            0x10
#define SDMA0_QUEUE2_CONTEXT_STATUS__SELECTED_MASK                                                            0x00000001L
#define SDMA0_QUEUE2_CONTEXT_STATUS__USE_IB_MASK                                                              0x00000002L
#define SDMA0_QUEUE2_CONTEXT_STATUS__IDLE_MASK                                                                0x00000004L
#define SDMA0_QUEUE2_CONTEXT_STATUS__EXPIRED_MASK                                                             0x00000008L
#define SDMA0_QUEUE2_CONTEXT_STATUS__EXCEPTION_MASK                                                           0x00000070L
#define SDMA0_QUEUE2_CONTEXT_STATUS__CTXSW_ABLE_MASK                                                          0x00000080L
#define SDMA0_QUEUE2_CONTEXT_STATUS__VF_STATUS_MASK                                                           0x00000100L
#define SDMA0_QUEUE2_CONTEXT_STATUS__PRIV_EXCEPTION_MASK                                                      0x00000200L
#define SDMA0_QUEUE2_CONTEXT_STATUS__PREEMPT_DISABLE_MASK                                                     0x00000400L
#define SDMA0_QUEUE2_CONTEXT_STATUS__RPTR_WB_IDLE_MASK                                                        0x00000800L
#define SDMA0_QUEUE2_CONTEXT_STATUS__WPTR_UPDATE_PENDING_MASK                                                 0x00001000L
#define SDMA0_QUEUE2_CONTEXT_STATUS__WPTR_UPDATE_FAIL_COUNT_MASK                                              0x00FF0000L
//SDMA0_QUEUE3_RB_CNTL
#define SDMA0_QUEUE3_RB_CNTL__RB_ENABLE__SHIFT                                                                0x0
#define SDMA0_QUEUE3_RB_CNTL__RB_SIZE__SHIFT                                                                  0x1
#define SDMA0_QUEUE3_RB_CNTL__WPTR_POLL_ENABLE__SHIFT                                                         0x8
#define SDMA0_QUEUE3_RB_CNTL__RB_SWAP_ENABLE__SHIFT                                                           0x9
#define SDMA0_QUEUE3_RB_CNTL__WPTR_POLL_SWAP_ENABLE__SHIFT                                                    0xa
#define SDMA0_QUEUE3_RB_CNTL__MCU_WPTR_POLL_ENABLE__SHIFT                                                     0xb
#define SDMA0_QUEUE3_RB_CNTL__RPTR_WRITEBACK_ENABLE__SHIFT                                                    0xc
#define SDMA0_QUEUE3_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE__SHIFT                                               0xd
#define SDMA0_QUEUE3_RB_CNTL__RPTR_WRITEBACK_TIMER__SHIFT                                                     0x10
#define SDMA0_QUEUE3_RB_CNTL__RB_PRIV__SHIFT                                                                  0x17
#define SDMA0_QUEUE3_RB_CNTL__RB_VMID__SHIFT                                                                  0x18
#define SDMA0_QUEUE3_RB_CNTL__RB_ENABLE_MASK                                                                  0x00000001L
#define SDMA0_QUEUE3_RB_CNTL__RB_SIZE_MASK                                                                    0x0000003EL
#define SDMA0_QUEUE3_RB_CNTL__WPTR_POLL_ENABLE_MASK                                                           0x00000100L
#define SDMA0_QUEUE3_RB_CNTL__RB_SWAP_ENABLE_MASK                                                             0x00000200L
#define SDMA0_QUEUE3_RB_CNTL__WPTR_POLL_SWAP_ENABLE_MASK                                                      0x00000400L
#define SDMA0_QUEUE3_RB_CNTL__MCU_WPTR_POLL_ENABLE_MASK                                                       0x00000800L
#define SDMA0_QUEUE3_RB_CNTL__RPTR_WRITEBACK_ENABLE_MASK                                                      0x00001000L
#define SDMA0_QUEUE3_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE_MASK                                                 0x00002000L
#define SDMA0_QUEUE3_RB_CNTL__RPTR_WRITEBACK_TIMER_MASK                                                       0x001F0000L
#define SDMA0_QUEUE3_RB_CNTL__RB_PRIV_MASK                                                                    0x00800000L
#define SDMA0_QUEUE3_RB_CNTL__RB_VMID_MASK                                                                    0x0F000000L
//SDMA0_QUEUE3_RB_BASE
#define SDMA0_QUEUE3_RB_BASE__ADDR__SHIFT                                                                     0x0
#define SDMA0_QUEUE3_RB_BASE__ADDR_MASK                                                                       0xFFFFFFFFL
//SDMA0_QUEUE3_RB_BASE_HI
#define SDMA0_QUEUE3_RB_BASE_HI__ADDR__SHIFT                                                                  0x0
#define SDMA0_QUEUE3_RB_BASE_HI__ADDR_MASK                                                                    0x00FFFFFFL
//SDMA0_QUEUE3_RB_RPTR
#define SDMA0_QUEUE3_RB_RPTR__OFFSET__SHIFT                                                                   0x0
#define SDMA0_QUEUE3_RB_RPTR__OFFSET_MASK                                                                     0xFFFFFFFFL
//SDMA0_QUEUE3_RB_RPTR_HI
#define SDMA0_QUEUE3_RB_RPTR_HI__OFFSET__SHIFT                                                                0x0
#define SDMA0_QUEUE3_RB_RPTR_HI__OFFSET_MASK                                                                  0xFFFFFFFFL
//SDMA0_QUEUE3_RB_WPTR
#define SDMA0_QUEUE3_RB_WPTR__OFFSET__SHIFT                                                                   0x0
#define SDMA0_QUEUE3_RB_WPTR__OFFSET_MASK                                                                     0xFFFFFFFFL
//SDMA0_QUEUE3_RB_WPTR_HI
#define SDMA0_QUEUE3_RB_WPTR_HI__OFFSET__SHIFT                                                                0x0
#define SDMA0_QUEUE3_RB_WPTR_HI__OFFSET_MASK                                                                  0xFFFFFFFFL
//SDMA0_QUEUE3_RB_RPTR_ADDR_LO
#define SDMA0_QUEUE3_RB_RPTR_ADDR_LO__ADDR__SHIFT                                                             0x2
#define SDMA0_QUEUE3_RB_RPTR_ADDR_LO__ADDR_MASK                                                               0xFFFFFFFCL
//SDMA0_QUEUE3_RB_RPTR_ADDR_HI
#define SDMA0_QUEUE3_RB_RPTR_ADDR_HI__ADDR__SHIFT                                                             0x0
#define SDMA0_QUEUE3_RB_RPTR_ADDR_HI__ADDR_MASK                                                               0xFFFFFFFFL
//SDMA0_QUEUE3_IB_CNTL
#define SDMA0_QUEUE3_IB_CNTL__IB_ENABLE__SHIFT                                                                0x0
#define SDMA0_QUEUE3_IB_CNTL__IB_SWAP_ENABLE__SHIFT                                                           0x4
#define SDMA0_QUEUE3_IB_CNTL__SWITCH_INSIDE_IB__SHIFT                                                         0x8
#define SDMA0_QUEUE3_IB_CNTL__CMD_VMID__SHIFT                                                                 0x10
#define SDMA0_QUEUE3_IB_CNTL__IB_ENABLE_MASK                                                                  0x00000001L
#define SDMA0_QUEUE3_IB_CNTL__IB_SWAP_ENABLE_MASK                                                             0x00000010L
#define SDMA0_QUEUE3_IB_CNTL__SWITCH_INSIDE_IB_MASK                                                           0x00000100L
#define SDMA0_QUEUE3_IB_CNTL__CMD_VMID_MASK                                                                   0x000F0000L
//SDMA0_QUEUE3_IB_RPTR
#define SDMA0_QUEUE3_IB_RPTR__OFFSET__SHIFT                                                                   0x2
#define SDMA0_QUEUE3_IB_RPTR__OFFSET_MASK                                                                     0x003FFFFCL
//SDMA0_QUEUE3_IB_OFFSET
#define SDMA0_QUEUE3_IB_OFFSET__OFFSET__SHIFT                                                                 0x2
#define SDMA0_QUEUE3_IB_OFFSET__OFFSET_MASK                                                                   0x003FFFFCL
//SDMA0_QUEUE3_IB_BASE_LO
#define SDMA0_QUEUE3_IB_BASE_LO__ADDR__SHIFT                                                                  0x2
#define SDMA0_QUEUE3_IB_BASE_LO__ADDR_MASK                                                                    0xFFFFFFFCL
//SDMA0_QUEUE3_IB_BASE_HI
#define SDMA0_QUEUE3_IB_BASE_HI__ADDR__SHIFT                                                                  0x0
#define SDMA0_QUEUE3_IB_BASE_HI__ADDR_MASK                                                                    0xFFFFFFFFL
//SDMA0_QUEUE3_IB_SIZE
#define SDMA0_QUEUE3_IB_SIZE__SIZE__SHIFT                                                                     0x0
#define SDMA0_QUEUE3_IB_SIZE__SIZE_MASK                                                                       0x000FFFFFL
//SDMA0_QUEUE3_DOORBELL
#define SDMA0_QUEUE3_DOORBELL__ENABLE__SHIFT                                                                  0x1c
#define SDMA0_QUEUE3_DOORBELL__CAPTURED__SHIFT                                                                0x1e
#define SDMA0_QUEUE3_DOORBELL__ENABLE_MASK                                                                    0x10000000L
#define SDMA0_QUEUE3_DOORBELL__CAPTURED_MASK                                                                  0x40000000L
//SDMA0_QUEUE3_DOORBELL_LOG
#define SDMA0_QUEUE3_DOORBELL_LOG__BE_ERROR__SHIFT                                                            0x0
#define SDMA0_QUEUE3_DOORBELL_LOG__DATA__SHIFT                                                                0x2
#define SDMA0_QUEUE3_DOORBELL_LOG__BE_ERROR_MASK                                                              0x00000001L
#define SDMA0_QUEUE3_DOORBELL_LOG__DATA_MASK                                                                  0xFFFFFFFCL
//SDMA0_QUEUE3_DOORBELL_OFFSET
#define SDMA0_QUEUE3_DOORBELL_OFFSET__OFFSET__SHIFT                                                           0x2
#define SDMA0_QUEUE3_DOORBELL_OFFSET__OFFSET_MASK                                                             0x0FFFFFFCL
//SDMA0_QUEUE3_CSA_ADDR_LO
#define SDMA0_QUEUE3_CSA_ADDR_LO__ADDR__SHIFT                                                                 0x2
#define SDMA0_QUEUE3_CSA_ADDR_LO__ADDR_MASK                                                                   0xFFFFFFFCL
//SDMA0_QUEUE3_CSA_ADDR_HI
#define SDMA0_QUEUE3_CSA_ADDR_HI__ADDR__SHIFT                                                                 0x0
#define SDMA0_QUEUE3_CSA_ADDR_HI__ADDR_MASK                                                                   0xFFFFFFFFL
//SDMA0_QUEUE3_SCHEDULE_CNTL
#define SDMA0_QUEUE3_SCHEDULE_CNTL__GLOBAL_ID__SHIFT                                                          0x0
#define SDMA0_QUEUE3_SCHEDULE_CNTL__PROCESS_ID__SHIFT                                                         0x2
#define SDMA0_QUEUE3_SCHEDULE_CNTL__LOCAL_ID__SHIFT                                                           0x6
#define SDMA0_QUEUE3_SCHEDULE_CNTL__CONTEXT_QUANTUM__SHIFT                                                    0x8
#define SDMA0_QUEUE3_SCHEDULE_CNTL__GLOBAL_ID_MASK                                                            0x00000003L
#define SDMA0_QUEUE3_SCHEDULE_CNTL__PROCESS_ID_MASK                                                           0x0000001CL
#define SDMA0_QUEUE3_SCHEDULE_CNTL__LOCAL_ID_MASK                                                             0x000000C0L
#define SDMA0_QUEUE3_SCHEDULE_CNTL__CONTEXT_QUANTUM_MASK                                                      0x0000FF00L
//SDMA0_QUEUE3_IB_SUB_REMAIN
#define SDMA0_QUEUE3_IB_SUB_REMAIN__SIZE__SHIFT                                                               0x0
#define SDMA0_QUEUE3_IB_SUB_REMAIN__SIZE_MASK                                                                 0x00003FFFL
//SDMA0_QUEUE3_PREEMPT
#define SDMA0_QUEUE3_PREEMPT__IB_PREEMPT__SHIFT                                                               0x0
#define SDMA0_QUEUE3_PREEMPT__IB_PREEMPT_MASK                                                                 0x00000001L
//SDMA0_QUEUE3_DUMMY_REG
#define SDMA0_QUEUE3_DUMMY_REG__DUMMY__SHIFT                                                                  0x0
#define SDMA0_QUEUE3_DUMMY_REG__DUMMY_MASK                                                                    0xFFFFFFFFL
//SDMA0_QUEUE3_RB_WPTR_POLL_ADDR_LO
#define SDMA0_QUEUE3_RB_WPTR_POLL_ADDR_LO__ADDR__SHIFT                                                        0x2
#define SDMA0_QUEUE3_RB_WPTR_POLL_ADDR_LO__ADDR_MASK                                                          0xFFFFFFFCL
//SDMA0_QUEUE3_RB_WPTR_POLL_ADDR_HI
#define SDMA0_QUEUE3_RB_WPTR_POLL_ADDR_HI__ADDR__SHIFT                                                        0x0
#define SDMA0_QUEUE3_RB_WPTR_POLL_ADDR_HI__ADDR_MASK                                                          0xFFFFFFFFL
//SDMA0_QUEUE3_RB_AQL_CNTL
#define SDMA0_QUEUE3_RB_AQL_CNTL__AQL_ENABLE__SHIFT                                                           0x0
#define SDMA0_QUEUE3_RB_AQL_CNTL__AQL_PACKET_SIZE__SHIFT                                                      0x1
#define SDMA0_QUEUE3_RB_AQL_CNTL__PACKET_STEP__SHIFT                                                          0x8
#define SDMA0_QUEUE3_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE__SHIFT                                                0x10
#define SDMA0_QUEUE3_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE__SHIFT                                          0x11
#define SDMA0_QUEUE3_RB_AQL_CNTL__OVERLAP_ENABLE__SHIFT                                                       0x12
#define SDMA0_QUEUE3_RB_AQL_CNTL__AQL_ENABLE_MASK                                                             0x00000001L
#define SDMA0_QUEUE3_RB_AQL_CNTL__AQL_PACKET_SIZE_MASK                                                        0x000000FEL
#define SDMA0_QUEUE3_RB_AQL_CNTL__PACKET_STEP_MASK                                                            0x0000FF00L
#define SDMA0_QUEUE3_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE_MASK                                                  0x00010000L
#define SDMA0_QUEUE3_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE_MASK                                            0x00020000L
#define SDMA0_QUEUE3_RB_AQL_CNTL__OVERLAP_ENABLE_MASK                                                         0x00040000L
//SDMA0_QUEUE3_MINOR_PTR_UPDATE
#define SDMA0_QUEUE3_MINOR_PTR_UPDATE__ENABLE__SHIFT                                                          0x0
#define SDMA0_QUEUE3_MINOR_PTR_UPDATE__ENABLE_MASK                                                            0x00000001L
//SDMA0_QUEUE3_CONTEXT_SWITCH_STATUS
#define SDMA0_QUEUE3_CONTEXT_SWITCH_STATUS__RB_PREEMPT_STATUS__SHIFT                                          0x0
#define SDMA0_QUEUE3_CONTEXT_SWITCH_STATUS__VM_HOLE_EXCEPTION__SHIFT                                          0x1
#define SDMA0_QUEUE3_CONTEXT_SWITCH_STATUS__PAGE_EXCEPTION__SHIFT                                             0x2
#define SDMA0_QUEUE3_CONTEXT_SWITCH_STATUS__QUEUE_HANG_EXCEPTION__SHIFT                                       0x5
#define SDMA0_QUEUE3_CONTEXT_SWITCH_STATUS__DOORBELL_ERROR_EXCEPTION__SHIFT                                   0x6
#define SDMA0_QUEUE3_CONTEXT_SWITCH_STATUS__SRAM_ECC_EXCEPTION__SHIFT                                         0x7
#define SDMA0_QUEUE3_CONTEXT_SWITCH_STATUS__DRAM_ECC_EXCEPTION__SHIFT                                         0x8
#define SDMA0_QUEUE3_CONTEXT_SWITCH_STATUS__WPTR_LT_RPTR_EXCEPTION__SHIFT                                     0x9
#define SDMA0_QUEUE3_CONTEXT_SWITCH_STATUS__RB_PREEMPT_STATUS_MASK                                            0x00000001L
#define SDMA0_QUEUE3_CONTEXT_SWITCH_STATUS__VM_HOLE_EXCEPTION_MASK                                            0x00000002L
#define SDMA0_QUEUE3_CONTEXT_SWITCH_STATUS__PAGE_EXCEPTION_MASK                                               0x00000004L
#define SDMA0_QUEUE3_CONTEXT_SWITCH_STATUS__QUEUE_HANG_EXCEPTION_MASK                                         0x00000020L
#define SDMA0_QUEUE3_CONTEXT_SWITCH_STATUS__DOORBELL_ERROR_EXCEPTION_MASK                                     0x00000040L
#define SDMA0_QUEUE3_CONTEXT_SWITCH_STATUS__SRAM_ECC_EXCEPTION_MASK                                           0x00000080L
#define SDMA0_QUEUE3_CONTEXT_SWITCH_STATUS__DRAM_ECC_EXCEPTION_MASK                                           0x00000100L
#define SDMA0_QUEUE3_CONTEXT_SWITCH_STATUS__WPTR_LT_RPTR_EXCEPTION_MASK                                       0x00000200L
//SDMA0_QUEUE3_MIDCMD_CNTL
#define SDMA0_QUEUE3_MIDCMD_CNTL__DATA_VALID__SHIFT                                                           0x0
#define SDMA0_QUEUE3_MIDCMD_CNTL__COPY_MODE__SHIFT                                                            0x1
#define SDMA0_QUEUE3_MIDCMD_CNTL__SPLIT_STATE__SHIFT                                                          0x4
#define SDMA0_QUEUE3_MIDCMD_CNTL__ALLOW_PREEMPT__SHIFT                                                        0x8
#define SDMA0_QUEUE3_MIDCMD_CNTL__DATA_VALID_MASK                                                             0x00000001L
#define SDMA0_QUEUE3_MIDCMD_CNTL__COPY_MODE_MASK                                                              0x00000002L
#define SDMA0_QUEUE3_MIDCMD_CNTL__SPLIT_STATE_MASK                                                            0x000000F0L
#define SDMA0_QUEUE3_MIDCMD_CNTL__ALLOW_PREEMPT_MASK                                                          0x00000100L
//SDMA0_QUEUE3_MIDCMD_DATA0
#define SDMA0_QUEUE3_MIDCMD_DATA0__DATA0__SHIFT                                                               0x0
#define SDMA0_QUEUE3_MIDCMD_DATA0__DATA0_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE3_MIDCMD_DATA1
#define SDMA0_QUEUE3_MIDCMD_DATA1__DATA1__SHIFT                                                               0x0
#define SDMA0_QUEUE3_MIDCMD_DATA1__DATA1_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE3_MIDCMD_DATA2
#define SDMA0_QUEUE3_MIDCMD_DATA2__DATA2__SHIFT                                                               0x0
#define SDMA0_QUEUE3_MIDCMD_DATA2__DATA2_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE3_MIDCMD_DATA3
#define SDMA0_QUEUE3_MIDCMD_DATA3__DATA3__SHIFT                                                               0x0
#define SDMA0_QUEUE3_MIDCMD_DATA3__DATA3_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE3_MIDCMD_DATA4
#define SDMA0_QUEUE3_MIDCMD_DATA4__DATA4__SHIFT                                                               0x0
#define SDMA0_QUEUE3_MIDCMD_DATA4__DATA4_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE3_MIDCMD_DATA5
#define SDMA0_QUEUE3_MIDCMD_DATA5__DATA5__SHIFT                                                               0x0
#define SDMA0_QUEUE3_MIDCMD_DATA5__DATA5_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE3_MIDCMD_DATA6
#define SDMA0_QUEUE3_MIDCMD_DATA6__DATA6__SHIFT                                                               0x0
#define SDMA0_QUEUE3_MIDCMD_DATA6__DATA6_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE3_MIDCMD_DATA7
#define SDMA0_QUEUE3_MIDCMD_DATA7__DATA7__SHIFT                                                               0x0
#define SDMA0_QUEUE3_MIDCMD_DATA7__DATA7_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE3_MIDCMD_DATA8
#define SDMA0_QUEUE3_MIDCMD_DATA8__DATA8__SHIFT                                                               0x0
#define SDMA0_QUEUE3_MIDCMD_DATA8__DATA8_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE3_MIDCMD_DATA9
#define SDMA0_QUEUE3_MIDCMD_DATA9__DATA9__SHIFT                                                               0x0
#define SDMA0_QUEUE3_MIDCMD_DATA9__DATA9_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE3_MIDCMD_DATA10
#define SDMA0_QUEUE3_MIDCMD_DATA10__DATA10__SHIFT                                                             0x0
#define SDMA0_QUEUE3_MIDCMD_DATA10__DATA10_MASK                                                               0xFFFFFFFFL
//SDMA0_QUEUE3_WAIT_UNSATISFIED_THD
#define SDMA0_QUEUE3_WAIT_UNSATISFIED_THD__THRESHOLD__SHIFT                                                   0x0
#define SDMA0_QUEUE3_WAIT_UNSATISFIED_THD__THRESHOLD_MASK                                                     0x0000001FL
//SDMA0_QUEUE3_MQD_BASE_ADDR_LO
#define SDMA0_QUEUE3_MQD_BASE_ADDR_LO__BASE_ADDR_LO__SHIFT                                                    0x2
#define SDMA0_QUEUE3_MQD_BASE_ADDR_LO__BASE_ADDR_LO_MASK                                                      0xFFFFFFFCL
//SDMA0_QUEUE3_MQD_BASE_ADDR_HI
#define SDMA0_QUEUE3_MQD_BASE_ADDR_HI__BASE_ADDR_HI__SHIFT                                                    0x0
#define SDMA0_QUEUE3_MQD_BASE_ADDR_HI__BASE_ADDR_HI_MASK                                                      0xFFFFFFFFL
//SDMA0_QUEUE3_MQD_CONTROL
#define SDMA0_QUEUE3_MQD_CONTROL__VMID__SHIFT                                                                 0x0
#define SDMA0_QUEUE3_MQD_CONTROL__VMID_MASK                                                                   0x0000000FL
//SDMA0_QUEUE3_DEQUEUE_REQUEST
#define SDMA0_QUEUE3_DEQUEUE_REQUEST__DEQUEUE_REQ__SHIFT                                                      0x0
#define SDMA0_QUEUE3_DEQUEUE_REQUEST__DEQUEUE_REQ_MASK                                                        0x00000001L
//SDMA0_QUEUE3_CONTEXT_STATUS
#define SDMA0_QUEUE3_CONTEXT_STATUS__SELECTED__SHIFT                                                          0x0
#define SDMA0_QUEUE3_CONTEXT_STATUS__USE_IB__SHIFT                                                            0x1
#define SDMA0_QUEUE3_CONTEXT_STATUS__IDLE__SHIFT                                                              0x2
#define SDMA0_QUEUE3_CONTEXT_STATUS__EXPIRED__SHIFT                                                           0x3
#define SDMA0_QUEUE3_CONTEXT_STATUS__EXCEPTION__SHIFT                                                         0x4
#define SDMA0_QUEUE3_CONTEXT_STATUS__CTXSW_ABLE__SHIFT                                                        0x7
#define SDMA0_QUEUE3_CONTEXT_STATUS__VF_STATUS__SHIFT                                                         0x8
#define SDMA0_QUEUE3_CONTEXT_STATUS__PRIV_EXCEPTION__SHIFT                                                    0x9
#define SDMA0_QUEUE3_CONTEXT_STATUS__PREEMPT_DISABLE__SHIFT                                                   0xa
#define SDMA0_QUEUE3_CONTEXT_STATUS__RPTR_WB_IDLE__SHIFT                                                      0xb
#define SDMA0_QUEUE3_CONTEXT_STATUS__WPTR_UPDATE_PENDING__SHIFT                                               0xc
#define SDMA0_QUEUE3_CONTEXT_STATUS__WPTR_UPDATE_FAIL_COUNT__SHIFT                                            0x10
#define SDMA0_QUEUE3_CONTEXT_STATUS__SELECTED_MASK                                                            0x00000001L
#define SDMA0_QUEUE3_CONTEXT_STATUS__USE_IB_MASK                                                              0x00000002L
#define SDMA0_QUEUE3_CONTEXT_STATUS__IDLE_MASK                                                                0x00000004L
#define SDMA0_QUEUE3_CONTEXT_STATUS__EXPIRED_MASK                                                             0x00000008L
#define SDMA0_QUEUE3_CONTEXT_STATUS__EXCEPTION_MASK                                                           0x00000070L
#define SDMA0_QUEUE3_CONTEXT_STATUS__CTXSW_ABLE_MASK                                                          0x00000080L
#define SDMA0_QUEUE3_CONTEXT_STATUS__VF_STATUS_MASK                                                           0x00000100L
#define SDMA0_QUEUE3_CONTEXT_STATUS__PRIV_EXCEPTION_MASK                                                      0x00000200L
#define SDMA0_QUEUE3_CONTEXT_STATUS__PREEMPT_DISABLE_MASK                                                     0x00000400L
#define SDMA0_QUEUE3_CONTEXT_STATUS__RPTR_WB_IDLE_MASK                                                        0x00000800L
#define SDMA0_QUEUE3_CONTEXT_STATUS__WPTR_UPDATE_PENDING_MASK                                                 0x00001000L
#define SDMA0_QUEUE3_CONTEXT_STATUS__WPTR_UPDATE_FAIL_COUNT_MASK                                              0x00FF0000L
//SDMA0_QUEUE4_RB_CNTL
#define SDMA0_QUEUE4_RB_CNTL__RB_ENABLE__SHIFT                                                                0x0
#define SDMA0_QUEUE4_RB_CNTL__RB_SIZE__SHIFT                                                                  0x1
#define SDMA0_QUEUE4_RB_CNTL__WPTR_POLL_ENABLE__SHIFT                                                         0x8
#define SDMA0_QUEUE4_RB_CNTL__RB_SWAP_ENABLE__SHIFT                                                           0x9
#define SDMA0_QUEUE4_RB_CNTL__WPTR_POLL_SWAP_ENABLE__SHIFT                                                    0xa
#define SDMA0_QUEUE4_RB_CNTL__MCU_WPTR_POLL_ENABLE__SHIFT                                                     0xb
#define SDMA0_QUEUE4_RB_CNTL__RPTR_WRITEBACK_ENABLE__SHIFT                                                    0xc
#define SDMA0_QUEUE4_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE__SHIFT                                               0xd
#define SDMA0_QUEUE4_RB_CNTL__RPTR_WRITEBACK_TIMER__SHIFT                                                     0x10
#define SDMA0_QUEUE4_RB_CNTL__RB_PRIV__SHIFT                                                                  0x17
#define SDMA0_QUEUE4_RB_CNTL__RB_VMID__SHIFT                                                                  0x18
#define SDMA0_QUEUE4_RB_CNTL__RB_ENABLE_MASK                                                                  0x00000001L
#define SDMA0_QUEUE4_RB_CNTL__RB_SIZE_MASK                                                                    0x0000003EL
#define SDMA0_QUEUE4_RB_CNTL__WPTR_POLL_ENABLE_MASK                                                           0x00000100L
#define SDMA0_QUEUE4_RB_CNTL__RB_SWAP_ENABLE_MASK                                                             0x00000200L
#define SDMA0_QUEUE4_RB_CNTL__WPTR_POLL_SWAP_ENABLE_MASK                                                      0x00000400L
#define SDMA0_QUEUE4_RB_CNTL__MCU_WPTR_POLL_ENABLE_MASK                                                       0x00000800L
#define SDMA0_QUEUE4_RB_CNTL__RPTR_WRITEBACK_ENABLE_MASK                                                      0x00001000L
#define SDMA0_QUEUE4_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE_MASK                                                 0x00002000L
#define SDMA0_QUEUE4_RB_CNTL__RPTR_WRITEBACK_TIMER_MASK                                                       0x001F0000L
#define SDMA0_QUEUE4_RB_CNTL__RB_PRIV_MASK                                                                    0x00800000L
#define SDMA0_QUEUE4_RB_CNTL__RB_VMID_MASK                                                                    0x0F000000L
//SDMA0_QUEUE4_RB_BASE
#define SDMA0_QUEUE4_RB_BASE__ADDR__SHIFT                                                                     0x0
#define SDMA0_QUEUE4_RB_BASE__ADDR_MASK                                                                       0xFFFFFFFFL
//SDMA0_QUEUE4_RB_BASE_HI
#define SDMA0_QUEUE4_RB_BASE_HI__ADDR__SHIFT                                                                  0x0
#define SDMA0_QUEUE4_RB_BASE_HI__ADDR_MASK                                                                    0x00FFFFFFL
//SDMA0_QUEUE4_RB_RPTR
#define SDMA0_QUEUE4_RB_RPTR__OFFSET__SHIFT                                                                   0x0
#define SDMA0_QUEUE4_RB_RPTR__OFFSET_MASK                                                                     0xFFFFFFFFL
//SDMA0_QUEUE4_RB_RPTR_HI
#define SDMA0_QUEUE4_RB_RPTR_HI__OFFSET__SHIFT                                                                0x0
#define SDMA0_QUEUE4_RB_RPTR_HI__OFFSET_MASK                                                                  0xFFFFFFFFL
//SDMA0_QUEUE4_RB_WPTR
#define SDMA0_QUEUE4_RB_WPTR__OFFSET__SHIFT                                                                   0x0
#define SDMA0_QUEUE4_RB_WPTR__OFFSET_MASK                                                                     0xFFFFFFFFL
//SDMA0_QUEUE4_RB_WPTR_HI
#define SDMA0_QUEUE4_RB_WPTR_HI__OFFSET__SHIFT                                                                0x0
#define SDMA0_QUEUE4_RB_WPTR_HI__OFFSET_MASK                                                                  0xFFFFFFFFL
//SDMA0_QUEUE4_RB_RPTR_ADDR_LO
#define SDMA0_QUEUE4_RB_RPTR_ADDR_LO__ADDR__SHIFT                                                             0x2
#define SDMA0_QUEUE4_RB_RPTR_ADDR_LO__ADDR_MASK                                                               0xFFFFFFFCL
//SDMA0_QUEUE4_RB_RPTR_ADDR_HI
#define SDMA0_QUEUE4_RB_RPTR_ADDR_HI__ADDR__SHIFT                                                             0x0
#define SDMA0_QUEUE4_RB_RPTR_ADDR_HI__ADDR_MASK                                                               0xFFFFFFFFL
//SDMA0_QUEUE4_IB_CNTL
#define SDMA0_QUEUE4_IB_CNTL__IB_ENABLE__SHIFT                                                                0x0
#define SDMA0_QUEUE4_IB_CNTL__IB_SWAP_ENABLE__SHIFT                                                           0x4
#define SDMA0_QUEUE4_IB_CNTL__SWITCH_INSIDE_IB__SHIFT                                                         0x8
#define SDMA0_QUEUE4_IB_CNTL__CMD_VMID__SHIFT                                                                 0x10
#define SDMA0_QUEUE4_IB_CNTL__IB_ENABLE_MASK                                                                  0x00000001L
#define SDMA0_QUEUE4_IB_CNTL__IB_SWAP_ENABLE_MASK                                                             0x00000010L
#define SDMA0_QUEUE4_IB_CNTL__SWITCH_INSIDE_IB_MASK                                                           0x00000100L
#define SDMA0_QUEUE4_IB_CNTL__CMD_VMID_MASK                                                                   0x000F0000L
//SDMA0_QUEUE4_IB_RPTR
#define SDMA0_QUEUE4_IB_RPTR__OFFSET__SHIFT                                                                   0x2
#define SDMA0_QUEUE4_IB_RPTR__OFFSET_MASK                                                                     0x003FFFFCL
//SDMA0_QUEUE4_IB_OFFSET
#define SDMA0_QUEUE4_IB_OFFSET__OFFSET__SHIFT                                                                 0x2
#define SDMA0_QUEUE4_IB_OFFSET__OFFSET_MASK                                                                   0x003FFFFCL
//SDMA0_QUEUE4_IB_BASE_LO
#define SDMA0_QUEUE4_IB_BASE_LO__ADDR__SHIFT                                                                  0x2
#define SDMA0_QUEUE4_IB_BASE_LO__ADDR_MASK                                                                    0xFFFFFFFCL
//SDMA0_QUEUE4_IB_BASE_HI
#define SDMA0_QUEUE4_IB_BASE_HI__ADDR__SHIFT                                                                  0x0
#define SDMA0_QUEUE4_IB_BASE_HI__ADDR_MASK                                                                    0xFFFFFFFFL
//SDMA0_QUEUE4_IB_SIZE
#define SDMA0_QUEUE4_IB_SIZE__SIZE__SHIFT                                                                     0x0
#define SDMA0_QUEUE4_IB_SIZE__SIZE_MASK                                                                       0x000FFFFFL
//SDMA0_QUEUE4_DOORBELL
#define SDMA0_QUEUE4_DOORBELL__ENABLE__SHIFT                                                                  0x1c
#define SDMA0_QUEUE4_DOORBELL__CAPTURED__SHIFT                                                                0x1e
#define SDMA0_QUEUE4_DOORBELL__ENABLE_MASK                                                                    0x10000000L
#define SDMA0_QUEUE4_DOORBELL__CAPTURED_MASK                                                                  0x40000000L
//SDMA0_QUEUE4_DOORBELL_LOG
#define SDMA0_QUEUE4_DOORBELL_LOG__BE_ERROR__SHIFT                                                            0x0
#define SDMA0_QUEUE4_DOORBELL_LOG__DATA__SHIFT                                                                0x2
#define SDMA0_QUEUE4_DOORBELL_LOG__BE_ERROR_MASK                                                              0x00000001L
#define SDMA0_QUEUE4_DOORBELL_LOG__DATA_MASK                                                                  0xFFFFFFFCL
//SDMA0_QUEUE4_DOORBELL_OFFSET
#define SDMA0_QUEUE4_DOORBELL_OFFSET__OFFSET__SHIFT                                                           0x2
#define SDMA0_QUEUE4_DOORBELL_OFFSET__OFFSET_MASK                                                             0x0FFFFFFCL
//SDMA0_QUEUE4_CSA_ADDR_LO
#define SDMA0_QUEUE4_CSA_ADDR_LO__ADDR__SHIFT                                                                 0x2
#define SDMA0_QUEUE4_CSA_ADDR_LO__ADDR_MASK                                                                   0xFFFFFFFCL
//SDMA0_QUEUE4_CSA_ADDR_HI
#define SDMA0_QUEUE4_CSA_ADDR_HI__ADDR__SHIFT                                                                 0x0
#define SDMA0_QUEUE4_CSA_ADDR_HI__ADDR_MASK                                                                   0xFFFFFFFFL
//SDMA0_QUEUE4_SCHEDULE_CNTL
#define SDMA0_QUEUE4_SCHEDULE_CNTL__GLOBAL_ID__SHIFT                                                          0x0
#define SDMA0_QUEUE4_SCHEDULE_CNTL__PROCESS_ID__SHIFT                                                         0x2
#define SDMA0_QUEUE4_SCHEDULE_CNTL__LOCAL_ID__SHIFT                                                           0x6
#define SDMA0_QUEUE4_SCHEDULE_CNTL__CONTEXT_QUANTUM__SHIFT                                                    0x8
#define SDMA0_QUEUE4_SCHEDULE_CNTL__GLOBAL_ID_MASK                                                            0x00000003L
#define SDMA0_QUEUE4_SCHEDULE_CNTL__PROCESS_ID_MASK                                                           0x0000001CL
#define SDMA0_QUEUE4_SCHEDULE_CNTL__LOCAL_ID_MASK                                                             0x000000C0L
#define SDMA0_QUEUE4_SCHEDULE_CNTL__CONTEXT_QUANTUM_MASK                                                      0x0000FF00L
//SDMA0_QUEUE4_IB_SUB_REMAIN
#define SDMA0_QUEUE4_IB_SUB_REMAIN__SIZE__SHIFT                                                               0x0
#define SDMA0_QUEUE4_IB_SUB_REMAIN__SIZE_MASK                                                                 0x00003FFFL
//SDMA0_QUEUE4_PREEMPT
#define SDMA0_QUEUE4_PREEMPT__IB_PREEMPT__SHIFT                                                               0x0
#define SDMA0_QUEUE4_PREEMPT__IB_PREEMPT_MASK                                                                 0x00000001L
//SDMA0_QUEUE4_DUMMY_REG
#define SDMA0_QUEUE4_DUMMY_REG__DUMMY__SHIFT                                                                  0x0
#define SDMA0_QUEUE4_DUMMY_REG__DUMMY_MASK                                                                    0xFFFFFFFFL
//SDMA0_QUEUE4_RB_WPTR_POLL_ADDR_LO
#define SDMA0_QUEUE4_RB_WPTR_POLL_ADDR_LO__ADDR__SHIFT                                                        0x2
#define SDMA0_QUEUE4_RB_WPTR_POLL_ADDR_LO__ADDR_MASK                                                          0xFFFFFFFCL
//SDMA0_QUEUE4_RB_WPTR_POLL_ADDR_HI
#define SDMA0_QUEUE4_RB_WPTR_POLL_ADDR_HI__ADDR__SHIFT                                                        0x0
#define SDMA0_QUEUE4_RB_WPTR_POLL_ADDR_HI__ADDR_MASK                                                          0xFFFFFFFFL
//SDMA0_QUEUE4_RB_AQL_CNTL
#define SDMA0_QUEUE4_RB_AQL_CNTL__AQL_ENABLE__SHIFT                                                           0x0
#define SDMA0_QUEUE4_RB_AQL_CNTL__AQL_PACKET_SIZE__SHIFT                                                      0x1
#define SDMA0_QUEUE4_RB_AQL_CNTL__PACKET_STEP__SHIFT                                                          0x8
#define SDMA0_QUEUE4_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE__SHIFT                                                0x10
#define SDMA0_QUEUE4_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE__SHIFT                                          0x11
#define SDMA0_QUEUE4_RB_AQL_CNTL__OVERLAP_ENABLE__SHIFT                                                       0x12
#define SDMA0_QUEUE4_RB_AQL_CNTL__AQL_ENABLE_MASK                                                             0x00000001L
#define SDMA0_QUEUE4_RB_AQL_CNTL__AQL_PACKET_SIZE_MASK                                                        0x000000FEL
#define SDMA0_QUEUE4_RB_AQL_CNTL__PACKET_STEP_MASK                                                            0x0000FF00L
#define SDMA0_QUEUE4_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE_MASK                                                  0x00010000L
#define SDMA0_QUEUE4_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE_MASK                                            0x00020000L
#define SDMA0_QUEUE4_RB_AQL_CNTL__OVERLAP_ENABLE_MASK                                                         0x00040000L
//SDMA0_QUEUE4_MINOR_PTR_UPDATE
#define SDMA0_QUEUE4_MINOR_PTR_UPDATE__ENABLE__SHIFT                                                          0x0
#define SDMA0_QUEUE4_MINOR_PTR_UPDATE__ENABLE_MASK                                                            0x00000001L
//SDMA0_QUEUE4_CONTEXT_SWITCH_STATUS
#define SDMA0_QUEUE4_CONTEXT_SWITCH_STATUS__RB_PREEMPT_STATUS__SHIFT                                          0x0
#define SDMA0_QUEUE4_CONTEXT_SWITCH_STATUS__VM_HOLE_EXCEPTION__SHIFT                                          0x1
#define SDMA0_QUEUE4_CONTEXT_SWITCH_STATUS__PAGE_EXCEPTION__SHIFT                                             0x2
#define SDMA0_QUEUE4_CONTEXT_SWITCH_STATUS__QUEUE_HANG_EXCEPTION__SHIFT                                       0x5
#define SDMA0_QUEUE4_CONTEXT_SWITCH_STATUS__DOORBELL_ERROR_EXCEPTION__SHIFT                                   0x6
#define SDMA0_QUEUE4_CONTEXT_SWITCH_STATUS__SRAM_ECC_EXCEPTION__SHIFT                                         0x7
#define SDMA0_QUEUE4_CONTEXT_SWITCH_STATUS__DRAM_ECC_EXCEPTION__SHIFT                                         0x8
#define SDMA0_QUEUE4_CONTEXT_SWITCH_STATUS__WPTR_LT_RPTR_EXCEPTION__SHIFT                                     0x9
#define SDMA0_QUEUE4_CONTEXT_SWITCH_STATUS__RB_PREEMPT_STATUS_MASK                                            0x00000001L
#define SDMA0_QUEUE4_CONTEXT_SWITCH_STATUS__VM_HOLE_EXCEPTION_MASK                                            0x00000002L
#define SDMA0_QUEUE4_CONTEXT_SWITCH_STATUS__PAGE_EXCEPTION_MASK                                               0x00000004L
#define SDMA0_QUEUE4_CONTEXT_SWITCH_STATUS__QUEUE_HANG_EXCEPTION_MASK                                         0x00000020L
#define SDMA0_QUEUE4_CONTEXT_SWITCH_STATUS__DOORBELL_ERROR_EXCEPTION_MASK                                     0x00000040L
#define SDMA0_QUEUE4_CONTEXT_SWITCH_STATUS__SRAM_ECC_EXCEPTION_MASK                                           0x00000080L
#define SDMA0_QUEUE4_CONTEXT_SWITCH_STATUS__DRAM_ECC_EXCEPTION_MASK                                           0x00000100L
#define SDMA0_QUEUE4_CONTEXT_SWITCH_STATUS__WPTR_LT_RPTR_EXCEPTION_MASK                                       0x00000200L
//SDMA0_QUEUE4_MIDCMD_CNTL
#define SDMA0_QUEUE4_MIDCMD_CNTL__DATA_VALID__SHIFT                                                           0x0
#define SDMA0_QUEUE4_MIDCMD_CNTL__COPY_MODE__SHIFT                                                            0x1
#define SDMA0_QUEUE4_MIDCMD_CNTL__SPLIT_STATE__SHIFT                                                          0x4
#define SDMA0_QUEUE4_MIDCMD_CNTL__ALLOW_PREEMPT__SHIFT                                                        0x8
#define SDMA0_QUEUE4_MIDCMD_CNTL__DATA_VALID_MASK                                                             0x00000001L
#define SDMA0_QUEUE4_MIDCMD_CNTL__COPY_MODE_MASK                                                              0x00000002L
#define SDMA0_QUEUE4_MIDCMD_CNTL__SPLIT_STATE_MASK                                                            0x000000F0L
#define SDMA0_QUEUE4_MIDCMD_CNTL__ALLOW_PREEMPT_MASK                                                          0x00000100L
//SDMA0_QUEUE4_MIDCMD_DATA0
#define SDMA0_QUEUE4_MIDCMD_DATA0__DATA0__SHIFT                                                               0x0
#define SDMA0_QUEUE4_MIDCMD_DATA0__DATA0_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE4_MIDCMD_DATA1
#define SDMA0_QUEUE4_MIDCMD_DATA1__DATA1__SHIFT                                                               0x0
#define SDMA0_QUEUE4_MIDCMD_DATA1__DATA1_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE4_MIDCMD_DATA2
#define SDMA0_QUEUE4_MIDCMD_DATA2__DATA2__SHIFT                                                               0x0
#define SDMA0_QUEUE4_MIDCMD_DATA2__DATA2_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE4_MIDCMD_DATA3
#define SDMA0_QUEUE4_MIDCMD_DATA3__DATA3__SHIFT                                                               0x0
#define SDMA0_QUEUE4_MIDCMD_DATA3__DATA3_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE4_MIDCMD_DATA4
#define SDMA0_QUEUE4_MIDCMD_DATA4__DATA4__SHIFT                                                               0x0
#define SDMA0_QUEUE4_MIDCMD_DATA4__DATA4_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE4_MIDCMD_DATA5
#define SDMA0_QUEUE4_MIDCMD_DATA5__DATA5__SHIFT                                                               0x0
#define SDMA0_QUEUE4_MIDCMD_DATA5__DATA5_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE4_MIDCMD_DATA6
#define SDMA0_QUEUE4_MIDCMD_DATA6__DATA6__SHIFT                                                               0x0
#define SDMA0_QUEUE4_MIDCMD_DATA6__DATA6_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE4_MIDCMD_DATA7
#define SDMA0_QUEUE4_MIDCMD_DATA7__DATA7__SHIFT                                                               0x0
#define SDMA0_QUEUE4_MIDCMD_DATA7__DATA7_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE4_MIDCMD_DATA8
#define SDMA0_QUEUE4_MIDCMD_DATA8__DATA8__SHIFT                                                               0x0
#define SDMA0_QUEUE4_MIDCMD_DATA8__DATA8_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE4_MIDCMD_DATA9
#define SDMA0_QUEUE4_MIDCMD_DATA9__DATA9__SHIFT                                                               0x0
#define SDMA0_QUEUE4_MIDCMD_DATA9__DATA9_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE4_MIDCMD_DATA10
#define SDMA0_QUEUE4_MIDCMD_DATA10__DATA10__SHIFT                                                             0x0
#define SDMA0_QUEUE4_MIDCMD_DATA10__DATA10_MASK                                                               0xFFFFFFFFL
//SDMA0_QUEUE4_WAIT_UNSATISFIED_THD
#define SDMA0_QUEUE4_WAIT_UNSATISFIED_THD__THRESHOLD__SHIFT                                                   0x0
#define SDMA0_QUEUE4_WAIT_UNSATISFIED_THD__THRESHOLD_MASK                                                     0x0000001FL
//SDMA0_QUEUE4_MQD_BASE_ADDR_LO
#define SDMA0_QUEUE4_MQD_BASE_ADDR_LO__BASE_ADDR_LO__SHIFT                                                    0x2
#define SDMA0_QUEUE4_MQD_BASE_ADDR_LO__BASE_ADDR_LO_MASK                                                      0xFFFFFFFCL
//SDMA0_QUEUE4_MQD_BASE_ADDR_HI
#define SDMA0_QUEUE4_MQD_BASE_ADDR_HI__BASE_ADDR_HI__SHIFT                                                    0x0
#define SDMA0_QUEUE4_MQD_BASE_ADDR_HI__BASE_ADDR_HI_MASK                                                      0xFFFFFFFFL
//SDMA0_QUEUE4_MQD_CONTROL
#define SDMA0_QUEUE4_MQD_CONTROL__VMID__SHIFT                                                                 0x0
#define SDMA0_QUEUE4_MQD_CONTROL__VMID_MASK                                                                   0x0000000FL
//SDMA0_QUEUE4_DEQUEUE_REQUEST
#define SDMA0_QUEUE4_DEQUEUE_REQUEST__DEQUEUE_REQ__SHIFT                                                      0x0
#define SDMA0_QUEUE4_DEQUEUE_REQUEST__DEQUEUE_REQ_MASK                                                        0x00000001L
//SDMA0_QUEUE4_CONTEXT_STATUS
#define SDMA0_QUEUE4_CONTEXT_STATUS__SELECTED__SHIFT                                                          0x0
#define SDMA0_QUEUE4_CONTEXT_STATUS__USE_IB__SHIFT                                                            0x1
#define SDMA0_QUEUE4_CONTEXT_STATUS__IDLE__SHIFT                                                              0x2
#define SDMA0_QUEUE4_CONTEXT_STATUS__EXPIRED__SHIFT                                                           0x3
#define SDMA0_QUEUE4_CONTEXT_STATUS__EXCEPTION__SHIFT                                                         0x4
#define SDMA0_QUEUE4_CONTEXT_STATUS__CTXSW_ABLE__SHIFT                                                        0x7
#define SDMA0_QUEUE4_CONTEXT_STATUS__VF_STATUS__SHIFT                                                         0x8
#define SDMA0_QUEUE4_CONTEXT_STATUS__PRIV_EXCEPTION__SHIFT                                                    0x9
#define SDMA0_QUEUE4_CONTEXT_STATUS__PREEMPT_DISABLE__SHIFT                                                   0xa
#define SDMA0_QUEUE4_CONTEXT_STATUS__RPTR_WB_IDLE__SHIFT                                                      0xb
#define SDMA0_QUEUE4_CONTEXT_STATUS__WPTR_UPDATE_PENDING__SHIFT                                               0xc
#define SDMA0_QUEUE4_CONTEXT_STATUS__WPTR_UPDATE_FAIL_COUNT__SHIFT                                            0x10
#define SDMA0_QUEUE4_CONTEXT_STATUS__SELECTED_MASK                                                            0x00000001L
#define SDMA0_QUEUE4_CONTEXT_STATUS__USE_IB_MASK                                                              0x00000002L
#define SDMA0_QUEUE4_CONTEXT_STATUS__IDLE_MASK                                                                0x00000004L
#define SDMA0_QUEUE4_CONTEXT_STATUS__EXPIRED_MASK                                                             0x00000008L
#define SDMA0_QUEUE4_CONTEXT_STATUS__EXCEPTION_MASK                                                           0x00000070L
#define SDMA0_QUEUE4_CONTEXT_STATUS__CTXSW_ABLE_MASK                                                          0x00000080L
#define SDMA0_QUEUE4_CONTEXT_STATUS__VF_STATUS_MASK                                                           0x00000100L
#define SDMA0_QUEUE4_CONTEXT_STATUS__PRIV_EXCEPTION_MASK                                                      0x00000200L
#define SDMA0_QUEUE4_CONTEXT_STATUS__PREEMPT_DISABLE_MASK                                                     0x00000400L
#define SDMA0_QUEUE4_CONTEXT_STATUS__RPTR_WB_IDLE_MASK                                                        0x00000800L
#define SDMA0_QUEUE4_CONTEXT_STATUS__WPTR_UPDATE_PENDING_MASK                                                 0x00001000L
#define SDMA0_QUEUE4_CONTEXT_STATUS__WPTR_UPDATE_FAIL_COUNT_MASK                                              0x00FF0000L
//SDMA0_QUEUE5_RB_CNTL
#define SDMA0_QUEUE5_RB_CNTL__RB_ENABLE__SHIFT                                                                0x0
#define SDMA0_QUEUE5_RB_CNTL__RB_SIZE__SHIFT                                                                  0x1
#define SDMA0_QUEUE5_RB_CNTL__WPTR_POLL_ENABLE__SHIFT                                                         0x8
#define SDMA0_QUEUE5_RB_CNTL__RB_SWAP_ENABLE__SHIFT                                                           0x9
#define SDMA0_QUEUE5_RB_CNTL__WPTR_POLL_SWAP_ENABLE__SHIFT                                                    0xa
#define SDMA0_QUEUE5_RB_CNTL__MCU_WPTR_POLL_ENABLE__SHIFT                                                     0xb
#define SDMA0_QUEUE5_RB_CNTL__RPTR_WRITEBACK_ENABLE__SHIFT                                                    0xc
#define SDMA0_QUEUE5_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE__SHIFT                                               0xd
#define SDMA0_QUEUE5_RB_CNTL__RPTR_WRITEBACK_TIMER__SHIFT                                                     0x10
#define SDMA0_QUEUE5_RB_CNTL__RB_PRIV__SHIFT                                                                  0x17
#define SDMA0_QUEUE5_RB_CNTL__RB_VMID__SHIFT                                                                  0x18
#define SDMA0_QUEUE5_RB_CNTL__RB_ENABLE_MASK                                                                  0x00000001L
#define SDMA0_QUEUE5_RB_CNTL__RB_SIZE_MASK                                                                    0x0000003EL
#define SDMA0_QUEUE5_RB_CNTL__WPTR_POLL_ENABLE_MASK                                                           0x00000100L
#define SDMA0_QUEUE5_RB_CNTL__RB_SWAP_ENABLE_MASK                                                             0x00000200L
#define SDMA0_QUEUE5_RB_CNTL__WPTR_POLL_SWAP_ENABLE_MASK                                                      0x00000400L
#define SDMA0_QUEUE5_RB_CNTL__MCU_WPTR_POLL_ENABLE_MASK                                                       0x00000800L
#define SDMA0_QUEUE5_RB_CNTL__RPTR_WRITEBACK_ENABLE_MASK                                                      0x00001000L
#define SDMA0_QUEUE5_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE_MASK                                                 0x00002000L
#define SDMA0_QUEUE5_RB_CNTL__RPTR_WRITEBACK_TIMER_MASK                                                       0x001F0000L
#define SDMA0_QUEUE5_RB_CNTL__RB_PRIV_MASK                                                                    0x00800000L
#define SDMA0_QUEUE5_RB_CNTL__RB_VMID_MASK                                                                    0x0F000000L
//SDMA0_QUEUE5_RB_BASE
#define SDMA0_QUEUE5_RB_BASE__ADDR__SHIFT                                                                     0x0
#define SDMA0_QUEUE5_RB_BASE__ADDR_MASK                                                                       0xFFFFFFFFL
//SDMA0_QUEUE5_RB_BASE_HI
#define SDMA0_QUEUE5_RB_BASE_HI__ADDR__SHIFT                                                                  0x0
#define SDMA0_QUEUE5_RB_BASE_HI__ADDR_MASK                                                                    0x00FFFFFFL
//SDMA0_QUEUE5_RB_RPTR
#define SDMA0_QUEUE5_RB_RPTR__OFFSET__SHIFT                                                                   0x0
#define SDMA0_QUEUE5_RB_RPTR__OFFSET_MASK                                                                     0xFFFFFFFFL
//SDMA0_QUEUE5_RB_RPTR_HI
#define SDMA0_QUEUE5_RB_RPTR_HI__OFFSET__SHIFT                                                                0x0
#define SDMA0_QUEUE5_RB_RPTR_HI__OFFSET_MASK                                                                  0xFFFFFFFFL
//SDMA0_QUEUE5_RB_WPTR
#define SDMA0_QUEUE5_RB_WPTR__OFFSET__SHIFT                                                                   0x0
#define SDMA0_QUEUE5_RB_WPTR__OFFSET_MASK                                                                     0xFFFFFFFFL
//SDMA0_QUEUE5_RB_WPTR_HI
#define SDMA0_QUEUE5_RB_WPTR_HI__OFFSET__SHIFT                                                                0x0
#define SDMA0_QUEUE5_RB_WPTR_HI__OFFSET_MASK                                                                  0xFFFFFFFFL
//SDMA0_QUEUE5_RB_RPTR_ADDR_LO
#define SDMA0_QUEUE5_RB_RPTR_ADDR_LO__ADDR__SHIFT                                                             0x2
#define SDMA0_QUEUE5_RB_RPTR_ADDR_LO__ADDR_MASK                                                               0xFFFFFFFCL
//SDMA0_QUEUE5_RB_RPTR_ADDR_HI
#define SDMA0_QUEUE5_RB_RPTR_ADDR_HI__ADDR__SHIFT                                                             0x0
#define SDMA0_QUEUE5_RB_RPTR_ADDR_HI__ADDR_MASK                                                               0xFFFFFFFFL
//SDMA0_QUEUE5_IB_CNTL
#define SDMA0_QUEUE5_IB_CNTL__IB_ENABLE__SHIFT                                                                0x0
#define SDMA0_QUEUE5_IB_CNTL__IB_SWAP_ENABLE__SHIFT                                                           0x4
#define SDMA0_QUEUE5_IB_CNTL__SWITCH_INSIDE_IB__SHIFT                                                         0x8
#define SDMA0_QUEUE5_IB_CNTL__CMD_VMID__SHIFT                                                                 0x10
#define SDMA0_QUEUE5_IB_CNTL__IB_ENABLE_MASK                                                                  0x00000001L
#define SDMA0_QUEUE5_IB_CNTL__IB_SWAP_ENABLE_MASK                                                             0x00000010L
#define SDMA0_QUEUE5_IB_CNTL__SWITCH_INSIDE_IB_MASK                                                           0x00000100L
#define SDMA0_QUEUE5_IB_CNTL__CMD_VMID_MASK                                                                   0x000F0000L
//SDMA0_QUEUE5_IB_RPTR
#define SDMA0_QUEUE5_IB_RPTR__OFFSET__SHIFT                                                                   0x2
#define SDMA0_QUEUE5_IB_RPTR__OFFSET_MASK                                                                     0x003FFFFCL
//SDMA0_QUEUE5_IB_OFFSET
#define SDMA0_QUEUE5_IB_OFFSET__OFFSET__SHIFT                                                                 0x2
#define SDMA0_QUEUE5_IB_OFFSET__OFFSET_MASK                                                                   0x003FFFFCL
//SDMA0_QUEUE5_IB_BASE_LO
#define SDMA0_QUEUE5_IB_BASE_LO__ADDR__SHIFT                                                                  0x2
#define SDMA0_QUEUE5_IB_BASE_LO__ADDR_MASK                                                                    0xFFFFFFFCL
//SDMA0_QUEUE5_IB_BASE_HI
#define SDMA0_QUEUE5_IB_BASE_HI__ADDR__SHIFT                                                                  0x0
#define SDMA0_QUEUE5_IB_BASE_HI__ADDR_MASK                                                                    0xFFFFFFFFL
//SDMA0_QUEUE5_IB_SIZE
#define SDMA0_QUEUE5_IB_SIZE__SIZE__SHIFT                                                                     0x0
#define SDMA0_QUEUE5_IB_SIZE__SIZE_MASK                                                                       0x000FFFFFL
//SDMA0_QUEUE5_DOORBELL
#define SDMA0_QUEUE5_DOORBELL__ENABLE__SHIFT                                                                  0x1c
#define SDMA0_QUEUE5_DOORBELL__CAPTURED__SHIFT                                                                0x1e
#define SDMA0_QUEUE5_DOORBELL__ENABLE_MASK                                                                    0x10000000L
#define SDMA0_QUEUE5_DOORBELL__CAPTURED_MASK                                                                  0x40000000L
//SDMA0_QUEUE5_DOORBELL_LOG
#define SDMA0_QUEUE5_DOORBELL_LOG__BE_ERROR__SHIFT                                                            0x0
#define SDMA0_QUEUE5_DOORBELL_LOG__DATA__SHIFT                                                                0x2
#define SDMA0_QUEUE5_DOORBELL_LOG__BE_ERROR_MASK                                                              0x00000001L
#define SDMA0_QUEUE5_DOORBELL_LOG__DATA_MASK                                                                  0xFFFFFFFCL
//SDMA0_QUEUE5_DOORBELL_OFFSET
#define SDMA0_QUEUE5_DOORBELL_OFFSET__OFFSET__SHIFT                                                           0x2
#define SDMA0_QUEUE5_DOORBELL_OFFSET__OFFSET_MASK                                                             0x0FFFFFFCL
//SDMA0_QUEUE5_CSA_ADDR_LO
#define SDMA0_QUEUE5_CSA_ADDR_LO__ADDR__SHIFT                                                                 0x2
#define SDMA0_QUEUE5_CSA_ADDR_LO__ADDR_MASK                                                                   0xFFFFFFFCL
//SDMA0_QUEUE5_CSA_ADDR_HI
#define SDMA0_QUEUE5_CSA_ADDR_HI__ADDR__SHIFT                                                                 0x0
#define SDMA0_QUEUE5_CSA_ADDR_HI__ADDR_MASK                                                                   0xFFFFFFFFL
//SDMA0_QUEUE5_SCHEDULE_CNTL
#define SDMA0_QUEUE5_SCHEDULE_CNTL__GLOBAL_ID__SHIFT                                                          0x0
#define SDMA0_QUEUE5_SCHEDULE_CNTL__PROCESS_ID__SHIFT                                                         0x2
#define SDMA0_QUEUE5_SCHEDULE_CNTL__LOCAL_ID__SHIFT                                                           0x6
#define SDMA0_QUEUE5_SCHEDULE_CNTL__CONTEXT_QUANTUM__SHIFT                                                    0x8
#define SDMA0_QUEUE5_SCHEDULE_CNTL__GLOBAL_ID_MASK                                                            0x00000003L
#define SDMA0_QUEUE5_SCHEDULE_CNTL__PROCESS_ID_MASK                                                           0x0000001CL
#define SDMA0_QUEUE5_SCHEDULE_CNTL__LOCAL_ID_MASK                                                             0x000000C0L
#define SDMA0_QUEUE5_SCHEDULE_CNTL__CONTEXT_QUANTUM_MASK                                                      0x0000FF00L
//SDMA0_QUEUE5_IB_SUB_REMAIN
#define SDMA0_QUEUE5_IB_SUB_REMAIN__SIZE__SHIFT                                                               0x0
#define SDMA0_QUEUE5_IB_SUB_REMAIN__SIZE_MASK                                                                 0x00003FFFL
//SDMA0_QUEUE5_PREEMPT
#define SDMA0_QUEUE5_PREEMPT__IB_PREEMPT__SHIFT                                                               0x0
#define SDMA0_QUEUE5_PREEMPT__IB_PREEMPT_MASK                                                                 0x00000001L
//SDMA0_QUEUE5_DUMMY_REG
#define SDMA0_QUEUE5_DUMMY_REG__DUMMY__SHIFT                                                                  0x0
#define SDMA0_QUEUE5_DUMMY_REG__DUMMY_MASK                                                                    0xFFFFFFFFL
//SDMA0_QUEUE5_RB_WPTR_POLL_ADDR_LO
#define SDMA0_QUEUE5_RB_WPTR_POLL_ADDR_LO__ADDR__SHIFT                                                        0x2
#define SDMA0_QUEUE5_RB_WPTR_POLL_ADDR_LO__ADDR_MASK                                                          0xFFFFFFFCL
//SDMA0_QUEUE5_RB_WPTR_POLL_ADDR_HI
#define SDMA0_QUEUE5_RB_WPTR_POLL_ADDR_HI__ADDR__SHIFT                                                        0x0
#define SDMA0_QUEUE5_RB_WPTR_POLL_ADDR_HI__ADDR_MASK                                                          0xFFFFFFFFL
//SDMA0_QUEUE5_RB_AQL_CNTL
#define SDMA0_QUEUE5_RB_AQL_CNTL__AQL_ENABLE__SHIFT                                                           0x0
#define SDMA0_QUEUE5_RB_AQL_CNTL__AQL_PACKET_SIZE__SHIFT                                                      0x1
#define SDMA0_QUEUE5_RB_AQL_CNTL__PACKET_STEP__SHIFT                                                          0x8
#define SDMA0_QUEUE5_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE__SHIFT                                                0x10
#define SDMA0_QUEUE5_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE__SHIFT                                          0x11
#define SDMA0_QUEUE5_RB_AQL_CNTL__OVERLAP_ENABLE__SHIFT                                                       0x12
#define SDMA0_QUEUE5_RB_AQL_CNTL__AQL_ENABLE_MASK                                                             0x00000001L
#define SDMA0_QUEUE5_RB_AQL_CNTL__AQL_PACKET_SIZE_MASK                                                        0x000000FEL
#define SDMA0_QUEUE5_RB_AQL_CNTL__PACKET_STEP_MASK                                                            0x0000FF00L
#define SDMA0_QUEUE5_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE_MASK                                                  0x00010000L
#define SDMA0_QUEUE5_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE_MASK                                            0x00020000L
#define SDMA0_QUEUE5_RB_AQL_CNTL__OVERLAP_ENABLE_MASK                                                         0x00040000L
//SDMA0_QUEUE5_MINOR_PTR_UPDATE
#define SDMA0_QUEUE5_MINOR_PTR_UPDATE__ENABLE__SHIFT                                                          0x0
#define SDMA0_QUEUE5_MINOR_PTR_UPDATE__ENABLE_MASK                                                            0x00000001L
//SDMA0_QUEUE5_CONTEXT_SWITCH_STATUS
#define SDMA0_QUEUE5_CONTEXT_SWITCH_STATUS__RB_PREEMPT_STATUS__SHIFT                                          0x0
#define SDMA0_QUEUE5_CONTEXT_SWITCH_STATUS__VM_HOLE_EXCEPTION__SHIFT                                          0x1
#define SDMA0_QUEUE5_CONTEXT_SWITCH_STATUS__PAGE_EXCEPTION__SHIFT                                             0x2
#define SDMA0_QUEUE5_CONTEXT_SWITCH_STATUS__QUEUE_HANG_EXCEPTION__SHIFT                                       0x5
#define SDMA0_QUEUE5_CONTEXT_SWITCH_STATUS__DOORBELL_ERROR_EXCEPTION__SHIFT                                   0x6
#define SDMA0_QUEUE5_CONTEXT_SWITCH_STATUS__SRAM_ECC_EXCEPTION__SHIFT                                         0x7
#define SDMA0_QUEUE5_CONTEXT_SWITCH_STATUS__DRAM_ECC_EXCEPTION__SHIFT                                         0x8
#define SDMA0_QUEUE5_CONTEXT_SWITCH_STATUS__WPTR_LT_RPTR_EXCEPTION__SHIFT                                     0x9
#define SDMA0_QUEUE5_CONTEXT_SWITCH_STATUS__RB_PREEMPT_STATUS_MASK                                            0x00000001L
#define SDMA0_QUEUE5_CONTEXT_SWITCH_STATUS__VM_HOLE_EXCEPTION_MASK                                            0x00000002L
#define SDMA0_QUEUE5_CONTEXT_SWITCH_STATUS__PAGE_EXCEPTION_MASK                                               0x00000004L
#define SDMA0_QUEUE5_CONTEXT_SWITCH_STATUS__QUEUE_HANG_EXCEPTION_MASK                                         0x00000020L
#define SDMA0_QUEUE5_CONTEXT_SWITCH_STATUS__DOORBELL_ERROR_EXCEPTION_MASK                                     0x00000040L
#define SDMA0_QUEUE5_CONTEXT_SWITCH_STATUS__SRAM_ECC_EXCEPTION_MASK                                           0x00000080L
#define SDMA0_QUEUE5_CONTEXT_SWITCH_STATUS__DRAM_ECC_EXCEPTION_MASK                                           0x00000100L
#define SDMA0_QUEUE5_CONTEXT_SWITCH_STATUS__WPTR_LT_RPTR_EXCEPTION_MASK                                       0x00000200L
//SDMA0_QUEUE5_MIDCMD_CNTL
#define SDMA0_QUEUE5_MIDCMD_CNTL__DATA_VALID__SHIFT                                                           0x0
#define SDMA0_QUEUE5_MIDCMD_CNTL__COPY_MODE__SHIFT                                                            0x1
#define SDMA0_QUEUE5_MIDCMD_CNTL__SPLIT_STATE__SHIFT                                                          0x4
#define SDMA0_QUEUE5_MIDCMD_CNTL__ALLOW_PREEMPT__SHIFT                                                        0x8
#define SDMA0_QUEUE5_MIDCMD_CNTL__DATA_VALID_MASK                                                             0x00000001L
#define SDMA0_QUEUE5_MIDCMD_CNTL__COPY_MODE_MASK                                                              0x00000002L
#define SDMA0_QUEUE5_MIDCMD_CNTL__SPLIT_STATE_MASK                                                            0x000000F0L
#define SDMA0_QUEUE5_MIDCMD_CNTL__ALLOW_PREEMPT_MASK                                                          0x00000100L
//SDMA0_QUEUE5_MIDCMD_DATA0
#define SDMA0_QUEUE5_MIDCMD_DATA0__DATA0__SHIFT                                                               0x0
#define SDMA0_QUEUE5_MIDCMD_DATA0__DATA0_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE5_MIDCMD_DATA1
#define SDMA0_QUEUE5_MIDCMD_DATA1__DATA1__SHIFT                                                               0x0
#define SDMA0_QUEUE5_MIDCMD_DATA1__DATA1_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE5_MIDCMD_DATA2
#define SDMA0_QUEUE5_MIDCMD_DATA2__DATA2__SHIFT                                                               0x0
#define SDMA0_QUEUE5_MIDCMD_DATA2__DATA2_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE5_MIDCMD_DATA3
#define SDMA0_QUEUE5_MIDCMD_DATA3__DATA3__SHIFT                                                               0x0
#define SDMA0_QUEUE5_MIDCMD_DATA3__DATA3_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE5_MIDCMD_DATA4
#define SDMA0_QUEUE5_MIDCMD_DATA4__DATA4__SHIFT                                                               0x0
#define SDMA0_QUEUE5_MIDCMD_DATA4__DATA4_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE5_MIDCMD_DATA5
#define SDMA0_QUEUE5_MIDCMD_DATA5__DATA5__SHIFT                                                               0x0
#define SDMA0_QUEUE5_MIDCMD_DATA5__DATA5_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE5_MIDCMD_DATA6
#define SDMA0_QUEUE5_MIDCMD_DATA6__DATA6__SHIFT                                                               0x0
#define SDMA0_QUEUE5_MIDCMD_DATA6__DATA6_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE5_MIDCMD_DATA7
#define SDMA0_QUEUE5_MIDCMD_DATA7__DATA7__SHIFT                                                               0x0
#define SDMA0_QUEUE5_MIDCMD_DATA7__DATA7_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE5_MIDCMD_DATA8
#define SDMA0_QUEUE5_MIDCMD_DATA8__DATA8__SHIFT                                                               0x0
#define SDMA0_QUEUE5_MIDCMD_DATA8__DATA8_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE5_MIDCMD_DATA9
#define SDMA0_QUEUE5_MIDCMD_DATA9__DATA9__SHIFT                                                               0x0
#define SDMA0_QUEUE5_MIDCMD_DATA9__DATA9_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE5_MIDCMD_DATA10
#define SDMA0_QUEUE5_MIDCMD_DATA10__DATA10__SHIFT                                                             0x0
#define SDMA0_QUEUE5_MIDCMD_DATA10__DATA10_MASK                                                               0xFFFFFFFFL
//SDMA0_QUEUE5_WAIT_UNSATISFIED_THD
#define SDMA0_QUEUE5_WAIT_UNSATISFIED_THD__THRESHOLD__SHIFT                                                   0x0
#define SDMA0_QUEUE5_WAIT_UNSATISFIED_THD__THRESHOLD_MASK                                                     0x0000001FL
//SDMA0_QUEUE5_MQD_BASE_ADDR_LO
#define SDMA0_QUEUE5_MQD_BASE_ADDR_LO__BASE_ADDR_LO__SHIFT                                                    0x2
#define SDMA0_QUEUE5_MQD_BASE_ADDR_LO__BASE_ADDR_LO_MASK                                                      0xFFFFFFFCL
//SDMA0_QUEUE5_MQD_BASE_ADDR_HI
#define SDMA0_QUEUE5_MQD_BASE_ADDR_HI__BASE_ADDR_HI__SHIFT                                                    0x0
#define SDMA0_QUEUE5_MQD_BASE_ADDR_HI__BASE_ADDR_HI_MASK                                                      0xFFFFFFFFL
//SDMA0_QUEUE5_MQD_CONTROL
#define SDMA0_QUEUE5_MQD_CONTROL__VMID__SHIFT                                                                 0x0
#define SDMA0_QUEUE5_MQD_CONTROL__VMID_MASK                                                                   0x0000000FL
//SDMA0_QUEUE5_DEQUEUE_REQUEST
#define SDMA0_QUEUE5_DEQUEUE_REQUEST__DEQUEUE_REQ__SHIFT                                                      0x0
#define SDMA0_QUEUE5_DEQUEUE_REQUEST__DEQUEUE_REQ_MASK                                                        0x00000001L
//SDMA0_QUEUE5_CONTEXT_STATUS
#define SDMA0_QUEUE5_CONTEXT_STATUS__SELECTED__SHIFT                                                          0x0
#define SDMA0_QUEUE5_CONTEXT_STATUS__USE_IB__SHIFT                                                            0x1
#define SDMA0_QUEUE5_CONTEXT_STATUS__IDLE__SHIFT                                                              0x2
#define SDMA0_QUEUE5_CONTEXT_STATUS__EXPIRED__SHIFT                                                           0x3
#define SDMA0_QUEUE5_CONTEXT_STATUS__EXCEPTION__SHIFT                                                         0x4
#define SDMA0_QUEUE5_CONTEXT_STATUS__CTXSW_ABLE__SHIFT                                                        0x7
#define SDMA0_QUEUE5_CONTEXT_STATUS__VF_STATUS__SHIFT                                                         0x8
#define SDMA0_QUEUE5_CONTEXT_STATUS__PRIV_EXCEPTION__SHIFT                                                    0x9
#define SDMA0_QUEUE5_CONTEXT_STATUS__PREEMPT_DISABLE__SHIFT                                                   0xa
#define SDMA0_QUEUE5_CONTEXT_STATUS__RPTR_WB_IDLE__SHIFT                                                      0xb
#define SDMA0_QUEUE5_CONTEXT_STATUS__WPTR_UPDATE_PENDING__SHIFT                                               0xc
#define SDMA0_QUEUE5_CONTEXT_STATUS__WPTR_UPDATE_FAIL_COUNT__SHIFT                                            0x10
#define SDMA0_QUEUE5_CONTEXT_STATUS__SELECTED_MASK                                                            0x00000001L
#define SDMA0_QUEUE5_CONTEXT_STATUS__USE_IB_MASK                                                              0x00000002L
#define SDMA0_QUEUE5_CONTEXT_STATUS__IDLE_MASK                                                                0x00000004L
#define SDMA0_QUEUE5_CONTEXT_STATUS__EXPIRED_MASK                                                             0x00000008L
#define SDMA0_QUEUE5_CONTEXT_STATUS__EXCEPTION_MASK                                                           0x00000070L
#define SDMA0_QUEUE5_CONTEXT_STATUS__CTXSW_ABLE_MASK                                                          0x00000080L
#define SDMA0_QUEUE5_CONTEXT_STATUS__VF_STATUS_MASK                                                           0x00000100L
#define SDMA0_QUEUE5_CONTEXT_STATUS__PRIV_EXCEPTION_MASK                                                      0x00000200L
#define SDMA0_QUEUE5_CONTEXT_STATUS__PREEMPT_DISABLE_MASK                                                     0x00000400L
#define SDMA0_QUEUE5_CONTEXT_STATUS__RPTR_WB_IDLE_MASK                                                        0x00000800L
#define SDMA0_QUEUE5_CONTEXT_STATUS__WPTR_UPDATE_PENDING_MASK                                                 0x00001000L
#define SDMA0_QUEUE5_CONTEXT_STATUS__WPTR_UPDATE_FAIL_COUNT_MASK                                              0x00FF0000L
//SDMA0_QUEUE6_RB_CNTL
#define SDMA0_QUEUE6_RB_CNTL__RB_ENABLE__SHIFT                                                                0x0
#define SDMA0_QUEUE6_RB_CNTL__RB_SIZE__SHIFT                                                                  0x1
#define SDMA0_QUEUE6_RB_CNTL__WPTR_POLL_ENABLE__SHIFT                                                         0x8
#define SDMA0_QUEUE6_RB_CNTL__RB_SWAP_ENABLE__SHIFT                                                           0x9
#define SDMA0_QUEUE6_RB_CNTL__WPTR_POLL_SWAP_ENABLE__SHIFT                                                    0xa
#define SDMA0_QUEUE6_RB_CNTL__MCU_WPTR_POLL_ENABLE__SHIFT                                                     0xb
#define SDMA0_QUEUE6_RB_CNTL__RPTR_WRITEBACK_ENABLE__SHIFT                                                    0xc
#define SDMA0_QUEUE6_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE__SHIFT                                               0xd
#define SDMA0_QUEUE6_RB_CNTL__RPTR_WRITEBACK_TIMER__SHIFT                                                     0x10
#define SDMA0_QUEUE6_RB_CNTL__RB_PRIV__SHIFT                                                                  0x17
#define SDMA0_QUEUE6_RB_CNTL__RB_VMID__SHIFT                                                                  0x18
#define SDMA0_QUEUE6_RB_CNTL__RB_ENABLE_MASK                                                                  0x00000001L
#define SDMA0_QUEUE6_RB_CNTL__RB_SIZE_MASK                                                                    0x0000003EL
#define SDMA0_QUEUE6_RB_CNTL__WPTR_POLL_ENABLE_MASK                                                           0x00000100L
#define SDMA0_QUEUE6_RB_CNTL__RB_SWAP_ENABLE_MASK                                                             0x00000200L
#define SDMA0_QUEUE6_RB_CNTL__WPTR_POLL_SWAP_ENABLE_MASK                                                      0x00000400L
#define SDMA0_QUEUE6_RB_CNTL__MCU_WPTR_POLL_ENABLE_MASK                                                       0x00000800L
#define SDMA0_QUEUE6_RB_CNTL__RPTR_WRITEBACK_ENABLE_MASK                                                      0x00001000L
#define SDMA0_QUEUE6_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE_MASK                                                 0x00002000L
#define SDMA0_QUEUE6_RB_CNTL__RPTR_WRITEBACK_TIMER_MASK                                                       0x001F0000L
#define SDMA0_QUEUE6_RB_CNTL__RB_PRIV_MASK                                                                    0x00800000L
#define SDMA0_QUEUE6_RB_CNTL__RB_VMID_MASK                                                                    0x0F000000L
//SDMA0_QUEUE6_RB_BASE
#define SDMA0_QUEUE6_RB_BASE__ADDR__SHIFT                                                                     0x0
#define SDMA0_QUEUE6_RB_BASE__ADDR_MASK                                                                       0xFFFFFFFFL
//SDMA0_QUEUE6_RB_BASE_HI
#define SDMA0_QUEUE6_RB_BASE_HI__ADDR__SHIFT                                                                  0x0
#define SDMA0_QUEUE6_RB_BASE_HI__ADDR_MASK                                                                    0x00FFFFFFL
//SDMA0_QUEUE6_RB_RPTR
#define SDMA0_QUEUE6_RB_RPTR__OFFSET__SHIFT                                                                   0x0
#define SDMA0_QUEUE6_RB_RPTR__OFFSET_MASK                                                                     0xFFFFFFFFL
//SDMA0_QUEUE6_RB_RPTR_HI
#define SDMA0_QUEUE6_RB_RPTR_HI__OFFSET__SHIFT                                                                0x0
#define SDMA0_QUEUE6_RB_RPTR_HI__OFFSET_MASK                                                                  0xFFFFFFFFL
//SDMA0_QUEUE6_RB_WPTR
#define SDMA0_QUEUE6_RB_WPTR__OFFSET__SHIFT                                                                   0x0
#define SDMA0_QUEUE6_RB_WPTR__OFFSET_MASK                                                                     0xFFFFFFFFL
//SDMA0_QUEUE6_RB_WPTR_HI
#define SDMA0_QUEUE6_RB_WPTR_HI__OFFSET__SHIFT                                                                0x0
#define SDMA0_QUEUE6_RB_WPTR_HI__OFFSET_MASK                                                                  0xFFFFFFFFL
//SDMA0_QUEUE6_RB_RPTR_ADDR_LO
#define SDMA0_QUEUE6_RB_RPTR_ADDR_LO__ADDR__SHIFT                                                             0x2
#define SDMA0_QUEUE6_RB_RPTR_ADDR_LO__ADDR_MASK                                                               0xFFFFFFFCL
//SDMA0_QUEUE6_RB_RPTR_ADDR_HI
#define SDMA0_QUEUE6_RB_RPTR_ADDR_HI__ADDR__SHIFT                                                             0x0
#define SDMA0_QUEUE6_RB_RPTR_ADDR_HI__ADDR_MASK                                                               0xFFFFFFFFL
//SDMA0_QUEUE6_IB_CNTL
#define SDMA0_QUEUE6_IB_CNTL__IB_ENABLE__SHIFT                                                                0x0
#define SDMA0_QUEUE6_IB_CNTL__IB_SWAP_ENABLE__SHIFT                                                           0x4
#define SDMA0_QUEUE6_IB_CNTL__SWITCH_INSIDE_IB__SHIFT                                                         0x8
#define SDMA0_QUEUE6_IB_CNTL__CMD_VMID__SHIFT                                                                 0x10
#define SDMA0_QUEUE6_IB_CNTL__IB_ENABLE_MASK                                                                  0x00000001L
#define SDMA0_QUEUE6_IB_CNTL__IB_SWAP_ENABLE_MASK                                                             0x00000010L
#define SDMA0_QUEUE6_IB_CNTL__SWITCH_INSIDE_IB_MASK                                                           0x00000100L
#define SDMA0_QUEUE6_IB_CNTL__CMD_VMID_MASK                                                                   0x000F0000L
//SDMA0_QUEUE6_IB_RPTR
#define SDMA0_QUEUE6_IB_RPTR__OFFSET__SHIFT                                                                   0x2
#define SDMA0_QUEUE6_IB_RPTR__OFFSET_MASK                                                                     0x003FFFFCL
//SDMA0_QUEUE6_IB_OFFSET
#define SDMA0_QUEUE6_IB_OFFSET__OFFSET__SHIFT                                                                 0x2
#define SDMA0_QUEUE6_IB_OFFSET__OFFSET_MASK                                                                   0x003FFFFCL
//SDMA0_QUEUE6_IB_BASE_LO
#define SDMA0_QUEUE6_IB_BASE_LO__ADDR__SHIFT                                                                  0x2
#define SDMA0_QUEUE6_IB_BASE_LO__ADDR_MASK                                                                    0xFFFFFFFCL
//SDMA0_QUEUE6_IB_BASE_HI
#define SDMA0_QUEUE6_IB_BASE_HI__ADDR__SHIFT                                                                  0x0
#define SDMA0_QUEUE6_IB_BASE_HI__ADDR_MASK                                                                    0xFFFFFFFFL
//SDMA0_QUEUE6_IB_SIZE
#define SDMA0_QUEUE6_IB_SIZE__SIZE__SHIFT                                                                     0x0
#define SDMA0_QUEUE6_IB_SIZE__SIZE_MASK                                                                       0x000FFFFFL
//SDMA0_QUEUE6_DOORBELL
#define SDMA0_QUEUE6_DOORBELL__ENABLE__SHIFT                                                                  0x1c
#define SDMA0_QUEUE6_DOORBELL__CAPTURED__SHIFT                                                                0x1e
#define SDMA0_QUEUE6_DOORBELL__ENABLE_MASK                                                                    0x10000000L
#define SDMA0_QUEUE6_DOORBELL__CAPTURED_MASK                                                                  0x40000000L
//SDMA0_QUEUE6_DOORBELL_LOG
#define SDMA0_QUEUE6_DOORBELL_LOG__BE_ERROR__SHIFT                                                            0x0
#define SDMA0_QUEUE6_DOORBELL_LOG__DATA__SHIFT                                                                0x2
#define SDMA0_QUEUE6_DOORBELL_LOG__BE_ERROR_MASK                                                              0x00000001L
#define SDMA0_QUEUE6_DOORBELL_LOG__DATA_MASK                                                                  0xFFFFFFFCL
//SDMA0_QUEUE6_DOORBELL_OFFSET
#define SDMA0_QUEUE6_DOORBELL_OFFSET__OFFSET__SHIFT                                                           0x2
#define SDMA0_QUEUE6_DOORBELL_OFFSET__OFFSET_MASK                                                             0x0FFFFFFCL
//SDMA0_QUEUE6_CSA_ADDR_LO
#define SDMA0_QUEUE6_CSA_ADDR_LO__ADDR__SHIFT                                                                 0x2
#define SDMA0_QUEUE6_CSA_ADDR_LO__ADDR_MASK                                                                   0xFFFFFFFCL
//SDMA0_QUEUE6_CSA_ADDR_HI
#define SDMA0_QUEUE6_CSA_ADDR_HI__ADDR__SHIFT                                                                 0x0
#define SDMA0_QUEUE6_CSA_ADDR_HI__ADDR_MASK                                                                   0xFFFFFFFFL
//SDMA0_QUEUE6_SCHEDULE_CNTL
#define SDMA0_QUEUE6_SCHEDULE_CNTL__GLOBAL_ID__SHIFT                                                          0x0
#define SDMA0_QUEUE6_SCHEDULE_CNTL__PROCESS_ID__SHIFT                                                         0x2
#define SDMA0_QUEUE6_SCHEDULE_CNTL__LOCAL_ID__SHIFT                                                           0x6
#define SDMA0_QUEUE6_SCHEDULE_CNTL__CONTEXT_QUANTUM__SHIFT                                                    0x8
#define SDMA0_QUEUE6_SCHEDULE_CNTL__GLOBAL_ID_MASK                                                            0x00000003L
#define SDMA0_QUEUE6_SCHEDULE_CNTL__PROCESS_ID_MASK                                                           0x0000001CL
#define SDMA0_QUEUE6_SCHEDULE_CNTL__LOCAL_ID_MASK                                                             0x000000C0L
#define SDMA0_QUEUE6_SCHEDULE_CNTL__CONTEXT_QUANTUM_MASK                                                      0x0000FF00L
//SDMA0_QUEUE6_IB_SUB_REMAIN
#define SDMA0_QUEUE6_IB_SUB_REMAIN__SIZE__SHIFT                                                               0x0
#define SDMA0_QUEUE6_IB_SUB_REMAIN__SIZE_MASK                                                                 0x00003FFFL
//SDMA0_QUEUE6_PREEMPT
#define SDMA0_QUEUE6_PREEMPT__IB_PREEMPT__SHIFT                                                               0x0
#define SDMA0_QUEUE6_PREEMPT__IB_PREEMPT_MASK                                                                 0x00000001L
//SDMA0_QUEUE6_DUMMY_REG
#define SDMA0_QUEUE6_DUMMY_REG__DUMMY__SHIFT                                                                  0x0
#define SDMA0_QUEUE6_DUMMY_REG__DUMMY_MASK                                                                    0xFFFFFFFFL
//SDMA0_QUEUE6_RB_WPTR_POLL_ADDR_LO
#define SDMA0_QUEUE6_RB_WPTR_POLL_ADDR_LO__ADDR__SHIFT                                                        0x2
#define SDMA0_QUEUE6_RB_WPTR_POLL_ADDR_LO__ADDR_MASK                                                          0xFFFFFFFCL
//SDMA0_QUEUE6_RB_WPTR_POLL_ADDR_HI
#define SDMA0_QUEUE6_RB_WPTR_POLL_ADDR_HI__ADDR__SHIFT                                                        0x0
#define SDMA0_QUEUE6_RB_WPTR_POLL_ADDR_HI__ADDR_MASK                                                          0xFFFFFFFFL
//SDMA0_QUEUE6_RB_AQL_CNTL
#define SDMA0_QUEUE6_RB_AQL_CNTL__AQL_ENABLE__SHIFT                                                           0x0
#define SDMA0_QUEUE6_RB_AQL_CNTL__AQL_PACKET_SIZE__SHIFT                                                      0x1
#define SDMA0_QUEUE6_RB_AQL_CNTL__PACKET_STEP__SHIFT                                                          0x8
#define SDMA0_QUEUE6_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE__SHIFT                                                0x10
#define SDMA0_QUEUE6_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE__SHIFT                                          0x11
#define SDMA0_QUEUE6_RB_AQL_CNTL__OVERLAP_ENABLE__SHIFT                                                       0x12
#define SDMA0_QUEUE6_RB_AQL_CNTL__AQL_ENABLE_MASK                                                             0x00000001L
#define SDMA0_QUEUE6_RB_AQL_CNTL__AQL_PACKET_SIZE_MASK                                                        0x000000FEL
#define SDMA0_QUEUE6_RB_AQL_CNTL__PACKET_STEP_MASK                                                            0x0000FF00L
#define SDMA0_QUEUE6_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE_MASK                                                  0x00010000L
#define SDMA0_QUEUE6_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE_MASK                                            0x00020000L
#define SDMA0_QUEUE6_RB_AQL_CNTL__OVERLAP_ENABLE_MASK                                                         0x00040000L
//SDMA0_QUEUE6_MINOR_PTR_UPDATE
#define SDMA0_QUEUE6_MINOR_PTR_UPDATE__ENABLE__SHIFT                                                          0x0
#define SDMA0_QUEUE6_MINOR_PTR_UPDATE__ENABLE_MASK                                                            0x00000001L
//SDMA0_QUEUE6_CONTEXT_SWITCH_STATUS
#define SDMA0_QUEUE6_CONTEXT_SWITCH_STATUS__RB_PREEMPT_STATUS__SHIFT                                          0x0
#define SDMA0_QUEUE6_CONTEXT_SWITCH_STATUS__VM_HOLE_EXCEPTION__SHIFT                                          0x1
#define SDMA0_QUEUE6_CONTEXT_SWITCH_STATUS__PAGE_EXCEPTION__SHIFT                                             0x2
#define SDMA0_QUEUE6_CONTEXT_SWITCH_STATUS__QUEUE_HANG_EXCEPTION__SHIFT                                       0x5
#define SDMA0_QUEUE6_CONTEXT_SWITCH_STATUS__DOORBELL_ERROR_EXCEPTION__SHIFT                                   0x6
#define SDMA0_QUEUE6_CONTEXT_SWITCH_STATUS__SRAM_ECC_EXCEPTION__SHIFT                                         0x7
#define SDMA0_QUEUE6_CONTEXT_SWITCH_STATUS__DRAM_ECC_EXCEPTION__SHIFT                                         0x8
#define SDMA0_QUEUE6_CONTEXT_SWITCH_STATUS__WPTR_LT_RPTR_EXCEPTION__SHIFT                                     0x9
#define SDMA0_QUEUE6_CONTEXT_SWITCH_STATUS__RB_PREEMPT_STATUS_MASK                                            0x00000001L
#define SDMA0_QUEUE6_CONTEXT_SWITCH_STATUS__VM_HOLE_EXCEPTION_MASK                                            0x00000002L
#define SDMA0_QUEUE6_CONTEXT_SWITCH_STATUS__PAGE_EXCEPTION_MASK                                               0x00000004L
#define SDMA0_QUEUE6_CONTEXT_SWITCH_STATUS__QUEUE_HANG_EXCEPTION_MASK                                         0x00000020L
#define SDMA0_QUEUE6_CONTEXT_SWITCH_STATUS__DOORBELL_ERROR_EXCEPTION_MASK                                     0x00000040L
#define SDMA0_QUEUE6_CONTEXT_SWITCH_STATUS__SRAM_ECC_EXCEPTION_MASK                                           0x00000080L
#define SDMA0_QUEUE6_CONTEXT_SWITCH_STATUS__DRAM_ECC_EXCEPTION_MASK                                           0x00000100L
#define SDMA0_QUEUE6_CONTEXT_SWITCH_STATUS__WPTR_LT_RPTR_EXCEPTION_MASK                                       0x00000200L
//SDMA0_QUEUE6_MIDCMD_CNTL
#define SDMA0_QUEUE6_MIDCMD_CNTL__DATA_VALID__SHIFT                                                           0x0
#define SDMA0_QUEUE6_MIDCMD_CNTL__COPY_MODE__SHIFT                                                            0x1
#define SDMA0_QUEUE6_MIDCMD_CNTL__SPLIT_STATE__SHIFT                                                          0x4
#define SDMA0_QUEUE6_MIDCMD_CNTL__ALLOW_PREEMPT__SHIFT                                                        0x8
#define SDMA0_QUEUE6_MIDCMD_CNTL__DATA_VALID_MASK                                                             0x00000001L
#define SDMA0_QUEUE6_MIDCMD_CNTL__COPY_MODE_MASK                                                              0x00000002L
#define SDMA0_QUEUE6_MIDCMD_CNTL__SPLIT_STATE_MASK                                                            0x000000F0L
#define SDMA0_QUEUE6_MIDCMD_CNTL__ALLOW_PREEMPT_MASK                                                          0x00000100L
//SDMA0_QUEUE6_MIDCMD_DATA0
#define SDMA0_QUEUE6_MIDCMD_DATA0__DATA0__SHIFT                                                               0x0
#define SDMA0_QUEUE6_MIDCMD_DATA0__DATA0_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE6_MIDCMD_DATA1
#define SDMA0_QUEUE6_MIDCMD_DATA1__DATA1__SHIFT                                                               0x0
#define SDMA0_QUEUE6_MIDCMD_DATA1__DATA1_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE6_MIDCMD_DATA2
#define SDMA0_QUEUE6_MIDCMD_DATA2__DATA2__SHIFT                                                               0x0
#define SDMA0_QUEUE6_MIDCMD_DATA2__DATA2_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE6_MIDCMD_DATA3
#define SDMA0_QUEUE6_MIDCMD_DATA3__DATA3__SHIFT                                                               0x0
#define SDMA0_QUEUE6_MIDCMD_DATA3__DATA3_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE6_MIDCMD_DATA4
#define SDMA0_QUEUE6_MIDCMD_DATA4__DATA4__SHIFT                                                               0x0
#define SDMA0_QUEUE6_MIDCMD_DATA4__DATA4_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE6_MIDCMD_DATA5
#define SDMA0_QUEUE6_MIDCMD_DATA5__DATA5__SHIFT                                                               0x0
#define SDMA0_QUEUE6_MIDCMD_DATA5__DATA5_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE6_MIDCMD_DATA6
#define SDMA0_QUEUE6_MIDCMD_DATA6__DATA6__SHIFT                                                               0x0
#define SDMA0_QUEUE6_MIDCMD_DATA6__DATA6_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE6_MIDCMD_DATA7
#define SDMA0_QUEUE6_MIDCMD_DATA7__DATA7__SHIFT                                                               0x0
#define SDMA0_QUEUE6_MIDCMD_DATA7__DATA7_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE6_MIDCMD_DATA8
#define SDMA0_QUEUE6_MIDCMD_DATA8__DATA8__SHIFT                                                               0x0
#define SDMA0_QUEUE6_MIDCMD_DATA8__DATA8_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE6_MIDCMD_DATA9
#define SDMA0_QUEUE6_MIDCMD_DATA9__DATA9__SHIFT                                                               0x0
#define SDMA0_QUEUE6_MIDCMD_DATA9__DATA9_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE6_MIDCMD_DATA10
#define SDMA0_QUEUE6_MIDCMD_DATA10__DATA10__SHIFT                                                             0x0
#define SDMA0_QUEUE6_MIDCMD_DATA10__DATA10_MASK                                                               0xFFFFFFFFL
//SDMA0_QUEUE6_WAIT_UNSATISFIED_THD
#define SDMA0_QUEUE6_WAIT_UNSATISFIED_THD__THRESHOLD__SHIFT                                                   0x0
#define SDMA0_QUEUE6_WAIT_UNSATISFIED_THD__THRESHOLD_MASK                                                     0x0000001FL
//SDMA0_QUEUE6_MQD_BASE_ADDR_LO
#define SDMA0_QUEUE6_MQD_BASE_ADDR_LO__BASE_ADDR_LO__SHIFT                                                    0x2
#define SDMA0_QUEUE6_MQD_BASE_ADDR_LO__BASE_ADDR_LO_MASK                                                      0xFFFFFFFCL
//SDMA0_QUEUE6_MQD_BASE_ADDR_HI
#define SDMA0_QUEUE6_MQD_BASE_ADDR_HI__BASE_ADDR_HI__SHIFT                                                    0x0
#define SDMA0_QUEUE6_MQD_BASE_ADDR_HI__BASE_ADDR_HI_MASK                                                      0xFFFFFFFFL
//SDMA0_QUEUE6_MQD_CONTROL
#define SDMA0_QUEUE6_MQD_CONTROL__VMID__SHIFT                                                                 0x0
#define SDMA0_QUEUE6_MQD_CONTROL__VMID_MASK                                                                   0x0000000FL
//SDMA0_QUEUE6_DEQUEUE_REQUEST
#define SDMA0_QUEUE6_DEQUEUE_REQUEST__DEQUEUE_REQ__SHIFT                                                      0x0
#define SDMA0_QUEUE6_DEQUEUE_REQUEST__DEQUEUE_REQ_MASK                                                        0x00000001L
//SDMA0_QUEUE6_CONTEXT_STATUS
#define SDMA0_QUEUE6_CONTEXT_STATUS__SELECTED__SHIFT                                                          0x0
#define SDMA0_QUEUE6_CONTEXT_STATUS__USE_IB__SHIFT                                                            0x1
#define SDMA0_QUEUE6_CONTEXT_STATUS__IDLE__SHIFT                                                              0x2
#define SDMA0_QUEUE6_CONTEXT_STATUS__EXPIRED__SHIFT                                                           0x3
#define SDMA0_QUEUE6_CONTEXT_STATUS__EXCEPTION__SHIFT                                                         0x4
#define SDMA0_QUEUE6_CONTEXT_STATUS__CTXSW_ABLE__SHIFT                                                        0x7
#define SDMA0_QUEUE6_CONTEXT_STATUS__VF_STATUS__SHIFT                                                         0x8
#define SDMA0_QUEUE6_CONTEXT_STATUS__PRIV_EXCEPTION__SHIFT                                                    0x9
#define SDMA0_QUEUE6_CONTEXT_STATUS__PREEMPT_DISABLE__SHIFT                                                   0xa
#define SDMA0_QUEUE6_CONTEXT_STATUS__RPTR_WB_IDLE__SHIFT                                                      0xb
#define SDMA0_QUEUE6_CONTEXT_STATUS__WPTR_UPDATE_PENDING__SHIFT                                               0xc
#define SDMA0_QUEUE6_CONTEXT_STATUS__WPTR_UPDATE_FAIL_COUNT__SHIFT                                            0x10
#define SDMA0_QUEUE6_CONTEXT_STATUS__SELECTED_MASK                                                            0x00000001L
#define SDMA0_QUEUE6_CONTEXT_STATUS__USE_IB_MASK                                                              0x00000002L
#define SDMA0_QUEUE6_CONTEXT_STATUS__IDLE_MASK                                                                0x00000004L
#define SDMA0_QUEUE6_CONTEXT_STATUS__EXPIRED_MASK                                                             0x00000008L
#define SDMA0_QUEUE6_CONTEXT_STATUS__EXCEPTION_MASK                                                           0x00000070L
#define SDMA0_QUEUE6_CONTEXT_STATUS__CTXSW_ABLE_MASK                                                          0x00000080L
#define SDMA0_QUEUE6_CONTEXT_STATUS__VF_STATUS_MASK                                                           0x00000100L
#define SDMA0_QUEUE6_CONTEXT_STATUS__PRIV_EXCEPTION_MASK                                                      0x00000200L
#define SDMA0_QUEUE6_CONTEXT_STATUS__PREEMPT_DISABLE_MASK                                                     0x00000400L
#define SDMA0_QUEUE6_CONTEXT_STATUS__RPTR_WB_IDLE_MASK                                                        0x00000800L
#define SDMA0_QUEUE6_CONTEXT_STATUS__WPTR_UPDATE_PENDING_MASK                                                 0x00001000L
#define SDMA0_QUEUE6_CONTEXT_STATUS__WPTR_UPDATE_FAIL_COUNT_MASK                                              0x00FF0000L
//SDMA0_QUEUE7_RB_CNTL
#define SDMA0_QUEUE7_RB_CNTL__RB_ENABLE__SHIFT                                                                0x0
#define SDMA0_QUEUE7_RB_CNTL__RB_SIZE__SHIFT                                                                  0x1
#define SDMA0_QUEUE7_RB_CNTL__WPTR_POLL_ENABLE__SHIFT                                                         0x8
#define SDMA0_QUEUE7_RB_CNTL__RB_SWAP_ENABLE__SHIFT                                                           0x9
#define SDMA0_QUEUE7_RB_CNTL__WPTR_POLL_SWAP_ENABLE__SHIFT                                                    0xa
#define SDMA0_QUEUE7_RB_CNTL__MCU_WPTR_POLL_ENABLE__SHIFT                                                     0xb
#define SDMA0_QUEUE7_RB_CNTL__RPTR_WRITEBACK_ENABLE__SHIFT                                                    0xc
#define SDMA0_QUEUE7_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE__SHIFT                                               0xd
#define SDMA0_QUEUE7_RB_CNTL__RPTR_WRITEBACK_TIMER__SHIFT                                                     0x10
#define SDMA0_QUEUE7_RB_CNTL__RB_PRIV__SHIFT                                                                  0x17
#define SDMA0_QUEUE7_RB_CNTL__RB_VMID__SHIFT                                                                  0x18
#define SDMA0_QUEUE7_RB_CNTL__RB_ENABLE_MASK                                                                  0x00000001L
#define SDMA0_QUEUE7_RB_CNTL__RB_SIZE_MASK                                                                    0x0000003EL
#define SDMA0_QUEUE7_RB_CNTL__WPTR_POLL_ENABLE_MASK                                                           0x00000100L
#define SDMA0_QUEUE7_RB_CNTL__RB_SWAP_ENABLE_MASK                                                             0x00000200L
#define SDMA0_QUEUE7_RB_CNTL__WPTR_POLL_SWAP_ENABLE_MASK                                                      0x00000400L
#define SDMA0_QUEUE7_RB_CNTL__MCU_WPTR_POLL_ENABLE_MASK                                                       0x00000800L
#define SDMA0_QUEUE7_RB_CNTL__RPTR_WRITEBACK_ENABLE_MASK                                                      0x00001000L
#define SDMA0_QUEUE7_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE_MASK                                                 0x00002000L
#define SDMA0_QUEUE7_RB_CNTL__RPTR_WRITEBACK_TIMER_MASK                                                       0x001F0000L
#define SDMA0_QUEUE7_RB_CNTL__RB_PRIV_MASK                                                                    0x00800000L
#define SDMA0_QUEUE7_RB_CNTL__RB_VMID_MASK                                                                    0x0F000000L
//SDMA0_QUEUE7_RB_BASE
#define SDMA0_QUEUE7_RB_BASE__ADDR__SHIFT                                                                     0x0
#define SDMA0_QUEUE7_RB_BASE__ADDR_MASK                                                                       0xFFFFFFFFL
//SDMA0_QUEUE7_RB_BASE_HI
#define SDMA0_QUEUE7_RB_BASE_HI__ADDR__SHIFT                                                                  0x0
#define SDMA0_QUEUE7_RB_BASE_HI__ADDR_MASK                                                                    0x00FFFFFFL
//SDMA0_QUEUE7_RB_RPTR
#define SDMA0_QUEUE7_RB_RPTR__OFFSET__SHIFT                                                                   0x0
#define SDMA0_QUEUE7_RB_RPTR__OFFSET_MASK                                                                     0xFFFFFFFFL
//SDMA0_QUEUE7_RB_RPTR_HI
#define SDMA0_QUEUE7_RB_RPTR_HI__OFFSET__SHIFT                                                                0x0
#define SDMA0_QUEUE7_RB_RPTR_HI__OFFSET_MASK                                                                  0xFFFFFFFFL
//SDMA0_QUEUE7_RB_WPTR
#define SDMA0_QUEUE7_RB_WPTR__OFFSET__SHIFT                                                                   0x0
#define SDMA0_QUEUE7_RB_WPTR__OFFSET_MASK                                                                     0xFFFFFFFFL
//SDMA0_QUEUE7_RB_WPTR_HI
#define SDMA0_QUEUE7_RB_WPTR_HI__OFFSET__SHIFT                                                                0x0
#define SDMA0_QUEUE7_RB_WPTR_HI__OFFSET_MASK                                                                  0xFFFFFFFFL
//SDMA0_QUEUE7_RB_RPTR_ADDR_LO
#define SDMA0_QUEUE7_RB_RPTR_ADDR_LO__ADDR__SHIFT                                                             0x2
#define SDMA0_QUEUE7_RB_RPTR_ADDR_LO__ADDR_MASK                                                               0xFFFFFFFCL
//SDMA0_QUEUE7_RB_RPTR_ADDR_HI
#define SDMA0_QUEUE7_RB_RPTR_ADDR_HI__ADDR__SHIFT                                                             0x0
#define SDMA0_QUEUE7_RB_RPTR_ADDR_HI__ADDR_MASK                                                               0xFFFFFFFFL
//SDMA0_QUEUE7_IB_CNTL
#define SDMA0_QUEUE7_IB_CNTL__IB_ENABLE__SHIFT                                                                0x0
#define SDMA0_QUEUE7_IB_CNTL__IB_SWAP_ENABLE__SHIFT                                                           0x4
#define SDMA0_QUEUE7_IB_CNTL__SWITCH_INSIDE_IB__SHIFT                                                         0x8
#define SDMA0_QUEUE7_IB_CNTL__CMD_VMID__SHIFT                                                                 0x10
#define SDMA0_QUEUE7_IB_CNTL__IB_ENABLE_MASK                                                                  0x00000001L
#define SDMA0_QUEUE7_IB_CNTL__IB_SWAP_ENABLE_MASK                                                             0x00000010L
#define SDMA0_QUEUE7_IB_CNTL__SWITCH_INSIDE_IB_MASK                                                           0x00000100L
#define SDMA0_QUEUE7_IB_CNTL__CMD_VMID_MASK                                                                   0x000F0000L
//SDMA0_QUEUE7_IB_RPTR
#define SDMA0_QUEUE7_IB_RPTR__OFFSET__SHIFT                                                                   0x2
#define SDMA0_QUEUE7_IB_RPTR__OFFSET_MASK                                                                     0x003FFFFCL
//SDMA0_QUEUE7_IB_OFFSET
#define SDMA0_QUEUE7_IB_OFFSET__OFFSET__SHIFT                                                                 0x2
#define SDMA0_QUEUE7_IB_OFFSET__OFFSET_MASK                                                                   0x003FFFFCL
//SDMA0_QUEUE7_IB_BASE_LO
#define SDMA0_QUEUE7_IB_BASE_LO__ADDR__SHIFT                                                                  0x2
#define SDMA0_QUEUE7_IB_BASE_LO__ADDR_MASK                                                                    0xFFFFFFFCL
//SDMA0_QUEUE7_IB_BASE_HI
#define SDMA0_QUEUE7_IB_BASE_HI__ADDR__SHIFT                                                                  0x0
#define SDMA0_QUEUE7_IB_BASE_HI__ADDR_MASK                                                                    0xFFFFFFFFL
//SDMA0_QUEUE7_IB_SIZE
#define SDMA0_QUEUE7_IB_SIZE__SIZE__SHIFT                                                                     0x0
#define SDMA0_QUEUE7_IB_SIZE__SIZE_MASK                                                                       0x000FFFFFL
//SDMA0_QUEUE7_DOORBELL
#define SDMA0_QUEUE7_DOORBELL__ENABLE__SHIFT                                                                  0x1c
#define SDMA0_QUEUE7_DOORBELL__CAPTURED__SHIFT                                                                0x1e
#define SDMA0_QUEUE7_DOORBELL__ENABLE_MASK                                                                    0x10000000L
#define SDMA0_QUEUE7_DOORBELL__CAPTURED_MASK                                                                  0x40000000L
//SDMA0_QUEUE7_DOORBELL_LOG
#define SDMA0_QUEUE7_DOORBELL_LOG__BE_ERROR__SHIFT                                                            0x0
#define SDMA0_QUEUE7_DOORBELL_LOG__DATA__SHIFT                                                                0x2
#define SDMA0_QUEUE7_DOORBELL_LOG__BE_ERROR_MASK                                                              0x00000001L
#define SDMA0_QUEUE7_DOORBELL_LOG__DATA_MASK                                                                  0xFFFFFFFCL
//SDMA0_QUEUE7_DOORBELL_OFFSET
#define SDMA0_QUEUE7_DOORBELL_OFFSET__OFFSET__SHIFT                                                           0x2
#define SDMA0_QUEUE7_DOORBELL_OFFSET__OFFSET_MASK                                                             0x0FFFFFFCL
//SDMA0_QUEUE7_CSA_ADDR_LO
#define SDMA0_QUEUE7_CSA_ADDR_LO__ADDR__SHIFT                                                                 0x2
#define SDMA0_QUEUE7_CSA_ADDR_LO__ADDR_MASK                                                                   0xFFFFFFFCL
//SDMA0_QUEUE7_CSA_ADDR_HI
#define SDMA0_QUEUE7_CSA_ADDR_HI__ADDR__SHIFT                                                                 0x0
#define SDMA0_QUEUE7_CSA_ADDR_HI__ADDR_MASK                                                                   0xFFFFFFFFL
//SDMA0_QUEUE7_SCHEDULE_CNTL
#define SDMA0_QUEUE7_SCHEDULE_CNTL__GLOBAL_ID__SHIFT                                                          0x0
#define SDMA0_QUEUE7_SCHEDULE_CNTL__PROCESS_ID__SHIFT                                                         0x2
#define SDMA0_QUEUE7_SCHEDULE_CNTL__LOCAL_ID__SHIFT                                                           0x6
#define SDMA0_QUEUE7_SCHEDULE_CNTL__CONTEXT_QUANTUM__SHIFT                                                    0x8
#define SDMA0_QUEUE7_SCHEDULE_CNTL__GLOBAL_ID_MASK                                                            0x00000003L
#define SDMA0_QUEUE7_SCHEDULE_CNTL__PROCESS_ID_MASK                                                           0x0000001CL
#define SDMA0_QUEUE7_SCHEDULE_CNTL__LOCAL_ID_MASK                                                             0x000000C0L
#define SDMA0_QUEUE7_SCHEDULE_CNTL__CONTEXT_QUANTUM_MASK                                                      0x0000FF00L
//SDMA0_QUEUE7_IB_SUB_REMAIN
#define SDMA0_QUEUE7_IB_SUB_REMAIN__SIZE__SHIFT                                                               0x0
#define SDMA0_QUEUE7_IB_SUB_REMAIN__SIZE_MASK                                                                 0x00003FFFL
//SDMA0_QUEUE7_PREEMPT
#define SDMA0_QUEUE7_PREEMPT__IB_PREEMPT__SHIFT                                                               0x0
#define SDMA0_QUEUE7_PREEMPT__IB_PREEMPT_MASK                                                                 0x00000001L
//SDMA0_QUEUE7_DUMMY_REG
#define SDMA0_QUEUE7_DUMMY_REG__DUMMY__SHIFT                                                                  0x0
#define SDMA0_QUEUE7_DUMMY_REG__DUMMY_MASK                                                                    0xFFFFFFFFL
//SDMA0_QUEUE7_RB_WPTR_POLL_ADDR_LO
#define SDMA0_QUEUE7_RB_WPTR_POLL_ADDR_LO__ADDR__SHIFT                                                        0x2
#define SDMA0_QUEUE7_RB_WPTR_POLL_ADDR_LO__ADDR_MASK                                                          0xFFFFFFFCL
//SDMA0_QUEUE7_RB_WPTR_POLL_ADDR_HI
#define SDMA0_QUEUE7_RB_WPTR_POLL_ADDR_HI__ADDR__SHIFT                                                        0x0
#define SDMA0_QUEUE7_RB_WPTR_POLL_ADDR_HI__ADDR_MASK                                                          0xFFFFFFFFL
//SDMA0_QUEUE7_RB_AQL_CNTL
#define SDMA0_QUEUE7_RB_AQL_CNTL__AQL_ENABLE__SHIFT                                                           0x0
#define SDMA0_QUEUE7_RB_AQL_CNTL__AQL_PACKET_SIZE__SHIFT                                                      0x1
#define SDMA0_QUEUE7_RB_AQL_CNTL__PACKET_STEP__SHIFT                                                          0x8
#define SDMA0_QUEUE7_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE__SHIFT                                                0x10
#define SDMA0_QUEUE7_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE__SHIFT                                          0x11
#define SDMA0_QUEUE7_RB_AQL_CNTL__OVERLAP_ENABLE__SHIFT                                                       0x12
#define SDMA0_QUEUE7_RB_AQL_CNTL__AQL_ENABLE_MASK                                                             0x00000001L
#define SDMA0_QUEUE7_RB_AQL_CNTL__AQL_PACKET_SIZE_MASK                                                        0x000000FEL
#define SDMA0_QUEUE7_RB_AQL_CNTL__PACKET_STEP_MASK                                                            0x0000FF00L
#define SDMA0_QUEUE7_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE_MASK                                                  0x00010000L
#define SDMA0_QUEUE7_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE_MASK                                            0x00020000L
#define SDMA0_QUEUE7_RB_AQL_CNTL__OVERLAP_ENABLE_MASK                                                         0x00040000L
//SDMA0_QUEUE7_MINOR_PTR_UPDATE
#define SDMA0_QUEUE7_MINOR_PTR_UPDATE__ENABLE__SHIFT                                                          0x0
#define SDMA0_QUEUE7_MINOR_PTR_UPDATE__ENABLE_MASK                                                            0x00000001L
//SDMA0_QUEUE7_CONTEXT_SWITCH_STATUS
#define SDMA0_QUEUE7_CONTEXT_SWITCH_STATUS__RB_PREEMPT_STATUS__SHIFT                                          0x0
#define SDMA0_QUEUE7_CONTEXT_SWITCH_STATUS__VM_HOLE_EXCEPTION__SHIFT                                          0x1
#define SDMA0_QUEUE7_CONTEXT_SWITCH_STATUS__PAGE_EXCEPTION__SHIFT                                             0x2
#define SDMA0_QUEUE7_CONTEXT_SWITCH_STATUS__QUEUE_HANG_EXCEPTION__SHIFT                                       0x5
#define SDMA0_QUEUE7_CONTEXT_SWITCH_STATUS__DOORBELL_ERROR_EXCEPTION__SHIFT                                   0x6
#define SDMA0_QUEUE7_CONTEXT_SWITCH_STATUS__SRAM_ECC_EXCEPTION__SHIFT                                         0x7
#define SDMA0_QUEUE7_CONTEXT_SWITCH_STATUS__DRAM_ECC_EXCEPTION__SHIFT                                         0x8
#define SDMA0_QUEUE7_CONTEXT_SWITCH_STATUS__WPTR_LT_RPTR_EXCEPTION__SHIFT                                     0x9
#define SDMA0_QUEUE7_CONTEXT_SWITCH_STATUS__RB_PREEMPT_STATUS_MASK                                            0x00000001L
#define SDMA0_QUEUE7_CONTEXT_SWITCH_STATUS__VM_HOLE_EXCEPTION_MASK                                            0x00000002L
#define SDMA0_QUEUE7_CONTEXT_SWITCH_STATUS__PAGE_EXCEPTION_MASK                                               0x00000004L
#define SDMA0_QUEUE7_CONTEXT_SWITCH_STATUS__QUEUE_HANG_EXCEPTION_MASK                                         0x00000020L
#define SDMA0_QUEUE7_CONTEXT_SWITCH_STATUS__DOORBELL_ERROR_EXCEPTION_MASK                                     0x00000040L
#define SDMA0_QUEUE7_CONTEXT_SWITCH_STATUS__SRAM_ECC_EXCEPTION_MASK                                           0x00000080L
#define SDMA0_QUEUE7_CONTEXT_SWITCH_STATUS__DRAM_ECC_EXCEPTION_MASK                                           0x00000100L
#define SDMA0_QUEUE7_CONTEXT_SWITCH_STATUS__WPTR_LT_RPTR_EXCEPTION_MASK                                       0x00000200L
//SDMA0_QUEUE7_MIDCMD_CNTL
#define SDMA0_QUEUE7_MIDCMD_CNTL__DATA_VALID__SHIFT                                                           0x0
#define SDMA0_QUEUE7_MIDCMD_CNTL__COPY_MODE__SHIFT                                                            0x1
#define SDMA0_QUEUE7_MIDCMD_CNTL__SPLIT_STATE__SHIFT                                                          0x4
#define SDMA0_QUEUE7_MIDCMD_CNTL__ALLOW_PREEMPT__SHIFT                                                        0x8
#define SDMA0_QUEUE7_MIDCMD_CNTL__DATA_VALID_MASK                                                             0x00000001L
#define SDMA0_QUEUE7_MIDCMD_CNTL__COPY_MODE_MASK                                                              0x00000002L
#define SDMA0_QUEUE7_MIDCMD_CNTL__SPLIT_STATE_MASK                                                            0x000000F0L
#define SDMA0_QUEUE7_MIDCMD_CNTL__ALLOW_PREEMPT_MASK                                                          0x00000100L
//SDMA0_QUEUE7_MIDCMD_DATA0
#define SDMA0_QUEUE7_MIDCMD_DATA0__DATA0__SHIFT                                                               0x0
#define SDMA0_QUEUE7_MIDCMD_DATA0__DATA0_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE7_MIDCMD_DATA1
#define SDMA0_QUEUE7_MIDCMD_DATA1__DATA1__SHIFT                                                               0x0
#define SDMA0_QUEUE7_MIDCMD_DATA1__DATA1_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE7_MIDCMD_DATA2
#define SDMA0_QUEUE7_MIDCMD_DATA2__DATA2__SHIFT                                                               0x0
#define SDMA0_QUEUE7_MIDCMD_DATA2__DATA2_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE7_MIDCMD_DATA3
#define SDMA0_QUEUE7_MIDCMD_DATA3__DATA3__SHIFT                                                               0x0
#define SDMA0_QUEUE7_MIDCMD_DATA3__DATA3_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE7_MIDCMD_DATA4
#define SDMA0_QUEUE7_MIDCMD_DATA4__DATA4__SHIFT                                                               0x0
#define SDMA0_QUEUE7_MIDCMD_DATA4__DATA4_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE7_MIDCMD_DATA5
#define SDMA0_QUEUE7_MIDCMD_DATA5__DATA5__SHIFT                                                               0x0
#define SDMA0_QUEUE7_MIDCMD_DATA5__DATA5_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE7_MIDCMD_DATA6
#define SDMA0_QUEUE7_MIDCMD_DATA6__DATA6__SHIFT                                                               0x0
#define SDMA0_QUEUE7_MIDCMD_DATA6__DATA6_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE7_MIDCMD_DATA7
#define SDMA0_QUEUE7_MIDCMD_DATA7__DATA7__SHIFT                                                               0x0
#define SDMA0_QUEUE7_MIDCMD_DATA7__DATA7_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE7_MIDCMD_DATA8
#define SDMA0_QUEUE7_MIDCMD_DATA8__DATA8__SHIFT                                                               0x0
#define SDMA0_QUEUE7_MIDCMD_DATA8__DATA8_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE7_MIDCMD_DATA9
#define SDMA0_QUEUE7_MIDCMD_DATA9__DATA9__SHIFT                                                               0x0
#define SDMA0_QUEUE7_MIDCMD_DATA9__DATA9_MASK                                                                 0xFFFFFFFFL
//SDMA0_QUEUE7_MIDCMD_DATA10
#define SDMA0_QUEUE7_MIDCMD_DATA10__DATA10__SHIFT                                                             0x0
#define SDMA0_QUEUE7_MIDCMD_DATA10__DATA10_MASK                                                               0xFFFFFFFFL
//SDMA0_QUEUE7_WAIT_UNSATISFIED_THD
#define SDMA0_QUEUE7_WAIT_UNSATISFIED_THD__THRESHOLD__SHIFT                                                   0x0
#define SDMA0_QUEUE7_WAIT_UNSATISFIED_THD__THRESHOLD_MASK                                                     0x0000001FL
//SDMA0_QUEUE7_MQD_BASE_ADDR_LO
#define SDMA0_QUEUE7_MQD_BASE_ADDR_LO__BASE_ADDR_LO__SHIFT                                                    0x2
#define SDMA0_QUEUE7_MQD_BASE_ADDR_LO__BASE_ADDR_LO_MASK                                                      0xFFFFFFFCL
//SDMA0_QUEUE7_MQD_BASE_ADDR_HI
#define SDMA0_QUEUE7_MQD_BASE_ADDR_HI__BASE_ADDR_HI__SHIFT                                                    0x0
#define SDMA0_QUEUE7_MQD_BASE_ADDR_HI__BASE_ADDR_HI_MASK                                                      0xFFFFFFFFL
//SDMA0_QUEUE7_MQD_CONTROL
#define SDMA0_QUEUE7_MQD_CONTROL__VMID__SHIFT                                                                 0x0
#define SDMA0_QUEUE7_MQD_CONTROL__VMID_MASK                                                                   0x0000000FL
//SDMA0_QUEUE7_DEQUEUE_REQUEST
#define SDMA0_QUEUE7_DEQUEUE_REQUEST__DEQUEUE_REQ__SHIFT                                                      0x0
#define SDMA0_QUEUE7_DEQUEUE_REQUEST__DEQUEUE_REQ_MASK                                                        0x00000001L
//SDMA0_QUEUE7_CONTEXT_STATUS
#define SDMA0_QUEUE7_CONTEXT_STATUS__SELECTED__SHIFT                                                          0x0
#define SDMA0_QUEUE7_CONTEXT_STATUS__USE_IB__SHIFT                                                            0x1
#define SDMA0_QUEUE7_CONTEXT_STATUS__IDLE__SHIFT                                                              0x2
#define SDMA0_QUEUE7_CONTEXT_STATUS__EXPIRED__SHIFT                                                           0x3
#define SDMA0_QUEUE7_CONTEXT_STATUS__EXCEPTION__SHIFT                                                         0x4
#define SDMA0_QUEUE7_CONTEXT_STATUS__CTXSW_ABLE__SHIFT                                                        0x7
#define SDMA0_QUEUE7_CONTEXT_STATUS__VF_STATUS__SHIFT                                                         0x8
#define SDMA0_QUEUE7_CONTEXT_STATUS__PRIV_EXCEPTION__SHIFT                                                    0x9
#define SDMA0_QUEUE7_CONTEXT_STATUS__PREEMPT_DISABLE__SHIFT                                                   0xa
#define SDMA0_QUEUE7_CONTEXT_STATUS__RPTR_WB_IDLE__SHIFT                                                      0xb
#define SDMA0_QUEUE7_CONTEXT_STATUS__WPTR_UPDATE_PENDING__SHIFT                                               0xc
#define SDMA0_QUEUE7_CONTEXT_STATUS__WPTR_UPDATE_FAIL_COUNT__SHIFT                                            0x10
#define SDMA0_QUEUE7_CONTEXT_STATUS__SELECTED_MASK                                                            0x00000001L
#define SDMA0_QUEUE7_CONTEXT_STATUS__USE_IB_MASK                                                              0x00000002L
#define SDMA0_QUEUE7_CONTEXT_STATUS__IDLE_MASK                                                                0x00000004L
#define SDMA0_QUEUE7_CONTEXT_STATUS__EXPIRED_MASK                                                             0x00000008L
#define SDMA0_QUEUE7_CONTEXT_STATUS__EXCEPTION_MASK                                                           0x00000070L
#define SDMA0_QUEUE7_CONTEXT_STATUS__CTXSW_ABLE_MASK                                                          0x00000080L
#define SDMA0_QUEUE7_CONTEXT_STATUS__VF_STATUS_MASK                                                           0x00000100L
#define SDMA0_QUEUE7_CONTEXT_STATUS__PRIV_EXCEPTION_MASK                                                      0x00000200L
#define SDMA0_QUEUE7_CONTEXT_STATUS__PREEMPT_DISABLE_MASK                                                     0x00000400L
#define SDMA0_QUEUE7_CONTEXT_STATUS__RPTR_WB_IDLE_MASK                                                        0x00000800L
#define SDMA0_QUEUE7_CONTEXT_STATUS__WPTR_UPDATE_PENDING_MASK                                                 0x00001000L
#define SDMA0_QUEUE7_CONTEXT_STATUS__WPTR_UPDATE_FAIL_COUNT_MASK                                              0x00FF0000L


// addressBlock: gc_gfx_cpwd_sdma0_sdmahypdec
//SDMA0_VM_CTX_LO
#define SDMA0_VM_CTX_LO__ADDR__SHIFT                                                                          0x2
#define SDMA0_VM_CTX_LO__ADDR_MASK                                                                            0xFFFFFFFCL
//SDMA0_VM_CTX_HI
#define SDMA0_VM_CTX_HI__ADDR__SHIFT                                                                          0x0
#define SDMA0_VM_CTX_HI__ADDR_MASK                                                                            0xFFFFFFFFL
//SDMA0_ACTIVE_FCN_ID
#define SDMA0_ACTIVE_FCN_ID__VFID__SHIFT                                                                      0x0
#define SDMA0_ACTIVE_FCN_ID__VF__SHIFT                                                                        0x7
#define SDMA0_ACTIVE_FCN_ID__RESERVED__SHIFT                                                                  0x8
#define SDMA0_ACTIVE_FCN_ID__VFID_MASK                                                                        0x0000001FL
#define SDMA0_ACTIVE_FCN_ID__VF_MASK                                                                          0x00000080L
#define SDMA0_ACTIVE_FCN_ID__RESERVED_MASK                                                                    0xFFFFFF00L
//SDMA0_VIRT_RESET_REQ
#define SDMA0_VIRT_RESET_REQ__VF__SHIFT                                                                       0x0
#define SDMA0_VIRT_RESET_REQ__PF__SHIFT                                                                       0x1f
#define SDMA0_VIRT_RESET_REQ__VF_MASK                                                                         0x7FFFFFFFL
#define SDMA0_VIRT_RESET_REQ__PF_MASK                                                                         0x80000000L
//SDMA0_VM_CNTL
#define SDMA0_VM_CNTL__CMD__SHIFT                                                                             0x0
#define SDMA0_VM_CNTL__CMD_MASK                                                                               0x0000000FL
//SDMA0_MCU_CNTL
#define SDMA0_MCU_CNTL__HALT__SHIFT                                                                           0x0
#define SDMA0_MCU_CNTL__RESET__SHIFT                                                                          0x1
#define SDMA0_MCU_CNTL__DBG_SELECT_BITS__SHIFT                                                                0x2
#define SDMA0_MCU_CNTL__HALT_MASK                                                                             0x00000001L
#define SDMA0_MCU_CNTL__RESET_MASK                                                                            0x00000002L
#define SDMA0_MCU_CNTL__DBG_SELECT_BITS_MASK                                                                  0x000000FCL
//SDMA0_IC_BASE_LO
#define SDMA0_IC_BASE_LO__IC_BASE_LO__SHIFT                                                                   0xc
#define SDMA0_IC_BASE_LO__IC_BASE_LO_MASK                                                                     0xFFFFF000L
//SDMA0_IC_BASE_HI
#define SDMA0_IC_BASE_HI__IC_BASE_HI__SHIFT                                                                   0x0
#define SDMA0_IC_BASE_HI__IC_BASE_HI_MASK                                                                     0xFFFFFFFFL
//SDMA0_IC_BASE_CNTL
#define SDMA0_IC_BASE_CNTL__VMID__SHIFT                                                                       0x0
#define SDMA0_IC_BASE_CNTL__EXE_DISABLE__SHIFT                                                                0x17
#define SDMA0_IC_BASE_CNTL__MALL_POLICY__SHIFT                                                                0x18
#define SDMA0_IC_BASE_CNTL__VMID_MASK                                                                         0x0000000FL
#define SDMA0_IC_BASE_CNTL__EXE_DISABLE_MASK                                                                  0x00800000L
#define SDMA0_IC_BASE_CNTL__MALL_POLICY_MASK                                                                  0x03000000L
//SDMA0_IC_OP_CNTL
#define SDMA0_IC_OP_CNTL__INVALIDATE_CACHE__SHIFT                                                             0x0
#define SDMA0_IC_OP_CNTL__PRIME_ICACHE__SHIFT                                                                 0x4
#define SDMA0_IC_OP_CNTL__ICACHE_PRIMED__SHIFT                                                                0x5
#define SDMA0_IC_OP_CNTL__INVALIDATE_CACHE_MASK                                                               0x00000001L
#define SDMA0_IC_OP_CNTL__PRIME_ICACHE_MASK                                                                   0x00000010L
#define SDMA0_IC_OP_CNTL__ICACHE_PRIMED_MASK                                                                  0x00000020L
//SDMA0_IC_CNTL
#define SDMA0_IC_CNTL__CID_SEL__SHIFT                                                                         0x0
#define SDMA0_IC_CNTL__GPA__SHIFT                                                                             0x2
#define SDMA0_IC_CNTL__UCODE_VF_OVERRIDE__SHIFT                                                               0x4
#define SDMA0_IC_CNTL__AUTO_PRIME_ICACHE__SHIFT                                                               0x5
#define SDMA0_IC_CNTL__CID_SEL_MASK                                                                           0x00000001L
#define SDMA0_IC_CNTL__GPA_MASK                                                                               0x0000000CL
#define SDMA0_IC_CNTL__UCODE_VF_OVERRIDE_MASK                                                                 0x00000010L
#define SDMA0_IC_CNTL__AUTO_PRIME_ICACHE_MASK                                                                 0x00000020L


// addressBlock: gc_gfx_cpwd_sdma0_sdmapspdec
//SDMA0_MCU_DM_FROM_RST_ADDR_OFFSET
#define SDMA0_MCU_DM_FROM_RST_ADDR_OFFSET__DATA__SHIFT                                                        0x0
#define SDMA0_MCU_DM_FROM_RST_ADDR_OFFSET__DATA_MASK                                                          0xFFFFFFFFL


// addressBlock: gc_gfx_cpwd_sdma0_sdmaperfsdec
//SDMA0_PERFCNT_PERFCOUNTER0_CFG
#define SDMA0_PERFCNT_PERFCOUNTER0_CFG__PERF_SEL__SHIFT                                                       0x0
#define SDMA0_PERFCNT_PERFCOUNTER0_CFG__PERF_SEL_END__SHIFT                                                   0x8
#define SDMA0_PERFCNT_PERFCOUNTER0_CFG__PERF_MODE__SHIFT                                                      0x18
#define SDMA0_PERFCNT_PERFCOUNTER0_CFG__ENABLE__SHIFT                                                         0x1c
#define SDMA0_PERFCNT_PERFCOUNTER0_CFG__CLEAR__SHIFT                                                          0x1d
#define SDMA0_PERFCNT_PERFCOUNTER0_CFG__PERF_SEL_MASK                                                         0x000000FFL
#define SDMA0_PERFCNT_PERFCOUNTER0_CFG__PERF_SEL_END_MASK                                                     0x0000FF00L
#define SDMA0_PERFCNT_PERFCOUNTER0_CFG__PERF_MODE_MASK                                                        0x0F000000L
#define SDMA0_PERFCNT_PERFCOUNTER0_CFG__ENABLE_MASK                                                           0x10000000L
#define SDMA0_PERFCNT_PERFCOUNTER0_CFG__CLEAR_MASK                                                            0x20000000L
//SDMA0_PERFCNT_PERFCOUNTER1_CFG
#define SDMA0_PERFCNT_PERFCOUNTER1_CFG__PERF_SEL__SHIFT                                                       0x0
#define SDMA0_PERFCNT_PERFCOUNTER1_CFG__PERF_SEL_END__SHIFT                                                   0x8
#define SDMA0_PERFCNT_PERFCOUNTER1_CFG__PERF_MODE__SHIFT                                                      0x18
#define SDMA0_PERFCNT_PERFCOUNTER1_CFG__ENABLE__SHIFT                                                         0x1c
#define SDMA0_PERFCNT_PERFCOUNTER1_CFG__CLEAR__SHIFT                                                          0x1d
#define SDMA0_PERFCNT_PERFCOUNTER1_CFG__PERF_SEL_MASK                                                         0x000000FFL
#define SDMA0_PERFCNT_PERFCOUNTER1_CFG__PERF_SEL_END_MASK                                                     0x0000FF00L
#define SDMA0_PERFCNT_PERFCOUNTER1_CFG__PERF_MODE_MASK                                                        0x0F000000L
#define SDMA0_PERFCNT_PERFCOUNTER1_CFG__ENABLE_MASK                                                           0x10000000L
#define SDMA0_PERFCNT_PERFCOUNTER1_CFG__CLEAR_MASK                                                            0x20000000L
//SDMA0_PERFCNT_PERFCOUNTER_RSLT_CNTL
#define SDMA0_PERFCNT_PERFCOUNTER_RSLT_CNTL__PERF_COUNTER_SELECT__SHIFT                                       0x0
#define SDMA0_PERFCNT_PERFCOUNTER_RSLT_CNTL__START_TRIGGER__SHIFT                                             0x8
#define SDMA0_PERFCNT_PERFCOUNTER_RSLT_CNTL__STOP_TRIGGER__SHIFT                                              0x10
#define SDMA0_PERFCNT_PERFCOUNTER_RSLT_CNTL__ENABLE_ANY__SHIFT                                                0x18
#define SDMA0_PERFCNT_PERFCOUNTER_RSLT_CNTL__CLEAR_ALL__SHIFT                                                 0x19
#define SDMA0_PERFCNT_PERFCOUNTER_RSLT_CNTL__STOP_ALL_ON_SATURATE__SHIFT                                      0x1a
#define SDMA0_PERFCNT_PERFCOUNTER_RSLT_CNTL__PERF_COUNTER_SELECT_MASK                                         0x0000000FL
#define SDMA0_PERFCNT_PERFCOUNTER_RSLT_CNTL__START_TRIGGER_MASK                                               0x0000FF00L
#define SDMA0_PERFCNT_PERFCOUNTER_RSLT_CNTL__STOP_TRIGGER_MASK                                                0x00FF0000L
#define SDMA0_PERFCNT_PERFCOUNTER_RSLT_CNTL__ENABLE_ANY_MASK                                                  0x01000000L
#define SDMA0_PERFCNT_PERFCOUNTER_RSLT_CNTL__CLEAR_ALL_MASK                                                   0x02000000L
#define SDMA0_PERFCNT_PERFCOUNTER_RSLT_CNTL__STOP_ALL_ON_SATURATE_MASK                                        0x04000000L
//SDMA0_PERFCNT_MISC_CNTL
#define SDMA0_PERFCNT_MISC_CNTL__CMD_OP__SHIFT                                                                0x0
#define SDMA0_PERFCNT_MISC_CNTL__CMD_OP_MASK                                                                  0x0000FFFFL
//SDMA0_PERFCOUNTER0_SELECT
#define SDMA0_PERFCOUNTER0_SELECT__PERF_SEL__SHIFT                                                            0x0
#define SDMA0_PERFCOUNTER0_SELECT__PERF_SEL1__SHIFT                                                           0xa
#define SDMA0_PERFCOUNTER0_SELECT__CNTR_MODE__SHIFT                                                           0x14
#define SDMA0_PERFCOUNTER0_SELECT__PERF_MODE1__SHIFT                                                          0x18
#define SDMA0_PERFCOUNTER0_SELECT__PERF_MODE__SHIFT                                                           0x1c
#define SDMA0_PERFCOUNTER0_SELECT__PERF_SEL_MASK                                                              0x000003FFL
#define SDMA0_PERFCOUNTER0_SELECT__PERF_SEL1_MASK                                                             0x000FFC00L
#define SDMA0_PERFCOUNTER0_SELECT__CNTR_MODE_MASK                                                             0x00F00000L
#define SDMA0_PERFCOUNTER0_SELECT__PERF_MODE1_MASK                                                            0x0F000000L
#define SDMA0_PERFCOUNTER0_SELECT__PERF_MODE_MASK                                                             0xF0000000L
//SDMA0_PERFCOUNTER0_SELECT1
#define SDMA0_PERFCOUNTER0_SELECT1__PERF_SEL2__SHIFT                                                          0x0
#define SDMA0_PERFCOUNTER0_SELECT1__PERF_SEL3__SHIFT                                                          0xa
#define SDMA0_PERFCOUNTER0_SELECT1__PERF_MODE3__SHIFT                                                         0x18
#define SDMA0_PERFCOUNTER0_SELECT1__PERF_MODE2__SHIFT                                                         0x1c
#define SDMA0_PERFCOUNTER0_SELECT1__PERF_SEL2_MASK                                                            0x000003FFL
#define SDMA0_PERFCOUNTER0_SELECT1__PERF_SEL3_MASK                                                            0x000FFC00L
#define SDMA0_PERFCOUNTER0_SELECT1__PERF_MODE3_MASK                                                           0x0F000000L
#define SDMA0_PERFCOUNTER0_SELECT1__PERF_MODE2_MASK                                                           0xF0000000L
//SDMA0_PERFCOUNTER1_SELECT
#define SDMA0_PERFCOUNTER1_SELECT__PERF_SEL__SHIFT                                                            0x0
#define SDMA0_PERFCOUNTER1_SELECT__PERF_SEL1__SHIFT                                                           0xa
#define SDMA0_PERFCOUNTER1_SELECT__CNTR_MODE__SHIFT                                                           0x14
#define SDMA0_PERFCOUNTER1_SELECT__PERF_MODE1__SHIFT                                                          0x18
#define SDMA0_PERFCOUNTER1_SELECT__PERF_MODE__SHIFT                                                           0x1c
#define SDMA0_PERFCOUNTER1_SELECT__PERF_SEL_MASK                                                              0x000003FFL
#define SDMA0_PERFCOUNTER1_SELECT__PERF_SEL1_MASK                                                             0x000FFC00L
#define SDMA0_PERFCOUNTER1_SELECT__CNTR_MODE_MASK                                                             0x00F00000L
#define SDMA0_PERFCOUNTER1_SELECT__PERF_MODE1_MASK                                                            0x0F000000L
#define SDMA0_PERFCOUNTER1_SELECT__PERF_MODE_MASK                                                             0xF0000000L
//SDMA0_PERFCOUNTER1_SELECT1
#define SDMA0_PERFCOUNTER1_SELECT1__PERF_SEL2__SHIFT                                                          0x0
#define SDMA0_PERFCOUNTER1_SELECT1__PERF_SEL3__SHIFT                                                          0xa
#define SDMA0_PERFCOUNTER1_SELECT1__PERF_MODE3__SHIFT                                                         0x18
#define SDMA0_PERFCOUNTER1_SELECT1__PERF_MODE2__SHIFT                                                         0x1c
#define SDMA0_PERFCOUNTER1_SELECT1__PERF_SEL2_MASK                                                            0x000003FFL
#define SDMA0_PERFCOUNTER1_SELECT1__PERF_SEL3_MASK                                                            0x000FFC00L
#define SDMA0_PERFCOUNTER1_SELECT1__PERF_MODE3_MASK                                                           0x0F000000L
#define SDMA0_PERFCOUNTER1_SELECT1__PERF_MODE2_MASK                                                           0xF0000000L


// addressBlock: gc_gfx_cpwd_sdma0_sdmaperfddec
//SDMA0_PERFCNT_PERFCOUNTER_LO
#define SDMA0_PERFCNT_PERFCOUNTER_LO__COUNTER_LO__SHIFT                                                       0x0
#define SDMA0_PERFCNT_PERFCOUNTER_LO__COUNTER_LO_MASK                                                         0xFFFFFFFFL
//SDMA0_PERFCNT_PERFCOUNTER_HI
#define SDMA0_PERFCNT_PERFCOUNTER_HI__COUNTER_HI__SHIFT                                                       0x0
#define SDMA0_PERFCNT_PERFCOUNTER_HI__COMPARE_VALUE__SHIFT                                                    0x10
#define SDMA0_PERFCNT_PERFCOUNTER_HI__COUNTER_HI_MASK                                                         0x0000FFFFL
#define SDMA0_PERFCNT_PERFCOUNTER_HI__COMPARE_VALUE_MASK                                                      0xFFFF0000L
//SDMA0_PERFCOUNTER0_LO
#define SDMA0_PERFCOUNTER0_LO__PERFCOUNTER_LO__SHIFT                                                          0x0
#define SDMA0_PERFCOUNTER0_LO__PERFCOUNTER_LO_MASK                                                            0xFFFFFFFFL
//SDMA0_PERFCOUNTER0_HI
#define SDMA0_PERFCOUNTER0_HI__PERFCOUNTER_HI__SHIFT                                                          0x0
#define SDMA0_PERFCOUNTER0_HI__PERFCOUNTER_HI_MASK                                                            0xFFFFFFFFL
//SDMA0_PERFCOUNTER1_LO
#define SDMA0_PERFCOUNTER1_LO__PERFCOUNTER_LO__SHIFT                                                          0x0
#define SDMA0_PERFCOUNTER1_LO__PERFCOUNTER_LO_MASK                                                            0xFFFFFFFFL
//SDMA0_PERFCOUNTER1_HI
#define SDMA0_PERFCOUNTER1_HI__PERFCOUNTER_HI__SHIFT                                                          0x0
#define SDMA0_PERFCOUNTER1_HI__PERFCOUNTER_HI_MASK                                                            0xFFFFFFFFL


// addressBlock: gc_gfx_cpwd_sdma0_sdmapwrdec
//GFX_ICG_SDMA0_CTRL
#define GFX_ICG_SDMA0_CTRL__REG_MGCG_CLK_SOFT_OVERRIDE__SHIFT                                                 0x1
#define GFX_ICG_SDMA0_CTRL__PTR_MGCG_CLK_SOFT_OVERRIDE__SHIFT                                                 0x2
#define GFX_ICG_SDMA0_CTRL__PIO_MGCG_CLK_SOFT_OVERRIDE__SHIFT                                                 0x3
#define GFX_ICG_SDMA0_CTRL__MCU_MGCG_CLK_SOFT_OVERRIDE__SHIFT                                                 0x4
#define GFX_ICG_SDMA0_CTRL__COPY_ENG_MGCG_CLK_SOFT_OVERRIDE__SHIFT                                            0x5
#define GFX_ICG_SDMA0_CTRL__SERVE_ENG_MGCG_CLK_SOFT_OVERRIDE__SHIFT                                           0x6
#define GFX_ICG_SDMA0_CTRL__CMD_FETCH_MGCG_CLK_SOFT_OVERRIDE__SHIFT                                           0x7
#define GFX_ICG_SDMA0_CTRL__GU_MEMREQ_MGCG_CLK_SOFT_OVERRIDE__SHIFT                                           0x8
#define GFX_ICG_SDMA0_CTRL__INV_MGCG_CLK_SOFT_OVERRIDE__SHIFT                                                 0x9
#define GFX_ICG_SDMA0_CTRL__GU_CACHE_MGCG_CLK_SOFT_OVERRIDE__SHIFT                                            0xa
#define GFX_ICG_SDMA0_CTRL__IC_CACHE_MGCG_CLK_SOFT_OVERRIDE__SHIFT                                            0xb
#define GFX_ICG_SDMA0_CTRL__MEM_CHNL_MGCG_CLK_SOFT_OVERRIDE__SHIFT                                            0xc
#define GFX_ICG_SDMA0_CTRL__PERF_CNTR_MGCG_CLK_SOFT_OVERRIDE__SHIFT                                           0xd
#define GFX_ICG_SDMA0_CTRL__CORE_MGCG_CLK_SOFT_OVERRIDE__SHIFT                                                0xe
#define GFX_ICG_SDMA0_CTRL__MEM_CHNL_CESE_MGCG_CLK_SOFT_OVERRIDE__SHIFT                                       0xf
#define GFX_ICG_SDMA0_CTRL__MGCG_CLK_HYST__SHIFT                                                              0x10
#define GFX_ICG_SDMA0_CTRL__REG_MGCG_CLK_SOFT_OVERRIDE_MASK                                                   0x00000002L
#define GFX_ICG_SDMA0_CTRL__PTR_MGCG_CLK_SOFT_OVERRIDE_MASK                                                   0x00000004L
#define GFX_ICG_SDMA0_CTRL__PIO_MGCG_CLK_SOFT_OVERRIDE_MASK                                                   0x00000008L
#define GFX_ICG_SDMA0_CTRL__MCU_MGCG_CLK_SOFT_OVERRIDE_MASK                                                   0x00000010L
#define GFX_ICG_SDMA0_CTRL__COPY_ENG_MGCG_CLK_SOFT_OVERRIDE_MASK                                              0x00000020L
#define GFX_ICG_SDMA0_CTRL__SERVE_ENG_MGCG_CLK_SOFT_OVERRIDE_MASK                                             0x00000040L
#define GFX_ICG_SDMA0_CTRL__CMD_FETCH_MGCG_CLK_SOFT_OVERRIDE_MASK                                             0x00000080L
#define GFX_ICG_SDMA0_CTRL__GU_MEMREQ_MGCG_CLK_SOFT_OVERRIDE_MASK                                             0x00000100L
#define GFX_ICG_SDMA0_CTRL__INV_MGCG_CLK_SOFT_OVERRIDE_MASK                                                   0x00000200L
#define GFX_ICG_SDMA0_CTRL__GU_CACHE_MGCG_CLK_SOFT_OVERRIDE_MASK                                              0x00000400L
#define GFX_ICG_SDMA0_CTRL__IC_CACHE_MGCG_CLK_SOFT_OVERRIDE_MASK                                              0x00000800L
#define GFX_ICG_SDMA0_CTRL__MEM_CHNL_MGCG_CLK_SOFT_OVERRIDE_MASK                                              0x00001000L
#define GFX_ICG_SDMA0_CTRL__PERF_CNTR_MGCG_CLK_SOFT_OVERRIDE_MASK                                             0x00002000L
#define GFX_ICG_SDMA0_CTRL__CORE_MGCG_CLK_SOFT_OVERRIDE_MASK                                                  0x00004000L
#define GFX_ICG_SDMA0_CTRL__MEM_CHNL_CESE_MGCG_CLK_SOFT_OVERRIDE_MASK                                         0x00008000L
#define GFX_ICG_SDMA0_CTRL__MGCG_CLK_HYST_MASK                                                                0x00FF0000L


// addressBlock: gc_gfx_cpwd_sdma0_sdmadec:1
//SDMA1_DEC_START
#define SDMA1_DEC_START__START__SHIFT                                                                         0x0
#define SDMA1_DEC_START__START_MASK                                                                           0xFFFFFFFFL
//SDMA1_MCU_MISC_CNTL
#define SDMA1_MCU_MISC_CNTL__MCU_WAKEUP__SHIFT                                                                0x0
#define SDMA1_MCU_MISC_CNTL__MCU_WAKEUP_MASK                                                                  0x00000001L
//SDMA1_UCODE_REV
#define SDMA1_UCODE_REV__CL__SHIFT                                                                            0x0
#define SDMA1_UCODE_REV__VARIANT_ID__SHIFT                                                                    0x1c
#define SDMA1_UCODE_REV__CL_MASK                                                                              0x0FFFFFFFL
#define SDMA1_UCODE_REV__VARIANT_ID_MASK                                                                      0xF0000000L
//SDMA1_GLOBAL_TIMESTAMP_LO
#define SDMA1_GLOBAL_TIMESTAMP_LO__DATA__SHIFT                                                                0x0
#define SDMA1_GLOBAL_TIMESTAMP_LO__DATA_MASK                                                                  0xFFFFFFFFL
//SDMA1_GLOBAL_TIMESTAMP_HI
#define SDMA1_GLOBAL_TIMESTAMP_HI__DATA__SHIFT                                                                0x0
#define SDMA1_GLOBAL_TIMESTAMP_HI__DATA_MASK                                                                  0xFFFFFFFFL
//SDMA1_POWER_CNTL
#define SDMA1_POWER_CNTL__LS_ENABLE__SHIFT                                                                    0x8
#define SDMA1_POWER_CNTL__LS_ENABLE_MASK                                                                      0x00000100L
//SDMA1_CNTL
#define SDMA1_CNTL__TRAP_ENABLE__SHIFT                                                                        0x0
#define SDMA1_CNTL__RESERVED__SHIFT                                                                           0x2
#define SDMA1_CNTL__DATA_SWAP_ENABLE__SHIFT                                                                   0x3
#define SDMA1_CNTL__FENCE_SWAP_ENABLE__SHIFT                                                                  0x4
#define SDMA1_CNTL__MIDCMD_PREEMPT_ENABLE__SHIFT                                                              0x5
#define SDMA1_CNTL__PIO_DONE_ACK_ENABLE__SHIFT                                                                0x6
#define SDMA1_CNTL__TMZ_MIDCMD_PREEMPT_ENABLE__SHIFT                                                          0x8
#define SDMA1_CNTL__MIDCMD_EXPIRE_ENABLE__SHIFT                                                               0x9
#define SDMA1_CNTL__CP_MES_INT_ENABLE__SHIFT                                                                  0xa
#define SDMA1_CNTL__PAGE_RETRY_TIMEOUT_INT_ENABLE__SHIFT                                                      0xb
#define SDMA1_CNTL__PAGE_NULL_INT_ENABLE__SHIFT                                                               0xc
#define SDMA1_CNTL__PAGE_FAULT_INT_ENABLE__SHIFT                                                              0xd
#define SDMA1_CNTL__CH_PERFCNT_ENABLE__SHIFT                                                                  0x10
#define SDMA1_CNTL__MIDCMD_WORLDSWITCH_ENABLE__SHIFT                                                          0x11
#define SDMA1_CNTL__CTXEMPTY_INT_ENABLE__SHIFT                                                                0x1c
#define SDMA1_CNTL__FROZEN_INT_ENABLE__SHIFT                                                                  0x1d
#define SDMA1_CNTL__IB_PREEMPT_INT_ENABLE__SHIFT                                                              0x1e
#define SDMA1_CNTL__RB_PREEMPT_INT_ENABLE__SHIFT                                                              0x1f
#define SDMA1_CNTL__TRAP_ENABLE_MASK                                                                          0x00000001L
#define SDMA1_CNTL__RESERVED_MASK                                                                             0x00000004L
#define SDMA1_CNTL__DATA_SWAP_ENABLE_MASK                                                                     0x00000008L
#define SDMA1_CNTL__FENCE_SWAP_ENABLE_MASK                                                                    0x00000010L
#define SDMA1_CNTL__MIDCMD_PREEMPT_ENABLE_MASK                                                                0x00000020L
#define SDMA1_CNTL__PIO_DONE_ACK_ENABLE_MASK                                                                  0x00000040L
#define SDMA1_CNTL__TMZ_MIDCMD_PREEMPT_ENABLE_MASK                                                            0x00000100L
#define SDMA1_CNTL__MIDCMD_EXPIRE_ENABLE_MASK                                                                 0x00000200L
#define SDMA1_CNTL__CP_MES_INT_ENABLE_MASK                                                                    0x00000400L
#define SDMA1_CNTL__PAGE_RETRY_TIMEOUT_INT_ENABLE_MASK                                                        0x00000800L
#define SDMA1_CNTL__PAGE_NULL_INT_ENABLE_MASK                                                                 0x00001000L
#define SDMA1_CNTL__PAGE_FAULT_INT_ENABLE_MASK                                                                0x00002000L
#define SDMA1_CNTL__CH_PERFCNT_ENABLE_MASK                                                                    0x00010000L
#define SDMA1_CNTL__MIDCMD_WORLDSWITCH_ENABLE_MASK                                                            0x00020000L
#define SDMA1_CNTL__CTXEMPTY_INT_ENABLE_MASK                                                                  0x10000000L
#define SDMA1_CNTL__FROZEN_INT_ENABLE_MASK                                                                    0x20000000L
#define SDMA1_CNTL__IB_PREEMPT_INT_ENABLE_MASK                                                                0x40000000L
#define SDMA1_CNTL__RB_PREEMPT_INT_ENABLE_MASK                                                                0x80000000L
//SDMA1_CHICKEN_BITS
#define SDMA1_CHICKEN_BITS__SRBM_POLL_RETRYING__SHIFT                                                         0x5
#define SDMA1_CHICKEN_BITS__RD_BURST__SHIFT                                                                   0x6
#define SDMA1_CHICKEN_BITS__WR_BURST__SHIFT                                                                   0x8
#define SDMA1_CHICKEN_BITS__COMBINE_256B_WAIT_CYCLE__SHIFT                                                    0xa
#define SDMA1_CHICKEN_BITS__WR_COMBINE_256B_ENABLE__SHIFT                                                     0xe
#define SDMA1_CHICKEN_BITS__RD_COMBINE_256B_ENABLE__SHIFT                                                     0xf
#define SDMA1_CHICKEN_BITS__COPY_OVERLAP_ENABLE__SHIFT                                                        0x10
#define SDMA1_CHICKEN_BITS__RAW_CHECK_ENABLE__SHIFT                                                           0x11
#define SDMA1_CHICKEN_BITS__T2L_256B_ENABLE__SHIFT                                                            0x12
#define SDMA1_CHICKEN_BITS__SOFT_OVERRIDE_GCR_FGCG__SHIFT                                                     0x13
#define SDMA1_CHICKEN_BITS__SOFT_OVERRIDE_GRBM_FGCG__SHIFT                                                    0x14
#define SDMA1_CHICKEN_BITS__SOFT_OVERRIDE_CH_FGCG__SHIFT                                                      0x15
#define SDMA1_CHICKEN_BITS__SOFT_OVERRIDE_UTCL2_INVREQ_FGCG__SHIFT                                            0x16
#define SDMA1_CHICKEN_BITS__SOFT_OVERRIDE_UTCL1_FGCG__SHIFT                                                   0x17
#define SDMA1_CHICKEN_BITS__CG_STATUS_OUTPUT__SHIFT                                                           0x18
#define SDMA1_CHICKEN_BITS__SW_FREEZE_ENABLE__SHIFT                                                           0x19
#define SDMA1_CHICKEN_BITS__DRAM_ECC_COPY_MODE_CNTL__SHIFT                                                    0x1a
#define SDMA1_CHICKEN_BITS__SOFT_OVERRIDE_REG_ADDR_CHECK__SHIFT                                               0x1b
#define SDMA1_CHICKEN_BITS__RESERVED__SHIFT                                                                   0x1c
#define SDMA1_CHICKEN_BITS__SRBM_POLL_RETRYING_MASK                                                           0x00000020L
#define SDMA1_CHICKEN_BITS__RD_BURST_MASK                                                                     0x000000C0L
#define SDMA1_CHICKEN_BITS__WR_BURST_MASK                                                                     0x00000300L
#define SDMA1_CHICKEN_BITS__COMBINE_256B_WAIT_CYCLE_MASK                                                      0x00003C00L
#define SDMA1_CHICKEN_BITS__WR_COMBINE_256B_ENABLE_MASK                                                       0x00004000L
#define SDMA1_CHICKEN_BITS__RD_COMBINE_256B_ENABLE_MASK                                                       0x00008000L
#define SDMA1_CHICKEN_BITS__COPY_OVERLAP_ENABLE_MASK                                                          0x00010000L
#define SDMA1_CHICKEN_BITS__RAW_CHECK_ENABLE_MASK                                                             0x00020000L
#define SDMA1_CHICKEN_BITS__T2L_256B_ENABLE_MASK                                                              0x00040000L
#define SDMA1_CHICKEN_BITS__SOFT_OVERRIDE_GCR_FGCG_MASK                                                       0x00080000L
#define SDMA1_CHICKEN_BITS__SOFT_OVERRIDE_GRBM_FGCG_MASK                                                      0x00100000L
#define SDMA1_CHICKEN_BITS__SOFT_OVERRIDE_CH_FGCG_MASK                                                        0x00200000L
#define SDMA1_CHICKEN_BITS__SOFT_OVERRIDE_UTCL2_INVREQ_FGCG_MASK                                              0x00400000L
#define SDMA1_CHICKEN_BITS__SOFT_OVERRIDE_UTCL1_FGCG_MASK                                                     0x00800000L
#define SDMA1_CHICKEN_BITS__CG_STATUS_OUTPUT_MASK                                                             0x01000000L
#define SDMA1_CHICKEN_BITS__SW_FREEZE_ENABLE_MASK                                                             0x02000000L
#define SDMA1_CHICKEN_BITS__DRAM_ECC_COPY_MODE_CNTL_MASK                                                      0x04000000L
#define SDMA1_CHICKEN_BITS__SOFT_OVERRIDE_REG_ADDR_CHECK_MASK                                                 0x08000000L
#define SDMA1_CHICKEN_BITS__RESERVED_MASK                                                                     0xF0000000L
//SDMA1_CACHE_CNTL
#define SDMA1_CACHE_CNTL__RD_MALL_POLICY__SHIFT                                                               0x0
#define SDMA1_CACHE_CNTL__WR_MALL_POLICY__SHIFT                                                               0x2
#define SDMA1_CACHE_CNTL__RD_MALL_POLICY_MASK                                                                 0x00000003L
#define SDMA1_CACHE_CNTL__WR_MALL_POLICY_MASK                                                                 0x0000000CL
//SDMA1_RB_RPTR_FETCH
#define SDMA1_RB_RPTR_FETCH__OFFSET__SHIFT                                                                    0x2
#define SDMA1_RB_RPTR_FETCH__OFFSET_MASK                                                                      0xFFFFFFFCL
//SDMA1_RB_RPTR_FETCH_HI
#define SDMA1_RB_RPTR_FETCH_HI__OFFSET__SHIFT                                                                 0x0
#define SDMA1_RB_RPTR_FETCH_HI__OFFSET_MASK                                                                   0xFFFFFFFFL
//SDMA1_IB_OFFSET_FETCH
#define SDMA1_IB_OFFSET_FETCH__OFFSET__SHIFT                                                                  0x2
#define SDMA1_IB_OFFSET_FETCH__OFFSET_MASK                                                                    0x003FFFFCL
//SDMA1_PROGRAM
#define SDMA1_PROGRAM__STREAM__SHIFT                                                                          0x0
#define SDMA1_PROGRAM__STREAM_MASK                                                                            0xFFFFFFFFL
//SDMA1_STATUS_REG
#define SDMA1_STATUS_REG__IDLE__SHIFT                                                                         0x0
#define SDMA1_STATUS_REG__REG_IDLE__SHIFT                                                                     0x1
#define SDMA1_STATUS_REG__RB_EMPTY__SHIFT                                                                     0x2
#define SDMA1_STATUS_REG__RB_FULL__SHIFT                                                                      0x3
#define SDMA1_STATUS_REG__RB_CMD_IDLE__SHIFT                                                                  0x4
#define SDMA1_STATUS_REG__RB_CMD_FULL__SHIFT                                                                  0x5
#define SDMA1_STATUS_REG__IB_CMD_IDLE__SHIFT                                                                  0x6
#define SDMA1_STATUS_REG__IB_CMD_FULL__SHIFT                                                                  0x7
#define SDMA1_STATUS_REG__BLOCK_IDLE__SHIFT                                                                   0x8
#define SDMA1_STATUS_REG__INSIDE_IB__SHIFT                                                                    0x9
#define SDMA1_STATUS_REG__FETCH_IDLE__SHIFT                                                                   0xa
#define SDMA1_STATUS_REG__CGCG_FENCE__SHIFT                                                                   0xb
#define SDMA1_STATUS_REG__PACKET_READY__SHIFT                                                                 0xc
#define SDMA1_STATUS_REG__MC_WR_IDLE__SHIFT                                                                   0xd
#define SDMA1_STATUS_REG__SRBM_IDLE__SHIFT                                                                    0xe
#define SDMA1_STATUS_REG__CONTEXT_EMPTY__SHIFT                                                                0xf
#define SDMA1_STATUS_REG__DELTA_RPTR_FULL__SHIFT                                                              0x10
#define SDMA1_STATUS_REG__RB_MC_RREQ_IDLE__SHIFT                                                              0x11
#define SDMA1_STATUS_REG__IB_MC_RREQ_IDLE__SHIFT                                                              0x12
#define SDMA1_STATUS_REG__MC_RD_IDLE__SHIFT                                                                   0x13
#define SDMA1_STATUS_REG__DELTA_RPTR_EMPTY__SHIFT                                                             0x14
#define SDMA1_STATUS_REG__EXEC_ENG_IDLE__SHIFT                                                                0x19
#define SDMA1_STATUS_REG__PROC_CNTL_IDLE__SHIFT                                                               0x1a
#define SDMA1_STATUS_REG__UCODE_INIT_DONE__SHIFT                                                              0x1b
#define SDMA1_STATUS_REG__RESERVED__SHIFT                                                                     0x1d
#define SDMA1_STATUS_REG__INT_IDLE__SHIFT                                                                     0x1e
#define SDMA1_STATUS_REG__INT_REQ_STALL__SHIFT                                                                0x1f
#define SDMA1_STATUS_REG__IDLE_MASK                                                                           0x00000001L
#define SDMA1_STATUS_REG__REG_IDLE_MASK                                                                       0x00000002L
#define SDMA1_STATUS_REG__RB_EMPTY_MASK                                                                       0x00000004L
#define SDMA1_STATUS_REG__RB_FULL_MASK                                                                        0x00000008L
#define SDMA1_STATUS_REG__RB_CMD_IDLE_MASK                                                                    0x00000010L
#define SDMA1_STATUS_REG__RB_CMD_FULL_MASK                                                                    0x00000020L
#define SDMA1_STATUS_REG__IB_CMD_IDLE_MASK                                                                    0x00000040L
#define SDMA1_STATUS_REG__IB_CMD_FULL_MASK                                                                    0x00000080L
#define SDMA1_STATUS_REG__BLOCK_IDLE_MASK                                                                     0x00000100L
#define SDMA1_STATUS_REG__INSIDE_IB_MASK                                                                      0x00000200L
#define SDMA1_STATUS_REG__FETCH_IDLE_MASK                                                                     0x00000400L
#define SDMA1_STATUS_REG__CGCG_FENCE_MASK                                                                     0x00000800L
#define SDMA1_STATUS_REG__PACKET_READY_MASK                                                                   0x00001000L
#define SDMA1_STATUS_REG__MC_WR_IDLE_MASK                                                                     0x00002000L
#define SDMA1_STATUS_REG__SRBM_IDLE_MASK                                                                      0x00004000L
#define SDMA1_STATUS_REG__CONTEXT_EMPTY_MASK                                                                  0x00008000L
#define SDMA1_STATUS_REG__DELTA_RPTR_FULL_MASK                                                                0x00010000L
#define SDMA1_STATUS_REG__RB_MC_RREQ_IDLE_MASK                                                                0x00020000L
#define SDMA1_STATUS_REG__IB_MC_RREQ_IDLE_MASK                                                                0x00040000L
#define SDMA1_STATUS_REG__MC_RD_IDLE_MASK                                                                     0x00080000L
#define SDMA1_STATUS_REG__DELTA_RPTR_EMPTY_MASK                                                               0x00100000L
#define SDMA1_STATUS_REG__EXEC_ENG_IDLE_MASK                                                                  0x02000000L
#define SDMA1_STATUS_REG__PROC_CNTL_IDLE_MASK                                                                 0x04000000L
#define SDMA1_STATUS_REG__UCODE_INIT_DONE_MASK                                                                0x08000000L
#define SDMA1_STATUS_REG__RESERVED_MASK                                                                       0x20000000L
#define SDMA1_STATUS_REG__INT_IDLE_MASK                                                                       0x40000000L
#define SDMA1_STATUS_REG__INT_REQ_STALL_MASK                                                                  0x80000000L
//SDMA1_STATUS1_REG
#define SDMA1_STATUS1_REG__CE_WREQ_IDLE__SHIFT                                                                0x0
#define SDMA1_STATUS1_REG__CE_WR_IDLE__SHIFT                                                                  0x1
#define SDMA1_STATUS1_REG__CE_SPLIT_IDLE__SHIFT                                                               0x2
#define SDMA1_STATUS1_REG__CE_RREQ_IDLE__SHIFT                                                                0x3
#define SDMA1_STATUS1_REG__CE_OUT_IDLE__SHIFT                                                                 0x4
#define SDMA1_STATUS1_REG__CE_IN_IDLE__SHIFT                                                                  0x5
#define SDMA1_STATUS1_REG__CE_DST_IDLE__SHIFT                                                                 0x6
#define SDMA1_STATUS1_REG__RESERVED_8_7__SHIFT                                                                0x7
#define SDMA1_STATUS1_REG__CE_CMD_IDLE__SHIFT                                                                 0x9
#define SDMA1_STATUS1_REG__CE_AFIFO_FULL__SHIFT                                                               0xa
#define SDMA1_STATUS1_REG__CE_INFO_FULL__SHIFT                                                                0xb
#define SDMA1_STATUS1_REG__CE_INFO1_FULL__SHIFT                                                               0xc
#define SDMA1_STATUS1_REG__EX_START__SHIFT                                                                    0xd
#define SDMA1_STATUS1_REG__CE_RD_STALL__SHIFT                                                                 0xf
#define SDMA1_STATUS1_REG__CE_WR_STALL__SHIFT                                                                 0x10
#define SDMA1_STATUS1_REG__SEC_INTR_STATUS__SHIFT                                                             0x11
#define SDMA1_STATUS1_REG__WPTR_POLL_IDLE__SHIFT                                                              0x12
#define SDMA1_STATUS1_REG__SDMA_IDLE__SHIFT                                                                   0x13
#define SDMA1_STATUS1_REG__IC_FETCH_IDLE__SHIFT                                                               0x14
#define SDMA1_STATUS1_REG__IC_FETCH_PAGE_FAULT__SHIFT                                                         0x15
#define SDMA1_STATUS1_REG__IC_FETCH_PAGE_RETRY_TIMEOUT__SHIFT                                                 0x16
#define SDMA1_STATUS1_REG__IC_FETCH_PAGE_NULL__SHIFT                                                          0x17
#define SDMA1_STATUS1_REG__MCU_FW_STACK_OVERFLOW__SHIFT                                                       0x18
#define SDMA1_STATUS1_REG__CE_WREQ_IDLE_MASK                                                                  0x00000001L
#define SDMA1_STATUS1_REG__CE_WR_IDLE_MASK                                                                    0x00000002L
#define SDMA1_STATUS1_REG__CE_SPLIT_IDLE_MASK                                                                 0x00000004L
#define SDMA1_STATUS1_REG__CE_RREQ_IDLE_MASK                                                                  0x00000008L
#define SDMA1_STATUS1_REG__CE_OUT_IDLE_MASK                                                                   0x00000010L
#define SDMA1_STATUS1_REG__CE_IN_IDLE_MASK                                                                    0x00000020L
#define SDMA1_STATUS1_REG__CE_DST_IDLE_MASK                                                                   0x00000040L
#define SDMA1_STATUS1_REG__RESERVED_8_7_MASK                                                                  0x00000180L
#define SDMA1_STATUS1_REG__CE_CMD_IDLE_MASK                                                                   0x00000200L
#define SDMA1_STATUS1_REG__CE_AFIFO_FULL_MASK                                                                 0x00000400L
#define SDMA1_STATUS1_REG__CE_INFO_FULL_MASK                                                                  0x00000800L
#define SDMA1_STATUS1_REG__CE_INFO1_FULL_MASK                                                                 0x00001000L
#define SDMA1_STATUS1_REG__EX_START_MASK                                                                      0x00002000L
#define SDMA1_STATUS1_REG__CE_RD_STALL_MASK                                                                   0x00008000L
#define SDMA1_STATUS1_REG__CE_WR_STALL_MASK                                                                   0x00010000L
#define SDMA1_STATUS1_REG__SEC_INTR_STATUS_MASK                                                               0x00020000L
#define SDMA1_STATUS1_REG__WPTR_POLL_IDLE_MASK                                                                0x00040000L
#define SDMA1_STATUS1_REG__SDMA_IDLE_MASK                                                                     0x00080000L
#define SDMA1_STATUS1_REG__IC_FETCH_IDLE_MASK                                                                 0x00100000L
#define SDMA1_STATUS1_REG__IC_FETCH_PAGE_FAULT_MASK                                                           0x00200000L
#define SDMA1_STATUS1_REG__IC_FETCH_PAGE_RETRY_TIMEOUT_MASK                                                   0x00400000L
#define SDMA1_STATUS1_REG__IC_FETCH_PAGE_NULL_MASK                                                            0x00800000L
#define SDMA1_STATUS1_REG__MCU_FW_STACK_OVERFLOW_MASK                                                         0x03000000L
//SDMA1_CNTL1
#define SDMA1_CNTL1__WPTR_POLL_FREQUENCY__SHIFT                                                               0x2
#define SDMA1_CNTL1__WPTR_POLL_FREQUENCY_MASK                                                                 0x0000FFFCL
//SDMA1_HBM_PAGE_CONFIG
#define SDMA1_HBM_PAGE_CONFIG__PAGE_SIZE_EXPONENT__SHIFT                                                      0x0
#define SDMA1_HBM_PAGE_CONFIG__PAGE_SIZE_EXPONENT_MASK                                                        0x00000003L
//SDMA1_FREEZE
#define SDMA1_FREEZE__PREEMPT__SHIFT                                                                          0x0
#define SDMA1_FREEZE__FROZEN__SHIFT                                                                           0x5
#define SDMA1_FREEZE__MCU_FREEZE__SHIFT                                                                       0x6
#define SDMA1_FREEZE__IMU_FSM_STATE__SHIFT                                                                    0x8
#define SDMA1_FREEZE__EXTERNAL_FROZEN__SHIFT                                                                  0xc
#define SDMA1_FREEZE__PREEMPT_MASK                                                                            0x00000001L
#define SDMA1_FREEZE__FROZEN_MASK                                                                             0x00000020L
#define SDMA1_FREEZE__MCU_FREEZE_MASK                                                                         0x00000040L
#define SDMA1_FREEZE__IMU_FSM_STATE_MASK                                                                      0x00000300L
#define SDMA1_FREEZE__EXTERNAL_FROZEN_MASK                                                                    0x00001000L
//SDMA1_PROCESS_QUANTUM0
#define SDMA1_PROCESS_QUANTUM0__PROCESS0_QUANTUM__SHIFT                                                       0x0
#define SDMA1_PROCESS_QUANTUM0__PROCESS1_QUANTUM__SHIFT                                                       0x8
#define SDMA1_PROCESS_QUANTUM0__PROCESS2_QUANTUM__SHIFT                                                       0x10
#define SDMA1_PROCESS_QUANTUM0__PROCESS3_QUANTUM__SHIFT                                                       0x18
#define SDMA1_PROCESS_QUANTUM0__PROCESS0_QUANTUM_MASK                                                         0x000000FFL
#define SDMA1_PROCESS_QUANTUM0__PROCESS1_QUANTUM_MASK                                                         0x0000FF00L
#define SDMA1_PROCESS_QUANTUM0__PROCESS2_QUANTUM_MASK                                                         0x00FF0000L
#define SDMA1_PROCESS_QUANTUM0__PROCESS3_QUANTUM_MASK                                                         0xFF000000L
//SDMA1_PROCESS_QUANTUM1
#define SDMA1_PROCESS_QUANTUM1__PROCESS4_QUANTUM__SHIFT                                                       0x0
#define SDMA1_PROCESS_QUANTUM1__PROCESS5_QUANTUM__SHIFT                                                       0x8
#define SDMA1_PROCESS_QUANTUM1__PROCESS6_QUANTUM__SHIFT                                                       0x10
#define SDMA1_PROCESS_QUANTUM1__PROCESS7_QUANTUM__SHIFT                                                       0x18
#define SDMA1_PROCESS_QUANTUM1__PROCESS4_QUANTUM_MASK                                                         0x000000FFL
#define SDMA1_PROCESS_QUANTUM1__PROCESS5_QUANTUM_MASK                                                         0x0000FF00L
#define SDMA1_PROCESS_QUANTUM1__PROCESS6_QUANTUM_MASK                                                         0x00FF0000L
#define SDMA1_PROCESS_QUANTUM1__PROCESS7_QUANTUM_MASK                                                         0xFF000000L
//SDMA1_WATCHDOG_CNTL
#define SDMA1_WATCHDOG_CNTL__QUEUE_HANG_COUNT__SHIFT                                                          0x0
#define SDMA1_WATCHDOG_CNTL__CMD_TIMEOUT_COUNT__SHIFT                                                         0x8
#define SDMA1_WATCHDOG_CNTL__QUEUE_HANG_COUNT_MASK                                                            0x000000FFL
#define SDMA1_WATCHDOG_CNTL__CMD_TIMEOUT_COUNT_MASK                                                           0x0000FF00L
//SDMA1_QUEUE_STATUS0
#define SDMA1_QUEUE_STATUS0__QUEUE0_STATUS__SHIFT                                                             0x0
#define SDMA1_QUEUE_STATUS0__QUEUE1_STATUS__SHIFT                                                             0x4
#define SDMA1_QUEUE_STATUS0__QUEUE2_STATUS__SHIFT                                                             0x8
#define SDMA1_QUEUE_STATUS0__QUEUE3_STATUS__SHIFT                                                             0xc
#define SDMA1_QUEUE_STATUS0__QUEUE4_STATUS__SHIFT                                                             0x10
#define SDMA1_QUEUE_STATUS0__QUEUE5_STATUS__SHIFT                                                             0x14
#define SDMA1_QUEUE_STATUS0__QUEUE6_STATUS__SHIFT                                                             0x18
#define SDMA1_QUEUE_STATUS0__QUEUE7_STATUS__SHIFT                                                             0x1c
#define SDMA1_QUEUE_STATUS0__QUEUE0_STATUS_MASK                                                               0x0000000FL
#define SDMA1_QUEUE_STATUS0__QUEUE1_STATUS_MASK                                                               0x000000F0L
#define SDMA1_QUEUE_STATUS0__QUEUE2_STATUS_MASK                                                               0x00000F00L
#define SDMA1_QUEUE_STATUS0__QUEUE3_STATUS_MASK                                                               0x0000F000L
#define SDMA1_QUEUE_STATUS0__QUEUE4_STATUS_MASK                                                               0x000F0000L
#define SDMA1_QUEUE_STATUS0__QUEUE5_STATUS_MASK                                                               0x00F00000L
#define SDMA1_QUEUE_STATUS0__QUEUE6_STATUS_MASK                                                               0x0F000000L
#define SDMA1_QUEUE_STATUS0__QUEUE7_STATUS_MASK                                                               0xF0000000L
//SDMA1_EDC_CONFIG
#define SDMA1_EDC_CONFIG__DIS_EDC__SHIFT                                                                      0x1
#define SDMA1_EDC_CONFIG__ECC_INT_ENABLE__SHIFT                                                               0x2
#define SDMA1_EDC_CONFIG__DIS_EDC_MASK                                                                        0x00000002L
#define SDMA1_EDC_CONFIG__ECC_INT_ENABLE_MASK                                                                 0x00000004L
//SDMA1_ID
#define SDMA1_ID__DEVICE_ID__SHIFT                                                                            0x0
#define SDMA1_ID__DEVICE_ID_MASK                                                                              0x000000FFL
//SDMA1_VERSION
#define SDMA1_VERSION__MINVER__SHIFT                                                                          0x0
#define SDMA1_VERSION__MAJVER__SHIFT                                                                          0x8
#define SDMA1_VERSION__REV__SHIFT                                                                             0x10
#define SDMA1_VERSION__MINVER_MASK                                                                            0x0000007FL
#define SDMA1_VERSION__MAJVER_MASK                                                                            0x00007F00L
#define SDMA1_VERSION__REV_MASK                                                                               0x003F0000L
//SDMA1_STATUS2_REG
#define SDMA1_STATUS2_REG__ID__SHIFT                                                                          0x0
#define SDMA1_STATUS2_REG__TH0MCU_INSTR_PTR__SHIFT                                                            0x2
#define SDMA1_STATUS2_REG__CMD_OP__SHIFT                                                                      0x10
#define SDMA1_STATUS2_REG__ID_MASK                                                                            0x00000003L
#define SDMA1_STATUS2_REG__TH0MCU_INSTR_PTR_MASK                                                              0x0000FFFCL
#define SDMA1_STATUS2_REG__CMD_OP_MASK                                                                        0xFFFF0000L
//SDMA1_ATOMIC_CNTL
#define SDMA1_ATOMIC_CNTL__LOOP_TIMER__SHIFT                                                                  0x0
#define SDMA1_ATOMIC_CNTL__ATOMIC_RTN_INT_ENABLE__SHIFT                                                       0x1f
#define SDMA1_ATOMIC_CNTL__LOOP_TIMER_MASK                                                                    0x7FFFFFFFL
#define SDMA1_ATOMIC_CNTL__ATOMIC_RTN_INT_ENABLE_MASK                                                         0x80000000L
//SDMA1_ATOMIC_PREOP_LO
#define SDMA1_ATOMIC_PREOP_LO__DATA__SHIFT                                                                    0x0
#define SDMA1_ATOMIC_PREOP_LO__DATA_MASK                                                                      0xFFFFFFFFL
//SDMA1_ATOMIC_PREOP_HI
#define SDMA1_ATOMIC_PREOP_HI__DATA__SHIFT                                                                    0x0
#define SDMA1_ATOMIC_PREOP_HI__DATA_MASK                                                                      0xFFFFFFFFL
//SDMA1_DCC_CNTL
#define SDMA1_DCC_CNTL__DCC_FORCE_BYPASS__SHIFT                                                               0x0
#define SDMA1_DCC_CNTL__DCC_RD_NOPTE_OVERRIDE_0__SHIFT                                                        0x1
#define SDMA1_DCC_CNTL__DCC_RD_NOPTE_COMP_EN_0__SHIFT                                                         0x2
#define SDMA1_DCC_CNTL__DCC_WR_NOPTE_OVERRIDE_0__SHIFT                                                        0x3
#define SDMA1_DCC_CNTL__DCC_WR_NOPTE_COMP_EN_0__SHIFT                                                         0x4
#define SDMA1_DCC_CNTL__DCC_RD_NOPTE_OVERRIDE_1__SHIFT                                                        0x5
#define SDMA1_DCC_CNTL__DCC_RD_NOPTE_COMP_EN_1__SHIFT                                                         0x6
#define SDMA1_DCC_CNTL__DCC_WR_NOPTE_OVERRIDE_1__SHIFT                                                        0x7
#define SDMA1_DCC_CNTL__DCC_WR_NOPTE_COMP_EN_1__SHIFT                                                         0x8
#define SDMA1_DCC_CNTL__DCC_RD_NOPTE_OVERRIDE_2__SHIFT                                                        0x9
#define SDMA1_DCC_CNTL__DCC_RD_NOPTE_COMP_EN_2__SHIFT                                                         0xa
#define SDMA1_DCC_CNTL__DCC_WR_NOPTE_OVERRIDE_2__SHIFT                                                        0xb
#define SDMA1_DCC_CNTL__DCC_WR_NOPTE_COMP_EN_2__SHIFT                                                         0xc
#define SDMA1_DCC_CNTL__DCC_RD_NOPTE_OVERRIDE_3__SHIFT                                                        0xd
#define SDMA1_DCC_CNTL__DCC_RD_NOPTE_COMP_EN_3__SHIFT                                                         0xe
#define SDMA1_DCC_CNTL__DCC_WR_NOPTE_OVERRIDE_3__SHIFT                                                        0xf
#define SDMA1_DCC_CNTL__DCC_WR_NOPTE_COMP_EN_3__SHIFT                                                         0x10
#define SDMA1_DCC_CNTL__DCC_FORCE_BYPASS_MASK                                                                 0x00000001L
#define SDMA1_DCC_CNTL__DCC_RD_NOPTE_OVERRIDE_0_MASK                                                          0x00000002L
#define SDMA1_DCC_CNTL__DCC_RD_NOPTE_COMP_EN_0_MASK                                                           0x00000004L
#define SDMA1_DCC_CNTL__DCC_WR_NOPTE_OVERRIDE_0_MASK                                                          0x00000008L
#define SDMA1_DCC_CNTL__DCC_WR_NOPTE_COMP_EN_0_MASK                                                           0x00000010L
#define SDMA1_DCC_CNTL__DCC_RD_NOPTE_OVERRIDE_1_MASK                                                          0x00000020L
#define SDMA1_DCC_CNTL__DCC_RD_NOPTE_COMP_EN_1_MASK                                                           0x00000040L
#define SDMA1_DCC_CNTL__DCC_WR_NOPTE_OVERRIDE_1_MASK                                                          0x00000080L
#define SDMA1_DCC_CNTL__DCC_WR_NOPTE_COMP_EN_1_MASK                                                           0x00000100L
#define SDMA1_DCC_CNTL__DCC_RD_NOPTE_OVERRIDE_2_MASK                                                          0x00000200L
#define SDMA1_DCC_CNTL__DCC_RD_NOPTE_COMP_EN_2_MASK                                                           0x00000400L
#define SDMA1_DCC_CNTL__DCC_WR_NOPTE_OVERRIDE_2_MASK                                                          0x00000800L
#define SDMA1_DCC_CNTL__DCC_WR_NOPTE_COMP_EN_2_MASK                                                           0x00001000L
#define SDMA1_DCC_CNTL__DCC_RD_NOPTE_OVERRIDE_3_MASK                                                          0x00002000L
#define SDMA1_DCC_CNTL__DCC_RD_NOPTE_COMP_EN_3_MASK                                                           0x00004000L
#define SDMA1_DCC_CNTL__DCC_WR_NOPTE_OVERRIDE_3_MASK                                                          0x00008000L
#define SDMA1_DCC_CNTL__DCC_WR_NOPTE_COMP_EN_3_MASK                                                           0x00010000L
//SDMA1_UTCL1_CNTL
#define SDMA1_UTCL1_CNTL__REDO_DELAY__SHIFT                                                                   0x0
#define SDMA1_UTCL1_CNTL__PAGE_WAIT_DELAY__SHIFT                                                              0x5
#define SDMA1_UTCL1_CNTL__RESP_MODE__SHIFT                                                                    0x9
#define SDMA1_UTCL1_CNTL__FORCE_INVALIDATION__SHIFT                                                           0xe
#define SDMA1_UTCL1_CNTL__FORCE_INVREQ_HEAVY__SHIFT                                                           0xf
#define SDMA1_UTCL1_CNTL__WR_EXE_PERMS_CTRL__SHIFT                                                            0x10
#define SDMA1_UTCL1_CNTL__RD_EXE_PERMS_CTRL__SHIFT                                                            0x11
#define SDMA1_UTCL1_CNTL__INVACK_DELAY__SHIFT                                                                 0x12
#define SDMA1_UTCL1_CNTL__REQL2_CREDIT__SHIFT                                                                 0x18
#define SDMA1_UTCL1_CNTL__REDO_DELAY_MASK                                                                     0x0000001FL
#define SDMA1_UTCL1_CNTL__PAGE_WAIT_DELAY_MASK                                                                0x000001E0L
#define SDMA1_UTCL1_CNTL__RESP_MODE_MASK                                                                      0x00000600L
#define SDMA1_UTCL1_CNTL__FORCE_INVALIDATION_MASK                                                             0x00004000L
#define SDMA1_UTCL1_CNTL__FORCE_INVREQ_HEAVY_MASK                                                             0x00008000L
#define SDMA1_UTCL1_CNTL__WR_EXE_PERMS_CTRL_MASK                                                              0x00010000L
#define SDMA1_UTCL1_CNTL__RD_EXE_PERMS_CTRL_MASK                                                              0x00020000L
#define SDMA1_UTCL1_CNTL__INVACK_DELAY_MASK                                                                   0x003C0000L
#define SDMA1_UTCL1_CNTL__REQL2_CREDIT_MASK                                                                   0x3F000000L
//SDMA1_UTCL1_WATERMK
#define SDMA1_UTCL1_WATERMK__WR_REQ_FIFO_WATERMK__SHIFT                                                       0x0
#define SDMA1_UTCL1_WATERMK__WR_REQ_FIFO_DEPTH_STEP__SHIFT                                                    0x4
#define SDMA1_UTCL1_WATERMK__RD_REQ_FIFO_WATERMK__SHIFT                                                       0x6
#define SDMA1_UTCL1_WATERMK__RD_REQ_FIFO_DEPTH_STEP__SHIFT                                                    0xa
#define SDMA1_UTCL1_WATERMK__WR_PAGE_FIFO_WATERMK__SHIFT                                                      0xc
#define SDMA1_UTCL1_WATERMK__WR_PAGE_FIFO_DEPTH_STEP__SHIFT                                                   0x10
#define SDMA1_UTCL1_WATERMK__RD_PAGE_FIFO_WATERMK__SHIFT                                                      0x12
#define SDMA1_UTCL1_WATERMK__RD_PAGE_FIFO_DEPTH_STEP__SHIFT                                                   0x16
#define SDMA1_UTCL1_WATERMK__WR_REQ_FIFO_WATERMK_MASK                                                         0x0000000FL
#define SDMA1_UTCL1_WATERMK__WR_REQ_FIFO_DEPTH_STEP_MASK                                                      0x00000030L
#define SDMA1_UTCL1_WATERMK__RD_REQ_FIFO_WATERMK_MASK                                                         0x000003C0L
#define SDMA1_UTCL1_WATERMK__RD_REQ_FIFO_DEPTH_STEP_MASK                                                      0x00000C00L
#define SDMA1_UTCL1_WATERMK__WR_PAGE_FIFO_WATERMK_MASK                                                        0x0000F000L
#define SDMA1_UTCL1_WATERMK__WR_PAGE_FIFO_DEPTH_STEP_MASK                                                     0x00030000L
#define SDMA1_UTCL1_WATERMK__RD_PAGE_FIFO_WATERMK_MASK                                                        0x003C0000L
#define SDMA1_UTCL1_WATERMK__RD_PAGE_FIFO_DEPTH_STEP_MASK                                                     0x00C00000L
//SDMA1_UTCL1_TIMEOUT
#define SDMA1_UTCL1_TIMEOUT__XNACK_LIMIT__SHIFT                                                               0x0
#define SDMA1_UTCL1_TIMEOUT__XNACK_LIMIT_MASK                                                                 0x0000FFFFL
//SDMA1_UTCL1_PAGE
#define SDMA1_UTCL1_PAGE__INVALID_ADDR__SHIFT                                                                 0x0
#define SDMA1_UTCL1_PAGE__REQ_TYPE__SHIFT                                                                     0x1
#define SDMA1_UTCL1_PAGE__USE_MTYPE__SHIFT                                                                    0x6
#define SDMA1_UTCL1_PAGE__USE_PT_SNOOP__SHIFT                                                                 0xa
#define SDMA1_UTCL1_PAGE__USE_IO__SHIFT                                                                       0xb
#define SDMA1_UTCL1_PAGE__RD_L2_POLICY__SHIFT                                                                 0xc
#define SDMA1_UTCL1_PAGE__WR_L2_POLICY__SHIFT                                                                 0xe
#define SDMA1_UTCL1_PAGE__DMA_PAGE_SIZE__SHIFT                                                                0x10
#define SDMA1_UTCL1_PAGE__USE_BC__SHIFT                                                                       0x16
#define SDMA1_UTCL1_PAGE__ADDR_IS_PA__SHIFT                                                                   0x17
#define SDMA1_UTCL1_PAGE__INVALID_ADDR_MASK                                                                   0x00000001L
#define SDMA1_UTCL1_PAGE__REQ_TYPE_MASK                                                                       0x0000001EL
#define SDMA1_UTCL1_PAGE__USE_MTYPE_MASK                                                                      0x000003C0L
#define SDMA1_UTCL1_PAGE__USE_PT_SNOOP_MASK                                                                   0x00000400L
#define SDMA1_UTCL1_PAGE__USE_IO_MASK                                                                         0x00000800L
#define SDMA1_UTCL1_PAGE__RD_L2_POLICY_MASK                                                                   0x00003000L
#define SDMA1_UTCL1_PAGE__WR_L2_POLICY_MASK                                                                   0x0000C000L
#define SDMA1_UTCL1_PAGE__DMA_PAGE_SIZE_MASK                                                                  0x003F0000L
#define SDMA1_UTCL1_PAGE__USE_BC_MASK                                                                         0x00400000L
#define SDMA1_UTCL1_PAGE__ADDR_IS_PA_MASK                                                                     0x00800000L
//SDMA1_EXTERNAL_FROZEN
#define SDMA1_EXTERNAL_FROZEN__THRESHOLD__SHIFT                                                               0x0
#define SDMA1_EXTERNAL_FROZEN__THRESHOLD_MASK                                                                 0x0000FFFFL
//SDMA1_UTCL1_RD_STATUS
#define SDMA1_UTCL1_RD_STATUS__CE_RD_DATA_FIFO_EMPTY__SHIFT                                                   0x0
#define SDMA1_UTCL1_RD_STATUS__CE_RD_VA_REQ_SEND_FIFO_EMPTY__SHIFT                                            0x1
#define SDMA1_UTCL1_RD_STATUS__CE_RD_REG_ENTRY_EMPTY__SHIFT                                                   0x2
#define SDMA1_UTCL1_RD_STATUS__CE_RD_PAGE_FIFO_EMPTY__SHIFT                                                   0x3
#define SDMA1_UTCL1_RD_STATUS__CE_RD_REQ_FIFO_EMPTY__SHIFT                                                    0x4
#define SDMA1_UTCL1_RD_STATUS__RD_VA_FIFO_EMPTY__SHIFT                                                        0x5
#define SDMA1_UTCL1_RD_STATUS__CE_RD_VA_REQ_SEND_FIFO_FULL__SHIFT                                             0x7
#define SDMA1_UTCL1_RD_STATUS__CE_RD_REG_ENTRY_FULL__SHIFT                                                    0x8
#define SDMA1_UTCL1_RD_STATUS__CE_RD_PAGE_FIFO_FULL__SHIFT                                                    0x9
#define SDMA1_UTCL1_RD_STATUS__CE_RD_REQ_FIFO_FULL__SHIFT                                                     0xa
#define SDMA1_UTCL1_RD_STATUS__RD_VA_FIFO_FULL__SHIFT                                                         0xb
#define SDMA1_UTCL1_RD_STATUS__L2_INTF_RD_IDLE__SHIFT                                                         0x10
#define SDMA1_UTCL1_RD_STATUS__RD_REQRET_IDLE__SHIFT                                                          0x11
#define SDMA1_UTCL1_RD_STATUS__RD_REQ_IDLE__SHIFT                                                             0x12
#define SDMA1_UTCL1_RD_STATUS__CE_RD_DATA_FIFO_EMPTY_MASK                                                     0x00000001L
#define SDMA1_UTCL1_RD_STATUS__CE_RD_VA_REQ_SEND_FIFO_EMPTY_MASK                                              0x00000002L
#define SDMA1_UTCL1_RD_STATUS__CE_RD_REG_ENTRY_EMPTY_MASK                                                     0x00000004L
#define SDMA1_UTCL1_RD_STATUS__CE_RD_PAGE_FIFO_EMPTY_MASK                                                     0x00000008L
#define SDMA1_UTCL1_RD_STATUS__CE_RD_REQ_FIFO_EMPTY_MASK                                                      0x00000010L
#define SDMA1_UTCL1_RD_STATUS__RD_VA_FIFO_EMPTY_MASK                                                          0x00000020L
#define SDMA1_UTCL1_RD_STATUS__CE_RD_VA_REQ_SEND_FIFO_FULL_MASK                                               0x00000080L
#define SDMA1_UTCL1_RD_STATUS__CE_RD_REG_ENTRY_FULL_MASK                                                      0x00000100L
#define SDMA1_UTCL1_RD_STATUS__CE_RD_PAGE_FIFO_FULL_MASK                                                      0x00000200L
#define SDMA1_UTCL1_RD_STATUS__CE_RD_REQ_FIFO_FULL_MASK                                                       0x00000400L
#define SDMA1_UTCL1_RD_STATUS__RD_VA_FIFO_FULL_MASK                                                           0x00000800L
#define SDMA1_UTCL1_RD_STATUS__L2_INTF_RD_IDLE_MASK                                                           0x00010000L
#define SDMA1_UTCL1_RD_STATUS__RD_REQRET_IDLE_MASK                                                            0x00020000L
#define SDMA1_UTCL1_RD_STATUS__RD_REQ_IDLE_MASK                                                               0x00040000L
//SDMA1_UTCL1_WR_STATUS
#define SDMA1_UTCL1_WR_STATUS__CE_WR_DATA_FIFO_EMPTY__SHIFT                                                   0x0
#define SDMA1_UTCL1_WR_STATUS__CE_WR_VA_REQ_SEND_FIFO_EMPTY__SHIFT                                            0x1
#define SDMA1_UTCL1_WR_STATUS__CE_WR_REG_ENTRY_EMPTY__SHIFT                                                   0x2
#define SDMA1_UTCL1_WR_STATUS__CE_WR_PAGE_FIFO_EMPTY__SHIFT                                                   0x3
#define SDMA1_UTCL1_WR_STATUS__CE_WR_REQ_FIFO_EMPTY__SHIFT                                                    0x4
#define SDMA1_UTCL1_WR_STATUS__WR_VA_FIFO_EMPTY__SHIFT                                                        0x5
#define SDMA1_UTCL1_WR_STATUS__CE_WR_DATA_FIFO_FULL__SHIFT                                                    0x6
#define SDMA1_UTCL1_WR_STATUS__CE_WR_VA_REQ_SEND_FIFO_FULL__SHIFT                                             0x7
#define SDMA1_UTCL1_WR_STATUS__CE_WR_REG_ENTRY_FULL__SHIFT                                                    0x8
#define SDMA1_UTCL1_WR_STATUS__CE_WR_PAGE_FIFO_FULL__SHIFT                                                    0x9
#define SDMA1_UTCL1_WR_STATUS__CE_WR_REQ_FIFO_FULL__SHIFT                                                     0xa
#define SDMA1_UTCL1_WR_STATUS__WR_VA_FIFO_FULL__SHIFT                                                         0xb
#define SDMA1_UTCL1_WR_STATUS__L2_INTF_WR_IDLE__SHIFT                                                         0x10
#define SDMA1_UTCL1_WR_STATUS__WR_REQRET_IDLE__SHIFT                                                          0x11
#define SDMA1_UTCL1_WR_STATUS__WR_REQ_IDLE__SHIFT                                                             0x12
#define SDMA1_UTCL1_WR_STATUS__CE_WR_DATA_FIFO_EMPTY_MASK                                                     0x00000001L
#define SDMA1_UTCL1_WR_STATUS__CE_WR_VA_REQ_SEND_FIFO_EMPTY_MASK                                              0x00000002L
#define SDMA1_UTCL1_WR_STATUS__CE_WR_REG_ENTRY_EMPTY_MASK                                                     0x00000004L
#define SDMA1_UTCL1_WR_STATUS__CE_WR_PAGE_FIFO_EMPTY_MASK                                                     0x00000008L
#define SDMA1_UTCL1_WR_STATUS__CE_WR_REQ_FIFO_EMPTY_MASK                                                      0x00000010L
#define SDMA1_UTCL1_WR_STATUS__WR_VA_FIFO_EMPTY_MASK                                                          0x00000020L
#define SDMA1_UTCL1_WR_STATUS__CE_WR_DATA_FIFO_FULL_MASK                                                      0x00000040L
#define SDMA1_UTCL1_WR_STATUS__CE_WR_VA_REQ_SEND_FIFO_FULL_MASK                                               0x00000080L
#define SDMA1_UTCL1_WR_STATUS__CE_WR_REG_ENTRY_FULL_MASK                                                      0x00000100L
#define SDMA1_UTCL1_WR_STATUS__CE_WR_PAGE_FIFO_FULL_MASK                                                      0x00000200L
#define SDMA1_UTCL1_WR_STATUS__CE_WR_REQ_FIFO_FULL_MASK                                                       0x00000400L
#define SDMA1_UTCL1_WR_STATUS__WR_VA_FIFO_FULL_MASK                                                           0x00000800L
#define SDMA1_UTCL1_WR_STATUS__L2_INTF_WR_IDLE_MASK                                                           0x00010000L
#define SDMA1_UTCL1_WR_STATUS__WR_REQRET_IDLE_MASK                                                            0x00020000L
#define SDMA1_UTCL1_WR_STATUS__WR_REQ_IDLE_MASK                                                               0x00040000L
//SDMA1_UTCL1_INV0
#define SDMA1_UTCL1_INV0__INV_PROC_BUSY__SHIFT                                                                0x0
#define SDMA1_UTCL1_INV0__GPUVM_FRAG_SIZE__SHIFT                                                              0x1
#define SDMA1_UTCL1_INV0__GPUVM_VMID__SHIFT                                                                   0x7
#define SDMA1_UTCL1_INV0__GPUVM_MODE__SHIFT                                                                   0xb
#define SDMA1_UTCL1_INV0__GPUVM_HIGH__SHIFT                                                                   0xd
#define SDMA1_UTCL1_INV0__GPUVM_TAG__SHIFT                                                                    0xe
#define SDMA1_UTCL1_INV0__GPUVM_VMID_HIGH__SHIFT                                                              0x12
#define SDMA1_UTCL1_INV0__GPUVM_VMID_LOW__SHIFT                                                               0x16
#define SDMA1_UTCL1_INV0__INV_TYPE__SHIFT                                                                     0x1a
#define SDMA1_UTCL1_INV0__INV_PROC_BUSY_MASK                                                                  0x00000001L
#define SDMA1_UTCL1_INV0__GPUVM_FRAG_SIZE_MASK                                                                0x0000007EL
#define SDMA1_UTCL1_INV0__GPUVM_VMID_MASK                                                                     0x00000780L
#define SDMA1_UTCL1_INV0__GPUVM_MODE_MASK                                                                     0x00001800L
#define SDMA1_UTCL1_INV0__GPUVM_HIGH_MASK                                                                     0x00002000L
#define SDMA1_UTCL1_INV0__GPUVM_TAG_MASK                                                                      0x0003C000L
#define SDMA1_UTCL1_INV0__GPUVM_VMID_HIGH_MASK                                                                0x003C0000L
#define SDMA1_UTCL1_INV0__GPUVM_VMID_LOW_MASK                                                                 0x03C00000L
#define SDMA1_UTCL1_INV0__INV_TYPE_MASK                                                                       0x0C000000L
//SDMA1_UTCL1_INV1
#define SDMA1_UTCL1_INV1__INV_ADDR_LO__SHIFT                                                                  0x0
#define SDMA1_UTCL1_INV1__INV_ADDR_LO_MASK                                                                    0xFFFFFFFFL
//SDMA1_UTCL1_INV2
#define SDMA1_UTCL1_INV2__CPF_VMID__SHIFT                                                                     0x0
#define SDMA1_UTCL1_INV2__CPF_FLUSH_TYPE__SHIFT                                                               0x10
#define SDMA1_UTCL1_INV2__CPF_FRAG_SIZE__SHIFT                                                                0x11
#define SDMA1_UTCL1_INV2__CPF_VMID_MASK                                                                       0x0000FFFFL
#define SDMA1_UTCL1_INV2__CPF_FLUSH_TYPE_MASK                                                                 0x00010000L
#define SDMA1_UTCL1_INV2__CPF_FRAG_SIZE_MASK                                                                  0x007E0000L
//SDMA1_UTCL1_RD_XNACK0
#define SDMA1_UTCL1_RD_XNACK0__XNACK_FAULT_ADDR_LO__SHIFT                                                     0x0
#define SDMA1_UTCL1_RD_XNACK0__XNACK_FAULT_ADDR_LO_MASK                                                       0xFFFFFFFFL
//SDMA1_UTCL1_RD_XNACK1
#define SDMA1_UTCL1_RD_XNACK1__XNACK_FAULT_ADDR_HI__SHIFT                                                     0x0
#define SDMA1_UTCL1_RD_XNACK1__XNACK_FAULT_VMID__SHIFT                                                        0x4
#define SDMA1_UTCL1_RD_XNACK1__XNACK_FAULT_VECTOR__SHIFT                                                      0x8
#define SDMA1_UTCL1_RD_XNACK1__XNACK_NULL_VECTOR__SHIFT                                                       0xb
#define SDMA1_UTCL1_RD_XNACK1__XNACK_TIMEOUT_VECTOR__SHIFT                                                    0xe
#define SDMA1_UTCL1_RD_XNACK1__XNACK_FAULT_FLAG__SHIFT                                                        0x11
#define SDMA1_UTCL1_RD_XNACK1__XNACK_NULL_FLAG__SHIFT                                                         0x12
#define SDMA1_UTCL1_RD_XNACK1__XNACK_TIMEOUT_FLAG__SHIFT                                                      0x13
#define SDMA1_UTCL1_RD_XNACK1__XNACK_FAULT_ADDR_HI_MASK                                                       0x0000000FL
#define SDMA1_UTCL1_RD_XNACK1__XNACK_FAULT_VMID_MASK                                                          0x000000F0L
#define SDMA1_UTCL1_RD_XNACK1__XNACK_FAULT_VECTOR_MASK                                                        0x00000700L
#define SDMA1_UTCL1_RD_XNACK1__XNACK_NULL_VECTOR_MASK                                                         0x00003800L
#define SDMA1_UTCL1_RD_XNACK1__XNACK_TIMEOUT_VECTOR_MASK                                                      0x0001C000L
#define SDMA1_UTCL1_RD_XNACK1__XNACK_FAULT_FLAG_MASK                                                          0x00020000L
#define SDMA1_UTCL1_RD_XNACK1__XNACK_NULL_FLAG_MASK                                                           0x00040000L
#define SDMA1_UTCL1_RD_XNACK1__XNACK_TIMEOUT_FLAG_MASK                                                        0x00080000L
//SDMA1_UTCL1_WR_XNACK0
#define SDMA1_UTCL1_WR_XNACK0__XNACK_FAULT_ADDR_LO__SHIFT                                                     0x0
#define SDMA1_UTCL1_WR_XNACK0__XNACK_FAULT_ADDR_LO_MASK                                                       0xFFFFFFFFL
//SDMA1_UTCL1_WR_XNACK1
#define SDMA1_UTCL1_WR_XNACK1__XNACK_FAULT_ADDR_HI__SHIFT                                                     0x0
#define SDMA1_UTCL1_WR_XNACK1__XNACK_FAULT_VMID__SHIFT                                                        0x4
#define SDMA1_UTCL1_WR_XNACK1__XNACK_FAULT_VECTOR__SHIFT                                                      0x8
#define SDMA1_UTCL1_WR_XNACK1__XNACK_NULL_VECTOR__SHIFT                                                       0xb
#define SDMA1_UTCL1_WR_XNACK1__XNACK_TIMEOUT_VECTOR__SHIFT                                                    0xe
#define SDMA1_UTCL1_WR_XNACK1__XNACK_FAULT_FLAG__SHIFT                                                        0x11
#define SDMA1_UTCL1_WR_XNACK1__XNACK_NULL_FLAG__SHIFT                                                         0x12
#define SDMA1_UTCL1_WR_XNACK1__XNACK_TIMEOUT_FLAG__SHIFT                                                      0x13
#define SDMA1_UTCL1_WR_XNACK1__XNACK_FAULT_ADDR_HI_MASK                                                       0x0000000FL
#define SDMA1_UTCL1_WR_XNACK1__XNACK_FAULT_VMID_MASK                                                          0x000000F0L
#define SDMA1_UTCL1_WR_XNACK1__XNACK_FAULT_VECTOR_MASK                                                        0x00000700L
#define SDMA1_UTCL1_WR_XNACK1__XNACK_NULL_VECTOR_MASK                                                         0x00003800L
#define SDMA1_UTCL1_WR_XNACK1__XNACK_TIMEOUT_VECTOR_MASK                                                      0x0001C000L
#define SDMA1_UTCL1_WR_XNACK1__XNACK_FAULT_FLAG_MASK                                                          0x00020000L
#define SDMA1_UTCL1_WR_XNACK1__XNACK_NULL_FLAG_MASK                                                           0x00040000L
#define SDMA1_UTCL1_WR_XNACK1__XNACK_TIMEOUT_FLAG_MASK                                                        0x00080000L
//SDMA1_RELAX_ORDERING_LUT
#define SDMA1_RELAX_ORDERING_LUT__RESERVED0__SHIFT                                                            0x0
#define SDMA1_RELAX_ORDERING_LUT__COPY__SHIFT                                                                 0x1
#define SDMA1_RELAX_ORDERING_LUT__WRITE__SHIFT                                                                0x2
#define SDMA1_RELAX_ORDERING_LUT__RESERVED3__SHIFT                                                            0x3
#define SDMA1_RELAX_ORDERING_LUT__RESERVED4__SHIFT                                                            0x4
#define SDMA1_RELAX_ORDERING_LUT__FENCE__SHIFT                                                                0x5
#define SDMA1_RELAX_ORDERING_LUT__RESERVED76__SHIFT                                                           0x6
#define SDMA1_RELAX_ORDERING_LUT__POLL_MEM__SHIFT                                                             0x8
#define SDMA1_RELAX_ORDERING_LUT__COND_EXE__SHIFT                                                             0x9
#define SDMA1_RELAX_ORDERING_LUT__ATOMIC__SHIFT                                                               0xa
#define SDMA1_RELAX_ORDERING_LUT__CONST_FILL__SHIFT                                                           0xb
#define SDMA1_RELAX_ORDERING_LUT__PTEPDE__SHIFT                                                               0xc
#define SDMA1_RELAX_ORDERING_LUT__TIMESTAMP__SHIFT                                                            0xd
#define SDMA1_RELAX_ORDERING_LUT__RESERVED__SHIFT                                                             0xe
#define SDMA1_RELAX_ORDERING_LUT__RB_PREEMPT__SHIFT                                                           0x1a
#define SDMA1_RELAX_ORDERING_LUT__WORLD_SWITCH__SHIFT                                                         0x1b
#define SDMA1_RELAX_ORDERING_LUT__RPTR_WRB__SHIFT                                                             0x1c
#define SDMA1_RELAX_ORDERING_LUT__WPTR_POLL__SHIFT                                                            0x1d
#define SDMA1_RELAX_ORDERING_LUT__IB_FETCH__SHIFT                                                             0x1e
#define SDMA1_RELAX_ORDERING_LUT__RB_FETCH__SHIFT                                                             0x1f
#define SDMA1_RELAX_ORDERING_LUT__RESERVED0_MASK                                                              0x00000001L
#define SDMA1_RELAX_ORDERING_LUT__COPY_MASK                                                                   0x00000002L
#define SDMA1_RELAX_ORDERING_LUT__WRITE_MASK                                                                  0x00000004L
#define SDMA1_RELAX_ORDERING_LUT__RESERVED3_MASK                                                              0x00000008L
#define SDMA1_RELAX_ORDERING_LUT__RESERVED4_MASK                                                              0x00000010L
#define SDMA1_RELAX_ORDERING_LUT__FENCE_MASK                                                                  0x00000020L
#define SDMA1_RELAX_ORDERING_LUT__RESERVED76_MASK                                                             0x000000C0L
#define SDMA1_RELAX_ORDERING_LUT__POLL_MEM_MASK                                                               0x00000100L
#define SDMA1_RELAX_ORDERING_LUT__COND_EXE_MASK                                                               0x00000200L
#define SDMA1_RELAX_ORDERING_LUT__ATOMIC_MASK                                                                 0x00000400L
#define SDMA1_RELAX_ORDERING_LUT__CONST_FILL_MASK                                                             0x00000800L
#define SDMA1_RELAX_ORDERING_LUT__PTEPDE_MASK                                                                 0x00001000L
#define SDMA1_RELAX_ORDERING_LUT__TIMESTAMP_MASK                                                              0x00002000L
#define SDMA1_RELAX_ORDERING_LUT__RESERVED_MASK                                                               0x03FFC000L
#define SDMA1_RELAX_ORDERING_LUT__RB_PREEMPT_MASK                                                             0x04000000L
#define SDMA1_RELAX_ORDERING_LUT__WORLD_SWITCH_MASK                                                           0x08000000L
#define SDMA1_RELAX_ORDERING_LUT__RPTR_WRB_MASK                                                               0x10000000L
#define SDMA1_RELAX_ORDERING_LUT__WPTR_POLL_MASK                                                              0x20000000L
#define SDMA1_RELAX_ORDERING_LUT__IB_FETCH_MASK                                                               0x40000000L
#define SDMA1_RELAX_ORDERING_LUT__RB_FETCH_MASK                                                               0x80000000L
//SDMA1_CHICKEN_BITS_2
#define SDMA1_CHICKEN_BITS_2__MCU_CMD_PROC_DELAY__SHIFT                                                       0x0
#define SDMA1_CHICKEN_BITS_2__MCU_SEND_POSTCODE_EN__SHIFT                                                     0x4
#define SDMA1_CHICKEN_BITS_2__RESERVED_7_6__SHIFT                                                             0x6
#define SDMA1_CHICKEN_BITS_2__WPTR_POLL_OUTSTANDING__SHIFT                                                    0x8
#define SDMA1_CHICKEN_BITS_2__RESERVED_14_12__SHIFT                                                           0xc
#define SDMA1_CHICKEN_BITS_2__RESERVED_15__SHIFT                                                              0xf
#define SDMA1_CHICKEN_BITS_2__RB_FIFO_WATERMARK__SHIFT                                                        0x10
#define SDMA1_CHICKEN_BITS_2__IB_FIFO_WATERMARK__SHIFT                                                        0x12
#define SDMA1_CHICKEN_BITS_2__RESERVED_22_20__SHIFT                                                           0x14
#define SDMA1_CHICKEN_BITS_2__CH_RD_WATERMARK__SHIFT                                                          0x17
#define SDMA1_CHICKEN_BITS_2__CH_WR_WATERMARK__SHIFT                                                          0x19
#define SDMA1_CHICKEN_BITS_2__CH_WR_WATERMARK_LSB__SHIFT                                                      0x1e
#define SDMA1_CHICKEN_BITS_2__PIO_VFID_SOURCE__SHIFT                                                          0x1f
#define SDMA1_CHICKEN_BITS_2__MCU_CMD_PROC_DELAY_MASK                                                         0x0000000FL
#define SDMA1_CHICKEN_BITS_2__MCU_SEND_POSTCODE_EN_MASK                                                       0x00000010L
#define SDMA1_CHICKEN_BITS_2__RESERVED_7_6_MASK                                                               0x000000C0L
#define SDMA1_CHICKEN_BITS_2__WPTR_POLL_OUTSTANDING_MASK                                                      0x00000F00L
#define SDMA1_CHICKEN_BITS_2__RESERVED_14_12_MASK                                                             0x00007000L
#define SDMA1_CHICKEN_BITS_2__RESERVED_15_MASK                                                                0x00008000L
#define SDMA1_CHICKEN_BITS_2__RB_FIFO_WATERMARK_MASK                                                          0x00030000L
#define SDMA1_CHICKEN_BITS_2__IB_FIFO_WATERMARK_MASK                                                          0x000C0000L
#define SDMA1_CHICKEN_BITS_2__RESERVED_22_20_MASK                                                             0x00700000L
#define SDMA1_CHICKEN_BITS_2__CH_RD_WATERMARK_MASK                                                            0x01800000L
#define SDMA1_CHICKEN_BITS_2__CH_WR_WATERMARK_MASK                                                            0x3E000000L
#define SDMA1_CHICKEN_BITS_2__CH_WR_WATERMARK_LSB_MASK                                                        0x40000000L
#define SDMA1_CHICKEN_BITS_2__PIO_VFID_SOURCE_MASK                                                            0x80000000L
//SDMA1_STATUS3_REG
#define SDMA1_STATUS3_REG__PREV_VM_CMD__SHIFT                                                                 0x10
#define SDMA1_STATUS3_REG__EXCEPTION_IDLE__SHIFT                                                              0x14
#define SDMA1_STATUS3_REG__AQL_PREV_CMD_IDLE__SHIFT                                                           0x15
#define SDMA1_STATUS3_REG__TLBI_IDLE__SHIFT                                                                   0x16
#define SDMA1_STATUS3_REG__GCR_IDLE__SHIFT                                                                    0x17
#define SDMA1_STATUS3_REG__INVREQ_IDLE__SHIFT                                                                 0x18
#define SDMA1_STATUS3_REG__QUEUE_ID_MATCH__SHIFT                                                              0x19
#define SDMA1_STATUS3_REG__INT_QUEUE_ID__SHIFT                                                                0x1a
#define SDMA1_STATUS3_REG__TMZ_MTYPE_STATUS__SHIFT                                                            0x1e
#define SDMA1_STATUS3_REG__PREV_VM_CMD_MASK                                                                   0x000F0000L
#define SDMA1_STATUS3_REG__EXCEPTION_IDLE_MASK                                                                0x00100000L
#define SDMA1_STATUS3_REG__AQL_PREV_CMD_IDLE_MASK                                                             0x00200000L
#define SDMA1_STATUS3_REG__TLBI_IDLE_MASK                                                                     0x00400000L
#define SDMA1_STATUS3_REG__GCR_IDLE_MASK                                                                      0x00800000L
#define SDMA1_STATUS3_REG__INVREQ_IDLE_MASK                                                                   0x01000000L
#define SDMA1_STATUS3_REG__QUEUE_ID_MATCH_MASK                                                                0x02000000L
#define SDMA1_STATUS3_REG__INT_QUEUE_ID_MASK                                                                  0x3C000000L
#define SDMA1_STATUS3_REG__TMZ_MTYPE_STATUS_MASK                                                              0xC0000000L
//SDMA1_GLOBAL_QUANTUM
#define SDMA1_GLOBAL_QUANTUM__GLOBAL_FOCUS_QUANTUM__SHIFT                                                     0x0
#define SDMA1_GLOBAL_QUANTUM__GLOBAL_NORMAL_QUANTUM__SHIFT                                                    0x8
#define SDMA1_GLOBAL_QUANTUM__GLOBAL_FOCUS_QUANTUM_MASK                                                       0x000000FFL
#define SDMA1_GLOBAL_QUANTUM__GLOBAL_NORMAL_QUANTUM_MASK                                                      0x0000FF00L
//SDMA1_ERROR_LOG
#define SDMA1_ERROR_LOG__OVERRIDE__SHIFT                                                                      0x0
#define SDMA1_ERROR_LOG__STATUS__SHIFT                                                                        0x10
#define SDMA1_ERROR_LOG__OVERRIDE_MASK                                                                        0x0000FFFFL
#define SDMA1_ERROR_LOG__STATUS_MASK                                                                          0xFFFF0000L
//SDMA1_PUB_DUMMY_REG0
#define SDMA1_PUB_DUMMY_REG0__VALUE__SHIFT                                                                    0x0
#define SDMA1_PUB_DUMMY_REG0__VALUE_MASK                                                                      0xFFFFFFFFL
//SDMA1_PUB_DUMMY_REG1
#define SDMA1_PUB_DUMMY_REG1__VALUE__SHIFT                                                                    0x0
#define SDMA1_PUB_DUMMY_REG1__VALUE_MASK                                                                      0xFFFFFFFFL
//SDMA1_PUB_DUMMY_REG2
#define SDMA1_PUB_DUMMY_REG2__VALUE__SHIFT                                                                    0x0
#define SDMA1_PUB_DUMMY_REG2__VALUE_MASK                                                                      0xFFFFFFFFL
//SDMA1_PUB_DUMMY_REG3
#define SDMA1_PUB_DUMMY_REG3__VALUE__SHIFT                                                                    0x0
#define SDMA1_PUB_DUMMY_REG3__VALUE_MASK                                                                      0xFFFFFFFFL
//SDMA1_MCU_COUNTER
#define SDMA1_MCU_COUNTER__VALUE__SHIFT                                                                       0x0
#define SDMA1_MCU_COUNTER__VALUE_MASK                                                                         0xFFFFFFFFL
//SDMA1_CRD_CNTL
#define SDMA1_CRD_CNTL__CH_WRREQ_CREDIT__SHIFT                                                                0x13
#define SDMA1_CRD_CNTL__CH_RDREQ_CREDIT__SHIFT                                                                0x19
#define SDMA1_CRD_CNTL__CH_WRREQ_CREDIT_MASK                                                                  0x01F80000L
#define SDMA1_CRD_CNTL__CH_RDREQ_CREDIT_MASK                                                                  0x7E000000L
//SDMA1_RLC_CGCG_CTRL
#define SDMA1_RLC_CGCG_CTRL__CGCG_INT_ENABLE__SHIFT                                                           0x1
#define SDMA1_RLC_CGCG_CTRL__MCU_CGCG_ALLOW__SHIFT                                                            0x4
#define SDMA1_RLC_CGCG_CTRL__CGCG_IDLE_HYSTERESIS__SHIFT                                                      0x10
#define SDMA1_RLC_CGCG_CTRL__CGCG_INT_ENABLE_MASK                                                             0x00000002L
#define SDMA1_RLC_CGCG_CTRL__MCU_CGCG_ALLOW_MASK                                                              0x00000010L
#define SDMA1_RLC_CGCG_CTRL__CGCG_IDLE_HYSTERESIS_MASK                                                        0xFFFF0000L
//SDMA1_GPU_IOV_VIOLATION_LOG
#define SDMA1_GPU_IOV_VIOLATION_LOG__VIOLATION_STATUS__SHIFT                                                  0x0
#define SDMA1_GPU_IOV_VIOLATION_LOG__MULTIPLE_VIOLATION_STATUS__SHIFT                                         0x1
#define SDMA1_GPU_IOV_VIOLATION_LOG__ADDRESS__SHIFT                                                           0x2
#define SDMA1_GPU_IOV_VIOLATION_LOG__WRITE_OPERATION__SHIFT                                                   0x14
#define SDMA1_GPU_IOV_VIOLATION_LOG__VF__SHIFT                                                                0x15
#define SDMA1_GPU_IOV_VIOLATION_LOG__VFID__SHIFT                                                              0x16
#define SDMA1_GPU_IOV_VIOLATION_LOG__VIOLATION_STATUS_MASK                                                    0x00000001L
#define SDMA1_GPU_IOV_VIOLATION_LOG__MULTIPLE_VIOLATION_STATUS_MASK                                           0x00000002L
#define SDMA1_GPU_IOV_VIOLATION_LOG__ADDRESS_MASK                                                             0x000FFFFCL
#define SDMA1_GPU_IOV_VIOLATION_LOG__WRITE_OPERATION_MASK                                                     0x00100000L
#define SDMA1_GPU_IOV_VIOLATION_LOG__VF_MASK                                                                  0x00200000L
#define SDMA1_GPU_IOV_VIOLATION_LOG__VFID_MASK                                                                0x07C00000L
//SDMA1_AQL_STATUS
#define SDMA1_AQL_STATUS__COMPLETE_SIGNAL_EMPTY__SHIFT                                                        0x0
#define SDMA1_AQL_STATUS__INVALID_CMD_EMPTY__SHIFT                                                            0x1
#define SDMA1_AQL_STATUS__COMPLETE_SIGNAL_EMPTY_MASK                                                          0x00000001L
#define SDMA1_AQL_STATUS__INVALID_CMD_EMPTY_MASK                                                              0x00000002L
//SDMA1_TLBI_GCR_CNTL
#define SDMA1_TLBI_GCR_CNTL__TLBI_CMD_DW__SHIFT                                                               0x0
#define SDMA1_TLBI_GCR_CNTL__GCR_CMD_DW__SHIFT                                                                0x4
#define SDMA1_TLBI_GCR_CNTL__TLBI_CREDIT__SHIFT                                                               0x10
#define SDMA1_TLBI_GCR_CNTL__GCR_CREDIT__SHIFT                                                                0x18
#define SDMA1_TLBI_GCR_CNTL__TLBI_CMD_DW_MASK                                                                 0x0000000FL
#define SDMA1_TLBI_GCR_CNTL__GCR_CMD_DW_MASK                                                                  0x000000F0L
#define SDMA1_TLBI_GCR_CNTL__TLBI_CREDIT_MASK                                                                 0x00FF0000L
#define SDMA1_TLBI_GCR_CNTL__GCR_CREDIT_MASK                                                                  0xFF000000L
//SDMA1_INT_STATUS
#define SDMA1_INT_STATUS__DATA__SHIFT                                                                         0x0
#define SDMA1_INT_STATUS__DATA_MASK                                                                           0xFFFFFFFFL
//SDMA1_GPU_IOV_VIOLATION_LOG2
#define SDMA1_GPU_IOV_VIOLATION_LOG2__INITIATOR_ID__SHIFT                                                     0x0
#define SDMA1_GPU_IOV_VIOLATION_LOG2__INITIATOR_ID_MASK                                                       0x000003FFL
//SDMA1_INVALID_ADDR_LO
#define SDMA1_INVALID_ADDR_LO__VALUE__SHIFT                                                                   0x0
#define SDMA1_INVALID_ADDR_LO__VALUE_MASK                                                                     0xFFFFFFFFL
//SDMA1_INVALID_ADDR_HI
#define SDMA1_INVALID_ADDR_HI__VALUE__SHIFT                                                                   0x0
#define SDMA1_INVALID_ADDR_HI__VALUE_MASK                                                                     0xFFFFFFFFL
//SDMA1_INVALID_ADDR_SRC
#define SDMA1_INVALID_ADDR_SRC__ID__SHIFT                                                                     0x0
#define SDMA1_INVALID_ADDR_SRC__ID_MASK                                                                       0x0000001FL
//SDMA1_CLOCK_GATING_STATUS
#define SDMA1_CLOCK_GATING_STATUS__PTR_MGCG_CLK_STATUS__SHIFT                                                 0x8
#define SDMA1_CLOCK_GATING_STATUS__PIO_MGCG_CLK_STATUS__SHIFT                                                 0x9
#define SDMA1_CLOCK_GATING_STATUS__MCU_MGCG_CLK_STATUS__SHIFT                                                 0xa
#define SDMA1_CLOCK_GATING_STATUS__COPY_ENG_MGCG_CLK_STATUS__SHIFT                                            0xb
#define SDMA1_CLOCK_GATING_STATUS__SERVE_ENG_MGCG_CLK_STATUS__SHIFT                                           0xc
#define SDMA1_CLOCK_GATING_STATUS__CMD_FETCH_MGCG_CLK_STATUS__SHIFT                                           0xd
#define SDMA1_CLOCK_GATING_STATUS__GU_MEMREQ_MGCG_CLK_STATUS__SHIFT                                           0xe
#define SDMA1_CLOCK_GATING_STATUS__INV_MGCG_CLK_STATUS__SHIFT                                                 0xf
#define SDMA1_CLOCK_GATING_STATUS__GU_CACHE_MGCG_CLK_STATUS__SHIFT                                            0x10
#define SDMA1_CLOCK_GATING_STATUS__IC_CACHE_MGCG_CLK_STATUS__SHIFT                                            0x11
#define SDMA1_CLOCK_GATING_STATUS__MEM_CHNL_MGCG_CLK_STATUS__SHIFT                                            0x12
#define SDMA1_CLOCK_GATING_STATUS__MEM_CHNL_CESE_MGCG_CLK_STATUS__SHIFT                                       0x13
#define SDMA1_CLOCK_GATING_STATUS__PTR_MGCG_CLK_STATUS_MASK                                                   0x00000100L
#define SDMA1_CLOCK_GATING_STATUS__PIO_MGCG_CLK_STATUS_MASK                                                   0x00000200L
#define SDMA1_CLOCK_GATING_STATUS__MCU_MGCG_CLK_STATUS_MASK                                                   0x00000400L
#define SDMA1_CLOCK_GATING_STATUS__COPY_ENG_MGCG_CLK_STATUS_MASK                                              0x00000800L
#define SDMA1_CLOCK_GATING_STATUS__SERVE_ENG_MGCG_CLK_STATUS_MASK                                             0x00001000L
#define SDMA1_CLOCK_GATING_STATUS__CMD_FETCH_MGCG_CLK_STATUS_MASK                                             0x00002000L
#define SDMA1_CLOCK_GATING_STATUS__GU_MEMREQ_MGCG_CLK_STATUS_MASK                                             0x00004000L
#define SDMA1_CLOCK_GATING_STATUS__INV_MGCG_CLK_STATUS_MASK                                                   0x00008000L
#define SDMA1_CLOCK_GATING_STATUS__GU_CACHE_MGCG_CLK_STATUS_MASK                                              0x00010000L
#define SDMA1_CLOCK_GATING_STATUS__IC_CACHE_MGCG_CLK_STATUS_MASK                                              0x00020000L
#define SDMA1_CLOCK_GATING_STATUS__MEM_CHNL_MGCG_CLK_STATUS_MASK                                              0x00040000L
#define SDMA1_CLOCK_GATING_STATUS__MEM_CHNL_CESE_MGCG_CLK_STATUS_MASK                                         0x00080000L
//SDMA1_STATUS4_REG
#define SDMA1_STATUS4_REG__IDLE__SHIFT                                                                        0x0
#define SDMA1_STATUS4_REG__IH_OUTSTANDING__SHIFT                                                              0x2
#define SDMA1_STATUS4_REG__RESERVED__SHIFT                                                                    0x3
#define SDMA1_STATUS4_REG__CH_RD_OUTSTANDING__SHIFT                                                           0x4
#define SDMA1_STATUS4_REG__CH_WR_OUTSTANDING__SHIFT                                                           0x5
#define SDMA1_STATUS4_REG__GCR_OUTSTANDING__SHIFT                                                             0x6
#define SDMA1_STATUS4_REG__TLBI_OUTSTANDING__SHIFT                                                            0x7
#define SDMA1_STATUS4_REG__UTCL2_RD_OUTSTANDING__SHIFT                                                        0x8
#define SDMA1_STATUS4_REG__UTCL2_WR_OUTSTANDING__SHIFT                                                        0x9
#define SDMA1_STATUS4_REG__REG_POLLING__SHIFT                                                                 0xa
#define SDMA1_STATUS4_REG__MEM_POLLING__SHIFT                                                                 0xb
#define SDMA1_STATUS4_REG__RESERVED_13_12__SHIFT                                                              0xc
#define SDMA1_STATUS4_REG__RESERVED_15_14__SHIFT                                                              0xe
#define SDMA1_STATUS4_REG__ACTIVE_QUEUE_ID__SHIFT                                                             0x10
#define SDMA1_STATUS4_REG__SRIOV_WATING_RLCV_CMD__SHIFT                                                       0x14
#define SDMA1_STATUS4_REG__SRIOV_SDMA_EXECUTING_CMD__SHIFT                                                    0x15
#define SDMA1_STATUS4_REG__UTCL2_RD_XNACK_FAULT__SHIFT                                                        0x16
#define SDMA1_STATUS4_REG__UTCL2_RD_XNACK_NULL__SHIFT                                                         0x17
#define SDMA1_STATUS4_REG__UTCL2_RD_XNACK_TIMEOUT__SHIFT                                                      0x18
#define SDMA1_STATUS4_REG__UTCL2_WR_XNACK_FAULT__SHIFT                                                        0x19
#define SDMA1_STATUS4_REG__UTCL2_WR_XNACK_NULL__SHIFT                                                         0x1a
#define SDMA1_STATUS4_REG__UTCL2_WR_XNACK_TIMEOUT__SHIFT                                                      0x1b
#define SDMA1_STATUS4_REG__IDLE_MASK                                                                          0x00000001L
#define SDMA1_STATUS4_REG__IH_OUTSTANDING_MASK                                                                0x00000004L
#define SDMA1_STATUS4_REG__RESERVED_MASK                                                                      0x00000008L
#define SDMA1_STATUS4_REG__CH_RD_OUTSTANDING_MASK                                                             0x00000010L
#define SDMA1_STATUS4_REG__CH_WR_OUTSTANDING_MASK                                                             0x00000020L
#define SDMA1_STATUS4_REG__GCR_OUTSTANDING_MASK                                                               0x00000040L
#define SDMA1_STATUS4_REG__TLBI_OUTSTANDING_MASK                                                              0x00000080L
#define SDMA1_STATUS4_REG__UTCL2_RD_OUTSTANDING_MASK                                                          0x00000100L
#define SDMA1_STATUS4_REG__UTCL2_WR_OUTSTANDING_MASK                                                          0x00000200L
#define SDMA1_STATUS4_REG__REG_POLLING_MASK                                                                   0x00000400L
#define SDMA1_STATUS4_REG__MEM_POLLING_MASK                                                                   0x00000800L
#define SDMA1_STATUS4_REG__RESERVED_13_12_MASK                                                                0x00003000L
#define SDMA1_STATUS4_REG__RESERVED_15_14_MASK                                                                0x0000C000L
#define SDMA1_STATUS4_REG__ACTIVE_QUEUE_ID_MASK                                                               0x000F0000L
#define SDMA1_STATUS4_REG__SRIOV_WATING_RLCV_CMD_MASK                                                         0x00100000L
#define SDMA1_STATUS4_REG__SRIOV_SDMA_EXECUTING_CMD_MASK                                                      0x00200000L
#define SDMA1_STATUS4_REG__UTCL2_RD_XNACK_FAULT_MASK                                                          0x00400000L
#define SDMA1_STATUS4_REG__UTCL2_RD_XNACK_NULL_MASK                                                           0x00800000L
#define SDMA1_STATUS4_REG__UTCL2_RD_XNACK_TIMEOUT_MASK                                                        0x01000000L
#define SDMA1_STATUS4_REG__UTCL2_WR_XNACK_FAULT_MASK                                                          0x02000000L
#define SDMA1_STATUS4_REG__UTCL2_WR_XNACK_NULL_MASK                                                           0x04000000L
#define SDMA1_STATUS4_REG__UTCL2_WR_XNACK_TIMEOUT_MASK                                                        0x08000000L
//SDMA1_SCRATCH_RAM_DATA
#define SDMA1_SCRATCH_RAM_DATA__DATA__SHIFT                                                                   0x0
#define SDMA1_SCRATCH_RAM_DATA__DATA_MASK                                                                     0xFFFFFFFFL
//SDMA1_SCRATCH_RAM_ADDR
#define SDMA1_SCRATCH_RAM_ADDR__ADDR__SHIFT                                                                   0x0
#define SDMA1_SCRATCH_RAM_ADDR__ADDR_MASK                                                                     0x0000007FL
//SDMA1_TIMESTAMP_CNTL
#define SDMA1_TIMESTAMP_CNTL__CAPTURE__SHIFT                                                                  0x0
#define SDMA1_TIMESTAMP_CNTL__CAPTURE_MASK                                                                    0x00000001L
//SDMA1_STATUS5_REG
#define SDMA1_STATUS5_REG__QUEUE0_RB_ENABLE_STATUS__SHIFT                                                     0x0
#define SDMA1_STATUS5_REG__QUEUE1_RB_ENABLE_STATUS__SHIFT                                                     0x1
#define SDMA1_STATUS5_REG__QUEUE2_RB_ENABLE_STATUS__SHIFT                                                     0x2
#define SDMA1_STATUS5_REG__QUEUE3_RB_ENABLE_STATUS__SHIFT                                                     0x3
#define SDMA1_STATUS5_REG__QUEUE4_RB_ENABLE_STATUS__SHIFT                                                     0x4
#define SDMA1_STATUS5_REG__QUEUE5_RB_ENABLE_STATUS__SHIFT                                                     0x5
#define SDMA1_STATUS5_REG__QUEUE6_RB_ENABLE_STATUS__SHIFT                                                     0x6
#define SDMA1_STATUS5_REG__QUEUE7_RB_ENABLE_STATUS__SHIFT                                                     0x7
#define SDMA1_STATUS5_REG__ACTIVE_QUEUE_ID__SHIFT                                                             0x10
#define SDMA1_STATUS5_REG__QUEUE0_WPTR_POLL_PAGE_EXCEPTION__SHIFT                                             0x14
#define SDMA1_STATUS5_REG__QUEUE1_WPTR_POLL_PAGE_EXCEPTION__SHIFT                                             0x15
#define SDMA1_STATUS5_REG__QUEUE2_WPTR_POLL_PAGE_EXCEPTION__SHIFT                                             0x16
#define SDMA1_STATUS5_REG__QUEUE3_WPTR_POLL_PAGE_EXCEPTION__SHIFT                                             0x17
#define SDMA1_STATUS5_REG__QUEUE4_WPTR_POLL_PAGE_EXCEPTION__SHIFT                                             0x18
#define SDMA1_STATUS5_REG__QUEUE5_WPTR_POLL_PAGE_EXCEPTION__SHIFT                                             0x19
#define SDMA1_STATUS5_REG__QUEUE6_WPTR_POLL_PAGE_EXCEPTION__SHIFT                                             0x1a
#define SDMA1_STATUS5_REG__QUEUE7_WPTR_POLL_PAGE_EXCEPTION__SHIFT                                             0x1b
#define SDMA1_STATUS5_REG__QUEUE0_RB_ENABLE_STATUS_MASK                                                       0x00000001L
#define SDMA1_STATUS5_REG__QUEUE1_RB_ENABLE_STATUS_MASK                                                       0x00000002L
#define SDMA1_STATUS5_REG__QUEUE2_RB_ENABLE_STATUS_MASK                                                       0x00000004L
#define SDMA1_STATUS5_REG__QUEUE3_RB_ENABLE_STATUS_MASK                                                       0x00000008L
#define SDMA1_STATUS5_REG__QUEUE4_RB_ENABLE_STATUS_MASK                                                       0x00000010L
#define SDMA1_STATUS5_REG__QUEUE5_RB_ENABLE_STATUS_MASK                                                       0x00000020L
#define SDMA1_STATUS5_REG__QUEUE6_RB_ENABLE_STATUS_MASK                                                       0x00000040L
#define SDMA1_STATUS5_REG__QUEUE7_RB_ENABLE_STATUS_MASK                                                       0x00000080L
#define SDMA1_STATUS5_REG__ACTIVE_QUEUE_ID_MASK                                                               0x000F0000L
#define SDMA1_STATUS5_REG__QUEUE0_WPTR_POLL_PAGE_EXCEPTION_MASK                                               0x00100000L
#define SDMA1_STATUS5_REG__QUEUE1_WPTR_POLL_PAGE_EXCEPTION_MASK                                               0x00200000L
#define SDMA1_STATUS5_REG__QUEUE2_WPTR_POLL_PAGE_EXCEPTION_MASK                                               0x00400000L
#define SDMA1_STATUS5_REG__QUEUE3_WPTR_POLL_PAGE_EXCEPTION_MASK                                               0x00800000L
#define SDMA1_STATUS5_REG__QUEUE4_WPTR_POLL_PAGE_EXCEPTION_MASK                                               0x01000000L
#define SDMA1_STATUS5_REG__QUEUE5_WPTR_POLL_PAGE_EXCEPTION_MASK                                               0x02000000L
#define SDMA1_STATUS5_REG__QUEUE6_WPTR_POLL_PAGE_EXCEPTION_MASK                                               0x04000000L
#define SDMA1_STATUS5_REG__QUEUE7_WPTR_POLL_PAGE_EXCEPTION_MASK                                               0x08000000L
//SDMA1_QUEUE_RESET_REQ
#define SDMA1_QUEUE_RESET_REQ__QUEUE0_RESET__SHIFT                                                            0x0
#define SDMA1_QUEUE_RESET_REQ__QUEUE1_RESET__SHIFT                                                            0x1
#define SDMA1_QUEUE_RESET_REQ__QUEUE2_RESET__SHIFT                                                            0x2
#define SDMA1_QUEUE_RESET_REQ__QUEUE3_RESET__SHIFT                                                            0x3
#define SDMA1_QUEUE_RESET_REQ__QUEUE4_RESET__SHIFT                                                            0x4
#define SDMA1_QUEUE_RESET_REQ__QUEUE5_RESET__SHIFT                                                            0x5
#define SDMA1_QUEUE_RESET_REQ__QUEUE6_RESET__SHIFT                                                            0x6
#define SDMA1_QUEUE_RESET_REQ__QUEUE7_RESET__SHIFT                                                            0x7
#define SDMA1_QUEUE_RESET_REQ__RESERVED__SHIFT                                                                0x8
#define SDMA1_QUEUE_RESET_REQ__QUEUE0_RESET_MASK                                                              0x00000001L
#define SDMA1_QUEUE_RESET_REQ__QUEUE1_RESET_MASK                                                              0x00000002L
#define SDMA1_QUEUE_RESET_REQ__QUEUE2_RESET_MASK                                                              0x00000004L
#define SDMA1_QUEUE_RESET_REQ__QUEUE3_RESET_MASK                                                              0x00000008L
#define SDMA1_QUEUE_RESET_REQ__QUEUE4_RESET_MASK                                                              0x00000010L
#define SDMA1_QUEUE_RESET_REQ__QUEUE5_RESET_MASK                                                              0x00000020L
#define SDMA1_QUEUE_RESET_REQ__QUEUE6_RESET_MASK                                                              0x00000040L
#define SDMA1_QUEUE_RESET_REQ__QUEUE7_RESET_MASK                                                              0x00000080L
#define SDMA1_QUEUE_RESET_REQ__RESERVED_MASK                                                                  0xFFFFFF00L
//SDMA1_STATUS6_REG
#define SDMA1_STATUS6_REG__ID__SHIFT                                                                          0x0
#define SDMA1_STATUS6_REG__TH1MCU_INSTR_PTR__SHIFT                                                            0x2
#define SDMA1_STATUS6_REG__TH1_EXCEPTION__SHIFT                                                               0x10
#define SDMA1_STATUS6_REG__ID_MASK                                                                            0x00000003L
#define SDMA1_STATUS6_REG__TH1MCU_INSTR_PTR_MASK                                                              0x0000FFFCL
#define SDMA1_STATUS6_REG__TH1_EXCEPTION_MASK                                                                 0xFFFF0000L
//SDMA1_STATUS7_REG
#define SDMA1_STATUS7_REG__BLT_REQ_DROP__SHIFT                                                                0x0
#define SDMA1_STATUS7_REG__BLT_REQ_DROP_MASK                                                                  0x00000001L
//SDMA1_STATUS8_REG
#define SDMA1_STATUS8_REG__LD_CTXSW_COND__SHIFT                                                               0x0
#define SDMA1_STATUS8_REG__LD_CTXSW_COND_MASK                                                                 0xFFFFFFFFL
//SDMA1_CE_CTRL
#define SDMA1_CE_CTRL__RD_LUT_WATERMARK__SHIFT                                                                0x0
#define SDMA1_CE_CTRL__RD_LUT_DEPTH__SHIFT                                                                    0x3
#define SDMA1_CE_CTRL__WR_AFIFO_WATERMARK__SHIFT                                                              0x5
#define SDMA1_CE_CTRL__RESERVED__SHIFT                                                                        0x9
#define SDMA1_CE_CTRL__RD_LUT_WATERMARK_MASK                                                                  0x00000007L
#define SDMA1_CE_CTRL__RD_LUT_DEPTH_MASK                                                                      0x00000018L
#define SDMA1_CE_CTRL__WR_AFIFO_WATERMARK_MASK                                                                0x000000E0L
#define SDMA1_CE_CTRL__RESERVED_MASK                                                                          0xFFFFFE00L
//SDMA1_FED_STATUS
#define SDMA1_FED_STATUS__RB_FETCH_ECC__SHIFT                                                                 0x0
#define SDMA1_FED_STATUS__IB_FETCH_ECC__SHIFT                                                                 0x1
#define SDMA1_FED_STATUS__MCU_DATA_ECC__SHIFT                                                                 0x2
#define SDMA1_FED_STATUS__WPTR_POLL_ECC__SHIFT                                                                0x3
#define SDMA1_FED_STATUS__COPY_DATA_ECC__SHIFT                                                                0x4
#define SDMA1_FED_STATUS__INSTR_FETCH_ECC__SHIFT                                                              0x5
#define SDMA1_FED_STATUS__ATOMIC_ECC__SHIFT                                                                   0x6
#define SDMA1_FED_STATUS__RB_FETCH_ECC_MASK                                                                   0x00000001L
#define SDMA1_FED_STATUS__IB_FETCH_ECC_MASK                                                                   0x00000002L
#define SDMA1_FED_STATUS__MCU_DATA_ECC_MASK                                                                   0x00000004L
#define SDMA1_FED_STATUS__WPTR_POLL_ECC_MASK                                                                  0x00000008L
#define SDMA1_FED_STATUS__COPY_DATA_ECC_MASK                                                                  0x00000010L
#define SDMA1_FED_STATUS__INSTR_FETCH_ECC_MASK                                                                0x00000020L
#define SDMA1_FED_STATUS__ATOMIC_ECC_MASK                                                                     0x00000040L
//SDMA1_QUEUE0_RB_CNTL
#define SDMA1_QUEUE0_RB_CNTL__RB_ENABLE__SHIFT                                                                0x0
#define SDMA1_QUEUE0_RB_CNTL__RB_SIZE__SHIFT                                                                  0x1
#define SDMA1_QUEUE0_RB_CNTL__WPTR_POLL_ENABLE__SHIFT                                                         0x8
#define SDMA1_QUEUE0_RB_CNTL__RB_SWAP_ENABLE__SHIFT                                                           0x9
#define SDMA1_QUEUE0_RB_CNTL__WPTR_POLL_SWAP_ENABLE__SHIFT                                                    0xa
#define SDMA1_QUEUE0_RB_CNTL__MCU_WPTR_POLL_ENABLE__SHIFT                                                     0xb
#define SDMA1_QUEUE0_RB_CNTL__RPTR_WRITEBACK_ENABLE__SHIFT                                                    0xc
#define SDMA1_QUEUE0_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE__SHIFT                                               0xd
#define SDMA1_QUEUE0_RB_CNTL__RPTR_WRITEBACK_TIMER__SHIFT                                                     0x10
#define SDMA1_QUEUE0_RB_CNTL__RB_PRIV__SHIFT                                                                  0x17
#define SDMA1_QUEUE0_RB_CNTL__RB_VMID__SHIFT                                                                  0x18
#define SDMA1_QUEUE0_RB_CNTL__RB_ENABLE_MASK                                                                  0x00000001L
#define SDMA1_QUEUE0_RB_CNTL__RB_SIZE_MASK                                                                    0x0000003EL
#define SDMA1_QUEUE0_RB_CNTL__WPTR_POLL_ENABLE_MASK                                                           0x00000100L
#define SDMA1_QUEUE0_RB_CNTL__RB_SWAP_ENABLE_MASK                                                             0x00000200L
#define SDMA1_QUEUE0_RB_CNTL__WPTR_POLL_SWAP_ENABLE_MASK                                                      0x00000400L
#define SDMA1_QUEUE0_RB_CNTL__MCU_WPTR_POLL_ENABLE_MASK                                                       0x00000800L
#define SDMA1_QUEUE0_RB_CNTL__RPTR_WRITEBACK_ENABLE_MASK                                                      0x00001000L
#define SDMA1_QUEUE0_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE_MASK                                                 0x00002000L
#define SDMA1_QUEUE0_RB_CNTL__RPTR_WRITEBACK_TIMER_MASK                                                       0x001F0000L
#define SDMA1_QUEUE0_RB_CNTL__RB_PRIV_MASK                                                                    0x00800000L
#define SDMA1_QUEUE0_RB_CNTL__RB_VMID_MASK                                                                    0x0F000000L
//SDMA1_QUEUE0_RB_BASE
#define SDMA1_QUEUE0_RB_BASE__ADDR__SHIFT                                                                     0x0
#define SDMA1_QUEUE0_RB_BASE__ADDR_MASK                                                                       0xFFFFFFFFL
//SDMA1_QUEUE0_RB_BASE_HI
#define SDMA1_QUEUE0_RB_BASE_HI__ADDR__SHIFT                                                                  0x0
#define SDMA1_QUEUE0_RB_BASE_HI__ADDR_MASK                                                                    0x00FFFFFFL
//SDMA1_QUEUE0_RB_RPTR
#define SDMA1_QUEUE0_RB_RPTR__OFFSET__SHIFT                                                                   0x0
#define SDMA1_QUEUE0_RB_RPTR__OFFSET_MASK                                                                     0xFFFFFFFFL
//SDMA1_QUEUE0_RB_RPTR_HI
#define SDMA1_QUEUE0_RB_RPTR_HI__OFFSET__SHIFT                                                                0x0
#define SDMA1_QUEUE0_RB_RPTR_HI__OFFSET_MASK                                                                  0xFFFFFFFFL
//SDMA1_QUEUE0_RB_WPTR
#define SDMA1_QUEUE0_RB_WPTR__OFFSET__SHIFT                                                                   0x0
#define SDMA1_QUEUE0_RB_WPTR__OFFSET_MASK                                                                     0xFFFFFFFFL
//SDMA1_QUEUE0_RB_WPTR_HI
#define SDMA1_QUEUE0_RB_WPTR_HI__OFFSET__SHIFT                                                                0x0
#define SDMA1_QUEUE0_RB_WPTR_HI__OFFSET_MASK                                                                  0xFFFFFFFFL
//SDMA1_QUEUE0_RB_RPTR_ADDR_LO
#define SDMA1_QUEUE0_RB_RPTR_ADDR_LO__ADDR__SHIFT                                                             0x2
#define SDMA1_QUEUE0_RB_RPTR_ADDR_LO__ADDR_MASK                                                               0xFFFFFFFCL
//SDMA1_QUEUE0_RB_RPTR_ADDR_HI
#define SDMA1_QUEUE0_RB_RPTR_ADDR_HI__ADDR__SHIFT                                                             0x0
#define SDMA1_QUEUE0_RB_RPTR_ADDR_HI__ADDR_MASK                                                               0xFFFFFFFFL
//SDMA1_QUEUE0_IB_CNTL
#define SDMA1_QUEUE0_IB_CNTL__IB_ENABLE__SHIFT                                                                0x0
#define SDMA1_QUEUE0_IB_CNTL__IB_SWAP_ENABLE__SHIFT                                                           0x4
#define SDMA1_QUEUE0_IB_CNTL__SWITCH_INSIDE_IB__SHIFT                                                         0x8
#define SDMA1_QUEUE0_IB_CNTL__CMD_VMID__SHIFT                                                                 0x10
#define SDMA1_QUEUE0_IB_CNTL__IB_ENABLE_MASK                                                                  0x00000001L
#define SDMA1_QUEUE0_IB_CNTL__IB_SWAP_ENABLE_MASK                                                             0x00000010L
#define SDMA1_QUEUE0_IB_CNTL__SWITCH_INSIDE_IB_MASK                                                           0x00000100L
#define SDMA1_QUEUE0_IB_CNTL__CMD_VMID_MASK                                                                   0x000F0000L
//SDMA1_QUEUE0_IB_RPTR
#define SDMA1_QUEUE0_IB_RPTR__OFFSET__SHIFT                                                                   0x2
#define SDMA1_QUEUE0_IB_RPTR__OFFSET_MASK                                                                     0x003FFFFCL
//SDMA1_QUEUE0_IB_OFFSET
#define SDMA1_QUEUE0_IB_OFFSET__OFFSET__SHIFT                                                                 0x2
#define SDMA1_QUEUE0_IB_OFFSET__OFFSET_MASK                                                                   0x003FFFFCL
//SDMA1_QUEUE0_IB_BASE_LO
#define SDMA1_QUEUE0_IB_BASE_LO__ADDR__SHIFT                                                                  0x2
#define SDMA1_QUEUE0_IB_BASE_LO__ADDR_MASK                                                                    0xFFFFFFFCL
//SDMA1_QUEUE0_IB_BASE_HI
#define SDMA1_QUEUE0_IB_BASE_HI__ADDR__SHIFT                                                                  0x0
#define SDMA1_QUEUE0_IB_BASE_HI__ADDR_MASK                                                                    0xFFFFFFFFL
//SDMA1_QUEUE0_IB_SIZE
#define SDMA1_QUEUE0_IB_SIZE__SIZE__SHIFT                                                                     0x0
#define SDMA1_QUEUE0_IB_SIZE__SIZE_MASK                                                                       0x000FFFFFL
//SDMA1_QUEUE0_DOORBELL
#define SDMA1_QUEUE0_DOORBELL__ENABLE__SHIFT                                                                  0x1c
#define SDMA1_QUEUE0_DOORBELL__CAPTURED__SHIFT                                                                0x1e
#define SDMA1_QUEUE0_DOORBELL__ENABLE_MASK                                                                    0x10000000L
#define SDMA1_QUEUE0_DOORBELL__CAPTURED_MASK                                                                  0x40000000L
//SDMA1_QUEUE0_DOORBELL_LOG
#define SDMA1_QUEUE0_DOORBELL_LOG__BE_ERROR__SHIFT                                                            0x0
#define SDMA1_QUEUE0_DOORBELL_LOG__DATA__SHIFT                                                                0x2
#define SDMA1_QUEUE0_DOORBELL_LOG__BE_ERROR_MASK                                                              0x00000001L
#define SDMA1_QUEUE0_DOORBELL_LOG__DATA_MASK                                                                  0xFFFFFFFCL
//SDMA1_QUEUE0_DOORBELL_OFFSET
#define SDMA1_QUEUE0_DOORBELL_OFFSET__OFFSET__SHIFT                                                           0x2
#define SDMA1_QUEUE0_DOORBELL_OFFSET__OFFSET_MASK                                                             0x0FFFFFFCL
//SDMA1_QUEUE0_CSA_ADDR_LO
#define SDMA1_QUEUE0_CSA_ADDR_LO__ADDR__SHIFT                                                                 0x2
#define SDMA1_QUEUE0_CSA_ADDR_LO__ADDR_MASK                                                                   0xFFFFFFFCL
//SDMA1_QUEUE0_CSA_ADDR_HI
#define SDMA1_QUEUE0_CSA_ADDR_HI__ADDR__SHIFT                                                                 0x0
#define SDMA1_QUEUE0_CSA_ADDR_HI__ADDR_MASK                                                                   0xFFFFFFFFL
//SDMA1_QUEUE0_SCHEDULE_CNTL
#define SDMA1_QUEUE0_SCHEDULE_CNTL__GLOBAL_ID__SHIFT                                                          0x0
#define SDMA1_QUEUE0_SCHEDULE_CNTL__PROCESS_ID__SHIFT                                                         0x2
#define SDMA1_QUEUE0_SCHEDULE_CNTL__LOCAL_ID__SHIFT                                                           0x6
#define SDMA1_QUEUE0_SCHEDULE_CNTL__CONTEXT_QUANTUM__SHIFT                                                    0x8
#define SDMA1_QUEUE0_SCHEDULE_CNTL__GLOBAL_ID_MASK                                                            0x00000003L
#define SDMA1_QUEUE0_SCHEDULE_CNTL__PROCESS_ID_MASK                                                           0x0000001CL
#define SDMA1_QUEUE0_SCHEDULE_CNTL__LOCAL_ID_MASK                                                             0x000000C0L
#define SDMA1_QUEUE0_SCHEDULE_CNTL__CONTEXT_QUANTUM_MASK                                                      0x0000FF00L
//SDMA1_QUEUE0_IB_SUB_REMAIN
#define SDMA1_QUEUE0_IB_SUB_REMAIN__SIZE__SHIFT                                                               0x0
#define SDMA1_QUEUE0_IB_SUB_REMAIN__SIZE_MASK                                                                 0x00003FFFL
//SDMA1_QUEUE0_PREEMPT
#define SDMA1_QUEUE0_PREEMPT__IB_PREEMPT__SHIFT                                                               0x0
#define SDMA1_QUEUE0_PREEMPT__IB_PREEMPT_MASK                                                                 0x00000001L
//SDMA1_QUEUE0_DUMMY_REG
#define SDMA1_QUEUE0_DUMMY_REG__DUMMY__SHIFT                                                                  0x0
#define SDMA1_QUEUE0_DUMMY_REG__DUMMY_MASK                                                                    0xFFFFFFFFL
//SDMA1_QUEUE0_RB_WPTR_POLL_ADDR_LO
#define SDMA1_QUEUE0_RB_WPTR_POLL_ADDR_LO__ADDR__SHIFT                                                        0x2
#define SDMA1_QUEUE0_RB_WPTR_POLL_ADDR_LO__ADDR_MASK                                                          0xFFFFFFFCL
//SDMA1_QUEUE0_RB_WPTR_POLL_ADDR_HI
#define SDMA1_QUEUE0_RB_WPTR_POLL_ADDR_HI__ADDR__SHIFT                                                        0x0
#define SDMA1_QUEUE0_RB_WPTR_POLL_ADDR_HI__ADDR_MASK                                                          0xFFFFFFFFL
//SDMA1_QUEUE0_RB_AQL_CNTL
#define SDMA1_QUEUE0_RB_AQL_CNTL__AQL_ENABLE__SHIFT                                                           0x0
#define SDMA1_QUEUE0_RB_AQL_CNTL__AQL_PACKET_SIZE__SHIFT                                                      0x1
#define SDMA1_QUEUE0_RB_AQL_CNTL__PACKET_STEP__SHIFT                                                          0x8
#define SDMA1_QUEUE0_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE__SHIFT                                                0x10
#define SDMA1_QUEUE0_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE__SHIFT                                          0x11
#define SDMA1_QUEUE0_RB_AQL_CNTL__OVERLAP_ENABLE__SHIFT                                                       0x12
#define SDMA1_QUEUE0_RB_AQL_CNTL__AQL_ENABLE_MASK                                                             0x00000001L
#define SDMA1_QUEUE0_RB_AQL_CNTL__AQL_PACKET_SIZE_MASK                                                        0x000000FEL
#define SDMA1_QUEUE0_RB_AQL_CNTL__PACKET_STEP_MASK                                                            0x0000FF00L
#define SDMA1_QUEUE0_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE_MASK                                                  0x00010000L
#define SDMA1_QUEUE0_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE_MASK                                            0x00020000L
#define SDMA1_QUEUE0_RB_AQL_CNTL__OVERLAP_ENABLE_MASK                                                         0x00040000L
//SDMA1_QUEUE0_MINOR_PTR_UPDATE
#define SDMA1_QUEUE0_MINOR_PTR_UPDATE__ENABLE__SHIFT                                                          0x0
#define SDMA1_QUEUE0_MINOR_PTR_UPDATE__ENABLE_MASK                                                            0x00000001L
//SDMA1_QUEUE0_CONTEXT_SWITCH_STATUS
#define SDMA1_QUEUE0_CONTEXT_SWITCH_STATUS__RB_PREEMPT_STATUS__SHIFT                                          0x0
#define SDMA1_QUEUE0_CONTEXT_SWITCH_STATUS__VM_HOLE_EXCEPTION__SHIFT                                          0x1
#define SDMA1_QUEUE0_CONTEXT_SWITCH_STATUS__PAGE_EXCEPTION__SHIFT                                             0x2
#define SDMA1_QUEUE0_CONTEXT_SWITCH_STATUS__QUEUE_HANG_EXCEPTION__SHIFT                                       0x5
#define SDMA1_QUEUE0_CONTEXT_SWITCH_STATUS__DOORBELL_ERROR_EXCEPTION__SHIFT                                   0x6
#define SDMA1_QUEUE0_CONTEXT_SWITCH_STATUS__SRAM_ECC_EXCEPTION__SHIFT                                         0x7
#define SDMA1_QUEUE0_CONTEXT_SWITCH_STATUS__DRAM_ECC_EXCEPTION__SHIFT                                         0x8
#define SDMA1_QUEUE0_CONTEXT_SWITCH_STATUS__WPTR_LT_RPTR_EXCEPTION__SHIFT                                     0x9
#define SDMA1_QUEUE0_CONTEXT_SWITCH_STATUS__RB_PREEMPT_STATUS_MASK                                            0x00000001L
#define SDMA1_QUEUE0_CONTEXT_SWITCH_STATUS__VM_HOLE_EXCEPTION_MASK                                            0x00000002L
#define SDMA1_QUEUE0_CONTEXT_SWITCH_STATUS__PAGE_EXCEPTION_MASK                                               0x00000004L
#define SDMA1_QUEUE0_CONTEXT_SWITCH_STATUS__QUEUE_HANG_EXCEPTION_MASK                                         0x00000020L
#define SDMA1_QUEUE0_CONTEXT_SWITCH_STATUS__DOORBELL_ERROR_EXCEPTION_MASK                                     0x00000040L
#define SDMA1_QUEUE0_CONTEXT_SWITCH_STATUS__SRAM_ECC_EXCEPTION_MASK                                           0x00000080L
#define SDMA1_QUEUE0_CONTEXT_SWITCH_STATUS__DRAM_ECC_EXCEPTION_MASK                                           0x00000100L
#define SDMA1_QUEUE0_CONTEXT_SWITCH_STATUS__WPTR_LT_RPTR_EXCEPTION_MASK                                       0x00000200L
//SDMA1_QUEUE0_MIDCMD_CNTL
#define SDMA1_QUEUE0_MIDCMD_CNTL__DATA_VALID__SHIFT                                                           0x0
#define SDMA1_QUEUE0_MIDCMD_CNTL__COPY_MODE__SHIFT                                                            0x1
#define SDMA1_QUEUE0_MIDCMD_CNTL__SPLIT_STATE__SHIFT                                                          0x4
#define SDMA1_QUEUE0_MIDCMD_CNTL__ALLOW_PREEMPT__SHIFT                                                        0x8
#define SDMA1_QUEUE0_MIDCMD_CNTL__DATA_VALID_MASK                                                             0x00000001L
#define SDMA1_QUEUE0_MIDCMD_CNTL__COPY_MODE_MASK                                                              0x00000002L
#define SDMA1_QUEUE0_MIDCMD_CNTL__SPLIT_STATE_MASK                                                            0x000000F0L
#define SDMA1_QUEUE0_MIDCMD_CNTL__ALLOW_PREEMPT_MASK                                                          0x00000100L
//SDMA1_QUEUE0_MIDCMD_DATA0
#define SDMA1_QUEUE0_MIDCMD_DATA0__DATA0__SHIFT                                                               0x0
#define SDMA1_QUEUE0_MIDCMD_DATA0__DATA0_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE0_MIDCMD_DATA1
#define SDMA1_QUEUE0_MIDCMD_DATA1__DATA1__SHIFT                                                               0x0
#define SDMA1_QUEUE0_MIDCMD_DATA1__DATA1_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE0_MIDCMD_DATA2
#define SDMA1_QUEUE0_MIDCMD_DATA2__DATA2__SHIFT                                                               0x0
#define SDMA1_QUEUE0_MIDCMD_DATA2__DATA2_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE0_MIDCMD_DATA3
#define SDMA1_QUEUE0_MIDCMD_DATA3__DATA3__SHIFT                                                               0x0
#define SDMA1_QUEUE0_MIDCMD_DATA3__DATA3_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE0_MIDCMD_DATA4
#define SDMA1_QUEUE0_MIDCMD_DATA4__DATA4__SHIFT                                                               0x0
#define SDMA1_QUEUE0_MIDCMD_DATA4__DATA4_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE0_MIDCMD_DATA5
#define SDMA1_QUEUE0_MIDCMD_DATA5__DATA5__SHIFT                                                               0x0
#define SDMA1_QUEUE0_MIDCMD_DATA5__DATA5_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE0_MIDCMD_DATA6
#define SDMA1_QUEUE0_MIDCMD_DATA6__DATA6__SHIFT                                                               0x0
#define SDMA1_QUEUE0_MIDCMD_DATA6__DATA6_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE0_MIDCMD_DATA7
#define SDMA1_QUEUE0_MIDCMD_DATA7__DATA7__SHIFT                                                               0x0
#define SDMA1_QUEUE0_MIDCMD_DATA7__DATA7_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE0_MIDCMD_DATA8
#define SDMA1_QUEUE0_MIDCMD_DATA8__DATA8__SHIFT                                                               0x0
#define SDMA1_QUEUE0_MIDCMD_DATA8__DATA8_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE0_MIDCMD_DATA9
#define SDMA1_QUEUE0_MIDCMD_DATA9__DATA9__SHIFT                                                               0x0
#define SDMA1_QUEUE0_MIDCMD_DATA9__DATA9_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE0_MIDCMD_DATA10
#define SDMA1_QUEUE0_MIDCMD_DATA10__DATA10__SHIFT                                                             0x0
#define SDMA1_QUEUE0_MIDCMD_DATA10__DATA10_MASK                                                               0xFFFFFFFFL
//SDMA1_QUEUE0_WAIT_UNSATISFIED_THD
#define SDMA1_QUEUE0_WAIT_UNSATISFIED_THD__THRESHOLD__SHIFT                                                   0x0
#define SDMA1_QUEUE0_WAIT_UNSATISFIED_THD__THRESHOLD_MASK                                                     0x0000001FL
//SDMA1_QUEUE0_MQD_BASE_ADDR_LO
#define SDMA1_QUEUE0_MQD_BASE_ADDR_LO__BASE_ADDR_LO__SHIFT                                                    0x2
#define SDMA1_QUEUE0_MQD_BASE_ADDR_LO__BASE_ADDR_LO_MASK                                                      0xFFFFFFFCL
//SDMA1_QUEUE0_MQD_BASE_ADDR_HI
#define SDMA1_QUEUE0_MQD_BASE_ADDR_HI__BASE_ADDR_HI__SHIFT                                                    0x0
#define SDMA1_QUEUE0_MQD_BASE_ADDR_HI__BASE_ADDR_HI_MASK                                                      0xFFFFFFFFL
//SDMA1_QUEUE0_MQD_CONTROL
#define SDMA1_QUEUE0_MQD_CONTROL__VMID__SHIFT                                                                 0x0
#define SDMA1_QUEUE0_MQD_CONTROL__VMID_MASK                                                                   0x0000000FL
//SDMA1_QUEUE0_DEQUEUE_REQUEST
#define SDMA1_QUEUE0_DEQUEUE_REQUEST__DEQUEUE_REQ__SHIFT                                                      0x0
#define SDMA1_QUEUE0_DEQUEUE_REQUEST__DEQUEUE_REQ_MASK                                                        0x00000001L
//SDMA1_QUEUE0_CONTEXT_STATUS
#define SDMA1_QUEUE0_CONTEXT_STATUS__SELECTED__SHIFT                                                          0x0
#define SDMA1_QUEUE0_CONTEXT_STATUS__USE_IB__SHIFT                                                            0x1
#define SDMA1_QUEUE0_CONTEXT_STATUS__IDLE__SHIFT                                                              0x2
#define SDMA1_QUEUE0_CONTEXT_STATUS__EXPIRED__SHIFT                                                           0x3
#define SDMA1_QUEUE0_CONTEXT_STATUS__EXCEPTION__SHIFT                                                         0x4
#define SDMA1_QUEUE0_CONTEXT_STATUS__CTXSW_ABLE__SHIFT                                                        0x7
#define SDMA1_QUEUE0_CONTEXT_STATUS__VF_STATUS__SHIFT                                                         0x8
#define SDMA1_QUEUE0_CONTEXT_STATUS__PRIV_EXCEPTION__SHIFT                                                    0x9
#define SDMA1_QUEUE0_CONTEXT_STATUS__PREEMPT_DISABLE__SHIFT                                                   0xa
#define SDMA1_QUEUE0_CONTEXT_STATUS__RPTR_WB_IDLE__SHIFT                                                      0xb
#define SDMA1_QUEUE0_CONTEXT_STATUS__WPTR_UPDATE_PENDING__SHIFT                                               0xc
#define SDMA1_QUEUE0_CONTEXT_STATUS__WPTR_UPDATE_FAIL_COUNT__SHIFT                                            0x10
#define SDMA1_QUEUE0_CONTEXT_STATUS__SELECTED_MASK                                                            0x00000001L
#define SDMA1_QUEUE0_CONTEXT_STATUS__USE_IB_MASK                                                              0x00000002L
#define SDMA1_QUEUE0_CONTEXT_STATUS__IDLE_MASK                                                                0x00000004L
#define SDMA1_QUEUE0_CONTEXT_STATUS__EXPIRED_MASK                                                             0x00000008L
#define SDMA1_QUEUE0_CONTEXT_STATUS__EXCEPTION_MASK                                                           0x00000070L
#define SDMA1_QUEUE0_CONTEXT_STATUS__CTXSW_ABLE_MASK                                                          0x00000080L
#define SDMA1_QUEUE0_CONTEXT_STATUS__VF_STATUS_MASK                                                           0x00000100L
#define SDMA1_QUEUE0_CONTEXT_STATUS__PRIV_EXCEPTION_MASK                                                      0x00000200L
#define SDMA1_QUEUE0_CONTEXT_STATUS__PREEMPT_DISABLE_MASK                                                     0x00000400L
#define SDMA1_QUEUE0_CONTEXT_STATUS__RPTR_WB_IDLE_MASK                                                        0x00000800L
#define SDMA1_QUEUE0_CONTEXT_STATUS__WPTR_UPDATE_PENDING_MASK                                                 0x00001000L
#define SDMA1_QUEUE0_CONTEXT_STATUS__WPTR_UPDATE_FAIL_COUNT_MASK                                              0x00FF0000L
//SDMA1_QUEUE1_RB_CNTL
#define SDMA1_QUEUE1_RB_CNTL__RB_ENABLE__SHIFT                                                                0x0
#define SDMA1_QUEUE1_RB_CNTL__RB_SIZE__SHIFT                                                                  0x1
#define SDMA1_QUEUE1_RB_CNTL__WPTR_POLL_ENABLE__SHIFT                                                         0x8
#define SDMA1_QUEUE1_RB_CNTL__RB_SWAP_ENABLE__SHIFT                                                           0x9
#define SDMA1_QUEUE1_RB_CNTL__WPTR_POLL_SWAP_ENABLE__SHIFT                                                    0xa
#define SDMA1_QUEUE1_RB_CNTL__MCU_WPTR_POLL_ENABLE__SHIFT                                                     0xb
#define SDMA1_QUEUE1_RB_CNTL__RPTR_WRITEBACK_ENABLE__SHIFT                                                    0xc
#define SDMA1_QUEUE1_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE__SHIFT                                               0xd
#define SDMA1_QUEUE1_RB_CNTL__RPTR_WRITEBACK_TIMER__SHIFT                                                     0x10
#define SDMA1_QUEUE1_RB_CNTL__RB_PRIV__SHIFT                                                                  0x17
#define SDMA1_QUEUE1_RB_CNTL__RB_VMID__SHIFT                                                                  0x18
#define SDMA1_QUEUE1_RB_CNTL__RB_ENABLE_MASK                                                                  0x00000001L
#define SDMA1_QUEUE1_RB_CNTL__RB_SIZE_MASK                                                                    0x0000003EL
#define SDMA1_QUEUE1_RB_CNTL__WPTR_POLL_ENABLE_MASK                                                           0x00000100L
#define SDMA1_QUEUE1_RB_CNTL__RB_SWAP_ENABLE_MASK                                                             0x00000200L
#define SDMA1_QUEUE1_RB_CNTL__WPTR_POLL_SWAP_ENABLE_MASK                                                      0x00000400L
#define SDMA1_QUEUE1_RB_CNTL__MCU_WPTR_POLL_ENABLE_MASK                                                       0x00000800L
#define SDMA1_QUEUE1_RB_CNTL__RPTR_WRITEBACK_ENABLE_MASK                                                      0x00001000L
#define SDMA1_QUEUE1_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE_MASK                                                 0x00002000L
#define SDMA1_QUEUE1_RB_CNTL__RPTR_WRITEBACK_TIMER_MASK                                                       0x001F0000L
#define SDMA1_QUEUE1_RB_CNTL__RB_PRIV_MASK                                                                    0x00800000L
#define SDMA1_QUEUE1_RB_CNTL__RB_VMID_MASK                                                                    0x0F000000L
//SDMA1_QUEUE1_RB_BASE
#define SDMA1_QUEUE1_RB_BASE__ADDR__SHIFT                                                                     0x0
#define SDMA1_QUEUE1_RB_BASE__ADDR_MASK                                                                       0xFFFFFFFFL
//SDMA1_QUEUE1_RB_BASE_HI
#define SDMA1_QUEUE1_RB_BASE_HI__ADDR__SHIFT                                                                  0x0
#define SDMA1_QUEUE1_RB_BASE_HI__ADDR_MASK                                                                    0x00FFFFFFL
//SDMA1_QUEUE1_RB_RPTR
#define SDMA1_QUEUE1_RB_RPTR__OFFSET__SHIFT                                                                   0x0
#define SDMA1_QUEUE1_RB_RPTR__OFFSET_MASK                                                                     0xFFFFFFFFL
//SDMA1_QUEUE1_RB_RPTR_HI
#define SDMA1_QUEUE1_RB_RPTR_HI__OFFSET__SHIFT                                                                0x0
#define SDMA1_QUEUE1_RB_RPTR_HI__OFFSET_MASK                                                                  0xFFFFFFFFL
//SDMA1_QUEUE1_RB_WPTR
#define SDMA1_QUEUE1_RB_WPTR__OFFSET__SHIFT                                                                   0x0
#define SDMA1_QUEUE1_RB_WPTR__OFFSET_MASK                                                                     0xFFFFFFFFL
//SDMA1_QUEUE1_RB_WPTR_HI
#define SDMA1_QUEUE1_RB_WPTR_HI__OFFSET__SHIFT                                                                0x0
#define SDMA1_QUEUE1_RB_WPTR_HI__OFFSET_MASK                                                                  0xFFFFFFFFL
//SDMA1_QUEUE1_RB_RPTR_ADDR_LO
#define SDMA1_QUEUE1_RB_RPTR_ADDR_LO__ADDR__SHIFT                                                             0x2
#define SDMA1_QUEUE1_RB_RPTR_ADDR_LO__ADDR_MASK                                                               0xFFFFFFFCL
//SDMA1_QUEUE1_RB_RPTR_ADDR_HI
#define SDMA1_QUEUE1_RB_RPTR_ADDR_HI__ADDR__SHIFT                                                             0x0
#define SDMA1_QUEUE1_RB_RPTR_ADDR_HI__ADDR_MASK                                                               0xFFFFFFFFL
//SDMA1_QUEUE1_IB_CNTL
#define SDMA1_QUEUE1_IB_CNTL__IB_ENABLE__SHIFT                                                                0x0
#define SDMA1_QUEUE1_IB_CNTL__IB_SWAP_ENABLE__SHIFT                                                           0x4
#define SDMA1_QUEUE1_IB_CNTL__SWITCH_INSIDE_IB__SHIFT                                                         0x8
#define SDMA1_QUEUE1_IB_CNTL__CMD_VMID__SHIFT                                                                 0x10
#define SDMA1_QUEUE1_IB_CNTL__IB_ENABLE_MASK                                                                  0x00000001L
#define SDMA1_QUEUE1_IB_CNTL__IB_SWAP_ENABLE_MASK                                                             0x00000010L
#define SDMA1_QUEUE1_IB_CNTL__SWITCH_INSIDE_IB_MASK                                                           0x00000100L
#define SDMA1_QUEUE1_IB_CNTL__CMD_VMID_MASK                                                                   0x000F0000L
//SDMA1_QUEUE1_IB_RPTR
#define SDMA1_QUEUE1_IB_RPTR__OFFSET__SHIFT                                                                   0x2
#define SDMA1_QUEUE1_IB_RPTR__OFFSET_MASK                                                                     0x003FFFFCL
//SDMA1_QUEUE1_IB_OFFSET
#define SDMA1_QUEUE1_IB_OFFSET__OFFSET__SHIFT                                                                 0x2
#define SDMA1_QUEUE1_IB_OFFSET__OFFSET_MASK                                                                   0x003FFFFCL
//SDMA1_QUEUE1_IB_BASE_LO
#define SDMA1_QUEUE1_IB_BASE_LO__ADDR__SHIFT                                                                  0x2
#define SDMA1_QUEUE1_IB_BASE_LO__ADDR_MASK                                                                    0xFFFFFFFCL
//SDMA1_QUEUE1_IB_BASE_HI
#define SDMA1_QUEUE1_IB_BASE_HI__ADDR__SHIFT                                                                  0x0
#define SDMA1_QUEUE1_IB_BASE_HI__ADDR_MASK                                                                    0xFFFFFFFFL
//SDMA1_QUEUE1_IB_SIZE
#define SDMA1_QUEUE1_IB_SIZE__SIZE__SHIFT                                                                     0x0
#define SDMA1_QUEUE1_IB_SIZE__SIZE_MASK                                                                       0x000FFFFFL
//SDMA1_QUEUE1_DOORBELL
#define SDMA1_QUEUE1_DOORBELL__ENABLE__SHIFT                                                                  0x1c
#define SDMA1_QUEUE1_DOORBELL__CAPTURED__SHIFT                                                                0x1e
#define SDMA1_QUEUE1_DOORBELL__ENABLE_MASK                                                                    0x10000000L
#define SDMA1_QUEUE1_DOORBELL__CAPTURED_MASK                                                                  0x40000000L
//SDMA1_QUEUE1_DOORBELL_LOG
#define SDMA1_QUEUE1_DOORBELL_LOG__BE_ERROR__SHIFT                                                            0x0
#define SDMA1_QUEUE1_DOORBELL_LOG__DATA__SHIFT                                                                0x2
#define SDMA1_QUEUE1_DOORBELL_LOG__BE_ERROR_MASK                                                              0x00000001L
#define SDMA1_QUEUE1_DOORBELL_LOG__DATA_MASK                                                                  0xFFFFFFFCL
//SDMA1_QUEUE1_DOORBELL_OFFSET
#define SDMA1_QUEUE1_DOORBELL_OFFSET__OFFSET__SHIFT                                                           0x2
#define SDMA1_QUEUE1_DOORBELL_OFFSET__OFFSET_MASK                                                             0x0FFFFFFCL
//SDMA1_QUEUE1_CSA_ADDR_LO
#define SDMA1_QUEUE1_CSA_ADDR_LO__ADDR__SHIFT                                                                 0x2
#define SDMA1_QUEUE1_CSA_ADDR_LO__ADDR_MASK                                                                   0xFFFFFFFCL
//SDMA1_QUEUE1_CSA_ADDR_HI
#define SDMA1_QUEUE1_CSA_ADDR_HI__ADDR__SHIFT                                                                 0x0
#define SDMA1_QUEUE1_CSA_ADDR_HI__ADDR_MASK                                                                   0xFFFFFFFFL
//SDMA1_QUEUE1_SCHEDULE_CNTL
#define SDMA1_QUEUE1_SCHEDULE_CNTL__GLOBAL_ID__SHIFT                                                          0x0
#define SDMA1_QUEUE1_SCHEDULE_CNTL__PROCESS_ID__SHIFT                                                         0x2
#define SDMA1_QUEUE1_SCHEDULE_CNTL__LOCAL_ID__SHIFT                                                           0x6
#define SDMA1_QUEUE1_SCHEDULE_CNTL__CONTEXT_QUANTUM__SHIFT                                                    0x8
#define SDMA1_QUEUE1_SCHEDULE_CNTL__GLOBAL_ID_MASK                                                            0x00000003L
#define SDMA1_QUEUE1_SCHEDULE_CNTL__PROCESS_ID_MASK                                                           0x0000001CL
#define SDMA1_QUEUE1_SCHEDULE_CNTL__LOCAL_ID_MASK                                                             0x000000C0L
#define SDMA1_QUEUE1_SCHEDULE_CNTL__CONTEXT_QUANTUM_MASK                                                      0x0000FF00L
//SDMA1_QUEUE1_IB_SUB_REMAIN
#define SDMA1_QUEUE1_IB_SUB_REMAIN__SIZE__SHIFT                                                               0x0
#define SDMA1_QUEUE1_IB_SUB_REMAIN__SIZE_MASK                                                                 0x00003FFFL
//SDMA1_QUEUE1_PREEMPT
#define SDMA1_QUEUE1_PREEMPT__IB_PREEMPT__SHIFT                                                               0x0
#define SDMA1_QUEUE1_PREEMPT__IB_PREEMPT_MASK                                                                 0x00000001L
//SDMA1_QUEUE1_DUMMY_REG
#define SDMA1_QUEUE1_DUMMY_REG__DUMMY__SHIFT                                                                  0x0
#define SDMA1_QUEUE1_DUMMY_REG__DUMMY_MASK                                                                    0xFFFFFFFFL
//SDMA1_QUEUE1_RB_WPTR_POLL_ADDR_LO
#define SDMA1_QUEUE1_RB_WPTR_POLL_ADDR_LO__ADDR__SHIFT                                                        0x2
#define SDMA1_QUEUE1_RB_WPTR_POLL_ADDR_LO__ADDR_MASK                                                          0xFFFFFFFCL
//SDMA1_QUEUE1_RB_WPTR_POLL_ADDR_HI
#define SDMA1_QUEUE1_RB_WPTR_POLL_ADDR_HI__ADDR__SHIFT                                                        0x0
#define SDMA1_QUEUE1_RB_WPTR_POLL_ADDR_HI__ADDR_MASK                                                          0xFFFFFFFFL
//SDMA1_QUEUE1_RB_AQL_CNTL
#define SDMA1_QUEUE1_RB_AQL_CNTL__AQL_ENABLE__SHIFT                                                           0x0
#define SDMA1_QUEUE1_RB_AQL_CNTL__AQL_PACKET_SIZE__SHIFT                                                      0x1
#define SDMA1_QUEUE1_RB_AQL_CNTL__PACKET_STEP__SHIFT                                                          0x8
#define SDMA1_QUEUE1_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE__SHIFT                                                0x10
#define SDMA1_QUEUE1_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE__SHIFT                                          0x11
#define SDMA1_QUEUE1_RB_AQL_CNTL__OVERLAP_ENABLE__SHIFT                                                       0x12
#define SDMA1_QUEUE1_RB_AQL_CNTL__AQL_ENABLE_MASK                                                             0x00000001L
#define SDMA1_QUEUE1_RB_AQL_CNTL__AQL_PACKET_SIZE_MASK                                                        0x000000FEL
#define SDMA1_QUEUE1_RB_AQL_CNTL__PACKET_STEP_MASK                                                            0x0000FF00L
#define SDMA1_QUEUE1_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE_MASK                                                  0x00010000L
#define SDMA1_QUEUE1_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE_MASK                                            0x00020000L
#define SDMA1_QUEUE1_RB_AQL_CNTL__OVERLAP_ENABLE_MASK                                                         0x00040000L
//SDMA1_QUEUE1_MINOR_PTR_UPDATE
#define SDMA1_QUEUE1_MINOR_PTR_UPDATE__ENABLE__SHIFT                                                          0x0
#define SDMA1_QUEUE1_MINOR_PTR_UPDATE__ENABLE_MASK                                                            0x00000001L
//SDMA1_QUEUE1_CONTEXT_SWITCH_STATUS
#define SDMA1_QUEUE1_CONTEXT_SWITCH_STATUS__RB_PREEMPT_STATUS__SHIFT                                          0x0
#define SDMA1_QUEUE1_CONTEXT_SWITCH_STATUS__VM_HOLE_EXCEPTION__SHIFT                                          0x1
#define SDMA1_QUEUE1_CONTEXT_SWITCH_STATUS__PAGE_EXCEPTION__SHIFT                                             0x2
#define SDMA1_QUEUE1_CONTEXT_SWITCH_STATUS__QUEUE_HANG_EXCEPTION__SHIFT                                       0x5
#define SDMA1_QUEUE1_CONTEXT_SWITCH_STATUS__DOORBELL_ERROR_EXCEPTION__SHIFT                                   0x6
#define SDMA1_QUEUE1_CONTEXT_SWITCH_STATUS__SRAM_ECC_EXCEPTION__SHIFT                                         0x7
#define SDMA1_QUEUE1_CONTEXT_SWITCH_STATUS__DRAM_ECC_EXCEPTION__SHIFT                                         0x8
#define SDMA1_QUEUE1_CONTEXT_SWITCH_STATUS__WPTR_LT_RPTR_EXCEPTION__SHIFT                                     0x9
#define SDMA1_QUEUE1_CONTEXT_SWITCH_STATUS__RB_PREEMPT_STATUS_MASK                                            0x00000001L
#define SDMA1_QUEUE1_CONTEXT_SWITCH_STATUS__VM_HOLE_EXCEPTION_MASK                                            0x00000002L
#define SDMA1_QUEUE1_CONTEXT_SWITCH_STATUS__PAGE_EXCEPTION_MASK                                               0x00000004L
#define SDMA1_QUEUE1_CONTEXT_SWITCH_STATUS__QUEUE_HANG_EXCEPTION_MASK                                         0x00000020L
#define SDMA1_QUEUE1_CONTEXT_SWITCH_STATUS__DOORBELL_ERROR_EXCEPTION_MASK                                     0x00000040L
#define SDMA1_QUEUE1_CONTEXT_SWITCH_STATUS__SRAM_ECC_EXCEPTION_MASK                                           0x00000080L
#define SDMA1_QUEUE1_CONTEXT_SWITCH_STATUS__DRAM_ECC_EXCEPTION_MASK                                           0x00000100L
#define SDMA1_QUEUE1_CONTEXT_SWITCH_STATUS__WPTR_LT_RPTR_EXCEPTION_MASK                                       0x00000200L
//SDMA1_QUEUE1_MIDCMD_CNTL
#define SDMA1_QUEUE1_MIDCMD_CNTL__DATA_VALID__SHIFT                                                           0x0
#define SDMA1_QUEUE1_MIDCMD_CNTL__COPY_MODE__SHIFT                                                            0x1
#define SDMA1_QUEUE1_MIDCMD_CNTL__SPLIT_STATE__SHIFT                                                          0x4
#define SDMA1_QUEUE1_MIDCMD_CNTL__ALLOW_PREEMPT__SHIFT                                                        0x8
#define SDMA1_QUEUE1_MIDCMD_CNTL__DATA_VALID_MASK                                                             0x00000001L
#define SDMA1_QUEUE1_MIDCMD_CNTL__COPY_MODE_MASK                                                              0x00000002L
#define SDMA1_QUEUE1_MIDCMD_CNTL__SPLIT_STATE_MASK                                                            0x000000F0L
#define SDMA1_QUEUE1_MIDCMD_CNTL__ALLOW_PREEMPT_MASK                                                          0x00000100L
//SDMA1_QUEUE1_MIDCMD_DATA0
#define SDMA1_QUEUE1_MIDCMD_DATA0__DATA0__SHIFT                                                               0x0
#define SDMA1_QUEUE1_MIDCMD_DATA0__DATA0_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE1_MIDCMD_DATA1
#define SDMA1_QUEUE1_MIDCMD_DATA1__DATA1__SHIFT                                                               0x0
#define SDMA1_QUEUE1_MIDCMD_DATA1__DATA1_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE1_MIDCMD_DATA2
#define SDMA1_QUEUE1_MIDCMD_DATA2__DATA2__SHIFT                                                               0x0
#define SDMA1_QUEUE1_MIDCMD_DATA2__DATA2_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE1_MIDCMD_DATA3
#define SDMA1_QUEUE1_MIDCMD_DATA3__DATA3__SHIFT                                                               0x0
#define SDMA1_QUEUE1_MIDCMD_DATA3__DATA3_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE1_MIDCMD_DATA4
#define SDMA1_QUEUE1_MIDCMD_DATA4__DATA4__SHIFT                                                               0x0
#define SDMA1_QUEUE1_MIDCMD_DATA4__DATA4_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE1_MIDCMD_DATA5
#define SDMA1_QUEUE1_MIDCMD_DATA5__DATA5__SHIFT                                                               0x0
#define SDMA1_QUEUE1_MIDCMD_DATA5__DATA5_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE1_MIDCMD_DATA6
#define SDMA1_QUEUE1_MIDCMD_DATA6__DATA6__SHIFT                                                               0x0
#define SDMA1_QUEUE1_MIDCMD_DATA6__DATA6_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE1_MIDCMD_DATA7
#define SDMA1_QUEUE1_MIDCMD_DATA7__DATA7__SHIFT                                                               0x0
#define SDMA1_QUEUE1_MIDCMD_DATA7__DATA7_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE1_MIDCMD_DATA8
#define SDMA1_QUEUE1_MIDCMD_DATA8__DATA8__SHIFT                                                               0x0
#define SDMA1_QUEUE1_MIDCMD_DATA8__DATA8_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE1_MIDCMD_DATA9
#define SDMA1_QUEUE1_MIDCMD_DATA9__DATA9__SHIFT                                                               0x0
#define SDMA1_QUEUE1_MIDCMD_DATA9__DATA9_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE1_MIDCMD_DATA10
#define SDMA1_QUEUE1_MIDCMD_DATA10__DATA10__SHIFT                                                             0x0
#define SDMA1_QUEUE1_MIDCMD_DATA10__DATA10_MASK                                                               0xFFFFFFFFL
//SDMA1_QUEUE1_WAIT_UNSATISFIED_THD
#define SDMA1_QUEUE1_WAIT_UNSATISFIED_THD__THRESHOLD__SHIFT                                                   0x0
#define SDMA1_QUEUE1_WAIT_UNSATISFIED_THD__THRESHOLD_MASK                                                     0x0000001FL
//SDMA1_QUEUE1_MQD_BASE_ADDR_LO
#define SDMA1_QUEUE1_MQD_BASE_ADDR_LO__BASE_ADDR_LO__SHIFT                                                    0x2
#define SDMA1_QUEUE1_MQD_BASE_ADDR_LO__BASE_ADDR_LO_MASK                                                      0xFFFFFFFCL
//SDMA1_QUEUE1_MQD_BASE_ADDR_HI
#define SDMA1_QUEUE1_MQD_BASE_ADDR_HI__BASE_ADDR_HI__SHIFT                                                    0x0
#define SDMA1_QUEUE1_MQD_BASE_ADDR_HI__BASE_ADDR_HI_MASK                                                      0xFFFFFFFFL
//SDMA1_QUEUE1_MQD_CONTROL
#define SDMA1_QUEUE1_MQD_CONTROL__VMID__SHIFT                                                                 0x0
#define SDMA1_QUEUE1_MQD_CONTROL__VMID_MASK                                                                   0x0000000FL
//SDMA1_QUEUE1_DEQUEUE_REQUEST
#define SDMA1_QUEUE1_DEQUEUE_REQUEST__DEQUEUE_REQ__SHIFT                                                      0x0
#define SDMA1_QUEUE1_DEQUEUE_REQUEST__DEQUEUE_REQ_MASK                                                        0x00000001L
//SDMA1_QUEUE1_CONTEXT_STATUS
#define SDMA1_QUEUE1_CONTEXT_STATUS__SELECTED__SHIFT                                                          0x0
#define SDMA1_QUEUE1_CONTEXT_STATUS__USE_IB__SHIFT                                                            0x1
#define SDMA1_QUEUE1_CONTEXT_STATUS__IDLE__SHIFT                                                              0x2
#define SDMA1_QUEUE1_CONTEXT_STATUS__EXPIRED__SHIFT                                                           0x3
#define SDMA1_QUEUE1_CONTEXT_STATUS__EXCEPTION__SHIFT                                                         0x4
#define SDMA1_QUEUE1_CONTEXT_STATUS__CTXSW_ABLE__SHIFT                                                        0x7
#define SDMA1_QUEUE1_CONTEXT_STATUS__VF_STATUS__SHIFT                                                         0x8
#define SDMA1_QUEUE1_CONTEXT_STATUS__PRIV_EXCEPTION__SHIFT                                                    0x9
#define SDMA1_QUEUE1_CONTEXT_STATUS__PREEMPT_DISABLE__SHIFT                                                   0xa
#define SDMA1_QUEUE1_CONTEXT_STATUS__RPTR_WB_IDLE__SHIFT                                                      0xb
#define SDMA1_QUEUE1_CONTEXT_STATUS__WPTR_UPDATE_PENDING__SHIFT                                               0xc
#define SDMA1_QUEUE1_CONTEXT_STATUS__WPTR_UPDATE_FAIL_COUNT__SHIFT                                            0x10
#define SDMA1_QUEUE1_CONTEXT_STATUS__SELECTED_MASK                                                            0x00000001L
#define SDMA1_QUEUE1_CONTEXT_STATUS__USE_IB_MASK                                                              0x00000002L
#define SDMA1_QUEUE1_CONTEXT_STATUS__IDLE_MASK                                                                0x00000004L
#define SDMA1_QUEUE1_CONTEXT_STATUS__EXPIRED_MASK                                                             0x00000008L
#define SDMA1_QUEUE1_CONTEXT_STATUS__EXCEPTION_MASK                                                           0x00000070L
#define SDMA1_QUEUE1_CONTEXT_STATUS__CTXSW_ABLE_MASK                                                          0x00000080L
#define SDMA1_QUEUE1_CONTEXT_STATUS__VF_STATUS_MASK                                                           0x00000100L
#define SDMA1_QUEUE1_CONTEXT_STATUS__PRIV_EXCEPTION_MASK                                                      0x00000200L
#define SDMA1_QUEUE1_CONTEXT_STATUS__PREEMPT_DISABLE_MASK                                                     0x00000400L
#define SDMA1_QUEUE1_CONTEXT_STATUS__RPTR_WB_IDLE_MASK                                                        0x00000800L
#define SDMA1_QUEUE1_CONTEXT_STATUS__WPTR_UPDATE_PENDING_MASK                                                 0x00001000L
#define SDMA1_QUEUE1_CONTEXT_STATUS__WPTR_UPDATE_FAIL_COUNT_MASK                                              0x00FF0000L
//SDMA1_QUEUE2_RB_CNTL
#define SDMA1_QUEUE2_RB_CNTL__RB_ENABLE__SHIFT                                                                0x0
#define SDMA1_QUEUE2_RB_CNTL__RB_SIZE__SHIFT                                                                  0x1
#define SDMA1_QUEUE2_RB_CNTL__WPTR_POLL_ENABLE__SHIFT                                                         0x8
#define SDMA1_QUEUE2_RB_CNTL__RB_SWAP_ENABLE__SHIFT                                                           0x9
#define SDMA1_QUEUE2_RB_CNTL__WPTR_POLL_SWAP_ENABLE__SHIFT                                                    0xa
#define SDMA1_QUEUE2_RB_CNTL__MCU_WPTR_POLL_ENABLE__SHIFT                                                     0xb
#define SDMA1_QUEUE2_RB_CNTL__RPTR_WRITEBACK_ENABLE__SHIFT                                                    0xc
#define SDMA1_QUEUE2_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE__SHIFT                                               0xd
#define SDMA1_QUEUE2_RB_CNTL__RPTR_WRITEBACK_TIMER__SHIFT                                                     0x10
#define SDMA1_QUEUE2_RB_CNTL__RB_PRIV__SHIFT                                                                  0x17
#define SDMA1_QUEUE2_RB_CNTL__RB_VMID__SHIFT                                                                  0x18
#define SDMA1_QUEUE2_RB_CNTL__RB_ENABLE_MASK                                                                  0x00000001L
#define SDMA1_QUEUE2_RB_CNTL__RB_SIZE_MASK                                                                    0x0000003EL
#define SDMA1_QUEUE2_RB_CNTL__WPTR_POLL_ENABLE_MASK                                                           0x00000100L
#define SDMA1_QUEUE2_RB_CNTL__RB_SWAP_ENABLE_MASK                                                             0x00000200L
#define SDMA1_QUEUE2_RB_CNTL__WPTR_POLL_SWAP_ENABLE_MASK                                                      0x00000400L
#define SDMA1_QUEUE2_RB_CNTL__MCU_WPTR_POLL_ENABLE_MASK                                                       0x00000800L
#define SDMA1_QUEUE2_RB_CNTL__RPTR_WRITEBACK_ENABLE_MASK                                                      0x00001000L
#define SDMA1_QUEUE2_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE_MASK                                                 0x00002000L
#define SDMA1_QUEUE2_RB_CNTL__RPTR_WRITEBACK_TIMER_MASK                                                       0x001F0000L
#define SDMA1_QUEUE2_RB_CNTL__RB_PRIV_MASK                                                                    0x00800000L
#define SDMA1_QUEUE2_RB_CNTL__RB_VMID_MASK                                                                    0x0F000000L
//SDMA1_QUEUE2_RB_BASE
#define SDMA1_QUEUE2_RB_BASE__ADDR__SHIFT                                                                     0x0
#define SDMA1_QUEUE2_RB_BASE__ADDR_MASK                                                                       0xFFFFFFFFL
//SDMA1_QUEUE2_RB_BASE_HI
#define SDMA1_QUEUE2_RB_BASE_HI__ADDR__SHIFT                                                                  0x0
#define SDMA1_QUEUE2_RB_BASE_HI__ADDR_MASK                                                                    0x00FFFFFFL
//SDMA1_QUEUE2_RB_RPTR
#define SDMA1_QUEUE2_RB_RPTR__OFFSET__SHIFT                                                                   0x0
#define SDMA1_QUEUE2_RB_RPTR__OFFSET_MASK                                                                     0xFFFFFFFFL
//SDMA1_QUEUE2_RB_RPTR_HI
#define SDMA1_QUEUE2_RB_RPTR_HI__OFFSET__SHIFT                                                                0x0
#define SDMA1_QUEUE2_RB_RPTR_HI__OFFSET_MASK                                                                  0xFFFFFFFFL
//SDMA1_QUEUE2_RB_WPTR
#define SDMA1_QUEUE2_RB_WPTR__OFFSET__SHIFT                                                                   0x0
#define SDMA1_QUEUE2_RB_WPTR__OFFSET_MASK                                                                     0xFFFFFFFFL
//SDMA1_QUEUE2_RB_WPTR_HI
#define SDMA1_QUEUE2_RB_WPTR_HI__OFFSET__SHIFT                                                                0x0
#define SDMA1_QUEUE2_RB_WPTR_HI__OFFSET_MASK                                                                  0xFFFFFFFFL
//SDMA1_QUEUE2_RB_RPTR_ADDR_LO
#define SDMA1_QUEUE2_RB_RPTR_ADDR_LO__ADDR__SHIFT                                                             0x2
#define SDMA1_QUEUE2_RB_RPTR_ADDR_LO__ADDR_MASK                                                               0xFFFFFFFCL
//SDMA1_QUEUE2_RB_RPTR_ADDR_HI
#define SDMA1_QUEUE2_RB_RPTR_ADDR_HI__ADDR__SHIFT                                                             0x0
#define SDMA1_QUEUE2_RB_RPTR_ADDR_HI__ADDR_MASK                                                               0xFFFFFFFFL
//SDMA1_QUEUE2_IB_CNTL
#define SDMA1_QUEUE2_IB_CNTL__IB_ENABLE__SHIFT                                                                0x0
#define SDMA1_QUEUE2_IB_CNTL__IB_SWAP_ENABLE__SHIFT                                                           0x4
#define SDMA1_QUEUE2_IB_CNTL__SWITCH_INSIDE_IB__SHIFT                                                         0x8
#define SDMA1_QUEUE2_IB_CNTL__CMD_VMID__SHIFT                                                                 0x10
#define SDMA1_QUEUE2_IB_CNTL__IB_ENABLE_MASK                                                                  0x00000001L
#define SDMA1_QUEUE2_IB_CNTL__IB_SWAP_ENABLE_MASK                                                             0x00000010L
#define SDMA1_QUEUE2_IB_CNTL__SWITCH_INSIDE_IB_MASK                                                           0x00000100L
#define SDMA1_QUEUE2_IB_CNTL__CMD_VMID_MASK                                                                   0x000F0000L
//SDMA1_QUEUE2_IB_RPTR
#define SDMA1_QUEUE2_IB_RPTR__OFFSET__SHIFT                                                                   0x2
#define SDMA1_QUEUE2_IB_RPTR__OFFSET_MASK                                                                     0x003FFFFCL
//SDMA1_QUEUE2_IB_OFFSET
#define SDMA1_QUEUE2_IB_OFFSET__OFFSET__SHIFT                                                                 0x2
#define SDMA1_QUEUE2_IB_OFFSET__OFFSET_MASK                                                                   0x003FFFFCL
//SDMA1_QUEUE2_IB_BASE_LO
#define SDMA1_QUEUE2_IB_BASE_LO__ADDR__SHIFT                                                                  0x2
#define SDMA1_QUEUE2_IB_BASE_LO__ADDR_MASK                                                                    0xFFFFFFFCL
//SDMA1_QUEUE2_IB_BASE_HI
#define SDMA1_QUEUE2_IB_BASE_HI__ADDR__SHIFT                                                                  0x0
#define SDMA1_QUEUE2_IB_BASE_HI__ADDR_MASK                                                                    0xFFFFFFFFL
//SDMA1_QUEUE2_IB_SIZE
#define SDMA1_QUEUE2_IB_SIZE__SIZE__SHIFT                                                                     0x0
#define SDMA1_QUEUE2_IB_SIZE__SIZE_MASK                                                                       0x000FFFFFL
//SDMA1_QUEUE2_DOORBELL
#define SDMA1_QUEUE2_DOORBELL__ENABLE__SHIFT                                                                  0x1c
#define SDMA1_QUEUE2_DOORBELL__CAPTURED__SHIFT                                                                0x1e
#define SDMA1_QUEUE2_DOORBELL__ENABLE_MASK                                                                    0x10000000L
#define SDMA1_QUEUE2_DOORBELL__CAPTURED_MASK                                                                  0x40000000L
//SDMA1_QUEUE2_DOORBELL_LOG
#define SDMA1_QUEUE2_DOORBELL_LOG__BE_ERROR__SHIFT                                                            0x0
#define SDMA1_QUEUE2_DOORBELL_LOG__DATA__SHIFT                                                                0x2
#define SDMA1_QUEUE2_DOORBELL_LOG__BE_ERROR_MASK                                                              0x00000001L
#define SDMA1_QUEUE2_DOORBELL_LOG__DATA_MASK                                                                  0xFFFFFFFCL
//SDMA1_QUEUE2_DOORBELL_OFFSET
#define SDMA1_QUEUE2_DOORBELL_OFFSET__OFFSET__SHIFT                                                           0x2
#define SDMA1_QUEUE2_DOORBELL_OFFSET__OFFSET_MASK                                                             0x0FFFFFFCL
//SDMA1_QUEUE2_CSA_ADDR_LO
#define SDMA1_QUEUE2_CSA_ADDR_LO__ADDR__SHIFT                                                                 0x2
#define SDMA1_QUEUE2_CSA_ADDR_LO__ADDR_MASK                                                                   0xFFFFFFFCL
//SDMA1_QUEUE2_CSA_ADDR_HI
#define SDMA1_QUEUE2_CSA_ADDR_HI__ADDR__SHIFT                                                                 0x0
#define SDMA1_QUEUE2_CSA_ADDR_HI__ADDR_MASK                                                                   0xFFFFFFFFL
//SDMA1_QUEUE2_SCHEDULE_CNTL
#define SDMA1_QUEUE2_SCHEDULE_CNTL__GLOBAL_ID__SHIFT                                                          0x0
#define SDMA1_QUEUE2_SCHEDULE_CNTL__PROCESS_ID__SHIFT                                                         0x2
#define SDMA1_QUEUE2_SCHEDULE_CNTL__LOCAL_ID__SHIFT                                                           0x6
#define SDMA1_QUEUE2_SCHEDULE_CNTL__CONTEXT_QUANTUM__SHIFT                                                    0x8
#define SDMA1_QUEUE2_SCHEDULE_CNTL__GLOBAL_ID_MASK                                                            0x00000003L
#define SDMA1_QUEUE2_SCHEDULE_CNTL__PROCESS_ID_MASK                                                           0x0000001CL
#define SDMA1_QUEUE2_SCHEDULE_CNTL__LOCAL_ID_MASK                                                             0x000000C0L
#define SDMA1_QUEUE2_SCHEDULE_CNTL__CONTEXT_QUANTUM_MASK                                                      0x0000FF00L
//SDMA1_QUEUE2_IB_SUB_REMAIN
#define SDMA1_QUEUE2_IB_SUB_REMAIN__SIZE__SHIFT                                                               0x0
#define SDMA1_QUEUE2_IB_SUB_REMAIN__SIZE_MASK                                                                 0x00003FFFL
//SDMA1_QUEUE2_PREEMPT
#define SDMA1_QUEUE2_PREEMPT__IB_PREEMPT__SHIFT                                                               0x0
#define SDMA1_QUEUE2_PREEMPT__IB_PREEMPT_MASK                                                                 0x00000001L
//SDMA1_QUEUE2_DUMMY_REG
#define SDMA1_QUEUE2_DUMMY_REG__DUMMY__SHIFT                                                                  0x0
#define SDMA1_QUEUE2_DUMMY_REG__DUMMY_MASK                                                                    0xFFFFFFFFL
//SDMA1_QUEUE2_RB_WPTR_POLL_ADDR_LO
#define SDMA1_QUEUE2_RB_WPTR_POLL_ADDR_LO__ADDR__SHIFT                                                        0x2
#define SDMA1_QUEUE2_RB_WPTR_POLL_ADDR_LO__ADDR_MASK                                                          0xFFFFFFFCL
//SDMA1_QUEUE2_RB_WPTR_POLL_ADDR_HI
#define SDMA1_QUEUE2_RB_WPTR_POLL_ADDR_HI__ADDR__SHIFT                                                        0x0
#define SDMA1_QUEUE2_RB_WPTR_POLL_ADDR_HI__ADDR_MASK                                                          0xFFFFFFFFL
//SDMA1_QUEUE2_RB_AQL_CNTL
#define SDMA1_QUEUE2_RB_AQL_CNTL__AQL_ENABLE__SHIFT                                                           0x0
#define SDMA1_QUEUE2_RB_AQL_CNTL__AQL_PACKET_SIZE__SHIFT                                                      0x1
#define SDMA1_QUEUE2_RB_AQL_CNTL__PACKET_STEP__SHIFT                                                          0x8
#define SDMA1_QUEUE2_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE__SHIFT                                                0x10
#define SDMA1_QUEUE2_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE__SHIFT                                          0x11
#define SDMA1_QUEUE2_RB_AQL_CNTL__OVERLAP_ENABLE__SHIFT                                                       0x12
#define SDMA1_QUEUE2_RB_AQL_CNTL__AQL_ENABLE_MASK                                                             0x00000001L
#define SDMA1_QUEUE2_RB_AQL_CNTL__AQL_PACKET_SIZE_MASK                                                        0x000000FEL
#define SDMA1_QUEUE2_RB_AQL_CNTL__PACKET_STEP_MASK                                                            0x0000FF00L
#define SDMA1_QUEUE2_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE_MASK                                                  0x00010000L
#define SDMA1_QUEUE2_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE_MASK                                            0x00020000L
#define SDMA1_QUEUE2_RB_AQL_CNTL__OVERLAP_ENABLE_MASK                                                         0x00040000L
//SDMA1_QUEUE2_MINOR_PTR_UPDATE
#define SDMA1_QUEUE2_MINOR_PTR_UPDATE__ENABLE__SHIFT                                                          0x0
#define SDMA1_QUEUE2_MINOR_PTR_UPDATE__ENABLE_MASK                                                            0x00000001L
//SDMA1_QUEUE2_CONTEXT_SWITCH_STATUS
#define SDMA1_QUEUE2_CONTEXT_SWITCH_STATUS__RB_PREEMPT_STATUS__SHIFT                                          0x0
#define SDMA1_QUEUE2_CONTEXT_SWITCH_STATUS__VM_HOLE_EXCEPTION__SHIFT                                          0x1
#define SDMA1_QUEUE2_CONTEXT_SWITCH_STATUS__PAGE_EXCEPTION__SHIFT                                             0x2
#define SDMA1_QUEUE2_CONTEXT_SWITCH_STATUS__QUEUE_HANG_EXCEPTION__SHIFT                                       0x5
#define SDMA1_QUEUE2_CONTEXT_SWITCH_STATUS__DOORBELL_ERROR_EXCEPTION__SHIFT                                   0x6
#define SDMA1_QUEUE2_CONTEXT_SWITCH_STATUS__SRAM_ECC_EXCEPTION__SHIFT                                         0x7
#define SDMA1_QUEUE2_CONTEXT_SWITCH_STATUS__DRAM_ECC_EXCEPTION__SHIFT                                         0x8
#define SDMA1_QUEUE2_CONTEXT_SWITCH_STATUS__WPTR_LT_RPTR_EXCEPTION__SHIFT                                     0x9
#define SDMA1_QUEUE2_CONTEXT_SWITCH_STATUS__RB_PREEMPT_STATUS_MASK                                            0x00000001L
#define SDMA1_QUEUE2_CONTEXT_SWITCH_STATUS__VM_HOLE_EXCEPTION_MASK                                            0x00000002L
#define SDMA1_QUEUE2_CONTEXT_SWITCH_STATUS__PAGE_EXCEPTION_MASK                                               0x00000004L
#define SDMA1_QUEUE2_CONTEXT_SWITCH_STATUS__QUEUE_HANG_EXCEPTION_MASK                                         0x00000020L
#define SDMA1_QUEUE2_CONTEXT_SWITCH_STATUS__DOORBELL_ERROR_EXCEPTION_MASK                                     0x00000040L
#define SDMA1_QUEUE2_CONTEXT_SWITCH_STATUS__SRAM_ECC_EXCEPTION_MASK                                           0x00000080L
#define SDMA1_QUEUE2_CONTEXT_SWITCH_STATUS__DRAM_ECC_EXCEPTION_MASK                                           0x00000100L
#define SDMA1_QUEUE2_CONTEXT_SWITCH_STATUS__WPTR_LT_RPTR_EXCEPTION_MASK                                       0x00000200L
//SDMA1_QUEUE2_MIDCMD_CNTL
#define SDMA1_QUEUE2_MIDCMD_CNTL__DATA_VALID__SHIFT                                                           0x0
#define SDMA1_QUEUE2_MIDCMD_CNTL__COPY_MODE__SHIFT                                                            0x1
#define SDMA1_QUEUE2_MIDCMD_CNTL__SPLIT_STATE__SHIFT                                                          0x4
#define SDMA1_QUEUE2_MIDCMD_CNTL__ALLOW_PREEMPT__SHIFT                                                        0x8
#define SDMA1_QUEUE2_MIDCMD_CNTL__DATA_VALID_MASK                                                             0x00000001L
#define SDMA1_QUEUE2_MIDCMD_CNTL__COPY_MODE_MASK                                                              0x00000002L
#define SDMA1_QUEUE2_MIDCMD_CNTL__SPLIT_STATE_MASK                                                            0x000000F0L
#define SDMA1_QUEUE2_MIDCMD_CNTL__ALLOW_PREEMPT_MASK                                                          0x00000100L
//SDMA1_QUEUE2_MIDCMD_DATA0
#define SDMA1_QUEUE2_MIDCMD_DATA0__DATA0__SHIFT                                                               0x0
#define SDMA1_QUEUE2_MIDCMD_DATA0__DATA0_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE2_MIDCMD_DATA1
#define SDMA1_QUEUE2_MIDCMD_DATA1__DATA1__SHIFT                                                               0x0
#define SDMA1_QUEUE2_MIDCMD_DATA1__DATA1_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE2_MIDCMD_DATA2
#define SDMA1_QUEUE2_MIDCMD_DATA2__DATA2__SHIFT                                                               0x0
#define SDMA1_QUEUE2_MIDCMD_DATA2__DATA2_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE2_MIDCMD_DATA3
#define SDMA1_QUEUE2_MIDCMD_DATA3__DATA3__SHIFT                                                               0x0
#define SDMA1_QUEUE2_MIDCMD_DATA3__DATA3_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE2_MIDCMD_DATA4
#define SDMA1_QUEUE2_MIDCMD_DATA4__DATA4__SHIFT                                                               0x0
#define SDMA1_QUEUE2_MIDCMD_DATA4__DATA4_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE2_MIDCMD_DATA5
#define SDMA1_QUEUE2_MIDCMD_DATA5__DATA5__SHIFT                                                               0x0
#define SDMA1_QUEUE2_MIDCMD_DATA5__DATA5_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE2_MIDCMD_DATA6
#define SDMA1_QUEUE2_MIDCMD_DATA6__DATA6__SHIFT                                                               0x0
#define SDMA1_QUEUE2_MIDCMD_DATA6__DATA6_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE2_MIDCMD_DATA7
#define SDMA1_QUEUE2_MIDCMD_DATA7__DATA7__SHIFT                                                               0x0
#define SDMA1_QUEUE2_MIDCMD_DATA7__DATA7_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE2_MIDCMD_DATA8
#define SDMA1_QUEUE2_MIDCMD_DATA8__DATA8__SHIFT                                                               0x0
#define SDMA1_QUEUE2_MIDCMD_DATA8__DATA8_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE2_MIDCMD_DATA9
#define SDMA1_QUEUE2_MIDCMD_DATA9__DATA9__SHIFT                                                               0x0
#define SDMA1_QUEUE2_MIDCMD_DATA9__DATA9_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE2_MIDCMD_DATA10
#define SDMA1_QUEUE2_MIDCMD_DATA10__DATA10__SHIFT                                                             0x0
#define SDMA1_QUEUE2_MIDCMD_DATA10__DATA10_MASK                                                               0xFFFFFFFFL
//SDMA1_QUEUE2_WAIT_UNSATISFIED_THD
#define SDMA1_QUEUE2_WAIT_UNSATISFIED_THD__THRESHOLD__SHIFT                                                   0x0
#define SDMA1_QUEUE2_WAIT_UNSATISFIED_THD__THRESHOLD_MASK                                                     0x0000001FL
//SDMA1_QUEUE2_MQD_BASE_ADDR_LO
#define SDMA1_QUEUE2_MQD_BASE_ADDR_LO__BASE_ADDR_LO__SHIFT                                                    0x2
#define SDMA1_QUEUE2_MQD_BASE_ADDR_LO__BASE_ADDR_LO_MASK                                                      0xFFFFFFFCL
//SDMA1_QUEUE2_MQD_BASE_ADDR_HI
#define SDMA1_QUEUE2_MQD_BASE_ADDR_HI__BASE_ADDR_HI__SHIFT                                                    0x0
#define SDMA1_QUEUE2_MQD_BASE_ADDR_HI__BASE_ADDR_HI_MASK                                                      0xFFFFFFFFL
//SDMA1_QUEUE2_MQD_CONTROL
#define SDMA1_QUEUE2_MQD_CONTROL__VMID__SHIFT                                                                 0x0
#define SDMA1_QUEUE2_MQD_CONTROL__VMID_MASK                                                                   0x0000000FL
//SDMA1_QUEUE2_DEQUEUE_REQUEST
#define SDMA1_QUEUE2_DEQUEUE_REQUEST__DEQUEUE_REQ__SHIFT                                                      0x0
#define SDMA1_QUEUE2_DEQUEUE_REQUEST__DEQUEUE_REQ_MASK                                                        0x00000001L
//SDMA1_QUEUE2_CONTEXT_STATUS
#define SDMA1_QUEUE2_CONTEXT_STATUS__SELECTED__SHIFT                                                          0x0
#define SDMA1_QUEUE2_CONTEXT_STATUS__USE_IB__SHIFT                                                            0x1
#define SDMA1_QUEUE2_CONTEXT_STATUS__IDLE__SHIFT                                                              0x2
#define SDMA1_QUEUE2_CONTEXT_STATUS__EXPIRED__SHIFT                                                           0x3
#define SDMA1_QUEUE2_CONTEXT_STATUS__EXCEPTION__SHIFT                                                         0x4
#define SDMA1_QUEUE2_CONTEXT_STATUS__CTXSW_ABLE__SHIFT                                                        0x7
#define SDMA1_QUEUE2_CONTEXT_STATUS__VF_STATUS__SHIFT                                                         0x8
#define SDMA1_QUEUE2_CONTEXT_STATUS__PRIV_EXCEPTION__SHIFT                                                    0x9
#define SDMA1_QUEUE2_CONTEXT_STATUS__PREEMPT_DISABLE__SHIFT                                                   0xa
#define SDMA1_QUEUE2_CONTEXT_STATUS__RPTR_WB_IDLE__SHIFT                                                      0xb
#define SDMA1_QUEUE2_CONTEXT_STATUS__WPTR_UPDATE_PENDING__SHIFT                                               0xc
#define SDMA1_QUEUE2_CONTEXT_STATUS__WPTR_UPDATE_FAIL_COUNT__SHIFT                                            0x10
#define SDMA1_QUEUE2_CONTEXT_STATUS__SELECTED_MASK                                                            0x00000001L
#define SDMA1_QUEUE2_CONTEXT_STATUS__USE_IB_MASK                                                              0x00000002L
#define SDMA1_QUEUE2_CONTEXT_STATUS__IDLE_MASK                                                                0x00000004L
#define SDMA1_QUEUE2_CONTEXT_STATUS__EXPIRED_MASK                                                             0x00000008L
#define SDMA1_QUEUE2_CONTEXT_STATUS__EXCEPTION_MASK                                                           0x00000070L
#define SDMA1_QUEUE2_CONTEXT_STATUS__CTXSW_ABLE_MASK                                                          0x00000080L
#define SDMA1_QUEUE2_CONTEXT_STATUS__VF_STATUS_MASK                                                           0x00000100L
#define SDMA1_QUEUE2_CONTEXT_STATUS__PRIV_EXCEPTION_MASK                                                      0x00000200L
#define SDMA1_QUEUE2_CONTEXT_STATUS__PREEMPT_DISABLE_MASK                                                     0x00000400L
#define SDMA1_QUEUE2_CONTEXT_STATUS__RPTR_WB_IDLE_MASK                                                        0x00000800L
#define SDMA1_QUEUE2_CONTEXT_STATUS__WPTR_UPDATE_PENDING_MASK                                                 0x00001000L
#define SDMA1_QUEUE2_CONTEXT_STATUS__WPTR_UPDATE_FAIL_COUNT_MASK                                              0x00FF0000L
//SDMA1_QUEUE3_RB_CNTL
#define SDMA1_QUEUE3_RB_CNTL__RB_ENABLE__SHIFT                                                                0x0
#define SDMA1_QUEUE3_RB_CNTL__RB_SIZE__SHIFT                                                                  0x1
#define SDMA1_QUEUE3_RB_CNTL__WPTR_POLL_ENABLE__SHIFT                                                         0x8
#define SDMA1_QUEUE3_RB_CNTL__RB_SWAP_ENABLE__SHIFT                                                           0x9
#define SDMA1_QUEUE3_RB_CNTL__WPTR_POLL_SWAP_ENABLE__SHIFT                                                    0xa
#define SDMA1_QUEUE3_RB_CNTL__MCU_WPTR_POLL_ENABLE__SHIFT                                                     0xb
#define SDMA1_QUEUE3_RB_CNTL__RPTR_WRITEBACK_ENABLE__SHIFT                                                    0xc
#define SDMA1_QUEUE3_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE__SHIFT                                               0xd
#define SDMA1_QUEUE3_RB_CNTL__RPTR_WRITEBACK_TIMER__SHIFT                                                     0x10
#define SDMA1_QUEUE3_RB_CNTL__RB_PRIV__SHIFT                                                                  0x17
#define SDMA1_QUEUE3_RB_CNTL__RB_VMID__SHIFT                                                                  0x18
#define SDMA1_QUEUE3_RB_CNTL__RB_ENABLE_MASK                                                                  0x00000001L
#define SDMA1_QUEUE3_RB_CNTL__RB_SIZE_MASK                                                                    0x0000003EL
#define SDMA1_QUEUE3_RB_CNTL__WPTR_POLL_ENABLE_MASK                                                           0x00000100L
#define SDMA1_QUEUE3_RB_CNTL__RB_SWAP_ENABLE_MASK                                                             0x00000200L
#define SDMA1_QUEUE3_RB_CNTL__WPTR_POLL_SWAP_ENABLE_MASK                                                      0x00000400L
#define SDMA1_QUEUE3_RB_CNTL__MCU_WPTR_POLL_ENABLE_MASK                                                       0x00000800L
#define SDMA1_QUEUE3_RB_CNTL__RPTR_WRITEBACK_ENABLE_MASK                                                      0x00001000L
#define SDMA1_QUEUE3_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE_MASK                                                 0x00002000L
#define SDMA1_QUEUE3_RB_CNTL__RPTR_WRITEBACK_TIMER_MASK                                                       0x001F0000L
#define SDMA1_QUEUE3_RB_CNTL__RB_PRIV_MASK                                                                    0x00800000L
#define SDMA1_QUEUE3_RB_CNTL__RB_VMID_MASK                                                                    0x0F000000L
//SDMA1_QUEUE3_RB_BASE
#define SDMA1_QUEUE3_RB_BASE__ADDR__SHIFT                                                                     0x0
#define SDMA1_QUEUE3_RB_BASE__ADDR_MASK                                                                       0xFFFFFFFFL
//SDMA1_QUEUE3_RB_BASE_HI
#define SDMA1_QUEUE3_RB_BASE_HI__ADDR__SHIFT                                                                  0x0
#define SDMA1_QUEUE3_RB_BASE_HI__ADDR_MASK                                                                    0x00FFFFFFL
//SDMA1_QUEUE3_RB_RPTR
#define SDMA1_QUEUE3_RB_RPTR__OFFSET__SHIFT                                                                   0x0
#define SDMA1_QUEUE3_RB_RPTR__OFFSET_MASK                                                                     0xFFFFFFFFL
//SDMA1_QUEUE3_RB_RPTR_HI
#define SDMA1_QUEUE3_RB_RPTR_HI__OFFSET__SHIFT                                                                0x0
#define SDMA1_QUEUE3_RB_RPTR_HI__OFFSET_MASK                                                                  0xFFFFFFFFL
//SDMA1_QUEUE3_RB_WPTR
#define SDMA1_QUEUE3_RB_WPTR__OFFSET__SHIFT                                                                   0x0
#define SDMA1_QUEUE3_RB_WPTR__OFFSET_MASK                                                                     0xFFFFFFFFL
//SDMA1_QUEUE3_RB_WPTR_HI
#define SDMA1_QUEUE3_RB_WPTR_HI__OFFSET__SHIFT                                                                0x0
#define SDMA1_QUEUE3_RB_WPTR_HI__OFFSET_MASK                                                                  0xFFFFFFFFL
//SDMA1_QUEUE3_RB_RPTR_ADDR_LO
#define SDMA1_QUEUE3_RB_RPTR_ADDR_LO__ADDR__SHIFT                                                             0x2
#define SDMA1_QUEUE3_RB_RPTR_ADDR_LO__ADDR_MASK                                                               0xFFFFFFFCL
//SDMA1_QUEUE3_RB_RPTR_ADDR_HI
#define SDMA1_QUEUE3_RB_RPTR_ADDR_HI__ADDR__SHIFT                                                             0x0
#define SDMA1_QUEUE3_RB_RPTR_ADDR_HI__ADDR_MASK                                                               0xFFFFFFFFL
//SDMA1_QUEUE3_IB_CNTL
#define SDMA1_QUEUE3_IB_CNTL__IB_ENABLE__SHIFT                                                                0x0
#define SDMA1_QUEUE3_IB_CNTL__IB_SWAP_ENABLE__SHIFT                                                           0x4
#define SDMA1_QUEUE3_IB_CNTL__SWITCH_INSIDE_IB__SHIFT                                                         0x8
#define SDMA1_QUEUE3_IB_CNTL__CMD_VMID__SHIFT                                                                 0x10
#define SDMA1_QUEUE3_IB_CNTL__IB_ENABLE_MASK                                                                  0x00000001L
#define SDMA1_QUEUE3_IB_CNTL__IB_SWAP_ENABLE_MASK                                                             0x00000010L
#define SDMA1_QUEUE3_IB_CNTL__SWITCH_INSIDE_IB_MASK                                                           0x00000100L
#define SDMA1_QUEUE3_IB_CNTL__CMD_VMID_MASK                                                                   0x000F0000L
//SDMA1_QUEUE3_IB_RPTR
#define SDMA1_QUEUE3_IB_RPTR__OFFSET__SHIFT                                                                   0x2
#define SDMA1_QUEUE3_IB_RPTR__OFFSET_MASK                                                                     0x003FFFFCL
//SDMA1_QUEUE3_IB_OFFSET
#define SDMA1_QUEUE3_IB_OFFSET__OFFSET__SHIFT                                                                 0x2
#define SDMA1_QUEUE3_IB_OFFSET__OFFSET_MASK                                                                   0x003FFFFCL
//SDMA1_QUEUE3_IB_BASE_LO
#define SDMA1_QUEUE3_IB_BASE_LO__ADDR__SHIFT                                                                  0x2
#define SDMA1_QUEUE3_IB_BASE_LO__ADDR_MASK                                                                    0xFFFFFFFCL
//SDMA1_QUEUE3_IB_BASE_HI
#define SDMA1_QUEUE3_IB_BASE_HI__ADDR__SHIFT                                                                  0x0
#define SDMA1_QUEUE3_IB_BASE_HI__ADDR_MASK                                                                    0xFFFFFFFFL
//SDMA1_QUEUE3_IB_SIZE
#define SDMA1_QUEUE3_IB_SIZE__SIZE__SHIFT                                                                     0x0
#define SDMA1_QUEUE3_IB_SIZE__SIZE_MASK                                                                       0x000FFFFFL
//SDMA1_QUEUE3_DOORBELL
#define SDMA1_QUEUE3_DOORBELL__ENABLE__SHIFT                                                                  0x1c
#define SDMA1_QUEUE3_DOORBELL__CAPTURED__SHIFT                                                                0x1e
#define SDMA1_QUEUE3_DOORBELL__ENABLE_MASK                                                                    0x10000000L
#define SDMA1_QUEUE3_DOORBELL__CAPTURED_MASK                                                                  0x40000000L
//SDMA1_QUEUE3_DOORBELL_LOG
#define SDMA1_QUEUE3_DOORBELL_LOG__BE_ERROR__SHIFT                                                            0x0
#define SDMA1_QUEUE3_DOORBELL_LOG__DATA__SHIFT                                                                0x2
#define SDMA1_QUEUE3_DOORBELL_LOG__BE_ERROR_MASK                                                              0x00000001L
#define SDMA1_QUEUE3_DOORBELL_LOG__DATA_MASK                                                                  0xFFFFFFFCL
//SDMA1_QUEUE3_DOORBELL_OFFSET
#define SDMA1_QUEUE3_DOORBELL_OFFSET__OFFSET__SHIFT                                                           0x2
#define SDMA1_QUEUE3_DOORBELL_OFFSET__OFFSET_MASK                                                             0x0FFFFFFCL
//SDMA1_QUEUE3_CSA_ADDR_LO
#define SDMA1_QUEUE3_CSA_ADDR_LO__ADDR__SHIFT                                                                 0x2
#define SDMA1_QUEUE3_CSA_ADDR_LO__ADDR_MASK                                                                   0xFFFFFFFCL
//SDMA1_QUEUE3_CSA_ADDR_HI
#define SDMA1_QUEUE3_CSA_ADDR_HI__ADDR__SHIFT                                                                 0x0
#define SDMA1_QUEUE3_CSA_ADDR_HI__ADDR_MASK                                                                   0xFFFFFFFFL
//SDMA1_QUEUE3_SCHEDULE_CNTL
#define SDMA1_QUEUE3_SCHEDULE_CNTL__GLOBAL_ID__SHIFT                                                          0x0
#define SDMA1_QUEUE3_SCHEDULE_CNTL__PROCESS_ID__SHIFT                                                         0x2
#define SDMA1_QUEUE3_SCHEDULE_CNTL__LOCAL_ID__SHIFT                                                           0x6
#define SDMA1_QUEUE3_SCHEDULE_CNTL__CONTEXT_QUANTUM__SHIFT                                                    0x8
#define SDMA1_QUEUE3_SCHEDULE_CNTL__GLOBAL_ID_MASK                                                            0x00000003L
#define SDMA1_QUEUE3_SCHEDULE_CNTL__PROCESS_ID_MASK                                                           0x0000001CL
#define SDMA1_QUEUE3_SCHEDULE_CNTL__LOCAL_ID_MASK                                                             0x000000C0L
#define SDMA1_QUEUE3_SCHEDULE_CNTL__CONTEXT_QUANTUM_MASK                                                      0x0000FF00L
//SDMA1_QUEUE3_IB_SUB_REMAIN
#define SDMA1_QUEUE3_IB_SUB_REMAIN__SIZE__SHIFT                                                               0x0
#define SDMA1_QUEUE3_IB_SUB_REMAIN__SIZE_MASK                                                                 0x00003FFFL
//SDMA1_QUEUE3_PREEMPT
#define SDMA1_QUEUE3_PREEMPT__IB_PREEMPT__SHIFT                                                               0x0
#define SDMA1_QUEUE3_PREEMPT__IB_PREEMPT_MASK                                                                 0x00000001L
//SDMA1_QUEUE3_DUMMY_REG
#define SDMA1_QUEUE3_DUMMY_REG__DUMMY__SHIFT                                                                  0x0
#define SDMA1_QUEUE3_DUMMY_REG__DUMMY_MASK                                                                    0xFFFFFFFFL
//SDMA1_QUEUE3_RB_WPTR_POLL_ADDR_LO
#define SDMA1_QUEUE3_RB_WPTR_POLL_ADDR_LO__ADDR__SHIFT                                                        0x2
#define SDMA1_QUEUE3_RB_WPTR_POLL_ADDR_LO__ADDR_MASK                                                          0xFFFFFFFCL
//SDMA1_QUEUE3_RB_WPTR_POLL_ADDR_HI
#define SDMA1_QUEUE3_RB_WPTR_POLL_ADDR_HI__ADDR__SHIFT                                                        0x0
#define SDMA1_QUEUE3_RB_WPTR_POLL_ADDR_HI__ADDR_MASK                                                          0xFFFFFFFFL
//SDMA1_QUEUE3_RB_AQL_CNTL
#define SDMA1_QUEUE3_RB_AQL_CNTL__AQL_ENABLE__SHIFT                                                           0x0
#define SDMA1_QUEUE3_RB_AQL_CNTL__AQL_PACKET_SIZE__SHIFT                                                      0x1
#define SDMA1_QUEUE3_RB_AQL_CNTL__PACKET_STEP__SHIFT                                                          0x8
#define SDMA1_QUEUE3_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE__SHIFT                                                0x10
#define SDMA1_QUEUE3_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE__SHIFT                                          0x11
#define SDMA1_QUEUE3_RB_AQL_CNTL__OVERLAP_ENABLE__SHIFT                                                       0x12
#define SDMA1_QUEUE3_RB_AQL_CNTL__AQL_ENABLE_MASK                                                             0x00000001L
#define SDMA1_QUEUE3_RB_AQL_CNTL__AQL_PACKET_SIZE_MASK                                                        0x000000FEL
#define SDMA1_QUEUE3_RB_AQL_CNTL__PACKET_STEP_MASK                                                            0x0000FF00L
#define SDMA1_QUEUE3_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE_MASK                                                  0x00010000L
#define SDMA1_QUEUE3_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE_MASK                                            0x00020000L
#define SDMA1_QUEUE3_RB_AQL_CNTL__OVERLAP_ENABLE_MASK                                                         0x00040000L
//SDMA1_QUEUE3_MINOR_PTR_UPDATE
#define SDMA1_QUEUE3_MINOR_PTR_UPDATE__ENABLE__SHIFT                                                          0x0
#define SDMA1_QUEUE3_MINOR_PTR_UPDATE__ENABLE_MASK                                                            0x00000001L
//SDMA1_QUEUE3_CONTEXT_SWITCH_STATUS
#define SDMA1_QUEUE3_CONTEXT_SWITCH_STATUS__RB_PREEMPT_STATUS__SHIFT                                          0x0
#define SDMA1_QUEUE3_CONTEXT_SWITCH_STATUS__VM_HOLE_EXCEPTION__SHIFT                                          0x1
#define SDMA1_QUEUE3_CONTEXT_SWITCH_STATUS__PAGE_EXCEPTION__SHIFT                                             0x2
#define SDMA1_QUEUE3_CONTEXT_SWITCH_STATUS__QUEUE_HANG_EXCEPTION__SHIFT                                       0x5
#define SDMA1_QUEUE3_CONTEXT_SWITCH_STATUS__DOORBELL_ERROR_EXCEPTION__SHIFT                                   0x6
#define SDMA1_QUEUE3_CONTEXT_SWITCH_STATUS__SRAM_ECC_EXCEPTION__SHIFT                                         0x7
#define SDMA1_QUEUE3_CONTEXT_SWITCH_STATUS__DRAM_ECC_EXCEPTION__SHIFT                                         0x8
#define SDMA1_QUEUE3_CONTEXT_SWITCH_STATUS__WPTR_LT_RPTR_EXCEPTION__SHIFT                                     0x9
#define SDMA1_QUEUE3_CONTEXT_SWITCH_STATUS__RB_PREEMPT_STATUS_MASK                                            0x00000001L
#define SDMA1_QUEUE3_CONTEXT_SWITCH_STATUS__VM_HOLE_EXCEPTION_MASK                                            0x00000002L
#define SDMA1_QUEUE3_CONTEXT_SWITCH_STATUS__PAGE_EXCEPTION_MASK                                               0x00000004L
#define SDMA1_QUEUE3_CONTEXT_SWITCH_STATUS__QUEUE_HANG_EXCEPTION_MASK                                         0x00000020L
#define SDMA1_QUEUE3_CONTEXT_SWITCH_STATUS__DOORBELL_ERROR_EXCEPTION_MASK                                     0x00000040L
#define SDMA1_QUEUE3_CONTEXT_SWITCH_STATUS__SRAM_ECC_EXCEPTION_MASK                                           0x00000080L
#define SDMA1_QUEUE3_CONTEXT_SWITCH_STATUS__DRAM_ECC_EXCEPTION_MASK                                           0x00000100L
#define SDMA1_QUEUE3_CONTEXT_SWITCH_STATUS__WPTR_LT_RPTR_EXCEPTION_MASK                                       0x00000200L
//SDMA1_QUEUE3_MIDCMD_CNTL
#define SDMA1_QUEUE3_MIDCMD_CNTL__DATA_VALID__SHIFT                                                           0x0
#define SDMA1_QUEUE3_MIDCMD_CNTL__COPY_MODE__SHIFT                                                            0x1
#define SDMA1_QUEUE3_MIDCMD_CNTL__SPLIT_STATE__SHIFT                                                          0x4
#define SDMA1_QUEUE3_MIDCMD_CNTL__ALLOW_PREEMPT__SHIFT                                                        0x8
#define SDMA1_QUEUE3_MIDCMD_CNTL__DATA_VALID_MASK                                                             0x00000001L
#define SDMA1_QUEUE3_MIDCMD_CNTL__COPY_MODE_MASK                                                              0x00000002L
#define SDMA1_QUEUE3_MIDCMD_CNTL__SPLIT_STATE_MASK                                                            0x000000F0L
#define SDMA1_QUEUE3_MIDCMD_CNTL__ALLOW_PREEMPT_MASK                                                          0x00000100L
//SDMA1_QUEUE3_MIDCMD_DATA0
#define SDMA1_QUEUE3_MIDCMD_DATA0__DATA0__SHIFT                                                               0x0
#define SDMA1_QUEUE3_MIDCMD_DATA0__DATA0_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE3_MIDCMD_DATA1
#define SDMA1_QUEUE3_MIDCMD_DATA1__DATA1__SHIFT                                                               0x0
#define SDMA1_QUEUE3_MIDCMD_DATA1__DATA1_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE3_MIDCMD_DATA2
#define SDMA1_QUEUE3_MIDCMD_DATA2__DATA2__SHIFT                                                               0x0
#define SDMA1_QUEUE3_MIDCMD_DATA2__DATA2_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE3_MIDCMD_DATA3
#define SDMA1_QUEUE3_MIDCMD_DATA3__DATA3__SHIFT                                                               0x0
#define SDMA1_QUEUE3_MIDCMD_DATA3__DATA3_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE3_MIDCMD_DATA4
#define SDMA1_QUEUE3_MIDCMD_DATA4__DATA4__SHIFT                                                               0x0
#define SDMA1_QUEUE3_MIDCMD_DATA4__DATA4_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE3_MIDCMD_DATA5
#define SDMA1_QUEUE3_MIDCMD_DATA5__DATA5__SHIFT                                                               0x0
#define SDMA1_QUEUE3_MIDCMD_DATA5__DATA5_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE3_MIDCMD_DATA6
#define SDMA1_QUEUE3_MIDCMD_DATA6__DATA6__SHIFT                                                               0x0
#define SDMA1_QUEUE3_MIDCMD_DATA6__DATA6_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE3_MIDCMD_DATA7
#define SDMA1_QUEUE3_MIDCMD_DATA7__DATA7__SHIFT                                                               0x0
#define SDMA1_QUEUE3_MIDCMD_DATA7__DATA7_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE3_MIDCMD_DATA8
#define SDMA1_QUEUE3_MIDCMD_DATA8__DATA8__SHIFT                                                               0x0
#define SDMA1_QUEUE3_MIDCMD_DATA8__DATA8_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE3_MIDCMD_DATA9
#define SDMA1_QUEUE3_MIDCMD_DATA9__DATA9__SHIFT                                                               0x0
#define SDMA1_QUEUE3_MIDCMD_DATA9__DATA9_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE3_MIDCMD_DATA10
#define SDMA1_QUEUE3_MIDCMD_DATA10__DATA10__SHIFT                                                             0x0
#define SDMA1_QUEUE3_MIDCMD_DATA10__DATA10_MASK                                                               0xFFFFFFFFL
//SDMA1_QUEUE3_WAIT_UNSATISFIED_THD
#define SDMA1_QUEUE3_WAIT_UNSATISFIED_THD__THRESHOLD__SHIFT                                                   0x0
#define SDMA1_QUEUE3_WAIT_UNSATISFIED_THD__THRESHOLD_MASK                                                     0x0000001FL
//SDMA1_QUEUE3_MQD_BASE_ADDR_LO
#define SDMA1_QUEUE3_MQD_BASE_ADDR_LO__BASE_ADDR_LO__SHIFT                                                    0x2
#define SDMA1_QUEUE3_MQD_BASE_ADDR_LO__BASE_ADDR_LO_MASK                                                      0xFFFFFFFCL
//SDMA1_QUEUE3_MQD_BASE_ADDR_HI
#define SDMA1_QUEUE3_MQD_BASE_ADDR_HI__BASE_ADDR_HI__SHIFT                                                    0x0
#define SDMA1_QUEUE3_MQD_BASE_ADDR_HI__BASE_ADDR_HI_MASK                                                      0xFFFFFFFFL
//SDMA1_QUEUE3_MQD_CONTROL
#define SDMA1_QUEUE3_MQD_CONTROL__VMID__SHIFT                                                                 0x0
#define SDMA1_QUEUE3_MQD_CONTROL__VMID_MASK                                                                   0x0000000FL
//SDMA1_QUEUE3_DEQUEUE_REQUEST
#define SDMA1_QUEUE3_DEQUEUE_REQUEST__DEQUEUE_REQ__SHIFT                                                      0x0
#define SDMA1_QUEUE3_DEQUEUE_REQUEST__DEQUEUE_REQ_MASK                                                        0x00000001L
//SDMA1_QUEUE3_CONTEXT_STATUS
#define SDMA1_QUEUE3_CONTEXT_STATUS__SELECTED__SHIFT                                                          0x0
#define SDMA1_QUEUE3_CONTEXT_STATUS__USE_IB__SHIFT                                                            0x1
#define SDMA1_QUEUE3_CONTEXT_STATUS__IDLE__SHIFT                                                              0x2
#define SDMA1_QUEUE3_CONTEXT_STATUS__EXPIRED__SHIFT                                                           0x3
#define SDMA1_QUEUE3_CONTEXT_STATUS__EXCEPTION__SHIFT                                                         0x4
#define SDMA1_QUEUE3_CONTEXT_STATUS__CTXSW_ABLE__SHIFT                                                        0x7
#define SDMA1_QUEUE3_CONTEXT_STATUS__VF_STATUS__SHIFT                                                         0x8
#define SDMA1_QUEUE3_CONTEXT_STATUS__PRIV_EXCEPTION__SHIFT                                                    0x9
#define SDMA1_QUEUE3_CONTEXT_STATUS__PREEMPT_DISABLE__SHIFT                                                   0xa
#define SDMA1_QUEUE3_CONTEXT_STATUS__RPTR_WB_IDLE__SHIFT                                                      0xb
#define SDMA1_QUEUE3_CONTEXT_STATUS__WPTR_UPDATE_PENDING__SHIFT                                               0xc
#define SDMA1_QUEUE3_CONTEXT_STATUS__WPTR_UPDATE_FAIL_COUNT__SHIFT                                            0x10
#define SDMA1_QUEUE3_CONTEXT_STATUS__SELECTED_MASK                                                            0x00000001L
#define SDMA1_QUEUE3_CONTEXT_STATUS__USE_IB_MASK                                                              0x00000002L
#define SDMA1_QUEUE3_CONTEXT_STATUS__IDLE_MASK                                                                0x00000004L
#define SDMA1_QUEUE3_CONTEXT_STATUS__EXPIRED_MASK                                                             0x00000008L
#define SDMA1_QUEUE3_CONTEXT_STATUS__EXCEPTION_MASK                                                           0x00000070L
#define SDMA1_QUEUE3_CONTEXT_STATUS__CTXSW_ABLE_MASK                                                          0x00000080L
#define SDMA1_QUEUE3_CONTEXT_STATUS__VF_STATUS_MASK                                                           0x00000100L
#define SDMA1_QUEUE3_CONTEXT_STATUS__PRIV_EXCEPTION_MASK                                                      0x00000200L
#define SDMA1_QUEUE3_CONTEXT_STATUS__PREEMPT_DISABLE_MASK                                                     0x00000400L
#define SDMA1_QUEUE3_CONTEXT_STATUS__RPTR_WB_IDLE_MASK                                                        0x00000800L
#define SDMA1_QUEUE3_CONTEXT_STATUS__WPTR_UPDATE_PENDING_MASK                                                 0x00001000L
#define SDMA1_QUEUE3_CONTEXT_STATUS__WPTR_UPDATE_FAIL_COUNT_MASK                                              0x00FF0000L
//SDMA1_QUEUE4_RB_CNTL
#define SDMA1_QUEUE4_RB_CNTL__RB_ENABLE__SHIFT                                                                0x0
#define SDMA1_QUEUE4_RB_CNTL__RB_SIZE__SHIFT                                                                  0x1
#define SDMA1_QUEUE4_RB_CNTL__WPTR_POLL_ENABLE__SHIFT                                                         0x8
#define SDMA1_QUEUE4_RB_CNTL__RB_SWAP_ENABLE__SHIFT                                                           0x9
#define SDMA1_QUEUE4_RB_CNTL__WPTR_POLL_SWAP_ENABLE__SHIFT                                                    0xa
#define SDMA1_QUEUE4_RB_CNTL__MCU_WPTR_POLL_ENABLE__SHIFT                                                     0xb
#define SDMA1_QUEUE4_RB_CNTL__RPTR_WRITEBACK_ENABLE__SHIFT                                                    0xc
#define SDMA1_QUEUE4_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE__SHIFT                                               0xd
#define SDMA1_QUEUE4_RB_CNTL__RPTR_WRITEBACK_TIMER__SHIFT                                                     0x10
#define SDMA1_QUEUE4_RB_CNTL__RB_PRIV__SHIFT                                                                  0x17
#define SDMA1_QUEUE4_RB_CNTL__RB_VMID__SHIFT                                                                  0x18
#define SDMA1_QUEUE4_RB_CNTL__RB_ENABLE_MASK                                                                  0x00000001L
#define SDMA1_QUEUE4_RB_CNTL__RB_SIZE_MASK                                                                    0x0000003EL
#define SDMA1_QUEUE4_RB_CNTL__WPTR_POLL_ENABLE_MASK                                                           0x00000100L
#define SDMA1_QUEUE4_RB_CNTL__RB_SWAP_ENABLE_MASK                                                             0x00000200L
#define SDMA1_QUEUE4_RB_CNTL__WPTR_POLL_SWAP_ENABLE_MASK                                                      0x00000400L
#define SDMA1_QUEUE4_RB_CNTL__MCU_WPTR_POLL_ENABLE_MASK                                                       0x00000800L
#define SDMA1_QUEUE4_RB_CNTL__RPTR_WRITEBACK_ENABLE_MASK                                                      0x00001000L
#define SDMA1_QUEUE4_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE_MASK                                                 0x00002000L
#define SDMA1_QUEUE4_RB_CNTL__RPTR_WRITEBACK_TIMER_MASK                                                       0x001F0000L
#define SDMA1_QUEUE4_RB_CNTL__RB_PRIV_MASK                                                                    0x00800000L
#define SDMA1_QUEUE4_RB_CNTL__RB_VMID_MASK                                                                    0x0F000000L
//SDMA1_QUEUE4_RB_BASE
#define SDMA1_QUEUE4_RB_BASE__ADDR__SHIFT                                                                     0x0
#define SDMA1_QUEUE4_RB_BASE__ADDR_MASK                                                                       0xFFFFFFFFL
//SDMA1_QUEUE4_RB_BASE_HI
#define SDMA1_QUEUE4_RB_BASE_HI__ADDR__SHIFT                                                                  0x0
#define SDMA1_QUEUE4_RB_BASE_HI__ADDR_MASK                                                                    0x00FFFFFFL
//SDMA1_QUEUE4_RB_RPTR
#define SDMA1_QUEUE4_RB_RPTR__OFFSET__SHIFT                                                                   0x0
#define SDMA1_QUEUE4_RB_RPTR__OFFSET_MASK                                                                     0xFFFFFFFFL
//SDMA1_QUEUE4_RB_RPTR_HI
#define SDMA1_QUEUE4_RB_RPTR_HI__OFFSET__SHIFT                                                                0x0
#define SDMA1_QUEUE4_RB_RPTR_HI__OFFSET_MASK                                                                  0xFFFFFFFFL
//SDMA1_QUEUE4_RB_WPTR
#define SDMA1_QUEUE4_RB_WPTR__OFFSET__SHIFT                                                                   0x0
#define SDMA1_QUEUE4_RB_WPTR__OFFSET_MASK                                                                     0xFFFFFFFFL
//SDMA1_QUEUE4_RB_WPTR_HI
#define SDMA1_QUEUE4_RB_WPTR_HI__OFFSET__SHIFT                                                                0x0
#define SDMA1_QUEUE4_RB_WPTR_HI__OFFSET_MASK                                                                  0xFFFFFFFFL
//SDMA1_QUEUE4_RB_RPTR_ADDR_LO
#define SDMA1_QUEUE4_RB_RPTR_ADDR_LO__ADDR__SHIFT                                                             0x2
#define SDMA1_QUEUE4_RB_RPTR_ADDR_LO__ADDR_MASK                                                               0xFFFFFFFCL
//SDMA1_QUEUE4_RB_RPTR_ADDR_HI
#define SDMA1_QUEUE4_RB_RPTR_ADDR_HI__ADDR__SHIFT                                                             0x0
#define SDMA1_QUEUE4_RB_RPTR_ADDR_HI__ADDR_MASK                                                               0xFFFFFFFFL
//SDMA1_QUEUE4_IB_CNTL
#define SDMA1_QUEUE4_IB_CNTL__IB_ENABLE__SHIFT                                                                0x0
#define SDMA1_QUEUE4_IB_CNTL__IB_SWAP_ENABLE__SHIFT                                                           0x4
#define SDMA1_QUEUE4_IB_CNTL__SWITCH_INSIDE_IB__SHIFT                                                         0x8
#define SDMA1_QUEUE4_IB_CNTL__CMD_VMID__SHIFT                                                                 0x10
#define SDMA1_QUEUE4_IB_CNTL__IB_ENABLE_MASK                                                                  0x00000001L
#define SDMA1_QUEUE4_IB_CNTL__IB_SWAP_ENABLE_MASK                                                             0x00000010L
#define SDMA1_QUEUE4_IB_CNTL__SWITCH_INSIDE_IB_MASK                                                           0x00000100L
#define SDMA1_QUEUE4_IB_CNTL__CMD_VMID_MASK                                                                   0x000F0000L
//SDMA1_QUEUE4_IB_RPTR
#define SDMA1_QUEUE4_IB_RPTR__OFFSET__SHIFT                                                                   0x2
#define SDMA1_QUEUE4_IB_RPTR__OFFSET_MASK                                                                     0x003FFFFCL
//SDMA1_QUEUE4_IB_OFFSET
#define SDMA1_QUEUE4_IB_OFFSET__OFFSET__SHIFT                                                                 0x2
#define SDMA1_QUEUE4_IB_OFFSET__OFFSET_MASK                                                                   0x003FFFFCL
//SDMA1_QUEUE4_IB_BASE_LO
#define SDMA1_QUEUE4_IB_BASE_LO__ADDR__SHIFT                                                                  0x2
#define SDMA1_QUEUE4_IB_BASE_LO__ADDR_MASK                                                                    0xFFFFFFFCL
//SDMA1_QUEUE4_IB_BASE_HI
#define SDMA1_QUEUE4_IB_BASE_HI__ADDR__SHIFT                                                                  0x0
#define SDMA1_QUEUE4_IB_BASE_HI__ADDR_MASK                                                                    0xFFFFFFFFL
//SDMA1_QUEUE4_IB_SIZE
#define SDMA1_QUEUE4_IB_SIZE__SIZE__SHIFT                                                                     0x0
#define SDMA1_QUEUE4_IB_SIZE__SIZE_MASK                                                                       0x000FFFFFL
//SDMA1_QUEUE4_DOORBELL
#define SDMA1_QUEUE4_DOORBELL__ENABLE__SHIFT                                                                  0x1c
#define SDMA1_QUEUE4_DOORBELL__CAPTURED__SHIFT                                                                0x1e
#define SDMA1_QUEUE4_DOORBELL__ENABLE_MASK                                                                    0x10000000L
#define SDMA1_QUEUE4_DOORBELL__CAPTURED_MASK                                                                  0x40000000L
//SDMA1_QUEUE4_DOORBELL_LOG
#define SDMA1_QUEUE4_DOORBELL_LOG__BE_ERROR__SHIFT                                                            0x0
#define SDMA1_QUEUE4_DOORBELL_LOG__DATA__SHIFT                                                                0x2
#define SDMA1_QUEUE4_DOORBELL_LOG__BE_ERROR_MASK                                                              0x00000001L
#define SDMA1_QUEUE4_DOORBELL_LOG__DATA_MASK                                                                  0xFFFFFFFCL
//SDMA1_QUEUE4_DOORBELL_OFFSET
#define SDMA1_QUEUE4_DOORBELL_OFFSET__OFFSET__SHIFT                                                           0x2
#define SDMA1_QUEUE4_DOORBELL_OFFSET__OFFSET_MASK                                                             0x0FFFFFFCL
//SDMA1_QUEUE4_CSA_ADDR_LO
#define SDMA1_QUEUE4_CSA_ADDR_LO__ADDR__SHIFT                                                                 0x2
#define SDMA1_QUEUE4_CSA_ADDR_LO__ADDR_MASK                                                                   0xFFFFFFFCL
//SDMA1_QUEUE4_CSA_ADDR_HI
#define SDMA1_QUEUE4_CSA_ADDR_HI__ADDR__SHIFT                                                                 0x0
#define SDMA1_QUEUE4_CSA_ADDR_HI__ADDR_MASK                                                                   0xFFFFFFFFL
//SDMA1_QUEUE4_SCHEDULE_CNTL
#define SDMA1_QUEUE4_SCHEDULE_CNTL__GLOBAL_ID__SHIFT                                                          0x0
#define SDMA1_QUEUE4_SCHEDULE_CNTL__PROCESS_ID__SHIFT                                                         0x2
#define SDMA1_QUEUE4_SCHEDULE_CNTL__LOCAL_ID__SHIFT                                                           0x6
#define SDMA1_QUEUE4_SCHEDULE_CNTL__CONTEXT_QUANTUM__SHIFT                                                    0x8
#define SDMA1_QUEUE4_SCHEDULE_CNTL__GLOBAL_ID_MASK                                                            0x00000003L
#define SDMA1_QUEUE4_SCHEDULE_CNTL__PROCESS_ID_MASK                                                           0x0000001CL
#define SDMA1_QUEUE4_SCHEDULE_CNTL__LOCAL_ID_MASK                                                             0x000000C0L
#define SDMA1_QUEUE4_SCHEDULE_CNTL__CONTEXT_QUANTUM_MASK                                                      0x0000FF00L
//SDMA1_QUEUE4_IB_SUB_REMAIN
#define SDMA1_QUEUE4_IB_SUB_REMAIN__SIZE__SHIFT                                                               0x0
#define SDMA1_QUEUE4_IB_SUB_REMAIN__SIZE_MASK                                                                 0x00003FFFL
//SDMA1_QUEUE4_PREEMPT
#define SDMA1_QUEUE4_PREEMPT__IB_PREEMPT__SHIFT                                                               0x0
#define SDMA1_QUEUE4_PREEMPT__IB_PREEMPT_MASK                                                                 0x00000001L
//SDMA1_QUEUE4_DUMMY_REG
#define SDMA1_QUEUE4_DUMMY_REG__DUMMY__SHIFT                                                                  0x0
#define SDMA1_QUEUE4_DUMMY_REG__DUMMY_MASK                                                                    0xFFFFFFFFL
//SDMA1_QUEUE4_RB_WPTR_POLL_ADDR_LO
#define SDMA1_QUEUE4_RB_WPTR_POLL_ADDR_LO__ADDR__SHIFT                                                        0x2
#define SDMA1_QUEUE4_RB_WPTR_POLL_ADDR_LO__ADDR_MASK                                                          0xFFFFFFFCL
//SDMA1_QUEUE4_RB_WPTR_POLL_ADDR_HI
#define SDMA1_QUEUE4_RB_WPTR_POLL_ADDR_HI__ADDR__SHIFT                                                        0x0
#define SDMA1_QUEUE4_RB_WPTR_POLL_ADDR_HI__ADDR_MASK                                                          0xFFFFFFFFL
//SDMA1_QUEUE4_RB_AQL_CNTL
#define SDMA1_QUEUE4_RB_AQL_CNTL__AQL_ENABLE__SHIFT                                                           0x0
#define SDMA1_QUEUE4_RB_AQL_CNTL__AQL_PACKET_SIZE__SHIFT                                                      0x1
#define SDMA1_QUEUE4_RB_AQL_CNTL__PACKET_STEP__SHIFT                                                          0x8
#define SDMA1_QUEUE4_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE__SHIFT                                                0x10
#define SDMA1_QUEUE4_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE__SHIFT                                          0x11
#define SDMA1_QUEUE4_RB_AQL_CNTL__OVERLAP_ENABLE__SHIFT                                                       0x12
#define SDMA1_QUEUE4_RB_AQL_CNTL__AQL_ENABLE_MASK                                                             0x00000001L
#define SDMA1_QUEUE4_RB_AQL_CNTL__AQL_PACKET_SIZE_MASK                                                        0x000000FEL
#define SDMA1_QUEUE4_RB_AQL_CNTL__PACKET_STEP_MASK                                                            0x0000FF00L
#define SDMA1_QUEUE4_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE_MASK                                                  0x00010000L
#define SDMA1_QUEUE4_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE_MASK                                            0x00020000L
#define SDMA1_QUEUE4_RB_AQL_CNTL__OVERLAP_ENABLE_MASK                                                         0x00040000L
//SDMA1_QUEUE4_MINOR_PTR_UPDATE
#define SDMA1_QUEUE4_MINOR_PTR_UPDATE__ENABLE__SHIFT                                                          0x0
#define SDMA1_QUEUE4_MINOR_PTR_UPDATE__ENABLE_MASK                                                            0x00000001L
//SDMA1_QUEUE4_CONTEXT_SWITCH_STATUS
#define SDMA1_QUEUE4_CONTEXT_SWITCH_STATUS__RB_PREEMPT_STATUS__SHIFT                                          0x0
#define SDMA1_QUEUE4_CONTEXT_SWITCH_STATUS__VM_HOLE_EXCEPTION__SHIFT                                          0x1
#define SDMA1_QUEUE4_CONTEXT_SWITCH_STATUS__PAGE_EXCEPTION__SHIFT                                             0x2
#define SDMA1_QUEUE4_CONTEXT_SWITCH_STATUS__QUEUE_HANG_EXCEPTION__SHIFT                                       0x5
#define SDMA1_QUEUE4_CONTEXT_SWITCH_STATUS__DOORBELL_ERROR_EXCEPTION__SHIFT                                   0x6
#define SDMA1_QUEUE4_CONTEXT_SWITCH_STATUS__SRAM_ECC_EXCEPTION__SHIFT                                         0x7
#define SDMA1_QUEUE4_CONTEXT_SWITCH_STATUS__DRAM_ECC_EXCEPTION__SHIFT                                         0x8
#define SDMA1_QUEUE4_CONTEXT_SWITCH_STATUS__WPTR_LT_RPTR_EXCEPTION__SHIFT                                     0x9
#define SDMA1_QUEUE4_CONTEXT_SWITCH_STATUS__RB_PREEMPT_STATUS_MASK                                            0x00000001L
#define SDMA1_QUEUE4_CONTEXT_SWITCH_STATUS__VM_HOLE_EXCEPTION_MASK                                            0x00000002L
#define SDMA1_QUEUE4_CONTEXT_SWITCH_STATUS__PAGE_EXCEPTION_MASK                                               0x00000004L
#define SDMA1_QUEUE4_CONTEXT_SWITCH_STATUS__QUEUE_HANG_EXCEPTION_MASK                                         0x00000020L
#define SDMA1_QUEUE4_CONTEXT_SWITCH_STATUS__DOORBELL_ERROR_EXCEPTION_MASK                                     0x00000040L
#define SDMA1_QUEUE4_CONTEXT_SWITCH_STATUS__SRAM_ECC_EXCEPTION_MASK                                           0x00000080L
#define SDMA1_QUEUE4_CONTEXT_SWITCH_STATUS__DRAM_ECC_EXCEPTION_MASK                                           0x00000100L
#define SDMA1_QUEUE4_CONTEXT_SWITCH_STATUS__WPTR_LT_RPTR_EXCEPTION_MASK                                       0x00000200L
//SDMA1_QUEUE4_MIDCMD_CNTL
#define SDMA1_QUEUE4_MIDCMD_CNTL__DATA_VALID__SHIFT                                                           0x0
#define SDMA1_QUEUE4_MIDCMD_CNTL__COPY_MODE__SHIFT                                                            0x1
#define SDMA1_QUEUE4_MIDCMD_CNTL__SPLIT_STATE__SHIFT                                                          0x4
#define SDMA1_QUEUE4_MIDCMD_CNTL__ALLOW_PREEMPT__SHIFT                                                        0x8
#define SDMA1_QUEUE4_MIDCMD_CNTL__DATA_VALID_MASK                                                             0x00000001L
#define SDMA1_QUEUE4_MIDCMD_CNTL__COPY_MODE_MASK                                                              0x00000002L
#define SDMA1_QUEUE4_MIDCMD_CNTL__SPLIT_STATE_MASK                                                            0x000000F0L
#define SDMA1_QUEUE4_MIDCMD_CNTL__ALLOW_PREEMPT_MASK                                                          0x00000100L
//SDMA1_QUEUE4_MIDCMD_DATA0
#define SDMA1_QUEUE4_MIDCMD_DATA0__DATA0__SHIFT                                                               0x0
#define SDMA1_QUEUE4_MIDCMD_DATA0__DATA0_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE4_MIDCMD_DATA1
#define SDMA1_QUEUE4_MIDCMD_DATA1__DATA1__SHIFT                                                               0x0
#define SDMA1_QUEUE4_MIDCMD_DATA1__DATA1_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE4_MIDCMD_DATA2
#define SDMA1_QUEUE4_MIDCMD_DATA2__DATA2__SHIFT                                                               0x0
#define SDMA1_QUEUE4_MIDCMD_DATA2__DATA2_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE4_MIDCMD_DATA3
#define SDMA1_QUEUE4_MIDCMD_DATA3__DATA3__SHIFT                                                               0x0
#define SDMA1_QUEUE4_MIDCMD_DATA3__DATA3_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE4_MIDCMD_DATA4
#define SDMA1_QUEUE4_MIDCMD_DATA4__DATA4__SHIFT                                                               0x0
#define SDMA1_QUEUE4_MIDCMD_DATA4__DATA4_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE4_MIDCMD_DATA5
#define SDMA1_QUEUE4_MIDCMD_DATA5__DATA5__SHIFT                                                               0x0
#define SDMA1_QUEUE4_MIDCMD_DATA5__DATA5_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE4_MIDCMD_DATA6
#define SDMA1_QUEUE4_MIDCMD_DATA6__DATA6__SHIFT                                                               0x0
#define SDMA1_QUEUE4_MIDCMD_DATA6__DATA6_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE4_MIDCMD_DATA7
#define SDMA1_QUEUE4_MIDCMD_DATA7__DATA7__SHIFT                                                               0x0
#define SDMA1_QUEUE4_MIDCMD_DATA7__DATA7_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE4_MIDCMD_DATA8
#define SDMA1_QUEUE4_MIDCMD_DATA8__DATA8__SHIFT                                                               0x0
#define SDMA1_QUEUE4_MIDCMD_DATA8__DATA8_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE4_MIDCMD_DATA9
#define SDMA1_QUEUE4_MIDCMD_DATA9__DATA9__SHIFT                                                               0x0
#define SDMA1_QUEUE4_MIDCMD_DATA9__DATA9_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE4_MIDCMD_DATA10
#define SDMA1_QUEUE4_MIDCMD_DATA10__DATA10__SHIFT                                                             0x0
#define SDMA1_QUEUE4_MIDCMD_DATA10__DATA10_MASK                                                               0xFFFFFFFFL
//SDMA1_QUEUE4_WAIT_UNSATISFIED_THD
#define SDMA1_QUEUE4_WAIT_UNSATISFIED_THD__THRESHOLD__SHIFT                                                   0x0
#define SDMA1_QUEUE4_WAIT_UNSATISFIED_THD__THRESHOLD_MASK                                                     0x0000001FL
//SDMA1_QUEUE4_MQD_BASE_ADDR_LO
#define SDMA1_QUEUE4_MQD_BASE_ADDR_LO__BASE_ADDR_LO__SHIFT                                                    0x2
#define SDMA1_QUEUE4_MQD_BASE_ADDR_LO__BASE_ADDR_LO_MASK                                                      0xFFFFFFFCL
//SDMA1_QUEUE4_MQD_BASE_ADDR_HI
#define SDMA1_QUEUE4_MQD_BASE_ADDR_HI__BASE_ADDR_HI__SHIFT                                                    0x0
#define SDMA1_QUEUE4_MQD_BASE_ADDR_HI__BASE_ADDR_HI_MASK                                                      0xFFFFFFFFL
//SDMA1_QUEUE4_MQD_CONTROL
#define SDMA1_QUEUE4_MQD_CONTROL__VMID__SHIFT                                                                 0x0
#define SDMA1_QUEUE4_MQD_CONTROL__VMID_MASK                                                                   0x0000000FL
//SDMA1_QUEUE4_DEQUEUE_REQUEST
#define SDMA1_QUEUE4_DEQUEUE_REQUEST__DEQUEUE_REQ__SHIFT                                                      0x0
#define SDMA1_QUEUE4_DEQUEUE_REQUEST__DEQUEUE_REQ_MASK                                                        0x00000001L
//SDMA1_QUEUE4_CONTEXT_STATUS
#define SDMA1_QUEUE4_CONTEXT_STATUS__SELECTED__SHIFT                                                          0x0
#define SDMA1_QUEUE4_CONTEXT_STATUS__USE_IB__SHIFT                                                            0x1
#define SDMA1_QUEUE4_CONTEXT_STATUS__IDLE__SHIFT                                                              0x2
#define SDMA1_QUEUE4_CONTEXT_STATUS__EXPIRED__SHIFT                                                           0x3
#define SDMA1_QUEUE4_CONTEXT_STATUS__EXCEPTION__SHIFT                                                         0x4
#define SDMA1_QUEUE4_CONTEXT_STATUS__CTXSW_ABLE__SHIFT                                                        0x7
#define SDMA1_QUEUE4_CONTEXT_STATUS__VF_STATUS__SHIFT                                                         0x8
#define SDMA1_QUEUE4_CONTEXT_STATUS__PRIV_EXCEPTION__SHIFT                                                    0x9
#define SDMA1_QUEUE4_CONTEXT_STATUS__PREEMPT_DISABLE__SHIFT                                                   0xa
#define SDMA1_QUEUE4_CONTEXT_STATUS__RPTR_WB_IDLE__SHIFT                                                      0xb
#define SDMA1_QUEUE4_CONTEXT_STATUS__WPTR_UPDATE_PENDING__SHIFT                                               0xc
#define SDMA1_QUEUE4_CONTEXT_STATUS__WPTR_UPDATE_FAIL_COUNT__SHIFT                                            0x10
#define SDMA1_QUEUE4_CONTEXT_STATUS__SELECTED_MASK                                                            0x00000001L
#define SDMA1_QUEUE4_CONTEXT_STATUS__USE_IB_MASK                                                              0x00000002L
#define SDMA1_QUEUE4_CONTEXT_STATUS__IDLE_MASK                                                                0x00000004L
#define SDMA1_QUEUE4_CONTEXT_STATUS__EXPIRED_MASK                                                             0x00000008L
#define SDMA1_QUEUE4_CONTEXT_STATUS__EXCEPTION_MASK                                                           0x00000070L
#define SDMA1_QUEUE4_CONTEXT_STATUS__CTXSW_ABLE_MASK                                                          0x00000080L
#define SDMA1_QUEUE4_CONTEXT_STATUS__VF_STATUS_MASK                                                           0x00000100L
#define SDMA1_QUEUE4_CONTEXT_STATUS__PRIV_EXCEPTION_MASK                                                      0x00000200L
#define SDMA1_QUEUE4_CONTEXT_STATUS__PREEMPT_DISABLE_MASK                                                     0x00000400L
#define SDMA1_QUEUE4_CONTEXT_STATUS__RPTR_WB_IDLE_MASK                                                        0x00000800L
#define SDMA1_QUEUE4_CONTEXT_STATUS__WPTR_UPDATE_PENDING_MASK                                                 0x00001000L
#define SDMA1_QUEUE4_CONTEXT_STATUS__WPTR_UPDATE_FAIL_COUNT_MASK                                              0x00FF0000L
//SDMA1_QUEUE5_RB_CNTL
#define SDMA1_QUEUE5_RB_CNTL__RB_ENABLE__SHIFT                                                                0x0
#define SDMA1_QUEUE5_RB_CNTL__RB_SIZE__SHIFT                                                                  0x1
#define SDMA1_QUEUE5_RB_CNTL__WPTR_POLL_ENABLE__SHIFT                                                         0x8
#define SDMA1_QUEUE5_RB_CNTL__RB_SWAP_ENABLE__SHIFT                                                           0x9
#define SDMA1_QUEUE5_RB_CNTL__WPTR_POLL_SWAP_ENABLE__SHIFT                                                    0xa
#define SDMA1_QUEUE5_RB_CNTL__MCU_WPTR_POLL_ENABLE__SHIFT                                                     0xb
#define SDMA1_QUEUE5_RB_CNTL__RPTR_WRITEBACK_ENABLE__SHIFT                                                    0xc
#define SDMA1_QUEUE5_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE__SHIFT                                               0xd
#define SDMA1_QUEUE5_RB_CNTL__RPTR_WRITEBACK_TIMER__SHIFT                                                     0x10
#define SDMA1_QUEUE5_RB_CNTL__RB_PRIV__SHIFT                                                                  0x17
#define SDMA1_QUEUE5_RB_CNTL__RB_VMID__SHIFT                                                                  0x18
#define SDMA1_QUEUE5_RB_CNTL__RB_ENABLE_MASK                                                                  0x00000001L
#define SDMA1_QUEUE5_RB_CNTL__RB_SIZE_MASK                                                                    0x0000003EL
#define SDMA1_QUEUE5_RB_CNTL__WPTR_POLL_ENABLE_MASK                                                           0x00000100L
#define SDMA1_QUEUE5_RB_CNTL__RB_SWAP_ENABLE_MASK                                                             0x00000200L
#define SDMA1_QUEUE5_RB_CNTL__WPTR_POLL_SWAP_ENABLE_MASK                                                      0x00000400L
#define SDMA1_QUEUE5_RB_CNTL__MCU_WPTR_POLL_ENABLE_MASK                                                       0x00000800L
#define SDMA1_QUEUE5_RB_CNTL__RPTR_WRITEBACK_ENABLE_MASK                                                      0x00001000L
#define SDMA1_QUEUE5_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE_MASK                                                 0x00002000L
#define SDMA1_QUEUE5_RB_CNTL__RPTR_WRITEBACK_TIMER_MASK                                                       0x001F0000L
#define SDMA1_QUEUE5_RB_CNTL__RB_PRIV_MASK                                                                    0x00800000L
#define SDMA1_QUEUE5_RB_CNTL__RB_VMID_MASK                                                                    0x0F000000L
//SDMA1_QUEUE5_RB_BASE
#define SDMA1_QUEUE5_RB_BASE__ADDR__SHIFT                                                                     0x0
#define SDMA1_QUEUE5_RB_BASE__ADDR_MASK                                                                       0xFFFFFFFFL
//SDMA1_QUEUE5_RB_BASE_HI
#define SDMA1_QUEUE5_RB_BASE_HI__ADDR__SHIFT                                                                  0x0
#define SDMA1_QUEUE5_RB_BASE_HI__ADDR_MASK                                                                    0x00FFFFFFL
//SDMA1_QUEUE5_RB_RPTR
#define SDMA1_QUEUE5_RB_RPTR__OFFSET__SHIFT                                                                   0x0
#define SDMA1_QUEUE5_RB_RPTR__OFFSET_MASK                                                                     0xFFFFFFFFL
//SDMA1_QUEUE5_RB_RPTR_HI
#define SDMA1_QUEUE5_RB_RPTR_HI__OFFSET__SHIFT                                                                0x0
#define SDMA1_QUEUE5_RB_RPTR_HI__OFFSET_MASK                                                                  0xFFFFFFFFL
//SDMA1_QUEUE5_RB_WPTR
#define SDMA1_QUEUE5_RB_WPTR__OFFSET__SHIFT                                                                   0x0
#define SDMA1_QUEUE5_RB_WPTR__OFFSET_MASK                                                                     0xFFFFFFFFL
//SDMA1_QUEUE5_RB_WPTR_HI
#define SDMA1_QUEUE5_RB_WPTR_HI__OFFSET__SHIFT                                                                0x0
#define SDMA1_QUEUE5_RB_WPTR_HI__OFFSET_MASK                                                                  0xFFFFFFFFL
//SDMA1_QUEUE5_RB_RPTR_ADDR_LO
#define SDMA1_QUEUE5_RB_RPTR_ADDR_LO__ADDR__SHIFT                                                             0x2
#define SDMA1_QUEUE5_RB_RPTR_ADDR_LO__ADDR_MASK                                                               0xFFFFFFFCL
//SDMA1_QUEUE5_RB_RPTR_ADDR_HI
#define SDMA1_QUEUE5_RB_RPTR_ADDR_HI__ADDR__SHIFT                                                             0x0
#define SDMA1_QUEUE5_RB_RPTR_ADDR_HI__ADDR_MASK                                                               0xFFFFFFFFL
//SDMA1_QUEUE5_IB_CNTL
#define SDMA1_QUEUE5_IB_CNTL__IB_ENABLE__SHIFT                                                                0x0
#define SDMA1_QUEUE5_IB_CNTL__IB_SWAP_ENABLE__SHIFT                                                           0x4
#define SDMA1_QUEUE5_IB_CNTL__SWITCH_INSIDE_IB__SHIFT                                                         0x8
#define SDMA1_QUEUE5_IB_CNTL__CMD_VMID__SHIFT                                                                 0x10
#define SDMA1_QUEUE5_IB_CNTL__IB_ENABLE_MASK                                                                  0x00000001L
#define SDMA1_QUEUE5_IB_CNTL__IB_SWAP_ENABLE_MASK                                                             0x00000010L
#define SDMA1_QUEUE5_IB_CNTL__SWITCH_INSIDE_IB_MASK                                                           0x00000100L
#define SDMA1_QUEUE5_IB_CNTL__CMD_VMID_MASK                                                                   0x000F0000L
//SDMA1_QUEUE5_IB_RPTR
#define SDMA1_QUEUE5_IB_RPTR__OFFSET__SHIFT                                                                   0x2
#define SDMA1_QUEUE5_IB_RPTR__OFFSET_MASK                                                                     0x003FFFFCL
//SDMA1_QUEUE5_IB_OFFSET
#define SDMA1_QUEUE5_IB_OFFSET__OFFSET__SHIFT                                                                 0x2
#define SDMA1_QUEUE5_IB_OFFSET__OFFSET_MASK                                                                   0x003FFFFCL
//SDMA1_QUEUE5_IB_BASE_LO
#define SDMA1_QUEUE5_IB_BASE_LO__ADDR__SHIFT                                                                  0x2
#define SDMA1_QUEUE5_IB_BASE_LO__ADDR_MASK                                                                    0xFFFFFFFCL
//SDMA1_QUEUE5_IB_BASE_HI
#define SDMA1_QUEUE5_IB_BASE_HI__ADDR__SHIFT                                                                  0x0
#define SDMA1_QUEUE5_IB_BASE_HI__ADDR_MASK                                                                    0xFFFFFFFFL
//SDMA1_QUEUE5_IB_SIZE
#define SDMA1_QUEUE5_IB_SIZE__SIZE__SHIFT                                                                     0x0
#define SDMA1_QUEUE5_IB_SIZE__SIZE_MASK                                                                       0x000FFFFFL
//SDMA1_QUEUE5_DOORBELL
#define SDMA1_QUEUE5_DOORBELL__ENABLE__SHIFT                                                                  0x1c
#define SDMA1_QUEUE5_DOORBELL__CAPTURED__SHIFT                                                                0x1e
#define SDMA1_QUEUE5_DOORBELL__ENABLE_MASK                                                                    0x10000000L
#define SDMA1_QUEUE5_DOORBELL__CAPTURED_MASK                                                                  0x40000000L
//SDMA1_QUEUE5_DOORBELL_LOG
#define SDMA1_QUEUE5_DOORBELL_LOG__BE_ERROR__SHIFT                                                            0x0
#define SDMA1_QUEUE5_DOORBELL_LOG__DATA__SHIFT                                                                0x2
#define SDMA1_QUEUE5_DOORBELL_LOG__BE_ERROR_MASK                                                              0x00000001L
#define SDMA1_QUEUE5_DOORBELL_LOG__DATA_MASK                                                                  0xFFFFFFFCL
//SDMA1_QUEUE5_DOORBELL_OFFSET
#define SDMA1_QUEUE5_DOORBELL_OFFSET__OFFSET__SHIFT                                                           0x2
#define SDMA1_QUEUE5_DOORBELL_OFFSET__OFFSET_MASK                                                             0x0FFFFFFCL
//SDMA1_QUEUE5_CSA_ADDR_LO
#define SDMA1_QUEUE5_CSA_ADDR_LO__ADDR__SHIFT                                                                 0x2
#define SDMA1_QUEUE5_CSA_ADDR_LO__ADDR_MASK                                                                   0xFFFFFFFCL
//SDMA1_QUEUE5_CSA_ADDR_HI
#define SDMA1_QUEUE5_CSA_ADDR_HI__ADDR__SHIFT                                                                 0x0
#define SDMA1_QUEUE5_CSA_ADDR_HI__ADDR_MASK                                                                   0xFFFFFFFFL
//SDMA1_QUEUE5_SCHEDULE_CNTL
#define SDMA1_QUEUE5_SCHEDULE_CNTL__GLOBAL_ID__SHIFT                                                          0x0
#define SDMA1_QUEUE5_SCHEDULE_CNTL__PROCESS_ID__SHIFT                                                         0x2
#define SDMA1_QUEUE5_SCHEDULE_CNTL__LOCAL_ID__SHIFT                                                           0x6
#define SDMA1_QUEUE5_SCHEDULE_CNTL__CONTEXT_QUANTUM__SHIFT                                                    0x8
#define SDMA1_QUEUE5_SCHEDULE_CNTL__GLOBAL_ID_MASK                                                            0x00000003L
#define SDMA1_QUEUE5_SCHEDULE_CNTL__PROCESS_ID_MASK                                                           0x0000001CL
#define SDMA1_QUEUE5_SCHEDULE_CNTL__LOCAL_ID_MASK                                                             0x000000C0L
#define SDMA1_QUEUE5_SCHEDULE_CNTL__CONTEXT_QUANTUM_MASK                                                      0x0000FF00L
//SDMA1_QUEUE5_IB_SUB_REMAIN
#define SDMA1_QUEUE5_IB_SUB_REMAIN__SIZE__SHIFT                                                               0x0
#define SDMA1_QUEUE5_IB_SUB_REMAIN__SIZE_MASK                                                                 0x00003FFFL
//SDMA1_QUEUE5_PREEMPT
#define SDMA1_QUEUE5_PREEMPT__IB_PREEMPT__SHIFT                                                               0x0
#define SDMA1_QUEUE5_PREEMPT__IB_PREEMPT_MASK                                                                 0x00000001L
//SDMA1_QUEUE5_DUMMY_REG
#define SDMA1_QUEUE5_DUMMY_REG__DUMMY__SHIFT                                                                  0x0
#define SDMA1_QUEUE5_DUMMY_REG__DUMMY_MASK                                                                    0xFFFFFFFFL
//SDMA1_QUEUE5_RB_WPTR_POLL_ADDR_LO
#define SDMA1_QUEUE5_RB_WPTR_POLL_ADDR_LO__ADDR__SHIFT                                                        0x2
#define SDMA1_QUEUE5_RB_WPTR_POLL_ADDR_LO__ADDR_MASK                                                          0xFFFFFFFCL
//SDMA1_QUEUE5_RB_WPTR_POLL_ADDR_HI
#define SDMA1_QUEUE5_RB_WPTR_POLL_ADDR_HI__ADDR__SHIFT                                                        0x0
#define SDMA1_QUEUE5_RB_WPTR_POLL_ADDR_HI__ADDR_MASK                                                          0xFFFFFFFFL
//SDMA1_QUEUE5_RB_AQL_CNTL
#define SDMA1_QUEUE5_RB_AQL_CNTL__AQL_ENABLE__SHIFT                                                           0x0
#define SDMA1_QUEUE5_RB_AQL_CNTL__AQL_PACKET_SIZE__SHIFT                                                      0x1
#define SDMA1_QUEUE5_RB_AQL_CNTL__PACKET_STEP__SHIFT                                                          0x8
#define SDMA1_QUEUE5_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE__SHIFT                                                0x10
#define SDMA1_QUEUE5_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE__SHIFT                                          0x11
#define SDMA1_QUEUE5_RB_AQL_CNTL__OVERLAP_ENABLE__SHIFT                                                       0x12
#define SDMA1_QUEUE5_RB_AQL_CNTL__AQL_ENABLE_MASK                                                             0x00000001L
#define SDMA1_QUEUE5_RB_AQL_CNTL__AQL_PACKET_SIZE_MASK                                                        0x000000FEL
#define SDMA1_QUEUE5_RB_AQL_CNTL__PACKET_STEP_MASK                                                            0x0000FF00L
#define SDMA1_QUEUE5_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE_MASK                                                  0x00010000L
#define SDMA1_QUEUE5_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE_MASK                                            0x00020000L
#define SDMA1_QUEUE5_RB_AQL_CNTL__OVERLAP_ENABLE_MASK                                                         0x00040000L
//SDMA1_QUEUE5_MINOR_PTR_UPDATE
#define SDMA1_QUEUE5_MINOR_PTR_UPDATE__ENABLE__SHIFT                                                          0x0
#define SDMA1_QUEUE5_MINOR_PTR_UPDATE__ENABLE_MASK                                                            0x00000001L
//SDMA1_QUEUE5_CONTEXT_SWITCH_STATUS
#define SDMA1_QUEUE5_CONTEXT_SWITCH_STATUS__RB_PREEMPT_STATUS__SHIFT                                          0x0
#define SDMA1_QUEUE5_CONTEXT_SWITCH_STATUS__VM_HOLE_EXCEPTION__SHIFT                                          0x1
#define SDMA1_QUEUE5_CONTEXT_SWITCH_STATUS__PAGE_EXCEPTION__SHIFT                                             0x2
#define SDMA1_QUEUE5_CONTEXT_SWITCH_STATUS__QUEUE_HANG_EXCEPTION__SHIFT                                       0x5
#define SDMA1_QUEUE5_CONTEXT_SWITCH_STATUS__DOORBELL_ERROR_EXCEPTION__SHIFT                                   0x6
#define SDMA1_QUEUE5_CONTEXT_SWITCH_STATUS__SRAM_ECC_EXCEPTION__SHIFT                                         0x7
#define SDMA1_QUEUE5_CONTEXT_SWITCH_STATUS__DRAM_ECC_EXCEPTION__SHIFT                                         0x8
#define SDMA1_QUEUE5_CONTEXT_SWITCH_STATUS__WPTR_LT_RPTR_EXCEPTION__SHIFT                                     0x9
#define SDMA1_QUEUE5_CONTEXT_SWITCH_STATUS__RB_PREEMPT_STATUS_MASK                                            0x00000001L
#define SDMA1_QUEUE5_CONTEXT_SWITCH_STATUS__VM_HOLE_EXCEPTION_MASK                                            0x00000002L
#define SDMA1_QUEUE5_CONTEXT_SWITCH_STATUS__PAGE_EXCEPTION_MASK                                               0x00000004L
#define SDMA1_QUEUE5_CONTEXT_SWITCH_STATUS__QUEUE_HANG_EXCEPTION_MASK                                         0x00000020L
#define SDMA1_QUEUE5_CONTEXT_SWITCH_STATUS__DOORBELL_ERROR_EXCEPTION_MASK                                     0x00000040L
#define SDMA1_QUEUE5_CONTEXT_SWITCH_STATUS__SRAM_ECC_EXCEPTION_MASK                                           0x00000080L
#define SDMA1_QUEUE5_CONTEXT_SWITCH_STATUS__DRAM_ECC_EXCEPTION_MASK                                           0x00000100L
#define SDMA1_QUEUE5_CONTEXT_SWITCH_STATUS__WPTR_LT_RPTR_EXCEPTION_MASK                                       0x00000200L
//SDMA1_QUEUE5_MIDCMD_CNTL
#define SDMA1_QUEUE5_MIDCMD_CNTL__DATA_VALID__SHIFT                                                           0x0
#define SDMA1_QUEUE5_MIDCMD_CNTL__COPY_MODE__SHIFT                                                            0x1
#define SDMA1_QUEUE5_MIDCMD_CNTL__SPLIT_STATE__SHIFT                                                          0x4
#define SDMA1_QUEUE5_MIDCMD_CNTL__ALLOW_PREEMPT__SHIFT                                                        0x8
#define SDMA1_QUEUE5_MIDCMD_CNTL__DATA_VALID_MASK                                                             0x00000001L
#define SDMA1_QUEUE5_MIDCMD_CNTL__COPY_MODE_MASK                                                              0x00000002L
#define SDMA1_QUEUE5_MIDCMD_CNTL__SPLIT_STATE_MASK                                                            0x000000F0L
#define SDMA1_QUEUE5_MIDCMD_CNTL__ALLOW_PREEMPT_MASK                                                          0x00000100L
//SDMA1_QUEUE5_MIDCMD_DATA0
#define SDMA1_QUEUE5_MIDCMD_DATA0__DATA0__SHIFT                                                               0x0
#define SDMA1_QUEUE5_MIDCMD_DATA0__DATA0_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE5_MIDCMD_DATA1
#define SDMA1_QUEUE5_MIDCMD_DATA1__DATA1__SHIFT                                                               0x0
#define SDMA1_QUEUE5_MIDCMD_DATA1__DATA1_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE5_MIDCMD_DATA2
#define SDMA1_QUEUE5_MIDCMD_DATA2__DATA2__SHIFT                                                               0x0
#define SDMA1_QUEUE5_MIDCMD_DATA2__DATA2_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE5_MIDCMD_DATA3
#define SDMA1_QUEUE5_MIDCMD_DATA3__DATA3__SHIFT                                                               0x0
#define SDMA1_QUEUE5_MIDCMD_DATA3__DATA3_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE5_MIDCMD_DATA4
#define SDMA1_QUEUE5_MIDCMD_DATA4__DATA4__SHIFT                                                               0x0
#define SDMA1_QUEUE5_MIDCMD_DATA4__DATA4_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE5_MIDCMD_DATA5
#define SDMA1_QUEUE5_MIDCMD_DATA5__DATA5__SHIFT                                                               0x0
#define SDMA1_QUEUE5_MIDCMD_DATA5__DATA5_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE5_MIDCMD_DATA6
#define SDMA1_QUEUE5_MIDCMD_DATA6__DATA6__SHIFT                                                               0x0
#define SDMA1_QUEUE5_MIDCMD_DATA6__DATA6_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE5_MIDCMD_DATA7
#define SDMA1_QUEUE5_MIDCMD_DATA7__DATA7__SHIFT                                                               0x0
#define SDMA1_QUEUE5_MIDCMD_DATA7__DATA7_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE5_MIDCMD_DATA8
#define SDMA1_QUEUE5_MIDCMD_DATA8__DATA8__SHIFT                                                               0x0
#define SDMA1_QUEUE5_MIDCMD_DATA8__DATA8_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE5_MIDCMD_DATA9
#define SDMA1_QUEUE5_MIDCMD_DATA9__DATA9__SHIFT                                                               0x0
#define SDMA1_QUEUE5_MIDCMD_DATA9__DATA9_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE5_MIDCMD_DATA10
#define SDMA1_QUEUE5_MIDCMD_DATA10__DATA10__SHIFT                                                             0x0
#define SDMA1_QUEUE5_MIDCMD_DATA10__DATA10_MASK                                                               0xFFFFFFFFL
//SDMA1_QUEUE5_WAIT_UNSATISFIED_THD
#define SDMA1_QUEUE5_WAIT_UNSATISFIED_THD__THRESHOLD__SHIFT                                                   0x0
#define SDMA1_QUEUE5_WAIT_UNSATISFIED_THD__THRESHOLD_MASK                                                     0x0000001FL
//SDMA1_QUEUE5_MQD_BASE_ADDR_LO
#define SDMA1_QUEUE5_MQD_BASE_ADDR_LO__BASE_ADDR_LO__SHIFT                                                    0x2
#define SDMA1_QUEUE5_MQD_BASE_ADDR_LO__BASE_ADDR_LO_MASK                                                      0xFFFFFFFCL
//SDMA1_QUEUE5_MQD_BASE_ADDR_HI
#define SDMA1_QUEUE5_MQD_BASE_ADDR_HI__BASE_ADDR_HI__SHIFT                                                    0x0
#define SDMA1_QUEUE5_MQD_BASE_ADDR_HI__BASE_ADDR_HI_MASK                                                      0xFFFFFFFFL
//SDMA1_QUEUE5_MQD_CONTROL
#define SDMA1_QUEUE5_MQD_CONTROL__VMID__SHIFT                                                                 0x0
#define SDMA1_QUEUE5_MQD_CONTROL__VMID_MASK                                                                   0x0000000FL
//SDMA1_QUEUE5_DEQUEUE_REQUEST
#define SDMA1_QUEUE5_DEQUEUE_REQUEST__DEQUEUE_REQ__SHIFT                                                      0x0
#define SDMA1_QUEUE5_DEQUEUE_REQUEST__DEQUEUE_REQ_MASK                                                        0x00000001L
//SDMA1_QUEUE5_CONTEXT_STATUS
#define SDMA1_QUEUE5_CONTEXT_STATUS__SELECTED__SHIFT                                                          0x0
#define SDMA1_QUEUE5_CONTEXT_STATUS__USE_IB__SHIFT                                                            0x1
#define SDMA1_QUEUE5_CONTEXT_STATUS__IDLE__SHIFT                                                              0x2
#define SDMA1_QUEUE5_CONTEXT_STATUS__EXPIRED__SHIFT                                                           0x3
#define SDMA1_QUEUE5_CONTEXT_STATUS__EXCEPTION__SHIFT                                                         0x4
#define SDMA1_QUEUE5_CONTEXT_STATUS__CTXSW_ABLE__SHIFT                                                        0x7
#define SDMA1_QUEUE5_CONTEXT_STATUS__VF_STATUS__SHIFT                                                         0x8
#define SDMA1_QUEUE5_CONTEXT_STATUS__PRIV_EXCEPTION__SHIFT                                                    0x9
#define SDMA1_QUEUE5_CONTEXT_STATUS__PREEMPT_DISABLE__SHIFT                                                   0xa
#define SDMA1_QUEUE5_CONTEXT_STATUS__RPTR_WB_IDLE__SHIFT                                                      0xb
#define SDMA1_QUEUE5_CONTEXT_STATUS__WPTR_UPDATE_PENDING__SHIFT                                               0xc
#define SDMA1_QUEUE5_CONTEXT_STATUS__WPTR_UPDATE_FAIL_COUNT__SHIFT                                            0x10
#define SDMA1_QUEUE5_CONTEXT_STATUS__SELECTED_MASK                                                            0x00000001L
#define SDMA1_QUEUE5_CONTEXT_STATUS__USE_IB_MASK                                                              0x00000002L
#define SDMA1_QUEUE5_CONTEXT_STATUS__IDLE_MASK                                                                0x00000004L
#define SDMA1_QUEUE5_CONTEXT_STATUS__EXPIRED_MASK                                                             0x00000008L
#define SDMA1_QUEUE5_CONTEXT_STATUS__EXCEPTION_MASK                                                           0x00000070L
#define SDMA1_QUEUE5_CONTEXT_STATUS__CTXSW_ABLE_MASK                                                          0x00000080L
#define SDMA1_QUEUE5_CONTEXT_STATUS__VF_STATUS_MASK                                                           0x00000100L
#define SDMA1_QUEUE5_CONTEXT_STATUS__PRIV_EXCEPTION_MASK                                                      0x00000200L
#define SDMA1_QUEUE5_CONTEXT_STATUS__PREEMPT_DISABLE_MASK                                                     0x00000400L
#define SDMA1_QUEUE5_CONTEXT_STATUS__RPTR_WB_IDLE_MASK                                                        0x00000800L
#define SDMA1_QUEUE5_CONTEXT_STATUS__WPTR_UPDATE_PENDING_MASK                                                 0x00001000L
#define SDMA1_QUEUE5_CONTEXT_STATUS__WPTR_UPDATE_FAIL_COUNT_MASK                                              0x00FF0000L
//SDMA1_QUEUE6_RB_CNTL
#define SDMA1_QUEUE6_RB_CNTL__RB_ENABLE__SHIFT                                                                0x0
#define SDMA1_QUEUE6_RB_CNTL__RB_SIZE__SHIFT                                                                  0x1
#define SDMA1_QUEUE6_RB_CNTL__WPTR_POLL_ENABLE__SHIFT                                                         0x8
#define SDMA1_QUEUE6_RB_CNTL__RB_SWAP_ENABLE__SHIFT                                                           0x9
#define SDMA1_QUEUE6_RB_CNTL__WPTR_POLL_SWAP_ENABLE__SHIFT                                                    0xa
#define SDMA1_QUEUE6_RB_CNTL__MCU_WPTR_POLL_ENABLE__SHIFT                                                     0xb
#define SDMA1_QUEUE6_RB_CNTL__RPTR_WRITEBACK_ENABLE__SHIFT                                                    0xc
#define SDMA1_QUEUE6_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE__SHIFT                                               0xd
#define SDMA1_QUEUE6_RB_CNTL__RPTR_WRITEBACK_TIMER__SHIFT                                                     0x10
#define SDMA1_QUEUE6_RB_CNTL__RB_PRIV__SHIFT                                                                  0x17
#define SDMA1_QUEUE6_RB_CNTL__RB_VMID__SHIFT                                                                  0x18
#define SDMA1_QUEUE6_RB_CNTL__RB_ENABLE_MASK                                                                  0x00000001L
#define SDMA1_QUEUE6_RB_CNTL__RB_SIZE_MASK                                                                    0x0000003EL
#define SDMA1_QUEUE6_RB_CNTL__WPTR_POLL_ENABLE_MASK                                                           0x00000100L
#define SDMA1_QUEUE6_RB_CNTL__RB_SWAP_ENABLE_MASK                                                             0x00000200L
#define SDMA1_QUEUE6_RB_CNTL__WPTR_POLL_SWAP_ENABLE_MASK                                                      0x00000400L
#define SDMA1_QUEUE6_RB_CNTL__MCU_WPTR_POLL_ENABLE_MASK                                                       0x00000800L
#define SDMA1_QUEUE6_RB_CNTL__RPTR_WRITEBACK_ENABLE_MASK                                                      0x00001000L
#define SDMA1_QUEUE6_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE_MASK                                                 0x00002000L
#define SDMA1_QUEUE6_RB_CNTL__RPTR_WRITEBACK_TIMER_MASK                                                       0x001F0000L
#define SDMA1_QUEUE6_RB_CNTL__RB_PRIV_MASK                                                                    0x00800000L
#define SDMA1_QUEUE6_RB_CNTL__RB_VMID_MASK                                                                    0x0F000000L
//SDMA1_QUEUE6_RB_BASE
#define SDMA1_QUEUE6_RB_BASE__ADDR__SHIFT                                                                     0x0
#define SDMA1_QUEUE6_RB_BASE__ADDR_MASK                                                                       0xFFFFFFFFL
//SDMA1_QUEUE6_RB_BASE_HI
#define SDMA1_QUEUE6_RB_BASE_HI__ADDR__SHIFT                                                                  0x0
#define SDMA1_QUEUE6_RB_BASE_HI__ADDR_MASK                                                                    0x00FFFFFFL
//SDMA1_QUEUE6_RB_RPTR
#define SDMA1_QUEUE6_RB_RPTR__OFFSET__SHIFT                                                                   0x0
#define SDMA1_QUEUE6_RB_RPTR__OFFSET_MASK                                                                     0xFFFFFFFFL
//SDMA1_QUEUE6_RB_RPTR_HI
#define SDMA1_QUEUE6_RB_RPTR_HI__OFFSET__SHIFT                                                                0x0
#define SDMA1_QUEUE6_RB_RPTR_HI__OFFSET_MASK                                                                  0xFFFFFFFFL
//SDMA1_QUEUE6_RB_WPTR
#define SDMA1_QUEUE6_RB_WPTR__OFFSET__SHIFT                                                                   0x0
#define SDMA1_QUEUE6_RB_WPTR__OFFSET_MASK                                                                     0xFFFFFFFFL
//SDMA1_QUEUE6_RB_WPTR_HI
#define SDMA1_QUEUE6_RB_WPTR_HI__OFFSET__SHIFT                                                                0x0
#define SDMA1_QUEUE6_RB_WPTR_HI__OFFSET_MASK                                                                  0xFFFFFFFFL
//SDMA1_QUEUE6_RB_RPTR_ADDR_LO
#define SDMA1_QUEUE6_RB_RPTR_ADDR_LO__ADDR__SHIFT                                                             0x2
#define SDMA1_QUEUE6_RB_RPTR_ADDR_LO__ADDR_MASK                                                               0xFFFFFFFCL
//SDMA1_QUEUE6_RB_RPTR_ADDR_HI
#define SDMA1_QUEUE6_RB_RPTR_ADDR_HI__ADDR__SHIFT                                                             0x0
#define SDMA1_QUEUE6_RB_RPTR_ADDR_HI__ADDR_MASK                                                               0xFFFFFFFFL
//SDMA1_QUEUE6_IB_CNTL
#define SDMA1_QUEUE6_IB_CNTL__IB_ENABLE__SHIFT                                                                0x0
#define SDMA1_QUEUE6_IB_CNTL__IB_SWAP_ENABLE__SHIFT                                                           0x4
#define SDMA1_QUEUE6_IB_CNTL__SWITCH_INSIDE_IB__SHIFT                                                         0x8
#define SDMA1_QUEUE6_IB_CNTL__CMD_VMID__SHIFT                                                                 0x10
#define SDMA1_QUEUE6_IB_CNTL__IB_ENABLE_MASK                                                                  0x00000001L
#define SDMA1_QUEUE6_IB_CNTL__IB_SWAP_ENABLE_MASK                                                             0x00000010L
#define SDMA1_QUEUE6_IB_CNTL__SWITCH_INSIDE_IB_MASK                                                           0x00000100L
#define SDMA1_QUEUE6_IB_CNTL__CMD_VMID_MASK                                                                   0x000F0000L
//SDMA1_QUEUE6_IB_RPTR
#define SDMA1_QUEUE6_IB_RPTR__OFFSET__SHIFT                                                                   0x2
#define SDMA1_QUEUE6_IB_RPTR__OFFSET_MASK                                                                     0x003FFFFCL
//SDMA1_QUEUE6_IB_OFFSET
#define SDMA1_QUEUE6_IB_OFFSET__OFFSET__SHIFT                                                                 0x2
#define SDMA1_QUEUE6_IB_OFFSET__OFFSET_MASK                                                                   0x003FFFFCL
//SDMA1_QUEUE6_IB_BASE_LO
#define SDMA1_QUEUE6_IB_BASE_LO__ADDR__SHIFT                                                                  0x2
#define SDMA1_QUEUE6_IB_BASE_LO__ADDR_MASK                                                                    0xFFFFFFFCL
//SDMA1_QUEUE6_IB_BASE_HI
#define SDMA1_QUEUE6_IB_BASE_HI__ADDR__SHIFT                                                                  0x0
#define SDMA1_QUEUE6_IB_BASE_HI__ADDR_MASK                                                                    0xFFFFFFFFL
//SDMA1_QUEUE6_IB_SIZE
#define SDMA1_QUEUE6_IB_SIZE__SIZE__SHIFT                                                                     0x0
#define SDMA1_QUEUE6_IB_SIZE__SIZE_MASK                                                                       0x000FFFFFL
//SDMA1_QUEUE6_DOORBELL
#define SDMA1_QUEUE6_DOORBELL__ENABLE__SHIFT                                                                  0x1c
#define SDMA1_QUEUE6_DOORBELL__CAPTURED__SHIFT                                                                0x1e
#define SDMA1_QUEUE6_DOORBELL__ENABLE_MASK                                                                    0x10000000L
#define SDMA1_QUEUE6_DOORBELL__CAPTURED_MASK                                                                  0x40000000L
//SDMA1_QUEUE6_DOORBELL_LOG
#define SDMA1_QUEUE6_DOORBELL_LOG__BE_ERROR__SHIFT                                                            0x0
#define SDMA1_QUEUE6_DOORBELL_LOG__DATA__SHIFT                                                                0x2
#define SDMA1_QUEUE6_DOORBELL_LOG__BE_ERROR_MASK                                                              0x00000001L
#define SDMA1_QUEUE6_DOORBELL_LOG__DATA_MASK                                                                  0xFFFFFFFCL
//SDMA1_QUEUE6_DOORBELL_OFFSET
#define SDMA1_QUEUE6_DOORBELL_OFFSET__OFFSET__SHIFT                                                           0x2
#define SDMA1_QUEUE6_DOORBELL_OFFSET__OFFSET_MASK                                                             0x0FFFFFFCL
//SDMA1_QUEUE6_CSA_ADDR_LO
#define SDMA1_QUEUE6_CSA_ADDR_LO__ADDR__SHIFT                                                                 0x2
#define SDMA1_QUEUE6_CSA_ADDR_LO__ADDR_MASK                                                                   0xFFFFFFFCL
//SDMA1_QUEUE6_CSA_ADDR_HI
#define SDMA1_QUEUE6_CSA_ADDR_HI__ADDR__SHIFT                                                                 0x0
#define SDMA1_QUEUE6_CSA_ADDR_HI__ADDR_MASK                                                                   0xFFFFFFFFL
//SDMA1_QUEUE6_SCHEDULE_CNTL
#define SDMA1_QUEUE6_SCHEDULE_CNTL__GLOBAL_ID__SHIFT                                                          0x0
#define SDMA1_QUEUE6_SCHEDULE_CNTL__PROCESS_ID__SHIFT                                                         0x2
#define SDMA1_QUEUE6_SCHEDULE_CNTL__LOCAL_ID__SHIFT                                                           0x6
#define SDMA1_QUEUE6_SCHEDULE_CNTL__CONTEXT_QUANTUM__SHIFT                                                    0x8
#define SDMA1_QUEUE6_SCHEDULE_CNTL__GLOBAL_ID_MASK                                                            0x00000003L
#define SDMA1_QUEUE6_SCHEDULE_CNTL__PROCESS_ID_MASK                                                           0x0000001CL
#define SDMA1_QUEUE6_SCHEDULE_CNTL__LOCAL_ID_MASK                                                             0x000000C0L
#define SDMA1_QUEUE6_SCHEDULE_CNTL__CONTEXT_QUANTUM_MASK                                                      0x0000FF00L
//SDMA1_QUEUE6_IB_SUB_REMAIN
#define SDMA1_QUEUE6_IB_SUB_REMAIN__SIZE__SHIFT                                                               0x0
#define SDMA1_QUEUE6_IB_SUB_REMAIN__SIZE_MASK                                                                 0x00003FFFL
//SDMA1_QUEUE6_PREEMPT
#define SDMA1_QUEUE6_PREEMPT__IB_PREEMPT__SHIFT                                                               0x0
#define SDMA1_QUEUE6_PREEMPT__IB_PREEMPT_MASK                                                                 0x00000001L
//SDMA1_QUEUE6_DUMMY_REG
#define SDMA1_QUEUE6_DUMMY_REG__DUMMY__SHIFT                                                                  0x0
#define SDMA1_QUEUE6_DUMMY_REG__DUMMY_MASK                                                                    0xFFFFFFFFL
//SDMA1_QUEUE6_RB_WPTR_POLL_ADDR_LO
#define SDMA1_QUEUE6_RB_WPTR_POLL_ADDR_LO__ADDR__SHIFT                                                        0x2
#define SDMA1_QUEUE6_RB_WPTR_POLL_ADDR_LO__ADDR_MASK                                                          0xFFFFFFFCL
//SDMA1_QUEUE6_RB_WPTR_POLL_ADDR_HI
#define SDMA1_QUEUE6_RB_WPTR_POLL_ADDR_HI__ADDR__SHIFT                                                        0x0
#define SDMA1_QUEUE6_RB_WPTR_POLL_ADDR_HI__ADDR_MASK                                                          0xFFFFFFFFL
//SDMA1_QUEUE6_RB_AQL_CNTL
#define SDMA1_QUEUE6_RB_AQL_CNTL__AQL_ENABLE__SHIFT                                                           0x0
#define SDMA1_QUEUE6_RB_AQL_CNTL__AQL_PACKET_SIZE__SHIFT                                                      0x1
#define SDMA1_QUEUE6_RB_AQL_CNTL__PACKET_STEP__SHIFT                                                          0x8
#define SDMA1_QUEUE6_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE__SHIFT                                                0x10
#define SDMA1_QUEUE6_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE__SHIFT                                          0x11
#define SDMA1_QUEUE6_RB_AQL_CNTL__OVERLAP_ENABLE__SHIFT                                                       0x12
#define SDMA1_QUEUE6_RB_AQL_CNTL__AQL_ENABLE_MASK                                                             0x00000001L
#define SDMA1_QUEUE6_RB_AQL_CNTL__AQL_PACKET_SIZE_MASK                                                        0x000000FEL
#define SDMA1_QUEUE6_RB_AQL_CNTL__PACKET_STEP_MASK                                                            0x0000FF00L
#define SDMA1_QUEUE6_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE_MASK                                                  0x00010000L
#define SDMA1_QUEUE6_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE_MASK                                            0x00020000L
#define SDMA1_QUEUE6_RB_AQL_CNTL__OVERLAP_ENABLE_MASK                                                         0x00040000L
//SDMA1_QUEUE6_MINOR_PTR_UPDATE
#define SDMA1_QUEUE6_MINOR_PTR_UPDATE__ENABLE__SHIFT                                                          0x0
#define SDMA1_QUEUE6_MINOR_PTR_UPDATE__ENABLE_MASK                                                            0x00000001L
//SDMA1_QUEUE6_CONTEXT_SWITCH_STATUS
#define SDMA1_QUEUE6_CONTEXT_SWITCH_STATUS__RB_PREEMPT_STATUS__SHIFT                                          0x0
#define SDMA1_QUEUE6_CONTEXT_SWITCH_STATUS__VM_HOLE_EXCEPTION__SHIFT                                          0x1
#define SDMA1_QUEUE6_CONTEXT_SWITCH_STATUS__PAGE_EXCEPTION__SHIFT                                             0x2
#define SDMA1_QUEUE6_CONTEXT_SWITCH_STATUS__QUEUE_HANG_EXCEPTION__SHIFT                                       0x5
#define SDMA1_QUEUE6_CONTEXT_SWITCH_STATUS__DOORBELL_ERROR_EXCEPTION__SHIFT                                   0x6
#define SDMA1_QUEUE6_CONTEXT_SWITCH_STATUS__SRAM_ECC_EXCEPTION__SHIFT                                         0x7
#define SDMA1_QUEUE6_CONTEXT_SWITCH_STATUS__DRAM_ECC_EXCEPTION__SHIFT                                         0x8
#define SDMA1_QUEUE6_CONTEXT_SWITCH_STATUS__WPTR_LT_RPTR_EXCEPTION__SHIFT                                     0x9
#define SDMA1_QUEUE6_CONTEXT_SWITCH_STATUS__RB_PREEMPT_STATUS_MASK                                            0x00000001L
#define SDMA1_QUEUE6_CONTEXT_SWITCH_STATUS__VM_HOLE_EXCEPTION_MASK                                            0x00000002L
#define SDMA1_QUEUE6_CONTEXT_SWITCH_STATUS__PAGE_EXCEPTION_MASK                                               0x00000004L
#define SDMA1_QUEUE6_CONTEXT_SWITCH_STATUS__QUEUE_HANG_EXCEPTION_MASK                                         0x00000020L
#define SDMA1_QUEUE6_CONTEXT_SWITCH_STATUS__DOORBELL_ERROR_EXCEPTION_MASK                                     0x00000040L
#define SDMA1_QUEUE6_CONTEXT_SWITCH_STATUS__SRAM_ECC_EXCEPTION_MASK                                           0x00000080L
#define SDMA1_QUEUE6_CONTEXT_SWITCH_STATUS__DRAM_ECC_EXCEPTION_MASK                                           0x00000100L
#define SDMA1_QUEUE6_CONTEXT_SWITCH_STATUS__WPTR_LT_RPTR_EXCEPTION_MASK                                       0x00000200L
//SDMA1_QUEUE6_MIDCMD_CNTL
#define SDMA1_QUEUE6_MIDCMD_CNTL__DATA_VALID__SHIFT                                                           0x0
#define SDMA1_QUEUE6_MIDCMD_CNTL__COPY_MODE__SHIFT                                                            0x1
#define SDMA1_QUEUE6_MIDCMD_CNTL__SPLIT_STATE__SHIFT                                                          0x4
#define SDMA1_QUEUE6_MIDCMD_CNTL__ALLOW_PREEMPT__SHIFT                                                        0x8
#define SDMA1_QUEUE6_MIDCMD_CNTL__DATA_VALID_MASK                                                             0x00000001L
#define SDMA1_QUEUE6_MIDCMD_CNTL__COPY_MODE_MASK                                                              0x00000002L
#define SDMA1_QUEUE6_MIDCMD_CNTL__SPLIT_STATE_MASK                                                            0x000000F0L
#define SDMA1_QUEUE6_MIDCMD_CNTL__ALLOW_PREEMPT_MASK                                                          0x00000100L
//SDMA1_QUEUE6_MIDCMD_DATA0
#define SDMA1_QUEUE6_MIDCMD_DATA0__DATA0__SHIFT                                                               0x0
#define SDMA1_QUEUE6_MIDCMD_DATA0__DATA0_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE6_MIDCMD_DATA1
#define SDMA1_QUEUE6_MIDCMD_DATA1__DATA1__SHIFT                                                               0x0
#define SDMA1_QUEUE6_MIDCMD_DATA1__DATA1_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE6_MIDCMD_DATA2
#define SDMA1_QUEUE6_MIDCMD_DATA2__DATA2__SHIFT                                                               0x0
#define SDMA1_QUEUE6_MIDCMD_DATA2__DATA2_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE6_MIDCMD_DATA3
#define SDMA1_QUEUE6_MIDCMD_DATA3__DATA3__SHIFT                                                               0x0
#define SDMA1_QUEUE6_MIDCMD_DATA3__DATA3_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE6_MIDCMD_DATA4
#define SDMA1_QUEUE6_MIDCMD_DATA4__DATA4__SHIFT                                                               0x0
#define SDMA1_QUEUE6_MIDCMD_DATA4__DATA4_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE6_MIDCMD_DATA5
#define SDMA1_QUEUE6_MIDCMD_DATA5__DATA5__SHIFT                                                               0x0
#define SDMA1_QUEUE6_MIDCMD_DATA5__DATA5_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE6_MIDCMD_DATA6
#define SDMA1_QUEUE6_MIDCMD_DATA6__DATA6__SHIFT                                                               0x0
#define SDMA1_QUEUE6_MIDCMD_DATA6__DATA6_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE6_MIDCMD_DATA7
#define SDMA1_QUEUE6_MIDCMD_DATA7__DATA7__SHIFT                                                               0x0
#define SDMA1_QUEUE6_MIDCMD_DATA7__DATA7_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE6_MIDCMD_DATA8
#define SDMA1_QUEUE6_MIDCMD_DATA8__DATA8__SHIFT                                                               0x0
#define SDMA1_QUEUE6_MIDCMD_DATA8__DATA8_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE6_MIDCMD_DATA9
#define SDMA1_QUEUE6_MIDCMD_DATA9__DATA9__SHIFT                                                               0x0
#define SDMA1_QUEUE6_MIDCMD_DATA9__DATA9_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE6_MIDCMD_DATA10
#define SDMA1_QUEUE6_MIDCMD_DATA10__DATA10__SHIFT                                                             0x0
#define SDMA1_QUEUE6_MIDCMD_DATA10__DATA10_MASK                                                               0xFFFFFFFFL
//SDMA1_QUEUE6_WAIT_UNSATISFIED_THD
#define SDMA1_QUEUE6_WAIT_UNSATISFIED_THD__THRESHOLD__SHIFT                                                   0x0
#define SDMA1_QUEUE6_WAIT_UNSATISFIED_THD__THRESHOLD_MASK                                                     0x0000001FL
//SDMA1_QUEUE6_MQD_BASE_ADDR_LO
#define SDMA1_QUEUE6_MQD_BASE_ADDR_LO__BASE_ADDR_LO__SHIFT                                                    0x2
#define SDMA1_QUEUE6_MQD_BASE_ADDR_LO__BASE_ADDR_LO_MASK                                                      0xFFFFFFFCL
//SDMA1_QUEUE6_MQD_BASE_ADDR_HI
#define SDMA1_QUEUE6_MQD_BASE_ADDR_HI__BASE_ADDR_HI__SHIFT                                                    0x0
#define SDMA1_QUEUE6_MQD_BASE_ADDR_HI__BASE_ADDR_HI_MASK                                                      0xFFFFFFFFL
//SDMA1_QUEUE6_MQD_CONTROL
#define SDMA1_QUEUE6_MQD_CONTROL__VMID__SHIFT                                                                 0x0
#define SDMA1_QUEUE6_MQD_CONTROL__VMID_MASK                                                                   0x0000000FL
//SDMA1_QUEUE6_DEQUEUE_REQUEST
#define SDMA1_QUEUE6_DEQUEUE_REQUEST__DEQUEUE_REQ__SHIFT                                                      0x0
#define SDMA1_QUEUE6_DEQUEUE_REQUEST__DEQUEUE_REQ_MASK                                                        0x00000001L
//SDMA1_QUEUE6_CONTEXT_STATUS
#define SDMA1_QUEUE6_CONTEXT_STATUS__SELECTED__SHIFT                                                          0x0
#define SDMA1_QUEUE6_CONTEXT_STATUS__USE_IB__SHIFT                                                            0x1
#define SDMA1_QUEUE6_CONTEXT_STATUS__IDLE__SHIFT                                                              0x2
#define SDMA1_QUEUE6_CONTEXT_STATUS__EXPIRED__SHIFT                                                           0x3
#define SDMA1_QUEUE6_CONTEXT_STATUS__EXCEPTION__SHIFT                                                         0x4
#define SDMA1_QUEUE6_CONTEXT_STATUS__CTXSW_ABLE__SHIFT                                                        0x7
#define SDMA1_QUEUE6_CONTEXT_STATUS__VF_STATUS__SHIFT                                                         0x8
#define SDMA1_QUEUE6_CONTEXT_STATUS__PRIV_EXCEPTION__SHIFT                                                    0x9
#define SDMA1_QUEUE6_CONTEXT_STATUS__PREEMPT_DISABLE__SHIFT                                                   0xa
#define SDMA1_QUEUE6_CONTEXT_STATUS__RPTR_WB_IDLE__SHIFT                                                      0xb
#define SDMA1_QUEUE6_CONTEXT_STATUS__WPTR_UPDATE_PENDING__SHIFT                                               0xc
#define SDMA1_QUEUE6_CONTEXT_STATUS__WPTR_UPDATE_FAIL_COUNT__SHIFT                                            0x10
#define SDMA1_QUEUE6_CONTEXT_STATUS__SELECTED_MASK                                                            0x00000001L
#define SDMA1_QUEUE6_CONTEXT_STATUS__USE_IB_MASK                                                              0x00000002L
#define SDMA1_QUEUE6_CONTEXT_STATUS__IDLE_MASK                                                                0x00000004L
#define SDMA1_QUEUE6_CONTEXT_STATUS__EXPIRED_MASK                                                             0x00000008L
#define SDMA1_QUEUE6_CONTEXT_STATUS__EXCEPTION_MASK                                                           0x00000070L
#define SDMA1_QUEUE6_CONTEXT_STATUS__CTXSW_ABLE_MASK                                                          0x00000080L
#define SDMA1_QUEUE6_CONTEXT_STATUS__VF_STATUS_MASK                                                           0x00000100L
#define SDMA1_QUEUE6_CONTEXT_STATUS__PRIV_EXCEPTION_MASK                                                      0x00000200L
#define SDMA1_QUEUE6_CONTEXT_STATUS__PREEMPT_DISABLE_MASK                                                     0x00000400L
#define SDMA1_QUEUE6_CONTEXT_STATUS__RPTR_WB_IDLE_MASK                                                        0x00000800L
#define SDMA1_QUEUE6_CONTEXT_STATUS__WPTR_UPDATE_PENDING_MASK                                                 0x00001000L
#define SDMA1_QUEUE6_CONTEXT_STATUS__WPTR_UPDATE_FAIL_COUNT_MASK                                              0x00FF0000L
//SDMA1_QUEUE7_RB_CNTL
#define SDMA1_QUEUE7_RB_CNTL__RB_ENABLE__SHIFT                                                                0x0
#define SDMA1_QUEUE7_RB_CNTL__RB_SIZE__SHIFT                                                                  0x1
#define SDMA1_QUEUE7_RB_CNTL__WPTR_POLL_ENABLE__SHIFT                                                         0x8
#define SDMA1_QUEUE7_RB_CNTL__RB_SWAP_ENABLE__SHIFT                                                           0x9
#define SDMA1_QUEUE7_RB_CNTL__WPTR_POLL_SWAP_ENABLE__SHIFT                                                    0xa
#define SDMA1_QUEUE7_RB_CNTL__MCU_WPTR_POLL_ENABLE__SHIFT                                                     0xb
#define SDMA1_QUEUE7_RB_CNTL__RPTR_WRITEBACK_ENABLE__SHIFT                                                    0xc
#define SDMA1_QUEUE7_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE__SHIFT                                               0xd
#define SDMA1_QUEUE7_RB_CNTL__RPTR_WRITEBACK_TIMER__SHIFT                                                     0x10
#define SDMA1_QUEUE7_RB_CNTL__RB_PRIV__SHIFT                                                                  0x17
#define SDMA1_QUEUE7_RB_CNTL__RB_VMID__SHIFT                                                                  0x18
#define SDMA1_QUEUE7_RB_CNTL__RB_ENABLE_MASK                                                                  0x00000001L
#define SDMA1_QUEUE7_RB_CNTL__RB_SIZE_MASK                                                                    0x0000003EL
#define SDMA1_QUEUE7_RB_CNTL__WPTR_POLL_ENABLE_MASK                                                           0x00000100L
#define SDMA1_QUEUE7_RB_CNTL__RB_SWAP_ENABLE_MASK                                                             0x00000200L
#define SDMA1_QUEUE7_RB_CNTL__WPTR_POLL_SWAP_ENABLE_MASK                                                      0x00000400L
#define SDMA1_QUEUE7_RB_CNTL__MCU_WPTR_POLL_ENABLE_MASK                                                       0x00000800L
#define SDMA1_QUEUE7_RB_CNTL__RPTR_WRITEBACK_ENABLE_MASK                                                      0x00001000L
#define SDMA1_QUEUE7_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE_MASK                                                 0x00002000L
#define SDMA1_QUEUE7_RB_CNTL__RPTR_WRITEBACK_TIMER_MASK                                                       0x001F0000L
#define SDMA1_QUEUE7_RB_CNTL__RB_PRIV_MASK                                                                    0x00800000L
#define SDMA1_QUEUE7_RB_CNTL__RB_VMID_MASK                                                                    0x0F000000L
//SDMA1_QUEUE7_RB_BASE
#define SDMA1_QUEUE7_RB_BASE__ADDR__SHIFT                                                                     0x0
#define SDMA1_QUEUE7_RB_BASE__ADDR_MASK                                                                       0xFFFFFFFFL
//SDMA1_QUEUE7_RB_BASE_HI
#define SDMA1_QUEUE7_RB_BASE_HI__ADDR__SHIFT                                                                  0x0
#define SDMA1_QUEUE7_RB_BASE_HI__ADDR_MASK                                                                    0x00FFFFFFL
//SDMA1_QUEUE7_RB_RPTR
#define SDMA1_QUEUE7_RB_RPTR__OFFSET__SHIFT                                                                   0x0
#define SDMA1_QUEUE7_RB_RPTR__OFFSET_MASK                                                                     0xFFFFFFFFL
//SDMA1_QUEUE7_RB_RPTR_HI
#define SDMA1_QUEUE7_RB_RPTR_HI__OFFSET__SHIFT                                                                0x0
#define SDMA1_QUEUE7_RB_RPTR_HI__OFFSET_MASK                                                                  0xFFFFFFFFL
//SDMA1_QUEUE7_RB_WPTR
#define SDMA1_QUEUE7_RB_WPTR__OFFSET__SHIFT                                                                   0x0
#define SDMA1_QUEUE7_RB_WPTR__OFFSET_MASK                                                                     0xFFFFFFFFL
//SDMA1_QUEUE7_RB_WPTR_HI
#define SDMA1_QUEUE7_RB_WPTR_HI__OFFSET__SHIFT                                                                0x0
#define SDMA1_QUEUE7_RB_WPTR_HI__OFFSET_MASK                                                                  0xFFFFFFFFL
//SDMA1_QUEUE7_RB_RPTR_ADDR_LO
#define SDMA1_QUEUE7_RB_RPTR_ADDR_LO__ADDR__SHIFT                                                             0x2
#define SDMA1_QUEUE7_RB_RPTR_ADDR_LO__ADDR_MASK                                                               0xFFFFFFFCL
//SDMA1_QUEUE7_RB_RPTR_ADDR_HI
#define SDMA1_QUEUE7_RB_RPTR_ADDR_HI__ADDR__SHIFT                                                             0x0
#define SDMA1_QUEUE7_RB_RPTR_ADDR_HI__ADDR_MASK                                                               0xFFFFFFFFL
//SDMA1_QUEUE7_IB_CNTL
#define SDMA1_QUEUE7_IB_CNTL__IB_ENABLE__SHIFT                                                                0x0
#define SDMA1_QUEUE7_IB_CNTL__IB_SWAP_ENABLE__SHIFT                                                           0x4
#define SDMA1_QUEUE7_IB_CNTL__SWITCH_INSIDE_IB__SHIFT                                                         0x8
#define SDMA1_QUEUE7_IB_CNTL__CMD_VMID__SHIFT                                                                 0x10
#define SDMA1_QUEUE7_IB_CNTL__IB_ENABLE_MASK                                                                  0x00000001L
#define SDMA1_QUEUE7_IB_CNTL__IB_SWAP_ENABLE_MASK                                                             0x00000010L
#define SDMA1_QUEUE7_IB_CNTL__SWITCH_INSIDE_IB_MASK                                                           0x00000100L
#define SDMA1_QUEUE7_IB_CNTL__CMD_VMID_MASK                                                                   0x000F0000L
//SDMA1_QUEUE7_IB_RPTR
#define SDMA1_QUEUE7_IB_RPTR__OFFSET__SHIFT                                                                   0x2
#define SDMA1_QUEUE7_IB_RPTR__OFFSET_MASK                                                                     0x003FFFFCL
//SDMA1_QUEUE7_IB_OFFSET
#define SDMA1_QUEUE7_IB_OFFSET__OFFSET__SHIFT                                                                 0x2
#define SDMA1_QUEUE7_IB_OFFSET__OFFSET_MASK                                                                   0x003FFFFCL
//SDMA1_QUEUE7_IB_BASE_LO
#define SDMA1_QUEUE7_IB_BASE_LO__ADDR__SHIFT                                                                  0x2
#define SDMA1_QUEUE7_IB_BASE_LO__ADDR_MASK                                                                    0xFFFFFFFCL
//SDMA1_QUEUE7_IB_BASE_HI
#define SDMA1_QUEUE7_IB_BASE_HI__ADDR__SHIFT                                                                  0x0
#define SDMA1_QUEUE7_IB_BASE_HI__ADDR_MASK                                                                    0xFFFFFFFFL
//SDMA1_QUEUE7_IB_SIZE
#define SDMA1_QUEUE7_IB_SIZE__SIZE__SHIFT                                                                     0x0
#define SDMA1_QUEUE7_IB_SIZE__SIZE_MASK                                                                       0x000FFFFFL
//SDMA1_QUEUE7_DOORBELL
#define SDMA1_QUEUE7_DOORBELL__ENABLE__SHIFT                                                                  0x1c
#define SDMA1_QUEUE7_DOORBELL__CAPTURED__SHIFT                                                                0x1e
#define SDMA1_QUEUE7_DOORBELL__ENABLE_MASK                                                                    0x10000000L
#define SDMA1_QUEUE7_DOORBELL__CAPTURED_MASK                                                                  0x40000000L
//SDMA1_QUEUE7_DOORBELL_LOG
#define SDMA1_QUEUE7_DOORBELL_LOG__BE_ERROR__SHIFT                                                            0x0
#define SDMA1_QUEUE7_DOORBELL_LOG__DATA__SHIFT                                                                0x2
#define SDMA1_QUEUE7_DOORBELL_LOG__BE_ERROR_MASK                                                              0x00000001L
#define SDMA1_QUEUE7_DOORBELL_LOG__DATA_MASK                                                                  0xFFFFFFFCL
//SDMA1_QUEUE7_DOORBELL_OFFSET
#define SDMA1_QUEUE7_DOORBELL_OFFSET__OFFSET__SHIFT                                                           0x2
#define SDMA1_QUEUE7_DOORBELL_OFFSET__OFFSET_MASK                                                             0x0FFFFFFCL
//SDMA1_QUEUE7_CSA_ADDR_LO
#define SDMA1_QUEUE7_CSA_ADDR_LO__ADDR__SHIFT                                                                 0x2
#define SDMA1_QUEUE7_CSA_ADDR_LO__ADDR_MASK                                                                   0xFFFFFFFCL
//SDMA1_QUEUE7_CSA_ADDR_HI
#define SDMA1_QUEUE7_CSA_ADDR_HI__ADDR__SHIFT                                                                 0x0
#define SDMA1_QUEUE7_CSA_ADDR_HI__ADDR_MASK                                                                   0xFFFFFFFFL
//SDMA1_QUEUE7_SCHEDULE_CNTL
#define SDMA1_QUEUE7_SCHEDULE_CNTL__GLOBAL_ID__SHIFT                                                          0x0
#define SDMA1_QUEUE7_SCHEDULE_CNTL__PROCESS_ID__SHIFT                                                         0x2
#define SDMA1_QUEUE7_SCHEDULE_CNTL__LOCAL_ID__SHIFT                                                           0x6
#define SDMA1_QUEUE7_SCHEDULE_CNTL__CONTEXT_QUANTUM__SHIFT                                                    0x8
#define SDMA1_QUEUE7_SCHEDULE_CNTL__GLOBAL_ID_MASK                                                            0x00000003L
#define SDMA1_QUEUE7_SCHEDULE_CNTL__PROCESS_ID_MASK                                                           0x0000001CL
#define SDMA1_QUEUE7_SCHEDULE_CNTL__LOCAL_ID_MASK                                                             0x000000C0L
#define SDMA1_QUEUE7_SCHEDULE_CNTL__CONTEXT_QUANTUM_MASK                                                      0x0000FF00L
//SDMA1_QUEUE7_IB_SUB_REMAIN
#define SDMA1_QUEUE7_IB_SUB_REMAIN__SIZE__SHIFT                                                               0x0
#define SDMA1_QUEUE7_IB_SUB_REMAIN__SIZE_MASK                                                                 0x00003FFFL
//SDMA1_QUEUE7_PREEMPT
#define SDMA1_QUEUE7_PREEMPT__IB_PREEMPT__SHIFT                                                               0x0
#define SDMA1_QUEUE7_PREEMPT__IB_PREEMPT_MASK                                                                 0x00000001L
//SDMA1_QUEUE7_DUMMY_REG
#define SDMA1_QUEUE7_DUMMY_REG__DUMMY__SHIFT                                                                  0x0
#define SDMA1_QUEUE7_DUMMY_REG__DUMMY_MASK                                                                    0xFFFFFFFFL
//SDMA1_QUEUE7_RB_WPTR_POLL_ADDR_LO
#define SDMA1_QUEUE7_RB_WPTR_POLL_ADDR_LO__ADDR__SHIFT                                                        0x2
#define SDMA1_QUEUE7_RB_WPTR_POLL_ADDR_LO__ADDR_MASK                                                          0xFFFFFFFCL
//SDMA1_QUEUE7_RB_WPTR_POLL_ADDR_HI
#define SDMA1_QUEUE7_RB_WPTR_POLL_ADDR_HI__ADDR__SHIFT                                                        0x0
#define SDMA1_QUEUE7_RB_WPTR_POLL_ADDR_HI__ADDR_MASK                                                          0xFFFFFFFFL
//SDMA1_QUEUE7_RB_AQL_CNTL
#define SDMA1_QUEUE7_RB_AQL_CNTL__AQL_ENABLE__SHIFT                                                           0x0
#define SDMA1_QUEUE7_RB_AQL_CNTL__AQL_PACKET_SIZE__SHIFT                                                      0x1
#define SDMA1_QUEUE7_RB_AQL_CNTL__PACKET_STEP__SHIFT                                                          0x8
#define SDMA1_QUEUE7_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE__SHIFT                                                0x10
#define SDMA1_QUEUE7_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE__SHIFT                                          0x11
#define SDMA1_QUEUE7_RB_AQL_CNTL__OVERLAP_ENABLE__SHIFT                                                       0x12
#define SDMA1_QUEUE7_RB_AQL_CNTL__AQL_ENABLE_MASK                                                             0x00000001L
#define SDMA1_QUEUE7_RB_AQL_CNTL__AQL_PACKET_SIZE_MASK                                                        0x000000FEL
#define SDMA1_QUEUE7_RB_AQL_CNTL__PACKET_STEP_MASK                                                            0x0000FF00L
#define SDMA1_QUEUE7_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE_MASK                                                  0x00010000L
#define SDMA1_QUEUE7_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE_MASK                                            0x00020000L
#define SDMA1_QUEUE7_RB_AQL_CNTL__OVERLAP_ENABLE_MASK                                                         0x00040000L
//SDMA1_QUEUE7_MINOR_PTR_UPDATE
#define SDMA1_QUEUE7_MINOR_PTR_UPDATE__ENABLE__SHIFT                                                          0x0
#define SDMA1_QUEUE7_MINOR_PTR_UPDATE__ENABLE_MASK                                                            0x00000001L
//SDMA1_QUEUE7_CONTEXT_SWITCH_STATUS
#define SDMA1_QUEUE7_CONTEXT_SWITCH_STATUS__RB_PREEMPT_STATUS__SHIFT                                          0x0
#define SDMA1_QUEUE7_CONTEXT_SWITCH_STATUS__VM_HOLE_EXCEPTION__SHIFT                                          0x1
#define SDMA1_QUEUE7_CONTEXT_SWITCH_STATUS__PAGE_EXCEPTION__SHIFT                                             0x2
#define SDMA1_QUEUE7_CONTEXT_SWITCH_STATUS__QUEUE_HANG_EXCEPTION__SHIFT                                       0x5
#define SDMA1_QUEUE7_CONTEXT_SWITCH_STATUS__DOORBELL_ERROR_EXCEPTION__SHIFT                                   0x6
#define SDMA1_QUEUE7_CONTEXT_SWITCH_STATUS__SRAM_ECC_EXCEPTION__SHIFT                                         0x7
#define SDMA1_QUEUE7_CONTEXT_SWITCH_STATUS__DRAM_ECC_EXCEPTION__SHIFT                                         0x8
#define SDMA1_QUEUE7_CONTEXT_SWITCH_STATUS__WPTR_LT_RPTR_EXCEPTION__SHIFT                                     0x9
#define SDMA1_QUEUE7_CONTEXT_SWITCH_STATUS__RB_PREEMPT_STATUS_MASK                                            0x00000001L
#define SDMA1_QUEUE7_CONTEXT_SWITCH_STATUS__VM_HOLE_EXCEPTION_MASK                                            0x00000002L
#define SDMA1_QUEUE7_CONTEXT_SWITCH_STATUS__PAGE_EXCEPTION_MASK                                               0x00000004L
#define SDMA1_QUEUE7_CONTEXT_SWITCH_STATUS__QUEUE_HANG_EXCEPTION_MASK                                         0x00000020L
#define SDMA1_QUEUE7_CONTEXT_SWITCH_STATUS__DOORBELL_ERROR_EXCEPTION_MASK                                     0x00000040L
#define SDMA1_QUEUE7_CONTEXT_SWITCH_STATUS__SRAM_ECC_EXCEPTION_MASK                                           0x00000080L
#define SDMA1_QUEUE7_CONTEXT_SWITCH_STATUS__DRAM_ECC_EXCEPTION_MASK                                           0x00000100L
#define SDMA1_QUEUE7_CONTEXT_SWITCH_STATUS__WPTR_LT_RPTR_EXCEPTION_MASK                                       0x00000200L
//SDMA1_QUEUE7_MIDCMD_CNTL
#define SDMA1_QUEUE7_MIDCMD_CNTL__DATA_VALID__SHIFT                                                           0x0
#define SDMA1_QUEUE7_MIDCMD_CNTL__COPY_MODE__SHIFT                                                            0x1
#define SDMA1_QUEUE7_MIDCMD_CNTL__SPLIT_STATE__SHIFT                                                          0x4
#define SDMA1_QUEUE7_MIDCMD_CNTL__ALLOW_PREEMPT__SHIFT                                                        0x8
#define SDMA1_QUEUE7_MIDCMD_CNTL__DATA_VALID_MASK                                                             0x00000001L
#define SDMA1_QUEUE7_MIDCMD_CNTL__COPY_MODE_MASK                                                              0x00000002L
#define SDMA1_QUEUE7_MIDCMD_CNTL__SPLIT_STATE_MASK                                                            0x000000F0L
#define SDMA1_QUEUE7_MIDCMD_CNTL__ALLOW_PREEMPT_MASK                                                          0x00000100L
//SDMA1_QUEUE7_MIDCMD_DATA0
#define SDMA1_QUEUE7_MIDCMD_DATA0__DATA0__SHIFT                                                               0x0
#define SDMA1_QUEUE7_MIDCMD_DATA0__DATA0_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE7_MIDCMD_DATA1
#define SDMA1_QUEUE7_MIDCMD_DATA1__DATA1__SHIFT                                                               0x0
#define SDMA1_QUEUE7_MIDCMD_DATA1__DATA1_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE7_MIDCMD_DATA2
#define SDMA1_QUEUE7_MIDCMD_DATA2__DATA2__SHIFT                                                               0x0
#define SDMA1_QUEUE7_MIDCMD_DATA2__DATA2_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE7_MIDCMD_DATA3
#define SDMA1_QUEUE7_MIDCMD_DATA3__DATA3__SHIFT                                                               0x0
#define SDMA1_QUEUE7_MIDCMD_DATA3__DATA3_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE7_MIDCMD_DATA4
#define SDMA1_QUEUE7_MIDCMD_DATA4__DATA4__SHIFT                                                               0x0
#define SDMA1_QUEUE7_MIDCMD_DATA4__DATA4_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE7_MIDCMD_DATA5
#define SDMA1_QUEUE7_MIDCMD_DATA5__DATA5__SHIFT                                                               0x0
#define SDMA1_QUEUE7_MIDCMD_DATA5__DATA5_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE7_MIDCMD_DATA6
#define SDMA1_QUEUE7_MIDCMD_DATA6__DATA6__SHIFT                                                               0x0
#define SDMA1_QUEUE7_MIDCMD_DATA6__DATA6_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE7_MIDCMD_DATA7
#define SDMA1_QUEUE7_MIDCMD_DATA7__DATA7__SHIFT                                                               0x0
#define SDMA1_QUEUE7_MIDCMD_DATA7__DATA7_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE7_MIDCMD_DATA8
#define SDMA1_QUEUE7_MIDCMD_DATA8__DATA8__SHIFT                                                               0x0
#define SDMA1_QUEUE7_MIDCMD_DATA8__DATA8_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE7_MIDCMD_DATA9
#define SDMA1_QUEUE7_MIDCMD_DATA9__DATA9__SHIFT                                                               0x0
#define SDMA1_QUEUE7_MIDCMD_DATA9__DATA9_MASK                                                                 0xFFFFFFFFL
//SDMA1_QUEUE7_MIDCMD_DATA10
#define SDMA1_QUEUE7_MIDCMD_DATA10__DATA10__SHIFT                                                             0x0
#define SDMA1_QUEUE7_MIDCMD_DATA10__DATA10_MASK                                                               0xFFFFFFFFL
//SDMA1_QUEUE7_WAIT_UNSATISFIED_THD
#define SDMA1_QUEUE7_WAIT_UNSATISFIED_THD__THRESHOLD__SHIFT                                                   0x0
#define SDMA1_QUEUE7_WAIT_UNSATISFIED_THD__THRESHOLD_MASK                                                     0x0000001FL
//SDMA1_QUEUE7_MQD_BASE_ADDR_LO
#define SDMA1_QUEUE7_MQD_BASE_ADDR_LO__BASE_ADDR_LO__SHIFT                                                    0x2
#define SDMA1_QUEUE7_MQD_BASE_ADDR_LO__BASE_ADDR_LO_MASK                                                      0xFFFFFFFCL
//SDMA1_QUEUE7_MQD_BASE_ADDR_HI
#define SDMA1_QUEUE7_MQD_BASE_ADDR_HI__BASE_ADDR_HI__SHIFT                                                    0x0
#define SDMA1_QUEUE7_MQD_BASE_ADDR_HI__BASE_ADDR_HI_MASK                                                      0xFFFFFFFFL
//SDMA1_QUEUE7_MQD_CONTROL
#define SDMA1_QUEUE7_MQD_CONTROL__VMID__SHIFT                                                                 0x0
#define SDMA1_QUEUE7_MQD_CONTROL__VMID_MASK                                                                   0x0000000FL
//SDMA1_QUEUE7_DEQUEUE_REQUEST
#define SDMA1_QUEUE7_DEQUEUE_REQUEST__DEQUEUE_REQ__SHIFT                                                      0x0
#define SDMA1_QUEUE7_DEQUEUE_REQUEST__DEQUEUE_REQ_MASK                                                        0x00000001L
//SDMA1_QUEUE7_CONTEXT_STATUS
#define SDMA1_QUEUE7_CONTEXT_STATUS__SELECTED__SHIFT                                                          0x0
#define SDMA1_QUEUE7_CONTEXT_STATUS__USE_IB__SHIFT                                                            0x1
#define SDMA1_QUEUE7_CONTEXT_STATUS__IDLE__SHIFT                                                              0x2
#define SDMA1_QUEUE7_CONTEXT_STATUS__EXPIRED__SHIFT                                                           0x3
#define SDMA1_QUEUE7_CONTEXT_STATUS__EXCEPTION__SHIFT                                                         0x4
#define SDMA1_QUEUE7_CONTEXT_STATUS__CTXSW_ABLE__SHIFT                                                        0x7
#define SDMA1_QUEUE7_CONTEXT_STATUS__VF_STATUS__SHIFT                                                         0x8
#define SDMA1_QUEUE7_CONTEXT_STATUS__PRIV_EXCEPTION__SHIFT                                                    0x9
#define SDMA1_QUEUE7_CONTEXT_STATUS__PREEMPT_DISABLE__SHIFT                                                   0xa
#define SDMA1_QUEUE7_CONTEXT_STATUS__RPTR_WB_IDLE__SHIFT                                                      0xb
#define SDMA1_QUEUE7_CONTEXT_STATUS__WPTR_UPDATE_PENDING__SHIFT                                               0xc
#define SDMA1_QUEUE7_CONTEXT_STATUS__WPTR_UPDATE_FAIL_COUNT__SHIFT                                            0x10
#define SDMA1_QUEUE7_CONTEXT_STATUS__SELECTED_MASK                                                            0x00000001L
#define SDMA1_QUEUE7_CONTEXT_STATUS__USE_IB_MASK                                                              0x00000002L
#define SDMA1_QUEUE7_CONTEXT_STATUS__IDLE_MASK                                                                0x00000004L
#define SDMA1_QUEUE7_CONTEXT_STATUS__EXPIRED_MASK                                                             0x00000008L
#define SDMA1_QUEUE7_CONTEXT_STATUS__EXCEPTION_MASK                                                           0x00000070L
#define SDMA1_QUEUE7_CONTEXT_STATUS__CTXSW_ABLE_MASK                                                          0x00000080L
#define SDMA1_QUEUE7_CONTEXT_STATUS__VF_STATUS_MASK                                                           0x00000100L
#define SDMA1_QUEUE7_CONTEXT_STATUS__PRIV_EXCEPTION_MASK                                                      0x00000200L
#define SDMA1_QUEUE7_CONTEXT_STATUS__PREEMPT_DISABLE_MASK                                                     0x00000400L
#define SDMA1_QUEUE7_CONTEXT_STATUS__RPTR_WB_IDLE_MASK                                                        0x00000800L
#define SDMA1_QUEUE7_CONTEXT_STATUS__WPTR_UPDATE_PENDING_MASK                                                 0x00001000L
#define SDMA1_QUEUE7_CONTEXT_STATUS__WPTR_UPDATE_FAIL_COUNT_MASK                                              0x00FF0000L


// addressBlock: gc_gfx_cpwd_sdma0_sdmahypdec:1
//SDMA1_VM_CTX_LO
#define SDMA1_VM_CTX_LO__ADDR__SHIFT                                                                          0x2
#define SDMA1_VM_CTX_LO__ADDR_MASK                                                                            0xFFFFFFFCL
//SDMA1_VM_CTX_HI
#define SDMA1_VM_CTX_HI__ADDR__SHIFT                                                                          0x0
#define SDMA1_VM_CTX_HI__ADDR_MASK                                                                            0xFFFFFFFFL
//SDMA1_ACTIVE_FCN_ID
#define SDMA1_ACTIVE_FCN_ID__VFID__SHIFT                                                                      0x0
#define SDMA1_ACTIVE_FCN_ID__VF__SHIFT                                                                        0x7
#define SDMA1_ACTIVE_FCN_ID__RESERVED__SHIFT                                                                  0x8
#define SDMA1_ACTIVE_FCN_ID__VFID_MASK                                                                        0x0000001FL
#define SDMA1_ACTIVE_FCN_ID__VF_MASK                                                                          0x00000080L
#define SDMA1_ACTIVE_FCN_ID__RESERVED_MASK                                                                    0xFFFFFF00L
//SDMA1_VIRT_RESET_REQ
#define SDMA1_VIRT_RESET_REQ__VF__SHIFT                                                                       0x0
#define SDMA1_VIRT_RESET_REQ__PF__SHIFT                                                                       0x1f
#define SDMA1_VIRT_RESET_REQ__VF_MASK                                                                         0x7FFFFFFFL
#define SDMA1_VIRT_RESET_REQ__PF_MASK                                                                         0x80000000L
//SDMA1_VM_CNTL
#define SDMA1_VM_CNTL__CMD__SHIFT                                                                             0x0
#define SDMA1_VM_CNTL__CMD_MASK                                                                               0x0000000FL
//SDMA1_MCU_CNTL
#define SDMA1_MCU_CNTL__HALT__SHIFT                                                                           0x0
#define SDMA1_MCU_CNTL__RESET__SHIFT                                                                          0x1
#define SDMA1_MCU_CNTL__DBG_SELECT_BITS__SHIFT                                                                0x2
#define SDMA1_MCU_CNTL__HALT_MASK                                                                             0x00000001L
#define SDMA1_MCU_CNTL__RESET_MASK                                                                            0x00000002L
#define SDMA1_MCU_CNTL__DBG_SELECT_BITS_MASK                                                                  0x000000FCL
//SDMA1_IC_BASE_LO
#define SDMA1_IC_BASE_LO__IC_BASE_LO__SHIFT                                                                   0xc
#define SDMA1_IC_BASE_LO__IC_BASE_LO_MASK                                                                     0xFFFFF000L
//SDMA1_IC_BASE_HI
#define SDMA1_IC_BASE_HI__IC_BASE_HI__SHIFT                                                                   0x0
#define SDMA1_IC_BASE_HI__IC_BASE_HI_MASK                                                                     0xFFFFFFFFL
//SDMA1_IC_BASE_CNTL
#define SDMA1_IC_BASE_CNTL__VMID__SHIFT                                                                       0x0
#define SDMA1_IC_BASE_CNTL__EXE_DISABLE__SHIFT                                                                0x17
#define SDMA1_IC_BASE_CNTL__MALL_POLICY__SHIFT                                                                0x18
#define SDMA1_IC_BASE_CNTL__VMID_MASK                                                                         0x0000000FL
#define SDMA1_IC_BASE_CNTL__EXE_DISABLE_MASK                                                                  0x00800000L
#define SDMA1_IC_BASE_CNTL__MALL_POLICY_MASK                                                                  0x03000000L
//SDMA1_IC_OP_CNTL
#define SDMA1_IC_OP_CNTL__INVALIDATE_CACHE__SHIFT                                                             0x0
#define SDMA1_IC_OP_CNTL__PRIME_ICACHE__SHIFT                                                                 0x4
#define SDMA1_IC_OP_CNTL__ICACHE_PRIMED__SHIFT                                                                0x5
#define SDMA1_IC_OP_CNTL__INVALIDATE_CACHE_MASK                                                               0x00000001L
#define SDMA1_IC_OP_CNTL__PRIME_ICACHE_MASK                                                                   0x00000010L
#define SDMA1_IC_OP_CNTL__ICACHE_PRIMED_MASK                                                                  0x00000020L
//SDMA1_IC_CNTL
#define SDMA1_IC_CNTL__CID_SEL__SHIFT                                                                         0x0
#define SDMA1_IC_CNTL__GPA__SHIFT                                                                             0x2
#define SDMA1_IC_CNTL__UCODE_VF_OVERRIDE__SHIFT                                                               0x4
#define SDMA1_IC_CNTL__AUTO_PRIME_ICACHE__SHIFT                                                               0x5
#define SDMA1_IC_CNTL__CID_SEL_MASK                                                                           0x00000001L
#define SDMA1_IC_CNTL__GPA_MASK                                                                               0x0000000CL
#define SDMA1_IC_CNTL__UCODE_VF_OVERRIDE_MASK                                                                 0x00000010L
#define SDMA1_IC_CNTL__AUTO_PRIME_ICACHE_MASK                                                                 0x00000020L


// addressBlock: gc_gfx_cpwd_sdma0_sdmapspdec:1
//SDMA1_MCU_DM_FROM_RST_ADDR_OFFSET
#define SDMA1_MCU_DM_FROM_RST_ADDR_OFFSET__DATA__SHIFT                                                        0x0
#define SDMA1_MCU_DM_FROM_RST_ADDR_OFFSET__DATA_MASK                                                          0xFFFFFFFFL


// addressBlock: gc_gfx_cpwd_sdma0_sdmaperfsdec:1
//SDMA1_PERFCNT_PERFCOUNTER0_CFG
#define SDMA1_PERFCNT_PERFCOUNTER0_CFG__PERF_SEL__SHIFT                                                       0x0
#define SDMA1_PERFCNT_PERFCOUNTER0_CFG__PERF_SEL_END__SHIFT                                                   0x8
#define SDMA1_PERFCNT_PERFCOUNTER0_CFG__PERF_MODE__SHIFT                                                      0x18
#define SDMA1_PERFCNT_PERFCOUNTER0_CFG__ENABLE__SHIFT                                                         0x1c
#define SDMA1_PERFCNT_PERFCOUNTER0_CFG__CLEAR__SHIFT                                                          0x1d
#define SDMA1_PERFCNT_PERFCOUNTER0_CFG__PERF_SEL_MASK                                                         0x000000FFL
#define SDMA1_PERFCNT_PERFCOUNTER0_CFG__PERF_SEL_END_MASK                                                     0x0000FF00L
#define SDMA1_PERFCNT_PERFCOUNTER0_CFG__PERF_MODE_MASK                                                        0x0F000000L
#define SDMA1_PERFCNT_PERFCOUNTER0_CFG__ENABLE_MASK                                                           0x10000000L
#define SDMA1_PERFCNT_PERFCOUNTER0_CFG__CLEAR_MASK                                                            0x20000000L
//SDMA1_PERFCNT_PERFCOUNTER1_CFG
#define SDMA1_PERFCNT_PERFCOUNTER1_CFG__PERF_SEL__SHIFT                                                       0x0
#define SDMA1_PERFCNT_PERFCOUNTER1_CFG__PERF_SEL_END__SHIFT                                                   0x8
#define SDMA1_PERFCNT_PERFCOUNTER1_CFG__PERF_MODE__SHIFT                                                      0x18
#define SDMA1_PERFCNT_PERFCOUNTER1_CFG__ENABLE__SHIFT                                                         0x1c
#define SDMA1_PERFCNT_PERFCOUNTER1_CFG__CLEAR__SHIFT                                                          0x1d
#define SDMA1_PERFCNT_PERFCOUNTER1_CFG__PERF_SEL_MASK                                                         0x000000FFL
#define SDMA1_PERFCNT_PERFCOUNTER1_CFG__PERF_SEL_END_MASK                                                     0x0000FF00L
#define SDMA1_PERFCNT_PERFCOUNTER1_CFG__PERF_MODE_MASK                                                        0x0F000000L
#define SDMA1_PERFCNT_PERFCOUNTER1_CFG__ENABLE_MASK                                                           0x10000000L
#define SDMA1_PERFCNT_PERFCOUNTER1_CFG__CLEAR_MASK                                                            0x20000000L
//SDMA1_PERFCNT_PERFCOUNTER_RSLT_CNTL
#define SDMA1_PERFCNT_PERFCOUNTER_RSLT_CNTL__PERF_COUNTER_SELECT__SHIFT                                       0x0
#define SDMA1_PERFCNT_PERFCOUNTER_RSLT_CNTL__START_TRIGGER__SHIFT                                             0x8
#define SDMA1_PERFCNT_PERFCOUNTER_RSLT_CNTL__STOP_TRIGGER__SHIFT                                              0x10
#define SDMA1_PERFCNT_PERFCOUNTER_RSLT_CNTL__ENABLE_ANY__SHIFT                                                0x18
#define SDMA1_PERFCNT_PERFCOUNTER_RSLT_CNTL__CLEAR_ALL__SHIFT                                                 0x19
#define SDMA1_PERFCNT_PERFCOUNTER_RSLT_CNTL__STOP_ALL_ON_SATURATE__SHIFT                                      0x1a
#define SDMA1_PERFCNT_PERFCOUNTER_RSLT_CNTL__PERF_COUNTER_SELECT_MASK                                         0x0000000FL
#define SDMA1_PERFCNT_PERFCOUNTER_RSLT_CNTL__START_TRIGGER_MASK                                               0x0000FF00L
#define SDMA1_PERFCNT_PERFCOUNTER_RSLT_CNTL__STOP_TRIGGER_MASK                                                0x00FF0000L
#define SDMA1_PERFCNT_PERFCOUNTER_RSLT_CNTL__ENABLE_ANY_MASK                                                  0x01000000L
#define SDMA1_PERFCNT_PERFCOUNTER_RSLT_CNTL__CLEAR_ALL_MASK                                                   0x02000000L
#define SDMA1_PERFCNT_PERFCOUNTER_RSLT_CNTL__STOP_ALL_ON_SATURATE_MASK                                        0x04000000L
//SDMA1_PERFCNT_MISC_CNTL
#define SDMA1_PERFCNT_MISC_CNTL__CMD_OP__SHIFT                                                                0x0
#define SDMA1_PERFCNT_MISC_CNTL__CMD_OP_MASK                                                                  0x0000FFFFL
//SDMA1_PERFCOUNTER0_SELECT
#define SDMA1_PERFCOUNTER0_SELECT__PERF_SEL__SHIFT                                                            0x0
#define SDMA1_PERFCOUNTER0_SELECT__PERF_SEL1__SHIFT                                                           0xa
#define SDMA1_PERFCOUNTER0_SELECT__CNTR_MODE__SHIFT                                                           0x14
#define SDMA1_PERFCOUNTER0_SELECT__PERF_MODE1__SHIFT                                                          0x18
#define SDMA1_PERFCOUNTER0_SELECT__PERF_MODE__SHIFT                                                           0x1c
#define SDMA1_PERFCOUNTER0_SELECT__PERF_SEL_MASK                                                              0x000003FFL
#define SDMA1_PERFCOUNTER0_SELECT__PERF_SEL1_MASK                                                             0x000FFC00L
#define SDMA1_PERFCOUNTER0_SELECT__CNTR_MODE_MASK                                                             0x00F00000L
#define SDMA1_PERFCOUNTER0_SELECT__PERF_MODE1_MASK                                                            0x0F000000L
#define SDMA1_PERFCOUNTER0_SELECT__PERF_MODE_MASK                                                             0xF0000000L
//SDMA1_PERFCOUNTER0_SELECT1
#define SDMA1_PERFCOUNTER0_SELECT1__PERF_SEL2__SHIFT                                                          0x0
#define SDMA1_PERFCOUNTER0_SELECT1__PERF_SEL3__SHIFT                                                          0xa
#define SDMA1_PERFCOUNTER0_SELECT1__PERF_MODE3__SHIFT                                                         0x18
#define SDMA1_PERFCOUNTER0_SELECT1__PERF_MODE2__SHIFT                                                         0x1c
#define SDMA1_PERFCOUNTER0_SELECT1__PERF_SEL2_MASK                                                            0x000003FFL
#define SDMA1_PERFCOUNTER0_SELECT1__PERF_SEL3_MASK                                                            0x000FFC00L
#define SDMA1_PERFCOUNTER0_SELECT1__PERF_MODE3_MASK                                                           0x0F000000L
#define SDMA1_PERFCOUNTER0_SELECT1__PERF_MODE2_MASK                                                           0xF0000000L
//SDMA1_PERFCOUNTER1_SELECT
#define SDMA1_PERFCOUNTER1_SELECT__PERF_SEL__SHIFT                                                            0x0
#define SDMA1_PERFCOUNTER1_SELECT__PERF_SEL1__SHIFT                                                           0xa
#define SDMA1_PERFCOUNTER1_SELECT__CNTR_MODE__SHIFT                                                           0x14
#define SDMA1_PERFCOUNTER1_SELECT__PERF_MODE1__SHIFT                                                          0x18
#define SDMA1_PERFCOUNTER1_SELECT__PERF_MODE__SHIFT                                                           0x1c
#define SDMA1_PERFCOUNTER1_SELECT__PERF_SEL_MASK                                                              0x000003FFL
#define SDMA1_PERFCOUNTER1_SELECT__PERF_SEL1_MASK                                                             0x000FFC00L
#define SDMA1_PERFCOUNTER1_SELECT__CNTR_MODE_MASK                                                             0x00F00000L
#define SDMA1_PERFCOUNTER1_SELECT__PERF_MODE1_MASK                                                            0x0F000000L
#define SDMA1_PERFCOUNTER1_SELECT__PERF_MODE_MASK                                                             0xF0000000L
//SDMA1_PERFCOUNTER1_SELECT1
#define SDMA1_PERFCOUNTER1_SELECT1__PERF_SEL2__SHIFT                                                          0x0
#define SDMA1_PERFCOUNTER1_SELECT1__PERF_SEL3__SHIFT                                                          0xa
#define SDMA1_PERFCOUNTER1_SELECT1__PERF_MODE3__SHIFT                                                         0x18
#define SDMA1_PERFCOUNTER1_SELECT1__PERF_MODE2__SHIFT                                                         0x1c
#define SDMA1_PERFCOUNTER1_SELECT1__PERF_SEL2_MASK                                                            0x000003FFL
#define SDMA1_PERFCOUNTER1_SELECT1__PERF_SEL3_MASK                                                            0x000FFC00L
#define SDMA1_PERFCOUNTER1_SELECT1__PERF_MODE3_MASK                                                           0x0F000000L
#define SDMA1_PERFCOUNTER1_SELECT1__PERF_MODE2_MASK                                                           0xF0000000L


// addressBlock: gc_gfx_cpwd_sdma0_sdmaperfddec:1
//SDMA1_PERFCNT_PERFCOUNTER_LO
#define SDMA1_PERFCNT_PERFCOUNTER_LO__COUNTER_LO__SHIFT                                                       0x0
#define SDMA1_PERFCNT_PERFCOUNTER_LO__COUNTER_LO_MASK                                                         0xFFFFFFFFL
//SDMA1_PERFCNT_PERFCOUNTER_HI
#define SDMA1_PERFCNT_PERFCOUNTER_HI__COUNTER_HI__SHIFT                                                       0x0
#define SDMA1_PERFCNT_PERFCOUNTER_HI__COMPARE_VALUE__SHIFT                                                    0x10
#define SDMA1_PERFCNT_PERFCOUNTER_HI__COUNTER_HI_MASK                                                         0x0000FFFFL
#define SDMA1_PERFCNT_PERFCOUNTER_HI__COMPARE_VALUE_MASK                                                      0xFFFF0000L
//SDMA1_PERFCOUNTER0_LO
#define SDMA1_PERFCOUNTER0_LO__PERFCOUNTER_LO__SHIFT                                                          0x0
#define SDMA1_PERFCOUNTER0_LO__PERFCOUNTER_LO_MASK                                                            0xFFFFFFFFL
//SDMA1_PERFCOUNTER0_HI
#define SDMA1_PERFCOUNTER0_HI__PERFCOUNTER_HI__SHIFT                                                          0x0
#define SDMA1_PERFCOUNTER0_HI__PERFCOUNTER_HI_MASK                                                            0xFFFFFFFFL
//SDMA1_PERFCOUNTER1_LO
#define SDMA1_PERFCOUNTER1_LO__PERFCOUNTER_LO__SHIFT                                                          0x0
#define SDMA1_PERFCOUNTER1_LO__PERFCOUNTER_LO_MASK                                                            0xFFFFFFFFL
//SDMA1_PERFCOUNTER1_HI
#define SDMA1_PERFCOUNTER1_HI__PERFCOUNTER_HI__SHIFT                                                          0x0
#define SDMA1_PERFCOUNTER1_HI__PERFCOUNTER_HI_MASK                                                            0xFFFFFFFFL


// addressBlock: gc_gfx_cpwd_sdma0_sdmapwrdec:1
//GFX_ICG_SDMA1_CTRL
#define GFX_ICG_SDMA1_CTRL__REG_MGCG_CLK_SOFT_OVERRIDE__SHIFT                                                 0x1
#define GFX_ICG_SDMA1_CTRL__PTR_MGCG_CLK_SOFT_OVERRIDE__SHIFT                                                 0x2
#define GFX_ICG_SDMA1_CTRL__PIO_MGCG_CLK_SOFT_OVERRIDE__SHIFT                                                 0x3
#define GFX_ICG_SDMA1_CTRL__MCU_MGCG_CLK_SOFT_OVERRIDE__SHIFT                                                 0x4
#define GFX_ICG_SDMA1_CTRL__COPY_ENG_MGCG_CLK_SOFT_OVERRIDE__SHIFT                                            0x5
#define GFX_ICG_SDMA1_CTRL__SERVE_ENG_MGCG_CLK_SOFT_OVERRIDE__SHIFT                                           0x6
#define GFX_ICG_SDMA1_CTRL__CMD_FETCH_MGCG_CLK_SOFT_OVERRIDE__SHIFT                                           0x7
#define GFX_ICG_SDMA1_CTRL__GU_MEMREQ_MGCG_CLK_SOFT_OVERRIDE__SHIFT                                           0x8
#define GFX_ICG_SDMA1_CTRL__INV_MGCG_CLK_SOFT_OVERRIDE__SHIFT                                                 0x9
#define GFX_ICG_SDMA1_CTRL__GU_CACHE_MGCG_CLK_SOFT_OVERRIDE__SHIFT                                            0xa
#define GFX_ICG_SDMA1_CTRL__IC_CACHE_MGCG_CLK_SOFT_OVERRIDE__SHIFT                                            0xb
#define GFX_ICG_SDMA1_CTRL__MEM_CHNL_MGCG_CLK_SOFT_OVERRIDE__SHIFT                                            0xc
#define GFX_ICG_SDMA1_CTRL__PERF_CNTR_MGCG_CLK_SOFT_OVERRIDE__SHIFT                                           0xd
#define GFX_ICG_SDMA1_CTRL__CORE_MGCG_CLK_SOFT_OVERRIDE__SHIFT                                                0xe
#define GFX_ICG_SDMA1_CTRL__MEM_CHNL_CESE_MGCG_CLK_SOFT_OVERRIDE__SHIFT                                       0xf
#define GFX_ICG_SDMA1_CTRL__MGCG_CLK_HYST__SHIFT                                                              0x10
#define GFX_ICG_SDMA1_CTRL__REG_MGCG_CLK_SOFT_OVERRIDE_MASK                                                   0x00000002L
#define GFX_ICG_SDMA1_CTRL__PTR_MGCG_CLK_SOFT_OVERRIDE_MASK                                                   0x00000004L
#define GFX_ICG_SDMA1_CTRL__PIO_MGCG_CLK_SOFT_OVERRIDE_MASK                                                   0x00000008L
#define GFX_ICG_SDMA1_CTRL__MCU_MGCG_CLK_SOFT_OVERRIDE_MASK                                                   0x00000010L
#define GFX_ICG_SDMA1_CTRL__COPY_ENG_MGCG_CLK_SOFT_OVERRIDE_MASK                                              0x00000020L
#define GFX_ICG_SDMA1_CTRL__SERVE_ENG_MGCG_CLK_SOFT_OVERRIDE_MASK                                             0x00000040L
#define GFX_ICG_SDMA1_CTRL__CMD_FETCH_MGCG_CLK_SOFT_OVERRIDE_MASK                                             0x00000080L
#define GFX_ICG_SDMA1_CTRL__GU_MEMREQ_MGCG_CLK_SOFT_OVERRIDE_MASK                                             0x00000100L
#define GFX_ICG_SDMA1_CTRL__INV_MGCG_CLK_SOFT_OVERRIDE_MASK                                                   0x00000200L
#define GFX_ICG_SDMA1_CTRL__GU_CACHE_MGCG_CLK_SOFT_OVERRIDE_MASK                                              0x00000400L
#define GFX_ICG_SDMA1_CTRL__IC_CACHE_MGCG_CLK_SOFT_OVERRIDE_MASK                                              0x00000800L
#define GFX_ICG_SDMA1_CTRL__MEM_CHNL_MGCG_CLK_SOFT_OVERRIDE_MASK                                              0x00001000L
#define GFX_ICG_SDMA1_CTRL__PERF_CNTR_MGCG_CLK_SOFT_OVERRIDE_MASK                                             0x00002000L
#define GFX_ICG_SDMA1_CTRL__CORE_MGCG_CLK_SOFT_OVERRIDE_MASK                                                  0x00004000L
#define GFX_ICG_SDMA1_CTRL__MEM_CHNL_CESE_MGCG_CLK_SOFT_OVERRIDE_MASK                                         0x00008000L
#define GFX_ICG_SDMA1_CTRL__MGCG_CLK_HYST_MASK                                                                0x00FF0000L


// addressBlock: gc_gfx_cpwd_cpwd_grbmdec
//GRBM_CNTL
#define GRBM_CNTL__READ_TIMEOUT__SHIFT                                                                        0x0
#define GRBM_CNTL__SED_READ_TIMEOUT__SHIFT                                                                    0x10
#define GRBM_CNTL__REPORT_LAST_RDERR__SHIFT                                                                   0x1f
#define GRBM_CNTL__READ_TIMEOUT_MASK                                                                          0x00000FFFL
#define GRBM_CNTL__SED_READ_TIMEOUT_MASK                                                                      0x0FFF0000L
#define GRBM_CNTL__REPORT_LAST_RDERR_MASK                                                                     0x80000000L
//GRBM_SKEW_CNTL
#define GRBM_SKEW_CNTL__SKEW_TOP_THRESHOLD__SHIFT                                                             0x0
#define GRBM_SKEW_CNTL__SKEW_COUNT__SHIFT                                                                     0x6
#define GRBM_SKEW_CNTL__SKEW_TOP_THRESHOLD_MASK                                                               0x0000003FL
#define GRBM_SKEW_CNTL__SKEW_COUNT_MASK                                                                       0x00000FC0L
//GRBM_STATUS2
#define GRBM_STATUS2__ME0PIPE1_CMDFIFO_AVAIL__SHIFT                                                           0x0
#define GRBM_STATUS2__ME0PIPE1_CF_RQ_PENDING__SHIFT                                                           0x4
#define GRBM_STATUS2__ME0PIPE1_PF_RQ_PENDING__SHIFT                                                           0x5
#define GRBM_STATUS2__ME1PIPE0_RQ_PENDING__SHIFT                                                              0x6
#define GRBM_STATUS2__ME1PIPE1_RQ_PENDING__SHIFT                                                              0x7
#define GRBM_STATUS2__RLC_RQ_PENDING__SHIFT                                                                   0xe
#define GRBM_STATUS2__UTCL2_BUSY__SHIFT                                                                       0xf
#define GRBM_STATUS2__EA_BUSY__SHIFT                                                                          0x10
#define GRBM_STATUS2__UTCL2_RQ_PENDING__SHIFT                                                                 0x12
#define GRBM_STATUS2__SDMA_SCH_RQ_PENDING__SHIFT                                                              0x13
#define GRBM_STATUS2__EA_LINK_BUSY__SHIFT                                                                     0x14
#define GRBM_STATUS2__SDMA_BUSY__SHIFT                                                                        0x15
#define GRBM_STATUS2__SDMA0_RQ_PENDING__SHIFT                                                                 0x16
#define GRBM_STATUS2__SDMA1_RQ_PENDING__SHIFT                                                                 0x17
#define GRBM_STATUS2__RLC_BUSY__SHIFT                                                                         0x1a
#define GRBM_STATUS2__TCP_BUSY__SHIFT                                                                         0x1b
#define GRBM_STATUS2__CPF_BUSY__SHIFT                                                                         0x1c
#define GRBM_STATUS2__CPC_BUSY__SHIFT                                                                         0x1d
#define GRBM_STATUS2__CPG_BUSY__SHIFT                                                                         0x1e
#define GRBM_STATUS2__ME0PIPE1_CMDFIFO_AVAIL_MASK                                                             0x0000000FL
#define GRBM_STATUS2__ME0PIPE1_CF_RQ_PENDING_MASK                                                             0x00000010L
#define GRBM_STATUS2__ME0PIPE1_PF_RQ_PENDING_MASK                                                             0x00000020L
#define GRBM_STATUS2__ME1PIPE0_RQ_PENDING_MASK                                                                0x00000040L
#define GRBM_STATUS2__ME1PIPE1_RQ_PENDING_MASK                                                                0x00000080L
#define GRBM_STATUS2__RLC_RQ_PENDING_MASK                                                                     0x00004000L
#define GRBM_STATUS2__UTCL2_BUSY_MASK                                                                         0x00008000L
#define GRBM_STATUS2__EA_BUSY_MASK                                                                            0x00010000L
#define GRBM_STATUS2__UTCL2_RQ_PENDING_MASK                                                                   0x00040000L
#define GRBM_STATUS2__SDMA_SCH_RQ_PENDING_MASK                                                                0x00080000L
#define GRBM_STATUS2__EA_LINK_BUSY_MASK                                                                       0x00100000L
#define GRBM_STATUS2__SDMA_BUSY_MASK                                                                          0x00200000L
#define GRBM_STATUS2__SDMA0_RQ_PENDING_MASK                                                                   0x00400000L
#define GRBM_STATUS2__SDMA1_RQ_PENDING_MASK                                                                   0x00800000L
#define GRBM_STATUS2__RLC_BUSY_MASK                                                                           0x04000000L
#define GRBM_STATUS2__TCP_BUSY_MASK                                                                           0x08000000L
#define GRBM_STATUS2__CPF_BUSY_MASK                                                                           0x10000000L
#define GRBM_STATUS2__CPC_BUSY_MASK                                                                           0x20000000L
#define GRBM_STATUS2__CPG_BUSY_MASK                                                                           0x40000000L
//GRBM_PWR_CNTL
#define GRBM_PWR_CNTL__ALL_REQ_TYPE__SHIFT                                                                    0x0
#define GRBM_PWR_CNTL__GFX_REQ_TYPE__SHIFT                                                                    0x2
#define GRBM_PWR_CNTL__ALL_RSP_TYPE__SHIFT                                                                    0x4
#define GRBM_PWR_CNTL__GFX_RSP_TYPE__SHIFT                                                                    0x6
#define GRBM_PWR_CNTL__GFX_REQ_EN__SHIFT                                                                      0xe
#define GRBM_PWR_CNTL__ALL_REQ_EN__SHIFT                                                                      0xf
#define GRBM_PWR_CNTL__ALL_REQ_TYPE_MASK                                                                      0x00000003L
#define GRBM_PWR_CNTL__GFX_REQ_TYPE_MASK                                                                      0x0000000CL
#define GRBM_PWR_CNTL__ALL_RSP_TYPE_MASK                                                                      0x00000030L
#define GRBM_PWR_CNTL__GFX_RSP_TYPE_MASK                                                                      0x000000C0L
#define GRBM_PWR_CNTL__GFX_REQ_EN_MASK                                                                        0x00004000L
#define GRBM_PWR_CNTL__ALL_REQ_EN_MASK                                                                        0x00008000L
//GRBM_STATUS
#define GRBM_STATUS__ME0PIPE0_CMDFIFO_AVAIL__SHIFT                                                            0x0
#define GRBM_STATUS__SDMA_RQ_PENDING__SHIFT                                                                   0x6
#define GRBM_STATUS__ME0PIPE0_CF_RQ_PENDING__SHIFT                                                            0x7
#define GRBM_STATUS__ME0PIPE0_PF_RQ_PENDING__SHIFT                                                            0x8
#define GRBM_STATUS__SC_CLEAN__SHIFT                                                                          0xb
#define GRBM_STATUS__DB_CLEAN__SHIFT                                                                          0xc
#define GRBM_STATUS__CB_CLEAN__SHIFT                                                                          0xd
#define GRBM_STATUS__TA_BUSY__SHIFT                                                                           0xe
#define GRBM_STATUS__GE_BUSY_NO_DMA__SHIFT                                                                    0x10
#define GRBM_STATUS__SX_BUSY__SHIFT                                                                           0x14
#define GRBM_STATUS__GE_BUSY__SHIFT                                                                           0x15
#define GRBM_STATUS__SPI_BUSY__SHIFT                                                                          0x16
#define GRBM_STATUS__BCI_BUSY__SHIFT                                                                          0x17
#define GRBM_STATUS__SC_BUSY__SHIFT                                                                           0x18
#define GRBM_STATUS__PA_BUSY__SHIFT                                                                           0x19
#define GRBM_STATUS__DB_BUSY__SHIFT                                                                           0x1a
#define GRBM_STATUS__ANY_ACTIVE__SHIFT                                                                        0x1b
#define GRBM_STATUS__CP_COHERENCY_BUSY__SHIFT                                                                 0x1c
#define GRBM_STATUS__CP_BUSY__SHIFT                                                                           0x1d
#define GRBM_STATUS__CB_BUSY__SHIFT                                                                           0x1e
#define GRBM_STATUS__GUI_ACTIVE__SHIFT                                                                        0x1f
#define GRBM_STATUS__ME0PIPE0_CMDFIFO_AVAIL_MASK                                                              0x0000000FL
#define GRBM_STATUS__SDMA_RQ_PENDING_MASK                                                                     0x00000040L
#define GRBM_STATUS__ME0PIPE0_CF_RQ_PENDING_MASK                                                              0x00000080L
#define GRBM_STATUS__ME0PIPE0_PF_RQ_PENDING_MASK                                                              0x00000100L
#define GRBM_STATUS__SC_CLEAN_MASK                                                                            0x00000800L
#define GRBM_STATUS__DB_CLEAN_MASK                                                                            0x00001000L
#define GRBM_STATUS__CB_CLEAN_MASK                                                                            0x00002000L
#define GRBM_STATUS__TA_BUSY_MASK                                                                             0x00004000L
#define GRBM_STATUS__GE_BUSY_NO_DMA_MASK                                                                      0x00010000L
#define GRBM_STATUS__SX_BUSY_MASK                                                                             0x00100000L
#define GRBM_STATUS__GE_BUSY_MASK                                                                             0x00200000L
#define GRBM_STATUS__SPI_BUSY_MASK                                                                            0x00400000L
#define GRBM_STATUS__BCI_BUSY_MASK                                                                            0x00800000L
#define GRBM_STATUS__SC_BUSY_MASK                                                                             0x01000000L
#define GRBM_STATUS__PA_BUSY_MASK                                                                             0x02000000L
#define GRBM_STATUS__DB_BUSY_MASK                                                                             0x04000000L
#define GRBM_STATUS__ANY_ACTIVE_MASK                                                                          0x08000000L
#define GRBM_STATUS__CP_COHERENCY_BUSY_MASK                                                                   0x10000000L
#define GRBM_STATUS__CP_BUSY_MASK                                                                             0x20000000L
#define GRBM_STATUS__CB_BUSY_MASK                                                                             0x40000000L
#define GRBM_STATUS__GUI_ACTIVE_MASK                                                                          0x80000000L
//GRBM_STATUS_SE0
#define GRBM_STATUS_SE0__SC_CLEAN__SHIFT                                                                      0x0
#define GRBM_STATUS_SE0__DB_CLEAN__SHIFT                                                                      0x1
#define GRBM_STATUS_SE0__CB_CLEAN__SHIFT                                                                      0x2
#define GRBM_STATUS_SE0__UTCL1_BUSY__SHIFT                                                                    0x3
#define GRBM_STATUS_SE0__TCP_BUSY__SHIFT                                                                      0x4
#define GRBM_STATUS_SE0__GL1CC_BUSY__SHIFT                                                                    0x5
#define GRBM_STATUS_SE0__GL1XCC_BUSY__SHIFT                                                                   0x6
#define GRBM_STATUS_SE0__PC_BUSY__SHIFT                                                                       0x7
#define GRBM_STATUS_SE0__BCI_BUSY__SHIFT                                                                      0x16
#define GRBM_STATUS_SE0__PA_BUSY__SHIFT                                                                       0x18
#define GRBM_STATUS_SE0__TA_BUSY__SHIFT                                                                       0x19
#define GRBM_STATUS_SE0__SX_BUSY__SHIFT                                                                       0x1a
#define GRBM_STATUS_SE0__SPI_BUSY__SHIFT                                                                      0x1b
#define GRBM_STATUS_SE0__SC_BUSY__SHIFT                                                                       0x1d
#define GRBM_STATUS_SE0__DB_BUSY__SHIFT                                                                       0x1e
#define GRBM_STATUS_SE0__CB_BUSY__SHIFT                                                                       0x1f
#define GRBM_STATUS_SE0__SC_CLEAN_MASK                                                                        0x00000001L
#define GRBM_STATUS_SE0__DB_CLEAN_MASK                                                                        0x00000002L
#define GRBM_STATUS_SE0__CB_CLEAN_MASK                                                                        0x00000004L
#define GRBM_STATUS_SE0__UTCL1_BUSY_MASK                                                                      0x00000008L
#define GRBM_STATUS_SE0__TCP_BUSY_MASK                                                                        0x00000010L
#define GRBM_STATUS_SE0__GL1CC_BUSY_MASK                                                                      0x00000020L
#define GRBM_STATUS_SE0__GL1XCC_BUSY_MASK                                                                     0x00000040L
#define GRBM_STATUS_SE0__PC_BUSY_MASK                                                                         0x00000080L
#define GRBM_STATUS_SE0__BCI_BUSY_MASK                                                                        0x00400000L
#define GRBM_STATUS_SE0__PA_BUSY_MASK                                                                         0x01000000L
#define GRBM_STATUS_SE0__TA_BUSY_MASK                                                                         0x02000000L
#define GRBM_STATUS_SE0__SX_BUSY_MASK                                                                         0x04000000L
#define GRBM_STATUS_SE0__SPI_BUSY_MASK                                                                        0x08000000L
#define GRBM_STATUS_SE0__SC_BUSY_MASK                                                                         0x20000000L
#define GRBM_STATUS_SE0__DB_BUSY_MASK                                                                         0x40000000L
#define GRBM_STATUS_SE0__CB_BUSY_MASK                                                                         0x80000000L
//GRBM_STATUS_SE1
#define GRBM_STATUS_SE1__SC_CLEAN__SHIFT                                                                      0x0
#define GRBM_STATUS_SE1__DB_CLEAN__SHIFT                                                                      0x1
#define GRBM_STATUS_SE1__CB_CLEAN__SHIFT                                                                      0x2
#define GRBM_STATUS_SE1__UTCL1_BUSY__SHIFT                                                                    0x3
#define GRBM_STATUS_SE1__TCP_BUSY__SHIFT                                                                      0x4
#define GRBM_STATUS_SE1__GL1CC_BUSY__SHIFT                                                                    0x5
#define GRBM_STATUS_SE1__GL1XCC_BUSY__SHIFT                                                                   0x6
#define GRBM_STATUS_SE1__PC_BUSY__SHIFT                                                                       0x7
#define GRBM_STATUS_SE1__BCI_BUSY__SHIFT                                                                      0x16
#define GRBM_STATUS_SE1__PA_BUSY__SHIFT                                                                       0x18
#define GRBM_STATUS_SE1__TA_BUSY__SHIFT                                                                       0x19
#define GRBM_STATUS_SE1__SX_BUSY__SHIFT                                                                       0x1a
#define GRBM_STATUS_SE1__SPI_BUSY__SHIFT                                                                      0x1b
#define GRBM_STATUS_SE1__SC_BUSY__SHIFT                                                                       0x1d
#define GRBM_STATUS_SE1__DB_BUSY__SHIFT                                                                       0x1e
#define GRBM_STATUS_SE1__CB_BUSY__SHIFT                                                                       0x1f
#define GRBM_STATUS_SE1__SC_CLEAN_MASK                                                                        0x00000001L
#define GRBM_STATUS_SE1__DB_CLEAN_MASK                                                                        0x00000002L
#define GRBM_STATUS_SE1__CB_CLEAN_MASK                                                                        0x00000004L
#define GRBM_STATUS_SE1__UTCL1_BUSY_MASK                                                                      0x00000008L
#define GRBM_STATUS_SE1__TCP_BUSY_MASK                                                                        0x00000010L
#define GRBM_STATUS_SE1__GL1CC_BUSY_MASK                                                                      0x00000020L
#define GRBM_STATUS_SE1__GL1XCC_BUSY_MASK                                                                     0x00000040L
#define GRBM_STATUS_SE1__PC_BUSY_MASK                                                                         0x00000080L
#define GRBM_STATUS_SE1__BCI_BUSY_MASK                                                                        0x00400000L
#define GRBM_STATUS_SE1__PA_BUSY_MASK                                                                         0x01000000L
#define GRBM_STATUS_SE1__TA_BUSY_MASK                                                                         0x02000000L
#define GRBM_STATUS_SE1__SX_BUSY_MASK                                                                         0x04000000L
#define GRBM_STATUS_SE1__SPI_BUSY_MASK                                                                        0x08000000L
#define GRBM_STATUS_SE1__SC_BUSY_MASK                                                                         0x20000000L
#define GRBM_STATUS_SE1__DB_BUSY_MASK                                                                         0x40000000L
#define GRBM_STATUS_SE1__CB_BUSY_MASK                                                                         0x80000000L
//GRBM_STATUS3
#define GRBM_STATUS3__GRBM_RLC_INTR_CREDIT_PENDING__SHIFT                                                     0x5
#define GRBM_STATUS3__GRBM_CPF_INTR_CREDIT_PENDING__SHIFT                                                     0x7
#define GRBM_STATUS3__MESPIPE0_RQ_PENDING__SHIFT                                                              0x8
#define GRBM_STATUS3__MESPIPE1_RQ_PENDING__SHIFT                                                              0x9
#define GRBM_STATUS3__CH_BUSY__SHIFT                                                                          0xe
#define GRBM_STATUS3__GL2CC_BUSY__SHIFT                                                                       0xf
#define GRBM_STATUS3__GL1CC_BUSY__SHIFT                                                                       0x10
#define GRBM_STATUS3__PC_BUSY__SHIFT                                                                          0x1a
#define GRBM_STATUS3__GL1XCC_BUSY__SHIFT                                                                      0x1b
#define GRBM_STATUS3__UTCL1_BUSY__SHIFT                                                                       0x1e
#define GRBM_STATUS3__PMM_BUSY__SHIFT                                                                         0x1f
#define GRBM_STATUS3__GRBM_RLC_INTR_CREDIT_PENDING_MASK                                                       0x00000020L
#define GRBM_STATUS3__GRBM_CPF_INTR_CREDIT_PENDING_MASK                                                       0x00000080L
#define GRBM_STATUS3__MESPIPE0_RQ_PENDING_MASK                                                                0x00000100L
#define GRBM_STATUS3__MESPIPE1_RQ_PENDING_MASK                                                                0x00000200L
#define GRBM_STATUS3__CH_BUSY_MASK                                                                            0x00004000L
#define GRBM_STATUS3__GL2CC_BUSY_MASK                                                                         0x00008000L
#define GRBM_STATUS3__GL1CC_BUSY_MASK                                                                         0x00010000L
#define GRBM_STATUS3__PC_BUSY_MASK                                                                            0x04000000L
#define GRBM_STATUS3__GL1XCC_BUSY_MASK                                                                        0x08000000L
#define GRBM_STATUS3__UTCL1_BUSY_MASK                                                                         0x40000000L
#define GRBM_STATUS3__PMM_BUSY_MASK                                                                           0x80000000L
//GRBM_SOFT_RESET
#define GRBM_SOFT_RESET__SOFT_RESET_CP__SHIFT                                                                 0x0
#define GRBM_SOFT_RESET__SOFT_RESET_RLC__SHIFT                                                                0x2
#define GRBM_SOFT_RESET__SOFT_RESET_UTCL2__SHIFT                                                              0xf
#define GRBM_SOFT_RESET__SOFT_RESET_GFX__SHIFT                                                                0x10
#define GRBM_SOFT_RESET__SOFT_RESET_CPF__SHIFT                                                                0x11
#define GRBM_SOFT_RESET__SOFT_RESET_CPC__SHIFT                                                                0x12
#define GRBM_SOFT_RESET__SOFT_RESET_CPG__SHIFT                                                                0x13
#define GRBM_SOFT_RESET__SOFT_RESET_CAC__SHIFT                                                                0x14
#define GRBM_SOFT_RESET__SOFT_RESET_EA__SHIFT                                                                 0x16
#define GRBM_SOFT_RESET__SOFT_RESET_SDMA0__SHIFT                                                              0x17
#define GRBM_SOFT_RESET__SOFT_RESET_SDMA1__SHIFT                                                              0x18
#define GRBM_SOFT_RESET__SOFT_RESET_CP_MASK                                                                   0x00000001L
#define GRBM_SOFT_RESET__SOFT_RESET_RLC_MASK                                                                  0x00000004L
#define GRBM_SOFT_RESET__SOFT_RESET_UTCL2_MASK                                                                0x00008000L
#define GRBM_SOFT_RESET__SOFT_RESET_GFX_MASK                                                                  0x00010000L
#define GRBM_SOFT_RESET__SOFT_RESET_CPF_MASK                                                                  0x00020000L
#define GRBM_SOFT_RESET__SOFT_RESET_CPC_MASK                                                                  0x00040000L
#define GRBM_SOFT_RESET__SOFT_RESET_CPG_MASK                                                                  0x00080000L
#define GRBM_SOFT_RESET__SOFT_RESET_CAC_MASK                                                                  0x00100000L
#define GRBM_SOFT_RESET__SOFT_RESET_EA_MASK                                                                   0x00400000L
#define GRBM_SOFT_RESET__SOFT_RESET_SDMA0_MASK                                                                0x00800000L
#define GRBM_SOFT_RESET__SOFT_RESET_SDMA1_MASK                                                                0x01000000L
//GRBM_GFX_CLKEN_CNTL
#define GRBM_GFX_CLKEN_CNTL__PREFIX_DELAY_CNT__SHIFT                                                          0x0
#define GRBM_GFX_CLKEN_CNTL__POST_DELAY_CNT__SHIFT                                                            0x8
#define GRBM_GFX_CLKEN_CNTL__PREFIX_DELAY_CNT_MASK                                                            0x0000000FL
#define GRBM_GFX_CLKEN_CNTL__POST_DELAY_CNT_MASK                                                              0x00001F00L
//GRBM_WAIT_IDLE_CLOCKS
#define GRBM_WAIT_IDLE_CLOCKS__WAIT_IDLE_CLOCKS__SHIFT                                                        0x0
#define GRBM_WAIT_IDLE_CLOCKS__WAIT_IDLE_CLOCKS_MASK                                                          0x000000FFL
//GRBM_STATUS_SE2
#define GRBM_STATUS_SE2__SC_CLEAN__SHIFT                                                                      0x0
#define GRBM_STATUS_SE2__DB_CLEAN__SHIFT                                                                      0x1
#define GRBM_STATUS_SE2__CB_CLEAN__SHIFT                                                                      0x2
#define GRBM_STATUS_SE2__UTCL1_BUSY__SHIFT                                                                    0x3
#define GRBM_STATUS_SE2__TCP_BUSY__SHIFT                                                                      0x4
#define GRBM_STATUS_SE2__GL1CC_BUSY__SHIFT                                                                    0x5
#define GRBM_STATUS_SE2__GL1XCC_BUSY__SHIFT                                                                   0x6
#define GRBM_STATUS_SE2__PC_BUSY__SHIFT                                                                       0x7
#define GRBM_STATUS_SE2__BCI_BUSY__SHIFT                                                                      0x16
#define GRBM_STATUS_SE2__PA_BUSY__SHIFT                                                                       0x18
#define GRBM_STATUS_SE2__TA_BUSY__SHIFT                                                                       0x19
#define GRBM_STATUS_SE2__SX_BUSY__SHIFT                                                                       0x1a
#define GRBM_STATUS_SE2__SPI_BUSY__SHIFT                                                                      0x1b
#define GRBM_STATUS_SE2__SC_BUSY__SHIFT                                                                       0x1d
#define GRBM_STATUS_SE2__DB_BUSY__SHIFT                                                                       0x1e
#define GRBM_STATUS_SE2__CB_BUSY__SHIFT                                                                       0x1f
#define GRBM_STATUS_SE2__SC_CLEAN_MASK                                                                        0x00000001L
#define GRBM_STATUS_SE2__DB_CLEAN_MASK                                                                        0x00000002L
#define GRBM_STATUS_SE2__CB_CLEAN_MASK                                                                        0x00000004L
#define GRBM_STATUS_SE2__UTCL1_BUSY_MASK                                                                      0x00000008L
#define GRBM_STATUS_SE2__TCP_BUSY_MASK                                                                        0x00000010L
#define GRBM_STATUS_SE2__GL1CC_BUSY_MASK                                                                      0x00000020L
#define GRBM_STATUS_SE2__GL1XCC_BUSY_MASK                                                                     0x00000040L
#define GRBM_STATUS_SE2__PC_BUSY_MASK                                                                         0x00000080L
#define GRBM_STATUS_SE2__BCI_BUSY_MASK                                                                        0x00400000L
#define GRBM_STATUS_SE2__PA_BUSY_MASK                                                                         0x01000000L
#define GRBM_STATUS_SE2__TA_BUSY_MASK                                                                         0x02000000L
#define GRBM_STATUS_SE2__SX_BUSY_MASK                                                                         0x04000000L
#define GRBM_STATUS_SE2__SPI_BUSY_MASK                                                                        0x08000000L
#define GRBM_STATUS_SE2__SC_BUSY_MASK                                                                         0x20000000L
#define GRBM_STATUS_SE2__DB_BUSY_MASK                                                                         0x40000000L
#define GRBM_STATUS_SE2__CB_BUSY_MASK                                                                         0x80000000L
//GRBM_STATUS_SE3
#define GRBM_STATUS_SE3__SC_CLEAN__SHIFT                                                                      0x0
#define GRBM_STATUS_SE3__DB_CLEAN__SHIFT                                                                      0x1
#define GRBM_STATUS_SE3__CB_CLEAN__SHIFT                                                                      0x2
#define GRBM_STATUS_SE3__UTCL1_BUSY__SHIFT                                                                    0x3
#define GRBM_STATUS_SE3__TCP_BUSY__SHIFT                                                                      0x4
#define GRBM_STATUS_SE3__GL1CC_BUSY__SHIFT                                                                    0x5
#define GRBM_STATUS_SE3__GL1XCC_BUSY__SHIFT                                                                   0x6
#define GRBM_STATUS_SE3__PC_BUSY__SHIFT                                                                       0x7
#define GRBM_STATUS_SE3__BCI_BUSY__SHIFT                                                                      0x16
#define GRBM_STATUS_SE3__PA_BUSY__SHIFT                                                                       0x18
#define GRBM_STATUS_SE3__TA_BUSY__SHIFT                                                                       0x19
#define GRBM_STATUS_SE3__SX_BUSY__SHIFT                                                                       0x1a
#define GRBM_STATUS_SE3__SPI_BUSY__SHIFT                                                                      0x1b
#define GRBM_STATUS_SE3__SC_BUSY__SHIFT                                                                       0x1d
#define GRBM_STATUS_SE3__DB_BUSY__SHIFT                                                                       0x1e
#define GRBM_STATUS_SE3__CB_BUSY__SHIFT                                                                       0x1f
#define GRBM_STATUS_SE3__SC_CLEAN_MASK                                                                        0x00000001L
#define GRBM_STATUS_SE3__DB_CLEAN_MASK                                                                        0x00000002L
#define GRBM_STATUS_SE3__CB_CLEAN_MASK                                                                        0x00000004L
#define GRBM_STATUS_SE3__UTCL1_BUSY_MASK                                                                      0x00000008L
#define GRBM_STATUS_SE3__TCP_BUSY_MASK                                                                        0x00000010L
#define GRBM_STATUS_SE3__GL1CC_BUSY_MASK                                                                      0x00000020L
#define GRBM_STATUS_SE3__GL1XCC_BUSY_MASK                                                                     0x00000040L
#define GRBM_STATUS_SE3__PC_BUSY_MASK                                                                         0x00000080L
#define GRBM_STATUS_SE3__BCI_BUSY_MASK                                                                        0x00400000L
#define GRBM_STATUS_SE3__PA_BUSY_MASK                                                                         0x01000000L
#define GRBM_STATUS_SE3__TA_BUSY_MASK                                                                         0x02000000L
#define GRBM_STATUS_SE3__SX_BUSY_MASK                                                                         0x04000000L
#define GRBM_STATUS_SE3__SPI_BUSY_MASK                                                                        0x08000000L
#define GRBM_STATUS_SE3__SC_BUSY_MASK                                                                         0x20000000L
#define GRBM_STATUS_SE3__DB_BUSY_MASK                                                                         0x40000000L
#define GRBM_STATUS_SE3__CB_BUSY_MASK                                                                         0x80000000L
//GRBM_READ_ERROR
#define GRBM_READ_ERROR__READ_ADDRESS__SHIFT                                                                  0x2
#define GRBM_READ_ERROR__READ_PIPEID__SHIFT                                                                   0x14
#define GRBM_READ_ERROR__READ_MEID__SHIFT                                                                     0x16
#define GRBM_READ_ERROR__READ_ERROR__SHIFT                                                                    0x1f
#define GRBM_READ_ERROR__READ_ADDRESS_MASK                                                                    0x000FFFFCL
#define GRBM_READ_ERROR__READ_PIPEID_MASK                                                                     0x00300000L
#define GRBM_READ_ERROR__READ_MEID_MASK                                                                       0x00C00000L
#define GRBM_READ_ERROR__READ_ERROR_MASK                                                                      0x80000000L
//GRBM_READ_ERROR2
#define GRBM_READ_ERROR2__READ_REQUESTER_MESPIPE0__SHIFT                                                      0x9
#define GRBM_READ_ERROR2__READ_REQUESTER_MESPIPE1__SHIFT                                                      0xa
#define GRBM_READ_ERROR2__READ_REQUESTER_MESPIPE2__SHIFT                                                      0xb
#define GRBM_READ_ERROR2__READ_REQUESTER_MESPIPE3__SHIFT                                                      0xc
#define GRBM_READ_ERROR2__READ_REQUESTER_SDMA0__SHIFT                                                         0xd
#define GRBM_READ_ERROR2__READ_REQUESTER_SDMA1__SHIFT                                                         0xe
#define GRBM_READ_ERROR2__READ_REQUESTER_RLC__SHIFT                                                           0x12
#define GRBM_READ_ERROR2__READ_REQUESTER_GDS_DMA__SHIFT                                                       0x13
#define GRBM_READ_ERROR2__READ_REQUESTER_ME0PIPE0_CF__SHIFT                                                   0x14
#define GRBM_READ_ERROR2__READ_REQUESTER_ME0PIPE0_PF__SHIFT                                                   0x15
#define GRBM_READ_ERROR2__READ_REQUESTER_ME0PIPE1_CF__SHIFT                                                   0x16
#define GRBM_READ_ERROR2__READ_REQUESTER_ME0PIPE1_PF__SHIFT                                                   0x17
#define GRBM_READ_ERROR2__READ_REQUESTER_ME1PIPE0__SHIFT                                                      0x18
#define GRBM_READ_ERROR2__READ_REQUESTER_ME1PIPE1__SHIFT                                                      0x19
#define GRBM_READ_ERROR2__READ_REQUESTER_ME1PIPE2__SHIFT                                                      0x1a
#define GRBM_READ_ERROR2__READ_REQUESTER_ME1PIPE3__SHIFT                                                      0x1b
#define GRBM_READ_ERROR2__READ_REQUESTER_ME2PIPE0__SHIFT                                                      0x1c
#define GRBM_READ_ERROR2__READ_REQUESTER_ME2PIPE1__SHIFT                                                      0x1d
#define GRBM_READ_ERROR2__READ_REQUESTER_ME2PIPE2__SHIFT                                                      0x1e
#define GRBM_READ_ERROR2__READ_REQUESTER_ME2PIPE3__SHIFT                                                      0x1f
#define GRBM_READ_ERROR2__READ_REQUESTER_MESPIPE0_MASK                                                        0x00000200L
#define GRBM_READ_ERROR2__READ_REQUESTER_MESPIPE1_MASK                                                        0x00000400L
#define GRBM_READ_ERROR2__READ_REQUESTER_MESPIPE2_MASK                                                        0x00000800L
#define GRBM_READ_ERROR2__READ_REQUESTER_MESPIPE3_MASK                                                        0x00001000L
#define GRBM_READ_ERROR2__READ_REQUESTER_SDMA0_MASK                                                           0x00002000L
#define GRBM_READ_ERROR2__READ_REQUESTER_SDMA1_MASK                                                           0x00004000L
#define GRBM_READ_ERROR2__READ_REQUESTER_RLC_MASK                                                             0x00040000L
#define GRBM_READ_ERROR2__READ_REQUESTER_GDS_DMA_MASK                                                         0x00080000L
#define GRBM_READ_ERROR2__READ_REQUESTER_ME0PIPE0_CF_MASK                                                     0x00100000L
#define GRBM_READ_ERROR2__READ_REQUESTER_ME0PIPE0_PF_MASK                                                     0x00200000L
#define GRBM_READ_ERROR2__READ_REQUESTER_ME0PIPE1_CF_MASK                                                     0x00400000L
#define GRBM_READ_ERROR2__READ_REQUESTER_ME0PIPE1_PF_MASK                                                     0x00800000L
#define GRBM_READ_ERROR2__READ_REQUESTER_ME1PIPE0_MASK                                                        0x01000000L
#define GRBM_READ_ERROR2__READ_REQUESTER_ME1PIPE1_MASK                                                        0x02000000L
#define GRBM_READ_ERROR2__READ_REQUESTER_ME1PIPE2_MASK                                                        0x04000000L
#define GRBM_READ_ERROR2__READ_REQUESTER_ME1PIPE3_MASK                                                        0x08000000L
#define GRBM_READ_ERROR2__READ_REQUESTER_ME2PIPE0_MASK                                                        0x10000000L
#define GRBM_READ_ERROR2__READ_REQUESTER_ME2PIPE1_MASK                                                        0x20000000L
#define GRBM_READ_ERROR2__READ_REQUESTER_ME2PIPE2_MASK                                                        0x40000000L
#define GRBM_READ_ERROR2__READ_REQUESTER_ME2PIPE3_MASK                                                        0x80000000L
//GRBM_INT_CNTL
#define GRBM_INT_CNTL__RDERR_INT_ENABLE__SHIFT                                                                0x0
#define GRBM_INT_CNTL__GUI_IDLE_INT_ENABLE__SHIFT                                                             0x13
#define GRBM_INT_CNTL__RDERR_INT_ENABLE_MASK                                                                  0x00000001L
#define GRBM_INT_CNTL__GUI_IDLE_INT_ENABLE_MASK                                                               0x00080000L
//GRBM_TRAP_OP
#define GRBM_TRAP_OP__RW__SHIFT                                                                               0x0
#define GRBM_TRAP_OP__RW_MASK                                                                                 0x00000001L
//GRBM_TRAP_ADDR
#define GRBM_TRAP_ADDR__DATA__SHIFT                                                                           0x0
#define GRBM_TRAP_ADDR__DATA_MASK                                                                             0x0003FFFFL
//GRBM_TRAP_ADDR_MSK
#define GRBM_TRAP_ADDR_MSK__DATA__SHIFT                                                                       0x0
#define GRBM_TRAP_ADDR_MSK__DATA_MASK                                                                         0x0003FFFFL
//GRBM_TRAP_WD
#define GRBM_TRAP_WD__DATA__SHIFT                                                                             0x0
#define GRBM_TRAP_WD__DATA_MASK                                                                               0xFFFFFFFFL
//GRBM_TRAP_WD_MSK
#define GRBM_TRAP_WD_MSK__DATA__SHIFT                                                                         0x0
#define GRBM_TRAP_WD_MSK__DATA_MASK                                                                           0xFFFFFFFFL
//GRBM_DSM_BYPASS
#define GRBM_DSM_BYPASS__BYPASS_BITS__SHIFT                                                                   0x0
#define GRBM_DSM_BYPASS__BYPASS_EN__SHIFT                                                                     0x2
#define GRBM_DSM_BYPASS__BYPASS_BITS_MASK                                                                     0x00000003L
#define GRBM_DSM_BYPASS__BYPASS_EN_MASK                                                                       0x00000004L
//GRBM_WRITE_ERROR
#define GRBM_WRITE_ERROR__WRITE_REQUESTER_RLC__SHIFT                                                          0x0
#define GRBM_WRITE_ERROR__WRITE_SSRCID__SHIFT                                                                 0x2
#define GRBM_WRITE_ERROR__WRITE_VFID__SHIFT                                                                   0x7
#define GRBM_WRITE_ERROR__WRITE_VF__SHIFT                                                                     0xc
#define GRBM_WRITE_ERROR__WRITE_VMID__SHIFT                                                                   0xd
#define GRBM_WRITE_ERROR__TMZ__SHIFT                                                                          0x11
#define GRBM_WRITE_ERROR__CP_SECURE_WR_ILLEGAL__SHIFT                                                         0x12
#define GRBM_WRITE_ERROR__WRITE_PIPEID__SHIFT                                                                 0x14
#define GRBM_WRITE_ERROR__WRITE_MEID__SHIFT                                                                   0x16
#define GRBM_WRITE_ERROR__WRITE_ERROR__SHIFT                                                                  0x1f
#define GRBM_WRITE_ERROR__WRITE_REQUESTER_RLC_MASK                                                            0x00000001L
#define GRBM_WRITE_ERROR__WRITE_SSRCID_MASK                                                                   0x0000003CL
#define GRBM_WRITE_ERROR__WRITE_VFID_MASK                                                                     0x00000F80L
#define GRBM_WRITE_ERROR__WRITE_VF_MASK                                                                       0x00001000L
#define GRBM_WRITE_ERROR__WRITE_VMID_MASK                                                                     0x0001E000L
#define GRBM_WRITE_ERROR__TMZ_MASK                                                                            0x00020000L
#define GRBM_WRITE_ERROR__CP_SECURE_WR_ILLEGAL_MASK                                                           0x00040000L
#define GRBM_WRITE_ERROR__WRITE_PIPEID_MASK                                                                   0x00300000L
#define GRBM_WRITE_ERROR__WRITE_MEID_MASK                                                                     0x00C00000L
#define GRBM_WRITE_ERROR__WRITE_ERROR_MASK                                                                    0x80000000L
//GRBM_CHIP_REVISION
#define GRBM_CHIP_REVISION__CHIP_REVISION__SHIFT                                                              0x0
#define GRBM_CHIP_REVISION__CHIP_REVISION_MASK                                                                0x000000FFL
//GRBM_IH_CREDIT
#define GRBM_IH_CREDIT__CREDIT_VALUE__SHIFT                                                                   0x0
#define GRBM_IH_CREDIT__IH_CLIENT_ID__SHIFT                                                                   0x10
#define GRBM_IH_CREDIT__CREDIT_VALUE_MASK                                                                     0x00000003L
#define GRBM_IH_CREDIT__IH_CLIENT_ID_MASK                                                                     0x00FF0000L
//GRBM_PWR_CNTL2
#define GRBM_PWR_CNTL2__PWR_REQUEST_HALT__SHIFT                                                               0x10
#define GRBM_PWR_CNTL2__PWR_GFX3D_REQUEST_HALT__SHIFT                                                         0x14
#define GRBM_PWR_CNTL2__PWR_REQUEST_HALT_MASK                                                                 0x00010000L
#define GRBM_PWR_CNTL2__PWR_GFX3D_REQUEST_HALT_MASK                                                           0x00100000L
//GRBM_UTCL2_INVAL_RANGE_START
#define GRBM_UTCL2_INVAL_RANGE_START__DATA__SHIFT                                                             0x0
#define GRBM_UTCL2_INVAL_RANGE_START__DATA_MASK                                                               0x0003FFFFL
//GRBM_UTCL2_INVAL_RANGE_END
#define GRBM_UTCL2_INVAL_RANGE_END__DATA__SHIFT                                                               0x0
#define GRBM_UTCL2_INVAL_RANGE_END__DATA_MASK                                                                 0x0003FFFFL
//GRBM_INVALID_PIPE
#define GRBM_INVALID_PIPE__ADDR__SHIFT                                                                        0x2
#define GRBM_INVALID_PIPE__PIPEID__SHIFT                                                                      0x14
#define GRBM_INVALID_PIPE__MEID__SHIFT                                                                        0x16
#define GRBM_INVALID_PIPE__QUEUEID__SHIFT                                                                     0x18
#define GRBM_INVALID_PIPE__SSRCID__SHIFT                                                                      0x1b
#define GRBM_INVALID_PIPE__INVALID_PIPE__SHIFT                                                                0x1f
#define GRBM_INVALID_PIPE__ADDR_MASK                                                                          0x000FFFFCL
#define GRBM_INVALID_PIPE__PIPEID_MASK                                                                        0x00300000L
#define GRBM_INVALID_PIPE__MEID_MASK                                                                          0x00C00000L
#define GRBM_INVALID_PIPE__QUEUEID_MASK                                                                       0x07000000L
#define GRBM_INVALID_PIPE__SSRCID_MASK                                                                        0x78000000L
#define GRBM_INVALID_PIPE__INVALID_PIPE_MASK                                                                  0x80000000L
//GRBM_FENCE_RANGE0
#define GRBM_FENCE_RANGE0__START__SHIFT                                                                       0x0
#define GRBM_FENCE_RANGE0__END__SHIFT                                                                         0x10
#define GRBM_FENCE_RANGE0__START_MASK                                                                         0x0000FFFFL
#define GRBM_FENCE_RANGE0__END_MASK                                                                           0xFFFF0000L
//GRBM_FENCE_RANGE1
#define GRBM_FENCE_RANGE1__START__SHIFT                                                                       0x0
#define GRBM_FENCE_RANGE1__END__SHIFT                                                                         0x10
#define GRBM_FENCE_RANGE1__START_MASK                                                                         0x0000FFFFL
#define GRBM_FENCE_RANGE1__END_MASK                                                                           0xFFFF0000L
//GRBM_CHICKEN_BITS0
#define GRBM_CHICKEN_BITS0__GRBM_SDMA0_reg_fgcg_chick_bit__SHIFT                                              0x0
#define GRBM_CHICKEN_BITS0__GRBM_SDMA1_reg_fgcg_chick_bit__SHIFT                                              0x1
#define GRBM_CHICKEN_BITS0__GRBM_CPG_reg_fgcg_chick_bit__SHIFT                                                0x2
#define GRBM_CHICKEN_BITS0__GRBM_CPF_reg_fgcg_chick_bit__SHIFT                                                0x3
#define GRBM_CHICKEN_BITS0__GRBM_UTCL2_reg_fgcg_chick_bit__SHIFT                                              0x5
#define GRBM_CHICKEN_BITS0__GRBM_TARG0_mcd_reg_clken_chick_bit__SHIFT                                         0x6
#define GRBM_CHICKEN_BITS0__GRBM_TARG1_targvf_reg_clken_chick_bit__SHIFT                                      0x7
#define GRBM_CHICKEN_BITS0__GRBM_TARG2_targvf_reg_clken_chick_bit__SHIFT                                      0x8
#define GRBM_CHICKEN_BITS0__GRBM_TARG3_targvf_reg_clken_chick_bit__SHIFT                                      0x9
#define GRBM_CHICKEN_BITS0__GRBM_TARG4_targvf_reg_clken_chick_bit__SHIFT                                      0xa
#define GRBM_CHICKEN_BITS0__GRBM_TARG5_reg_clken_chick_bit__SHIFT                                             0xb
#define GRBM_CHICKEN_BITS0__GRBM_TARG6_reg_clken_chick_bit__SHIFT                                             0xc
#define GRBM_CHICKEN_BITS0__GRBM_TARG7_reg_clken_chick_bit__SHIFT                                             0xd
#define GRBM_CHICKEN_BITS0__GRBM_TARG8_reg_clken_chick_bit__SHIFT                                             0xe
#define GRBM_CHICKEN_BITS0__GRBM_TARG9_reg_clken_chick_bit__SHIFT                                             0xf
#define GRBM_CHICKEN_BITS0__GRBM_TARG10_reg_clken_chick_bit__SHIFT                                            0x10
#define GRBM_CHICKEN_BITS0__GRBM_TARG11_reg_clken_chick_bit__SHIFT                                            0x11
#define GRBM_CHICKEN_BITS0__GRBM_GRBMHSE0_reg_clken_chick_bit__SHIFT                                          0x12
#define GRBM_CHICKEN_BITS0__GRBM_GRBMHSE1_reg_clken_chick_bit__SHIFT                                          0x13
#define GRBM_CHICKEN_BITS0__GRBM_GRBMHSE2_reg_clken_chick_bit__SHIFT                                          0x14
#define GRBM_CHICKEN_BITS0__GRBM_GRBMHSE3_reg_clken_chick_bit__SHIFT                                          0x15
#define GRBM_CHICKEN_BITS0__GRBM_GRBMHSE4_reg_clken_chick_bit__SHIFT                                          0x16
#define GRBM_CHICKEN_BITS0__GRBM_GRBMHSE5_reg_clken_chick_bit__SHIFT                                          0x17
#define GRBM_CHICKEN_BITS0__GRBM_GRBMHSE6_reg_clken_chick_bit__SHIFT                                          0x18
#define GRBM_CHICKEN_BITS0__GRBM_GRBMHSE7_reg_clken_chick_bit__SHIFT                                          0x19
#define GRBM_CHICKEN_BITS0__GRBM_CPC_reg_clken_chick_bit__SHIFT                                               0x1c
#define GRBM_CHICKEN_BITS0__GRBM_GDFLL_reg_clken_chick_bit__SHIFT                                             0x1e
#define GRBM_CHICKEN_BITS0__GRBM_RLC_reg_clken_chick_bit__SHIFT                                               0x1f
#define GRBM_CHICKEN_BITS0__GRBM_SDMA0_reg_fgcg_chick_bit_MASK                                                0x00000001L
#define GRBM_CHICKEN_BITS0__GRBM_SDMA1_reg_fgcg_chick_bit_MASK                                                0x00000002L
#define GRBM_CHICKEN_BITS0__GRBM_CPG_reg_fgcg_chick_bit_MASK                                                  0x00000004L
#define GRBM_CHICKEN_BITS0__GRBM_CPF_reg_fgcg_chick_bit_MASK                                                  0x00000008L
#define GRBM_CHICKEN_BITS0__GRBM_UTCL2_reg_fgcg_chick_bit_MASK                                                0x00000020L
#define GRBM_CHICKEN_BITS0__GRBM_TARG0_mcd_reg_clken_chick_bit_MASK                                           0x00000040L
#define GRBM_CHICKEN_BITS0__GRBM_TARG1_targvf_reg_clken_chick_bit_MASK                                        0x00000080L
#define GRBM_CHICKEN_BITS0__GRBM_TARG2_targvf_reg_clken_chick_bit_MASK                                        0x00000100L
#define GRBM_CHICKEN_BITS0__GRBM_TARG3_targvf_reg_clken_chick_bit_MASK                                        0x00000200L
#define GRBM_CHICKEN_BITS0__GRBM_TARG4_targvf_reg_clken_chick_bit_MASK                                        0x00000400L
#define GRBM_CHICKEN_BITS0__GRBM_TARG5_reg_clken_chick_bit_MASK                                               0x00000800L
#define GRBM_CHICKEN_BITS0__GRBM_TARG6_reg_clken_chick_bit_MASK                                               0x00001000L
#define GRBM_CHICKEN_BITS0__GRBM_TARG7_reg_clken_chick_bit_MASK                                               0x00002000L
#define GRBM_CHICKEN_BITS0__GRBM_TARG8_reg_clken_chick_bit_MASK                                               0x00004000L
#define GRBM_CHICKEN_BITS0__GRBM_TARG9_reg_clken_chick_bit_MASK                                               0x00008000L
#define GRBM_CHICKEN_BITS0__GRBM_TARG10_reg_clken_chick_bit_MASK                                              0x00010000L
#define GRBM_CHICKEN_BITS0__GRBM_TARG11_reg_clken_chick_bit_MASK                                              0x00020000L
#define GRBM_CHICKEN_BITS0__GRBM_GRBMHSE0_reg_clken_chick_bit_MASK                                            0x00040000L
#define GRBM_CHICKEN_BITS0__GRBM_GRBMHSE1_reg_clken_chick_bit_MASK                                            0x00080000L
#define GRBM_CHICKEN_BITS0__GRBM_GRBMHSE2_reg_clken_chick_bit_MASK                                            0x00100000L
#define GRBM_CHICKEN_BITS0__GRBM_GRBMHSE3_reg_clken_chick_bit_MASK                                            0x00200000L
#define GRBM_CHICKEN_BITS0__GRBM_GRBMHSE4_reg_clken_chick_bit_MASK                                            0x00400000L
#define GRBM_CHICKEN_BITS0__GRBM_GRBMHSE5_reg_clken_chick_bit_MASK                                            0x00800000L
#define GRBM_CHICKEN_BITS0__GRBM_GRBMHSE6_reg_clken_chick_bit_MASK                                            0x01000000L
#define GRBM_CHICKEN_BITS0__GRBM_GRBMHSE7_reg_clken_chick_bit_MASK                                            0x02000000L
#define GRBM_CHICKEN_BITS0__GRBM_CPC_reg_clken_chick_bit_MASK                                                 0x10000000L
#define GRBM_CHICKEN_BITS0__GRBM_GDFLL_reg_clken_chick_bit_MASK                                               0x40000000L
#define GRBM_CHICKEN_BITS0__GRBM_RLC_reg_clken_chick_bit_MASK                                                 0x80000000L
//GRBM_CHICKEN_BITS1
//CC_GC_FULL_SA_UNIT_DISABLE
#define CC_GC_FULL_SA_UNIT_DISABLE__SA_DISABLE__SHIFT                                                         0x8
#define CC_GC_FULL_SA_UNIT_DISABLE__SA_DISABLE_MASK                                                           0x03FFFF00L
//GRBM_SCRATCH_REG0
#define GRBM_SCRATCH_REG0__SCRATCH_REG0__SHIFT                                                                0x0
#define GRBM_SCRATCH_REG0__SCRATCH_REG0_MASK                                                                  0xFFFFFFFFL
//GRBM_SCRATCH_REG1
#define GRBM_SCRATCH_REG1__SCRATCH_REG1__SHIFT                                                                0x0
#define GRBM_SCRATCH_REG1__SCRATCH_REG1_MASK                                                                  0xFFFFFFFFL
//GRBM_SCRATCH_REG2
#define GRBM_SCRATCH_REG2__SCRATCH_REG2__SHIFT                                                                0x0
#define GRBM_SCRATCH_REG2__SCRATCH_REG2_MASK                                                                  0xFFFFFFFFL
//GRBM_SCRATCH_REG3
#define GRBM_SCRATCH_REG3__SCRATCH_REG3__SHIFT                                                                0x0
#define GRBM_SCRATCH_REG3__SCRATCH_REG3_MASK                                                                  0xFFFFFFFFL
//GRBM_SCRATCH_REG4
#define GRBM_SCRATCH_REG4__SCRATCH_REG4__SHIFT                                                                0x0
#define GRBM_SCRATCH_REG4__SCRATCH_REG4_MASK                                                                  0xFFFFFFFFL
//GRBM_SCRATCH_REG5
#define GRBM_SCRATCH_REG5__SCRATCH_REG5__SHIFT                                                                0x0
#define GRBM_SCRATCH_REG5__SCRATCH_REG5_MASK                                                                  0xFFFFFFFFL
//GRBM_SCRATCH_REG6
#define GRBM_SCRATCH_REG6__SCRATCH_REG6__SHIFT                                                                0x0
#define GRBM_SCRATCH_REG6__SCRATCH_REG6_MASK                                                                  0xFFFFFFFFL
//GRBM_SCRATCH_REG7
#define GRBM_SCRATCH_REG7__SCRATCH_REG7__SHIFT                                                                0x0
#define GRBM_SCRATCH_REG7__SCRATCH_REG7_MASK                                                                  0xFFFFFFFFL
//GRBM_INTF_CNTL
#define GRBM_INTF_CNTL__GRBM_BRIDGE_DISABLE__SHIFT                                                            0x0
#define GRBM_INTF_CNTL__GRBM_BRIDGE_DISABLE_MASK                                                              0x00000001L


// addressBlock: gc_gfx_cpwd_cpwd_cpdec
//CP_CPC_DEBUG_CNTL
#define CP_CPC_DEBUG_CNTL__DEBUG_INDX__SHIFT                                                                  0x0
#define CP_CPC_DEBUG_CNTL__DEBUG_INDX_MASK                                                                    0x0000007FL
//CP_CPC_DEBUG_DATA
#define CP_CPC_DEBUG_DATA__DEBUG_DATA__SHIFT                                                                  0x0
#define CP_CPC_DEBUG_DATA__DEBUG_DATA_MASK                                                                    0xFFFFFFFFL
//CP_CPF_DEBUG_CNTL
#define CP_CPF_DEBUG_CNTL__DEBUG_INDX__SHIFT                                                                  0x0
#define CP_CPF_DEBUG_CNTL__DEBUG_INDX_MASK                                                                    0x0000007FL
//CP_CPC_STATUS
#define CP_CPC_STATUS__MEC1_BUSY__SHIFT                                                                       0x0
#define CP_CPC_STATUS__MEC2_BUSY__SHIFT                                                                       0x1
#define CP_CPC_STATUS__DC0_BUSY__SHIFT                                                                        0x2
#define CP_CPC_STATUS__DC1_BUSY__SHIFT                                                                        0x3
#define CP_CPC_STATUS__RCIU1_BUSY__SHIFT                                                                      0x4
#define CP_CPC_STATUS__RCIU2_BUSY__SHIFT                                                                      0x5
#define CP_CPC_STATUS__ROQ1_BUSY__SHIFT                                                                       0x6
#define CP_CPC_STATUS__ROQ2_BUSY__SHIFT                                                                       0x7
#define CP_CPC_STATUS__TCIU_BUSY__SHIFT                                                                       0xa
#define CP_CPC_STATUS__SCRATCH_RAM_BUSY__SHIFT                                                                0xb
#define CP_CPC_STATUS__QU_BUSY__SHIFT                                                                         0xc
#define CP_CPC_STATUS__UTCL2IU_BUSY__SHIFT                                                                    0xd
#define CP_CPC_STATUS__SAVE_RESTORE_BUSY__SHIFT                                                               0xe
#define CP_CPC_STATUS__GCRIU_BUSY__SHIFT                                                                      0xf
#define CP_CPC_STATUS__MES_BUSY__SHIFT                                                                        0x10
#define CP_CPC_STATUS__MES_SCRATCH_RAM_BUSY__SHIFT                                                            0x11
#define CP_CPC_STATUS__RCIU3_BUSY__SHIFT                                                                      0x12
#define CP_CPC_STATUS__MES_INSTRUCTION_CACHE_BUSY__SHIFT                                                      0x13
#define CP_CPC_STATUS__MES_DATA_CACHE_BUSY__SHIFT                                                             0x14
#define CP_CPC_STATUS__MEC_DATA_CACHE_BUSY__SHIFT                                                             0x15
#define CP_CPC_STATUS__CPG_CPC_BUSY__SHIFT                                                                    0x1d
#define CP_CPC_STATUS__CPF_CPC_BUSY__SHIFT                                                                    0x1e
#define CP_CPC_STATUS__CPC_BUSY__SHIFT                                                                        0x1f
#define CP_CPC_STATUS__MEC1_BUSY_MASK                                                                         0x00000001L
#define CP_CPC_STATUS__MEC2_BUSY_MASK                                                                         0x00000002L
#define CP_CPC_STATUS__DC0_BUSY_MASK                                                                          0x00000004L
#define CP_CPC_STATUS__DC1_BUSY_MASK                                                                          0x00000008L
#define CP_CPC_STATUS__RCIU1_BUSY_MASK                                                                        0x00000010L
#define CP_CPC_STATUS__RCIU2_BUSY_MASK                                                                        0x00000020L
#define CP_CPC_STATUS__ROQ1_BUSY_MASK                                                                         0x00000040L
#define CP_CPC_STATUS__ROQ2_BUSY_MASK                                                                         0x00000080L
#define CP_CPC_STATUS__TCIU_BUSY_MASK                                                                         0x00000400L
#define CP_CPC_STATUS__SCRATCH_RAM_BUSY_MASK                                                                  0x00000800L
#define CP_CPC_STATUS__QU_BUSY_MASK                                                                           0x00001000L
#define CP_CPC_STATUS__UTCL2IU_BUSY_MASK                                                                      0x00002000L
#define CP_CPC_STATUS__SAVE_RESTORE_BUSY_MASK                                                                 0x00004000L
#define CP_CPC_STATUS__GCRIU_BUSY_MASK                                                                        0x00008000L
#define CP_CPC_STATUS__MES_BUSY_MASK                                                                          0x00010000L
#define CP_CPC_STATUS__MES_SCRATCH_RAM_BUSY_MASK                                                              0x00020000L
#define CP_CPC_STATUS__RCIU3_BUSY_MASK                                                                        0x00040000L
#define CP_CPC_STATUS__MES_INSTRUCTION_CACHE_BUSY_MASK                                                        0x00080000L
#define CP_CPC_STATUS__MES_DATA_CACHE_BUSY_MASK                                                               0x00100000L
#define CP_CPC_STATUS__MEC_DATA_CACHE_BUSY_MASK                                                               0x00200000L
#define CP_CPC_STATUS__CPG_CPC_BUSY_MASK                                                                      0x20000000L
#define CP_CPC_STATUS__CPF_CPC_BUSY_MASK                                                                      0x40000000L
#define CP_CPC_STATUS__CPC_BUSY_MASK                                                                          0x80000000L
//CP_CPC_BUSY_STAT
#define CP_CPC_BUSY_STAT__MEC1_LOAD_BUSY__SHIFT                                                               0x0
#define CP_CPC_BUSY_STAT__MEC1_MUTEX_BUSY__SHIFT                                                              0x2
#define CP_CPC_BUSY_STAT__MEC1_MESSAGE_BUSY__SHIFT                                                            0x3
#define CP_CPC_BUSY_STAT__MEC1_EOP_QUEUE_BUSY__SHIFT                                                          0x4
#define CP_CPC_BUSY_STAT__MEC1_IQ_QUEUE_BUSY__SHIFT                                                           0x5
#define CP_CPC_BUSY_STAT__MEC1_IB_QUEUE_BUSY__SHIFT                                                           0x6
#define CP_CPC_BUSY_STAT__MEC1_TC_BUSY__SHIFT                                                                 0x7
#define CP_CPC_BUSY_STAT__MEC1_DMA_BUSY__SHIFT                                                                0x8
#define CP_CPC_BUSY_STAT__MEC1_PARTIAL_FLUSH_BUSY__SHIFT                                                      0x9
#define CP_CPC_BUSY_STAT__MEC1_PIPE0_BUSY__SHIFT                                                              0xa
#define CP_CPC_BUSY_STAT__MEC1_PIPE1_BUSY__SHIFT                                                              0xb
#define CP_CPC_BUSY_STAT__MEC1_PIPE2_BUSY__SHIFT                                                              0xc
#define CP_CPC_BUSY_STAT__MEC1_PIPE3_BUSY__SHIFT                                                              0xd
#define CP_CPC_BUSY_STAT__MEC2_LOAD_BUSY__SHIFT                                                               0x10
#define CP_CPC_BUSY_STAT__MEC2_MUTEX_BUSY__SHIFT                                                              0x12
#define CP_CPC_BUSY_STAT__MEC2_MESSAGE_BUSY__SHIFT                                                            0x13
#define CP_CPC_BUSY_STAT__MEC2_EOP_QUEUE_BUSY__SHIFT                                                          0x14
#define CP_CPC_BUSY_STAT__MEC2_IQ_QUEUE_BUSY__SHIFT                                                           0x15
#define CP_CPC_BUSY_STAT__MEC2_IB_QUEUE_BUSY__SHIFT                                                           0x16
#define CP_CPC_BUSY_STAT__MEC2_TC_BUSY__SHIFT                                                                 0x17
#define CP_CPC_BUSY_STAT__MEC2_DMA_BUSY__SHIFT                                                                0x18
#define CP_CPC_BUSY_STAT__MEC2_PARTIAL_FLUSH_BUSY__SHIFT                                                      0x19
#define CP_CPC_BUSY_STAT__MEC2_PIPE0_BUSY__SHIFT                                                              0x1a
#define CP_CPC_BUSY_STAT__MEC2_PIPE1_BUSY__SHIFT                                                              0x1b
#define CP_CPC_BUSY_STAT__MEC2_PIPE2_BUSY__SHIFT                                                              0x1c
#define CP_CPC_BUSY_STAT__MEC2_PIPE3_BUSY__SHIFT                                                              0x1d
#define CP_CPC_BUSY_STAT__MEC1_LOAD_BUSY_MASK                                                                 0x00000001L
#define CP_CPC_BUSY_STAT__MEC1_MUTEX_BUSY_MASK                                                                0x00000004L
#define CP_CPC_BUSY_STAT__MEC1_MESSAGE_BUSY_MASK                                                              0x00000008L
#define CP_CPC_BUSY_STAT__MEC1_EOP_QUEUE_BUSY_MASK                                                            0x00000010L
#define CP_CPC_BUSY_STAT__MEC1_IQ_QUEUE_BUSY_MASK                                                             0x00000020L
#define CP_CPC_BUSY_STAT__MEC1_IB_QUEUE_BUSY_MASK                                                             0x00000040L
#define CP_CPC_BUSY_STAT__MEC1_TC_BUSY_MASK                                                                   0x00000080L
#define CP_CPC_BUSY_STAT__MEC1_DMA_BUSY_MASK                                                                  0x00000100L
#define CP_CPC_BUSY_STAT__MEC1_PARTIAL_FLUSH_BUSY_MASK                                                        0x00000200L
#define CP_CPC_BUSY_STAT__MEC1_PIPE0_BUSY_MASK                                                                0x00000400L
#define CP_CPC_BUSY_STAT__MEC1_PIPE1_BUSY_MASK                                                                0x00000800L
#define CP_CPC_BUSY_STAT__MEC1_PIPE2_BUSY_MASK                                                                0x00001000L
#define CP_CPC_BUSY_STAT__MEC1_PIPE3_BUSY_MASK                                                                0x00002000L
#define CP_CPC_BUSY_STAT__MEC2_LOAD_BUSY_MASK                                                                 0x00010000L
#define CP_CPC_BUSY_STAT__MEC2_MUTEX_BUSY_MASK                                                                0x00040000L
#define CP_CPC_BUSY_STAT__MEC2_MESSAGE_BUSY_MASK                                                              0x00080000L
#define CP_CPC_BUSY_STAT__MEC2_EOP_QUEUE_BUSY_MASK                                                            0x00100000L
#define CP_CPC_BUSY_STAT__MEC2_IQ_QUEUE_BUSY_MASK                                                             0x00200000L
#define CP_CPC_BUSY_STAT__MEC2_IB_QUEUE_BUSY_MASK                                                             0x00400000L
#define CP_CPC_BUSY_STAT__MEC2_TC_BUSY_MASK                                                                   0x00800000L
#define CP_CPC_BUSY_STAT__MEC2_DMA_BUSY_MASK                                                                  0x01000000L
#define CP_CPC_BUSY_STAT__MEC2_PARTIAL_FLUSH_BUSY_MASK                                                        0x02000000L
#define CP_CPC_BUSY_STAT__MEC2_PIPE0_BUSY_MASK                                                                0x04000000L
#define CP_CPC_BUSY_STAT__MEC2_PIPE1_BUSY_MASK                                                                0x08000000L
#define CP_CPC_BUSY_STAT__MEC2_PIPE2_BUSY_MASK                                                                0x10000000L
#define CP_CPC_BUSY_STAT__MEC2_PIPE3_BUSY_MASK                                                                0x20000000L
//CP_CPC_STALLED_STAT1
#define CP_CPC_STALLED_STAT1__RCIU_TX_FREE_STALL__SHIFT                                                       0x3
#define CP_CPC_STALLED_STAT1__RCIU_PRIV_VIOLATION__SHIFT                                                      0x4
#define CP_CPC_STALLED_STAT1__TCIU_TX_FREE_STALL__SHIFT                                                       0x6
#define CP_CPC_STALLED_STAT1__TCIU_WAITING_ON_TAGS__SHIFT                                                     0x7
#define CP_CPC_STALLED_STAT1__MEC1_DECODING_PACKET__SHIFT                                                     0x8
#define CP_CPC_STALLED_STAT1__MEC1_WAIT_ON_RCIU__SHIFT                                                        0x9
#define CP_CPC_STALLED_STAT1__MEC1_WAIT_ON_RCIU_READ__SHIFT                                                   0xa
#define CP_CPC_STALLED_STAT1__MEC1_WAIT_ON_ROQ_DATA__SHIFT                                                    0xd
#define CP_CPC_STALLED_STAT1__MEC2_DECODING_PACKET__SHIFT                                                     0x10
#define CP_CPC_STALLED_STAT1__MEC2_WAIT_ON_RCIU__SHIFT                                                        0x11
#define CP_CPC_STALLED_STAT1__MEC2_WAIT_ON_RCIU_READ__SHIFT                                                   0x12
#define CP_CPC_STALLED_STAT1__MEC2_WAIT_ON_ROQ_DATA__SHIFT                                                    0x15
#define CP_CPC_STALLED_STAT1__UTCL2IU_WAITING_ON_FREE__SHIFT                                                  0x16
#define CP_CPC_STALLED_STAT1__UTCL2IU_WAITING_ON_TAGS__SHIFT                                                  0x17
#define CP_CPC_STALLED_STAT1__UTCL1_WAITING_ON_TRANS__SHIFT                                                   0x18
#define CP_CPC_STALLED_STAT1__GCRIU_WAITING_ON_FREE__SHIFT                                                    0x19
#define CP_CPC_STALLED_STAT1__RCIU_TX_FREE_STALL_MASK                                                         0x00000008L
#define CP_CPC_STALLED_STAT1__RCIU_PRIV_VIOLATION_MASK                                                        0x00000010L
#define CP_CPC_STALLED_STAT1__TCIU_TX_FREE_STALL_MASK                                                         0x00000040L
#define CP_CPC_STALLED_STAT1__TCIU_WAITING_ON_TAGS_MASK                                                       0x00000080L
#define CP_CPC_STALLED_STAT1__MEC1_DECODING_PACKET_MASK                                                       0x00000100L
#define CP_CPC_STALLED_STAT1__MEC1_WAIT_ON_RCIU_MASK                                                          0x00000200L
#define CP_CPC_STALLED_STAT1__MEC1_WAIT_ON_RCIU_READ_MASK                                                     0x00000400L
#define CP_CPC_STALLED_STAT1__MEC1_WAIT_ON_ROQ_DATA_MASK                                                      0x00002000L
#define CP_CPC_STALLED_STAT1__MEC2_DECODING_PACKET_MASK                                                       0x00010000L
#define CP_CPC_STALLED_STAT1__MEC2_WAIT_ON_RCIU_MASK                                                          0x00020000L
#define CP_CPC_STALLED_STAT1__MEC2_WAIT_ON_RCIU_READ_MASK                                                     0x00040000L
#define CP_CPC_STALLED_STAT1__MEC2_WAIT_ON_ROQ_DATA_MASK                                                      0x00200000L
#define CP_CPC_STALLED_STAT1__UTCL2IU_WAITING_ON_FREE_MASK                                                    0x00400000L
#define CP_CPC_STALLED_STAT1__UTCL2IU_WAITING_ON_TAGS_MASK                                                    0x00800000L
#define CP_CPC_STALLED_STAT1__UTCL1_WAITING_ON_TRANS_MASK                                                     0x01000000L
#define CP_CPC_STALLED_STAT1__GCRIU_WAITING_ON_FREE_MASK                                                      0x02000000L
//CP_CPF_STATUS
#define CP_CPF_STATUS__POST_WPTR_GFX_BUSY__SHIFT                                                              0x0
#define CP_CPF_STATUS__CSF_BUSY__SHIFT                                                                        0x1
#define CP_CPF_STATUS__ROQ_ALIGN_BUSY__SHIFT                                                                  0x4
#define CP_CPF_STATUS__ROQ_RING_BUSY__SHIFT                                                                   0x5
#define CP_CPF_STATUS__ROQ_INDIRECT1_BUSY__SHIFT                                                              0x6
#define CP_CPF_STATUS__ROQ_INDIRECT2_BUSY__SHIFT                                                              0x7
#define CP_CPF_STATUS__ROQ_STATE_BUSY__SHIFT                                                                  0x8
#define CP_CPF_STATUS__ROQ_CE_RING_BUSY__SHIFT                                                                0x9
#define CP_CPF_STATUS__ROQ_CE_INDIRECT1_BUSY__SHIFT                                                           0xa
#define CP_CPF_STATUS__ROQ_CE_INDIRECT2_BUSY__SHIFT                                                           0xb
#define CP_CPF_STATUS__INTERRUPT_BUSY__SHIFT                                                                  0xd
#define CP_CPF_STATUS__TCIU_BUSY__SHIFT                                                                       0xe
#define CP_CPF_STATUS__HQD_BUSY__SHIFT                                                                        0xf
#define CP_CPF_STATUS__PRT_BUSY__SHIFT                                                                        0x10
#define CP_CPF_STATUS__UTCL2IU_BUSY__SHIFT                                                                    0x11
#define CP_CPF_STATUS__RCIU_BUSY__SHIFT                                                                       0x12
#define CP_CPF_STATUS__RCIU_GFX_BUSY__SHIFT                                                                   0x13
#define CP_CPF_STATUS__RCIU_CMP_BUSY__SHIFT                                                                   0x14
#define CP_CPF_STATUS__ROQ_DATA_BUSY__SHIFT                                                                   0x15
#define CP_CPF_STATUS__ROQ_CE_DATA_BUSY__SHIFT                                                                0x16
#define CP_CPF_STATUS__GCRIU_BUSY__SHIFT                                                                      0x17
#define CP_CPF_STATUS__MES_HQD_BUSY__SHIFT                                                                    0x18
#define CP_CPF_STATUS__CPF_GFX_BUSY__SHIFT                                                                    0x1a
#define CP_CPF_STATUS__CPF_CMP_BUSY__SHIFT                                                                    0x1b
#define CP_CPF_STATUS__GRBM_CPF_STAT_BUSY__SHIFT                                                              0x1c
#define CP_CPF_STATUS__CPC_CPF_BUSY__SHIFT                                                                    0x1e
#define CP_CPF_STATUS__CPF_BUSY__SHIFT                                                                        0x1f
#define CP_CPF_STATUS__POST_WPTR_GFX_BUSY_MASK                                                                0x00000001L
#define CP_CPF_STATUS__CSF_BUSY_MASK                                                                          0x00000002L
#define CP_CPF_STATUS__ROQ_ALIGN_BUSY_MASK                                                                    0x00000010L
#define CP_CPF_STATUS__ROQ_RING_BUSY_MASK                                                                     0x00000020L
#define CP_CPF_STATUS__ROQ_INDIRECT1_BUSY_MASK                                                                0x00000040L
#define CP_CPF_STATUS__ROQ_INDIRECT2_BUSY_MASK                                                                0x00000080L
#define CP_CPF_STATUS__ROQ_STATE_BUSY_MASK                                                                    0x00000100L
#define CP_CPF_STATUS__ROQ_CE_RING_BUSY_MASK                                                                  0x00000200L
#define CP_CPF_STATUS__ROQ_CE_INDIRECT1_BUSY_MASK                                                             0x00000400L
#define CP_CPF_STATUS__ROQ_CE_INDIRECT2_BUSY_MASK                                                             0x00000800L
#define CP_CPF_STATUS__INTERRUPT_BUSY_MASK                                                                    0x00002000L
#define CP_CPF_STATUS__TCIU_BUSY_MASK                                                                         0x00004000L
#define CP_CPF_STATUS__HQD_BUSY_MASK                                                                          0x00008000L
#define CP_CPF_STATUS__PRT_BUSY_MASK                                                                          0x00010000L
#define CP_CPF_STATUS__UTCL2IU_BUSY_MASK                                                                      0x00020000L
#define CP_CPF_STATUS__RCIU_BUSY_MASK                                                                         0x00040000L
#define CP_CPF_STATUS__RCIU_GFX_BUSY_MASK                                                                     0x00080000L
#define CP_CPF_STATUS__RCIU_CMP_BUSY_MASK                                                                     0x00100000L
#define CP_CPF_STATUS__ROQ_DATA_BUSY_MASK                                                                     0x00200000L
#define CP_CPF_STATUS__ROQ_CE_DATA_BUSY_MASK                                                                  0x00400000L
#define CP_CPF_STATUS__GCRIU_BUSY_MASK                                                                        0x00800000L
#define CP_CPF_STATUS__MES_HQD_BUSY_MASK                                                                      0x01000000L
#define CP_CPF_STATUS__CPF_GFX_BUSY_MASK                                                                      0x04000000L
#define CP_CPF_STATUS__CPF_CMP_BUSY_MASK                                                                      0x08000000L
#define CP_CPF_STATUS__GRBM_CPF_STAT_BUSY_MASK                                                                0x30000000L
#define CP_CPF_STATUS__CPC_CPF_BUSY_MASK                                                                      0x40000000L
#define CP_CPF_STATUS__CPF_BUSY_MASK                                                                          0x80000000L
//CP_CPF_BUSY_STAT
#define CP_CPF_BUSY_STAT__REG_BUS_FIFO_BUSY__SHIFT                                                            0x0
#define CP_CPF_BUSY_STAT__CSF_RING_BUSY__SHIFT                                                                0x1
#define CP_CPF_BUSY_STAT__CSF_INDIRECT1_BUSY__SHIFT                                                           0x2
#define CP_CPF_BUSY_STAT__CSF_INDIRECT2_BUSY__SHIFT                                                           0x3
#define CP_CPF_BUSY_STAT__CSF_STATE_BUSY__SHIFT                                                               0x4
#define CP_CPF_BUSY_STAT__CSF_CE_INDR1_BUSY__SHIFT                                                            0x5
#define CP_CPF_BUSY_STAT__CSF_CE_INDR2_BUSY__SHIFT                                                            0x6
#define CP_CPF_BUSY_STAT__CSF_ARBITER_BUSY__SHIFT                                                             0x7
#define CP_CPF_BUSY_STAT__CSF_INPUT_BUSY__SHIFT                                                               0x8
#define CP_CPF_BUSY_STAT__CSF_DATA_BUSY__SHIFT                                                                0x9
#define CP_CPF_BUSY_STAT__CSF_CE_DATA_BUSY__SHIFT                                                             0xa
#define CP_CPF_BUSY_STAT__HPD_PROCESSING_EOP_BUSY__SHIFT                                                      0xb
#define CP_CPF_BUSY_STAT__HQD_DISPATCH_BUSY__SHIFT                                                            0xc
#define CP_CPF_BUSY_STAT__HQD_IQ_TIMER_BUSY__SHIFT                                                            0xd
#define CP_CPF_BUSY_STAT__HQD_DMA_OFFLOAD_BUSY__SHIFT                                                         0xe
#define CP_CPF_BUSY_STAT__HQD_MESSAGE_BUSY__SHIFT                                                             0x11
#define CP_CPF_BUSY_STAT__HQD_PQ_FETCHER_BUSY__SHIFT                                                          0x12
#define CP_CPF_BUSY_STAT__HQD_IB_FETCHER_BUSY__SHIFT                                                          0x13
#define CP_CPF_BUSY_STAT__HQD_IQ_FETCHER_BUSY__SHIFT                                                          0x14
#define CP_CPF_BUSY_STAT__HQD_EOP_FETCHER_BUSY__SHIFT                                                         0x15
#define CP_CPF_BUSY_STAT__HQD_CONSUMED_RPTR_BUSY__SHIFT                                                       0x16
#define CP_CPF_BUSY_STAT__HQD_FETCHER_ARB_BUSY__SHIFT                                                         0x17
#define CP_CPF_BUSY_STAT__HQD_ROQ_ALIGN_BUSY__SHIFT                                                           0x18
#define CP_CPF_BUSY_STAT__HQD_ROQ_EOP_BUSY__SHIFT                                                             0x19
#define CP_CPF_BUSY_STAT__HQD_ROQ_IQ_BUSY__SHIFT                                                              0x1a
#define CP_CPF_BUSY_STAT__HQD_ROQ_PQ_BUSY__SHIFT                                                              0x1b
#define CP_CPF_BUSY_STAT__HQD_ROQ_IB_BUSY__SHIFT                                                              0x1c
#define CP_CPF_BUSY_STAT__HQD_WPTR_POLL_BUSY__SHIFT                                                           0x1d
#define CP_CPF_BUSY_STAT__HQD_PQ_BUSY__SHIFT                                                                  0x1e
#define CP_CPF_BUSY_STAT__HQD_IB_BUSY__SHIFT                                                                  0x1f
#define CP_CPF_BUSY_STAT__REG_BUS_FIFO_BUSY_MASK                                                              0x00000001L
#define CP_CPF_BUSY_STAT__CSF_RING_BUSY_MASK                                                                  0x00000002L
#define CP_CPF_BUSY_STAT__CSF_INDIRECT1_BUSY_MASK                                                             0x00000004L
#define CP_CPF_BUSY_STAT__CSF_INDIRECT2_BUSY_MASK                                                             0x00000008L
#define CP_CPF_BUSY_STAT__CSF_STATE_BUSY_MASK                                                                 0x00000010L
#define CP_CPF_BUSY_STAT__CSF_CE_INDR1_BUSY_MASK                                                              0x00000020L
#define CP_CPF_BUSY_STAT__CSF_CE_INDR2_BUSY_MASK                                                              0x00000040L
#define CP_CPF_BUSY_STAT__CSF_ARBITER_BUSY_MASK                                                               0x00000080L
#define CP_CPF_BUSY_STAT__CSF_INPUT_BUSY_MASK                                                                 0x00000100L
#define CP_CPF_BUSY_STAT__CSF_DATA_BUSY_MASK                                                                  0x00000200L
#define CP_CPF_BUSY_STAT__CSF_CE_DATA_BUSY_MASK                                                               0x00000400L
#define CP_CPF_BUSY_STAT__HPD_PROCESSING_EOP_BUSY_MASK                                                        0x00000800L
#define CP_CPF_BUSY_STAT__HQD_DISPATCH_BUSY_MASK                                                              0x00001000L
#define CP_CPF_BUSY_STAT__HQD_IQ_TIMER_BUSY_MASK                                                              0x00002000L
#define CP_CPF_BUSY_STAT__HQD_DMA_OFFLOAD_BUSY_MASK                                                           0x00004000L
#define CP_CPF_BUSY_STAT__HQD_MESSAGE_BUSY_MASK                                                               0x00020000L
#define CP_CPF_BUSY_STAT__HQD_PQ_FETCHER_BUSY_MASK                                                            0x00040000L
#define CP_CPF_BUSY_STAT__HQD_IB_FETCHER_BUSY_MASK                                                            0x00080000L
#define CP_CPF_BUSY_STAT__HQD_IQ_FETCHER_BUSY_MASK                                                            0x00100000L
#define CP_CPF_BUSY_STAT__HQD_EOP_FETCHER_BUSY_MASK                                                           0x00200000L
#define CP_CPF_BUSY_STAT__HQD_CONSUMED_RPTR_BUSY_MASK                                                         0x00400000L
#define CP_CPF_BUSY_STAT__HQD_FETCHER_ARB_BUSY_MASK                                                           0x00800000L
#define CP_CPF_BUSY_STAT__HQD_ROQ_ALIGN_BUSY_MASK                                                             0x01000000L
#define CP_CPF_BUSY_STAT__HQD_ROQ_EOP_BUSY_MASK                                                               0x02000000L
#define CP_CPF_BUSY_STAT__HQD_ROQ_IQ_BUSY_MASK                                                                0x04000000L
#define CP_CPF_BUSY_STAT__HQD_ROQ_PQ_BUSY_MASK                                                                0x08000000L
#define CP_CPF_BUSY_STAT__HQD_ROQ_IB_BUSY_MASK                                                                0x10000000L
#define CP_CPF_BUSY_STAT__HQD_WPTR_POLL_BUSY_MASK                                                             0x20000000L
#define CP_CPF_BUSY_STAT__HQD_PQ_BUSY_MASK                                                                    0x40000000L
#define CP_CPF_BUSY_STAT__HQD_IB_BUSY_MASK                                                                    0x80000000L
//CP_CPF_STALLED_STAT1
#define CP_CPF_STALLED_STAT1__RING_FETCHING_DATA__SHIFT                                                       0x0
#define CP_CPF_STALLED_STAT1__INDR1_FETCHING_DATA__SHIFT                                                      0x1
#define CP_CPF_STALLED_STAT1__INDR2_FETCHING_DATA__SHIFT                                                      0x2
#define CP_CPF_STALLED_STAT1__STATE_FETCHING_DATA__SHIFT                                                      0x3
#define CP_CPF_STALLED_STAT1__TCIU_WAITING_ON_FREE__SHIFT                                                     0x5
#define CP_CPF_STALLED_STAT1__TCIU_WAITING_ON_TAGS__SHIFT                                                     0x6
#define CP_CPF_STALLED_STAT1__UTCL2IU_WAITING_ON_FREE__SHIFT                                                  0x7
#define CP_CPF_STALLED_STAT1__UTCL2IU_WAITING_ON_TAGS__SHIFT                                                  0x8
#define CP_CPF_STALLED_STAT1__GFX_UTCL1_WAITING_ON_TRANS__SHIFT                                               0x9
#define CP_CPF_STALLED_STAT1__CMP_UTCL1_WAITING_ON_TRANS__SHIFT                                               0xa
#define CP_CPF_STALLED_STAT1__RCIU_WAITING_ON_FREE__SHIFT                                                     0xb
#define CP_CPF_STALLED_STAT1__DATA_FETCHING_DATA__SHIFT                                                       0xc
#define CP_CPF_STALLED_STAT1__GCRIU_WAIT_ON_FREE__SHIFT                                                       0xd
#define CP_CPF_STALLED_STAT1__RING_FETCHING_DATA_MASK                                                         0x00000001L
#define CP_CPF_STALLED_STAT1__INDR1_FETCHING_DATA_MASK                                                        0x00000002L
#define CP_CPF_STALLED_STAT1__INDR2_FETCHING_DATA_MASK                                                        0x00000004L
#define CP_CPF_STALLED_STAT1__STATE_FETCHING_DATA_MASK                                                        0x00000008L
#define CP_CPF_STALLED_STAT1__TCIU_WAITING_ON_FREE_MASK                                                       0x00000020L
#define CP_CPF_STALLED_STAT1__TCIU_WAITING_ON_TAGS_MASK                                                       0x00000040L
#define CP_CPF_STALLED_STAT1__UTCL2IU_WAITING_ON_FREE_MASK                                                    0x00000080L
#define CP_CPF_STALLED_STAT1__UTCL2IU_WAITING_ON_TAGS_MASK                                                    0x00000100L
#define CP_CPF_STALLED_STAT1__GFX_UTCL1_WAITING_ON_TRANS_MASK                                                 0x00000200L
#define CP_CPF_STALLED_STAT1__CMP_UTCL1_WAITING_ON_TRANS_MASK                                                 0x00000400L
#define CP_CPF_STALLED_STAT1__RCIU_WAITING_ON_FREE_MASK                                                       0x00000800L
#define CP_CPF_STALLED_STAT1__DATA_FETCHING_DATA_MASK                                                         0x00001000L
#define CP_CPF_STALLED_STAT1__GCRIU_WAIT_ON_FREE_MASK                                                         0x00002000L
//CP_CPC_BUSY_STAT2
#define CP_CPC_BUSY_STAT2__MES_LOAD_BUSY__SHIFT                                                               0x0
#define CP_CPC_BUSY_STAT2__MES_MUTEX_BUSY__SHIFT                                                              0x2
#define CP_CPC_BUSY_STAT2__MES_MESSAGE_BUSY__SHIFT                                                            0x3
#define CP_CPC_BUSY_STAT2__MES_TC_BUSY__SHIFT                                                                 0x7
#define CP_CPC_BUSY_STAT2__MES_DMA_BUSY__SHIFT                                                                0x8
#define CP_CPC_BUSY_STAT2__MES_PIPE0_BUSY__SHIFT                                                              0xa
#define CP_CPC_BUSY_STAT2__MES_PIPE1_BUSY__SHIFT                                                              0xb
#define CP_CPC_BUSY_STAT2__MES_PIPE2_BUSY__SHIFT                                                              0xc
#define CP_CPC_BUSY_STAT2__MES_PIPE3_BUSY__SHIFT                                                              0xd
#define CP_CPC_BUSY_STAT2__MES_PIPE0_DC_BUSY__SHIFT                                                           0xe
#define CP_CPC_BUSY_STAT2__MES_PIPE1_DC_BUSY__SHIFT                                                           0xf
#define CP_CPC_BUSY_STAT2__MES_PIPE2_DC_BUSY__SHIFT                                                           0x10
#define CP_CPC_BUSY_STAT2__MES_PIPE3_DC_BUSY__SHIFT                                                           0x11
#define CP_CPC_BUSY_STAT2__MEC1_PIPE0_DC_BUSY__SHIFT                                                          0x12
#define CP_CPC_BUSY_STAT2__MEC1_PIPE1_DC_BUSY__SHIFT                                                          0x13
#define CP_CPC_BUSY_STAT2__MEC1_PIPE2_DC_BUSY__SHIFT                                                          0x14
#define CP_CPC_BUSY_STAT2__MEC1_PIPE3_DC_BUSY__SHIFT                                                          0x15
#define CP_CPC_BUSY_STAT2__MES_LOAD_BUSY_MASK                                                                 0x00000001L
#define CP_CPC_BUSY_STAT2__MES_MUTEX_BUSY_MASK                                                                0x00000004L
#define CP_CPC_BUSY_STAT2__MES_MESSAGE_BUSY_MASK                                                              0x00000008L
#define CP_CPC_BUSY_STAT2__MES_TC_BUSY_MASK                                                                   0x00000080L
#define CP_CPC_BUSY_STAT2__MES_DMA_BUSY_MASK                                                                  0x00000100L
#define CP_CPC_BUSY_STAT2__MES_PIPE0_BUSY_MASK                                                                0x00000400L
#define CP_CPC_BUSY_STAT2__MES_PIPE1_BUSY_MASK                                                                0x00000800L
#define CP_CPC_BUSY_STAT2__MES_PIPE2_BUSY_MASK                                                                0x00001000L
#define CP_CPC_BUSY_STAT2__MES_PIPE3_BUSY_MASK                                                                0x00002000L
#define CP_CPC_BUSY_STAT2__MES_PIPE0_DC_BUSY_MASK                                                             0x00004000L
#define CP_CPC_BUSY_STAT2__MES_PIPE1_DC_BUSY_MASK                                                             0x00008000L
#define CP_CPC_BUSY_STAT2__MES_PIPE2_DC_BUSY_MASK                                                             0x00010000L
#define CP_CPC_BUSY_STAT2__MES_PIPE3_DC_BUSY_MASK                                                             0x00020000L
#define CP_CPC_BUSY_STAT2__MEC1_PIPE0_DC_BUSY_MASK                                                            0x00040000L
#define CP_CPC_BUSY_STAT2__MEC1_PIPE1_DC_BUSY_MASK                                                            0x00080000L
#define CP_CPC_BUSY_STAT2__MEC1_PIPE2_DC_BUSY_MASK                                                            0x00100000L
#define CP_CPC_BUSY_STAT2__MEC1_PIPE3_DC_BUSY_MASK                                                            0x00200000L
//CP_CPC_GRBM_FREE_COUNT
#define CP_CPC_GRBM_FREE_COUNT__FREE_COUNT__SHIFT                                                             0x0
#define CP_CPC_GRBM_FREE_COUNT__FREE_COUNT_MASK                                                               0x0000003FL
//CP_CPC_PRIV_VIOLATION_ADDR
#define CP_CPC_PRIV_VIOLATION_ADDR__PRIV_VIOLATION_STATUS__SHIFT                                              0x0
#define CP_CPC_PRIV_VIOLATION_ADDR__PRIV_VIOLATION_OP__SHIFT                                                  0x1
#define CP_CPC_PRIV_VIOLATION_ADDR__PRIV_VIOLATION_ADDR__SHIFT                                                0x2
#define CP_CPC_PRIV_VIOLATION_ADDR__PRIV_VIOLATION_STATUS_MASK                                                0x00000001L
#define CP_CPC_PRIV_VIOLATION_ADDR__PRIV_VIOLATION_OP_MASK                                                    0x00000002L
#define CP_CPC_PRIV_VIOLATION_ADDR__PRIV_VIOLATION_ADDR_MASK                                                  0xFFFFFFFCL
//CP_CPC_PRIV_VIOLATION_ADDR_HI
#define CP_CPC_PRIV_VIOLATION_ADDR_HI__PRIV_VIOLATION_ADDR__SHIFT                                             0x0
#define CP_CPC_PRIV_VIOLATION_ADDR_HI__PRIV_VIOLATION_ADDR_MASK                                               0x000000FFL
//CP_MEC_ME1_HEADER_DUMP
#define CP_MEC_ME1_HEADER_DUMP__HEADER_DUMP__SHIFT                                                            0x0
#define CP_MEC_ME1_HEADER_DUMP__HEADER_DUMP_MASK                                                              0xFFFFFFFFL
//CP_CPC_SCRATCH_INDEX
#define CP_CPC_SCRATCH_INDEX__SCRATCH_INDEX__SHIFT                                                            0x0
#define CP_CPC_SCRATCH_INDEX__SCRATCH_INDEX_64BIT_MODE__SHIFT                                                 0x1f
#define CP_CPC_SCRATCH_INDEX__SCRATCH_INDEX_MASK                                                              0x000001FFL
#define CP_CPC_SCRATCH_INDEX__SCRATCH_INDEX_64BIT_MODE_MASK                                                   0x80000000L
//CP_CPC_SCRATCH_DATA
#define CP_CPC_SCRATCH_DATA__SCRATCH_DATA__SHIFT                                                              0x0
#define CP_CPC_SCRATCH_DATA__SCRATCH_DATA_MASK                                                                0xFFFFFFFFL
//CP_CPF_GRBM_FREE_COUNT
#define CP_CPF_GRBM_FREE_COUNT__FREE_COUNT__SHIFT                                                             0x0
#define CP_CPF_GRBM_FREE_COUNT__FREE_COUNT_MASK                                                               0x00000007L
//CP_CPF_BUSY_STAT2
#define CP_CPF_BUSY_STAT2__CP_SDMA_CPG_BUSY__SHIFT                                                            0x0
#define CP_CPF_BUSY_STAT2__CP_SDMA_CPC_BUSY__SHIFT                                                            0x1
#define CP_CPF_BUSY_STAT2__MES_HQD_DISPATCH_BUSY__SHIFT                                                       0xc
#define CP_CPF_BUSY_STAT2__MES_HQD_DMA_OFFLOAD_BUSY__SHIFT                                                    0xe
#define CP_CPF_BUSY_STAT2__MES_HQD_MESSAGE_BUSY__SHIFT                                                        0x11
#define CP_CPF_BUSY_STAT2__MES_HQD_PQ_FETCHER_BUSY__SHIFT                                                     0x12
#define CP_CPF_BUSY_STAT2__MES_HQD_CONSUMED_RPTR_BUSY__SHIFT                                                  0x16
#define CP_CPF_BUSY_STAT2__MES_HQD_FETCHER_ARB_BUSY__SHIFT                                                    0x17
#define CP_CPF_BUSY_STAT2__MES_HQD_ROQ_ALIGN_BUSY__SHIFT                                                      0x18
#define CP_CPF_BUSY_STAT2__MES_HQD_ROQ_PQ_BUSY__SHIFT                                                         0x1b
#define CP_CPF_BUSY_STAT2__MES_HQD_PQ_BUSY__SHIFT                                                             0x1e
#define CP_CPF_BUSY_STAT2__MES_UNMAPPED_DOORBELL_BUSY__SHIFT                                                  0x1f
#define CP_CPF_BUSY_STAT2__CP_SDMA_CPG_BUSY_MASK                                                              0x00000001L
#define CP_CPF_BUSY_STAT2__CP_SDMA_CPC_BUSY_MASK                                                              0x00000002L
#define CP_CPF_BUSY_STAT2__MES_HQD_DISPATCH_BUSY_MASK                                                         0x00001000L
#define CP_CPF_BUSY_STAT2__MES_HQD_DMA_OFFLOAD_BUSY_MASK                                                      0x00004000L
#define CP_CPF_BUSY_STAT2__MES_HQD_MESSAGE_BUSY_MASK                                                          0x00020000L
#define CP_CPF_BUSY_STAT2__MES_HQD_PQ_FETCHER_BUSY_MASK                                                       0x00040000L
#define CP_CPF_BUSY_STAT2__MES_HQD_CONSUMED_RPTR_BUSY_MASK                                                    0x00400000L
#define CP_CPF_BUSY_STAT2__MES_HQD_FETCHER_ARB_BUSY_MASK                                                      0x00800000L
#define CP_CPF_BUSY_STAT2__MES_HQD_ROQ_ALIGN_BUSY_MASK                                                        0x01000000L
#define CP_CPF_BUSY_STAT2__MES_HQD_ROQ_PQ_BUSY_MASK                                                           0x08000000L
#define CP_CPF_BUSY_STAT2__MES_HQD_PQ_BUSY_MASK                                                               0x40000000L
#define CP_CPF_BUSY_STAT2__MES_UNMAPPED_DOORBELL_BUSY_MASK                                                    0x80000000L
//CP_CPC_HALT_HYST_COUNT
#define CP_CPC_HALT_HYST_COUNT__COUNT__SHIFT                                                                  0x0
#define CP_CPC_HALT_HYST_COUNT__COUNT_MASK                                                                    0x0000000FL
//CP_STALLED_STAT3
#define CP_STALLED_STAT3__CE_TO_CSF_NOT_RDY_TO_RCV__SHIFT                                                     0x0
#define CP_STALLED_STAT3__CE_TO_RAM_INIT_FETCHER_NOT_RDY_TO_RCV__SHIFT                                        0x1
#define CP_STALLED_STAT3__CE_WAITING_ON_DATA_FROM_RAM_INIT_FETCHER__SHIFT                                     0x2
#define CP_STALLED_STAT3__CE_TO_RAM_INIT_NOT_RDY__SHIFT                                                       0x3
#define CP_STALLED_STAT3__CE_TO_RAM_DUMP_NOT_RDY__SHIFT                                                       0x4
#define CP_STALLED_STAT3__CE_TO_RAM_WRITE_NOT_RDY__SHIFT                                                      0x5
#define CP_STALLED_STAT3__CE_TO_INC_FIFO_NOT_RDY_TO_RCV__SHIFT                                                0x6
#define CP_STALLED_STAT3__CE_TO_WR_FIFO_NOT_RDY_TO_RCV__SHIFT                                                 0x7
#define CP_STALLED_STAT3__CE_WAITING_ON_BUFFER_DATA__SHIFT                                                    0xa
#define CP_STALLED_STAT3__CE_WAITING_ON_CE_BUFFER_FLAG__SHIFT                                                 0xb
#define CP_STALLED_STAT3__CE_WAITING_ON_DE_COUNTER__SHIFT                                                     0xc
#define CP_STALLED_STAT3__CE_WAITING_ON_DE_COUNTER_UNDERFLOW__SHIFT                                           0xd
#define CP_STALLED_STAT3__TCIU_WAITING_ON_FREE__SHIFT                                                         0xe
#define CP_STALLED_STAT3__TCIU_WAITING_ON_TAGS__SHIFT                                                         0xf
#define CP_STALLED_STAT3__CE_STALLED_ON_TC_WR_CONFIRM__SHIFT                                                  0x10
#define CP_STALLED_STAT3__CE_STALLED_ON_ATOMIC_RTN_DATA__SHIFT                                                0x11
#define CP_STALLED_STAT3__UTCL2IU_WAITING_ON_FREE__SHIFT                                                      0x12
#define CP_STALLED_STAT3__UTCL2IU_WAITING_ON_TAGS__SHIFT                                                      0x13
#define CP_STALLED_STAT3__UTCL1_WAITING_ON_TRANS__SHIFT                                                       0x14
#define CP_STALLED_STAT3__GCRIU_WAITING_ON_FREE__SHIFT                                                        0x15
#define CP_STALLED_STAT3__CE_TO_CSF_NOT_RDY_TO_RCV_MASK                                                       0x00000001L
#define CP_STALLED_STAT3__CE_TO_RAM_INIT_FETCHER_NOT_RDY_TO_RCV_MASK                                          0x00000002L
#define CP_STALLED_STAT3__CE_WAITING_ON_DATA_FROM_RAM_INIT_FETCHER_MASK                                       0x00000004L
#define CP_STALLED_STAT3__CE_TO_RAM_INIT_NOT_RDY_MASK                                                         0x00000008L
#define CP_STALLED_STAT3__CE_TO_RAM_DUMP_NOT_RDY_MASK                                                         0x00000010L
#define CP_STALLED_STAT3__CE_TO_RAM_WRITE_NOT_RDY_MASK                                                        0x00000020L
#define CP_STALLED_STAT3__CE_TO_INC_FIFO_NOT_RDY_TO_RCV_MASK                                                  0x00000040L
#define CP_STALLED_STAT3__CE_TO_WR_FIFO_NOT_RDY_TO_RCV_MASK                                                   0x00000080L
#define CP_STALLED_STAT3__CE_WAITING_ON_BUFFER_DATA_MASK                                                      0x00000400L
#define CP_STALLED_STAT3__CE_WAITING_ON_CE_BUFFER_FLAG_MASK                                                   0x00000800L
#define CP_STALLED_STAT3__CE_WAITING_ON_DE_COUNTER_MASK                                                       0x00001000L
#define CP_STALLED_STAT3__CE_WAITING_ON_DE_COUNTER_UNDERFLOW_MASK                                             0x00002000L
#define CP_STALLED_STAT3__TCIU_WAITING_ON_FREE_MASK                                                           0x00004000L
#define CP_STALLED_STAT3__TCIU_WAITING_ON_TAGS_MASK                                                           0x00008000L
#define CP_STALLED_STAT3__CE_STALLED_ON_TC_WR_CONFIRM_MASK                                                    0x00010000L
#define CP_STALLED_STAT3__CE_STALLED_ON_ATOMIC_RTN_DATA_MASK                                                  0x00020000L
#define CP_STALLED_STAT3__UTCL2IU_WAITING_ON_FREE_MASK                                                        0x00040000L
#define CP_STALLED_STAT3__UTCL2IU_WAITING_ON_TAGS_MASK                                                        0x00080000L
#define CP_STALLED_STAT3__UTCL1_WAITING_ON_TRANS_MASK                                                         0x00100000L
#define CP_STALLED_STAT3__GCRIU_WAITING_ON_FREE_MASK                                                          0x00200000L
//CP_STALLED_STAT1
#define CP_STALLED_STAT1__RBIU_TO_DMA_NOT_RDY_TO_RCV__SHIFT                                                   0x0
#define CP_STALLED_STAT1__RBIU_TO_MEMWR_NOT_RDY_TO_RCV_R0__SHIFT                                              0x4
#define CP_STALLED_STAT1__RBIU_TO_MEMWR_NOT_RDY_TO_RCV_R1__SHIFT                                              0x5
#define CP_STALLED_STAT1__ME_HAS_ACTIVE_CE_BUFFER_FLAG__SHIFT                                                 0xa
#define CP_STALLED_STAT1__ME_HAS_ACTIVE_DE_BUFFER_FLAG__SHIFT                                                 0xb
#define CP_STALLED_STAT1__ME_STALLED_ON_TC_WR_CONFIRM__SHIFT                                                  0xc
#define CP_STALLED_STAT1__ME_STALLED_ON_ATOMIC_RTN_DATA__SHIFT                                                0xd
#define CP_STALLED_STAT1__ME_WAITING_ON_TC_READ_DATA__SHIFT                                                   0xe
#define CP_STALLED_STAT1__ME_WAITING_ON_REG_READ_DATA__SHIFT                                                  0xf
#define CP_STALLED_STAT1__RCIU_WAITING_ON_GDS_FREE__SHIFT                                                     0x17
#define CP_STALLED_STAT1__RCIU_WAITING_ON_GRBM_FREE__SHIFT                                                    0x18
#define CP_STALLED_STAT1__RCIU_WAITING_ON_VGT_FREE__SHIFT                                                     0x19
#define CP_STALLED_STAT1__RCIU_STALLED_ON_ME_READ__SHIFT                                                      0x1a
#define CP_STALLED_STAT1__RCIU_STALLED_ON_DMA_READ__SHIFT                                                     0x1b
#define CP_STALLED_STAT1__RCIU_STALLED_ON_APPEND_READ__SHIFT                                                  0x1c
#define CP_STALLED_STAT1__RCIU_HALTED_BY_REG_VIOLATION__SHIFT                                                 0x1d
#define CP_STALLED_STAT1__RBIU_TO_DMA_NOT_RDY_TO_RCV_MASK                                                     0x00000001L
#define CP_STALLED_STAT1__RBIU_TO_MEMWR_NOT_RDY_TO_RCV_R0_MASK                                                0x00000010L
#define CP_STALLED_STAT1__RBIU_TO_MEMWR_NOT_RDY_TO_RCV_R1_MASK                                                0x00000020L
#define CP_STALLED_STAT1__ME_HAS_ACTIVE_CE_BUFFER_FLAG_MASK                                                   0x00000400L
#define CP_STALLED_STAT1__ME_HAS_ACTIVE_DE_BUFFER_FLAG_MASK                                                   0x00000800L
#define CP_STALLED_STAT1__ME_STALLED_ON_TC_WR_CONFIRM_MASK                                                    0x00001000L
#define CP_STALLED_STAT1__ME_STALLED_ON_ATOMIC_RTN_DATA_MASK                                                  0x00002000L
#define CP_STALLED_STAT1__ME_WAITING_ON_TC_READ_DATA_MASK                                                     0x00004000L
#define CP_STALLED_STAT1__ME_WAITING_ON_REG_READ_DATA_MASK                                                    0x00008000L
#define CP_STALLED_STAT1__RCIU_WAITING_ON_GDS_FREE_MASK                                                       0x00800000L
#define CP_STALLED_STAT1__RCIU_WAITING_ON_GRBM_FREE_MASK                                                      0x01000000L
#define CP_STALLED_STAT1__RCIU_WAITING_ON_VGT_FREE_MASK                                                       0x02000000L
#define CP_STALLED_STAT1__RCIU_STALLED_ON_ME_READ_MASK                                                        0x04000000L
#define CP_STALLED_STAT1__RCIU_STALLED_ON_DMA_READ_MASK                                                       0x08000000L
#define CP_STALLED_STAT1__RCIU_STALLED_ON_APPEND_READ_MASK                                                    0x10000000L
#define CP_STALLED_STAT1__RCIU_HALTED_BY_REG_VIOLATION_MASK                                                   0x20000000L
//CP_STALLED_STAT2
#define CP_STALLED_STAT2__PFP_TO_CSF_NOT_RDY_TO_RCV__SHIFT                                                    0x0
#define CP_STALLED_STAT2__PFP_TO_MEQ_NOT_RDY_TO_RCV__SHIFT                                                    0x1
#define CP_STALLED_STAT2__PFP_TO_RCIU_NOT_RDY_TO_RCV__SHIFT                                                   0x2
#define CP_STALLED_STAT2__PFP_TO_VGT_WRITES_PENDING__SHIFT                                                    0x4
#define CP_STALLED_STAT2__PFP_RCIU_READ_PENDING__SHIFT                                                        0x5
#define CP_STALLED_STAT2__PFP_TO_MEQ_DDID_NOT_RDY_TO_RCV__SHIFT                                               0x6
#define CP_STALLED_STAT2__PFP_WAITING_ON_BUFFER_DATA__SHIFT                                                   0x8
#define CP_STALLED_STAT2__ME_WAIT_ON_CE_COUNTER__SHIFT                                                        0x9
#define CP_STALLED_STAT2__ME_WAIT_ON_AVAIL_BUFFER__SHIFT                                                      0xa
#define CP_STALLED_STAT2__GFX_CNTX_NOT_AVAIL_TO_ME__SHIFT                                                     0xb
#define CP_STALLED_STAT2__ME_RCIU_NOT_RDY_TO_RCV__SHIFT                                                       0xc
#define CP_STALLED_STAT2__ME_TO_CONST_NOT_RDY_TO_RCV__SHIFT                                                   0xd
#define CP_STALLED_STAT2__ME_WAITING_DATA_FROM_PFP__SHIFT                                                     0xe
#define CP_STALLED_STAT2__ME_WAITING_ON_PARTIAL_FLUSH__SHIFT                                                  0xf
#define CP_STALLED_STAT2__MEQ_TO_ME_NOT_RDY_TO_RCV__SHIFT                                                     0x10
#define CP_STALLED_STAT2__STQ_TO_ME_NOT_RDY_TO_RCV__SHIFT                                                     0x11
#define CP_STALLED_STAT2__ME_WAITING_DATA_FROM_STQ__SHIFT                                                     0x12
#define CP_STALLED_STAT2__PFP_STALLED_ON_TC_WR_CONFIRM__SHIFT                                                 0x13
#define CP_STALLED_STAT2__PFP_STALLED_ON_ATOMIC_RTN_DATA__SHIFT                                               0x14
#define CP_STALLED_STAT2__QU_STALLED_ON_EOP_DONE_PULSE__SHIFT                                                 0x15
#define CP_STALLED_STAT2__QU_STALLED_ON_EOP_DONE_WR_CONFIRM__SHIFT                                            0x16
#define CP_STALLED_STAT2__STRMO_WR_OF_PRIM_DATA_PENDING__SHIFT                                                0x17
#define CP_STALLED_STAT2__PIPE_STATS_WR_DATA_PENDING__SHIFT                                                   0x18
#define CP_STALLED_STAT2__APPEND_RDY_WAIT_ON_CS_DONE__SHIFT                                                   0x19
#define CP_STALLED_STAT2__APPEND_RDY_WAIT_ON_PS_DONE__SHIFT                                                   0x1a
#define CP_STALLED_STAT2__APPEND_WAIT_ON_WR_CONFIRM__SHIFT                                                    0x1b
#define CP_STALLED_STAT2__APPEND_ACTIVE_PARTITION__SHIFT                                                      0x1c
#define CP_STALLED_STAT2__APPEND_WAITING_TO_SEND_MEMWRITE__SHIFT                                              0x1d
#define CP_STALLED_STAT2__SURF_SYNC_NEEDS_IDLE_CNTXS__SHIFT                                                   0x1e
#define CP_STALLED_STAT2__SURF_SYNC_NEEDS_ALL_CLEAN__SHIFT                                                    0x1f
#define CP_STALLED_STAT2__PFP_TO_CSF_NOT_RDY_TO_RCV_MASK                                                      0x00000001L
#define CP_STALLED_STAT2__PFP_TO_MEQ_NOT_RDY_TO_RCV_MASK                                                      0x00000002L
#define CP_STALLED_STAT2__PFP_TO_RCIU_NOT_RDY_TO_RCV_MASK                                                     0x00000004L
#define CP_STALLED_STAT2__PFP_TO_VGT_WRITES_PENDING_MASK                                                      0x00000010L
#define CP_STALLED_STAT2__PFP_RCIU_READ_PENDING_MASK                                                          0x00000020L
#define CP_STALLED_STAT2__PFP_TO_MEQ_DDID_NOT_RDY_TO_RCV_MASK                                                 0x00000040L
#define CP_STALLED_STAT2__PFP_WAITING_ON_BUFFER_DATA_MASK                                                     0x00000100L
#define CP_STALLED_STAT2__ME_WAIT_ON_CE_COUNTER_MASK                                                          0x00000200L
#define CP_STALLED_STAT2__ME_WAIT_ON_AVAIL_BUFFER_MASK                                                        0x00000400L
#define CP_STALLED_STAT2__GFX_CNTX_NOT_AVAIL_TO_ME_MASK                                                       0x00000800L
#define CP_STALLED_STAT2__ME_RCIU_NOT_RDY_TO_RCV_MASK                                                         0x00001000L
#define CP_STALLED_STAT2__ME_TO_CONST_NOT_RDY_TO_RCV_MASK                                                     0x00002000L
#define CP_STALLED_STAT2__ME_WAITING_DATA_FROM_PFP_MASK                                                       0x00004000L
#define CP_STALLED_STAT2__ME_WAITING_ON_PARTIAL_FLUSH_MASK                                                    0x00008000L
#define CP_STALLED_STAT2__MEQ_TO_ME_NOT_RDY_TO_RCV_MASK                                                       0x00010000L
#define CP_STALLED_STAT2__STQ_TO_ME_NOT_RDY_TO_RCV_MASK                                                       0x00020000L
#define CP_STALLED_STAT2__ME_WAITING_DATA_FROM_STQ_MASK                                                       0x00040000L
#define CP_STALLED_STAT2__PFP_STALLED_ON_TC_WR_CONFIRM_MASK                                                   0x00080000L
#define CP_STALLED_STAT2__PFP_STALLED_ON_ATOMIC_RTN_DATA_MASK                                                 0x00100000L
#define CP_STALLED_STAT2__QU_STALLED_ON_EOP_DONE_PULSE_MASK                                                   0x00200000L
#define CP_STALLED_STAT2__QU_STALLED_ON_EOP_DONE_WR_CONFIRM_MASK                                              0x00400000L
#define CP_STALLED_STAT2__STRMO_WR_OF_PRIM_DATA_PENDING_MASK                                                  0x00800000L
#define CP_STALLED_STAT2__PIPE_STATS_WR_DATA_PENDING_MASK                                                     0x01000000L
#define CP_STALLED_STAT2__APPEND_RDY_WAIT_ON_CS_DONE_MASK                                                     0x02000000L
#define CP_STALLED_STAT2__APPEND_RDY_WAIT_ON_PS_DONE_MASK                                                     0x04000000L
#define CP_STALLED_STAT2__APPEND_WAIT_ON_WR_CONFIRM_MASK                                                      0x08000000L
#define CP_STALLED_STAT2__APPEND_ACTIVE_PARTITION_MASK                                                        0x10000000L
#define CP_STALLED_STAT2__APPEND_WAITING_TO_SEND_MEMWRITE_MASK                                                0x20000000L
#define CP_STALLED_STAT2__SURF_SYNC_NEEDS_IDLE_CNTXS_MASK                                                     0x40000000L
#define CP_STALLED_STAT2__SURF_SYNC_NEEDS_ALL_CLEAN_MASK                                                      0x80000000L
//CP_BUSY_STAT
#define CP_BUSY_STAT__REG_BUS_FIFO_BUSY__SHIFT                                                                0x0
#define CP_BUSY_STAT__PFP_DATA_CACHE_BUSY__SHIFT                                                              0x1
#define CP_BUSY_STAT__ME_DATA_CACHE_BUSY__SHIFT                                                               0x2
#define CP_BUSY_STAT__COHER_CNT_NEQ_ZERO__SHIFT                                                               0x6
#define CP_BUSY_STAT__PFP_PARSING_PACKETS__SHIFT                                                              0x7
#define CP_BUSY_STAT__ME_PARSING_PACKETS__SHIFT                                                               0x8
#define CP_BUSY_STAT__RCIU_PFP_BUSY__SHIFT                                                                    0x9
#define CP_BUSY_STAT__RCIU_ME_BUSY__SHIFT                                                                     0xa
#define CP_BUSY_STAT__GFX_CONTEXT_BUSY__SHIFT                                                                 0xf
#define CP_BUSY_STAT__ME_PARSER_BUSY__SHIFT                                                                   0x11
#define CP_BUSY_STAT__EOP_DONE_BUSY__SHIFT                                                                    0x12
#define CP_BUSY_STAT__STRM_OUT_BUSY__SHIFT                                                                    0x13
#define CP_BUSY_STAT__PIPE_STATS_BUSY__SHIFT                                                                  0x14
#define CP_BUSY_STAT__RCIU_CE_BUSY__SHIFT                                                                     0x15
#define CP_BUSY_STAT__CE_PARSING_PACKETS__SHIFT                                                               0x16
#define CP_BUSY_STAT__PFP_PIPE0_DC_BUSY__SHIFT                                                                0x17
#define CP_BUSY_STAT__ME_PIPE0_DC_BUSY__SHIFT                                                                 0x18
#define CP_BUSY_STAT__PFP_PIPE1_DC_BUSY__SHIFT                                                                0x19
#define CP_BUSY_STAT__ME_PIPE1_DC_BUSY__SHIFT                                                                 0x1a
#define CP_BUSY_STAT__REG_BUS_FIFO_BUSY_MASK                                                                  0x00000001L
#define CP_BUSY_STAT__PFP_DATA_CACHE_BUSY_MASK                                                                0x00000002L
#define CP_BUSY_STAT__ME_DATA_CACHE_BUSY_MASK                                                                 0x00000004L
#define CP_BUSY_STAT__COHER_CNT_NEQ_ZERO_MASK                                                                 0x00000040L
#define CP_BUSY_STAT__PFP_PARSING_PACKETS_MASK                                                                0x00000080L
#define CP_BUSY_STAT__ME_PARSING_PACKETS_MASK                                                                 0x00000100L
#define CP_BUSY_STAT__RCIU_PFP_BUSY_MASK                                                                      0x00000200L
#define CP_BUSY_STAT__RCIU_ME_BUSY_MASK                                                                       0x00000400L
#define CP_BUSY_STAT__GFX_CONTEXT_BUSY_MASK                                                                   0x00008000L
#define CP_BUSY_STAT__ME_PARSER_BUSY_MASK                                                                     0x00020000L
#define CP_BUSY_STAT__EOP_DONE_BUSY_MASK                                                                      0x00040000L
#define CP_BUSY_STAT__STRM_OUT_BUSY_MASK                                                                      0x00080000L
#define CP_BUSY_STAT__PIPE_STATS_BUSY_MASK                                                                    0x00100000L
#define CP_BUSY_STAT__RCIU_CE_BUSY_MASK                                                                       0x00200000L
#define CP_BUSY_STAT__CE_PARSING_PACKETS_MASK                                                                 0x00400000L
#define CP_BUSY_STAT__PFP_PIPE0_DC_BUSY_MASK                                                                  0x00800000L
#define CP_BUSY_STAT__ME_PIPE0_DC_BUSY_MASK                                                                   0x01000000L
#define CP_BUSY_STAT__PFP_PIPE1_DC_BUSY_MASK                                                                  0x02000000L
#define CP_BUSY_STAT__ME_PIPE1_DC_BUSY_MASK                                                                   0x04000000L
//CP_STAT
#define CP_STAT__ROQ_DB_BUSY__SHIFT                                                                           0x5
#define CP_STAT__ROQ_CE_DB_BUSY__SHIFT                                                                        0x6
#define CP_STAT__ROQ_RING_BUSY__SHIFT                                                                         0x9
#define CP_STAT__ROQ_INDIRECT1_BUSY__SHIFT                                                                    0xa
#define CP_STAT__ROQ_INDIRECT2_BUSY__SHIFT                                                                    0xb
#define CP_STAT__ROQ_STATE_BUSY__SHIFT                                                                        0xc
#define CP_STAT__DC_BUSY__SHIFT                                                                               0xd
#define CP_STAT__UTCL2IU_BUSY__SHIFT                                                                          0xe
#define CP_STAT__PFP_BUSY__SHIFT                                                                              0xf
#define CP_STAT__MEQ_BUSY__SHIFT                                                                              0x10
#define CP_STAT__ME_BUSY__SHIFT                                                                               0x11
#define CP_STAT__QUERY_BUSY__SHIFT                                                                            0x12
#define CP_STAT__INTERRUPT_BUSY__SHIFT                                                                        0x14
#define CP_STAT__SURFACE_SYNC_BUSY__SHIFT                                                                     0x15
#define CP_STAT__DMA_BUSY__SHIFT                                                                              0x16
#define CP_STAT__RCIU_BUSY__SHIFT                                                                             0x17
#define CP_STAT__SCRATCH_RAM_BUSY__SHIFT                                                                      0x18
#define CP_STAT__GCRIU_BUSY__SHIFT                                                                            0x19
#define CP_STAT__CE_BUSY__SHIFT                                                                               0x1a
#define CP_STAT__TCIU_BUSY__SHIFT                                                                             0x1b
#define CP_STAT__ROQ_CE_RING_BUSY__SHIFT                                                                      0x1c
#define CP_STAT__ROQ_CE_INDIRECT1_BUSY__SHIFT                                                                 0x1d
#define CP_STAT__ROQ_CE_INDIRECT2_BUSY__SHIFT                                                                 0x1e
#define CP_STAT__CP_BUSY__SHIFT                                                                               0x1f
#define CP_STAT__ROQ_DB_BUSY_MASK                                                                             0x00000020L
#define CP_STAT__ROQ_CE_DB_BUSY_MASK                                                                          0x00000040L
#define CP_STAT__ROQ_RING_BUSY_MASK                                                                           0x00000200L
#define CP_STAT__ROQ_INDIRECT1_BUSY_MASK                                                                      0x00000400L
#define CP_STAT__ROQ_INDIRECT2_BUSY_MASK                                                                      0x00000800L
#define CP_STAT__ROQ_STATE_BUSY_MASK                                                                          0x00001000L
#define CP_STAT__DC_BUSY_MASK                                                                                 0x00002000L
#define CP_STAT__UTCL2IU_BUSY_MASK                                                                            0x00004000L
#define CP_STAT__PFP_BUSY_MASK                                                                                0x00008000L
#define CP_STAT__MEQ_BUSY_MASK                                                                                0x00010000L
#define CP_STAT__ME_BUSY_MASK                                                                                 0x00020000L
#define CP_STAT__QUERY_BUSY_MASK                                                                              0x00040000L
#define CP_STAT__INTERRUPT_BUSY_MASK                                                                          0x00100000L
#define CP_STAT__SURFACE_SYNC_BUSY_MASK                                                                       0x00200000L
#define CP_STAT__DMA_BUSY_MASK                                                                                0x00400000L
#define CP_STAT__RCIU_BUSY_MASK                                                                               0x00800000L
#define CP_STAT__SCRATCH_RAM_BUSY_MASK                                                                        0x01000000L
#define CP_STAT__GCRIU_BUSY_MASK                                                                              0x02000000L
#define CP_STAT__CE_BUSY_MASK                                                                                 0x04000000L
#define CP_STAT__TCIU_BUSY_MASK                                                                               0x08000000L
#define CP_STAT__ROQ_CE_RING_BUSY_MASK                                                                        0x10000000L
#define CP_STAT__ROQ_CE_INDIRECT1_BUSY_MASK                                                                   0x20000000L
#define CP_STAT__ROQ_CE_INDIRECT2_BUSY_MASK                                                                   0x40000000L
#define CP_STAT__CP_BUSY_MASK                                                                                 0x80000000L
//CP_ME_HEADER_DUMP
#define CP_ME_HEADER_DUMP__ME_HEADER_DUMP__SHIFT                                                              0x0
#define CP_ME_HEADER_DUMP__ME_HEADER_DUMP_MASK                                                                0xFFFFFFFFL
//CP_PFP_HEADER_DUMP
#define CP_PFP_HEADER_DUMP__PFP_HEADER_DUMP__SHIFT                                                            0x0
#define CP_PFP_HEADER_DUMP__PFP_HEADER_DUMP_MASK                                                              0xFFFFFFFFL
//CP_GRBM_FREE_COUNT
#define CP_GRBM_FREE_COUNT__FREE_COUNT__SHIFT                                                                 0x0
#define CP_GRBM_FREE_COUNT__FREE_COUNT_PFP__SHIFT                                                             0x10
#define CP_GRBM_FREE_COUNT__FREE_COUNT_MASK                                                                   0x0000003FL
#define CP_GRBM_FREE_COUNT__FREE_COUNT_PFP_MASK                                                               0x003F0000L
//CP_PFP_INSTR_PNTR
#define CP_PFP_INSTR_PNTR__INSTR_PNTR__SHIFT                                                                  0x0
#define CP_PFP_INSTR_PNTR__INSTR_PNTR_MASK                                                                    0x0000FFFFL
//CP_ME_INSTR_PNTR
#define CP_ME_INSTR_PNTR__INSTR_PNTR__SHIFT                                                                   0x0
#define CP_ME_INSTR_PNTR__INSTR_PNTR_MASK                                                                     0x0000FFFFL
//CP_CSF_STAT
#define CP_CSF_STAT__BUFFER_REQUEST_COUNT__SHIFT                                                              0x8
#define CP_CSF_STAT__BUFFER_REQUEST_COUNT_MASK                                                                0x0001FF00L
//CP_CNTX_STAT
#define CP_CNTX_STAT__ACTIVE_HP3D_CONTEXTS__SHIFT                                                             0x0
#define CP_CNTX_STAT__CURRENT_HP3D_CONTEXT__SHIFT                                                             0x8
#define CP_CNTX_STAT__ACTIVE_GFX_CONTEXTS__SHIFT                                                              0x14
#define CP_CNTX_STAT__CURRENT_GFX_CONTEXT__SHIFT                                                              0x1c
#define CP_CNTX_STAT__ACTIVE_HP3D_CONTEXTS_MASK                                                               0x000000FFL
#define CP_CNTX_STAT__CURRENT_HP3D_CONTEXT_MASK                                                               0x00000700L
#define CP_CNTX_STAT__ACTIVE_GFX_CONTEXTS_MASK                                                                0x0FF00000L
#define CP_CNTX_STAT__CURRENT_GFX_CONTEXT_MASK                                                                0x70000000L
//CP_ME_PREEMPTION
#define CP_ME_PREEMPTION__OBSOLETE__SHIFT                                                                     0x0
#define CP_ME_PREEMPTION__OBSOLETE_MASK                                                                       0x00000001L
//CP_RB0_RPTR
#define CP_RB0_RPTR__RB_RPTR__SHIFT                                                                           0x0
#define CP_RB0_RPTR__RB_RPTR_MASK                                                                             0x000FFFFFL
//CP_RB_RPTR
#define CP_RB_RPTR__RB_RPTR__SHIFT                                                                            0x0
#define CP_RB_RPTR__RB_RPTR_MASK                                                                              0x000FFFFFL
//CP_RB_WPTR_DELAY
#define CP_RB_WPTR_DELAY__PRE_WRITE_TIMER__SHIFT                                                              0x0
#define CP_RB_WPTR_DELAY__PRE_WRITE_LIMIT__SHIFT                                                              0x1c
#define CP_RB_WPTR_DELAY__PRE_WRITE_TIMER_MASK                                                                0x0FFFFFFFL
#define CP_RB_WPTR_DELAY__PRE_WRITE_LIMIT_MASK                                                                0xF0000000L
//CP_RB_WPTR_POLL_CNTL
#define CP_RB_WPTR_POLL_CNTL__POLL_FREQUENCY__SHIFT                                                           0x0
#define CP_RB_WPTR_POLL_CNTL__IDLE_POLL_COUNT__SHIFT                                                          0x10
#define CP_RB_WPTR_POLL_CNTL__POLL_FREQUENCY_MASK                                                             0x0000FFFFUL
#define CP_RB_WPTR_POLL_CNTL__IDLE_POLL_COUNT_MASK                                                            0xFFFF0000UL
//CP_ROQ1_THRESHOLDS
#define CP_ROQ1_THRESHOLDS__RB1_START__SHIFT                                                                  0x0
#define CP_ROQ1_THRESHOLDS__R0_IB1_START__SHIFT                                                               0xa
#define CP_ROQ1_THRESHOLDS__R1_IB1_START__SHIFT                                                               0x14
#define CP_ROQ1_THRESHOLDS__RB1_START_MASK                                                                    0x000003FFL
#define CP_ROQ1_THRESHOLDS__R0_IB1_START_MASK                                                                 0x000FFC00L
#define CP_ROQ1_THRESHOLDS__R1_IB1_START_MASK                                                                 0x3FF00000L
//CP_ROQ2_THRESHOLDS
#define CP_ROQ2_THRESHOLDS__R0_IB2_START__SHIFT                                                               0x0
#define CP_ROQ2_THRESHOLDS__R1_IB2_START__SHIFT                                                               0xa
#define CP_ROQ2_THRESHOLDS__R0_IB2_START_MASK                                                                 0x000003FFL
#define CP_ROQ2_THRESHOLDS__R1_IB2_START_MASK                                                                 0x000FFC00L
//CP_STQ_THRESHOLDS
#define CP_STQ_THRESHOLDS__STQ0_START__SHIFT                                                                  0x0
#define CP_STQ_THRESHOLDS__STQ1_START__SHIFT                                                                  0x8
#define CP_STQ_THRESHOLDS__STQ2_START__SHIFT                                                                  0x10
#define CP_STQ_THRESHOLDS__STQ0_START_MASK                                                                    0x000000FFL
#define CP_STQ_THRESHOLDS__STQ1_START_MASK                                                                    0x0000FF00L
#define CP_STQ_THRESHOLDS__STQ2_START_MASK                                                                    0x00FF0000L
//CP_MEQ_THRESHOLDS
#define CP_MEQ_THRESHOLDS__MEQ1_START__SHIFT                                                                  0x0
#define CP_MEQ_THRESHOLDS__MEQ2_START__SHIFT                                                                  0x8
#define CP_MEQ_THRESHOLDS__MEQ1_START_MASK                                                                    0x000000FFL
#define CP_MEQ_THRESHOLDS__MEQ2_START_MASK                                                                    0x0000FF00L
//CP_ROQ_AVAIL
#define CP_ROQ_AVAIL__ROQ_CNT_RING__SHIFT                                                                     0x0
#define CP_ROQ_AVAIL__ROQ_CNT_IB1__SHIFT                                                                      0x10
#define CP_ROQ_AVAIL__ROQ_CNT_RING_MASK                                                                       0x00000FFFL
#define CP_ROQ_AVAIL__ROQ_CNT_IB1_MASK                                                                        0x0FFF0000L
//CP_STQ_AVAIL
#define CP_STQ_AVAIL__STQ_CNT__SHIFT                                                                          0x0
#define CP_STQ_AVAIL__STQ_CNT_MASK                                                                            0x000003FFL
//CP_ROQ2_AVAIL
#define CP_ROQ2_AVAIL__ROQ_CNT_IB2__SHIFT                                                                     0x0
#define CP_ROQ2_AVAIL__ROQ_CNT_DB__SHIFT                                                                      0x10
#define CP_ROQ2_AVAIL__ROQ_CNT_IB2_MASK                                                                       0x00000FFFL
#define CP_ROQ2_AVAIL__ROQ_CNT_DB_MASK                                                                        0x0FFF0000L
//CP_MEQ_AVAIL
#define CP_MEQ_AVAIL__MEQ_CNT__SHIFT                                                                          0x0
#define CP_MEQ_AVAIL__MEQ_CNT_MASK                                                                            0x000003FFL
//CP_CMD_INDEX
#define CP_CMD_INDEX__CMD_INDEX__SHIFT                                                                        0x0
#define CP_CMD_INDEX__CMD_ME_SEL__SHIFT                                                                       0xc
#define CP_CMD_INDEX__CMD_QUEUE_SEL__SHIFT                                                                    0x10
#define CP_CMD_INDEX__CMD_INDEX_MASK                                                                          0x000007FFL
#define CP_CMD_INDEX__CMD_ME_SEL_MASK                                                                         0x00003000L
#define CP_CMD_INDEX__CMD_QUEUE_SEL_MASK                                                                      0x00070000L
//CP_CMD_DATA
#define CP_CMD_DATA__CMD_DATA__SHIFT                                                                          0x0
#define CP_CMD_DATA__CMD_DATA_MASK                                                                            0xFFFFFFFFL
//CP_ROQ_RB_STAT
#define CP_ROQ_RB_STAT__ROQ_RPTR_PRIMARY__SHIFT                                                               0x0
#define CP_ROQ_RB_STAT__ROQ_WPTR_PRIMARY__SHIFT                                                               0x10
#define CP_ROQ_RB_STAT__ROQ_RPTR_PRIMARY_MASK                                                                 0x00000FFFL
#define CP_ROQ_RB_STAT__ROQ_WPTR_PRIMARY_MASK                                                                 0x0FFF0000L
//CP_ROQ_IB1_STAT
#define CP_ROQ_IB1_STAT__ROQ_RPTR_INDIRECT1__SHIFT                                                            0x0
#define CP_ROQ_IB1_STAT__ROQ_WPTR_INDIRECT1__SHIFT                                                            0x10
#define CP_ROQ_IB1_STAT__ROQ_RPTR_INDIRECT1_MASK                                                              0x00000FFFL
#define CP_ROQ_IB1_STAT__ROQ_WPTR_INDIRECT1_MASK                                                              0x0FFF0000L
//CP_ROQ_IB2_STAT
#define CP_ROQ_IB2_STAT__ROQ_RPTR_INDIRECT2__SHIFT                                                            0x0
#define CP_ROQ_IB2_STAT__ROQ_WPTR_INDIRECT2__SHIFT                                                            0x10
#define CP_ROQ_IB2_STAT__ROQ_RPTR_INDIRECT2_MASK                                                              0x00000FFFL
#define CP_ROQ_IB2_STAT__ROQ_WPTR_INDIRECT2_MASK                                                              0x0FFF0000L
//CP_STQ_STAT
#define CP_STQ_STAT__STQ_RPTR__SHIFT                                                                          0x0
#define CP_STQ_STAT__STQ_RPTR_MASK                                                                            0x000003FFL
//CP_STQ_WR_STAT
#define CP_STQ_WR_STAT__STQ_WPTR__SHIFT                                                                       0x0
#define CP_STQ_WR_STAT__STQ_WPTR_MASK                                                                         0x000003FFL
//CP_MEQ_STAT
#define CP_MEQ_STAT__MEQ_RPTR__SHIFT                                                                          0x0
#define CP_MEQ_STAT__MEQ_WPTR__SHIFT                                                                          0x10
#define CP_MEQ_STAT__MEQ_RPTR_MASK                                                                            0x000003FFL
#define CP_MEQ_STAT__MEQ_WPTR_MASK                                                                            0x03FF0000L
//CP_ROQ3_THRESHOLDS
#define CP_ROQ3_THRESHOLDS__R0_DB_START__SHIFT                                                                0x0
#define CP_ROQ3_THRESHOLDS__R1_DB_START__SHIFT                                                                0xa
#define CP_ROQ3_THRESHOLDS__R0_DB_START_MASK                                                                  0x000003FFL
#define CP_ROQ3_THRESHOLDS__R1_DB_START_MASK                                                                  0x000FFC00L
//CP_ROQ_DB_STAT
#define CP_ROQ_DB_STAT__ROQ_RPTR_DB__SHIFT                                                                    0x0
#define CP_ROQ_DB_STAT__ROQ_WPTR_DB__SHIFT                                                                    0x10
#define CP_ROQ_DB_STAT__ROQ_RPTR_DB_MASK                                                                      0x00000FFFL
#define CP_ROQ_DB_STAT__ROQ_WPTR_DB_MASK                                                                      0x0FFF0000L
//CP_INT_STAT_DEBUG
#define CP_INT_STAT_DEBUG__RESUME_INT_ASSERTED__SHIFT                                                         0x8
#define CP_INT_STAT_DEBUG__SUSPEND_INT_ASSERTED__SHIFT                                                        0x9
#define CP_INT_STAT_DEBUG__DMA_WATCH_INT_ASSERTED__SHIFT                                                      0xa
#define CP_INT_STAT_DEBUG__CP_VM_DOORBELL_WR_INT_ASSERTED__SHIFT                                              0xb
#define CP_INT_STAT_DEBUG__CP_ECC_ERROR_INT_ASSERTED__SHIFT                                                   0xe
#define CP_INT_STAT_DEBUG__FUE_INT_STATUS_DEBUG__SHIFT                                                        0xf
#define CP_INT_STAT_DEBUG__GPF_INT_ASSERTED__SHIFT                                                            0x10
#define CP_INT_STAT_DEBUG__WRM_POLL_TIMEOUT_INT_ASSERTED__SHIFT                                               0x11
#define CP_INT_STAT_DEBUG__CMP_BUSY_INT_ASSERTED__SHIFT                                                       0x12
#define CP_INT_STAT_DEBUG__CNTX_BUSY_INT_ASSERTED__SHIFT                                                      0x13
#define CP_INT_STAT_DEBUG__CNTX_EMPTY_INT_ASSERTED__SHIFT                                                     0x14
#define CP_INT_STAT_DEBUG__GFX_IDLE_INT_ASSERTED__SHIFT                                                       0x15
#define CP_INT_STAT_DEBUG__PRIV_INSTR_INT_ASSERTED__SHIFT                                                     0x16
#define CP_INT_STAT_DEBUG__PRIV_REG_INT_ASSERTED__SHIFT                                                       0x17
#define CP_INT_STAT_DEBUG__OPCODE_ERROR_INT_ASSERTED__SHIFT                                                   0x18
#define CP_INT_STAT_DEBUG__TIME_STAMP_INT_ASSERTED__SHIFT                                                     0x1a
#define CP_INT_STAT_DEBUG__RESERVED_BIT_ERROR_INT_ASSERTED__SHIFT                                             0x1b
#define CP_INT_STAT_DEBUG__GENERIC2_INT_ASSERTED__SHIFT                                                       0x1d
#define CP_INT_STAT_DEBUG__GENERIC1_INT_ASSERTED__SHIFT                                                       0x1e
#define CP_INT_STAT_DEBUG__GENERIC0_INT_ASSERTED__SHIFT                                                       0x1f
#define CP_INT_STAT_DEBUG__RESUME_INT_ASSERTED_MASK                                                           0x00000100L
#define CP_INT_STAT_DEBUG__SUSPEND_INT_ASSERTED_MASK                                                          0x00000200L
#define CP_INT_STAT_DEBUG__DMA_WATCH_INT_ASSERTED_MASK                                                        0x00000400L
#define CP_INT_STAT_DEBUG__CP_VM_DOORBELL_WR_INT_ASSERTED_MASK                                                0x00000800L
#define CP_INT_STAT_DEBUG__CP_ECC_ERROR_INT_ASSERTED_MASK                                                     0x00004000L
#define CP_INT_STAT_DEBUG__FUE_INT_STATUS_DEBUG_MASK                                                          0x00008000L
#define CP_INT_STAT_DEBUG__GPF_INT_ASSERTED_MASK                                                              0x00010000L
#define CP_INT_STAT_DEBUG__WRM_POLL_TIMEOUT_INT_ASSERTED_MASK                                                 0x00020000L
#define CP_INT_STAT_DEBUG__CMP_BUSY_INT_ASSERTED_MASK                                                         0x00040000L
#define CP_INT_STAT_DEBUG__CNTX_BUSY_INT_ASSERTED_MASK                                                        0x00080000L
#define CP_INT_STAT_DEBUG__CNTX_EMPTY_INT_ASSERTED_MASK                                                       0x00100000L
#define CP_INT_STAT_DEBUG__GFX_IDLE_INT_ASSERTED_MASK                                                         0x00200000L
#define CP_INT_STAT_DEBUG__PRIV_INSTR_INT_ASSERTED_MASK                                                       0x00400000L
#define CP_INT_STAT_DEBUG__PRIV_REG_INT_ASSERTED_MASK                                                         0x00800000L
#define CP_INT_STAT_DEBUG__OPCODE_ERROR_INT_ASSERTED_MASK                                                     0x01000000L
#define CP_INT_STAT_DEBUG__TIME_STAMP_INT_ASSERTED_MASK                                                       0x04000000L
#define CP_INT_STAT_DEBUG__RESERVED_BIT_ERROR_INT_ASSERTED_MASK                                               0x08000000L
#define CP_INT_STAT_DEBUG__GENERIC2_INT_ASSERTED_MASK                                                         0x20000000L
#define CP_INT_STAT_DEBUG__GENERIC1_INT_ASSERTED_MASK                                                         0x40000000L
#define CP_INT_STAT_DEBUG__GENERIC0_INT_ASSERTED_MASK                                                         0x80000000L
//CP_DEBUG_CNTL
#define CP_DEBUG_CNTL__DEBUG_INDX__SHIFT                                                                      0x0
#define CP_DEBUG_CNTL__DEBUG_INDX_MASK                                                                        0x0000007FL
//CP_PRIV_VIOLATION_ADDR
#define CP_PRIV_VIOLATION_ADDR__PRIV_VIOLATION_STATUS__SHIFT                                                  0x0
#define CP_PRIV_VIOLATION_ADDR__PRIV_VIOLATION_OP__SHIFT                                                      0x1
#define CP_PRIV_VIOLATION_ADDR__PRIV_VIOLATION_ADDR__SHIFT                                                    0x2
#define CP_PRIV_VIOLATION_ADDR__PRIV_VIOLATION_STATUS_MASK                                                    0x00000001L
#define CP_PRIV_VIOLATION_ADDR__PRIV_VIOLATION_OP_MASK                                                        0x00000002L
#define CP_PRIV_VIOLATION_ADDR__PRIV_VIOLATION_ADDR_MASK                                                      0xFFFFFFFCL
//CP_PRIV_VIOLATION_ADDR_HI
#define CP_PRIV_VIOLATION_ADDR_HI__PRIV_VIOLATION_ADDR_HI__SHIFT                                              0x0
#define CP_PRIV_VIOLATION_ADDR_HI__PRIV_VIOLATION_ADDR_HI_MASK                                                0x000000FFL


// addressBlock: gc_gfx_cpwd_cpwd_padec
//VGT_DMA_DATA_FIFO_DEPTH
#define VGT_DMA_DATA_FIFO_DEPTH__DMA_DATA_FIFO_DEPTH__SHIFT                                                   0x0
#define VGT_DMA_DATA_FIFO_DEPTH__DMA_DATA_FIFO_DEPTH_MASK                                                     0x000003FFL
//VGT_DMA_REQ_FIFO_DEPTH
#define VGT_DMA_REQ_FIFO_DEPTH__DMA_REQ_FIFO_DEPTH__SHIFT                                                     0x0
#define VGT_DMA_REQ_FIFO_DEPTH__DMA_REQ_FIFO_DEPTH_MASK                                                       0x0000003FL
//VGT_DRAW_INIT_FIFO_DEPTH
#define VGT_DRAW_INIT_FIFO_DEPTH__DRAW_INIT_FIFO_DEPTH__SHIFT                                                 0x0
#define VGT_DRAW_INIT_FIFO_DEPTH__DRAW_INIT_FIFO_DEPTH_MASK                                                   0x0000003FL
//VGT_MC_LAT_CNTL
#define VGT_MC_LAT_CNTL__MC_TIME_STAMP_RES__SHIFT                                                             0x0
#define VGT_MC_LAT_CNTL__MC_TIME_STAMP_RES_MASK                                                               0x0000000FL
//IA_UTCL1_STATUS_2
#define IA_UTCL1_STATUS_2__FAULT_DETECTED__SHIFT                                                              0x0
#define IA_UTCL1_STATUS_2__RETRY_DETECTED__SHIFT                                                              0x1
#define IA_UTCL1_STATUS_2__PRT_DETECTED__SHIFT                                                                0x2
#define IA_UTCL1_STATUS_2__FAULT_VMID__SHIFT                                                                  0x4
#define IA_UTCL1_STATUS_2__FAULT_UTCL1ID__SHIFT                                                               0x8
#define IA_UTCL1_STATUS_2__FAULT_INSTANCEID__SHIFT                                                            0xe
#define IA_UTCL1_STATUS_2__RETRY_UTCL1ID__SHIFT                                                               0x10
#define IA_UTCL1_STATUS_2__RETRY_INSTANCEID__SHIFT                                                            0x16
#define IA_UTCL1_STATUS_2__PRT_UTCL1ID__SHIFT                                                                 0x18
#define IA_UTCL1_STATUS_2__PRT_INSTANCEID__SHIFT                                                              0x1e
#define IA_UTCL1_STATUS_2__FAULT_DETECTED_MASK                                                                0x00000001L
#define IA_UTCL1_STATUS_2__RETRY_DETECTED_MASK                                                                0x00000002L
#define IA_UTCL1_STATUS_2__PRT_DETECTED_MASK                                                                  0x00000004L
#define IA_UTCL1_STATUS_2__FAULT_VMID_MASK                                                                    0x000000F0L
#define IA_UTCL1_STATUS_2__FAULT_UTCL1ID_MASK                                                                 0x00003F00L
#define IA_UTCL1_STATUS_2__FAULT_INSTANCEID_MASK                                                              0x0000C000L
#define IA_UTCL1_STATUS_2__RETRY_UTCL1ID_MASK                                                                 0x003F0000L
#define IA_UTCL1_STATUS_2__RETRY_INSTANCEID_MASK                                                              0x00C00000L
#define IA_UTCL1_STATUS_2__PRT_UTCL1ID_MASK                                                                   0x3F000000L
#define IA_UTCL1_STATUS_2__PRT_INSTANCEID_MASK                                                                0xC0000000L
//GE_WD_CNTL_STATUS
#define GE_WD_CNTL_STATUS__DIST_BUSY__SHIFT                                                                   0x0
#define GE_WD_CNTL_STATUS__DIST_BE_BUSY__SHIFT                                                                0x1
#define GE_WD_CNTL_STATUS__GE_UTCL1_BUSY__SHIFT                                                               0x2
#define GE_WD_CNTL_STATUS__WD_TE11_BUSY__SHIFT                                                                0x3
#define GE_WD_CNTL_STATUS__PC_MANAGER_BUSY__SHIFT                                                             0x4
#define GE_WD_CNTL_STATUS__WLC_BUSY__SHIFT                                                                    0x5
#define GE_WD_CNTL_STATUS__DIST_BUSY_MASK                                                                     0x00000001L
#define GE_WD_CNTL_STATUS__DIST_BE_BUSY_MASK                                                                  0x00000002L
#define GE_WD_CNTL_STATUS__GE_UTCL1_BUSY_MASK                                                                 0x00000004L
#define GE_WD_CNTL_STATUS__WD_TE11_BUSY_MASK                                                                  0x00000008L
#define GE_WD_CNTL_STATUS__PC_MANAGER_BUSY_MASK                                                               0x00000010L
#define GE_WD_CNTL_STATUS__WLC_BUSY_MASK                                                                      0x00000020L
//WD_UTCL1_CNTL
#define WD_UTCL1_CNTL__XNACK_REDO_TIMER_CNT__SHIFT                                                            0x0
#define WD_UTCL1_CNTL__VMID_RESET_MODE__SHIFT                                                                 0x17
#define WD_UTCL1_CNTL__DROP_MODE__SHIFT                                                                       0x18
#define WD_UTCL1_CNTL__BYPASS__SHIFT                                                                          0x19
#define WD_UTCL1_CNTL__INVALIDATE__SHIFT                                                                      0x1a
#define WD_UTCL1_CNTL__FRAG_LIMIT_MODE__SHIFT                                                                 0x1b
#define WD_UTCL1_CNTL__FORCE_SNOOP__SHIFT                                                                     0x1c
#define WD_UTCL1_CNTL__MTYPE_OVERRIDE__SHIFT                                                                  0x1d
#define WD_UTCL1_CNTL__LLC_NOALLOC_OVERRIDE__SHIFT                                                            0x1e
#define WD_UTCL1_CNTL__XNACK_REDO_TIMER_CNT_MASK                                                              0x000FFFFFL
#define WD_UTCL1_CNTL__VMID_RESET_MODE_MASK                                                                   0x00800000L
#define WD_UTCL1_CNTL__DROP_MODE_MASK                                                                         0x01000000L
#define WD_UTCL1_CNTL__BYPASS_MASK                                                                            0x02000000L
#define WD_UTCL1_CNTL__INVALIDATE_MASK                                                                        0x04000000L
#define WD_UTCL1_CNTL__FRAG_LIMIT_MODE_MASK                                                                   0x08000000L
#define WD_UTCL1_CNTL__FORCE_SNOOP_MASK                                                                       0x10000000L
#define WD_UTCL1_CNTL__MTYPE_OVERRIDE_MASK                                                                    0x20000000L
#define WD_UTCL1_CNTL__LLC_NOALLOC_OVERRIDE_MASK                                                              0x40000000L
//WD_UTCL1_STATUS
#define WD_UTCL1_STATUS__FAULT_DETECTED__SHIFT                                                                0x0
#define WD_UTCL1_STATUS__RETRY_DETECTED__SHIFT                                                                0x1
#define WD_UTCL1_STATUS__PRT_DETECTED__SHIFT                                                                  0x2
#define WD_UTCL1_STATUS__FAULT_VMID__SHIFT                                                                    0x4
#define WD_UTCL1_STATUS__FAULT_UTCL1ID__SHIFT                                                                 0x8
#define WD_UTCL1_STATUS__FAULT_INSTANCEID__SHIFT                                                              0xe
#define WD_UTCL1_STATUS__RETRY_UTCL1ID__SHIFT                                                                 0x10
#define WD_UTCL1_STATUS__RETRY_INSTANCEID__SHIFT                                                              0x16
#define WD_UTCL1_STATUS__PRT_UTCL1ID__SHIFT                                                                   0x18
#define WD_UTCL1_STATUS__PRT_INSTANCEID__SHIFT                                                                0x1e
#define WD_UTCL1_STATUS__FAULT_DETECTED_MASK                                                                  0x00000001L
#define WD_UTCL1_STATUS__RETRY_DETECTED_MASK                                                                  0x00000002L
#define WD_UTCL1_STATUS__PRT_DETECTED_MASK                                                                    0x00000004L
#define WD_UTCL1_STATUS__FAULT_VMID_MASK                                                                      0x000000F0L
#define WD_UTCL1_STATUS__FAULT_UTCL1ID_MASK                                                                   0x00003F00L
#define WD_UTCL1_STATUS__FAULT_INSTANCEID_MASK                                                                0x0000C000L
#define WD_UTCL1_STATUS__RETRY_UTCL1ID_MASK                                                                   0x003F0000L
#define WD_UTCL1_STATUS__RETRY_INSTANCEID_MASK                                                                0x00C00000L
#define WD_UTCL1_STATUS__PRT_UTCL1ID_MASK                                                                     0x3F000000L
#define WD_UTCL1_STATUS__PRT_INSTANCEID_MASK                                                                  0xC0000000L
//IA_UTCL1_CNTL
#define IA_UTCL1_CNTL__XNACK_REDO_TIMER_CNT__SHIFT                                                            0x0
#define IA_UTCL1_CNTL__VMID_RESET_MODE__SHIFT                                                                 0x17
#define IA_UTCL1_CNTL__DROP_MODE__SHIFT                                                                       0x18
#define IA_UTCL1_CNTL__BYPASS__SHIFT                                                                          0x19
#define IA_UTCL1_CNTL__INVALIDATE__SHIFT                                                                      0x1a
#define IA_UTCL1_CNTL__FRAG_LIMIT_MODE__SHIFT                                                                 0x1b
#define IA_UTCL1_CNTL__FORCE_SNOOP__SHIFT                                                                     0x1c
#define IA_UTCL1_CNTL__MTYPE_OVERRIDE__SHIFT                                                                  0x1d
#define IA_UTCL1_CNTL__LLC_NOALLOC_OVERRIDE__SHIFT                                                            0x1e
#define IA_UTCL1_CNTL__XNACK_REDO_TIMER_CNT_MASK                                                              0x000FFFFFL
#define IA_UTCL1_CNTL__VMID_RESET_MODE_MASK                                                                   0x00800000L
#define IA_UTCL1_CNTL__DROP_MODE_MASK                                                                         0x01000000L
#define IA_UTCL1_CNTL__BYPASS_MASK                                                                            0x02000000L
#define IA_UTCL1_CNTL__INVALIDATE_MASK                                                                        0x04000000L
#define IA_UTCL1_CNTL__FRAG_LIMIT_MODE_MASK                                                                   0x08000000L
#define IA_UTCL1_CNTL__FORCE_SNOOP_MASK                                                                       0x10000000L
#define IA_UTCL1_CNTL__MTYPE_OVERRIDE_MASK                                                                    0x20000000L
#define IA_UTCL1_CNTL__LLC_NOALLOC_OVERRIDE_MASK                                                              0x40000000L
//IA_UTCL1_STATUS
#define IA_UTCL1_STATUS__FAULT_DETECTED__SHIFT                                                                0x0
#define IA_UTCL1_STATUS__RETRY_DETECTED__SHIFT                                                                0x1
#define IA_UTCL1_STATUS__PRT_DETECTED__SHIFT                                                                  0x2
#define IA_UTCL1_STATUS__FAULT_VMID__SHIFT                                                                    0x4
#define IA_UTCL1_STATUS__FAULT_UTCL1ID__SHIFT                                                                 0x8
#define IA_UTCL1_STATUS__FAULT_INSTANCEID__SHIFT                                                              0xe
#define IA_UTCL1_STATUS__RETRY_UTCL1ID__SHIFT                                                                 0x10
#define IA_UTCL1_STATUS__RETRY_INSTANCEID__SHIFT                                                              0x16
#define IA_UTCL1_STATUS__PRT_UTCL1ID__SHIFT                                                                   0x18
#define IA_UTCL1_STATUS__PRT_INSTANCEID__SHIFT                                                                0x1e
#define IA_UTCL1_STATUS__FAULT_DETECTED_MASK                                                                  0x00000001L
#define IA_UTCL1_STATUS__RETRY_DETECTED_MASK                                                                  0x00000002L
#define IA_UTCL1_STATUS__PRT_DETECTED_MASK                                                                    0x00000004L
#define IA_UTCL1_STATUS__FAULT_VMID_MASK                                                                      0x000000F0L
#define IA_UTCL1_STATUS__FAULT_UTCL1ID_MASK                                                                   0x00003F00L
#define IA_UTCL1_STATUS__FAULT_INSTANCEID_MASK                                                                0x0000C000L
#define IA_UTCL1_STATUS__RETRY_UTCL1ID_MASK                                                                   0x003F0000L
#define IA_UTCL1_STATUS__RETRY_INSTANCEID_MASK                                                                0x00C00000L
#define IA_UTCL1_STATUS__PRT_UTCL1ID_MASK                                                                     0x3F000000L
#define IA_UTCL1_STATUS__PRT_INSTANCEID_MASK                                                                  0xC0000000L
//GRBM_CC_GC_SA_UNIT_DISABLE
#define GRBM_CC_GC_SA_UNIT_DISABLE__SA_DISABLE__SHIFT                                                         0x8
#define GRBM_CC_GC_SA_UNIT_DISABLE__SA_DISABLE_MASK                                                           0x00FFFF00L
//GE_PRIV_CONTROL
#define GE_PRIV_CONTROL__RESERVED__SHIFT                                                                      0x0
#define GE_PRIV_CONTROL__CLAMP_PRIMGRP_SIZE__SHIFT                                                            0x1
#define GE_PRIV_CONTROL__FGCG_OVERRIDE__SHIFT                                                                 0xf
#define GE_PRIV_CONTROL__CLAMP_HS_OFFCHIP_PER_SE_OVERRIDE__SHIFT                                              0x10
#define GE_PRIV_CONTROL__MIN_ATTR_GRPS__SHIFT                                                                 0x12
#define GE_PRIV_CONTROL__RESERVED_MASK                                                                        0x00000001L
#define GE_PRIV_CONTROL__CLAMP_PRIMGRP_SIZE_MASK                                                              0x000003FEL
#define GE_PRIV_CONTROL__FGCG_OVERRIDE_MASK                                                                   0x00008000L
#define GE_PRIV_CONTROL__CLAMP_HS_OFFCHIP_PER_SE_OVERRIDE_MASK                                                0x00010000L
#define GE_PRIV_CONTROL__MIN_ATTR_GRPS_MASK                                                                   0x003C0000L
//GE_STATUS
#define GE_STATUS__PERFCOUNTER_STATUS__SHIFT                                                                  0x0
#define GE_STATUS__THREAD_TRACE_STATUS__SHIFT                                                                 0x1
#define GE_STATUS__PERFCOUNTER_STATUS_MASK                                                                    0x00000001L
#define GE_STATUS__THREAD_TRACE_STATUS_MASK                                                                   0x00000002L
//VGT_GS_MAX_WAVE_ID
#define VGT_GS_MAX_WAVE_ID__MAX_WAVE_ID__SHIFT                                                                0x0
#define VGT_GS_MAX_WAVE_ID__MAX_WAVE_ID_MASK                                                                  0x00000FFFL
//GFX_PIPE_CONTROL
#define GFX_PIPE_CONTROL__HYSTERESIS_CNT__SHIFT                                                               0x0
#define GFX_PIPE_CONTROL__CONTEXT_SUSPEND_EN__SHIFT                                                           0x10
#define GFX_PIPE_CONTROL__CONTEXT_SUSPEND_STALL_EN__SHIFT                                                     0x11
#define GFX_PIPE_CONTROL__HYSTERESIS_CNT_MASK                                                                 0x00001FFFL
#define GFX_PIPE_CONTROL__CONTEXT_SUSPEND_EN_MASK                                                             0x00010000L
#define GFX_PIPE_CONTROL__CONTEXT_SUSPEND_STALL_EN_MASK                                                       0x00020000L
//VGT_RESET_DEBUG
#define VGT_RESET_DEBUG__GS_DISABLE__SHIFT                                                                    0x0
#define VGT_RESET_DEBUG__TESS_DISABLE__SHIFT                                                                  0x1
#define VGT_RESET_DEBUG__WD_DISABLE__SHIFT                                                                    0x2
#define VGT_RESET_DEBUG__DISABLE_TE11_DIST_PIPE0__SHIFT                                                       0x3
#define VGT_RESET_DEBUG__DISABLE_TE11_DIST_PIPE1__SHIFT                                                       0x4
#define VGT_RESET_DEBUG__ENABLE_VMID_RESET_UTCL1__SHIFT                                                       0x5
#define VGT_RESET_DEBUG__DISABLE_PREFETCH__SHIFT                                                              0x6
#define VGT_RESET_DEBUG__DISABLE_SWITCH_MODE_STALL_FIX__SHIFT                                                 0x7
#define VGT_RESET_DEBUG__DISABLE_SENDING_MULTIPLE_SE_IN_PD__SHIFT                                             0x8
#define VGT_RESET_DEBUG__ENABLE_DIST_STALL_TESS_ON_OFF__SHIFT                                                 0x9
#define VGT_RESET_DEBUG__DISABLE_PATCH_OPTIMIZATION__SHIFT                                                    0xa
#define VGT_RESET_DEBUG__ENABLE_DIST_STALL_TESS_OFF_ON__SHIFT                                                 0xb
#define VGT_RESET_DEBUG__DISABLE_MERGE_GRP_PERF_FIX__SHIFT                                                    0xc
#define VGT_RESET_DEBUG__DISABLE_MESH_SHADER_ATTR_PACKING__SHIFT                                              0xd
#define VGT_RESET_DEBUG__ENABLE_SMALL_INST_PACK_ADJ_GS_OFF__SHIFT                                             0xe
#define VGT_RESET_DEBUG__DISABLE_PATCH_DIST_LAST_DONUT_SE_SWITCH_LOGIC__SHIFT                                 0xf
#define VGT_RESET_DEBUG__SPARE__SHIFT                                                                         0x10
#define VGT_RESET_DEBUG__GS_DISABLE_MASK                                                                      0x00000001L
#define VGT_RESET_DEBUG__TESS_DISABLE_MASK                                                                    0x00000002L
#define VGT_RESET_DEBUG__WD_DISABLE_MASK                                                                      0x00000004L
#define VGT_RESET_DEBUG__DISABLE_TE11_DIST_PIPE0_MASK                                                         0x00000008L
#define VGT_RESET_DEBUG__DISABLE_TE11_DIST_PIPE1_MASK                                                         0x00000010L
#define VGT_RESET_DEBUG__ENABLE_VMID_RESET_UTCL1_MASK                                                         0x00000020L
#define VGT_RESET_DEBUG__DISABLE_PREFETCH_MASK                                                                0x00000040L
#define VGT_RESET_DEBUG__DISABLE_SWITCH_MODE_STALL_FIX_MASK                                                   0x00000080L
#define VGT_RESET_DEBUG__DISABLE_SENDING_MULTIPLE_SE_IN_PD_MASK                                               0x00000100L
#define VGT_RESET_DEBUG__ENABLE_DIST_STALL_TESS_ON_OFF_MASK                                                   0x00000200L
#define VGT_RESET_DEBUG__DISABLE_PATCH_OPTIMIZATION_MASK                                                      0x00000400L
#define VGT_RESET_DEBUG__ENABLE_DIST_STALL_TESS_OFF_ON_MASK                                                   0x00000800L
#define VGT_RESET_DEBUG__DISABLE_MERGE_GRP_PERF_FIX_MASK                                                      0x00001000L
#define VGT_RESET_DEBUG__DISABLE_MESH_SHADER_ATTR_PACKING_MASK                                                0x00002000L
#define VGT_RESET_DEBUG__ENABLE_SMALL_INST_PACK_ADJ_GS_OFF_MASK                                               0x00004000L
#define VGT_RESET_DEBUG__DISABLE_PATCH_DIST_LAST_DONUT_SE_SWITCH_LOGIC_MASK                                   0x00008000L
#define VGT_RESET_DEBUG__SPARE_MASK                                                                           0xFFFF0000L


// addressBlock: gc_gfx_cpwd_cpwd_shdec
//COMPUTE_DISPATCH_INITIATOR
#define COMPUTE_DISPATCH_INITIATOR__COMPUTE_SHADER_EN__SHIFT                                                  0x0
#define COMPUTE_DISPATCH_INITIATOR__PARTIAL_TG_EN__SHIFT                                                      0x1
#define COMPUTE_DISPATCH_INITIATOR__FORCE_START_AT_000__SHIFT                                                 0x2
#define COMPUTE_DISPATCH_INITIATOR__ORDERED_APPEND_ENBL__SHIFT                                                0x3
#define COMPUTE_DISPATCH_INITIATOR__ORDERED_APPEND_MODE__SHIFT                                                0x4
#define COMPUTE_DISPATCH_INITIATOR__USE_THREAD_DIMENSIONS__SHIFT                                              0x5
#define COMPUTE_DISPATCH_INITIATOR__ORDER_MODE__SHIFT                                                         0x6
#define COMPUTE_DISPATCH_INITIATOR__SCALAR_L1_INV_VOL__SHIFT                                                  0xa
#define COMPUTE_DISPATCH_INITIATOR__VECTOR_L1_INV_VOL__SHIFT                                                  0xb
#define COMPUTE_DISPATCH_INITIATOR__PING_PONG_EN__SHIFT                                                       0xc
#define COMPUTE_DISPATCH_INITIATOR__TUNNEL_ENABLE__SHIFT                                                      0xd
#define COMPUTE_DISPATCH_INITIATOR__RESTORE__SHIFT                                                            0xe
#define COMPUTE_DISPATCH_INITIATOR__CS_W32_EN__SHIFT                                                          0xf
#define COMPUTE_DISPATCH_INITIATOR__AMP_SHADER_EN__SHIFT                                                      0x10
#define COMPUTE_DISPATCH_INITIATOR__DISABLE_DISP_PREMPT_EN__SHIFT                                             0x11
#define COMPUTE_DISPATCH_INITIATOR__INTERLEAVE_2D_EN__SHIFT                                                   0x12
#define COMPUTE_DISPATCH_INITIATOR__TTRACE_QUEUE_ID__SHIFT                                                    0x1d
#define COMPUTE_DISPATCH_INITIATOR__COMPUTE_SHADER_EN_MASK                                                    0x00000001L
#define COMPUTE_DISPATCH_INITIATOR__PARTIAL_TG_EN_MASK                                                        0x00000002L
#define COMPUTE_DISPATCH_INITIATOR__FORCE_START_AT_000_MASK                                                   0x00000004L
#define COMPUTE_DISPATCH_INITIATOR__ORDERED_APPEND_ENBL_MASK                                                  0x00000008L
#define COMPUTE_DISPATCH_INITIATOR__ORDERED_APPEND_MODE_MASK                                                  0x00000010L
#define COMPUTE_DISPATCH_INITIATOR__USE_THREAD_DIMENSIONS_MASK                                                0x00000020L
#define COMPUTE_DISPATCH_INITIATOR__ORDER_MODE_MASK                                                           0x00000040L
#define COMPUTE_DISPATCH_INITIATOR__SCALAR_L1_INV_VOL_MASK                                                    0x00000400L
#define COMPUTE_DISPATCH_INITIATOR__VECTOR_L1_INV_VOL_MASK                                                    0x00000800L
#define COMPUTE_DISPATCH_INITIATOR__PING_PONG_EN_MASK                                                         0x00001000L
#define COMPUTE_DISPATCH_INITIATOR__TUNNEL_ENABLE_MASK                                                        0x00002000L
#define COMPUTE_DISPATCH_INITIATOR__RESTORE_MASK                                                              0x00004000L
#define COMPUTE_DISPATCH_INITIATOR__CS_W32_EN_MASK                                                            0x00008000L
#define COMPUTE_DISPATCH_INITIATOR__AMP_SHADER_EN_MASK                                                        0x00010000L
#define COMPUTE_DISPATCH_INITIATOR__DISABLE_DISP_PREMPT_EN_MASK                                               0x00020000L
#define COMPUTE_DISPATCH_INITIATOR__INTERLEAVE_2D_EN_MASK                                                     0x00040000L
#define COMPUTE_DISPATCH_INITIATOR__TTRACE_QUEUE_ID_MASK                                                      0xE0000000L
//COMPUTE_DIM_X
#define COMPUTE_DIM_X__SIZE__SHIFT                                                                            0x0
#define COMPUTE_DIM_X__SIZE_MASK                                                                              0xFFFFFFFFL
//COMPUTE_DIM_Y
#define COMPUTE_DIM_Y__SIZE__SHIFT                                                                            0x0
#define COMPUTE_DIM_Y__SIZE_MASK                                                                              0xFFFFFFFFL
//COMPUTE_DIM_Z
#define COMPUTE_DIM_Z__SIZE__SHIFT                                                                            0x0
#define COMPUTE_DIM_Z__SIZE_MASK                                                                              0xFFFFFFFFL
//COMPUTE_START_X
#define COMPUTE_START_X__START__SHIFT                                                                         0x0
#define COMPUTE_START_X__START_MASK                                                                           0xFFFFFFFFL
//COMPUTE_START_Y
#define COMPUTE_START_Y__START__SHIFT                                                                         0x0
#define COMPUTE_START_Y__START_MASK                                                                           0xFFFFFFFFL
//COMPUTE_START_Z
#define COMPUTE_START_Z__START__SHIFT                                                                         0x0
#define COMPUTE_START_Z__START_MASK                                                                           0xFFFFFFFFL
//COMPUTE_NUM_THREAD_X
#define COMPUTE_NUM_THREAD_X__NUM_THREAD_FULL__SHIFT                                                          0x0
#define COMPUTE_NUM_THREAD_X__INTERLEAVE_BITS_X__SHIFT                                                        0xd
#define COMPUTE_NUM_THREAD_X__NUM_THREAD_PARTIAL__SHIFT                                                       0x10
#define COMPUTE_NUM_THREAD_X__NUM_THREAD_FULL_MASK                                                            0x00001FFFL
#define COMPUTE_NUM_THREAD_X__INTERLEAVE_BITS_X_MASK                                                          0x0000E000L
#define COMPUTE_NUM_THREAD_X__NUM_THREAD_PARTIAL_MASK                                                         0xFFFF0000L
//COMPUTE_NUM_THREAD_Y
#define COMPUTE_NUM_THREAD_Y__NUM_THREAD_FULL__SHIFT                                                          0x0
#define COMPUTE_NUM_THREAD_Y__INTERLEAVE_BITS_Y__SHIFT                                                        0xd
#define COMPUTE_NUM_THREAD_Y__NUM_THREAD_PARTIAL__SHIFT                                                       0x10
#define COMPUTE_NUM_THREAD_Y__NUM_THREAD_FULL_MASK                                                            0x00001FFFL
#define COMPUTE_NUM_THREAD_Y__INTERLEAVE_BITS_Y_MASK                                                          0x0000E000L
#define COMPUTE_NUM_THREAD_Y__NUM_THREAD_PARTIAL_MASK                                                         0xFFFF0000L
//COMPUTE_NUM_THREAD_Z
#define COMPUTE_NUM_THREAD_Z__NUM_THREAD_FULL__SHIFT                                                          0x0
#define COMPUTE_NUM_THREAD_Z__NUM_THREAD_PARTIAL__SHIFT                                                       0x10
#define COMPUTE_NUM_THREAD_Z__NUM_THREAD_FULL_MASK                                                            0x0000FFFFL
#define COMPUTE_NUM_THREAD_Z__NUM_THREAD_PARTIAL_MASK                                                         0xFFFF0000L
//COMPUTE_PIPELINESTAT_ENABLE
#define COMPUTE_PIPELINESTAT_ENABLE__PIPELINESTAT_ENABLE__SHIFT                                               0x0
#define COMPUTE_PIPELINESTAT_ENABLE__PIPELINESTAT_ENABLE_MASK                                                 0x00000001L
//COMPUTE_PERFCOUNT_ENABLE
#define COMPUTE_PERFCOUNT_ENABLE__PERFCOUNT_ENABLE__SHIFT                                                     0x0
#define COMPUTE_PERFCOUNT_ENABLE__PERFCOUNT_ENABLE_MASK                                                       0x00000001L
//COMPUTE_PGM_LO
#define COMPUTE_PGM_LO__DATA__SHIFT                                                                           0x0
#define COMPUTE_PGM_LO__DATA_MASK                                                                             0xFFFFFFFFL
//COMPUTE_PGM_HI
#define COMPUTE_PGM_HI__DATA__SHIFT                                                                           0x0
#define COMPUTE_PGM_HI__DATA_MASK                                                                             0x000000FFL
//COMPUTE_DISPATCH_PKT_ADDR_LO
#define COMPUTE_DISPATCH_PKT_ADDR_LO__DATA__SHIFT                                                             0x0
#define COMPUTE_DISPATCH_PKT_ADDR_LO__DATA_MASK                                                               0xFFFFFFFFL
//COMPUTE_DISPATCH_PKT_ADDR_HI
#define COMPUTE_DISPATCH_PKT_ADDR_HI__DATA__SHIFT                                                             0x0
#define COMPUTE_DISPATCH_PKT_ADDR_HI__DATA_MASK                                                               0x000000FFL
//COMPUTE_DISPATCH_SCRATCH_BASE_LO
#define COMPUTE_DISPATCH_SCRATCH_BASE_LO__DATA__SHIFT                                                         0x0
#define COMPUTE_DISPATCH_SCRATCH_BASE_LO__DATA_MASK                                                           0xFFFFFFFFL
//COMPUTE_DISPATCH_SCRATCH_BASE_HI
#define COMPUTE_DISPATCH_SCRATCH_BASE_HI__DATA__SHIFT                                                         0x0
#define COMPUTE_DISPATCH_SCRATCH_BASE_HI__DATA_MASK                                                           0x000000FFL
//COMPUTE_PGM_RSRC1
#define COMPUTE_PGM_RSRC1__VGPRS__SHIFT                                                                       0x0
#define COMPUTE_PGM_RSRC1__SGPRS__SHIFT                                                                       0x6
#define COMPUTE_PGM_RSRC1__PRIORITY__SHIFT                                                                    0xa
#define COMPUTE_PGM_RSRC1__FLOAT_MODE__SHIFT                                                                  0xc
#define COMPUTE_PGM_RSRC1__PRIV__SHIFT                                                                        0x14
#define COMPUTE_PGM_RSRC1__WG_RR_EN__SHIFT                                                                    0x15
#define COMPUTE_PGM_RSRC1__DEBUG_MODE__SHIFT                                                                  0x16
#define COMPUTE_PGM_RSRC1__DISABLE_PERF__SHIFT                                                                0x17
#define COMPUTE_PGM_RSRC1__BULKY__SHIFT                                                                       0x18
#define COMPUTE_PGM_RSRC1__CDBG_USER__SHIFT                                                                   0x19
#define COMPUTE_PGM_RSRC1__FP16_OVFL__SHIFT                                                                   0x1a
#define COMPUTE_PGM_RSRC1__WGP_MODE__SHIFT                                                                    0x1d
#define COMPUTE_PGM_RSRC1__MEM_ORDERED__SHIFT                                                                 0x1e
#define COMPUTE_PGM_RSRC1__FWD_PROGRESS__SHIFT                                                                0x1f
#define COMPUTE_PGM_RSRC1__VGPRS_MASK                                                                         0x0000003FL
#define COMPUTE_PGM_RSRC1__SGPRS_MASK                                                                         0x000003C0L
#define COMPUTE_PGM_RSRC1__PRIORITY_MASK                                                                      0x00000C00L
#define COMPUTE_PGM_RSRC1__FLOAT_MODE_MASK                                                                    0x000FF000L
#define COMPUTE_PGM_RSRC1__PRIV_MASK                                                                          0x00100000L
#define COMPUTE_PGM_RSRC1__WG_RR_EN_MASK                                                                      0x00200000L
#define COMPUTE_PGM_RSRC1__DEBUG_MODE_MASK                                                                    0x00400000L
#define COMPUTE_PGM_RSRC1__DISABLE_PERF_MASK                                                                  0x00800000L
#define COMPUTE_PGM_RSRC1__BULKY_MASK                                                                         0x01000000L
#define COMPUTE_PGM_RSRC1__CDBG_USER_MASK                                                                     0x02000000L
#define COMPUTE_PGM_RSRC1__FP16_OVFL_MASK                                                                     0x04000000L
#define COMPUTE_PGM_RSRC1__WGP_MODE_MASK                                                                      0x20000000L
#define COMPUTE_PGM_RSRC1__MEM_ORDERED_MASK                                                                   0x40000000L
#define COMPUTE_PGM_RSRC1__FWD_PROGRESS_MASK                                                                  0x80000000L
//COMPUTE_PGM_RSRC2
#define COMPUTE_PGM_RSRC2__SCRATCH_EN__SHIFT                                                                  0x0
#define COMPUTE_PGM_RSRC2__USER_SGPR__SHIFT                                                                   0x1
#define COMPUTE_PGM_RSRC2__DYNAMIC_VGPR__SHIFT                                                                0x6
#define COMPUTE_PGM_RSRC2__TGID_X_EN__SHIFT                                                                   0x7
#define COMPUTE_PGM_RSRC2__TGID_Y_EN__SHIFT                                                                   0x8
#define COMPUTE_PGM_RSRC2__TGID_Z_EN__SHIFT                                                                   0x9
#define COMPUTE_PGM_RSRC2__TG_SIZE_EN__SHIFT                                                                  0xa
#define COMPUTE_PGM_RSRC2__TIDIG_COMP_CNT__SHIFT                                                              0xb
#define COMPUTE_PGM_RSRC2__EXCP_EN_MSB__SHIFT                                                                 0xd
#define COMPUTE_PGM_RSRC2__LDS_SIZE__SHIFT                                                                    0xf
#define COMPUTE_PGM_RSRC2__EXCP_EN__SHIFT                                                                     0x18
#define COMPUTE_PGM_RSRC2__WGP_TAKEOVER__SHIFT                                                                0x1f
#define COMPUTE_PGM_RSRC2__SCRATCH_EN_MASK                                                                    0x00000001L
#define COMPUTE_PGM_RSRC2__USER_SGPR_MASK                                                                     0x0000003EL
#define COMPUTE_PGM_RSRC2__DYNAMIC_VGPR_MASK                                                                  0x00000040L
#define COMPUTE_PGM_RSRC2__TGID_X_EN_MASK                                                                     0x00000080L
#define COMPUTE_PGM_RSRC2__TGID_Y_EN_MASK                                                                     0x00000100L
#define COMPUTE_PGM_RSRC2__TGID_Z_EN_MASK                                                                     0x00000200L
#define COMPUTE_PGM_RSRC2__TG_SIZE_EN_MASK                                                                    0x00000400L
#define COMPUTE_PGM_RSRC2__TIDIG_COMP_CNT_MASK                                                                0x00001800L
#define COMPUTE_PGM_RSRC2__EXCP_EN_MSB_MASK                                                                   0x00006000L
#define COMPUTE_PGM_RSRC2__LDS_SIZE_MASK                                                                      0x00FF8000L
#define COMPUTE_PGM_RSRC2__EXCP_EN_MASK                                                                       0x7F000000L
#define COMPUTE_PGM_RSRC2__WGP_TAKEOVER_MASK                                                                  0x80000000L
//COMPUTE_VMID
#define COMPUTE_VMID__DATA__SHIFT                                                                             0x0
#define COMPUTE_VMID__DATA_MASK                                                                               0x0000000FL
//COMPUTE_RESOURCE_LIMITS
#define COMPUTE_RESOURCE_LIMITS__WAVES_PER_SH__SHIFT                                                          0x0
#define COMPUTE_RESOURCE_LIMITS__TG_PER_CU__SHIFT                                                             0xc
#define COMPUTE_RESOURCE_LIMITS__LOCK_THRESHOLD__SHIFT                                                        0x10
#define COMPUTE_RESOURCE_LIMITS__SIMD_DEST_CNTL__SHIFT                                                        0x16
#define COMPUTE_RESOURCE_LIMITS__FORCE_SIMD_DIST__SHIFT                                                       0x17
#define COMPUTE_RESOURCE_LIMITS__CU_GROUP_COUNT__SHIFT                                                        0x18
#define COMPUTE_RESOURCE_LIMITS__WAVES_PER_SH_MASK                                                            0x000003FFL
#define COMPUTE_RESOURCE_LIMITS__TG_PER_CU_MASK                                                               0x0000F000L
#define COMPUTE_RESOURCE_LIMITS__LOCK_THRESHOLD_MASK                                                          0x003F0000L
#define COMPUTE_RESOURCE_LIMITS__SIMD_DEST_CNTL_MASK                                                          0x00400000L
#define COMPUTE_RESOURCE_LIMITS__FORCE_SIMD_DIST_MASK                                                         0x00800000L
#define COMPUTE_RESOURCE_LIMITS__CU_GROUP_COUNT_MASK                                                          0x07000000L
//COMPUTE_DESTINATION_EN_SE0
#define COMPUTE_DESTINATION_EN_SE0__CU_EN__SHIFT                                                              0x0
#define COMPUTE_DESTINATION_EN_SE0__CU_EN_MASK                                                                0xFFFFFFFFL
//COMPUTE_STATIC_THREAD_MGMT_SE0
#define COMPUTE_STATIC_THREAD_MGMT_SE0__SA0_CU_EN__SHIFT                                                      0x0
#define COMPUTE_STATIC_THREAD_MGMT_SE0__SA1_CU_EN__SHIFT                                                      0x10
#define COMPUTE_STATIC_THREAD_MGMT_SE0__SA0_CU_EN_MASK                                                        0x0000FFFFL
#define COMPUTE_STATIC_THREAD_MGMT_SE0__SA1_CU_EN_MASK                                                        0xFFFF0000L
//COMPUTE_DESTINATION_EN_SE1
#define COMPUTE_DESTINATION_EN_SE1__CU_EN__SHIFT                                                              0x0
#define COMPUTE_DESTINATION_EN_SE1__CU_EN_MASK                                                                0xFFFFFFFFL
//COMPUTE_STATIC_THREAD_MGMT_SE1
#define COMPUTE_STATIC_THREAD_MGMT_SE1__SA0_CU_EN__SHIFT                                                      0x0
#define COMPUTE_STATIC_THREAD_MGMT_SE1__SA1_CU_EN__SHIFT                                                      0x10
#define COMPUTE_STATIC_THREAD_MGMT_SE1__SA0_CU_EN_MASK                                                        0x0000FFFFL
#define COMPUTE_STATIC_THREAD_MGMT_SE1__SA1_CU_EN_MASK                                                        0xFFFF0000L
//COMPUTE_TMPRING_SIZE
#define COMPUTE_TMPRING_SIZE__WAVES__SHIFT                                                                    0x0
#define COMPUTE_TMPRING_SIZE__WAVESIZE__SHIFT                                                                 0xc
#define COMPUTE_TMPRING_SIZE__WAVES_MASK                                                                      0x00000FFFL
#define COMPUTE_TMPRING_SIZE__WAVESIZE_MASK                                                                   0x3FFFF000L
//COMPUTE_DESTINATION_EN_SE2
#define COMPUTE_DESTINATION_EN_SE2__CU_EN__SHIFT                                                              0x0
#define COMPUTE_DESTINATION_EN_SE2__CU_EN_MASK                                                                0xFFFFFFFFL
//COMPUTE_STATIC_THREAD_MGMT_SE2
#define COMPUTE_STATIC_THREAD_MGMT_SE2__SA0_CU_EN__SHIFT                                                      0x0
#define COMPUTE_STATIC_THREAD_MGMT_SE2__SA1_CU_EN__SHIFT                                                      0x10
#define COMPUTE_STATIC_THREAD_MGMT_SE2__SA0_CU_EN_MASK                                                        0x0000FFFFL
#define COMPUTE_STATIC_THREAD_MGMT_SE2__SA1_CU_EN_MASK                                                        0xFFFF0000L
//COMPUTE_DESTINATION_EN_SE3
#define COMPUTE_DESTINATION_EN_SE3__CU_EN__SHIFT                                                              0x0
#define COMPUTE_DESTINATION_EN_SE3__CU_EN_MASK                                                                0xFFFFFFFFL
//COMPUTE_STATIC_THREAD_MGMT_SE3
#define COMPUTE_STATIC_THREAD_MGMT_SE3__SA0_CU_EN__SHIFT                                                      0x0
#define COMPUTE_STATIC_THREAD_MGMT_SE3__SA1_CU_EN__SHIFT                                                      0x10
#define COMPUTE_STATIC_THREAD_MGMT_SE3__SA0_CU_EN_MASK                                                        0x0000FFFFL
#define COMPUTE_STATIC_THREAD_MGMT_SE3__SA1_CU_EN_MASK                                                        0xFFFF0000L
//COMPUTE_RESTART_X
#define COMPUTE_RESTART_X__RESTART__SHIFT                                                                     0x0
#define COMPUTE_RESTART_X__RESTART_MASK                                                                       0xFFFFFFFFL
//COMPUTE_RESTART_Y
#define COMPUTE_RESTART_Y__RESTART__SHIFT                                                                     0x0
#define COMPUTE_RESTART_Y__RESTART_MASK                                                                       0xFFFFFFFFL
//COMPUTE_RESTART_Z
#define COMPUTE_RESTART_Z__RESTART__SHIFT                                                                     0x0
#define COMPUTE_RESTART_Z__RESTART_MASK                                                                       0xFFFFFFFFL
//COMPUTE_THREAD_TRACE_ENABLE
#define COMPUTE_THREAD_TRACE_ENABLE__THREAD_TRACE_ENABLE__SHIFT                                               0x0
#define COMPUTE_THREAD_TRACE_ENABLE__THREAD_TRACE_ENABLE_MASK                                                 0x00000001L
//COMPUTE_MISC_RESERVED
#define COMPUTE_MISC_RESERVED__SEND_SEID__SHIFT                                                               0x0
#define COMPUTE_MISC_RESERVED__RESERVED4__SHIFT                                                               0x4
#define COMPUTE_MISC_RESERVED__WAVE_ID_BASE__SHIFT                                                            0x5
#define COMPUTE_MISC_RESERVED__SEND_SEID_MASK                                                                 0x0000000FL
#define COMPUTE_MISC_RESERVED__RESERVED4_MASK                                                                 0x00000010L
#define COMPUTE_MISC_RESERVED__WAVE_ID_BASE_MASK                                                              0x0001FFE0L
//COMPUTE_DISPATCH_ID
#define COMPUTE_DISPATCH_ID__DISPATCH_ID__SHIFT                                                               0x0
#define COMPUTE_DISPATCH_ID__DISPATCH_ID_MASK                                                                 0xFFFFFFFFL
//COMPUTE_THREADGROUP_ID
#define COMPUTE_THREADGROUP_ID__THREADGROUP_ID__SHIFT                                                         0x0
#define COMPUTE_THREADGROUP_ID__THREADGROUP_ID_MASK                                                           0xFFFFFFFFL
//COMPUTE_REQ_CTRL
#define COMPUTE_REQ_CTRL__SOFT_GROUPING_EN__SHIFT                                                             0x0
#define COMPUTE_REQ_CTRL__NUMBER_OF_REQUESTS_PER_CU__SHIFT                                                    0x1
#define COMPUTE_REQ_CTRL__SOFT_GROUPING_ALLOCATION_TIMEOUT__SHIFT                                             0x5
#define COMPUTE_REQ_CTRL__HARD_LOCK_HYSTERESIS__SHIFT                                                         0x9
#define COMPUTE_REQ_CTRL__HARD_LOCK_LOW_THRESHOLD__SHIFT                                                      0xa
#define COMPUTE_REQ_CTRL__PRODUCER_REQUEST_LOCKOUT__SHIFT                                                     0xf
#define COMPUTE_REQ_CTRL__GLOBAL_SCANNING_EN__SHIFT                                                           0x10
#define COMPUTE_REQ_CTRL__ALLOCATION_RATE_THROTTLING_THRESHOLD__SHIFT                                         0x11
#define COMPUTE_REQ_CTRL__DEDICATED_PREALLOCATION_BUFFER_LIMIT__SHIFT                                         0x14
#define COMPUTE_REQ_CTRL__SOFT_GROUPING_EN_MASK                                                               0x00000001L
#define COMPUTE_REQ_CTRL__NUMBER_OF_REQUESTS_PER_CU_MASK                                                      0x0000001EL
#define COMPUTE_REQ_CTRL__SOFT_GROUPING_ALLOCATION_TIMEOUT_MASK                                               0x000001E0L
#define COMPUTE_REQ_CTRL__HARD_LOCK_HYSTERESIS_MASK                                                           0x00000200L
#define COMPUTE_REQ_CTRL__HARD_LOCK_LOW_THRESHOLD_MASK                                                        0x00007C00L
#define COMPUTE_REQ_CTRL__PRODUCER_REQUEST_LOCKOUT_MASK                                                       0x00008000L
#define COMPUTE_REQ_CTRL__GLOBAL_SCANNING_EN_MASK                                                             0x00010000L
#define COMPUTE_REQ_CTRL__ALLOCATION_RATE_THROTTLING_THRESHOLD_MASK                                           0x000E0000L
#define COMPUTE_REQ_CTRL__DEDICATED_PREALLOCATION_BUFFER_LIMIT_MASK                                           0x07F00000L
//COMPUTE_STATIC_THREAD_MGMT_SE8
#define COMPUTE_STATIC_THREAD_MGMT_SE8__SA0_CU_EN__SHIFT                                                      0x0
#define COMPUTE_STATIC_THREAD_MGMT_SE8__SA1_CU_EN__SHIFT                                                      0x10
#define COMPUTE_STATIC_THREAD_MGMT_SE8__SA0_CU_EN_MASK                                                        0x0000FFFFL
#define COMPUTE_STATIC_THREAD_MGMT_SE8__SA1_CU_EN_MASK                                                        0xFFFF0000L
//COMPUTE_USER_ACCUM_0
#define COMPUTE_USER_ACCUM_0__CONTRIBUTION__SHIFT                                                             0x0
#define COMPUTE_USER_ACCUM_0__CONTRIBUTION_MASK                                                               0x0000007FL
//COMPUTE_USER_ACCUM_1
#define COMPUTE_USER_ACCUM_1__CONTRIBUTION__SHIFT                                                             0x0
#define COMPUTE_USER_ACCUM_1__CONTRIBUTION_MASK                                                               0x0000007FL
//COMPUTE_USER_ACCUM_2
#define COMPUTE_USER_ACCUM_2__CONTRIBUTION__SHIFT                                                             0x0
#define COMPUTE_USER_ACCUM_2__CONTRIBUTION_MASK                                                               0x0000007FL
//COMPUTE_USER_ACCUM_3
#define COMPUTE_USER_ACCUM_3__CONTRIBUTION__SHIFT                                                             0x0
#define COMPUTE_USER_ACCUM_3__CONTRIBUTION_MASK                                                               0x0000007FL
//COMPUTE_PGM_RSRC3
#define COMPUTE_PGM_RSRC3__SHARED_VGPR_CNT__SHIFT                                                             0x0
#define COMPUTE_PGM_RSRC3__INST_PREF_SIZE__SHIFT                                                              0x4
#define COMPUTE_PGM_RSRC3__GLG_EN__SHIFT                                                                      0xd
#define COMPUTE_PGM_RSRC3__IMAGE_OP__SHIFT                                                                    0x1f
#define COMPUTE_PGM_RSRC3__SHARED_VGPR_CNT_MASK                                                               0x0000000FL
#define COMPUTE_PGM_RSRC3__INST_PREF_SIZE_MASK                                                                0x00000FF0L
#define COMPUTE_PGM_RSRC3__GLG_EN_MASK                                                                        0x00002000L
#define COMPUTE_PGM_RSRC3__IMAGE_OP_MASK                                                                      0x80000000L
//COMPUTE_DDID_INDEX
#define COMPUTE_DDID_INDEX__INDEX__SHIFT                                                                      0x0
#define COMPUTE_DDID_INDEX__INDEX_MASK                                                                        0x000007FFL
//COMPUTE_SHADER_CHKSUM
#define COMPUTE_SHADER_CHKSUM__CHECKSUM__SHIFT                                                                0x0
#define COMPUTE_SHADER_CHKSUM__CHECKSUM_MASK                                                                  0xFFFFFFFFL
//COMPUTE_STATIC_THREAD_MGMT_SE4
#define COMPUTE_STATIC_THREAD_MGMT_SE4__SA0_CU_EN__SHIFT                                                      0x0
#define COMPUTE_STATIC_THREAD_MGMT_SE4__SA1_CU_EN__SHIFT                                                      0x10
#define COMPUTE_STATIC_THREAD_MGMT_SE4__SA0_CU_EN_MASK                                                        0x0000FFFFL
#define COMPUTE_STATIC_THREAD_MGMT_SE4__SA1_CU_EN_MASK                                                        0xFFFF0000L
//COMPUTE_STATIC_THREAD_MGMT_SE5
#define COMPUTE_STATIC_THREAD_MGMT_SE5__SA0_CU_EN__SHIFT                                                      0x0
#define COMPUTE_STATIC_THREAD_MGMT_SE5__SA1_CU_EN__SHIFT                                                      0x10
#define COMPUTE_STATIC_THREAD_MGMT_SE5__SA0_CU_EN_MASK                                                        0x0000FFFFL
#define COMPUTE_STATIC_THREAD_MGMT_SE5__SA1_CU_EN_MASK                                                        0xFFFF0000L
//COMPUTE_STATIC_THREAD_MGMT_SE6
#define COMPUTE_STATIC_THREAD_MGMT_SE6__SA0_CU_EN__SHIFT                                                      0x0
#define COMPUTE_STATIC_THREAD_MGMT_SE6__SA1_CU_EN__SHIFT                                                      0x10
#define COMPUTE_STATIC_THREAD_MGMT_SE6__SA0_CU_EN_MASK                                                        0x0000FFFFL
#define COMPUTE_STATIC_THREAD_MGMT_SE6__SA1_CU_EN_MASK                                                        0xFFFF0000L
//COMPUTE_STATIC_THREAD_MGMT_SE7
#define COMPUTE_STATIC_THREAD_MGMT_SE7__SA0_CU_EN__SHIFT                                                      0x0
#define COMPUTE_STATIC_THREAD_MGMT_SE7__SA1_CU_EN__SHIFT                                                      0x10
#define COMPUTE_STATIC_THREAD_MGMT_SE7__SA0_CU_EN_MASK                                                        0x0000FFFFL
#define COMPUTE_STATIC_THREAD_MGMT_SE7__SA1_CU_EN_MASK                                                        0xFFFF0000L
//COMPUTE_DISPATCH_INTERLEAVE
#define COMPUTE_DISPATCH_INTERLEAVE__INTERLEAVE_1D__SHIFT                                                     0x0
#define COMPUTE_DISPATCH_INTERLEAVE__INTERLEAVE_2D_X_SIZE__SHIFT                                              0x10
#define COMPUTE_DISPATCH_INTERLEAVE__INTERLEAVE_2D_Y_SIZE__SHIFT                                              0x18
#define COMPUTE_DISPATCH_INTERLEAVE__INTERLEAVE_1D_MASK                                                       0x000003FFL
#define COMPUTE_DISPATCH_INTERLEAVE__INTERLEAVE_2D_X_SIZE_MASK                                                0x000F0000L
#define COMPUTE_DISPATCH_INTERLEAVE__INTERLEAVE_2D_Y_SIZE_MASK                                                0x0F000000L
//COMPUTE_RELAUNCH
#define COMPUTE_RELAUNCH__PAYLOAD__SHIFT                                                                      0x0
#define COMPUTE_RELAUNCH__IS_EVENT__SHIFT                                                                     0x1e
#define COMPUTE_RELAUNCH__IS_STATE__SHIFT                                                                     0x1f
#define COMPUTE_RELAUNCH__PAYLOAD_MASK                                                                        0x3FFFFFFFL
#define COMPUTE_RELAUNCH__IS_EVENT_MASK                                                                       0x40000000L
#define COMPUTE_RELAUNCH__IS_STATE_MASK                                                                       0x80000000L
//COMPUTE_WAVE_RESTORE_ADDR_LO
#define COMPUTE_WAVE_RESTORE_ADDR_LO__ADDR__SHIFT                                                             0x0
#define COMPUTE_WAVE_RESTORE_ADDR_LO__ADDR_MASK                                                               0xFFFFFFFFL
//COMPUTE_WAVE_RESTORE_ADDR_HI
#define COMPUTE_WAVE_RESTORE_ADDR_HI__ADDR__SHIFT                                                             0x0
#define COMPUTE_WAVE_RESTORE_ADDR_HI__ADDR_MASK                                                               0x0000FFFFL
//COMPUTE_RELAUNCH2
#define COMPUTE_RELAUNCH2__PAYLOAD__SHIFT                                                                     0x0
#define COMPUTE_RELAUNCH2__IS_EVENT__SHIFT                                                                    0x1e
#define COMPUTE_RELAUNCH2__IS_STATE__SHIFT                                                                    0x1f
#define COMPUTE_RELAUNCH2__PAYLOAD_MASK                                                                       0x3FFFFFFFL
#define COMPUTE_RELAUNCH2__IS_EVENT_MASK                                                                      0x40000000L
#define COMPUTE_RELAUNCH2__IS_STATE_MASK                                                                      0x80000000L
//COMPUTE_PRESCALED_DIM_X
#define COMPUTE_PRESCALED_DIM_X__SIZE__SHIFT                                                                  0x0
#define COMPUTE_PRESCALED_DIM_X__SIZE_MASK                                                                    0xFFFFFFFFL
//COMPUTE_PRESCALED_DIM_Y
#define COMPUTE_PRESCALED_DIM_Y__SIZE__SHIFT                                                                  0x0
#define COMPUTE_PRESCALED_DIM_Y__SIZE_MASK                                                                    0xFFFFFFFFL
//COMPUTE_PRESCALED_DIM_Z
#define COMPUTE_PRESCALED_DIM_Z__SIZE__SHIFT                                                                  0x0
#define COMPUTE_PRESCALED_DIM_Z__SIZE_MASK                                                                    0xFFFFFFFFL
//COMPUTE_USER_DATA_0
#define COMPUTE_USER_DATA_0__DATA__SHIFT                                                                      0x0
#define COMPUTE_USER_DATA_0__DATA_MASK                                                                        0xFFFFFFFFL
//COMPUTE_USER_DATA_1
#define COMPUTE_USER_DATA_1__DATA__SHIFT                                                                      0x0
#define COMPUTE_USER_DATA_1__DATA_MASK                                                                        0xFFFFFFFFL
//COMPUTE_USER_DATA_2
#define COMPUTE_USER_DATA_2__DATA__SHIFT                                                                      0x0
#define COMPUTE_USER_DATA_2__DATA_MASK                                                                        0xFFFFFFFFL
//COMPUTE_USER_DATA_3
#define COMPUTE_USER_DATA_3__DATA__SHIFT                                                                      0x0
#define COMPUTE_USER_DATA_3__DATA_MASK                                                                        0xFFFFFFFFL
//COMPUTE_USER_DATA_4
#define COMPUTE_USER_DATA_4__DATA__SHIFT                                                                      0x0
#define COMPUTE_USER_DATA_4__DATA_MASK                                                                        0xFFFFFFFFL
//COMPUTE_USER_DATA_5
#define COMPUTE_USER_DATA_5__DATA__SHIFT                                                                      0x0
#define COMPUTE_USER_DATA_5__DATA_MASK                                                                        0xFFFFFFFFL
//COMPUTE_USER_DATA_6
#define COMPUTE_USER_DATA_6__DATA__SHIFT                                                                      0x0
#define COMPUTE_USER_DATA_6__DATA_MASK                                                                        0xFFFFFFFFL
//COMPUTE_USER_DATA_7
#define COMPUTE_USER_DATA_7__DATA__SHIFT                                                                      0x0
#define COMPUTE_USER_DATA_7__DATA_MASK                                                                        0xFFFFFFFFL
//COMPUTE_USER_DATA_8
#define COMPUTE_USER_DATA_8__DATA__SHIFT                                                                      0x0
#define COMPUTE_USER_DATA_8__DATA_MASK                                                                        0xFFFFFFFFL
//COMPUTE_USER_DATA_9
#define COMPUTE_USER_DATA_9__DATA__SHIFT                                                                      0x0
#define COMPUTE_USER_DATA_9__DATA_MASK                                                                        0xFFFFFFFFL
//COMPUTE_USER_DATA_10
#define COMPUTE_USER_DATA_10__DATA__SHIFT                                                                     0x0
#define COMPUTE_USER_DATA_10__DATA_MASK                                                                       0xFFFFFFFFL
//COMPUTE_USER_DATA_11
#define COMPUTE_USER_DATA_11__DATA__SHIFT                                                                     0x0
#define COMPUTE_USER_DATA_11__DATA_MASK                                                                       0xFFFFFFFFL
//COMPUTE_USER_DATA_12
#define COMPUTE_USER_DATA_12__DATA__SHIFT                                                                     0x0
#define COMPUTE_USER_DATA_12__DATA_MASK                                                                       0xFFFFFFFFL
//COMPUTE_USER_DATA_13
#define COMPUTE_USER_DATA_13__DATA__SHIFT                                                                     0x0
#define COMPUTE_USER_DATA_13__DATA_MASK                                                                       0xFFFFFFFFL
//COMPUTE_USER_DATA_14
#define COMPUTE_USER_DATA_14__DATA__SHIFT                                                                     0x0
#define COMPUTE_USER_DATA_14__DATA_MASK                                                                       0xFFFFFFFFL
//COMPUTE_USER_DATA_15
#define COMPUTE_USER_DATA_15__DATA__SHIFT                                                                     0x0
#define COMPUTE_USER_DATA_15__DATA_MASK                                                                       0xFFFFFFFFL
//COMPUTE_DISPATCH_TUNNEL
#define COMPUTE_DISPATCH_TUNNEL__OFF_DELAY__SHIFT                                                             0x0
#define COMPUTE_DISPATCH_TUNNEL__OFF_DELAY_MASK                                                               0x00001FFFL
//COMPUTE_DISPATCH_END
#define COMPUTE_DISPATCH_END__DATA__SHIFT                                                                     0x0
#define COMPUTE_DISPATCH_END__DATA_MASK                                                                       0xFFFFFFFFL
//COMPUTE_NOWHERE
#define COMPUTE_NOWHERE__DATA__SHIFT                                                                          0x0
#define COMPUTE_NOWHERE__DATA_MASK                                                                            0xFFFFFFFFL
//SH_RESERVED_REG0
#define SH_RESERVED_REG0__DATA__SHIFT                                                                         0x0
#define SH_RESERVED_REG0__DATA_MASK                                                                           0xFFFFFFFFL
//SH_RESERVED_REG1
#define SH_RESERVED_REG1__DATA__SHIFT                                                                         0x0
#define SH_RESERVED_REG1__DATA_MASK                                                                           0xFFFFFFFFL


// addressBlock: gc_gfx_cpwd_cpwd_rasdec
//RAS_GE_SIGNATURE0
#define RAS_GE_SIGNATURE0__SIGNATURE__SHIFT                                                                   0x0
#define RAS_GE_SIGNATURE0__SIGNATURE_MASK                                                                     0xFFFFFFFFL


// addressBlock: gc_gfx_cpwd_cpwd_pfonly_gccacdec
//GC_CAC_CTRL_1
#define GC_CAC_CTRL_1__CAC_WINDOW__SHIFT                                                                      0x0
#define GC_CAC_CTRL_1__TDP_WINDOW__SHIFT                                                                      0x8
#define GC_CAC_CTRL_1__CAC_WINDOW_MASK                                                                        0x000000FFL
#define GC_CAC_CTRL_1__TDP_WINDOW_MASK                                                                        0xFFFFFF00L
//GC_CAC_CTRL_2
#define GC_CAC_CTRL_2__CAC_ENABLE__SHIFT                                                                      0x0
#define GC_CAC_CTRL_2__GC_LCAC_ENABLE__SHIFT                                                                  0x1
#define GC_CAC_CTRL_2__GC_CAC_INDEX_AUTO_INCR_EN__SHIFT                                                       0x2
#define GC_CAC_CTRL_2__TOGGLE_EN__SHIFT                                                                       0x3
#define GC_CAC_CTRL_2__INTR_EN__SHIFT                                                                         0x4
#define GC_CAC_CTRL_2__CAC_COUNTER_SNAP_SEL__SHIFT                                                            0x5
#define GC_CAC_CTRL_2__SE_AGGR_ACC_EN__SHIFT                                                                  0x6
#define GC_CAC_CTRL_2__GC_AGGR_ACC_EN__SHIFT                                                                  0xf
#define GC_CAC_CTRL_2__GC_LCAC_OVR_EN__SHIFT                                                                  0x10
#define GC_CAC_CTRL_2__CAC_SOFT_CTRL_ENABLE__SHIFT                                                            0x11
#define GC_CAC_CTRL_2__CAC_INTR_MAX_HYSTERESIS__SHIFT                                                         0x12
#define GC_CAC_CTRL_2__CAC_ENABLE_MASK                                                                        0x00000001L
#define GC_CAC_CTRL_2__GC_LCAC_ENABLE_MASK                                                                    0x00000002L
#define GC_CAC_CTRL_2__GC_CAC_INDEX_AUTO_INCR_EN_MASK                                                         0x00000004L
#define GC_CAC_CTRL_2__TOGGLE_EN_MASK                                                                         0x00000008L
#define GC_CAC_CTRL_2__INTR_EN_MASK                                                                           0x00000010L
#define GC_CAC_CTRL_2__CAC_COUNTER_SNAP_SEL_MASK                                                              0x00000020L
#define GC_CAC_CTRL_2__SE_AGGR_ACC_EN_MASK                                                                    0x00007FC0L
#define GC_CAC_CTRL_2__GC_AGGR_ACC_EN_MASK                                                                    0x00008000L
#define GC_CAC_CTRL_2__GC_LCAC_OVR_EN_MASK                                                                    0x00010000L
#define GC_CAC_CTRL_2__CAC_SOFT_CTRL_ENABLE_MASK                                                              0x00020000L
#define GC_CAC_CTRL_2__CAC_INTR_MAX_HYSTERESIS_MASK                                                           0x00FC0000L
//GC_CAC_AGGR_LOWER
#define GC_CAC_AGGR_LOWER__GC_AGGR_31_0__SHIFT                                                                0x0
#define GC_CAC_AGGR_LOWER__GC_AGGR_31_0_MASK                                                                  0xFFFFFFFFL
//GC_CAC_AGGR_UPPER
#define GC_CAC_AGGR_UPPER__GC_AGGR_63_32__SHIFT                                                               0x0
#define GC_CAC_AGGR_UPPER__GC_AGGR_63_32_MASK                                                                 0xFFFFFFFFL
//SE0_CAC_AGGR_LOWER
#define SE0_CAC_AGGR_LOWER__SE0_AGGR_31_0__SHIFT                                                              0x0
#define SE0_CAC_AGGR_LOWER__SE0_AGGR_31_0_MASK                                                                0xFFFFFFFFL
//SE0_CAC_AGGR_UPPER
#define SE0_CAC_AGGR_UPPER__SE0_AGGR_63_32__SHIFT                                                             0x0
#define SE0_CAC_AGGR_UPPER__SE0_AGGR_63_32_MASK                                                               0xFFFFFFFFL
//SE1_CAC_AGGR_LOWER
#define SE1_CAC_AGGR_LOWER__SE1_AGGR_31_0__SHIFT                                                              0x0
#define SE1_CAC_AGGR_LOWER__SE1_AGGR_31_0_MASK                                                                0xFFFFFFFFL
//SE1_CAC_AGGR_UPPER
#define SE1_CAC_AGGR_UPPER__SE1_AGGR_63_32__SHIFT                                                             0x0
#define SE1_CAC_AGGR_UPPER__SE1_AGGR_63_32_MASK                                                               0xFFFFFFFFL
//SE2_CAC_AGGR_LOWER
#define SE2_CAC_AGGR_LOWER__SE2_AGGR_31_0__SHIFT                                                              0x0
#define SE2_CAC_AGGR_LOWER__SE2_AGGR_31_0_MASK                                                                0xFFFFFFFFL
//SE2_CAC_AGGR_UPPER
#define SE2_CAC_AGGR_UPPER__SE2_AGGR_63_32__SHIFT                                                             0x0
#define SE2_CAC_AGGR_UPPER__SE2_AGGR_63_32_MASK                                                               0xFFFFFFFFL
//SE3_CAC_AGGR_LOWER
#define SE3_CAC_AGGR_LOWER__SE3_AGGR_31_0__SHIFT                                                              0x0
#define SE3_CAC_AGGR_LOWER__SE3_AGGR_31_0_MASK                                                                0xFFFFFFFFL
//SE3_CAC_AGGR_UPPER
#define SE3_CAC_AGGR_UPPER__SE3_AGGR_63_32__SHIFT                                                             0x0
#define SE3_CAC_AGGR_UPPER__SE3_AGGR_63_32_MASK                                                               0xFFFFFFFFL
//GC_CAC_AGGR_GFXCLK_CYCLE
#define GC_CAC_AGGR_GFXCLK_CYCLE__GC_AGGR_GFXCLK_CYCLE__SHIFT                                                 0x0
#define GC_CAC_AGGR_GFXCLK_CYCLE__GC_AGGR_GFXCLK_CYCLE_MASK                                                   0xFFFFFFFFL
//SE0_CAC_AGGR_GFXCLK_CYCLE
#define SE0_CAC_AGGR_GFXCLK_CYCLE__SE0_AGGR_GFXCLK_CYCLE__SHIFT                                               0x0
#define SE0_CAC_AGGR_GFXCLK_CYCLE__SE0_AGGR_GFXCLK_CYCLE_MASK                                                 0xFFFFFFFFL
//SE1_CAC_AGGR_GFXCLK_CYCLE
#define SE1_CAC_AGGR_GFXCLK_CYCLE__SE1_AGGR_GFXCLK_CYCLE__SHIFT                                               0x0
#define SE1_CAC_AGGR_GFXCLK_CYCLE__SE1_AGGR_GFXCLK_CYCLE_MASK                                                 0xFFFFFFFFL
//SE2_CAC_AGGR_GFXCLK_CYCLE
#define SE2_CAC_AGGR_GFXCLK_CYCLE__SE2_AGGR_GFXCLK_CYCLE__SHIFT                                               0x0
#define SE2_CAC_AGGR_GFXCLK_CYCLE__SE2_AGGR_GFXCLK_CYCLE_MASK                                                 0xFFFFFFFFL
//SE3_CAC_AGGR_GFXCLK_CYCLE
#define SE3_CAC_AGGR_GFXCLK_CYCLE__SE3_AGGR_GFXCLK_CYCLE__SHIFT                                               0x0
#define SE3_CAC_AGGR_GFXCLK_CYCLE__SE3_AGGR_GFXCLK_CYCLE_MASK                                                 0xFFFFFFFFL
//GC_EDC_CTRL
#define GC_EDC_CTRL__EDC_EN__SHIFT                                                                            0x0
#define GC_EDC_CTRL__EDC_SW_RST__SHIFT                                                                        0x1
#define GC_EDC_CTRL__EDC_CLK_EN_OVERRIDE__SHIFT                                                               0x2
#define GC_EDC_CTRL__EDC_FORCE_STALL__SHIFT                                                                   0x3
#define GC_EDC_CTRL__EDC_TRIGGER_THROTTLE_LOWBIT__SHIFT                                                       0x4
#define GC_EDC_CTRL__EDC_ALLOW_WRITE_PWRDELTA__SHIFT                                                          0xa
#define GC_EDC_CTRL__EDC_THROTTLE_PATTERN_BIT_NUMS__SHIFT                                                     0xb
#define GC_EDC_CTRL__EDC_LEVEL_SEL__SHIFT                                                                     0xf
#define GC_EDC_CTRL__EDC_ALGORITHM_MODE__SHIFT                                                                0x10
#define GC_EDC_CTRL__EDC_AVGDIV__SHIFT                                                                        0x11
#define GC_EDC_CTRL__PSM_THROTTLE_SRC_SEL__SHIFT                                                              0x15
#define GC_EDC_CTRL__THROTTLE_SRC0_MASK__SHIFT                                                                0x18
#define GC_EDC_CTRL__THROTTLE_SRC1_MASK__SHIFT                                                                0x19
#define GC_EDC_CTRL__THROTTLE_SRC2_MASK__SHIFT                                                                0x1a
#define GC_EDC_CTRL__THROTTLE_SRC3_MASK__SHIFT                                                                0x1b
#define GC_EDC_CTRL__EDC_CREDIT_SHIFT_BIT_NUMS__SHIFT                                                         0x1c
#define GC_EDC_CTRL__EDC_EN_MASK                                                                              0x00000001L
#define GC_EDC_CTRL__EDC_SW_RST_MASK                                                                          0x00000002L
#define GC_EDC_CTRL__EDC_CLK_EN_OVERRIDE_MASK                                                                 0x00000004L
#define GC_EDC_CTRL__EDC_FORCE_STALL_MASK                                                                     0x00000008L
#define GC_EDC_CTRL__EDC_TRIGGER_THROTTLE_LOWBIT_MASK                                                         0x000003F0L
#define GC_EDC_CTRL__EDC_ALLOW_WRITE_PWRDELTA_MASK                                                            0x00000400L
#define GC_EDC_CTRL__EDC_THROTTLE_PATTERN_BIT_NUMS_MASK                                                       0x00007800L
#define GC_EDC_CTRL__EDC_LEVEL_SEL_MASK                                                                       0x00008000L
#define GC_EDC_CTRL__EDC_ALGORITHM_MODE_MASK                                                                  0x00010000L
#define GC_EDC_CTRL__EDC_AVGDIV_MASK                                                                          0x001E0000L
#define GC_EDC_CTRL__PSM_THROTTLE_SRC_SEL_MASK                                                                0x00E00000L
#define GC_EDC_CTRL__THROTTLE_SRC0_MASK_MASK                                                                  0x01000000L
#define GC_EDC_CTRL__THROTTLE_SRC1_MASK_MASK                                                                  0x02000000L
#define GC_EDC_CTRL__THROTTLE_SRC2_MASK_MASK                                                                  0x04000000L
#define GC_EDC_CTRL__THROTTLE_SRC3_MASK_MASK                                                                  0x08000000L
#define GC_EDC_CTRL__EDC_CREDIT_SHIFT_BIT_NUMS_MASK                                                           0xF0000000L
//GC_EDC_STRETCH_CTRL
#define GC_EDC_STRETCH_CTRL__EDC_STRETCH_EN__SHIFT                                                            0x0
#define GC_EDC_STRETCH_CTRL__EDC_STRETCH_DELAY__SHIFT                                                         0x1
#define GC_EDC_STRETCH_CTRL__EDC_UNSTRETCH_DELAY__SHIFT                                                       0xa
#define GC_EDC_STRETCH_CTRL__EDC_STRETCH_EN_MASK                                                              0x00000001L
#define GC_EDC_STRETCH_CTRL__EDC_STRETCH_DELAY_MASK                                                           0x000003FEL
#define GC_EDC_STRETCH_CTRL__EDC_UNSTRETCH_DELAY_MASK                                                         0x0007FC00L
//GC_EDC_THRESHOLD_LO
#define GC_EDC_THRESHOLD_LO__EDC_THRESHOLD_LO__SHIFT                                                          0x0
#define GC_EDC_THRESHOLD_LO__EDC_THRESHOLD_LO_MASK                                                            0xFFFFFFFFL
//GC_EDC_THRESHOLD_HI
#define GC_EDC_THRESHOLD_HI__EDC_THRESHOLD_HI__SHIFT                                                          0x0
#define GC_EDC_THRESHOLD_HI__EDC_THRESHOLD_HI_MASK                                                            0xFFFFFFFFL
//GC_EDC_STRETCH_THRESHOLD_LO
#define GC_EDC_STRETCH_THRESHOLD_LO__EDC_STRETCH_THRESHOLD_LO__SHIFT                                          0x0
#define GC_EDC_STRETCH_THRESHOLD_LO__EDC_STRETCH_THRESHOLD_LO_MASK                                            0xFFFFFFFFL
//GC_EDC_STRETCH_THRESHOLD_HI
#define GC_EDC_STRETCH_THRESHOLD_HI__EDC_STRETCH_THRESHOLD_HI__SHIFT                                          0x0
#define GC_EDC_STRETCH_THRESHOLD_HI__EDC_STRETCH_THRESHOLD_HI_MASK                                            0xFFFFFFFFL
//EDC_HYSTERESIS_CNTL
#define EDC_HYSTERESIS_CNTL__MAX_HYSTERESIS__SHIFT                                                            0x0
#define EDC_HYSTERESIS_CNTL__EDC_AGGR_TIMER__SHIFT                                                            0x8
#define EDC_HYSTERESIS_CNTL__PATTERN_EXTEND_EN__SHIFT                                                         0x10
#define EDC_HYSTERESIS_CNTL__PATTERN_EXTEND_MODE__SHIFT                                                       0x11
#define EDC_HYSTERESIS_CNTL__EDC_AGGR_MODE__SHIFT                                                             0x14
#define EDC_HYSTERESIS_CNTL__MAX_HYSTERESIS_MASK                                                              0x000000FFL
#define EDC_HYSTERESIS_CNTL__EDC_AGGR_TIMER_MASK                                                              0x0000FF00L
#define EDC_HYSTERESIS_CNTL__PATTERN_EXTEND_EN_MASK                                                           0x00010000L
#define EDC_HYSTERESIS_CNTL__PATTERN_EXTEND_MODE_MASK                                                         0x000E0000L
#define EDC_HYSTERESIS_CNTL__EDC_AGGR_MODE_MASK                                                               0x00100000L
//GC_THROTTLE_CTRL
#define GC_THROTTLE_CTRL__THROTTLE_CTRL_SW_RST__SHIFT                                                         0x0
#define GC_THROTTLE_CTRL__GC_EDC_STALL_EN__SHIFT                                                              0x1
#define GC_THROTTLE_CTRL__PWRBRK_STALL_EN__SHIFT                                                              0x2
#define GC_THROTTLE_CTRL__PWRBRK_POLARITY_CNTL__SHIFT                                                         0x3
#define GC_THROTTLE_CTRL__PCC_STALL_EN__SHIFT                                                                 0x4
#define GC_THROTTLE_CTRL__PATTERN_MODE__SHIFT                                                                 0x5
#define GC_THROTTLE_CTRL__GC_EDC_ONLY_MODE__SHIFT                                                             0x6
#define GC_THROTTLE_CTRL__GC_EDC_OVERRIDE__SHIFT                                                              0x7
#define GC_THROTTLE_CTRL__PCC_OVERRIDE__SHIFT                                                                 0x8
#define GC_THROTTLE_CTRL__PWRBRK_OVERRIDE__SHIFT                                                              0x9
#define GC_THROTTLE_CTRL__GC_EDC_PERF_COUNTER_EN__SHIFT                                                       0xa
#define GC_THROTTLE_CTRL__PCC_PERF_COUNTER_EN__SHIFT                                                          0xb
#define GC_THROTTLE_CTRL__PWRBRK_PERF_COUNTER_EN__SHIFT                                                       0xc
#define GC_THROTTLE_CTRL__RELEASE_STEP_INTERVAL__SHIFT                                                        0xd
#define GC_THROTTLE_CTRL__FIXED_PATTERN_PERF_COUNTER_EN__SHIFT                                                0x17
#define GC_THROTTLE_CTRL__FIXED_PATTERN_LOG_INDEX__SHIFT                                                      0x18
#define GC_THROTTLE_CTRL__LUT_HW_UPDATE__SHIFT                                                                0x1d
#define GC_THROTTLE_CTRL__THROTTLE_CTRL_CLK_EN_OVERRIDE__SHIFT                                                0x1e
#define GC_THROTTLE_CTRL__PCC_POLARITY_CNTL__SHIFT                                                            0x1f
#define GC_THROTTLE_CTRL__THROTTLE_CTRL_SW_RST_MASK                                                           0x00000001L
#define GC_THROTTLE_CTRL__GC_EDC_STALL_EN_MASK                                                                0x00000002L
#define GC_THROTTLE_CTRL__PWRBRK_STALL_EN_MASK                                                                0x00000004L
#define GC_THROTTLE_CTRL__PWRBRK_POLARITY_CNTL_MASK                                                           0x00000008L
#define GC_THROTTLE_CTRL__PCC_STALL_EN_MASK                                                                   0x00000010L
#define GC_THROTTLE_CTRL__PATTERN_MODE_MASK                                                                   0x00000020L
#define GC_THROTTLE_CTRL__GC_EDC_ONLY_MODE_MASK                                                               0x00000040L
#define GC_THROTTLE_CTRL__GC_EDC_OVERRIDE_MASK                                                                0x00000080L
#define GC_THROTTLE_CTRL__PCC_OVERRIDE_MASK                                                                   0x00000100L
#define GC_THROTTLE_CTRL__PWRBRK_OVERRIDE_MASK                                                                0x00000200L
#define GC_THROTTLE_CTRL__GC_EDC_PERF_COUNTER_EN_MASK                                                         0x00000400L
#define GC_THROTTLE_CTRL__PCC_PERF_COUNTER_EN_MASK                                                            0x00000800L
#define GC_THROTTLE_CTRL__PWRBRK_PERF_COUNTER_EN_MASK                                                         0x00001000L
#define GC_THROTTLE_CTRL__RELEASE_STEP_INTERVAL_MASK                                                          0x007FE000L
#define GC_THROTTLE_CTRL__FIXED_PATTERN_PERF_COUNTER_EN_MASK                                                  0x00800000L
#define GC_THROTTLE_CTRL__FIXED_PATTERN_LOG_INDEX_MASK                                                        0x1F000000L
#define GC_THROTTLE_CTRL__LUT_HW_UPDATE_MASK                                                                  0x20000000L
#define GC_THROTTLE_CTRL__THROTTLE_CTRL_CLK_EN_OVERRIDE_MASK                                                  0x40000000L
#define GC_THROTTLE_CTRL__PCC_POLARITY_CNTL_MASK                                                              0x80000000L
//GC_THROTTLE_CTRL1
#define GC_THROTTLE_CTRL1__PCC_FP_PROGRAM_STEP_EN__SHIFT                                                      0x0
#define GC_THROTTLE_CTRL1__PCC_PROGRAM_MIN_STEP__SHIFT                                                        0x1
#define GC_THROTTLE_CTRL1__PCC_PROGRAM_MAX_STEP__SHIFT                                                        0x5
#define GC_THROTTLE_CTRL1__PCC_PROGRAM_UPWARDS_STEP_SIZE__SHIFT                                               0xa
#define GC_THROTTLE_CTRL1__PWRBRK_FP_PROGRAM_STEP_EN__SHIFT                                                   0xd
#define GC_THROTTLE_CTRL1__PWRBRK_PROGRAM_MIN_STEP__SHIFT                                                     0xe
#define GC_THROTTLE_CTRL1__PWRBRK_PROGRAM_MAX_STEP__SHIFT                                                     0x12
#define GC_THROTTLE_CTRL1__PWRBRK_PROGRAM_UPWARDS_STEP_SIZE__SHIFT                                            0x17
#define GC_THROTTLE_CTRL1__FIXED_PATTERN_SELECT__SHIFT                                                        0x1a
#define GC_THROTTLE_CTRL1__GC_EDC_STRETCH_PERF_COUNTER_EN__SHIFT                                              0x1e
#define GC_THROTTLE_CTRL1__GC_EDC_UNSTRETCH_PERF_COUNTER_EN__SHIFT                                            0x1f
#define GC_THROTTLE_CTRL1__PCC_FP_PROGRAM_STEP_EN_MASK                                                        0x00000001L
#define GC_THROTTLE_CTRL1__PCC_PROGRAM_MIN_STEP_MASK                                                          0x0000001EL
#define GC_THROTTLE_CTRL1__PCC_PROGRAM_MAX_STEP_MASK                                                          0x000003E0L
#define GC_THROTTLE_CTRL1__PCC_PROGRAM_UPWARDS_STEP_SIZE_MASK                                                 0x00001C00L
#define GC_THROTTLE_CTRL1__PWRBRK_FP_PROGRAM_STEP_EN_MASK                                                     0x00002000L
#define GC_THROTTLE_CTRL1__PWRBRK_PROGRAM_MIN_STEP_MASK                                                       0x0003C000L
#define GC_THROTTLE_CTRL1__PWRBRK_PROGRAM_MAX_STEP_MASK                                                       0x007C0000L
#define GC_THROTTLE_CTRL1__PWRBRK_PROGRAM_UPWARDS_STEP_SIZE_MASK                                              0x03800000L
#define GC_THROTTLE_CTRL1__FIXED_PATTERN_SELECT_MASK                                                          0x0C000000L
#define GC_THROTTLE_CTRL1__GC_EDC_STRETCH_PERF_COUNTER_EN_MASK                                                0x40000000L
#define GC_THROTTLE_CTRL1__GC_EDC_UNSTRETCH_PERF_COUNTER_EN_MASK                                              0x80000000L
//GC_THROTTLE_CTRL2
#define GC_THROTTLE_CTRL2__EDC_FP_PROGRAM_STEP_EN__SHIFT                                                      0x0
#define GC_THROTTLE_CTRL2__EDC_PROGRAM_MIN_STEP__SHIFT                                                        0x1
#define GC_THROTTLE_CTRL2__EDC_PROGRAM_MAX_STEP__SHIFT                                                        0x5
#define GC_THROTTLE_CTRL2__EDC_PROGRAM_UPWARDS_STEP_SIZE__SHIFT                                               0xa
#define GC_THROTTLE_CTRL2__PATTERN_COUNTER_NO_RESTART__SHIFT                                                  0xd
#define GC_THROTTLE_CTRL2__EDC_FP_PROGRAM_STEP_EN_MASK                                                        0x00000001L
#define GC_THROTTLE_CTRL2__EDC_PROGRAM_MIN_STEP_MASK                                                          0x0000001EL
#define GC_THROTTLE_CTRL2__EDC_PROGRAM_MAX_STEP_MASK                                                          0x000003E0L
#define GC_THROTTLE_CTRL2__EDC_PROGRAM_UPWARDS_STEP_SIZE_MASK                                                 0x00001C00L
#define GC_THROTTLE_CTRL2__PATTERN_COUNTER_NO_RESTART_MASK                                                    0x00002000L
//EDC_STALL_PATTERN_CTRL
#define EDC_STALL_PATTERN_CTRL__EDC_STEP_INTERVAL__SHIFT                                                      0x0
#define EDC_STALL_PATTERN_CTRL__EDC_BEGIN_STEP__SHIFT                                                         0xa
#define EDC_STALL_PATTERN_CTRL__EDC_END_STEP__SHIFT                                                           0xf
#define EDC_STALL_PATTERN_CTRL__EDC_DITHER_MODE__SHIFT                                                        0x14
#define EDC_STALL_PATTERN_CTRL__EDC_STEP_INTERVAL_MASK                                                        0x000003FFL
#define EDC_STALL_PATTERN_CTRL__EDC_BEGIN_STEP_MASK                                                           0x00007C00L
#define EDC_STALL_PATTERN_CTRL__EDC_END_STEP_MASK                                                             0x000F8000L
#define EDC_STALL_PATTERN_CTRL__EDC_DITHER_MODE_MASK                                                          0x00100000L
//PCC_STALL_PATTERN_CTRL
#define PCC_STALL_PATTERN_CTRL__PCC_STEP_INTERVAL__SHIFT                                                      0x0
#define PCC_STALL_PATTERN_CTRL__PCC_BEGIN_STEP__SHIFT                                                         0xa
#define PCC_STALL_PATTERN_CTRL__PCC_END_STEP__SHIFT                                                           0xf
#define PCC_STALL_PATTERN_CTRL__PCC_THROTTLE_PATTERN_BIT_NUMS__SHIFT                                          0x14
#define PCC_STALL_PATTERN_CTRL__PCC_INST_THROT_INCR__SHIFT                                                    0x18
#define PCC_STALL_PATTERN_CTRL__PCC_INST_THROT_DECR__SHIFT                                                    0x19
#define PCC_STALL_PATTERN_CTRL__PCC_DITHER_MODE__SHIFT                                                        0x1a
#define PCC_STALL_PATTERN_CTRL__PCC_STEP_INTERVAL_MASK                                                        0x000003FFL
#define PCC_STALL_PATTERN_CTRL__PCC_BEGIN_STEP_MASK                                                           0x00007C00L
#define PCC_STALL_PATTERN_CTRL__PCC_END_STEP_MASK                                                             0x000F8000L
#define PCC_STALL_PATTERN_CTRL__PCC_THROTTLE_PATTERN_BIT_NUMS_MASK                                            0x00F00000L
#define PCC_STALL_PATTERN_CTRL__PCC_INST_THROT_INCR_MASK                                                      0x01000000L
#define PCC_STALL_PATTERN_CTRL__PCC_INST_THROT_DECR_MASK                                                      0x02000000L
#define PCC_STALL_PATTERN_CTRL__PCC_DITHER_MODE_MASK                                                          0x04000000L
//PWRBRK_STALL_PATTERN_CTRL
#define PWRBRK_STALL_PATTERN_CTRL__PWRBRK_STEP_INTERVAL__SHIFT                                                0x0
#define PWRBRK_STALL_PATTERN_CTRL__PWRBRK_BEGIN_STEP__SHIFT                                                   0xa
#define PWRBRK_STALL_PATTERN_CTRL__PWRBRK_END_STEP__SHIFT                                                     0xf
#define PWRBRK_STALL_PATTERN_CTRL__PWRBRK_THROTTLE_PATTERN_BIT_NUMS__SHIFT                                    0x14
#define PWRBRK_STALL_PATTERN_CTRL__PWRBRK_STEP_INTERVAL_MASK                                                  0x000003FFL
#define PWRBRK_STALL_PATTERN_CTRL__PWRBRK_BEGIN_STEP_MASK                                                     0x00007C00L
#define PWRBRK_STALL_PATTERN_CTRL__PWRBRK_END_STEP_MASK                                                       0x000F8000L
#define PWRBRK_STALL_PATTERN_CTRL__PWRBRK_THROTTLE_PATTERN_BIT_NUMS_MASK                                      0x00F00000L
//EDC_STALL_PATTERN_1_2
#define EDC_STALL_PATTERN_1_2__EDC_STALL_PATTERN_1__SHIFT                                                     0x0
#define EDC_STALL_PATTERN_1_2__EDC_STALL_PATTERN_2__SHIFT                                                     0x10
#define EDC_STALL_PATTERN_1_2__EDC_STALL_PATTERN_1_MASK                                                       0x00007FFFL
#define EDC_STALL_PATTERN_1_2__EDC_STALL_PATTERN_2_MASK                                                       0x7FFF0000L
//EDC_STALL_PATTERN_3_4
#define EDC_STALL_PATTERN_3_4__EDC_STALL_PATTERN_3__SHIFT                                                     0x0
#define EDC_STALL_PATTERN_3_4__EDC_STALL_PATTERN_4__SHIFT                                                     0x10
#define EDC_STALL_PATTERN_3_4__EDC_STALL_PATTERN_3_MASK                                                       0x00007FFFL
#define EDC_STALL_PATTERN_3_4__EDC_STALL_PATTERN_4_MASK                                                       0x7FFF0000L
//EDC_STALL_PATTERN_5_6
#define EDC_STALL_PATTERN_5_6__EDC_STALL_PATTERN_5__SHIFT                                                     0x0
#define EDC_STALL_PATTERN_5_6__EDC_STALL_PATTERN_6__SHIFT                                                     0x10
#define EDC_STALL_PATTERN_5_6__EDC_STALL_PATTERN_5_MASK                                                       0x00007FFFL
#define EDC_STALL_PATTERN_5_6__EDC_STALL_PATTERN_6_MASK                                                       0x7FFF0000L
//EDC_STALL_PATTERN_7
#define EDC_STALL_PATTERN_7__EDC_STALL_PATTERN_7__SHIFT                                                       0x0
#define EDC_STALL_PATTERN_7__EDC_STALL_PATTERN_7_MASK                                                         0x00007FFFL
//PCC_STALL_PATTERN_1_2
#define PCC_STALL_PATTERN_1_2__PCC_STALL_PATTERN_1__SHIFT                                                     0x0
#define PCC_STALL_PATTERN_1_2__PCC_STALL_PATTERN_2__SHIFT                                                     0x10
#define PCC_STALL_PATTERN_1_2__PCC_STALL_PATTERN_1_MASK                                                       0x00007FFFL
#define PCC_STALL_PATTERN_1_2__PCC_STALL_PATTERN_2_MASK                                                       0x7FFF0000L
//PCC_STALL_PATTERN_3_4
#define PCC_STALL_PATTERN_3_4__PCC_STALL_PATTERN_3__SHIFT                                                     0x0
#define PCC_STALL_PATTERN_3_4__PCC_STALL_PATTERN_4__SHIFT                                                     0x10
#define PCC_STALL_PATTERN_3_4__PCC_STALL_PATTERN_3_MASK                                                       0x00007FFFL
#define PCC_STALL_PATTERN_3_4__PCC_STALL_PATTERN_4_MASK                                                       0x7FFF0000L
//PCC_STALL_PATTERN_5_6
#define PCC_STALL_PATTERN_5_6__PCC_STALL_PATTERN_5__SHIFT                                                     0x0
#define PCC_STALL_PATTERN_5_6__PCC_STALL_PATTERN_6__SHIFT                                                     0x10
#define PCC_STALL_PATTERN_5_6__PCC_STALL_PATTERN_5_MASK                                                       0x00007FFFL
#define PCC_STALL_PATTERN_5_6__PCC_STALL_PATTERN_6_MASK                                                       0x7FFF0000L
//PCC_STALL_PATTERN_7
#define PCC_STALL_PATTERN_7__PCC_STALL_PATTERN_7__SHIFT                                                       0x0
#define PCC_STALL_PATTERN_7__PCC_STALL_PATTERN_7_MASK                                                         0x00007FFFL
//PWRBRK_STALL_PATTERN_1_2
#define PWRBRK_STALL_PATTERN_1_2__PWRBRK_STALL_PATTERN_1__SHIFT                                               0x0
#define PWRBRK_STALL_PATTERN_1_2__PWRBRK_STALL_PATTERN_2__SHIFT                                               0x10
#define PWRBRK_STALL_PATTERN_1_2__PWRBRK_STALL_PATTERN_1_MASK                                                 0x00007FFFL
#define PWRBRK_STALL_PATTERN_1_2__PWRBRK_STALL_PATTERN_2_MASK                                                 0x7FFF0000L
//PWRBRK_STALL_PATTERN_3_4
#define PWRBRK_STALL_PATTERN_3_4__PWRBRK_STALL_PATTERN_3__SHIFT                                               0x0
#define PWRBRK_STALL_PATTERN_3_4__PWRBRK_STALL_PATTERN_4__SHIFT                                               0x10
#define PWRBRK_STALL_PATTERN_3_4__PWRBRK_STALL_PATTERN_3_MASK                                                 0x00007FFFL
#define PWRBRK_STALL_PATTERN_3_4__PWRBRK_STALL_PATTERN_4_MASK                                                 0x7FFF0000L
//PWRBRK_STALL_PATTERN_5_6
#define PWRBRK_STALL_PATTERN_5_6__PWRBRK_STALL_PATTERN_5__SHIFT                                               0x0
#define PWRBRK_STALL_PATTERN_5_6__PWRBRK_STALL_PATTERN_6__SHIFT                                               0x10
#define PWRBRK_STALL_PATTERN_5_6__PWRBRK_STALL_PATTERN_5_MASK                                                 0x00007FFFL
#define PWRBRK_STALL_PATTERN_5_6__PWRBRK_STALL_PATTERN_6_MASK                                                 0x7FFF0000L
//PWRBRK_STALL_PATTERN_7
#define PWRBRK_STALL_PATTERN_7__PWRBRK_STALL_PATTERN_7__SHIFT                                                 0x0
#define PWRBRK_STALL_PATTERN_7__PWRBRK_STALL_PATTERN_7_MASK                                                   0x00007FFFL
//DIDT_STALL_PATTERN_CTRL
#define DIDT_STALL_PATTERN_CTRL__DIDT_DROOP_CTRL_EN__SHIFT                                                    0x0
#define DIDT_STALL_PATTERN_CTRL__DIDT_DROOP_SW_RST__SHIFT                                                     0x1
#define DIDT_STALL_PATTERN_CTRL__DIDT_DROOP_CLK_EN_OVERRIDE__SHIFT                                            0x2
#define DIDT_STALL_PATTERN_CTRL__DIDT_STALL_PATTERN_BIT_NUMS__SHIFT                                           0x3
#define DIDT_STALL_PATTERN_CTRL__DIDT_PATTERN_EXTEND_EN__SHIFT                                                0x7
#define DIDT_STALL_PATTERN_CTRL__DIDT_PATTERN_EXTEND_MODE__SHIFT                                              0x8
#define DIDT_STALL_PATTERN_CTRL__DIDT_DROOP_STRETCH_EN__SHIFT                                                 0xb
#define DIDT_STALL_PATTERN_CTRL__DIDT_MAX_HYSTERESIS__SHIFT                                                   0xc
#define DIDT_STALL_PATTERN_CTRL__DIDT_PERF_COUNTER_EN__SHIFT                                                  0x14
#define DIDT_STALL_PATTERN_CTRL__PSM_DIDT_THROTTLE_SRC_SEL__SHIFT                                             0x15
#define DIDT_STALL_PATTERN_CTRL__DIDT_THROTTLE_SRC0_MASK__SHIFT                                               0x18
#define DIDT_STALL_PATTERN_CTRL__DIDT_THROTTLE_SRC1_MASK__SHIFT                                               0x19
#define DIDT_STALL_PATTERN_CTRL__DIDT_THROTTLE_SRC2_MASK__SHIFT                                               0x1a
#define DIDT_STALL_PATTERN_CTRL__DIDT_THROTTLE_SRC3_MASK__SHIFT                                               0x1b
#define DIDT_STALL_PATTERN_CTRL__DIDT_DROOP_CTRL_EN_MASK                                                      0x00000001L
#define DIDT_STALL_PATTERN_CTRL__DIDT_DROOP_SW_RST_MASK                                                       0x00000002L
#define DIDT_STALL_PATTERN_CTRL__DIDT_DROOP_CLK_EN_OVERRIDE_MASK                                              0x00000004L
#define DIDT_STALL_PATTERN_CTRL__DIDT_STALL_PATTERN_BIT_NUMS_MASK                                             0x00000078L
#define DIDT_STALL_PATTERN_CTRL__DIDT_PATTERN_EXTEND_EN_MASK                                                  0x00000080L
#define DIDT_STALL_PATTERN_CTRL__DIDT_PATTERN_EXTEND_MODE_MASK                                                0x00000700L
#define DIDT_STALL_PATTERN_CTRL__DIDT_DROOP_STRETCH_EN_MASK                                                   0x00000800L
#define DIDT_STALL_PATTERN_CTRL__DIDT_MAX_HYSTERESIS_MASK                                                     0x000FF000L
#define DIDT_STALL_PATTERN_CTRL__DIDT_PERF_COUNTER_EN_MASK                                                    0x00100000L
#define DIDT_STALL_PATTERN_CTRL__PSM_DIDT_THROTTLE_SRC_SEL_MASK                                               0x00E00000L
#define DIDT_STALL_PATTERN_CTRL__DIDT_THROTTLE_SRC0_MASK_MASK                                                 0x01000000L
#define DIDT_STALL_PATTERN_CTRL__DIDT_THROTTLE_SRC1_MASK_MASK                                                 0x02000000L
#define DIDT_STALL_PATTERN_CTRL__DIDT_THROTTLE_SRC2_MASK_MASK                                                 0x04000000L
#define DIDT_STALL_PATTERN_CTRL__DIDT_THROTTLE_SRC3_MASK_MASK                                                 0x08000000L
//DIDT_STALL_PATTERN_1_2
#define DIDT_STALL_PATTERN_1_2__DIDT_STALL_PATTERN_1__SHIFT                                                   0x0
#define DIDT_STALL_PATTERN_1_2__DIDT_STALL_PATTERN_2__SHIFT                                                   0x10
#define DIDT_STALL_PATTERN_1_2__DIDT_STALL_PATTERN_1_MASK                                                     0x00007FFFL
#define DIDT_STALL_PATTERN_1_2__DIDT_STALL_PATTERN_2_MASK                                                     0x7FFF0000L
//DIDT_STALL_PATTERN_3_4
#define DIDT_STALL_PATTERN_3_4__DIDT_STALL_PATTERN_3__SHIFT                                                   0x0
#define DIDT_STALL_PATTERN_3_4__DIDT_STALL_PATTERN_4__SHIFT                                                   0x10
#define DIDT_STALL_PATTERN_3_4__DIDT_STALL_PATTERN_3_MASK                                                     0x00007FFFL
#define DIDT_STALL_PATTERN_3_4__DIDT_STALL_PATTERN_4_MASK                                                     0x7FFF0000L
//DIDT_STALL_PATTERN_5_6
#define DIDT_STALL_PATTERN_5_6__DIDT_STALL_PATTERN_5__SHIFT                                                   0x0
#define DIDT_STALL_PATTERN_5_6__DIDT_STALL_PATTERN_6__SHIFT                                                   0x10
#define DIDT_STALL_PATTERN_5_6__DIDT_STALL_PATTERN_5_MASK                                                     0x00007FFFL
#define DIDT_STALL_PATTERN_5_6__DIDT_STALL_PATTERN_6_MASK                                                     0x7FFF0000L
//DIDT_STALL_PATTERN_7
#define DIDT_STALL_PATTERN_7__DIDT_STALL_PATTERN_7__SHIFT                                                     0x0
#define DIDT_STALL_PATTERN_7__DIDT_STALL_PATTERN_7_MASK                                                       0x00007FFFL
//PCC_PWRBRK_HYSTERESIS_CTRL
#define PCC_PWRBRK_HYSTERESIS_CTRL__PCC_MAX_HYSTERESIS__SHIFT                                                 0x0
#define PCC_PWRBRK_HYSTERESIS_CTRL__PWRBRK_MAX_HYSTERESIS__SHIFT                                              0x8
#define PCC_PWRBRK_HYSTERESIS_CTRL__PCC_MAX_HYSTERESIS_MASK                                                   0x000000FFL
#define PCC_PWRBRK_HYSTERESIS_CTRL__PWRBRK_MAX_HYSTERESIS_MASK                                                0x0000FF00L
//EDC_STRETCH_PERF_COUNTER
#define EDC_STRETCH_PERF_COUNTER__STRETCH_PERF_COUNTER__SHIFT                                                 0x0
#define EDC_STRETCH_PERF_COUNTER__STRETCH_PERF_COUNTER_MASK                                                   0xFFFFFFFFL
//EDC_UNSTRETCH_PERF_COUNTER
#define EDC_UNSTRETCH_PERF_COUNTER__UNSTRETCH_PERF_COUNTER__SHIFT                                             0x0
#define EDC_UNSTRETCH_PERF_COUNTER__UNSTRETCH_PERF_COUNTER_MASK                                               0xFFFFFFFFL
//EDC_STRETCH_NUM_PERF_COUNTER
#define EDC_STRETCH_NUM_PERF_COUNTER__STRETCH_NUM_PERF_COUNTER__SHIFT                                         0x0
#define EDC_STRETCH_NUM_PERF_COUNTER__STRETCH_NUM_PERF_COUNTER_MASK                                           0xFFFFFFFFL
//GC_EDC_STATUS
#define GC_EDC_STATUS__EDC_THROTTLE_LEVEL__SHIFT                                                              0x0
#define GC_EDC_STATUS__GPIO_IN_0__SHIFT                                                                       0x3
#define GC_EDC_STATUS__GPIO_IN_1__SHIFT                                                                       0x4
#define GC_EDC_STATUS__EDC_THROTTLE_LEVEL_MASK                                                                0x00000007L
#define GC_EDC_STATUS__GPIO_IN_0_MASK                                                                         0x00000008L
#define GC_EDC_STATUS__GPIO_IN_1_MASK                                                                         0x00000010L
//GC_EDC_OVERFLOW
#define GC_EDC_OVERFLOW__EDC_ROLLING_POWER_DELTA_OVERFLOW__SHIFT                                              0x0
#define GC_EDC_OVERFLOW__EDC_THROTTLE_LEVEL_OVERFLOW_COUNTER__SHIFT                                           0x1
#define GC_EDC_OVERFLOW__EDC_ROLLING_POWER_DELTA_OVERFLOW_MASK                                                0x00000001L
#define GC_EDC_OVERFLOW__EDC_THROTTLE_LEVEL_OVERFLOW_COUNTER_MASK                                             0x0001FFFEL
//GC_EDC_ROLLING_POWER_DELTA_LO
#define GC_EDC_ROLLING_POWER_DELTA_LO__EDC_ROLLING_POWER_DELTA_LO__SHIFT                                      0x0
#define GC_EDC_ROLLING_POWER_DELTA_LO__EDC_ROLLING_POWER_DELTA_LO_MASK                                        0xFFFFFFFFL
//GC_EDC_ROLLING_POWER_DELTA_HI
#define GC_EDC_ROLLING_POWER_DELTA_HI__EDC_ROLLING_POWER_DELTA_HI__SHIFT                                      0x0
#define GC_EDC_ROLLING_POWER_DELTA_HI__EDC_ROLLING_POWER_DELTA_HI_MASK                                        0xFFFFFFFFL
//GC_THROTTLE_STATUS
#define GC_THROTTLE_STATUS__FSM_STATE__SHIFT                                                                  0x0
#define GC_THROTTLE_STATUS__PATTERN_INDEX__SHIFT                                                              0x4
#define GC_THROTTLE_STATUS__FSM_STATE_MASK                                                                    0x0000000FL
#define GC_THROTTLE_STATUS__PATTERN_INDEX_MASK                                                                0x000001F0L
//EDC_PERF_COUNTER
#define EDC_PERF_COUNTER__EDC_PERF_COUNTER__SHIFT                                                             0x0
#define EDC_PERF_COUNTER__EDC_PERF_COUNTER_MASK                                                               0xFFFFFFFFL
//PCC_PERF_COUNTER
#define PCC_PERF_COUNTER__PCC_PERF_COUNTER__SHIFT                                                             0x0
#define PCC_PERF_COUNTER__PCC_PERF_COUNTER_MASK                                                               0xFFFFFFFFL
//PWRBRK_PERF_COUNTER
#define PWRBRK_PERF_COUNTER__PWRBRK_PERF_COUNTER__SHIFT                                                       0x0
#define PWRBRK_PERF_COUNTER__PWRBRK_PERF_COUNTER_MASK                                                         0xFFFFFFFFL
//EDC_HYSTERESIS_STAT
#define EDC_HYSTERESIS_STAT__HYSTERESIS_CNT__SHIFT                                                            0x0
#define EDC_HYSTERESIS_STAT__EDC_STATUS__SHIFT                                                                0x8
#define EDC_HYSTERESIS_STAT__EDC_THRESHOLD_STAT__SHIFT                                                        0x9
#define EDC_HYSTERESIS_STAT__HYSTERESIS_CNT_MASK                                                              0x000000FFL
#define EDC_HYSTERESIS_STAT__EDC_STATUS_MASK                                                                  0x00000100L
#define EDC_HYSTERESIS_STAT__EDC_THRESHOLD_STAT_MASK                                                          0x00000200L
//DIDT_HYSTERESIS_STAT
#define DIDT_HYSTERESIS_STAT__DIDT_HYSTERESIS_CNT__SHIFT                                                      0x0
#define DIDT_HYSTERESIS_STAT__DIDT_DROOP_STATUS__SHIFT                                                        0x8
#define DIDT_HYSTERESIS_STAT__DIDT_HYSTERESIS_CNT_MASK                                                        0x000000FFL
#define DIDT_HYSTERESIS_STAT__DIDT_DROOP_STATUS_MASK                                                          0x00000100L
//DIDT_PERF_COUNTER
#define DIDT_PERF_COUNTER__DIDT_PERF_COUNTER__SHIFT                                                           0x0
#define DIDT_PERF_COUNTER__DIDT_PERF_COUNTER_MASK                                                             0xFFFFFFFFL
//GC_EDC_CLK_MONITOR_CTRL
#define GC_EDC_CLK_MONITOR_CTRL__EDC_CLK_MONITOR_EN__SHIFT                                                    0x0
#define GC_EDC_CLK_MONITOR_CTRL__EDC_CLK_MONITOR_INTERVAL__SHIFT                                              0x1
#define GC_EDC_CLK_MONITOR_CTRL__EDC_CLK_MONITOR_THRESHOLD__SHIFT                                             0x5
#define GC_EDC_CLK_MONITOR_CTRL__EDC_CLK_MONITOR_EN_MASK                                                      0x00000001L
#define GC_EDC_CLK_MONITOR_CTRL__EDC_CLK_MONITOR_INTERVAL_MASK                                                0x0000001EL
#define GC_EDC_CLK_MONITOR_CTRL__EDC_CLK_MONITOR_THRESHOLD_MASK                                               0x0001FFE0L
//GC_CAC_SOFT_CTRL
#define GC_CAC_SOFT_CTRL__CAC_SOFT_SNAP__SHIFT                                                                0x0
#define GC_CAC_SOFT_CTRL__CAC_SOFT_SNAP_MASK                                                                  0x00000001L
//GC_CAC_WEIGHT_CP_0
#define GC_CAC_WEIGHT_CP_0__WEIGHT_CP_SIG0__SHIFT                                                             0x0
#define GC_CAC_WEIGHT_CP_0__WEIGHT_CP_SIG1__SHIFT                                                             0x10
#define GC_CAC_WEIGHT_CP_0__WEIGHT_CP_SIG0_MASK                                                               0x0000FFFFL
#define GC_CAC_WEIGHT_CP_0__WEIGHT_CP_SIG1_MASK                                                               0xFFFF0000L
//GC_CAC_WEIGHT_CP_1
#define GC_CAC_WEIGHT_CP_1__WEIGHT_CP_SIG2__SHIFT                                                             0x0
#define GC_CAC_WEIGHT_CP_1__WEIGHT_CP_SIG2_MASK                                                               0x0000FFFFL
//GC_CAC_WEIGHT_EA_0
#define GC_CAC_WEIGHT_EA_0__WEIGHT_EA_SIG0__SHIFT                                                             0x0
#define GC_CAC_WEIGHT_EA_0__WEIGHT_EA_SIG1__SHIFT                                                             0x10
#define GC_CAC_WEIGHT_EA_0__WEIGHT_EA_SIG0_MASK                                                               0x0000FFFFL
#define GC_CAC_WEIGHT_EA_0__WEIGHT_EA_SIG1_MASK                                                               0xFFFF0000L
//GC_CAC_WEIGHT_EA_1
#define GC_CAC_WEIGHT_EA_1__WEIGHT_EA_SIG2__SHIFT                                                             0x0
#define GC_CAC_WEIGHT_EA_1__WEIGHT_EA_SIG3__SHIFT                                                             0x10
#define GC_CAC_WEIGHT_EA_1__WEIGHT_EA_SIG2_MASK                                                               0x0000FFFFL
#define GC_CAC_WEIGHT_EA_1__WEIGHT_EA_SIG3_MASK                                                               0xFFFF0000L
//GC_CAC_WEIGHT_EA_2
#define GC_CAC_WEIGHT_EA_2__WEIGHT_EA_SIG4__SHIFT                                                             0x0
#define GC_CAC_WEIGHT_EA_2__WEIGHT_EA_SIG5__SHIFT                                                             0x10
#define GC_CAC_WEIGHT_EA_2__WEIGHT_EA_SIG4_MASK                                                               0x0000FFFFL
#define GC_CAC_WEIGHT_EA_2__WEIGHT_EA_SIG5_MASK                                                               0xFFFF0000L
//GC_CAC_WEIGHT_UTCL2_ROUTER_0
#define GC_CAC_WEIGHT_UTCL2_ROUTER_0__WEIGHT_UTCL2_ROUTER_SIG0__SHIFT                                         0x0
#define GC_CAC_WEIGHT_UTCL2_ROUTER_0__WEIGHT_UTCL2_ROUTER_SIG1__SHIFT                                         0x10
#define GC_CAC_WEIGHT_UTCL2_ROUTER_0__WEIGHT_UTCL2_ROUTER_SIG0_MASK                                           0x0000FFFFL
#define GC_CAC_WEIGHT_UTCL2_ROUTER_0__WEIGHT_UTCL2_ROUTER_SIG1_MASK                                           0xFFFF0000L
//GC_CAC_WEIGHT_UTCL2_ROUTER_1
#define GC_CAC_WEIGHT_UTCL2_ROUTER_1__WEIGHT_UTCL2_ROUTER_SIG2__SHIFT                                         0x0
#define GC_CAC_WEIGHT_UTCL2_ROUTER_1__WEIGHT_UTCL2_ROUTER_SIG3__SHIFT                                         0x10
#define GC_CAC_WEIGHT_UTCL2_ROUTER_1__WEIGHT_UTCL2_ROUTER_SIG2_MASK                                           0x0000FFFFL
#define GC_CAC_WEIGHT_UTCL2_ROUTER_1__WEIGHT_UTCL2_ROUTER_SIG3_MASK                                           0xFFFF0000L
//GC_CAC_WEIGHT_UTCL2_ROUTER_2
#define GC_CAC_WEIGHT_UTCL2_ROUTER_2__WEIGHT_UTCL2_ROUTER_SIG4__SHIFT                                         0x0
#define GC_CAC_WEIGHT_UTCL2_ROUTER_2__WEIGHT_UTCL2_ROUTER_SIG5__SHIFT                                         0x10
#define GC_CAC_WEIGHT_UTCL2_ROUTER_2__WEIGHT_UTCL2_ROUTER_SIG4_MASK                                           0x0000FFFFL
#define GC_CAC_WEIGHT_UTCL2_ROUTER_2__WEIGHT_UTCL2_ROUTER_SIG5_MASK                                           0xFFFF0000L
//GC_CAC_WEIGHT_UTCL2_ROUTER_3
#define GC_CAC_WEIGHT_UTCL2_ROUTER_3__WEIGHT_UTCL2_ROUTER_SIG6__SHIFT                                         0x0
#define GC_CAC_WEIGHT_UTCL2_ROUTER_3__WEIGHT_UTCL2_ROUTER_SIG7__SHIFT                                         0x10
#define GC_CAC_WEIGHT_UTCL2_ROUTER_3__WEIGHT_UTCL2_ROUTER_SIG6_MASK                                           0x0000FFFFL
#define GC_CAC_WEIGHT_UTCL2_ROUTER_3__WEIGHT_UTCL2_ROUTER_SIG7_MASK                                           0xFFFF0000L
//GC_CAC_WEIGHT_UTCL2_ROUTER_4
#define GC_CAC_WEIGHT_UTCL2_ROUTER_4__WEIGHT_UTCL2_ROUTER_SIG8__SHIFT                                         0x0
#define GC_CAC_WEIGHT_UTCL2_ROUTER_4__WEIGHT_UTCL2_ROUTER_SIG9__SHIFT                                         0x10
#define GC_CAC_WEIGHT_UTCL2_ROUTER_4__WEIGHT_UTCL2_ROUTER_SIG8_MASK                                           0x0000FFFFL
#define GC_CAC_WEIGHT_UTCL2_ROUTER_4__WEIGHT_UTCL2_ROUTER_SIG9_MASK                                           0xFFFF0000L
//GC_CAC_WEIGHT_UTCL2_VML2_0
#define GC_CAC_WEIGHT_UTCL2_VML2_0__WEIGHT_UTCL2_VML2_SIG0__SHIFT                                             0x0
#define GC_CAC_WEIGHT_UTCL2_VML2_0__WEIGHT_UTCL2_VML2_SIG1__SHIFT                                             0x10
#define GC_CAC_WEIGHT_UTCL2_VML2_0__WEIGHT_UTCL2_VML2_SIG0_MASK                                               0x0000FFFFL
#define GC_CAC_WEIGHT_UTCL2_VML2_0__WEIGHT_UTCL2_VML2_SIG1_MASK                                               0xFFFF0000L
//GC_CAC_WEIGHT_UTCL2_VML2_1
#define GC_CAC_WEIGHT_UTCL2_VML2_1__WEIGHT_UTCL2_VML2_SIG2__SHIFT                                             0x0
#define GC_CAC_WEIGHT_UTCL2_VML2_1__WEIGHT_UTCL2_VML2_SIG3__SHIFT                                             0x10
#define GC_CAC_WEIGHT_UTCL2_VML2_1__WEIGHT_UTCL2_VML2_SIG2_MASK                                               0x0000FFFFL
#define GC_CAC_WEIGHT_UTCL2_VML2_1__WEIGHT_UTCL2_VML2_SIG3_MASK                                               0xFFFF0000L
//GC_CAC_WEIGHT_UTCL2_VML2_2
#define GC_CAC_WEIGHT_UTCL2_VML2_2__WEIGHT_UTCL2_VML2_SIG4__SHIFT                                             0x0
#define GC_CAC_WEIGHT_UTCL2_VML2_2__WEIGHT_UTCL2_VML2_SIG4_MASK                                               0x0000FFFFL
//GC_CAC_WEIGHT_UTCL2_WALKER_0
#define GC_CAC_WEIGHT_UTCL2_WALKER_0__WEIGHT_UTCL2_WALKER_SIG0__SHIFT                                         0x0
#define GC_CAC_WEIGHT_UTCL2_WALKER_0__WEIGHT_UTCL2_WALKER_SIG1__SHIFT                                         0x10
#define GC_CAC_WEIGHT_UTCL2_WALKER_0__WEIGHT_UTCL2_WALKER_SIG0_MASK                                           0x0000FFFFL
#define GC_CAC_WEIGHT_UTCL2_WALKER_0__WEIGHT_UTCL2_WALKER_SIG1_MASK                                           0xFFFF0000L
//GC_CAC_WEIGHT_UTCL2_WALKER_1
#define GC_CAC_WEIGHT_UTCL2_WALKER_1__WEIGHT_UTCL2_WALKER_SIG2__SHIFT                                         0x0
#define GC_CAC_WEIGHT_UTCL2_WALKER_1__WEIGHT_UTCL2_WALKER_SIG3__SHIFT                                         0x10
#define GC_CAC_WEIGHT_UTCL2_WALKER_1__WEIGHT_UTCL2_WALKER_SIG2_MASK                                           0x0000FFFFL
#define GC_CAC_WEIGHT_UTCL2_WALKER_1__WEIGHT_UTCL2_WALKER_SIG3_MASK                                           0xFFFF0000L
//GC_CAC_WEIGHT_UTCL2_WALKER_2
#define GC_CAC_WEIGHT_UTCL2_WALKER_2__WEIGHT_UTCL2_WALKER_SIG4__SHIFT                                         0x0
#define GC_CAC_WEIGHT_UTCL2_WALKER_2__WEIGHT_UTCL2_WALKER_SIG4_MASK                                           0x0000FFFFL
//GC_CAC_WEIGHT_GE_0
#define GC_CAC_WEIGHT_GE_0__WEIGHT_GE_SIG0__SHIFT                                                             0x0
#define GC_CAC_WEIGHT_GE_0__WEIGHT_GE_SIG1__SHIFT                                                             0x10
#define GC_CAC_WEIGHT_GE_0__WEIGHT_GE_SIG0_MASK                                                               0x0000FFFFL
#define GC_CAC_WEIGHT_GE_0__WEIGHT_GE_SIG1_MASK                                                               0xFFFF0000L
//GC_CAC_WEIGHT_GE_1
#define GC_CAC_WEIGHT_GE_1__WEIGHT_GE_SIG2__SHIFT                                                             0x0
#define GC_CAC_WEIGHT_GE_1__WEIGHT_GE_SIG2_MASK                                                               0x0000FFFFL
//GC_CAC_WEIGHT_PMM_0
#define GC_CAC_WEIGHT_PMM_0__WEIGHT_PMM_SIG0__SHIFT                                                           0x0
#define GC_CAC_WEIGHT_PMM_0__WEIGHT_PMM_SIG0_MASK                                                             0x0000FFFFL
//GC_CAC_WEIGHT_SDMA_0
#define GC_CAC_WEIGHT_SDMA_0__WEIGHT_SDMA_SIG0__SHIFT                                                         0x0
#define GC_CAC_WEIGHT_SDMA_0__WEIGHT_SDMA_SIG1__SHIFT                                                         0x10
#define GC_CAC_WEIGHT_SDMA_0__WEIGHT_SDMA_SIG0_MASK                                                           0x0000FFFFL
#define GC_CAC_WEIGHT_SDMA_0__WEIGHT_SDMA_SIG1_MASK                                                           0xFFFF0000L
//GC_CAC_WEIGHT_SDMA_1
#define GC_CAC_WEIGHT_SDMA_1__WEIGHT_SDMA_SIG2__SHIFT                                                         0x0
#define GC_CAC_WEIGHT_SDMA_1__WEIGHT_SDMA_SIG3__SHIFT                                                         0x10
#define GC_CAC_WEIGHT_SDMA_1__WEIGHT_SDMA_SIG2_MASK                                                           0x0000FFFFL
#define GC_CAC_WEIGHT_SDMA_1__WEIGHT_SDMA_SIG3_MASK                                                           0xFFFF0000L
//GC_CAC_WEIGHT_SDMA_2
#define GC_CAC_WEIGHT_SDMA_2__WEIGHT_SDMA_SIG4__SHIFT                                                         0x0
#define GC_CAC_WEIGHT_SDMA_2__WEIGHT_SDMA_SIG5__SHIFT                                                         0x10
#define GC_CAC_WEIGHT_SDMA_2__WEIGHT_SDMA_SIG4_MASK                                                           0x0000FFFFL
#define GC_CAC_WEIGHT_SDMA_2__WEIGHT_SDMA_SIG5_MASK                                                           0xFFFF0000L
//GC_CAC_WEIGHT_SDMA_3
#define GC_CAC_WEIGHT_SDMA_3__WEIGHT_SDMA_SIG6__SHIFT                                                         0x0
#define GC_CAC_WEIGHT_SDMA_3__WEIGHT_SDMA_SIG7__SHIFT                                                         0x10
#define GC_CAC_WEIGHT_SDMA_3__WEIGHT_SDMA_SIG6_MASK                                                           0x0000FFFFL
#define GC_CAC_WEIGHT_SDMA_3__WEIGHT_SDMA_SIG7_MASK                                                           0xFFFF0000L
//GC_CAC_WEIGHT_SDMA_4
#define GC_CAC_WEIGHT_SDMA_4__WEIGHT_SDMA_SIG8__SHIFT                                                         0x0
#define GC_CAC_WEIGHT_SDMA_4__WEIGHT_SDMA_SIG9__SHIFT                                                         0x10
#define GC_CAC_WEIGHT_SDMA_4__WEIGHT_SDMA_SIG8_MASK                                                           0x0000FFFFL
#define GC_CAC_WEIGHT_SDMA_4__WEIGHT_SDMA_SIG9_MASK                                                           0xFFFF0000L
//GC_CAC_WEIGHT_SDMA_5
#define GC_CAC_WEIGHT_SDMA_5__WEIGHT_SDMA_SIG10__SHIFT                                                        0x0
#define GC_CAC_WEIGHT_SDMA_5__WEIGHT_SDMA_SIG11__SHIFT                                                        0x10
#define GC_CAC_WEIGHT_SDMA_5__WEIGHT_SDMA_SIG10_MASK                                                          0x0000FFFFL
#define GC_CAC_WEIGHT_SDMA_5__WEIGHT_SDMA_SIG11_MASK                                                          0xFFFF0000L
//GC_CAC_WEIGHT_CHC_0
#define GC_CAC_WEIGHT_CHC_0__WEIGHT_CHC_SIG0__SHIFT                                                           0x0
#define GC_CAC_WEIGHT_CHC_0__WEIGHT_CHC_SIG1__SHIFT                                                           0x10
#define GC_CAC_WEIGHT_CHC_0__WEIGHT_CHC_SIG0_MASK                                                             0x0000FFFFL
#define GC_CAC_WEIGHT_CHC_0__WEIGHT_CHC_SIG1_MASK                                                             0xFFFF0000L
//GC_CAC_WEIGHT_CHC_1
#define GC_CAC_WEIGHT_CHC_1__WEIGHT_CHC_SIG2__SHIFT                                                           0x0
#define GC_CAC_WEIGHT_CHC_1__WEIGHT_CHC_SIG2_MASK                                                             0x0000FFFFL
//GC_CAC_WEIGHT_RLC_0
#define GC_CAC_WEIGHT_RLC_0__WEIGHT_RLC_SIG0__SHIFT                                                           0x0
#define GC_CAC_WEIGHT_RLC_0__WEIGHT_RLC_SIG0_MASK                                                             0x0000FFFFL
//GC_CAC_WEIGHT_GRBM_0
#define GC_CAC_WEIGHT_GRBM_0__WEIGHT_GRBM_SIG0__SHIFT                                                         0x0
#define GC_CAC_WEIGHT_GRBM_0__WEIGHT_GRBM_SIG1__SHIFT                                                         0x10
#define GC_CAC_WEIGHT_GRBM_0__WEIGHT_GRBM_SIG0_MASK                                                           0x0000FFFFL
#define GC_CAC_WEIGHT_GRBM_0__WEIGHT_GRBM_SIG1_MASK                                                           0xFFFF0000L
//GC_CAC_WEIGHT_GL2C_0
#define GC_CAC_WEIGHT_GL2C_0__WEIGHT_GL2C_SIG0__SHIFT                                                         0x0
#define GC_CAC_WEIGHT_GL2C_0__WEIGHT_GL2C_SIG1__SHIFT                                                         0x10
#define GC_CAC_WEIGHT_GL2C_0__WEIGHT_GL2C_SIG0_MASK                                                           0x0000FFFFL
#define GC_CAC_WEIGHT_GL2C_0__WEIGHT_GL2C_SIG1_MASK                                                           0xFFFF0000L
//GC_CAC_WEIGHT_GL2C_1
#define GC_CAC_WEIGHT_GL2C_1__WEIGHT_GL2C_SIG2__SHIFT                                                         0x0
#define GC_CAC_WEIGHT_GL2C_1__WEIGHT_GL2C_SIG3__SHIFT                                                         0x10
#define GC_CAC_WEIGHT_GL2C_1__WEIGHT_GL2C_SIG2_MASK                                                           0x0000FFFFL
#define GC_CAC_WEIGHT_GL2C_1__WEIGHT_GL2C_SIG3_MASK                                                           0xFFFF0000L
//GC_CAC_WEIGHT_GL2C_2
#define GC_CAC_WEIGHT_GL2C_2__WEIGHT_GL2C_SIG4__SHIFT                                                         0x0
#define GC_CAC_WEIGHT_GL2C_2__WEIGHT_GL2C_SIG4_MASK                                                           0x0000FFFFL
//GC_CAC_IND_INDEX
#define GC_CAC_IND_INDEX__GC_CAC_IND_ADDR__SHIFT                                                              0x0
#define GC_CAC_IND_INDEX__GC_CAC_IND_ADDR_MASK                                                                0xFFFFFFFFL
//GC_CAC_IND_DATA
#define GC_CAC_IND_DATA__GC_CAC_IND_DATA__SHIFT                                                               0x0
#define GC_CAC_IND_DATA__GC_CAC_IND_DATA_MASK                                                                 0xFFFFFFFFL


// addressBlock: gc_gfx_cpwd_gc_ea_cpwd_gceadec
//GC_EA_CPWD_VC_MAP
#define GC_EA_CPWD_VC_MAP__DRAM_VC__SHIFT                                                                     0x0
#define GC_EA_CPWD_VC_MAP__IO_RD_VC__SHIFT                                                                    0x3
#define GC_EA_CPWD_VC_MAP__IO_WR_VC__SHIFT                                                                    0x6
#define GC_EA_CPWD_VC_MAP__DRAM_VC_MASK                                                                       0x00000007L
#define GC_EA_CPWD_VC_MAP__IO_RD_VC_MASK                                                                      0x00000038L
#define GC_EA_CPWD_VC_MAP__IO_WR_VC_MASK                                                                      0x000001C0L
//GC_EA_CPWD_SDP_ARB_FINAL
#define GC_EA_CPWD_SDP_ARB_FINAL__DRAM_BURST_LIMIT__SHIFT                                                     0x0
#define GC_EA_CPWD_SDP_ARB_FINAL__MAM_BURST_LIMIT__SHIFT                                                      0x5
#define GC_EA_CPWD_SDP_ARB_FINAL__IO_BURST_LIMIT__SHIFT                                                       0xa
#define GC_EA_CPWD_SDP_ARB_FINAL__BURST_LIMIT_MULTIPLIER__SHIFT                                               0xf
#define GC_EA_CPWD_SDP_ARB_FINAL__ERREVENT_ON_ERROR__SHIFT                                                    0x11
#define GC_EA_CPWD_SDP_ARB_FINAL__HALTREQ_ON_ERROR__SHIFT                                                     0x12
#define GC_EA_CPWD_SDP_ARB_FINAL__DRAM_BURST_LIMIT_MASK                                                       0x0000001FL
#define GC_EA_CPWD_SDP_ARB_FINAL__MAM_BURST_LIMIT_MASK                                                        0x000003E0L
#define GC_EA_CPWD_SDP_ARB_FINAL__IO_BURST_LIMIT_MASK                                                         0x00007C00L
#define GC_EA_CPWD_SDP_ARB_FINAL__BURST_LIMIT_MULTIPLIER_MASK                                                 0x00018000L
#define GC_EA_CPWD_SDP_ARB_FINAL__ERREVENT_ON_ERROR_MASK                                                      0x00020000L
#define GC_EA_CPWD_SDP_ARB_FINAL__HALTREQ_ON_ERROR_MASK                                                       0x00040000L
//GC_EA_CPWD_SDP_PRIORITY
#define GC_EA_CPWD_SDP_PRIORITY__DRAM_PRIORITY__SHIFT                                                         0x0
#define GC_EA_CPWD_SDP_PRIORITY__IO_RD_PRIORITY__SHIFT                                                        0x4
#define GC_EA_CPWD_SDP_PRIORITY__IO_WR_PRIORITY__SHIFT                                                        0x8
#define GC_EA_CPWD_SDP_PRIORITY__MAM_WR_PRIORITY__SHIFT                                                       0xc
#define GC_EA_CPWD_SDP_PRIORITY__DRAM_PRIORITY_MASK                                                           0x0000000FL
#define GC_EA_CPWD_SDP_PRIORITY__IO_RD_PRIORITY_MASK                                                          0x000000F0L
#define GC_EA_CPWD_SDP_PRIORITY__IO_WR_PRIORITY_MASK                                                          0x00000F00L
#define GC_EA_CPWD_SDP_PRIORITY__MAM_WR_PRIORITY_MASK                                                         0x0000F000L
//GC_EA_CPWD_SDP_CREDITS
#define GC_EA_CPWD_SDP_CREDITS__TAG_LIMIT__SHIFT                                                              0x0
#define GC_EA_CPWD_SDP_CREDITS__WR_RESP_CREDITS__SHIFT                                                        0x9
#define GC_EA_CPWD_SDP_CREDITS__RD_RESP_CREDITS__SHIFT                                                        0x10
#define GC_EA_CPWD_SDP_CREDITS__TAG_LIMIT_MASK                                                                0x000001FFL
#define GC_EA_CPWD_SDP_CREDITS__WR_RESP_CREDITS_MASK                                                          0x0000FE00L
#define GC_EA_CPWD_SDP_CREDITS__RD_RESP_CREDITS_MASK                                                          0x007F0000L
//GC_EA_CPWD_SDP_TAG_RESERVE0
#define GC_EA_CPWD_SDP_TAG_RESERVE0__VC0__SHIFT                                                               0x0
#define GC_EA_CPWD_SDP_TAG_RESERVE0__VC1__SHIFT                                                               0x9
#define GC_EA_CPWD_SDP_TAG_RESERVE0__VC2__SHIFT                                                               0x12
#define GC_EA_CPWD_SDP_TAG_RESERVE0__VC0_MASK                                                                 0x000001FFL
#define GC_EA_CPWD_SDP_TAG_RESERVE0__VC1_MASK                                                                 0x0003FE00L
#define GC_EA_CPWD_SDP_TAG_RESERVE0__VC2_MASK                                                                 0x07FC0000L
//GC_EA_CPWD_SDP_TAG_RESERVE1
#define GC_EA_CPWD_SDP_TAG_RESERVE1__VC3__SHIFT                                                               0x0
#define GC_EA_CPWD_SDP_TAG_RESERVE1__VC4__SHIFT                                                               0x9
#define GC_EA_CPWD_SDP_TAG_RESERVE1__VC5__SHIFT                                                               0x12
#define GC_EA_CPWD_SDP_TAG_RESERVE1__VC3_MASK                                                                 0x000001FFL
#define GC_EA_CPWD_SDP_TAG_RESERVE1__VC4_MASK                                                                 0x0003FE00L
#define GC_EA_CPWD_SDP_TAG_RESERVE1__VC5_MASK                                                                 0x07FC0000L
//GC_EA_CPWD_SDP_TAG_RESERVE2
#define GC_EA_CPWD_SDP_TAG_RESERVE2__VC6__SHIFT                                                               0x0
#define GC_EA_CPWD_SDP_TAG_RESERVE2__VC7__SHIFT                                                               0x9
#define GC_EA_CPWD_SDP_TAG_RESERVE2__VC6_MASK                                                                 0x000001FFL
#define GC_EA_CPWD_SDP_TAG_RESERVE2__VC7_MASK                                                                 0x0003FE00L
//GC_EA_CPWD_SDP_VCC_RESERVE0
#define GC_EA_CPWD_SDP_VCC_RESERVE0__VC0_CREDITS__SHIFT                                                       0x0
#define GC_EA_CPWD_SDP_VCC_RESERVE0__VC1_CREDITS__SHIFT                                                       0x6
#define GC_EA_CPWD_SDP_VCC_RESERVE0__VC2_CREDITS__SHIFT                                                       0xc
#define GC_EA_CPWD_SDP_VCC_RESERVE0__VC3_CREDITS__SHIFT                                                       0x12
#define GC_EA_CPWD_SDP_VCC_RESERVE0__VC4_CREDITS__SHIFT                                                       0x18
#define GC_EA_CPWD_SDP_VCC_RESERVE0__VC0_CREDITS_MASK                                                         0x0000003FL
#define GC_EA_CPWD_SDP_VCC_RESERVE0__VC1_CREDITS_MASK                                                         0x00000FC0L
#define GC_EA_CPWD_SDP_VCC_RESERVE0__VC2_CREDITS_MASK                                                         0x0003F000L
#define GC_EA_CPWD_SDP_VCC_RESERVE0__VC3_CREDITS_MASK                                                         0x00FC0000L
#define GC_EA_CPWD_SDP_VCC_RESERVE0__VC4_CREDITS_MASK                                                         0x3F000000L
//GC_EA_CPWD_SDP_VCC_RESERVE1
#define GC_EA_CPWD_SDP_VCC_RESERVE1__VC5_CREDITS__SHIFT                                                       0x0
#define GC_EA_CPWD_SDP_VCC_RESERVE1__VC6_CREDITS__SHIFT                                                       0x6
#define GC_EA_CPWD_SDP_VCC_RESERVE1__VC7_CREDITS__SHIFT                                                       0xc
#define GC_EA_CPWD_SDP_VCC_RESERVE1__DISTRIBUTE_POOL__SHIFT                                                   0x1f
#define GC_EA_CPWD_SDP_VCC_RESERVE1__VC5_CREDITS_MASK                                                         0x0000003FL
#define GC_EA_CPWD_SDP_VCC_RESERVE1__VC6_CREDITS_MASK                                                         0x00000FC0L
#define GC_EA_CPWD_SDP_VCC_RESERVE1__VC7_CREDITS_MASK                                                         0x0003F000L
#define GC_EA_CPWD_SDP_VCC_RESERVE1__DISTRIBUTE_POOL_MASK                                                     0x80000000L
//GC_EA_CPWD_SDP_VCD_RESERVE0
#define GC_EA_CPWD_SDP_VCD_RESERVE0__VC0_CREDITS__SHIFT                                                       0x0
#define GC_EA_CPWD_SDP_VCD_RESERVE0__VC1_CREDITS__SHIFT                                                       0x6
#define GC_EA_CPWD_SDP_VCD_RESERVE0__VC2_CREDITS__SHIFT                                                       0xc
#define GC_EA_CPWD_SDP_VCD_RESERVE0__VC3_CREDITS__SHIFT                                                       0x12
#define GC_EA_CPWD_SDP_VCD_RESERVE0__VC4_CREDITS__SHIFT                                                       0x18
#define GC_EA_CPWD_SDP_VCD_RESERVE0__VC0_CREDITS_MASK                                                         0x0000003FL
#define GC_EA_CPWD_SDP_VCD_RESERVE0__VC1_CREDITS_MASK                                                         0x00000FC0L
#define GC_EA_CPWD_SDP_VCD_RESERVE0__VC2_CREDITS_MASK                                                         0x0003F000L
#define GC_EA_CPWD_SDP_VCD_RESERVE0__VC3_CREDITS_MASK                                                         0x00FC0000L
#define GC_EA_CPWD_SDP_VCD_RESERVE0__VC4_CREDITS_MASK                                                         0x3F000000L
//GC_EA_CPWD_SDP_VCD_RESERVE1
#define GC_EA_CPWD_SDP_VCD_RESERVE1__VC5_CREDITS__SHIFT                                                       0x0
#define GC_EA_CPWD_SDP_VCD_RESERVE1__VC6_CREDITS__SHIFT                                                       0x6
#define GC_EA_CPWD_SDP_VCD_RESERVE1__VC7_CREDITS__SHIFT                                                       0xc
#define GC_EA_CPWD_SDP_VCD_RESERVE1__DISTRIBUTE_POOL__SHIFT                                                   0x1f
#define GC_EA_CPWD_SDP_VCD_RESERVE1__VC5_CREDITS_MASK                                                         0x0000003FL
#define GC_EA_CPWD_SDP_VCD_RESERVE1__VC6_CREDITS_MASK                                                         0x00000FC0L
#define GC_EA_CPWD_SDP_VCD_RESERVE1__VC7_CREDITS_MASK                                                         0x0003F000L
#define GC_EA_CPWD_SDP_VCD_RESERVE1__DISTRIBUTE_POOL_MASK                                                     0x80000000L
//GC_EA_CPWD_SDP_REQ_CNTL
#define GC_EA_CPWD_SDP_REQ_CNTL__REQ_PASS_PW_OVERRIDE_READ__SHIFT                                             0x0
#define GC_EA_CPWD_SDP_REQ_CNTL__REQ_PASS_PW_OVERRIDE_WRITE__SHIFT                                            0x1
#define GC_EA_CPWD_SDP_REQ_CNTL__REQ_PASS_PW_OVERRIDE_ATOMIC__SHIFT                                           0x2
#define GC_EA_CPWD_SDP_REQ_CNTL__INNER_DOMAIN_MODE__SHIFT                                                     0x3
#define GC_EA_CPWD_SDP_REQ_CNTL__REQ_BLOCK_LEVEL_READ__SHIFT                                                  0x4
#define GC_EA_CPWD_SDP_REQ_CNTL__REQ_BLOCK_LEVEL_WRITE__SHIFT                                                 0x6
#define GC_EA_CPWD_SDP_REQ_CNTL__REQ_BLOCK_LEVEL_ATOMIC__SHIFT                                                0x8
#define GC_EA_CPWD_SDP_REQ_CNTL__REQ_PASS_PW_OVERRIDE_READ_MASK                                               0x00000001L
#define GC_EA_CPWD_SDP_REQ_CNTL__REQ_PASS_PW_OVERRIDE_WRITE_MASK                                              0x00000002L
#define GC_EA_CPWD_SDP_REQ_CNTL__REQ_PASS_PW_OVERRIDE_ATOMIC_MASK                                             0x00000004L
#define GC_EA_CPWD_SDP_REQ_CNTL__INNER_DOMAIN_MODE_MASK                                                       0x00000008L
#define GC_EA_CPWD_SDP_REQ_CNTL__REQ_BLOCK_LEVEL_READ_MASK                                                    0x00000030L
#define GC_EA_CPWD_SDP_REQ_CNTL__REQ_BLOCK_LEVEL_WRITE_MASK                                                   0x000000C0L
#define GC_EA_CPWD_SDP_REQ_CNTL__REQ_BLOCK_LEVEL_ATOMIC_MASK                                                  0x00000300L
//GC_EA_CPWD_MISC
#define GC_EA_CPWD_MISC__LINKMGR_DYNAMIC_MODE__SHIFT                                                          0x0
#define GC_EA_CPWD_MISC__LINKMGR_HALT_THRESHOLD__SHIFT                                                        0x2
#define GC_EA_CPWD_MISC__LINKMGR_RECONNECT_DELAY__SHIFT                                                       0x4
#define GC_EA_CPWD_MISC__LINKMGR_IDLE_THRESHOLD__SHIFT                                                        0x6
#define GC_EA_CPWD_MISC__LINKMGR_CREDITRESET_CGCG_IGNORE__SHIFT                                               0xb
#define GC_EA_CPWD_MISC__LINKMGR_DYNAMIC_MODE_MASK                                                            0x00000003L
#define GC_EA_CPWD_MISC__LINKMGR_HALT_THRESHOLD_MASK                                                          0x0000000CL
#define GC_EA_CPWD_MISC__LINKMGR_RECONNECT_DELAY_MASK                                                         0x00000030L
#define GC_EA_CPWD_MISC__LINKMGR_IDLE_THRESHOLD_MASK                                                          0x000007C0L
#define GC_EA_CPWD_MISC__LINKMGR_CREDITRESET_CGCG_IGNORE_MASK                                                 0x00000800L
//GC_EA_CPWD_ERR_STATUS
#define GC_EA_CPWD_ERR_STATUS__SDP_RDRSP_STATUS__SHIFT                                                        0x0
#define GC_EA_CPWD_ERR_STATUS__SDP_WRRSP_STATUS__SHIFT                                                        0x4
#define GC_EA_CPWD_ERR_STATUS__SDP_RDRSP_DATASTATUS__SHIFT                                                    0x8
#define GC_EA_CPWD_ERR_STATUS__SDP_RDRSP_DATAPARITY_ERROR__SHIFT                                              0xa
#define GC_EA_CPWD_ERR_STATUS__SDP_RDRSP_COMP_KEY_PARITY_ERROR__SHIFT                                         0xb
#define GC_EA_CPWD_ERR_STATUS__CLEAR_ERROR_STATUS__SHIFT                                                      0xc
#define GC_EA_CPWD_ERR_STATUS__BUSY_ON_ERROR__SHIFT                                                           0xd
#define GC_EA_CPWD_ERR_STATUS__IGNORE_RDRSP_FED__SHIFT                                                        0xe
#define GC_EA_CPWD_ERR_STATUS__SDP_RDRSP_STATUS_MASK                                                          0x0000000FL
#define GC_EA_CPWD_ERR_STATUS__SDP_WRRSP_STATUS_MASK                                                          0x000000F0L
#define GC_EA_CPWD_ERR_STATUS__SDP_RDRSP_DATASTATUS_MASK                                                      0x00000300L
#define GC_EA_CPWD_ERR_STATUS__SDP_RDRSP_DATAPARITY_ERROR_MASK                                                0x00000400L
#define GC_EA_CPWD_ERR_STATUS__SDP_RDRSP_COMP_KEY_PARITY_ERROR_MASK                                           0x00000800L
#define GC_EA_CPWD_ERR_STATUS__CLEAR_ERROR_STATUS_MASK                                                        0x00001000L
#define GC_EA_CPWD_ERR_STATUS__BUSY_ON_ERROR_MASK                                                             0x00002000L
#define GC_EA_CPWD_ERR_STATUS__IGNORE_RDRSP_FED_MASK                                                          0x00004000L
//GC_EA_CPWD_MISC2
#define GC_EA_CPWD_MISC2__BLOCK_REQUESTS__SHIFT                                                               0x0
#define GC_EA_CPWD_MISC2__REQUESTS_BLOCKED__SHIFT                                                             0x1
#define GC_EA_CPWD_MISC2__FGCLKEN_OVERRIDE__SHIFT                                                             0x2
#define GC_EA_CPWD_MISC2__LINKMGR_CRBUSY_MASK__SHIFT                                                          0x3
#define GC_EA_CPWD_MISC2__RDRET_FED_MASK__SHIFT                                                               0x4
#define GC_EA_CPWD_MISC2__BLOCK_REQUESTS_MASK                                                                 0x00000001L
#define GC_EA_CPWD_MISC2__REQUESTS_BLOCKED_MASK                                                               0x00000002L
#define GC_EA_CPWD_MISC2__FGCLKEN_OVERRIDE_MASK                                                               0x00000004L
#define GC_EA_CPWD_MISC2__LINKMGR_CRBUSY_MASK_MASK                                                            0x00000008L
#define GC_EA_CPWD_MISC2__RDRET_FED_MASK_MASK                                                                 0x00000010L
//GC_EA_CPWD_SDP_BACKDOOR_CMDCREDITS0
#define GC_EA_CPWD_SDP_BACKDOOR_CMDCREDITS0__VC0_CREDITS_RECEIVED__SHIFT                                      0x0
#define GC_EA_CPWD_SDP_BACKDOOR_CMDCREDITS0__VC1_CREDITS_RECEIVED__SHIFT                                      0x7
#define GC_EA_CPWD_SDP_BACKDOOR_CMDCREDITS0__VC2_CREDITS_RECEIVED__SHIFT                                      0xe
#define GC_EA_CPWD_SDP_BACKDOOR_CMDCREDITS0__VC3_CREDITS_RECEIVED__SHIFT                                      0x15
#define GC_EA_CPWD_SDP_BACKDOOR_CMDCREDITS0__VC4_CREDITS_RECEIVED__SHIFT                                      0x1c
#define GC_EA_CPWD_SDP_BACKDOOR_CMDCREDITS0__VC0_CREDITS_RECEIVED_MASK                                        0x0000007FL
#define GC_EA_CPWD_SDP_BACKDOOR_CMDCREDITS0__VC1_CREDITS_RECEIVED_MASK                                        0x00003F80L
#define GC_EA_CPWD_SDP_BACKDOOR_CMDCREDITS0__VC2_CREDITS_RECEIVED_MASK                                        0x001FC000L
#define GC_EA_CPWD_SDP_BACKDOOR_CMDCREDITS0__VC3_CREDITS_RECEIVED_MASK                                        0x0FE00000L
#define GC_EA_CPWD_SDP_BACKDOOR_CMDCREDITS0__VC4_CREDITS_RECEIVED_MASK                                        0xF0000000L
//GC_EA_CPWD_SDP_BACKDOOR_CMDCREDITS0_WRITE
#define GC_EA_CPWD_SDP_BACKDOOR_CMDCREDITS0_WRITE__VC0_CREDITS_RECEIVED__SHIFT                                0x0
#define GC_EA_CPWD_SDP_BACKDOOR_CMDCREDITS0_WRITE__VC1_CREDITS_RECEIVED__SHIFT                                0x7
#define GC_EA_CPWD_SDP_BACKDOOR_CMDCREDITS0_WRITE__VC2_CREDITS_RECEIVED__SHIFT                                0xe
#define GC_EA_CPWD_SDP_BACKDOOR_CMDCREDITS0_WRITE__VC3_CREDITS_RECEIVED__SHIFT                                0x15
#define GC_EA_CPWD_SDP_BACKDOOR_CMDCREDITS0_WRITE__VC4_CREDITS_RECEIVED__SHIFT                                0x1c
#define GC_EA_CPWD_SDP_BACKDOOR_CMDCREDITS0_WRITE__VC0_CREDITS_RECEIVED_MASK                                  0x0000007FL
#define GC_EA_CPWD_SDP_BACKDOOR_CMDCREDITS0_WRITE__VC1_CREDITS_RECEIVED_MASK                                  0x00003F80L
#define GC_EA_CPWD_SDP_BACKDOOR_CMDCREDITS0_WRITE__VC2_CREDITS_RECEIVED_MASK                                  0x001FC000L
#define GC_EA_CPWD_SDP_BACKDOOR_CMDCREDITS0_WRITE__VC3_CREDITS_RECEIVED_MASK                                  0x0FE00000L
#define GC_EA_CPWD_SDP_BACKDOOR_CMDCREDITS0_WRITE__VC4_CREDITS_RECEIVED_MASK                                  0xF0000000L
//GC_EA_CPWD_SDP_BACKDOOR_CMDCREDITS1
#define GC_EA_CPWD_SDP_BACKDOOR_CMDCREDITS1__VC4_CREDITS_RECEIVED__SHIFT                                      0x0
#define GC_EA_CPWD_SDP_BACKDOOR_CMDCREDITS1__VC5_CREDITS_RECEIVED__SHIFT                                      0x3
#define GC_EA_CPWD_SDP_BACKDOOR_CMDCREDITS1__VC6_CREDITS_RECEIVED__SHIFT                                      0xa
#define GC_EA_CPWD_SDP_BACKDOOR_CMDCREDITS1__VC7_CREDITS_RECEIVED__SHIFT                                      0x11
#define GC_EA_CPWD_SDP_BACKDOOR_CMDCREDITS1__POOL_CREDITS_RECEIVED__SHIFT                                     0x18
#define GC_EA_CPWD_SDP_BACKDOOR_CMDCREDITS1__VC4_CREDITS_RECEIVED_MASK                                        0x00000007L
#define GC_EA_CPWD_SDP_BACKDOOR_CMDCREDITS1__VC5_CREDITS_RECEIVED_MASK                                        0x000003F8L
#define GC_EA_CPWD_SDP_BACKDOOR_CMDCREDITS1__VC6_CREDITS_RECEIVED_MASK                                        0x0001FC00L
#define GC_EA_CPWD_SDP_BACKDOOR_CMDCREDITS1__VC7_CREDITS_RECEIVED_MASK                                        0x00FE0000L
#define GC_EA_CPWD_SDP_BACKDOOR_CMDCREDITS1__POOL_CREDITS_RECEIVED_MASK                                       0x7F000000L
//GC_EA_CPWD_SDP_BACKDOOR_CMDCREDITS1_WRITE
#define GC_EA_CPWD_SDP_BACKDOOR_CMDCREDITS1_WRITE__VC4_CREDITS_RECEIVED__SHIFT                                0x0
#define GC_EA_CPWD_SDP_BACKDOOR_CMDCREDITS1_WRITE__VC5_CREDITS_RECEIVED__SHIFT                                0x3
#define GC_EA_CPWD_SDP_BACKDOOR_CMDCREDITS1_WRITE__VC6_CREDITS_RECEIVED__SHIFT                                0xa
#define GC_EA_CPWD_SDP_BACKDOOR_CMDCREDITS1_WRITE__VC7_CREDITS_RECEIVED__SHIFT                                0x11
#define GC_EA_CPWD_SDP_BACKDOOR_CMDCREDITS1_WRITE__POOL_CREDITS_RECEIVED__SHIFT                               0x18
#define GC_EA_CPWD_SDP_BACKDOOR_CMDCREDITS1_WRITE__VC4_CREDITS_RECEIVED_MASK                                  0x00000007L
#define GC_EA_CPWD_SDP_BACKDOOR_CMDCREDITS1_WRITE__VC5_CREDITS_RECEIVED_MASK                                  0x000003F8L
#define GC_EA_CPWD_SDP_BACKDOOR_CMDCREDITS1_WRITE__VC6_CREDITS_RECEIVED_MASK                                  0x0001FC00L
#define GC_EA_CPWD_SDP_BACKDOOR_CMDCREDITS1_WRITE__VC7_CREDITS_RECEIVED_MASK                                  0x00FE0000L
#define GC_EA_CPWD_SDP_BACKDOOR_CMDCREDITS1_WRITE__POOL_CREDITS_RECEIVED_MASK                                 0x7F000000L
//GC_EA_CPWD_SDP_BACKDOOR_DATACREDITS0
#define GC_EA_CPWD_SDP_BACKDOOR_DATACREDITS0__VC0_CREDITS_RECEIVED__SHIFT                                     0x0
#define GC_EA_CPWD_SDP_BACKDOOR_DATACREDITS0__VC1_CREDITS_RECEIVED__SHIFT                                     0x7
#define GC_EA_CPWD_SDP_BACKDOOR_DATACREDITS0__VC2_CREDITS_RECEIVED__SHIFT                                     0xe
#define GC_EA_CPWD_SDP_BACKDOOR_DATACREDITS0__VC3_CREDITS_RECEIVED__SHIFT                                     0x15
#define GC_EA_CPWD_SDP_BACKDOOR_DATACREDITS0__VC4_CREDITS_RECEIVED__SHIFT                                     0x1c
#define GC_EA_CPWD_SDP_BACKDOOR_DATACREDITS0__VC0_CREDITS_RECEIVED_MASK                                       0x0000007FL
#define GC_EA_CPWD_SDP_BACKDOOR_DATACREDITS0__VC1_CREDITS_RECEIVED_MASK                                       0x00003F80L
#define GC_EA_CPWD_SDP_BACKDOOR_DATACREDITS0__VC2_CREDITS_RECEIVED_MASK                                       0x001FC000L
#define GC_EA_CPWD_SDP_BACKDOOR_DATACREDITS0__VC3_CREDITS_RECEIVED_MASK                                       0x0FE00000L
#define GC_EA_CPWD_SDP_BACKDOOR_DATACREDITS0__VC4_CREDITS_RECEIVED_MASK                                       0xF0000000L
//GC_EA_CPWD_SDP_BACKDOOR_DATACREDITS0_WRITE
#define GC_EA_CPWD_SDP_BACKDOOR_DATACREDITS0_WRITE__VC0_CREDITS_RECEIVED__SHIFT                               0x0
#define GC_EA_CPWD_SDP_BACKDOOR_DATACREDITS0_WRITE__VC1_CREDITS_RECEIVED__SHIFT                               0x7
#define GC_EA_CPWD_SDP_BACKDOOR_DATACREDITS0_WRITE__VC2_CREDITS_RECEIVED__SHIFT                               0xe
#define GC_EA_CPWD_SDP_BACKDOOR_DATACREDITS0_WRITE__VC3_CREDITS_RECEIVED__SHIFT                               0x15
#define GC_EA_CPWD_SDP_BACKDOOR_DATACREDITS0_WRITE__VC4_CREDITS_RECEIVED__SHIFT                               0x1c
#define GC_EA_CPWD_SDP_BACKDOOR_DATACREDITS0_WRITE__VC0_CREDITS_RECEIVED_MASK                                 0x0000007FL
#define GC_EA_CPWD_SDP_BACKDOOR_DATACREDITS0_WRITE__VC1_CREDITS_RECEIVED_MASK                                 0x00003F80L
#define GC_EA_CPWD_SDP_BACKDOOR_DATACREDITS0_WRITE__VC2_CREDITS_RECEIVED_MASK                                 0x001FC000L
#define GC_EA_CPWD_SDP_BACKDOOR_DATACREDITS0_WRITE__VC3_CREDITS_RECEIVED_MASK                                 0x0FE00000L
#define GC_EA_CPWD_SDP_BACKDOOR_DATACREDITS0_WRITE__VC4_CREDITS_RECEIVED_MASK                                 0xF0000000L
//GC_EA_CPWD_SDP_BACKDOOR_DATACREDITS1
#define GC_EA_CPWD_SDP_BACKDOOR_DATACREDITS1__VC4_CREDITS_RECEIVED__SHIFT                                     0x0
#define GC_EA_CPWD_SDP_BACKDOOR_DATACREDITS1__VC5_CREDITS_RECEIVED__SHIFT                                     0x3
#define GC_EA_CPWD_SDP_BACKDOOR_DATACREDITS1__VC6_CREDITS_RECEIVED__SHIFT                                     0xa
#define GC_EA_CPWD_SDP_BACKDOOR_DATACREDITS1__VC7_CREDITS_RECEIVED__SHIFT                                     0x11
#define GC_EA_CPWD_SDP_BACKDOOR_DATACREDITS1__POOL_CREDITS_RECEIVED__SHIFT                                    0x18
#define GC_EA_CPWD_SDP_BACKDOOR_DATACREDITS1__VC4_CREDITS_RECEIVED_MASK                                       0x00000007L
#define GC_EA_CPWD_SDP_BACKDOOR_DATACREDITS1__VC5_CREDITS_RECEIVED_MASK                                       0x000003F8L
#define GC_EA_CPWD_SDP_BACKDOOR_DATACREDITS1__VC6_CREDITS_RECEIVED_MASK                                       0x0001FC00L
#define GC_EA_CPWD_SDP_BACKDOOR_DATACREDITS1__VC7_CREDITS_RECEIVED_MASK                                       0x00FE0000L
#define GC_EA_CPWD_SDP_BACKDOOR_DATACREDITS1__POOL_CREDITS_RECEIVED_MASK                                      0x7F000000L
//GC_EA_CPWD_SDP_BACKDOOR_DATACREDITS1_WRITE
#define GC_EA_CPWD_SDP_BACKDOOR_DATACREDITS1_WRITE__VC4_CREDITS_RECEIVED__SHIFT                               0x0
#define GC_EA_CPWD_SDP_BACKDOOR_DATACREDITS1_WRITE__VC5_CREDITS_RECEIVED__SHIFT                               0x3
#define GC_EA_CPWD_SDP_BACKDOOR_DATACREDITS1_WRITE__VC6_CREDITS_RECEIVED__SHIFT                               0xa
#define GC_EA_CPWD_SDP_BACKDOOR_DATACREDITS1_WRITE__VC7_CREDITS_RECEIVED__SHIFT                               0x11
#define GC_EA_CPWD_SDP_BACKDOOR_DATACREDITS1_WRITE__POOL_CREDITS_RECEIVED__SHIFT                              0x18
#define GC_EA_CPWD_SDP_BACKDOOR_DATACREDITS1_WRITE__VC4_CREDITS_RECEIVED_MASK                                 0x00000007L
#define GC_EA_CPWD_SDP_BACKDOOR_DATACREDITS1_WRITE__VC5_CREDITS_RECEIVED_MASK                                 0x000003F8L
#define GC_EA_CPWD_SDP_BACKDOOR_DATACREDITS1_WRITE__VC6_CREDITS_RECEIVED_MASK                                 0x0001FC00L
#define GC_EA_CPWD_SDP_BACKDOOR_DATACREDITS1_WRITE__VC7_CREDITS_RECEIVED_MASK                                 0x00FE0000L
#define GC_EA_CPWD_SDP_BACKDOOR_DATACREDITS1_WRITE__POOL_CREDITS_RECEIVED_MASK                                0x7F000000L
//GC_EA_CPWD_SDP_BACKDOOR_MISCCTL
#define GC_EA_CPWD_SDP_BACKDOOR_MISCCTL__SDP_ORIGCLKCTL__SHIFT                                                0x0
#define GC_EA_CPWD_SDP_BACKDOOR_MISCCTL__SDP_ORIGCLKCTL_MASK                                                  0x00000001L
//GC_EA_CPWD_SDP_BACKDOOR_MISCCTL_WRITE
#define GC_EA_CPWD_SDP_BACKDOOR_MISCCTL_WRITE__SDP_ORIGCLKCTL__SHIFT                                          0x0
#define GC_EA_CPWD_SDP_BACKDOOR_MISCCTL_WRITE__SDP_ORIGCLKCTL_MASK                                            0x00000001L
//GC_EA_CPWD_SDP_ENABLE
#define GC_EA_CPWD_SDP_ENABLE__ENABLE__SHIFT                                                                  0x0
#define GC_EA_CPWD_SDP_ENABLE__EARLY_CREDIT_REQUEST__SHIFT                                                    0x1
#define GC_EA_CPWD_SDP_ENABLE__ENABLE_MASK                                                                    0x00000001L
#define GC_EA_CPWD_SDP_ENABLE__EARLY_CREDIT_REQUEST_MASK                                                      0x00000002L


// addressBlock: gc_gfx_cpwd_gc_ea_se_gceadec
//GC_EA_SE_SDP_ARB_FINAL
#define GC_EA_SE_SDP_ARB_FINAL__DRAM_BURST_LIMIT__SHIFT                                                       0x0
#define GC_EA_SE_SDP_ARB_FINAL__MAM_BURST_LIMIT__SHIFT                                                        0x5
#define GC_EA_SE_SDP_ARB_FINAL__IO_BURST_LIMIT__SHIFT                                                         0xa
#define GC_EA_SE_SDP_ARB_FINAL__BURST_LIMIT_MULTIPLIER__SHIFT                                                 0xf
#define GC_EA_SE_SDP_ARB_FINAL__ERREVENT_ON_ERROR__SHIFT                                                      0x11
#define GC_EA_SE_SDP_ARB_FINAL__HALTREQ_ON_ERROR__SHIFT                                                       0x12
#define GC_EA_SE_SDP_ARB_FINAL__DRAM_BURST_LIMIT_MASK                                                         0x0000001FL
#define GC_EA_SE_SDP_ARB_FINAL__MAM_BURST_LIMIT_MASK                                                          0x000003E0L
#define GC_EA_SE_SDP_ARB_FINAL__IO_BURST_LIMIT_MASK                                                           0x00007C00L
#define GC_EA_SE_SDP_ARB_FINAL__BURST_LIMIT_MULTIPLIER_MASK                                                   0x00018000L
#define GC_EA_SE_SDP_ARB_FINAL__ERREVENT_ON_ERROR_MASK                                                        0x00020000L
#define GC_EA_SE_SDP_ARB_FINAL__HALTREQ_ON_ERROR_MASK                                                         0x00040000L
//GC_EA_SE_SDP_PRIORITY
#define GC_EA_SE_SDP_PRIORITY__DRAM_PRIORITY__SHIFT                                                           0x0
#define GC_EA_SE_SDP_PRIORITY__IO_RD_PRIORITY__SHIFT                                                          0x4
#define GC_EA_SE_SDP_PRIORITY__IO_WR_PRIORITY__SHIFT                                                          0x8
#define GC_EA_SE_SDP_PRIORITY__MAM_WR_PRIORITY__SHIFT                                                         0xc
#define GC_EA_SE_SDP_PRIORITY__DRAM_PRIORITY_MASK                                                             0x0000000FL
#define GC_EA_SE_SDP_PRIORITY__IO_RD_PRIORITY_MASK                                                            0x000000F0L
#define GC_EA_SE_SDP_PRIORITY__IO_WR_PRIORITY_MASK                                                            0x00000F00L
#define GC_EA_SE_SDP_PRIORITY__MAM_WR_PRIORITY_MASK                                                           0x0000F000L
//GC_EA_SE_SDP_CREDITS
#define GC_EA_SE_SDP_CREDITS__TAG_LIMIT__SHIFT                                                                0x0
#define GC_EA_SE_SDP_CREDITS__WR_RESP_CREDITS__SHIFT                                                          0x9
#define GC_EA_SE_SDP_CREDITS__RD_RESP_CREDITS__SHIFT                                                          0x10
#define GC_EA_SE_SDP_CREDITS__TAG_LIMIT_MASK                                                                  0x000001FFL
#define GC_EA_SE_SDP_CREDITS__WR_RESP_CREDITS_MASK                                                            0x0000FE00L
#define GC_EA_SE_SDP_CREDITS__RD_RESP_CREDITS_MASK                                                            0x007F0000L
//GC_EA_SE_SDP_TAG_RESERVE0
#define GC_EA_SE_SDP_TAG_RESERVE0__VC0__SHIFT                                                                 0x0
#define GC_EA_SE_SDP_TAG_RESERVE0__VC1__SHIFT                                                                 0x9
#define GC_EA_SE_SDP_TAG_RESERVE0__VC2__SHIFT                                                                 0x12
#define GC_EA_SE_SDP_TAG_RESERVE0__VC0_MASK                                                                   0x000001FFL
#define GC_EA_SE_SDP_TAG_RESERVE0__VC1_MASK                                                                   0x0003FE00L
#define GC_EA_SE_SDP_TAG_RESERVE0__VC2_MASK                                                                   0x07FC0000L
//GC_EA_SE_SDP_TAG_RESERVE1
#define GC_EA_SE_SDP_TAG_RESERVE1__VC3__SHIFT                                                                 0x0
#define GC_EA_SE_SDP_TAG_RESERVE1__VC4__SHIFT                                                                 0x9
#define GC_EA_SE_SDP_TAG_RESERVE1__VC5__SHIFT                                                                 0x12
#define GC_EA_SE_SDP_TAG_RESERVE1__VC3_MASK                                                                   0x000001FFL
#define GC_EA_SE_SDP_TAG_RESERVE1__VC4_MASK                                                                   0x0003FE00L
#define GC_EA_SE_SDP_TAG_RESERVE1__VC5_MASK                                                                   0x07FC0000L
//GC_EA_SE_SDP_TAG_RESERVE2
#define GC_EA_SE_SDP_TAG_RESERVE2__VC6__SHIFT                                                                 0x0
#define GC_EA_SE_SDP_TAG_RESERVE2__VC7__SHIFT                                                                 0x9
#define GC_EA_SE_SDP_TAG_RESERVE2__VC6_MASK                                                                   0x000001FFL
#define GC_EA_SE_SDP_TAG_RESERVE2__VC7_MASK                                                                   0x0003FE00L
//GC_EA_SE_SDP_VCC_RESERVE0
#define GC_EA_SE_SDP_VCC_RESERVE0__VC0_CREDITS__SHIFT                                                         0x0
#define GC_EA_SE_SDP_VCC_RESERVE0__VC1_CREDITS__SHIFT                                                         0x6
#define GC_EA_SE_SDP_VCC_RESERVE0__VC2_CREDITS__SHIFT                                                         0xc
#define GC_EA_SE_SDP_VCC_RESERVE0__VC3_CREDITS__SHIFT                                                         0x12
#define GC_EA_SE_SDP_VCC_RESERVE0__VC4_CREDITS__SHIFT                                                         0x18
#define GC_EA_SE_SDP_VCC_RESERVE0__VC0_CREDITS_MASK                                                           0x0000003FL
#define GC_EA_SE_SDP_VCC_RESERVE0__VC1_CREDITS_MASK                                                           0x00000FC0L
#define GC_EA_SE_SDP_VCC_RESERVE0__VC2_CREDITS_MASK                                                           0x0003F000L
#define GC_EA_SE_SDP_VCC_RESERVE0__VC3_CREDITS_MASK                                                           0x00FC0000L
#define GC_EA_SE_SDP_VCC_RESERVE0__VC4_CREDITS_MASK                                                           0x3F000000L
//GC_EA_SE_SDP_VCC_RESERVE1
#define GC_EA_SE_SDP_VCC_RESERVE1__VC5_CREDITS__SHIFT                                                         0x0
#define GC_EA_SE_SDP_VCC_RESERVE1__VC6_CREDITS__SHIFT                                                         0x6
#define GC_EA_SE_SDP_VCC_RESERVE1__VC7_CREDITS__SHIFT                                                         0xc
#define GC_EA_SE_SDP_VCC_RESERVE1__DISTRIBUTE_POOL__SHIFT                                                     0x1f
#define GC_EA_SE_SDP_VCC_RESERVE1__VC5_CREDITS_MASK                                                           0x0000003FL
#define GC_EA_SE_SDP_VCC_RESERVE1__VC6_CREDITS_MASK                                                           0x00000FC0L
#define GC_EA_SE_SDP_VCC_RESERVE1__VC7_CREDITS_MASK                                                           0x0003F000L
#define GC_EA_SE_SDP_VCC_RESERVE1__DISTRIBUTE_POOL_MASK                                                       0x80000000L
//GC_EA_SE_SDP_VCD_RESERVE0
#define GC_EA_SE_SDP_VCD_RESERVE0__VC0_CREDITS__SHIFT                                                         0x0
#define GC_EA_SE_SDP_VCD_RESERVE0__VC1_CREDITS__SHIFT                                                         0x6
#define GC_EA_SE_SDP_VCD_RESERVE0__VC2_CREDITS__SHIFT                                                         0xc
#define GC_EA_SE_SDP_VCD_RESERVE0__VC3_CREDITS__SHIFT                                                         0x12
#define GC_EA_SE_SDP_VCD_RESERVE0__VC4_CREDITS__SHIFT                                                         0x18
#define GC_EA_SE_SDP_VCD_RESERVE0__VC0_CREDITS_MASK                                                           0x0000003FL
#define GC_EA_SE_SDP_VCD_RESERVE0__VC1_CREDITS_MASK                                                           0x00000FC0L
#define GC_EA_SE_SDP_VCD_RESERVE0__VC2_CREDITS_MASK                                                           0x0003F000L
#define GC_EA_SE_SDP_VCD_RESERVE0__VC3_CREDITS_MASK                                                           0x00FC0000L
#define GC_EA_SE_SDP_VCD_RESERVE0__VC4_CREDITS_MASK                                                           0x3F000000L
//GC_EA_SE_SDP_VCD_RESERVE1
#define GC_EA_SE_SDP_VCD_RESERVE1__VC5_CREDITS__SHIFT                                                         0x0
#define GC_EA_SE_SDP_VCD_RESERVE1__VC6_CREDITS__SHIFT                                                         0x6
#define GC_EA_SE_SDP_VCD_RESERVE1__VC7_CREDITS__SHIFT                                                         0xc
#define GC_EA_SE_SDP_VCD_RESERVE1__DISTRIBUTE_POOL__SHIFT                                                     0x1f
#define GC_EA_SE_SDP_VCD_RESERVE1__VC5_CREDITS_MASK                                                           0x0000003FL
#define GC_EA_SE_SDP_VCD_RESERVE1__VC6_CREDITS_MASK                                                           0x00000FC0L
#define GC_EA_SE_SDP_VCD_RESERVE1__VC7_CREDITS_MASK                                                           0x0003F000L
#define GC_EA_SE_SDP_VCD_RESERVE1__DISTRIBUTE_POOL_MASK                                                       0x80000000L
//GC_EA_SE_SDP_REQ_CNTL
#define GC_EA_SE_SDP_REQ_CNTL__REQ_PASS_PW_OVERRIDE_READ__SHIFT                                               0x0
#define GC_EA_SE_SDP_REQ_CNTL__REQ_PASS_PW_OVERRIDE_WRITE__SHIFT                                              0x1
#define GC_EA_SE_SDP_REQ_CNTL__REQ_PASS_PW_OVERRIDE_ATOMIC__SHIFT                                             0x2
#define GC_EA_SE_SDP_REQ_CNTL__INNER_DOMAIN_MODE__SHIFT                                                       0x3
#define GC_EA_SE_SDP_REQ_CNTL__REQ_BLOCK_LEVEL_READ__SHIFT                                                    0x4
#define GC_EA_SE_SDP_REQ_CNTL__REQ_BLOCK_LEVEL_WRITE__SHIFT                                                   0x6
#define GC_EA_SE_SDP_REQ_CNTL__REQ_BLOCK_LEVEL_ATOMIC__SHIFT                                                  0x8
#define GC_EA_SE_SDP_REQ_CNTL__REQ_PASS_PW_OVERRIDE_READ_MASK                                                 0x00000001L
#define GC_EA_SE_SDP_REQ_CNTL__REQ_PASS_PW_OVERRIDE_WRITE_MASK                                                0x00000002L
#define GC_EA_SE_SDP_REQ_CNTL__REQ_PASS_PW_OVERRIDE_ATOMIC_MASK                                               0x00000004L
#define GC_EA_SE_SDP_REQ_CNTL__INNER_DOMAIN_MODE_MASK                                                         0x00000008L
#define GC_EA_SE_SDP_REQ_CNTL__REQ_BLOCK_LEVEL_READ_MASK                                                      0x00000030L
#define GC_EA_SE_SDP_REQ_CNTL__REQ_BLOCK_LEVEL_WRITE_MASK                                                     0x000000C0L
#define GC_EA_SE_SDP_REQ_CNTL__REQ_BLOCK_LEVEL_ATOMIC_MASK                                                    0x00000300L
//GC_EA_SE_MISC
#define GC_EA_SE_MISC__LINKMGR_DYNAMIC_MODE__SHIFT                                                            0x0
#define GC_EA_SE_MISC__LINKMGR_HALT_THRESHOLD__SHIFT                                                          0x2
#define GC_EA_SE_MISC__LINKMGR_RECONNECT_DELAY__SHIFT                                                         0x4
#define GC_EA_SE_MISC__LINKMGR_IDLE_THRESHOLD__SHIFT                                                          0x6
#define GC_EA_SE_MISC__LINKMGR_CREDITRESET_CGCG_IGNORE__SHIFT                                                 0xb
#define GC_EA_SE_MISC__LINKMGR_DYNAMIC_MODE_MASK                                                              0x00000003L
#define GC_EA_SE_MISC__LINKMGR_HALT_THRESHOLD_MASK                                                            0x0000000CL
#define GC_EA_SE_MISC__LINKMGR_RECONNECT_DELAY_MASK                                                           0x00000030L
#define GC_EA_SE_MISC__LINKMGR_IDLE_THRESHOLD_MASK                                                            0x000007C0L
#define GC_EA_SE_MISC__LINKMGR_CREDITRESET_CGCG_IGNORE_MASK                                                   0x00000800L
//GC_EA_SE_MISC2
#define GC_EA_SE_MISC2__BLOCK_REQUESTS__SHIFT                                                                 0x0
#define GC_EA_SE_MISC2__REQUESTS_BLOCKED__SHIFT                                                               0x1
#define GC_EA_SE_MISC2__FGCLKEN_OVERRIDE__SHIFT                                                               0x2
#define GC_EA_SE_MISC2__LINKMGR_CRBUSY_MASK__SHIFT                                                            0x3
#define GC_EA_SE_MISC2__RDRET_FED_MASK__SHIFT                                                                 0x4
#define GC_EA_SE_MISC2__BLOCK_REQUESTS_MASK                                                                   0x00000001L
#define GC_EA_SE_MISC2__REQUESTS_BLOCKED_MASK                                                                 0x00000002L
#define GC_EA_SE_MISC2__FGCLKEN_OVERRIDE_MASK                                                                 0x00000004L
#define GC_EA_SE_MISC2__LINKMGR_CRBUSY_MASK_MASK                                                              0x00000008L
#define GC_EA_SE_MISC2__RDRET_FED_MASK_MASK                                                                   0x00000010L
//GC_EA_SE_SDP_ENABLE
#define GC_EA_SE_SDP_ENABLE__ENABLE__SHIFT                                                                    0x0
#define GC_EA_SE_SDP_ENABLE__EARLY_CREDIT_REQUEST__SHIFT                                                      0x1
#define GC_EA_SE_SDP_ENABLE__ENABLE_MASK                                                                      0x00000001L
#define GC_EA_SE_SDP_ENABLE__EARLY_CREDIT_REQUEST_MASK                                                        0x00000002L


// addressBlock: gc_gfx_cpwd_cpwd_gcrdec
//GCR_PIO_CNTL
#define GCR_PIO_CNTL__GCR_DATA_INDEX__SHIFT                                                                   0x0
#define GCR_PIO_CNTL__GCR_REG_DONE__SHIFT                                                                     0x2
#define GCR_PIO_CNTL__GCR_REG_RESET__SHIFT                                                                    0x3
#define GCR_PIO_CNTL__GCR_PIO_RSP_TAG__SHIFT                                                                  0x10
#define GCR_PIO_CNTL__GCR_PIO_RSP_DONE__SHIFT                                                                 0x1e
#define GCR_PIO_CNTL__GCR_READY__SHIFT                                                                        0x1f
#define GCR_PIO_CNTL__GCR_DATA_INDEX_MASK                                                                     0x00000003L
#define GCR_PIO_CNTL__GCR_REG_DONE_MASK                                                                       0x00000004L
#define GCR_PIO_CNTL__GCR_REG_RESET_MASK                                                                      0x00000008L
#define GCR_PIO_CNTL__GCR_PIO_RSP_TAG_MASK                                                                    0x00FF0000L
#define GCR_PIO_CNTL__GCR_PIO_RSP_DONE_MASK                                                                   0x40000000L
#define GCR_PIO_CNTL__GCR_READY_MASK                                                                          0x80000000L
//GCR_PIO_DATA
#define GCR_PIO_DATA__GCR_DATA__SHIFT                                                                         0x0
#define GCR_PIO_DATA__GCR_DATA_MASK                                                                           0xFFFFFFFFL
//PMM_CNTL
#define PMM_CNTL__ABIT_FORCE_FLUSH__SHIFT                                                                     0x0
#define PMM_CNTL__RESERVED__SHIFT                                                                             0x1
#define PMM_CNTL__ABIT_FORCE_FLUSH_MASK                                                                       0x00000001L
#define PMM_CNTL__RESERVED_MASK                                                                               0xFFFFFFFEL
//PMM_STATUS
#define PMM_STATUS__PMM_IDLE__SHIFT                                                                           0x0
#define PMM_STATUS__ABIT_FORCE_FLUSH_IN_PROGRESS__SHIFT                                                       0x1
#define PMM_STATUS__ABIT_FORCE_FLUSH_DONE__SHIFT                                                              0x2
#define PMM_STATUS__PMM_INTERRUPTS_PENDING__SHIFT                                                             0x3
#define PMM_STATUS__ABIT_FLUSH_ERROR__SHIFT                                                                   0x4
#define PMM_STATUS__RESERVED__SHIFT                                                                           0x5
#define PMM_STATUS__PMM_IDLE_MASK                                                                             0x00000001L
#define PMM_STATUS__ABIT_FORCE_FLUSH_IN_PROGRESS_MASK                                                         0x00000002L
#define PMM_STATUS__ABIT_FORCE_FLUSH_DONE_MASK                                                                0x00000004L
#define PMM_STATUS__PMM_INTERRUPTS_PENDING_MASK                                                               0x00000008L
#define PMM_STATUS__ABIT_FLUSH_ERROR_MASK                                                                     0x00000010L
#define PMM_STATUS__RESERVED_MASK                                                                             0xFFFFFFE0L


// addressBlock: gc_gfx_cpwd_gcutcl2_gcvmsharedpfdec
//GCMC_VM_NB_MMIOBASE
#define GCMC_VM_NB_MMIOBASE__MMIOBASE__SHIFT                                                                  0x0
#define GCMC_VM_NB_MMIOBASE__MMIOBASE_MASK                                                                    0xFFFFFFFFL
//GCMC_VM_NB_MMIOLIMIT
#define GCMC_VM_NB_MMIOLIMIT__MMIOLIMIT__SHIFT                                                                0x0
#define GCMC_VM_NB_MMIOLIMIT__MMIOLIMIT_MASK                                                                  0xFFFFFFFFL
//GCMC_VM_NB_PCI_CTRL
#define GCMC_VM_NB_PCI_CTRL__MMIOENABLE__SHIFT                                                                0x17
#define GCMC_VM_NB_PCI_CTRL__MMIOENABLE_MASK                                                                  0x00800000L
//GCMC_VM_NB_PCI_ARB
#define GCMC_VM_NB_PCI_ARB__VGA_HOLE__SHIFT                                                                   0x3
#define GCMC_VM_NB_PCI_ARB__VGA_HOLE_MASK                                                                     0x00000008L
//GCMC_VM_NB_TOP_OF_DRAM_SLOT1
#define GCMC_VM_NB_TOP_OF_DRAM_SLOT1__TOP_OF_DRAM__SHIFT                                                      0x17
#define GCMC_VM_NB_TOP_OF_DRAM_SLOT1__TOP_OF_DRAM_MASK                                                        0xFF800000L
//GCMC_VM_NB_LOWER_TOP_OF_DRAM2
#define GCMC_VM_NB_LOWER_TOP_OF_DRAM2__ENABLE__SHIFT                                                          0x0
#define GCMC_VM_NB_LOWER_TOP_OF_DRAM2__LOWER_TOM2__SHIFT                                                      0x17
#define GCMC_VM_NB_LOWER_TOP_OF_DRAM2__ENABLE_MASK                                                            0x00000001L
#define GCMC_VM_NB_LOWER_TOP_OF_DRAM2__LOWER_TOM2_MASK                                                        0xFF800000L
//GCMC_VM_NB_UPPER_TOP_OF_DRAM2
#define GCMC_VM_NB_UPPER_TOP_OF_DRAM2__UPPER_TOM2__SHIFT                                                      0x0
#define GCMC_VM_NB_UPPER_TOP_OF_DRAM2__UPPER_TOM2_MASK                                                        0x0000FFFFL
//GCMC_VM_FB_OFFSET
#define GCMC_VM_FB_OFFSET__FB_OFFSET__SHIFT                                                                   0x0
#define GCMC_VM_FB_OFFSET__FB_OFFSET_MASK                                                                     0x00FFFFFFL
//GCMC_VM_SYSTEM_APERTURE_DEFAULT_ADDR_LSB
#define GCMC_VM_SYSTEM_APERTURE_DEFAULT_ADDR_LSB__PHYSICAL_PAGE_NUMBER_LSB__SHIFT                             0x0
#define GCMC_VM_SYSTEM_APERTURE_DEFAULT_ADDR_LSB__PHYSICAL_PAGE_NUMBER_LSB_MASK                               0xFFFFFFFFL
//GCMC_VM_SYSTEM_APERTURE_DEFAULT_ADDR_MSB
#define GCMC_VM_SYSTEM_APERTURE_DEFAULT_ADDR_MSB__PHYSICAL_PAGE_NUMBER_MSB__SHIFT                             0x0
#define GCMC_VM_SYSTEM_APERTURE_DEFAULT_ADDR_MSB__PHYSICAL_PAGE_NUMBER_MSB_MASK                               0x0000000FL
//GCMC_VM_STEERING
#define GCMC_VM_STEERING__DEFAULT_STEERING__SHIFT                                                             0x0
#define GCMC_VM_STEERING__DEFAULT_STEERING_MASK                                                               0x00000003L
//GCMC_SHARED_VIRT_RESET_REQ
#define GCMC_SHARED_VIRT_RESET_REQ__VF__SHIFT                                                                 0x0
#define GCMC_SHARED_VIRT_RESET_REQ__PF__SHIFT                                                                 0x18
#define GCMC_SHARED_VIRT_RESET_REQ__VF_MASK                                                                   0x00FFFFFFL
#define GCMC_SHARED_VIRT_RESET_REQ__PF_MASK                                                                   0x01000000L
//GCMC_VM_CACHEABLE_DRAM_ADDRESS_START
#define GCMC_VM_CACHEABLE_DRAM_ADDRESS_START__ADDRESS__SHIFT                                                  0x0
#define GCMC_VM_CACHEABLE_DRAM_ADDRESS_START__ADDRESS_MASK                                                    0x00FFFFFFL
//GCMC_VM_CACHEABLE_DRAM_ADDRESS_END
#define GCMC_VM_CACHEABLE_DRAM_ADDRESS_END__ADDRESS__SHIFT                                                    0x0
#define GCMC_VM_CACHEABLE_DRAM_ADDRESS_END__ADDRESS_MASK                                                      0x00FFFFFFL
//GCMC_VM_LOCAL_SYSMEM_ADDRESS_START
#define GCMC_VM_LOCAL_SYSMEM_ADDRESS_START__ADDRESS__SHIFT                                                    0x0
#define GCMC_VM_LOCAL_SYSMEM_ADDRESS_START__ADDRESS_MASK                                                      0x00FFFFFFL
//GCMC_VM_LOCAL_SYSMEM_ADDRESS_END
#define GCMC_VM_LOCAL_SYSMEM_ADDRESS_END__ADDRESS__SHIFT                                                      0x0
#define GCMC_VM_LOCAL_SYSMEM_ADDRESS_END__ADDRESS_MASK                                                        0x00FFFFFFL
//GCMC_VM_APT_CNTL
#define GCMC_VM_APT_CNTL__FORCE_MTYPE_UC__SHIFT                                                               0x0
#define GCMC_VM_APT_CNTL__DIRECT_SYSTEM_EN__SHIFT                                                             0x1
#define GCMC_VM_APT_CNTL__FRAG_APT_INTXN_MODE__SHIFT                                                          0x2
#define GCMC_VM_APT_CNTL__CHECK_IS_LOCAL__SHIFT                                                               0x4
#define GCMC_VM_APT_CNTL__CAP_FRAG_SIZE_2M__SHIFT                                                             0x5
#define GCMC_VM_APT_CNTL__LOCAL_SYSMEM_APERTURE_CNTL__SHIFT                                                   0x6
#define GCMC_VM_APT_CNTL__FORCE_MTYPE_UC_MASK                                                                 0x00000001L
#define GCMC_VM_APT_CNTL__DIRECT_SYSTEM_EN_MASK                                                               0x00000002L
#define GCMC_VM_APT_CNTL__FRAG_APT_INTXN_MODE_MASK                                                            0x0000000CL
#define GCMC_VM_APT_CNTL__CHECK_IS_LOCAL_MASK                                                                 0x00000010L
#define GCMC_VM_APT_CNTL__CAP_FRAG_SIZE_2M_MASK                                                               0x00000020L
#define GCMC_VM_APT_CNTL__LOCAL_SYSMEM_APERTURE_CNTL_MASK                                                     0x000000C0L
//GCMC_VM_LOCAL_FB_ADDRESS_START
#define GCMC_VM_LOCAL_FB_ADDRESS_START__ADDRESS__SHIFT                                                        0x0
#define GCMC_VM_LOCAL_FB_ADDRESS_START__ADDRESS_MASK                                                          0x00FFFFFFL
//GCMC_VM_LOCAL_FB_ADDRESS_END
#define GCMC_VM_LOCAL_FB_ADDRESS_END__ADDRESS__SHIFT                                                          0x0
#define GCMC_VM_LOCAL_FB_ADDRESS_END__ADDRESS_MASK                                                            0x00FFFFFFL
//GCMC_VM_LOCAL_FB_ADDRESS_LOCK_CNTL
#define GCMC_VM_LOCAL_FB_ADDRESS_LOCK_CNTL__LOCK__SHIFT                                                       0x0
#define GCMC_VM_LOCAL_FB_ADDRESS_LOCK_CNTL__LOCK_MASK                                                         0x00000001L
//GCUTCL2_ICG_CTRL
#define GCUTCL2_ICG_CTRL__OFF_HYSTERESIS__SHIFT                                                               0x0
#define GCUTCL2_ICG_CTRL__DYNAMIC_CLOCK_OVERRIDE__SHIFT                                                       0x4
#define GCUTCL2_ICG_CTRL__STATIC_CLOCK_OVERRIDE__SHIFT                                                        0x5
#define GCUTCL2_ICG_CTRL__AON_CLOCK_OVERRIDE__SHIFT                                                           0x6
#define GCUTCL2_ICG_CTRL__PERFMON_CLOCK_OVERRIDE__SHIFT                                                       0x7
#define GCUTCL2_ICG_CTRL__OFF_HYSTERESIS_MASK                                                                 0x0000000FL
#define GCUTCL2_ICG_CTRL__DYNAMIC_CLOCK_OVERRIDE_MASK                                                         0x00000010L
#define GCUTCL2_ICG_CTRL__STATIC_CLOCK_OVERRIDE_MASK                                                          0x00000020L
#define GCUTCL2_ICG_CTRL__AON_CLOCK_OVERRIDE_MASK                                                             0x00000040L
#define GCUTCL2_ICG_CTRL__PERFMON_CLOCK_OVERRIDE_MASK                                                         0x00000080L
//GCMC_SHARED_ACTIVE_FCN_ID
#define GCMC_SHARED_ACTIVE_FCN_ID__VFID__SHIFT                                                                0x0
#define GCMC_SHARED_ACTIVE_FCN_ID__VF__SHIFT                                                                  0x1f
#define GCMC_SHARED_ACTIVE_FCN_ID__VFID_MASK                                                                  0x0000001FL
#define GCMC_SHARED_ACTIVE_FCN_ID__VF_MASK                                                                    0x80000000L
//GCUTCL2_CGTT_BUSY_CTRL
#define GCUTCL2_CGTT_BUSY_CTRL__READ_DELAY__SHIFT                                                             0x0
#define GCUTCL2_CGTT_BUSY_CTRL__ALWAYS_BUSY__SHIFT                                                            0x5
#define GCUTCL2_CGTT_BUSY_CTRL__READ_DELAY_MASK                                                               0x0000001FL
#define GCUTCL2_CGTT_BUSY_CTRL__ALWAYS_BUSY_MASK                                                              0x00000020L
//GCUTCL2_HARVEST_BYPASS_GROUPS
#define GCUTCL2_HARVEST_BYPASS_GROUPS__BYPASS_GROUPS__SHIFT                                                   0x0
#define GCUTCL2_HARVEST_BYPASS_GROUPS__BYPASS_GROUPS_MASK                                                     0xFFFFFFFFL
//GCUTCL2_GROUP_RET_FAULT_STATUS
#define GCUTCL2_GROUP_RET_FAULT_STATUS__FAULT_GROUPS__SHIFT                                                   0x0
#define GCUTCL2_GROUP_RET_FAULT_STATUS__FAULT_GROUPS_MASK                                                     0xFFFFFFFFL


// addressBlock: gc_gfx_cpwd_gcutcl2_gcvml2pfdec
//GCVM_L2_CNTL
#define GCVM_L2_CNTL__ENABLE_L2_CACHE__SHIFT                                                                  0x0
#define GCVM_L2_CNTL__ENABLE_L2_FRAGMENT_PROCESSING__SHIFT                                                    0x1
#define GCVM_L2_CNTL__L2_CACHE_PTE_ENDIAN_SWAP_MODE__SHIFT                                                    0x2
#define GCVM_L2_CNTL__L2_CACHE_PDE_ENDIAN_SWAP_MODE__SHIFT                                                    0x4
#define GCVM_L2_CNTL__L2_PDE0_CACHE_TAG_GENERATION_MODE__SHIFT                                                0x8
#define GCVM_L2_CNTL__ENABLE_L2_PTE_CACHE_LRU_UPDATE_BY_WRITE__SHIFT                                          0x9
#define GCVM_L2_CNTL__ENABLE_L2_PDE0_CACHE_LRU_UPDATE_BY_WRITE__SHIFT                                         0xa
#define GCVM_L2_CNTL__ENABLE_DEFAULT_PAGE_OUT_TO_SYSTEM_MEMORY__SHIFT                                         0xb
#define GCVM_L2_CNTL__L2_PDE0_CACHE_SPLIT_MODE__SHIFT                                                         0xc
#define GCVM_L2_CNTL__EFFECTIVE_L2_QUEUE_SIZE__SHIFT                                                          0xf
#define GCVM_L2_CNTL__PDE_FAULT_CLASSIFICATION__SHIFT                                                         0x12
#define GCVM_L2_CNTL__CONTEXT1_IDENTITY_ACCESS_MODE__SHIFT                                                    0x13
#define GCVM_L2_CNTL__IDENTITY_MODE_FRAGMENT_SIZE__SHIFT                                                      0x15
#define GCVM_L2_CNTL__L2_PTE_CACHE_ADDR_MODE__SHIFT                                                           0x1a
#define GCVM_L2_CNTL__ENABLE_L2_CACHE_MASK                                                                    0x00000001L
#define GCVM_L2_CNTL__ENABLE_L2_FRAGMENT_PROCESSING_MASK                                                      0x00000002L
#define GCVM_L2_CNTL__L2_CACHE_PTE_ENDIAN_SWAP_MODE_MASK                                                      0x0000000CL
#define GCVM_L2_CNTL__L2_CACHE_PDE_ENDIAN_SWAP_MODE_MASK                                                      0x00000030L
#define GCVM_L2_CNTL__L2_PDE0_CACHE_TAG_GENERATION_MODE_MASK                                                  0x00000100L
#define GCVM_L2_CNTL__ENABLE_L2_PTE_CACHE_LRU_UPDATE_BY_WRITE_MASK                                            0x00000200L
#define GCVM_L2_CNTL__ENABLE_L2_PDE0_CACHE_LRU_UPDATE_BY_WRITE_MASK                                           0x00000400L
#define GCVM_L2_CNTL__ENABLE_DEFAULT_PAGE_OUT_TO_SYSTEM_MEMORY_MASK                                           0x00000800L
#define GCVM_L2_CNTL__L2_PDE0_CACHE_SPLIT_MODE_MASK                                                           0x00007000L
#define GCVM_L2_CNTL__EFFECTIVE_L2_QUEUE_SIZE_MASK                                                            0x00038000L
#define GCVM_L2_CNTL__PDE_FAULT_CLASSIFICATION_MASK                                                           0x00040000L
#define GCVM_L2_CNTL__CONTEXT1_IDENTITY_ACCESS_MODE_MASK                                                      0x00180000L
#define GCVM_L2_CNTL__IDENTITY_MODE_FRAGMENT_SIZE_MASK                                                        0x03E00000L
#define GCVM_L2_CNTL__L2_PTE_CACHE_ADDR_MODE_MASK                                                             0x0C000000L
//GCVM_L2_CNTL2
#define GCVM_L2_CNTL2__INVALIDATE_ALL_L1_TLBS__SHIFT                                                          0x0
#define GCVM_L2_CNTL2__INVALIDATE_L2_CACHE__SHIFT                                                             0x1
#define GCVM_L2_CNTL2__DISABLE_INVALIDATE_PER_DOMAIN__SHIFT                                                   0x15
#define GCVM_L2_CNTL2__DISABLE_BIGK_CACHE_OPTIMIZATION__SHIFT                                                 0x16
#define GCVM_L2_CNTL2__L2_PTE_CACHE_VMID_MODE__SHIFT                                                          0x17
#define GCVM_L2_CNTL2__INVALIDATE_CACHE_MODE__SHIFT                                                           0x1a
#define GCVM_L2_CNTL2__PDE_CACHE_EFFECTIVE_SIZE__SHIFT                                                        0x1c
#define GCVM_L2_CNTL2__INVALIDATE_ALL_L1_TLBS_MASK                                                            0x00000001L
#define GCVM_L2_CNTL2__INVALIDATE_L2_CACHE_MASK                                                               0x00000002L
#define GCVM_L2_CNTL2__DISABLE_INVALIDATE_PER_DOMAIN_MASK                                                     0x00200000L
#define GCVM_L2_CNTL2__DISABLE_BIGK_CACHE_OPTIMIZATION_MASK                                                   0x00400000L
#define GCVM_L2_CNTL2__L2_PTE_CACHE_VMID_MODE_MASK                                                            0x03800000L
#define GCVM_L2_CNTL2__INVALIDATE_CACHE_MODE_MASK                                                             0x0C000000L
#define GCVM_L2_CNTL2__PDE_CACHE_EFFECTIVE_SIZE_MASK                                                          0x70000000L
//GCVM_L2_CNTL3
#define GCVM_L2_CNTL3__BANK_SELECT__SHIFT                                                                     0x0
#define GCVM_L2_CNTL3__L2_CACHE_UPDATE_MODE__SHIFT                                                            0x6
#define GCVM_L2_CNTL3__L2_CACHE_UPDATE_WILDCARD_REFERENCE_VALUE__SHIFT                                        0x8
#define GCVM_L2_CNTL3__L2_CACHE_BIGK_FRAGMENT_SIZE__SHIFT                                                     0xf
#define GCVM_L2_CNTL3__L2_CACHE_BIGK_ASSOCIATIVITY__SHIFT                                                     0x14
#define GCVM_L2_CNTL3__L2_CACHE_4K_EFFECTIVE_SIZE__SHIFT                                                      0x15
#define GCVM_L2_CNTL3__L2_CACHE_BIGK_EFFECTIVE_SIZE__SHIFT                                                    0x18
#define GCVM_L2_CNTL3__L2_CACHE_4K_FORCE_MISS__SHIFT                                                          0x1c
#define GCVM_L2_CNTL3__L2_CACHE_BIGK_FORCE_MISS__SHIFT                                                        0x1d
#define GCVM_L2_CNTL3__PDE_CACHE_FORCE_MISS__SHIFT                                                            0x1e
#define GCVM_L2_CNTL3__L2_CACHE_4K_ASSOCIATIVITY__SHIFT                                                       0x1f
#define GCVM_L2_CNTL3__BANK_SELECT_MASK                                                                       0x0000003FL
#define GCVM_L2_CNTL3__L2_CACHE_UPDATE_MODE_MASK                                                              0x000000C0L
#define GCVM_L2_CNTL3__L2_CACHE_UPDATE_WILDCARD_REFERENCE_VALUE_MASK                                          0x00001F00L
#define GCVM_L2_CNTL3__L2_CACHE_BIGK_FRAGMENT_SIZE_MASK                                                       0x000F8000L
#define GCVM_L2_CNTL3__L2_CACHE_BIGK_ASSOCIATIVITY_MASK                                                       0x00100000L
#define GCVM_L2_CNTL3__L2_CACHE_4K_EFFECTIVE_SIZE_MASK                                                        0x00E00000L
#define GCVM_L2_CNTL3__L2_CACHE_BIGK_EFFECTIVE_SIZE_MASK                                                      0x0F000000L
#define GCVM_L2_CNTL3__L2_CACHE_4K_FORCE_MISS_MASK                                                            0x10000000L
#define GCVM_L2_CNTL3__L2_CACHE_BIGK_FORCE_MISS_MASK                                                          0x20000000L
#define GCVM_L2_CNTL3__PDE_CACHE_FORCE_MISS_MASK                                                              0x40000000L
#define GCVM_L2_CNTL3__L2_CACHE_4K_ASSOCIATIVITY_MASK                                                         0x80000000L
//GCVM_L2_STATUS
#define GCVM_L2_STATUS__L2_BUSY__SHIFT                                                                        0x0
#define GCVM_L2_STATUS__CONTEXT_DOMAIN_BUSY__SHIFT                                                            0x1
#define GCVM_L2_STATUS__FOUND_4K_PTE_CACHE_PARITY_ERRORS__SHIFT                                               0x11
#define GCVM_L2_STATUS__FOUND_BIGK_PTE_CACHE_PARITY_ERRORS__SHIFT                                             0x12
#define GCVM_L2_STATUS__FOUND_PDE0_CACHE_PARITY_ERRORS__SHIFT                                                 0x13
#define GCVM_L2_STATUS__FOUND_PDE1_CACHE_PARITY_ERRORS__SHIFT                                                 0x14
#define GCVM_L2_STATUS__FOUND_PDE2_CACHE_PARITY_ERRORS__SHIFT                                                 0x15
#define GCVM_L2_STATUS__L2_BUSY_MASK                                                                          0x00000001L
#define GCVM_L2_STATUS__CONTEXT_DOMAIN_BUSY_MASK                                                              0x0001FFFEL
#define GCVM_L2_STATUS__FOUND_4K_PTE_CACHE_PARITY_ERRORS_MASK                                                 0x00020000L
#define GCVM_L2_STATUS__FOUND_BIGK_PTE_CACHE_PARITY_ERRORS_MASK                                               0x00040000L
#define GCVM_L2_STATUS__FOUND_PDE0_CACHE_PARITY_ERRORS_MASK                                                   0x00080000L
#define GCVM_L2_STATUS__FOUND_PDE1_CACHE_PARITY_ERRORS_MASK                                                   0x00100000L
#define GCVM_L2_STATUS__FOUND_PDE2_CACHE_PARITY_ERRORS_MASK                                                   0x00200000L
//GCVM_DUMMY_PAGE_FAULT_CNTL
#define GCVM_DUMMY_PAGE_FAULT_CNTL__DUMMY_PAGE_FAULT_ENABLE__SHIFT                                            0x0
#define GCVM_DUMMY_PAGE_FAULT_CNTL__DUMMY_PAGE_ADDRESS_LOGICAL__SHIFT                                         0x1
#define GCVM_DUMMY_PAGE_FAULT_CNTL__DUMMY_PAGE_COMPARE_MSBS__SHIFT                                            0x2
#define GCVM_DUMMY_PAGE_FAULT_CNTL__DUMMY_PAGE_FAULT_ENABLE_MASK                                              0x00000001L
#define GCVM_DUMMY_PAGE_FAULT_CNTL__DUMMY_PAGE_ADDRESS_LOGICAL_MASK                                           0x00000002L
#define GCVM_DUMMY_PAGE_FAULT_CNTL__DUMMY_PAGE_COMPARE_MSBS_MASK                                              0x000000FCL
//GCVM_DUMMY_PAGE_FAULT_ADDR_LO32
#define GCVM_DUMMY_PAGE_FAULT_ADDR_LO32__DUMMY_PAGE_ADDR_LO32__SHIFT                                          0x0
#define GCVM_DUMMY_PAGE_FAULT_ADDR_LO32__DUMMY_PAGE_ADDR_LO32_MASK                                            0xFFFFFFFFL
//GCVM_DUMMY_PAGE_FAULT_ADDR_HI32
#define GCVM_DUMMY_PAGE_FAULT_ADDR_HI32__DUMMY_PAGE_ADDR_HI4__SHIFT                                           0x0
#define GCVM_DUMMY_PAGE_FAULT_ADDR_HI32__DUMMY_PAGE_ADDR_HI4_MASK                                             0x0000000FL
//GCVM_INVALIDATE_CNTL
#define GCVM_INVALIDATE_CNTL__PRI_REG_ALTERNATING__SHIFT                                                      0x0
#define GCVM_INVALIDATE_CNTL__MAX_REG_OUTSTANDING__SHIFT                                                      0x8
#define GCVM_INVALIDATE_CNTL__PRI_REG_ALTERNATING_MASK                                                        0x000000FFL
#define GCVM_INVALIDATE_CNTL__MAX_REG_OUTSTANDING_MASK                                                        0x0000FF00L
//GCVM_L2_PROTECTION_FAULT_CNTL
#define GCVM_L2_PROTECTION_FAULT_CNTL__CLEAR_PROTECTION_FAULT_STATUS_ADDR__SHIFT                              0x0
#define GCVM_L2_PROTECTION_FAULT_CNTL__ALLOW_SUBSEQUENT_PROTECTION_FAULT_STATUS_ADDR_UPDATES__SHIFT           0x1
#define GCVM_L2_PROTECTION_FAULT_CNTL__RANGE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                           0x2
#define GCVM_L2_PROTECTION_FAULT_CNTL__PDE0_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                            0x3
#define GCVM_L2_PROTECTION_FAULT_CNTL__PDE1_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                            0x4
#define GCVM_L2_PROTECTION_FAULT_CNTL__PDE2_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                            0x5
#define GCVM_L2_PROTECTION_FAULT_CNTL__TRANSLATE_FURTHER_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT               0x6
#define GCVM_L2_PROTECTION_FAULT_CNTL__NACK_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                            0x7
#define GCVM_L2_PROTECTION_FAULT_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                      0x8
#define GCVM_L2_PROTECTION_FAULT_CNTL__VALID_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                           0x9
#define GCVM_L2_PROTECTION_FAULT_CNTL__READ_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                            0xa
#define GCVM_L2_PROTECTION_FAULT_CNTL__WRITE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                           0xb
#define GCVM_L2_PROTECTION_FAULT_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                         0xc
#define GCVM_L2_PROTECTION_FAULT_CNTL__CLIENT_ID_NO_RETRY_FAULT_INTERRUPT__SHIFT                              0xd
#define GCVM_L2_PROTECTION_FAULT_CNTL__OTHER_CLIENT_ID_NO_RETRY_FAULT_INTERRUPT__SHIFT                        0x1d
#define GCVM_L2_PROTECTION_FAULT_CNTL__CRASH_ON_NO_RETRY_FAULT__SHIFT                                         0x1e
#define GCVM_L2_PROTECTION_FAULT_CNTL__CRASH_ON_RETRY_FAULT__SHIFT                                            0x1f
#define GCVM_L2_PROTECTION_FAULT_CNTL__CLEAR_PROTECTION_FAULT_STATUS_ADDR_MASK                                0x00000001L
#define GCVM_L2_PROTECTION_FAULT_CNTL__ALLOW_SUBSEQUENT_PROTECTION_FAULT_STATUS_ADDR_UPDATES_MASK             0x00000002L
#define GCVM_L2_PROTECTION_FAULT_CNTL__RANGE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                             0x00000004L
#define GCVM_L2_PROTECTION_FAULT_CNTL__PDE0_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                              0x00000008L
#define GCVM_L2_PROTECTION_FAULT_CNTL__PDE1_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                              0x00000010L
#define GCVM_L2_PROTECTION_FAULT_CNTL__PDE2_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                              0x00000020L
#define GCVM_L2_PROTECTION_FAULT_CNTL__TRANSLATE_FURTHER_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                 0x00000040L
#define GCVM_L2_PROTECTION_FAULT_CNTL__NACK_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                              0x00000080L
#define GCVM_L2_PROTECTION_FAULT_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                        0x00000100L
#define GCVM_L2_PROTECTION_FAULT_CNTL__VALID_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                             0x00000200L
#define GCVM_L2_PROTECTION_FAULT_CNTL__READ_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                              0x00000400L
#define GCVM_L2_PROTECTION_FAULT_CNTL__WRITE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                             0x00000800L
#define GCVM_L2_PROTECTION_FAULT_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                           0x00001000L
#define GCVM_L2_PROTECTION_FAULT_CNTL__CLIENT_ID_NO_RETRY_FAULT_INTERRUPT_MASK                                0x1FFFE000L
#define GCVM_L2_PROTECTION_FAULT_CNTL__OTHER_CLIENT_ID_NO_RETRY_FAULT_INTERRUPT_MASK                          0x20000000L
#define GCVM_L2_PROTECTION_FAULT_CNTL__CRASH_ON_NO_RETRY_FAULT_MASK                                           0x40000000L
#define GCVM_L2_PROTECTION_FAULT_CNTL__CRASH_ON_RETRY_FAULT_MASK                                              0x80000000L
//GCVM_L2_PROTECTION_FAULT_CNTL2
#define GCVM_L2_PROTECTION_FAULT_CNTL2__CLIENT_ID_PRT_FAULT_INTERRUPT__SHIFT                                  0x0
#define GCVM_L2_PROTECTION_FAULT_CNTL2__OTHER_CLIENT_ID_PRT_FAULT_INTERRUPT__SHIFT                            0x10
#define GCVM_L2_PROTECTION_FAULT_CNTL2__ACTIVE_PAGE_MIGRATION_PTE__SHIFT                                      0x11
#define GCVM_L2_PROTECTION_FAULT_CNTL2__ACTIVE_PAGE_MIGRATION_PTE_READ_RETRY__SHIFT                           0x12
#define GCVM_L2_PROTECTION_FAULT_CNTL2__ENABLE_RETRY_FAULT_INTERRUPT__SHIFT                                   0x13
#define GCVM_L2_PROTECTION_FAULT_CNTL2__CLIENT_ID_PRT_FAULT_INTERRUPT_MASK                                    0x0000FFFFL
#define GCVM_L2_PROTECTION_FAULT_CNTL2__OTHER_CLIENT_ID_PRT_FAULT_INTERRUPT_MASK                              0x00010000L
#define GCVM_L2_PROTECTION_FAULT_CNTL2__ACTIVE_PAGE_MIGRATION_PTE_MASK                                        0x00020000L
#define GCVM_L2_PROTECTION_FAULT_CNTL2__ACTIVE_PAGE_MIGRATION_PTE_READ_RETRY_MASK                             0x00040000L
#define GCVM_L2_PROTECTION_FAULT_CNTL2__ENABLE_RETRY_FAULT_INTERRUPT_MASK                                     0x00080000L
//GCVM_L2_PROTECTION_FAULT_MM_CNTL3
#define GCVM_L2_PROTECTION_FAULT_MM_CNTL3__VML1_READ_CLIENT_ID_NO_RETRY_FAULT_INTERRUPT__SHIFT                0x0
#define GCVM_L2_PROTECTION_FAULT_MM_CNTL3__VML1_READ_CLIENT_ID_NO_RETRY_FAULT_INTERRUPT_MASK                  0xFFFFFFFFL
//GCVM_L2_PROTECTION_FAULT_MM_CNTL4
#define GCVM_L2_PROTECTION_FAULT_MM_CNTL4__VML1_WRITE_CLIENT_ID_NO_RETRY_FAULT_INTERRUPT__SHIFT               0x0
#define GCVM_L2_PROTECTION_FAULT_MM_CNTL4__VML1_WRITE_CLIENT_ID_NO_RETRY_FAULT_INTERRUPT_MASK                 0xFFFFFFFFL
//GCVM_L2_PROTECTION_FAULT_STATUS_LO32
#define GCVM_L2_PROTECTION_FAULT_STATUS_LO32__MORE_FAULTS__SHIFT                                              0x0
#define GCVM_L2_PROTECTION_FAULT_STATUS_LO32__WALKER_ERROR__SHIFT                                             0x1
#define GCVM_L2_PROTECTION_FAULT_STATUS_LO32__PERMISSION_FAULTS__SHIFT                                        0x4
#define GCVM_L2_PROTECTION_FAULT_STATUS_LO32__MAPPING_ERROR__SHIFT                                            0x8
#define GCVM_L2_PROTECTION_FAULT_STATUS_LO32__CID__SHIFT                                                      0x9
#define GCVM_L2_PROTECTION_FAULT_STATUS_LO32__RW__SHIFT                                                       0x12
#define GCVM_L2_PROTECTION_FAULT_STATUS_LO32__ATOMIC__SHIFT                                                   0x13
#define GCVM_L2_PROTECTION_FAULT_STATUS_LO32__VMID__SHIFT                                                     0x14
#define GCVM_L2_PROTECTION_FAULT_STATUS_LO32__VF__SHIFT                                                       0x18
#define GCVM_L2_PROTECTION_FAULT_STATUS_LO32__VFID__SHIFT                                                     0x19
#define GCVM_L2_PROTECTION_FAULT_STATUS_LO32__PRT__SHIFT                                                      0x1e
#define GCVM_L2_PROTECTION_FAULT_STATUS_LO32__UCE__SHIFT                                                      0x1f
#define GCVM_L2_PROTECTION_FAULT_STATUS_LO32__MORE_FAULTS_MASK                                                0x00000001L
#define GCVM_L2_PROTECTION_FAULT_STATUS_LO32__WALKER_ERROR_MASK                                               0x0000000EL
#define GCVM_L2_PROTECTION_FAULT_STATUS_LO32__PERMISSION_FAULTS_MASK                                          0x000000F0L
#define GCVM_L2_PROTECTION_FAULT_STATUS_LO32__MAPPING_ERROR_MASK                                              0x00000100L
#define GCVM_L2_PROTECTION_FAULT_STATUS_LO32__CID_MASK                                                        0x0003FE00L
#define GCVM_L2_PROTECTION_FAULT_STATUS_LO32__RW_MASK                                                         0x00040000L
#define GCVM_L2_PROTECTION_FAULT_STATUS_LO32__ATOMIC_MASK                                                     0x00080000L
#define GCVM_L2_PROTECTION_FAULT_STATUS_LO32__VMID_MASK                                                       0x00F00000L
#define GCVM_L2_PROTECTION_FAULT_STATUS_LO32__VF_MASK                                                         0x01000000L
#define GCVM_L2_PROTECTION_FAULT_STATUS_LO32__VFID_MASK                                                       0x3E000000L
#define GCVM_L2_PROTECTION_FAULT_STATUS_LO32__PRT_MASK                                                        0x40000000L
#define GCVM_L2_PROTECTION_FAULT_STATUS_LO32__UCE_MASK                                                        0x80000000L
//GCVM_L2_PROTECTION_FAULT_STATUS_HI32
#define GCVM_L2_PROTECTION_FAULT_STATUS_HI32__FED__SHIFT                                                      0x0
#define GCVM_L2_PROTECTION_FAULT_STATUS_HI32__FED_MASK                                                        0x00000001L
//GCVM_L2_PROTECTION_FAULT_ADDR_LO32
#define GCVM_L2_PROTECTION_FAULT_ADDR_LO32__LOGICAL_PAGE_ADDR_LO32__SHIFT                                     0x0
#define GCVM_L2_PROTECTION_FAULT_ADDR_LO32__LOGICAL_PAGE_ADDR_LO32_MASK                                       0xFFFFFFFFL
//GCVM_L2_PROTECTION_FAULT_ADDR_HI32
#define GCVM_L2_PROTECTION_FAULT_ADDR_HI32__LOGICAL_PAGE_ADDR_HI4__SHIFT                                      0x0
#define GCVM_L2_PROTECTION_FAULT_ADDR_HI32__LOGICAL_PAGE_ADDR_HI4_MASK                                        0x0000000FL
//GCVM_L2_PROTECTION_FAULT_DEFAULT_ADDR_LO32
#define GCVM_L2_PROTECTION_FAULT_DEFAULT_ADDR_LO32__PHYSICAL_PAGE_ADDR_LO32__SHIFT                            0x0
#define GCVM_L2_PROTECTION_FAULT_DEFAULT_ADDR_LO32__PHYSICAL_PAGE_ADDR_LO32_MASK                              0xFFFFFFFFL
//GCVM_L2_PROTECTION_FAULT_DEFAULT_ADDR_HI32
#define GCVM_L2_PROTECTION_FAULT_DEFAULT_ADDR_HI32__PHYSICAL_PAGE_ADDR_HI4__SHIFT                             0x0
#define GCVM_L2_PROTECTION_FAULT_DEFAULT_ADDR_HI32__PHYSICAL_PAGE_ADDR_HI4_MASK                               0x0000000FL
//GCVM_L2_CONTEXT1_IDENTITY_APERTURE_LOW_ADDR_LO32
#define GCVM_L2_CONTEXT1_IDENTITY_APERTURE_LOW_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32__SHIFT                     0x0
#define GCVM_L2_CONTEXT1_IDENTITY_APERTURE_LOW_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32_MASK                       0xFFFFFFFFL
//GCVM_L2_CONTEXT1_IDENTITY_APERTURE_LOW_ADDR_HI32
#define GCVM_L2_CONTEXT1_IDENTITY_APERTURE_LOW_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4__SHIFT                      0x0
#define GCVM_L2_CONTEXT1_IDENTITY_APERTURE_LOW_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4_MASK                        0x0000000FL
//GCVM_L2_CONTEXT1_IDENTITY_APERTURE_HIGH_ADDR_LO32
#define GCVM_L2_CONTEXT1_IDENTITY_APERTURE_HIGH_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32__SHIFT                    0x0
#define GCVM_L2_CONTEXT1_IDENTITY_APERTURE_HIGH_ADDR_LO32__LOGICAL_PAGE_NUMBER_LO32_MASK                      0xFFFFFFFFL
//GCVM_L2_CONTEXT1_IDENTITY_APERTURE_HIGH_ADDR_HI32
#define GCVM_L2_CONTEXT1_IDENTITY_APERTURE_HIGH_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4__SHIFT                     0x0
#define GCVM_L2_CONTEXT1_IDENTITY_APERTURE_HIGH_ADDR_HI32__LOGICAL_PAGE_NUMBER_HI4_MASK                       0x0000000FL
//GCVM_L2_CONTEXT_IDENTITY_PHYSICAL_OFFSET_LO32
#define GCVM_L2_CONTEXT_IDENTITY_PHYSICAL_OFFSET_LO32__PHYSICAL_PAGE_OFFSET_LO32__SHIFT                       0x0
#define GCVM_L2_CONTEXT_IDENTITY_PHYSICAL_OFFSET_LO32__PHYSICAL_PAGE_OFFSET_LO32_MASK                         0xFFFFFFFFL
//GCVM_L2_CONTEXT_IDENTITY_PHYSICAL_OFFSET_HI32
#define GCVM_L2_CONTEXT_IDENTITY_PHYSICAL_OFFSET_HI32__PHYSICAL_PAGE_OFFSET_HI4__SHIFT                        0x0
#define GCVM_L2_CONTEXT_IDENTITY_PHYSICAL_OFFSET_HI32__PHYSICAL_PAGE_OFFSET_HI4_MASK                          0x0000000FL
//GCVM_L2_CNTL4
#define GCVM_L2_CNTL4__L2_CACHE_4K_PARTITION_COUNT__SHIFT                                                     0x0
#define GCVM_L2_CNTL4__VMC_TAP_PDE_REQUEST_PHYSICAL__SHIFT                                                    0x6
#define GCVM_L2_CNTL4__VMC_TAP_PTE_REQUEST_PHYSICAL__SHIFT                                                    0x7
#define GCVM_L2_CNTL4__MM_NONRT_IFIFO_ACTIVE_TRANSACTION_LIMIT__SHIFT                                         0x8
#define GCVM_L2_CNTL4__MM_SOFTRT_IFIFO_ACTIVE_TRANSACTION_LIMIT__SHIFT                                        0x12
#define GCVM_L2_CNTL4__BPM_CGCGLS_OVERRIDE__SHIFT                                                             0x1c
#define GCVM_L2_CNTL4__GC_CH_FGCG_OFF__SHIFT                                                                  0x1d
#define GCVM_L2_CNTL4__VFIFO_HEAD_OF_QUEUE__SHIFT                                                             0x1e
#define GCVM_L2_CNTL4__VFIFO_VISIBLE_BANK_SILOS__SHIFT                                                        0x1f
#define GCVM_L2_CNTL4__L2_CACHE_4K_PARTITION_COUNT_MASK                                                       0x0000003FL
#define GCVM_L2_CNTL4__VMC_TAP_PDE_REQUEST_PHYSICAL_MASK                                                      0x00000040L
#define GCVM_L2_CNTL4__VMC_TAP_PTE_REQUEST_PHYSICAL_MASK                                                      0x00000080L
#define GCVM_L2_CNTL4__MM_NONRT_IFIFO_ACTIVE_TRANSACTION_LIMIT_MASK                                           0x0003FF00L
#define GCVM_L2_CNTL4__MM_SOFTRT_IFIFO_ACTIVE_TRANSACTION_LIMIT_MASK                                          0x0FFC0000L
#define GCVM_L2_CNTL4__BPM_CGCGLS_OVERRIDE_MASK                                                               0x10000000L
#define GCVM_L2_CNTL4__GC_CH_FGCG_OFF_MASK                                                                    0x20000000L
#define GCVM_L2_CNTL4__VFIFO_HEAD_OF_QUEUE_MASK                                                               0x40000000L
#define GCVM_L2_CNTL4__VFIFO_VISIBLE_BANK_SILOS_MASK                                                          0x80000000L
//GCVM_L2_MM_GROUP_RT_CLASSES
#define GCVM_L2_MM_GROUP_RT_CLASSES__GROUP_0_RT_CLASS__SHIFT                                                  0x0
#define GCVM_L2_MM_GROUP_RT_CLASSES__GROUP_1_RT_CLASS__SHIFT                                                  0x1
#define GCVM_L2_MM_GROUP_RT_CLASSES__GROUP_2_RT_CLASS__SHIFT                                                  0x2
#define GCVM_L2_MM_GROUP_RT_CLASSES__GROUP_3_RT_CLASS__SHIFT                                                  0x3
#define GCVM_L2_MM_GROUP_RT_CLASSES__GROUP_4_RT_CLASS__SHIFT                                                  0x4
#define GCVM_L2_MM_GROUP_RT_CLASSES__GROUP_5_RT_CLASS__SHIFT                                                  0x5
#define GCVM_L2_MM_GROUP_RT_CLASSES__GROUP_6_RT_CLASS__SHIFT                                                  0x6
#define GCVM_L2_MM_GROUP_RT_CLASSES__GROUP_7_RT_CLASS__SHIFT                                                  0x7
#define GCVM_L2_MM_GROUP_RT_CLASSES__GROUP_8_RT_CLASS__SHIFT                                                  0x8
#define GCVM_L2_MM_GROUP_RT_CLASSES__GROUP_9_RT_CLASS__SHIFT                                                  0x9
#define GCVM_L2_MM_GROUP_RT_CLASSES__GROUP_10_RT_CLASS__SHIFT                                                 0xa
#define GCVM_L2_MM_GROUP_RT_CLASSES__GROUP_11_RT_CLASS__SHIFT                                                 0xb
#define GCVM_L2_MM_GROUP_RT_CLASSES__GROUP_12_RT_CLASS__SHIFT                                                 0xc
#define GCVM_L2_MM_GROUP_RT_CLASSES__GROUP_13_RT_CLASS__SHIFT                                                 0xd
#define GCVM_L2_MM_GROUP_RT_CLASSES__GROUP_14_RT_CLASS__SHIFT                                                 0xe
#define GCVM_L2_MM_GROUP_RT_CLASSES__GROUP_15_RT_CLASS__SHIFT                                                 0xf
#define GCVM_L2_MM_GROUP_RT_CLASSES__GROUP_16_RT_CLASS__SHIFT                                                 0x10
#define GCVM_L2_MM_GROUP_RT_CLASSES__GROUP_17_RT_CLASS__SHIFT                                                 0x11
#define GCVM_L2_MM_GROUP_RT_CLASSES__GROUP_18_RT_CLASS__SHIFT                                                 0x12
#define GCVM_L2_MM_GROUP_RT_CLASSES__GROUP_19_RT_CLASS__SHIFT                                                 0x13
#define GCVM_L2_MM_GROUP_RT_CLASSES__GROUP_20_RT_CLASS__SHIFT                                                 0x14
#define GCVM_L2_MM_GROUP_RT_CLASSES__GROUP_21_RT_CLASS__SHIFT                                                 0x15
#define GCVM_L2_MM_GROUP_RT_CLASSES__GROUP_22_RT_CLASS__SHIFT                                                 0x16
#define GCVM_L2_MM_GROUP_RT_CLASSES__GROUP_23_RT_CLASS__SHIFT                                                 0x17
#define GCVM_L2_MM_GROUP_RT_CLASSES__GROUP_24_RT_CLASS__SHIFT                                                 0x18
#define GCVM_L2_MM_GROUP_RT_CLASSES__GROUP_25_RT_CLASS__SHIFT                                                 0x19
#define GCVM_L2_MM_GROUP_RT_CLASSES__GROUP_26_RT_CLASS__SHIFT                                                 0x1a
#define GCVM_L2_MM_GROUP_RT_CLASSES__GROUP_27_RT_CLASS__SHIFT                                                 0x1b
#define GCVM_L2_MM_GROUP_RT_CLASSES__GROUP_28_RT_CLASS__SHIFT                                                 0x1c
#define GCVM_L2_MM_GROUP_RT_CLASSES__GROUP_29_RT_CLASS__SHIFT                                                 0x1d
#define GCVM_L2_MM_GROUP_RT_CLASSES__GROUP_30_RT_CLASS__SHIFT                                                 0x1e
#define GCVM_L2_MM_GROUP_RT_CLASSES__GROUP_31_RT_CLASS__SHIFT                                                 0x1f
#define GCVM_L2_MM_GROUP_RT_CLASSES__GROUP_0_RT_CLASS_MASK                                                    0x00000001L
#define GCVM_L2_MM_GROUP_RT_CLASSES__GROUP_1_RT_CLASS_MASK                                                    0x00000002L
#define GCVM_L2_MM_GROUP_RT_CLASSES__GROUP_2_RT_CLASS_MASK                                                    0x00000004L
#define GCVM_L2_MM_GROUP_RT_CLASSES__GROUP_3_RT_CLASS_MASK                                                    0x00000008L
#define GCVM_L2_MM_GROUP_RT_CLASSES__GROUP_4_RT_CLASS_MASK                                                    0x00000010L
#define GCVM_L2_MM_GROUP_RT_CLASSES__GROUP_5_RT_CLASS_MASK                                                    0x00000020L
#define GCVM_L2_MM_GROUP_RT_CLASSES__GROUP_6_RT_CLASS_MASK                                                    0x00000040L
#define GCVM_L2_MM_GROUP_RT_CLASSES__GROUP_7_RT_CLASS_MASK                                                    0x00000080L
#define GCVM_L2_MM_GROUP_RT_CLASSES__GROUP_8_RT_CLASS_MASK                                                    0x00000100L
#define GCVM_L2_MM_GROUP_RT_CLASSES__GROUP_9_RT_CLASS_MASK                                                    0x00000200L
#define GCVM_L2_MM_GROUP_RT_CLASSES__GROUP_10_RT_CLASS_MASK                                                   0x00000400L
#define GCVM_L2_MM_GROUP_RT_CLASSES__GROUP_11_RT_CLASS_MASK                                                   0x00000800L
#define GCVM_L2_MM_GROUP_RT_CLASSES__GROUP_12_RT_CLASS_MASK                                                   0x00001000L
#define GCVM_L2_MM_GROUP_RT_CLASSES__GROUP_13_RT_CLASS_MASK                                                   0x00002000L
#define GCVM_L2_MM_GROUP_RT_CLASSES__GROUP_14_RT_CLASS_MASK                                                   0x00004000L
#define GCVM_L2_MM_GROUP_RT_CLASSES__GROUP_15_RT_CLASS_MASK                                                   0x00008000L
#define GCVM_L2_MM_GROUP_RT_CLASSES__GROUP_16_RT_CLASS_MASK                                                   0x00010000L
#define GCVM_L2_MM_GROUP_RT_CLASSES__GROUP_17_RT_CLASS_MASK                                                   0x00020000L
#define GCVM_L2_MM_GROUP_RT_CLASSES__GROUP_18_RT_CLASS_MASK                                                   0x00040000L
#define GCVM_L2_MM_GROUP_RT_CLASSES__GROUP_19_RT_CLASS_MASK                                                   0x00080000L
#define GCVM_L2_MM_GROUP_RT_CLASSES__GROUP_20_RT_CLASS_MASK                                                   0x00100000L
#define GCVM_L2_MM_GROUP_RT_CLASSES__GROUP_21_RT_CLASS_MASK                                                   0x00200000L
#define GCVM_L2_MM_GROUP_RT_CLASSES__GROUP_22_RT_CLASS_MASK                                                   0x00400000L
#define GCVM_L2_MM_GROUP_RT_CLASSES__GROUP_23_RT_CLASS_MASK                                                   0x00800000L
#define GCVM_L2_MM_GROUP_RT_CLASSES__GROUP_24_RT_CLASS_MASK                                                   0x01000000L
#define GCVM_L2_MM_GROUP_RT_CLASSES__GROUP_25_RT_CLASS_MASK                                                   0x02000000L
#define GCVM_L2_MM_GROUP_RT_CLASSES__GROUP_26_RT_CLASS_MASK                                                   0x04000000L
#define GCVM_L2_MM_GROUP_RT_CLASSES__GROUP_27_RT_CLASS_MASK                                                   0x08000000L
#define GCVM_L2_MM_GROUP_RT_CLASSES__GROUP_28_RT_CLASS_MASK                                                   0x10000000L
#define GCVM_L2_MM_GROUP_RT_CLASSES__GROUP_29_RT_CLASS_MASK                                                   0x20000000L
#define GCVM_L2_MM_GROUP_RT_CLASSES__GROUP_30_RT_CLASS_MASK                                                   0x40000000L
#define GCVM_L2_MM_GROUP_RT_CLASSES__GROUP_31_RT_CLASS_MASK                                                   0x80000000L
//GCVM_L2_BANK_SELECT_RESERVED_CID
#define GCVM_L2_BANK_SELECT_RESERVED_CID__RESERVED_READ_CLIENT_ID__SHIFT                                      0x0
#define GCVM_L2_BANK_SELECT_RESERVED_CID__RESERVED_WRITE_CLIENT_ID__SHIFT                                     0xa
#define GCVM_L2_BANK_SELECT_RESERVED_CID__ENABLE__SHIFT                                                       0x14
#define GCVM_L2_BANK_SELECT_RESERVED_CID__RESERVED_CACHE_INVALIDATION_MODE__SHIFT                             0x18
#define GCVM_L2_BANK_SELECT_RESERVED_CID__RESERVED_CACHE_PRIVATE_INVALIDATION__SHIFT                          0x19
#define GCVM_L2_BANK_SELECT_RESERVED_CID__RESERVED_CACHE_FRAGMENT_SIZE__SHIFT                                 0x1a
#define GCVM_L2_BANK_SELECT_RESERVED_CID__RESERVED_READ_CLIENT_ID_MASK                                        0x000001FFL
#define GCVM_L2_BANK_SELECT_RESERVED_CID__RESERVED_WRITE_CLIENT_ID_MASK                                       0x0007FC00L
#define GCVM_L2_BANK_SELECT_RESERVED_CID__ENABLE_MASK                                                         0x00100000L
#define GCVM_L2_BANK_SELECT_RESERVED_CID__RESERVED_CACHE_INVALIDATION_MODE_MASK                               0x01000000L
#define GCVM_L2_BANK_SELECT_RESERVED_CID__RESERVED_CACHE_PRIVATE_INVALIDATION_MASK                            0x02000000L
#define GCVM_L2_BANK_SELECT_RESERVED_CID__RESERVED_CACHE_FRAGMENT_SIZE_MASK                                   0x7C000000L
//GCVM_L2_BANK_SELECT_RESERVED_CID2
#define GCVM_L2_BANK_SELECT_RESERVED_CID2__RESERVED_READ_CLIENT_ID__SHIFT                                     0x0
#define GCVM_L2_BANK_SELECT_RESERVED_CID2__RESERVED_WRITE_CLIENT_ID__SHIFT                                    0xa
#define GCVM_L2_BANK_SELECT_RESERVED_CID2__ENABLE__SHIFT                                                      0x14
#define GCVM_L2_BANK_SELECT_RESERVED_CID2__RESERVED_CACHE_INVALIDATION_MODE__SHIFT                            0x18
#define GCVM_L2_BANK_SELECT_RESERVED_CID2__RESERVED_CACHE_PRIVATE_INVALIDATION__SHIFT                         0x19
#define GCVM_L2_BANK_SELECT_RESERVED_CID2__RESERVED_CACHE_FRAGMENT_SIZE__SHIFT                                0x1a
#define GCVM_L2_BANK_SELECT_RESERVED_CID2__RESERVED_READ_CLIENT_ID_MASK                                       0x000001FFL
#define GCVM_L2_BANK_SELECT_RESERVED_CID2__RESERVED_WRITE_CLIENT_ID_MASK                                      0x0007FC00L
#define GCVM_L2_BANK_SELECT_RESERVED_CID2__ENABLE_MASK                                                        0x00100000L
#define GCVM_L2_BANK_SELECT_RESERVED_CID2__RESERVED_CACHE_INVALIDATION_MODE_MASK                              0x01000000L
#define GCVM_L2_BANK_SELECT_RESERVED_CID2__RESERVED_CACHE_PRIVATE_INVALIDATION_MASK                           0x02000000L
#define GCVM_L2_BANK_SELECT_RESERVED_CID2__RESERVED_CACHE_FRAGMENT_SIZE_MASK                                  0x7C000000L
//GCVM_L2_CACHE_PARITY_CNTL
#define GCVM_L2_CACHE_PARITY_CNTL__ENABLE_PARITY_CHECKS_IN_4K_PTE_CACHES__SHIFT                               0x0
#define GCVM_L2_CACHE_PARITY_CNTL__ENABLE_PARITY_CHECKS_IN_BIGK_PTE_CACHES__SHIFT                             0x1
#define GCVM_L2_CACHE_PARITY_CNTL__ENABLE_PARITY_CHECKS_IN_PDE_CACHES__SHIFT                                  0x2
#define GCVM_L2_CACHE_PARITY_CNTL__FORCE_PARITY_MISMATCH_IN_4K_PTE_CACHE__SHIFT                               0x3
#define GCVM_L2_CACHE_PARITY_CNTL__FORCE_PARITY_MISMATCH_IN_BIGK_PTE_CACHE__SHIFT                             0x4
#define GCVM_L2_CACHE_PARITY_CNTL__FORCE_PARITY_MISMATCH_IN_PDE_CACHE__SHIFT                                  0x5
#define GCVM_L2_CACHE_PARITY_CNTL__FORCE_CACHE_BANK__SHIFT                                                    0x6
#define GCVM_L2_CACHE_PARITY_CNTL__FORCE_CACHE_NUMBER__SHIFT                                                  0x9
#define GCVM_L2_CACHE_PARITY_CNTL__FORCE_CACHE_ASSOC__SHIFT                                                   0xc
#define GCVM_L2_CACHE_PARITY_CNTL__ENABLE_PARITY_CHECKS_IN_4K_PTE_CACHES_MASK                                 0x00000001L
#define GCVM_L2_CACHE_PARITY_CNTL__ENABLE_PARITY_CHECKS_IN_BIGK_PTE_CACHES_MASK                               0x00000002L
#define GCVM_L2_CACHE_PARITY_CNTL__ENABLE_PARITY_CHECKS_IN_PDE_CACHES_MASK                                    0x00000004L
#define GCVM_L2_CACHE_PARITY_CNTL__FORCE_PARITY_MISMATCH_IN_4K_PTE_CACHE_MASK                                 0x00000008L
#define GCVM_L2_CACHE_PARITY_CNTL__FORCE_PARITY_MISMATCH_IN_BIGK_PTE_CACHE_MASK                               0x00000010L
#define GCVM_L2_CACHE_PARITY_CNTL__FORCE_PARITY_MISMATCH_IN_PDE_CACHE_MASK                                    0x00000020L
#define GCVM_L2_CACHE_PARITY_CNTL__FORCE_CACHE_BANK_MASK                                                      0x000001C0L
#define GCVM_L2_CACHE_PARITY_CNTL__FORCE_CACHE_NUMBER_MASK                                                    0x00000E00L
#define GCVM_L2_CACHE_PARITY_CNTL__FORCE_CACHE_ASSOC_MASK                                                     0x0000F000L
//GCVM_L2_ICG_CTRL
#define GCVM_L2_ICG_CTRL__OFF_HYSTERESIS__SHIFT                                                               0x0
#define GCVM_L2_ICG_CTRL__DYNAMIC_CLOCK_OVERRIDE__SHIFT                                                       0x4
#define GCVM_L2_ICG_CTRL__STATIC_CLOCK_OVERRIDE__SHIFT                                                        0x5
#define GCVM_L2_ICG_CTRL__AON_CLOCK_OVERRIDE__SHIFT                                                           0x6
#define GCVM_L2_ICG_CTRL__PERFMON_CLOCK_OVERRIDE__SHIFT                                                       0x7
#define GCVM_L2_ICG_CTRL__OFF_HYSTERESIS_MASK                                                                 0x0000000FL
#define GCVM_L2_ICG_CTRL__DYNAMIC_CLOCK_OVERRIDE_MASK                                                         0x00000010L
#define GCVM_L2_ICG_CTRL__STATIC_CLOCK_OVERRIDE_MASK                                                          0x00000020L
#define GCVM_L2_ICG_CTRL__AON_CLOCK_OVERRIDE_MASK                                                             0x00000040L
#define GCVM_L2_ICG_CTRL__PERFMON_CLOCK_OVERRIDE_MASK                                                         0x00000080L
//GCVM_L2_CNTL5
#define GCVM_L2_CNTL5__L2_CACHE_SMALLK_FRAGMENT_SIZE__SHIFT                                                   0x0
#define GCVM_L2_CNTL5__WALKER_PRIORITY_CLIENT_ID__SHIFT                                                       0x5
#define GCVM_L2_CNTL5__WALKER_FETCH_PDE_NOALLOC_ENABLE__SHIFT                                                 0xe
#define GCVM_L2_CNTL5__WALKER_FETCH_PDE_MTYPE_ENABLE__SHIFT                                                   0xf
#define GCVM_L2_CNTL5__UTCL2_ATC_REQ_FGCG_OFF__SHIFT                                                          0x10
#define GCVM_L2_CNTL5__UTCL2_ATC_INVREQ_REPEATER_FGCG_OFF__SHIFT                                              0x11
#define GCVM_L2_CNTL5__UTCL2_ONE_OUTSTANDING_ATC_INVREQ__SHIFT                                                0x12
#define GCVM_L2_CNTL5__L2_CACHE_SMALLK_FRAGMENT_SIZE_MASK                                                     0x0000001FL
#define GCVM_L2_CNTL5__WALKER_PRIORITY_CLIENT_ID_MASK                                                         0x00003FE0L
#define GCVM_L2_CNTL5__WALKER_FETCH_PDE_NOALLOC_ENABLE_MASK                                                   0x00004000L
#define GCVM_L2_CNTL5__WALKER_FETCH_PDE_MTYPE_ENABLE_MASK                                                     0x00008000L
#define GCVM_L2_CNTL5__UTCL2_ATC_REQ_FGCG_OFF_MASK                                                            0x00010000L
#define GCVM_L2_CNTL5__UTCL2_ATC_INVREQ_REPEATER_FGCG_OFF_MASK                                                0x00020000L
#define GCVM_L2_CNTL5__UTCL2_ONE_OUTSTANDING_ATC_INVREQ_MASK                                                  0x00040000L
//GCVM_L2_GCR_CNTL
#define GCVM_L2_GCR_CNTL__GCR_ENABLE__SHIFT                                                                   0x0
#define GCVM_L2_GCR_CNTL__GCR_CLIENT_ID__SHIFT                                                                0x1
#define GCVM_L2_GCR_CNTL__GCR_ENABLE_MASK                                                                     0x00000001L
#define GCVM_L2_GCR_CNTL__GCR_CLIENT_ID_MASK                                                                  0x000003FEL
//GCVML2_WALKER_MACRO_THROTTLE_TIME
#define GCVML2_WALKER_MACRO_THROTTLE_TIME__TIME__SHIFT                                                        0x0
#define GCVML2_WALKER_MACRO_THROTTLE_TIME__TIME_MASK                                                          0x00FFFFFFL
//GCVML2_WALKER_MACRO_THROTTLE_FETCH_LIMIT
#define GCVML2_WALKER_MACRO_THROTTLE_FETCH_LIMIT__LIMIT__SHIFT                                                0x1
#define GCVML2_WALKER_MACRO_THROTTLE_FETCH_LIMIT__LIMIT_MASK                                                  0x0000FFFEL
//GCVML2_WALKER_MICRO_THROTTLE_TIME
#define GCVML2_WALKER_MICRO_THROTTLE_TIME__TIME__SHIFT                                                        0x0
#define GCVML2_WALKER_MICRO_THROTTLE_TIME__TIME_MASK                                                          0x00FFFFFFL
//GCVML2_WALKER_MICRO_THROTTLE_FETCH_LIMIT
#define GCVML2_WALKER_MICRO_THROTTLE_FETCH_LIMIT__LIMIT__SHIFT                                                0x1
#define GCVML2_WALKER_MICRO_THROTTLE_FETCH_LIMIT__LIMIT_MASK                                                  0x0000FFFEL
//GCVM_L2_CGTT_BUSY_CTRL
#define GCVM_L2_CGTT_BUSY_CTRL__READ_DELAY__SHIFT                                                             0x0
#define GCVM_L2_CGTT_BUSY_CTRL__ALWAYS_BUSY__SHIFT                                                            0x5
#define GCVM_L2_CGTT_BUSY_CTRL__READ_DELAY_MASK                                                               0x0000001FL
#define GCVM_L2_CGTT_BUSY_CTRL__ALWAYS_BUSY_MASK                                                              0x00000020L
//GCVM_L2_PTE_CACHE_DUMP_CNTL
#define GCVM_L2_PTE_CACHE_DUMP_CNTL__ENABLE__SHIFT                                                            0x0
#define GCVM_L2_PTE_CACHE_DUMP_CNTL__READY__SHIFT                                                             0x1
#define GCVM_L2_PTE_CACHE_DUMP_CNTL__BANK__SHIFT                                                              0x4
#define GCVM_L2_PTE_CACHE_DUMP_CNTL__CACHE__SHIFT                                                             0x8
#define GCVM_L2_PTE_CACHE_DUMP_CNTL__ASSOC__SHIFT                                                             0xc
#define GCVM_L2_PTE_CACHE_DUMP_CNTL__INDEX__SHIFT                                                             0x10
#define GCVM_L2_PTE_CACHE_DUMP_CNTL__ENABLE_MASK                                                              0x00000001L
#define GCVM_L2_PTE_CACHE_DUMP_CNTL__READY_MASK                                                               0x00000002L
#define GCVM_L2_PTE_CACHE_DUMP_CNTL__BANK_MASK                                                                0x000000F0L
#define GCVM_L2_PTE_CACHE_DUMP_CNTL__CACHE_MASK                                                               0x00000F00L
#define GCVM_L2_PTE_CACHE_DUMP_CNTL__ASSOC_MASK                                                               0x0000F000L
#define GCVM_L2_PTE_CACHE_DUMP_CNTL__INDEX_MASK                                                               0xFFFF0000L
//GCVM_L2_PTE_CACHE_DUMP_READ
#define GCVM_L2_PTE_CACHE_DUMP_READ__DATA__SHIFT                                                              0x0
#define GCVM_L2_PTE_CACHE_DUMP_READ__DATA_MASK                                                                0xFFFFFFFFL
//GCUTC_GPUVA_VMID_TRANSLATION_ASSIST_REQUEST_ADDR_LO32
#define GCUTC_GPUVA_VMID_TRANSLATION_ASSIST_REQUEST_ADDR_LO32__ADDR_LO32__SHIFT                               0x0
#define GCUTC_GPUVA_VMID_TRANSLATION_ASSIST_REQUEST_ADDR_LO32__ADDR_LO32_MASK                                 0xFFFFFFFFL
//GCUTC_GPUVA_VMID_TRANSLATION_ASSIST_REQUEST_ADDR_HI32
#define GCUTC_GPUVA_VMID_TRANSLATION_ASSIST_REQUEST_ADDR_HI32__ADDR_HI4__SHIFT                                0x0
#define GCUTC_GPUVA_VMID_TRANSLATION_ASSIST_REQUEST_ADDR_HI32__ADDR_HI4_MASK                                  0x0000000FL
//GCUTC_GPUVA_VMID_TRANSLATION_ASSIST_REQUEST_ATTR
#define GCUTC_GPUVA_VMID_TRANSLATION_ASSIST_REQUEST_ATTR__VMID__SHIFT                                         0x0
#define GCUTC_GPUVA_VMID_TRANSLATION_ASSIST_REQUEST_ATTR__VFID__SHIFT                                         0x4
#define GCUTC_GPUVA_VMID_TRANSLATION_ASSIST_REQUEST_ATTR__VF__SHIFT                                           0x9
#define GCUTC_GPUVA_VMID_TRANSLATION_ASSIST_REQUEST_ATTR__GPA__SHIFT                                          0xa
#define GCUTC_GPUVA_VMID_TRANSLATION_ASSIST_REQUEST_ATTR__RD_PERM__SHIFT                                      0xc
#define GCUTC_GPUVA_VMID_TRANSLATION_ASSIST_REQUEST_ATTR__WR_PERM__SHIFT                                      0xd
#define GCUTC_GPUVA_VMID_TRANSLATION_ASSIST_REQUEST_ATTR__EX_PERM__SHIFT                                      0xe
#define GCUTC_GPUVA_VMID_TRANSLATION_ASSIST_REQUEST_ATTR__CLIENT_ID__SHIFT                                    0xf
#define GCUTC_GPUVA_VMID_TRANSLATION_ASSIST_REQUEST_ATTR__REQ__SHIFT                                          0x1f
#define GCUTC_GPUVA_VMID_TRANSLATION_ASSIST_REQUEST_ATTR__VMID_MASK                                           0x0000000FL
#define GCUTC_GPUVA_VMID_TRANSLATION_ASSIST_REQUEST_ATTR__VFID_MASK                                           0x000001F0L
#define GCUTC_GPUVA_VMID_TRANSLATION_ASSIST_REQUEST_ATTR__VF_MASK                                             0x00000200L
#define GCUTC_GPUVA_VMID_TRANSLATION_ASSIST_REQUEST_ATTR__GPA_MASK                                            0x00000C00L
#define GCUTC_GPUVA_VMID_TRANSLATION_ASSIST_REQUEST_ATTR__RD_PERM_MASK                                        0x00001000L
#define GCUTC_GPUVA_VMID_TRANSLATION_ASSIST_REQUEST_ATTR__WR_PERM_MASK                                        0x00002000L
#define GCUTC_GPUVA_VMID_TRANSLATION_ASSIST_REQUEST_ATTR__EX_PERM_MASK                                        0x00004000L
#define GCUTC_GPUVA_VMID_TRANSLATION_ASSIST_REQUEST_ATTR__CLIENT_ID_MASK                                      0x00FF8000L
#define GCUTC_GPUVA_VMID_TRANSLATION_ASSIST_REQUEST_ATTR__REQ_MASK                                            0x80000000L
//GCUTC_GPUVA_VMID_TRANSLATION_ASSIST_RESPONSE_ADDR_LO32
#define GCUTC_GPUVA_VMID_TRANSLATION_ASSIST_RESPONSE_ADDR_LO32__ADDR_LO32__SHIFT                              0x0
#define GCUTC_GPUVA_VMID_TRANSLATION_ASSIST_RESPONSE_ADDR_LO32__ADDR_LO32_MASK                                0xFFFFFFFFL
//GCUTC_GPUVA_VMID_TRANSLATION_ASSIST_RESPONSE_ADDR_HI32
#define GCUTC_GPUVA_VMID_TRANSLATION_ASSIST_RESPONSE_ADDR_HI32__ADDR_HI4__SHIFT                               0x0
#define GCUTC_GPUVA_VMID_TRANSLATION_ASSIST_RESPONSE_ADDR_HI32__ADDR_HI4_MASK                                 0x0000000FL
//GCUTC_GPUVA_VMID_TRANSLATION_ASSIST_RESPONSE_ATTR
#define GCUTC_GPUVA_VMID_TRANSLATION_ASSIST_RESPONSE_ATTR__PERMS__SHIFT                                       0x0
#define GCUTC_GPUVA_VMID_TRANSLATION_ASSIST_RESPONSE_ATTR__FRAGMENT_SIZE__SHIFT                               0x3
#define GCUTC_GPUVA_VMID_TRANSLATION_ASSIST_RESPONSE_ATTR__SNOOP__SHIFT                                       0x9
#define GCUTC_GPUVA_VMID_TRANSLATION_ASSIST_RESPONSE_ATTR__SPA__SHIFT                                         0xa
#define GCUTC_GPUVA_VMID_TRANSLATION_ASSIST_RESPONSE_ATTR__IO__SHIFT                                          0xb
#define GCUTC_GPUVA_VMID_TRANSLATION_ASSIST_RESPONSE_ATTR__PTE_TMZ__SHIFT                                     0xc
#define GCUTC_GPUVA_VMID_TRANSLATION_ASSIST_RESPONSE_ATTR__NO_PTE__SHIFT                                      0xd
#define GCUTC_GPUVA_VMID_TRANSLATION_ASSIST_RESPONSE_ATTR__MTYPE__SHIFT                                       0xe
#define GCUTC_GPUVA_VMID_TRANSLATION_ASSIST_RESPONSE_ATTR__COMP_EN__SHIFT                                     0x10
#define GCUTC_GPUVA_VMID_TRANSLATION_ASSIST_RESPONSE_ATTR__NACK__SHIFT                                        0x11
#define GCUTC_GPUVA_VMID_TRANSLATION_ASSIST_RESPONSE_ATTR__ACK__SHIFT                                         0x1f
#define GCUTC_GPUVA_VMID_TRANSLATION_ASSIST_RESPONSE_ATTR__PERMS_MASK                                         0x00000007L
#define GCUTC_GPUVA_VMID_TRANSLATION_ASSIST_RESPONSE_ATTR__FRAGMENT_SIZE_MASK                                 0x000001F8L
#define GCUTC_GPUVA_VMID_TRANSLATION_ASSIST_RESPONSE_ATTR__SNOOP_MASK                                         0x00000200L
#define GCUTC_GPUVA_VMID_TRANSLATION_ASSIST_RESPONSE_ATTR__SPA_MASK                                           0x00000400L
#define GCUTC_GPUVA_VMID_TRANSLATION_ASSIST_RESPONSE_ATTR__IO_MASK                                            0x00000800L
#define GCUTC_GPUVA_VMID_TRANSLATION_ASSIST_RESPONSE_ATTR__PTE_TMZ_MASK                                       0x00001000L
#define GCUTC_GPUVA_VMID_TRANSLATION_ASSIST_RESPONSE_ATTR__NO_PTE_MASK                                        0x00002000L
#define GCUTC_GPUVA_VMID_TRANSLATION_ASSIST_RESPONSE_ATTR__MTYPE_MASK                                         0x0000C000L
#define GCUTC_GPUVA_VMID_TRANSLATION_ASSIST_RESPONSE_ATTR__COMP_EN_MASK                                       0x00010000L
#define GCUTC_GPUVA_VMID_TRANSLATION_ASSIST_RESPONSE_ATTR__NACK_MASK                                          0x00060000L
#define GCUTC_GPUVA_VMID_TRANSLATION_ASSIST_RESPONSE_ATTR__ACK_MASK                                           0x80000000L
//GCVM_L2_BANK_SELECT_MASKS
#define GCVM_L2_BANK_SELECT_MASKS__MASK0__SHIFT                                                               0x0
#define GCVM_L2_BANK_SELECT_MASKS__MASK1__SHIFT                                                               0x4
#define GCVM_L2_BANK_SELECT_MASKS__MASK2__SHIFT                                                               0x8
#define GCVM_L2_BANK_SELECT_MASKS__MASK3__SHIFT                                                               0xc
#define GCVM_L2_BANK_SELECT_MASKS__MASK0_MASK                                                                 0x0000000FL
#define GCVM_L2_BANK_SELECT_MASKS__MASK1_MASK                                                                 0x000000F0L
#define GCVM_L2_BANK_SELECT_MASKS__MASK2_MASK                                                                 0x00000F00L
#define GCVM_L2_BANK_SELECT_MASKS__MASK3_MASK                                                                 0x0000F000L
//GCUTCL2_CREDIT_SAFETY_GROUP_RET_CDC
#define GCUTCL2_CREDIT_SAFETY_GROUP_RET_CDC__CREDITS__SHIFT                                                   0x0
#define GCUTCL2_CREDIT_SAFETY_GROUP_RET_CDC__UPDATE__SHIFT                                                    0xa
#define GCUTCL2_CREDIT_SAFETY_GROUP_RET_CDC__CREDITS_MASK                                                     0x000003FFL
#define GCUTCL2_CREDIT_SAFETY_GROUP_RET_CDC__UPDATE_MASK                                                      0x00000400L
//GCUTCL2_CREDIT_SAFETY_GROUP_CLIENTS_INVREQ_CDC
#define GCUTCL2_CREDIT_SAFETY_GROUP_CLIENTS_INVREQ_CDC__CREDITS__SHIFT                                        0x0
#define GCUTCL2_CREDIT_SAFETY_GROUP_CLIENTS_INVREQ_CDC__UPDATE__SHIFT                                         0xa
#define GCUTCL2_CREDIT_SAFETY_GROUP_CLIENTS_INVREQ_CDC__CREDITS_MASK                                          0x000003FFL
#define GCUTCL2_CREDIT_SAFETY_GROUP_CLIENTS_INVREQ_CDC__UPDATE_MASK                                           0x00000400L
//GCUTCL2_CREDIT_SAFETY_GROUP_CLIENTS_INVREQ_NOCDC
#define GCUTCL2_CREDIT_SAFETY_GROUP_CLIENTS_INVREQ_NOCDC__CREDITS__SHIFT                                      0x0
#define GCUTCL2_CREDIT_SAFETY_GROUP_CLIENTS_INVREQ_NOCDC__UPDATE__SHIFT                                       0xa
#define GCUTCL2_CREDIT_SAFETY_GROUP_CLIENTS_INVREQ_NOCDC__CREDITS_MASK                                        0x000003FFL
#define GCUTCL2_CREDIT_SAFETY_GROUP_CLIENTS_INVREQ_NOCDC__UPDATE_MASK                                         0x00000400L
//GCVML2_CREDIT_SAFETY_IH_FAULT_INTERRUPT
#define GCVML2_CREDIT_SAFETY_IH_FAULT_INTERRUPT__CREDITS__SHIFT                                               0x0
#define GCVML2_CREDIT_SAFETY_IH_FAULT_INTERRUPT__UPDATE__SHIFT                                                0xa
#define GCVML2_CREDIT_SAFETY_IH_FAULT_INTERRUPT__CREDITS_MASK                                                 0x000003FFL
#define GCVML2_CREDIT_SAFETY_IH_FAULT_INTERRUPT__UPDATE_MASK                                                  0x00000400L
//GCVML2_WALKER_CREDIT_SAFETY_FETCH_RDREQ
#define GCVML2_WALKER_CREDIT_SAFETY_FETCH_RDREQ__CREDITS__SHIFT                                               0x0
#define GCVML2_WALKER_CREDIT_SAFETY_FETCH_RDREQ__UPDATE__SHIFT                                                0xa
#define GCVML2_WALKER_CREDIT_SAFETY_FETCH_RDREQ__CREDITS_MASK                                                 0x000003FFL
#define GCVML2_WALKER_CREDIT_SAFETY_FETCH_RDREQ__UPDATE_MASK                                                  0x00000400L


// addressBlock: gc_gfx_cpwd_gcutcl2_gcvmsharedvcdec
//GCMC_VM_FB_LOCATION_BASE
#define GCMC_VM_FB_LOCATION_BASE__FB_BASE__SHIFT                                                              0x0
#define GCMC_VM_FB_LOCATION_BASE__FB_BASE_MASK                                                                0x00FFFFFFL
//GCMC_VM_FB_LOCATION_TOP
#define GCMC_VM_FB_LOCATION_TOP__FB_TOP__SHIFT                                                                0x0
#define GCMC_VM_FB_LOCATION_TOP__FB_TOP_MASK                                                                  0x00FFFFFFL
//GCMC_VM_AGP_TOP
#define GCMC_VM_AGP_TOP__AGP_TOP__SHIFT                                                                       0x0
#define GCMC_VM_AGP_TOP__AGP_TOP_MASK                                                                         0x00FFFFFFL
//GCMC_VM_AGP_BOT
#define GCMC_VM_AGP_BOT__AGP_BOT__SHIFT                                                                       0x0
#define GCMC_VM_AGP_BOT__AGP_BOT_MASK                                                                         0x00FFFFFFL
//GCMC_VM_AGP_BASE
#define GCMC_VM_AGP_BASE__AGP_BASE__SHIFT                                                                     0x0
#define GCMC_VM_AGP_BASE__AGP_BASE_MASK                                                                       0x00FFFFFFL
//GCMC_VM_SYSTEM_APERTURE_LOW_ADDR
#define GCMC_VM_SYSTEM_APERTURE_LOW_ADDR__LOGICAL_ADDR__SHIFT                                                 0x0
#define GCMC_VM_SYSTEM_APERTURE_LOW_ADDR__LOGICAL_ADDR_MASK                                                   0x3FFFFFFFL
//GCMC_VM_SYSTEM_APERTURE_HIGH_ADDR
#define GCMC_VM_SYSTEM_APERTURE_HIGH_ADDR__LOGICAL_ADDR__SHIFT                                                0x0
#define GCMC_VM_SYSTEM_APERTURE_HIGH_ADDR__LOGICAL_ADDR_MASK                                                  0x3FFFFFFFL
//GCMC_VM_MX_L1_TLB_CNTL
#define GCMC_VM_MX_L1_TLB_CNTL__ENABLE_L1_TLB__SHIFT                                                          0x0
#define GCMC_VM_MX_L1_TLB_CNTL__SYSTEM_ACCESS_MODE__SHIFT                                                     0x3
#define GCMC_VM_MX_L1_TLB_CNTL__SYSTEM_APERTURE_UNMAPPED_ACCESS__SHIFT                                        0x5
#define GCMC_VM_MX_L1_TLB_CNTL__ENABLE_ADVANCED_DRIVER_MODEL__SHIFT                                           0x6
#define GCMC_VM_MX_L1_TLB_CNTL__ECO_BITS__SHIFT                                                               0x7
#define GCMC_VM_MX_L1_TLB_CNTL__MTYPE__SHIFT                                                                  0xb
#define GCMC_VM_MX_L1_TLB_CNTL__ENABLE_L1_TLB_MASK                                                            0x00000001L
#define GCMC_VM_MX_L1_TLB_CNTL__SYSTEM_ACCESS_MODE_MASK                                                       0x00000018L
#define GCMC_VM_MX_L1_TLB_CNTL__SYSTEM_APERTURE_UNMAPPED_ACCESS_MASK                                          0x00000020L
#define GCMC_VM_MX_L1_TLB_CNTL__ENABLE_ADVANCED_DRIVER_MODEL_MASK                                             0x00000040L
#define GCMC_VM_MX_L1_TLB_CNTL__ECO_BITS_MASK                                                                 0x00000780L
#define GCMC_VM_MX_L1_TLB_CNTL__MTYPE_MASK                                                                    0x00001800L


// addressBlock: gc_gfx_cpwd_gcutcl2_gcvml2vcdec
//GCVM_CONTEXT0_CNTL
#define GCVM_CONTEXT0_CNTL__ENABLE_CONTEXT__SHIFT                                                             0x0
#define GCVM_CONTEXT0_CNTL__PAGE_TABLE_DEPTH__SHIFT                                                           0x1
#define GCVM_CONTEXT0_CNTL__PAGE_TABLE_BLOCK_SIZE__SHIFT                                                      0x4
#define GCVM_CONTEXT0_CNTL__RETRY_PERMISSION_OR_INVALID_PAGE_FAULT__SHIFT                                     0x8
#define GCVM_CONTEXT0_CNTL__RETRY_OTHER_FAULT__SHIFT                                                          0x9
#define GCVM_CONTEXT0_CNTL__RANGE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                    0xa
#define GCVM_CONTEXT0_CNTL__RANGE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                      0xb
#define GCVM_CONTEXT0_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                               0xc
#define GCVM_CONTEXT0_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                 0xd
#define GCVM_CONTEXT0_CNTL__PDE0_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                     0xe
#define GCVM_CONTEXT0_CNTL__PDE0_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                       0xf
#define GCVM_CONTEXT0_CNTL__VALID_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                    0x10
#define GCVM_CONTEXT0_CNTL__VALID_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                      0x11
#define GCVM_CONTEXT0_CNTL__READ_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                     0x12
#define GCVM_CONTEXT0_CNTL__READ_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                       0x13
#define GCVM_CONTEXT0_CNTL__WRITE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                    0x14
#define GCVM_CONTEXT0_CNTL__WRITE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                      0x15
#define GCVM_CONTEXT0_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                  0x16
#define GCVM_CONTEXT0_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                    0x17
#define GCVM_CONTEXT0_CNTL__ENABLE_CONTEXT_MASK                                                               0x00000001L
#define GCVM_CONTEXT0_CNTL__PAGE_TABLE_DEPTH_MASK                                                             0x00000006L
#define GCVM_CONTEXT0_CNTL__PAGE_TABLE_BLOCK_SIZE_MASK                                                        0x000000F0L
#define GCVM_CONTEXT0_CNTL__RETRY_PERMISSION_OR_INVALID_PAGE_FAULT_MASK                                       0x00000100L
#define GCVM_CONTEXT0_CNTL__RETRY_OTHER_FAULT_MASK                                                            0x00000200L
#define GCVM_CONTEXT0_CNTL__RANGE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                      0x00000400L
#define GCVM_CONTEXT0_CNTL__RANGE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                        0x00000800L
#define GCVM_CONTEXT0_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                 0x00001000L
#define GCVM_CONTEXT0_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                   0x00002000L
#define GCVM_CONTEXT0_CNTL__PDE0_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                       0x00004000L
#define GCVM_CONTEXT0_CNTL__PDE0_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                         0x00008000L
#define GCVM_CONTEXT0_CNTL__VALID_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                      0x00010000L
#define GCVM_CONTEXT0_CNTL__VALID_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                        0x00020000L
#define GCVM_CONTEXT0_CNTL__READ_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                       0x00040000L
#define GCVM_CONTEXT0_CNTL__READ_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                         0x00080000L
#define GCVM_CONTEXT0_CNTL__WRITE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                      0x00100000L
#define GCVM_CONTEXT0_CNTL__WRITE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                        0x00200000L
#define GCVM_CONTEXT0_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                    0x00400000L
#define GCVM_CONTEXT0_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                      0x00800000L
//GCVM_CONTEXT1_CNTL
#define GCVM_CONTEXT1_CNTL__ENABLE_CONTEXT__SHIFT                                                             0x0
#define GCVM_CONTEXT1_CNTL__PAGE_TABLE_DEPTH__SHIFT                                                           0x1
#define GCVM_CONTEXT1_CNTL__PAGE_TABLE_BLOCK_SIZE__SHIFT                                                      0x4
#define GCVM_CONTEXT1_CNTL__RETRY_PERMISSION_OR_INVALID_PAGE_FAULT__SHIFT                                     0x8
#define GCVM_CONTEXT1_CNTL__RETRY_OTHER_FAULT__SHIFT                                                          0x9
#define GCVM_CONTEXT1_CNTL__RANGE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                    0xa
#define GCVM_CONTEXT1_CNTL__RANGE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                      0xb
#define GCVM_CONTEXT1_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                               0xc
#define GCVM_CONTEXT1_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                 0xd
#define GCVM_CONTEXT1_CNTL__PDE0_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                     0xe
#define GCVM_CONTEXT1_CNTL__PDE0_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                       0xf
#define GCVM_CONTEXT1_CNTL__VALID_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                    0x10
#define GCVM_CONTEXT1_CNTL__VALID_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                      0x11
#define GCVM_CONTEXT1_CNTL__READ_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                     0x12
#define GCVM_CONTEXT1_CNTL__READ_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                       0x13
#define GCVM_CONTEXT1_CNTL__WRITE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                    0x14
#define GCVM_CONTEXT1_CNTL__WRITE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                      0x15
#define GCVM_CONTEXT1_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                  0x16
#define GCVM_CONTEXT1_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                    0x17
#define GCVM_CONTEXT1_CNTL__ENABLE_CONTEXT_MASK                                                               0x00000001L
#define GCVM_CONTEXT1_CNTL__PAGE_TABLE_DEPTH_MASK                                                             0x00000006L
#define GCVM_CONTEXT1_CNTL__PAGE_TABLE_BLOCK_SIZE_MASK                                                        0x000000F0L
#define GCVM_CONTEXT1_CNTL__RETRY_PERMISSION_OR_INVALID_PAGE_FAULT_MASK                                       0x00000100L
#define GCVM_CONTEXT1_CNTL__RETRY_OTHER_FAULT_MASK                                                            0x00000200L
#define GCVM_CONTEXT1_CNTL__RANGE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                      0x00000400L
#define GCVM_CONTEXT1_CNTL__RANGE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                        0x00000800L
#define GCVM_CONTEXT1_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                 0x00001000L
#define GCVM_CONTEXT1_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                   0x00002000L
#define GCVM_CONTEXT1_CNTL__PDE0_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                       0x00004000L
#define GCVM_CONTEXT1_CNTL__PDE0_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                         0x00008000L
#define GCVM_CONTEXT1_CNTL__VALID_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                      0x00010000L
#define GCVM_CONTEXT1_CNTL__VALID_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                        0x00020000L
#define GCVM_CONTEXT1_CNTL__READ_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                       0x00040000L
#define GCVM_CONTEXT1_CNTL__READ_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                         0x00080000L
#define GCVM_CONTEXT1_CNTL__WRITE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                      0x00100000L
#define GCVM_CONTEXT1_CNTL__WRITE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                        0x00200000L
#define GCVM_CONTEXT1_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                    0x00400000L
#define GCVM_CONTEXT1_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                      0x00800000L
//GCVM_CONTEXT2_CNTL
#define GCVM_CONTEXT2_CNTL__ENABLE_CONTEXT__SHIFT                                                             0x0
#define GCVM_CONTEXT2_CNTL__PAGE_TABLE_DEPTH__SHIFT                                                           0x1
#define GCVM_CONTEXT2_CNTL__PAGE_TABLE_BLOCK_SIZE__SHIFT                                                      0x4
#define GCVM_CONTEXT2_CNTL__RETRY_PERMISSION_OR_INVALID_PAGE_FAULT__SHIFT                                     0x8
#define GCVM_CONTEXT2_CNTL__RETRY_OTHER_FAULT__SHIFT                                                          0x9
#define GCVM_CONTEXT2_CNTL__RANGE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                    0xa
#define GCVM_CONTEXT2_CNTL__RANGE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                      0xb
#define GCVM_CONTEXT2_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                               0xc
#define GCVM_CONTEXT2_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                 0xd
#define GCVM_CONTEXT2_CNTL__PDE0_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                     0xe
#define GCVM_CONTEXT2_CNTL__PDE0_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                       0xf
#define GCVM_CONTEXT2_CNTL__VALID_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                    0x10
#define GCVM_CONTEXT2_CNTL__VALID_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                      0x11
#define GCVM_CONTEXT2_CNTL__READ_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                     0x12
#define GCVM_CONTEXT2_CNTL__READ_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                       0x13
#define GCVM_CONTEXT2_CNTL__WRITE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                    0x14
#define GCVM_CONTEXT2_CNTL__WRITE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                      0x15
#define GCVM_CONTEXT2_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                  0x16
#define GCVM_CONTEXT2_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                    0x17
#define GCVM_CONTEXT2_CNTL__ENABLE_CONTEXT_MASK                                                               0x00000001L
#define GCVM_CONTEXT2_CNTL__PAGE_TABLE_DEPTH_MASK                                                             0x00000006L
#define GCVM_CONTEXT2_CNTL__PAGE_TABLE_BLOCK_SIZE_MASK                                                        0x000000F0L
#define GCVM_CONTEXT2_CNTL__RETRY_PERMISSION_OR_INVALID_PAGE_FAULT_MASK                                       0x00000100L
#define GCVM_CONTEXT2_CNTL__RETRY_OTHER_FAULT_MASK                                                            0x00000200L
#define GCVM_CONTEXT2_CNTL__RANGE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                      0x00000400L
#define GCVM_CONTEXT2_CNTL__RANGE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                        0x00000800L
#define GCVM_CONTEXT2_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                 0x00001000L
#define GCVM_CONTEXT2_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                   0x00002000L
#define GCVM_CONTEXT2_CNTL__PDE0_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                       0x00004000L
#define GCVM_CONTEXT2_CNTL__PDE0_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                         0x00008000L
#define GCVM_CONTEXT2_CNTL__VALID_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                      0x00010000L
#define GCVM_CONTEXT2_CNTL__VALID_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                        0x00020000L
#define GCVM_CONTEXT2_CNTL__READ_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                       0x00040000L
#define GCVM_CONTEXT2_CNTL__READ_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                         0x00080000L
#define GCVM_CONTEXT2_CNTL__WRITE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                      0x00100000L
#define GCVM_CONTEXT2_CNTL__WRITE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                        0x00200000L
#define GCVM_CONTEXT2_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                    0x00400000L
#define GCVM_CONTEXT2_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                      0x00800000L
//GCVM_CONTEXT3_CNTL
#define GCVM_CONTEXT3_CNTL__ENABLE_CONTEXT__SHIFT                                                             0x0
#define GCVM_CONTEXT3_CNTL__PAGE_TABLE_DEPTH__SHIFT                                                           0x1
#define GCVM_CONTEXT3_CNTL__PAGE_TABLE_BLOCK_SIZE__SHIFT                                                      0x4
#define GCVM_CONTEXT3_CNTL__RETRY_PERMISSION_OR_INVALID_PAGE_FAULT__SHIFT                                     0x8
#define GCVM_CONTEXT3_CNTL__RETRY_OTHER_FAULT__SHIFT                                                          0x9
#define GCVM_CONTEXT3_CNTL__RANGE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                    0xa
#define GCVM_CONTEXT3_CNTL__RANGE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                      0xb
#define GCVM_CONTEXT3_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                               0xc
#define GCVM_CONTEXT3_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                 0xd
#define GCVM_CONTEXT3_CNTL__PDE0_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                     0xe
#define GCVM_CONTEXT3_CNTL__PDE0_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                       0xf
#define GCVM_CONTEXT3_CNTL__VALID_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                    0x10
#define GCVM_CONTEXT3_CNTL__VALID_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                      0x11
#define GCVM_CONTEXT3_CNTL__READ_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                     0x12
#define GCVM_CONTEXT3_CNTL__READ_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                       0x13
#define GCVM_CONTEXT3_CNTL__WRITE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                    0x14
#define GCVM_CONTEXT3_CNTL__WRITE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                      0x15
#define GCVM_CONTEXT3_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                  0x16
#define GCVM_CONTEXT3_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                    0x17
#define GCVM_CONTEXT3_CNTL__ENABLE_CONTEXT_MASK                                                               0x00000001L
#define GCVM_CONTEXT3_CNTL__PAGE_TABLE_DEPTH_MASK                                                             0x00000006L
#define GCVM_CONTEXT3_CNTL__PAGE_TABLE_BLOCK_SIZE_MASK                                                        0x000000F0L
#define GCVM_CONTEXT3_CNTL__RETRY_PERMISSION_OR_INVALID_PAGE_FAULT_MASK                                       0x00000100L
#define GCVM_CONTEXT3_CNTL__RETRY_OTHER_FAULT_MASK                                                            0x00000200L
#define GCVM_CONTEXT3_CNTL__RANGE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                      0x00000400L
#define GCVM_CONTEXT3_CNTL__RANGE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                        0x00000800L
#define GCVM_CONTEXT3_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                 0x00001000L
#define GCVM_CONTEXT3_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                   0x00002000L
#define GCVM_CONTEXT3_CNTL__PDE0_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                       0x00004000L
#define GCVM_CONTEXT3_CNTL__PDE0_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                         0x00008000L
#define GCVM_CONTEXT3_CNTL__VALID_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                      0x00010000L
#define GCVM_CONTEXT3_CNTL__VALID_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                        0x00020000L
#define GCVM_CONTEXT3_CNTL__READ_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                       0x00040000L
#define GCVM_CONTEXT3_CNTL__READ_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                         0x00080000L
#define GCVM_CONTEXT3_CNTL__WRITE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                      0x00100000L
#define GCVM_CONTEXT3_CNTL__WRITE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                        0x00200000L
#define GCVM_CONTEXT3_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                    0x00400000L
#define GCVM_CONTEXT3_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                      0x00800000L
//GCVM_CONTEXT4_CNTL
#define GCVM_CONTEXT4_CNTL__ENABLE_CONTEXT__SHIFT                                                             0x0
#define GCVM_CONTEXT4_CNTL__PAGE_TABLE_DEPTH__SHIFT                                                           0x1
#define GCVM_CONTEXT4_CNTL__PAGE_TABLE_BLOCK_SIZE__SHIFT                                                      0x4
#define GCVM_CONTEXT4_CNTL__RETRY_PERMISSION_OR_INVALID_PAGE_FAULT__SHIFT                                     0x8
#define GCVM_CONTEXT4_CNTL__RETRY_OTHER_FAULT__SHIFT                                                          0x9
#define GCVM_CONTEXT4_CNTL__RANGE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                    0xa
#define GCVM_CONTEXT4_CNTL__RANGE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                      0xb
#define GCVM_CONTEXT4_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                               0xc
#define GCVM_CONTEXT4_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                 0xd
#define GCVM_CONTEXT4_CNTL__PDE0_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                     0xe
#define GCVM_CONTEXT4_CNTL__PDE0_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                       0xf
#define GCVM_CONTEXT4_CNTL__VALID_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                    0x10
#define GCVM_CONTEXT4_CNTL__VALID_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                      0x11
#define GCVM_CONTEXT4_CNTL__READ_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                     0x12
#define GCVM_CONTEXT4_CNTL__READ_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                       0x13
#define GCVM_CONTEXT4_CNTL__WRITE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                    0x14
#define GCVM_CONTEXT4_CNTL__WRITE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                      0x15
#define GCVM_CONTEXT4_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                  0x16
#define GCVM_CONTEXT4_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                    0x17
#define GCVM_CONTEXT4_CNTL__ENABLE_CONTEXT_MASK                                                               0x00000001L
#define GCVM_CONTEXT4_CNTL__PAGE_TABLE_DEPTH_MASK                                                             0x00000006L
#define GCVM_CONTEXT4_CNTL__PAGE_TABLE_BLOCK_SIZE_MASK                                                        0x000000F0L
#define GCVM_CONTEXT4_CNTL__RETRY_PERMISSION_OR_INVALID_PAGE_FAULT_MASK                                       0x00000100L
#define GCVM_CONTEXT4_CNTL__RETRY_OTHER_FAULT_MASK                                                            0x00000200L
#define GCVM_CONTEXT4_CNTL__RANGE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                      0x00000400L
#define GCVM_CONTEXT4_CNTL__RANGE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                        0x00000800L
#define GCVM_CONTEXT4_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                 0x00001000L
#define GCVM_CONTEXT4_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                   0x00002000L
#define GCVM_CONTEXT4_CNTL__PDE0_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                       0x00004000L
#define GCVM_CONTEXT4_CNTL__PDE0_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                         0x00008000L
#define GCVM_CONTEXT4_CNTL__VALID_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                      0x00010000L
#define GCVM_CONTEXT4_CNTL__VALID_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                        0x00020000L
#define GCVM_CONTEXT4_CNTL__READ_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                       0x00040000L
#define GCVM_CONTEXT4_CNTL__READ_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                         0x00080000L
#define GCVM_CONTEXT4_CNTL__WRITE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                      0x00100000L
#define GCVM_CONTEXT4_CNTL__WRITE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                        0x00200000L
#define GCVM_CONTEXT4_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                    0x00400000L
#define GCVM_CONTEXT4_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                      0x00800000L
//GCVM_CONTEXT5_CNTL
#define GCVM_CONTEXT5_CNTL__ENABLE_CONTEXT__SHIFT                                                             0x0
#define GCVM_CONTEXT5_CNTL__PAGE_TABLE_DEPTH__SHIFT                                                           0x1
#define GCVM_CONTEXT5_CNTL__PAGE_TABLE_BLOCK_SIZE__SHIFT                                                      0x4
#define GCVM_CONTEXT5_CNTL__RETRY_PERMISSION_OR_INVALID_PAGE_FAULT__SHIFT                                     0x8
#define GCVM_CONTEXT5_CNTL__RETRY_OTHER_FAULT__SHIFT                                                          0x9
#define GCVM_CONTEXT5_CNTL__RANGE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                    0xa
#define GCVM_CONTEXT5_CNTL__RANGE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                      0xb
#define GCVM_CONTEXT5_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                               0xc
#define GCVM_CONTEXT5_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                 0xd
#define GCVM_CONTEXT5_CNTL__PDE0_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                     0xe
#define GCVM_CONTEXT5_CNTL__PDE0_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                       0xf
#define GCVM_CONTEXT5_CNTL__VALID_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                    0x10
#define GCVM_CONTEXT5_CNTL__VALID_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                      0x11
#define GCVM_CONTEXT5_CNTL__READ_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                     0x12
#define GCVM_CONTEXT5_CNTL__READ_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                       0x13
#define GCVM_CONTEXT5_CNTL__WRITE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                    0x14
#define GCVM_CONTEXT5_CNTL__WRITE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                      0x15
#define GCVM_CONTEXT5_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                  0x16
#define GCVM_CONTEXT5_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                    0x17
#define GCVM_CONTEXT5_CNTL__ENABLE_CONTEXT_MASK                                                               0x00000001L
#define GCVM_CONTEXT5_CNTL__PAGE_TABLE_DEPTH_MASK                                                             0x00000006L
#define GCVM_CONTEXT5_CNTL__PAGE_TABLE_BLOCK_SIZE_MASK                                                        0x000000F0L
#define GCVM_CONTEXT5_CNTL__RETRY_PERMISSION_OR_INVALID_PAGE_FAULT_MASK                                       0x00000100L
#define GCVM_CONTEXT5_CNTL__RETRY_OTHER_FAULT_MASK                                                            0x00000200L
#define GCVM_CONTEXT5_CNTL__RANGE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                      0x00000400L
#define GCVM_CONTEXT5_CNTL__RANGE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                        0x00000800L
#define GCVM_CONTEXT5_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                 0x00001000L
#define GCVM_CONTEXT5_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                   0x00002000L
#define GCVM_CONTEXT5_CNTL__PDE0_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                       0x00004000L
#define GCVM_CONTEXT5_CNTL__PDE0_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                         0x00008000L
#define GCVM_CONTEXT5_CNTL__VALID_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                      0x00010000L
#define GCVM_CONTEXT5_CNTL__VALID_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                        0x00020000L
#define GCVM_CONTEXT5_CNTL__READ_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                       0x00040000L
#define GCVM_CONTEXT5_CNTL__READ_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                         0x00080000L
#define GCVM_CONTEXT5_CNTL__WRITE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                      0x00100000L
#define GCVM_CONTEXT5_CNTL__WRITE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                        0x00200000L
#define GCVM_CONTEXT5_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK                                    0x00400000L
#define GCVM_CONTEXT5_CNTL__EXECUTE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK                                      0x00800000L
//GCVM_CONTEXT6_CNTL
#define GCVM_CONTEXT6_CNTL__ENABLE_CONTEXT__SHIFT                                                             0x0
#define GCVM_CONTEXT6_CNTL__PAGE_TABLE_DEPTH__SHIFT                                                           0x1
#define GCVM_CONTEXT6_CNTL__PAGE_TABLE_BLOCK_SIZE__SHIFT                                                      0x4
#define GCVM_CONTEXT6_CNTL__RETRY_PERMISSION_OR_INVALID_PAGE_FAULT__SHIFT                                     0x8
#define GCVM_CONTEXT6_CNTL__RETRY_OTHER_FAULT__SHIFT                                                          0x9
#define GCVM_CONTEXT6_CNTL__RANGE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                    0xa
#define GCVM_CONTEXT6_CNTL__RANGE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                      0xb
#define GCVM_CONTEXT6_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                               0xc
#define GCVM_CONTEXT6_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                 0xd
#define GCVM_CONTEXT6_CNTL__PDE0_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT                                     0xe
#define GCVM_CONTEXT6_CNTL__PDE0_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT                                       0xf
#define GCVM_C