/*
 * Copyright (C) 2014 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *     Antti Kaijanmäki <antti.kaijanmaki@canonical.com>
 */

#include "access-point-item.h"

#include "menumodel-cpp/action.h"
#include "menumodel-cpp/menu-item.h"
#include "menumodel-cpp/gio-helpers/variant.h"

using namespace std;
using namespace nmofono;

#include <vector>

class AccessPointItem::Private : public QObject
{
    Q_OBJECT

public:
    AccessPointItem& q;

    wifi::AccessPoint::Ptr m_accessPoint;
    bool m_isActive;

    Action::Ptr m_actionActivate;
    Action::Ptr m_actionStrength;
    MenuItem::Ptr m_item;

    Private(AccessPointItem& parent, wifi::AccessPoint::Ptr accessPoint, bool isActive = false)
        : q{parent},
          m_accessPoint{accessPoint},
          m_isActive{isActive}
    {
        static int id = 0;
        ++id;

        QString actionId = "accesspoint." + QString::number(id);
        QString strengthActionId = actionId + "::strength";

        m_item = make_shared<MenuItem>(m_accessPoint->ssid(),
                                            "indicator." + actionId);



        m_item->setAttribute("x-ayatana-type", TypedVariant<std::string>("lomiri.widgets.systemsettings.tablet.accesspoint"));
        m_item->setAttribute("x-ayatana-wifi-ap-is-adhoc", TypedVariant<bool>(m_accessPoint->adhoc()));
        m_item->setAttribute("x-ayatana-wifi-ap-is-secure", TypedVariant<bool>(m_accessPoint->secured()));
        m_item->setAttribute("x-ayatana-wifi-ap-is-enterprise", TypedVariant<bool>(m_accessPoint->enterprise()));
        m_item->setAttribute("x-ayatana-wifi-ap-strength-action", TypedVariant<std::string>(("indicator." + strengthActionId).toStdString()));

        m_actionStrength = std::make_shared<Action>(strengthActionId,
                                                    nullptr,
                                                    TypedVariant<std::uint8_t>(m_accessPoint->strength()));

        connect(m_accessPoint.get(), &wifi::AccessPoint::strengthUpdated, this, &Private::setStrength);

        m_actionActivate = std::make_shared<Action>(actionId,
                                                    nullptr,
                                                    TypedVariant<bool>(m_isActive));
        connect(m_actionActivate.get(), &Action::activated, &q, &AccessPointItem::activated);

        q.actionGroup()->add(m_actionActivate);
        q.actionGroup()->add(m_actionStrength);
    }

    virtual ~Private()
    {
    }

public Q_SLOTS:
    void setStrength(double value)
    {
        /// @todo narrow_cast<>;
        m_actionStrength->setState(TypedVariant<std::uint8_t>(value));
    }
};

AccessPointItem::AccessPointItem(wifi::AccessPoint::Ptr accessPoint, bool isActive)
    : d{new Private(*this, accessPoint, isActive)}
{
}

AccessPointItem::~AccessPointItem()
{}

void
AccessPointItem::setActive(bool value)
{
    d->m_isActive = value;
    d->m_actionActivate->setState(TypedVariant<bool>(d->m_isActive));
}

MenuItem::Ptr
AccessPointItem::menuItem()
{
    return d->m_item;
}

#include "access-point-item.moc"
