/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2018 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * ABoxModKaliV2, a formula from Mandelbulb3D
 * @reference http://www.fractalforums.com/new-theories-and-research/aboxmodkali-the-2d-version/

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the function "AboxModKaliV2Iteration" in the file fractal_formulas.cpp
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 AboxModKaliV2Iteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	REAL4 c = aux->const_c;
	REAL colorAdd = 0.0f;

	// fold
	REAL4 oldZ = z;
	z.x = fractal->transformCommon.additionConstant0555.x - fabs(z.x);
	z.y = fractal->transformCommon.additionConstant0555.y - fabs(z.y);
	if (fractal->transformCommon.functionEnabledM)
	{
		z.z = fractal->transformCommon.additionConstant0555.z - fabs(z.z);
	}
	REAL4 postZ = z;

	// spherical fold & scaling
	REAL rr = dot(z, z);
	// z += fractal->transformCommon.additionConstant000;
	REAL m = fractal->transformCommon.scale015;
	if (rr < fractal->transformCommon.minR2p25)
	{
		m *= native_divide(fractal->transformCommon.maxR2d1, fractal->transformCommon.minR2p25);
		colorAdd += fractal->mandelbox.color.factorSp1;
	}
	else if (rr < fractal->transformCommon.maxR2d1)
	{
		m *= native_divide(fractal->transformCommon.maxR2d1, rr);
		colorAdd += fractal->mandelbox.color.factorSp2;
	}
	// z -= fractal->transformCommon.additionConstant000;
	z = z * m;
	aux->DE = mad(aux->DE, fabs(m), 1.0f);

	z += fractal->transformCommon.additionConstant000;

	// rotation
	if (fractal->transformCommon.rotationEnabled && aux->i >= fractal->transformCommon.startIterations
			&& aux->i < fractal->transformCommon.stopIterations)
	{
		z = Matrix33MulFloat4(fractal->transformCommon.rotationMatrix, z);
	}

	z += fractal->transformCommon.additionConstant000;

	// add cpixel symmetrical
	if (fractal->transformCommon.addCpixelEnabledFalse
			&& aux->i >= fractal->transformCommon.startIterationsC
			&& aux->i < fractal->transformCommon.stopIterationsC)
	{
		REAL4 tempFAB = c;
		if (fractal->transformCommon.functionEnabledx) tempFAB.x = fabs(tempFAB.x);
		if (fractal->transformCommon.functionEnabledy) tempFAB.y = fabs(tempFAB.y);
		if (fractal->transformCommon.functionEnabledz) tempFAB.z = fabs(tempFAB.z);

		tempFAB *= fractal->transformCommon.constantMultiplier000;

		z.x += sign(z.x) * tempFAB.x;
		z.y += sign(z.y) * tempFAB.y;
		z.z += sign(z.z) * tempFAB.z;
	}

	// sign options
	if (fractal->transformCommon.functionEnabledSFalse
			&& aux->i >= fractal->transformCommon.startIterationsD
			&& aux->i < fractal->transformCommon.stopIterationsD)
	{
		if (fractal->transformCommon.functionEnabledAxFalse) z.x *= sign(oldZ.x);
		if (fractal->transformCommon.functionEnabledAyFalse) z.y *= sign(oldZ.y);
		if (fractal->transformCommon.functionEnabledAzFalse) z.z *= sign(oldZ.z);
	}

	// DE tweak
	if (fractal->analyticDE.enabledFalse)
		aux->DE = mad(aux->DE, fractal->analyticDE.scale1, fractal->analyticDE.offset0);

	// aux->color controls
	if (fractal->foldColor.auxColorEnabledFalse)
	{
		postZ -= oldZ;
		if (postZ.x < 1.0f) aux->color += fractal->mandelbox.color.factor.x;
		if (postZ.y < 1.0f) aux->color += fractal->mandelbox.color.factor.y;
		if (postZ.z < 1.0f) aux->color += fractal->mandelbox.color.factor.z;
		aux->color += colorAdd;
	}
	return z;
}