// |jit-test| skip-if: !wasmSimdEnabled()

/* Copyright 2021 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// ./test/core/simd/simd_i8x16_arith.wast

// ./test/core/simd/simd_i8x16_arith.wast:4
let $0 = instantiate(`(module
  (func (export "i8x16.add") (param v128 v128) (result v128) (i8x16.add (local.get 0) (local.get 1)))
  (func (export "i8x16.sub") (param v128 v128) (result v128) (i8x16.sub (local.get 0) (local.get 1)))
  (func (export "i8x16.neg") (param v128) (result v128) (i8x16.neg (local.get 0)))
)`);

// ./test/core/simd/simd_i8x16_arith.wast:12
assert_return(
  () =>
    invoke($0, `i8x16.add`, [
      i8x16([
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
      ]),
      i8x16([
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
      ]),
    ]),
  [i8x16([
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:15
assert_return(
  () =>
    invoke($0, `i8x16.add`, [
      i8x16([
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
      ]),
      i8x16([
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
      ]),
    ]),
  [i8x16([
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:18
assert_return(
  () =>
    invoke($0, `i8x16.add`, [
      i8x16([
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
      ]),
      i8x16([
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
      ]),
    ]),
  [i8x16([
    0x2,
    0x2,
    0x2,
    0x2,
    0x2,
    0x2,
    0x2,
    0x2,
    0x2,
    0x2,
    0x2,
    0x2,
    0x2,
    0x2,
    0x2,
    0x2,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:21
assert_return(
  () =>
    invoke($0, `i8x16.add`, [
      i8x16([
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
      ]),
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
    ]),
  [i8x16([
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:24
assert_return(
  () =>
    invoke($0, `i8x16.add`, [
      i8x16([
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
      ]),
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
    ]),
  [i8x16([
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:27
assert_return(
  () =>
    invoke($0, `i8x16.add`, [
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
    ]),
  [i8x16([
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:30
assert_return(
  () =>
    invoke($0, `i8x16.add`, [
      i8x16([
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
      ]),
      i8x16([
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
      ]),
    ]),
  [i8x16([
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:33
assert_return(
  () =>
    invoke($0, `i8x16.add`, [
      i8x16([
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
      ]),
      i8x16([
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
      ]),
    ]),
  [i8x16([
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:36
assert_return(
  () =>
    invoke($0, `i8x16.add`, [
      i8x16([
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
      ]),
      i8x16([
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
      ]),
    ]),
  [i8x16([
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:39
assert_return(
  () =>
    invoke($0, `i8x16.add`, [
      i8x16([
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
      ]),
      i8x16([
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
      ]),
    ]),
  [i8x16([
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:42
assert_return(
  () =>
    invoke($0, `i8x16.add`, [
      i8x16([
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
      ]),
      i8x16([
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
      ]),
    ]),
  [i8x16([
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:45
assert_return(
  () =>
    invoke($0, `i8x16.add`, [
      i8x16([
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
      ]),
      i8x16([
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
      ]),
    ]),
  [i8x16([
    0x7e,
    0x7e,
    0x7e,
    0x7e,
    0x7e,
    0x7e,
    0x7e,
    0x7e,
    0x7e,
    0x7e,
    0x7e,
    0x7e,
    0x7e,
    0x7e,
    0x7e,
    0x7e,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:48
assert_return(
  () =>
    invoke($0, `i8x16.add`, [
      i8x16([
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
      ]),
      i8x16([
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
      ]),
    ]),
  [i8x16([
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:51
assert_return(
  () =>
    invoke($0, `i8x16.add`, [
      i8x16([
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
      ]),
      i8x16([
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
      ]),
    ]),
  [i8x16([
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:54
assert_return(
  () =>
    invoke($0, `i8x16.add`, [
      i8x16([
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
      ]),
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
    ]),
  [i8x16([
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:57
assert_return(
  () =>
    invoke($0, `i8x16.add`, [
      i8x16([
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
      ]),
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
    ]),
  [i8x16([
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:60
assert_return(
  () =>
    invoke($0, `i8x16.add`, [
      i8x16([
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
      ]),
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
    ]),
  [i8x16([
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:63
assert_return(
  () =>
    invoke($0, `i8x16.add`, [
      i8x16([
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
      ]),
      i8x16([
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
      ]),
    ]),
  [i8x16([
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:66
assert_return(
  () =>
    invoke($0, `i8x16.add`, [
      i8x16([
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
      ]),
      i8x16([
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
      ]),
    ]),
  [i8x16([
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:69
assert_return(
  () =>
    invoke($0, `i8x16.add`, [
      i8x16([
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
      ]),
      i8x16([
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
      ]),
    ]),
  [i8x16([
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:72
assert_return(
  () =>
    invoke($0, `i8x16.add`, [
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
      i8x16([
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
      ]),
    ]),
  [i8x16([
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:75
assert_return(
  () =>
    invoke($0, `i8x16.add`, [
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
      i8x16([
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
      ]),
    ]),
  [i8x16([
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:78
assert_return(
  () =>
    invoke($0, `i8x16.add`, [
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
    ]),
  [i8x16([
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:81
assert_return(
  () =>
    invoke($0, `i8x16.add`, [
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
      i8x16([
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
      ]),
    ]),
  [i8x16([
    0x7e,
    0x7e,
    0x7e,
    0x7e,
    0x7e,
    0x7e,
    0x7e,
    0x7e,
    0x7e,
    0x7e,
    0x7e,
    0x7e,
    0x7e,
    0x7e,
    0x7e,
    0x7e,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:84
assert_return(
  () =>
    invoke($0, `i8x16.add`, [
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
      i8x16([
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
      ]),
    ]),
  [i8x16([
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:87
assert_return(
  () =>
    invoke($0, `i8x16.add`, [
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
    ]),
  [i8x16([
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:90
assert_return(
  () =>
    invoke($0, `i8x16.add`, [
      i8x16([
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
      ]),
      i8x16([
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
      ]),
    ]),
  [i8x16([
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:93
assert_return(
  () =>
    invoke($0, `i8x16.add`, [
      i8x16([
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
      ]),
      i8x16([
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
      ]),
    ]),
  [i8x16([
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:96
assert_return(
  () =>
    invoke($0, `i8x16.add`, [
      i8x16([
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
      ]),
      i8x16([
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
      ]),
    ]),
  [i8x16([
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:99
assert_return(
  () =>
    invoke($0, `i8x16.add`, [
      i8x16([
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
      ]),
      i8x16([
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
      ]),
    ]),
  [i8x16([
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:102
assert_return(
  () =>
    invoke($0, `i8x16.add`, [
      i8x16([
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
      ]),
      i8x16([
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
      ]),
    ]),
  [i8x16([
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:105
assert_return(
  () =>
    invoke($0, `i8x16.add`, [
      i8x16([
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
      ]),
      i8x16([
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
      ]),
    ]),
  [i8x16([
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:108
assert_return(
  () =>
    invoke($0, `i8x16.add`, [
      i8x16([
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
      ]),
      i8x16([
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
      ]),
    ]),
  [i8x16([
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:111
assert_return(
  () =>
    invoke($0, `i8x16.add`, [
      i8x16([
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
      ]),
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
    ]),
  [i8x16([
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:114
assert_return(
  () =>
    invoke($0, `i8x16.add`, [
      i8x16([
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
      ]),
      i8x16([
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
      ]),
    ]),
  [i8x16([
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:117
assert_return(
  () =>
    invoke($0, `i8x16.add`, [
      i8x16([
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
      ]),
      i8x16([
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
      ]),
    ]),
  [i8x16([
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:120
assert_return(
  () =>
    invoke($0, `i8x16.add`, [
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
      i8x16([
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
      ]),
    ]),
  [i8x16([
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:123
assert_return(
  () =>
    invoke($0, `i8x16.add`, [
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
    ]),
  [i8x16([
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:126
assert_return(
  () =>
    invoke($0, `i8x16.add`, [
      i8x16([
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
      ]),
      i16x8([0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080]),
    ]),
  [i8x16([
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:129
assert_return(
  () =>
    invoke($0, `i8x16.add`, [
      i8x16([
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
      ]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i8x16([
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:132
assert_return(
  () =>
    invoke($0, `i8x16.add`, [
      i8x16([
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
      ]),
      i32x4([0x80808080, 0x80808080, 0x80808080, 0x80808080]),
    ]),
  [i8x16([
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:135
assert_return(
  () =>
    invoke($0, `i8x16.add`, [
      i8x16([
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
      ]),
      i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff]),
    ]),
  [i8x16([
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:138
assert_return(
  () =>
    invoke($0, `i8x16.add`, [
      i8x16([
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i8x16([
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:141
assert_return(
  () =>
    invoke($0, `i8x16.add`, [
      i8x16([
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i8x16([
    0x80,
    0x80,
    0x80,
    0x0,
    0x80,
    0x80,
    0x80,
    0x0,
    0x80,
    0x80,
    0x80,
    0x0,
    0x80,
    0x80,
    0x80,
    0x0,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:144
assert_return(
  () =>
    invoke($0, `i8x16.add`, [
      i8x16([
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i8x16([
    0x80,
    0x80,
    0x0,
    0xbf,
    0x80,
    0x80,
    0x0,
    0xbf,
    0x80,
    0x80,
    0x0,
    0xbf,
    0x80,
    0x80,
    0x0,
    0xbf,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:147
assert_return(
  () =>
    invoke($0, `i8x16.add`, [
      i8x16([
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i8x16([
    0x80,
    0x80,
    0x0,
    0x3f,
    0x80,
    0x80,
    0x0,
    0x3f,
    0x80,
    0x80,
    0x0,
    0x3f,
    0x80,
    0x80,
    0x0,
    0x3f,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:150
assert_return(
  () =>
    invoke($0, `i8x16.add`, [
      i8x16([
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i8x16([
    0x1,
    0x1,
    0x81,
    0x80,
    0x1,
    0x1,
    0x81,
    0x80,
    0x1,
    0x1,
    0x81,
    0x80,
    0x1,
    0x1,
    0x81,
    0x80,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:153
assert_return(
  () =>
    invoke($0, `i8x16.add`, [
      i8x16([
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i8x16([
    0x1,
    0x1,
    0x81,
    0x0,
    0x1,
    0x1,
    0x81,
    0x0,
    0x1,
    0x1,
    0x81,
    0x0,
    0x1,
    0x1,
    0x81,
    0x0,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:156
assert_return(
  () =>
    invoke($0, `i8x16.add`, [
      i8x16([
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i8x16([
    0x1,
    0x1,
    0xc1,
    0x80,
    0x1,
    0x1,
    0xc1,
    0x80,
    0x1,
    0x1,
    0xc1,
    0x80,
    0x1,
    0x1,
    0xc1,
    0x80,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:159
assert_return(
  () =>
    invoke($0, `i8x16.add`, [
      i8x16([
        0x0,
        0x1,
        0x2,
        0x3,
        0x4,
        0x5,
        0x6,
        0x7,
        0x8,
        0x9,
        0xa,
        0xb,
        0xc,
        0xd,
        0xe,
        0xf,
      ]),
      i8x16([
        0x0,
        0xff,
        0xfe,
        0xfd,
        0xfc,
        0xfb,
        0xfa,
        0xf9,
        0xf8,
        0xf7,
        0xf6,
        0xf5,
        0xf4,
        0xf3,
        0xf2,
        0xf1,
      ]),
    ]),
  [i8x16([
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:162
assert_return(
  () =>
    invoke($0, `i8x16.add`, [
      i8x16([
        0x0,
        0x1,
        0x2,
        0x3,
        0x4,
        0x5,
        0x6,
        0x7,
        0x8,
        0x9,
        0xa,
        0xb,
        0xc,
        0xd,
        0xe,
        0xf,
      ]),
      i8x16([
        0x0,
        0x2,
        0x4,
        0x6,
        0x8,
        0xa,
        0xc,
        0xe,
        0x10,
        0x12,
        0x14,
        0x16,
        0x18,
        0x1a,
        0x1c,
        0x1e,
      ]),
    ]),
  [i8x16([
    0x0,
    0x3,
    0x6,
    0x9,
    0xc,
    0xf,
    0x12,
    0x15,
    0x18,
    0x1b,
    0x1e,
    0x21,
    0x24,
    0x27,
    0x2a,
    0x2d,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:167
assert_return(
  () =>
    invoke($0, `i8x16.sub`, [
      i8x16([
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
      ]),
      i8x16([
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
      ]),
    ]),
  [i8x16([
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:170
assert_return(
  () =>
    invoke($0, `i8x16.sub`, [
      i8x16([
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
      ]),
      i8x16([
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
      ]),
    ]),
  [i8x16([
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:173
assert_return(
  () =>
    invoke($0, `i8x16.sub`, [
      i8x16([
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
      ]),
      i8x16([
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
      ]),
    ]),
  [i8x16([
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:176
assert_return(
  () =>
    invoke($0, `i8x16.sub`, [
      i8x16([
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
      ]),
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
    ]),
  [i8x16([
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:179
assert_return(
  () =>
    invoke($0, `i8x16.sub`, [
      i8x16([
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
      ]),
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
    ]),
  [i8x16([
    0x2,
    0x2,
    0x2,
    0x2,
    0x2,
    0x2,
    0x2,
    0x2,
    0x2,
    0x2,
    0x2,
    0x2,
    0x2,
    0x2,
    0x2,
    0x2,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:182
assert_return(
  () =>
    invoke($0, `i8x16.sub`, [
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
    ]),
  [i8x16([
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:185
assert_return(
  () =>
    invoke($0, `i8x16.sub`, [
      i8x16([
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
      ]),
      i8x16([
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
      ]),
    ]),
  [i8x16([
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:188
assert_return(
  () =>
    invoke($0, `i8x16.sub`, [
      i8x16([
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
      ]),
      i8x16([
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
      ]),
    ]),
  [i8x16([
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:191
assert_return(
  () =>
    invoke($0, `i8x16.sub`, [
      i8x16([
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
      ]),
      i8x16([
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
      ]),
    ]),
  [i8x16([
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:194
assert_return(
  () =>
    invoke($0, `i8x16.sub`, [
      i8x16([
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
      ]),
      i8x16([
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
      ]),
    ]),
  [i8x16([
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:197
assert_return(
  () =>
    invoke($0, `i8x16.sub`, [
      i8x16([
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
      ]),
      i8x16([
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
      ]),
    ]),
  [i8x16([
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:200
assert_return(
  () =>
    invoke($0, `i8x16.sub`, [
      i8x16([
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
        0x7d,
      ]),
      i8x16([
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
      ]),
    ]),
  [i8x16([
    0x7c,
    0x7c,
    0x7c,
    0x7c,
    0x7c,
    0x7c,
    0x7c,
    0x7c,
    0x7c,
    0x7c,
    0x7c,
    0x7c,
    0x7c,
    0x7c,
    0x7c,
    0x7c,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:203
assert_return(
  () =>
    invoke($0, `i8x16.sub`, [
      i8x16([
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
      ]),
      i8x16([
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
      ]),
    ]),
  [i8x16([
    0x7d,
    0x7d,
    0x7d,
    0x7d,
    0x7d,
    0x7d,
    0x7d,
    0x7d,
    0x7d,
    0x7d,
    0x7d,
    0x7d,
    0x7d,
    0x7d,
    0x7d,
    0x7d,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:206
assert_return(
  () =>
    invoke($0, `i8x16.sub`, [
      i8x16([
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
      ]),
      i8x16([
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
      ]),
    ]),
  [i8x16([
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:209
assert_return(
  () =>
    invoke($0, `i8x16.sub`, [
      i8x16([
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
        0x82,
      ]),
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
    ]),
  [i8x16([
    0x83,
    0x83,
    0x83,
    0x83,
    0x83,
    0x83,
    0x83,
    0x83,
    0x83,
    0x83,
    0x83,
    0x83,
    0x83,
    0x83,
    0x83,
    0x83,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:212
assert_return(
  () =>
    invoke($0, `i8x16.sub`, [
      i8x16([
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
      ]),
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
    ]),
  [i8x16([
    0x82,
    0x82,
    0x82,
    0x82,
    0x82,
    0x82,
    0x82,
    0x82,
    0x82,
    0x82,
    0x82,
    0x82,
    0x82,
    0x82,
    0x82,
    0x82,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:215
assert_return(
  () =>
    invoke($0, `i8x16.sub`, [
      i8x16([
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
      ]),
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
    ]),
  [i8x16([
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:218
assert_return(
  () =>
    invoke($0, `i8x16.sub`, [
      i8x16([
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
      ]),
      i8x16([
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
      ]),
    ]),
  [i8x16([
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:221
assert_return(
  () =>
    invoke($0, `i8x16.sub`, [
      i8x16([
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
      ]),
      i8x16([
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
      ]),
    ]),
  [i8x16([
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:224
assert_return(
  () =>
    invoke($0, `i8x16.sub`, [
      i8x16([
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
      ]),
      i8x16([
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
      ]),
    ]),
  [i8x16([
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:227
assert_return(
  () =>
    invoke($0, `i8x16.sub`, [
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
      i8x16([
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
      ]),
    ]),
  [i8x16([
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:230
assert_return(
  () =>
    invoke($0, `i8x16.sub`, [
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
      i8x16([
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
      ]),
    ]),
  [i8x16([
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:233
assert_return(
  () =>
    invoke($0, `i8x16.sub`, [
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
    ]),
  [i8x16([
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:236
assert_return(
  () =>
    invoke($0, `i8x16.sub`, [
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
      i8x16([
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
      ]),
    ]),
  [i8x16([
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:239
assert_return(
  () =>
    invoke($0, `i8x16.sub`, [
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
      i8x16([
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
      ]),
    ]),
  [i8x16([
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:242
assert_return(
  () =>
    invoke($0, `i8x16.sub`, [
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
    ]),
  [i8x16([
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:245
assert_return(
  () =>
    invoke($0, `i8x16.sub`, [
      i8x16([
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
        0x3f,
      ]),
      i8x16([
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
      ]),
    ]),
  [i8x16([
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:248
assert_return(
  () =>
    invoke($0, `i8x16.sub`, [
      i8x16([
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
      ]),
      i8x16([
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
        0x40,
      ]),
    ]),
  [i8x16([
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:251
assert_return(
  () =>
    invoke($0, `i8x16.sub`, [
      i8x16([
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
        0xc1,
      ]),
      i8x16([
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
      ]),
    ]),
  [i8x16([
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:254
assert_return(
  () =>
    invoke($0, `i8x16.sub`, [
      i8x16([
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
      ]),
      i8x16([
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
      ]),
    ]),
  [i8x16([
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:257
assert_return(
  () =>
    invoke($0, `i8x16.sub`, [
      i8x16([
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
        0xc0,
      ]),
      i8x16([
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
        0xbf,
      ]),
    ]),
  [i8x16([
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:260
assert_return(
  () =>
    invoke($0, `i8x16.sub`, [
      i8x16([
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
      ]),
      i8x16([
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
      ]),
    ]),
  [i8x16([
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:263
assert_return(
  () =>
    invoke($0, `i8x16.sub`, [
      i8x16([
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
      ]),
      i8x16([
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
      ]),
    ]),
  [i8x16([
    0x7e,
    0x7e,
    0x7e,
    0x7e,
    0x7e,
    0x7e,
    0x7e,
    0x7e,
    0x7e,
    0x7e,
    0x7e,
    0x7e,
    0x7e,
    0x7e,
    0x7e,
    0x7e,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:266
assert_return(
  () =>
    invoke($0, `i8x16.sub`, [
      i8x16([
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
      ]),
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
    ]),
  [i8x16([
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:269
assert_return(
  () =>
    invoke($0, `i8x16.sub`, [
      i8x16([
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
      ]),
      i8x16([
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
      ]),
    ]),
  [i8x16([
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:272
assert_return(
  () =>
    invoke($0, `i8x16.sub`, [
      i8x16([
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
      ]),
      i8x16([
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
      ]),
    ]),
  [i8x16([
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:275
assert_return(
  () =>
    invoke($0, `i8x16.sub`, [
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
      i8x16([
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
      ]),
    ]),
  [i8x16([
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
    0xfe,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:278
assert_return(
  () =>
    invoke($0, `i8x16.sub`, [
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
    ]),
  [i8x16([
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:281
assert_return(
  () =>
    invoke($0, `i8x16.sub`, [
      i8x16([
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
      ]),
      i16x8([0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080]),
    ]),
  [i8x16([
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:284
assert_return(
  () =>
    invoke($0, `i8x16.sub`, [
      i8x16([
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
      ]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i8x16([
    0x2,
    0x2,
    0x2,
    0x2,
    0x2,
    0x2,
    0x2,
    0x2,
    0x2,
    0x2,
    0x2,
    0x2,
    0x2,
    0x2,
    0x2,
    0x2,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:287
assert_return(
  () =>
    invoke($0, `i8x16.sub`, [
      i8x16([
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
      ]),
      i32x4([0x80808080, 0x80808080, 0x80808080, 0x80808080]),
    ]),
  [i8x16([
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:290
assert_return(
  () =>
    invoke($0, `i8x16.sub`, [
      i8x16([
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
      ]),
      i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff]),
    ]),
  [i8x16([
    0x2,
    0x2,
    0x2,
    0x2,
    0x2,
    0x2,
    0x2,
    0x2,
    0x2,
    0x2,
    0x2,
    0x2,
    0x2,
    0x2,
    0x2,
    0x2,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:293
assert_return(
  () =>
    invoke($0, `i8x16.sub`, [
      i8x16([
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i8x16([
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:296
assert_return(
  () =>
    invoke($0, `i8x16.sub`, [
      i8x16([
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i8x16([
    0x80,
    0x80,
    0x80,
    0x0,
    0x80,
    0x80,
    0x80,
    0x0,
    0x80,
    0x80,
    0x80,
    0x0,
    0x80,
    0x80,
    0x80,
    0x0,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:299
assert_return(
  () =>
    invoke($0, `i8x16.sub`, [
      i8x16([
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i8x16([
    0x80,
    0x80,
    0x0,
    0x41,
    0x80,
    0x80,
    0x0,
    0x41,
    0x80,
    0x80,
    0x0,
    0x41,
    0x80,
    0x80,
    0x0,
    0x41,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:302
assert_return(
  () =>
    invoke($0, `i8x16.sub`, [
      i8x16([
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i8x16([
    0x80,
    0x80,
    0x0,
    0xc1,
    0x80,
    0x80,
    0x0,
    0xc1,
    0x80,
    0x80,
    0x0,
    0xc1,
    0x80,
    0x80,
    0x0,
    0xc1,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:305
assert_return(
  () =>
    invoke($0, `i8x16.sub`, [
      i8x16([
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i8x16([
    0x1,
    0x1,
    0x81,
    0x82,
    0x1,
    0x1,
    0x81,
    0x82,
    0x1,
    0x1,
    0x81,
    0x82,
    0x1,
    0x1,
    0x81,
    0x82,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:308
assert_return(
  () =>
    invoke($0, `i8x16.sub`, [
      i8x16([
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i8x16([
    0x1,
    0x1,
    0x81,
    0x2,
    0x1,
    0x1,
    0x81,
    0x2,
    0x1,
    0x1,
    0x81,
    0x2,
    0x1,
    0x1,
    0x81,
    0x2,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:311
assert_return(
  () =>
    invoke($0, `i8x16.sub`, [
      i8x16([
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i8x16([
    0x1,
    0x1,
    0x41,
    0x82,
    0x1,
    0x1,
    0x41,
    0x82,
    0x1,
    0x1,
    0x41,
    0x82,
    0x1,
    0x1,
    0x41,
    0x82,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:314
assert_return(
  () =>
    invoke($0, `i8x16.sub`, [
      i8x16([
        0x0,
        0x1,
        0x2,
        0x3,
        0x4,
        0x5,
        0x6,
        0x7,
        0x8,
        0x9,
        0xa,
        0xb,
        0xc,
        0xd,
        0xe,
        0xf,
      ]),
      i8x16([
        0x0,
        0xff,
        0xfe,
        0xfd,
        0xfc,
        0xfb,
        0xfa,
        0xf9,
        0xf8,
        0xf7,
        0xf6,
        0xf5,
        0xf4,
        0xf3,
        0xf2,
        0xf1,
      ]),
    ]),
  [i8x16([
    0x0,
    0x2,
    0x4,
    0x6,
    0x8,
    0xa,
    0xc,
    0xe,
    0x10,
    0x12,
    0x14,
    0x16,
    0x18,
    0x1a,
    0x1c,
    0x1e,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:317
assert_return(
  () =>
    invoke($0, `i8x16.sub`, [
      i8x16([
        0x0,
        0x1,
        0x2,
        0x3,
        0x4,
        0x5,
        0x6,
        0x7,
        0x8,
        0x9,
        0xa,
        0xb,
        0xc,
        0xd,
        0xe,
        0xf,
      ]),
      i8x16([
        0x0,
        0x2,
        0x4,
        0x6,
        0x8,
        0xa,
        0xc,
        0xe,
        0x10,
        0x12,
        0x14,
        0x16,
        0x18,
        0x1a,
        0x1c,
        0x1e,
      ]),
    ]),
  [i8x16([
    0x0,
    0xff,
    0xfe,
    0xfd,
    0xfc,
    0xfb,
    0xfa,
    0xf9,
    0xf8,
    0xf7,
    0xf6,
    0xf5,
    0xf4,
    0xf3,
    0xf2,
    0xf1,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:322
assert_return(
  () =>
    invoke($0, `i8x16.neg`, [
      i8x16([
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
      ]),
    ]),
  [i8x16([
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:324
assert_return(
  () =>
    invoke($0, `i8x16.neg`, [
      i8x16([
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
      ]),
    ]),
  [i8x16([
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:326
assert_return(
  () =>
    invoke($0, `i8x16.neg`, [
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
    ]),
  [i8x16([
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:328
assert_return(
  () =>
    invoke($0, `i8x16.neg`, [
      i8x16([
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
        0x7e,
      ]),
    ]),
  [i8x16([
    0x82,
    0x82,
    0x82,
    0x82,
    0x82,
    0x82,
    0x82,
    0x82,
    0x82,
    0x82,
    0x82,
    0x82,
    0x82,
    0x82,
    0x82,
    0x82,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:330
assert_return(
  () =>
    invoke($0, `i8x16.neg`, [
      i8x16([
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
      ]),
    ]),
  [i8x16([
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:332
assert_return(
  () =>
    invoke($0, `i8x16.neg`, [
      i8x16([
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
      ]),
    ]),
  [i8x16([
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:334
assert_return(
  () =>
    invoke($0, `i8x16.neg`, [
      i8x16([
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
      ]),
    ]),
  [i8x16([
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:336
assert_return(
  () =>
    invoke($0, `i8x16.neg`, [
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
    ]),
  [i8x16([
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:338
assert_return(
  () =>
    invoke($0, `i8x16.neg`, [
      i8x16([
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
        0x1,
      ]),
    ]),
  [i8x16([
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
    0xff,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:340
assert_return(
  () =>
    invoke($0, `i8x16.neg`, [
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
    ]),
  [i8x16([
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:342
assert_return(
  () =>
    invoke($0, `i8x16.neg`, [
      i8x16([
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
      ]),
    ]),
  [i8x16([
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:344
assert_return(
  () =>
    invoke($0, `i8x16.neg`, [
      i8x16([
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
        0x81,
      ]),
    ]),
  [i8x16([
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
    0x7f,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:346
assert_return(
  () =>
    invoke($0, `i8x16.neg`, [
      i8x16([
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
        0x7f,
      ]),
    ]),
  [i8x16([
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
    0x81,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:348
assert_return(
  () =>
    invoke($0, `i8x16.neg`, [
      i8x16([
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
        0x80,
      ]),
    ]),
  [i8x16([
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
    0x80,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:350
assert_return(
  () =>
    invoke($0, `i8x16.neg`, [
      i8x16([
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
        0xff,
      ]),
    ]),
  [i8x16([
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
    0x1,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:354
assert_invalid(
  () => instantiate(`(module (func (result v128) (i8x16.neg (i32.const 0))))`),
  `type mismatch`,
);

// ./test/core/simd/simd_i8x16_arith.wast:355
assert_invalid(
  () =>
    instantiate(
      `(module (func (result v128) (i8x16.add (i32.const 0) (f32.const 0.0))))`,
    ),
  `type mismatch`,
);

// ./test/core/simd/simd_i8x16_arith.wast:356
assert_invalid(
  () =>
    instantiate(
      `(module (func (result v128) (i8x16.sub (i32.const 0) (f32.const 0.0))))`,
    ),
  `type mismatch`,
);

// ./test/core/simd/simd_i8x16_arith.wast:360
assert_invalid(() =>
  instantiate(`(module
    (func $$i8x16.neg-arg-empty (result v128)
      (i8x16.neg)
    )
  )`), `type mismatch`);

// ./test/core/simd/simd_i8x16_arith.wast:368
assert_invalid(() =>
  instantiate(`(module
    (func $$i8x16.add-1st-arg-empty (result v128)
      (i8x16.add (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
    )
  )`), `type mismatch`);

// ./test/core/simd/simd_i8x16_arith.wast:376
assert_invalid(() =>
  instantiate(`(module
    (func $$i8x16.add-arg-empty (result v128)
      (i8x16.add)
    )
  )`), `type mismatch`);

// ./test/core/simd/simd_i8x16_arith.wast:384
assert_invalid(() =>
  instantiate(`(module
    (func $$i8x16.sub-1st-arg-empty (result v128)
      (i8x16.sub (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
    )
  )`), `type mismatch`);

// ./test/core/simd/simd_i8x16_arith.wast:392
assert_invalid(() =>
  instantiate(`(module
    (func $$i8x16.sub-arg-empty (result v128)
      (i8x16.sub)
    )
  )`), `type mismatch`);

// ./test/core/simd/simd_i8x16_arith.wast:402
let $1 = instantiate(`(module
  (func (export "add-sub") (param v128 v128 v128) (result v128)
    (i8x16.add (i8x16.sub (local.get 0) (local.get 1))(local.get 2)))
  (func (export "sub-add") (param v128 v128 v128) (result v128)
    (i8x16.sub (i8x16.add (local.get 0) (local.get 1))(local.get 2)))
  (func (export "add-neg") (param v128 v128) (result v128)
    (i8x16.add (i8x16.neg (local.get 0)) (local.get 1)))
  (func (export "sub-neg") (param v128 v128) (result v128)
    (i8x16.sub (i8x16.neg (local.get 0)) (local.get 1)))
)`);

// ./test/core/simd/simd_i8x16_arith.wast:413
assert_return(
  () =>
    invoke($1, `add-sub`, [
      i8x16([
        0x0,
        0x1,
        0x2,
        0x3,
        0x4,
        0x5,
        0x6,
        0x7,
        0x8,
        0x9,
        0xa,
        0xb,
        0xc,
        0xd,
        0xe,
        0xf,
      ]),
      i8x16([
        0x0,
        0x2,
        0x4,
        0x6,
        0x8,
        0xa,
        0xc,
        0xe,
        0x10,
        0x12,
        0x14,
        0x16,
        0x18,
        0x1a,
        0x1c,
        0x1e,
      ]),
      i8x16([
        0x0,
        0x2,
        0x4,
        0x6,
        0x8,
        0xa,
        0xc,
        0xe,
        0x10,
        0x12,
        0x14,
        0x16,
        0x18,
        0x1a,
        0x1c,
        0x1e,
      ]),
    ]),
  [i8x16([
    0x0,
    0x1,
    0x2,
    0x3,
    0x4,
    0x5,
    0x6,
    0x7,
    0x8,
    0x9,
    0xa,
    0xb,
    0xc,
    0xd,
    0xe,
    0xf,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:417
assert_return(
  () =>
    invoke($1, `sub-add`, [
      i8x16([
        0x0,
        0x1,
        0x2,
        0x3,
        0x4,
        0x5,
        0x6,
        0x7,
        0x8,
        0x9,
        0xa,
        0xb,
        0xc,
        0xd,
        0xe,
        0xf,
      ]),
      i8x16([
        0x0,
        0x2,
        0x4,
        0x6,
        0x8,
        0xa,
        0xc,
        0xe,
        0x10,
        0x12,
        0x14,
        0x16,
        0x18,
        0x1a,
        0x1c,
        0x1e,
      ]),
      i8x16([
        0x0,
        0x2,
        0x4,
        0x6,
        0x8,
        0xa,
        0xc,
        0xe,
        0x10,
        0x12,
        0x14,
        0x16,
        0x18,
        0x1a,
        0x1c,
        0x1e,
      ]),
    ]),
  [i8x16([
    0x0,
    0x1,
    0x2,
    0x3,
    0x4,
    0x5,
    0x6,
    0x7,
    0x8,
    0x9,
    0xa,
    0xb,
    0xc,
    0xd,
    0xe,
    0xf,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:421
assert_return(
  () =>
    invoke($1, `add-neg`, [
      i8x16([
        0x0,
        0x1,
        0x2,
        0x3,
        0x4,
        0x5,
        0x6,
        0x7,
        0x8,
        0x9,
        0xa,
        0xb,
        0xc,
        0xd,
        0xe,
        0xf,
      ]),
      i8x16([
        0x0,
        0x1,
        0x2,
        0x3,
        0x4,
        0x5,
        0x6,
        0x7,
        0x8,
        0x9,
        0xa,
        0xb,
        0xc,
        0xd,
        0xe,
        0xf,
      ]),
    ]),
  [i8x16([
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
    0x0,
  ])],
);

// ./test/core/simd/simd_i8x16_arith.wast:424
assert_return(
  () =>
    invoke($1, `sub-neg`, [
      i8x16([
        0x0,
        0x1,
        0x2,
        0x3,
        0x4,
        0x5,
        0x6,
        0x7,
        0x8,
        0x9,
        0xa,
        0xb,
        0xc,
        0xd,
        0xe,
        0xf,
      ]),
      i8x16([
        0x0,
        0x1,
        0x2,
        0x3,
        0x4,
        0x5,
        0x6,
        0x7,
        0x8,
        0x9,
        0xa,
        0xb,
        0xc,
        0xd,
        0xe,
        0xf,
      ]),
    ]),
  [i8x16([
    0x0,
    0xfe,
    0xfc,
    0xfa,
    0xf8,
    0xf6,
    0xf4,
    0xf2,
    0xf0,
    0xee,
    0xec,
    0xea,
    0xe8,
    0xe6,
    0xe4,
    0xe2,
  ])],
);
