# Copyright 2022 DeepMind Technologies Limited
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# ==============================================================================
"""Provides information about MuJoCo API functions.

DO NOT EDIT. THIS FILE IS AUTOMATICALLY GENERATED.
"""

from typing import Mapping

from .ast_nodes import ArrayType
from .ast_nodes import FunctionDecl
from .ast_nodes import FunctionParameterDecl
from .ast_nodes import PointerType
from .ast_nodes import ValueType

FUNCTIONS: Mapping[str, FunctionDecl] = dict([
    ('mj_defaultVFS',
     FunctionDecl(
         name='mj_defaultVFS',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='vfs',
                 type=PointerType(
                     inner_type=ValueType(name='mjVFS'),
                 ),
             ),
         ),
         doc='Initialize VFS to empty (no deallocation).',
     )),
    ('mj_addFileVFS',
     FunctionDecl(
         name='mj_addFileVFS',
         return_type=ValueType(name='int'),
         parameters=(
             FunctionParameterDecl(
                 name='vfs',
                 type=PointerType(
                     inner_type=ValueType(name='mjVFS'),
                 ),
             ),
             FunctionParameterDecl(
                 name='directory',
                 type=PointerType(
                     inner_type=ValueType(name='char', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='filename',
                 type=PointerType(
                     inner_type=ValueType(name='char', is_const=True),
                 ),
             ),
         ),
         doc='Add file to VFS, return 0: success, 1: full, 2: repeated name, -1: failed to load.',  # pylint: disable=line-too-long
     )),
    ('mj_makeEmptyFileVFS',
     FunctionDecl(
         name='mj_makeEmptyFileVFS',
         return_type=ValueType(name='int'),
         parameters=(
             FunctionParameterDecl(
                 name='vfs',
                 type=PointerType(
                     inner_type=ValueType(name='mjVFS'),
                 ),
             ),
             FunctionParameterDecl(
                 name='filename',
                 type=PointerType(
                     inner_type=ValueType(name='char', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='filesize',
                 type=ValueType(name='int'),
             ),
         ),
         doc='Make empty file in VFS, return 0: success, 1: full, 2: repeated name.',  # pylint: disable=line-too-long
     )),
    ('mj_findFileVFS',
     FunctionDecl(
         name='mj_findFileVFS',
         return_type=ValueType(name='int'),
         parameters=(
             FunctionParameterDecl(
                 name='vfs',
                 type=PointerType(
                     inner_type=ValueType(name='mjVFS', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='filename',
                 type=PointerType(
                     inner_type=ValueType(name='char', is_const=True),
                 ),
             ),
         ),
         doc='Return file index in VFS, or -1 if not found in VFS.',
     )),
    ('mj_deleteFileVFS',
     FunctionDecl(
         name='mj_deleteFileVFS',
         return_type=ValueType(name='int'),
         parameters=(
             FunctionParameterDecl(
                 name='vfs',
                 type=PointerType(
                     inner_type=ValueType(name='mjVFS'),
                 ),
             ),
             FunctionParameterDecl(
                 name='filename',
                 type=PointerType(
                     inner_type=ValueType(name='char', is_const=True),
                 ),
             ),
         ),
         doc='Delete file from VFS, return 0: success, -1: not found in VFS.',
     )),
    ('mj_deleteVFS',
     FunctionDecl(
         name='mj_deleteVFS',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='vfs',
                 type=PointerType(
                     inner_type=ValueType(name='mjVFS'),
                 ),
             ),
         ),
         doc='Delete all files from VFS.',
     )),
    ('mj_loadXML',
     FunctionDecl(
         name='mj_loadXML',
         return_type=PointerType(
             inner_type=ValueType(name='mjModel'),
         ),
         parameters=(
             FunctionParameterDecl(
                 name='filename',
                 type=PointerType(
                     inner_type=ValueType(name='char', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='vfs',
                 type=PointerType(
                     inner_type=ValueType(name='mjVFS', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='error',
                 type=PointerType(
                     inner_type=ValueType(name='char'),
                 ),
             ),
             FunctionParameterDecl(
                 name='error_sz',
                 type=ValueType(name='int'),
             ),
         ),
         doc='Parse XML file in MJCF or URDF format, compile it, return low-level model. If vfs is not NULL, look up files in vfs before reading from disk. If error is not NULL, it must have size error_sz.',  # pylint: disable=line-too-long
     )),
    ('mj_saveLastXML',
     FunctionDecl(
         name='mj_saveLastXML',
         return_type=ValueType(name='int'),
         parameters=(
             FunctionParameterDecl(
                 name='filename',
                 type=PointerType(
                     inner_type=ValueType(name='char', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='error',
                 type=PointerType(
                     inner_type=ValueType(name='char'),
                 ),
             ),
             FunctionParameterDecl(
                 name='error_sz',
                 type=ValueType(name='int'),
             ),
         ),
         doc='Update XML data structures with info from low-level model, save as MJCF. If error is not NULL, it must have size error_sz.',  # pylint: disable=line-too-long
     )),
    ('mj_freeLastXML',
     FunctionDecl(
         name='mj_freeLastXML',
         return_type=ValueType(name='void'),
         parameters=(),
         doc='Free last XML model if loaded. Called internally at each load.',
     )),
    ('mj_printSchema',
     FunctionDecl(
         name='mj_printSchema',
         return_type=ValueType(name='int'),
         parameters=(
             FunctionParameterDecl(
                 name='filename',
                 type=PointerType(
                     inner_type=ValueType(name='char', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='buffer',
                 type=PointerType(
                     inner_type=ValueType(name='char'),
                 ),
             ),
             FunctionParameterDecl(
                 name='buffer_sz',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='flg_html',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='flg_pad',
                 type=ValueType(name='int'),
             ),
         ),
         doc='Print internal XML schema as plain text or HTML, with style-padding or &nbsp;.',  # pylint: disable=line-too-long
     )),
    ('mj_step',
     FunctionDecl(
         name='mj_step',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
         ),
         doc='Advance simulation, use control callback to obtain external force and control.',  # pylint: disable=line-too-long
     )),
    ('mj_step1',
     FunctionDecl(
         name='mj_step1',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
         ),
         doc='Advance simulation in two steps: before external force and control is set by user.',  # pylint: disable=line-too-long
     )),
    ('mj_step2',
     FunctionDecl(
         name='mj_step2',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
         ),
         doc='Advance simulation in two steps: after external force and control is set by user.',  # pylint: disable=line-too-long
     )),
    ('mj_forward',
     FunctionDecl(
         name='mj_forward',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
         ),
         doc='Forward dynamics: same as mj_step but do not integrate in time.',
     )),
    ('mj_inverse',
     FunctionDecl(
         name='mj_inverse',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
         ),
         doc='Inverse dynamics: qacc must be set before calling.',
     )),
    ('mj_forwardSkip',
     FunctionDecl(
         name='mj_forwardSkip',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
             FunctionParameterDecl(
                 name='skipstage',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='skipsensor',
                 type=ValueType(name='int'),
             ),
         ),
         doc='Forward dynamics with skip; skipstage is mjtStage.',
     )),
    ('mj_inverseSkip',
     FunctionDecl(
         name='mj_inverseSkip',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
             FunctionParameterDecl(
                 name='skipstage',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='skipsensor',
                 type=ValueType(name='int'),
             ),
         ),
         doc='Inverse dynamics with skip; skipstage is mjtStage.',
     )),
    ('mj_defaultLROpt',
     FunctionDecl(
         name='mj_defaultLROpt',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='opt',
                 type=PointerType(
                     inner_type=ValueType(name='mjLROpt'),
                 ),
             ),
         ),
         doc='Set default options for length range computation.',
     )),
    ('mj_defaultSolRefImp',
     FunctionDecl(
         name='mj_defaultSolRefImp',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='solref',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum'),
                 ),
             ),
             FunctionParameterDecl(
                 name='solimp',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum'),
                 ),
             ),
         ),
         doc='Set solver parameters to default values.',
     )),
    ('mj_defaultOption',
     FunctionDecl(
         name='mj_defaultOption',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='opt',
                 type=PointerType(
                     inner_type=ValueType(name='mjOption'),
                 ),
             ),
         ),
         doc='Set physics options to default values.',
     )),
    ('mj_defaultVisual',
     FunctionDecl(
         name='mj_defaultVisual',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='vis',
                 type=PointerType(
                     inner_type=ValueType(name='mjVisual'),
                 ),
             ),
         ),
         doc='Set visual options to default values.',
     )),
    ('mj_copyModel',
     FunctionDecl(
         name='mj_copyModel',
         return_type=PointerType(
             inner_type=ValueType(name='mjModel'),
         ),
         parameters=(
             FunctionParameterDecl(
                 name='dest',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel'),
                 ),
             ),
             FunctionParameterDecl(
                 name='src',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
         ),
         doc='Copy mjModel, allocate new if dest is NULL.',
     )),
    ('mj_saveModel',
     FunctionDecl(
         name='mj_saveModel',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='filename',
                 type=PointerType(
                     inner_type=ValueType(name='char', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='buffer',
                 type=PointerType(
                     inner_type=ValueType(name='void'),
                 ),
             ),
             FunctionParameterDecl(
                 name='buffer_sz',
                 type=ValueType(name='int'),
             ),
         ),
         doc='Save model to binary MJB file or memory buffer; buffer has precedence when given.',  # pylint: disable=line-too-long
     )),
    ('mj_loadModel',
     FunctionDecl(
         name='mj_loadModel',
         return_type=PointerType(
             inner_type=ValueType(name='mjModel'),
         ),
         parameters=(
             FunctionParameterDecl(
                 name='filename',
                 type=PointerType(
                     inner_type=ValueType(name='char', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='vfs',
                 type=PointerType(
                     inner_type=ValueType(name='mjVFS', is_const=True),
                 ),
             ),
         ),
         doc='Load model from binary MJB file. If vfs is not NULL, look up file in vfs before reading from disk.',  # pylint: disable=line-too-long
     )),
    ('mj_deleteModel',
     FunctionDecl(
         name='mj_deleteModel',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel'),
                 ),
             ),
         ),
         doc='Free memory allocation in model.',
     )),
    ('mj_sizeModel',
     FunctionDecl(
         name='mj_sizeModel',
         return_type=ValueType(name='int'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
         ),
         doc='Return size of buffer needed to hold model.',
     )),
    ('mj_makeData',
     FunctionDecl(
         name='mj_makeData',
         return_type=PointerType(
             inner_type=ValueType(name='mjData'),
         ),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
         ),
         doc='Allocate mjData correponding to given model. If the model buffer is unallocated the initial configuration will not be set.',  # pylint: disable=line-too-long
     )),
    ('mj_copyData',
     FunctionDecl(
         name='mj_copyData',
         return_type=PointerType(
             inner_type=ValueType(name='mjData'),
         ),
         parameters=(
             FunctionParameterDecl(
                 name='dest',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='src',
                 type=PointerType(
                     inner_type=ValueType(name='mjData', is_const=True),
                 ),
             ),
         ),
         doc='Copy mjData. m is only required to contain the size fields from MJMODEL_INTS.',  # pylint: disable=line-too-long
     )),
    ('mj_resetData',
     FunctionDecl(
         name='mj_resetData',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
         ),
         doc='Reset data to defaults.',
     )),
    ('mj_resetDataDebug',
     FunctionDecl(
         name='mj_resetDataDebug',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
             FunctionParameterDecl(
                 name='debug_value',
                 type=ValueType(name='unsigned char'),
             ),
         ),
         doc='Reset data to defaults, fill everything else with debug_value.',
     )),
    ('mj_resetDataKeyframe',
     FunctionDecl(
         name='mj_resetDataKeyframe',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
             FunctionParameterDecl(
                 name='key',
                 type=ValueType(name='int'),
             ),
         ),
         doc='Reset data, set fields from specified keyframe.',
     )),
    ('mj_stackAlloc',
     FunctionDecl(
         name='mj_stackAlloc',
         return_type=PointerType(
             inner_type=ValueType(name='mjtNum'),
         ),
         parameters=(
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
             FunctionParameterDecl(
                 name='size',
                 type=ValueType(name='int'),
             ),
         ),
         doc='Allocate array of specified size on mjData stack. Call mju_error on stack overflow.',  # pylint: disable=line-too-long
     )),
    ('mj_deleteData',
     FunctionDecl(
         name='mj_deleteData',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
         ),
         doc='Free memory allocation in mjData.',
     )),
    ('mj_resetCallbacks',
     FunctionDecl(
         name='mj_resetCallbacks',
         return_type=ValueType(name='void'),
         parameters=(),
         doc='Reset all callbacks to NULL pointers (NULL is the default).',
     )),
    ('mj_setConst',
     FunctionDecl(
         name='mj_setConst',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel'),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
         ),
         doc='Set constant fields of mjModel, corresponding to qpos0 configuration.',  # pylint: disable=line-too-long
     )),
    ('mj_setLengthRange',
     FunctionDecl(
         name='mj_setLengthRange',
         return_type=ValueType(name='int'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel'),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
             FunctionParameterDecl(
                 name='index',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='opt',
                 type=PointerType(
                     inner_type=ValueType(name='mjLROpt', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='error',
                 type=PointerType(
                     inner_type=ValueType(name='char'),
                 ),
             ),
             FunctionParameterDecl(
                 name='error_sz',
                 type=ValueType(name='int'),
             ),
         ),
         doc='Set actuator_lengthrange for specified actuator; return 1 if ok, 0 if error.',  # pylint: disable=line-too-long
     )),
    ('mj_printFormattedModel',
     FunctionDecl(
         name='mj_printFormattedModel',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='filename',
                 type=PointerType(
                     inner_type=ValueType(name='char', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='float_format',
                 type=PointerType(
                     inner_type=ValueType(name='char', is_const=True),
                 ),
             ),
         ),
         doc='Print mjModel to text file, specifying format. float_format must be a valid printf-style format string for a single float value.',  # pylint: disable=line-too-long
     )),
    ('mj_printModel',
     FunctionDecl(
         name='mj_printModel',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='filename',
                 type=PointerType(
                     inner_type=ValueType(name='char', is_const=True),
                 ),
             ),
         ),
         doc='Print model to text file.',
     )),
    ('mj_printFormattedData',
     FunctionDecl(
         name='mj_printFormattedData',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
             FunctionParameterDecl(
                 name='filename',
                 type=PointerType(
                     inner_type=ValueType(name='char', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='float_format',
                 type=PointerType(
                     inner_type=ValueType(name='char', is_const=True),
                 ),
             ),
         ),
         doc='Print mjData to text file, specifying format. float_format must be a valid printf-style format string for a single float value',  # pylint: disable=line-too-long
     )),
    ('mj_printData',
     FunctionDecl(
         name='mj_printData',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
             FunctionParameterDecl(
                 name='filename',
                 type=PointerType(
                     inner_type=ValueType(name='char', is_const=True),
                 ),
             ),
         ),
         doc='Print data to text file.',
     )),
    ('mju_printMat',
     FunctionDecl(
         name='mju_printMat',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='mat',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='nr',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='nc',
                 type=ValueType(name='int'),
             ),
         ),
         doc='Print matrix to screen.',
     )),
    ('mju_printMatSparse',
     FunctionDecl(
         name='mju_printMatSparse',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='mat',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='nr',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='rownnz',
                 type=PointerType(
                     inner_type=ValueType(name='int', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='rowadr',
                 type=PointerType(
                     inner_type=ValueType(name='int', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='colind',
                 type=PointerType(
                     inner_type=ValueType(name='int', is_const=True),
                 ),
             ),
         ),
         doc='Print sparse matrix to screen.',
     )),
    ('mj_fwdPosition',
     FunctionDecl(
         name='mj_fwdPosition',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
         ),
         doc='Run position-dependent computations.',
     )),
    ('mj_fwdVelocity',
     FunctionDecl(
         name='mj_fwdVelocity',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
         ),
         doc='Run velocity-dependent computations.',
     )),
    ('mj_fwdActuation',
     FunctionDecl(
         name='mj_fwdActuation',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
         ),
         doc='Compute actuator force qfrc_actuator.',
     )),
    ('mj_fwdAcceleration',
     FunctionDecl(
         name='mj_fwdAcceleration',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
         ),
         doc='Add up all non-constraint forces, compute qacc_unc.',
     )),
    ('mj_fwdConstraint',
     FunctionDecl(
         name='mj_fwdConstraint',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
         ),
         doc='Run selected constraint solver.',
     )),
    ('mj_Euler',
     FunctionDecl(
         name='mj_Euler',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
         ),
         doc='Euler integrator, semi-implicit in velocity.',
     )),
    ('mj_RungeKutta',
     FunctionDecl(
         name='mj_RungeKutta',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
             FunctionParameterDecl(
                 name='N',
                 type=ValueType(name='int'),
             ),
         ),
         doc='Runge-Kutta explicit order-N integrator.',
     )),
    ('mj_invPosition',
     FunctionDecl(
         name='mj_invPosition',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
         ),
         doc='Run position-dependent computations in inverse dynamics.',
     )),
    ('mj_invVelocity',
     FunctionDecl(
         name='mj_invVelocity',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
         ),
         doc='Run velocity-dependent computations in inverse dynamics.',
     )),
    ('mj_invConstraint',
     FunctionDecl(
         name='mj_invConstraint',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
         ),
         doc='Apply the analytical formula for inverse constraint dynamics.',
     )),
    ('mj_compareFwdInv',
     FunctionDecl(
         name='mj_compareFwdInv',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
         ),
         doc='Compare forward and inverse dynamics, save results in fwdinv.',
     )),
    ('mj_sensorPos',
     FunctionDecl(
         name='mj_sensorPos',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
         ),
         doc='Evaluate position-dependent sensors.',
     )),
    ('mj_sensorVel',
     FunctionDecl(
         name='mj_sensorVel',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
         ),
         doc='Evaluate velocity-dependent sensors.',
     )),
    ('mj_sensorAcc',
     FunctionDecl(
         name='mj_sensorAcc',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
         ),
         doc='Evaluate acceleration and force-dependent sensors.',
     )),
    ('mj_energyPos',
     FunctionDecl(
         name='mj_energyPos',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
         ),
         doc='Evaluate position-dependent energy (potential).',
     )),
    ('mj_energyVel',
     FunctionDecl(
         name='mj_energyVel',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
         ),
         doc='Evaluate velocity-dependent energy (kinetic).',
     )),
    ('mj_checkPos',
     FunctionDecl(
         name='mj_checkPos',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
         ),
         doc='Check qpos, reset if any element is too big or nan.',
     )),
    ('mj_checkVel',
     FunctionDecl(
         name='mj_checkVel',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
         ),
         doc='Check qvel, reset if any element is too big or nan.',
     )),
    ('mj_checkAcc',
     FunctionDecl(
         name='mj_checkAcc',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
         ),
         doc='Check qacc, reset if any element is too big or nan.',
     )),
    ('mj_kinematics',
     FunctionDecl(
         name='mj_kinematics',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
         ),
         doc='Run forward kinematics.',
     )),
    ('mj_comPos',
     FunctionDecl(
         name='mj_comPos',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
         ),
         doc='Map inertias and motion dofs to global frame centered at CoM.',
     )),
    ('mj_camlight',
     FunctionDecl(
         name='mj_camlight',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
         ),
         doc='Compute camera and light positions and orientations.',
     )),
    ('mj_tendon',
     FunctionDecl(
         name='mj_tendon',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
         ),
         doc='Compute tendon lengths, velocities and moment arms.',
     )),
    ('mj_transmission',
     FunctionDecl(
         name='mj_transmission',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
         ),
         doc='Compute actuator transmission lengths and moments.',
     )),
    ('mj_crb',
     FunctionDecl(
         name='mj_crb',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
         ),
         doc='Run composite rigid body inertia algorithm (CRB).',
     )),
    ('mj_factorM',
     FunctionDecl(
         name='mj_factorM',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
         ),
         doc="Compute sparse L'*D*L factorizaton of inertia matrix.",
     )),
    ('mj_solveM',
     FunctionDecl(
         name='mj_solveM',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
             FunctionParameterDecl(
                 name='x',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum'),
                 ),
             ),
             FunctionParameterDecl(
                 name='y',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='n',
                 type=ValueType(name='int'),
             ),
         ),
         doc="Solve linear system M * x = y using factorization:  x = inv(L'*D*L)*y",  # pylint: disable=line-too-long
     )),
    ('mj_solveM2',
     FunctionDecl(
         name='mj_solveM2',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
             FunctionParameterDecl(
                 name='x',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum'),
                 ),
             ),
             FunctionParameterDecl(
                 name='y',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='n',
                 type=ValueType(name='int'),
             ),
         ),
         doc="Half of linear solve:  x = sqrt(inv(D))*inv(L')*y",
     )),
    ('mj_comVel',
     FunctionDecl(
         name='mj_comVel',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
         ),
         doc='Compute cvel, cdof_dot.',
     )),
    ('mj_passive',
     FunctionDecl(
         name='mj_passive',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
         ),
         doc='Compute qfrc_passive from spring-dampers, viscosity and density.',
     )),
    ('mj_subtreeVel',
     FunctionDecl(
         name='mj_subtreeVel',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
         ),
         doc='subtree linear velocity and angular momentum',
     )),
    ('mj_rne',
     FunctionDecl(
         name='mj_rne',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
             FunctionParameterDecl(
                 name='flg_acc',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='result',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum'),
                 ),
             ),
         ),
         doc='RNE: compute M(qpos)*qacc + C(qpos,qvel); flg_acc=0 removes inertial term.',  # pylint: disable=line-too-long
     )),
    ('mj_rnePostConstraint',
     FunctionDecl(
         name='mj_rnePostConstraint',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
         ),
         doc='RNE with complete data: compute cacc, cfrc_ext, cfrc_int.',
     )),
    ('mj_collision',
     FunctionDecl(
         name='mj_collision',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
         ),
         doc='Run collision detection.',
     )),
    ('mj_makeConstraint',
     FunctionDecl(
         name='mj_makeConstraint',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
         ),
         doc='Construct constraints.',
     )),
    ('mj_projectConstraint',
     FunctionDecl(
         name='mj_projectConstraint',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
         ),
         doc='Compute inverse constaint inertia efc_AR.',
     )),
    ('mj_referenceConstraint',
     FunctionDecl(
         name='mj_referenceConstraint',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
         ),
         doc='Compute efc_vel, efc_aref.',
     )),
    ('mj_constraintUpdate',
     FunctionDecl(
         name='mj_constraintUpdate',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
             FunctionParameterDecl(
                 name='jar',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='cost',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum'),
                     extents=(1,),
                 ),
             ),
             FunctionParameterDecl(
                 name='flg_coneHessian',
                 type=ValueType(name='int'),
             ),
         ),
         doc='Compute efc_state, efc_force, qfrc_constraint, and (optionally) cone Hessians. If cost is not NULL, set *cost = s(jar) where jar = Jac*qacc-aref.',  # pylint: disable=line-too-long
     )),
    ('mj_addContact',
     FunctionDecl(
         name='mj_addContact',
         return_type=ValueType(name='int'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
             FunctionParameterDecl(
                 name='con',
                 type=PointerType(
                     inner_type=ValueType(name='mjContact', is_const=True),
                 ),
             ),
         ),
         doc='Add contact to d->contact list; return 0 if success; 1 if buffer full.',  # pylint: disable=line-too-long
     )),
    ('mj_isPyramidal',
     FunctionDecl(
         name='mj_isPyramidal',
         return_type=ValueType(name='int'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
         ),
         doc='Determine type of friction cone.',
     )),
    ('mj_isSparse',
     FunctionDecl(
         name='mj_isSparse',
         return_type=ValueType(name='int'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
         ),
         doc='Determine type of constraint Jacobian.',
     )),
    ('mj_isDual',
     FunctionDecl(
         name='mj_isDual',
         return_type=ValueType(name='int'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
         ),
         doc='Determine type of solver (PGS is dual, CG and Newton are primal).',  # pylint: disable=line-too-long
     )),
    ('mj_mulJacVec',
     FunctionDecl(
         name='mj_mulJacVec',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
             FunctionParameterDecl(
                 name='res',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum'),
                 ),
             ),
             FunctionParameterDecl(
                 name='vec',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                 ),
             ),
         ),
         doc='Multiply dense or sparse constraint Jacobian by vector.',
     )),
    ('mj_mulJacTVec',
     FunctionDecl(
         name='mj_mulJacTVec',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
             FunctionParameterDecl(
                 name='res',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum'),
                 ),
             ),
             FunctionParameterDecl(
                 name='vec',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                 ),
             ),
         ),
         doc='Multiply dense or sparse constraint Jacobian transpose by vector.',  # pylint: disable=line-too-long
     )),
    ('mj_jac',
     FunctionDecl(
         name='mj_jac',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='jacp',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum'),
                 ),
             ),
             FunctionParameterDecl(
                 name='jacr',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum'),
                 ),
             ),
             FunctionParameterDecl(
                 name='point',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='body',
                 type=ValueType(name='int'),
             ),
         ),
         doc='Compute 3/6-by-nv end-effector Jacobian of global point attached to given body.',  # pylint: disable=line-too-long
     )),
    ('mj_jacBody',
     FunctionDecl(
         name='mj_jacBody',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='jacp',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum'),
                 ),
             ),
             FunctionParameterDecl(
                 name='jacr',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum'),
                 ),
             ),
             FunctionParameterDecl(
                 name='body',
                 type=ValueType(name='int'),
             ),
         ),
         doc='Compute body frame end-effector Jacobian.',
     )),
    ('mj_jacBodyCom',
     FunctionDecl(
         name='mj_jacBodyCom',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='jacp',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum'),
                 ),
             ),
             FunctionParameterDecl(
                 name='jacr',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum'),
                 ),
             ),
             FunctionParameterDecl(
                 name='body',
                 type=ValueType(name='int'),
             ),
         ),
         doc='Compute body center-of-mass end-effector Jacobian.',
     )),
    ('mj_jacSubtreeCom',
     FunctionDecl(
         name='mj_jacSubtreeCom',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
             FunctionParameterDecl(
                 name='jacp',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum'),
                 ),
             ),
             FunctionParameterDecl(
                 name='body',
                 type=ValueType(name='int'),
             ),
         ),
         doc='Compute subtree center-of-mass end-effector Jacobian.',
     )),
    ('mj_jacGeom',
     FunctionDecl(
         name='mj_jacGeom',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='jacp',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum'),
                 ),
             ),
             FunctionParameterDecl(
                 name='jacr',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum'),
                 ),
             ),
             FunctionParameterDecl(
                 name='geom',
                 type=ValueType(name='int'),
             ),
         ),
         doc='Compute geom end-effector Jacobian.',
     )),
    ('mj_jacSite',
     FunctionDecl(
         name='mj_jacSite',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='jacp',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum'),
                 ),
             ),
             FunctionParameterDecl(
                 name='jacr',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum'),
                 ),
             ),
             FunctionParameterDecl(
                 name='site',
                 type=ValueType(name='int'),
             ),
         ),
         doc='Compute site end-effector Jacobian.',
     )),
    ('mj_jacPointAxis',
     FunctionDecl(
         name='mj_jacPointAxis',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
             FunctionParameterDecl(
                 name='jacPoint',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum'),
                 ),
             ),
             FunctionParameterDecl(
                 name='jacAxis',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum'),
                 ),
             ),
             FunctionParameterDecl(
                 name='point',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='axis',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='body',
                 type=ValueType(name='int'),
             ),
         ),
         doc='Compute translation end-effector Jacobian of point, and rotation Jacobian of axis.',  # pylint: disable=line-too-long
     )),
    ('mj_name2id',
     FunctionDecl(
         name='mj_name2id',
         return_type=ValueType(name='int'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='type',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='name',
                 type=PointerType(
                     inner_type=ValueType(name='char', is_const=True),
                 ),
             ),
         ),
         doc='Get id of object with specified name, return -1 if not found; type is mjtObj.',  # pylint: disable=line-too-long
     )),
    ('mj_id2name',
     FunctionDecl(
         name='mj_id2name',
         return_type=PointerType(
             inner_type=ValueType(name='char', is_const=True),
         ),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='type',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='id',
                 type=ValueType(name='int'),
             ),
         ),
         doc='Get name of object with specified id, return 0 if invalid type or id; type is mjtObj.',  # pylint: disable=line-too-long
     )),
    ('mj_fullM',
     FunctionDecl(
         name='mj_fullM',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='dst',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum'),
                 ),
             ),
             FunctionParameterDecl(
                 name='M',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                 ),
             ),
         ),
         doc='Convert sparse inertia matrix M into full (i.e. dense) matrix.',
     )),
    ('mj_mulM',
     FunctionDecl(
         name='mj_mulM',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='res',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum'),
                 ),
             ),
             FunctionParameterDecl(
                 name='vec',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                 ),
             ),
         ),
         doc='Multiply vector by inertia matrix.',
     )),
    ('mj_mulM2',
     FunctionDecl(
         name='mj_mulM2',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='res',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum'),
                 ),
             ),
             FunctionParameterDecl(
                 name='vec',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                 ),
             ),
         ),
         doc='Multiply vector by (inertia matrix)^(1/2).',
     )),
    ('mj_addM',
     FunctionDecl(
         name='mj_addM',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
             FunctionParameterDecl(
                 name='dst',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum'),
                 ),
             ),
             FunctionParameterDecl(
                 name='rownnz',
                 type=PointerType(
                     inner_type=ValueType(name='int'),
                 ),
             ),
             FunctionParameterDecl(
                 name='rowadr',
                 type=PointerType(
                     inner_type=ValueType(name='int'),
                 ),
             ),
             FunctionParameterDecl(
                 name='colind',
                 type=PointerType(
                     inner_type=ValueType(name='int'),
                 ),
             ),
         ),
         doc='Add inertia matrix to destination matrix. Destination can be sparse uncompressed, or dense when all int* are NULL',  # pylint: disable=line-too-long
     )),
    ('mj_applyFT',
     FunctionDecl(
         name='mj_applyFT',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
             FunctionParameterDecl(
                 name='force',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='torque',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='point',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='body',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='qfrc_target',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum'),
                 ),
             ),
         ),
         doc='Apply cartesian force and torque (outside xfrc_applied mechanism).',  # pylint: disable=line-too-long
     )),
    ('mj_objectVelocity',
     FunctionDecl(
         name='mj_objectVelocity',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='objtype',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='objid',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='res',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum'),
                     extents=(6,),
                 ),
             ),
             FunctionParameterDecl(
                 name='flg_local',
                 type=ValueType(name='int'),
             ),
         ),
         doc='Compute object 6D velocity in object-centered frame, world/local orientation.',  # pylint: disable=line-too-long
     )),
    ('mj_objectAcceleration',
     FunctionDecl(
         name='mj_objectAcceleration',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='objtype',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='objid',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='res',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum'),
                     extents=(6,),
                 ),
             ),
             FunctionParameterDecl(
                 name='flg_local',
                 type=ValueType(name='int'),
             ),
         ),
         doc='Compute object 6D acceleration in object-centered frame, world/local orientation.',  # pylint: disable=line-too-long
     )),
    ('mj_contactForce',
     FunctionDecl(
         name='mj_contactForce',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='id',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='result',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum'),
                     extents=(6,),
                 ),
             ),
         ),
         doc='Extract 6D force:torque given contact id, in the contact frame.',
     )),
    ('mj_differentiatePos',
     FunctionDecl(
         name='mj_differentiatePos',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='qvel',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum'),
                 ),
             ),
             FunctionParameterDecl(
                 name='dt',
                 type=ValueType(name='mjtNum'),
             ),
             FunctionParameterDecl(
                 name='qpos1',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='qpos2',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                 ),
             ),
         ),
         doc='Compute velocity by finite-differencing two positions.',
     )),
    ('mj_integratePos',
     FunctionDecl(
         name='mj_integratePos',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='qpos',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum'),
                 ),
             ),
             FunctionParameterDecl(
                 name='qvel',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='dt',
                 type=ValueType(name='mjtNum'),
             ),
         ),
         doc='Integrate position with given velocity.',
     )),
    ('mj_normalizeQuat',
     FunctionDecl(
         name='mj_normalizeQuat',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='qpos',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum'),
                 ),
             ),
         ),
         doc='Normalize all quaternions in qpos-type vector.',
     )),
    ('mj_local2Global',
     FunctionDecl(
         name='mj_local2Global',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
             FunctionParameterDecl(
                 name='xpos',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum'),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='xmat',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum'),
                     extents=(9,),
                 ),
             ),
             FunctionParameterDecl(
                 name='pos',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='quat',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(4,),
                 ),
             ),
             FunctionParameterDecl(
                 name='body',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='sameframe',
                 type=ValueType(name='mjtByte'),
             ),
         ),
         doc='Map from body local to global Cartesian coordinates.',
     )),
    ('mj_getTotalmass',
     FunctionDecl(
         name='mj_getTotalmass',
         return_type=ValueType(name='mjtNum'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
         ),
         doc='Sum all body masses.',
     )),
    ('mj_setTotalmass',
     FunctionDecl(
         name='mj_setTotalmass',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel'),
                 ),
             ),
             FunctionParameterDecl(
                 name='newmass',
                 type=ValueType(name='mjtNum'),
             ),
         ),
         doc='Scale body masses and inertias to achieve specified total mass.',
     )),
    ('mj_version',
     FunctionDecl(
         name='mj_version',
         return_type=ValueType(name='int'),
         parameters=(),
         doc='Return version number: 1.0.2 is encoded as 102.',
     )),
    ('mj_versionString',
     FunctionDecl(
         name='mj_versionString',
         return_type=PointerType(
             inner_type=ValueType(name='char', is_const=True),
         ),
         parameters=(),
         doc='Return the current version of MuJoCo as a null-terminated string.',  # pylint: disable=line-too-long
     )),
    ('mj_ray',
     FunctionDecl(
         name='mj_ray',
         return_type=ValueType(name='mjtNum'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='pnt',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='vec',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='geomgroup',
                 type=PointerType(
                     inner_type=ValueType(name='mjtByte', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='flg_static',
                 type=ValueType(name='mjtByte'),
             ),
             FunctionParameterDecl(
                 name='bodyexclude',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='geomid',
                 type=ArrayType(
                     inner_type=ValueType(name='int'),
                     extents=(1,),
                 ),
             ),
         ),
         doc='Intersect ray (pnt+x*vec, x>=0) with visible geoms, except geoms in bodyexclude. Return distance (x) to nearest surface, or -1 if no intersection and output geomid. geomgroup, flg_static are as in mjvOption; geomgroup==NULL skips group exclusion.',  # pylint: disable=line-too-long
     )),
    ('mj_rayHfield',
     FunctionDecl(
         name='mj_rayHfield',
         return_type=ValueType(name='mjtNum'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='geomid',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='pnt',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='vec',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(3,),
                 ),
             ),
         ),
         doc='Interect ray with hfield, return nearest distance or -1 if no intersection.',  # pylint: disable=line-too-long
     )),
    ('mj_rayMesh',
     FunctionDecl(
         name='mj_rayMesh',
         return_type=ValueType(name='mjtNum'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='geomid',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='pnt',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='vec',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(3,),
                 ),
             ),
         ),
         doc='Interect ray with mesh, return nearest distance or -1 if no intersection.',  # pylint: disable=line-too-long
     )),
    ('mju_rayGeom',
     FunctionDecl(
         name='mju_rayGeom',
         return_type=ValueType(name='mjtNum'),
         parameters=(
             FunctionParameterDecl(
                 name='pos',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='mat',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(9,),
                 ),
             ),
             FunctionParameterDecl(
                 name='size',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='pnt',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='vec',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='geomtype',
                 type=ValueType(name='int'),
             ),
         ),
         doc='Interect ray with pure geom, return nearest distance or -1 if no intersection.',  # pylint: disable=line-too-long
     )),
    ('mju_raySkin',
     FunctionDecl(
         name='mju_raySkin',
         return_type=ValueType(name='mjtNum'),
         parameters=(
             FunctionParameterDecl(
                 name='nface',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='nvert',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='face',
                 type=PointerType(
                     inner_type=ValueType(name='int', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='vert',
                 type=PointerType(
                     inner_type=ValueType(name='float', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='pnt',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='vec',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='vertid',
                 type=ArrayType(
                     inner_type=ValueType(name='int'),
                     extents=(1,),
                 ),
             ),
         ),
         doc='Interect ray with skin, return nearest distance or -1 if no intersection, and also output nearest vertex id.',  # pylint: disable=line-too-long
     )),
    ('mjv_defaultCamera',
     FunctionDecl(
         name='mjv_defaultCamera',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='cam',
                 type=PointerType(
                     inner_type=ValueType(name='mjvCamera'),
                 ),
             ),
         ),
         doc='Set default camera.',
     )),
    ('mjv_defaultFreeCamera',
     FunctionDecl(
         name='mjv_defaultFreeCamera',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='cam',
                 type=PointerType(
                     inner_type=ValueType(name='mjvCamera'),
                 ),
             ),
         ),
         doc='Set default free camera.',
     )),
    ('mjv_defaultPerturb',
     FunctionDecl(
         name='mjv_defaultPerturb',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='pert',
                 type=PointerType(
                     inner_type=ValueType(name='mjvPerturb'),
                 ),
             ),
         ),
         doc='Set default perturbation.',
     )),
    ('mjv_room2model',
     FunctionDecl(
         name='mjv_room2model',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='modelpos',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum'),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='modelquat',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum'),
                     extents=(4,),
                 ),
             ),
             FunctionParameterDecl(
                 name='roompos',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='roomquat',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(4,),
                 ),
             ),
             FunctionParameterDecl(
                 name='scn',
                 type=PointerType(
                     inner_type=ValueType(name='mjvScene', is_const=True),
                 ),
             ),
         ),
         doc='Transform pose from room to model space.',
     )),
    ('mjv_model2room',
     FunctionDecl(
         name='mjv_model2room',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='roompos',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum'),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='roomquat',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum'),
                     extents=(4,),
                 ),
             ),
             FunctionParameterDecl(
                 name='modelpos',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='modelquat',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(4,),
                 ),
             ),
             FunctionParameterDecl(
                 name='scn',
                 type=PointerType(
                     inner_type=ValueType(name='mjvScene', is_const=True),
                 ),
             ),
         ),
         doc='Transform pose from model to room space.',
     )),
    ('mjv_cameraInModel',
     FunctionDecl(
         name='mjv_cameraInModel',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='headpos',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum'),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='forward',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum'),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='up',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum'),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='scn',
                 type=PointerType(
                     inner_type=ValueType(name='mjvScene', is_const=True),
                 ),
             ),
         ),
         doc='Get camera info in model space; average left and right OpenGL cameras.',  # pylint: disable=line-too-long
     )),
    ('mjv_cameraInRoom',
     FunctionDecl(
         name='mjv_cameraInRoom',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='headpos',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum'),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='forward',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum'),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='up',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum'),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='scn',
                 type=PointerType(
                     inner_type=ValueType(name='mjvScene', is_const=True),
                 ),
             ),
         ),
         doc='Get camera info in room space; average left and right OpenGL cameras.',  # pylint: disable=line-too-long
     )),
    ('mjv_frustumHeight',
     FunctionDecl(
         name='mjv_frustumHeight',
         return_type=ValueType(name='mjtNum'),
         parameters=(
             FunctionParameterDecl(
                 name='scn',
                 type=PointerType(
                     inner_type=ValueType(name='mjvScene', is_const=True),
                 ),
             ),
         ),
         doc='Get frustum height at unit distance from camera; average left and right OpenGL cameras.',  # pylint: disable=line-too-long
     )),
    ('mjv_alignToCamera',
     FunctionDecl(
         name='mjv_alignToCamera',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='res',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum'),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='vec',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='forward',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(3,),
                 ),
             ),
         ),
         doc='Rotate 3D vec in horizontal plane by angle between (0,1) and (forward_x,forward_y).',  # pylint: disable=line-too-long
     )),
    ('mjv_moveCamera',
     FunctionDecl(
         name='mjv_moveCamera',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='action',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='reldx',
                 type=ValueType(name='mjtNum'),
             ),
             FunctionParameterDecl(
                 name='reldy',
                 type=ValueType(name='mjtNum'),
             ),
             FunctionParameterDecl(
                 name='scn',
                 type=PointerType(
                     inner_type=ValueType(name='mjvScene', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='cam',
                 type=PointerType(
                     inner_type=ValueType(name='mjvCamera'),
                 ),
             ),
         ),
         doc='Move camera with mouse; action is mjtMouse.',
     )),
    ('mjv_movePerturb',
     FunctionDecl(
         name='mjv_movePerturb',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='action',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='reldx',
                 type=ValueType(name='mjtNum'),
             ),
             FunctionParameterDecl(
                 name='reldy',
                 type=ValueType(name='mjtNum'),
             ),
             FunctionParameterDecl(
                 name='scn',
                 type=PointerType(
                     inner_type=ValueType(name='mjvScene', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='pert',
                 type=PointerType(
                     inner_type=ValueType(name='mjvPerturb'),
                 ),
             ),
         ),
         doc='Move perturb object with mouse; action is mjtMouse.',
     )),
    ('mjv_moveModel',
     FunctionDecl(
         name='mjv_moveModel',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='action',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='reldx',
                 type=ValueType(name='mjtNum'),
             ),
             FunctionParameterDecl(
                 name='reldy',
                 type=ValueType(name='mjtNum'),
             ),
             FunctionParameterDecl(
                 name='roomup',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='scn',
                 type=PointerType(
                     inner_type=ValueType(name='mjvScene'),
                 ),
             ),
         ),
         doc='Move model with mouse; action is mjtMouse.',
     )),
    ('mjv_initPerturb',
     FunctionDecl(
         name='mjv_initPerturb',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='scn',
                 type=PointerType(
                     inner_type=ValueType(name='mjvScene', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='pert',
                 type=PointerType(
                     inner_type=ValueType(name='mjvPerturb'),
                 ),
             ),
         ),
         doc='Copy perturb pos,quat from selected body; set scale for perturbation.',  # pylint: disable=line-too-long
     )),
    ('mjv_applyPerturbPose',
     FunctionDecl(
         name='mjv_applyPerturbPose',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
             FunctionParameterDecl(
                 name='pert',
                 type=PointerType(
                     inner_type=ValueType(name='mjvPerturb', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='flg_paused',
                 type=ValueType(name='int'),
             ),
         ),
         doc='Set perturb pos,quat in d->mocap when selected body is mocap, and in d->qpos otherwise. Write d->qpos only if flg_paused and subtree root for selected body has free joint.',  # pylint: disable=line-too-long
     )),
    ('mjv_applyPerturbForce',
     FunctionDecl(
         name='mjv_applyPerturbForce',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
             FunctionParameterDecl(
                 name='pert',
                 type=PointerType(
                     inner_type=ValueType(name='mjvPerturb', is_const=True),
                 ),
             ),
         ),
         doc='Set perturb force,torque in d->xfrc_applied, if selected body is dynamic.',  # pylint: disable=line-too-long
     )),
    ('mjv_averageCamera',
     FunctionDecl(
         name='mjv_averageCamera',
         return_type=ValueType(name='mjvGLCamera'),
         parameters=(
             FunctionParameterDecl(
                 name='cam1',
                 type=PointerType(
                     inner_type=ValueType(name='mjvGLCamera', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='cam2',
                 type=PointerType(
                     inner_type=ValueType(name='mjvGLCamera', is_const=True),
                 ),
             ),
         ),
         doc='Return the average of two OpenGL cameras.',
     )),
    ('mjv_select',
     FunctionDecl(
         name='mjv_select',
         return_type=ValueType(name='int'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='vopt',
                 type=PointerType(
                     inner_type=ValueType(name='mjvOption', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='aspectratio',
                 type=ValueType(name='mjtNum'),
             ),
             FunctionParameterDecl(
                 name='relx',
                 type=ValueType(name='mjtNum'),
             ),
             FunctionParameterDecl(
                 name='rely',
                 type=ValueType(name='mjtNum'),
             ),
             FunctionParameterDecl(
                 name='scn',
                 type=PointerType(
                     inner_type=ValueType(name='mjvScene', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='selpnt',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum'),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='geomid',
                 type=ArrayType(
                     inner_type=ValueType(name='int'),
                     extents=(1,),
                 ),
             ),
             FunctionParameterDecl(
                 name='skinid',
                 type=ArrayType(
                     inner_type=ValueType(name='int'),
                     extents=(1,),
                 ),
             ),
         ),
         doc='Select geom or skin with mouse, return bodyid; -1: none selected.',  # pylint: disable=line-too-long
     )),
    ('mjv_defaultOption',
     FunctionDecl(
         name='mjv_defaultOption',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='opt',
                 type=PointerType(
                     inner_type=ValueType(name='mjvOption'),
                 ),
             ),
         ),
         doc='Set default visualization options.',
     )),
    ('mjv_defaultFigure',
     FunctionDecl(
         name='mjv_defaultFigure',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='fig',
                 type=PointerType(
                     inner_type=ValueType(name='mjvFigure'),
                 ),
             ),
         ),
         doc='Set default figure.',
     )),
    ('mjv_initGeom',
     FunctionDecl(
         name='mjv_initGeom',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='geom',
                 type=PointerType(
                     inner_type=ValueType(name='mjvGeom'),
                 ),
             ),
             FunctionParameterDecl(
                 name='type',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='size',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='pos',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='mat',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(9,),
                 ),
             ),
             FunctionParameterDecl(
                 name='rgba',
                 type=ArrayType(
                     inner_type=ValueType(name='float', is_const=True),
                     extents=(4,),
                 ),
             ),
         ),
         doc='Initialize given geom fields when not NULL, set the rest to their default values.',  # pylint: disable=line-too-long
     )),
    ('mjv_makeConnector',
     FunctionDecl(
         name='mjv_makeConnector',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='geom',
                 type=PointerType(
                     inner_type=ValueType(name='mjvGeom'),
                 ),
             ),
             FunctionParameterDecl(
                 name='type',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='width',
                 type=ValueType(name='mjtNum'),
             ),
             FunctionParameterDecl(
                 name='a0',
                 type=ValueType(name='mjtNum'),
             ),
             FunctionParameterDecl(
                 name='a1',
                 type=ValueType(name='mjtNum'),
             ),
             FunctionParameterDecl(
                 name='a2',
                 type=ValueType(name='mjtNum'),
             ),
             FunctionParameterDecl(
                 name='b0',
                 type=ValueType(name='mjtNum'),
             ),
             FunctionParameterDecl(
                 name='b1',
                 type=ValueType(name='mjtNum'),
             ),
             FunctionParameterDecl(
                 name='b2',
                 type=ValueType(name='mjtNum'),
             ),
         ),
         doc='Set (type, size, pos, mat) for connector-type geom between given points. Assume that mjv_initGeom was already called to set all other properties.',  # pylint: disable=line-too-long
     )),
    ('mjv_defaultScene',
     FunctionDecl(
         name='mjv_defaultScene',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='scn',
                 type=PointerType(
                     inner_type=ValueType(name='mjvScene'),
                 ),
             ),
         ),
         doc='Set default abstract scene.',
     )),
    ('mjv_makeScene',
     FunctionDecl(
         name='mjv_makeScene',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='scn',
                 type=PointerType(
                     inner_type=ValueType(name='mjvScene'),
                 ),
             ),
             FunctionParameterDecl(
                 name='maxgeom',
                 type=ValueType(name='int'),
             ),
         ),
         doc='Allocate resources in abstract scene.',
     )),
    ('mjv_freeScene',
     FunctionDecl(
         name='mjv_freeScene',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='scn',
                 type=PointerType(
                     inner_type=ValueType(name='mjvScene'),
                 ),
             ),
         ),
         doc='Free abstract scene.',
     )),
    ('mjv_updateScene',
     FunctionDecl(
         name='mjv_updateScene',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
             FunctionParameterDecl(
                 name='opt',
                 type=PointerType(
                     inner_type=ValueType(name='mjvOption', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='pert',
                 type=PointerType(
                     inner_type=ValueType(name='mjvPerturb', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='cam',
                 type=PointerType(
                     inner_type=ValueType(name='mjvCamera'),
                 ),
             ),
             FunctionParameterDecl(
                 name='catmask',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='scn',
                 type=PointerType(
                     inner_type=ValueType(name='mjvScene'),
                 ),
             ),
         ),
         doc='Update entire scene given model state.',
     )),
    ('mjv_addGeoms',
     FunctionDecl(
         name='mjv_addGeoms',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
             FunctionParameterDecl(
                 name='opt',
                 type=PointerType(
                     inner_type=ValueType(name='mjvOption', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='pert',
                 type=PointerType(
                     inner_type=ValueType(name='mjvPerturb', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='catmask',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='scn',
                 type=PointerType(
                     inner_type=ValueType(name='mjvScene'),
                 ),
             ),
         ),
         doc='Add geoms from selected categories.',
     )),
    ('mjv_makeLights',
     FunctionDecl(
         name='mjv_makeLights',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
             FunctionParameterDecl(
                 name='scn',
                 type=PointerType(
                     inner_type=ValueType(name='mjvScene'),
                 ),
             ),
         ),
         doc='Make list of lights.',
     )),
    ('mjv_updateCamera',
     FunctionDecl(
         name='mjv_updateCamera',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
             FunctionParameterDecl(
                 name='cam',
                 type=PointerType(
                     inner_type=ValueType(name='mjvCamera'),
                 ),
             ),
             FunctionParameterDecl(
                 name='scn',
                 type=PointerType(
                     inner_type=ValueType(name='mjvScene'),
                 ),
             ),
         ),
         doc='Update camera.',
     )),
    ('mjv_updateSkin',
     FunctionDecl(
         name='mjv_updateSkin',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
             FunctionParameterDecl(
                 name='scn',
                 type=PointerType(
                     inner_type=ValueType(name='mjvScene'),
                 ),
             ),
         ),
         doc='Update skins.',
     )),
    ('mjr_defaultContext',
     FunctionDecl(
         name='mjr_defaultContext',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='con',
                 type=PointerType(
                     inner_type=ValueType(name='mjrContext'),
                 ),
             ),
         ),
         doc='Set default mjrContext.',
     )),
    ('mjr_makeContext',
     FunctionDecl(
         name='mjr_makeContext',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='con',
                 type=PointerType(
                     inner_type=ValueType(name='mjrContext'),
                 ),
             ),
             FunctionParameterDecl(
                 name='fontscale',
                 type=ValueType(name='int'),
             ),
         ),
         doc='Allocate resources in custom OpenGL context; fontscale is mjtFontScale.',  # pylint: disable=line-too-long
     )),
    ('mjr_changeFont',
     FunctionDecl(
         name='mjr_changeFont',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='fontscale',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='con',
                 type=PointerType(
                     inner_type=ValueType(name='mjrContext'),
                 ),
             ),
         ),
         doc='Change font of existing context.',
     )),
    ('mjr_addAux',
     FunctionDecl(
         name='mjr_addAux',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='index',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='width',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='height',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='samples',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='con',
                 type=PointerType(
                     inner_type=ValueType(name='mjrContext'),
                 ),
             ),
         ),
         doc='Add Aux buffer with given index to context; free previous Aux buffer.',  # pylint: disable=line-too-long
     )),
    ('mjr_freeContext',
     FunctionDecl(
         name='mjr_freeContext',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='con',
                 type=PointerType(
                     inner_type=ValueType(name='mjrContext'),
                 ),
             ),
         ),
         doc='Free resources in custom OpenGL context, set to default.',
     )),
    ('mjr_uploadTexture',
     FunctionDecl(
         name='mjr_uploadTexture',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='con',
                 type=PointerType(
                     inner_type=ValueType(name='mjrContext', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='texid',
                 type=ValueType(name='int'),
             ),
         ),
         doc='Upload texture to GPU, overwriting previous upload if any.',
     )),
    ('mjr_uploadMesh',
     FunctionDecl(
         name='mjr_uploadMesh',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='con',
                 type=PointerType(
                     inner_type=ValueType(name='mjrContext', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='meshid',
                 type=ValueType(name='int'),
             ),
         ),
         doc='Upload mesh to GPU, overwriting previous upload if any.',
     )),
    ('mjr_uploadHField',
     FunctionDecl(
         name='mjr_uploadHField',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='con',
                 type=PointerType(
                     inner_type=ValueType(name='mjrContext', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='hfieldid',
                 type=ValueType(name='int'),
             ),
         ),
         doc='Upload height field to GPU, overwriting previous upload if any.',
     )),
    ('mjr_restoreBuffer',
     FunctionDecl(
         name='mjr_restoreBuffer',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='con',
                 type=PointerType(
                     inner_type=ValueType(name='mjrContext', is_const=True),
                 ),
             ),
         ),
         doc='Make con->currentBuffer current again.',
     )),
    ('mjr_setBuffer',
     FunctionDecl(
         name='mjr_setBuffer',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='framebuffer',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='con',
                 type=PointerType(
                     inner_type=ValueType(name='mjrContext'),
                 ),
             ),
         ),
         doc='Set OpenGL framebuffer for rendering: mjFB_WINDOW or mjFB_OFFSCREEN. If only one buffer is available, set that buffer and ignore framebuffer argument.',  # pylint: disable=line-too-long
     )),
    ('mjr_readPixels',
     FunctionDecl(
         name='mjr_readPixels',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='rgb',
                 type=PointerType(
                     inner_type=ValueType(name='unsigned char'),
                 ),
             ),
             FunctionParameterDecl(
                 name='depth',
                 type=PointerType(
                     inner_type=ValueType(name='float'),
                 ),
             ),
             FunctionParameterDecl(
                 name='viewport',
                 type=ValueType(name='mjrRect'),
             ),
             FunctionParameterDecl(
                 name='con',
                 type=PointerType(
                     inner_type=ValueType(name='mjrContext', is_const=True),
                 ),
             ),
         ),
         doc='Read pixels from current OpenGL framebuffer to client buffer. Viewport is in OpenGL framebuffer; client buffer starts at (0,0).',  # pylint: disable=line-too-long
     )),
    ('mjr_drawPixels',
     FunctionDecl(
         name='mjr_drawPixels',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='rgb',
                 type=PointerType(
                     inner_type=ValueType(name='unsigned char', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='depth',
                 type=PointerType(
                     inner_type=ValueType(name='float', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='viewport',
                 type=ValueType(name='mjrRect'),
             ),
             FunctionParameterDecl(
                 name='con',
                 type=PointerType(
                     inner_type=ValueType(name='mjrContext', is_const=True),
                 ),
             ),
         ),
         doc='Draw pixels from client buffer to current OpenGL framebuffer. Viewport is in OpenGL framebuffer; client buffer starts at (0,0).',  # pylint: disable=line-too-long
     )),
    ('mjr_blitBuffer',
     FunctionDecl(
         name='mjr_blitBuffer',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='src',
                 type=ValueType(name='mjrRect'),
             ),
             FunctionParameterDecl(
                 name='dst',
                 type=ValueType(name='mjrRect'),
             ),
             FunctionParameterDecl(
                 name='flg_color',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='flg_depth',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='con',
                 type=PointerType(
                     inner_type=ValueType(name='mjrContext', is_const=True),
                 ),
             ),
         ),
         doc='Blit from src viewpoint in current framebuffer to dst viewport in other framebuffer. If src, dst have different size and flg_depth==0, color is interpolated with GL_LINEAR.',  # pylint: disable=line-too-long
     )),
    ('mjr_setAux',
     FunctionDecl(
         name='mjr_setAux',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='index',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='con',
                 type=PointerType(
                     inner_type=ValueType(name='mjrContext', is_const=True),
                 ),
             ),
         ),
         doc='Set Aux buffer for custom OpenGL rendering (call restoreBuffer when done).',  # pylint: disable=line-too-long
     )),
    ('mjr_blitAux',
     FunctionDecl(
         name='mjr_blitAux',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='index',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='src',
                 type=ValueType(name='mjrRect'),
             ),
             FunctionParameterDecl(
                 name='left',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='bottom',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='con',
                 type=PointerType(
                     inner_type=ValueType(name='mjrContext', is_const=True),
                 ),
             ),
         ),
         doc='Blit from Aux buffer to con->currentBuffer.',
     )),
    ('mjr_text',
     FunctionDecl(
         name='mjr_text',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='font',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='txt',
                 type=PointerType(
                     inner_type=ValueType(name='char', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='con',
                 type=PointerType(
                     inner_type=ValueType(name='mjrContext', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='x',
                 type=ValueType(name='float'),
             ),
             FunctionParameterDecl(
                 name='y',
                 type=ValueType(name='float'),
             ),
             FunctionParameterDecl(
                 name='r',
                 type=ValueType(name='float'),
             ),
             FunctionParameterDecl(
                 name='g',
                 type=ValueType(name='float'),
             ),
             FunctionParameterDecl(
                 name='b',
                 type=ValueType(name='float'),
             ),
         ),
         doc='Draw text at (x,y) in relative coordinates; font is mjtFont.',
     )),
    ('mjr_overlay',
     FunctionDecl(
         name='mjr_overlay',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='font',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='gridpos',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='viewport',
                 type=ValueType(name='mjrRect'),
             ),
             FunctionParameterDecl(
                 name='overlay',
                 type=PointerType(
                     inner_type=ValueType(name='char', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='overlay2',
                 type=PointerType(
                     inner_type=ValueType(name='char', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='con',
                 type=PointerType(
                     inner_type=ValueType(name='mjrContext', is_const=True),
                 ),
             ),
         ),
         doc='Draw text overlay; font is mjtFont; gridpos is mjtGridPos.',
     )),
    ('mjr_maxViewport',
     FunctionDecl(
         name='mjr_maxViewport',
         return_type=ValueType(name='mjrRect'),
         parameters=(
             FunctionParameterDecl(
                 name='con',
                 type=PointerType(
                     inner_type=ValueType(name='mjrContext', is_const=True),
                 ),
             ),
         ),
         doc='Get maximum viewport for active buffer.',
     )),
    ('mjr_rectangle',
     FunctionDecl(
         name='mjr_rectangle',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='viewport',
                 type=ValueType(name='mjrRect'),
             ),
             FunctionParameterDecl(
                 name='r',
                 type=ValueType(name='float'),
             ),
             FunctionParameterDecl(
                 name='g',
                 type=ValueType(name='float'),
             ),
             FunctionParameterDecl(
                 name='b',
                 type=ValueType(name='float'),
             ),
             FunctionParameterDecl(
                 name='a',
                 type=ValueType(name='float'),
             ),
         ),
         doc='Draw rectangle.',
     )),
    ('mjr_label',
     FunctionDecl(
         name='mjr_label',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='viewport',
                 type=ValueType(name='mjrRect'),
             ),
             FunctionParameterDecl(
                 name='font',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='txt',
                 type=PointerType(
                     inner_type=ValueType(name='char', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='r',
                 type=ValueType(name='float'),
             ),
             FunctionParameterDecl(
                 name='g',
                 type=ValueType(name='float'),
             ),
             FunctionParameterDecl(
                 name='b',
                 type=ValueType(name='float'),
             ),
             FunctionParameterDecl(
                 name='a',
                 type=ValueType(name='float'),
             ),
             FunctionParameterDecl(
                 name='rt',
                 type=ValueType(name='float'),
             ),
             FunctionParameterDecl(
                 name='gt',
                 type=ValueType(name='float'),
             ),
             FunctionParameterDecl(
                 name='bt',
                 type=ValueType(name='float'),
             ),
             FunctionParameterDecl(
                 name='con',
                 type=PointerType(
                     inner_type=ValueType(name='mjrContext', is_const=True),
                 ),
             ),
         ),
         doc='Draw rectangle with centered text.',
     )),
    ('mjr_figure',
     FunctionDecl(
         name='mjr_figure',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='viewport',
                 type=ValueType(name='mjrRect'),
             ),
             FunctionParameterDecl(
                 name='fig',
                 type=PointerType(
                     inner_type=ValueType(name='mjvFigure'),
                 ),
             ),
             FunctionParameterDecl(
                 name='con',
                 type=PointerType(
                     inner_type=ValueType(name='mjrContext', is_const=True),
                 ),
             ),
         ),
         doc='Draw 2D figure.',
     )),
    ('mjr_render',
     FunctionDecl(
         name='mjr_render',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='viewport',
                 type=ValueType(name='mjrRect'),
             ),
             FunctionParameterDecl(
                 name='scn',
                 type=PointerType(
                     inner_type=ValueType(name='mjvScene'),
                 ),
             ),
             FunctionParameterDecl(
                 name='con',
                 type=PointerType(
                     inner_type=ValueType(name='mjrContext', is_const=True),
                 ),
             ),
         ),
         doc='Render 3D scene.',
     )),
    ('mjr_finish',
     FunctionDecl(
         name='mjr_finish',
         return_type=ValueType(name='void'),
         parameters=(),
         doc='Call glFinish.',
     )),
    ('mjr_getError',
     FunctionDecl(
         name='mjr_getError',
         return_type=ValueType(name='int'),
         parameters=(),
         doc='Call glGetError and return result.',
     )),
    ('mjr_findRect',
     FunctionDecl(
         name='mjr_findRect',
         return_type=ValueType(name='int'),
         parameters=(
             FunctionParameterDecl(
                 name='x',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='y',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='nrect',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='rect',
                 type=PointerType(
                     inner_type=ValueType(name='mjrRect', is_const=True),
                 ),
             ),
         ),
         doc='Find first rectangle containing mouse, -1: not found.',
     )),
    ('mjui_themeSpacing',
     FunctionDecl(
         name='mjui_themeSpacing',
         return_type=ValueType(name='mjuiThemeSpacing'),
         parameters=(
             FunctionParameterDecl(
                 name='ind',
                 type=ValueType(name='int'),
             ),
         ),
         doc='Get builtin UI theme spacing (ind: 0-1).',
     )),
    ('mjui_themeColor',
     FunctionDecl(
         name='mjui_themeColor',
         return_type=ValueType(name='mjuiThemeColor'),
         parameters=(
             FunctionParameterDecl(
                 name='ind',
                 type=ValueType(name='int'),
             ),
         ),
         doc='Get builtin UI theme color (ind: 0-3).',
     )),
    ('mjui_add',
     FunctionDecl(
         name='mjui_add',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='ui',
                 type=PointerType(
                     inner_type=ValueType(name='mjUI'),
                 ),
             ),
             FunctionParameterDecl(
                 name='def',
                 type=PointerType(
                     inner_type=ValueType(name='mjuiDef', is_const=True),
                 ),
             ),
         ),
         doc='Add definitions to UI.',
     )),
    ('mjui_addToSection',
     FunctionDecl(
         name='mjui_addToSection',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='ui',
                 type=PointerType(
                     inner_type=ValueType(name='mjUI'),
                 ),
             ),
             FunctionParameterDecl(
                 name='sect',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='def',
                 type=PointerType(
                     inner_type=ValueType(name='mjuiDef', is_const=True),
                 ),
             ),
         ),
         doc='Add definitions to UI section.',
     )),
    ('mjui_resize',
     FunctionDecl(
         name='mjui_resize',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='ui',
                 type=PointerType(
                     inner_type=ValueType(name='mjUI'),
                 ),
             ),
             FunctionParameterDecl(
                 name='con',
                 type=PointerType(
                     inner_type=ValueType(name='mjrContext', is_const=True),
                 ),
             ),
         ),
         doc='Compute UI sizes.',
     )),
    ('mjui_update',
     FunctionDecl(
         name='mjui_update',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='section',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='item',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='ui',
                 type=PointerType(
                     inner_type=ValueType(name='mjUI', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='state',
                 type=PointerType(
                     inner_type=ValueType(name='mjuiState', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='con',
                 type=PointerType(
                     inner_type=ValueType(name='mjrContext', is_const=True),
                 ),
             ),
         ),
         doc='Update specific section/item; -1: update all.',
     )),
    ('mjui_event',
     FunctionDecl(
         name='mjui_event',
         return_type=PointerType(
             inner_type=ValueType(name='mjuiItem'),
         ),
         parameters=(
             FunctionParameterDecl(
                 name='ui',
                 type=PointerType(
                     inner_type=ValueType(name='mjUI'),
                 ),
             ),
             FunctionParameterDecl(
                 name='state',
                 type=PointerType(
                     inner_type=ValueType(name='mjuiState'),
                 ),
             ),
             FunctionParameterDecl(
                 name='con',
                 type=PointerType(
                     inner_type=ValueType(name='mjrContext', is_const=True),
                 ),
             ),
         ),
         doc='Handle UI event, return pointer to changed item, NULL if no change.',  # pylint: disable=line-too-long
     )),
    ('mjui_render',
     FunctionDecl(
         name='mjui_render',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='ui',
                 type=PointerType(
                     inner_type=ValueType(name='mjUI'),
                 ),
             ),
             FunctionParameterDecl(
                 name='state',
                 type=PointerType(
                     inner_type=ValueType(name='mjuiState', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='con',
                 type=PointerType(
                     inner_type=ValueType(name='mjrContext', is_const=True),
                 ),
             ),
         ),
         doc='Copy UI image to current buffer.',
     )),
    ('mju_error',
     FunctionDecl(
         name='mju_error',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='msg',
                 type=PointerType(
                     inner_type=ValueType(name='char', is_const=True),
                 ),
             ),
         ),
         doc='Main error function; does not return to caller.',
     )),
    ('mju_error_i',
     FunctionDecl(
         name='mju_error_i',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='msg',
                 type=PointerType(
                     inner_type=ValueType(name='char', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='i',
                 type=ValueType(name='int'),
             ),
         ),
         doc='Error function with int argument; msg is a printf format string.',
     )),
    ('mju_error_s',
     FunctionDecl(
         name='mju_error_s',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='msg',
                 type=PointerType(
                     inner_type=ValueType(name='char', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='text',
                 type=PointerType(
                     inner_type=ValueType(name='char', is_const=True),
                 ),
             ),
         ),
         doc='Error function with string argument.',
     )),
    ('mju_warning',
     FunctionDecl(
         name='mju_warning',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='msg',
                 type=PointerType(
                     inner_type=ValueType(name='char', is_const=True),
                 ),
             ),
         ),
         doc='Main warning function; returns to caller.',
     )),
    ('mju_warning_i',
     FunctionDecl(
         name='mju_warning_i',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='msg',
                 type=PointerType(
                     inner_type=ValueType(name='char', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='i',
                 type=ValueType(name='int'),
             ),
         ),
         doc='Warning function with int argument.',
     )),
    ('mju_warning_s',
     FunctionDecl(
         name='mju_warning_s',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='msg',
                 type=PointerType(
                     inner_type=ValueType(name='char', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='text',
                 type=PointerType(
                     inner_type=ValueType(name='char', is_const=True),
                 ),
             ),
         ),
         doc='Warning function with string argument.',
     )),
    ('mju_clearHandlers',
     FunctionDecl(
         name='mju_clearHandlers',
         return_type=ValueType(name='void'),
         parameters=(),
         doc='Clear user error and memory handlers.',
     )),
    ('mju_malloc',
     FunctionDecl(
         name='mju_malloc',
         return_type=PointerType(
             inner_type=ValueType(name='void'),
         ),
         parameters=(
             FunctionParameterDecl(
                 name='size',
                 type=ValueType(name='size_t'),
             ),
         ),
         doc='Allocate memory; byte-align on 64; pad size to multiple of 64.',
     )),
    ('mju_free',
     FunctionDecl(
         name='mju_free',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='ptr',
                 type=PointerType(
                     inner_type=ValueType(name='void'),
                 ),
             ),
         ),
         doc='Free memory, using free() by default.',
     )),
    ('mj_warning',
     FunctionDecl(
         name='mj_warning',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
             FunctionParameterDecl(
                 name='warning',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='info',
                 type=ValueType(name='int'),
             ),
         ),
         doc='High-level warning function: count warnings in mjData, print only the first.',  # pylint: disable=line-too-long
     )),
    ('mju_writeLog',
     FunctionDecl(
         name='mju_writeLog',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='type',
                 type=PointerType(
                     inner_type=ValueType(name='char', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='msg',
                 type=PointerType(
                     inner_type=ValueType(name='char', is_const=True),
                 ),
             ),
         ),
         doc='Write [datetime, type: message] to MUJOCO_LOG.TXT.',
     )),
    ('mj_activate',
     FunctionDecl(
         name='mj_activate',
         return_type=ValueType(name='int'),
         parameters=(
             FunctionParameterDecl(
                 name='filename',
                 type=PointerType(
                     inner_type=ValueType(name='char', is_const=True),
                 ),
             ),
         ),
         doc='Return 1 (for backward compatibility).',
     )),
    ('mj_deactivate',
     FunctionDecl(
         name='mj_deactivate',
         return_type=ValueType(name='void'),
         parameters=(),
         doc='Do nothing (for backward compatibility).',
     )),
    ('mju_zero3',
     FunctionDecl(
         name='mju_zero3',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='res',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum'),
                     extents=(3,),
                 ),
             ),
         ),
         doc='Set res = 0.',
     )),
    ('mju_copy3',
     FunctionDecl(
         name='mju_copy3',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='res',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum'),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='data',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(3,),
                 ),
             ),
         ),
         doc='Set res = vec.',
     )),
    ('mju_scl3',
     FunctionDecl(
         name='mju_scl3',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='res',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum'),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='vec',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='scl',
                 type=ValueType(name='mjtNum'),
             ),
         ),
         doc='Set res = vec*scl.',
     )),
    ('mju_add3',
     FunctionDecl(
         name='mju_add3',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='res',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum'),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='vec1',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='vec2',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(3,),
                 ),
             ),
         ),
         doc='Set res = vec1 + vec2.',
     )),
    ('mju_sub3',
     FunctionDecl(
         name='mju_sub3',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='res',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum'),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='vec1',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='vec2',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(3,),
                 ),
             ),
         ),
         doc='Set res = vec1 - vec2.',
     )),
    ('mju_addTo3',
     FunctionDecl(
         name='mju_addTo3',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='res',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum'),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='vec',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(3,),
                 ),
             ),
         ),
         doc='Set res = res + vec.',
     )),
    ('mju_subFrom3',
     FunctionDecl(
         name='mju_subFrom3',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='res',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum'),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='vec',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(3,),
                 ),
             ),
         ),
         doc='Set res = res - vec.',
     )),
    ('mju_addToScl3',
     FunctionDecl(
         name='mju_addToScl3',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='res',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum'),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='vec',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='scl',
                 type=ValueType(name='mjtNum'),
             ),
         ),
         doc='Set res = res + vec*scl.',
     )),
    ('mju_addScl3',
     FunctionDecl(
         name='mju_addScl3',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='res',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum'),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='vec1',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='vec2',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='scl',
                 type=ValueType(name='mjtNum'),
             ),
         ),
         doc='Set res = vec1 + vec2*scl.',
     )),
    ('mju_normalize3',
     FunctionDecl(
         name='mju_normalize3',
         return_type=ValueType(name='mjtNum'),
         parameters=(
             FunctionParameterDecl(
                 name='res',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum'),
                     extents=(3,),
                 ),
             ),
         ),
         doc='Normalize vector, return length before normalization.',
     )),
    ('mju_norm3',
     FunctionDecl(
         name='mju_norm3',
         return_type=ValueType(name='mjtNum'),
         parameters=(
             FunctionParameterDecl(
                 name='vec',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(3,),
                 ),
             ),
         ),
         doc='Return vector length (without normalizing the vector).',
     )),
    ('mju_dot3',
     FunctionDecl(
         name='mju_dot3',
         return_type=ValueType(name='mjtNum'),
         parameters=(
             FunctionParameterDecl(
                 name='vec1',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='vec2',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(3,),
                 ),
             ),
         ),
         doc='Return dot-product of vec1 and vec2.',
     )),
    ('mju_dist3',
     FunctionDecl(
         name='mju_dist3',
         return_type=ValueType(name='mjtNum'),
         parameters=(
             FunctionParameterDecl(
                 name='pos1',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='pos2',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(3,),
                 ),
             ),
         ),
         doc='Return Cartesian distance between 3D vectors pos1 and pos2.',
     )),
    ('mju_rotVecMat',
     FunctionDecl(
         name='mju_rotVecMat',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='res',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum'),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='vec',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='mat',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(9,),
                 ),
             ),
         ),
         doc='Multiply vector by 3D rotation matrix: res = mat * vec.',
     )),
    ('mju_rotVecMatT',
     FunctionDecl(
         name='mju_rotVecMatT',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='res',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum'),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='vec',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='mat',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(9,),
                 ),
             ),
         ),
         doc="Multiply vector by transposed 3D rotation matrix: res = mat' * vec.",  # pylint: disable=line-too-long
     )),
    ('mju_cross',
     FunctionDecl(
         name='mju_cross',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='res',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum'),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='a',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='b',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(3,),
                 ),
             ),
         ),
         doc='Compute cross-product: res = cross(a, b).',
     )),
    ('mju_zero4',
     FunctionDecl(
         name='mju_zero4',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='res',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum'),
                     extents=(4,),
                 ),
             ),
         ),
         doc='Set res = 0.',
     )),
    ('mju_unit4',
     FunctionDecl(
         name='mju_unit4',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='res',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum'),
                     extents=(4,),
                 ),
             ),
         ),
         doc='Set res = (1,0,0,0).',
     )),
    ('mju_copy4',
     FunctionDecl(
         name='mju_copy4',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='res',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum'),
                     extents=(4,),
                 ),
             ),
             FunctionParameterDecl(
                 name='data',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(4,),
                 ),
             ),
         ),
         doc='Set res = vec.',
     )),
    ('mju_normalize4',
     FunctionDecl(
         name='mju_normalize4',
         return_type=ValueType(name='mjtNum'),
         parameters=(
             FunctionParameterDecl(
                 name='res',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum'),
                     extents=(4,),
                 ),
             ),
         ),
         doc='Normalize vector, return length before normalization.',
     )),
    ('mju_zero',
     FunctionDecl(
         name='mju_zero',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='res',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum'),
                 ),
             ),
             FunctionParameterDecl(
                 name='n',
                 type=ValueType(name='int'),
             ),
         ),
         doc='Set res = 0.',
     )),
    ('mju_copy',
     FunctionDecl(
         name='mju_copy',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='res',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum'),
                 ),
             ),
             FunctionParameterDecl(
                 name='data',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='n',
                 type=ValueType(name='int'),
             ),
         ),
         doc='Set res = vec.',
     )),
    ('mju_sum',
     FunctionDecl(
         name='mju_sum',
         return_type=ValueType(name='mjtNum'),
         parameters=(
             FunctionParameterDecl(
                 name='vec',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='n',
                 type=ValueType(name='int'),
             ),
         ),
         doc='Return sum(vec).',
     )),
    ('mju_L1',
     FunctionDecl(
         name='mju_L1',
         return_type=ValueType(name='mjtNum'),
         parameters=(
             FunctionParameterDecl(
                 name='vec',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='n',
                 type=ValueType(name='int'),
             ),
         ),
         doc='Return L1 norm: sum(abs(vec)).',
     )),
    ('mju_scl',
     FunctionDecl(
         name='mju_scl',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='res',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum'),
                 ),
             ),
             FunctionParameterDecl(
                 name='vec',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='scl',
                 type=ValueType(name='mjtNum'),
             ),
             FunctionParameterDecl(
                 name='n',
                 type=ValueType(name='int'),
             ),
         ),
         doc='Set res = vec*scl.',
     )),
    ('mju_add',
     FunctionDecl(
         name='mju_add',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='res',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum'),
                 ),
             ),
             FunctionParameterDecl(
                 name='vec1',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='vec2',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='n',
                 type=ValueType(name='int'),
             ),
         ),
         doc='Set res = vec1 + vec2.',
     )),
    ('mju_sub',
     FunctionDecl(
         name='mju_sub',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='res',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum'),
                 ),
             ),
             FunctionParameterDecl(
                 name='vec1',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='vec2',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='n',
                 type=ValueType(name='int'),
             ),
         ),
         doc='Set res = vec1 - vec2.',
     )),
    ('mju_addTo',
     FunctionDecl(
         name='mju_addTo',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='res',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum'),
                 ),
             ),
             FunctionParameterDecl(
                 name='vec',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='n',
                 type=ValueType(name='int'),
             ),
         ),
         doc='Set res = res + vec.',
     )),
    ('mju_subFrom',
     FunctionDecl(
         name='mju_subFrom',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='res',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum'),
                 ),
             ),
             FunctionParameterDecl(
                 name='vec',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='n',
                 type=ValueType(name='int'),
             ),
         ),
         doc='Set res = res - vec.',
     )),
    ('mju_addToScl',
     FunctionDecl(
         name='mju_addToScl',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='res',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum'),
                 ),
             ),
             FunctionParameterDecl(
                 name='vec',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='scl',
                 type=ValueType(name='mjtNum'),
             ),
             FunctionParameterDecl(
                 name='n',
                 type=ValueType(name='int'),
             ),
         ),
         doc='Set res = res + vec*scl.',
     )),
    ('mju_addScl',
     FunctionDecl(
         name='mju_addScl',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='res',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum'),
                 ),
             ),
             FunctionParameterDecl(
                 name='vec1',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='vec2',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='scl',
                 type=ValueType(name='mjtNum'),
             ),
             FunctionParameterDecl(
                 name='n',
                 type=ValueType(name='int'),
             ),
         ),
         doc='Set res = vec1 + vec2*scl.',
     )),
    ('mju_normalize',
     FunctionDecl(
         name='mju_normalize',
         return_type=ValueType(name='mjtNum'),
         parameters=(
             FunctionParameterDecl(
                 name='res',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum'),
                 ),
             ),
             FunctionParameterDecl(
                 name='n',
                 type=ValueType(name='int'),
             ),
         ),
         doc='Normalize vector, return length before normalization.',
     )),
    ('mju_norm',
     FunctionDecl(
         name='mju_norm',
         return_type=ValueType(name='mjtNum'),
         parameters=(
             FunctionParameterDecl(
                 name='res',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='n',
                 type=ValueType(name='int'),
             ),
         ),
         doc='Return vector length (without normalizing vector).',
     )),
    ('mju_dot',
     FunctionDecl(
         name='mju_dot',
         return_type=ValueType(name='mjtNum'),
         parameters=(
             FunctionParameterDecl(
                 name='vec1',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='vec2',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='n',
                 type=ValueType(name='int', is_const=True),
             ),
         ),
         doc='Return dot-product of vec1 and vec2.',
     )),
    ('mju_mulMatVec',
     FunctionDecl(
         name='mju_mulMatVec',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='res',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum'),
                 ),
             ),
             FunctionParameterDecl(
                 name='mat',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='vec',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='nr',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='nc',
                 type=ValueType(name='int'),
             ),
         ),
         doc='Multiply matrix and vector: res = mat * vec.',
     )),
    ('mju_mulMatTVec',
     FunctionDecl(
         name='mju_mulMatTVec',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='res',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum'),
                 ),
             ),
             FunctionParameterDecl(
                 name='mat',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='vec',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='nr',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='nc',
                 type=ValueType(name='int'),
             ),
         ),
         doc="Multiply transposed matrix and vector: res = mat' * vec.",
     )),
    ('mju_transpose',
     FunctionDecl(
         name='mju_transpose',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='res',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum'),
                 ),
             ),
             FunctionParameterDecl(
                 name='mat',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='nr',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='nc',
                 type=ValueType(name='int'),
             ),
         ),
         doc="Transpose matrix: res = mat'.",
     )),
    ('mju_mulMatMat',
     FunctionDecl(
         name='mju_mulMatMat',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='res',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum'),
                 ),
             ),
             FunctionParameterDecl(
                 name='mat1',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='mat2',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='r1',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='c1',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='c2',
                 type=ValueType(name='int'),
             ),
         ),
         doc='Multiply matrices: res = mat1 * mat2.',
     )),
    ('mju_mulMatMatT',
     FunctionDecl(
         name='mju_mulMatMatT',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='res',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum'),
                 ),
             ),
             FunctionParameterDecl(
                 name='mat1',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='mat2',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='r1',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='c1',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='r2',
                 type=ValueType(name='int'),
             ),
         ),
         doc="Multiply matrices, second argument transposed: res = mat1 * mat2'.",  # pylint: disable=line-too-long
     )),
    ('mju_mulMatTMat',
     FunctionDecl(
         name='mju_mulMatTMat',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='res',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum'),
                 ),
             ),
             FunctionParameterDecl(
                 name='mat1',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='mat2',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='r1',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='c1',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='c2',
                 type=ValueType(name='int'),
             ),
         ),
         doc="Multiply matrices, first argument transposed: res = mat1' * mat2.",  # pylint: disable=line-too-long
     )),
    ('mju_sqrMatTD',
     FunctionDecl(
         name='mju_sqrMatTD',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='res',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum'),
                 ),
             ),
             FunctionParameterDecl(
                 name='mat',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='diag',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='nr',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='nc',
                 type=ValueType(name='int'),
             ),
         ),
         doc="Set res = mat' * diag * mat if diag is not NULL, and res = mat' * mat otherwise.",  # pylint: disable=line-too-long
     )),
    ('mju_transformSpatial',
     FunctionDecl(
         name='mju_transformSpatial',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='res',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum'),
                     extents=(6,),
                 ),
             ),
             FunctionParameterDecl(
                 name='vec',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(6,),
                 ),
             ),
             FunctionParameterDecl(
                 name='flg_force',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='newpos',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='oldpos',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='rotnew2old',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(9,),
                 ),
             ),
         ),
         doc='Coordinate transform of 6D motion or force vector in rotation:translation format. rotnew2old is 3-by-3, NULL means no rotation; flg_force specifies force or motion type.',  # pylint: disable=line-too-long
     )),
    ('mju_rotVecQuat',
     FunctionDecl(
         name='mju_rotVecQuat',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='res',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum'),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='vec',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='quat',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(4,),
                 ),
             ),
         ),
         doc='Rotate vector by quaternion.',
     )),
    ('mju_negQuat',
     FunctionDecl(
         name='mju_negQuat',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='res',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum'),
                     extents=(4,),
                 ),
             ),
             FunctionParameterDecl(
                 name='quat',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(4,),
                 ),
             ),
         ),
         doc='Conjugate quaternion, corresponding to opposite rotation.',
     )),
    ('mju_mulQuat',
     FunctionDecl(
         name='mju_mulQuat',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='res',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum'),
                     extents=(4,),
                 ),
             ),
             FunctionParameterDecl(
                 name='quat1',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(4,),
                 ),
             ),
             FunctionParameterDecl(
                 name='quat2',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(4,),
                 ),
             ),
         ),
         doc='Multiply quaternions.',
     )),
    ('mju_mulQuatAxis',
     FunctionDecl(
         name='mju_mulQuatAxis',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='res',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum'),
                     extents=(4,),
                 ),
             ),
             FunctionParameterDecl(
                 name='quat',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(4,),
                 ),
             ),
             FunctionParameterDecl(
                 name='axis',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(3,),
                 ),
             ),
         ),
         doc='Multiply quaternion and axis.',
     )),
    ('mju_axisAngle2Quat',
     FunctionDecl(
         name='mju_axisAngle2Quat',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='res',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum'),
                     extents=(4,),
                 ),
             ),
             FunctionParameterDecl(
                 name='axis',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='angle',
                 type=ValueType(name='mjtNum'),
             ),
         ),
         doc='Convert axisAngle to quaternion.',
     )),
    ('mju_quat2Vel',
     FunctionDecl(
         name='mju_quat2Vel',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='res',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum'),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='quat',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(4,),
                 ),
             ),
             FunctionParameterDecl(
                 name='dt',
                 type=ValueType(name='mjtNum'),
             ),
         ),
         doc='Convert quaternion (corresponding to orientation difference) to 3D velocity.',  # pylint: disable=line-too-long
     )),
    ('mju_subQuat',
     FunctionDecl(
         name='mju_subQuat',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='res',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum'),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='qa',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(4,),
                 ),
             ),
             FunctionParameterDecl(
                 name='qb',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(4,),
                 ),
             ),
         ),
         doc='Subtract quaternions, express as 3D velocity: qb*quat(res) = qa.',
     )),
    ('mju_quat2Mat',
     FunctionDecl(
         name='mju_quat2Mat',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='res',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum'),
                     extents=(9,),
                 ),
             ),
             FunctionParameterDecl(
                 name='quat',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(4,),
                 ),
             ),
         ),
         doc='Convert quaternion to 3D rotation matrix.',
     )),
    ('mju_mat2Quat',
     FunctionDecl(
         name='mju_mat2Quat',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='quat',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum'),
                     extents=(4,),
                 ),
             ),
             FunctionParameterDecl(
                 name='mat',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(9,),
                 ),
             ),
         ),
         doc='Convert 3D rotation matrix to quaternion.',
     )),
    ('mju_derivQuat',
     FunctionDecl(
         name='mju_derivQuat',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='res',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum'),
                     extents=(4,),
                 ),
             ),
             FunctionParameterDecl(
                 name='quat',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(4,),
                 ),
             ),
             FunctionParameterDecl(
                 name='vel',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(3,),
                 ),
             ),
         ),
         doc='Compute time-derivative of quaternion, given 3D rotational velocity.',  # pylint: disable=line-too-long
     )),
    ('mju_quatIntegrate',
     FunctionDecl(
         name='mju_quatIntegrate',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='quat',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum'),
                     extents=(4,),
                 ),
             ),
             FunctionParameterDecl(
                 name='vel',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='scale',
                 type=ValueType(name='mjtNum'),
             ),
         ),
         doc='Integrate quaternion given 3D angular velocity.',
     )),
    ('mju_quatZ2Vec',
     FunctionDecl(
         name='mju_quatZ2Vec',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='quat',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum'),
                     extents=(4,),
                 ),
             ),
             FunctionParameterDecl(
                 name='vec',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(3,),
                 ),
             ),
         ),
         doc='Construct quaternion performing rotation from z-axis to given vector.',  # pylint: disable=line-too-long
     )),
    ('mju_mulPose',
     FunctionDecl(
         name='mju_mulPose',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='posres',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum'),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='quatres',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum'),
                     extents=(4,),
                 ),
             ),
             FunctionParameterDecl(
                 name='pos1',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='quat1',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(4,),
                 ),
             ),
             FunctionParameterDecl(
                 name='pos2',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='quat2',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(4,),
                 ),
             ),
         ),
         doc='Multiply two poses.',
     )),
    ('mju_negPose',
     FunctionDecl(
         name='mju_negPose',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='posres',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum'),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='quatres',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum'),
                     extents=(4,),
                 ),
             ),
             FunctionParameterDecl(
                 name='pos',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='quat',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(4,),
                 ),
             ),
         ),
         doc='Conjugate pose, corresponding to the opposite spatial transformation.',  # pylint: disable=line-too-long
     )),
    ('mju_trnVecPose',
     FunctionDecl(
         name='mju_trnVecPose',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='res',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum'),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='pos',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='quat',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(4,),
                 ),
             ),
             FunctionParameterDecl(
                 name='vec',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(3,),
                 ),
             ),
         ),
         doc='Transform vector by pose.',
     )),
    ('mju_cholFactor',
     FunctionDecl(
         name='mju_cholFactor',
         return_type=ValueType(name='int'),
         parameters=(
             FunctionParameterDecl(
                 name='mat',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum'),
                 ),
             ),
             FunctionParameterDecl(
                 name='n',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='mindiag',
                 type=ValueType(name='mjtNum'),
             ),
         ),
         doc="Cholesky decomposition: mat = L*L'; return rank, decomposition performed in-place into mat.",  # pylint: disable=line-too-long
     )),
    ('mju_cholSolve',
     FunctionDecl(
         name='mju_cholSolve',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='res',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum'),
                 ),
             ),
             FunctionParameterDecl(
                 name='mat',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='vec',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='n',
                 type=ValueType(name='int'),
             ),
         ),
         doc='Solve mat * res = vec, where mat is Cholesky-factorized',
     )),
    ('mju_cholUpdate',
     FunctionDecl(
         name='mju_cholUpdate',
         return_type=ValueType(name='int'),
         parameters=(
             FunctionParameterDecl(
                 name='mat',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum'),
                 ),
             ),
             FunctionParameterDecl(
                 name='x',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum'),
                 ),
             ),
             FunctionParameterDecl(
                 name='n',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='flg_plus',
                 type=ValueType(name='int'),
             ),
         ),
         doc="Cholesky rank-one update: L*L' +/- x*x'; return rank.",
     )),
    ('mju_eig3',
     FunctionDecl(
         name='mju_eig3',
         return_type=ValueType(name='int'),
         parameters=(
             FunctionParameterDecl(
                 name='eigval',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum'),
                     extents=(3,),
                 ),
             ),
             FunctionParameterDecl(
                 name='eigvec',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum'),
                     extents=(9,),
                 ),
             ),
             FunctionParameterDecl(
                 name='quat',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum'),
                     extents=(4,),
                 ),
             ),
             FunctionParameterDecl(
                 name='mat',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(9,),
                 ),
             ),
         ),
         doc='Eigenvalue decomposition of symmetric 3x3 matrix.',
     )),
    ('mju_muscleGain',
     FunctionDecl(
         name='mju_muscleGain',
         return_type=ValueType(name='mjtNum'),
         parameters=(
             FunctionParameterDecl(
                 name='len',
                 type=ValueType(name='mjtNum'),
             ),
             FunctionParameterDecl(
                 name='vel',
                 type=ValueType(name='mjtNum'),
             ),
             FunctionParameterDecl(
                 name='lengthrange',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(2,),
                 ),
             ),
             FunctionParameterDecl(
                 name='acc0',
                 type=ValueType(name='mjtNum'),
             ),
             FunctionParameterDecl(
                 name='prm',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(9,),
                 ),
             ),
         ),
         doc='Muscle active force, prm = (range[2], force, scale, lmin, lmax, vmax, fpmax, fvmax).',  # pylint: disable=line-too-long
     )),
    ('mju_muscleBias',
     FunctionDecl(
         name='mju_muscleBias',
         return_type=ValueType(name='mjtNum'),
         parameters=(
             FunctionParameterDecl(
                 name='len',
                 type=ValueType(name='mjtNum'),
             ),
             FunctionParameterDecl(
                 name='lengthrange',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(2,),
                 ),
             ),
             FunctionParameterDecl(
                 name='acc0',
                 type=ValueType(name='mjtNum'),
             ),
             FunctionParameterDecl(
                 name='prm',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(9,),
                 ),
             ),
         ),
         doc='Muscle passive force, prm = (range[2], force, scale, lmin, lmax, vmax, fpmax, fvmax).',  # pylint: disable=line-too-long
     )),
    ('mju_muscleDynamics',
     FunctionDecl(
         name='mju_muscleDynamics',
         return_type=ValueType(name='mjtNum'),
         parameters=(
             FunctionParameterDecl(
                 name='ctrl',
                 type=ValueType(name='mjtNum'),
             ),
             FunctionParameterDecl(
                 name='act',
                 type=ValueType(name='mjtNum'),
             ),
             FunctionParameterDecl(
                 name='prm',
                 type=ArrayType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                     extents=(2,),
                 ),
             ),
         ),
         doc='Muscle activation dynamics, prm = (tau_act, tau_deact).',
     )),
    ('mju_encodePyramid',
     FunctionDecl(
         name='mju_encodePyramid',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='pyramid',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum'),
                 ),
             ),
             FunctionParameterDecl(
                 name='force',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='mu',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='dim',
                 type=ValueType(name='int'),
             ),
         ),
         doc='Convert contact force to pyramid representation.',
     )),
    ('mju_decodePyramid',
     FunctionDecl(
         name='mju_decodePyramid',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='force',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum'),
                 ),
             ),
             FunctionParameterDecl(
                 name='pyramid',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='mu',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='dim',
                 type=ValueType(name='int'),
             ),
         ),
         doc='Convert pyramid representation to contact force.',
     )),
    ('mju_springDamper',
     FunctionDecl(
         name='mju_springDamper',
         return_type=ValueType(name='mjtNum'),
         parameters=(
             FunctionParameterDecl(
                 name='pos0',
                 type=ValueType(name='mjtNum'),
             ),
             FunctionParameterDecl(
                 name='vel0',
                 type=ValueType(name='mjtNum'),
             ),
             FunctionParameterDecl(
                 name='Kp',
                 type=ValueType(name='mjtNum'),
             ),
             FunctionParameterDecl(
                 name='Kv',
                 type=ValueType(name='mjtNum'),
             ),
             FunctionParameterDecl(
                 name='dt',
                 type=ValueType(name='mjtNum'),
             ),
         ),
         doc='Integrate spring-damper analytically, return pos(dt).',
     )),
    ('mju_min',
     FunctionDecl(
         name='mju_min',
         return_type=ValueType(name='mjtNum'),
         parameters=(
             FunctionParameterDecl(
                 name='a',
                 type=ValueType(name='mjtNum'),
             ),
             FunctionParameterDecl(
                 name='b',
                 type=ValueType(name='mjtNum'),
             ),
         ),
         doc='Return min(a,b) with single evaluation of a and b.',
     )),
    ('mju_max',
     FunctionDecl(
         name='mju_max',
         return_type=ValueType(name='mjtNum'),
         parameters=(
             FunctionParameterDecl(
                 name='a',
                 type=ValueType(name='mjtNum'),
             ),
             FunctionParameterDecl(
                 name='b',
                 type=ValueType(name='mjtNum'),
             ),
         ),
         doc='Return max(a,b) with single evaluation of a and b.',
     )),
    ('mju_clip',
     FunctionDecl(
         name='mju_clip',
         return_type=ValueType(name='mjtNum'),
         parameters=(
             FunctionParameterDecl(
                 name='x',
                 type=ValueType(name='mjtNum'),
             ),
             FunctionParameterDecl(
                 name='min',
                 type=ValueType(name='mjtNum'),
             ),
             FunctionParameterDecl(
                 name='max',
                 type=ValueType(name='mjtNum'),
             ),
         ),
         doc='Clip x to the range [min, max].',
     )),
    ('mju_sign',
     FunctionDecl(
         name='mju_sign',
         return_type=ValueType(name='mjtNum'),
         parameters=(
             FunctionParameterDecl(
                 name='x',
                 type=ValueType(name='mjtNum'),
             ),
         ),
         doc='Return sign of x: +1, -1 or 0.',
     )),
    ('mju_round',
     FunctionDecl(
         name='mju_round',
         return_type=ValueType(name='int'),
         parameters=(
             FunctionParameterDecl(
                 name='x',
                 type=ValueType(name='mjtNum'),
             ),
         ),
         doc='Round x to nearest integer.',
     )),
    ('mju_type2Str',
     FunctionDecl(
         name='mju_type2Str',
         return_type=PointerType(
             inner_type=ValueType(name='char', is_const=True),
         ),
         parameters=(
             FunctionParameterDecl(
                 name='type',
                 type=ValueType(name='int'),
             ),
         ),
         doc='Convert type id (mjtObj) to type name.',
     )),
    ('mju_str2Type',
     FunctionDecl(
         name='mju_str2Type',
         return_type=ValueType(name='int'),
         parameters=(
             FunctionParameterDecl(
                 name='str',
                 type=PointerType(
                     inner_type=ValueType(name='char', is_const=True),
                 ),
             ),
         ),
         doc='Convert type name to type id (mjtObj).',
     )),
    ('mju_warningText',
     FunctionDecl(
         name='mju_warningText',
         return_type=PointerType(
             inner_type=ValueType(name='char', is_const=True),
         ),
         parameters=(
             FunctionParameterDecl(
                 name='warning',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='info',
                 type=ValueType(name='int'),
             ),
         ),
         doc='Construct a warning message given the warning type and info.',
     )),
    ('mju_isBad',
     FunctionDecl(
         name='mju_isBad',
         return_type=ValueType(name='int'),
         parameters=(
             FunctionParameterDecl(
                 name='x',
                 type=ValueType(name='mjtNum'),
             ),
         ),
         doc='Return 1 if nan or abs(x)>mjMAXVAL, 0 otherwise. Used by check functions.',  # pylint: disable=line-too-long
     )),
    ('mju_isZero',
     FunctionDecl(
         name='mju_isZero',
         return_type=ValueType(name='int'),
         parameters=(
             FunctionParameterDecl(
                 name='vec',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum'),
                 ),
             ),
             FunctionParameterDecl(
                 name='n',
                 type=ValueType(name='int'),
             ),
         ),
         doc='Return 1 if all elements are 0.',
     )),
    ('mju_standardNormal',
     FunctionDecl(
         name='mju_standardNormal',
         return_type=ValueType(name='mjtNum'),
         parameters=(
             FunctionParameterDecl(
                 name='num2',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum'),
                 ),
             ),
         ),
         doc='Standard normal random number generator (optional second number).',  # pylint: disable=line-too-long
     )),
    ('mju_f2n',
     FunctionDecl(
         name='mju_f2n',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='res',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum'),
                 ),
             ),
             FunctionParameterDecl(
                 name='vec',
                 type=PointerType(
                     inner_type=ValueType(name='float', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='n',
                 type=ValueType(name='int'),
             ),
         ),
         doc='Convert from float to mjtNum.',
     )),
    ('mju_n2f',
     FunctionDecl(
         name='mju_n2f',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='res',
                 type=PointerType(
                     inner_type=ValueType(name='float'),
                 ),
             ),
             FunctionParameterDecl(
                 name='vec',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='n',
                 type=ValueType(name='int'),
             ),
         ),
         doc='Convert from mjtNum to float.',
     )),
    ('mju_d2n',
     FunctionDecl(
         name='mju_d2n',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='res',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum'),
                 ),
             ),
             FunctionParameterDecl(
                 name='vec',
                 type=PointerType(
                     inner_type=ValueType(name='double', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='n',
                 type=ValueType(name='int'),
             ),
         ),
         doc='Convert from double to mjtNum.',
     )),
    ('mju_n2d',
     FunctionDecl(
         name='mju_n2d',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='res',
                 type=PointerType(
                     inner_type=ValueType(name='double'),
                 ),
             ),
             FunctionParameterDecl(
                 name='vec',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='n',
                 type=ValueType(name='int'),
             ),
         ),
         doc='Convert from mjtNum to double.',
     )),
    ('mju_insertionSort',
     FunctionDecl(
         name='mju_insertionSort',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='list',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum'),
                 ),
             ),
             FunctionParameterDecl(
                 name='n',
                 type=ValueType(name='int'),
             ),
         ),
         doc='Insertion sort, resulting list is in increasing order.',
     )),
    ('mju_insertionSortInt',
     FunctionDecl(
         name='mju_insertionSortInt',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='list',
                 type=PointerType(
                     inner_type=ValueType(name='int'),
                 ),
             ),
             FunctionParameterDecl(
                 name='n',
                 type=ValueType(name='int'),
             ),
         ),
         doc='Integer insertion sort, resulting list is in increasing order.',
     )),
    ('mju_Halton',
     FunctionDecl(
         name='mju_Halton',
         return_type=ValueType(name='mjtNum'),
         parameters=(
             FunctionParameterDecl(
                 name='index',
                 type=ValueType(name='int'),
             ),
             FunctionParameterDecl(
                 name='base',
                 type=ValueType(name='int'),
             ),
         ),
         doc='Generate Halton sequence.',
     )),
    ('mju_strncpy',
     FunctionDecl(
         name='mju_strncpy',
         return_type=PointerType(
             inner_type=ValueType(name='char'),
         ),
         parameters=(
             FunctionParameterDecl(
                 name='dst',
                 type=PointerType(
                     inner_type=ValueType(name='char'),
                 ),
             ),
             FunctionParameterDecl(
                 name='src',
                 type=PointerType(
                     inner_type=ValueType(name='char', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='n',
                 type=ValueType(name='int'),
             ),
         ),
         doc='Call strncpy, then set dst[n-1] = 0.',
     )),
    ('mju_sigmoid',
     FunctionDecl(
         name='mju_sigmoid',
         return_type=ValueType(name='mjtNum'),
         parameters=(
             FunctionParameterDecl(
                 name='x',
                 type=ValueType(name='mjtNum'),
             ),
         ),
         doc='Sigmoid function over 0<=x<=1 constructed from half-quadratics.',
     )),
    ('mjd_transitionFD',
     FunctionDecl(
         name='mjd_transitionFD',
         return_type=ValueType(name='void'),
         parameters=(
             FunctionParameterDecl(
                 name='m',
                 type=PointerType(
                     inner_type=ValueType(name='mjModel', is_const=True),
                 ),
             ),
             FunctionParameterDecl(
                 name='d',
                 type=PointerType(
                     inner_type=ValueType(name='mjData'),
                 ),
             ),
             FunctionParameterDecl(
                 name='eps',
                 type=ValueType(name='mjtNum'),
             ),
             FunctionParameterDecl(
                 name='centered',
                 type=ValueType(name='mjtByte'),
             ),
             FunctionParameterDecl(
                 name='A',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum'),
                 ),
             ),
             FunctionParameterDecl(
                 name='B',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum'),
                 ),
             ),
             FunctionParameterDecl(
                 name='C',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum'),
                 ),
             ),
             FunctionParameterDecl(
                 name='D',
                 type=PointerType(
                     inner_type=ValueType(name='mjtNum'),
                 ),
             ),
         ),
         doc='Finite differenced transition matrices (control theory notation)   d(x_next) = A*dx + B*du   d(sensor) = C*dx + D*du   required output matrix dimensions:      A: (2*nv+na x 2*nv+na)      B: (2*nv+na x nu)      D: (nsensordata x 2*nv+na)      C: (nsensordata x nu)',  # pylint: disable=line-too-long
     )),
])
