% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsva.R
\name{gsvaEnrichment}
\alias{gsvaEnrichment}
\alias{gsvaEnrichment,gsvaRanksParam-method}
\title{GSVA enrichment data and visualization}
\usage{
\S4method{gsvaEnrichment}{gsvaRanksParam}(
  param,
  column = 1,
  geneSet = 1,
  plot = c("auto", "base", "ggplot", "no"),
  ...
)
}
\arguments{
\item{param}{A \code{\linkS4class{gsvaRanksParam}} object obtained with the method
\code{\link{gsvaRanks}}.}

\item{column}{The column for which we want to retrieve the enrichment data.
This parameter is only available in the \code{gsvaEnrichment()} method.}

\item{geneSet}{Either a positive integer number between 1 and the number of
available gene sets in \code{param}, or a character string with the name of
one of the gene sets available in \code{param}.}

\item{plot}{A character string indicating whether an enrichment plot should
be produced using either base R graphics (\code{plot="base"}) or the ggplot2 package
(\code{plot="ggplot"}), or not (\code{plot="no"}). In the latter case, the enrichment
data will be returned. By default \code{plot="auto"}, which implies that if this
method is called from an interactive session, a plot using base R graphics
will be produced and, otherwise, the enrichment data is returned.}

\item{...}{Further arguments passed to the \code{plot()} function when the
previous parameter \code{plot="base"}.}
}
\value{
When \code{plot="no"}, this method returns the enrichment data. When
\code{plot="ggplot"}, this method returns a \code{ggplot} object. When \code{plot="base"}
no value is returned.
}
\description{
Extract and plot enrichment data from GSVA scores.
}
\examples{
library(GSVA)

p <- 10 ## number of genes
n <- 30 ## number of samples
nGrp1 <- 15 ## number of samples in group 1
nGrp2 <- n - nGrp1 ## number of samples in group 2

## consider three disjoint gene sets
geneSets <- list(gset1=paste0("g", 1:3),
                 gset2=paste0("g", 4:6),
                 gset3=paste0("g", 7:10))

## sample data from a normal distribution with mean 0 and st.dev. 1
y <- matrix(rnorm(n*p), nrow=p, ncol=n,
            dimnames=list(paste("g", 1:p, sep="") , paste("s", 1:n, sep="")))

## genes in set1 are expressed at higher levels in the last 'nGrp1+1' to 'n' samples
y[geneSets$set1, (nGrp1+1):n] <- y[geneSets$set1, (nGrp1+1):n] + 2

## build GSVA parameter object
gsvapar <- gsvaParam(y, geneSets)

## calculate GSVA ranks
gsvarankspar <- gsvaRanks(gsvapar)
gsvarankspar

## by default the enrichment data for the first column and the first
## gene set are retrieved
gsvaEnrichment(gsvarankspar)

}
\references{
Hänzelmann, S., Castelo, R. and Guinney, J. GSVA: Gene set
variation analysis for microarray and RNA-Seq data.
\emph{BMC Bioinformatics}, 14:7, 2013.
\href{https://doi.org/10.1186/1471-2105-14-7}{DOI}
}
