% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_to_wide.R
\name{data_to_wide}
\alias{data_to_wide}
\alias{reshape_wider}
\title{Reshape (pivot) data from long to wide}
\usage{
data_to_wide(
  data,
  id_cols = NULL,
  values_from = "Value",
  names_from = "Name",
  names_sep = "_",
  names_prefix = "",
  names_glue = NULL,
  values_fill = NULL,
  verbose = TRUE,
  ...,
  colnames_from,
  rows_from,
  sep
)

reshape_wider(
  data,
  id_cols = NULL,
  values_from = "Value",
  names_from = "Name",
  names_sep = "_",
  names_prefix = "",
  names_glue = NULL,
  values_fill = NULL,
  verbose = TRUE,
  ...,
  colnames_from,
  rows_from,
  sep
)
}
\arguments{
\item{data}{A data frame to pivot.}

\item{id_cols}{The name of the column that identifies the rows. If \code{NULL},
it will use all the unique rows.}

\item{values_from}{The name of the column that contains the values to be used
as future variable values.}

\item{names_from}{The name of the column that contains the levels to be
used as future column names.}

\item{names_sep}{If \code{names_from} or \code{values_from} contains multiple variables,
this will be used to join their values together into a single string to use
as a column name.}

\item{names_prefix}{String added to the start of every variable name. This is
particularly useful if \code{names_from} is a numeric vector and you want to create
syntactic variable names.}

\item{names_glue}{Instead of \code{names_sep} and \code{names_prefix}, you can supply a
\href{https://glue.tidyverse.org/index.html}{glue specification} that uses the
\code{names_from} columns to create custom column names. Note that the only
delimiters supported by \code{names_glue} are curly brackets, \verb{\{} and \verb{\}}.}

\item{values_fill}{Optionally, a (scalar) value that will be used to replace
missing values in the new columns created.}

\item{verbose}{Toggle warnings.}

\item{...}{Not used for now.}

\item{colnames_from}{Deprecated. Use \code{names_from} instead.}

\item{rows_from}{Deprecated. Use \code{id_cols} instead.}

\item{sep}{Deprecated. Use \code{names_sep} instead.}
}
\value{
If a tibble was provided as input, \code{reshape_wider()} also returns a
tibble. Otherwise, it returns a data frame.
}
\description{
This function "widens" data, increasing the number of columns and decreasing
the number of rows. This is a dependency-free base-R equivalent of
\code{tidyr::pivot_wider()}.
}
\examples{
data_long <- read.table(header = TRUE, text = "
 subject sex condition measurement
       1   M   control         7.9
       1   M     cond1        12.3
       1   M     cond2        10.7
       2   F   control         6.3
       2   F     cond1        10.6
       2   F     cond2        11.1
       3   F   control         9.5
       3   F     cond1        13.1
       3   F     cond2        13.8
       4   M   control        11.5
       4   M     cond1        13.4
       4   M     cond2        12.9")


reshape_wider(
  data_long,
  id_cols = "subject",
  names_from = "condition",
  values_from = "measurement"
)

reshape_wider(
  data_long,
  id_cols = "subject",
  names_from = "condition",
  values_from = "measurement",
  names_prefix = "Var.",
  names_sep = "."
)

production <- expand.grid(
  product = c("A", "B"),
  country = c("AI", "EI"),
  year = 2000:2014
)
production <- data_filter(production, (product == "A" & country == "AI") | product == "B")

production$production <- rnorm(nrow(production))

reshape_wider(
  production,
  names_from = c("product", "country"),
  values_from = "production",
  names_glue = "prod_{product}_{country}"
)

}
\seealso{
\itemize{
\item Functions to rename stuff: \code{\link[=data_rename]{data_rename()}}, \code{\link[=data_rename_rows]{data_rename_rows()}}, \code{\link[=data_addprefix]{data_addprefix()}}, \code{\link[=data_addsuffix]{data_addsuffix()}}
\item Functions to reorder or remove columns: \code{\link[=data_reorder]{data_reorder()}}, \code{\link[=data_relocate]{data_relocate()}}, \code{\link[=data_remove]{data_remove()}}
\item Functions to reshape, pivot or rotate data frames: \code{\link[=data_to_long]{data_to_long()}}, \code{\link[=data_to_wide]{data_to_wide()}}, \code{\link[=data_rotate]{data_rotate()}}
\item Functions to recode data: \code{\link[=rescale]{rescale()}}, \code{\link[=reverse]{reverse()}}, \code{\link[=categorize]{categorize()}}, \code{\link[=recode_values]{recode_values()}}, \code{\link[=slide]{slide()}}
\item Functions to standardize, normalize, rank-transform: \code{\link[=center]{center()}}, \code{\link[=standardize]{standardize()}}, \code{\link[=normalize]{normalize()}}, \code{\link[=ranktransform]{ranktransform()}}, \code{\link[=winsorize]{winsorize()}}
\item Split and merge data frames: \code{\link[=data_partition]{data_partition()}}, \code{\link[=data_merge]{data_merge()}}
\item Functions to find or select columns: \code{\link[=data_select]{data_select()}}, \code{\link[=data_find]{data_find()}}
\item Functions to filter rows: \code{\link[=data_match]{data_match()}}, \code{\link[=data_filter]{data_filter()}}
}
}
