% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/styles.R
\docType{class}
\name{StyleFuns-class}
\alias{StyleFuns-class}
\alias{StyleFuns}
\title{Functions Used for Styling Diff Components}
\arguments{
\item{container}{function used primarily by HTML styles to generate an
outermost \code{DIV} that allows for CSS targeting of its contents
(see \code{\link{cont_f}} for a function generator appropriate for use
here)}

\item{line}{function}

\item{line.insert}{function}

\item{line.delete}{function}

\item{line.match}{function}

\item{line.guide}{function formats guide lines (see \code{\link{guides}})}

\item{text}{function}

\item{text.insert}{function}

\item{text.delete}{function}

\item{text.match}{function}

\item{text.guide}{function formats guide lines (see \code{\link{guides}})}

\item{gutter}{function}

\item{gutter.insert}{function}

\item{gutter.delete}{function}

\item{gutter.match}{function}

\item{gutter.guide}{function}

\item{gutter.pad}{function}

\item{header}{function to format each hunk header with}

\item{banner}{function to format entire banner}

\item{banner.insert}{function to format insertion banner}

\item{banner.delete}{function to format deletion banner}

\item{meta}{function format meta information lines}

\item{context.sep}{function to format the separator used to visually
distinguish the A and B hunks in \dQuote{context} \code{mode}}
}
\value{
a StyleFuns S4 object
}
\description{
Except for \code{container} every function specified here should be
vectorized and apply formatting to each element in a character vectors.  The
functions must accept at least one argument and require no more than one
argument.  The text to be formatted will be passed as a character vector
as the first argument to each function.
}
\details{
These functions are applied in post processing steps.  The \code{diff*}
methods do not do any of the formatting.  Instead, the formatting is done
only if the user requests to \code{show} the object.  Internally, \code{show}
first converts the object to a character vector using \code{as.character},
which applies every formatting function defined here except for
\code{container}.  Then \code{show} applies \code{container} before
forwarding the result to the screen or pager.
}
\note{
the slots are set to class \dQuote{ANY} to allow classed functions
  such as those defined in the \code{crayon} package.  Despite this seemingly
  permissive slot definition, only functions are allowed in the slots by
  the validation functions.
}
\seealso{
\code{\link{Style}}
}
