% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/start-geojob.R
\docType{methods}
\name{start}
\alias{start}
\alias{start,geojob-method}
\title{Submit a GDP web processing request}
\usage{
start(.Object)

\S4method{start}{geojob}(.Object)
}
\arguments{
\item{.Object}{a \linkS4class{geojob} object}
}
\value{
A \linkS4class{geojob} object with an active GDP process request.
}
\description{
Start process for \code{\link{geojob}}
}
\details{
start a geo-web processing request

 start is a method for submitting a geo-web processing request.
}
\examples{
wd <- webdata('prism')
wg <- webgeom('state::New Hampshire')
wp <- webprocess()
gj <- geojob()
\dontrun{
xml(gj) <- XML(wg, wd, wp)
url(gj) <- url(wp)
gj <- start(gj)
}
}
\seealso{
\code{\link{check}}
}
