% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secret.R
\name{secrets}
\alias{secret_make_key}
\alias{secret_encrypt}
\alias{secret_decrypt}
\alias{secret_write_rds}
\alias{secret_read_rds}
\alias{secret_decrypt_file}
\alias{secret_encrypt_file}
\alias{secret_has_key}
\title{Secret management}
\usage{
secret_make_key()

secret_encrypt(x, key)

secret_decrypt(encrypted, key)

secret_write_rds(x, path, key)

secret_read_rds(path, key)

secret_decrypt_file(path, key, envir = parent.frame())

secret_encrypt_file(path, key)

secret_has_key(key)
}
\arguments{
\item{x}{Object to encrypt. Must be a string for \code{secret_encrypt()}.}

\item{key}{Encryption key; this is the password that allows you to "lock"
and "unlock" the secret. The easiest way to specify this is as the
name of an environment variable. Alternatively, if you already have
a base64url encoded string, you can wrap it in \code{I()}, or you can pass
the raw vector in directly.}

\item{encrypted}{String to decrypt}

\item{path}{Path to file to encrypted file to read or write. For
\code{secret_write_rds()} and \code{secret_read_rds()} this should be an \code{.rds}
file.}

\item{envir}{The decrypted file will be automatically deleted when
this environment exits. You should only need to set this argument if you
want to pass the unencrypted file to another function.}
}
\value{
\itemize{
\item \code{secret_decrypt()} and \code{secret_encrypt()} return strings.
\item \code{secret_decrypt_file()} returns a path to a temporary file;
\code{secret_encrypt_file()} encrypts the file in place.
\item \code{secret_write_rds()} returns \code{x} invisibly; \code{secret_read_rds()}
returns the saved object.
\item \code{secret_make_key()} returns a string with class \code{AsIs}.
\item \code{secret_has_key()} returns \code{TRUE} or \code{FALSE}.
}
}
\description{
httr2 provides a handful of functions designed for working with confidential
data. These are useful because testing packages that use httr2 often
requires some confidential data that needs to be available for testing,
but should not be available to package users.
\itemize{
\item \code{secret_encrypt()} and \code{secret_decrypt()} work with individual strings
\item \code{secret_encrypt_file()} encrypts a file in place and
\code{secret_decrypt_file()} decrypts a file in a temporary location.
\item \code{secret_write_rds()} and \code{secret_read_rds()} work with \code{.rds} files
\item \code{secret_make_key()} generates a random string to use as a key.
\item \code{secret_has_key()} returns \code{TRUE} if the key is available; you can
use it in examples and vignettes that you want to evaluate on your CI,
but not for CRAN/package users.
}

These all look for the key in an environment variable. When used inside of
testthat, they will automatically \code{\link[testthat:skip]{testthat::skip()}} the test if the env var
isn't found. (Outside of testthat, they'll error if the env var isn't
found.)
}
\section{Basic workflow}{
\enumerate{
\item Use \code{secret_make_key()} to generate a password. Make this available
as an env var (e.g. \verb{\{MYPACKAGE\}_KEY}) by adding a line to your
\code{.Renviron}.
\item Encrypt strings with \code{secret_encrypt()}, files with
\code{secret_encrypt_file()}, and other data with \code{secret_write_rds()},
setting \code{key = "{MYPACKAGE}_KEY"}.
\item In your tests, decrypt the data with \code{secret_decrypt()},
\code{secret_decrypt_file()}, or \code{secret_read_rds()} to match how you encrypt
it.
\item If you push this code to your CI server, it will already "work" because
all functions automatically skip tests when your \verb{\{MYPACKAGE\}_KEY}
env var isn't set. To make the tests actually run, you'll need to set
the env var using whatever tool your CI system provides for setting
env vars. Make sure to carefully inspect the test output to check that
the skips have actually gone away.
}
}

\examples{
key <- secret_make_key()

path <- tempfile()
secret_write_rds(mtcars, path, key = key)
secret_read_rds(path, key)

# While you can manage the key explicitly in a variable, it's much
# easier to store in an environment variable. In real life, you should
# NEVER use `Sys.setenv()` to create this env var because you will
# also store the secret in your `.Rhistory`. Instead add it to your
# .Renviron using `usethis::edit_r_environ()` or similar.
Sys.setenv("MY_KEY" = key)

x <- secret_encrypt("This is a secret", "MY_KEY")
x
secret_decrypt(x, "MY_KEY")
}
