% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utils-formula.R
\name{combineFormula}
\alias{combineFormula}
\title{Combine formula}
\usage{
combineFormula(ls.formula, as.formula = TRUE, as.unique = FALSE)
}
\arguments{
\item{ls.formula}{a list of formula}

\item{as.formula}{should a list of formula be returned. Otherwise it will be a list of characters.}

\item{as.unique}{should regressors appears at most once in the formula}
}
\description{
Combine formula by outcome
}
\examples{
combineFormula(list(Y~X1,Y~X3+X5,Y1~X2))
lava.options(symbols = c("~",","))
combineFormula(list("Y~X1","Y~X3+X5","Y1~X2"))
lava.options(symbols = c("<-","<->"))
combineFormula(list("Y<-X1","Y<-X3+X5","Y1<-X2"))

combineFormula(list(Y~X1,Y~X3+X1,Y1~X2))
combineFormula(list(Y~X1,Y~X3+X1,Y1~X2), as.formula = FALSE)
combineFormula(list(Y~X1,Y~X3+X1,Y1~X2), as.unique = TRUE)

lava.options(symbols = c("~","~~"))
combineFormula(list("Y~X1","Y~X3","Y1~X2"))

}
