% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\name{loo-datasets}
\alias{loo-datasets}
\alias{Kline}
\alias{milk}
\alias{voice}
\alias{voice_loo}
\title{Datasets for loo examples and vignettes}
\description{
Small datasets for use in \strong{loo} examples and vignettes. The \code{Kline}
and \code{milk} datasets are also included in the \strong{rethinking} package
(McElreath, 2016a), but we include them here as \strong{rethinking} is not
on CRAN.
}
\details{
Currently the data sets included are:
\itemize{
\item \code{Kline}:
Small dataset from Kline and Boyd (2010) on tool complexity and demography
in Oceanic islands societies. This data is discussed in detail in
McElreath (2016a,2016b). \href{https://www.rdocumentation.org/packages/rethinking/versions/1.59/topics/Kline}{(Link to variable descriptions)}
\item \code{milk}:
Small dataset from Hinde and Milligan (2011) on primate milk
composition.This data is discussed in detail in McElreath (2016a,2016b).
\href{https://www.rdocumentation.org/packages/rethinking/versions/1.59/topics/milk}{(Link to variable descriptions)}
\item \code{voice}:
Voice rehabilitation data from Tsanas et al. (2014).
}
}
\examples{
str(Kline)
str(milk)

}
\references{
Hinde and Milligan. 2011. \emph{Evolutionary Anthropology} 20:9-23.

Kline, M.A. and R. Boyd. 2010. \emph{Proc R Soc B} 277:2559-2564.

McElreath, R. (2016a). rethinking: Statistical Rethinking book package.
R package version 1.59.

McElreath, R. (2016b). \emph{Statistical rethinking: A Bayesian course with
examples in R and Stan}. Chapman & Hall/CRC.

A. Tsanas, M.A. Little, C. Fox, L.O. Ramig: Objective automatic assessment of
rehabilitative speech treatment in Parkinson's disease, IEEE
Transactions on Neural Systems and Rehabilitation Engineering, Vol. 22, pp.
181-190, January 2014
}
