% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pr_set.R
\name{pr_set_docs}
\alias{pr_set_docs}
\title{Set the API visual documentation}
\usage{
pr_set_docs(pr, docs = getOption("plumber.docs", TRUE), ...)
}
\arguments{
\item{pr}{A Plumber API. Note: The supplied Plumber API object will also be updated in place as well as returned by the function.}

\item{docs}{a character value or a logical value.
If using \code{\link[=options_plumber]{options_plumber()}}, the value must be set before initializing your Plumber router.}

\item{...}{Other params to be passed to the \code{docs} functions.}
}
\value{
The Plumber router with the new docs settings.
}
\description{
\code{docs} should be either a logical or a character value matching a registered visual documentation.
When \code{TRUE} or a
function, multiple handles will be added to \code{\link{Plumber}} object. OpenAPI json
file will be served on paths \verb{/openapi.json} and \verb{/swagger.json}. Documentation
will be served on paths \verb{/__docs__/index.html} and \verb{/__docs__/}. When
using a function, it will receive the Plumber router as the first parameter
and current OpenAPI Specification as the second. This function should return a
list containing OpenAPI Specification.
See \url{http://spec.openapis.org/oas/v3.0.3}
}
\examples{
\dontrun{
## View API using Swagger UI
# Official Website: https://swagger.io/tools/swagger-ui/
# install.packages("swagger")
if (require(swagger)) {
  pr() \%>\%
    pr_set_docs("swagger") \%>\%
    pr_get("/plus/<a:int>/<b:int>", function(a, b) { a + b }) \%>\%
    pr_run()
}

## View API using Redoc
# Official Website: https://github.com/Redocly/redoc
# remotes::install_github("https://github.com/meztez/redoc/")
if (require(redoc)) {
  pr() \%>\%
    pr_set_docs("redoc") \%>\%
    pr_get("/plus/<a:int>/<b:int>", function(a, b) { a + b }) \%>\%
    pr_run()
}

## View API using RapiDoc
# Official Website: https://github.com/mrin9/RapiDoc
# remotes::install_github("https://github.com/meztez/rapidoc/")
if (require(rapidoc)) {
  pr() \%>\%
    pr_set_docs("rapidoc") \%>\%
    pr_get("/plus/<a:int>/<b:int>", function(a, b) { a + b }) \%>\%
    pr_run()
}

## Disable the OpenAPI Spec UI
pr() \%>\%
  pr_set_docs(FALSE) \%>\%
  pr_get("/plus/<a:int>/<b:int>", function(a, b) { a + b }) \%>\%
  pr_run()
}
}
