% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.regressionTable.R
\name{plot.regressionTable}
\alias{plot.regressionTable}
\title{Plotting regression coefficients with confidence limits}
\usage{
\method{plot}{regressionTable}(x, xlim, xlab, style = 1, ...)
}
\arguments{
\item{x}{regression table obtained with regressionTable}

\item{xlim}{Limits for x-axis}

\item{xlab}{Label for x-axis}

\item{style}{Determines how to arrange variable names and their corresponding units}

\item{...}{passed to plotConfidence}
}
\description{
Plotting regression coefficients with confidence limits
}
\examples{
## linear regression
data(Diabetes)
f <- glm(bp.1s~AgeGroups+chol+gender+location,data=Diabetes)
rtf <- regressionTable(f,factor.reference = "inline")
plot(rtf,cex=1.3)

## logistic regression
data(Diabetes)
f <- glm(I(BMI>25)~bp.1s+AgeGroups+chol+gender+location,data=Diabetes,family=binomial)
rtf <- regressionTable(f,factor.reference = "inline")
plot(rtf,cex=1.3)

## Poisson regression
data(trace)
fit <- glm(dead ~ smoking+ sex+ age+Time+offset(log(ObsTime)), family = poisson,data=trace)
rtab <- regressionTable(fit,factor.reference = "inline")
plot(rtab,xlim=c(0.85,1.15),cex=1.8,xaxis.cex=1.5)

## Cox regression
library(survival)
data(pbc)
coxfit <- coxph(Surv(time,status!=0)~age+log(bili)+log(albumin)+factor(edema)+sex,data=pbc)
pubcox <- publish(coxfit)
plot(pubcox,cex=1.5,xratio=c(0.4,0.2))

}
\seealso{
regressionTable
}
\author{
Thomas A. Gerds <tag@biostat.ku.dk>
}
