% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbQuoteIdentifier_MariaDBConnection_Id.R,
%   R/dbQuoteIdentifier_MariaDBConnection_SQL.R,
%   R/dbQuoteIdentifier_MariaDBConnection_character.R,
%   R/dbQuoteLiteral_MariaDBConnection.R,
%   R/dbQuoteString_MariaDBConnection_SQL.R,
%   R/dbQuoteString_MariaDBConnection_character.R,
%   R/dbUnquoteIdentifier_MariaDBConnection_SQL.R, R/quote.R
\name{mariadb-quoting}
\alias{mariadb-quoting}
\alias{dbQuoteIdentifier_MariaDBConnection_Id}
\alias{dbQuoteIdentifier,MariaDBConnection,Id-method}
\alias{dbQuoteIdentifier_MariaDBConnection_SQL}
\alias{dbQuoteIdentifier,MariaDBConnection,SQL-method}
\alias{dbQuoteIdentifier_MariaDBConnection_character}
\alias{dbQuoteIdentifier,MariaDBConnection,character-method}
\alias{dbQuoteLiteral_MariaDBConnection}
\alias{dbQuoteLiteral,MariaDBConnection-method}
\alias{dbQuoteString_MariaDBConnection_SQL}
\alias{dbQuoteString,MariaDBConnection,SQL-method}
\alias{dbQuoteString_MariaDBConnection_character}
\alias{dbQuoteString,MariaDBConnection,character-method}
\alias{dbUnquoteIdentifier_MariaDBConnection_SQL}
\alias{dbUnquoteIdentifier,MariaDBConnection,SQL-method}
\title{Quote MariaDB strings and identifiers.}
\usage{
\S4method{dbQuoteIdentifier}{MariaDBConnection,Id}(conn, x, ...)

\S4method{dbQuoteIdentifier}{MariaDBConnection,SQL}(conn, x, ...)

\S4method{dbQuoteIdentifier}{MariaDBConnection,character}(conn, x, ...)

\S4method{dbQuoteLiteral}{MariaDBConnection}(conn, x, ...)

\S4method{dbQuoteString}{MariaDBConnection,SQL}(conn, x, ...)

\S4method{dbQuoteString}{MariaDBConnection,character}(conn, x, ...)

\S4method{dbUnquoteIdentifier}{MariaDBConnection,SQL}(conn, x, ...)
}
\description{
In MariaDB, identifiers are enclosed in backticks, e.g. \code{`x`}.
}
\examples{
if (mariadbHasDefault()) {
  con <- dbConnect(RMariaDB::MariaDB())
  dbQuoteIdentifier(con, c("a b", "a`b"))
  dbQuoteString(con, c("a b", "a'b"))
  dbDisconnect(con)
}
}
\keyword{internal}
