% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tol.R
\name{tol_about}
\alias{tol_about}
\alias{tax_rank.tol_summary}
\alias{tax_sources.tol_summary}
\alias{unique_name.tol_summary}
\alias{tax_name.tol_summary}
\alias{ott_id.tol_summary}
\title{Information about the Tree of Life}
\usage{
tol_about(include_source_list = FALSE, ...)

\method{tax_rank}{tol_summary}(tax, ...)

\method{tax_sources}{tol_summary}(tax, ...)

\method{unique_name}{tol_summary}(tax, ...)

\method{tax_name}{tol_summary}(tax, ...)

\method{ott_id}{tol_summary}(tax, ...)
}
\arguments{
\item{include_source_list}{Logical (default =
\code{FALSE}). Return an ordered list of source trees.}

\item{...}{additional arguments to customize the API call (see
\code{\link{rotl}} for more information).}

\item{tax}{an object created with a call to \code{tol_about}.}
}
\value{
An invisible list of synthetic tree summary statistics:

\itemize{

    \item {date_created} {String. The creation date of the tree.}

    \item {num_source_studies} {Integer. The number of studies
    (publications)used as sources.}

    \item {num_source_trees} {The number of trees used as sources
    (may be >1 tree per study).}

    \item {taxonomy_version} {The Open Tree Taxonomy version used
    as a source.}

    \item {filtered_flags} {List. Taxa with these taxonomy flags were
    not used in construction of the tree.}

    \item {root} {List. Describes the root node:}
        \itemize{
            \item {node_id} {String. The canonical identifier of the node.}

            \item {num_tips} {Numeric. The number of descendant tips.}

            \item {taxon} {A list of taxonomic properties:}
            \itemize{
                \item {ott_id} {Numeric. The OpenTree Taxonomy ID (ott_id).}

                \item {name} {String. The taxonomic name of the queried node.}

                \item {unique_name} {String. The string that uniquely
                identifies the taxon in OTT.}

                \item {rank} {String. The taxonomic rank of the taxon in OTT.}

                \item {tax_sources} {List. A list of identifiers for taxonomic
                sources, such as other taxonomies, that define taxa judged
                equivalent to this taxon.}
            }
        }

    \item {source_list} {List. Present only if
    \code{include_source_list} is \code{TRUE}. The sourceid
    ordering is the precedence order for synthesis, with
    relationships from earlier trees in the list having priority
    over those from later trees in the list. See
    \code{source_id_map} below for study details.}

    \item {source_id_map} {Named list of lists. Present only if
    \code{include_source_list} is \code{TRUE}. Names correspond to
    the \sQuote{sourceids} used in \code{source_list}
    above. Source trees will have the following properties:}

        \itemize{
            \item {git_sha} {String. The git SHA identifying a particular source
            version.}

            \item {tree_id} {String. The tree id associated with the study id used.}

            \item {study_id} {String. The study identifier. Will typically include
            a prefix ("pg_" or "ot_").}
        }

    \item {synth_id} {The unique string for this version of the tree.}
}
}
\description{
Basic information about the Open Tree of Life (the synthetic tree)
}
\details{
Summary information about the current draft tree of life,
    including information about the list of trees and the taxonomy
    used to build it. The object returned by \code{tol_about} can
    be passed to the taxonomy methods (\code{tax_name()},
    \code{tax_rank()}, \code{tax_sources()}, \code{ott_id}), to
    extract relevant taxonomic information for the root of the
    synthetic tree.
}
\examples{
\dontrun{
res <- tol_about()
tax_sources(res)
ott_id(res)
studies <- source_list(tol_about(include_source_list=TRUE))}
}
\seealso{
\code{\link{source_list}} to explore the list of studies
    used in the synthetic tree (see example).
}
