% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tweet_retweeted_by.R
\name{tweet_retweeted_by}
\alias{tweet_retweeted_by}
\title{Tweet retweeted by}
\usage{
tweet_retweeted_by(
  ids,
  n = 100,
  expansions = NULL,
  fields = NULL,
  ...,
  token = NULL,
  parse = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{ids}{A tweet id string.}

\item{n}{Number of tweets to query.}

\item{expansions}{Set \code{NULL} to not use any expansion, set \code{NA} to get all
expansions, or provide a vector with the expansions you want (create it with
\code{\link[=set_expansions]{set_expansions()}}).}

\item{fields}{Set \code{NULL} to not use any field, get all allowed fields with \code{NA},
provide a list with the fields you want (create it with \code{\link[=set_fields]{set_fields()}}).}

\item{...}{Other arguments passed to the API.}

\item{token}{These endpoints only accept a bearer token (can be created via
\code{\link[=rtweet_app]{rtweet_app()}}). In most cases you
are better of changing the default for all calls via \code{\link[=auth_as]{auth_as()}}.}

\item{parse}{If \code{TRUE}, the default, returns a tidy data frame. Use \code{FALSE}
to return the "raw" list corresponding to the JSON returned from the
Twitter API.}

\item{verbose}{A logical value to provide more information about the
paginated queries (if any) and to store the data of each page.}
}
\value{
A data.frame with the user information of who retweeted it:
id, name, and username.
Other information depends on the \code{expansions} and \code{fields} requested.
}
\description{
Looks up who have retweeted a given tweet.
}
\examples{
if (FALSE) {
  rb <- tweet_retweeted_by("567053242429734913")
}
}
\references{
\url{https://developer.twitter.com/en/docs/twitter-api/tweets/retweets/api-reference/get-tweets-id-retweeted_by}
}
