% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.R
\name{install_tinytex}
\alias{install_tinytex}
\alias{uninstall_tinytex}
\alias{reinstall_tinytex}
\alias{tinytex_root}
\title{Install/Uninstall TinyTeX}
\usage{
install_tinytex(
  force = FALSE,
  dir = "auto",
  version = "",
  repository = "ctan",
  extra_packages = if (is_tinytex()) tl_pkgs(),
  add_path = TRUE
)

uninstall_tinytex(force = FALSE, dir = tinytex_root())

reinstall_tinytex(packages = TRUE, dir = tinytex_root(), ...)

tinytex_root(error = TRUE)
}
\arguments{
\item{force}{Whether to force to install (override) or uninstall TinyTeX.}

\item{dir}{The directory to install or uninstall TinyTeX (should not exist
unless \code{force = TRUE}).}

\item{version}{The version of TinyTeX, e.g., \code{"2020.09"} (see all
available versions at \url{https://github.com/yihui/tinytex-releases}). By
default, it installs the latest daily build of TinyTeX.}

\item{repository}{The CTAN repository to set. You can find available
repositories at \code{https://ctan.org/mirrors}), e.g.,
\code{'http://mirrors.tuna.tsinghua.edu.cn/CTAN/'}, or
\code{'https://mirror.las.iastate.edu/tex-archive/'}. In theory, this
argument should end with the path \file{/systems/texlive/tlnet}, and if it
does not, the path will be automatically appended.}

\item{extra_packages}{A character vector of extra LaTeX packages to be
installed. By default, a vector of all currently installed LaTeX packages
if an existing installation of TinyTeX is found. If you want a fresh
installation, you may use \code{extra_packages = NULL}.}

\item{add_path}{Whether to run the command \command{tlmgr path add} to add
the bin path of TeX Live to the system environment variable \var{PATH}.}

\item{packages}{Whether to reinstall all currently installed packages.}

\item{...}{Other arguments to be passed to \code{install_tinytex()} (note
that the \code{extra_packages} argument will be set to \code{tl_pkgs()} if
\code{packages = TRUE}).}

\item{error}{Whether to signal an error if TinyTeX is not found.}
}
\description{
The function \code{install_tinytex()} downloads and installs TinyTeX, a
custom LaTeX distribution based on TeX Live. The function
\code{uninstall_tinytex()} removes TinyTeX; \code{reinstall_tinytex()}
reinstalls TinyTeX as well as previously installed LaTeX packages by default;
\code{tinytex_root()} returns the root directory of TinyTeX if found.
}
\references{
See the TinyTeX documentation (\url{https://yihui.org/tinytex/})
  for the default installation directories on different platforms.
}
