//client.h:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2008-2019
 *
 *  This file is part of RoarAudio,
 *  a cross-platform sound system for both, home and professional use.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version 3
 *  as published by the Free Software Foundation.
 *
 *  RoarAudio is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 *  NOTE: Even though this file is LGPLed it (may) include GPLed files
 *  so the license of this file is/may therefore downgraded to GPL.
 *  See HACKING for details.
 */

#ifndef _ROARAUDIO_CLIENT_H_
#define _ROARAUDIO_CLIENT_H_

#define ROAR_BUFFER_NAME 80

#define ROAR_CLIENTS_MAX 64
#define ROAR_CLIENTS_MAX_STREAMS_PER_CLIENT 12

#define ROAR_PROTO_NONE             0
#define ROAR_PROTO_ROARAUDIO        1
#define ROAR_PROTO_ESOUND           2
#define ROAR_PROTO_AUTO             3 /* auto detect */
#define ROAR_PROTO_HTTP             4
#define ROAR_PROTO_GOPHER           5
#define ROAR_PROTO_ICY              7 /* Nullsoft ICY */
#define ROAR_PROTO_SIMPLE           8 /* PulseAudio Simple */
#define ROAR_PROTO_RSOUND           9
#define ROAR_PROTO_RPLAY           10
#define ROAR_PROTO_IRC             11 /* ID just for fun */
#define ROAR_PROTO_DCC             12
#define ROAR_PROTO_ECHO            13 /* for testing and stuff */
#define ROAR_PROTO_DISCARD         14 /* RFC 863 */
#define ROAR_PROTO_WHOIS           15
#define ROAR_PROTO_FINGER          16
#define ROAR_PROTO_QUOTE           17 /* RFC 865: Quote of the Day Protocol */
#define ROAR_PROTO_DAYTIME         18
#define ROAR_PROTO_GAME            19 /* a game, may be any game */
#define ROAR_PROTO_TELNET          20
#define ROAR_PROTO_DHCP            21
#define ROAR_PROTO_SSH             22
#define ROAR_PROTO_TIME            23 /* Time protocol, RFC 868 */
#define ROAR_PROTO_RLOGIN          24
#define ROAR_PROTO_RPLD            25 /* RoarAudio Playlist Daemon Protocol */
#define ROAR_PROTO_MPD             26 /* Music Player Daemon */
#define ROAR_PROTO_RTP             27 /* Real-time Transport Protocol */
#define ROAR_PROTO_RTCP            28 /* RealTime Control Protocol */
#define ROAR_PROTO_RTSP            29 /* Real-Time Streaming Protocol */
#define ROAR_PROTO_SIP             30 /* Session Initiation Protocol */

/* Dynamic defined protocols.
 * Those IDs MUST NOT be used on wire, stored on disk or
 * leave the process any other way.
 */
#define ROAR_PROTO_DYNAMIC0       208
#define ROAR_PROTO_DYNAMIC1       209
#define ROAR_PROTO_DYNAMIC2       210
#define ROAR_PROTO_DYNAMIC3       211
#define ROAR_PROTO_DYNAMIC4       212
#define ROAR_PROTO_DYNAMIC5       213
#define ROAR_PROTO_DYNAMIC6       214
#define ROAR_PROTO_DYNAMIC7       215
#define ROAR_PROTO_DYNAMIC8       216
#define ROAR_PROTO_DYNAMIC9       217
#define ROAR_PROTO_DYNAMIC10      218
#define ROAR_PROTO_DYNAMIC11      219
#define ROAR_PROTO_DYNAMIC12      220
#define ROAR_PROTO_DYNAMIC13      221
#define ROAR_PROTO_DYNAMIC14      222
#define ROAR_PROTO_DYNAMIC15      223

/* User defined protocols.
 * IDs may be used on wire or stored on disk if meaning of them
 * was agreed on before. This could e.g. be done using the CAPS command.
 */
#define ROAR_PROTO_USER0          224
#define ROAR_PROTO_USER1          225
#define ROAR_PROTO_USER2          226
#define ROAR_PROTO_USER3          227
#define ROAR_PROTO_USER4          228
#define ROAR_PROTO_USER5          229
#define ROAR_PROTO_USER6          230
#define ROAR_PROTO_USER7          231
#define ROAR_PROTO_USER8          232
#define ROAR_PROTO_USER9          233
#define ROAR_PROTO_USER10         234
#define ROAR_PROTO_USER11         235
#define ROAR_PROTO_USER12         236
#define ROAR_PROTO_USER13         237
#define ROAR_PROTO_USER14         238
#define ROAR_PROTO_USER15         239


#define ROAR_BYTEORDER_UNKNOWN      0x00
#define ROAR_BYTEORDER_LE           ROAR_CODEC_LE
#define ROAR_BYTEORDER_BE           ROAR_CODEC_BE
#define ROAR_BYTEORDER_PDP          ROAR_CODEC_PDP
#define ROAR_BYTEORDER_NETWORK      ROAR_BYTEORDER_BE

#if BYTE_ORDER == BIG_ENDIAN
#define ROAR_BYTEORDER_NATIVE       ROAR_CODEC_BE
#elif BYTE_ORDER == LITTLE_ENDIAN
#define ROAR_BYTEORDER_NATIVE       ROAR_CODEC_LE
#else
#define ROAR_BYTEORDER_NATIVE       ROAR_CODEC_PDP
#endif

#define ROAR_CLIENTPASS_FLAG_NONE    0x0000
#define ROAR_CLIENTPASS_FLAG_LISTEN  0x0001

#endif

//ll
