use super::KeyCode;
use super::OsCode;

impl From<KeyCode> for OsCode {
    fn from(item: KeyCode) -> Self {
        unsafe { std::mem::transmute(item) }
    }
}

impl From<OsCode> for KeyCode {
    fn from(item: OsCode) -> KeyCode {
        unsafe { std::mem::transmute(item) }
    }
}

#[test]
fn roundtrip_oscode_keycode() {
    use super::OsCode::*;
    let oscs = &[
        KEY_RESERVED,
        KEY_ESC,
        KEY_1,
        KEY_2,
        KEY_3,
        KEY_4,
        KEY_5,
        KEY_6,
        KEY_7,
        KEY_8,
        KEY_9,
        KEY_0,
        KEY_MINUS,
        KEY_EQUAL,
        KEY_BACKSPACE,
        KEY_TAB,
        KEY_Q,
        KEY_W,
        KEY_E,
        KEY_R,
        KEY_T,
        KEY_Y,
        KEY_U,
        KEY_I,
        KEY_O,
        KEY_P,
        KEY_LEFTBRACE,
        KEY_RIGHTBRACE,
        KEY_ENTER,
        KEY_LEFTCTRL,
        KEY_A,
        KEY_S,
        KEY_D,
        KEY_F,
        KEY_G,
        KEY_H,
        KEY_J,
        KEY_K,
        KEY_L,
        KEY_SEMICOLON,
        KEY_APOSTROPHE,
        KEY_GRAVE,
        KEY_LEFTSHIFT,
        KEY_BACKSLASH,
        KEY_Z,
        KEY_X,
        KEY_C,
        KEY_V,
        KEY_B,
        KEY_N,
        KEY_M,
        KEY_COMMA,
        KEY_DOT,
        KEY_SLASH,
        KEY_RIGHTSHIFT,
        KEY_KPASTERISK,
        KEY_LEFTALT,
        KEY_SPACE,
        KEY_CAPSLOCK,
        KEY_F1,
        KEY_F2,
        KEY_F3,
        KEY_F4,
        KEY_F5,
        KEY_F6,
        KEY_F7,
        KEY_F8,
        KEY_F9,
        KEY_F10,
        KEY_NUMLOCK,
        KEY_SCROLLLOCK,
        KEY_KP7,
        KEY_KP8,
        KEY_KP9,
        KEY_KPMINUS,
        KEY_KP4,
        KEY_KP5,
        KEY_KP6,
        KEY_KPPLUS,
        KEY_KP1,
        KEY_KP2,
        KEY_KP3,
        KEY_KP0,
        KEY_KPDOT,
        KEY_84,
        KEY_ZENKAKUHANKAKU,
        KEY_102ND,
        KEY_F11,
        KEY_F12,
        KEY_RO,
        KEY_KATAKANA,
        KEY_HIRAGANA,
        KEY_HENKAN,
        KEY_KATAKANAHIRAGANA,
        KEY_MUHENKAN,
        KEY_KPJPCOMMA,
        KEY_KPENTER,
        KEY_RIGHTCTRL,
        KEY_KPSLASH,
        KEY_SYSRQ,
        KEY_RIGHTALT,
        KEY_LINEFEED,
        KEY_HOME,
        KEY_UP,
        KEY_PAGEUP,
        KEY_LEFT,
        KEY_RIGHT,
        KEY_END,
        KEY_DOWN,
        KEY_PAGEDOWN,
        KEY_INSERT,
        KEY_DELETE,
        KEY_MACRO,
        KEY_MUTE,
        KEY_VOLUMEDOWN,
        KEY_VOLUMEUP,
        KEY_POWER,
        KEY_KPEQUAL,
        KEY_KPPLUSMINUS,
        KEY_PAUSE,
        KEY_SCALE,
        KEY_KPCOMMA,
        KEY_HANGEUL,
        KEY_HANJA,
        KEY_YEN,
        KEY_LEFTMETA,
        KEY_RIGHTMETA,
        KEY_COMPOSE,
        KEY_STOP,
        KEY_AGAIN,
        KEY_PROPS,
        KEY_UNDO,
        KEY_FRONT,
        KEY_COPY,
        KEY_OPEN,
        KEY_PASTE,
        KEY_FIND,
        KEY_CUT,
        KEY_HELP,
        KEY_MENU,
        KEY_CALC,
        KEY_SETUP,
        KEY_SLEEP,
        KEY_WAKEUP,
        KEY_FILE,
        KEY_SENDFILE,
        KEY_DELETEFILE,
        KEY_XFER,
        KEY_PROG1,
        KEY_PROG2,
        KEY_WWW,
        KEY_MSDOS,
        KEY_COFFEE,
        KEY_ROTATE_DISPLAY,
        KEY_CYCLEWINDOWS,
        KEY_MAIL,
        KEY_BOOKMARKS,
        KEY_COMPUTER,
        KEY_BACK,
        KEY_FORWARD,
        KEY_CLOSECD,
        KEY_EJECTCD,
        KEY_EJECTCLOSECD,
        KEY_NEXTSONG,
        KEY_PLAYPAUSE,
        KEY_PREVIOUSSONG,
        KEY_STOPCD,
        KEY_RECORD,
        KEY_REWIND,
        KEY_PHONE,
        KEY_ISO,
        KEY_CONFIG,
        KEY_HOMEPAGE,
        KEY_REFRESH,
        KEY_EXIT,
        KEY_MOVE,
        KEY_EDIT,
        KEY_SCROLLUP,
        KEY_SCROLLDOWN,
        KEY_KPLEFTPAREN,
        KEY_KPRIGHTPAREN,
        KEY_NEW,
        KEY_REDO,
        KEY_F13,
        KEY_F14,
        KEY_F15,
        KEY_F16,
        KEY_F17,
        KEY_F18,
        KEY_F19,
        KEY_F20,
        KEY_F21,
        KEY_F22,
        KEY_F23,
        KEY_F24,
        KEY_195,
        KEY_196,
        KEY_197,
        KEY_198,
        KEY_199,
        KEY_PLAYCD,
        KEY_PAUSECD,
        KEY_PROG3,
        KEY_PROG4,
        KEY_DASHBOARD,
        KEY_SUSPEND,
        KEY_CLOSE,
        KEY_PLAY,
        KEY_FASTFORWARD,
        KEY_BASSBOOST,
        KEY_PRINT,
        KEY_HP,
        KEY_CAMERA,
        KEY_SOUND,
        KEY_QUESTION,
        KEY_EMAIL,
        KEY_CHAT,
        KEY_SEARCH,
        KEY_CONNECT,
        KEY_FINANCE,
        KEY_SPORT,
        KEY_SHOP,
        KEY_ALTERASE,
        KEY_CANCEL,
        KEY_BRIGHTNESSDOWN,
        KEY_BRIGHTNESSUP,
        KEY_MEDIA,
        KEY_SWITCHVIDEOMODE,
        KEY_KBDILLUMTOGGLE,
        KEY_KBDILLUMDOWN,
        KEY_KBDILLUMUP,
        KEY_SEND,
        KEY_REPLY,
        KEY_FORWARDMAIL,
        KEY_SAVE,
        KEY_DOCUMENTS,
        KEY_BATTERY,
        KEY_BLUETOOTH,
        KEY_WLAN,
        KEY_UWB,
        KEY_UNKNOWN,
        KEY_VIDEO_NEXT,
        KEY_VIDEO_PREV,
        KEY_BRIGHTNESS_CYCLE,
        KEY_BRIGHTNESS_AUTO,
        KEY_DISPLAY_OFF,
        KEY_WWAN,
        KEY_RFKILL,
        KEY_MICMUTE,
        KEY_249,
        KEY_250,
        KEY_251,
        KEY_252,
        KEY_253,
        KEY_254,
        KEY_255,
        BTN_0,
        BTN_1,
        BTN_2,
        BTN_3,
        BTN_4,
        BTN_5,
        BTN_6,
        BTN_7,
        BTN_8,
        BTN_9,
        KEY_266,
        KEY_267,
        KEY_268,
        KEY_269,
        KEY_270,
        KEY_271,
        BTN_LEFT,
        BTN_RIGHT,
        BTN_MIDDLE,
        BTN_SIDE,
        BTN_EXTRA,
        BTN_FORWARD,
        BTN_BACK,
        BTN_TASK,
        KEY_280,
        KEY_281,
        KEY_282,
        KEY_283,
        KEY_284,
        KEY_285,
        KEY_286,
        KEY_287,
        BTN_TRIGGER,
        BTN_THUMB,
        BTN_THUMB2,
        BTN_TOP,
        BTN_TOP2,
        BTN_PINKIE,
        BTN_BASE,
        BTN_BASE2,
        BTN_BASE3,
        BTN_BASE4,
        BTN_BASE5,
        BTN_BASE6,
        KEY_300,
        KEY_301,
        KEY_302,
        BTN_DEAD,
        BTN_SOUTH,
        BTN_EAST,
        BTN_C,
        BTN_NORTH,
        BTN_WEST,
        BTN_Z,
        BTN_TL,
        BTN_TR,
        BTN_TL2,
        BTN_TR2,
        BTN_SELECT,
        BTN_START,
        BTN_MODE,
        BTN_THUMBL,
        BTN_THUMBR,
        KEY_319,
        BTN_TOOL_PEN,
        BTN_TOOL_RUBBER,
        BTN_TOOL_BRUSH,
        BTN_TOOL_PENCIL,
        BTN_TOOL_AIRBRUSH,
        BTN_TOOL_FINGER,
        BTN_TOOL_MOUSE,
        BTN_TOOL_LENS,
        BTN_TOOL_QUINTTAP,
        BTN_STYLUS3,
        BTN_TOUCH,
        BTN_STYLUS,
        BTN_STYLUS2,
        BTN_TOOL_DOUBLETAP,
        BTN_TOOL_TRIPLETAP,
        BTN_TOOL_QUADTAP,
        BTN_GEAR_DOWN,
        BTN_GEAR_UP,
        KEY_338,
        KEY_339,
        KEY_340,
        KEY_341,
        KEY_342,
        KEY_343,
        KEY_344,
        KEY_345,
        KEY_346,
        KEY_347,
        KEY_348,
        KEY_349,
        KEY_350,
        KEY_351,
        KEY_OK,
        KEY_SELECT,
        KEY_GOTO,
        KEY_CLEAR,
        KEY_POWER2,
        KEY_OPTION,
        KEY_INFO,
        KEY_TIME,
        KEY_VENDOR,
        KEY_ARCHIVE,
        KEY_PROGRAM,
        KEY_CHANNEL,
        KEY_FAVORITES,
        KEY_EPG,
        KEY_PVR,
        KEY_MHP,
        KEY_LANGUAGE,
        KEY_TITLE,
        KEY_SUBTITLE,
        KEY_ANGLE,
        KEY_FULL_SCREEN,
        KEY_MODE,
        KEY_KEYBOARD,
        KEY_ASPECT_RATIO,
        KEY_PC,
        KEY_TV,
        KEY_TV2,
        KEY_VCR,
        KEY_VCR2,
        KEY_SAT,
        KEY_SAT2,
        KEY_CD,
        KEY_TAPE,
        KEY_RADIO,
        KEY_TUNER,
        KEY_PLAYER,
        KEY_TEXT,
        KEY_DVD,
        KEY_AUX,
        KEY_MP3,
        KEY_AUDIO,
        KEY_VIDEO,
        KEY_DIRECTORY,
        KEY_LIST,
        KEY_MEMO,
        KEY_CALENDAR,
        KEY_RED,
        KEY_GREEN,
        KEY_YELLOW,
        KEY_BLUE,
        KEY_CHANNELUP,
        KEY_CHANNELDOWN,
        KEY_FIRST,
        KEY_LAST,
        KEY_AB,
        KEY_NEXT,
        KEY_RESTART,
        KEY_SLOW,
        KEY_SHUFFLE,
        KEY_BREAK,
        KEY_PREVIOUS,
        KEY_DIGITS,
        KEY_TEEN,
        KEY_TWEN,
        KEY_VIDEOPHONE,
        KEY_GAMES,
        KEY_ZOOMIN,
        KEY_ZOOMOUT,
        KEY_ZOOMRESET,
        KEY_WORDPROCESSOR,
        KEY_EDITOR,
        KEY_SPREADSHEET,
        KEY_GRAPHICSEDITOR,
        KEY_PRESENTATION,
        KEY_DATABASE,
        KEY_NEWS,
        KEY_VOICEMAIL,
        KEY_ADDRESSBOOK,
        KEY_MESSENGER,
        KEY_DISPLAYTOGGLE,
        KEY_SPELLCHECK,
        KEY_LOGOFF,
        KEY_DOLLAR,
        KEY_EURO,
        KEY_FRAMEBACK,
        KEY_FRAMEFORWARD,
        KEY_CONTEXT_MENU,
        KEY_MEDIA_REPEAT,
        KEY_10CHANNELSUP,
        KEY_10CHANNELSDOWN,
        KEY_IMAGES,
        KEY_443,
        KEY_444,
        KEY_445,
        KEY_446,
        KEY_447,
        KEY_DEL_EOL,
        KEY_DEL_EOS,
        KEY_INS_LINE,
        KEY_DEL_LINE,
        KEY_452,
        KEY_453,
        KEY_454,
        KEY_455,
        KEY_456,
        KEY_457,
        KEY_458,
        KEY_459,
        KEY_460,
        KEY_461,
        KEY_462,
        KEY_463,
        KEY_FN,
        KEY_FN_ESC,
        KEY_FN_F1,
        KEY_FN_F2,
        KEY_FN_F3,
        KEY_FN_F4,
        KEY_FN_F5,
        KEY_FN_F6,
        KEY_FN_F7,
        KEY_FN_F8,
        KEY_FN_F9,
        KEY_FN_F10,
        KEY_FN_F11,
        KEY_FN_F12,
        KEY_FN_1,
        KEY_FN_2,
        KEY_FN_D,
        KEY_FN_E,
        KEY_FN_F,
        KEY_FN_S,
        KEY_FN_B,
        KEY_485,
        KEY_486,
        KEY_487,
        KEY_488,
        KEY_489,
        KEY_490,
        KEY_491,
        KEY_492,
        KEY_493,
        KEY_494,
        KEY_495,
        KEY_496,
        KEY_BRL_DOT1,
        KEY_BRL_DOT2,
        KEY_BRL_DOT3,
        KEY_BRL_DOT4,
        KEY_BRL_DOT5,
        KEY_BRL_DOT6,
        KEY_BRL_DOT7,
        KEY_BRL_DOT8,
        KEY_BRL_DOT9,
        KEY_BRL_DOT10,
        KEY_507,
        KEY_508,
        KEY_509,
        KEY_510,
        KEY_511,
        KEY_NUMERIC_0,
        KEY_NUMERIC_1,
        KEY_NUMERIC_2,
        KEY_NUMERIC_3,
        KEY_NUMERIC_4,
        KEY_NUMERIC_5,
        KEY_NUMERIC_6,
        KEY_NUMERIC_7,
        KEY_NUMERIC_8,
        KEY_NUMERIC_9,
        KEY_NUMERIC_STAR,
        KEY_NUMERIC_POUND,
        KEY_NUMERIC_A,
        KEY_NUMERIC_B,
        KEY_NUMERIC_C,
        KEY_NUMERIC_D,
        KEY_CAMERA_FOCUS,
        KEY_WPS_BUTTON,
        KEY_TOUCHPAD_TOGGLE,
        KEY_TOUCHPAD_ON,
        KEY_TOUCHPAD_OFF,
        KEY_CAMERA_ZOOMIN,
        KEY_CAMERA_ZOOMOUT,
        KEY_CAMERA_UP,
        KEY_CAMERA_DOWN,
        KEY_CAMERA_LEFT,
        KEY_CAMERA_RIGHT,
        KEY_ATTENDANT_ON,
        KEY_ATTENDANT_OFF,
        KEY_ATTENDANT_TOGGLE,
        KEY_LIGHTS_TOGGLE,
        KEY_543,
        BTN_DPAD_UP,
        BTN_DPAD_DOWN,
        BTN_DPAD_LEFT,
        BTN_DPAD_RIGHT,
        KEY_548,
        KEY_549,
        KEY_550,
        KEY_551,
        KEY_552,
        KEY_553,
        KEY_554,
        KEY_555,
        KEY_556,
        KEY_557,
        KEY_558,
        KEY_559,
        KEY_ALS_TOGGLE,
        KEY_ROTATE_LOCK_TOGGLE,
        KEY_562,
        KEY_563,
        KEY_564,
        KEY_565,
        KEY_566,
        KEY_567,
        KEY_568,
        KEY_569,
        KEY_570,
        KEY_571,
        KEY_572,
        KEY_573,
        KEY_574,
        KEY_575,
        KEY_BUTTONCONFIG,
        KEY_TASKMANAGER,
        KEY_JOURNAL,
        KEY_CONTROLPANEL,
        KEY_APPSELECT,
        KEY_SCREENSAVER,
        KEY_VOICECOMMAND,
        KEY_ASSISTANT,
        KEY_KBD_LAYOUT_NEXT,
        KEY_585,
        KEY_586,
        KEY_587,
        KEY_588,
        KEY_589,
        KEY_590,
        KEY_591,
        KEY_BRIGHTNESS_MIN,
        KEY_BRIGHTNESS_MAX,
        KEY_594,
        KEY_595,
        KEY_596,
        KEY_597,
        KEY_598,
        KEY_599,
        KEY_600,
        KEY_601,
        KEY_602,
        KEY_603,
        KEY_604,
        KEY_605,
        KEY_606,
        KEY_607,
        KEY_KBDINPUTASSIST_PREV,
        KEY_KBDINPUTASSIST_NEXT,
        KEY_KBDINPUTASSIST_PREVGROUP,
        KEY_KBDINPUTASSIST_NEXTGROUP,
        KEY_KBDINPUTASSIST_ACCEPT,
        KEY_KBDINPUTASSIST_CANCEL,
        KEY_RIGHT_UP,
        KEY_RIGHT_DOWN,
        KEY_LEFT_UP,
        KEY_LEFT_DOWN,
        KEY_ROOT_MENU,
        KEY_MEDIA_TOP_MENU,
        KEY_NUMERIC_11,
        KEY_NUMERIC_12,
        KEY_AUDIO_DESC,
        KEY_3D_MODE,
        KEY_NEXT_FAVORITE,
        KEY_STOP_RECORD,
        KEY_PAUSE_RECORD,
        KEY_VOD,
        KEY_UNMUTE,
        KEY_FASTREVERSE,
        KEY_SLOWREVERSE,
        KEY_DATA,
        KEY_ONSCREEN_KEYBOARD,
        KEY_633,
        KEY_634,
        KEY_635,
        KEY_636,
        KEY_637,
        KEY_638,
        KEY_639,
        KEY_640,
        KEY_641,
        KEY_642,
        KEY_643,
        KEY_644,
        KEY_645,
        KEY_646,
        KEY_647,
        KEY_648,
        KEY_649,
        KEY_650,
        KEY_651,
        KEY_652,
        KEY_653,
        KEY_654,
        KEY_655,
        KEY_656,
        KEY_657,
        KEY_658,
        KEY_659,
        KEY_660,
        KEY_661,
        KEY_662,
        KEY_663,
        KEY_664,
        KEY_665,
        KEY_666,
        KEY_667,
        KEY_668,
        KEY_669,
        KEY_670,
        KEY_671,
        KEY_672,
        KEY_673,
        KEY_674,
        KEY_675,
        KEY_676,
        KEY_677,
        KEY_678,
        KEY_679,
        KEY_680,
        KEY_681,
        KEY_682,
        KEY_683,
        KEY_684,
        KEY_685,
        KEY_686,
        KEY_687,
        KEY_688,
        KEY_689,
        KEY_690,
        KEY_691,
        KEY_692,
        KEY_693,
        KEY_694,
        KEY_695,
        KEY_696,
        KEY_697,
        KEY_698,
        KEY_699,
        KEY_700,
        KEY_701,
        KEY_702,
        KEY_703,
        BTN_TRIGGER_HAPPY1,
        BTN_TRIGGER_HAPPY2,
        BTN_TRIGGER_HAPPY3,
        BTN_TRIGGER_HAPPY4,
        BTN_TRIGGER_HAPPY5,
        BTN_TRIGGER_HAPPY6,
        BTN_TRIGGER_HAPPY7,
        BTN_TRIGGER_HAPPY8,
        BTN_TRIGGER_HAPPY9,
        BTN_TRIGGER_HAPPY10,
        BTN_TRIGGER_HAPPY11,
        BTN_TRIGGER_HAPPY12,
        BTN_TRIGGER_HAPPY13,
        BTN_TRIGGER_HAPPY14,
        BTN_TRIGGER_HAPPY15,
        BTN_TRIGGER_HAPPY16,
        BTN_TRIGGER_HAPPY17,
        BTN_TRIGGER_HAPPY18,
        BTN_TRIGGER_HAPPY19,
        BTN_TRIGGER_HAPPY20,
        BTN_TRIGGER_HAPPY21,
        BTN_TRIGGER_HAPPY22,
        BTN_TRIGGER_HAPPY23,
        BTN_TRIGGER_HAPPY24,
        BTN_TRIGGER_HAPPY25,
        BTN_TRIGGER_HAPPY26,
        BTN_TRIGGER_HAPPY27,
        BTN_TRIGGER_HAPPY28,
        BTN_TRIGGER_HAPPY29,
        BTN_TRIGGER_HAPPY30,
        BTN_TRIGGER_HAPPY31,
        BTN_TRIGGER_HAPPY32,
        BTN_TRIGGER_HAPPY33,
        BTN_TRIGGER_HAPPY34,
        BTN_TRIGGER_HAPPY35,
        BTN_TRIGGER_HAPPY36,
        BTN_TRIGGER_HAPPY37,
        BTN_TRIGGER_HAPPY38,
        BTN_TRIGGER_HAPPY39,
        BTN_TRIGGER_HAPPY40,
        BTN_MAX,
        MouseWheelUp,
        MouseWheelDown,
        MouseWheelLeft,
        MouseWheelRight,
        KEY_749,
        KEY_750,
        KEY_751,
        KEY_752,
        KEY_753,
        KEY_754,
        KEY_755,
        KEY_756,
        KEY_757,
        KEY_758,
        KEY_759,
        KEY_760,
        KEY_761,
        KEY_762,
        KEY_763,
        KEY_764,
        KEY_765,
        KEY_766,
        KEY_MAX,
    ];

    for osc in oscs.iter().copied() {
        let roundtrip = OsCode::from(KeyCode::from(osc));
        assert_eq!(osc, roundtrip);
    }
}
