/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import org.jmol.g3d.Graphics3D;
import org.jmol.g3d.Shade3D;
import org.jmol.util.Int2IntHash;

class Colix3D {
    private static int colixMax = 4;
    private static int[] argbs = new int[128];
    private static int[] argbsGreyscale;
    private static int[][] ashades;
    private static int[][] ashadesGreyscale;
    private static final Int2IntHash colixHash;
    static final int[] predefinedArgbs;

    Colix3D() {
    }

    static short getColix(int n) {
        int n2;
        if (n == 0) {
            return 0;
        }
        int n3 = 0;
        if ((n & 0xFF000000) != -16777216) {
            n |= 0xFF000000;
            n3 = 8192;
        }
        return (n2 = colixHash.get(n)) > 0 ? (short)(n2 | n3) : (short)(Colix3D.allocateColix(n) | n3);
    }

    private static synchronized int allocateColix(int n) {
        if ((n & 0xFF000000) != -16777216) {
            throw new IndexOutOfBoundsException();
        }
        int n2 = colixMax;
        while (--n2 >= 4) {
            if (n != argbs[n2]) continue;
            return (short)n2;
        }
        if (colixMax == argbs.length) {
            n2 = colixMax;
            int n3 = n2 * 2;
            int[] nArray = new int[n3];
            System.arraycopy(argbs, 0, nArray, 0, n2);
            argbs = nArray;
            if (argbsGreyscale != null) {
                nArray = new int[n3];
                System.arraycopy(argbsGreyscale, 0, nArray, 0, n2);
                argbsGreyscale = nArray;
            }
            int[][] nArrayArray = new int[n3][];
            System.arraycopy(ashades, 0, nArrayArray, 0, n2);
            ashades = nArrayArray;
            if (ashadesGreyscale != null) {
                nArrayArray = new int[n3][];
                System.arraycopy(ashadesGreyscale, 0, nArrayArray, 0, n2);
                ashadesGreyscale = nArrayArray;
            }
        }
        Colix3D.argbs[Colix3D.colixMax] = n;
        if (argbsGreyscale != null) {
            Colix3D.argbsGreyscale[Colix3D.colixMax] = Graphics3D.calcGreyscaleRgbFromRgb(n);
        }
        colixHash.put(n, colixMax);
        return colixMax++;
    }

    private static synchronized void calcArgbsGreyscale() {
        if (argbsGreyscale != null) {
            return;
        }
        int[] nArray = new int[argbs.length];
        int n = argbs.length;
        while (--n >= 4) {
            nArray[n] = Graphics3D.calcGreyscaleRgbFromRgb(argbs[n]);
        }
        argbsGreyscale = nArray;
    }

    static final int getArgb(short s) {
        return argbs[s & 0xFFFF87FF];
    }

    static final int getArgbGreyscale(short s) {
        if (argbsGreyscale == null) {
            Colix3D.calcArgbsGreyscale();
        }
        return argbsGreyscale[s & 0xFFFF87FF];
    }

    static final int[] getShades(short s) {
        int[] nArray = ashades[s = (short)(s & 0xFFFF87FF)];
        if (nArray == null) {
            Colix3D.ashades[s] = Shade3D.getShades(argbs[s], false);
            nArray = Colix3D.ashades[s];
        }
        return nArray;
    }

    static final int[] getShadesGreyscale(short s) {
        int[] nArray;
        s = (short)(s & 0xFFFF87FF);
        if (ashadesGreyscale == null) {
            ashadesGreyscale = new int[ashades.length][];
        }
        if ((nArray = ashadesGreyscale[s]) == null) {
            Colix3D.ashadesGreyscale[s] = Shade3D.getShades(argbs[s], true);
            nArray = Colix3D.ashadesGreyscale[s];
        }
        return nArray;
    }

    static final synchronized void flushShades() {
        int n = colixMax;
        while (--n >= 0) {
            Colix3D.ashades[n] = null;
        }
        Shade3D.sphereShadingCalculated = false;
    }

    static {
        ashades = new int[128][];
        colixHash = new Int2IntHash();
        predefinedArgbs = new int[]{-16777216, -23296, -16181, -16776961, -1, -16711681, -65536, -16744448, -8355712, -4144960, -16711936, -8388608, -16777088, -8355840, -8388480, -16744320, -65281, -256, -38476, -10496};
        for (int i = 0; i < predefinedArgbs.length; ++i) {
            Colix3D.getColix(predefinedArgbs[i]);
        }
    }
}

