#
# sgtone.rb
#
# $Id$
#

require "numru/dcl"

include NumRu
include Math


np = 5
nt = 6
dd = 0.13
ds = 0.005
dx = dd+ds*2
dy = 1.0 / nt


#-- data ---
xbox = NArray[0.0, 1.0, 1.0, 0.0, 0.0]
ybox = NArray[0.0, 0.0, 1.0, 1.0, 0.0]

#-- graph ---
iw = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i
#ifn = (puts ' SOFT FILL=1/HARD FILL=2 (I) ? ;'; gets).to_i
ifn=1
n = (puts ' TONE PATTERN (0-6) (I) ? ;'; gets).to_i

DCL::gliset('MAXMSG', 300)
DCL::sgopn iw

if (ifn == 1)
  DCL::sglset('LSOFTF', true)
else
  DCL::sglset('LSOFTF', false)
end

DCL::sglset('LFULL', true)
DCL::sgiset('INDEX', 3)

DCL::slrat(0.85, 1.0)
DCL::slmgn(0.0, 0.0, 0.05, 0.1)

cttl = format("TONE PATTERN = %1dXX", n)
DCL::slsttl(cttl, 'T', 0.0, -0.5, 0.03, 1)

DCL::sgfrm
DCL::sgswnd(0.0, 1.0, 0.0, 1.0)
DCL::sgstrn(1)
for j in 0..5
  for i in 0..5
    x1=dx*i+ds+(1-dx*nt)/2
    x2=x1+dd
    y1=dy*(5-j)+ds
    y2=y1+dd
    level=i+j*10+n*100
    DCL::sgsvpt(x1, x2, y1, y2)
    DCL::sgstrf
    chr = format("%5d", level)
    DCL::sgtnzu(xbox, ybox, level)
    DCL::sgplzu(xbox, ybox, 1, 1)
    DCL::sgtxzv(x2, y2+(dy-dd)/2, chr, 0.015, 0, 1, 3)
  end
end

DCL::sgcls

