#
#      program gt2d01
#
#      T Horinouchi 2004/11/11

require "numru/dcl"
include NumRu
include NMath

nx=15
ny=15

ux = NArray.sfloat(nx).indgen!/(nx-1.0) - 0.5
terrain = 0.1 * exp(-24*ux**2)
uy = NArray.sfloat(ny).indgen!/(ny-1.0)

cx = NArray.sfloat(nx,ny)
cx[0,0] = DCL::glrget('rundef')
cy = uy.reshape(1,ny)*(1.0-terrain) + terrain

DCL::g2sctr(ux,uy, cx,cy)

print "terrain following coordinate\n"

uxp = 0.2
uyp = 0.3
print "original ux, uy:", uxp, "  ", uyp,"\n"

cxp, cyp = DCL::g2fctr(uxp, uyp)
print "transformed cx, cy:", cxp, "  ",  cyp,"\n"
uxp, uyp = DCL::g2ictr(cxp, cyp)
print "inverted ux, uy:", uxp, "  ",  uyp,"\n"
print "(...Note that DCL uses single precision floats.)\n"
