# Program: cproto2init.rb
#          2000/11/20 Takeshi Horinouchi
# Usage:
#
#     % ruby cproto2init.rb cprotofile
#
#  Here, cprotofile is the name of the C program obtained by,
#  for example,
#
#     ruby proto2c.rb grph2_grpack.fp > grph2_grpack.c
#
#  The package name is determined from the file name such as
#  'grph2_grpack'.

package =  $*[0].gsub(/.*\//,'').sub(/\..*/,'')    # remove directory name
                                                  # and suffix
print("void\n","init_",package,"(mDCL)\n","VALUE mDCL;\n","{\n")

macro_dclver = false 

while (line=gets)
  case line
  when /^static VALUE/
    funcdef = gets.chop
    func = funcdef.sub(/\(.*$/,'')
    nargs = funcdef.delete('^,').length
    method = func.sub(/dcl_/,'')
    print('    rb_define_module_function(mDCL, "',method,
	   '", ',func,", ",nargs,");\n")
  when  /^#if *DCLVER/
    macro_dclver = true
    print line
  when /^#endif/
    if macro_dclver
      print line
      macro_dclver = false
    end
  end
end

print "}\n"
