#
# color1.rb
#   $Id$
#


require "numru/dcl"
include NumRu
include Math


np = 4
nt = 10
dd = 0.07
ds = 0.003
dx = dd+ds*2
dy = 1.0/nt

#-- data ---
xbox = NArray[0.0, 1.0, 1.0, 0.0]
ybox = NArray[0.0, 0.0, 1.0, 1.0]

#-- graph ---
iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i
DCL::gliset('MAXMSG', 300)

DCL::sgopn(-(iws).abs)

DCL::sglset('LFULL', true)
DCL::slrat(0.85, 1.0)
DCL::slmgn(0.0, 0.0, 0.05, 0.1)
DCL::slsttl('TEST OF COLORMAP', 'T', 0.0, -0.5, 0.025, 1)

DCL::sgfrm
DCL::sgswnd(0.0, 1.0, 0.0, 1.0)
DCL::sgstrn(1)

DCL::sgstxs(0.01)
DCL::sgstxc(1)
for j in 0..9
  for i in 0..9
    x1 = dx*i     + ds + (1-dx*nt)/2
    y1 = dy*(9-j) + ds
    x2 = x1 + dd
    y2 = y1 + dd
    itpat = (i+j*10)*1000 + 999

    DCL::sgsvpt(x1, x2, y1, y2)
    DCL::sgstrf

    DCL::slpvpr(1)
    DCL::sgstnp(itpat)
    DCL::sgtnu(xbox, ybox)
    chr = format("%5d", itpat)
    DCL::sgtxv(x2, y2+(dy-dd)/2, chr)
  end
end

DCL::sgcls

