/*
 * $Id$
 */

#include <stdio.h>
#include "ruby.h"
#include "narray.h"
#include "cdcl.h"

/* for compatibility with ruby 1.6 */
#ifndef StringValuePtr
#define StringValuePtr(s) STR2CSTR(s)
#endif

#define DFLT_SIZE 32

#ifndef NARRAY_BIGMEM
typedef int    na_shape_t;
#endif

extern char    *dcl_obj2ccharary(VALUE, int, int);
extern integer *dcl_obj2cintegerary(VALUE);
extern real    *dcl_obj2crealary(VALUE);
extern complex *dcl_obj2ccomplexary(VALUE);
extern logical *dcl_obj2clogicalary(VALUE);

extern VALUE dcl_ccharary2obj(char *, int, int);
extern VALUE dcl_cintegerary2obj(integer *, na_shape_t, int, na_shape_t *);
extern VALUE dcl_crealary2obj(real *, na_shape_t, int, na_shape_t *);
/* extern VALUE dcl_ccomplexary2obj(complex *, int, char *); */
extern VALUE dcl_clogicalary2obj(logical *, na_shape_t, int, na_shape_t *);

extern void dcl_freeccharary(char *);
extern void dcl_freecintegerary(integer *);
extern void dcl_freecrealary(real *);
extern void dcl_freeccomplexary(complex *);
extern void dcl_freeclogicalary(logical *);

/* for functions which return real */
/* fnclib */
extern real rd2r_(real *);
extern real rr2d_(real *);
extern real rexp_(real *, integer *, integer *);
extern real rfpi_(void);
extern real rmod_(real *, real *);
/* gnmlib */
extern real rgnlt_(real *);
extern real rgnle_(real *);
extern real rgngt_(real *);
extern real rgnge_(real *);
/* rfalib */
extern real rmax_(real *, integer *, integer *);
extern real rmin_(real *, integer *, integer *);
extern real rsum_(real *, integer *, integer *);
extern real rave_(real *, integer *, integer *);
extern real rvar_(real *, integer *, integer *);
extern real rstd_(real *, integer *, integer *);
extern real rrms_(real *, integer *, integer *);
extern real ramp_(real *, integer *, integer *);
/* rfblib */
extern real rprd_(real *, real *, integer *, integer *, integer *);
extern real rcov_(real *, real *, integer *, integer *, integer *);
extern real rcor_(real *, real *, integer *, integer *, integer *);


extern VALUE mDCL;

static VALUE
dcl_csgi(obj, ic)
    VALUE obj, ic;
{
    integer i_ic;
    char *o_rtn_val;
    VALUE rtn_val;

    if ((TYPE(ic) != T_BIGNUM) || (TYPE(ic) != T_FIXNUM)) {
      ic = rb_funcall(ic, rb_intern("to_i"), 0);
    }

    i_ic = NUM2INT(ic);

    o_rtn_val= ALLOCA_N(char, (2));
    memset(o_rtn_val, '\0', 2);

    csgi__(o_rtn_val, (ftnlen)1, &i_ic);

    rtn_val = rb_str_new2(o_rtn_val);


    return rtn_val;

}

static VALUE
dcl_isgc(obj, ch)
    VALUE obj, ch;
{
    char *i_ch;
    integer o_rtn_val;
    VALUE rtn_val;

    if (TYPE(ch) != T_STRING) {
      ch = rb_funcall(ch, rb_intern("to_str"), 0);
    }

    i_ch = StringValuePtr(ch);


    o_rtn_val = isgc__(i_ch, (ftnlen)strlen(i_ch));

    rtn_val = INT2NUM(o_rtn_val);


    return rtn_val;

}

static VALUE
dcl_usgi(obj, ic)
    VALUE obj, ic;
{
    integer i_ic;
    char *o_rtn_val;
    VALUE rtn_val;

    if ((TYPE(ic) != T_BIGNUM) || (TYPE(ic) != T_FIXNUM)) {
      ic = rb_funcall(ic, rb_intern("to_i"), 0);
    }

    i_ic = NUM2INT(ic);

    o_rtn_val= ALLOCA_N(char, (3+1));
    memset(o_rtn_val, '\0', 3+1);

    usgi__(o_rtn_val, (ftnlen)3, &i_ic);

    rtn_val = rb_str_new2(o_rtn_val);


    return rtn_val;

}
void
init_grph1_csgi(mDCL)
VALUE mDCL;
{
    rb_define_module_function(mDCL, "csgi", dcl_csgi, 1);
    rb_define_module_function(mDCL, "isgc", dcl_isgc, 1);
    rb_define_module_function(mDCL, "usgi", dcl_usgi, 1);
}
