#!/bin/sh
#
# Copyright (C) GFD Dennou Club, 2002-2013.  All rights reserved.
#
prefix=$PREFIX
fc=$FC
mpifc=$MPIFC
fcflags=$FCFLAGS
ldflags=$LDFLAGS
ldlibs=$LDLIBS
version=$VERSION
out=${1:-spmconfig}

cat > $out <<END_OF_SCRIPT
#!/bin/sh
#=begin
#== NAME
#((* $out *)) -- output environment vaiables for using spml library.
#
#get environment variables using spml
#
#== SYNTAX
#
# % $out  [OPTIONS]
#
#== DESCRIPTION
#
#((* $out *)) is simple shell script.
#This script output environment variables for using spml library.
#
#== OPTION
#
#:--help
#  display this help message and exit
#:--all
#  display all options
#:--fc
#  output fortran compiler name using spml libarary
#:--mpifc
#  output MPI fortran compiler name using spml libarary
#:--fcflags
#  output fortran FCFLAGS using spml libarary
#:--ldflags
#  output fortran LDFLAGS using spml libarary
#:--ldlibs
#  output fortran LDLIBS using spml libarary
#:--prefix
#  output install prefix of spml
#:--includedir
#  output include (module file) directory of spml library
#== BUGS
#
#If you find a bug, please report it at SPMODEL Development Group
#<dcstaff_(at)_gfd-dennou.org>
#
#=end

END_OF_SCRIPT

cat >> $out <<END_OF_SCRIPT
prefix="$prefix"
exec_prefix=${prefix}
libdir=${exec_prefix}/lib
includedir=${prefix}/include

fc="$fc"
mpifc="$mpifc"
fcflags="$fcflags"
ldflags="$ldflags"
ldlibs="$ldlibs"
version="$version"

usage() {
	cat <<EOF
Usage: $out [OPTION]

Available values for OPTION include:

  --help        display this help message and exit
  --all         display all options
  --fc          output fortran compiler name using spml libarary
  --mpifc       output MPI fortran compiler name using spml libarary
  --fcflags     output fortran FCFLAGS using spml libarary
  --ldflags     output fortran LDFLAGS using spml library
  --ldlibs      output fortran LDLIBS using spml library
  --prefix      output install prefix of spml
  --includedir  output include(module file) directory of spml library
  --version     output version

EOF

	exit \$1

}

all()
{
        echo
        echo "This \$version has been built with the following features: "
        echo
        echo "  --fc         -> \$fc"
        echo "  --mpifc      -> \$mpifc"
        echo "  --fcflags    -> \$fcflags"
        echo "  --ldflags    -> \$ldflags"
        echo "  --ldlibs     -> \$ldlibs"
        echo
        echo "  --prefix     -> \$prefix"
        echo "  --includedir -> \$includedir"
        echo "  --version    -> \$version"
        echo
}

if test \$# -eq 0; then
	usage
fi

while test \$# -gt 0; do
    case "\$1" in
        -*=*) value=`echo "\$1" | sed 's/[-_a-zA-Z0-9]*=//'` ;;
        *) value= ;;
    esac

    case "\$1" in
    --help)       usage 0              ;;
    --all)        all                  ;;
	--fc)		  echo \$fc            ;;
	--mpifc)	  echo \$mpifc         ;;
	--fcflags)	  echo \$fcflags       ;;
	--ldflags)	  echo \$ldflags       ;;
	--ldlibs)	  echo \$ldlibs        ;;
    --prefix)     echo \$prefix        ;;
    --includedir) echo \$includedir    ;;
    --version)    echo \$version       ;;
	*)
    echo "unknown option: \$1" usage 1 ;;
    esac
    shift
done
exit 0
END_OF_SCRIPT
