!--
!----------------------------------------------------------------------
! Copyright(c) 2006-2013 SPMDODEL Development Group. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  et_galerkin_module
!
!      2 ϩΰ
!      Fourier Ÿ + ӥաݥ顼ˡѥ⥸塼
!
!  2006/01/24  ݹ  
!      2006/02/28  ݹ  Ȥ RDoc Ѥѹ
!      2009/06/03  ݹ  ʬؿɲý
!      2009/06/05  ݹ  et_ef, et_eh ̾ѹ, 
!      2009/07/05  ݹ  et_LaplaInv_et ɲ
!      2009/07/31  ݹ  ׻ threadprivate (OpenMP)
!      2010/03/10  ʿ  threadprivate (ѥ¸)
!      2013/08/24  ݹ   gfortran б
!
!++
module et_galerkin_module
  !
  != et_galerkin_module
  !
  ! Authors:: Shin-ichi Takehiro, Youhei SASAKI
  ! Version:: $Id: et_galerkin_module.f90 610 2013-08-24 12:46:42Z takepiro $
  ! Copyright&License:: See COPYRIGHT[link:../COPYRIGHT]
  !
  !== 
  !
  ! spml/et_galerkin_module ⥸塼 2 ͥΰǤήαư
  ! 򥹥ڥȥˡˤͷ׻뤿 Fortran90 ؿ󶡤.
  ! Ūʶ򰷤 X ؤΥաꥨѴ, 
  ! ɤ򰷤 Y ΥӥѴ(ӥա顼ˡ)
  ! Υڥȥ׻ΤΤޤޤʴؿ󶡤
  !
  !  et_module, Ӷ򤯤˥ӥա顼ˡ
  ! ⥸塼뷲(at_ab_galerkin_ND, at_ad_galerkin_DD, at_af_galerkin_MM,
  ! at_ah_galerkin_MMex, at_ap_galerkin_DN, at_aq_galerkin_RRFF,
  ! at_av_galerkin_NN) ѤƤ.
  !
  !== ؿѿ̾ȷˤĤ
  !
  !=== ̿̾ˡ
  !
  ! * ؿ̾Ƭ (et_, yx_, x_, y_...) , ֤ͤη򼨤Ƥ.
  !
  !   et_ :: 2ڥȥǡ
  !   yx_ :: 2 ʻǡ
  !   x_  :: X  1 ʻǡ
  !   y_  :: Y  1 ʻǡ
  !
  !   ed_ :: 2顼ǡ(y=ymin,ymax ͤ 0)
  !   ev_ :: 2顼ǡ(y=ymin,ymax  1 ʬͤ 0)
  !   eb_ :: 2顼ǡ(y=ymin ͤ 0, ymax  1 ʬͤ 0)
  !   ep_ :: 2顼ǡ(y=ymin 1 ʬͤ 0, ymax  ͤ 0)
  !   ef_ :: 2顼ǡ(y=ymin,ymax Ǻ維郎 0)
  !   eh_ :: 2顼ǡ(y=ymin,ymax ǿʿȿκ維郎 0)
  !   eq_ :: 2ήؿ顼ǡ(y=ymin,ymax Ǽͳ٤/Ǵ)
  !
  ! * ؿ̾δ֤ʸ(Dx, Dy, Lapla, LaplaInv, Jacobian), 
  !   δؿκѤɽƤ.
  !
  ! * ؿ̾κǸ (_et_et, _et, _yx, _x, _y...) , ѿΥڥȥǡ
  !   ʻǡӥ顼Ǥ뤳Ȥ򼨤Ƥ.
  !
  !   _et :: 2ڥȥǡ
  !   _yx :: 2 ʻǡ
  !   _x  :: X  1 ʻǡ
  !   _y  :: Y  1 ʻǡ
  !   _ed :: 2顼ǡ(y=ymin,ymax ͤ 0)
  !   _ev :: 2顼ǡ(y=ymin,ymax  1 ʬͤ 0)
  !   _eb :: 2顼ǡ(y=ymin ͤ 0, ymax  1 ʬͤ 0)
  !   _ep :: 2顼ǡ(y=ymin 1 ʬͤ 0, ymax  ͤ 0)
  !   _ef :: 2顼ǡ(y=ymin,ymax Ǻ維郎 0)
  !   _eh :: 2顼ǡ(y=ymin,ymax ǿʿȿκ維郎 0)
  !   _eq :: 2ήؿ顼ǡ(y=ymin,ymax Ǽͳ٤/Ǵ)
  !
  !=== ƥǡμ
  !
  ! * yx : 2 ʻǡ.
  !   * ѿμȼ real(8), dimension(0:jm,0:im-1). 
  !   * im, jm Ϥ줾 X, Y ɸγʻǤ, ֥롼
  !     et_galerkin_Initial ˤƤ餫ꤷƤ.
  !   *  1  Y ɸγʻֹ,  2  X ɸ
  !     ʻֹǤ (X, Y νǤϤʤ)Ȥ.
  !
  ! * et : 2 ڥȥǡ.
  !   * ѿμȼ real(8), dimension(-km:km,0:lm). 
  !   * km, lm Ϥ줾 X, Y κȿǤ, ֥롼
  !     et_galerkin_Initial ˤƤ餫ꤷƤ. 
  !   * ڥȥǡγǼΤˤĤƤ...
  !
  ! * ed, ev, eb, ef, eh : 2 顼ǡ. 
  !   * ѿμȼ real(8), dimension(-km:km,2:lm). 
  !   * km, lm Ϥ줾 X, Y κȿǤ, ֥롼
  !     et_galerkin_Initial ˤƤ餫ꤷƤ. 
  !
  ! * eq : 2 顼ǡ. 
  !   * ѿμȼ real(8), dimension(-km:km,4:lm). 
  !   * km, lm Ϥ줾 X, Y κȿǤ, ֥롼
  !     et_galerkin_Initial ˤƤ餫ꤷƤ. 
  !
  ! * x, y : X, Y  1 ʻǡ.
  !   * ѿμȼϤ줾 real(8), dimension(0:im-1)
  !      real(8), dimension(0:jm).
  !
  ! * e, t : 1 ڥȥǡ.
  !   * ѿμȼ real(8), dimension(-km:km) 
  !      real(8), dimension(-lm:lm).
  !
  ! * ax, ay : 1 ʻǡ¤ 2 .
  !   * ѿμȼ real(8), dimension(:,0:im-1) 
  !      real(8), dimension(:,0:jm).
  !
  ! * ae, at : 1 ڥȥǡ¤ 2 .
  !   * ѿμȼ real(8), dimension(:,-km:km) 
  !      real(8), dimension(:,0:lm).
  !
  ! * et_ ǻϤޤؿ֤ͤϥڥȥǡƱ.
  !
  ! * ed_, ev_, eb_, ep_, ef_, eh_, eq_ ǻϤޤؿ֤ͤ
  !   顼ǡƱ.
  !
  ! * yx_ ǻϤޤؿ֤ͤ 2 ʻǡƱ.
  !
  ! * x_, y_ ǻϤޤؿ֤ͤ 1 ʻǡƱ.
  !
  ! * ڥȥ/顼ǡФʬκѤȤ, 
  !   бʻǡʬʤɤѤǡ
  !   ڥȥ/顼ѴΤȤǤ.
  !
  !== ѿ³
  !
  !====  
  !
  ! et_galerlin_Initial :: ڥȥ/顼Ѵγʻ, ȿ, 
  !                        ΰ礭, Ѥ륬顼ѿ
  ! 
  !==== ɸѿ
  !
  ! x_X, y_Y     ::  ʻɸ(X,Yɸ)Ǽ 1 
  ! x_X_Weight, y_Y_Weight ::  ŤߺɸǼ 1 
  ! yx_X, yx_Y   :: ʻǡ XY ɸ(X,Y)(ʻǡ 2 )
  !
  !==== Ѵ
  !
  ! yx_et :: ڥȥǡʻҥǡؤѴ
  ! et_yx :: ʻҥǡ饹ڥȥǡؤѴ
  ! ax_ae, x_e :: X ΥڥȥǡʻҥǡؤѴ
  ! ay_at, y_t :: Y ΥڥȥǡʻҥǡؤѴ
  ! ae_ax, e_x :: X γʻǡ饹ڥȥǡؤѴ
  ! at_ay, t_y :: Y γʻǡ饹ڥȥǡؤѴ
  !
  ! ed_yx      :: 顼ǡ->ʻѴ 
  ! yx_ed      :: ʻ->顼ǡѴ 
  ! ed_et, d_t :: ӥ->顼Ѵ
  ! et_ed, t_d :: 顼->ӥѴ
  ! ed_ey, d_y :: ʻ->顼ǡѴ
  ! ey_ed, y_d :: 顼->ʻǡѴ
  !
  ! ev_yx      :: 顼ǡ->ʻѴ 
  ! yx_ev      :: ʻ->顼ǡѴ 
  ! ev_et, v_t :: ӥ->顼Ѵ
  ! et_ev, t_v :: 顼->ӥѴ
  ! ev_ey, v_y :: ʻ->顼ǡѴ
  ! ey_ev, y_v :: 顼->ʻǡѴ
  !
  ! eb_yx      :: 顼ǡ->ʻѴ 
  ! yx_eb      :: ʻ->顼ǡѴ 
  ! eb_et, b_t :: ӥ->顼Ѵ
  ! et_eb, t_b :: 顼->ӥѴ
  ! eb_ey, b_y :: ʻ->顼ǡѴ
  ! ey_eb, y_b :: 顼->ʻǡѴ
  !
  ! ep_yx      :: 顼ǡ->ʻѴ 
  ! yx_ep      :: ʻ->顼ǡѴ 
  ! ep_et, p_t :: ӥ->顼Ѵ
  ! et_ep, t_p :: 顼->ӥѴ
  ! ep_ey, p_y :: ʻ->顼ǡѴ
  ! ey_ep, y_p :: 顼->ʻǡѴ
  !
  ! ef_yx      :: 顼ǡ->ʻѴ 
  ! yx_ef      :: ʻ->顼ǡѴ 
  ! ef_et, f_t :: ӥ->顼Ѵ
  ! et_ef, t_f :: 顼->ӥѴ
  ! ef_ey, f_y :: ʻ->顼ǡѴ
  ! ey_ef, y_f :: 顼->ʻǡѴ
  !
  ! eh_yx      :: 顼ǡ->ʻѴ 
  ! yx_eh      :: ʻ->顼ǡѴ 
  ! eh_et      :: ӥ->顼Ѵ
  ! et_eh      :: 顼->ӥѴ
  ! eh_ey      :: ʻ->顼ǡѴ
  ! ey_eh      :: 顼->ʻǡѴ
  !
  ! eq_yx      :: 顼ǡ->ʻѴ 
  ! yx_eq      :: ʻ->顼ǡѴ 
  ! eq_et, q_t :: ӥ->顼Ѵ
  ! et_eq, t_q :: 顼->ӥѴ
  ! eq_ey, q_y :: ʻ->顼ǡѴ
  ! ey_eq, y_q :: 顼->ʻǡѴ
  !
  !==== ʬ
  !
  ! et_Lapla_et     :: ڥȥǡ˥ץ饷Ѥ
  ! et_LaplaInv_et  :: ڥȥǡ˵եץ饷Ѥ
  ! et_Dx_et, ae_Dx_ae, e_Dx_e :: ڥȥǡ X ʬѤ
  ! et_Dy_et, at_Dy_at, t_Dy_t :: ڥȥǡ Y ʬѤ
  ! et_Jacobian_et_et :: 2 ĤΥڥȥǡ䥳ӥ׻
  !
  ! ed_Dx_ed         :: X ʬ
  ! ed_Dy_ed, d_Dy_d :: Y ʬ
  ! ev_Dx_ev         :: X ʬ
  ! ev_Dy_ev, v_Dy_v :: Y ʬ
  ! eb_Dx_eb         :: X ʬ
  ! eb_Dy_eb, b_Dy_b :: Y ʬ
  ! ep_Dx_ep         :: X ʬ
  ! ep_Dy_ep, p_Dy_p :: Y ʬ
  ! ef_Dx_ef         :: X ʬ
  ! ef_Dy_ef, f_Dy_f :: Y ʬ
  ! eh_Dx_eh         :: X ʬ
  ! eh_Dy_eh         :: Y ʬ
  ! eq_Dx_eq         :: X ʬ
  ! eq_Dy_eq, q_Dy_q :: Y ʬ
  !
  !==== 
  !
  ! eq_Vor2Strm_eq :: ٤ή׻
  !
  !==== ʬʿ
  !
  ! IntYX_yx, AvrYX_yx   :: 2 ʻǡΰʬʿ
  ! y_IntX_yx, y_AvrX_yx :: 2 ʻǡ X ʬʿ
  ! IntX_x, AvrX_x       :: 1 (X)ʻǡ X ʬʿ
  ! x_IntY_yx, x_AvrY_yx :: 2 ʻǡ Y ʬʿ
  ! IntY_y, AvrY_y       :: 1 (Y)ʻǡ Y ʬʿ
  !
  !== 
  !
  ! Y ʬ׻Ϣ³ƹԤˤϥ顼ǡѴؿѤΤǤʤ
  ! ӥեڥȥѴؿѤ뤳
  !
  !    : ed_Dy_ed(ed_Dy_ed(ed)
  !    : ed_et(et_Dy_et(et_Dy_et(et_ed(ed))))
  !
  use dc_message
  use lumatrix
  use et_module
  use at_ad_galerkin_DD, only: at_ad_galerkin_DD_Initial,      &
                               ad_at, at_ad, ad_ag, ag_ad,     &
                               ad_Dx_ad,                       &
                               d_t, t_d,                       &
                               d_y => d_g, y_d => g_d,         &
                               d_Dy_d => d_Dx_d
  use at_av_galerkin_NN, only: at_av_galerkin_NN_Initial,      &
                               av_at, at_av, av_ag, ag_av,     &
                               av_Dx_av,                       &
                               v_t, t_v,                       &
                               v_y => v_g, y_v => g_v,         &
                               v_Dy_v => v_Dx_v
  use at_ab_galerkin_ND, only: at_ab_galerkin_ND_Initial,      &
                               ab_at, at_ab, ab_ag, ag_ab,     &
                               ab_Dx_ab,                       &
                               b_t, t_b,                       &
                               b_y => b_g, y_b => g_b,         &
                               b_Dy_b => b_Dx_b
  use at_ap_galerkin_DN, only: at_ap_galerkin_DN_Initial,      &
                               ap_at, at_ap, ap_ag, ag_ap,     &
                               ap_Dx_ap,                       &
                               p_t, t_p,                       &
                               p_y => p_g, y_p => g_p,         &
                               p_Dy_p => p_Dx_p
  use at_af_galerkin_MM, only: at_af_galerkin_MM_Initial,      &
                               af_at, at_af, af_ag, ag_af,     &
                               af_Dx_af,                       &
                               f_t, t_f,                       &
                               f_y => f_g, y_f => g_f,         &
                               f_Dy_f => f_Dx_f
  use at_ah_galerkin_MMex, only: at_ah_galerkin_MMex_Initial,  &
                                 ah_at, at_ah, ah_ag, ag_ah,   &
                                 ah_Dx_ah
  use at_aq_galerkin_RRFF, only: at_aq_galerkin_RRFF_Initial,  &
                                 aq_at, at_aq, aq_ag, ag_aq,   &
                                 aq_Dx_aq,                     &
                                 q_t, t_q,                     &
                                 q_y => q_g, y_q => g_q,       &
                                 q_Dy_q => q_Dx_q,             &
                                 TQ, QT, alpha, beta

  implicit none
  private

  public et_galerkin_Initial                              ! 
  public eq_Vor2Strm_et                                   ! ->ή

  !-- et_module 
  public x_X, y_Y, x_X_Weight, y_Y_Weight, yx_X, yx_Y     ! ɸѿ
  public yx_et, et_yx                                     ! Ѵ
  public e_x, x_e, ae_ax, ax_ae                           ! Ѵ
  public t_y, y_t, at_ay, ay_at                           ! Ѵ

  public et_Dx_et, e_Dx_e, ae_Dx_ae                       ! ʬ
  public et_Dy_et, t_Dy_t, at_Dy_at                       ! ʬ
  public et_Lapla_et                                      ! ʬ
  public et_LaplaInv_et                                   ! ʬ

  public et_Jacobian_et_et                                ! ׻

  public IntYX_yx, y_IntX_yx, x_IntY_yx, IntX_x, IntY_y   ! ʬ
  public AvrYX_yx, y_AvrX_yx, x_AvrY_yx, AvrX_x, AvrY_y   ! ʿ

  !-- at_ad_galerkin_DD
  public :: ed_yx, yx_ed               ! ʻ<->顼ǡѴ
  public :: ed_et, d_t                 ! ӥ->顼Ѵ
  public :: ed_ey, d_y                 ! ʻ->顼ǡѴ
  public :: et_ed, t_d                 ! 顼->ӥѴ
  public :: ey_ed, y_d                 ! 顼->ʻǡѴ
  public :: ed_Dx_ed                   ! X ʬ
  public :: ed_Dy_ed, d_Dy_d           ! Y ʬ

  !-- at_av_galerkin_NN
  public :: ev_yx, yx_ev               ! ʻ<->顼ǡѴ
  public :: ev_et, v_t                 ! ӥ->顼Ѵ
  public :: ev_ey, v_y                 ! ʻ->顼ǡѴ
  public :: et_ev, t_v                 ! 顼->ӥѴ
  public :: ey_ev, y_v                 ! 顼->ʻǡѴ
  public :: ev_Dx_ev                   ! X ʬ
  public :: ev_Dy_ev, v_Dy_v           ! Y ʬ

  !-- at_ab_galerkin_ND
  public :: eb_yx, yx_eb               ! ʻ<->顼ǡѴ
  public :: eb_et, b_t                 ! ӥ->顼Ѵ
  public :: eb_ey, b_y                 ! ʻ->顼ǡѴ
  public :: et_eb, t_b                 ! 顼->ӥѴ
  public :: ey_eb, y_b                 ! 顼->ʻǡѴ
  public :: eb_Dx_eb                   ! X ʬ
  public :: eb_Dy_eb, b_Dy_b           ! Y ʬ

  !-- at_ap_galerkin_DN
  public :: ep_yx, yx_ep               ! ʻ<->顼ǡѴ
  public :: ep_et, p_t                 ! ӥ->顼Ѵ
  public :: ep_ey, p_y                 ! ʻ->顼ǡѴ
  public :: et_ep, t_p                 ! 顼->ӥѴ
  public :: ey_ep, y_p                 ! 顼->ʻǡѴ
  public :: ep_Dx_ep                   ! X ʬ
  public :: ep_Dy_ep, p_Dy_p           ! Y ʬ

  !-- at_af_galerkin_MM
  public :: ef_yx, yx_ef               ! ʻ<->顼ǡѴ
  public :: ef_et, f_t                 ! ӥ->顼Ѵ
  public :: ef_ey, f_y                 ! ʻ->顼ǡѴ
  public :: et_ef, t_f                 ! 顼->ӥѴ
  public :: ey_ef, y_f                 ! 顼->ʻǡѴ
  public :: ef_Dx_ef                   ! X ʬ
  public :: ef_Dy_ef, f_Dy_f           ! Y ʬ

  !-- at_ah_galerkin_MMex
  public :: eh_yx, yx_eh               ! ʻ<->顼ǡѴ
  public :: eh_et                      ! ӥ->顼Ѵ
  public :: eh_ey                      ! ʻ->顼ǡѴ
  public :: et_eh                      ! 顼->ӥѴ
  public :: ey_eh                      ! 顼->ʻǡѴ
  public :: eh_Dx_eh                   ! X ʬ
  public :: eh_Dy_eh                   ! Y ʬ

  !-- at_aq_galerkin_RRFF
  public :: eq_yx, yx_eq               ! ʻ<->顼ǡѴ
  public :: eq_et, q_t                 ! ӥ->顼Ѵ
  public :: eq_ey, q_y                 ! ʻ->顼ǡѴ
  public :: et_eq, t_q                 ! 顼->ӥѴ
  public :: ey_eq, y_q                 ! 顼->ʻǡѴ
  public :: eq_Dx_eq                   ! X ʬ
  public :: eq_Dy_eq, q_Dy_q           ! Y ʬ


  !-- ѿ--
  integer :: im=128, jm=64               ! ʻ(X,Y)
  integer :: km=42,  lm=42               ! ȿ(X,Y)

  real(8) :: xl=2.0                      ! ΰ礭
  real(8), parameter :: pi=3.1415926535897932385D0

  logical :: Set_DD    =.false.        ! ⥸塼ɤ߹ߥå
  logical :: Set_NN    =.false.        ! ⥸塼ɤ߹ߥå
  logical :: Set_DN    =.false.        ! ⥸塼ɤ߹ߥå
  logical :: Set_ND    =.false.        ! ⥸塼ɤ߹ߥå
  logical :: Set_MM    =.false.        ! ⥸塼ɤ߹ߥå
  logical :: Set_MMex  =.false.        ! ⥸塼ɤ߹ߥå
  logical :: Set_RRFF  =.false.        ! ⥸塼ɤ߹ߥå

  save im, jm, km, lm, xl, &
       Set_DD, Set_NN, Set_DN, Set_ND, Set_MM, Set_MMex, Set_RRFF

  contains
  !---------------  -----------------
    subroutine et_galerkin_Initial(i,j,k,l,xmin,xmax,ymin,ymax,&
         DD,NN,DN,ND,velBC,&
         MM_cfdy0_ymin, MM_cfdy1_ymin, MM_cfdy0_ymax, MM_cfdy1_ymax,&
         MMex_cfdy0_ymin, MMex_cfdy1_ymin, MMex_cfdy0_ymax, MMex_cfdy1_ymax)
      !
      !  2 ϩΰ
      !  Fourier Ÿ + ӥաݥ顼ˡѥ⥸塼
      !
      !  ֥롼
      !
      integer,intent(in) :: i, j           ! ʻ(X,Y)
      integer,intent(in) :: k, l           ! ȿ(X,Y)

      real(8),intent(in) :: xmin, xmax     ! X ɸϰ
      real(8),intent(in) :: ymin, ymax     ! Y ɸϰ

      logical,intent(in),optional :: DD  ! ⥸塼ɤ߹ߥå
      logical,intent(in),optional :: NN  ! ⥸塼ɤ߹ߥå
      logical,intent(in),optional :: DN  ! ⥸塼ɤ߹ߥå
      logical,intent(in),optional :: ND  ! ⥸塼ɤ߹ߥå

      ! at_af_galerkin_MM_module ﷸ
      real(8),intent(in),optional :: MM_cfdy0_ymin ! (0ʬ@x=ymin)
      real(8),intent(In),optional :: MM_cfdy1_ymin ! (1ʬ@x=ymin)
      real(8),intent(in),optional :: MM_cfdy0_ymax ! (0ʬ@x=ymax)
      real(8),intent(in),optional :: MM_cfdy1_ymax ! (1ʬ@x=ymax)

      ! at_ah_galerkin_MMex_module ﷸ
      real(8),intent(in),optional :: MMex_cfdy0_ymin(-k:k) ! (0ʬ@x=ymin)
      real(8),intent(in),optional :: MMex_cfdy1_ymin(-k:k) ! (1ʬ@x=ymin)
      real(8),intent(in),optional :: MMex_cfdy0_ymax(-k:k) ! (0ʬ@x=ymax)
      real(8),intent(in),optional :: MMex_cfdy1_ymax(-k:k) ! (1ʬ@x=ymax)

      ! at_aq_galerkin_RRFF_module ®پ춭
      character(LEN=2),intent(in),optional :: velBC  ! (RR/SS/RS/SR)

      !---------------  -----------------
      im=i ; jm = j ; km=k ; lm=l ; xl = xmax-xmin

      if ( present(DD) ) Set_DD = DD
      if ( present(NN) ) Set_NN = NN
      if ( present(DN) ) Set_DN = DN
      if ( present(ND) ) Set_ND = ND

      if ( present(MM_cfdy0_ymin) .AND.present(MM_cfdy1_ymin) .AND.&
           present(MM_cfdy0_ymax) .AND.present(MM_cfdy1_ymax) ) &
           Set_MM=.true.

      if ( present(MMex_cfdy0_ymin) .AND.present(MMex_cfdy1_ymin) .AND.&
           present(MMex_cfdy0_ymax) .AND.present(MMex_cfdy1_ymax) ) &
           Set_MMex=.true.

      if ( present(velBC) ) Set_RRFF = .true.

      !--------------- ⥸塼 -----------------
      call et_Initial(im,jm,km,lm,xmin,xmax,ymin,ymax)
      if ( Set_DD ) call at_ad_galerkin_DD_Initial(jm,lm)
      if ( Set_NN ) call at_av_galerkin_NN_Initial(jm,lm)
      if ( Set_DN ) call at_ap_galerkin_DN_Initial(jm,lm)
      if ( Set_ND ) call at_ab_galerkin_ND_Initial(jm,lm)
      if ( Set_MM ) call at_af_galerkin_MM_Initial      &
                               (jm,lm, MM_cfdy0_ymax, MM_cfdy1_ymax,&
                                       MM_cfdy0_ymin, MM_cfdy1_ymin   )
      if ( Set_MMex ) call at_ah_galerkin_MMex_Initial      &
                               (jm,lm,2*km+1, &
                                MMex_cfdy0_ymax, MMex_cfdy1_ymax,&
                                MMex_cfdy0_ymin, MMex_cfdy1_ymin   )

      if ( Set_RRFF ) call at_aq_galerkin_RRFF_Initial(jm,lm,velBC)

      call MessageNotify('M','et_galerkin_initial','et_galerkin_module (2013/08/24) is initialized')

    end subroutine et_galerkin_initial


  !--------------- Ѵ -----------------
    !--- at_ad_galerkin_DD ---
    function et_ed(ed)
      !
      ! 顼ǡӥեǡѴ.
      !
      real(8), dimension(-km:km,0:lm)              :: et_ed
      !(out) ʻǡ

      real(8), dimension(-km:km,2:lm), intent(in)  :: ed
      !(in) ڥȥǡ

      et_ed = at_ad(ed)

    end function et_ed

    function ed_et(et)
      !
      ! ӥեǡ饬顼ǡѴ.
      !
      real(8), dimension(-km:km,2:lm)              :: ed_et
      !(out) ڥȥǡ

      real(8), dimension(-km:km,0:lm), intent(in)  :: et
      !(in) ʻǡ

      ed_et = ad_at(et)

    end function ed_et

    function ey_ed(ed)
      !
      ! 顼ǡʻҥǡѴ.
      !
      real(8), dimension(-km:km,0:jm)              :: ey_ed
      !(out) ʻǡ

      real(8), dimension(-km:km,2:lm), intent(in)  :: ed
      !(in) ڥȥǡ

      ey_ed = ag_ad(ed)

    end function ey_ed

    function ed_ey(ey)
      !
      ! ʻҥǡ饬顼ǡѴ.
      !
      real(8), dimension(-km:km,2:lm)              :: ed_ey
      !(out) ڥȥǡ

      real(8), dimension(-km:km,0:jm), intent(in)  :: ey
      !(in) ʻǡ

      ed_ey = ad_ag(ey)

    end function ed_ey

    function yx_ed(ed)
      !
      ! 顼ǡʻҥǡѴ.
      !
      real(8), dimension(0:jm,0:im-1)              :: yx_ed
      !(out) ʻǡ

      real(8), dimension(-km:km,2:lm), intent(in)  :: ed
      !(in) ڥȥǡ

      yx_ed = yx_et(et_ed(ed))

    end function yx_ed

    function ed_yx(yx)
      !
      ! ʻҥǡ饬顼ǡѴ.
      !
      real(8), dimension(-km:km,2:lm)              :: ed_yx
      !(out) ڥȥǡ

      real(8), dimension(0:jm,0:im-1), intent(in)  :: yx
      !(in) ʻǡ

      ed_yx = ed_et(et_yx(yx))

    end function ed_yx

    !--- at_av_galerkin_NN ---
    function et_ev(ev)
      !
      ! 顼ǡӥեǡѴ.
      !
      real(8), dimension(-km:km,0:lm)              :: et_ev
      !(out) ʻǡ

      real(8), dimension(-km:km,2:lm), intent(in)  :: ev
      !(in) ڥȥǡ

      et_ev = at_av(ev)

    end function et_ev

    function ev_et(et)
      !
      ! ӥեǡ饬顼ǡѴ.
      !
      real(8), dimension(-km:km,2:lm)              :: ev_et
      !(out) ڥȥǡ

      real(8), dimension(-km:km,0:lm), intent(in)  :: et
      !(in) ʻǡ

      ev_et = av_at(et)

    end function ev_et

    function ey_ev(ev)
      !
      ! 顼ǡʻҥǡѴ.
      !
      real(8), dimension(-km:km,0:jm)              :: ey_ev
      !(out) ʻǡ

      real(8), dimension(-km:km,2:lm), intent(in)  :: ev
      !(in) ڥȥǡ

      ey_ev = ag_av(ev)

    end function ey_ev

    function ev_ey(ey)
      !
      ! ʻҥǡ饬顼ǡѴ.
      !
      real(8), dimension(-km:km,2:lm)              :: ev_ey
      !(out) ڥȥǡ

      real(8), dimension(-km:km,0:jm), intent(in)  :: ey
      !(in) ʻǡ

      ev_ey = av_ag(ey)

    end function ev_ey

    function yx_ev(ev)
      !
      ! 顼ǡʻҥǡѴ.
      !
      real(8), dimension(0:jm,0:im-1)              :: yx_ev
      !(out) ʻǡ

      real(8), dimension(-km:km,2:lm), intent(in)  :: ev
      !(in) ڥȥǡ

      yx_ev = yx_et(et_ev(ev))

    end function yx_ev

    function ev_yx(yx)
      !
      ! ʻҥǡ饬顼ǡѴ.
      !
      real(8), dimension(-km:km,2:lm)              :: ev_yx
      !(out) ڥȥǡ

      real(8), dimension(0:jm,0:im-1), intent(in)  :: yx
      !(in) ʻǡ

      ev_yx = ev_et(et_yx(yx))

    end function ev_yx

    !--- at_ab_galerkin_ND ---
    function et_eb(eb)
      !
      ! 顼ǡӥեǡѴ.
      !
      real(8), dimension(-km:km,0:lm)              :: et_eb
      !(out) ʻǡ

      real(8), dimension(-km:km,2:lm), intent(in)  :: eb
      !(in) ڥȥǡ

      et_eb = at_ab(eb)

    end function et_eb

    function eb_et(et)
      !
      ! ӥեǡ饬顼ǡѴ.
      !
      real(8), dimension(-km:km,2:lm)              :: eb_et
      !(out) ڥȥǡ

      real(8), dimension(-km:km,0:lm), intent(in)  :: et
      !(in) ʻǡ

      eb_et = ab_at(et)

    end function eb_et

    function ey_eb(eb)
      !
      ! 顼ǡʻҥǡѴ.
      !
      real(8), dimension(-km:km,0:jm)              :: ey_eb
      !(out) ʻǡ

      real(8), dimension(-km:km,2:lm), intent(in)  :: eb
      !(in) ڥȥǡ

      ey_eb = ag_ab(eb)

    end function ey_eb

    function eb_ey(ey)
      !
      ! ʻҥǡ饬顼ǡѴ.
      !
      real(8), dimension(-km:km,2:lm)              :: eb_ey
      !(out) ڥȥǡ

      real(8), dimension(-km:km,0:jm), intent(in)  :: ey
      !(in) ʻǡ

      eb_ey = ab_ag(ey)

    end function eb_ey

    function yx_eb(eb)
      !
      ! 顼ǡʻҥǡѴ.
      !
      real(8), dimension(0:jm,0:im-1)              :: yx_eb
      !(out) ʻǡ

      real(8), dimension(-km:km,2:lm), intent(in)  :: eb
      !(in) ڥȥǡ

      yx_eb = yx_et(et_eb(eb))

    end function yx_eb

    function eb_yx(yx)
      !
      ! ʻҥǡ饬顼ǡѴ.
      !
      real(8), dimension(-km:km,2:lm)              :: eb_yx
      !(out) ڥȥǡ

      real(8), dimension(0:jm,0:im-1), intent(in)  :: yx
      !(in) ʻǡ

      eb_yx = eb_et(et_yx(yx))

    end function eb_yx

    !--- at_ap_galerkin_DN ---
    function et_ep(ep)
      !
      ! 顼ǡӥեǡѴ.
      !
      real(8), dimension(-km:km,0:lm)              :: et_ep
      !(out) ʻǡ

      real(8), dimension(-km:km,2:lm), intent(in)  :: ep
      !(in) ڥȥǡ

      et_ep = at_ap(ep)

    end function et_ep

    function ep_et(et)
      !
      ! ӥեǡ饬顼ǡѴ.
      !
      real(8), dimension(-km:km,2:lm)              :: ep_et
      !(out) ڥȥǡ

      real(8), dimension(-km:km,0:lm), intent(in)  :: et
      !(in) ʻǡ

      ep_et = ap_at(et)

    end function ep_et

    function ey_ep(ep)
      !
      ! 顼ǡʻҥǡѴ.
      !
      real(8), dimension(-km:km,0:jm)              :: ey_ep
      !(out) ʻǡ

      real(8), dimension(-km:km,2:lm), intent(in)  :: ep
      !(in) ڥȥǡ

      ey_ep = ag_ap(ep)

    end function ey_ep

    function ep_ey(ey)
      !
      ! ʻҥǡ饬顼ǡѴ.
      !
      real(8), dimension(-km:km,2:lm)              :: ep_ey
      !(out) ڥȥǡ

      real(8), dimension(-km:km,0:jm), intent(in)  :: ey
      !(in) ʻǡ

      ep_ey = ap_ag(ey)

    end function ep_ey

    function yx_ep(ep)
      !
      ! 顼ǡʻҥǡѴ.
      !
      real(8), dimension(0:jm,0:im-1)              :: yx_ep
      !(out) ʻǡ

      real(8), dimension(-km:km,2:lm), intent(in)  :: ep
      !(in) ڥȥǡ

      yx_ep = yx_et(et_ep(ep))

    end function yx_ep

    function ep_yx(yx)
      !
      ! ʻҥǡ饬顼ǡѴ.
      !
      real(8), dimension(-km:km,2:lm)              :: ep_yx
      !(out) ڥȥǡ

      real(8), dimension(0:jm,0:im-1), intent(in)  :: yx
      !(in) ʻǡ

      ep_yx = ep_et(et_yx(yx))

    end function ep_yx

    !--- at_af_galerkin_MM ---
    function et_ef(ef)
      !
      ! 顼ǡӥեǡѴ.
      !
      real(8), dimension(-km:km,0:lm)              :: et_ef
      !(out) ʻǡ

      real(8), dimension(-km:km,2:lm), intent(in)  :: ef
      !(in) ڥȥǡ

      et_ef = at_af(ef)

    end function et_ef

    function ef_et(et)
      !
      ! ӥեǡ饬顼ǡѴ.
      !
      real(8), dimension(-km:km,2:lm)              :: ef_et
      !(out) ڥȥǡ

      real(8), dimension(-km:km,0:lm), intent(in)  :: et
      !(in) ʻǡ

      ef_et = af_at(et)

    end function ef_et

    function ey_ef(ef)
      !
      ! 顼ǡʻҥǡѴ.
      !
      real(8), dimension(-km:km,0:jm)              :: ey_ef
      !(out) ʻǡ

      real(8), dimension(-km:km,2:lm), intent(in)  :: ef
      !(in) ڥȥǡ

      ey_ef = ag_af(ef)

    end function ey_ef

    function ef_ey(ey)
      !
      ! ʻҥǡ饬顼ǡѴ.
      !
      real(8), dimension(-km:km,2:lm)              :: ef_ey
      !(out) ڥȥǡ

      real(8), dimension(-km:km,0:jm), intent(in)  :: ey
      !(in) ʻǡ

      ef_ey = af_ag(ey)

    end function ef_ey

    function yx_ef(ef)
      !
      ! 顼ǡʻҥǡѴ.
      !
      real(8), dimension(0:jm,0:im-1)              :: yx_ef
      !(out) ʻǡ

      real(8), dimension(-km:km,2:lm), intent(in)  :: ef
      !(in) ڥȥǡ

      yx_ef = yx_et(et_ef(ef))

    end function yx_ef

    function ef_yx(yx)
      !
      ! ʻҥǡ饬顼ǡѴ.
      !
      real(8), dimension(-km:km,2:lm)              :: ef_yx
      !(out) ڥȥǡ

      real(8), dimension(0:jm,0:im-1), intent(in)  :: yx
      !(in) ʻǡ

      ef_yx = ef_et(et_yx(yx))

    end function ef_yx

    !--- at_ah_galerkin_MMex ---
    function et_eh(eh)
      !
      ! 顼ǡӥեǡѴ.
      !
      real(8), dimension(-km:km,0:lm)              :: et_eh
      !(out) ʻǡ

      real(8), dimension(-km:km,2:lm), intent(in)  :: eh
      !(in) ڥȥǡ

      et_eh = at_ah(eh)

    end function et_eh

    function eh_et(et)
      !
      ! ӥեǡ饬顼ǡѴ.
      !
      real(8), dimension(-km:km,2:lm)              :: eh_et
      !(out) ڥȥǡ

      real(8), dimension(-km:km,0:lm), intent(in)  :: et
      !(in) ʻǡ

      eh_et = ah_at(et)

    end function eh_et

    function ey_eh(eh)
      !
      ! 顼ǡʻҥǡѴ.
      !
      real(8), dimension(-km:km,0:jm)              :: ey_eh
      !(out) ʻǡ

      real(8), dimension(-km:km,2:lm), intent(in)  :: eh
      !(in) ڥȥǡ

      ey_eh = ag_ah(eh)

    end function ey_eh

    function eh_ey(ey)
      !
      ! ʻҥǡ饬顼ǡѴ.
      !
      real(8), dimension(-km:km,2:lm)              :: eh_ey
      !(out) ڥȥǡ

      real(8), dimension(-km:km,0:jm), intent(in)  :: ey
      !(in) ʻǡ

      eh_ey = ah_ag(ey)

    end function eh_ey

    function yx_eh(eh)
      !
      ! 顼ǡʻҥǡѴ.
      !
      real(8), dimension(0:jm,0:im-1)              :: yx_eh
      !(out) ʻǡ

      real(8), dimension(-km:km,2:lm), intent(in)  :: eh
      !(in) ڥȥǡ

      yx_eh = yx_et(et_eh(eh))

    end function yx_eh

    function eh_yx(yx)
      !
      ! ʻҥǡ饬顼ǡѴ.
      !
      real(8), dimension(-km:km,2:lm)              :: eh_yx
      !(out) ڥȥǡ

      real(8), dimension(0:jm,0:im-1), intent(in)  :: yx
      !(in) ʻǡ

      eh_yx = eh_et(et_yx(yx))

    end function eh_yx

    !--- at_aq_galerkin_RRFF ---
    function et_eq(eq)
      !
      ! 顼ǡӥեǡѴ.
      !
      real(8), dimension(-km:km,0:lm)              :: et_eq
      !(out) ʻǡ

      real(8), dimension(-km:km,4:lm), intent(in)  :: eq
      !(in) ڥȥǡ

      et_eq = at_aq(eq)

    end function et_eq

    function eq_et(et)
      !
      ! ӥեǡ饬顼ǡѴ.
      !
      real(8), dimension(-km:km,4:lm)              :: eq_et
      !(out) ڥȥǡ

      real(8), dimension(-km:km,0:lm), intent(in)  :: et
      !(in) ʻǡ

      eq_et = aq_at(et)

    end function eq_et

    function ey_eq(eq)
      !
      ! 顼ǡʻҥǡѴ.
      !
      real(8), dimension(-km:km,0:jm)              :: ey_eq
      !(out) ʻǡ

      real(8), dimension(-km:km,4:lm), intent(in)  :: eq
      !(in) ڥȥǡ

      ey_eq = ag_aq(eq)

    end function ey_eq

    function eq_ey(ey)
      !
      ! ʻҥǡ饬顼ǡѴ.
      !
      real(8), dimension(-km:km,4:lm)              :: eq_ey
      !(out) ڥȥǡ

      real(8), dimension(-km:km,0:jm), intent(in)  :: ey
      !(in) ʻǡ

      eq_ey = aq_ag(ey)

    end function eq_ey

    function yx_eq(eq)
      !
      ! 顼ǡʻҥǡѴ.
      !
      real(8), dimension(0:jm,0:im-1)              :: yx_eq
      !(out) ʻǡ

      real(8), dimension(-km:km,4:lm), intent(in)  :: eq
      !(in) ڥȥǡ

      yx_eq = yx_et(et_eq(eq))

    end function yx_eq

    function eq_yx(yx)
      !
      ! ʻҥǡ饬顼ǡѴ.
      !
      real(8), dimension(-km:km,4:lm)              :: eq_yx
      !(out) ڥȥǡ

      real(8), dimension(0:jm,0:im-1), intent(in)  :: yx
      !(in) ʻǡ

      eq_yx = eq_et(et_yx(yx))

    end function eq_yx

  !--------------- ʬ׻ -----------------

    function ed_Dx_ed(ed)
      !
      ! ϥڥȥǡ X ʬ(x)Ѥ.
      !
      ! ڥȥǡ X ʬȤ, бʻǡ X ʬ
      ! ѤǡΥڥȥѴΤȤǤ.
      !
      ! ºݤˤϥڥȥǡ X ȿ k 򤫤
      ! sin(kx) <-> cos(kx) ʬ촹׻ԤäƤ.
      !
      real(8), dimension(-km:km,2:lm)                :: ed_Dx_ed
      real(8), dimension(-km:km,2:lm), intent(in)    :: ed
      integer k

      do k=-km,km
         ed_Dx_ed(k,:)  =  (-2*pi*k/xl)*ed(-k,:)
      enddo
    end function ed_Dx_ed

    function ed_Dy_ed(ed)
      !
      ! ϥڥȥǡ Y ʬ(y)Ѥ.
      !
      ! ڥȥǡ Y ʬȤ, бʻǡ Y ʬ
      ! ѤǡΥڥȥѴΤȤǤ.
      !
      real(8), dimension(-km:km,2:lm)                :: ed_Dy_ed
      real(8), dimension(-km:km,2:lm), intent(in)    :: ed

      ed_Dy_ed  = ed_et(et_Dy_et(et_ed(ed)))

    end function ed_Dy_ed

    function ev_Dx_ev(ev)
      !
      ! ϥڥȥǡ X ʬ(x)Ѥ.
      !
      ! ڥȥǡ X ʬȤ, бʻǡ X ʬ
      ! ѤǡΥڥȥѴΤȤǤ.
      !
      ! ºݤˤϥڥȥǡ X ȿ k 򤫤
      ! sin(kx) <-> cos(kx) ʬ촹׻ԤäƤ.
      !
      real(8), dimension(-km:km,2:lm)                :: ev_Dx_ev
      real(8), dimension(-km:km,2:lm), intent(in)    :: ev
      integer k

      do k=-km,km
         ev_Dx_ev(k,:)  =  (-2*pi*k/xl)*ev(-k,:)
      enddo
    end function ev_Dx_ev

    function ev_Dy_ev(ev)
      !
      ! ϥڥȥǡ Y ʬ(y)Ѥ.
      !
      ! ڥȥǡ Y ʬȤ, бʻǡ Y ʬ
      ! ѤǡΥڥȥѴΤȤǤ.
      !
      real(8), dimension(-km:km,2:lm)                :: ev_Dy_ev
      real(8), dimension(-km:km,2:lm), intent(in)    :: ev

      ev_Dy_ev  = ev_et(et_Dy_et(et_ev(ev)))

    end function ev_Dy_ev

    function eb_Dx_eb(eb)
      !
      ! ϥڥȥǡ X ʬ(x)Ѥ.
      !
      ! ڥȥǡ X ʬȤ, бʻǡ X ʬ
      ! ѤǡΥڥȥѴΤȤǤ.
      !
      ! ºݤˤϥڥȥǡ X ȿ k 򤫤
      ! sin(kx) <-> cos(kx) ʬ촹׻ԤäƤ.
      !
      real(8), dimension(-km:km,2:lm)                :: eb_Dx_eb
      real(8), dimension(-km:km,2:lm), intent(in)    :: eb
      integer k

      do k=-km,km
         eb_Dx_eb(k,:)  =  (-2*pi*k/xl)*eb(-k,:)
      enddo
    end function eb_Dx_eb

    function eb_Dy_eb(eb)
      !
      ! ϥڥȥǡ Y ʬ(y)Ѥ.
      !
      ! ڥȥǡ Y ʬȤ, бʻǡ Y ʬ
      ! ѤǡΥڥȥѴΤȤǤ.
      !
      real(8), dimension(-km:km,2:lm)                :: eb_Dy_eb
      real(8), dimension(-km:km,2:lm), intent(in)    :: eb

      eb_Dy_eb  = eb_et(et_Dy_et(et_eb(eb)))

    end function eb_Dy_eb

    function ep_Dx_ep(ep)
      !
      ! ϥڥȥǡ X ʬ(x)Ѥ.
      !
      ! ڥȥǡ X ʬȤ, бʻǡ X ʬ
      ! ѤǡΥڥȥѴΤȤǤ.
      !
      ! ºݤˤϥڥȥǡ X ȿ k 򤫤
      ! sin(kx) <-> cos(kx) ʬ촹׻ԤäƤ.
      !
      real(8), dimension(-km:km,2:lm)                :: ep_Dx_ep
      real(8), dimension(-km:km,2:lm), intent(in)    :: ep
      integer k

      do k=-km,km
         ep_Dx_ep(k,:)  =  (-2*pi*k/xl)*ep(-k,:)
      enddo
    end function ep_Dx_ep

    function ep_Dy_ep(ep)
      !
      ! ϥڥȥǡ Y ʬ(y)Ѥ.
      !
      ! ڥȥǡ Y ʬȤ, бʻǡ Y ʬ
      ! ѤǡΥڥȥѴΤȤǤ.
      !
      real(8), dimension(-km:km,2:lm)                :: ep_Dy_ep
      real(8), dimension(-km:km,2:lm), intent(in)    :: ep

      ep_Dy_ep  = ep_et(et_Dy_et(et_ep(ep)))

    end function ep_Dy_ep

    function ef_Dx_ef(ef)
      !
      ! ϥڥȥǡ X ʬ(x)Ѥ.
      !
      ! ڥȥǡ X ʬȤ, бʻǡ X ʬ
      ! ѤǡΥڥȥѴΤȤǤ.
      !
      ! ºݤˤϥڥȥǡ X ȿ k 򤫤
      ! sin(kx) <-> cos(kx) ʬ촹׻ԤäƤ.
      !
      real(8), dimension(-km:km,2:lm)                :: ef_Dx_ef
      real(8), dimension(-km:km,2:lm), intent(in)    :: ef
      integer k

      do k=-km,km
         ef_Dx_ef(k,:)  =  (-2*pi*k/xl)*ef(-k,:)
      enddo
    end function ef_Dx_ef

    function ef_Dy_ef(ef)
      !
      ! ϥڥȥǡ Y ʬ(y)Ѥ.
      !
      ! ڥȥǡ Y ʬȤ, бʻǡ Y ʬ
      ! ѤǡΥڥȥѴΤȤǤ.
      !
      real(8), dimension(-km:km,2:lm)                :: ef_Dy_ef
      real(8), dimension(-km:km,2:lm), intent(in)    :: ef

      ef_Dy_ef  = ef_et(et_Dy_et(et_ef(ef)))

    end function ef_Dy_ef

    function eh_Dx_eh(eh)
      !
      ! ϥڥȥǡ X ʬ(x)Ѥ.
      !
      ! ڥȥǡ X ʬȤ, бʻǡ X ʬ
      ! ѤǡΥڥȥѴΤȤǤ.
      !
      ! ºݤˤϥڥȥǡ X ȿ k 򤫤
      ! sin(kx) <-> cos(kx) ʬ촹׻ԤäƤ.
      !
      real(8), dimension(-km:km,2:lm)                :: eh_Dx_eh
      real(8), dimension(-km:km,2:lm), intent(in)    :: eh
      integer k

      do k=-km,km
         eh_Dx_eh(k,:)  =  (-2*pi*k/xl)*eh(-k,:)
      enddo
    end function eh_Dx_eh

    function eh_Dy_eh(eh)
      !
      ! ϥڥȥǡ Y ʬ(y)Ѥ.
      !
      ! ڥȥǡ Y ʬȤ, бʻǡ Y ʬ
      ! ѤǡΥڥȥѴΤȤǤ.
      !
      real(8), dimension(-km:km,2:lm)                :: eh_Dy_eh
      real(8), dimension(-km:km,2:lm), intent(in)    :: eh

      eh_Dy_eh  = eh_et(et_Dy_et(et_eh(eh)))

    end function eh_Dy_eh

    function eq_Dx_eq(eq)
      !
      ! ϥڥȥǡ X ʬ(x)Ѥ.
      !
      ! ڥȥǡ X ʬȤ, бʻǡ X ʬ
      ! ѤǡΥڥȥѴΤȤǤ.
      !
      ! ºݤˤϥڥȥǡ X ȿ k 򤫤
      ! sin(kx) <-> cos(kx) ʬ촹׻ԤäƤ.
      !
      real(8), dimension(-km:km,4:lm)                :: eq_Dx_eq
      real(8), dimension(-km:km,4:lm), intent(in)    :: eq
      integer k

      do k=-km,km
         eq_Dx_eq(k,:)  =  (-2*pi*k/xl)*eq(-k,:)
      enddo
    end function eq_Dx_eq

    function eq_Dy_eq(eq)
      !
      ! ϥڥȥǡ Y ʬ(y)Ѥ.
      !
      ! ڥȥǡ Y ʬȤ, бʻǡ Y ʬ
      ! ѤǡΥڥȥѴΤȤǤ.
      !
      real(8), dimension(-km:km,4:lm)                :: eq_Dy_eq
      real(8), dimension(-km:km,4:lm), intent(in)    :: eq

      eq_Dy_eq  = eq_et(et_Dy_et(et_eq(eq)))

    end function eq_Dy_eq

   !------------------- ٤ή ----------------------
    function eq_Vor2Strm_et(et_Zeta)
      !
      !  2 ϩΰ
      !  Fourier Ÿ + ӥաݥ顼ˡѥ⥸塼
      !
      !  ٤ή׻.
      !
      real(8), intent(IN) :: et_Zeta(-km:km,0:lm)        !(in)   =^2
      real(8)             :: eq_Vor2Strm_et(-km:km,4:lm) !(out) ή 

      real(8), allocatable :: LaplaMT(:,:,:)
      real(8), allocatable :: LaplaInvMT(:,:,:)
      integer, allocatable :: kpvot(:,:)

      integer, parameter :: ls=4

      real(8) :: eq_work(-km:km,ls:lm)
      real(8) :: et_work(-km:km,0:lm)

      integer :: k, m, n, l, p
      logical :: first = .true.
      save LaplaInvMT, kpvot, first

      if ( .not. Set_RRFF ) &
           call MessageNotify('E','eq_Vor2Strm_et',&
                    'at_aq_galerkin_RRFF_module not initialized.')

      if ( first ) then
         first = .false.
         allocate(LaplaMT(-km:km,0:lm,0:lm))
         allocate(LaplaInvMT(-km:km,ls:lm,ls:lm),kpvot(-km:km,ls:lm))

         LaplaMT=0.0D0
         do l=0,lm
            et_work = 0.0D0 ; et_work(:,l) = 1.0D0
            et_work = et_Lapla_et(et_work)
            LaplaMT(:,:,l) = et_work
         enddo

         LaplaInvMT=0.0
         do n=ls,lm
            do m=ls,lm
               do l=0,lm
                  do p=0,lm
                     LaplaInvMT(:,n,m)=LaplaInvMT(:,n,m) &
                          +TQ(l,n)*LaplaMT(:,l,p)*alpha(p)*TQ(p,m)
                  enddo
               enddo
            enddo
         enddo

         call LUDecomp(LaplaInvMT,kpvot)
         deallocate(LaplaMT)
      endif

      eq_work=0.0
      do m=ls,lm
         do k=0,lm
            eq_work(:,m)=eq_work(:,m) &
                 + alpha(k) * beta(k) * et_Zeta(:,k)* TQ(k,m) 
         enddo
      enddo

      eq_Vor2Strm_et = LUSolve(LaplaInvMT,kpvot,eq_work)

    end function eq_Vor2Strm_et

end module et_galerkin_module
