!----------------------------------------------------------------------
! COPYRIGHT (c) 2002-2010 SPMODEL Development Group. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  au_module ƥȥץ
!      1 
!
!  2007/12/28  ݹ
!      2010/12/21  ʿ dc_test Ѥ褦˽
!                  Tau ˡΥƥȤ
!
program au_test_boundary1d

  use dc_message, only : MessageNotify
  use dc_test, only : AssertEqual
  use au_module
  implicit none

  integer, parameter :: im=8, km=8
  real(8), parameter :: ra=1.0
  real(8), parameter :: amin=2.0D0

  real(8), dimension(0:im) :: g_a
  real(8), dimension(0:im) :: g_dadx
  real(8), dimension(0:km) :: u_a

  ! Ƚ
  integer, parameter :: check_digits = 10
  integer, parameter :: ignore = -11

  call au_initial(im,km,ra,(/0/))

  g_a = (g_R-ra)**2 + 1.0D0
  u_a = u_g(g_a)

  call MessageNotify('M','au_test_boundary1d', &
    'au_module 1-dim boundary condition solver tests')

!----- au_BoundaryGrid_D ------
  call au_BoundaryGrid_D(u_a,amin)
  g_a = g_u(u_a)
  
  call AssertEqual(&
    message='Test of au_BoundaryGrid_D',                          &
    answer = amin,                                                &
    check = g_a(0),                                               &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

!----- au_BoundaryTau_D ------
  call au_BoundaryTau_D(u_a,amin)
  g_a = g_u(u_a)
  
  call AssertEqual(&
    message='Test of au_BoundaryTau_D',                           &
    answer = amin,                                                &
    check = g_a(0),                                               &
    significant_digits = check_digits, ignore_digits = ignore     &
    )


!----- au_BoundaryGrid_N ------
  call au_BoundaryGrid_N(u_a,amin)
  g_dadx = g_Dr_u(u_g(g_u(u_a)))

  call AssertEqual(&
    message='Test of au_BoundaryGrid_N',                          &
    answer = amin,                                                &
    check = g_dadx(0),                                            &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

!----- au_BoundaryTau_N ------
  call au_BoundaryTau_N(u_a,amin)
  g_dadx = g_Dr_u(u_g(g_u(u_a)))

  call AssertEqual(&
    message='Test of au_BoundaryTau_N',                           &
    answer = amin,                                                &
    check = g_dadx(0),                                            &
    significant_digits = check_digits, ignore_digits = ignore     &
    )


  call MessageNotify('M','au_test_boundary1d', &
    'au_module 1-dim boundary condition solver tests succeeded!')

end program au_test_boundary1d
