!----------------------------------------------------------------------
!     Copyright (c) 2013 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  w_base_mpi_module ƥȥץ :: λΥƥ
!
!  2013/02/23  ݹ
!
program w_base_mpi_module_finalize_test

  use dc_message, only : MessageNotify
  use dc_test, only : AssertEqual
  use w_mpi_module
  use mpi
  implicit none

  integer :: im(2)=(/16,32/)
  integer :: jm(2)=(/8,16/)
  integer :: nm(2)=(/5,10/)

  real(8), allocatable  :: w_data(:)
  real(8), allocatable  :: xv_data(:,:)
  real(8), allocatable  :: xv_Ddata(:,:)
  real(8), allocatable  :: xy_data(:,:)
  real(8), allocatable  :: xy_Ddata(:,:)

  ! Ƚ
  integer, parameter :: check_digits = 11
  integer, parameter :: ignore = -12

  real(8) :: pi
  integer :: iproc, np, ierr
  integer :: n

  pi = atan(1.0D0)*4.0D0

  call MessageNotify('M','w_base_mpi_module_finalize_test', &
                         'w_base_mpi_module finalize subroutine tests') 

 !---------------- MPI  ---------------------
  call MPI_INIT(IERR)
  call MPI_COMM_RANK(MPI_COMM_WORLD,IPROC,IERR)
  call MPI_COMM_SIZE(MPI_COMM_WORLD,NP,IERR)

  do n=1,2

  call w_mpi_Initial( nm(n), im(n), jm(n) )

  allocate(w_data((nm(n)+1)**2))
  allocate(xy_data(0:im(n)-1,jm(n)))
  allocate(xy_Ddata(0:im(n)-1,jm(n)))
  allocate(xv_data(0:im(n)-1,jc))
  allocate(xv_Ddata(0:im(n)-1,jc))

  !========================= xv_w, w_xv Υƥ===========================

  call MessageNotify('M','w_base_mpi_module_test', &
                         'w_base_mpi_module functions xv_w, w_xv tests') 
  !==================== Y_1^0 Υƥ ====================
  xv_data = sqrt(3.0D0)*sin(xv_Lat)                      ! Y_1^0
  w_data= 0.0D0 ; w_data(l_nm(1,0))=1.0D0

  !---- ̾Ѵ ----
  call AssertEqual(&
    message='Y_1^0 Test of w_xv(xv_data)',                        &
    answer = w_data,                                              &
    check = w_xv(xv_data),                                        &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Y_1^0 Test of xv_w(w_xv(xv_data))',                  &
    answer = xv_data,                                             &
    check = xv_w(w_xv(xv_data)),                                  &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- X ʬѴ ----
  xv_Ddata = 0.0D0
  call AssertEqual(&
    message='Y_1^0 Test of xv_w(w_xv(xv_data,iflag=-1))',         &
    answer = xv_Ddata,                                            &
    check = xv_w(w_xv(xv_data,iflag=-1)),                         &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Y_1^0 Test of xv_w(w_xv(xv_data),iflag=-1)',         &
    answer = xv_Ddata,                                            &
    check = xv_w(w_xv(xv_data),iflag=-1),                         &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- Y ʬѴ ----
  xv_Ddata = sqrt(3.0D0) * ( cos(xv_Lat)**2 - 2*sin(xv_Lat)**2 )
  call AssertEqual(&
    message='Y_1^0 Test of xv_w(w_xv(xv_data,iflag=1,ipow=0))',   &
    answer = xv_Ddata,                                            &
    check = xv_w(w_xv(xv_data,iflag=1,ipow=0)),                   &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  xv_Ddata = sqrt(3.0D0)*cos(xv_Lat)
  call AssertEqual(&
    message='Y_1^0 Test of xv_w(w_xv(xv_data),iflag=1,ipow=1)',   &
    answer = xv_Ddata,                                            &
    check = xv_w(w_xv(xv_data),iflag=1,ipow=1),                   &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- SIN ݤѴ ----
  xv_Ddata = sqrt(3.0D0) * sin(xv_Lat)**2
  call AssertEqual(&
    message='Y_1^0 Test of xv_w(w_xv(xv_data,iflag=2))',          &
    answer = xv_Ddata,                                            &
    check = xv_w(w_xv(xv_data,iflag=2)),                          &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Y_1^0 Test of xv_w(w_xv(xv_data),iflag=2)',          &
    answer = xv_Ddata,                                            &
    check = xv_w(w_xv(xv_data),iflag=2),                          &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  call MessageNotify('M','Test of Y_1^0','Test of Y_1^0 succeeded!') 

  !==================== Y_1^1 Υƥ ====================
  xv_data = sqrt(3.0D0/2)*cos(xv_Lat)*cos(xv_Lon)          ! Y_1^1
  w_data= 0.0D0 ; w_data(l_nm(1,1))=1.0D0/sqrt(2.0D0)

  !---- ̾Ѵ ----
  call AssertEqual(&
    message='Y_1^1 Test of w_xv(xv_data)',                        &
    answer = w_data,                                              &
    check = w_xv(xv_data),                                        &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Y_1^1 Test of xv_w(w_xv(xv_data))',                  &
    answer = xv_data,                                             &
    check = xv_w(w_xv(xv_data)),                                  &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- X ʬѴ ----
  xv_Ddata = -sqrt(3.0D0/2)*cos(xv_Lat)*sin(xv_Lon)          ! Y_1^1
  call AssertEqual(&
    message='Y_1^1 Test of xv_w(w_xv(xv_data,iflag=-1))',         &
    answer = xv_Ddata,                                            &
    check = xv_w(w_xv(xv_data,iflag=-1)),                         &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Y_1^1 Test of xv_w(w_xv(xv_data),iflag=-1)',         &
    answer = xv_Ddata,                                            &
    check = xv_w(w_xv(xv_data),iflag=-1),                         &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- Y ʬѴ ----
  xv_Ddata = - sqrt(3.0D0/2) * 3 * sin(xv_Lat) * cos(xv_Lat) * cos(xv_Lon)
  call AssertEqual(&
    message='Y_1^1 Test of xv_w(w_xv(xv_data,iflag=1,ipow=0))',   &
    answer = xv_Ddata,                                            &
    check = xv_w(w_xv(xv_data,iflag=1,ipow=0)),                   &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  xv_Ddata = - sqrt(3.0D0/2) * sin(xv_Lat) * cos(xv_Lon)
  call AssertEqual(&
    message='Y_1^1 Test of xv_w(w_xv(xv_data),iflag=1,ipow=1)',   &
    answer = xv_Ddata,                                            &
    check = xv_w(w_xv(xv_data),iflag=1,ipow=1),                   &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- SIN ݤѴ ----
  xv_Ddata = sqrt(3.0D0/2) * sin(xv_Lat)* cos(xv_Lat) * cos(xv_Lon)
  call AssertEqual(&
    message='Y_1^1 Test of xv_w(w_xv(xv_data,iflag=2))',          &
    answer = xv_Ddata,                                            &
    check = xv_w(w_xv(xv_data,iflag=2)),                          &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Y_1^1 Test of xv_w(w_xv(xv_data),iflag=2)',          &
    answer = xv_Ddata,                                            &
    check = xv_w(w_xv(xv_data),iflag=2),                          &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  call MessageNotify('M','Test of Y_1^1','Test of Y_1^1 succeeded!') 

  !==================== Y_1^{-1} Υƥ ====================
  xv_data = -sqrt(3.0D0/2)*cos(xv_Lat)*sin(xv_Lon)         ! Y_1^{-1}
  w_data= 0.0D0 ; w_data(l_nm(1,-1))=1.0D0/sqrt(2.0D0)

  !---- ̾Ѵ ----
  call AssertEqual(&
    message='Y_1^1 Test of w_xv(xv_data)',                        &
    answer = w_data,                                              &
    check = w_xv(xv_data),                                        &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Y_1^1 Test of xv_w(w_xv(xv_data))',                  &
    answer = xv_data,                                             &
    check = xv_w(w_xv(xv_data)),                                  &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- X ʬѴ ----
  xv_Ddata = -sqrt(3.0D0/2)*cos(xv_Lat)*cos(xv_Lon)          ! Y_1^{-1}
  call AssertEqual(&
    message='Y_1^1 Test of xv_w(w_xv(xv_data,iflag=-1))',         &
    answer = xv_Ddata,                                            &
    check = xv_w(w_xv(xv_data,iflag=-1)),                         &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Y_1^1 Test of xv_w(w_xv(xv_data),iflag=-1)',         &
    answer = xv_Ddata,                                            &
    check = xv_w(w_xv(xv_data),iflag=-1),                         &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- Y ʬѴ ----
  xv_Ddata = sqrt(3.0D0/2) * 3 * sin(xv_Lat) * cos(xv_Lat) * sin(xv_Lon)
  call AssertEqual(&
    message='Y_1^1 Test of xv_w(w_xv(xv_data,iflag=1,ipow=0))',   &
    answer = xv_Ddata,                                            &
    check = xv_w(w_xv(xv_data,iflag=1,ipow=0)),                   &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  xv_Ddata = sqrt(3.0D0/2) * sin(xv_Lat) * sin(xv_Lon)
  call AssertEqual(&
    message='Y_1^1 Test of xv_w(w_xv(xv_data),iflag=1,ipow=1)',   &
    answer = xv_Ddata,                                            &
    check = xv_w(w_xv(xv_data),iflag=1,ipow=1),                   &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- SIN ݤѴ ----
  xv_Ddata = - sqrt(3.0D0/2) * sin(xv_Lat)* cos(xv_Lat) * sin(xv_Lon)
  call AssertEqual(&
    message='Y_1^1 Test of xv_w(w_xv(xv_data,iflag=2))',          &
    answer = xv_Ddata,                                            &
    check = xv_w(w_xv(xv_data,iflag=2)),                          &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Y_1^1 Test of xv_w(w_xv(xv_data),iflag=2)',          &
    answer = xv_Ddata,                                            &
    check = xv_w(w_xv(xv_data),iflag=2),                          &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !==================== Y_2^0 Υƥ ====================
  xv_data = sqrt(5.0D0)*(3.0/2*sin(xv_Lat)**2-1/2.0)                 ! Y_2^0
  w_data= 0.0D0 ; w_data(l_nm(2,0))=1.0D0

  !---- ̾Ѵ ----
  call AssertEqual(&
    message='Y_2^0 Test of w_xv(xv_data)',                        &
    answer = w_data,                                              &
    check = w_xv(xv_data),                                        &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Y_2^0 Test of xv_w(w_xv(xv_data))',                  &
    answer = xv_data,                                             &
    check = xv_w(w_xv(xv_data)),                                  &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- X ʬѴ ----
  xv_Ddata = 0.0D0
  call AssertEqual(&
    message='Y_2^0 Test of xv_w(w_xv(xv_data,iflag=-1))',         &
    answer = xv_Ddata,                                            &
    check = xv_w(w_xv(xv_data,iflag=-1)),                         &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Y_2^0 Test of xv_w(w_xv(xv_data),iflag=-1)',         &
    answer = xv_Ddata,                                            &
    check = xv_w(w_xv(xv_data),iflag=-1),                         &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- Y ʬѴ ----
  xv_Ddata = sqrt(5.0D0)*(   3.0*sin(xv_Lat)*cos(xv_Lat)**2  &
                           - 3.0*sin(xv_Lat)**3 + sin(xv_Lat)  ) 
  call AssertEqual(&
    message='Y_2^0 Test of xv_w(w_xv(xv_data,iflag=1,ipow=0))',   &
    answer = xv_Ddata,                                            &
    check = xv_w(w_xv(xv_data,iflag=1,ipow=0)),                   &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  xv_Ddata = sqrt(5.0D0)*3.0*sin(xv_Lat)*cos(xv_Lat)
  call AssertEqual(&
    message='Y_2^0 Test of xv_w(w_xv(xv_data),iflag=1,ipow=1)',   &
    answer = xv_Ddata,                                            &
    check = xv_w(w_xv(xv_data),iflag=1,ipow=1),                   &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- SIN ݤѴ ----
  xv_Ddata = sqrt(5.0D0)*(3.0/2*sin(xv_Lat)**2-1/2.0)*sin(xv_Lat)
  call AssertEqual(&
    message='Y_2^0 Test of xv_w(w_xv(xv_data,iflag=2))',          &
    answer = xv_Ddata,                                            &
    check = xv_w(w_xv(xv_data,iflag=2)),                          &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Y_2^0 Test of xv_w(w_xv(xv_data),iflag=2)',          &
    answer = xv_Ddata,                                            &
    check = xv_w(w_xv(xv_data),iflag=2),                          &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  call MessageNotify('M','Test of Y_2^0','Test of Y_2^0 succeeded!') 

  !==================== Y_2^1 Υƥ ====================
  xv_data = sqrt(5.0D0/6)*3.0*sin(xv_Lat)*cos(xv_Lat) * cos(xv_Lon)! Y_2^1
  w_data= 0.0D0 ; w_data(l_nm(2,1))=1.0D0/sqrt(2.0D0)

  !---- ̾Ѵ ----
  call AssertEqual(&
    message='Y_2^1 Test of w_xv(xv_data)',                        &
    answer = w_data,                                              &
    check = w_xv(xv_data),                                        &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Y_2^1 Test of xv_w(w_xv(xv_data))',                  &
    answer = xv_data,                                             &
    check = xv_w(w_xv(xv_data)),                                  &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- X ʬѴ ----
  xv_Ddata = -sqrt(5.0D0/6)*3.0*sin(xv_Lat)*cos(xv_Lat)*sin(xv_Lon)! Y_2^1
  call AssertEqual(&
    message='Y_2^1 Test of xv_w(w_xv(xv_data,iflag=-1))',         &
    answer = xv_Ddata,                                            &
    check = xv_w(w_xv(xv_data,iflag=-1)),                         &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Y_2^1 Test of xv_w(w_xv(xv_data),iflag=-1)',         &
    answer = xv_Ddata,                                            &
    check = xv_w(w_xv(xv_data),iflag=-1),                         &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- Y ʬѴ ----
  xv_Ddata = sqrt(5.0D0/6)*3.0 &
       *(cos(xv_Lat)**3-3*sin(xv_Lat)**2*cos(xv_Lat))*cos(xv_Lon)
  call AssertEqual(&
    message='Y_2^1 Test of xv_w(w_xv(xv_data,iflag=1,ipow=1))',   &
    answer = xv_Ddata,                                            &
    check = xv_w(w_xv(xv_data,iflag=1,ipow=0)),                   &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  xv_Ddata = sqrt(5.0D0/6)*3.0 * cos(2*xv_Lat) * cos(xv_Lon)
  call AssertEqual(&
    message='Y_2^1 Test of xv_w(w_xv(xv_data),iflag=1,ipow=1)',   &
    answer = xv_Ddata,                                            &
    check = xv_w(w_xv(xv_data),iflag=1,ipow=1),                   &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- SIN ݤѴ ----
  xv_Ddata = sqrt(5.0D0/6)*3.0*sin(xv_Lat)**2*cos(xv_Lat) * cos(xv_Lon)
  call AssertEqual(&
    message='Y_2^1 Test of xv_w(w_xv(xv_data,iflag=2))',          &
    answer = xv_Ddata,                                            &
    check = xv_w(w_xv(xv_data,iflag=2)),                          &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Y_2^1 Test of xv_w(w_xv(xv_data),iflag=2)',          &
    answer = xv_Ddata,                                            &
    check = xv_w(w_xv(xv_data),iflag=2),                          &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  call MessageNotify('M','Test of Y_2^1','Test of Y_2^1 succeeded!') 

  !==================== Y_2^-1 Υƥ ====================
  xv_data = -sqrt(5.0D0/6)*3.0*sin(xv_Lat)*cos(xv_Lat) * sin(xv_Lon)! Y_2^-1
  w_data= 0.0D0 ; w_data(l_nm(2,-1))=1.0D0/sqrt(2.0D0)

  !---- ̾Ѵ ----
  call AssertEqual(&
    message='Y_2^-1 Test of w_xv(xv_data)',                       &
    answer = w_data,                                              &
    check = w_xv(xv_data),                                        &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Y_2^-1 Test of xv_w(w_xv(xv_data))',                 &
    answer = xv_data,                                             &
    check = xv_w(w_xv(xv_data)),                                  &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- X ʬѴ ----
  xv_Ddata = -sqrt(5.0D0/6)*3.0*sin(xv_Lat)*cos(xv_Lat)*cos(xv_Lon)! Y_2^-1
  call AssertEqual(&
    message='Y_2^-1 Test of xv_w(w_xv(xv_data,iflag=-1))',        &
    answer = xv_Ddata,                                            &
    check = xv_w(w_xv(xv_data,iflag=-1)),                         &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Y_2^-1 Test of xv_w(w_xv(xv_data),iflag=-1)',        &
    answer = xv_Ddata,                                            &
    check = xv_w(w_xv(xv_data),iflag=-1),                         &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- Y ʬѴ ----
  xv_Ddata = -sqrt(5.0D0/6)*3.0 &
       *(cos(xv_Lat)**3-3*sin(xv_Lat)**2*cos(xv_Lat))*sin(xv_Lon)
  call AssertEqual(&
    message='Y_2^-1 Test of xv_w(w_xv(xv_data,iflag=1,ipow=0))',  &
    answer = xv_Ddata,                                            &
    check = xv_w(w_xv(xv_data,iflag=1,ipow=0)),                   &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  xv_Ddata = -sqrt(5.0D0/6)*3.0 * cos(2*xv_Lat) * sin(xv_Lon)
  call AssertEqual(&
    message='Y_2^-1 Test of xv_w(w_xv(xv_data),iflag=1,ipow=1)',  &
    answer = xv_Ddata,                                            &
    check = xv_w(w_xv(xv_data),iflag=1,ipow=1),                   &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- SIN ݤѴ ----
  xv_Ddata = -sqrt(5.0D0/6)*3.0*sin(xv_Lat)**2*cos(xv_Lat) * sin(xv_Lon)
  call AssertEqual(&
    message='Y_2^-1 Test of xv_w(w_xv(xv_data,iflag=2))',         &
    answer = xv_Ddata,                                            &
    check = xv_w(w_xv(xv_data,iflag=2)),                          &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Y_2^-1 Test of xv_w(w_xv(xv_data),iflag=2)',         &
    answer = xv_Ddata,                                            &
    check = xv_w(w_xv(xv_data),iflag=2),                          &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  call MessageNotify('M','Test of Y_2^-1','Test of Y_2^-1 succeeded!') 

  !==================== Y_2^2 Υƥ ====================
  xv_data = sqrt(5.0D0/24)*3.0*cos(xv_Lat)**2*cos(2*xv_Lon)         ! Y_2^2
  w_data= 0.0D0 ; w_data(l_nm(2,2))=1.0D0/sqrt(2.0D0)

  !---- ̾Ѵ ----
  call AssertEqual(&
    message='Y_2^2 Test of w_xv(xv_data)',                        &
    answer = w_data,                                              &
    check = w_xv(xv_data),                                        &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Y_2^2 Test of xv_w(w_xv(xv_data))',                  &
    answer = xv_data,                                             &
    check = xv_w(w_xv(xv_data)),                                  &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- X ʬѴ ----
  xv_Ddata = sqrt(5.0D0/24)*3.0*cos(xv_Lat)**2* (-2)* sin(2*xv_Lon)  ! Y_2^2
  call AssertEqual(&
    message='Y_2^2 Test of xv_w(w_xv(xv_data,iflag=-1))',         &
    answer = xv_Ddata,                                            &
    check = xv_w(w_xv(xv_data,iflag=-1)),                         &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Y_2^2 Test of xv_w(w_xv(xv_data),iflag=-1)',         &
    answer = xv_Ddata,                                            &
    check = xv_w(w_xv(xv_data),iflag=-1),                         &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- Y ʬѴ ----
  xv_Ddata = - sqrt(5.0D0/24)*3.0*4*sin(xv_Lat)*cos(xv_Lat)**2*cos(2*xv_Lon)
  call AssertEqual(&
    message='Y_2^2 Test of xv_w(w_xv(xv_data,iflag=1,ipow=0))',   &
    answer = xv_Ddata,                                            &
    check = xv_w(w_xv(xv_data,iflag=1,ipow=0)),                   &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  xv_Ddata = -sqrt(5.0D0/24)*3.0*2*cos(xv_Lat)*sin(xv_Lat)*cos(2*xv_Lon)
  call AssertEqual(&
    message='Y_2^2 Test of xv_w(w_xv(xv_data),iflag=1,ipow=1)',   &
    answer = xv_Ddata,                                            &
    check = xv_w(w_xv(xv_data),iflag=1,ipow=1),                   &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- SIN ݤѴ ----
  xv_Ddata = sqrt(5.0D0/24)*3.0*cos(xv_Lat)**2*sin(xv_Lat)*cos(2*xv_Lon)
  call AssertEqual(&
    message='Y_2^2 Test of xv_w(w_xv(xv_data,iflag=2))',          &
    answer = xv_Ddata,                                            &
    check = xv_w(w_xv(xv_data,iflag=2)),                          &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Y_2^2 Test of xv_w(w_xv(xv_data),iflag=2)',          &
    answer = xv_Ddata,                                            &
    check = xv_w(w_xv(xv_data),iflag=2),                          &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  call MessageNotify('M','Test of Y_2^2','Test of Y_2^2 succeeded!') 

  !==================== Y_2^-2 Υƥ ====================
  xv_data = -sqrt(5.0D0/24)*3.0*cos(xv_Lat)**2*sin(2*xv_Lon)         ! Y_2^-2
  w_data= 0.0D0 ; w_data(l_nm(2,-2))=1.0D0/sqrt(2.0D0)

  !---- ̾Ѵ ----
  call AssertEqual(&
    message='Y_2^-2 Test of w_xv(xv_data)',                        &
    answer = w_data,                                              &
    check = w_xv(xv_data),                                        &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Y_2^-2 Test of xv_w(w_xv(xv_data))',                 &
    answer = xv_data,                                             &
    check = xv_w(w_xv(xv_data)),                                  &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- X ʬѴ ----
  xv_Ddata = -sqrt(5.0D0/24)*3.0*cos(xv_Lat)**2* 2*cos(2*xv_Lon)  ! Y_2^2
  call AssertEqual(&
    message='Y_2^-2 Test of xv_w(w_xv(xv_data,iflag=-1))',        &
    answer = xv_Ddata,                                            &
    check = xv_w(w_xv(xv_data,iflag=-1)),                         &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Y_2^-2 Test of xv_w(w_xv(xv_data),iflag=-1)',        &
    answer = xv_Ddata,                                            &
    check = xv_w(w_xv(xv_data),iflag=-1),                         &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- Y ʬѴ ----
  xv_Ddata = sqrt(5.0D0/24)*3.0*4*sin(xv_Lat)*cos(xv_Lat)**2*sin(2*xv_Lon)
  call AssertEqual(&
    message='Y_2^-2 Test of xv_w(w_xv(xv_data,iflag=1,ipow=0))',  &
    answer = xv_Ddata,                                            &
    check = xv_w(w_xv(xv_data,iflag=1,ipow=0)),                   &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  xv_Ddata = sqrt(5.0D0/24)*3.0*2*cos(xv_Lat)*sin(xv_Lat)*sin(2*xv_Lon)
  call AssertEqual(&
    message='Y_2^-2 Test of xv_w(w_xv(xv_data),iflag=1,ipow=1)',  &
    answer = xv_Ddata,                                            &
    check = xv_w(w_xv(xv_data),iflag=1,ipow=1),                   &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- SIN ݤѴ ----
  xv_Ddata = -sqrt(5.0D0/24)*3.0*cos(xv_Lat)**2*sin(xv_Lat)*sin(2*xv_Lon)
  call AssertEqual(&
    message='Y_2^-2 Test of xv_w(w_xv(xv_data,iflag=2))',         &
    answer = xv_Ddata,                                            &
    check = xv_w(w_xv(xv_data,iflag=2)),                          &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Y_2^-2 Test of xv_w(w_xv(xv_data),iflag=2)',         &
    answer = xv_Ddata,                                            &
    check = xv_w(w_xv(xv_data),iflag=2),                          &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  call MessageNotify('M','Test of Y_2^-2','Test of Y_2^-2 succeeded!') 

  !==================== ŪؿΥƥ ====================
  xv_data = cos(2*xv_Lon-pi/3) &
       *(sin(xv_Lat)-1)**2*(sin(xv_Lat)-0.5)*(sin(xv_Lat)+1)

  !---- ̾Ѵ ----
  call AssertEqual(&
    message='general function of xv_w(w_xv(xv_data))',            &
    answer = xv_data,                                             &
    check = xv_w(w_xv(xv_data)),                                  &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- Y ʬѴ ----
  xv_data  = cos(xv_Lat)
  xv_Ddata = -2*sin(xv_Lat)

  call AssertEqual(&
    message='general function test of xv_w(w_xv(xv_data,iflag=1,ipow=1))',  &
    answer = xv_Ddata,                                            &
    check = xv_w(w_xv(xv_data,iflag=1,ipow=1)),                   &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  xv_data  = cos(xv_Lat)**2
  xv_Ddata = -2*sin(xv_Lat)
  call AssertEqual(&
    message='general function test of xv_w(w_xv(xv_data,iflag=1,ipow=2))',  &
    answer = xv_Ddata,                                            &
    check = xv_w(w_xv(xv_data,iflag=1,ipow=2)),                   &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  xv_data  = sin(xv_Lat)
  xv_Ddata = cos(xv_Lat)**2

  call AssertEqual(&
    message='general function test of xv_w(w_xv(xv_data),iflag=1,ipow=0)',  &
    answer = xv_Ddata,                                            &
    check = xv_w(w_xv(xv_data),iflag=1,ipow=0),                   &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  xv_data  = cos(xv_Lat)**2
  xv_Ddata = -2.0D0 * sin(xv_Lat)

  call AssertEqual(&
    message='general function test of xv_w(w_xv(xv_data),iflag=1,ipow=2)',  &
    answer = xv_Ddata,                                            &
    check = xv_w(w_xv(xv_data),iflag=1,ipow=2),                   &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !========================= xy_w, w_xy Υƥ===========================

  call MessageNotify('M','w_base_mpi_module_test', &
                         'w_base_mpi_module functions xy_w, w_xy tests') 

  !==================== Y_1^0 Υƥ ====================
  xy_data = sqrt(3.0D0)*sin(xy_Lat)                      ! Y_1^0
  w_data= 0.0D0 ; w_data(l_nm(1,0))=1.0D0

  !---- ̾Ѵ ----
  call AssertEqual(&
    message='Y_1^0 Test of w_xy(xy_data)',                        &
    answer = w_data,                                              &
    check = w_xy(xy_data),                                        &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Y_1^0 Test of xy_w(w_xy(xy_data))',                  &
    answer = xy_data,                                             &
    check = xy_w(w_xy(xy_data)),                                  &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- X ʬѴ ----
  xy_Ddata = 0.0D0
  call AssertEqual(&
    message='Y_1^0 Test of xy_w(w_xy(xy_data,iflag=-1))',         &
    answer = xy_Ddata,                                            &
    check = xy_w(w_xy(xy_data,iflag=-1)),                         &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Y_1^0 Test of xy_w(w_xy(xy_data),iflag=-1)',         &
    answer = xy_Ddata,                                            &
    check = xy_w(w_xy(xy_data),iflag=-1),                         &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- Y ʬѴ ----
  xy_Ddata = sqrt(3.0D0) * ( cos(xy_Lat)**2 - 2*sin(xy_Lat)**2 )
  call AssertEqual(&
    message='Y_1^0 Test of xy_w(w_xy(xy_data,iflag=1,ipow=0))',   &
    answer = xy_Ddata,                                            &
    check = xy_w(w_xy(xy_data,iflag=1,ipow=0)),                   &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  xy_Ddata = sqrt(3.0D0)*cos(xy_Lat)
  call AssertEqual(&
    message='Y_1^0 Test of xy_w(w_xy(xy_data),iflag=1,ipow=1)',   &
    answer = xy_Ddata,                                            &
    check = xy_w(w_xy(xy_data),iflag=1,ipow=1),                   &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- SIN ݤѴ ----
  xy_Ddata = sqrt(3.0D0) * sin(xy_Lat)**2
  call AssertEqual(&
    message='Y_1^0 Test of xy_w(w_xy(xy_data,iflag=2))',          &
    answer = xy_Ddata,                                            &
    check = xy_w(w_xy(xy_data,iflag=2)),                          &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Y_1^0 Test of xy_w(w_xy(xy_data),iflag=2)',          &
    answer = xy_Ddata,                                            &
    check = xy_w(w_xy(xy_data),iflag=2),                          &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  call MessageNotify('M','Test of Y_1^0','Test of Y_1^0 succeeded!') 

  !==================== Y_1^1 Υƥ ====================
  xy_data = sqrt(3.0D0/2)*cos(xy_Lat)*cos(xy_Lon)          ! Y_1^1
  w_data= 0.0D0 ; w_data(l_nm(1,1))=1.0D0/sqrt(2.0D0)

  !---- ̾Ѵ ----
  call AssertEqual(&
    message='Y_1^1 Test of w_xy(xy_data)',                        &
    answer = w_data,                                              &
    check = w_xy(xy_data),                                        &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Y_1^1 Test of xy_w(w_xy(xy_data))',                  &
    answer = xy_data,                                             &
    check = xy_w(w_xy(xy_data)),                                  &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- X ʬѴ ----
  xy_Ddata = -sqrt(3.0D0/2)*cos(xy_Lat)*sin(xy_Lon)          ! Y_1^1
  call AssertEqual(&
    message='Y_1^1 Test of xy_w(w_xy(xy_data,iflag=-1))',         &
    answer = xy_Ddata,                                            &
    check = xy_w(w_xy(xy_data,iflag=-1)),                         &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Y_1^1 Test of xy_w(w_xy(xy_data),iflag=-1)',         &
    answer = xy_Ddata,                                            &
    check = xy_w(w_xy(xy_data),iflag=-1),                         &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- Y ʬѴ ----
  xy_Ddata = - sqrt(3.0D0/2) * 3 * sin(xy_Lat) * cos(xy_Lat) * cos(xy_Lon)
  call AssertEqual(&
    message='Y_1^1 Test of xy_w(w_xy(xy_data,iflag=1,ipow=0))',   &
    answer = xy_Ddata,                                            &
    check = xy_w(w_xy(xy_data,iflag=1,ipow=0)),                   &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  xy_Ddata = - sqrt(3.0D0/2) * sin(xy_Lat) * cos(xy_Lon)
  call AssertEqual(&
    message='Y_1^1 Test of xy_w(w_xy(xy_data),iflag=1,ipow=1)',   &
    answer = xy_Ddata,                                            &
    check = xy_w(w_xy(xy_data),iflag=1,ipow=1),                   &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- SIN ݤѴ ----
  xy_Ddata = sqrt(3.0D0/2) * sin(xy_Lat)* cos(xy_Lat) * cos(xy_Lon)
  call AssertEqual(&
    message='Y_1^1 Test of xy_w(w_xy(xy_data,iflag=2))',          &
    answer = xy_Ddata,                                            &
    check = xy_w(w_xy(xy_data,iflag=2)),                          &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Y_1^1 Test of xy_w(w_xy(xy_data),iflag=2)',          &
    answer = xy_Ddata,                                            &
    check = xy_w(w_xy(xy_data),iflag=2),                          &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  call MessageNotify('M','Test of Y_1^1','Test of Y_1^1 succeeded!') 

  !==================== Y_1^{-1} Υƥ ====================
  xy_data = -sqrt(3.0D0/2)*cos(xy_Lat)*sin(xy_Lon)         ! Y_1^{-1}
  w_data= 0.0D0 ; w_data(l_nm(1,-1))=1.0D0/sqrt(2.0D0)

  !---- ̾Ѵ ----
  call AssertEqual(&
    message='Y_1^1 Test of w_xy(xy_data)',                        &
    answer = w_data,                                              &
    check = w_xy(xy_data),                                        &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Y_1^1 Test of xy_w(w_xy(xy_data))',                  &
    answer = xy_data,                                             &
    check = xy_w(w_xy(xy_data)),                                  &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- X ʬѴ ----
  xy_Ddata = -sqrt(3.0D0/2)*cos(xy_Lat)*cos(xy_Lon)          ! Y_1^{-1}
  call AssertEqual(&
    message='Y_1^1 Test of xy_w(w_xy(xy_data,iflag=-1))',         &
    answer = xy_Ddata,                                            &
    check = xy_w(w_xy(xy_data,iflag=-1)),                         &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Y_1^1 Test of xy_w(w_xy(xy_data),iflag=-1)',         &
    answer = xy_Ddata,                                            &
    check = xy_w(w_xy(xy_data),iflag=-1),                         &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- Y ʬѴ ----
  xy_Ddata = sqrt(3.0D0/2) * 3 * sin(xy_Lat) * cos(xy_Lat) * sin(xy_Lon)
  call AssertEqual(&
    message='Y_1^1 Test of xy_w(w_xy(xy_data,iflag=1,ipow=0))',   &
    answer = xy_Ddata,                                            &
    check = xy_w(w_xy(xy_data,iflag=1,ipow=0)),                   &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  xy_Ddata = sqrt(3.0D0/2) * sin(xy_Lat) * sin(xy_Lon)
  call AssertEqual(&
    message='Y_1^1 Test of xy_w(w_xy(xy_data),iflag=1,ipow=1)',   &
    answer = xy_Ddata,                                            &
    check = xy_w(w_xy(xy_data),iflag=1,ipow=1),                   &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- SIN ݤѴ ----
  xy_Ddata = - sqrt(3.0D0/2) * sin(xy_Lat)* cos(xy_Lat) * sin(xy_Lon)
  call AssertEqual(&
    message='Y_1^1 Test of xy_w(w_xy(xy_data,iflag=2))',          &
    answer = xy_Ddata,                                            &
    check = xy_w(w_xy(xy_data,iflag=2)),                          &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Y_1^1 Test of xy_w(w_xy(xy_data),iflag=2)',          &
    answer = xy_Ddata,                                            &
    check = xy_w(w_xy(xy_data),iflag=2),                          &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !==================== Y_2^0 Υƥ ====================
  xy_data = sqrt(5.0D0)*(3.0/2*sin(xy_Lat)**2-1/2.0)                 ! Y_2^0
  w_data= 0.0D0 ; w_data(l_nm(2,0))=1.0D0

  !---- ̾Ѵ ----
  call AssertEqual(&
    message='Y_2^0 Test of w_xy(xy_data)',                        &
    answer = w_data,                                              &
    check = w_xy(xy_data),                                        &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Y_2^0 Test of xy_w(w_xy(xy_data))',                  &
    answer = xy_data,                                             &
    check = xy_w(w_xy(xy_data)),                                  &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- X ʬѴ ----
  xy_Ddata = 0.0D0
  call AssertEqual(&
    message='Y_2^0 Test of xy_w(w_xy(xy_data,iflag=-1))',         &
    answer = xy_Ddata,                                            &
    check = xy_w(w_xy(xy_data,iflag=-1)),                         &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Y_2^0 Test of xy_w(w_xy(xy_data),iflag=-1)',         &
    answer = xy_Ddata,                                            &
    check = xy_w(w_xy(xy_data),iflag=-1),                         &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- Y ʬѴ ----
  xy_Ddata = sqrt(5.0D0)*(   3.0*sin(xy_Lat)*cos(xy_Lat)**2  &
                           - 3.0*sin(xy_Lat)**3 + sin(xy_Lat)  ) 
  call AssertEqual(&
    message='Y_2^0 Test of xy_w(w_xy(xy_data,iflag=1,ipow=0))',   &
    answer = xy_Ddata,                                            &
    check = xy_w(w_xy(xy_data,iflag=1,ipow=0)),                   &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  xy_Ddata = sqrt(5.0D0)*3.0*sin(xy_Lat)*cos(xy_Lat)
  call AssertEqual(&
    message='Y_2^0 Test of xy_w(w_xy(xy_data),iflag=1,ipow=1)',   &
    answer = xy_Ddata,                                            &
    check = xy_w(w_xy(xy_data),iflag=1,ipow=1),                   &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- SIN ݤѴ ----
  xy_Ddata = sqrt(5.0D0)*(3.0/2*sin(xy_Lat)**2-1/2.0)*sin(xy_Lat)
  call AssertEqual(&
    message='Y_2^0 Test of xy_w(w_xy(xy_data,iflag=2))',          &
    answer = xy_Ddata,                                            &
    check = xy_w(w_xy(xy_data,iflag=2)),                          &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Y_2^0 Test of xy_w(w_xy(xy_data),iflag=2)',          &
    answer = xy_Ddata,                                            &
    check = xy_w(w_xy(xy_data),iflag=2),                          &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  call MessageNotify('M','Test of Y_2^0','Test of Y_2^0 succeeded!') 

  !==================== Y_2^1 Υƥ ====================
  xy_data = sqrt(5.0D0/6)*3.0*sin(xy_Lat)*cos(xy_Lat) * cos(xy_Lon)! Y_2^1
  w_data= 0.0D0 ; w_data(l_nm(2,1))=1.0D0/sqrt(2.0D0)

  !---- ̾Ѵ ----
  call AssertEqual(&
    message='Y_2^1 Test of w_xy(xy_data)',                        &
    answer = w_data,                                              &
    check = w_xy(xy_data),                                        &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Y_2^1 Test of xy_w(w_xy(xy_data))',                  &
    answer = xy_data,                                             &
    check = xy_w(w_xy(xy_data)),                                  &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- X ʬѴ ----
  xy_Ddata = -sqrt(5.0D0/6)*3.0*sin(xy_Lat)*cos(xy_Lat)*sin(xy_Lon)! Y_2^1
  call AssertEqual(&
    message='Y_2^1 Test of xy_w(w_xy(xy_data,iflag=-1))',         &
    answer = xy_Ddata,                                            &
    check = xy_w(w_xy(xy_data,iflag=-1)),                         &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Y_2^1 Test of xy_w(w_xy(xy_data),iflag=-1)',         &
    answer = xy_Ddata,                                            &
    check = xy_w(w_xy(xy_data),iflag=-1),                         &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- Y ʬѴ ----
  xy_Ddata = sqrt(5.0D0/6)*3.0 &
       *(cos(xy_Lat)**3-3*sin(xy_Lat)**2*cos(xy_Lat))*cos(xy_Lon)
  call AssertEqual(&
    message='Y_2^1 Test of xy_w(w_xy(xy_data,iflag=1,ipow=1))',   &
    answer = xy_Ddata,                                            &
    check = xy_w(w_xy(xy_data,iflag=1,ipow=0)),                   &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  xy_Ddata = sqrt(5.0D0/6)*3.0 * cos(2*xy_Lat) * cos(xy_Lon)
  call AssertEqual(&
    message='Y_2^1 Test of xy_w(w_xy(xy_data),iflag=1,ipow=1)',   &
    answer = xy_Ddata,                                            &
    check = xy_w(w_xy(xy_data),iflag=1,ipow=1),                   &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- SIN ݤѴ ----
  xy_Ddata = sqrt(5.0D0/6)*3.0*sin(xy_Lat)**2*cos(xy_Lat) * cos(xy_Lon)
  call AssertEqual(&
    message='Y_2^1 Test of xy_w(w_xy(xy_data,iflag=2))',          &
    answer = xy_Ddata,                                            &
    check = xy_w(w_xy(xy_data,iflag=2)),                          &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Y_2^1 Test of xy_w(w_xy(xy_data),iflag=2)',          &
    answer = xy_Ddata,                                            &
    check = xy_w(w_xy(xy_data),iflag=2),                          &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  call MessageNotify('M','Test of Y_2^1','Test of Y_2^1 succeeded!') 

  !==================== Y_2^-1 Υƥ ====================
  xy_data = -sqrt(5.0D0/6)*3.0*sin(xy_Lat)*cos(xy_Lat) * sin(xy_Lon)! Y_2^-1
  w_data= 0.0D0 ; w_data(l_nm(2,-1))=1.0D0/sqrt(2.0D0)

  !---- ̾Ѵ ----
  call AssertEqual(&
    message='Y_2^-1 Test of w_xy(xy_data)',                       &
    answer = w_data,                                              &
    check = w_xy(xy_data),                                        &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Y_2^-1 Test of xy_w(w_xy(xy_data))',                 &
    answer = xy_data,                                             &
    check = xy_w(w_xy(xy_data)),                                  &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- X ʬѴ ----
  xy_Ddata = -sqrt(5.0D0/6)*3.0*sin(xy_Lat)*cos(xy_Lat)*cos(xy_Lon)! Y_2^-1
  call AssertEqual(&
    message='Y_2^-1 Test of xy_w(w_xy(xy_data,iflag=-1))',        &
    answer = xy_Ddata,                                            &
    check = xy_w(w_xy(xy_data,iflag=-1)),                         &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Y_2^-1 Test of xy_w(w_xy(xy_data),iflag=-1)',        &
    answer = xy_Ddata,                                            &
    check = xy_w(w_xy(xy_data),iflag=-1),                         &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- Y ʬѴ ----
  xy_Ddata = -sqrt(5.0D0/6)*3.0 &
       *(cos(xy_Lat)**3-3*sin(xy_Lat)**2*cos(xy_Lat))*sin(xy_Lon)
  call AssertEqual(&
    message='Y_2^-1 Test of xy_w(w_xy(xy_data,iflag=1,ipow=0))',  &
    answer = xy_Ddata,                                            &
    check = xy_w(w_xy(xy_data,iflag=1,ipow=0)),                   &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  xy_Ddata = -sqrt(5.0D0/6)*3.0 * cos(2*xy_Lat) * sin(xy_Lon)
  call AssertEqual(&
    message='Y_2^-1 Test of xy_w(w_xy(xy_data),iflag=1,ipow=1)',  &
    answer = xy_Ddata,                                            &
    check = xy_w(w_xy(xy_data),iflag=1,ipow=1),                   &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- SIN ݤѴ ----
  xy_Ddata = -sqrt(5.0D0/6)*3.0*sin(xy_Lat)**2*cos(xy_Lat) * sin(xy_Lon)
  call AssertEqual(&
    message='Y_2^-1 Test of xy_w(w_xy(xy_data,iflag=2))',         &
    answer = xy_Ddata,                                            &
    check = xy_w(w_xy(xy_data,iflag=2)),                          &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Y_2^-1 Test of xy_w(w_xy(xy_data),iflag=2)',         &
    answer = xy_Ddata,                                            &
    check = xy_w(w_xy(xy_data),iflag=2),                          &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  call MessageNotify('M','Test of Y_2^-1','Test of Y_2^-1 succeeded!') 

  !==================== Y_2^2 Υƥ ====================
  xy_data = sqrt(5.0D0/24)*3.0*cos(xy_Lat)**2*cos(2*xy_Lon)         ! Y_2^2
  w_data= 0.0D0 ; w_data(l_nm(2,2))=1.0D0/sqrt(2.0D0)

  !---- ̾Ѵ ----
  call AssertEqual(&
    message='Y_2^2 Test of w_xy(xy_data)',                        &
    answer = w_data,                                              &
    check = w_xy(xy_data),                                        &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Y_2^2 Test of xy_w(w_xy(xy_data))',                  &
    answer = xy_data,                                             &
    check = xy_w(w_xy(xy_data)),                                  &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- X ʬѴ ----
  xy_Ddata = sqrt(5.0D0/24)*3.0*cos(xy_Lat)**2* (-2)* sin(2*xy_Lon)  ! Y_2^2
  call AssertEqual(&
    message='Y_2^2 Test of xy_w(w_xy(xy_data,iflag=-1))',         &
    answer = xy_Ddata,                                            &
    check = xy_w(w_xy(xy_data,iflag=-1)),                         &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Y_2^2 Test of xy_w(w_xy(xy_data),iflag=-1)',         &
    answer = xy_Ddata,                                            &
    check = xy_w(w_xy(xy_data),iflag=-1),                         &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- Y ʬѴ ----
  xy_Ddata = - sqrt(5.0D0/24)*3.0*4*sin(xy_Lat)*cos(xy_Lat)**2*cos(2*xy_Lon)
  call AssertEqual(&
    message='Y_2^2 Test of xy_w(w_xy(xy_data,iflag=1,ipow=0))',   &
    answer = xy_Ddata,                                            &
    check = xy_w(w_xy(xy_data,iflag=1,ipow=0)),                   &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  xy_Ddata = -sqrt(5.0D0/24)*3.0*2*cos(xy_Lat)*sin(xy_Lat)*cos(2*xy_Lon)
  call AssertEqual(&
    message='Y_2^2 Test of xy_w(w_xy(xy_data),iflag=1,ipow=1)',   &
    answer = xy_Ddata,                                            &
    check = xy_w(w_xy(xy_data),iflag=1,ipow=1),                   &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- SIN ݤѴ ----
  xy_Ddata = sqrt(5.0D0/24)*3.0*cos(xy_Lat)**2*sin(xy_Lat)*cos(2*xy_Lon)
  call AssertEqual(&
    message='Y_2^2 Test of xy_w(w_xy(xy_data,iflag=2))',          &
    answer = xy_Ddata,                                            &
    check = xy_w(w_xy(xy_data,iflag=2)),                          &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Y_2^2 Test of xy_w(w_xy(xy_data),iflag=2)',          &
    answer = xy_Ddata,                                            &
    check = xy_w(w_xy(xy_data),iflag=2),                          &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  call MessageNotify('M','Test of Y_2^2','Test of Y_2^2 succeeded!') 

  !==================== Y_2^-2 Υƥ ====================
  xy_data = -sqrt(5.0D0/24)*3.0*cos(xy_Lat)**2*sin(2*xy_Lon)         ! Y_2^-2
  w_data= 0.0D0 ; w_data(l_nm(2,-2))=1.0D0/sqrt(2.0D0)

  !---- ̾Ѵ ----
  call AssertEqual(&
    message='Y_2^-2 Test of w_xy(xy_data)',                        &
    answer = w_data,                                              &
    check = w_xy(xy_data),                                        &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Y_2^-2 Test of xy_w(w_xy(xy_data))',                 &
    answer = xy_data,                                             &
    check = xy_w(w_xy(xy_data)),                                  &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- X ʬѴ ----
  xy_Ddata = -sqrt(5.0D0/24)*3.0*cos(xy_Lat)**2* 2*cos(2*xy_Lon)  ! Y_2^2
  call AssertEqual(&
    message='Y_2^-2 Test of xy_w(w_xy(xy_data,iflag=-1))',        &
    answer = xy_Ddata,                                            &
    check = xy_w(w_xy(xy_data,iflag=-1)),                         &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Y_2^-2 Test of xy_w(w_xy(xy_data),iflag=-1)',        &
    answer = xy_Ddata,                                            &
    check = xy_w(w_xy(xy_data),iflag=-1),                         &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- Y ʬѴ ----
  xy_Ddata = sqrt(5.0D0/24)*3.0*4*sin(xy_Lat)*cos(xy_Lat)**2*sin(2*xy_Lon)
  call AssertEqual(&
    message='Y_2^-2 Test of xy_w(w_xy(xy_data,iflag=1,ipow=0))',  &
    answer = xy_Ddata,                                            &
    check = xy_w(w_xy(xy_data,iflag=1,ipow=0)),                   &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  xy_Ddata = sqrt(5.0D0/24)*3.0*2*cos(xy_Lat)*sin(xy_Lat)*sin(2*xy_Lon)
  call AssertEqual(&
    message='Y_2^-2 Test of xy_w(w_xy(xy_data),iflag=1,ipow=1)',  &
    answer = xy_Ddata,                                            &
    check = xy_w(w_xy(xy_data),iflag=1,ipow=1),                   &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- SIN ݤѴ ----
  xy_Ddata = -sqrt(5.0D0/24)*3.0*cos(xy_Lat)**2*sin(xy_Lat)*sin(2*xy_Lon)
  call AssertEqual(&
    message='Y_2^-2 Test of xy_w(w_xy(xy_data,iflag=2))',         &
    answer = xy_Ddata,                                            &
    check = xy_w(w_xy(xy_data,iflag=2)),                          &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Y_2^-2 Test of xy_w(w_xy(xy_data),iflag=2)',         &
    answer = xy_Ddata,                                            &
    check = xy_w(w_xy(xy_data),iflag=2),                          &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  call MessageNotify('M','Test of Y_2^-2','Test of Y_2^-2 succeeded!') 

  !==================== ŪؿΥƥ ====================
  xy_data = cos(2*xy_Lon-pi/3) &
       *(sin(xy_Lat)-1)**2*(sin(xy_Lat)-0.5)*(sin(xy_Lat)+1)

  !---- ̾Ѵ ----
  call AssertEqual(&
    message='general function of xy_w(w_xy(xy_data))',            &
    answer = xy_data,                                             &
    check = xy_w(w_xy(xy_data)),                                  &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- Y ʬѴ ----
  xy_data  = cos(xy_Lat)
  xy_Ddata = -2*sin(xy_Lat)

  call AssertEqual(&
    message='general function test of xy_w(w_xy(xy_data,iflag=1,ipow=1))',  &
    answer = xy_Ddata,                                            &
    check = xy_w(w_xy(xy_data,iflag=1,ipow=1)),                   &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  xy_data  = cos(xy_Lat)**2
  xy_Ddata = -2*sin(xy_Lat)
  call AssertEqual(&
    message='general function test of xy_w(w_xy(xy_data,iflag=1,ipow=2))',  &
    answer = xy_Ddata,                                            &
    check = xy_w(w_xy(xy_data,iflag=1,ipow=2)),                   &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  xy_data  = sin(xy_Lat)
  xy_Ddata = cos(xy_Lat)**2

  call AssertEqual(&
    message='general function test of xy_w(w_xy(xy_data),iflag=1,ipow=0)',  &
    answer = xy_Ddata,                                            &
    check = xy_w(w_xy(xy_data),iflag=1,ipow=0),                   &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  xy_data  = cos(xy_Lat)**2
  xy_Ddata = -2.0D0 * sin(xy_Lat)

  call AssertEqual(&
    message='general function test of xy_w(w_xy(xy_data),iflag=1,ipow=2)',  &
    answer = xy_Ddata,                                            &
    check = xy_w(w_xy(xy_data),iflag=1,ipow=2),                   &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  call MessageNotify('M','Test of genral function', &
       'Test of general function succeeded!') 


  deallocate(w_data)
  deallocate(xy_data)
  deallocate(xy_Ddata)
  deallocate(xv_data)
  deallocate(xv_Ddata)

  call w_mpi_Finalize

  end do

 !------ MPIνλ ------

  call MPI_FINALIZE(IERR)

  call MessageNotify('M','w_base_mpi_module_finalize_test', &
       'w_base_mpi_module finalize subroutine tests succeeded.') 


end program w_base_mpi_module_finalize_test
