// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.1
// 	protoc        v4.25.3
// source: google/cloud/discoveryengine/v1alpha/completion.proto

package discoveryenginepb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Operator for matching with the generated suggestions.
type SuggestionDenyListEntry_MatchOperator int32

const (
	// Default value. Should not be used
	SuggestionDenyListEntry_MATCH_OPERATOR_UNSPECIFIED SuggestionDenyListEntry_MatchOperator = 0
	// If the suggestion is an exact match to the block_phrase, then block it.
	SuggestionDenyListEntry_EXACT_MATCH SuggestionDenyListEntry_MatchOperator = 1
	// If the suggestion contains the block_phrase, then block it.
	SuggestionDenyListEntry_CONTAINS SuggestionDenyListEntry_MatchOperator = 2
)

// Enum value maps for SuggestionDenyListEntry_MatchOperator.
var (
	SuggestionDenyListEntry_MatchOperator_name = map[int32]string{
		0: "MATCH_OPERATOR_UNSPECIFIED",
		1: "EXACT_MATCH",
		2: "CONTAINS",
	}
	SuggestionDenyListEntry_MatchOperator_value = map[string]int32{
		"MATCH_OPERATOR_UNSPECIFIED": 0,
		"EXACT_MATCH":                1,
		"CONTAINS":                   2,
	}
)

func (x SuggestionDenyListEntry_MatchOperator) Enum() *SuggestionDenyListEntry_MatchOperator {
	p := new(SuggestionDenyListEntry_MatchOperator)
	*p = x
	return p
}

func (x SuggestionDenyListEntry_MatchOperator) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SuggestionDenyListEntry_MatchOperator) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_discoveryengine_v1alpha_completion_proto_enumTypes[0].Descriptor()
}

func (SuggestionDenyListEntry_MatchOperator) Type() protoreflect.EnumType {
	return &file_google_cloud_discoveryengine_v1alpha_completion_proto_enumTypes[0]
}

func (x SuggestionDenyListEntry_MatchOperator) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SuggestionDenyListEntry_MatchOperator.Descriptor instead.
func (SuggestionDenyListEntry_MatchOperator) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_completion_proto_rawDescGZIP(), []int{0, 0}
}

// Suggestion deny list entry identifying the phrase to block from suggestions
// and the applied operation for the phrase.
type SuggestionDenyListEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Phrase to block from suggestions served. Can be maximum 125
	// characters.
	BlockPhrase string `protobuf:"bytes,1,opt,name=block_phrase,json=blockPhrase,proto3" json:"block_phrase,omitempty"`
	// Required. The match operator to apply for this phrase. Whether to block the
	// exact phrase, or block any suggestions containing this phrase.
	MatchOperator SuggestionDenyListEntry_MatchOperator `protobuf:"varint,2,opt,name=match_operator,json=matchOperator,proto3,enum=google.cloud.discoveryengine.v1alpha.SuggestionDenyListEntry_MatchOperator" json:"match_operator,omitempty"`
}

func (x *SuggestionDenyListEntry) Reset() {
	*x = SuggestionDenyListEntry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_completion_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SuggestionDenyListEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SuggestionDenyListEntry) ProtoMessage() {}

func (x *SuggestionDenyListEntry) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_completion_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SuggestionDenyListEntry.ProtoReflect.Descriptor instead.
func (*SuggestionDenyListEntry) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_completion_proto_rawDescGZIP(), []int{0}
}

func (x *SuggestionDenyListEntry) GetBlockPhrase() string {
	if x != nil {
		return x.BlockPhrase
	}
	return ""
}

func (x *SuggestionDenyListEntry) GetMatchOperator() SuggestionDenyListEntry_MatchOperator {
	if x != nil {
		return x.MatchOperator
	}
	return SuggestionDenyListEntry_MATCH_OPERATOR_UNSPECIFIED
}

var File_google_cloud_discoveryengine_v1alpha_completion_proto protoreflect.FileDescriptor

var file_google_cloud_discoveryengine_v1alpha_completion_proto_rawDesc = []byte{
	0x0a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x24, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x8a,
	0x02, 0x0a, 0x17, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x6e,
	0x79, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x26, 0x0a, 0x0c, 0x62, 0x6c,
	0x6f, 0x63, 0x6b, 0x5f, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x50, 0x68, 0x72, 0x61,
	0x73, 0x65, 0x12, 0x77, 0x0a, 0x0e, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x6f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76,
	0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x6e, 0x79,
	0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x6d, 0x61,
	0x74, 0x63, 0x68, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x22, 0x4e, 0x0a, 0x0d, 0x4d,
	0x61, 0x74, 0x63, 0x68, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x1e, 0x0a, 0x1a,
	0x4d, 0x41, 0x54, 0x43, 0x48, 0x5f, 0x4f, 0x50, 0x45, 0x52, 0x41, 0x54, 0x4f, 0x52, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b,
	0x45, 0x58, 0x41, 0x43, 0x54, 0x5f, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x10, 0x01, 0x12, 0x0c, 0x0a,
	0x08, 0x43, 0x4f, 0x4e, 0x54, 0x41, 0x49, 0x4e, 0x53, 0x10, 0x02, 0x42, 0x9b, 0x02, 0x0a, 0x28,
	0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x42, 0x0f, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65,
	0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x52, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f,
	0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x64, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x70, 0x62, 0x3b, 0x64, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x70, 0x62, 0xa2,
	0x02, 0x0f, 0x44, 0x49, 0x53, 0x43, 0x4f, 0x56, 0x45, 0x52, 0x59, 0x45, 0x4e, 0x47, 0x49, 0x4e,
	0x45, 0xaa, 0x02, 0x24, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x2e, 0x56, 0x31, 0x41, 0x6c, 0x70, 0x68, 0x61, 0xca, 0x02, 0x24, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5c, 0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0xea,
	0x02, 0x27, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a,
	0x3a, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x3a, 0x3a, 0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x33,
}

var (
	file_google_cloud_discoveryengine_v1alpha_completion_proto_rawDescOnce sync.Once
	file_google_cloud_discoveryengine_v1alpha_completion_proto_rawDescData = file_google_cloud_discoveryengine_v1alpha_completion_proto_rawDesc
)

func file_google_cloud_discoveryengine_v1alpha_completion_proto_rawDescGZIP() []byte {
	file_google_cloud_discoveryengine_v1alpha_completion_proto_rawDescOnce.Do(func() {
		file_google_cloud_discoveryengine_v1alpha_completion_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_discoveryengine_v1alpha_completion_proto_rawDescData)
	})
	return file_google_cloud_discoveryengine_v1alpha_completion_proto_rawDescData
}

var file_google_cloud_discoveryengine_v1alpha_completion_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_discoveryengine_v1alpha_completion_proto_msgTypes = make([]protoimpl.MessageInfo, 1)
var file_google_cloud_discoveryengine_v1alpha_completion_proto_goTypes = []interface{}{
	(SuggestionDenyListEntry_MatchOperator)(0), // 0: google.cloud.discoveryengine.v1alpha.SuggestionDenyListEntry.MatchOperator
	(*SuggestionDenyListEntry)(nil),            // 1: google.cloud.discoveryengine.v1alpha.SuggestionDenyListEntry
}
var file_google_cloud_discoveryengine_v1alpha_completion_proto_depIdxs = []int32{
	0, // 0: google.cloud.discoveryengine.v1alpha.SuggestionDenyListEntry.match_operator:type_name -> google.cloud.discoveryengine.v1alpha.SuggestionDenyListEntry.MatchOperator
	1, // [1:1] is the sub-list for method output_type
	1, // [1:1] is the sub-list for method input_type
	1, // [1:1] is the sub-list for extension type_name
	1, // [1:1] is the sub-list for extension extendee
	0, // [0:1] is the sub-list for field type_name
}

func init() { file_google_cloud_discoveryengine_v1alpha_completion_proto_init() }
func file_google_cloud_discoveryengine_v1alpha_completion_proto_init() {
	if File_google_cloud_discoveryengine_v1alpha_completion_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_discoveryengine_v1alpha_completion_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SuggestionDenyListEntry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_discoveryengine_v1alpha_completion_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   1,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_discoveryengine_v1alpha_completion_proto_goTypes,
		DependencyIndexes: file_google_cloud_discoveryengine_v1alpha_completion_proto_depIdxs,
		EnumInfos:         file_google_cloud_discoveryengine_v1alpha_completion_proto_enumTypes,
		MessageInfos:      file_google_cloud_discoveryengine_v1alpha_completion_proto_msgTypes,
	}.Build()
	File_google_cloud_discoveryengine_v1alpha_completion_proto = out.File
	file_google_cloud_discoveryengine_v1alpha_completion_proto_rawDesc = nil
	file_google_cloud_discoveryengine_v1alpha_completion_proto_goTypes = nil
	file_google_cloud_discoveryengine_v1alpha_completion_proto_depIdxs = nil
}
