/*
 * Copyright (C) 2024-2025, KylinSoft Co., Ltd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Authors: Yunhe Liu <liuyunhe@kylinos.cn>
 *
 */

/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "libsyncconfig.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

/* ------------------------------------------------------------------------
 * Code for interface com.kylin.kysdk.SyncConfig
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:SyncConfig
 * @title: SyncConfig
 * @short_description: Generated C code for the com.kylin.kysdk.SyncConfig D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-com-kylin-kysdk-SyncConfig.top_of_page">com.kylin.kysdk.SyncConfig</link> D-Bus interface in C.
 */

/* ---- Introspection data for com.kylin.kysdk.SyncConfig ---- */

static const _ExtendedGDBusArgInfo _sync_config__method_info_register_schema_IN_ARG_Conf2Id =
{
  {
    -1,
    (gchar *) "Conf2Id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _sync_config__method_info_register_schema_IN_ARG_SchemaId =
{
  {
    -1,
    (gchar *) "SchemaId",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _sync_config__method_info_register_schema_IN_ARG_SchemaPath =
{
  {
    -1,
    (gchar *) "SchemaPath",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _sync_config__method_info_register_schema_IN_ARG_pointers[] =
{
  &_sync_config__method_info_register_schema_IN_ARG_Conf2Id.parent_struct,
  &_sync_config__method_info_register_schema_IN_ARG_SchemaId.parent_struct,
  &_sync_config__method_info_register_schema_IN_ARG_SchemaPath.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _sync_config__method_info_register_schema_OUT_ARG_ArgOut =
{
  {
    -1,
    (gchar *) "ArgOut",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _sync_config__method_info_register_schema_OUT_ARG_pointers[] =
{
  &_sync_config__method_info_register_schema_OUT_ARG_ArgOut.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _sync_config__method_info_register_schema =
{
  {
    -1,
    (gchar *) "RegisterSchema",
    (GDBusArgInfo **) &_sync_config__method_info_register_schema_IN_ARG_pointers,
    (GDBusArgInfo **) &_sync_config__method_info_register_schema_OUT_ARG_pointers,
    NULL
  },
  "handle-register-schema",
  FALSE
};

static const _ExtendedGDBusArgInfo _sync_config__method_info_unregister_schema_IN_ARG_SchemaId =
{
  {
    -1,
    (gchar *) "SchemaId",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _sync_config__method_info_unregister_schema_IN_ARG_SchemaPath =
{
  {
    -1,
    (gchar *) "SchemaPath",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _sync_config__method_info_unregister_schema_IN_ARG_pointers[] =
{
  &_sync_config__method_info_unregister_schema_IN_ARG_SchemaId.parent_struct,
  &_sync_config__method_info_unregister_schema_IN_ARG_SchemaPath.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _sync_config__method_info_unregister_schema_OUT_ARG_ArgOut =
{
  {
    -1,
    (gchar *) "ArgOut",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _sync_config__method_info_unregister_schema_OUT_ARG_pointers[] =
{
  &_sync_config__method_info_unregister_schema_OUT_ARG_ArgOut.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _sync_config__method_info_unregister_schema =
{
  {
    -1,
    (gchar *) "UnregisterSchema",
    (GDBusArgInfo **) &_sync_config__method_info_unregister_schema_IN_ARG_pointers,
    (GDBusArgInfo **) &_sync_config__method_info_unregister_schema_OUT_ARG_pointers,
    NULL
  },
  "handle-unregister-schema",
  FALSE
};

static const GDBusMethodInfo * const _sync_config__method_info_pointers[] =
{
  &_sync_config__method_info_register_schema.parent_struct,
  &_sync_config__method_info_unregister_schema.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _sync_config__signal_info_state_ARG_state =
{
  {
    -1,
    (gchar *) "state",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _sync_config__signal_info_state_ARG_pointers[] =
{
  &_sync_config__signal_info_state_ARG_state.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _sync_config__signal_info_state =
{
  {
    -1,
    (gchar *) "state",
    (GDBusArgInfo **) &_sync_config__signal_info_state_ARG_pointers,
    NULL
  },
  "state"
};

static const GDBusSignalInfo * const _sync_config__signal_info_pointers[] =
{
  &_sync_config__signal_info_state.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _sync_config__interface_info =
{
  {
    -1,
    (gchar *) "com.kylin.kysdk.SyncConfig",
    (GDBusMethodInfo **) &_sync_config__method_info_pointers,
    (GDBusSignalInfo **) &_sync_config__signal_info_pointers,
    NULL,
    NULL
  },
  "",
};


/**
 * sync_config__interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-com-kylin-kysdk-SyncConfig.top_of_page">com.kylin.kysdk.SyncConfig</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
sync_config__interface_info (void)
{
  return (GDBusInterfaceInfo *) &_sync_config__interface_info.parent_struct;
}

/**
 * sync_config__override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #SyncConfig interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
sync_config__override_properties (GObjectClass *klass, guint property_id_begin)
{
  return property_id_begin - 1;
}



/**
 * SyncConfig:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-com-kylin-kysdk-SyncConfig.top_of_page">com.kylin.kysdk.SyncConfig</link>.
 */

/**
 * SyncConfigIface:
 * @parent_iface: The parent interface.
 * @handle_register_schema: Handler for the #SyncConfig::handle-register-schema signal.
 * @handle_unregister_schema: Handler for the #SyncConfig::handle-unregister-schema signal.
 * @state: Handler for the #SyncConfig::state signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-com-kylin-kysdk-SyncConfig.top_of_page">com.kylin.kysdk.SyncConfig</link>.
 */

typedef SyncConfigIface SyncConfigInterface;
G_DEFINE_INTERFACE (SyncConfig, sync_config_, G_TYPE_OBJECT)

static void
sync_config__default_init (SyncConfigIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * SyncConfig::handle-register-schema:
   * @object: A #SyncConfig.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_Conf2Id: Argument passed by remote caller.
   * @arg_SchemaId: Argument passed by remote caller.
   * @arg_SchemaPath: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-com-kylin-kysdk-SyncConfig.RegisterSchema">RegisterSchema()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call sync_config__complete_register_schema() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-register-schema",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (SyncConfigIface, handle_register_schema),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * SyncConfig::handle-unregister-schema:
   * @object: A #SyncConfig.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_SchemaId: Argument passed by remote caller.
   * @arg_SchemaPath: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-com-kylin-kysdk-SyncConfig.UnregisterSchema">UnregisterSchema()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call sync_config__complete_unregister_schema() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-unregister-schema",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (SyncConfigIface, handle_unregister_schema),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /* GObject signals for received D-Bus signals: */
  /**
   * SyncConfig::state:
   * @object: A #SyncConfig.
   * @arg_state: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-com-kylin-kysdk-SyncConfig.state">"state"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("state",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (SyncConfigIface, state),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    1, G_TYPE_INT);

}

/**
 * sync_config__emit_state:
 * @object: A #SyncConfig.
 * @arg_state: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-com-kylin-kysdk-SyncConfig.state">"state"</link> D-Bus signal.
 */
void
sync_config__emit_state (
    SyncConfig *object,
    gint arg_state)
{
  g_signal_emit_by_name (object, "state", arg_state);
}

/**
 * sync_config__call_register_schema:
 * @proxy: A #SyncConfigProxy.
 * @arg_Conf2Id: Argument to pass with the method invocation.
 * @arg_SchemaId: Argument to pass with the method invocation.
 * @arg_SchemaPath: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-com-kylin-kysdk-SyncConfig.RegisterSchema">RegisterSchema()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call sync_config__call_register_schema_finish() to get the result of the operation.
 *
 * See sync_config__call_register_schema_sync() for the synchronous, blocking version of this method.
 */
void
sync_config__call_register_schema (
    SyncConfig *proxy,
    const gchar *arg_Conf2Id,
    const gchar *arg_SchemaId,
    const gchar *arg_SchemaPath,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "RegisterSchema",
    g_variant_new ("(sss)",
                   arg_Conf2Id,
                   arg_SchemaId,
                   arg_SchemaPath),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * sync_config__call_register_schema_finish:
 * @proxy: A #SyncConfigProxy.
 * @out_ArgOut: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to sync_config__call_register_schema().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with sync_config__call_register_schema().
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
sync_config__call_register_schema_finish (
    SyncConfig *proxy,
    gboolean *out_ArgOut,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_ArgOut);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * sync_config__call_register_schema_sync:
 * @proxy: A #SyncConfigProxy.
 * @arg_Conf2Id: Argument to pass with the method invocation.
 * @arg_SchemaId: Argument to pass with the method invocation.
 * @arg_SchemaPath: Argument to pass with the method invocation.
 * @out_ArgOut: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-com-kylin-kysdk-SyncConfig.RegisterSchema">RegisterSchema()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See sync_config__call_register_schema() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
sync_config__call_register_schema_sync (
    SyncConfig *proxy,
    const gchar *arg_Conf2Id,
    const gchar *arg_SchemaId,
    const gchar *arg_SchemaPath,
    gboolean *out_ArgOut,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "RegisterSchema",
    g_variant_new ("(sss)",
                   arg_Conf2Id,
                   arg_SchemaId,
                   arg_SchemaPath),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_ArgOut);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * sync_config__call_unregister_schema:
 * @proxy: A #SyncConfigProxy.
 * @arg_SchemaId: Argument to pass with the method invocation.
 * @arg_SchemaPath: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-com-kylin-kysdk-SyncConfig.UnregisterSchema">UnregisterSchema()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call sync_config__call_unregister_schema_finish() to get the result of the operation.
 *
 * See sync_config__call_unregister_schema_sync() for the synchronous, blocking version of this method.
 */
void
sync_config__call_unregister_schema (
    SyncConfig *proxy,
    const gchar *arg_SchemaId,
    const gchar *arg_SchemaPath,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "UnregisterSchema",
    g_variant_new ("(ss)",
                   arg_SchemaId,
                   arg_SchemaPath),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * sync_config__call_unregister_schema_finish:
 * @proxy: A #SyncConfigProxy.
 * @out_ArgOut: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to sync_config__call_unregister_schema().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with sync_config__call_unregister_schema().
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
sync_config__call_unregister_schema_finish (
    SyncConfig *proxy,
    gboolean *out_ArgOut,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_ArgOut);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * sync_config__call_unregister_schema_sync:
 * @proxy: A #SyncConfigProxy.
 * @arg_SchemaId: Argument to pass with the method invocation.
 * @arg_SchemaPath: Argument to pass with the method invocation.
 * @out_ArgOut: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-com-kylin-kysdk-SyncConfig.UnregisterSchema">UnregisterSchema()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See sync_config__call_unregister_schema() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
sync_config__call_unregister_schema_sync (
    SyncConfig *proxy,
    const gchar *arg_SchemaId,
    const gchar *arg_SchemaPath,
    gboolean *out_ArgOut,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "UnregisterSchema",
    g_variant_new ("(ss)",
                   arg_SchemaId,
                   arg_SchemaPath),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_ArgOut);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * sync_config__complete_register_schema:
 * @object: A #SyncConfig.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @ArgOut: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-com-kylin-kysdk-SyncConfig.RegisterSchema">RegisterSchema()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
sync_config__complete_register_schema (
    SyncConfig *object,
    GDBusMethodInvocation *invocation,
    gboolean ArgOut)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(b)",
                   ArgOut));
}

/**
 * sync_config__complete_unregister_schema:
 * @object: A #SyncConfig.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @ArgOut: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-com-kylin-kysdk-SyncConfig.UnregisterSchema">UnregisterSchema()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
sync_config__complete_unregister_schema (
    SyncConfig *object,
    GDBusMethodInvocation *invocation,
    gboolean ArgOut)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(b)",
                   ArgOut));
}

/* ------------------------------------------------------------------------ */

/**
 * SyncConfigProxy:
 *
 * The #SyncConfigProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * SyncConfigProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #SyncConfigProxy.
 */

struct _SyncConfigProxyPrivate
{
  GData *qdata;
};

static void sync_config__proxy_iface_init (SyncConfigIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (SyncConfigProxy, sync_config__proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (SyncConfigProxy)
                         G_IMPLEMENT_INTERFACE (SYNC_CONFIG_TYPE_, sync_config__proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (SyncConfigProxy, sync_config__proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (SYNC_CONFIG_TYPE_, sync_config__proxy_iface_init))

#endif
static void
sync_config__proxy_finalize (GObject *object)
{
  SyncConfigProxy *proxy = SYNC_CONFIG__PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (sync_config__proxy_parent_class)->finalize (object);
}

static void
sync_config__proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
sync_config__proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
sync_config__proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_sync_config__interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], SYNC_CONFIG_TYPE_);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, SYNC_CONFIG_TYPE_);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
sync_config__proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  SyncConfigProxy *proxy = SYNC_CONFIG__PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_sync_config__interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_sync_config__interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
sync_config__proxy_init (SyncConfigProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = sync_config__proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, SYNC_CONFIG_TYPE__PROXY, SyncConfigProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), sync_config__interface_info ());
}

static void
sync_config__proxy_class_init (SyncConfigProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = sync_config__proxy_finalize;
  gobject_class->get_property = sync_config__proxy_get_property;
  gobject_class->set_property = sync_config__proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = sync_config__proxy_g_signal;
  proxy_class->g_properties_changed = sync_config__proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (SyncConfigProxyPrivate));
#endif
}

static void
sync_config__proxy_iface_init (SyncConfigIface *iface)
{
}

/**
 * sync_config__proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-com-kylin-kysdk-SyncConfig.top_of_page">com.kylin.kysdk.SyncConfig</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call sync_config__proxy_new_finish() to get the result of the operation.
 *
 * See sync_config__proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
sync_config__proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (SYNC_CONFIG_TYPE__PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "com.kylin.kysdk.SyncConfig", NULL);
}

/**
 * sync_config__proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to sync_config__proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with sync_config__proxy_new().
 *
 * Returns: (transfer full) (type SyncConfigProxy): The constructed proxy object or %NULL if @error is set.
 */
SyncConfig *
sync_config__proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return SYNC_CONFIG_ (ret);
  else
    return NULL;
}

/**
 * sync_config__proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-com-kylin-kysdk-SyncConfig.top_of_page">com.kylin.kysdk.SyncConfig</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See sync_config__proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type SyncConfigProxy): The constructed proxy object or %NULL if @error is set.
 */
SyncConfig *
sync_config__proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (SYNC_CONFIG_TYPE__PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "com.kylin.kysdk.SyncConfig", NULL);
  if (ret != NULL)
    return SYNC_CONFIG_ (ret);
  else
    return NULL;
}


/**
 * sync_config__proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like sync_config__proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call sync_config__proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See sync_config__proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
sync_config__proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (SYNC_CONFIG_TYPE__PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "com.kylin.kysdk.SyncConfig", NULL);
}

/**
 * sync_config__proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to sync_config__proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with sync_config__proxy_new_for_bus().
 *
 * Returns: (transfer full) (type SyncConfigProxy): The constructed proxy object or %NULL if @error is set.
 */
SyncConfig *
sync_config__proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return SYNC_CONFIG_ (ret);
  else
    return NULL;
}

/**
 * sync_config__proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like sync_config__proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See sync_config__proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type SyncConfigProxy): The constructed proxy object or %NULL if @error is set.
 */
SyncConfig *
sync_config__proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (SYNC_CONFIG_TYPE__PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "com.kylin.kysdk.SyncConfig", NULL);
  if (ret != NULL)
    return SYNC_CONFIG_ (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * SyncConfigSkeleton:
 *
 * The #SyncConfigSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * SyncConfigSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #SyncConfigSkeleton.
 */

struct _SyncConfigSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_sync_config__skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  SyncConfigSkeleton *skeleton = SYNC_CONFIG__SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], SYNC_CONFIG_TYPE_);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, SYNC_CONFIG_TYPE_);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_sync_config__skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  SyncConfigSkeleton *skeleton = SYNC_CONFIG__SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_sync_config__interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_sync_config__skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  SyncConfigSkeleton *skeleton = SYNC_CONFIG__SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_sync_config__interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _sync_config__skeleton_vtable =
{
  _sync_config__skeleton_handle_method_call,
  _sync_config__skeleton_handle_get_property,
  _sync_config__skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
sync_config__skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return sync_config__interface_info ();
}

static GDBusInterfaceVTable *
sync_config__skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_sync_config__skeleton_vtable;
}

static GVariant *
sync_config__skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  SyncConfigSkeleton *skeleton = SYNC_CONFIG__SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_sync_config__interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _sync_config__interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _sync_config__interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _sync_config__skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "com.kylin.kysdk.SyncConfig", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
sync_config__skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
}

static void
_sync_config__on_signal_state (
    SyncConfig *object,
    gint arg_state)
{
  SyncConfigSkeleton *skeleton = SYNC_CONFIG__SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(i)",
                   arg_state));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "com.kylin.kysdk.SyncConfig", "state",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void sync_config__skeleton_iface_init (SyncConfigIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (SyncConfigSkeleton, sync_config__skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (SyncConfigSkeleton)
                         G_IMPLEMENT_INTERFACE (SYNC_CONFIG_TYPE_, sync_config__skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (SyncConfigSkeleton, sync_config__skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (SYNC_CONFIG_TYPE_, sync_config__skeleton_iface_init))

#endif
static void
sync_config__skeleton_finalize (GObject *object)
{
  SyncConfigSkeleton *skeleton = SYNC_CONFIG__SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (sync_config__skeleton_parent_class)->finalize (object);
}

static void
sync_config__skeleton_init (SyncConfigSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = sync_config__skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, SYNC_CONFIG_TYPE__SKELETON, SyncConfigSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
sync_config__skeleton_class_init (SyncConfigSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = sync_config__skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = sync_config__skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = sync_config__skeleton_dbus_interface_get_properties;
  skeleton_class->flush = sync_config__skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = sync_config__skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (SyncConfigSkeletonPrivate));
#endif
}

static void
sync_config__skeleton_iface_init (SyncConfigIface *iface)
{
  iface->state = _sync_config__on_signal_state;
}

/**
 * sync_config__skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-com-kylin-kysdk-SyncConfig.top_of_page">com.kylin.kysdk.SyncConfig</link>.
 *
 * Returns: (transfer full) (type SyncConfigSkeleton): The skeleton object.
 */
SyncConfig *
sync_config__skeleton_new (void)
{
  return SYNC_CONFIG_ (g_object_new (SYNC_CONFIG_TYPE__SKELETON, NULL));
}

