////////////////////////////////////////////////////////////////////////////////////////
//
//  Copyright 2023 OVITO GmbH, Germany
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify it either under the
//  terms of the GNU General Public License version 3 as published by the Free Software
//  Foundation (the "GPL") or, at your option, under the terms of the MIT License.
//  If you do not alter this notice, a recipient may use your version of this
//  file under either the GPL or the MIT License.
//
//  You should have received a copy of the GPL along with this program in a
//  file LICENSE.GPL.txt.  You should have received a copy of the MIT License along
//  with this program in a file LICENSE.MIT.txt
//
//  This software is distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND,
//  either express or implied. See the GPL or the MIT License for the specific language
//  governing rights and limitations.
//
////////////////////////////////////////////////////////////////////////////////////////

/**
 * \file
 * \brief This high-level header file includes other headers to import the most important linear algebra classes.
 */

#pragma once


#include <ovito/core/Core.h>

#include "Vector3.h"
#include "Vector2.h"
#include "Vector4.h"
#include "Point3.h"
#include "Point2.h"
#include "Matrix3.h"
#include "Matrix4.h"
#include "AffineTransformation.h"
#include "Scaling.h"
#include "Rotation.h"
#include "Quaternion.h"
#include "Box2.h"
#include "Box3.h"
#include "Ray.h"
#include "Plane.h"
#include "SymmetricTensor.h"


