from typing import Any, List, Sequence, Tuple

from _typeshed import Incomplete

from .callables import UserListener
from .listener import IListenerExcHandler
from .notificationmgr import INotificationHandler
from .topicargspec import ArgSpecGiven
from .topicdefnprovider import ITopicDefnProvider
from .topicexc import TopicDefnError as TopicDefnError
from .topicexc import TopicNameError as TopicNameError
from .topicobj import Topic
from .topicutils import ALL_TOPICS as ALL_TOPICS

class TreeConfig:
    notificationMgr: Incomplete
    listenerExcHandler: Incomplete
    raiseOnTopicUnspecified: bool
    def __init__(
        self,
        notificationHandler: INotificationHandler = ...,
        listenerExcHandler: IListenerExcHandler = ...,
    ) -> None: ...

class TopicManager:
    TOPIC_SPEC_NOT_SPECIFIED: int
    TOPIC_SPEC_ALREADY_CREATED: int
    TOPIC_SPEC_ALREADY_DEFINED: int
    def __init__(self, treeConfig: TreeConfig = ...) -> None: ...
    def getRootAllTopics(self) -> Topic: ...
    def addDefnProvider(
        self, providerOrSource: Any, format: Incomplete | None = ...
    ) -> ITopicDefnProvider: ...
    def clearDefnProviders(self) -> None: ...
    def getNumDefnProviders(self) -> int: ...
    def getTopic(self, name: str, okIfNone: bool = ...) -> Topic: ...
    def getOrCreateTopic(
        self, name: str, protoListener: UserListener = ...
    ) -> Topic: ...
    def isTopicInUse(self, name: str) -> bool: ...
    def hasTopicDefinition(self, name: str) -> bool: ...
    def checkAllTopicsHaveMDS(self) -> None: ...
    def delTopic(self, name: str) -> bool: ...
    def getTopicsSubscribed(self, listener: UserListener) -> List[Topic]: ...
    def clearTree(self) -> None: ...

class _MasterTopicDefnProvider:
    def __init__(self, treeConfig: TreeConfig) -> None: ...
    def addProvider(self, provider: ITopicDefnProvider) -> None: ...
    def clear(self) -> None: ...
    def getNumProviders(self) -> int: ...
    def getDefn(self, topicNameTuple: Sequence[str]) -> Tuple[str, ArgSpecGiven]: ...
    def isDefined(self, topicNameTuple: Sequence[str]) -> bool: ...
