// SPDX-License-Identifier: Apache-2.0
// Copyright (C) 2024-2025 Advanced Micro Devices, Inc. All rights reserved

#include "xdp/profile/writer/aie_debug/aie_debug_writer_metadata.h"

namespace xdp {

/*************************************************************************************
 * AIE2PS Registers
 *************************************************************************************/
void AIE2PSWriterUsedRegisters::populateRegDataMap() {
   regDataMap["cm_accumulator_control"].push_back(RegData("Input", "0", 0, 0x1));
   regDataMap["cm_accumulator_control"].push_back(RegData("Output", "1", 1, 0x1));
   regDataMap["cm_cssd_trigger"].push_back(RegData("Trigger", "0", 0, 0x1));
   regDataMap["cm_combo_event_control"].push_back(RegData("combo2", "17:16", 16, 0x3));
   regDataMap["cm_combo_event_control"].push_back(RegData("combo0", "1:0", 0, 0x3));
   regDataMap["cm_combo_event_control"].push_back(RegData("combo1", "9:8", 8, 0x3));
   regDataMap["cm_combo_event_inputs"].push_back(RegData("eventB", "14:8", 8, 0x7F));
   regDataMap["cm_combo_event_inputs"].push_back(RegData("eventC", "22:16", 16, 0x7F));
   regDataMap["cm_combo_event_inputs"].push_back(RegData("eventD", "30:24", 24, 0x7F));
   regDataMap["cm_combo_event_inputs"].push_back(RegData("eventA", "6:0", 0, 0x7F));
   regDataMap["cm_core_cr1"].push_back(RegData("Float_MAC_Huge_Mask", "10", 10, 0x1));
   regDataMap["cm_core_cr1"].push_back(RegData("MCD_Enable", "11", 11, 0x1));
   regDataMap["cm_core_cr1"].push_back(RegData("SCD_Enable", "12", 12, 0x1));
   regDataMap["cm_core_cr1"].push_back(RegData("Bfloat_to_Int_Zero_Mask", "18", 18, 0x1));
   regDataMap["cm_core_cr1"].push_back(RegData("Saturation_Mode", "1:0", 0, 0x3));
   regDataMap["cm_core_cr1"].push_back(RegData("Bfloat_to_Int_Invalid_Mask", "20", 20, 0x1));
   regDataMap["cm_core_cr1"].push_back(RegData("Bfloat_to_Int_Tiny_Mask", "21", 21, 0x1));
   regDataMap["cm_core_cr1"].push_back(RegData("Bfloat_to_Int_Huge_Mask", "22", 22, 0x1));
   regDataMap["cm_core_cr1"].push_back(RegData("Float_to_Bfloat_Zero_Mask", "23", 23, 0x1));
   regDataMap["cm_core_cr1"].push_back(RegData("Float_to_Bfloat_Infinity_Mask", "24", 24, 0x1));
   regDataMap["cm_core_cr1"].push_back(RegData("Float_to_Bfloat_Invalid_Mask", "25", 25, 0x1));
   regDataMap["cm_core_cr1"].push_back(RegData("Float_to_Bfloat_Tiny_Mask", "26", 26, 0x1));
   regDataMap["cm_core_cr1"].push_back(RegData("Float_to_Bfloat_Huge_Mask", "27", 27, 0x1));
   regDataMap["cm_core_cr1"].push_back(RegData("UnpackSize", "28", 28, 0x1));
   regDataMap["cm_core_cr1"].push_back(RegData("SRS_Mode", "29", 29, 0x1));
   regDataMap["cm_core_cr1"].push_back(RegData("UPS_Mode", "30", 30, 0x1));
   regDataMap["cm_core_cr1"].push_back(RegData("PackSize", "31", 31, 0x1));
   regDataMap["cm_core_cr1"].push_back(RegData("Round_Mode", "5:2", 2, 0xF));
   regDataMap["cm_core_cr1"].push_back(RegData("Float_MAC_Zero_Mask", "6", 6, 0x1));
   regDataMap["cm_core_cr1"].push_back(RegData("Float_MAC_Infinity_Mask", "7", 7, 0x1));
   regDataMap["cm_core_cr1"].push_back(RegData("Float_MAC_Invalid_Mask", "8", 8, 0x1));
   regDataMap["cm_core_cr1"].push_back(RegData("Float_MAC_Tiny_Mask", "9", 9, 0x1));
   regDataMap["cm_core_cr2"].push_back(RegData("Vadd_Sign0", "0", 0, 0x1));
   regDataMap["cm_core_cr2"].push_back(RegData("Vadd_Sign1", "1", 1, 0x1));
   regDataMap["cm_core_cr2"].push_back(RegData("BF8_Mode", "17:16", 16, 0x3));
   regDataMap["cm_core_cr2"].push_back(RegData("FP8_Mode", "19:18", 18, 0x3));
   regDataMap["cm_core_cr2"].push_back(RegData("Unpack_Sign0", "2", 2, 0x1));
   regDataMap["cm_core_cr2"].push_back(RegData("FP_Conv_Sat", "21:20", 20, 0x3));
   regDataMap["cm_core_cr2"].push_back(RegData("Unpack_Sign1", "3", 3, 0x1));
   regDataMap["cm_core_cr2"].push_back(RegData("Pack_Sign0", "4", 4, 0x1));
   regDataMap["cm_core_cr2"].push_back(RegData("Pack_Sign1", "5", 5, 0x1));
   regDataMap["cm_core_cr2"].push_back(RegData("UPS_Sign0", "6", 6, 0x1));
   regDataMap["cm_core_cr2"].push_back(RegData("UPS_Sign1", "7", 7, 0x1));
   regDataMap["cm_core_cr2"].push_back(RegData("SRS_Sign0", "8", 8, 0x1));
   regDataMap["cm_core_cr2"].push_back(RegData("SRS_Sign1", "9", 9, 0x1));
   regDataMap["cm_core_cr3"].push_back(RegData("Float_to_Fix_Zero_Mask", "0", 0, 0x1));
   regDataMap["cm_core_cr3"].push_back(RegData("Fix_to_Float_Inexact_Mask", "13", 13, 0x1));
   regDataMap["cm_core_cr3"].push_back(RegData("Nlf_Zero_Mask", "16", 16, 0x1));
   regDataMap["cm_core_cr3"].push_back(RegData("Nlf_Infinity_Mask", "17", 17, 0x1));
   regDataMap["cm_core_cr3"].push_back(RegData("Nlf_Invalid_Mask", "18", 18, 0x1));
   regDataMap["cm_core_cr3"].push_back(RegData("Nlf_Tiny_Mask", "19", 19, 0x1));
   regDataMap["cm_core_cr3"].push_back(RegData("Float_to_Fix_Invalid_Mask", "2", 2, 0x1));
   regDataMap["cm_core_cr3"].push_back(RegData("Nlf_Huge_Mask", "20", 20, 0x1));
   regDataMap["cm_core_cr3"].push_back(RegData("Nlf_Inexact_Mask", "21", 21, 0x1));
   regDataMap["cm_core_cr3"].push_back(RegData("Nlf_Reserved1_Mask", "22", 22, 0x1));
   regDataMap["cm_core_cr3"].push_back(RegData("Nlf_Reserved2_Mask", "23", 23, 0x1));
   regDataMap["cm_core_cr3"].push_back(RegData("Float_to_Bfp_Invalid_Mask", "26", 26, 0x1));
   regDataMap["cm_core_cr3"].push_back(RegData("Float_to_Fix_Inexact_Mask", "5", 5, 0x1));
   regDataMap["cm_core_cr3"].push_back(RegData("Float_to_Fix_Huge_Mask", "6", 6, 0x1));
   regDataMap["cm_core_cr3"].push_back(RegData("Fix_to_Float_Zero_Mask", "8", 8, 0x1));
   regDataMap["cm_core_control"].push_back(RegData("Enable", "0", 0, 0x1));
   regDataMap["cm_core_control"].push_back(RegData("Reset", "1", 1, 0x1));
   regDataMap["cm_core_dc0"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_dc1"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_dc2"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_dc3"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_dc4"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_dc5"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_dc6"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_dc7"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_dj0"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_dj1"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_dj2"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_dj3"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_dj4"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_dj5"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_dj6"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_dj7"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_dn0"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_dn1"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_dn2"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_dn3"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_dn4"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_dn5"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_dn6"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_dn7"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_fc"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_lc"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_lci"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_le"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_lr"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_ls"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_m0"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_m1"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_m2"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_m3"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_m4"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_m5"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_m6"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_m7"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_p0"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_p1"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_p2"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_p3"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_p4"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_p5"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_p6"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_p7"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_pc"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_processor_bus"].push_back(RegData("Enable", "0", 0, 0x1));
   regDataMap["cm_core_processor_bus"].push_back(RegData("SLVERR_On_Access", "2", 2, 0x1));
   regDataMap["cm_core_r0"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_r1"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_r10"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_r11"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_r12"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_r13"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_r14"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_r15"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_r16"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_r17"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_r18"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_r19"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_r2"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_r20"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_r21"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_r22"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_r23"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_r24"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_r25"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_r26"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_r27"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_r28"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_r29"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_r3"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_r30"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_r31"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_r4"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_r5"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_r6"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_r7"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_r8"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_r9"].push_back(RegData("Register_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_core_reset_defeature"].push_back(RegData("Core_Reset_Defeature", "0", 0, 0x1));
   regDataMap["cm_core_s0"].push_back(RegData("Register_Value", "5:0", 0, 0x3F));
   regDataMap["cm_core_s1"].push_back(RegData("Register_Value", "5:0", 0, 0x3F));
   regDataMap["cm_core_s2"].push_back(RegData("Register_Value", "5:0", 0, 0x3F));
   regDataMap["cm_core_s3"].push_back(RegData("Register_Value", "5:0", 0, 0x3F));
   regDataMap["cm_core_sp"].push_back(RegData("Register_Value", "19:0", 0, 0xFFFFF));
   regDataMap["cm_core_sr1"].push_back(RegData("Carry", "0", 0, 0x1));
   regDataMap["cm_core_sr1"].push_back(RegData("SS0_Success", "1", 1, 0x1));
   regDataMap["cm_core_sr1"].push_back(RegData("Float_MAC_Tiny_Flag", "10", 10, 0x1));
   regDataMap["cm_core_sr1"].push_back(RegData("Float_MAC_Huge_Flag", "11", 11, 0x1));
   regDataMap["cm_core_sr1"].push_back(RegData("Bfloat_to_Int_Zero_Flag", "12", 12, 0x1));
   regDataMap["cm_core_sr1"].push_back(RegData("Bfloat_to_Int_Invalid_Flag", "14", 14, 0x1));
   regDataMap["cm_core_sr1"].push_back(RegData("Bfloat_to_Int_Tiny_Flag", "15", 15, 0x1));
   regDataMap["cm_core_sr1"].push_back(RegData("Bfloat_to_Int_Huge_Flag", "16", 16, 0x1));
   regDataMap["cm_core_sr1"].push_back(RegData("Float_to_Bfloat_Zero_Flag", "17", 17, 0x1));
   regDataMap["cm_core_sr1"].push_back(RegData("Float_to_Bfloat_Infinity_Flag", "18", 18, 0x1));
   regDataMap["cm_core_sr1"].push_back(RegData("Float_to_Bfloat_Invalid_Flag", "19", 19, 0x1));
   regDataMap["cm_core_sr1"].push_back(RegData("SS0_Tlast", "2", 2, 0x1));
   regDataMap["cm_core_sr1"].push_back(RegData("Float_to_Bfloat_Tiny_Flag", "20", 20, 0x1));
   regDataMap["cm_core_sr1"].push_back(RegData("Float_to_Bfloat_Huge_Flag", "21", 21, 0x1));
   regDataMap["cm_core_sr1"].push_back(RegData("Sparse_Overflow", "22", 22, 0x1));
   regDataMap["cm_core_sr1"].push_back(RegData("Fifo_Overflow", "23", 23, 0x1));
   regDataMap["cm_core_sr1"].push_back(RegData("Fifo_Underflow", "24", 24, 0x1));
   regDataMap["cm_core_sr1"].push_back(RegData("Float_to_Bfp_Invalid_Flag", "27", 27, 0x1));
   regDataMap["cm_core_sr1"].push_back(RegData("MS0_Success", "3", 3, 0x1));
   regDataMap["cm_core_sr1"].push_back(RegData("SRS_Overflow", "4", 4, 0x1));
   regDataMap["cm_core_sr1"].push_back(RegData("UPS_Overflow", "5", 5, 0x1));
   regDataMap["cm_core_sr1"].push_back(RegData("Float_MAC_Zero_Flag", "7", 7, 0x1));
   regDataMap["cm_core_sr1"].push_back(RegData("Float_MAC_Infinity_Flag", "8", 8, 0x1));
   regDataMap["cm_core_sr1"].push_back(RegData("Float_MAC_Invalid_Flag", "9", 9, 0x1));
   regDataMap["cm_core_sr2"].push_back(RegData("Float_to_Fix_Zero_Flag", "0", 0, 0x1));
   regDataMap["cm_core_sr2"].push_back(RegData("Fix_to_Float_Inexact_Flag", "13", 13, 0x1));
   regDataMap["cm_core_sr2"].push_back(RegData("Nlf_Zero_Flag", "16", 16, 0x1));
   regDataMap["cm_core_sr2"].push_back(RegData("Nlf_Infinity_Flag", "17", 17, 0x1));
   regDataMap["cm_core_sr2"].push_back(RegData("Nlf_Invalid_Flag", "18", 18, 0x1));
   regDataMap["cm_core_sr2"].push_back(RegData("Nlf_Tiny_Flag", "19", 19, 0x1));
   regDataMap["cm_core_sr2"].push_back(RegData("Float_to_Fix_Invalid_Flag", "2", 2, 0x1));
   regDataMap["cm_core_sr2"].push_back(RegData("Nlf_Huge_Flag", "20", 20, 0x1));
   regDataMap["cm_core_sr2"].push_back(RegData("Nlf_Inexact_Flag", "21", 21, 0x1));
   regDataMap["cm_core_sr2"].push_back(RegData("Nlf_Reserved1_Flag", "22", 22, 0x1));
   regDataMap["cm_core_sr2"].push_back(RegData("Nlf_Reserved2_Flag", "23", 23, 0x1));
   regDataMap["cm_core_sr2"].push_back(RegData("Float_to_Fix_Inexact_Flag", "5", 5, 0x1));
   regDataMap["cm_core_sr2"].push_back(RegData("Float_to_Fix_Huge_Flag", "6", 6, 0x1));
   regDataMap["cm_core_sr2"].push_back(RegData("Fix_to_Float_Zero_Flag", "8", 8, 0x1));
   regDataMap["cm_core_status"].push_back(RegData("Enable", "0", 0, 0x1));
   regDataMap["cm_core_status"].push_back(RegData("Reset", "1", 1, 0x1));
   regDataMap["cm_core_status"].push_back(RegData("Stream_Stall_SS0", "10", 10, 0x1));
   regDataMap["cm_core_status"].push_back(RegData("Stream_Stall_MS0", "12", 12, 0x1));
   regDataMap["cm_core_status"].push_back(RegData("Cascade_Stall_SCD", "14", 14, 0x1));
   regDataMap["cm_core_status"].push_back(RegData("Cascade_Stall_MCD", "15", 15, 0x1));
   regDataMap["cm_core_status"].push_back(RegData("Debug_Halt", "16", 16, 0x1));
   regDataMap["cm_core_status"].push_back(RegData("ECC_Error_Stall", "17", 17, 0x1));
   regDataMap["cm_core_status"].push_back(RegData("ECC_Scrubbing_Stall", "18", 18, 0x1));
   regDataMap["cm_core_status"].push_back(RegData("Error_Halt", "19", 19, 0x1));
   regDataMap["cm_core_status"].push_back(RegData("Memory_Stall_S", "2", 2, 0x1));
   regDataMap["cm_core_status"].push_back(RegData("Core_Done", "20", 20, 0x1));
   regDataMap["cm_core_status"].push_back(RegData("Core_Processor_Bus_Stall", "21", 21, 0x1));
   regDataMap["cm_core_status"].push_back(RegData("Memory_Stall_W", "3", 3, 0x1));
   regDataMap["cm_core_status"].push_back(RegData("Memory_Stall_N", "4", 4, 0x1));
   regDataMap["cm_core_status"].push_back(RegData("Memory_Stall_E", "5", 5, 0x1));
   regDataMap["cm_core_status"].push_back(RegData("Lock_Stall_S", "6", 6, 0x1));
   regDataMap["cm_core_status"].push_back(RegData("Lock_Stall_W", "7", 7, 0x1));
   regDataMap["cm_core_status"].push_back(RegData("Lock_Stall_N", "8", 8, 0x1));
   regDataMap["cm_core_status"].push_back(RegData("Lock_Stall_E", "9", 9, 0x1));
   regDataMap["cm_debug_control0"].push_back(RegData("Debug_Halt_Bit", "0", 0, 0x1));
   regDataMap["cm_debug_control0"].push_back(RegData("Single_Step_Count", "5:2", 2, 0xF));
   regDataMap["cm_debug_control1"].push_back(RegData("Debug_SingleStep_Core_Event", "14:8", 8, 0x7F));
   regDataMap["cm_debug_control1"].push_back(RegData("Debug_Halt_Core_Event0", "22:16", 16, 0x7F));
   regDataMap["cm_debug_control1"].push_back(RegData("Debug_Halt_Core_Event1", "30:24", 24, 0x7F));
   regDataMap["cm_debug_control1"].push_back(RegData("Debug_Resume_Core_Event", "6:0", 0, 0x7F));
   regDataMap["cm_debug_control2"].push_back(RegData("PC_Event_Halt", "0", 0, 0x1));
   regDataMap["cm_debug_control2"].push_back(RegData("Memory_Stall_Halt", "1", 1, 0x1));
   regDataMap["cm_debug_control2"].push_back(RegData("Lock_Stall_Halt", "2", 2, 0x1));
   regDataMap["cm_debug_control2"].push_back(RegData("Stream_Stall_Halt", "3", 3, 0x1));
   regDataMap["cm_debug_status"].push_back(RegData("Debug_halted", "0", 0, 0x1));
   regDataMap["cm_debug_status"].push_back(RegData("PC_Event_halted", "1", 1, 0x1));
   regDataMap["cm_debug_status"].push_back(RegData("Memory_Stall_Halted", "2", 2, 0x1));
   regDataMap["cm_debug_status"].push_back(RegData("Lock_Stall_Halted", "3", 3, 0x1));
   regDataMap["cm_debug_status"].push_back(RegData("Stream_stall_Halted", "4", 4, 0x1));
   regDataMap["cm_debug_status"].push_back(RegData("Debug_Event0_Halted", "5", 5, 0x1));
   regDataMap["cm_debug_status"].push_back(RegData("Debug_Event1_Halted", "6", 6, 0x1));
   regDataMap["cm_ecc_control"].push_back(RegData("Stall_Core_Control", "0", 0, 0x1));
   regDataMap["cm_ecc_control"].push_back(RegData("Unstall_Core", "1", 1, 0x1));
   regDataMap["cm_ecc_failing_address"].push_back(RegData("ECC_Error_Detection_Address", "13:0", 0, 0x3FFF));
   regDataMap["cm_ecc_failing_address"].push_back(RegData("Access_Type", "14", 14, 0x1));
   regDataMap["cm_ecc_failing_address"].push_back(RegData("Clear_failing_address", "15", 15, 0x1));
   regDataMap["cm_ecc_scrubbing_event"].push_back(RegData("Scrubbing_Event_number", "6:0", 0, 0x7F));
   regDataMap["cm_edge_detection_event_control"].push_back(RegData("Edge_Detection_0_Trigger_Falling", "10", 10, 0x1));
   regDataMap["cm_edge_detection_event_control"].push_back(RegData("Edge_Detection_Event_1", "22:16", 16, 0x7F));
   regDataMap["cm_edge_detection_event_control"].push_back(RegData("Edge_Detection_1_Trigger_Rising", "25", 25, 0x1));
   regDataMap["cm_edge_detection_event_control"].push_back(RegData("Edge_Detection_1_Trigger_Falling", "26", 26, 0x1));
   regDataMap["cm_edge_detection_event_control"].push_back(RegData("Edge_Detection_Event_0", "6:0", 0, 0x7F));
   regDataMap["cm_edge_detection_event_control"].push_back(RegData("Edge_Detection_0_Trigger_Rising", "9", 9, 0x1));
   regDataMap["cm_enable_events"].push_back(RegData("Disable_Event", "14:8", 8, 0x7F));
   regDataMap["cm_enable_events"].push_back(RegData("Disable_Event_occurred", "15", 15, 0x1));
   regDataMap["cm_enable_events"].push_back(RegData("Enable_Event", "6:0", 0, 0x7F));
   regDataMap["cm_enable_events"].push_back(RegData("Enable_Event_occurred", "7", 7, 0x1));
   regDataMap["cm_error_halt_control"].push_back(RegData("Error_Halt", "0", 0, 0x1));
   regDataMap["cm_error_halt_event"].push_back(RegData("Error_Halt_Core_Event", "6:0", 0, 0x7F));
   regDataMap["cm_event_broadcast0"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["cm_event_broadcast1"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["cm_event_broadcast10"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["cm_event_broadcast11"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["cm_event_broadcast12"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["cm_event_broadcast13"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["cm_event_broadcast14"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["cm_event_broadcast15"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["cm_event_broadcast2"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["cm_event_broadcast3"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["cm_event_broadcast4"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["cm_event_broadcast5"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["cm_event_broadcast6"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["cm_event_broadcast7"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["cm_event_broadcast8"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["cm_event_broadcast9"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["cm_event_broadcast_block_east_clr"].push_back(RegData("Clear", "15:0", 0, 0xFFFF));
   regDataMap["cm_event_broadcast_block_east_set"].push_back(RegData("Set", "15:0", 0, 0xFFFF));
   regDataMap["cm_event_broadcast_block_east_value"].push_back(RegData("Value", "15:0", 0, 0xFFFF));
   regDataMap["cm_event_broadcast_block_north_clr"].push_back(RegData("Clear", "15:0", 0, 0xFFFF));
   regDataMap["cm_event_broadcast_block_north_set"].push_back(RegData("Set", "15:0", 0, 0xFFFF));
   regDataMap["cm_event_broadcast_block_north_value"].push_back(RegData("Value", "15:0", 0, 0xFFFF));
   regDataMap["cm_event_broadcast_block_south_clr"].push_back(RegData("Clear", "15:0", 0, 0xFFFF));
   regDataMap["cm_event_broadcast_block_south_set"].push_back(RegData("Set", "15:0", 0, 0xFFFF));
   regDataMap["cm_event_broadcast_block_south_value"].push_back(RegData("Value", "15:0", 0, 0xFFFF));
   regDataMap["cm_event_broadcast_block_west_clr"].push_back(RegData("Clear", "15:0", 0, 0xFFFF));
   regDataMap["cm_event_broadcast_block_west_set"].push_back(RegData("Set", "15:0", 0, 0xFFFF));
   regDataMap["cm_event_broadcast_block_west_value"].push_back(RegData("Value", "15:0", 0, 0xFFFF));
   regDataMap["cm_event_generate"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["cm_event_group_0_enable"].push_back(RegData("Timer_Sync", "0", 0, 0x1));
   regDataMap["cm_event_group_0_enable"].push_back(RegData("Timer_Value_Reached", "1", 1, 0x1));
   regDataMap["cm_event_group_0_enable"].push_back(RegData("Edge_Detection_Event_0", "10", 10, 0x1));
   regDataMap["cm_event_group_0_enable"].push_back(RegData("Edge_Detection_Event_1", "11", 11, 0x1));
   regDataMap["cm_event_group_0_enable"].push_back(RegData("Perf_Cnt0", "2", 2, 0x1));
   regDataMap["cm_event_group_0_enable"].push_back(RegData("Perf_Cnt1", "3", 3, 0x1));
   regDataMap["cm_event_group_0_enable"].push_back(RegData("Perf_Cnt2", "4", 4, 0x1));
   regDataMap["cm_event_group_0_enable"].push_back(RegData("Perf_Cnt3", "5", 5, 0x1));
   regDataMap["cm_event_group_0_enable"].push_back(RegData("Combo_Event_0", "6", 6, 0x1));
   regDataMap["cm_event_group_0_enable"].push_back(RegData("Combo_Event_1", "7", 7, 0x1));
   regDataMap["cm_event_group_0_enable"].push_back(RegData("Combo_Event_2", "8", 8, 0x1));
   regDataMap["cm_event_group_0_enable"].push_back(RegData("Combo_Event_3", "9", 9, 0x1));
   regDataMap["cm_event_group_broadcast_enable"].push_back(RegData("Broadcast_0", "0", 0, 0x1));
   regDataMap["cm_event_group_broadcast_enable"].push_back(RegData("Broadcast_1", "1", 1, 0x1));
   regDataMap["cm_event_group_broadcast_enable"].push_back(RegData("Broadcast_10", "10", 10, 0x1));
   regDataMap["cm_event_group_broadcast_enable"].push_back(RegData("Broadcast_11", "11", 11, 0x1));
   regDataMap["cm_event_group_broadcast_enable"].push_back(RegData("Broadcast_12", "12", 12, 0x1));
   regDataMap["cm_event_group_broadcast_enable"].push_back(RegData("Broadcast_13", "13", 13, 0x1));
   regDataMap["cm_event_group_broadcast_enable"].push_back(RegData("Broadcast_14", "14", 14, 0x1));
   regDataMap["cm_event_group_broadcast_enable"].push_back(RegData("Broadcast_15", "15", 15, 0x1));
   regDataMap["cm_event_group_broadcast_enable"].push_back(RegData("Broadcast_2", "2", 2, 0x1));
   regDataMap["cm_event_group_broadcast_enable"].push_back(RegData("Broadcast_3", "3", 3, 0x1));
   regDataMap["cm_event_group_broadcast_enable"].push_back(RegData("Broadcast_4", "4", 4, 0x1));
   regDataMap["cm_event_group_broadcast_enable"].push_back(RegData("Broadcast_5", "5", 5, 0x1));
   regDataMap["cm_event_group_broadcast_enable"].push_back(RegData("Broadcast_6", "6", 6, 0x1));
   regDataMap["cm_event_group_broadcast_enable"].push_back(RegData("Broadcast_7", "7", 7, 0x1));
   regDataMap["cm_event_group_broadcast_enable"].push_back(RegData("Broadcast_8", "8", 8, 0x1));
   regDataMap["cm_event_group_broadcast_enable"].push_back(RegData("Broadcast_9", "9", 9, 0x1));
   regDataMap["cm_event_group_core_program_flow_enable"].push_back(RegData("Instr_Event_0", "0", 0, 0x1));
   regDataMap["cm_event_group_core_program_flow_enable"].push_back(RegData("Instr_Event_1", "1", 1, 0x1));
   regDataMap["cm_event_group_core_program_flow_enable"].push_back(RegData("Instr_Cascade_Put", "10", 10, 0x1));
   regDataMap["cm_event_group_core_program_flow_enable"].push_back(RegData("Instr_Lock_Acquire_req", "11", 11, 0x1));
   regDataMap["cm_event_group_core_program_flow_enable"].push_back(RegData("Instr_Lock_Release_req", "12", 12, 0x1));
   regDataMap["cm_event_group_core_program_flow_enable"].push_back(RegData("Instr_Call", "2", 2, 0x1));
   regDataMap["cm_event_group_core_program_flow_enable"].push_back(RegData("Instr_Return", "3", 3, 0x1));
   regDataMap["cm_event_group_core_program_flow_enable"].push_back(RegData("Instr_Vector", "4", 4, 0x1));
   regDataMap["cm_event_group_core_program_flow_enable"].push_back(RegData("Instr_Load", "5", 5, 0x1));
   regDataMap["cm_event_group_core_program_flow_enable"].push_back(RegData("Instr_Store", "6", 6, 0x1));
   regDataMap["cm_event_group_core_program_flow_enable"].push_back(RegData("Instr_Stream_Get", "7", 7, 0x1));
   regDataMap["cm_event_group_core_program_flow_enable"].push_back(RegData("Instr_Stream_Put", "8", 8, 0x1));
   regDataMap["cm_event_group_core_program_flow_enable"].push_back(RegData("Instr_Cascade_Get", "9", 9, 0x1));
   regDataMap["cm_event_group_core_stall_enable"].push_back(RegData("Memory_Stall", "0", 0, 0x1));
   regDataMap["cm_event_group_core_stall_enable"].push_back(RegData("Stream_Stall", "1", 1, 0x1));
   regDataMap["cm_event_group_core_stall_enable"].push_back(RegData("Cascade_Stall", "2", 2, 0x1));
   regDataMap["cm_event_group_core_stall_enable"].push_back(RegData("Lock_Stall", "3", 3, 0x1));
   regDataMap["cm_event_group_core_stall_enable"].push_back(RegData("Debug", "4", 4, 0x1));
   regDataMap["cm_event_group_core_stall_enable"].push_back(RegData("Active", "5", 5, 0x1));
   regDataMap["cm_event_group_core_stall_enable"].push_back(RegData("Disable", "6", 6, 0x1));
   regDataMap["cm_event_group_core_stall_enable"].push_back(RegData("ECC_Scrubbing_Stall", "7", 7, 0x1));
   regDataMap["cm_event_group_core_stall_enable"].push_back(RegData("ECC_Error_Stall", "8", 8, 0x1));
   regDataMap["cm_event_group_errors0_enable"].push_back(RegData("SRS_Overflow", "0", 0, 0x1));
   regDataMap["cm_event_group_errors0_enable"].push_back(RegData("UPS_Overflow", "1", 1, 0x1));
   regDataMap["cm_event_group_errors0_enable"].push_back(RegData("AXI_MM_Slave_Error", "10", 10, 0x1));
   regDataMap["cm_event_group_errors0_enable"].push_back(RegData("Instruction_Decompression_Error", "11", 11, 0x1));
   regDataMap["cm_event_group_errors0_enable"].push_back(RegData("DM_address_out_of_range", "12", 12, 0x1));
   regDataMap["cm_event_group_errors0_enable"].push_back(RegData("PM_ECC_Error_Scrub_Corrected", "13", 13, 0x1));
   regDataMap["cm_event_group_errors0_enable"].push_back(RegData("PM_ECC_Error_Scrub_2bit", "14", 14, 0x1));
   regDataMap["cm_event_group_errors0_enable"].push_back(RegData("PM_ECC_Error_1bit", "15", 15, 0x1));
   regDataMap["cm_event_group_errors0_enable"].push_back(RegData("PM_ECC_Error_2bit", "16", 16, 0x1));
   regDataMap["cm_event_group_errors0_enable"].push_back(RegData("PM_address_out_of_range", "17", 17, 0x1));
   regDataMap["cm_event_group_errors0_enable"].push_back(RegData("DM_access_to_Unavailable", "18", 18, 0x1));
   regDataMap["cm_event_group_errors0_enable"].push_back(RegData("Lock_Access_to_Unavailable", "19", 19, 0x1));
   regDataMap["cm_event_group_errors0_enable"].push_back(RegData("FP_Huge", "2", 2, 0x1));
   regDataMap["cm_event_group_errors0_enable"].push_back(RegData("Instr_Warning", "20", 20, 0x1));
   regDataMap["cm_event_group_errors0_enable"].push_back(RegData("Instr_Error", "21", 21, 0x1));
   regDataMap["cm_event_group_errors0_enable"].push_back(RegData("Sparsity_Overflow", "22", 22, 0x1));
   regDataMap["cm_event_group_errors0_enable"].push_back(RegData("Stream_Switch_Port_Parity_Error", "23", 23, 0x1));
   regDataMap["cm_event_group_errors0_enable"].push_back(RegData("Processor_Bus_Error", "24", 24, 0x1));
   regDataMap["cm_event_group_errors0_enable"].push_back(RegData("Int_FP_Zero", "3", 3, 0x1));
   regDataMap["cm_event_group_errors0_enable"].push_back(RegData("FP_Invalid", "4", 4, 0x1));
   regDataMap["cm_event_group_errors0_enable"].push_back(RegData("FP_INF", "5", 5, 0x1));
   regDataMap["cm_event_group_errors0_enable"].push_back(RegData("reserved0", "6", 6, 0x1));
   regDataMap["cm_event_group_errors0_enable"].push_back(RegData("PM_Reg_Access_Failure", "7", 7, 0x1));
   regDataMap["cm_event_group_errors0_enable"].push_back(RegData("Stream_Pkt_Parity_Error", "8", 8, 0x1));
   regDataMap["cm_event_group_errors0_enable"].push_back(RegData("Control_Pkt_Error", "9", 9, 0x1));
   regDataMap["cm_event_group_errors1_enable"].push_back(RegData("SRS_Overflow", "0", 0, 0x1));
   regDataMap["cm_event_group_errors1_enable"].push_back(RegData("UPS_Overflow", "1", 1, 0x1));
   regDataMap["cm_event_group_errors1_enable"].push_back(RegData("AXI_MM_Slave_Error", "10", 10, 0x1));
   regDataMap["cm_event_group_errors1_enable"].push_back(RegData("Instruction_Decompression_Error", "11", 11, 0x1));
   regDataMap["cm_event_group_errors1_enable"].push_back(RegData("DM_address_out_of_range", "12", 12, 0x1));
   regDataMap["cm_event_group_errors1_enable"].push_back(RegData("PM_ECC_Error_Scrub_Corrected", "13", 13, 0x1));
   regDataMap["cm_event_group_errors1_enable"].push_back(RegData("PM_ECC_Error_Scrub_2bit", "14", 14, 0x1));
   regDataMap["cm_event_group_errors1_enable"].push_back(RegData("PM_ECC_Error_1bit", "15", 15, 0x1));
   regDataMap["cm_event_group_errors1_enable"].push_back(RegData("PM_ECC_Error_2bit", "16", 16, 0x1));
   regDataMap["cm_event_group_errors1_enable"].push_back(RegData("PM_address_out_of_range", "17", 17, 0x1));
   regDataMap["cm_event_group_errors1_enable"].push_back(RegData("DM_access_to_Unavailable", "18", 18, 0x1));
   regDataMap["cm_event_group_errors1_enable"].push_back(RegData("Lock_Access_to_Unavailable", "19", 19, 0x1));
   regDataMap["cm_event_group_errors1_enable"].push_back(RegData("FP_Huge", "2", 2, 0x1));
   regDataMap["cm_event_group_errors1_enable"].push_back(RegData("Instr_Warning", "20", 20, 0x1));
   regDataMap["cm_event_group_errors1_enable"].push_back(RegData("Instr_Error", "21", 21, 0x1));
   regDataMap["cm_event_group_errors1_enable"].push_back(RegData("Decompression_underflow", "22", 22, 0x1));
   regDataMap["cm_event_group_errors1_enable"].push_back(RegData("Stream_Switch_Port_Parity_Error", "23", 23, 0x1));
   regDataMap["cm_event_group_errors1_enable"].push_back(RegData("Processor_Bus_Error", "24", 24, 0x1));
   regDataMap["cm_event_group_errors1_enable"].push_back(RegData("Int_FP_Zero", "3", 3, 0x1));
   regDataMap["cm_event_group_errors1_enable"].push_back(RegData("FP_Invalid", "4", 4, 0x1));
   regDataMap["cm_event_group_errors1_enable"].push_back(RegData("FP_INF", "5", 5, 0x1));
   regDataMap["cm_event_group_errors1_enable"].push_back(RegData("reserved0", "6", 6, 0x1));
   regDataMap["cm_event_group_errors1_enable"].push_back(RegData("PM_Reg_Access_Failure", "7", 7, 0x1));
   regDataMap["cm_event_group_errors1_enable"].push_back(RegData("Stream_Pkt_Parity_Error", "8", 8, 0x1));
   regDataMap["cm_event_group_errors1_enable"].push_back(RegData("Control_Pkt_Error", "9", 9, 0x1));
   regDataMap["cm_event_group_pc_enable"].push_back(RegData("PC_0", "0", 0, 0x1));
   regDataMap["cm_event_group_pc_enable"].push_back(RegData("PC_1", "1", 1, 0x1));
   regDataMap["cm_event_group_pc_enable"].push_back(RegData("PC_2", "2", 2, 0x1));
   regDataMap["cm_event_group_pc_enable"].push_back(RegData("PC_3", "3", 3, 0x1));
   regDataMap["cm_event_group_pc_enable"].push_back(RegData("PC_Range_0_1", "4", 4, 0x1));
   regDataMap["cm_event_group_pc_enable"].push_back(RegData("PC_Range_2_3", "5", 5, 0x1));
   regDataMap["cm_event_group_stream_switch_enable"].push_back(RegData("Port_Idle_0", "0", 0, 0x1));
   regDataMap["cm_event_group_stream_switch_enable"].push_back(RegData("Port_Running_0", "1", 1, 0x1));
   regDataMap["cm_event_group_stream_switch_enable"].push_back(RegData("Port_Stalled_2", "10", 10, 0x1));
   regDataMap["cm_event_group_stream_switch_enable"].push_back(RegData("Port_TLAST_2", "11", 11, 0x1));
   regDataMap["cm_event_group_stream_switch_enable"].push_back(RegData("Port_Idle_3", "12", 12, 0x1));
   regDataMap["cm_event_group_stream_switch_enable"].push_back(RegData("Port_Running_3", "13", 13, 0x1));
   regDataMap["cm_event_group_stream_switch_enable"].push_back(RegData("Port_Stalled_3", "14", 14, 0x1));
   regDataMap["cm_event_group_stream_switch_enable"].push_back(RegData("Port_TLAST_3", "15", 15, 0x1));
   regDataMap["cm_event_group_stream_switch_enable"].push_back(RegData("Port_Idle_4", "16", 16, 0x1));
   regDataMap["cm_event_group_stream_switch_enable"].push_back(RegData("Port_Running_4", "17", 17, 0x1));
   regDataMap["cm_event_group_stream_switch_enable"].push_back(RegData("Port_Stalled_4", "18", 18, 0x1));
   regDataMap["cm_event_group_stream_switch_enable"].push_back(RegData("Port_TLAST_4", "19", 19, 0x1));
   regDataMap["cm_event_group_stream_switch_enable"].push_back(RegData("Port_Stalled_0", "2", 2, 0x1));
   regDataMap["cm_event_group_stream_switch_enable"].push_back(RegData("Port_Idle_5", "20", 20, 0x1));
   regDataMap["cm_event_group_stream_switch_enable"].push_back(RegData("Port_Running_5", "21", 21, 0x1));
   regDataMap["cm_event_group_stream_switch_enable"].push_back(RegData("Port_Stalled_5", "22", 22, 0x1));
   regDataMap["cm_event_group_stream_switch_enable"].push_back(RegData("Port_TLAST_5", "23", 23, 0x1));
   regDataMap["cm_event_group_stream_switch_enable"].push_back(RegData("Port_Idle_6", "24", 24, 0x1));
   regDataMap["cm_event_group_stream_switch_enable"].push_back(RegData("Port_Running_6", "25", 25, 0x1));
   regDataMap["cm_event_group_stream_switch_enable"].push_back(RegData("Port_Stalled_6", "26", 26, 0x1));
   regDataMap["cm_event_group_stream_switch_enable"].push_back(RegData("Port_TLAST_6", "27", 27, 0x1));
   regDataMap["cm_event_group_stream_switch_enable"].push_back(RegData("Port_Idle_7", "28", 28, 0x1));
   regDataMap["cm_event_group_stream_switch_enable"].push_back(RegData("Port_Running_7", "29", 29, 0x1));
   regDataMap["cm_event_group_stream_switch_enable"].push_back(RegData("Port_TLAST_0", "3", 3, 0x1));
   regDataMap["cm_event_group_stream_switch_enable"].push_back(RegData("Port_Stalled_7", "30", 30, 0x1));
   regDataMap["cm_event_group_stream_switch_enable"].push_back(RegData("Port_TLAST_7", "31", 31, 0x1));
   regDataMap["cm_event_group_stream_switch_enable"].push_back(RegData("Port_Idle_1", "4", 4, 0x1));
   regDataMap["cm_event_group_stream_switch_enable"].push_back(RegData("Port_Running_1", "5", 5, 0x1));
   regDataMap["cm_event_group_stream_switch_enable"].push_back(RegData("Port_Stalled_1", "6", 6, 0x1));
   regDataMap["cm_event_group_stream_switch_enable"].push_back(RegData("Port_TLAST_1", "7", 7, 0x1));
   regDataMap["cm_event_group_stream_switch_enable"].push_back(RegData("Port_Idle_2", "8", 8, 0x1));
   regDataMap["cm_event_group_stream_switch_enable"].push_back(RegData("Port_Running_2", "9", 9, 0x1));
   regDataMap["cm_event_group_user_event_enable"].push_back(RegData("User_Event_0", "0", 0, 0x1));
   regDataMap["cm_event_group_user_event_enable"].push_back(RegData("User_Event_1", "1", 1, 0x1));
   regDataMap["cm_event_group_user_event_enable"].push_back(RegData("User_Event_2", "2", 2, 0x1));
   regDataMap["cm_event_group_user_event_enable"].push_back(RegData("User_Event_3", "3", 3, 0x1));
   regDataMap["cm_event_status0"].push_back(RegData("Event_31_0_Status", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_event_status1"].push_back(RegData("Event_63_32_Status", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_event_status2"].push_back(RegData("Event_95_64_Status", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_event_status3"].push_back(RegData("Event_127_96_Status", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_memory_control"].push_back(RegData("Memory_Zeroisation", "0", 0, 0x1));
   regDataMap["cm_module_clock_control"].push_back(RegData("Stream_Switch_Clock_Enable", "0", 0, 0x1));
   regDataMap["cm_module_clock_control"].push_back(RegData("Memory_Module_Clock_Enable", "1", 1, 0x1));
   regDataMap["cm_module_clock_control"].push_back(RegData("Core_Module_Clock_Enable", "2", 2, 0x1));
   regDataMap["cm_module_clock_control"].push_back(RegData("Ctrl_Pkt_Tlast_Error_Enable", "4", 4, 0x1));
   regDataMap["cm_module_clock_control"].push_back(RegData("DMA_Adaptive_Clock_Gate", "5", 5, 0x1));
   regDataMap["cm_module_reset_control"].push_back(RegData("Stream_Switch_Reset", "0", 0, 0x1));
   regDataMap["cm_module_reset_control"].push_back(RegData("Memory_Module_Reset", "1", 1, 0x1));
   regDataMap["cm_module_reset_control"].push_back(RegData("Core_Module_Reset", "2", 2, 0x1));
   regDataMap["cm_pc_event0"].push_back(RegData("PC_Address", "13:0", 0, 0x3FFF));
   regDataMap["cm_pc_event0"].push_back(RegData("Valid", "31", 31, 0x1));
   regDataMap["cm_pc_event1"].push_back(RegData("PC_Address", "13:0", 0, 0x3FFF));
   regDataMap["cm_pc_event1"].push_back(RegData("Valid", "31", 31, 0x1));
   regDataMap["cm_pc_event2"].push_back(RegData("PC_Address", "13:0", 0, 0x3FFF));
   regDataMap["cm_pc_event2"].push_back(RegData("Valid", "31", 31, 0x1));
   regDataMap["cm_pc_event3"].push_back(RegData("PC_Address", "13:0", 0, 0x3FFF));
   regDataMap["cm_pc_event3"].push_back(RegData("Valid", "31", 31, 0x1));
   regDataMap["cm_performance_control0"].push_back(RegData("Cnt0_Stop_Event", "14:8", 8, 0x7F));
   regDataMap["cm_performance_control0"].push_back(RegData("Cnt1_Start_Event", "22:16", 16, 0x7F));
   regDataMap["cm_performance_control0"].push_back(RegData("Cnt1_Stop_Event", "30:24", 24, 0x7F));
   regDataMap["cm_performance_control0"].push_back(RegData("Cnt0_Start_Event", "6:0", 0, 0x7F));
   regDataMap["cm_performance_control1"].push_back(RegData("Cnt2_Stop_Event", "14:8", 8, 0x7F));
   regDataMap["cm_performance_control1"].push_back(RegData("Cnt3_Start_Event", "22:16", 16, 0x7F));
   regDataMap["cm_performance_control1"].push_back(RegData("Cnt3_Stop_Event", "30:24", 24, 0x7F));
   regDataMap["cm_performance_control1"].push_back(RegData("Cnt2_Start_Event", "6:0", 0, 0x7F));
   regDataMap["cm_performance_control2"].push_back(RegData("Cnt1_Reset_Event", "14:8", 8, 0x7F));
   regDataMap["cm_performance_control2"].push_back(RegData("Cnt2_Reset_Event", "22:16", 16, 0x7F));
   regDataMap["cm_performance_control2"].push_back(RegData("Cnt3_Reset_Event", "30:24", 24, 0x7F));
   regDataMap["cm_performance_control2"].push_back(RegData("Cnt0_Reset_Event", "6:0", 0, 0x7F));
   regDataMap["cm_performance_counter0"].push_back(RegData("Counter0_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_performance_counter0_event_value"].push_back(RegData("Counter_Event_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_performance_counter1"].push_back(RegData("Counter0_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_performance_counter1_event_value"].push_back(RegData("Counter_Event_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_performance_counter2"].push_back(RegData("Counter0_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_performance_counter2_event_value"].push_back(RegData("Counter_Event_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_performance_counter3"].push_back(RegData("Counter0_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_performance_counter3_event_value"].push_back(RegData("Counter_Event_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_reset_event"].push_back(RegData("Reset_Event", "6:0", 0, 0x7F));
   regDataMap["cm_spare_reg"].push_back(RegData("Spare_Reg", "15:0", 0, 0xFFFF));
   regDataMap["cm_spare_reg_privileged"].push_back(RegData("Spare_Reg", "15:0", 0, 0xFFFF));
   regDataMap["cm_stream_switch_adaptive_clock_gate_abort_period"].push_back(RegData("Abort_Period", "3:0", 0, 0xF));
   regDataMap["cm_stream_switch_adaptive_clock_gate_status"].push_back(RegData("Active", "0", 0, 0x1));
   regDataMap["cm_stream_switch_deterministic_merge_arb0_ctrl"].push_back(RegData("Enable", "0", 0, 0x1));
   regDataMap["cm_stream_switch_deterministic_merge_arb0_slave0_1"].push_back(RegData("Packet_Count_0", "13:8", 8, 0x3F));
   regDataMap["cm_stream_switch_deterministic_merge_arb0_slave0_1"].push_back(RegData("Slave_ID_1", "20:16", 16, 0x1F));
   regDataMap["cm_stream_switch_deterministic_merge_arb0_slave0_1"].push_back(RegData("Packet_Count_1", "29:24", 24, 0x3F));
   regDataMap["cm_stream_switch_deterministic_merge_arb0_slave0_1"].push_back(RegData("Slave_ID_0", "4:0", 0, 0x1F));
   regDataMap["cm_stream_switch_deterministic_merge_arb0_slave2_3"].push_back(RegData("Packet_Count_2", "13:8", 8, 0x3F));
   regDataMap["cm_stream_switch_deterministic_merge_arb0_slave2_3"].push_back(RegData("Slave_ID_3", "20:16", 16, 0x1F));
   regDataMap["cm_stream_switch_deterministic_merge_arb0_slave2_3"].push_back(RegData("Packet_Count_3", "29:24", 24, 0x3F));
   regDataMap["cm_stream_switch_deterministic_merge_arb0_slave2_3"].push_back(RegData("Slave_ID_2", "4:0", 0, 0x1F));
   regDataMap["cm_stream_switch_deterministic_merge_arb1_ctrl"].push_back(RegData("Enable", "0", 0, 0x1));
   regDataMap["cm_stream_switch_deterministic_merge_arb1_slave0_1"].push_back(RegData("Packet_Count_0", "13:8", 8, 0x3F));
   regDataMap["cm_stream_switch_deterministic_merge_arb1_slave0_1"].push_back(RegData("Slave_ID_1", "20:16", 16, 0x1F));
   regDataMap["cm_stream_switch_deterministic_merge_arb1_slave0_1"].push_back(RegData("Packet_Count_1", "29:24", 24, 0x3F));
   regDataMap["cm_stream_switch_deterministic_merge_arb1_slave0_1"].push_back(RegData("Slave_ID_0", "4:0", 0, 0x1F));
   regDataMap["cm_stream_switch_deterministic_merge_arb1_slave2_3"].push_back(RegData("Packet_Count_2", "13:8", 8, 0x3F));
   regDataMap["cm_stream_switch_deterministic_merge_arb1_slave2_3"].push_back(RegData("Slave_ID_3", "20:16", 16, 0x1F));
   regDataMap["cm_stream_switch_deterministic_merge_arb1_slave2_3"].push_back(RegData("Packet_Count_3", "29:24", 24, 0x3F));
   regDataMap["cm_stream_switch_deterministic_merge_arb1_slave2_3"].push_back(RegData("Slave_ID_2", "4:0", 0, 0x1F));
   regDataMap["cm_stream_switch_event_port_selection_0"].push_back(RegData("Port_1_ID", "12:8", 8, 0x1F));
   regDataMap["cm_stream_switch_event_port_selection_0"].push_back(RegData("Port_1_Master_Slave", "13", 13, 0x1));
   regDataMap["cm_stream_switch_event_port_selection_0"].push_back(RegData("Port_2_ID", "20:16", 16, 0x1F));
   regDataMap["cm_stream_switch_event_port_selection_0"].push_back(RegData("Port_2_Master_Slave", "21", 21, 0x1));
   regDataMap["cm_stream_switch_event_port_selection_0"].push_back(RegData("Port_3_ID", "28:24", 24, 0x1F));
   regDataMap["cm_stream_switch_event_port_selection_0"].push_back(RegData("Port_3_Master_Slave", "29", 29, 0x1));
   regDataMap["cm_stream_switch_event_port_selection_0"].push_back(RegData("Port_0_ID", "4:0", 0, 0x1F));
   regDataMap["cm_stream_switch_event_port_selection_0"].push_back(RegData("Port_0_Master_Slave", "5", 5, 0x1));
   regDataMap["cm_stream_switch_event_port_selection_1"].push_back(RegData("Port_5_ID", "12:8", 8, 0x1F));
   regDataMap["cm_stream_switch_event_port_selection_1"].push_back(RegData("Port_5_Master_Slave", "13", 13, 0x1));
   regDataMap["cm_stream_switch_event_port_selection_1"].push_back(RegData("Port_6_ID", "20:16", 16, 0x1F));
   regDataMap["cm_stream_switch_event_port_selection_1"].push_back(RegData("Port_6_Master_Slave", "21", 21, 0x1));
   regDataMap["cm_stream_switch_event_port_selection_1"].push_back(RegData("Port_7_ID", "28:24", 24, 0x1F));
   regDataMap["cm_stream_switch_event_port_selection_1"].push_back(RegData("Port_7_Master_Slave", "29", 29, 0x1));
   regDataMap["cm_stream_switch_event_port_selection_1"].push_back(RegData("Port_4_ID", "4:0", 0, 0x1F));
   regDataMap["cm_stream_switch_event_port_selection_1"].push_back(RegData("Port_4_Master_Slave", "5", 5, 0x1));
   regDataMap["cm_stream_switch_parity_injection"].push_back(RegData("Core_lower", "0", 0, 0x1));
   regDataMap["cm_stream_switch_parity_injection"].push_back(RegData("DMA_0_lower", "1", 1, 0x1));
   regDataMap["cm_stream_switch_parity_injection"].push_back(RegData("Core_upper", "16", 16, 0x1));
   regDataMap["cm_stream_switch_parity_injection"].push_back(RegData("DMA_0_upper", "17", 17, 0x1));
   regDataMap["cm_stream_switch_parity_injection"].push_back(RegData("DMA_1_upper", "18", 18, 0x1));
   regDataMap["cm_stream_switch_parity_injection"].push_back(RegData("Tile_Control_upper", "19", 19, 0x1));
   regDataMap["cm_stream_switch_parity_injection"].push_back(RegData("DMA_1_lower", "2", 2, 0x1));
   regDataMap["cm_stream_switch_parity_injection"].push_back(RegData("AIE_Trace_upper", "20", 20, 0x1));
   regDataMap["cm_stream_switch_parity_injection"].push_back(RegData("Mem_trace_upper", "21", 21, 0x1));
   regDataMap["cm_stream_switch_parity_injection"].push_back(RegData("Tile_Control_lower", "3", 3, 0x1));
   regDataMap["cm_stream_switch_parity_injection"].push_back(RegData("AIE_Trace_lower", "4", 4, 0x1));
   regDataMap["cm_stream_switch_parity_injection"].push_back(RegData("Mem_trace_lower", "5", 5, 0x1));
   regDataMap["cm_stream_switch_parity_status"].push_back(RegData("Core", "0", 0, 0x1));
   regDataMap["cm_stream_switch_parity_status"].push_back(RegData("DMA_0", "1", 1, 0x1));
   regDataMap["cm_stream_switch_parity_status"].push_back(RegData("DMA_1", "2", 2, 0x1));
   regDataMap["cm_stream_switch_parity_status"].push_back(RegData("Tile_Control", "3", 3, 0x1));
   regDataMap["cm_tile_control"].push_back(RegData("Isolate_From_South", "0", 0, 0x1));
   regDataMap["cm_tile_control"].push_back(RegData("Isolate_From_West", "1", 1, 0x1));
   regDataMap["cm_tile_control"].push_back(RegData("Isolate_From_North", "2", 2, 0x1));
   regDataMap["cm_tile_control"].push_back(RegData("Isolate_From_East", "3", 3, 0x1));
   regDataMap["cm_tile_control_packet_handler_status"].push_back(RegData("First_Header_Parity_Error", "0", 0, 0x1));
   regDataMap["cm_tile_control_packet_handler_status"].push_back(RegData("Second_Header_Parity_Error", "1", 1, 0x1));
   regDataMap["cm_tile_control_packet_handler_status"].push_back(RegData("SLVERR_On_Access", "2", 2, 0x1));
   regDataMap["cm_tile_control_packet_handler_status"].push_back(RegData("Tlast_Error", "3", 3, 0x1));
   regDataMap["cm_timer_control"].push_back(RegData("Reset_Event", "14:8", 8, 0x7F));
   regDataMap["cm_timer_control"].push_back(RegData("Reset", "31", 31, 0x1));
   regDataMap["cm_timer_high"].push_back(RegData("TimerHigh", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_timer_low"].push_back(RegData("TimerLow", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_timer_trig_event_high_value"].push_back(RegData("TimerTrigHigh", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_timer_trig_event_low_value"].push_back(RegData("TimerTrigLow", "31:0", 0, 0xFFFFFFFF));
   regDataMap["cm_trace_control0"].push_back(RegData("Mode", "1:0", 0, 0x3));
   regDataMap["cm_trace_control0"].push_back(RegData("Trace_Start_Event", "22:16", 16, 0x7F));
   regDataMap["cm_trace_control0"].push_back(RegData("Trace_Stop_Event", "30:24", 24, 0x7F));
   regDataMap["cm_trace_control1"].push_back(RegData("Packet_Type", "14:12", 12, 0x7));
   regDataMap["cm_trace_control1"].push_back(RegData("ID", "4:0", 0, 0x1F));
   regDataMap["cm_trace_event0"].push_back(RegData("Trace_Event1", "14:8", 8, 0x7F));
   regDataMap["cm_trace_event0"].push_back(RegData("Trace_Event2", "22:16", 16, 0x7F));
   regDataMap["cm_trace_event0"].push_back(RegData("Trace_Event3", "30:24", 24, 0x7F));
   regDataMap["cm_trace_event0"].push_back(RegData("Trace_Event0", "6:0", 0, 0x7F));
   regDataMap["cm_trace_event1"].push_back(RegData("Trace_Event5", "14:8", 8, 0x7F));
   regDataMap["cm_trace_event1"].push_back(RegData("Trace_Event6", "22:16", 16, 0x7F));
   regDataMap["cm_trace_event1"].push_back(RegData("Trace_Event7", "30:24", 24, 0x7F));
   regDataMap["cm_trace_event1"].push_back(RegData("Trace_Event4", "6:0", 0, 0x7F));
   regDataMap["cm_trace_status"].push_back(RegData("Mode", "2:0", 0, 0x7));
   regDataMap["cm_trace_status"].push_back(RegData("State", "9:8", 8, 0x3));
   regDataMap["mm_checkbit_error_generation"].push_back(RegData("Lane0", "0", 0, 0x1));
   regDataMap["mm_checkbit_error_generation"].push_back(RegData("Lane1", "1", 1, 0x1));
   regDataMap["mm_checkbit_error_generation"].push_back(RegData("Lane2", "2", 2, 0x1));
   regDataMap["mm_checkbit_error_generation"].push_back(RegData("Lane3", "3", 3, 0x1));
   regDataMap["mm_checkbit_error_generation"].push_back(RegData("Lane4", "4", 4, 0x1));
   regDataMap["mm_checkbit_error_generation"].push_back(RegData("Lane5", "5", 5, 0x1));
   regDataMap["mm_checkbit_error_generation"].push_back(RegData("Lane6", "6", 6, 0x1));
   regDataMap["mm_checkbit_error_generation"].push_back(RegData("Lane7", "7", 7, 0x1));
   regDataMap["mm_combo_event_control"].push_back(RegData("combo2", "17:16", 16, 0x3));
   regDataMap["mm_combo_event_control"].push_back(RegData("combo0", "1:0", 0, 0x3));
   regDataMap["mm_combo_event_control"].push_back(RegData("combo1", "9:8", 8, 0x3));
   regDataMap["mm_combo_event_inputs"].push_back(RegData("eventB", "14:8", 8, 0x7F));
   regDataMap["mm_combo_event_inputs"].push_back(RegData("eventC", "22:16", 16, 0x7F));
   regDataMap["mm_combo_event_inputs"].push_back(RegData("eventD", "30:24", 24, 0x7F));
   regDataMap["mm_combo_event_inputs"].push_back(RegData("eventA", "6:0", 0, 0x7F));
   regDataMap["mm_dma_mm2s_0_ctrl"].push_back(RegData("Reset", "1", 1, 0x1));
   regDataMap["mm_dma_mm2s_0_ctrl"].push_back(RegData("Controller_ID", "15:8", 8, 0xFF));
   regDataMap["mm_dma_mm2s_0_ctrl"].push_back(RegData("Compression_Enable", "4", 4, 0x1));
   regDataMap["mm_dma_mm2s_0_start_queue"].push_back(RegData("Repeat_Count", "23:16", 16, 0xFF));
   regDataMap["mm_dma_mm2s_0_start_queue"].push_back(RegData("Enable_Token_Issue", "31", 31, 0x1));
   regDataMap["mm_dma_mm2s_0_start_queue"].push_back(RegData("Start_BD_ID", "3:0", 0, 0xF));
   regDataMap["mm_dma_mm2s_1_ctrl"].push_back(RegData("Reset", "1", 1, 0x1));
   regDataMap["mm_dma_mm2s_1_ctrl"].push_back(RegData("Controller_ID", "15:8", 8, 0xFF));
   regDataMap["mm_dma_mm2s_1_ctrl"].push_back(RegData("Compression_Enable", "4", 4, 0x1));
   regDataMap["mm_dma_mm2s_1_start_queue"].push_back(RegData("Repeat_Count", "23:16", 16, 0xFF));
   regDataMap["mm_dma_mm2s_1_start_queue"].push_back(RegData("Enable_Token_Issue", "31", 31, 0x1));
   regDataMap["mm_dma_mm2s_1_start_queue"].push_back(RegData("Start_BD_ID", "3:0", 0, 0xF));
   regDataMap["mm_dma_mm2s_status_0"].push_back(RegData("Error_BD_Invalid", "11", 11, 0x1));
   regDataMap["mm_dma_mm2s_status_0"].push_back(RegData("Task_Queue_Overflow", "18", 18, 0x1));
   regDataMap["mm_dma_mm2s_status_0"].push_back(RegData("Channel_Running", "19", 19, 0x1));
   regDataMap["mm_dma_mm2s_status_0"].push_back(RegData("Status", "1:0", 0, 0x3));
   regDataMap["mm_dma_mm2s_status_0"].push_back(RegData("Stalled_Lock_Acq", "2", 2, 0x1));
   regDataMap["mm_dma_mm2s_status_0"].push_back(RegData("Task_Queue_Size", "22:20", 20, 0x7));
   regDataMap["mm_dma_mm2s_status_0"].push_back(RegData("Cur_BD", "27:24", 24, 0xF));
   regDataMap["mm_dma_mm2s_status_0"].push_back(RegData("Stalled_Lock_Rel", "3", 3, 0x1));
   regDataMap["mm_dma_mm2s_status_0"].push_back(RegData("Stalled_Stream_Backpressure", "4", 4, 0x1));
   regDataMap["mm_dma_mm2s_status_0"].push_back(RegData("Stalled_TCT", "5", 5, 0x1));
   regDataMap["mm_dma_mm2s_status_1"].push_back(RegData("Error_BD_Invalid", "11", 11, 0x1));
   regDataMap["mm_dma_mm2s_status_1"].push_back(RegData("Task_Queue_Overflow", "18", 18, 0x1));
   regDataMap["mm_dma_mm2s_status_1"].push_back(RegData("Channel_Running", "19", 19, 0x1));
   regDataMap["mm_dma_mm2s_status_1"].push_back(RegData("Status", "1:0", 0, 0x3));
   regDataMap["mm_dma_mm2s_status_1"].push_back(RegData("Stalled_Lock_Acq", "2", 2, 0x1));
   regDataMap["mm_dma_mm2s_status_1"].push_back(RegData("Task_Queue_Size", "22:20", 20, 0x7));
   regDataMap["mm_dma_mm2s_status_1"].push_back(RegData("Cur_BD", "27:24", 24, 0xF));
   regDataMap["mm_dma_mm2s_status_1"].push_back(RegData("Stalled_Lock_Rel", "3", 3, 0x1));
   regDataMap["mm_dma_mm2s_status_1"].push_back(RegData("Stalled_Stream_Backpressure", "4", 4, 0x1));
   regDataMap["mm_dma_mm2s_status_1"].push_back(RegData("Stalled_TCT", "5", 5, 0x1));
   regDataMap["mm_dma_s2mm_0_ctrl"].push_back(RegData("Reset", "1", 1, 0x1));
   regDataMap["mm_dma_s2mm_0_ctrl"].push_back(RegData("Controller_ID", "15:8", 8, 0xFF));
   regDataMap["mm_dma_s2mm_0_ctrl"].push_back(RegData("FoT_Mode", "17:16", 16, 0x3));
   regDataMap["mm_dma_s2mm_0_ctrl"].push_back(RegData("Enable_Out_of_Order", "3", 3, 0x1));
   regDataMap["mm_dma_s2mm_0_ctrl"].push_back(RegData("Decompression_Enable", "4", 4, 0x1));
   regDataMap["mm_dma_s2mm_0_start_queue"].push_back(RegData("Repeat_Count", "23:16", 16, 0xFF));
   regDataMap["mm_dma_s2mm_0_start_queue"].push_back(RegData("Enable_Token_Issue", "31", 31, 0x1));
   regDataMap["mm_dma_s2mm_0_start_queue"].push_back(RegData("Start_BD_ID", "3:0", 0, 0xF));
   regDataMap["mm_dma_s2mm_1_ctrl"].push_back(RegData("Reset", "1", 1, 0x1));
   regDataMap["mm_dma_s2mm_1_ctrl"].push_back(RegData("Controller_ID", "15:8", 8, 0xFF));
   regDataMap["mm_dma_s2mm_1_ctrl"].push_back(RegData("FoT_Mode", "17:16", 16, 0x3));
   regDataMap["mm_dma_s2mm_1_ctrl"].push_back(RegData("Enable_Out_of_Order", "3", 3, 0x1));
   regDataMap["mm_dma_s2mm_1_ctrl"].push_back(RegData("Decompression_Enable", "4", 4, 0x1));
   regDataMap["mm_dma_s2mm_1_start_queue"].push_back(RegData("Repeat_Count", "23:16", 16, 0xFF));
   regDataMap["mm_dma_s2mm_1_start_queue"].push_back(RegData("Enable_Token_Issue", "31", 31, 0x1));
   regDataMap["mm_dma_s2mm_1_start_queue"].push_back(RegData("Start_BD_ID", "3:0", 0, 0xF));
   regDataMap["mm_dma_s2mm_current_write_count_0"].push_back(RegData("Current_Write_Count", "13:0", 0, 0x3FFF));
   regDataMap["mm_dma_s2mm_current_write_count_1"].push_back(RegData("Current_Write_Count", "13:0", 0, 0x3FFF));
   regDataMap["mm_dma_s2mm_fot_count_fifo_pop_0"].push_back(RegData("Write_Count", "17:0", 0, 0x3FFFF));
   regDataMap["mm_dma_s2mm_fot_count_fifo_pop_0"].push_back(RegData("BD_ID", "29:24", 24, 0x3F));
   regDataMap["mm_dma_s2mm_fot_count_fifo_pop_0"].push_back(RegData("Last_in_Task", "30", 30, 0x1));
   regDataMap["mm_dma_s2mm_fot_count_fifo_pop_0"].push_back(RegData("Valid", "31", 31, 0x1));
   regDataMap["mm_dma_s2mm_fot_count_fifo_pop_1"].push_back(RegData("Write_Count", "17:0", 0, 0x3FFFF));
   regDataMap["mm_dma_s2mm_fot_count_fifo_pop_1"].push_back(RegData("BD_ID", "29:24", 24, 0x3F));
   regDataMap["mm_dma_s2mm_fot_count_fifo_pop_1"].push_back(RegData("Last_in_Task", "30", 30, 0x1));
   regDataMap["mm_dma_s2mm_fot_count_fifo_pop_1"].push_back(RegData("Valid", "31", 31, 0x1));
   regDataMap["mm_dma_s2mm_status_0"].push_back(RegData("Error_BD_Unavailable", "10", 10, 0x1));
   regDataMap["mm_dma_s2mm_status_0"].push_back(RegData("Error_BD_Invalid", "11", 11, 0x1));
   regDataMap["mm_dma_s2mm_status_0"].push_back(RegData("Error_FoT_Length_Exceeded", "12", 12, 0x1));
   regDataMap["mm_dma_s2mm_status_0"].push_back(RegData("Error_FoT_BDs_per_Task", "13", 13, 0x1));
   regDataMap["mm_dma_s2mm_status_0"].push_back(RegData("Task_Queue_Overflow", "18", 18, 0x1));
   regDataMap["mm_dma_s2mm_status_0"].push_back(RegData("Channel_Running", "19", 19, 0x1));
   regDataMap["mm_dma_s2mm_status_0"].push_back(RegData("Status", "1:0", 0, 0x3));
   regDataMap["mm_dma_s2mm_status_0"].push_back(RegData("Stalled_Lock_Acq", "2", 2, 0x1));
   regDataMap["mm_dma_s2mm_status_0"].push_back(RegData("Task_Queue_Size", "22:20", 20, 0x7));
   regDataMap["mm_dma_s2mm_status_0"].push_back(RegData("Cur_BD", "27:24", 24, 0xF));
   regDataMap["mm_dma_s2mm_status_0"].push_back(RegData("Stalled_Lock_Rel", "3", 3, 0x1));
   regDataMap["mm_dma_s2mm_status_0"].push_back(RegData("Stalled_Stream_Starvation", "4", 4, 0x1));
   regDataMap["mm_dma_s2mm_status_0"].push_back(RegData("Stalled_TCT_or_Count_FIFO_Full", "5", 5, 0x1));
   regDataMap["mm_dma_s2mm_status_1"].push_back(RegData("Error_BD_Unavailable", "10", 10, 0x1));
   regDataMap["mm_dma_s2mm_status_1"].push_back(RegData("Error_BD_Invalid", "11", 11, 0x1));
   regDataMap["mm_dma_s2mm_status_1"].push_back(RegData("Error_FoT_Length_Exceeded", "12", 12, 0x1));
   regDataMap["mm_dma_s2mm_status_1"].push_back(RegData("Error_FoT_BDs_per_Task", "13", 13, 0x1));
   regDataMap["mm_dma_s2mm_status_1"].push_back(RegData("Task_Queue_Overflow", "18", 18, 0x1));
   regDataMap["mm_dma_s2mm_status_1"].push_back(RegData("Channel_Running", "19", 19, 0x1));
   regDataMap["mm_dma_s2mm_status_1"].push_back(RegData("Status", "1:0", 0, 0x3));
   regDataMap["mm_dma_s2mm_status_1"].push_back(RegData("Stalled_Lock_Acq", "2", 2, 0x1));
   regDataMap["mm_dma_s2mm_status_1"].push_back(RegData("Task_Queue_Size", "22:20", 20, 0x7));
   regDataMap["mm_dma_s2mm_status_1"].push_back(RegData("Cur_BD", "27:24", 24, 0xF));
   regDataMap["mm_dma_s2mm_status_1"].push_back(RegData("Stalled_Lock_Rel", "3", 3, 0x1));
   regDataMap["mm_dma_s2mm_status_1"].push_back(RegData("Stalled_Stream_Starvation", "4", 4, 0x1));
   regDataMap["mm_dma_s2mm_status_1"].push_back(RegData("Stalled_TCT_or_Count_FIFO_Full", "5", 5, 0x1));
   regDataMap["mm_ecc_failing_address"].push_back(RegData("ECC_Error_Detection_Address", "13:0", 0, 0x3FFF));
   regDataMap["mm_ecc_failing_address"].push_back(RegData("Valid", "15", 15, 0x1));
   regDataMap["mm_ecc_scrubbing_event"].push_back(RegData("Scrubbing_Event_number", "6:0", 0, 0x7F));
   regDataMap["mm_edge_detection_event_control"].push_back(RegData("Edge_Detection_0_Trigger_Falling", "10", 10, 0x1));
   regDataMap["mm_edge_detection_event_control"].push_back(RegData("Edge_Detection_Event_1", "22:16", 16, 0x7F));
   regDataMap["mm_edge_detection_event_control"].push_back(RegData("Edge_Detection_1_Trigger_Rising", "25", 25, 0x1));
   regDataMap["mm_edge_detection_event_control"].push_back(RegData("Edge_Detection_1_Trigger_Falling", "26", 26, 0x1));
   regDataMap["mm_edge_detection_event_control"].push_back(RegData("Edge_Detection_Event_0", "6:0", 0, 0x7F));
   regDataMap["mm_edge_detection_event_control"].push_back(RegData("Edge_Detection_0_Trigger_Rising", "9", 9, 0x1));
   regDataMap["mm_event_broadcast0"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["mm_event_broadcast1"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["mm_event_broadcast10"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["mm_event_broadcast11"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["mm_event_broadcast12"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["mm_event_broadcast13"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["mm_event_broadcast14"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["mm_event_broadcast15"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["mm_event_broadcast2"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["mm_event_broadcast3"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["mm_event_broadcast4"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["mm_event_broadcast5"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["mm_event_broadcast6"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["mm_event_broadcast7"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["mm_event_broadcast8"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["mm_event_broadcast9"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["mm_event_broadcast_block_east_clr"].push_back(RegData("Clear", "15:0", 0, 0xFFFF));
   regDataMap["mm_event_broadcast_block_east_set"].push_back(RegData("Set", "15:0", 0, 0xFFFF));
   regDataMap["mm_event_broadcast_block_east_value"].push_back(RegData("Value", "15:0", 0, 0xFFFF));
   regDataMap["mm_event_broadcast_block_north_clr"].push_back(RegData("Clear", "15:0", 0, 0xFFFF));
   regDataMap["mm_event_broadcast_block_north_set"].push_back(RegData("Set", "15:0", 0, 0xFFFF));
   regDataMap["mm_event_broadcast_block_north_value"].push_back(RegData("Value", "15:0", 0, 0xFFFF));
   regDataMap["mm_event_broadcast_block_south_clr"].push_back(RegData("Clear", "15:0", 0, 0xFFFF));
   regDataMap["mm_event_broadcast_block_south_set"].push_back(RegData("Set", "15:0", 0, 0xFFFF));
   regDataMap["mm_event_broadcast_block_south_value"].push_back(RegData("Value", "15:0", 0, 0xFFFF));
   regDataMap["mm_event_broadcast_block_west_clr"].push_back(RegData("Clear", "15:0", 0, 0xFFFF));
   regDataMap["mm_event_broadcast_block_west_set"].push_back(RegData("Set", "15:0", 0, 0xFFFF));
   regDataMap["mm_event_broadcast_block_west_value"].push_back(RegData("Value", "15:0", 0, 0xFFFF));
   regDataMap["mm_event_generate"].push_back(RegData("Event", "6:0", 0, 0x7F));
   regDataMap["mm_event_group_0_enable"].push_back(RegData("Timer_Sync", "0", 0, 0x1));
   regDataMap["mm_event_group_0_enable"].push_back(RegData("Timer_Value_Reached", "1", 1, 0x1));
   regDataMap["mm_event_group_0_enable"].push_back(RegData("Perf_Cnt0_Event", "2", 2, 0x1));
   regDataMap["mm_event_group_0_enable"].push_back(RegData("Perf_Cnt1_Event", "3", 3, 0x1));
   regDataMap["mm_event_group_0_enable"].push_back(RegData("Combo_Event_0", "4", 4, 0x1));
   regDataMap["mm_event_group_0_enable"].push_back(RegData("Combo_Event_1", "5", 5, 0x1));
   regDataMap["mm_event_group_0_enable"].push_back(RegData("Combo_Event_2", "6", 6, 0x1));
   regDataMap["mm_event_group_0_enable"].push_back(RegData("Combo_Event_3", "7", 7, 0x1));
   regDataMap["mm_event_group_0_enable"].push_back(RegData("Edge_Detection_Event_0", "8", 8, 0x1));
   regDataMap["mm_event_group_0_enable"].push_back(RegData("Edge_Detection_Event_1", "9", 9, 0x1));
   regDataMap["mm_event_group_broadcast_enable"].push_back(RegData("Broadcast_0", "0", 0, 0x1));
   regDataMap["mm_event_group_broadcast_enable"].push_back(RegData("Broadcast_1", "1", 1, 0x1));
   regDataMap["mm_event_group_broadcast_enable"].push_back(RegData("Broadcast_10", "10", 10, 0x1));
   regDataMap["mm_event_group_broadcast_enable"].push_back(RegData("Broadcast_11", "11", 11, 0x1));
   regDataMap["mm_event_group_broadcast_enable"].push_back(RegData("Broadcast_12", "12", 12, 0x1));
   regDataMap["mm_event_group_broadcast_enable"].push_back(RegData("Broadcast_13", "13", 13, 0x1));
   regDataMap["mm_event_group_broadcast_enable"].push_back(RegData("Broadcast_14", "14", 14, 0x1));
   regDataMap["mm_event_group_broadcast_enable"].push_back(RegData("Broadcast_15", "15", 15, 0x1));
   regDataMap["mm_event_group_broadcast_enable"].push_back(RegData("Broadcast_2", "2", 2, 0x1));
   regDataMap["mm_event_group_broadcast_enable"].push_back(RegData("Broadcast_3", "3", 3, 0x1));
   regDataMap["mm_event_group_broadcast_enable"].push_back(RegData("Broadcast_4", "4", 4, 0x1));
   regDataMap["mm_event_group_broadcast_enable"].push_back(RegData("Broadcast_5", "5", 5, 0x1));
   regDataMap["mm_event_group_broadcast_enable"].push_back(RegData("Broadcast_6", "6", 6, 0x1));
   regDataMap["mm_event_group_broadcast_enable"].push_back(RegData("Broadcast_7", "7", 7, 0x1));
   regDataMap["mm_event_group_broadcast_enable"].push_back(RegData("Broadcast_8", "8", 8, 0x1));
   regDataMap["mm_event_group_broadcast_enable"].push_back(RegData("Broadcast_9", "9", 9, 0x1));
   regDataMap["mm_event_group_dma_enable"].push_back(RegData("DMA_S2MM_0_start_task", "0", 0, 0x1));
   regDataMap["mm_event_group_dma_enable"].push_back(RegData("DMA_S2MM_1_start_task", "1", 1, 0x1));
   regDataMap["mm_event_group_dma_enable"].push_back(RegData("DMA_MM2S_0_finished_task", "10", 10, 0x1));
   regDataMap["mm_event_group_dma_enable"].push_back(RegData("DMA_MM2S_1_finished_task", "11", 11, 0x1));
   regDataMap["mm_event_group_dma_enable"].push_back(RegData("DMA_S2MM_0_stalled_lock_acquire", "12", 12, 0x1));
   regDataMap["mm_event_group_dma_enable"].push_back(RegData("DMA_S2MM_1_stalled_lock_acquire", "13", 13, 0x1));
   regDataMap["mm_event_group_dma_enable"].push_back(RegData("DMA_MM2S_0_stalled_lock_acquire", "14", 14, 0x1));
   regDataMap["mm_event_group_dma_enable"].push_back(RegData("DMA_MM2S_1_stalled_lock_acquire", "15", 15, 0x1));
   regDataMap["mm_event_group_dma_enable"].push_back(RegData("DMA_S2MM_0_stream_starvation", "16", 16, 0x1));
   regDataMap["mm_event_group_dma_enable"].push_back(RegData("DMA_S2MM_1_stream_starvation", "17", 17, 0x1));
   regDataMap["mm_event_group_dma_enable"].push_back(RegData("DMA_S2MM_0_memory_backpressure", "18", 18, 0x1));
   regDataMap["mm_event_group_dma_enable"].push_back(RegData("DMA_S2MM_1_memory_backpressure", "19", 19, 0x1));
   regDataMap["mm_event_group_dma_enable"].push_back(RegData("DMA_MM2S_0_start_task", "2", 2, 0x1));
   regDataMap["mm_event_group_dma_enable"].push_back(RegData("DMA_MM2S_0_stream_backpressure", "20", 20, 0x1));
   regDataMap["mm_event_group_dma_enable"].push_back(RegData("DMA_MM2S_1_stream_backpressure", "21", 21, 0x1));
   regDataMap["mm_event_group_dma_enable"].push_back(RegData("DMA_MM2S_0_memory_starvation", "22", 22, 0x1));
   regDataMap["mm_event_group_dma_enable"].push_back(RegData("DMA_MM2S_1_memory_starvation", "23", 23, 0x1));
   regDataMap["mm_event_group_dma_enable"].push_back(RegData("DMA_MM2S_1_start_task", "3", 3, 0x1));
   regDataMap["mm_event_group_dma_enable"].push_back(RegData("DMA_S2MM_0_finished_BD", "4", 4, 0x1));
   regDataMap["mm_event_group_dma_enable"].push_back(RegData("DMA_S2MM_1_finished_BD", "5", 5, 0x1));
   regDataMap["mm_event_group_dma_enable"].push_back(RegData("DMA_MM2S_0_finished_BD", "6", 6, 0x1));
   regDataMap["mm_event_group_dma_enable"].push_back(RegData("DMA_MM2S_1_finished_BD", "7", 7, 0x1));
   regDataMap["mm_event_group_dma_enable"].push_back(RegData("DMA_S2MM_0_finished_task", "8", 8, 0x1));
   regDataMap["mm_event_group_dma_enable"].push_back(RegData("DMA_S2MM_1_finished_task", "9", 9, 0x1));
   regDataMap["mm_event_group_error_enable"].push_back(RegData("DM_ECC_Error_Scrub_Corrected", "0", 0, 0x1));
   regDataMap["mm_event_group_error_enable"].push_back(RegData("DM_ECC_Error_Scrub_2bit", "1", 1, 0x1));
   regDataMap["mm_event_group_error_enable"].push_back(RegData("DMA_S2MM_0_Error", "10", 10, 0x1));
   regDataMap["mm_event_group_error_enable"].push_back(RegData("DMA_S2MM_1_Error", "11", 11, 0x1));
   regDataMap["mm_event_group_error_enable"].push_back(RegData("DMA_MM2S_0_Error", "12", 12, 0x1));
   regDataMap["mm_event_group_error_enable"].push_back(RegData("DMA_MM2S_1_Error", "13", 13, 0x1));
   regDataMap["mm_event_group_error_enable"].push_back(RegData("Lock_Error", "14", 14, 0x1));
   regDataMap["mm_event_group_error_enable"].push_back(RegData("DMA_Task_Token_Stall", "15", 15, 0x1));
   regDataMap["mm_event_group_error_enable"].push_back(RegData("DM_ECC_Error_1bit", "2", 2, 0x1));
   regDataMap["mm_event_group_error_enable"].push_back(RegData("DM_ECC_Error_2bit", "3", 3, 0x1));
   regDataMap["mm_event_group_error_enable"].push_back(RegData("DM_Parity_Error_Bank_2", "4", 4, 0x1));
   regDataMap["mm_event_group_error_enable"].push_back(RegData("DM_Parity_Error_Bank_3", "5", 5, 0x1));
   regDataMap["mm_event_group_error_enable"].push_back(RegData("DM_Parity_Error_Bank_4", "6", 6, 0x1));
   regDataMap["mm_event_group_error_enable"].push_back(RegData("DM_Parity_Error_Bank_5", "7", 7, 0x1));
   regDataMap["mm_event_group_error_enable"].push_back(RegData("DM_Parity_Error_Bank_6", "8", 8, 0x1));
   regDataMap["mm_event_group_error_enable"].push_back(RegData("DM_Parity_Error_Bank_7", "9", 9, 0x1));
   regDataMap["mm_event_group_lock_enable"].push_back(RegData("Lock_Sel0_acq_eq", "0", 0, 0x1));
   regDataMap["mm_event_group_lock_enable"].push_back(RegData("Lock_Sel0_acq_ge", "1", 1, 0x1));
   regDataMap["mm_event_group_lock_enable"].push_back(RegData("Lock_Sel2_rel", "10", 10, 0x1));
   regDataMap["mm_event_group_lock_enable"].push_back(RegData("Lock_Sel2_equal_to_value", "11", 11, 0x1));
   regDataMap["mm_event_group_lock_enable"].push_back(RegData("Lock_Sel3_acq_eq", "12", 12, 0x1));
   regDataMap["mm_event_group_lock_enable"].push_back(RegData("Lock_Sel3_acq_ge", "13", 13, 0x1));
   regDataMap["mm_event_group_lock_enable"].push_back(RegData("Lock_Sel3_rel", "14", 14, 0x1));
   regDataMap["mm_event_group_lock_enable"].push_back(RegData("Lock_Sel3_equal_to_value", "15", 15, 0x1));
   regDataMap["mm_event_group_lock_enable"].push_back(RegData("Lock_Sel4_acq_eq", "16", 16, 0x1));
   regDataMap["mm_event_group_lock_enable"].push_back(RegData("Lock_Sel4_acq_ge", "17", 17, 0x1));
   regDataMap["mm_event_group_lock_enable"].push_back(RegData("Lock_Sel4_rel", "18", 18, 0x1));
   regDataMap["mm_event_group_lock_enable"].push_back(RegData("Lock_Sel4_equal_to_value", "19", 19, 0x1));
   regDataMap["mm_event_group_lock_enable"].push_back(RegData("Lock_Sel0_rel", "2", 2, 0x1));
   regDataMap["mm_event_group_lock_enable"].push_back(RegData("Lock_Sel5_acq_eq", "20", 20, 0x1));
   regDataMap["mm_event_group_lock_enable"].push_back(RegData("Lock_Sel5_acq_ge", "21", 21, 0x1));
   regDataMap["mm_event_group_lock_enable"].push_back(RegData("Lock_Sel5_rel", "22", 22, 0x1));
   regDataMap["mm_event_group_lock_enable"].push_back(RegData("Lock_Sel5_equal_to_value", "23", 23, 0x1));
   regDataMap["mm_event_group_lock_enable"].push_back(RegData("Lock_Sel6_acq_eq", "24", 24, 0x1));
   regDataMap["mm_event_group_lock_enable"].push_back(RegData("Lock_Sel6_acq_ge", "25", 25, 0x1));
   regDataMap["mm_event_group_lock_enable"].push_back(RegData("Lock_Sel6_rel", "26", 26, 0x1));
   regDataMap["mm_event_group_lock_enable"].push_back(RegData("Lock_Sel6_equal_to_value", "27", 27, 0x1));
   regDataMap["mm_event_group_lock_enable"].push_back(RegData("Lock_Sel7_acq_eq", "28", 28, 0x1));
   regDataMap["mm_event_group_lock_enable"].push_back(RegData("Lock_Sel7_acq_ge", "29", 29, 0x1));
   regDataMap["mm_event_group_lock_enable"].push_back(RegData("Lock_Sel0_equal_to_value", "3", 3, 0x1));
   regDataMap["mm_event_group_lock_enable"].push_back(RegData("Lock_Sel7_rel", "30", 30, 0x1));
   regDataMap["mm_event_group_lock_enable"].push_back(RegData("Lock_Sel7_equal_to_value", "31", 31, 0x1));
   regDataMap["mm_event_group_lock_enable"].push_back(RegData("Lock_Sel1_acq_eq", "4", 4, 0x1));
   regDataMap["mm_event_group_lock_enable"].push_back(RegData("Lock_Sel1_acq_ge", "5", 5, 0x1));
   regDataMap["mm_event_group_lock_enable"].push_back(RegData("Lock_Sel1_rel", "6", 6, 0x1));
   regDataMap["mm_event_group_lock_enable"].push_back(RegData("Lock_Sel1_equal_to_value", "7", 7, 0x1));
   regDataMap["mm_event_group_lock_enable"].push_back(RegData("Lock_Sel2_acq_eq", "8", 8, 0x1));
   regDataMap["mm_event_group_lock_enable"].push_back(RegData("Lock_Sel2_acq_ge", "9", 9, 0x1));
   regDataMap["mm_event_group_memory_conflict_enable"].push_back(RegData("Conflict_DM_Bank_0", "0", 0, 0x1));
   regDataMap["mm_event_group_memory_conflict_enable"].push_back(RegData("Conflict_DM_Bank_1", "1", 1, 0x1));
   regDataMap["mm_event_group_memory_conflict_enable"].push_back(RegData("Conflict_DM_Bank_2", "2", 2, 0x1));
   regDataMap["mm_event_group_memory_conflict_enable"].push_back(RegData("Conflict_DM_Bank_3", "3", 3, 0x1));
   regDataMap["mm_event_group_memory_conflict_enable"].push_back(RegData("Conflict_DM_Bank_4", "4", 4, 0x1));
   regDataMap["mm_event_group_memory_conflict_enable"].push_back(RegData("Conflict_DM_Bank_5", "5", 5, 0x1));
   regDataMap["mm_event_group_memory_conflict_enable"].push_back(RegData("Conflict_DM_Bank_6", "6", 6, 0x1));
   regDataMap["mm_event_group_memory_conflict_enable"].push_back(RegData("Conflict_DM_Bank_7", "7", 7, 0x1));
   regDataMap["mm_event_group_user_event_enable"].push_back(RegData("User_Event_0", "0", 0, 0x1));
   regDataMap["mm_event_group_user_event_enable"].push_back(RegData("User_Event_1", "1", 1, 0x1));
   regDataMap["mm_event_group_user_event_enable"].push_back(RegData("User_Event_2", "2", 2, 0x1));
   regDataMap["mm_event_group_user_event_enable"].push_back(RegData("User_Event_3", "3", 3, 0x1));
   regDataMap["mm_event_group_watchpoint_enable"].push_back(RegData("Watchpoint_0", "0", 0, 0x1));
   regDataMap["mm_event_group_watchpoint_enable"].push_back(RegData("Watchpoint_1", "1", 1, 0x1));
   regDataMap["mm_event_status0"].push_back(RegData("Event_31_0_Status", "31:0", 0, 0xFFFFFFFF));
   regDataMap["mm_event_status1"].push_back(RegData("Event_63_32_Status", "31:0", 0, 0xFFFFFFFF));
   regDataMap["mm_event_status2"].push_back(RegData("Event_95_64_Status", "31:0", 0, 0xFFFFFFFF));
   regDataMap["mm_event_status3"].push_back(RegData("Event_127_96_Status", "31:0", 0, 0xFFFFFFFF));
   regDataMap["mm_lock0_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mm_lock10_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mm_lock11_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mm_lock12_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mm_lock13_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mm_lock14_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mm_lock15_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mm_lock1_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mm_lock2_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mm_lock3_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mm_lock4_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mm_lock5_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mm_lock6_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mm_lock7_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mm_lock8_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mm_lock9_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mm_lock_request"].push_back(RegData("Request_Result", "0", 0, 0x1));
   regDataMap["mm_locks_event_selection_0"].push_back(RegData("Lock_Select", "19:16", 16, 0xF));
   regDataMap["mm_locks_event_selection_0"].push_back(RegData("Lock_Value", "5:0", 0, 0x3F));
   regDataMap["mm_locks_event_selection_1"].push_back(RegData("Lock_Select", "19:16", 16, 0xF));
   regDataMap["mm_locks_event_selection_1"].push_back(RegData("Lock_Value", "5:0", 0, 0x3F));
   regDataMap["mm_locks_event_selection_2"].push_back(RegData("Lock_Select", "19:16", 16, 0xF));
   regDataMap["mm_locks_event_selection_2"].push_back(RegData("Lock_Value", "5:0", 0, 0x3F));
   regDataMap["mm_locks_event_selection_3"].push_back(RegData("Lock_Select", "19:16", 16, 0xF));
   regDataMap["mm_locks_event_selection_3"].push_back(RegData("Lock_Value", "5:0", 0, 0x3F));
   regDataMap["mm_locks_event_selection_4"].push_back(RegData("Lock_Select", "19:16", 16, 0xF));
   regDataMap["mm_locks_event_selection_4"].push_back(RegData("Lock_Value", "5:0", 0, 0x3F));
   regDataMap["mm_locks_event_selection_5"].push_back(RegData("Lock_Select", "19:16", 16, 0xF));
   regDataMap["mm_locks_event_selection_5"].push_back(RegData("Lock_Value", "5:0", 0, 0x3F));
   regDataMap["mm_locks_event_selection_6"].push_back(RegData("Lock_Select", "19:16", 16, 0xF));
   regDataMap["mm_locks_event_selection_6"].push_back(RegData("Lock_Value", "5:0", 0, 0x3F));
   regDataMap["mm_locks_event_selection_7"].push_back(RegData("Lock_Select", "19:16", 16, 0xF));
   regDataMap["mm_locks_event_selection_7"].push_back(RegData("Lock_Value", "5:0", 0, 0x3F));
   regDataMap["mm_locks_overflow"].push_back(RegData("Lock_Overflow_0", "0", 0, 0x1));
   regDataMap["mm_locks_overflow"].push_back(RegData("Lock_Overflow_1", "1", 1, 0x1));
   regDataMap["mm_locks_overflow"].push_back(RegData("Lock_Overflow_10", "10", 10, 0x1));
   regDataMap["mm_locks_overflow"].push_back(RegData("Lock_Overflow_11", "11", 11, 0x1));
   regDataMap["mm_locks_overflow"].push_back(RegData("Lock_Overflow_12", "12", 12, 0x1));
   regDataMap["mm_locks_overflow"].push_back(RegData("Lock_Overflow_13", "13", 13, 0x1));
   regDataMap["mm_locks_overflow"].push_back(RegData("Lock_Overflow_14", "14", 14, 0x1));
   regDataMap["mm_locks_overflow"].push_back(RegData("Lock_Overflow_15", "15", 15, 0x1));
   regDataMap["mm_locks_overflow"].push_back(RegData("Lock_Overflow_2", "2", 2, 0x1));
   regDataMap["mm_locks_overflow"].push_back(RegData("Lock_Overflow_3", "3", 3, 0x1));
   regDataMap["mm_locks_overflow"].push_back(RegData("Lock_Overflow_4", "4", 4, 0x1));
   regDataMap["mm_locks_overflow"].push_back(RegData("Lock_Overflow_5", "5", 5, 0x1));
   regDataMap["mm_locks_overflow"].push_back(RegData("Lock_Overflow_6", "6", 6, 0x1));
   regDataMap["mm_locks_overflow"].push_back(RegData("Lock_Overflow_7", "7", 7, 0x1));
   regDataMap["mm_locks_overflow"].push_back(RegData("Lock_Overflow_8", "8", 8, 0x1));
   regDataMap["mm_locks_overflow"].push_back(RegData("Lock_Overflow_9", "9", 9, 0x1));
   regDataMap["mm_locks_underflow"].push_back(RegData("Lock_Underflow_0", "0", 0, 0x1));
   regDataMap["mm_locks_underflow"].push_back(RegData("Lock_Underflow_1", "1", 1, 0x1));
   regDataMap["mm_locks_underflow"].push_back(RegData("Lock_Underflow_10", "10", 10, 0x1));
   regDataMap["mm_locks_underflow"].push_back(RegData("Lock_Underflow_11", "11", 11, 0x1));
   regDataMap["mm_locks_underflow"].push_back(RegData("Lock_Underflow_12", "12", 12, 0x1));
   regDataMap["mm_locks_underflow"].push_back(RegData("Lock_Underflow_13", "13", 13, 0x1));
   regDataMap["mm_locks_underflow"].push_back(RegData("Lock_Underflow_14", "14", 14, 0x1));
   regDataMap["mm_locks_underflow"].push_back(RegData("Lock_Underflow_15", "15", 15, 0x1));
   regDataMap["mm_locks_underflow"].push_back(RegData("Lock_Underflow_2", "2", 2, 0x1));
   regDataMap["mm_locks_underflow"].push_back(RegData("Lock_Underflow_3", "3", 3, 0x1));
   regDataMap["mm_locks_underflow"].push_back(RegData("Lock_Underflow_4", "4", 4, 0x1));
   regDataMap["mm_locks_underflow"].push_back(RegData("Lock_Underflow_5", "5", 5, 0x1));
   regDataMap["mm_locks_underflow"].push_back(RegData("Lock_Underflow_6", "6", 6, 0x1));
   regDataMap["mm_locks_underflow"].push_back(RegData("Lock_Underflow_7", "7", 7, 0x1));
   regDataMap["mm_locks_underflow"].push_back(RegData("Lock_Underflow_8", "8", 8, 0x1));
   regDataMap["mm_locks_underflow"].push_back(RegData("Lock_Underflow_9", "9", 9, 0x1));
   regDataMap["mm_memory_control"].push_back(RegData("Memory_Zeroisation", "0", 0, 0x1));
   regDataMap["mm_parity_failing_address"].push_back(RegData("Parity_Error_Detection_Address", "15:0", 0, 0xFFFF));
   regDataMap["mm_parity_failing_address"].push_back(RegData("Valid", "16", 16, 0x1));
   regDataMap["mm_performance_control0"].push_back(RegData("Cnt0_Stop_Event", "14:8", 8, 0x7F));
   regDataMap["mm_performance_control0"].push_back(RegData("Cnt1_Start_Event", "22:16", 16, 0x7F));
   regDataMap["mm_performance_control0"].push_back(RegData("Cnt1_Stop_Event", "30:24", 24, 0x7F));
   regDataMap["mm_performance_control0"].push_back(RegData("Cnt0_Start_Event", "6:0", 0, 0x7F));
   regDataMap["mm_performance_control1"].push_back(RegData("Cnt1_Reset_Event", "14:8", 8, 0x7F));
   regDataMap["mm_performance_control1"].push_back(RegData("Cnt0_Reset_Event", "6:0", 0, 0x7F));
   regDataMap["mm_performance_control2"].push_back(RegData("Cnt2_Stop_Event", "14:8", 8, 0x7F));
   regDataMap["mm_performance_control2"].push_back(RegData("Cnt3_Start_Event", "22:16", 16, 0x7F));
   regDataMap["mm_performance_control2"].push_back(RegData("Cnt3_Stop_Event", "30:24", 24, 0x7F));
   regDataMap["mm_performance_control2"].push_back(RegData("Cnt2_Start_Event", "6:0", 0, 0x7F));
   regDataMap["mm_performance_control3"].push_back(RegData("Cnt3_Reset_Event", "14:8", 8, 0x7F));
   regDataMap["mm_performance_control3"].push_back(RegData("Cnt2_Reset_Event", "6:0", 0, 0x7F));
   regDataMap["mm_performance_counter0"].push_back(RegData("Counter0_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["mm_performance_counter0_event_value"].push_back(RegData("Counter0_Event_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["mm_performance_counter1"].push_back(RegData("Counter1_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["mm_performance_counter1_event_value"].push_back(RegData("Counter1_Event_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["mm_performance_counter2"].push_back(RegData("Counter2_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["mm_performance_counter3"].push_back(RegData("Counter3_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["mm_spare_reg"].push_back(RegData("Spare_Reg", "15:0", 0, 0xFFFF));
   regDataMap["mm_timer_control"].push_back(RegData("Reset_Event", "14:8", 8, 0x7F));
   regDataMap["mm_timer_control"].push_back(RegData("Reset", "31", 31, 0x1));
   regDataMap["mm_timer_high"].push_back(RegData("TimerHigh", "31:0", 0, 0xFFFFFFFF));
   regDataMap["mm_timer_low"].push_back(RegData("TimerLow", "31:0", 0, 0xFFFFFFFF));
   regDataMap["mm_timer_trig_event_high_value"].push_back(RegData("TimerTrigHigh", "31:0", 0, 0xFFFFFFFF));
   regDataMap["mm_timer_trig_event_low_value"].push_back(RegData("TimerTrigLow", "31:0", 0, 0xFFFFFFFF));
   regDataMap["mm_trace_control0"].push_back(RegData("Trace_Start_Event", "22:16", 16, 0x7F));
   regDataMap["mm_trace_control0"].push_back(RegData("Trace_Stop_Event", "30:24", 24, 0x7F));
   regDataMap["mm_trace_control1"].push_back(RegData("Packet_Type", "14:12", 12, 0x7));
   regDataMap["mm_trace_control1"].push_back(RegData("ID", "4:0", 0, 0x1F));
   regDataMap["mm_trace_event0"].push_back(RegData("Trace_Event1", "14:8", 8, 0x7F));
   regDataMap["mm_trace_event0"].push_back(RegData("Trace_Event2", "22:16", 16, 0x7F));
   regDataMap["mm_trace_event0"].push_back(RegData("Trace_Event3", "30:24", 24, 0x7F));
   regDataMap["mm_trace_event0"].push_back(RegData("Trace_Event0", "6:0", 0, 0x7F));
   regDataMap["mm_trace_event1"].push_back(RegData("Trace_Event5", "14:8", 8, 0x7F));
   regDataMap["mm_trace_event1"].push_back(RegData("Trace_Event6", "22:16", 16, 0x7F));
   regDataMap["mm_trace_event1"].push_back(RegData("Trace_Event7", "30:24", 24, 0x7F));
   regDataMap["mm_trace_event1"].push_back(RegData("Trace_Event4", "6:0", 0, 0x7F));
   regDataMap["mm_trace_status"].push_back(RegData("Mode", "2:0", 0, 0x7));
   regDataMap["mm_trace_status"].push_back(RegData("State", "9:8", 8, 0x3));
   regDataMap["mm_watchpoint0"].push_back(RegData("Address", "10:0", 0, 0x7FF));
   regDataMap["mm_watchpoint0"].push_back(RegData("WriteStrobeMask", "23:16", 16, 0xFF));
   regDataMap["mm_watchpoint0"].push_back(RegData("South_Access", "24", 24, 0x1));
   regDataMap["mm_watchpoint0"].push_back(RegData("West_Access", "25", 25, 0x1));
   regDataMap["mm_watchpoint0"].push_back(RegData("North_Access", "26", 26, 0x1));
   regDataMap["mm_watchpoint0"].push_back(RegData("East_Access", "27", 27, 0x1));
   regDataMap["mm_watchpoint0"].push_back(RegData("DMA_Access", "28", 28, 0x1));
   regDataMap["mm_watchpoint0"].push_back(RegData("AXI_Access", "29", 29, 0x1));
   regDataMap["mm_watchpoint0"].push_back(RegData("Write_Access", "30", 30, 0x1));
   regDataMap["mm_watchpoint0"].push_back(RegData("Read_Access", "31", 31, 0x1));
   regDataMap["mm_watchpoint1"].push_back(RegData("Address", "10:0", 0, 0x7FF));
   regDataMap["mm_watchpoint1"].push_back(RegData("WriteStrobeMask", "23:16", 16, 0xFF));
   regDataMap["mm_watchpoint1"].push_back(RegData("South_Access", "24", 24, 0x1));
   regDataMap["mm_watchpoint1"].push_back(RegData("West_Access", "25", 25, 0x1));
   regDataMap["mm_watchpoint1"].push_back(RegData("North_Access", "26", 26, 0x1));
   regDataMap["mm_watchpoint1"].push_back(RegData("East_Access", "27", 27, 0x1));
   regDataMap["mm_watchpoint1"].push_back(RegData("DMA_Access", "28", 28, 0x1));
   regDataMap["mm_watchpoint1"].push_back(RegData("AXI_Access", "29", 29, 0x1));
   regDataMap["mm_watchpoint1"].push_back(RegData("Write_Access", "30", 30, 0x1));
   regDataMap["mm_watchpoint1"].push_back(RegData("Read_Access", "31", 31, 0x1));
   regDataMap["mem_cssd_trigger"].push_back(RegData("Trigger", "0", 0, 0x1));
   regDataMap["mem_checkbit_error_generation"].push_back(RegData("Lane0", "0", 0, 0x1));
   regDataMap["mem_checkbit_error_generation"].push_back(RegData("Lane1", "1", 1, 0x1));
   regDataMap["mem_checkbit_error_generation"].push_back(RegData("Lane2", "2", 2, 0x1));
   regDataMap["mem_checkbit_error_generation"].push_back(RegData("Lane3", "3", 3, 0x1));
   regDataMap["mem_checkbit_error_generation"].push_back(RegData("Lane4", "4", 4, 0x1));
   regDataMap["mem_checkbit_error_generation"].push_back(RegData("Lane5", "5", 5, 0x1));
   regDataMap["mem_checkbit_error_generation"].push_back(RegData("Lane6", "6", 6, 0x1));
   regDataMap["mem_checkbit_error_generation"].push_back(RegData("Lane7", "7", 7, 0x1));
   regDataMap["mem_combo_event_control"].push_back(RegData("combo2", "17:16", 16, 0x3));
   regDataMap["mem_combo_event_control"].push_back(RegData("combo0", "1:0", 0, 0x3));
   regDataMap["mem_combo_event_control"].push_back(RegData("combo1", "9:8", 8, 0x3));
   regDataMap["mem_combo_event_inputs"].push_back(RegData("eventB", "15:8", 8, 0xFF));
   regDataMap["mem_combo_event_inputs"].push_back(RegData("eventC", "23:16", 16, 0xFF));
   regDataMap["mem_combo_event_inputs"].push_back(RegData("eventD", "31:24", 24, 0xFF));
   regDataMap["mem_combo_event_inputs"].push_back(RegData("eventA", "7:0", 0, 0xFF));
   regDataMap["mem_dma_event_channel_selection"].push_back(RegData("S2MM_Sel1_Channel", "10:8", 8, 0x7));
   regDataMap["mem_dma_event_channel_selection"].push_back(RegData("MM2S_Sel0_Channel", "18:16", 16, 0x7));
   regDataMap["mem_dma_event_channel_selection"].push_back(RegData("MM2S_Sel1_Channel", "26:24", 24, 0x7));
   regDataMap["mem_dma_event_channel_selection"].push_back(RegData("S2MM_Sel0_Channel", "2:0", 0, 0x7));
   regDataMap["mem_dma_mm2s_0_constant_pad_value"].push_back(RegData("Constant_Pad_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["mem_dma_mm2s_0_ctrl"].push_back(RegData("Reset", "1", 1, 0x1));
   regDataMap["mem_dma_mm2s_0_ctrl"].push_back(RegData("Controller_ID", "15:8", 8, 0xFF));
   regDataMap["mem_dma_mm2s_0_ctrl"].push_back(RegData("Compression_Enable", "4", 4, 0x1));
   regDataMap["mem_dma_mm2s_0_start_queue"].push_back(RegData("Repeat_Count", "23:16", 16, 0xFF));
   regDataMap["mem_dma_mm2s_0_start_queue"].push_back(RegData("Enable_Token_Issue", "31", 31, 0x1));
   regDataMap["mem_dma_mm2s_0_start_queue"].push_back(RegData("Start_BD_ID", "5:0", 0, 0x3F));
   regDataMap["mem_dma_mm2s_1_constant_pad_value"].push_back(RegData("Constant_Pad_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["mem_dma_mm2s_1_ctrl"].push_back(RegData("Reset", "1", 1, 0x1));
   regDataMap["mem_dma_mm2s_1_ctrl"].push_back(RegData("Controller_ID", "15:8", 8, 0xFF));
   regDataMap["mem_dma_mm2s_1_ctrl"].push_back(RegData("Compression_Enable", "4", 4, 0x1));
   regDataMap["mem_dma_mm2s_1_start_queue"].push_back(RegData("Repeat_Count", "23:16", 16, 0xFF));
   regDataMap["mem_dma_mm2s_1_start_queue"].push_back(RegData("Enable_Token_Issue", "31", 31, 0x1));
   regDataMap["mem_dma_mm2s_1_start_queue"].push_back(RegData("Start_BD_ID", "5:0", 0, 0x3F));
   regDataMap["mem_dma_mm2s_2_constant_pad_value"].push_back(RegData("Constant_Pad_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["mem_dma_mm2s_2_ctrl"].push_back(RegData("Reset", "1", 1, 0x1));
   regDataMap["mem_dma_mm2s_2_ctrl"].push_back(RegData("Controller_ID", "15:8", 8, 0xFF));
   regDataMap["mem_dma_mm2s_2_ctrl"].push_back(RegData("Compression_Enable", "4", 4, 0x1));
   regDataMap["mem_dma_mm2s_2_start_queue"].push_back(RegData("Repeat_Count", "23:16", 16, 0xFF));
   regDataMap["mem_dma_mm2s_2_start_queue"].push_back(RegData("Enable_Token_Issue", "31", 31, 0x1));
   regDataMap["mem_dma_mm2s_2_start_queue"].push_back(RegData("Start_BD_ID", "5:0", 0, 0x3F));
   regDataMap["mem_dma_mm2s_3_constant_pad_value"].push_back(RegData("Constant_Pad_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["mem_dma_mm2s_3_ctrl"].push_back(RegData("Reset", "1", 1, 0x1));
   regDataMap["mem_dma_mm2s_3_ctrl"].push_back(RegData("Controller_ID", "15:8", 8, 0xFF));
   regDataMap["mem_dma_mm2s_3_ctrl"].push_back(RegData("Compression_Enable", "4", 4, 0x1));
   regDataMap["mem_dma_mm2s_3_start_queue"].push_back(RegData("Repeat_Count", "23:16", 16, 0xFF));
   regDataMap["mem_dma_mm2s_3_start_queue"].push_back(RegData("Enable_Token_Issue", "31", 31, 0x1));
   regDataMap["mem_dma_mm2s_3_start_queue"].push_back(RegData("Start_BD_ID", "5:0", 0, 0x3F));
   regDataMap["mem_dma_mm2s_4_constant_pad_value"].push_back(RegData("Constant_Pad_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["mem_dma_mm2s_4_ctrl"].push_back(RegData("Reset", "1", 1, 0x1));
   regDataMap["mem_dma_mm2s_4_ctrl"].push_back(RegData("Controller_ID", "15:8", 8, 0xFF));
   regDataMap["mem_dma_mm2s_4_ctrl"].push_back(RegData("Compression_Enable", "4", 4, 0x1));
   regDataMap["mem_dma_mm2s_4_start_queue"].push_back(RegData("Repeat_Count", "23:16", 16, 0xFF));
   regDataMap["mem_dma_mm2s_4_start_queue"].push_back(RegData("Enable_Token_Issue", "31", 31, 0x1));
   regDataMap["mem_dma_mm2s_4_start_queue"].push_back(RegData("Start_BD_ID", "5:0", 0, 0x3F));
   regDataMap["mem_dma_mm2s_5_constant_pad_value"].push_back(RegData("Constant_Pad_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["mem_dma_mm2s_5_ctrl"].push_back(RegData("Reset", "1", 1, 0x1));
   regDataMap["mem_dma_mm2s_5_ctrl"].push_back(RegData("Controller_ID", "15:8", 8, 0xFF));
   regDataMap["mem_dma_mm2s_5_ctrl"].push_back(RegData("Compression_Enable", "4", 4, 0x1));
   regDataMap["mem_dma_mm2s_5_start_queue"].push_back(RegData("Repeat_Count", "23:16", 16, 0xFF));
   regDataMap["mem_dma_mm2s_5_start_queue"].push_back(RegData("Enable_Token_Issue", "31", 31, 0x1));
   regDataMap["mem_dma_mm2s_5_start_queue"].push_back(RegData("Start_BD_ID", "5:0", 0, 0x3F));
   regDataMap["mem_dma_mm2s_status_0"].push_back(RegData("Error_BD_Unavailable", "10", 10, 0x1));
   regDataMap["mem_dma_mm2s_status_0"].push_back(RegData("Error_BD_Invalid", "11", 11, 0x1));
   regDataMap["mem_dma_mm2s_status_0"].push_back(RegData("Task_Queue_Overflow", "18", 18, 0x1));
   regDataMap["mem_dma_mm2s_status_0"].push_back(RegData("Channel_Running", "19", 19, 0x1));
   regDataMap["mem_dma_mm2s_status_0"].push_back(RegData("Status", "1:0", 0, 0x3));
   regDataMap["mem_dma_mm2s_status_0"].push_back(RegData("Stalled_Lock_Acq", "2", 2, 0x1));
   regDataMap["mem_dma_mm2s_status_0"].push_back(RegData("Task_Queue_Size", "22:20", 20, 0x7));
   regDataMap["mem_dma_mm2s_status_0"].push_back(RegData("Cur_BD", "29:24", 24, 0x3F));
   regDataMap["mem_dma_mm2s_status_0"].push_back(RegData("Stalled_Lock_Rel", "3", 3, 0x1));
   regDataMap["mem_dma_mm2s_status_0"].push_back(RegData("Stalled_Stream_Backpressure", "4", 4, 0x1));
   regDataMap["mem_dma_mm2s_status_0"].push_back(RegData("Stalled_TCT", "5", 5, 0x1));
   regDataMap["mem_dma_mm2s_status_0"].push_back(RegData("Error_Lock_Access_to_Unavailable", "8", 8, 0x1));
   regDataMap["mem_dma_mm2s_status_0"].push_back(RegData("Error_DM_Access_to_Unavailable", "9", 9, 0x1));
   regDataMap["mem_dma_mm2s_status_1"].push_back(RegData("Error_BD_Unavailable", "10", 10, 0x1));
   regDataMap["mem_dma_mm2s_status_1"].push_back(RegData("Error_BD_Invalid", "11", 11, 0x1));
   regDataMap["mem_dma_mm2s_status_1"].push_back(RegData("Task_Queue_Overflow", "18", 18, 0x1));
   regDataMap["mem_dma_mm2s_status_1"].push_back(RegData("Channel_Running", "19", 19, 0x1));
   regDataMap["mem_dma_mm2s_status_1"].push_back(RegData("Status", "1:0", 0, 0x3));
   regDataMap["mem_dma_mm2s_status_1"].push_back(RegData("Stalled_Lock_Acq", "2", 2, 0x1));
   regDataMap["mem_dma_mm2s_status_1"].push_back(RegData("Task_Queue_Size", "22:20", 20, 0x7));
   regDataMap["mem_dma_mm2s_status_1"].push_back(RegData("Cur_BD", "29:24", 24, 0x3F));
   regDataMap["mem_dma_mm2s_status_1"].push_back(RegData("Stalled_Lock_Rel", "3", 3, 0x1));
   regDataMap["mem_dma_mm2s_status_1"].push_back(RegData("Stalled_Stream_Backpressure", "4", 4, 0x1));
   regDataMap["mem_dma_mm2s_status_1"].push_back(RegData("Stalled_TCT", "5", 5, 0x1));
   regDataMap["mem_dma_mm2s_status_1"].push_back(RegData("Error_Lock_Access_to_Unavailable", "8", 8, 0x1));
   regDataMap["mem_dma_mm2s_status_1"].push_back(RegData("Error_DM_Access_to_Unavailable", "9", 9, 0x1));
   regDataMap["mem_dma_mm2s_status_2"].push_back(RegData("Error_BD_Unavailable", "10", 10, 0x1));
   regDataMap["mem_dma_mm2s_status_2"].push_back(RegData("Error_BD_Invalid", "11", 11, 0x1));
   regDataMap["mem_dma_mm2s_status_2"].push_back(RegData("Task_Queue_Overflow", "18", 18, 0x1));
   regDataMap["mem_dma_mm2s_status_2"].push_back(RegData("Channel_Running", "19", 19, 0x1));
   regDataMap["mem_dma_mm2s_status_2"].push_back(RegData("Status", "1:0", 0, 0x3));
   regDataMap["mem_dma_mm2s_status_2"].push_back(RegData("Stalled_Lock_Acq", "2", 2, 0x1));
   regDataMap["mem_dma_mm2s_status_2"].push_back(RegData("Task_Queue_Size", "22:20", 20, 0x7));
   regDataMap["mem_dma_mm2s_status_2"].push_back(RegData("Cur_BD", "29:24", 24, 0x3F));
   regDataMap["mem_dma_mm2s_status_2"].push_back(RegData("Stalled_Lock_Rel", "3", 3, 0x1));
   regDataMap["mem_dma_mm2s_status_2"].push_back(RegData("Stalled_Stream_Backpressure", "4", 4, 0x1));
   regDataMap["mem_dma_mm2s_status_2"].push_back(RegData("Stalled_TCT", "5", 5, 0x1));
   regDataMap["mem_dma_mm2s_status_2"].push_back(RegData("Error_Lock_Access_to_Unavailable", "8", 8, 0x1));
   regDataMap["mem_dma_mm2s_status_2"].push_back(RegData("Error_DM_Access_to_Unavailable", "9", 9, 0x1));
   regDataMap["mem_dma_mm2s_status_3"].push_back(RegData("Error_BD_Unavailable", "10", 10, 0x1));
   regDataMap["mem_dma_mm2s_status_3"].push_back(RegData("Error_BD_Invalid", "11", 11, 0x1));
   regDataMap["mem_dma_mm2s_status_3"].push_back(RegData("Task_Queue_Overflow", "18", 18, 0x1));
   regDataMap["mem_dma_mm2s_status_3"].push_back(RegData("Channel_Running", "19", 19, 0x1));
   regDataMap["mem_dma_mm2s_status_3"].push_back(RegData("Status", "1:0", 0, 0x3));
   regDataMap["mem_dma_mm2s_status_3"].push_back(RegData("Stalled_Lock_Acq", "2", 2, 0x1));
   regDataMap["mem_dma_mm2s_status_3"].push_back(RegData("Task_Queue_Size", "22:20", 20, 0x7));
   regDataMap["mem_dma_mm2s_status_3"].push_back(RegData("Cur_BD", "29:24", 24, 0x3F));
   regDataMap["mem_dma_mm2s_status_3"].push_back(RegData("Stalled_Lock_Rel", "3", 3, 0x1));
   regDataMap["mem_dma_mm2s_status_3"].push_back(RegData("Stalled_Stream_Backpressure", "4", 4, 0x1));
   regDataMap["mem_dma_mm2s_status_3"].push_back(RegData("Stalled_TCT", "5", 5, 0x1));
   regDataMap["mem_dma_mm2s_status_3"].push_back(RegData("Error_Lock_Access_to_Unavailable", "8", 8, 0x1));
   regDataMap["mem_dma_mm2s_status_3"].push_back(RegData("Error_DM_Access_to_Unavailable", "9", 9, 0x1));
   regDataMap["mem_dma_mm2s_status_4"].push_back(RegData("Error_BD_Unavailable", "10", 10, 0x1));
   regDataMap["mem_dma_mm2s_status_4"].push_back(RegData("Error_BD_Invalid", "11", 11, 0x1));
   regDataMap["mem_dma_mm2s_status_4"].push_back(RegData("Task_Queue_Overflow", "18", 18, 0x1));
   regDataMap["mem_dma_mm2s_status_4"].push_back(RegData("Channel_Running", "19", 19, 0x1));
   regDataMap["mem_dma_mm2s_status_4"].push_back(RegData("Status", "1:0", 0, 0x3));
   regDataMap["mem_dma_mm2s_status_4"].push_back(RegData("Stalled_Lock_Acq", "2", 2, 0x1));
   regDataMap["mem_dma_mm2s_status_4"].push_back(RegData("Task_Queue_Size", "22:20", 20, 0x7));
   regDataMap["mem_dma_mm2s_status_4"].push_back(RegData("Cur_BD", "29:24", 24, 0x3F));
   regDataMap["mem_dma_mm2s_status_4"].push_back(RegData("Stalled_Lock_Rel", "3", 3, 0x1));
   regDataMap["mem_dma_mm2s_status_4"].push_back(RegData("Stalled_Stream_Backpressure", "4", 4, 0x1));
   regDataMap["mem_dma_mm2s_status_4"].push_back(RegData("Stalled_TCT", "5", 5, 0x1));
   regDataMap["mem_dma_mm2s_status_4"].push_back(RegData("Error_Lock_Access_to_Unavailable", "8", 8, 0x1));
   regDataMap["mem_dma_mm2s_status_4"].push_back(RegData("Error_DM_Access_to_Unavailable", "9", 9, 0x1));
   regDataMap["mem_dma_mm2s_status_5"].push_back(RegData("Error_BD_Unavailable", "10", 10, 0x1));
   regDataMap["mem_dma_mm2s_status_5"].push_back(RegData("Error_BD_Invalid", "11", 11, 0x1));
   regDataMap["mem_dma_mm2s_status_5"].push_back(RegData("Task_Queue_Overflow", "18", 18, 0x1));
   regDataMap["mem_dma_mm2s_status_5"].push_back(RegData("Channel_Running", "19", 19, 0x1));
   regDataMap["mem_dma_mm2s_status_5"].push_back(RegData("Status", "1:0", 0, 0x3));
   regDataMap["mem_dma_mm2s_status_5"].push_back(RegData("Stalled_Lock_Acq", "2", 2, 0x1));
   regDataMap["mem_dma_mm2s_status_5"].push_back(RegData("Task_Queue_Size", "22:20", 20, 0x7));
   regDataMap["mem_dma_mm2s_status_5"].push_back(RegData("Cur_BD", "29:24", 24, 0x3F));
   regDataMap["mem_dma_mm2s_status_5"].push_back(RegData("Stalled_Lock_Rel", "3", 3, 0x1));
   regDataMap["mem_dma_mm2s_status_5"].push_back(RegData("Stalled_Stream_Backpressure", "4", 4, 0x1));
   regDataMap["mem_dma_mm2s_status_5"].push_back(RegData("Stalled_TCT", "5", 5, 0x1));
   regDataMap["mem_dma_mm2s_status_5"].push_back(RegData("Error_Lock_Access_to_Unavailable", "8", 8, 0x1));
   regDataMap["mem_dma_mm2s_status_5"].push_back(RegData("Error_DM_Access_to_Unavailable", "9", 9, 0x1));
   regDataMap["mem_dma_s2mm_0_ctrl"].push_back(RegData("Reset", "1", 1, 0x1));
   regDataMap["mem_dma_s2mm_0_ctrl"].push_back(RegData("Controller_ID", "15:8", 8, 0xFF));
   regDataMap["mem_dma_s2mm_0_ctrl"].push_back(RegData("FoT_Mode", "17:16", 16, 0x3));
   regDataMap["mem_dma_s2mm_0_ctrl"].push_back(RegData("Enable_Out_of_Order", "3", 3, 0x1));
   regDataMap["mem_dma_s2mm_0_ctrl"].push_back(RegData("Decompression_Enable", "4", 4, 0x1));
   regDataMap["mem_dma_s2mm_0_start_queue"].push_back(RegData("Repeat_Count", "23:16", 16, 0xFF));
   regDataMap["mem_dma_s2mm_0_start_queue"].push_back(RegData("Enable_Token_Issue", "31", 31, 0x1));
   regDataMap["mem_dma_s2mm_0_start_queue"].push_back(RegData("Start_BD_ID", "5:0", 0, 0x3F));
   regDataMap["mem_dma_s2mm_1_ctrl"].push_back(RegData("Reset", "1", 1, 0x1));
   regDataMap["mem_dma_s2mm_1_ctrl"].push_back(RegData("Controller_ID", "15:8", 8, 0xFF));
   regDataMap["mem_dma_s2mm_1_ctrl"].push_back(RegData("FoT_Mode", "17:16", 16, 0x3));
   regDataMap["mem_dma_s2mm_1_ctrl"].push_back(RegData("Enable_Out_of_Order", "3", 3, 0x1));
   regDataMap["mem_dma_s2mm_1_ctrl"].push_back(RegData("Decompression_Enable", "4", 4, 0x1));
   regDataMap["mem_dma_s2mm_1_start_queue"].push_back(RegData("Repeat_Count", "23:16", 16, 0xFF));
   regDataMap["mem_dma_s2mm_1_start_queue"].push_back(RegData("Enable_Token_Issue", "31", 31, 0x1));
   regDataMap["mem_dma_s2mm_1_start_queue"].push_back(RegData("Start_BD_ID", "5:0", 0, 0x3F));
   regDataMap["mem_dma_s2mm_2_ctrl"].push_back(RegData("Reset", "1", 1, 0x1));
   regDataMap["mem_dma_s2mm_2_ctrl"].push_back(RegData("Controller_ID", "15:8", 8, 0xFF));
   regDataMap["mem_dma_s2mm_2_ctrl"].push_back(RegData("FoT_Mode", "17:16", 16, 0x3));
   regDataMap["mem_dma_s2mm_2_ctrl"].push_back(RegData("Enable_Out_of_Order", "3", 3, 0x1));
   regDataMap["mem_dma_s2mm_2_ctrl"].push_back(RegData("Decompression_Enable", "4", 4, 0x1));
   regDataMap["mem_dma_s2mm_2_start_queue"].push_back(RegData("Repeat_Count", "23:16", 16, 0xFF));
   regDataMap["mem_dma_s2mm_2_start_queue"].push_back(RegData("Enable_Token_Issue", "31", 31, 0x1));
   regDataMap["mem_dma_s2mm_2_start_queue"].push_back(RegData("Start_BD_ID", "5:0", 0, 0x3F));
   regDataMap["mem_dma_s2mm_3_ctrl"].push_back(RegData("Reset", "1", 1, 0x1));
   regDataMap["mem_dma_s2mm_3_ctrl"].push_back(RegData("Controller_ID", "15:8", 8, 0xFF));
   regDataMap["mem_dma_s2mm_3_ctrl"].push_back(RegData("FoT_Mode", "17:16", 16, 0x3));
   regDataMap["mem_dma_s2mm_3_ctrl"].push_back(RegData("Enable_Out_of_Order", "3", 3, 0x1));
   regDataMap["mem_dma_s2mm_3_ctrl"].push_back(RegData("Decompression_Enable", "4", 4, 0x1));
   regDataMap["mem_dma_s2mm_3_start_queue"].push_back(RegData("Repeat_Count", "23:16", 16, 0xFF));
   regDataMap["mem_dma_s2mm_3_start_queue"].push_back(RegData("Enable_Token_Issue", "31", 31, 0x1));
   regDataMap["mem_dma_s2mm_3_start_queue"].push_back(RegData("Start_BD_ID", "5:0", 0, 0x3F));
   regDataMap["mem_dma_s2mm_4_ctrl"].push_back(RegData("Reset", "1", 1, 0x1));
   regDataMap["mem_dma_s2mm_4_ctrl"].push_back(RegData("Controller_ID", "15:8", 8, 0xFF));
   regDataMap["mem_dma_s2mm_4_ctrl"].push_back(RegData("FoT_Mode", "17:16", 16, 0x3));
   regDataMap["mem_dma_s2mm_4_ctrl"].push_back(RegData("Enable_Out_of_Order", "3", 3, 0x1));
   regDataMap["mem_dma_s2mm_4_ctrl"].push_back(RegData("Decompression_Enable", "4", 4, 0x1));
   regDataMap["mem_dma_s2mm_4_start_queue"].push_back(RegData("Repeat_Count", "23:16", 16, 0xFF));
   regDataMap["mem_dma_s2mm_4_start_queue"].push_back(RegData("Enable_Token_Issue", "31", 31, 0x1));
   regDataMap["mem_dma_s2mm_4_start_queue"].push_back(RegData("Start_BD_ID", "5:0", 0, 0x3F));
   regDataMap["mem_dma_s2mm_5_ctrl"].push_back(RegData("Reset", "1", 1, 0x1));
   regDataMap["mem_dma_s2mm_5_ctrl"].push_back(RegData("Controller_ID", "15:8", 8, 0xFF));
   regDataMap["mem_dma_s2mm_5_ctrl"].push_back(RegData("FoT_Mode", "17:16", 16, 0x3));
   regDataMap["mem_dma_s2mm_5_ctrl"].push_back(RegData("Enable_Out_of_Order", "3", 3, 0x1));
   regDataMap["mem_dma_s2mm_5_ctrl"].push_back(RegData("Decompression_Enable", "4", 4, 0x1));
   regDataMap["mem_dma_s2mm_5_start_queue"].push_back(RegData("Repeat_Count", "23:16", 16, 0xFF));
   regDataMap["mem_dma_s2mm_5_start_queue"].push_back(RegData("Enable_Token_Issue", "31", 31, 0x1));
   regDataMap["mem_dma_s2mm_5_start_queue"].push_back(RegData("Start_BD_ID", "5:0", 0, 0x3F));
   regDataMap["mem_dma_s2mm_current_write_count_0"].push_back(RegData("Current_Write_Count", "16:0", 0, 0x1FFFF));
   regDataMap["mem_dma_s2mm_current_write_count_1"].push_back(RegData("Current_Write_Count", "16:0", 0, 0x1FFFF));
   regDataMap["mem_dma_s2mm_current_write_count_2"].push_back(RegData("Current_Write_Count", "16:0", 0, 0x1FFFF));
   regDataMap["mem_dma_s2mm_current_write_count_3"].push_back(RegData("Current_Write_Count", "16:0", 0, 0x1FFFF));
   regDataMap["mem_dma_s2mm_current_write_count_4"].push_back(RegData("Current_Write_Count", "16:0", 0, 0x1FFFF));
   regDataMap["mem_dma_s2mm_current_write_count_5"].push_back(RegData("Current_Write_Count", "16:0", 0, 0x1FFFF));
   regDataMap["mem_dma_s2mm_fot_count_fifo_pop_0"].push_back(RegData("Write_Count", "17:0", 0, 0x3FFFF));
   regDataMap["mem_dma_s2mm_fot_count_fifo_pop_0"].push_back(RegData("BD_ID", "29:24", 24, 0x3F));
   regDataMap["mem_dma_s2mm_fot_count_fifo_pop_0"].push_back(RegData("Last_in_Task", "30", 30, 0x1));
   regDataMap["mem_dma_s2mm_fot_count_fifo_pop_0"].push_back(RegData("Valid", "31", 31, 0x1));
   regDataMap["mem_dma_s2mm_fot_count_fifo_pop_1"].push_back(RegData("Write_Count", "17:0", 0, 0x3FFFF));
   regDataMap["mem_dma_s2mm_fot_count_fifo_pop_1"].push_back(RegData("BD_ID", "29:24", 24, 0x3F));
   regDataMap["mem_dma_s2mm_fot_count_fifo_pop_1"].push_back(RegData("Last_in_Task", "30", 30, 0x1));
   regDataMap["mem_dma_s2mm_fot_count_fifo_pop_1"].push_back(RegData("Valid", "31", 31, 0x1));
   regDataMap["mem_dma_s2mm_fot_count_fifo_pop_2"].push_back(RegData("Write_Count", "17:0", 0, 0x3FFFF));
   regDataMap["mem_dma_s2mm_fot_count_fifo_pop_2"].push_back(RegData("BD_ID", "29:24", 24, 0x3F));
   regDataMap["mem_dma_s2mm_fot_count_fifo_pop_2"].push_back(RegData("Last_in_Task", "30", 30, 0x1));
   regDataMap["mem_dma_s2mm_fot_count_fifo_pop_2"].push_back(RegData("Valid", "31", 31, 0x1));
   regDataMap["mem_dma_s2mm_fot_count_fifo_pop_3"].push_back(RegData("Write_Count", "17:0", 0, 0x3FFFF));
   regDataMap["mem_dma_s2mm_fot_count_fifo_pop_3"].push_back(RegData("BD_ID", "29:24", 24, 0x3F));
   regDataMap["mem_dma_s2mm_fot_count_fifo_pop_3"].push_back(RegData("Last_in_Task", "30", 30, 0x1));
   regDataMap["mem_dma_s2mm_fot_count_fifo_pop_3"].push_back(RegData("Valid", "31", 31, 0x1));
   regDataMap["mem_dma_s2mm_fot_count_fifo_pop_4"].push_back(RegData("Write_Count", "17:0", 0, 0x3FFFF));
   regDataMap["mem_dma_s2mm_fot_count_fifo_pop_4"].push_back(RegData("BD_ID", "29:24", 24, 0x3F));
   regDataMap["mem_dma_s2mm_fot_count_fifo_pop_4"].push_back(RegData("Last_in_Task", "30", 30, 0x1));
   regDataMap["mem_dma_s2mm_fot_count_fifo_pop_4"].push_back(RegData("Valid", "31", 31, 0x1));
   regDataMap["mem_dma_s2mm_fot_count_fifo_pop_5"].push_back(RegData("Write_Count", "17:0", 0, 0x3FFFF));
   regDataMap["mem_dma_s2mm_fot_count_fifo_pop_5"].push_back(RegData("BD_ID", "29:24", 24, 0x3F));
   regDataMap["mem_dma_s2mm_fot_count_fifo_pop_5"].push_back(RegData("Last_in_Task", "30", 30, 0x1));
   regDataMap["mem_dma_s2mm_fot_count_fifo_pop_5"].push_back(RegData("Valid", "31", 31, 0x1));
   regDataMap["mem_dma_s2mm_status_0"].push_back(RegData("Error_BD_Unavailable", "10", 10, 0x1));
   regDataMap["mem_dma_s2mm_status_0"].push_back(RegData("Error_BD_Invalid", "11", 11, 0x1));
   regDataMap["mem_dma_s2mm_status_0"].push_back(RegData("Error_FoT_Length_Exceeded", "12", 12, 0x1));
   regDataMap["mem_dma_s2mm_status_0"].push_back(RegData("Error_FoT_BDs_per_Task", "13", 13, 0x1));
   regDataMap["mem_dma_s2mm_status_0"].push_back(RegData("Task_Queue_Overflow", "18", 18, 0x1));
   regDataMap["mem_dma_s2mm_status_0"].push_back(RegData("Channel_Running", "19", 19, 0x1));
   regDataMap["mem_dma_s2mm_status_0"].push_back(RegData("Status", "1:0", 0, 0x3));
   regDataMap["mem_dma_s2mm_status_0"].push_back(RegData("Stalled_Lock_Acq", "2", 2, 0x1));
   regDataMap["mem_dma_s2mm_status_0"].push_back(RegData("Task_Queue_Size", "22:20", 20, 0x7));
   regDataMap["mem_dma_s2mm_status_0"].push_back(RegData("Cur_BD", "29:24", 24, 0x3F));
   regDataMap["mem_dma_s2mm_status_0"].push_back(RegData("Stalled_Lock_Rel", "3", 3, 0x1));
   regDataMap["mem_dma_s2mm_status_0"].push_back(RegData("Stalled_Stream_Starvation", "4", 4, 0x1));
   regDataMap["mem_dma_s2mm_status_0"].push_back(RegData("Stalled_TCT_or_Count_FIFO_Full", "5", 5, 0x1));
   regDataMap["mem_dma_s2mm_status_0"].push_back(RegData("Error_Lock_Access_to_Unavailable", "8", 8, 0x1));
   regDataMap["mem_dma_s2mm_status_0"].push_back(RegData("Error_DM_Access_to_Unavailable", "9", 9, 0x1));
   regDataMap["mem_dma_s2mm_status_1"].push_back(RegData("Error_BD_Unavailable", "10", 10, 0x1));
   regDataMap["mem_dma_s2mm_status_1"].push_back(RegData("Error_BD_Invalid", "11", 11, 0x1));
   regDataMap["mem_dma_s2mm_status_1"].push_back(RegData("Error_FoT_Length_Exceeded", "12", 12, 0x1));
   regDataMap["mem_dma_s2mm_status_1"].push_back(RegData("Error_FoT_BDs_per_Task", "13", 13, 0x1));
   regDataMap["mem_dma_s2mm_status_1"].push_back(RegData("Task_Queue_Overflow", "18", 18, 0x1));
   regDataMap["mem_dma_s2mm_status_1"].push_back(RegData("Channel_Running", "19", 19, 0x1));
   regDataMap["mem_dma_s2mm_status_1"].push_back(RegData("Status", "1:0", 0, 0x3));
   regDataMap["mem_dma_s2mm_status_1"].push_back(RegData("Stalled_Lock_Acq", "2", 2, 0x1));
   regDataMap["mem_dma_s2mm_status_1"].push_back(RegData("Task_Queue_Size", "22:20", 20, 0x7));
   regDataMap["mem_dma_s2mm_status_1"].push_back(RegData("Cur_BD", "29:24", 24, 0x3F));
   regDataMap["mem_dma_s2mm_status_1"].push_back(RegData("Stalled_Lock_Rel", "3", 3, 0x1));
   regDataMap["mem_dma_s2mm_status_1"].push_back(RegData("Stalled_Stream_Starvation", "4", 4, 0x1));
   regDataMap["mem_dma_s2mm_status_1"].push_back(RegData("Stalled_TCT_or_Count_FIFO_Full", "5", 5, 0x1));
   regDataMap["mem_dma_s2mm_status_1"].push_back(RegData("Error_Lock_Access_to_Unavailable", "8", 8, 0x1));
   regDataMap["mem_dma_s2mm_status_1"].push_back(RegData("Error_DM_Access_to_Unavailable", "9", 9, 0x1));
   regDataMap["mem_dma_s2mm_status_2"].push_back(RegData("Error_BD_Unavailable", "10", 10, 0x1));
   regDataMap["mem_dma_s2mm_status_2"].push_back(RegData("Error_BD_Invalid", "11", 11, 0x1));
   regDataMap["mem_dma_s2mm_status_2"].push_back(RegData("Error_FoT_Length_Exceeded", "12", 12, 0x1));
   regDataMap["mem_dma_s2mm_status_2"].push_back(RegData("Error_FoT_BDs_per_Task", "13", 13, 0x1));
   regDataMap["mem_dma_s2mm_status_2"].push_back(RegData("Task_Queue_Overflow", "18", 18, 0x1));
   regDataMap["mem_dma_s2mm_status_2"].push_back(RegData("Channel_Running", "19", 19, 0x1));
   regDataMap["mem_dma_s2mm_status_2"].push_back(RegData("Status", "1:0", 0, 0x3));
   regDataMap["mem_dma_s2mm_status_2"].push_back(RegData("Stalled_Lock_Acq", "2", 2, 0x1));
   regDataMap["mem_dma_s2mm_status_2"].push_back(RegData("Task_Queue_Size", "22:20", 20, 0x7));
   regDataMap["mem_dma_s2mm_status_2"].push_back(RegData("Cur_BD", "29:24", 24, 0x3F));
   regDataMap["mem_dma_s2mm_status_2"].push_back(RegData("Stalled_Lock_Rel", "3", 3, 0x1));
   regDataMap["mem_dma_s2mm_status_2"].push_back(RegData("Stalled_Stream_Starvation", "4", 4, 0x1));
   regDataMap["mem_dma_s2mm_status_2"].push_back(RegData("Stalled_TCT_or_Count_FIFO_Full", "5", 5, 0x1));
   regDataMap["mem_dma_s2mm_status_2"].push_back(RegData("Error_Lock_Access_to_Unavailable", "8", 8, 0x1));
   regDataMap["mem_dma_s2mm_status_2"].push_back(RegData("Error_DM_Access_to_Unavailable", "9", 9, 0x1));
   regDataMap["mem_dma_s2mm_status_3"].push_back(RegData("Error_BD_Unavailable", "10", 10, 0x1));
   regDataMap["mem_dma_s2mm_status_3"].push_back(RegData("Error_BD_Invalid", "11", 11, 0x1));
   regDataMap["mem_dma_s2mm_status_3"].push_back(RegData("Error_FoT_Length_Exceeded", "12", 12, 0x1));
   regDataMap["mem_dma_s2mm_status_3"].push_back(RegData("Error_FoT_BDs_per_Task", "13", 13, 0x1));
   regDataMap["mem_dma_s2mm_status_3"].push_back(RegData("Task_Queue_Overflow", "18", 18, 0x1));
   regDataMap["mem_dma_s2mm_status_3"].push_back(RegData("Channel_Running", "19", 19, 0x1));
   regDataMap["mem_dma_s2mm_status_3"].push_back(RegData("Status", "1:0", 0, 0x3));
   regDataMap["mem_dma_s2mm_status_3"].push_back(RegData("Stalled_Lock_Acq", "2", 2, 0x1));
   regDataMap["mem_dma_s2mm_status_3"].push_back(RegData("Task_Queue_Size", "22:20", 20, 0x7));
   regDataMap["mem_dma_s2mm_status_3"].push_back(RegData("Cur_BD", "29:24", 24, 0x3F));
   regDataMap["mem_dma_s2mm_status_3"].push_back(RegData("Stalled_Lock_Rel", "3", 3, 0x1));
   regDataMap["mem_dma_s2mm_status_3"].push_back(RegData("Stalled_Stream_Starvation", "4", 4, 0x1));
   regDataMap["mem_dma_s2mm_status_3"].push_back(RegData("Stalled_TCT_or_Count_FIFO_Full", "5", 5, 0x1));
   regDataMap["mem_dma_s2mm_status_3"].push_back(RegData("Error_Lock_Access_to_Unavailable", "8", 8, 0x1));
   regDataMap["mem_dma_s2mm_status_3"].push_back(RegData("Error_DM_Access_to_Unavailable", "9", 9, 0x1));
   regDataMap["mem_dma_s2mm_status_4"].push_back(RegData("Error_BD_Unavailable", "10", 10, 0x1));
   regDataMap["mem_dma_s2mm_status_4"].push_back(RegData("Error_BD_Invalid", "11", 11, 0x1));
   regDataMap["mem_dma_s2mm_status_4"].push_back(RegData("Error_FoT_Length_Exceeded", "12", 12, 0x1));
   regDataMap["mem_dma_s2mm_status_4"].push_back(RegData("Error_FoT_BDs_per_Task", "13", 13, 0x1));
   regDataMap["mem_dma_s2mm_status_4"].push_back(RegData("Task_Queue_Overflow", "18", 18, 0x1));
   regDataMap["mem_dma_s2mm_status_4"].push_back(RegData("Channel_Running", "19", 19, 0x1));
   regDataMap["mem_dma_s2mm_status_4"].push_back(RegData("Status", "1:0", 0, 0x3));
   regDataMap["mem_dma_s2mm_status_4"].push_back(RegData("Stalled_Lock_Acq", "2", 2, 0x1));
   regDataMap["mem_dma_s2mm_status_4"].push_back(RegData("Task_Queue_Size", "22:20", 20, 0x7));
   regDataMap["mem_dma_s2mm_status_4"].push_back(RegData("Cur_BD", "29:24", 24, 0x3F));
   regDataMap["mem_dma_s2mm_status_4"].push_back(RegData("Stalled_Lock_Rel", "3", 3, 0x1));
   regDataMap["mem_dma_s2mm_status_4"].push_back(RegData("Stalled_Stream_Starvation", "4", 4, 0x1));
   regDataMap["mem_dma_s2mm_status_4"].push_back(RegData("Stalled_TCT_or_Count_FIFO_Full", "5", 5, 0x1));
   regDataMap["mem_dma_s2mm_status_4"].push_back(RegData("Error_Lock_Access_to_Unavailable", "8", 8, 0x1));
   regDataMap["mem_dma_s2mm_status_4"].push_back(RegData("Error_DM_Access_to_Unavailable", "9", 9, 0x1));
   regDataMap["mem_dma_s2mm_status_5"].push_back(RegData("Error_BD_Unavailable", "10", 10, 0x1));
   regDataMap["mem_dma_s2mm_status_5"].push_back(RegData("Error_BD_Invalid", "11", 11, 0x1));
   regDataMap["mem_dma_s2mm_status_5"].push_back(RegData("Error_FoT_Length_Exceeded", "12", 12, 0x1));
   regDataMap["mem_dma_s2mm_status_5"].push_back(RegData("Error_FoT_BDs_per_Task", "13", 13, 0x1));
   regDataMap["mem_dma_s2mm_status_5"].push_back(RegData("Task_Queue_Overflow", "18", 18, 0x1));
   regDataMap["mem_dma_s2mm_status_5"].push_back(RegData("Channel_Running", "19", 19, 0x1));
   regDataMap["mem_dma_s2mm_status_5"].push_back(RegData("Status", "1:0", 0, 0x3));
   regDataMap["mem_dma_s2mm_status_5"].push_back(RegData("Stalled_Lock_Acq", "2", 2, 0x1));
   regDataMap["mem_dma_s2mm_status_5"].push_back(RegData("Task_Queue_Size", "22:20", 20, 0x7));
   regDataMap["mem_dma_s2mm_status_5"].push_back(RegData("Cur_BD", "29:24", 24, 0x3F));
   regDataMap["mem_dma_s2mm_status_5"].push_back(RegData("Stalled_Lock_Rel", "3", 3, 0x1));
   regDataMap["mem_dma_s2mm_status_5"].push_back(RegData("Stalled_Stream_Starvation", "4", 4, 0x1));
   regDataMap["mem_dma_s2mm_status_5"].push_back(RegData("Stalled_TCT_or_Count_FIFO_Full", "5", 5, 0x1));
   regDataMap["mem_dma_s2mm_status_5"].push_back(RegData("Error_Lock_Access_to_Unavailable", "8", 8, 0x1));
   regDataMap["mem_dma_s2mm_status_5"].push_back(RegData("Error_DM_Access_to_Unavailable", "9", 9, 0x1));
   regDataMap["mem_ecc_failing_address"].push_back(RegData("ECC_Error_Detection_Address", "18:0", 0, 0x7FFFF));
   regDataMap["mem_ecc_failing_address"].push_back(RegData("Valid", "19", 19, 0x1));
   regDataMap["mem_ecc_scrubbing_event"].push_back(RegData("Scrubbing_Event_Number", "7:0", 0, 0xFF));
   regDataMap["mem_edge_detection_event_control"].push_back(RegData("Edge_Detection_0_Trigger_Falling", "10", 10, 0x1));
   regDataMap["mem_edge_detection_event_control"].push_back(RegData("Edge_Detection_Event_1", "23:16", 16, 0xFF));
   regDataMap["mem_edge_detection_event_control"].push_back(RegData("Edge_Detection_1_Trigger_Rising", "25", 25, 0x1));
   regDataMap["mem_edge_detection_event_control"].push_back(RegData("Edge_Detection_1_Trigger_Falling", "26", 26, 0x1));
   regDataMap["mem_edge_detection_event_control"].push_back(RegData("Edge_Detection_Event_0", "7:0", 0, 0xFF));
   regDataMap["mem_edge_detection_event_control"].push_back(RegData("Edge_Detection_0_Trigger_Rising", "9", 9, 0x1));
   regDataMap["mem_event_broadcast0"].push_back(RegData("Event", "7:0", 0, 0xFF));
   regDataMap["mem_event_broadcast1"].push_back(RegData("Event", "7:0", 0, 0xFF));
   regDataMap["mem_event_broadcast10"].push_back(RegData("Event", "7:0", 0, 0xFF));
   regDataMap["mem_event_broadcast11"].push_back(RegData("Event", "7:0", 0, 0xFF));
   regDataMap["mem_event_broadcast12"].push_back(RegData("Event", "7:0", 0, 0xFF));
   regDataMap["mem_event_broadcast13"].push_back(RegData("Event", "7:0", 0, 0xFF));
   regDataMap["mem_event_broadcast14"].push_back(RegData("Event", "7:0", 0, 0xFF));
   regDataMap["mem_event_broadcast15"].push_back(RegData("Event", "7:0", 0, 0xFF));
   regDataMap["mem_event_broadcast2"].push_back(RegData("Event", "7:0", 0, 0xFF));
   regDataMap["mem_event_broadcast3"].push_back(RegData("Event", "7:0", 0, 0xFF));
   regDataMap["mem_event_broadcast4"].push_back(RegData("Event", "7:0", 0, 0xFF));
   regDataMap["mem_event_broadcast5"].push_back(RegData("Event", "7:0", 0, 0xFF));
   regDataMap["mem_event_broadcast6"].push_back(RegData("Event", "7:0", 0, 0xFF));
   regDataMap["mem_event_broadcast7"].push_back(RegData("Event", "7:0", 0, 0xFF));
   regDataMap["mem_event_broadcast8"].push_back(RegData("Event", "7:0", 0, 0xFF));
   regDataMap["mem_event_broadcast9"].push_back(RegData("Event", "7:0", 0, 0xFF));
   regDataMap["mem_event_broadcast_a_block_east_clr"].push_back(RegData("Clear", "15:0", 0, 0xFFFF));
   regDataMap["mem_event_broadcast_a_block_east_set"].push_back(RegData("Set", "15:0", 0, 0xFFFF));
   regDataMap["mem_event_broadcast_a_block_east_value"].push_back(RegData("Value", "15:0", 0, 0xFFFF));
   regDataMap["mem_event_broadcast_a_block_north_clr"].push_back(RegData("Clear", "15:0", 0, 0xFFFF));
   regDataMap["mem_event_broadcast_a_block_north_set"].push_back(RegData("Set", "15:0", 0, 0xFFFF));
   regDataMap["mem_event_broadcast_a_block_north_value"].push_back(RegData("Value", "15:0", 0, 0xFFFF));
   regDataMap["mem_event_broadcast_a_block_south_clr"].push_back(RegData("Clear", "15:0", 0, 0xFFFF));
   regDataMap["mem_event_broadcast_a_block_south_set"].push_back(RegData("Set", "15:0", 0, 0xFFFF));
   regDataMap["mem_event_broadcast_a_block_south_value"].push_back(RegData("Value", "15:0", 0, 0xFFFF));
   regDataMap["mem_event_broadcast_a_block_west_clr"].push_back(RegData("Clear", "15:0", 0, 0xFFFF));
   regDataMap["mem_event_broadcast_a_block_west_set"].push_back(RegData("Set", "15:0", 0, 0xFFFF));
   regDataMap["mem_event_broadcast_a_block_west_value"].push_back(RegData("Value", "15:0", 0, 0xFFFF));
   regDataMap["mem_event_broadcast_b_block_east_clr"].push_back(RegData("Clear", "15:0", 0, 0xFFFF));
   regDataMap["mem_event_broadcast_b_block_east_set"].push_back(RegData("Set", "15:0", 0, 0xFFFF));
   regDataMap["mem_event_broadcast_b_block_east_value"].push_back(RegData("Value", "15:0", 0, 0xFFFF));
   regDataMap["mem_event_broadcast_b_block_north_clr"].push_back(RegData("Clear", "15:0", 0, 0xFFFF));
   regDataMap["mem_event_broadcast_b_block_north_set"].push_back(RegData("Set", "15:0", 0, 0xFFFF));
   regDataMap["mem_event_broadcast_b_block_north_value"].push_back(RegData("Value", "15:0", 0, 0xFFFF));
   regDataMap["mem_event_broadcast_b_block_south_clr"].push_back(RegData("Clear", "15:0", 0, 0xFFFF));
   regDataMap["mem_event_broadcast_b_block_south_set"].push_back(RegData("Set", "15:0", 0, 0xFFFF));
   regDataMap["mem_event_broadcast_b_block_south_value"].push_back(RegData("Value", "15:0", 0, 0xFFFF));
   regDataMap["mem_event_broadcast_b_block_west_clr"].push_back(RegData("Clear", "15:0", 0, 0xFFFF));
   regDataMap["mem_event_broadcast_b_block_west_set"].push_back(RegData("Set", "15:0", 0, 0xFFFF));
   regDataMap["mem_event_broadcast_b_block_west_value"].push_back(RegData("Value", "15:0", 0, 0xFFFF));
   regDataMap["mem_event_generate"].push_back(RegData("Event", "7:0", 0, 0xFF));
   regDataMap["mem_event_group_0_enable"].push_back(RegData("Timer_Sync", "0", 0, 0x1));
   regDataMap["mem_event_group_0_enable"].push_back(RegData("Timer_Value_Reached", "1", 1, 0x1));
   regDataMap["mem_event_group_0_enable"].push_back(RegData("Edge_Detection_Event_0", "10", 10, 0x1));
   regDataMap["mem_event_group_0_enable"].push_back(RegData("Edge_Detection_Event_1", "11", 11, 0x1));
   regDataMap["mem_event_group_0_enable"].push_back(RegData("Perf_Cnt0_Event", "2", 2, 0x1));
   regDataMap["mem_event_group_0_enable"].push_back(RegData("Perf_Cnt1_Event", "3", 3, 0x1));
   regDataMap["mem_event_group_0_enable"].push_back(RegData("Perf_Cnt2_Event", "4", 4, 0x1));
   regDataMap["mem_event_group_0_enable"].push_back(RegData("Perf_Cnt3_Event", "5", 5, 0x1));
   regDataMap["mem_event_group_0_enable"].push_back(RegData("Combo_Event_0", "6", 6, 0x1));
   regDataMap["mem_event_group_0_enable"].push_back(RegData("Combo_Event_1", "7", 7, 0x1));
   regDataMap["mem_event_group_0_enable"].push_back(RegData("Combo_Event_2", "8", 8, 0x1));
   regDataMap["mem_event_group_0_enable"].push_back(RegData("Combo_Event_3", "9", 9, 0x1));
   regDataMap["mem_event_group_broadcast_enable"].push_back(RegData("Broadcast_A_0", "0", 0, 0x1));
   regDataMap["mem_event_group_broadcast_enable"].push_back(RegData("Broadcast_A_1", "1", 1, 0x1));
   regDataMap["mem_event_group_broadcast_enable"].push_back(RegData("Broadcast_A_10", "10", 10, 0x1));
   regDataMap["mem_event_group_broadcast_enable"].push_back(RegData("Broadcast_A_11", "11", 11, 0x1));
   regDataMap["mem_event_group_broadcast_enable"].push_back(RegData("Broadcast_A_12", "12", 12, 0x1));
   regDataMap["mem_event_group_broadcast_enable"].push_back(RegData("Broadcast_A_13", "13", 13, 0x1));
   regDataMap["mem_event_group_broadcast_enable"].push_back(RegData("Broadcast_A_14", "14", 14, 0x1));
   regDataMap["mem_event_group_broadcast_enable"].push_back(RegData("Broadcast_A_15", "15", 15, 0x1));
   regDataMap["mem_event_group_broadcast_enable"].push_back(RegData("Broadcast_A_2", "2", 2, 0x1));
   regDataMap["mem_event_group_broadcast_enable"].push_back(RegData("Broadcast_A_3", "3", 3, 0x1));
   regDataMap["mem_event_group_broadcast_enable"].push_back(RegData("Broadcast_A_4", "4", 4, 0x1));
   regDataMap["mem_event_group_broadcast_enable"].push_back(RegData("Broadcast_A_5", "5", 5, 0x1));
   regDataMap["mem_event_group_broadcast_enable"].push_back(RegData("Broadcast_A_6", "6", 6, 0x1));
   regDataMap["mem_event_group_broadcast_enable"].push_back(RegData("Broadcast_A_7", "7", 7, 0x1));
   regDataMap["mem_event_group_broadcast_enable"].push_back(RegData("Broadcast_A_8", "8", 8, 0x1));
   regDataMap["mem_event_group_broadcast_enable"].push_back(RegData("Broadcast_A_9", "9", 9, 0x1));
   regDataMap["mem_event_group_dma_enable"].push_back(RegData("DMA_S2MM_Sel0_start_task", "0", 0, 0x1));
   regDataMap["mem_event_group_dma_enable"].push_back(RegData("DMA_S2MM_Sel1_start_task", "1", 1, 0x1));
   regDataMap["mem_event_group_dma_enable"].push_back(RegData("DMA_MM2S_Sel0_finished_task", "10", 10, 0x1));
   regDataMap["mem_event_group_dma_enable"].push_back(RegData("DMA_MM2S_Sel1_finished_task", "11", 11, 0x1));
   regDataMap["mem_event_group_dma_enable"].push_back(RegData("DMA_S2MM_Sel0_stalled_lock_acquire", "12", 12, 0x1));
   regDataMap["mem_event_group_dma_enable"].push_back(RegData("DMA_S2MM_Sel1_stalled_lock_acquire", "13", 13, 0x1));
   regDataMap["mem_event_group_dma_enable"].push_back(RegData("DMA_MM2S_Sel0_stalled_lock_acquire", "14", 14, 0x1));
   regDataMap["mem_event_group_dma_enable"].push_back(RegData("DMA_MM2S_Sel1_stalled_lock_acquire", "15", 15, 0x1));
   regDataMap["mem_event_group_dma_enable"].push_back(RegData("DMA_S2MM_Sel0_stream_starvation", "16", 16, 0x1));
   regDataMap["mem_event_group_dma_enable"].push_back(RegData("DMA_S2MM_Sel1_stream_starvation", "17", 17, 0x1));
   regDataMap["mem_event_group_dma_enable"].push_back(RegData("DMA_MM2S_Sel0_stream_backpressure", "18", 18, 0x1));
   regDataMap["mem_event_group_dma_enable"].push_back(RegData("DMA_MM2S_Sel1_stream_backpressure", "19", 19, 0x1));
   regDataMap["mem_event_group_dma_enable"].push_back(RegData("DMA_MM2S_Sel0_start_task", "2", 2, 0x1));
   regDataMap["mem_event_group_dma_enable"].push_back(RegData("DMA_S2MM_Sel0_memory_backpressure", "20", 20, 0x1));
   regDataMap["mem_event_group_dma_enable"].push_back(RegData("DMA_S2MM_Sel1_memory_backpressure", "21", 21, 0x1));
   regDataMap["mem_event_group_dma_enable"].push_back(RegData("DMA_MM2S_Sel0_memory_starvation", "22", 22, 0x1));
   regDataMap["mem_event_group_dma_enable"].push_back(RegData("DMA_MM2S_Sel1_memory_starvation", "23", 23, 0x1));
   regDataMap["mem_event_group_dma_enable"].push_back(RegData("DMA_MM2S_Sel1_start_task", "3", 3, 0x1));
   regDataMap["mem_event_group_dma_enable"].push_back(RegData("DMA_S2MM_Sel0_finished_BD", "4", 4, 0x1));
   regDataMap["mem_event_group_dma_enable"].push_back(RegData("DMA_S2MM_Sel1_finished_BD", "5", 5, 0x1));
   regDataMap["mem_event_group_dma_enable"].push_back(RegData("DMA_MM2S_Sel0_finished_BD", "6", 6, 0x1));
   regDataMap["mem_event_group_dma_enable"].push_back(RegData("DMA_MM2S_Sel1_finished_BD", "7", 7, 0x1));
   regDataMap["mem_event_group_dma_enable"].push_back(RegData("DMA_S2MM_Sel0_finished_task", "8", 8, 0x1));
   regDataMap["mem_event_group_dma_enable"].push_back(RegData("DMA_S2MM_Sel1_finished_task", "9", 9, 0x1));
   regDataMap["mem_event_group_error_enable"].push_back(RegData("DM_ECC_Error_Scrub_Corrected", "0", 0, 0x1));
   regDataMap["mem_event_group_error_enable"].push_back(RegData("DM_ECC_Error_Scrub_2bit", "1", 1, 0x1));
   regDataMap["mem_event_group_error_enable"].push_back(RegData("Lock_Error", "10", 10, 0x1));
   regDataMap["mem_event_group_error_enable"].push_back(RegData("DMA_Task_Token_Stall", "11", 11, 0x1));
   regDataMap["mem_event_group_error_enable"].push_back(RegData("DM_ECC_Error_1bit", "2", 2, 0x1));
   regDataMap["mem_event_group_error_enable"].push_back(RegData("DM_ECC_Error_2bit", "3", 3, 0x1));
   regDataMap["mem_event_group_error_enable"].push_back(RegData("DMA_S2MM_Error", "4", 4, 0x1));
   regDataMap["mem_event_group_error_enable"].push_back(RegData("DMA_MM2S_Error", "5", 5, 0x1));
   regDataMap["mem_event_group_error_enable"].push_back(RegData("Stream_Switch_Port_Parity_Error", "6", 6, 0x1));
   regDataMap["mem_event_group_error_enable"].push_back(RegData("Stream_Pkt_Parity_Error", "7", 7, 0x1));
   regDataMap["mem_event_group_error_enable"].push_back(RegData("Control_Pkt_Error", "8", 8, 0x1));
   regDataMap["mem_event_group_error_enable"].push_back(RegData("AXI_MM_Slave_Error", "9", 9, 0x1));
   regDataMap["mem_event_group_lock_enable"].push_back(RegData("Lock_Sel0_acq_eq", "0", 0, 0x1));
   regDataMap["mem_event_group_lock_enable"].push_back(RegData("Lock_Sel0_acq_ge", "1", 1, 0x1));
   regDataMap["mem_event_group_lock_enable"].push_back(RegData("Lock_Sel2_rel", "10", 10, 0x1));
   regDataMap["mem_event_group_lock_enable"].push_back(RegData("Lock_Sel2_equal_to_value", "11", 11, 0x1));
   regDataMap["mem_event_group_lock_enable"].push_back(RegData("Lock_Sel3_acq_eq", "12", 12, 0x1));
   regDataMap["mem_event_group_lock_enable"].push_back(RegData("Lock_Sel3_acq_ge", "13", 13, 0x1));
   regDataMap["mem_event_group_lock_enable"].push_back(RegData("Lock_Sel3_rel", "14", 14, 0x1));
   regDataMap["mem_event_group_lock_enable"].push_back(RegData("Lock_Sel3_equal_to_value", "15", 15, 0x1));
   regDataMap["mem_event_group_lock_enable"].push_back(RegData("Lock_Sel4_acq_eq", "16", 16, 0x1));
   regDataMap["mem_event_group_lock_enable"].push_back(RegData("Lock_Sel4_acq_ge", "17", 17, 0x1));
   regDataMap["mem_event_group_lock_enable"].push_back(RegData("Lock_Sel4_rel", "18", 18, 0x1));
   regDataMap["mem_event_group_lock_enable"].push_back(RegData("Lock_Sel4_equal_to_value", "19", 19, 0x1));
   regDataMap["mem_event_group_lock_enable"].push_back(RegData("Lock_Sel0_rel", "2", 2, 0x1));
   regDataMap["mem_event_group_lock_enable"].push_back(RegData("Lock_Sel5_acq_eq", "20", 20, 0x1));
   regDataMap["mem_event_group_lock_enable"].push_back(RegData("Lock_Sel5_acq_ge", "21", 21, 0x1));
   regDataMap["mem_event_group_lock_enable"].push_back(RegData("Lock_Sel5_rel", "22", 22, 0x1));
   regDataMap["mem_event_group_lock_enable"].push_back(RegData("Lock_Sel5_equal_to_value", "23", 23, 0x1));
   regDataMap["mem_event_group_lock_enable"].push_back(RegData("Lock_Sel6_acq_eq", "24", 24, 0x1));
   regDataMap["mem_event_group_lock_enable"].push_back(RegData("Lock_Sel6_acq_ge", "25", 25, 0x1));
   regDataMap["mem_event_group_lock_enable"].push_back(RegData("Lock_Sel6_rel", "26", 26, 0x1));
   regDataMap["mem_event_group_lock_enable"].push_back(RegData("Lock_Sel6_equal_to_value", "27", 27, 0x1));
   regDataMap["mem_event_group_lock_enable"].push_back(RegData("Lock_Sel7_acq_eq", "28", 28, 0x1));
   regDataMap["mem_event_group_lock_enable"].push_back(RegData("Lock_Sel7_acq_ge", "29", 29, 0x1));
   regDataMap["mem_event_group_lock_enable"].push_back(RegData("Lock_Sel0_equal_to_value", "3", 3, 0x1));
   regDataMap["mem_event_group_lock_enable"].push_back(RegData("Lock_Sel7_rel", "30", 30, 0x1));
   regDataMap["mem_event_group_lock_enable"].push_back(RegData("Lock_Sel7_equal_to_value", "31", 31, 0x1));
   regDataMap["mem_event_group_lock_enable"].push_back(RegData("Lock_Sel1_acq_eq", "4", 4, 0x1));
   regDataMap["mem_event_group_lock_enable"].push_back(RegData("Lock_Sel1_acq_ge", "5", 5, 0x1));
   regDataMap["mem_event_group_lock_enable"].push_back(RegData("Lock_Sel1_rel", "6", 6, 0x1));
   regDataMap["mem_event_group_lock_enable"].push_back(RegData("Lock_Sel1_equal_to_value", "7", 7, 0x1));
   regDataMap["mem_event_group_lock_enable"].push_back(RegData("Lock_Sel2_acq_eq", "8", 8, 0x1));
   regDataMap["mem_event_group_lock_enable"].push_back(RegData("Lock_Sel2_acq_ge", "9", 9, 0x1));
   regDataMap["mem_event_group_memory_conflict_enable"].push_back(RegData("Conflict_DM_Bank_0", "0", 0, 0x1));
   regDataMap["mem_event_group_memory_conflict_enable"].push_back(RegData("Conflict_DM_Bank_1", "1", 1, 0x1));
   regDataMap["mem_event_group_memory_conflict_enable"].push_back(RegData("Conflict_DM_Bank_2", "2", 2, 0x1));
   regDataMap["mem_event_group_memory_conflict_enable"].push_back(RegData("Conflict_DM_Bank_3", "3", 3, 0x1));
   regDataMap["mem_event_group_memory_conflict_enable"].push_back(RegData("Conflict_DM_Bank_4", "4", 4, 0x1));
   regDataMap["mem_event_group_memory_conflict_enable"].push_back(RegData("Conflict_DM_Bank_5", "5", 5, 0x1));
   regDataMap["mem_event_group_memory_conflict_enable"].push_back(RegData("Conflict_DM_Bank_6", "6", 6, 0x1));
   regDataMap["mem_event_group_memory_conflict_enable"].push_back(RegData("Conflict_DM_Bank_7", "7", 7, 0x1));
   regDataMap["mem_event_group_stream_switch_enable"].push_back(RegData("Port_Idle_0", "0", 0, 0x1));
   regDataMap["mem_event_group_stream_switch_enable"].push_back(RegData("Port_Running_0", "1", 1, 0x1));
   regDataMap["mem_event_group_stream_switch_enable"].push_back(RegData("Port_Stalled_2", "10", 10, 0x1));
   regDataMap["mem_event_group_stream_switch_enable"].push_back(RegData("Port_TLAST_2", "11", 11, 0x1));
   regDataMap["mem_event_group_stream_switch_enable"].push_back(RegData("Port_Idle_3", "12", 12, 0x1));
   regDataMap["mem_event_group_stream_switch_enable"].push_back(RegData("Port_Running_3", "13", 13, 0x1));
   regDataMap["mem_event_group_stream_switch_enable"].push_back(RegData("Port_Stalled_3", "14", 14, 0x1));
   regDataMap["mem_event_group_stream_switch_enable"].push_back(RegData("Port_TLAST_3", "15", 15, 0x1));
   regDataMap["mem_event_group_stream_switch_enable"].push_back(RegData("Port_Idle_4", "16", 16, 0x1));
   regDataMap["mem_event_group_stream_switch_enable"].push_back(RegData("Port_Running_4", "17", 17, 0x1));
   regDataMap["mem_event_group_stream_switch_enable"].push_back(RegData("Port_Stalled_4", "18", 18, 0x1));
   regDataMap["mem_event_group_stream_switch_enable"].push_back(RegData("Port_TLAST_4", "19", 19, 0x1));
   regDataMap["mem_event_group_stream_switch_enable"].push_back(RegData("Port_Stalled_0", "2", 2, 0x1));
   regDataMap["mem_event_group_stream_switch_enable"].push_back(RegData("Port_Idle_5", "20", 20, 0x1));
   regDataMap["mem_event_group_stream_switch_enable"].push_back(RegData("Port_Running_5", "21", 21, 0x1));
   regDataMap["mem_event_group_stream_switch_enable"].push_back(RegData("Port_Stalled_5", "22", 22, 0x1));
   regDataMap["mem_event_group_stream_switch_enable"].push_back(RegData("Port_TLAST_5", "23", 23, 0x1));
   regDataMap["mem_event_group_stream_switch_enable"].push_back(RegData("Port_Idle_6", "24", 24, 0x1));
   regDataMap["mem_event_group_stream_switch_enable"].push_back(RegData("Port_Running_6", "25", 25, 0x1));
   regDataMap["mem_event_group_stream_switch_enable"].push_back(RegData("Port_Stalled_6", "26", 26, 0x1));
   regDataMap["mem_event_group_stream_switch_enable"].push_back(RegData("Port_TLAST_6", "27", 27, 0x1));
   regDataMap["mem_event_group_stream_switch_enable"].push_back(RegData("Port_Idle_7", "28", 28, 0x1));
   regDataMap["mem_event_group_stream_switch_enable"].push_back(RegData("Port_Running_7", "29", 29, 0x1));
   regDataMap["mem_event_group_stream_switch_enable"].push_back(RegData("Port_TLAST_0", "3", 3, 0x1));
   regDataMap["mem_event_group_stream_switch_enable"].push_back(RegData("Port_Stalled_7", "30", 30, 0x1));
   regDataMap["mem_event_group_stream_switch_enable"].push_back(RegData("Port_TLAST_7", "31", 31, 0x1));
   regDataMap["mem_event_group_stream_switch_enable"].push_back(RegData("Port_Idle_1", "4", 4, 0x1));
   regDataMap["mem_event_group_stream_switch_enable"].push_back(RegData("Port_Running_1", "5", 5, 0x1));
   regDataMap["mem_event_group_stream_switch_enable"].push_back(RegData("Port_Stalled_1", "6", 6, 0x1));
   regDataMap["mem_event_group_stream_switch_enable"].push_back(RegData("Port_TLAST_1", "7", 7, 0x1));
   regDataMap["mem_event_group_stream_switch_enable"].push_back(RegData("Port_Idle_2", "8", 8, 0x1));
   regDataMap["mem_event_group_stream_switch_enable"].push_back(RegData("Port_Running_2", "9", 9, 0x1));
   regDataMap["mem_event_group_user_event_enable"].push_back(RegData("User_Event_0", "0", 0, 0x1));
   regDataMap["mem_event_group_user_event_enable"].push_back(RegData("User_Event_1", "1", 1, 0x1));
   regDataMap["mem_event_group_watchpoint_enable"].push_back(RegData("Watchpoint_0", "0", 0, 0x1));
   regDataMap["mem_event_group_watchpoint_enable"].push_back(RegData("Watchpoint_1", "1", 1, 0x1));
   regDataMap["mem_event_group_watchpoint_enable"].push_back(RegData("Watchpoint_2", "2", 2, 0x1));
   regDataMap["mem_event_group_watchpoint_enable"].push_back(RegData("Watchpoint_3", "3", 3, 0x1));
   regDataMap["mem_event_status0"].push_back(RegData("Event_31_0_Status", "31:0", 0, 0xFFFFFFFF));
   regDataMap["mem_event_status1"].push_back(RegData("Event_63_32_Status", "31:0", 0, 0xFFFFFFFF));
   regDataMap["mem_event_status2"].push_back(RegData("Event_95_64_Status", "31:0", 0, 0xFFFFFFFF));
   regDataMap["mem_event_status3"].push_back(RegData("Event_127_96_Status", "31:0", 0, 0xFFFFFFFF));
   regDataMap["mem_event_status4"].push_back(RegData("Event_159_128_Status", "31:0", 0, 0xFFFFFFFF));
   regDataMap["mem_event_status5"].push_back(RegData("Event_191_160_Status", "31:0", 0, 0xFFFFFFFF));
   regDataMap["mem_lock0_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mem_lock10_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mem_lock11_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mem_lock12_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mem_lock13_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mem_lock14_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mem_lock15_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mem_lock16_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mem_lock17_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mem_lock18_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mem_lock19_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mem_lock1_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mem_lock20_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mem_lock21_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mem_lock22_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mem_lock23_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mem_lock24_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mem_lock25_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mem_lock26_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mem_lock27_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mem_lock28_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mem_lock29_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mem_lock2_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mem_lock30_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mem_lock31_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mem_lock32_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mem_lock33_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mem_lock34_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mem_lock35_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mem_lock36_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mem_lock37_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mem_lock38_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mem_lock39_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mem_lock3_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mem_lock40_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mem_lock41_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mem_lock42_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mem_lock43_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mem_lock44_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mem_lock45_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mem_lock46_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mem_lock47_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mem_lock48_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mem_lock49_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mem_lock4_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mem_lock50_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mem_lock51_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mem_lock52_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mem_lock53_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mem_lock54_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mem_lock55_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mem_lock56_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mem_lock57_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mem_lock58_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mem_lock59_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mem_lock5_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mem_lock60_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mem_lock61_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mem_lock62_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mem_lock63_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mem_lock6_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mem_lock7_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mem_lock8_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mem_lock9_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["mem_lock_request"].push_back(RegData("Request_Result", "0", 0, 0x1));
   regDataMap["mem_locks_event_selection_0"].push_back(RegData("Lock_Select", "21:16", 16, 0x3F));
   regDataMap["mem_locks_event_selection_0"].push_back(RegData("Lock_Value", "5:0", 0, 0x3F));
   regDataMap["mem_locks_event_selection_1"].push_back(RegData("Lock_Select", "21:16", 16, 0x3F));
   regDataMap["mem_locks_event_selection_1"].push_back(RegData("Lock_Value", "5:0", 0, 0x3F));
   regDataMap["mem_locks_event_selection_2"].push_back(RegData("Lock_Select", "21:16", 16, 0x3F));
   regDataMap["mem_locks_event_selection_2"].push_back(RegData("Lock_Value", "5:0", 0, 0x3F));
   regDataMap["mem_locks_event_selection_3"].push_back(RegData("Lock_Select", "21:16", 16, 0x3F));
   regDataMap["mem_locks_event_selection_3"].push_back(RegData("Lock_Value", "5:0", 0, 0x3F));
   regDataMap["mem_locks_event_selection_4"].push_back(RegData("Lock_Select", "21:16", 16, 0x3F));
   regDataMap["mem_locks_event_selection_4"].push_back(RegData("Lock_Value", "5:0", 0, 0x3F));
   regDataMap["mem_locks_event_selection_5"].push_back(RegData("Lock_Select", "21:16", 16, 0x3F));
   regDataMap["mem_locks_event_selection_5"].push_back(RegData("Lock_Value", "5:0", 0, 0x3F));
   regDataMap["mem_locks_event_selection_6"].push_back(RegData("Lock_Select", "21:16", 16, 0x3F));
   regDataMap["mem_locks_event_selection_6"].push_back(RegData("Lock_Value", "5:0", 0, 0x3F));
   regDataMap["mem_locks_event_selection_7"].push_back(RegData("Lock_Select", "21:16", 16, 0x3F));
   regDataMap["mem_locks_event_selection_7"].push_back(RegData("Lock_Value", "5:0", 0, 0x3F));
   regDataMap["mem_locks_overflow_0"].push_back(RegData("Lock_Overflow_0", "0", 0, 0x1));
   regDataMap["mem_locks_overflow_0"].push_back(RegData("Lock_Overflow_1", "1", 1, 0x1));
   regDataMap["mem_locks_overflow_0"].push_back(RegData("Lock_Overflow_10", "10", 10, 0x1));
   regDataMap["mem_locks_overflow_0"].push_back(RegData("Lock_Overflow_11", "11", 11, 0x1));
   regDataMap["mem_locks_overflow_0"].push_back(RegData("Lock_Overflow_12", "12", 12, 0x1));
   regDataMap["mem_locks_overflow_0"].push_back(RegData("Lock_Overflow_13", "13", 13, 0x1));
   regDataMap["mem_locks_overflow_0"].push_back(RegData("Lock_Overflow_14", "14", 14, 0x1));
   regDataMap["mem_locks_overflow_0"].push_back(RegData("Lock_Overflow_15", "15", 15, 0x1));
   regDataMap["mem_locks_overflow_0"].push_back(RegData("Lock_Overflow_16", "16", 16, 0x1));
   regDataMap["mem_locks_overflow_0"].push_back(RegData("Lock_Overflow_17", "17", 17, 0x1));
   regDataMap["mem_locks_overflow_0"].push_back(RegData("Lock_Overflow_18", "18", 18, 0x1));
   regDataMap["mem_locks_overflow_0"].push_back(RegData("Lock_Overflow_19", "19", 19, 0x1));
   regDataMap["mem_locks_overflow_0"].push_back(RegData("Lock_Overflow_2", "2", 2, 0x1));
   regDataMap["mem_locks_overflow_0"].push_back(RegData("Lock_Overflow_20", "20", 20, 0x1));
   regDataMap["mem_locks_overflow_0"].push_back(RegData("Lock_Overflow_21", "21", 21, 0x1));
   regDataMap["mem_locks_overflow_0"].push_back(RegData("Lock_Overflow_22", "22", 22, 0x1));
   regDataMap["mem_locks_overflow_0"].push_back(RegData("Lock_Overflow_23", "23", 23, 0x1));
   regDataMap["mem_locks_overflow_0"].push_back(RegData("Lock_Overflow_24", "24", 24, 0x1));
   regDataMap["mem_locks_overflow_0"].push_back(RegData("Lock_Overflow_25", "25", 25, 0x1));
   regDataMap["mem_locks_overflow_0"].push_back(RegData("Lock_Overflow_26", "26", 26, 0x1));
   regDataMap["mem_locks_overflow_0"].push_back(RegData("Lock_Overflow_27", "27", 27, 0x1));
   regDataMap["mem_locks_overflow_0"].push_back(RegData("Lock_Overflow_28", "28", 28, 0x1));
   regDataMap["mem_locks_overflow_0"].push_back(RegData("Lock_Overflow_29", "29", 29, 0x1));
   regDataMap["mem_locks_overflow_0"].push_back(RegData("Lock_Overflow_3", "3", 3, 0x1));
   regDataMap["mem_locks_overflow_0"].push_back(RegData("Lock_Overflow_30", "30", 30, 0x1));
   regDataMap["mem_locks_overflow_0"].push_back(RegData("Lock_Overflow_31", "31", 31, 0x1));
   regDataMap["mem_locks_overflow_0"].push_back(RegData("Lock_Overflow_4", "4", 4, 0x1));
   regDataMap["mem_locks_overflow_0"].push_back(RegData("Lock_Overflow_5", "5", 5, 0x1));
   regDataMap["mem_locks_overflow_0"].push_back(RegData("Lock_Overflow_6", "6", 6, 0x1));
   regDataMap["mem_locks_overflow_0"].push_back(RegData("Lock_Overflow_7", "7", 7, 0x1));
   regDataMap["mem_locks_overflow_0"].push_back(RegData("Lock_Overflow_8", "8", 8, 0x1));
   regDataMap["mem_locks_overflow_0"].push_back(RegData("Lock_Overflow_9", "9", 9, 0x1));
   regDataMap["mem_locks_overflow_1"].push_back(RegData("Lock_Overflow_32", "0", 0, 0x1));
   regDataMap["mem_locks_overflow_1"].push_back(RegData("Lock_Overflow_33", "1", 1, 0x1));
   regDataMap["mem_locks_overflow_1"].push_back(RegData("Lock_Overflow_42", "10", 10, 0x1));
   regDataMap["mem_locks_overflow_1"].push_back(RegData("Lock_Overflow_43", "11", 11, 0x1));
   regDataMap["mem_locks_overflow_1"].push_back(RegData("Lock_Overflow_44", "12", 12, 0x1));
   regDataMap["mem_locks_overflow_1"].push_back(RegData("Lock_Overflow_45", "13", 13, 0x1));
   regDataMap["mem_locks_overflow_1"].push_back(RegData("Lock_Overflow_46", "14", 14, 0x1));
   regDataMap["mem_locks_overflow_1"].push_back(RegData("Lock_Overflow_47", "15", 15, 0x1));
   regDataMap["mem_locks_overflow_1"].push_back(RegData("Lock_Overflow_48", "16", 16, 0x1));
   regDataMap["mem_locks_overflow_1"].push_back(RegData("Lock_Overflow_49", "17", 17, 0x1));
   regDataMap["mem_locks_overflow_1"].push_back(RegData("Lock_Overflow_50", "18", 18, 0x1));
   regDataMap["mem_locks_overflow_1"].push_back(RegData("Lock_Overflow_51", "19", 19, 0x1));
   regDataMap["mem_locks_overflow_1"].push_back(RegData("Lock_Overflow_34", "2", 2, 0x1));
   regDataMap["mem_locks_overflow_1"].push_back(RegData("Lock_Overflow_52", "20", 20, 0x1));
   regDataMap["mem_locks_overflow_1"].push_back(RegData("Lock_Overflow_53", "21", 21, 0x1));
   regDataMap["mem_locks_overflow_1"].push_back(RegData("Lock_Overflow_54", "22", 22, 0x1));
   regDataMap["mem_locks_overflow_1"].push_back(RegData("Lock_Overflow_55", "23", 23, 0x1));
   regDataMap["mem_locks_overflow_1"].push_back(RegData("Lock_Overflow_56", "24", 24, 0x1));
   regDataMap["mem_locks_overflow_1"].push_back(RegData("Lock_Overflow_57", "25", 25, 0x1));
   regDataMap["mem_locks_overflow_1"].push_back(RegData("Lock_Overflow_58", "26", 26, 0x1));
   regDataMap["mem_locks_overflow_1"].push_back(RegData("Lock_Overflow_59", "27", 27, 0x1));
   regDataMap["mem_locks_overflow_1"].push_back(RegData("Lock_Overflow_60", "28", 28, 0x1));
   regDataMap["mem_locks_overflow_1"].push_back(RegData("Lock_Overflow_61", "29", 29, 0x1));
   regDataMap["mem_locks_overflow_1"].push_back(RegData("Lock_Overflow_35", "3", 3, 0x1));
   regDataMap["mem_locks_overflow_1"].push_back(RegData("Lock_Overflow_62", "30", 30, 0x1));
   regDataMap["mem_locks_overflow_1"].push_back(RegData("Lock_Overflow_63", "31", 31, 0x1));
   regDataMap["mem_locks_overflow_1"].push_back(RegData("Lock_Overflow_36", "4", 4, 0x1));
   regDataMap["mem_locks_overflow_1"].push_back(RegData("Lock_Overflow_37", "5", 5, 0x1));
   regDataMap["mem_locks_overflow_1"].push_back(RegData("Lock_Overflow_38", "6", 6, 0x1));
   regDataMap["mem_locks_overflow_1"].push_back(RegData("Lock_Overflow_39", "7", 7, 0x1));
   regDataMap["mem_locks_overflow_1"].push_back(RegData("Lock_Overflow_40", "8", 8, 0x1));
   regDataMap["mem_locks_overflow_1"].push_back(RegData("Lock_Overflow_41", "9", 9, 0x1));
   regDataMap["mem_locks_underflow_0"].push_back(RegData("Lock_Underflow_0", "0", 0, 0x1));
   regDataMap["mem_locks_underflow_0"].push_back(RegData("Lock_Underflow_1", "1", 1, 0x1));
   regDataMap["mem_locks_underflow_0"].push_back(RegData("Lock_Underflow_10", "10", 10, 0x1));
   regDataMap["mem_locks_underflow_0"].push_back(RegData("Lock_Underflow_11", "11", 11, 0x1));
   regDataMap["mem_locks_underflow_0"].push_back(RegData("Lock_Underflow_12", "12", 12, 0x1));
   regDataMap["mem_locks_underflow_0"].push_back(RegData("Lock_Underflow_13", "13", 13, 0x1));
   regDataMap["mem_locks_underflow_0"].push_back(RegData("Lock_Underflow_14", "14", 14, 0x1));
   regDataMap["mem_locks_underflow_0"].push_back(RegData("Lock_Underflow_15", "15", 15, 0x1));
   regDataMap["mem_locks_underflow_0"].push_back(RegData("Lock_Underflow_16", "16", 16, 0x1));
   regDataMap["mem_locks_underflow_0"].push_back(RegData("Lock_Underflow_17", "17", 17, 0x1));
   regDataMap["mem_locks_underflow_0"].push_back(RegData("Lock_Underflow_18", "18", 18, 0x1));
   regDataMap["mem_locks_underflow_0"].push_back(RegData("Lock_Underflow_19", "19", 19, 0x1));
   regDataMap["mem_locks_underflow_0"].push_back(RegData("Lock_Underflow_2", "2", 2, 0x1));
   regDataMap["mem_locks_underflow_0"].push_back(RegData("Lock_Underflow_20", "20", 20, 0x1));
   regDataMap["mem_locks_underflow_0"].push_back(RegData("Lock_Underflow_21", "21", 21, 0x1));
   regDataMap["mem_locks_underflow_0"].push_back(RegData("Lock_Underflow_22", "22", 22, 0x1));
   regDataMap["mem_locks_underflow_0"].push_back(RegData("Lock_Underflow_23", "23", 23, 0x1));
   regDataMap["mem_locks_underflow_0"].push_back(RegData("Lock_Underflow_24", "24", 24, 0x1));
   regDataMap["mem_locks_underflow_0"].push_back(RegData("Lock_Underflow_25", "25", 25, 0x1));
   regDataMap["mem_locks_underflow_0"].push_back(RegData("Lock_Underflow_26", "26", 26, 0x1));
   regDataMap["mem_locks_underflow_0"].push_back(RegData("Lock_Underflow_27", "27", 27, 0x1));
   regDataMap["mem_locks_underflow_0"].push_back(RegData("Lock_Underflow_28", "28", 28, 0x1));
   regDataMap["mem_locks_underflow_0"].push_back(RegData("Lock_Underflow_29", "29", 29, 0x1));
   regDataMap["mem_locks_underflow_0"].push_back(RegData("Lock_Underflow_3", "3", 3, 0x1));
   regDataMap["mem_locks_underflow_0"].push_back(RegData("Lock_Underflow_30", "30", 30, 0x1));
   regDataMap["mem_locks_underflow_0"].push_back(RegData("Lock_Underflow_31", "31", 31, 0x1));
   regDataMap["mem_locks_underflow_0"].push_back(RegData("Lock_Underflow_4", "4", 4, 0x1));
   regDataMap["mem_locks_underflow_0"].push_back(RegData("Lock_Underflow_5", "5", 5, 0x1));
   regDataMap["mem_locks_underflow_0"].push_back(RegData("Lock_Underflow_6", "6", 6, 0x1));
   regDataMap["mem_locks_underflow_0"].push_back(RegData("Lock_Underflow_7", "7", 7, 0x1));
   regDataMap["mem_locks_underflow_0"].push_back(RegData("Lock_Underflow_8", "8", 8, 0x1));
   regDataMap["mem_locks_underflow_0"].push_back(RegData("Lock_Underflow_9", "9", 9, 0x1));
   regDataMap["mem_locks_underflow_1"].push_back(RegData("Lock_Underflow_32", "0", 0, 0x1));
   regDataMap["mem_locks_underflow_1"].push_back(RegData("Lock_Underflow_33", "1", 1, 0x1));
   regDataMap["mem_locks_underflow_1"].push_back(RegData("Lock_Underflow_42", "10", 10, 0x1));
   regDataMap["mem_locks_underflow_1"].push_back(RegData("Lock_Underflow_43", "11", 11, 0x1));
   regDataMap["mem_locks_underflow_1"].push_back(RegData("Lock_Underflow_44", "12", 12, 0x1));
   regDataMap["mem_locks_underflow_1"].push_back(RegData("Lock_Underflow_45", "13", 13, 0x1));
   regDataMap["mem_locks_underflow_1"].push_back(RegData("Lock_Underflow_46", "14", 14, 0x1));
   regDataMap["mem_locks_underflow_1"].push_back(RegData("Lock_Underflow_47", "15", 15, 0x1));
   regDataMap["mem_locks_underflow_1"].push_back(RegData("Lock_Underflow_48", "16", 16, 0x1));
   regDataMap["mem_locks_underflow_1"].push_back(RegData("Lock_Underflow_49", "17", 17, 0x1));
   regDataMap["mem_locks_underflow_1"].push_back(RegData("Lock_Underflow_50", "18", 18, 0x1));
   regDataMap["mem_locks_underflow_1"].push_back(RegData("Lock_Underflow_51", "19", 19, 0x1));
   regDataMap["mem_locks_underflow_1"].push_back(RegData("Lock_Underflow_34", "2", 2, 0x1));
   regDataMap["mem_locks_underflow_1"].push_back(RegData("Lock_Underflow_52", "20", 20, 0x1));
   regDataMap["mem_locks_underflow_1"].push_back(RegData("Lock_Underflow_53", "21", 21, 0x1));
   regDataMap["mem_locks_underflow_1"].push_back(RegData("Lock_Underflow_54", "22", 22, 0x1));
   regDataMap["mem_locks_underflow_1"].push_back(RegData("Lock_Underflow_55", "23", 23, 0x1));
   regDataMap["mem_locks_underflow_1"].push_back(RegData("Lock_Underflow_56", "24", 24, 0x1));
   regDataMap["mem_locks_underflow_1"].push_back(RegData("Lock_Underflow_57", "25", 25, 0x1));
   regDataMap["mem_locks_underflow_1"].push_back(RegData("Lock_Underflow_58", "26", 26, 0x1));
   regDataMap["mem_locks_underflow_1"].push_back(RegData("Lock_Underflow_59", "27", 27, 0x1));
   regDataMap["mem_locks_underflow_1"].push_back(RegData("Lock_Underflow_60", "28", 28, 0x1));
   regDataMap["mem_locks_underflow_1"].push_back(RegData("Lock_Underflow_61", "29", 29, 0x1));
   regDataMap["mem_locks_underflow_1"].push_back(RegData("Lock_Underflow_35", "3", 3, 0x1));
   regDataMap["mem_locks_underflow_1"].push_back(RegData("Lock_Underflow_62", "30", 30, 0x1));
   regDataMap["mem_locks_underflow_1"].push_back(RegData("Lock_Underflow_63", "31", 31, 0x1));
   regDataMap["mem_locks_underflow_1"].push_back(RegData("Lock_Underflow_36", "4", 4, 0x1));
   regDataMap["mem_locks_underflow_1"].push_back(RegData("Lock_Underflow_37", "5", 5, 0x1));
   regDataMap["mem_locks_underflow_1"].push_back(RegData("Lock_Underflow_38", "6", 6, 0x1));
   regDataMap["mem_locks_underflow_1"].push_back(RegData("Lock_Underflow_39", "7", 7, 0x1));
   regDataMap["mem_locks_underflow_1"].push_back(RegData("Lock_Underflow_40", "8", 8, 0x1));
   regDataMap["mem_locks_underflow_1"].push_back(RegData("Lock_Underflow_41", "9", 9, 0x1));
   regDataMap["mem_memory_control"].push_back(RegData("Memory_Zeroisation", "0", 0, 0x1));
   regDataMap["mem_memory_control"].push_back(RegData("Memory_Interleaving", "1", 1, 0x1));
   regDataMap["mem_module_clock_control"].push_back(RegData("Stream_Switch_Clock_Enable", "0", 0, 0x1));
   regDataMap["mem_module_clock_control"].push_back(RegData("Memory_Module_Clock_Enable", "1", 1, 0x1));
   regDataMap["mem_module_clock_control"].push_back(RegData("Ctrl_Pkt_Tlast_Error_Enable", "4", 4, 0x1));
   regDataMap["mem_module_clock_control"].push_back(RegData("DMA_Adaptive_Clock_Gate", "5", 5, 0x1));
   regDataMap["mem_module_reset_control"].push_back(RegData("Stream_Switch_Reset", "0", 0, 0x1));
   regDataMap["mem_module_reset_control"].push_back(RegData("Memory_Reset", "1", 1, 0x1));
   regDataMap["mem_performance_control0"].push_back(RegData("Cnt0_Stop_Event", "15:8", 8, 0xFF));
   regDataMap["mem_performance_control0"].push_back(RegData("Cnt1_Start_Event", "23:16", 16, 0xFF));
   regDataMap["mem_performance_control0"].push_back(RegData("Cnt1_Stop_Event", "31:24", 24, 0xFF));
   regDataMap["mem_performance_control0"].push_back(RegData("Cnt0_Start_Event", "7:0", 0, 0xFF));
   regDataMap["mem_performance_control1"].push_back(RegData("Cnt2_Stop_Event", "15:8", 8, 0xFF));
   regDataMap["mem_performance_control1"].push_back(RegData("Cnt3_Start_Event", "23:16", 16, 0xFF));
   regDataMap["mem_performance_control1"].push_back(RegData("Cnt3_Stop_Event", "31:24", 24, 0xFF));
   regDataMap["mem_performance_control1"].push_back(RegData("Cnt2_Start_Event", "7:0", 0, 0xFF));
   regDataMap["mem_performance_control2"].push_back(RegData("Cnt1_Reset_Event", "15:8", 8, 0xFF));
   regDataMap["mem_performance_control2"].push_back(RegData("Cnt2_Reset_Event", "23:16", 16, 0xFF));
   regDataMap["mem_performance_control2"].push_back(RegData("Cnt3_Reset_Event", "31:24", 24, 0xFF));
   regDataMap["mem_performance_control2"].push_back(RegData("Cnt0_Reset_Event", "7:0", 0, 0xFF));
   regDataMap["mem_performance_control3"].push_back(RegData("Cnt4_Stop_Event", "15:8", 8, 0xFF));
   regDataMap["mem_performance_control3"].push_back(RegData("Cnt5_Start_Event", "23:16", 16, 0xFF));
   regDataMap["mem_performance_control3"].push_back(RegData("Cnt5_Stop_Event", "31:24", 24, 0xFF));
   regDataMap["mem_performance_control3"].push_back(RegData("Cnt4_Start_Event", "7:0", 0, 0xFF));
   regDataMap["mem_performance_control4"].push_back(RegData("Cnt5_Reset_Event", "15:8", 8, 0xFF));
   regDataMap["mem_performance_control4"].push_back(RegData("Cnt4_Reset_Event", "7:0", 0, 0xFF));
   regDataMap["mem_performance_counter0"].push_back(RegData("Counter0_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["mem_performance_counter0_event_value"].push_back(RegData("Counter0_Event_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["mem_performance_counter1"].push_back(RegData("Counter1_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["mem_performance_counter1_event_value"].push_back(RegData("Counter1_Event_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["mem_performance_counter2"].push_back(RegData("Counter2_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["mem_performance_counter2_event_value"].push_back(RegData("Counter2_Event_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["mem_performance_counter3"].push_back(RegData("Counter3_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["mem_performance_counter3_event_value"].push_back(RegData("Counter3_Event_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["mem_performance_counter4"].push_back(RegData("Counter4_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["mem_performance_counter5"].push_back(RegData("Counter5_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["mem_spare_reg"].push_back(RegData("Spare_Reg", "15:0", 0, 0xFFFF));
   regDataMap["mem_spare_reg_privileged"].push_back(RegData("Spare_Reg", "15:0", 0, 0xFFFF));
   regDataMap["mem_stream_switch_adaptive_clock_gate_abort_period"].push_back(RegData("Abort_Period", "3:0", 0, 0xF));
   regDataMap["mem_stream_switch_adaptive_clock_gate_status"].push_back(RegData("Active", "0", 0, 0x1));
   regDataMap["mem_stream_switch_deterministic_merge_arb0_ctrl"].push_back(RegData("Enable", "0", 0, 0x1));
   regDataMap["mem_stream_switch_deterministic_merge_arb0_slave0_1"].push_back(RegData("Packet_Count_0", "13:8", 8, 0x3F));
   regDataMap["mem_stream_switch_deterministic_merge_arb0_slave0_1"].push_back(RegData("Slave_ID_1", "20:16", 16, 0x1F));
   regDataMap["mem_stream_switch_deterministic_merge_arb0_slave0_1"].push_back(RegData("Packet_Count_1", "29:24", 24, 0x3F));
   regDataMap["mem_stream_switch_deterministic_merge_arb0_slave0_1"].push_back(RegData("Slave_ID_0", "4:0", 0, 0x1F));
   regDataMap["mem_stream_switch_deterministic_merge_arb0_slave2_3"].push_back(RegData("Packet_Count_2", "13:8", 8, 0x3F));
   regDataMap["mem_stream_switch_deterministic_merge_arb0_slave2_3"].push_back(RegData("Slave_ID_3", "20:16", 16, 0x1F));
   regDataMap["mem_stream_switch_deterministic_merge_arb0_slave2_3"].push_back(RegData("Packet_Count_3", "29:24", 24, 0x3F));
   regDataMap["mem_stream_switch_deterministic_merge_arb0_slave2_3"].push_back(RegData("Slave_ID_2", "4:0", 0, 0x1F));
   regDataMap["mem_stream_switch_deterministic_merge_arb1_ctrl"].push_back(RegData("Enable", "0", 0, 0x1));
   regDataMap["mem_stream_switch_deterministic_merge_arb1_slave0_1"].push_back(RegData("Packet_Count_0", "13:8", 8, 0x3F));
   regDataMap["mem_stream_switch_deterministic_merge_arb1_slave0_1"].push_back(RegData("Slave_ID_1", "20:16", 16, 0x1F));
   regDataMap["mem_stream_switch_deterministic_merge_arb1_slave0_1"].push_back(RegData("Packet_Count_1", "29:24", 24, 0x3F));
   regDataMap["mem_stream_switch_deterministic_merge_arb1_slave0_1"].push_back(RegData("Slave_ID_0", "4:0", 0, 0x1F));
   regDataMap["mem_stream_switch_deterministic_merge_arb1_slave2_3"].push_back(RegData("Packet_Count_2", "13:8", 8, 0x3F));
   regDataMap["mem_stream_switch_deterministic_merge_arb1_slave2_3"].push_back(RegData("Slave_ID_3", "20:16", 16, 0x1F));
   regDataMap["mem_stream_switch_deterministic_merge_arb1_slave2_3"].push_back(RegData("Packet_Count_3", "29:24", 24, 0x3F));
   regDataMap["mem_stream_switch_deterministic_merge_arb1_slave2_3"].push_back(RegData("Slave_ID_2", "4:0", 0, 0x1F));
   regDataMap["mem_stream_switch_event_port_selection_0"].push_back(RegData("Port_1_ID", "12:8", 8, 0x1F));
   regDataMap["mem_stream_switch_event_port_selection_0"].push_back(RegData("Port_1_Master_Slave", "13", 13, 0x1));
   regDataMap["mem_stream_switch_event_port_selection_0"].push_back(RegData("Port_2_ID", "20:16", 16, 0x1F));
   regDataMap["mem_stream_switch_event_port_selection_0"].push_back(RegData("Port_2_Master_Slave", "21", 21, 0x1));
   regDataMap["mem_stream_switch_event_port_selection_0"].push_back(RegData("Port_3_ID", "28:24", 24, 0x1F));
   regDataMap["mem_stream_switch_event_port_selection_0"].push_back(RegData("Port_3_Master_Slave", "29", 29, 0x1));
   regDataMap["mem_stream_switch_event_port_selection_0"].push_back(RegData("Port_0_ID", "4:0", 0, 0x1F));
   regDataMap["mem_stream_switch_event_port_selection_0"].push_back(RegData("Port_0_Master_Slave", "5", 5, 0x1));
   regDataMap["mem_stream_switch_event_port_selection_1"].push_back(RegData("Port_5_ID", "12:8", 8, 0x1F));
   regDataMap["mem_stream_switch_event_port_selection_1"].push_back(RegData("Port_5_Master_Slave", "13", 13, 0x1));
   regDataMap["mem_stream_switch_event_port_selection_1"].push_back(RegData("Port_6_ID", "20:16", 16, 0x1F));
   regDataMap["mem_stream_switch_event_port_selection_1"].push_back(RegData("Port_6_Master_Slave", "21", 21, 0x1));
   regDataMap["mem_stream_switch_event_port_selection_1"].push_back(RegData("Port_7_ID", "28:24", 24, 0x1F));
   regDataMap["mem_stream_switch_event_port_selection_1"].push_back(RegData("Port_7_Master_Slave", "29", 29, 0x1));
   regDataMap["mem_stream_switch_event_port_selection_1"].push_back(RegData("Port_4_ID", "4:0", 0, 0x1F));
   regDataMap["mem_stream_switch_event_port_selection_1"].push_back(RegData("Port_4_Master_Slave", "5", 5, 0x1));
   regDataMap["mem_stream_switch_parity_injection"].push_back(RegData("DMA_0_lower", "0", 0, 0x1));
   regDataMap["mem_stream_switch_parity_injection"].push_back(RegData("DMA_1_lower", "1", 1, 0x1));
   regDataMap["mem_stream_switch_parity_injection"].push_back(RegData("DMA_0_upper", "16", 16, 0x1));
   regDataMap["mem_stream_switch_parity_injection"].push_back(RegData("DMA_1_upper", "17", 17, 0x1));
   regDataMap["mem_stream_switch_parity_injection"].push_back(RegData("DMA_2_upper", "18", 18, 0x1));
   regDataMap["mem_stream_switch_parity_injection"].push_back(RegData("DMA_3_upper", "19", 19, 0x1));
   regDataMap["mem_stream_switch_parity_injection"].push_back(RegData("DMA_2_lower", "2", 2, 0x1));
   regDataMap["mem_stream_switch_parity_injection"].push_back(RegData("DMA_4_upper", "20", 20, 0x1));
   regDataMap["mem_stream_switch_parity_injection"].push_back(RegData("DMA_5_upper", "21", 21, 0x1));
   regDataMap["mem_stream_switch_parity_injection"].push_back(RegData("Tile_Control_upper", "22", 22, 0x1));
   regDataMap["mem_stream_switch_parity_injection"].push_back(RegData("Mem_trace_upper", "23", 23, 0x1));
   regDataMap["mem_stream_switch_parity_injection"].push_back(RegData("DMA_3_lower", "3", 3, 0x1));
   regDataMap["mem_stream_switch_parity_injection"].push_back(RegData("DMA_4_lower", "4", 4, 0x1));
   regDataMap["mem_stream_switch_parity_injection"].push_back(RegData("DMA_5_lower", "5", 5, 0x1));
   regDataMap["mem_stream_switch_parity_injection"].push_back(RegData("Tile_Control_lower", "6", 6, 0x1));
   regDataMap["mem_stream_switch_parity_injection"].push_back(RegData("Mem_trace_lower", "7", 7, 0x1));
   regDataMap["mem_stream_switch_parity_status"].push_back(RegData("DMA_0", "0", 0, 0x1));
   regDataMap["mem_stream_switch_parity_status"].push_back(RegData("DMA_1", "1", 1, 0x1));
   regDataMap["mem_stream_switch_parity_status"].push_back(RegData("DMA_2", "2", 2, 0x1));
   regDataMap["mem_stream_switch_parity_status"].push_back(RegData("DMA_3", "3", 3, 0x1));
   regDataMap["mem_stream_switch_parity_status"].push_back(RegData("DMA_4", "4", 4, 0x1));
   regDataMap["mem_stream_switch_parity_status"].push_back(RegData("DMA_5", "5", 5, 0x1));
   regDataMap["mem_stream_switch_parity_status"].push_back(RegData("Tile_Control", "6", 6, 0x1));
   regDataMap["mem_tile_control"].push_back(RegData("Isolate_From_South", "0", 0, 0x1));
   regDataMap["mem_tile_control"].push_back(RegData("Isolate_From_West", "1", 1, 0x1));
   regDataMap["mem_tile_control"].push_back(RegData("Isolate_From_North", "2", 2, 0x1));
   regDataMap["mem_tile_control"].push_back(RegData("Isolate_From_East", "3", 3, 0x1));
   regDataMap["mem_tile_control_packet_handler_status"].push_back(RegData("First_Header_Parity_Error", "0", 0, 0x1));
   regDataMap["mem_tile_control_packet_handler_status"].push_back(RegData("Second_Header_Parity_Error", "1", 1, 0x1));
   regDataMap["mem_tile_control_packet_handler_status"].push_back(RegData("SLVERR_On_Access", "2", 2, 0x1));
   regDataMap["mem_tile_control_packet_handler_status"].push_back(RegData("Tlast_Error", "3", 3, 0x1));
   regDataMap["mem_timer_control"].push_back(RegData("Reset_Event", "15:8", 8, 0xFF));
   regDataMap["mem_timer_control"].push_back(RegData("Reset", "31", 31, 0x1));
   regDataMap["mem_timer_high"].push_back(RegData("TimerHigh", "31:0", 0, 0xFFFFFFFF));
   regDataMap["mem_timer_low"].push_back(RegData("TimerLow", "31:0", 0, 0xFFFFFFFF));
   regDataMap["mem_timer_trig_event_high_value"].push_back(RegData("TimerTrigHigh", "31:0", 0, 0xFFFFFFFF));
   regDataMap["mem_timer_trig_event_low_value"].push_back(RegData("TimerTrigLow", "31:0", 0, 0xFFFFFFFF));
   regDataMap["mem_trace_control0"].push_back(RegData("Trace_Start_Event", "23:16", 16, 0xFF));
   regDataMap["mem_trace_control0"].push_back(RegData("Trace_Stop_Event", "31:24", 24, 0xFF));
   regDataMap["mem_trace_control1"].push_back(RegData("Packet_Type", "14:12", 12, 0x7));
   regDataMap["mem_trace_control1"].push_back(RegData("ID", "4:0", 0, 0x1F));
   regDataMap["mem_trace_event0"].push_back(RegData("Trace_Event1", "15:8", 8, 0xFF));
   regDataMap["mem_trace_event0"].push_back(RegData("Trace_Event2", "23:16", 16, 0xFF));
   regDataMap["mem_trace_event0"].push_back(RegData("Trace_Event3", "31:24", 24, 0xFF));
   regDataMap["mem_trace_event0"].push_back(RegData("Trace_Event0", "7:0", 0, 0xFF));
   regDataMap["mem_trace_event1"].push_back(RegData("Trace_Event5", "15:8", 8, 0xFF));
   regDataMap["mem_trace_event1"].push_back(RegData("Trace_Event6", "23:16", 16, 0xFF));
   regDataMap["mem_trace_event1"].push_back(RegData("Trace_Event7", "31:24", 24, 0xFF));
   regDataMap["mem_trace_event1"].push_back(RegData("Trace_Event4", "7:0", 0, 0xFF));
   regDataMap["mem_trace_status"].push_back(RegData("Mode", "2:0", 0, 0x7));
   regDataMap["mem_trace_status"].push_back(RegData("State", "9:8", 8, 0x3));
   regDataMap["mem_watchpoint0"].push_back(RegData("Address", "13:0", 0, 0x3FFF));
   regDataMap["mem_watchpoint0"].push_back(RegData("WriteStrobeMask", "23:16", 16, 0xFF));
   regDataMap["mem_watchpoint0"].push_back(RegData("West_Access", "24", 24, 0x1));
   regDataMap["mem_watchpoint0"].push_back(RegData("East_Access", "25", 25, 0x1));
   regDataMap["mem_watchpoint0"].push_back(RegData("DMA_Access", "26", 26, 0x1));
   regDataMap["mem_watchpoint0"].push_back(RegData("AXI_Access", "27", 27, 0x1));
   regDataMap["mem_watchpoint0"].push_back(RegData("Write_Access", "28", 28, 0x1));
   regDataMap["mem_watchpoint0"].push_back(RegData("Read_Access", "29", 29, 0x1));
   regDataMap["mem_watchpoint1"].push_back(RegData("Address", "13:0", 0, 0x3FFF));
   regDataMap["mem_watchpoint1"].push_back(RegData("WriteStrobeMask", "23:16", 16, 0xFF));
   regDataMap["mem_watchpoint1"].push_back(RegData("West_Access", "24", 24, 0x1));
   regDataMap["mem_watchpoint1"].push_back(RegData("East_Access", "25", 25, 0x1));
   regDataMap["mem_watchpoint1"].push_back(RegData("DMA_Access", "26", 26, 0x1));
   regDataMap["mem_watchpoint1"].push_back(RegData("AXI_Access", "27", 27, 0x1));
   regDataMap["mem_watchpoint1"].push_back(RegData("Write_Access", "28", 28, 0x1));
   regDataMap["mem_watchpoint1"].push_back(RegData("Read_Access", "29", 29, 0x1));
   regDataMap["mem_watchpoint2"].push_back(RegData("Address", "13:0", 0, 0x3FFF));
   regDataMap["mem_watchpoint2"].push_back(RegData("WriteStrobeMask", "23:16", 16, 0xFF));
   regDataMap["mem_watchpoint2"].push_back(RegData("West_Access", "24", 24, 0x1));
   regDataMap["mem_watchpoint2"].push_back(RegData("East_Access", "25", 25, 0x1));
   regDataMap["mem_watchpoint2"].push_back(RegData("DMA_Access", "26", 26, 0x1));
   regDataMap["mem_watchpoint2"].push_back(RegData("AXI_Access", "27", 27, 0x1));
   regDataMap["mem_watchpoint2"].push_back(RegData("Write_Access", "28", 28, 0x1));
   regDataMap["mem_watchpoint2"].push_back(RegData("Read_Access", "29", 29, 0x1));
   regDataMap["mem_watchpoint3"].push_back(RegData("Address", "13:0", 0, 0x3FFF));
   regDataMap["mem_watchpoint3"].push_back(RegData("WriteStrobeMask", "23:16", 16, 0xFF));
   regDataMap["mem_watchpoint3"].push_back(RegData("West_Access", "24", 24, 0x1));
   regDataMap["mem_watchpoint3"].push_back(RegData("East_Access", "25", 25, 0x1));
   regDataMap["mem_watchpoint3"].push_back(RegData("DMA_Access", "26", 26, 0x1));
   regDataMap["mem_watchpoint3"].push_back(RegData("AXI_Access", "27", 27, 0x1));
   regDataMap["mem_watchpoint3"].push_back(RegData("Write_Access", "28", 28, 0x1));
   regDataMap["mem_watchpoint3"].push_back(RegData("Read_Access", "29", 29, 0x1));
   regDataMap["shim_axi_mm_outstanding_transactions"].push_back(RegData("NoC_Module_To_NMU", "0", 0, 0x1));
   regDataMap["shim_bisr_cache_ctrl"].push_back(RegData("Trigger", "0", 0, 0x1));
   regDataMap["shim_bisr_cache_ctrl"].push_back(RegData("Clear", "4", 4, 0x1));
   regDataMap["shim_bisr_cache_data0"].push_back(RegData("Data", "31:0", 0, 0xFFFFFFFF));
   regDataMap["shim_bisr_cache_data1"].push_back(RegData("Data", "31:0", 0, 0xFFFFFFFF));
   regDataMap["shim_bisr_cache_data2"].push_back(RegData("Data", "31:0", 0, 0xFFFFFFFF));
   regDataMap["shim_bisr_cache_data3"].push_back(RegData("Data", "31:0", 0, 0xFFFFFFFF));
   regDataMap["shim_bisr_cache_data4"].push_back(RegData("Data", "31:0", 0, 0xFFFFFFFF));
   regDataMap["shim_bisr_cache_data5"].push_back(RegData("Data", "31:0", 0, 0xFFFFFFFF));
   regDataMap["shim_bisr_cache_data6"].push_back(RegData("Data", "31:0", 0, 0xFFFFFFFF));
   regDataMap["shim_bisr_cache_data7"].push_back(RegData("Data", "31:0", 0, 0xFFFFFFFF));
   regDataMap["shim_bisr_cache_status"].push_back(RegData("Done", "0", 0, 0x1));
   regDataMap["shim_bisr_cache_status"].push_back(RegData("Pass", "1", 1, 0x1));
   regDataMap["shim_bisr_test_data0"].push_back(RegData("Data", "31:0", 0, 0xFFFFFFFF));
   regDataMap["shim_bisr_test_data1"].push_back(RegData("Data", "31:0", 0, 0xFFFFFFFF));
   regDataMap["shim_bisr_test_data2"].push_back(RegData("Data", "31:0", 0, 0xFFFFFFFF));
   regDataMap["shim_bisr_test_data3"].push_back(RegData("Data", "31:0", 0, 0xFFFFFFFF));
   regDataMap["shim_bisr_test_data4"].push_back(RegData("Data", "31:0", 0, 0xFFFFFFFF));
   regDataMap["shim_bisr_test_data5"].push_back(RegData("Data", "31:0", 0, 0xFFFFFFFF));
   regDataMap["shim_bisr_test_data6"].push_back(RegData("Data", "31:0", 0, 0xFFFFFFFF));
   regDataMap["shim_bisr_test_data7"].push_back(RegData("Data", "31:0", 0, 0xFFFFFFFF));
   regDataMap["shim_cssd_trigger"].push_back(RegData("Trigger", "0", 0, 0x1));
   regDataMap["shim_column_clock_control"].push_back(RegData("Clock_Buffer_Enable", "0", 0, 0x1));
   regDataMap["shim_column_clock_control"].push_back(RegData("Column_SRAMs_Sleep", "1", 1, 0x1));
   regDataMap["shim_column_reset_control"].push_back(RegData("Reset", "0", 0, 0x1));
   regDataMap["shim_combo_event_control"].push_back(RegData("combo2", "17:16", 16, 0x3));
   regDataMap["shim_combo_event_control"].push_back(RegData("combo0", "1:0", 0, 0x3));
   regDataMap["shim_combo_event_control"].push_back(RegData("combo1", "9:8", 8, 0x3));
   regDataMap["shim_combo_event_inputs"].push_back(RegData("eventB", "15:8", 8, 0xFF));
   regDataMap["shim_combo_event_inputs"].push_back(RegData("eventC", "23:16", 16, 0xFF));
   regDataMap["shim_combo_event_inputs"].push_back(RegData("eventD", "31:24", 24, 0xFF));
   regDataMap["shim_combo_event_inputs"].push_back(RegData("eventA", "7:0", 0, 0xFF));
   regDataMap["shim_control_packet_handler_status"].push_back(RegData("First_Header_Parity_Error", "0", 0, 0x1));
   regDataMap["shim_control_packet_handler_status"].push_back(RegData("Second_Header_Parity_Error", "1", 1, 0x1));
   regDataMap["shim_control_packet_handler_status"].push_back(RegData("SLVERR_On_Access", "2", 2, 0x1));
   regDataMap["shim_control_packet_handler_status"].push_back(RegData("Tlast_Error", "3", 3, 0x1));
   regDataMap["shim_core_control"].push_back(RegData("Wakeup", "0", 0, 0x1));
   regDataMap["shim_core_control"].push_back(RegData("Go_To_Sleep", "1", 1, 0x1));
   regDataMap["shim_core_interrupt_status"].push_back(RegData("Go_To_Sleep", "0", 0, 0x1));
   regDataMap["shim_core_interrupt_status"].push_back(RegData("Event_Action", "1", 1, 0x1));
   regDataMap["shim_core_status"].push_back(RegData("Sleep", "0", 0, 0x1));
   regDataMap["shim_core_status"].push_back(RegData("Interrupt", "1", 1, 0x1));
   regDataMap["shim_dma_dm2mm_axi_control"].push_back(RegData("AxQOS", "3:0", 0, 0xF));
   regDataMap["shim_dma_dm2mm_axi_control"].push_back(RegData("AxCACHE", "7:4", 4, 0xF));
   regDataMap["shim_dma_dm2mm_axi_control"].push_back(RegData("Burst_Length", "9:8", 8, 0x3));
   regDataMap["shim_dma_dm2mm_control"].push_back(RegData("Reset", "0", 0, 0x1));
   regDataMap["shim_dma_dm2mm_status"].push_back(RegData("Running", "0", 0, 0x1));
   regDataMap["shim_dma_dm2mm_status"].push_back(RegData("Error_BD_Invalid", "1", 1, 0x1));
   regDataMap["shim_dma_dm2mm_status"].push_back(RegData("Task_Queue_Size", "12:8", 8, 0x1F));
   regDataMap["shim_dma_dm2mm_status"].push_back(RegData("Error_Local_address_out_of_range", "2", 2, 0x1));
   regDataMap["shim_dma_dm2mm_status"].push_back(RegData("Response_Queue_Size", "20:16", 16, 0x1F));
   regDataMap["shim_dma_dm2mm_status"].push_back(RegData("AXI_MM_SLVERR", "3", 3, 0x1));
   regDataMap["shim_dma_dm2mm_status"].push_back(RegData("AXI_MM_DECERR", "4", 4, 0x1));
   regDataMap["shim_dma_dm2mm_status"].push_back(RegData("Error_ECC_DED", "5", 5, 0x1));
   regDataMap["shim_dma_dm2mm_status"].push_back(RegData("Task_Queue_Overflow", "6", 6, 0x1));
   regDataMap["shim_dma_mm2dm_axi_control"].push_back(RegData("AxQOS", "3:0", 0, 0xF));
   regDataMap["shim_dma_mm2dm_axi_control"].push_back(RegData("AxCACHE", "7:4", 4, 0xF));
   regDataMap["shim_dma_mm2dm_axi_control"].push_back(RegData("Burst_Length", "9:8", 8, 0x3));
   regDataMap["shim_dma_mm2dm_control"].push_back(RegData("Reset", "0", 0, 0x1));
   regDataMap["shim_dma_mm2dm_status"].push_back(RegData("Running", "0", 0, 0x1));
   regDataMap["shim_dma_mm2dm_status"].push_back(RegData("Error_BD_Invalid", "1", 1, 0x1));
   regDataMap["shim_dma_mm2dm_status"].push_back(RegData("Task_Queue_Size", "12:8", 8, 0x1F));
   regDataMap["shim_dma_mm2dm_status"].push_back(RegData("Error_Local_address_out_of_range", "2", 2, 0x1));
   regDataMap["shim_dma_mm2dm_status"].push_back(RegData("Response_Queue_Size", "20:16", 16, 0x1F));
   regDataMap["shim_dma_mm2dm_status"].push_back(RegData("AXI_MM_SLVERR", "3", 3, 0x1));
   regDataMap["shim_dma_mm2dm_status"].push_back(RegData("AXI_MM_DECERR", "4", 4, 0x1));
   regDataMap["shim_dma_mm2dm_status"].push_back(RegData("Error_ECC_DED", "5", 5, 0x1));
   regDataMap["shim_dma_mm2dm_status"].push_back(RegData("Task_Queue_Overflow", "6", 6, 0x1));
   regDataMap["shim_dma_mm2s_0_ctrl"].push_back(RegData("Controller_ID", "15:8", 8, 0xFF));
   regDataMap["shim_dma_mm2s_0_ctrl"].push_back(RegData("Pause_Stream", "2", 2, 0x1));
   regDataMap["shim_dma_mm2s_0_response_fifo_parity_error_injection"].push_back(RegData("Parity_Injection", "3:0", 0, 0xF));
   regDataMap["shim_dma_mm2s_0_task_queue"].push_back(RegData("Repeat_Count", "23:16", 16, 0xFF));
   regDataMap["shim_dma_mm2s_0_task_queue"].push_back(RegData("Enable_Token_Issue", "31", 31, 0x1));
   regDataMap["shim_dma_mm2s_0_task_queue"].push_back(RegData("Start_BD_ID", "3:0", 0, 0xF));
   regDataMap["shim_dma_mm2s_1_ctrl"].push_back(RegData("Controller_ID", "15:8", 8, 0xFF));
   regDataMap["shim_dma_mm2s_1_ctrl"].push_back(RegData("Pause_Stream", "2", 2, 0x1));
   regDataMap["shim_dma_mm2s_1_response_fifo_parity_error_injection"].push_back(RegData("Parity_Injection", "3:0", 0, 0xF));
   regDataMap["shim_dma_mm2s_1_task_queue"].push_back(RegData("Repeat_Count", "23:16", 16, 0xFF));
   regDataMap["shim_dma_mm2s_1_task_queue"].push_back(RegData("Enable_Token_Issue", "31", 31, 0x1));
   regDataMap["shim_dma_mm2s_1_task_queue"].push_back(RegData("Start_BD_ID", "3:0", 0, 0xF));
   regDataMap["shim_dma_mm2s_status_0"].push_back(RegData("Error_BD_Invalid", "11", 11, 0x1));
   regDataMap["shim_dma_mm2s_status_0"].push_back(RegData("AXI_MM_Decode_Error", "16", 16, 0x1));
   regDataMap["shim_dma_mm2s_status_0"].push_back(RegData("AXI_MM_Slave_Error", "17", 17, 0x1));
   regDataMap["shim_dma_mm2s_status_0"].push_back(RegData("Task_Queue_Overflow", "18", 18, 0x1));
   regDataMap["shim_dma_mm2s_status_0"].push_back(RegData("Channel_Running", "19", 19, 0x1));
   regDataMap["shim_dma_mm2s_status_0"].push_back(RegData("Status", "1:0", 0, 0x3));
   regDataMap["shim_dma_mm2s_status_0"].push_back(RegData("Stalled_Lock_Acq", "2", 2, 0x1));
   regDataMap["shim_dma_mm2s_status_0"].push_back(RegData("Task_Queue_Size", "24:20", 20, 0x1F));
   regDataMap["shim_dma_mm2s_status_0"].push_back(RegData("Cur_BD", "28:25", 25, 0xF));
   regDataMap["shim_dma_mm2s_status_0"].push_back(RegData("Stalled_Lock_Rel", "3", 3, 0x1));
   regDataMap["shim_dma_mm2s_status_0"].push_back(RegData("Stalled_Stream_Backpressure", "4", 4, 0x1));
   regDataMap["shim_dma_mm2s_status_0"].push_back(RegData("Stalled_TCT", "5", 5, 0x1));
   regDataMap["shim_dma_mm2s_status_1"].push_back(RegData("Error_BD_Invalid", "11", 11, 0x1));
   regDataMap["shim_dma_mm2s_status_1"].push_back(RegData("AXI_MM_Decode_Error", "16", 16, 0x1));
   regDataMap["shim_dma_mm2s_status_1"].push_back(RegData("AXI_MM_Slave_Error", "17", 17, 0x1));
   regDataMap["shim_dma_mm2s_status_1"].push_back(RegData("Task_Queue_Overflow", "18", 18, 0x1));
   regDataMap["shim_dma_mm2s_status_1"].push_back(RegData("Channel_Running", "19", 19, 0x1));
   regDataMap["shim_dma_mm2s_status_1"].push_back(RegData("Status", "1:0", 0, 0x3));
   regDataMap["shim_dma_mm2s_status_1"].push_back(RegData("Stalled_Lock_Acq", "2", 2, 0x1));
   regDataMap["shim_dma_mm2s_status_1"].push_back(RegData("Task_Queue_Size", "24:20", 20, 0x1F));
   regDataMap["shim_dma_mm2s_status_1"].push_back(RegData("Cur_BD", "28:25", 25, 0xF));
   regDataMap["shim_dma_mm2s_status_1"].push_back(RegData("Stalled_Lock_Rel", "3", 3, 0x1));
   regDataMap["shim_dma_mm2s_status_1"].push_back(RegData("Stalled_Stream_Backpressure", "4", 4, 0x1));
   regDataMap["shim_dma_mm2s_status_1"].push_back(RegData("Stalled_TCT", "5", 5, 0x1));
   regDataMap["shim_dma_pause"].push_back(RegData("S2MM_0", "0", 0, 0x1));
   regDataMap["shim_dma_pause"].push_back(RegData("S2MM_1", "1", 1, 0x1));
   regDataMap["shim_dma_pause"].push_back(RegData("MM2S_0", "2", 2, 0x1));
   regDataMap["shim_dma_pause"].push_back(RegData("MM2S_1", "3", 3, 0x1));
   regDataMap["shim_dma_pause"].push_back(RegData("DM2MM", "0", 0, 0x1));
   regDataMap["shim_dma_pause"].push_back(RegData("MM2DM", "1", 1, 0x1));
   regDataMap["shim_dma_s2mm_0_ctrl"].push_back(RegData("Controller_ID", "15:8", 8, 0xFF));
   regDataMap["shim_dma_s2mm_0_ctrl"].push_back(RegData("FoT_Mode", "17:16", 16, 0x3));
   regDataMap["shim_dma_s2mm_0_ctrl"].push_back(RegData("Pause_Stream", "2", 2, 0x1));
   regDataMap["shim_dma_s2mm_0_ctrl"].push_back(RegData("Enable_Out_of_Order", "3", 3, 0x1));
   regDataMap["shim_dma_s2mm_0_task_queue"].push_back(RegData("Repeat_Count", "23:16", 16, 0xFF));
   regDataMap["shim_dma_s2mm_0_task_queue"].push_back(RegData("Enable_Token_Issue", "31", 31, 0x1));
   regDataMap["shim_dma_s2mm_0_task_queue"].push_back(RegData("Start_BD_ID", "3:0", 0, 0xF));
   regDataMap["shim_dma_s2mm_1_ctrl"].push_back(RegData("Controller_ID", "15:8", 8, 0xFF));
   regDataMap["shim_dma_s2mm_1_ctrl"].push_back(RegData("FoT_Mode", "17:16", 16, 0x3));
   regDataMap["shim_dma_s2mm_1_ctrl"].push_back(RegData("Pause_Stream", "2", 2, 0x1));
   regDataMap["shim_dma_s2mm_1_ctrl"].push_back(RegData("Enable_Out_of_Order", "3", 3, 0x1));
   regDataMap["shim_dma_s2mm_1_task_queue"].push_back(RegData("Repeat_Count", "23:16", 16, 0xFF));
   regDataMap["shim_dma_s2mm_1_task_queue"].push_back(RegData("Enable_Token_Issue", "31", 31, 0x1));
   regDataMap["shim_dma_s2mm_1_task_queue"].push_back(RegData("Start_BD_ID", "3:0", 0, 0xF));
   regDataMap["shim_dma_s2mm_current_write_count_0"].push_back(RegData("Current_Write_Count", "17:0", 0, 0x3FFFF));
   regDataMap["shim_dma_s2mm_current_write_count_1"].push_back(RegData("Current_Write_Count", "17:0", 0, 0x3FFFF));
   regDataMap["shim_dma_s2mm_fot_count_fifo_pop_0"].push_back(RegData("Write_Count", "17:0", 0, 0x3FFFF));
   regDataMap["shim_dma_s2mm_fot_count_fifo_pop_0"].push_back(RegData("BD_ID", "29:24", 24, 0x3F));
   regDataMap["shim_dma_s2mm_fot_count_fifo_pop_0"].push_back(RegData("Last_in_Task", "30", 30, 0x1));
   regDataMap["shim_dma_s2mm_fot_count_fifo_pop_0"].push_back(RegData("Valid", "31", 31, 0x1));
   regDataMap["shim_dma_s2mm_fot_count_fifo_pop_1"].push_back(RegData("Write_Count", "17:0", 0, 0x3FFFF));
   regDataMap["shim_dma_s2mm_fot_count_fifo_pop_1"].push_back(RegData("BD_ID", "29:24", 24, 0x3F));
   regDataMap["shim_dma_s2mm_fot_count_fifo_pop_1"].push_back(RegData("Last_in_Task", "30", 30, 0x1));
   regDataMap["shim_dma_s2mm_fot_count_fifo_pop_1"].push_back(RegData("Valid", "31", 31, 0x1));
   regDataMap["shim_dma_s2mm_status_0"].push_back(RegData("Error_BD_Unavailable", "10", 10, 0x1));
   regDataMap["shim_dma_s2mm_status_0"].push_back(RegData("Error_BD_Invalid", "11", 11, 0x1));
   regDataMap["shim_dma_s2mm_status_0"].push_back(RegData("Error_FoT_Length_Exceeded", "12", 12, 0x1));
   regDataMap["shim_dma_s2mm_status_0"].push_back(RegData("Error_FoT_BDs_per_Task", "13", 13, 0x1));
   regDataMap["shim_dma_s2mm_status_0"].push_back(RegData("AXI_MM_Decode_Error", "16", 16, 0x1));
   regDataMap["shim_dma_s2mm_status_0"].push_back(RegData("AXI_MM_Slave_Error", "17", 17, 0x1));
   regDataMap["shim_dma_s2mm_status_0"].push_back(RegData("Task_Queue_Overflow", "18", 18, 0x1));
   regDataMap["shim_dma_s2mm_status_0"].push_back(RegData("Channel_Running", "19", 19, 0x1));
   regDataMap["shim_dma_s2mm_status_0"].push_back(RegData("Status", "1:0", 0, 0x3));
   regDataMap["shim_dma_s2mm_status_0"].push_back(RegData("Stalled_Lock_Acq", "2", 2, 0x1));
   regDataMap["shim_dma_s2mm_status_0"].push_back(RegData("Task_Queue_Size", "22:20", 20, 0x7));
   regDataMap["shim_dma_s2mm_status_0"].push_back(RegData("Cur_BD", "27:24", 24, 0xF));
   regDataMap["shim_dma_s2mm_status_0"].push_back(RegData("Stalled_Lock_Rel", "3", 3, 0x1));
   regDataMap["shim_dma_s2mm_status_0"].push_back(RegData("Stalled_Stream_Starvation", "4", 4, 0x1));
   regDataMap["shim_dma_s2mm_status_0"].push_back(RegData("Stalled_TCT_or_Count_FIFO_Full", "5", 5, 0x1));
   regDataMap["shim_dma_s2mm_status_1"].push_back(RegData("Error_BD_Unavailable", "10", 10, 0x1));
   regDataMap["shim_dma_s2mm_status_1"].push_back(RegData("Error_BD_Invalid", "11", 11, 0x1));
   regDataMap["shim_dma_s2mm_status_1"].push_back(RegData("Error_FoT_Length_Exceeded", "12", 12, 0x1));
   regDataMap["shim_dma_s2mm_status_1"].push_back(RegData("Error_FoT_BDs_per_Task", "13", 13, 0x1));
   regDataMap["shim_dma_s2mm_status_1"].push_back(RegData("AXI_MM_Decode_Error", "16", 16, 0x1));
   regDataMap["shim_dma_s2mm_status_1"].push_back(RegData("AXI_MM_Slave_Error", "17", 17, 0x1));
   regDataMap["shim_dma_s2mm_status_1"].push_back(RegData("Task_Queue_Overflow", "18", 18, 0x1));
   regDataMap["shim_dma_s2mm_status_1"].push_back(RegData("Channel_Running", "19", 19, 0x1));
   regDataMap["shim_dma_s2mm_status_1"].push_back(RegData("Status", "1:0", 0, 0x3));
   regDataMap["shim_dma_s2mm_status_1"].push_back(RegData("Stalled_Lock_Acq", "2", 2, 0x1));
   regDataMap["shim_dma_s2mm_status_1"].push_back(RegData("Task_Queue_Size", "22:20", 20, 0x7));
   regDataMap["shim_dma_s2mm_status_1"].push_back(RegData("Cur_BD", "27:24", 24, 0xF));
   regDataMap["shim_dma_s2mm_status_1"].push_back(RegData("Stalled_Lock_Rel", "3", 3, 0x1));
   regDataMap["shim_dma_s2mm_status_1"].push_back(RegData("Stalled_Stream_Starvation", "4", 4, 0x1));
   regDataMap["shim_dma_s2mm_status_1"].push_back(RegData("Stalled_TCT_or_Count_FIFO_Full", "5", 5, 0x1));
   regDataMap["shim_demux_config"].push_back(RegData("South5", "11:10", 10, 0x3));
   regDataMap["shim_demux_config"].push_back(RegData("South1", "3:2", 2, 0x3));
   regDataMap["shim_demux_config"].push_back(RegData("South2", "5:4", 4, 0x3));
   regDataMap["shim_demux_config"].push_back(RegData("South3", "7:6", 6, 0x3));
   regDataMap["shim_edge_detection_event_control"].push_back(RegData("Edge_Detection_0_Trigger_Falling", "10", 10, 0x1));
   regDataMap["shim_edge_detection_event_control"].push_back(RegData("Edge_Detection_Event_1", "23:16", 16, 0xFF));
   regDataMap["shim_edge_detection_event_control"].push_back(RegData("Edge_Detection_1_Trigger_Rising", "25", 25, 0x1));
   regDataMap["shim_edge_detection_event_control"].push_back(RegData("Edge_Detection_1_Trigger_Falling", "26", 26, 0x1));
   regDataMap["shim_edge_detection_event_control"].push_back(RegData("Edge_Detection_Event_0", "7:0", 0, 0xFF));
   regDataMap["shim_edge_detection_event_control"].push_back(RegData("Edge_Detection_0_Trigger_Rising", "9", 9, 0x1));
   regDataMap["shim_event_broadcast0_a"].push_back(RegData("Event", "7:0", 0, 0xFF));
   regDataMap["shim_event_broadcast10_a"].push_back(RegData("Event", "7:0", 0, 0xFF));
   regDataMap["shim_event_broadcast11_a"].push_back(RegData("Event", "7:0", 0, 0xFF));
   regDataMap["shim_event_broadcast12_a"].push_back(RegData("Event", "7:0", 0, 0xFF));
   regDataMap["shim_event_broadcast13_a"].push_back(RegData("Event", "7:0", 0, 0xFF));
   regDataMap["shim_event_broadcast14_a"].push_back(RegData("Event", "7:0", 0, 0xFF));
   regDataMap["shim_event_broadcast15_a"].push_back(RegData("Event", "7:0", 0, 0xFF));
   regDataMap["shim_event_broadcast1_a"].push_back(RegData("Event", "7:0", 0, 0xFF));
   regDataMap["shim_event_broadcast2_a"].push_back(RegData("Event", "7:0", 0, 0xFF));
   regDataMap["shim_event_broadcast3_a"].push_back(RegData("Event", "7:0", 0, 0xFF));
   regDataMap["shim_event_broadcast4_a"].push_back(RegData("Event", "7:0", 0, 0xFF));
   regDataMap["shim_event_broadcast5_a"].push_back(RegData("Event", "7:0", 0, 0xFF));
   regDataMap["shim_event_broadcast6_a"].push_back(RegData("Event", "7:0", 0, 0xFF));
   regDataMap["shim_event_broadcast7_a"].push_back(RegData("Event", "7:0", 0, 0xFF));
   regDataMap["shim_event_broadcast8_a"].push_back(RegData("Event", "7:0", 0, 0xFF));
   regDataMap["shim_event_broadcast9_a"].push_back(RegData("Event", "7:0", 0, 0xFF));
   regDataMap["shim_event_broadcast_a_block_east_clr"].push_back(RegData("Clear", "15:0", 0, 0xFFFF));
   regDataMap["shim_event_broadcast_a_block_east_set"].push_back(RegData("Set", "15:0", 0, 0xFFFF));
   regDataMap["shim_event_broadcast_a_block_east_value"].push_back(RegData("Value", "15:0", 0, 0xFFFF));
   regDataMap["shim_event_broadcast_a_block_north_clr"].push_back(RegData("Clear", "15:0", 0, 0xFFFF));
   regDataMap["shim_event_broadcast_a_block_north_set"].push_back(RegData("Set", "15:0", 0, 0xFFFF));
   regDataMap["shim_event_broadcast_a_block_north_value"].push_back(RegData("Value", "15:0", 0, 0xFFFF));
   regDataMap["shim_event_broadcast_a_block_south_clr"].push_back(RegData("Clear", "15:0", 0, 0xFFFF));
   regDataMap["shim_event_broadcast_a_block_south_set"].push_back(RegData("Set", "15:0", 0, 0xFFFF));
   regDataMap["shim_event_broadcast_a_block_south_value"].push_back(RegData("Value", "15:0", 0, 0xFFFF));
   regDataMap["shim_event_broadcast_a_block_west_clr"].push_back(RegData("Clear", "15:0", 0, 0xFFFF));
   regDataMap["shim_event_broadcast_a_block_west_set"].push_back(RegData("Set", "15:0", 0, 0xFFFF));
   regDataMap["shim_event_broadcast_a_block_west_value"].push_back(RegData("Value", "15:0", 0, 0xFFFF));
   regDataMap["shim_event_broadcast_b_block_east_clr"].push_back(RegData("Clear", "15:0", 0, 0xFFFF));
   regDataMap["shim_event_broadcast_b_block_east_set"].push_back(RegData("Set", "15:0", 0, 0xFFFF));
   regDataMap["shim_event_broadcast_b_block_east_value"].push_back(RegData("Value", "15:0", 0, 0xFFFF));
   regDataMap["shim_event_broadcast_b_block_north_clr"].push_back(RegData("Clear", "15:0", 0, 0xFFFF));
   regDataMap["shim_event_broadcast_b_block_north_set"].push_back(RegData("Set", "15:0", 0, 0xFFFF));
   regDataMap["shim_event_broadcast_b_block_north_value"].push_back(RegData("Value", "15:0", 0, 0xFFFF));
   regDataMap["shim_event_broadcast_b_block_south_clr"].push_back(RegData("Clear", "15:0", 0, 0xFFFF));
   regDataMap["shim_event_broadcast_b_block_south_set"].push_back(RegData("Set", "15:0", 0, 0xFFFF));
   regDataMap["shim_event_broadcast_b_block_south_value"].push_back(RegData("Value", "15:0", 0, 0xFFFF));
   regDataMap["shim_event_broadcast_b_block_west_clr"].push_back(RegData("Clear", "15:0", 0, 0xFFFF));
   regDataMap["shim_event_broadcast_b_block_west_set"].push_back(RegData("Set", "15:0", 0, 0xFFFF));
   regDataMap["shim_event_broadcast_b_block_west_value"].push_back(RegData("Value", "15:0", 0, 0xFFFF));
   regDataMap["shim_event_generate"].push_back(RegData("Event", "7:0", 0, 0xFF));
   regDataMap["shim_event_group_0_enable"].push_back(RegData("Timer_Sync", "0", 0, 0x1));
   regDataMap["shim_event_group_0_enable"].push_back(RegData("Timer_Value_Reached", "1", 1, 0x1));
   regDataMap["shim_event_group_0_enable"].push_back(RegData("Perf_Cnt0", "2", 2, 0x1));
   regDataMap["shim_event_group_0_enable"].push_back(RegData("Perf_Cnt1", "3", 3, 0x1));
   regDataMap["shim_event_group_0_enable"].push_back(RegData("Combo_Event_0", "4", 4, 0x1));
   regDataMap["shim_event_group_0_enable"].push_back(RegData("Combo_Event_1", "5", 5, 0x1));
   regDataMap["shim_event_group_0_enable"].push_back(RegData("Combo_Event_2", "6", 6, 0x1));
   regDataMap["shim_event_group_0_enable"].push_back(RegData("Combo_Event_3", "7", 7, 0x1));
   regDataMap["shim_event_group_0_enable"].push_back(RegData("Edge_Detection_Event_0", "8", 8, 0x1));
   regDataMap["shim_event_group_0_enable"].push_back(RegData("Edge_Detection_Event_1", "9", 9, 0x1));
   regDataMap["shim_event_group_broadcast_a_enable"].push_back(RegData("Broadcast_A_0", "0", 0, 0x1));
   regDataMap["shim_event_group_broadcast_a_enable"].push_back(RegData("Broadcast_A_1", "1", 1, 0x1));
   regDataMap["shim_event_group_broadcast_a_enable"].push_back(RegData("Broadcast_A_10", "10", 10, 0x1));
   regDataMap["shim_event_group_broadcast_a_enable"].push_back(RegData("Broadcast_A_11", "11", 11, 0x1));
   regDataMap["shim_event_group_broadcast_a_enable"].push_back(RegData("Broadcast_A_12", "12", 12, 0x1));
   regDataMap["shim_event_group_broadcast_a_enable"].push_back(RegData("Broadcast_A_13", "13", 13, 0x1));
   regDataMap["shim_event_group_broadcast_a_enable"].push_back(RegData("Broadcast_A_14", "14", 14, 0x1));
   regDataMap["shim_event_group_broadcast_a_enable"].push_back(RegData("Broadcast_A_15", "15", 15, 0x1));
   regDataMap["shim_event_group_broadcast_a_enable"].push_back(RegData("Broadcast_A_2", "2", 2, 0x1));
   regDataMap["shim_event_group_broadcast_a_enable"].push_back(RegData("Broadcast_A_3", "3", 3, 0x1));
   regDataMap["shim_event_group_broadcast_a_enable"].push_back(RegData("Broadcast_A_4", "4", 4, 0x1));
   regDataMap["shim_event_group_broadcast_a_enable"].push_back(RegData("Broadcast_A_5", "5", 5, 0x1));
   regDataMap["shim_event_group_broadcast_a_enable"].push_back(RegData("Broadcast_A_6", "6", 6, 0x1));
   regDataMap["shim_event_group_broadcast_a_enable"].push_back(RegData("Broadcast_A_7", "7", 7, 0x1));
   regDataMap["shim_event_group_broadcast_a_enable"].push_back(RegData("Broadcast_A_8", "8", 8, 0x1));
   regDataMap["shim_event_group_broadcast_a_enable"].push_back(RegData("Broadcast_A_9", "9", 9, 0x1));
   regDataMap["shim_event_group_errors_enable"].push_back(RegData("AXI_MM_Slave_Tile_Error", "0", 0, 0x1));
   regDataMap["shim_event_group_errors_enable"].push_back(RegData("Control_Pkt_Error", "1", 1, 0x1));
   regDataMap["shim_event_group_errors_enable"].push_back(RegData("NoC_0_DMA_MM2S_Error", "10", 10, 0x1));
   regDataMap["shim_event_group_errors_enable"].push_back(RegData("NoC_1_DMA_MM2S_Error", "11", 11, 0x1));
   regDataMap["shim_event_group_errors_enable"].push_back(RegData("NoC_0_Lock_Error", "12", 12, 0x1));
   regDataMap["shim_event_group_errors_enable"].push_back(RegData("NoC_1_Lock_Error", "13", 13, 0x1));
   regDataMap["shim_event_group_errors_enable"].push_back(RegData("NoC_0_DMA_Task_Token_Stall", "14", 14, 0x1));
   regDataMap["shim_event_group_errors_enable"].push_back(RegData("NoC_1_DMA_Task_Token_Stall", "15", 15, 0x1));
   regDataMap["shim_event_group_errors_enable"].push_back(RegData("NoC_0_DMA_HW_Error", "16", 16, 0x1));
   regDataMap["shim_event_group_errors_enable"].push_back(RegData("NoC_1_DMA_HW_Error", "17", 17, 0x1));
   regDataMap["shim_event_group_errors_enable"].push_back(RegData("Stream_Switch_Port_Parity_Error", "2", 2, 0x1));
   regDataMap["shim_event_group_errors_enable"].push_back(RegData("AXI_MM_Decode_NSU_Error", "3", 3, 0x1));
   regDataMap["shim_event_group_errors_enable"].push_back(RegData("AXI_MM_Slave_NSU_Error", "4", 4, 0x1));
   regDataMap["shim_event_group_errors_enable"].push_back(RegData("AXI_MM_Unsupported_Traffic", "5", 5, 0x1));
   regDataMap["shim_event_group_errors_enable"].push_back(RegData("AXI_MM_Unsecure_Access_in_Secure_Mode", "6", 6, 0x1));
   regDataMap["shim_event_group_errors_enable"].push_back(RegData("AXI_MM_Byte_Strobe_Error", "7", 7, 0x1));
   regDataMap["shim_event_group_errors_enable"].push_back(RegData("NoC_0_DMA_S2MM_Error", "8", 8, 0x1));
   regDataMap["shim_event_group_errors_enable"].push_back(RegData("NoC_1_DMA_S2MM_Error", "9", 9, 0x1));
   regDataMap["shim_event_group_noc_0_dma_activity_enable"].push_back(RegData("NoC_0_DMA_S2MM_0_start_task", "0", 0, 0x1));
   regDataMap["shim_event_group_noc_0_dma_activity_enable"].push_back(RegData("NoC_0_DMA_S2MM_1_start_task", "1", 1, 0x1));
   regDataMap["shim_event_group_noc_0_dma_activity_enable"].push_back(RegData("NoC_0_DMA_MM2S_0_finished_task", "10", 10, 0x1));
   regDataMap["shim_event_group_noc_0_dma_activity_enable"].push_back(RegData("NoC_0_DMA_MM2S_1_finished_task", "11", 11, 0x1));
   regDataMap["shim_event_group_noc_0_dma_activity_enable"].push_back(RegData("NoC_0_DMA_S2MM_0_stalled_lock_acquire", "12", 12, 0x1));
   regDataMap["shim_event_group_noc_0_dma_activity_enable"].push_back(RegData("NoC_0_DMA_S2MM_1_stalled_lock_acquire", "13", 13, 0x1));
   regDataMap["shim_event_group_noc_0_dma_activity_enable"].push_back(RegData("NoC_0_DMA_MM2S_0_stalled_lock_acquire", "14", 14, 0x1));
   regDataMap["shim_event_group_noc_0_dma_activity_enable"].push_back(RegData("NoC_0_DMA_MM2S_1_stalled_lock_acquire", "15", 15, 0x1));
   regDataMap["shim_event_group_noc_0_dma_activity_enable"].push_back(RegData("NoC_0_DMA_S2MM_0_stream_starvation", "16", 16, 0x1));
   regDataMap["shim_event_group_noc_0_dma_activity_enable"].push_back(RegData("NoC_0_DMA_S2MM_1_stream_starvation", "17", 17, 0x1));
   regDataMap["shim_event_group_noc_0_dma_activity_enable"].push_back(RegData("NoC_0_DMA_S2MM_0_memory_backpressure", "18", 18, 0x1));
   regDataMap["shim_event_group_noc_0_dma_activity_enable"].push_back(RegData("NoC_0_DMA_S2MM_1_memory_backpressure", "19", 19, 0x1));
   regDataMap["shim_event_group_noc_0_dma_activity_enable"].push_back(RegData("NoC_0_DMA_MM2S_0_start_task", "2", 2, 0x1));
   regDataMap["shim_event_group_noc_0_dma_activity_enable"].push_back(RegData("NoC_0_DMA_MM2S_0_stream_backpressure", "20", 20, 0x1));
   regDataMap["shim_event_group_noc_0_dma_activity_enable"].push_back(RegData("NoC_0_DMA_MM2S_1_stream_backpressure", "21", 21, 0x1));
   regDataMap["shim_event_group_noc_0_dma_activity_enable"].push_back(RegData("NoC_0_DMA_MM2S_0_memory_starvation", "22", 22, 0x1));
   regDataMap["shim_event_group_noc_0_dma_activity_enable"].push_back(RegData("NoC_0_DMA_MM2S_1_memory_starvation", "23", 23, 0x1));
   regDataMap["shim_event_group_noc_0_dma_activity_enable"].push_back(RegData("NoC_0_DMA_MM2S_1_start_task", "3", 3, 0x1));
   regDataMap["shim_event_group_noc_0_dma_activity_enable"].push_back(RegData("NoC_0_DMA_S2MM_0_finished_BD", "4", 4, 0x1));
   regDataMap["shim_event_group_noc_0_dma_activity_enable"].push_back(RegData("NoC_0_DMA_S2MM_1_finished_BD", "5", 5, 0x1));
   regDataMap["shim_event_group_noc_0_dma_activity_enable"].push_back(RegData("NoC_0_DMA_MM2S_0_finished_BD", "6", 6, 0x1));
   regDataMap["shim_event_group_noc_0_dma_activity_enable"].push_back(RegData("NoC_0_DMA_MM2S_1_finished_BD", "7", 7, 0x1));
   regDataMap["shim_event_group_noc_0_dma_activity_enable"].push_back(RegData("NoC_0_DMA_S2MM_0_finished_task", "8", 8, 0x1));
   regDataMap["shim_event_group_noc_0_dma_activity_enable"].push_back(RegData("NoC_0_DMA_S2MM_1_finished_task", "9", 9, 0x1));
   regDataMap["shim_event_group_noc_0_lock_enable"].push_back(RegData("NoC_0_Lock_Sel0_acq_eq", "0", 0, 0x1));
   regDataMap["shim_event_group_noc_0_lock_enable"].push_back(RegData("NoC_0_Lock_Sel0_acq_ge", "1", 1, 0x1));
   regDataMap["shim_event_group_noc_0_lock_enable"].push_back(RegData("NoC_0_Lock_Sel2_rel", "10", 10, 0x1));
   regDataMap["shim_event_group_noc_0_lock_enable"].push_back(RegData("NoC_0_Lock_Sel2_equal_to_value", "11", 11, 0x1));
   regDataMap["shim_event_group_noc_0_lock_enable"].push_back(RegData("NoC_0_Lock_Sel3_acq_eq", "12", 12, 0x1));
   regDataMap["shim_event_group_noc_0_lock_enable"].push_back(RegData("NoC_0_Lock_Sel3_acq_ge", "13", 13, 0x1));
   regDataMap["shim_event_group_noc_0_lock_enable"].push_back(RegData("NoC_0_Lock_Sel3_rel", "14", 14, 0x1));
   regDataMap["shim_event_group_noc_0_lock_enable"].push_back(RegData("NoC_0_Lock_Sel3_equal_to_value", "15", 15, 0x1));
   regDataMap["shim_event_group_noc_0_lock_enable"].push_back(RegData("NoC_0_Lock_Sel4_acq_eq", "16", 16, 0x1));
   regDataMap["shim_event_group_noc_0_lock_enable"].push_back(RegData("NoC_0_Lock_Sel4_acq_ge", "17", 17, 0x1));
   regDataMap["shim_event_group_noc_0_lock_enable"].push_back(RegData("NoC_0_Lock_Sel4_rel", "18", 18, 0x1));
   regDataMap["shim_event_group_noc_0_lock_enable"].push_back(RegData("NoC_0_Lock_Sel4_equal_to_value", "19", 19, 0x1));
   regDataMap["shim_event_group_noc_0_lock_enable"].push_back(RegData("NoC_0_Lock_Sel0_rel", "2", 2, 0x1));
   regDataMap["shim_event_group_noc_0_lock_enable"].push_back(RegData("NoC_0_Lock_Sel5_acq_eq", "20", 20, 0x1));
   regDataMap["shim_event_group_noc_0_lock_enable"].push_back(RegData("NoC_0_Lock_Sel5_acq_ge", "21", 21, 0x1));
   regDataMap["shim_event_group_noc_0_lock_enable"].push_back(RegData("NoC_0_Lock_Sel5_rel", "22", 22, 0x1));
   regDataMap["shim_event_group_noc_0_lock_enable"].push_back(RegData("NoC_0_Lock_Sel5_equal_to_value", "23", 23, 0x1));
   regDataMap["shim_event_group_noc_0_lock_enable"].push_back(RegData("NoC_0_Lock_Sel0_equal_to_value", "3", 3, 0x1));
   regDataMap["shim_event_group_noc_0_lock_enable"].push_back(RegData("NoC_0_Lock_Sel1_acq_eq", "4", 4, 0x1));
   regDataMap["shim_event_group_noc_0_lock_enable"].push_back(RegData("NoC_0_Lock_Sel1_acq_ge", "5", 5, 0x1));
   regDataMap["shim_event_group_noc_0_lock_enable"].push_back(RegData("NoC_0_Lock_Sel1_rel", "6", 6, 0x1));
   regDataMap["shim_event_group_noc_0_lock_enable"].push_back(RegData("NoC_0_Lock_Sel1_equal_to_value", "7", 7, 0x1));
   regDataMap["shim_event_group_noc_0_lock_enable"].push_back(RegData("NoC_0_Lock_Sel2_acq_eq", "8", 8, 0x1));
   regDataMap["shim_event_group_noc_0_lock_enable"].push_back(RegData("NoC_0_Lock_Sel2_acq_ge", "9", 9, 0x1));
   regDataMap["shim_event_group_noc_1_dma_activity_enable"].push_back(RegData("NoC_1_DMA_S2MM_0_start_task", "0", 0, 0x1));
   regDataMap["shim_event_group_noc_1_dma_activity_enable"].push_back(RegData("NoC_1_DMA_S2MM_1_start_task", "1", 1, 0x1));
   regDataMap["shim_event_group_noc_1_dma_activity_enable"].push_back(RegData("NoC_1_DMA_MM2S_0_finished_task", "10", 10, 0x1));
   regDataMap["shim_event_group_noc_1_dma_activity_enable"].push_back(RegData("NoC_1_DMA_MM2S_1_finished_task", "11", 11, 0x1));
   regDataMap["shim_event_group_noc_1_dma_activity_enable"].push_back(RegData("NoC_1_DMA_S2MM_0_stalled_lock_acquire", "12", 12, 0x1));
   regDataMap["shim_event_group_noc_1_dma_activity_enable"].push_back(RegData("NoC_1_DMA_S2MM_1_stalled_lock_acquire", "13", 13, 0x1));
   regDataMap["shim_event_group_noc_1_dma_activity_enable"].push_back(RegData("NoC_1_DMA_MM2S_0_stalled_lock_acquire", "14", 14, 0x1));
   regDataMap["shim_event_group_noc_1_dma_activity_enable"].push_back(RegData("NoC_1_DMA_MM2S_1_stalled_lock_acquire", "15", 15, 0x1));
   regDataMap["shim_event_group_noc_1_dma_activity_enable"].push_back(RegData("NoC_1_DMA_S2MM_0_stream_starvation", "16", 16, 0x1));
   regDataMap["shim_event_group_noc_1_dma_activity_enable"].push_back(RegData("NoC_1_DMA_S2MM_1_stream_starvation", "17", 17, 0x1));
   regDataMap["shim_event_group_noc_1_dma_activity_enable"].push_back(RegData("NoC_1_DMA_S2MM_0_memory_backpressure", "18", 18, 0x1));
   regDataMap["shim_event_group_noc_1_dma_activity_enable"].push_back(RegData("NoC_1_DMA_S2MM_1_memory_backpressure", "19", 19, 0x1));
   regDataMap["shim_event_group_noc_1_dma_activity_enable"].push_back(RegData("NoC_1_DMA_MM2S_0_start_task", "2", 2, 0x1));
   regDataMap["shim_event_group_noc_1_dma_activity_enable"].push_back(RegData("NoC_1_DMA_MM2S_0_stream_backpressure", "20", 20, 0x1));
   regDataMap["shim_event_group_noc_1_dma_activity_enable"].push_back(RegData("NoC_1_DMA_MM2S_1_stream_backpressure", "21", 21, 0x1));
   regDataMap["shim_event_group_noc_1_dma_activity_enable"].push_back(RegData("NoC_1_DMA_MM2S_0_memory_starvation", "22", 22, 0x1));
   regDataMap["shim_event_group_noc_1_dma_activity_enable"].push_back(RegData("NoC_1_DMA_MM2S_1_memory_starvation", "23", 23, 0x1));
   regDataMap["shim_event_group_noc_1_dma_activity_enable"].push_back(RegData("NoC_1_DMA_MM2S_1_start_task", "3", 3, 0x1));
   regDataMap["shim_event_group_noc_1_dma_activity_enable"].push_back(RegData("NoC_1_DMA_S2MM_0_finished_BD", "4", 4, 0x1));
   regDataMap["shim_event_group_noc_1_dma_activity_enable"].push_back(RegData("NoC_1_DMA_S2MM_1_finished_BD", "5", 5, 0x1));
   regDataMap["shim_event_group_noc_1_dma_activity_enable"].push_back(RegData("NoC_1_DMA_MM2S_0_finished_BD", "6", 6, 0x1));
   regDataMap["shim_event_group_noc_1_dma_activity_enable"].push_back(RegData("NoC_1_DMA_MM2S_1_finished_BD", "7", 7, 0x1));
   regDataMap["shim_event_group_noc_1_dma_activity_enable"].push_back(RegData("NoC_1_DMA_S2MM_0_finished_task", "8", 8, 0x1));
   regDataMap["shim_event_group_noc_1_dma_activity_enable"].push_back(RegData("NoC_1_DMA_S2MM_1_finished_task", "9", 9, 0x1));
   regDataMap["shim_event_group_noc_1_lock_enable"].push_back(RegData("NoC_1_Lock_Sel0_acq_eq", "0", 0, 0x1));
   regDataMap["shim_event_group_noc_1_lock_enable"].push_back(RegData("NoC_1_Lock_Sel0_acq_ge", "1", 1, 0x1));
   regDataMap["shim_event_group_noc_1_lock_enable"].push_back(RegData("NoC_1_Lock_Sel2_rel", "10", 10, 0x1));
   regDataMap["shim_event_group_noc_1_lock_enable"].push_back(RegData("NoC_1_Lock_Sel2_equal_to_value", "11", 11, 0x1));
   regDataMap["shim_event_group_noc_1_lock_enable"].push_back(RegData("NoC_1_Lock_Sel3_acq_eq", "12", 12, 0x1));
   regDataMap["shim_event_group_noc_1_lock_enable"].push_back(RegData("NoC_1_Lock_Sel3_acq_ge", "13", 13, 0x1));
   regDataMap["shim_event_group_noc_1_lock_enable"].push_back(RegData("NoC_1_Lock_Sel3_rel", "14", 14, 0x1));
   regDataMap["shim_event_group_noc_1_lock_enable"].push_back(RegData("NoC_1_Lock_Sel3_equal_to_value", "15", 15, 0x1));
   regDataMap["shim_event_group_noc_1_lock_enable"].push_back(RegData("NoC_1_Lock_Sel4_acq_eq", "16", 16, 0x1));
   regDataMap["shim_event_group_noc_1_lock_enable"].push_back(RegData("NoC_1_Lock_Sel4_acq_ge", "17", 17, 0x1));
   regDataMap["shim_event_group_noc_1_lock_enable"].push_back(RegData("NoC_1_Lock_Sel4_rel", "18", 18, 0x1));
   regDataMap["shim_event_group_noc_1_lock_enable"].push_back(RegData("NoC_1_Lock_Sel4_equal_to_value", "19", 19, 0x1));
   regDataMap["shim_event_group_noc_1_lock_enable"].push_back(RegData("NoC_1_Lock_Sel0_rel", "2", 2, 0x1));
   regDataMap["shim_event_group_noc_1_lock_enable"].push_back(RegData("NoC_1_Lock_Sel5_acq_eq", "20", 20, 0x1));
   regDataMap["shim_event_group_noc_1_lock_enable"].push_back(RegData("NoC_1_Lock_Sel5_acq_ge", "21", 21, 0x1));
   regDataMap["shim_event_group_noc_1_lock_enable"].push_back(RegData("NoC_1_Lock_Sel5_rel", "22", 22, 0x1));
   regDataMap["shim_event_group_noc_1_lock_enable"].push_back(RegData("NoC_1_Lock_Sel5_equal_to_value", "23", 23, 0x1));
   regDataMap["shim_event_group_noc_1_lock_enable"].push_back(RegData("NoC_1_Lock_Sel0_equal_to_value", "3", 3, 0x1));
   regDataMap["shim_event_group_noc_1_lock_enable"].push_back(RegData("NoC_1_Lock_Sel1_acq_eq", "4", 4, 0x1));
   regDataMap["shim_event_group_noc_1_lock_enable"].push_back(RegData("NoC_1_Lock_Sel1_acq_ge", "5", 5, 0x1));
   regDataMap["shim_event_group_noc_1_lock_enable"].push_back(RegData("NoC_1_Lock_Sel1_rel", "6", 6, 0x1));
   regDataMap["shim_event_group_noc_1_lock_enable"].push_back(RegData("NoC_1_Lock_Sel1_equal_to_value", "7", 7, 0x1));
   regDataMap["shim_event_group_noc_1_lock_enable"].push_back(RegData("NoC_1_Lock_Sel2_acq_eq", "8", 8, 0x1));
   regDataMap["shim_event_group_noc_1_lock_enable"].push_back(RegData("NoC_1_Lock_Sel2_acq_ge", "9", 9, 0x1));
   regDataMap["shim_event_group_stream_switch_enable"].push_back(RegData("Port_Idle_0", "0", 0, 0x1));
   regDataMap["shim_event_group_stream_switch_enable"].push_back(RegData("Port_Running_0", "1", 1, 0x1));
   regDataMap["shim_event_group_stream_switch_enable"].push_back(RegData("Port_Stalled_2", "10", 10, 0x1));
   regDataMap["shim_event_group_stream_switch_enable"].push_back(RegData("Port_TLAST_2", "11", 11, 0x1));
   regDataMap["shim_event_group_stream_switch_enable"].push_back(RegData("Port_Idle_3", "12", 12, 0x1));
   regDataMap["shim_event_group_stream_switch_enable"].push_back(RegData("Port_Running_3", "13", 13, 0x1));
   regDataMap["shim_event_group_stream_switch_enable"].push_back(RegData("Port_Stalled_3", "14", 14, 0x1));
   regDataMap["shim_event_group_stream_switch_enable"].push_back(RegData("Port_TLAST_3", "15", 15, 0x1));
   regDataMap["shim_event_group_stream_switch_enable"].push_back(RegData("Port_Idle_4", "16", 16, 0x1));
   regDataMap["shim_event_group_stream_switch_enable"].push_back(RegData("Port_Running_4", "17", 17, 0x1));
   regDataMap["shim_event_group_stream_switch_enable"].push_back(RegData("Port_Stalled_4", "18", 18, 0x1));
   regDataMap["shim_event_group_stream_switch_enable"].push_back(RegData("Port_TLAST_4", "19", 19, 0x1));
   regDataMap["shim_event_group_stream_switch_enable"].push_back(RegData("Port_Stalled_0", "2", 2, 0x1));
   regDataMap["shim_event_group_stream_switch_enable"].push_back(RegData("Port_Idle_5", "20", 20, 0x1));
   regDataMap["shim_event_group_stream_switch_enable"].push_back(RegData("Port_Running_5", "21", 21, 0x1));
   regDataMap["shim_event_group_stream_switch_enable"].push_back(RegData("Port_Stalled_5", "22", 22, 0x1));
   regDataMap["shim_event_group_stream_switch_enable"].push_back(RegData("Port_TLAST_5", "23", 23, 0x1));
   regDataMap["shim_event_group_stream_switch_enable"].push_back(RegData("Port_Idle_6", "24", 24, 0x1));
   regDataMap["shim_event_group_stream_switch_enable"].push_back(RegData("Port_Running_6", "25", 25, 0x1));
   regDataMap["shim_event_group_stream_switch_enable"].push_back(RegData("Port_Stalled_6", "26", 26, 0x1));
   regDataMap["shim_event_group_stream_switch_enable"].push_back(RegData("Port_TLAST_6", "27", 27, 0x1));
   regDataMap["shim_event_group_stream_switch_enable"].push_back(RegData("Port_Idle_7", "28", 28, 0x1));
   regDataMap["shim_event_group_stream_switch_enable"].push_back(RegData("Port_Running_7", "29", 29, 0x1));
   regDataMap["shim_event_group_stream_switch_enable"].push_back(RegData("Port_TLAST_0", "3", 3, 0x1));
   regDataMap["shim_event_group_stream_switch_enable"].push_back(RegData("Port_Stalled_7", "30", 30, 0x1));
   regDataMap["shim_event_group_stream_switch_enable"].push_back(RegData("Port_TLAST_7", "31", 31, 0x1));
   regDataMap["shim_event_group_stream_switch_enable"].push_back(RegData("Port_Idle_1", "4", 4, 0x1));
   regDataMap["shim_event_group_stream_switch_enable"].push_back(RegData("Port_Running_1", "5", 5, 0x1));
   regDataMap["shim_event_group_stream_switch_enable"].push_back(RegData("Port_Stalled_1", "6", 6, 0x1));
   regDataMap["shim_event_group_stream_switch_enable"].push_back(RegData("Port_TLAST_1", "7", 7, 0x1));
   regDataMap["shim_event_group_stream_switch_enable"].push_back(RegData("Port_Idle_2", "8", 8, 0x1));
   regDataMap["shim_event_group_stream_switch_enable"].push_back(RegData("Port_Running_2", "9", 9, 0x1));
   regDataMap["shim_event_group_uc_core_program_flow_enable"].push_back(RegData("uC_Core_Sleep", "0", 0, 0x1));
   regDataMap["shim_event_group_uc_core_program_flow_enable"].push_back(RegData("uC_Core_Interrupt", "1", 1, 0x1));
   regDataMap["shim_event_group_uc_core_program_flow_enable"].push_back(RegData("uC_Core_Jump_Taken", "10", 10, 0x1));
   regDataMap["shim_event_group_uc_core_program_flow_enable"].push_back(RegData("uC_Core_Jump_Hit", "11", 11, 0x1));
   regDataMap["shim_event_group_uc_core_program_flow_enable"].push_back(RegData("uC_Core_Data_Read", "12", 12, 0x1));
   regDataMap["shim_event_group_uc_core_program_flow_enable"].push_back(RegData("uC_Core_Data_Write", "13", 13, 0x1));
   regDataMap["shim_event_group_uc_core_program_flow_enable"].push_back(RegData("uC_Core_Pipeline_Halted_Debug", "14", 14, 0x1));
   regDataMap["shim_event_group_uc_core_program_flow_enable"].push_back(RegData("uC_Core_Stream_Get", "15", 15, 0x1));
   regDataMap["shim_event_group_uc_core_program_flow_enable"].push_back(RegData("uC_Core_Stream_Put", "16", 16, 0x1));
   regDataMap["shim_event_group_uc_core_program_flow_enable"].push_back(RegData("uC_Core_Debug_Sys_Rst", "2", 2, 0x1));
   regDataMap["shim_event_group_uc_core_program_flow_enable"].push_back(RegData("uC_Core_Debug_Wakeup", "3", 3, 0x1));
   regDataMap["shim_event_group_uc_core_program_flow_enable"].push_back(RegData("uC_Core_Timer1_Interrupt", "4", 4, 0x1));
   regDataMap["shim_event_group_uc_core_program_flow_enable"].push_back(RegData("uC_Core_Timer2_Interrupt", "5", 5, 0x1));
   regDataMap["shim_event_group_uc_core_program_flow_enable"].push_back(RegData("uC_Core_Timer3_Interrupt", "6", 6, 0x1));
   regDataMap["shim_event_group_uc_core_program_flow_enable"].push_back(RegData("uC_Core_Timer4_Interrupt", "7", 7, 0x1));
   regDataMap["shim_event_group_uc_core_program_flow_enable"].push_back(RegData("uC_Core_Reg_Write", "8", 8, 0x1));
   regDataMap["shim_event_group_uc_core_program_flow_enable"].push_back(RegData("uC_Core_Exception_Taken", "9", 9, 0x1));
   regDataMap["shim_event_group_uc_core_streams_enable"].push_back(RegData("AXIS_Master_Idle", "0", 0, 0x1));
   regDataMap["shim_event_group_uc_core_streams_enable"].push_back(RegData("AXIS_Master_Running", "1", 1, 0x1));
   regDataMap["shim_event_group_uc_core_streams_enable"].push_back(RegData("AXIS_Master_Stalled", "2", 2, 0x1));
   regDataMap["shim_event_group_uc_core_streams_enable"].push_back(RegData("AXIS_Master_TLAST", "3", 3, 0x1));
   regDataMap["shim_event_group_uc_core_streams_enable"].push_back(RegData("AXIS_Slave_Idle", "4", 4, 0x1));
   regDataMap["shim_event_group_uc_core_streams_enable"].push_back(RegData("AXIS_Slave_Running", "5", 5, 0x1));
   regDataMap["shim_event_group_uc_core_streams_enable"].push_back(RegData("AXIS_Slave_Stalled", "6", 6, 0x1));
   regDataMap["shim_event_group_uc_core_streams_enable"].push_back(RegData("AXIS_Slave_TLAST", "7", 7, 0x1));
   regDataMap["shim_event_group_uc_dma_activity_enable"].push_back(RegData("DMA_DM2MM_start_task", "0", 0, 0x1));
   regDataMap["shim_event_group_uc_dma_activity_enable"].push_back(RegData("DMA_MM2DM_start_task", "1", 1, 0x1));
   regDataMap["shim_event_group_uc_dma_activity_enable"].push_back(RegData("DMA_DM2MM_finished_BD", "2", 2, 0x1));
   regDataMap["shim_event_group_uc_dma_activity_enable"].push_back(RegData("DMA_MM2DM_finished_BD", "3", 3, 0x1));
   regDataMap["shim_event_group_uc_dma_activity_enable"].push_back(RegData("DMA_DM2MM_finished_task", "4", 4, 0x1));
   regDataMap["shim_event_group_uc_dma_activity_enable"].push_back(RegData("DMA_MM2DM_finished_task", "5", 5, 0x1));
   regDataMap["shim_event_group_uc_dma_activity_enable"].push_back(RegData("DMA_DM2MM_local_memory_starvation", "6", 6, 0x1));
   regDataMap["shim_event_group_uc_dma_activity_enable"].push_back(RegData("DMA_DM2MM_remote_memory_backpressure", "7", 7, 0x1));
   regDataMap["shim_event_group_uc_dma_activity_enable"].push_back(RegData("DMA_MM2DM_local_memory_backpressure", "8", 8, 0x1));
   regDataMap["shim_event_group_uc_dma_activity_enable"].push_back(RegData("DMA_MM2DM_remote_memory_starvation", "9", 9, 0x1));
   regDataMap["shim_event_group_uc_module_errors_enable"].push_back(RegData("AXI_MM_uC_Core_Master_Decode_Error", "0", 0, 0x1));
   regDataMap["shim_event_group_uc_module_errors_enable"].push_back(RegData("AXI_MM_uC_DMA_Master_Decode_Error", "1", 1, 0x1));
   regDataMap["shim_event_group_uc_module_errors_enable"].push_back(RegData("Shared_DM_ECC_Error_1bit", "10", 10, 0x1));
   regDataMap["shim_event_group_uc_module_errors_enable"].push_back(RegData("Shared_DM_ECC_Error_2bit", "11", 11, 0x1));
   regDataMap["shim_event_group_uc_module_errors_enable"].push_back(RegData("AXI_MM_uC_Core_Master_Slave_Error", "2", 2, 0x1));
   regDataMap["shim_event_group_uc_module_errors_enable"].push_back(RegData("AXI_MM_uC_DMA_Master_Slave_Error", "3", 3, 0x1));
   regDataMap["shim_event_group_uc_module_errors_enable"].push_back(RegData("DMA_DM2MM_Error", "4", 4, 0x1));
   regDataMap["shim_event_group_uc_module_errors_enable"].push_back(RegData("DMA_MM2DM_Error", "5", 5, 0x1));
   regDataMap["shim_event_group_uc_module_errors_enable"].push_back(RegData("PM_ECC_Error_1bit", "6", 6, 0x1));
   regDataMap["shim_event_group_uc_module_errors_enable"].push_back(RegData("PM_ECC_Error_2bit", "7", 7, 0x1));
   regDataMap["shim_event_group_uc_module_errors_enable"].push_back(RegData("Private_DM_ECC_Error_1bit", "8", 8, 0x1));
   regDataMap["shim_event_group_uc_module_errors_enable"].push_back(RegData("Private_DM_ECC_Error_2bit", "9", 9, 0x1));
   regDataMap["shim_event_status0"].push_back(RegData("Event_31_0_Status", "31:0", 0, 0xFFFFFFFF));
   regDataMap["shim_event_status1"].push_back(RegData("Event_63_32_Status", "31:0", 0, 0xFFFFFFFF));
   regDataMap["shim_event_status2"].push_back(RegData("Event_95_64_Status", "31:0", 0, 0xFFFFFFFF));
   regDataMap["shim_event_status3"].push_back(RegData("Event_127_96_Status", "31:0", 0, 0xFFFFFFFF));
   regDataMap["shim_event_status4"].push_back(RegData("Event_159_128_Status", "31:0", 0, 0xFFFFFFFF));
   regDataMap["shim_event_status5"].push_back(RegData("Event_191_160_Status", "31:0", 0, 0xFFFFFFFF));
   regDataMap["shim_event_status6"].push_back(RegData("Event_223_192_Status", "31:0", 0, 0xFFFFFFFF));
   regDataMap["shim_event_status7"].push_back(RegData("Event_255_224_Status", "31:0", 0, 0xFFFFFFFF));
   regDataMap["shim_interrupt_controller_1st_level_block_north_in_a_clear"].push_back(RegData("Clear", "15:0", 0, 0xFFFF));
   regDataMap["shim_interrupt_controller_1st_level_block_north_in_a_set"].push_back(RegData("Set", "15:0", 0, 0xFFFF));
   regDataMap["shim_interrupt_controller_1st_level_block_north_in_a_value"].push_back(RegData("Value", "15:0", 0, 0xFFFF));
   regDataMap["shim_interrupt_controller_1st_level_block_north_in_b_clear"].push_back(RegData("Clear", "15:0", 0, 0xFFFF));
   regDataMap["shim_interrupt_controller_1st_level_block_north_in_b_set"].push_back(RegData("Set", "15:0", 0, 0xFFFF));
   regDataMap["shim_interrupt_controller_1st_level_block_north_in_b_value"].push_back(RegData("Value", "15:0", 0, 0xFFFF));
   regDataMap["shim_interrupt_controller_1st_level_disable_a"].push_back(RegData("Disable_A", "19:0", 0, 0xFFFFF));
   regDataMap["shim_interrupt_controller_1st_level_disable_b"].push_back(RegData("Disable_B", "19:0", 0, 0xFFFFF));
   regDataMap["shim_interrupt_controller_1st_level_enable_a"].push_back(RegData("Enable_A", "19:0", 0, 0xFFFFF));
   regDataMap["shim_interrupt_controller_1st_level_enable_b"].push_back(RegData("Enable_B", "19:0", 0, 0xFFFFF));
   regDataMap["shim_interrupt_controller_1st_level_irq_event_a"].push_back(RegData("IRQ_Event1", "15:8", 8, 0xFF));
   regDataMap["shim_interrupt_controller_1st_level_irq_event_a"].push_back(RegData("IRQ_Event2", "23:16", 16, 0xFF));
   regDataMap["shim_interrupt_controller_1st_level_irq_event_a"].push_back(RegData("IRQ_Event3", "31:24", 24, 0xFF));
   regDataMap["shim_interrupt_controller_1st_level_irq_event_a"].push_back(RegData("IRQ_Event0", "7:0", 0, 0xFF));
   regDataMap["shim_interrupt_controller_1st_level_irq_event_b"].push_back(RegData("IRQ_Event1", "15:8", 8, 0xFF));
   regDataMap["shim_interrupt_controller_1st_level_irq_event_b"].push_back(RegData("IRQ_Event2", "23:16", 16, 0xFF));
   regDataMap["shim_interrupt_controller_1st_level_irq_event_b"].push_back(RegData("IRQ_Event3", "31:24", 24, 0xFF));
   regDataMap["shim_interrupt_controller_1st_level_irq_event_b"].push_back(RegData("IRQ_Event0", "7:0", 0, 0xFF));
   regDataMap["shim_interrupt_controller_1st_level_irq_no_a"].push_back(RegData("Irq_no_A", "3:0", 0, 0xF));
   regDataMap["shim_interrupt_controller_1st_level_irq_no_b"].push_back(RegData("Irq_no_B", "3:0", 0, 0xF));
   regDataMap["shim_interrupt_controller_1st_level_mask_a"].push_back(RegData("IRQ_Mask_A", "19:0", 0, 0xFFFFF));
   regDataMap["shim_interrupt_controller_1st_level_mask_b"].push_back(RegData("IRQ_Mask_B", "19:0", 0, 0xFFFFF));
   regDataMap["shim_interrupt_controller_1st_level_status_a"].push_back(RegData("Status_A", "19:0", 0, 0xFFFFF));
   regDataMap["shim_interrupt_controller_1st_level_status_b"].push_back(RegData("Status_B", "19:0", 0, 0xFFFFF));
   regDataMap["shim_interrupt_controller_2nd_level_disable"].push_back(RegData("Disable_A", "15:0", 0, 0xFFFF));
   regDataMap["shim_interrupt_controller_2nd_level_disable"].push_back(RegData("Disable_uC_Core", "16", 16, 0x1));
   regDataMap["shim_interrupt_controller_2nd_level_enable"].push_back(RegData("Enable_A", "15:0", 0, 0xFFFF));
   regDataMap["shim_interrupt_controller_2nd_level_enable"].push_back(RegData("Enable_uC_Core", "16", 16, 0x1));
   regDataMap["shim_interrupt_controller_2nd_level_interrupt"].push_back(RegData("NoC_Interrupt", "1:0", 0, 0x3));
   regDataMap["shim_interrupt_controller_2nd_level_mask"].push_back(RegData("IRQ_Mask_A", "15:0", 0, 0xFFFF));
   regDataMap["shim_interrupt_controller_2nd_level_mask"].push_back(RegData("IRQ_Mask_uC_Core", "16", 16, 0x1));
   regDataMap["shim_interrupt_controller_2nd_level_status"].push_back(RegData("Status_A", "15:0", 0, 0xFFFF));
   regDataMap["shim_interrupt_controller_2nd_level_status"].push_back(RegData("Status_uC_Core", "16", 16, 0x1));
   regDataMap["shim_interrupt_controller_hw_error_interrupt"].push_back(RegData("NoC_Interrupt", "1:0", 0, 0x3));
   regDataMap["shim_interrupt_controller_hw_error_mask"].push_back(RegData("Hw_Uncorrectable_Errors", "0", 0, 0x1));
   regDataMap["shim_interrupt_controller_hw_error_mask"].push_back(RegData("Hw_Correctable_Errors", "1", 1, 0x1));
   regDataMap["shim_interrupt_controller_hw_error_mask"].push_back(RegData("AXI_Errors", "2", 2, 0x1));
   regDataMap["shim_interrupt_controller_hw_error_status"].push_back(RegData("Hw_Uncorrectable_Errors", "0", 0, 0x1));
   regDataMap["shim_interrupt_controller_hw_error_status"].push_back(RegData("Hw_Correctable_Errors", "1", 1, 0x1));
   regDataMap["shim_interrupt_controller_hw_error_status"].push_back(RegData("AXI_Errors", "2", 2, 0x1));
   regDataMap["shim_lock0_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["shim_lock10_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["shim_lock11_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["shim_lock12_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["shim_lock13_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["shim_lock14_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["shim_lock15_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["shim_lock1_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["shim_lock2_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["shim_lock3_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["shim_lock4_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["shim_lock5_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["shim_lock6_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["shim_lock7_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["shim_lock8_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["shim_lock9_value"].push_back(RegData("Lock_value", "5:0", 0, 0x3F));
   regDataMap["shim_lock_request"].push_back(RegData("Request_Result", "0", 0, 0x1));
   regDataMap["shim_locks_event_selection_0"].push_back(RegData("Lock_Select", "19:16", 16, 0xF));
   regDataMap["shim_locks_event_selection_0"].push_back(RegData("Lock_Value", "5:0", 0, 0x3F));
   regDataMap["shim_locks_event_selection_1"].push_back(RegData("Lock_Select", "19:16", 16, 0xF));
   regDataMap["shim_locks_event_selection_1"].push_back(RegData("Lock_Value", "5:0", 0, 0x3F));
   regDataMap["shim_locks_event_selection_2"].push_back(RegData("Lock_Select", "19:16", 16, 0xF));
   regDataMap["shim_locks_event_selection_2"].push_back(RegData("Lock_Value", "5:0", 0, 0x3F));
   regDataMap["shim_locks_event_selection_3"].push_back(RegData("Lock_Select", "19:16", 16, 0xF));
   regDataMap["shim_locks_event_selection_3"].push_back(RegData("Lock_Value", "5:0", 0, 0x3F));
   regDataMap["shim_locks_event_selection_4"].push_back(RegData("Lock_Select", "19:16", 16, 0xF));
   regDataMap["shim_locks_event_selection_4"].push_back(RegData("Lock_Value", "5:0", 0, 0x3F));
   regDataMap["shim_locks_event_selection_5"].push_back(RegData("Lock_Select", "19:16", 16, 0xF));
   regDataMap["shim_locks_event_selection_5"].push_back(RegData("Lock_Value", "5:0", 0, 0x3F));
   regDataMap["shim_locks_overflow"].push_back(RegData("Lock_Overflow_0", "0", 0, 0x1));
   regDataMap["shim_locks_overflow"].push_back(RegData("Lock_Overflow_1", "1", 1, 0x1));
   regDataMap["shim_locks_overflow"].push_back(RegData("Lock_Overflow_10", "10", 10, 0x1));
   regDataMap["shim_locks_overflow"].push_back(RegData("Lock_Overflow_11", "11", 11, 0x1));
   regDataMap["shim_locks_overflow"].push_back(RegData("Lock_Overflow_12", "12", 12, 0x1));
   regDataMap["shim_locks_overflow"].push_back(RegData("Lock_Overflow_13", "13", 13, 0x1));
   regDataMap["shim_locks_overflow"].push_back(RegData("Lock_Overflow_14", "14", 14, 0x1));
   regDataMap["shim_locks_overflow"].push_back(RegData("Lock_Overflow_15", "15", 15, 0x1));
   regDataMap["shim_locks_overflow"].push_back(RegData("Lock_Overflow_2", "2", 2, 0x1));
   regDataMap["shim_locks_overflow"].push_back(RegData("Lock_Overflow_3", "3", 3, 0x1));
   regDataMap["shim_locks_overflow"].push_back(RegData("Lock_Overflow_4", "4", 4, 0x1));
   regDataMap["shim_locks_overflow"].push_back(RegData("Lock_Overflow_5", "5", 5, 0x1));
   regDataMap["shim_locks_overflow"].push_back(RegData("Lock_Overflow_6", "6", 6, 0x1));
   regDataMap["shim_locks_overflow"].push_back(RegData("Lock_Overflow_7", "7", 7, 0x1));
   regDataMap["shim_locks_overflow"].push_back(RegData("Lock_Overflow_8", "8", 8, 0x1));
   regDataMap["shim_locks_overflow"].push_back(RegData("Lock_Overflow_9", "9", 9, 0x1));
   regDataMap["shim_locks_underflow"].push_back(RegData("Lock_Underflow_0", "0", 0, 0x1));
   regDataMap["shim_locks_underflow"].push_back(RegData("Lock_Underflow_1", "1", 1, 0x1));
   regDataMap["shim_locks_underflow"].push_back(RegData("Lock_Underflow_10", "10", 10, 0x1));
   regDataMap["shim_locks_underflow"].push_back(RegData("Lock_Underflow_11", "11", 11, 0x1));
   regDataMap["shim_locks_underflow"].push_back(RegData("Lock_Underflow_12", "12", 12, 0x1));
   regDataMap["shim_locks_underflow"].push_back(RegData("Lock_Underflow_13", "13", 13, 0x1));
   regDataMap["shim_locks_underflow"].push_back(RegData("Lock_Underflow_14", "14", 14, 0x1));
   regDataMap["shim_locks_underflow"].push_back(RegData("Lock_Underflow_15", "15", 15, 0x1));
   regDataMap["shim_locks_underflow"].push_back(RegData("Lock_Underflow_2", "2", 2, 0x1));
   regDataMap["shim_locks_underflow"].push_back(RegData("Lock_Underflow_3", "3", 3, 0x1));
   regDataMap["shim_locks_underflow"].push_back(RegData("Lock_Underflow_4", "4", 4, 0x1));
   regDataMap["shim_locks_underflow"].push_back(RegData("Lock_Underflow_5", "5", 5, 0x1));
   regDataMap["shim_locks_underflow"].push_back(RegData("Lock_Underflow_6", "6", 6, 0x1));
   regDataMap["shim_locks_underflow"].push_back(RegData("Lock_Underflow_7", "7", 7, 0x1));
   regDataMap["shim_locks_underflow"].push_back(RegData("Lock_Underflow_8", "8", 8, 0x1));
   regDataMap["shim_locks_underflow"].push_back(RegData("Lock_Underflow_9", "9", 9, 0x1));
   regDataMap["shim_mdm_dbg_ctrl_status"].push_back(RegData("Bit_Size_0_Access_Lock", "0", 0, 0x1));
   regDataMap["shim_mdm_dbg_ctrl_status"].push_back(RegData("MDM_Command", "16:9", 9, 0xFF));
   regDataMap["shim_mdm_dbg_ctrl_status"].push_back(RegData("Access_MDM", "17", 17, 0x1));
   regDataMap["shim_mdm_dbg_ctrl_status"].push_back(RegData("Access_Lock_Type", "19:18", 18, 0x3));
   regDataMap["shim_mdm_dbg_ctrl_status"].push_back(RegData("Bit_Size_8_1", "8:1", 1, 0xFF));
   regDataMap["shim_mdm_dbg_data"].push_back(RegData("Debug_Data", "31:0", 0, 0xFFFFFFFF));
   regDataMap["shim_mdm_dbg_lock"].push_back(RegData("Debug_Lock", "15:0", 0, 0xFFFF));
   regDataMap["shim_mdm_pccmdr"].push_back(RegData("Reset", "0", 0, 0x1));
   regDataMap["shim_mdm_pccmdr"].push_back(RegData("Sample", "1", 1, 0x1));
   regDataMap["shim_mdm_pccmdr"].push_back(RegData("Stop", "2", 2, 0x1));
   regDataMap["shim_mdm_pccmdr"].push_back(RegData("Start", "3", 3, 0x1));
   regDataMap["shim_mdm_pccmdr"].push_back(RegData("Clear", "4", 4, 0x1));
   regDataMap["shim_mdm_pcctrlr"].push_back(RegData("Event", "7:0", 0, 0xFF));
   regDataMap["shim_mdm_pcdrr"].push_back(RegData("PCDRR", "31:0", 0, 0xFFFFFFFF));
   regDataMap["shim_mdm_pcsr"].push_back(RegData("Full", "0", 0, 0x1));
   regDataMap["shim_mdm_pcsr"].push_back(RegData("Overflow", "1", 1, 0x1));
   regDataMap["shim_mdm_pcwr"].push_back(RegData("PCWR", "31:0", 0, 0xFFFFFFFF));
   regDataMap["shim_me_aximm_config"].push_back(RegData("SLVERR_Block", "2", 2, 0x1));
   regDataMap["shim_me_aximm_config"].push_back(RegData("DECERR_Block", "3", 3, 0x1));
   regDataMap["shim_memory_dm_ecc_error_generation"].push_back(RegData("Inhibit_Checkbit", "0", 0, 0x1));
   regDataMap["shim_memory_dm_ecc_scrubbing_period"].push_back(RegData("Scrubbing_Period_Log2_Cycles", "4:0", 0, 0x1F));
   regDataMap["shim_memory_privileged"].push_back(RegData("Memory_Privileged", "0", 0, 0x1));
   regDataMap["shim_memory_zeroization"].push_back(RegData("PM_Zeroization", "0", 0, 0x1));
   regDataMap["shim_memory_zeroization"].push_back(RegData("Private_DM_Zeroization", "1", 1, 0x1));
   regDataMap["shim_memory_zeroization"].push_back(RegData("DM_Zeroization", "2", 2, 0x1));
   regDataMap["shim_module_aximm_offset"].push_back(RegData("AXIMM_Offset", "31:0", 0, 0xFFFFFFFF));
   regDataMap["shim_module_axi_mm_outstanding_transactions"].push_back(RegData("uC_DMA_To_NMU", "0", 0, 0x1));
   regDataMap["shim_module_axi_mm_outstanding_transactions"].push_back(RegData("uC_Module_To_Array", "1", 1, 0x1));
   regDataMap["shim_module_clock_control_0"].push_back(RegData("Stream_Switch_Clock_Enable", "0", 0, 0x1));
   regDataMap["shim_module_clock_control_0"].push_back(RegData("PL_Interface_Clock_Enable", "1", 1, 0x1));
   regDataMap["shim_module_clock_control_0"].push_back(RegData("uController_Clock_Enable", "2", 2, 0x1));
   regDataMap["shim_module_clock_control_0"].push_back(RegData("CTE_Clock_Enable", "3", 3, 0x1));
   regDataMap["shim_module_clock_control_0"].push_back(RegData("Ctrl_Pkt_Tlast_Error_Enable", "4", 4, 0x1));
   regDataMap["shim_module_clock_control_0"].push_back(RegData("NoC_Module_0_DMA_Adaptive_Clock_Gate", "5", 5, 0x1));
   regDataMap["shim_module_clock_control_0"].push_back(RegData("NoC_Module_1_DMA_Adaptive_Clock_Gate", "6", 6, 0x1));
   regDataMap["shim_module_clock_control_0"].push_back(RegData("uController_SRAMs_Sleep", "7", 7, 0x1));
   regDataMap["shim_module_clock_control_1"].push_back(RegData("NoC_Module_0_Clock_Enable", "0", 0, 0x1));
   regDataMap["shim_module_clock_control_1"].push_back(RegData("NoC_Module_1_Clock_Enable", "1", 1, 0x1));
   regDataMap["shim_module_clock_control_1"].push_back(RegData("Shim_DMA_SRAMs_Sleep", "2", 2, 0x1));
   regDataMap["shim_module_reset_control_0"].push_back(RegData("Stream_Switch_Reset", "0", 0, 0x1));
   regDataMap["shim_module_reset_control_0"].push_back(RegData("PL_Interface_Reset", "1", 1, 0x1));
   regDataMap["shim_module_reset_control_0"].push_back(RegData("uController_Reset", "2", 2, 0x1));
   regDataMap["shim_module_reset_control_0"].push_back(RegData("CTE_Module_Reset", "3", 3, 0x1));
   regDataMap["shim_module_reset_control_1"].push_back(RegData("NoC_Module_0_Reset", "0", 0, 0x1));
   regDataMap["shim_module_reset_control_1"].push_back(RegData("NoC_Module_1_Reset", "1", 1, 0x1));
   regDataMap["shim_mux_config"].push_back(RegData("South3", "11:10", 10, 0x3));
   regDataMap["shim_mux_config"].push_back(RegData("South5", "13:12", 12, 0x3));
   regDataMap["shim_mux_config"].push_back(RegData("South7", "15:14", 14, 0x3));
   regDataMap["shim_mux_config"].push_back(RegData("South1", "9:8", 8, 0x3));
   regDataMap["shim_nmu_switches_config"].push_back(RegData("NMU_0", "0", 0, 0x1));
   regDataMap["shim_nmu_switches_config"].push_back(RegData("NMU_1", "1", 1, 0x1));
   regDataMap["shim_pl_interface_downsizer_bypass"].push_back(RegData("South0", "0", 0, 0x1));
   regDataMap["shim_pl_interface_downsizer_bypass"].push_back(RegData("South1", "1", 1, 0x1));
   regDataMap["shim_pl_interface_downsizer_bypass"].push_back(RegData("South2", "2", 2, 0x1));
   regDataMap["shim_pl_interface_downsizer_bypass"].push_back(RegData("South4", "3", 3, 0x1));
   regDataMap["shim_pl_interface_downsizer_bypass"].push_back(RegData("South5", "4", 4, 0x1));
   regDataMap["shim_pl_interface_downsizer_bypass"].push_back(RegData("South6", "5", 5, 0x1));
   regDataMap["shim_pl_interface_downsizer_config"].push_back(RegData("South0", "0", 0, 0x1));
   regDataMap["shim_pl_interface_downsizer_config"].push_back(RegData("South1", "1", 1, 0x1));
   regDataMap["shim_pl_interface_downsizer_config"].push_back(RegData("South7", "10", 10, 0x1));
   regDataMap["shim_pl_interface_downsizer_config"].push_back(RegData("South6_South7_128_combine", "11", 11, 0x1));
   regDataMap["shim_pl_interface_downsizer_config"].push_back(RegData("South0_South1_128_combine", "2", 2, 0x1));
   regDataMap["shim_pl_interface_downsizer_config"].push_back(RegData("South2", "3", 3, 0x1));
   regDataMap["shim_pl_interface_downsizer_config"].push_back(RegData("South3", "4", 4, 0x1));
   regDataMap["shim_pl_interface_downsizer_config"].push_back(RegData("South2_South3_128_combine", "5", 5, 0x1));
   regDataMap["shim_pl_interface_downsizer_config"].push_back(RegData("South4", "6", 6, 0x1));
   regDataMap["shim_pl_interface_downsizer_config"].push_back(RegData("South5", "7", 7, 0x1));
   regDataMap["shim_pl_interface_downsizer_config"].push_back(RegData("South4_South5_128_combine", "8", 8, 0x1));
   regDataMap["shim_pl_interface_downsizer_config"].push_back(RegData("South6", "9", 9, 0x1));
   regDataMap["shim_pl_interface_downsizer_enable"].push_back(RegData("South0", "0", 0, 0x1));
   regDataMap["shim_pl_interface_downsizer_enable"].push_back(RegData("South1", "1", 1, 0x1));
   regDataMap["shim_pl_interface_downsizer_enable"].push_back(RegData("South2", "2", 2, 0x1));
   regDataMap["shim_pl_interface_downsizer_enable"].push_back(RegData("South3", "3", 3, 0x1));
   regDataMap["shim_pl_interface_downsizer_enable"].push_back(RegData("South4", "4", 4, 0x1));
   regDataMap["shim_pl_interface_downsizer_enable"].push_back(RegData("South5", "5", 5, 0x1));
   regDataMap["shim_pl_interface_downsizer_enable"].push_back(RegData("South6", "6", 6, 0x1));
   regDataMap["shim_pl_interface_downsizer_enable"].push_back(RegData("South7", "7", 7, 0x1));
   regDataMap["shim_pl_interface_upsizer_config"].push_back(RegData("South0", "0", 0, 0x1));
   regDataMap["shim_pl_interface_upsizer_config"].push_back(RegData("South1", "1", 1, 0x1));
   regDataMap["shim_pl_interface_upsizer_config"].push_back(RegData("South0_South1_128_combine", "2", 2, 0x1));
   regDataMap["shim_pl_interface_upsizer_config"].push_back(RegData("South2", "3", 3, 0x1));
   regDataMap["shim_pl_interface_upsizer_config"].push_back(RegData("South3", "4", 4, 0x1));
   regDataMap["shim_pl_interface_upsizer_config"].push_back(RegData("South2_South3_128_combine", "5", 5, 0x1));
   regDataMap["shim_pl_interface_upsizer_config"].push_back(RegData("South4", "6", 6, 0x1));
   regDataMap["shim_pl_interface_upsizer_config"].push_back(RegData("South5", "7", 7, 0x1));
   regDataMap["shim_pl_interface_upsizer_config"].push_back(RegData("South4_South5_128_combine", "8", 8, 0x1));
   regDataMap["shim_performance_counter0"].push_back(RegData("Counter0_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["shim_performance_counter0_event_value"].push_back(RegData("Counter_Event_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["shim_performance_counter1"].push_back(RegData("Counter0_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["shim_performance_counter1_event_value"].push_back(RegData("Counter_Event_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["shim_performance_counter2"].push_back(RegData("Counter0_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["shim_performance_counter3"].push_back(RegData("Counter0_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["shim_performance_counter4"].push_back(RegData("Counter0_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["shim_performance_counter5"].push_back(RegData("Counter0_Value", "31:0", 0, 0xFFFFFFFF));
   regDataMap["shim_performance_ctrl0"].push_back(RegData("Cnt0_Stop_Event", "15:8", 8, 0xFF));
   regDataMap["shim_performance_ctrl0"].push_back(RegData("Cnt1_Start_Event", "23:16", 16, 0xFF));
   regDataMap["shim_performance_ctrl0"].push_back(RegData("Cnt1_Stop_Event", "31:24", 24, 0xFF));
   regDataMap["shim_performance_ctrl0"].push_back(RegData("Cnt0_Start_Event", "7:0", 0, 0xFF));
   regDataMap["shim_performance_ctrl1"].push_back(RegData("Cnt1_Reset_Event", "15:8", 8, 0xFF));
   regDataMap["shim_performance_ctrl1"].push_back(RegData("Cnt0_Reset_Event", "7:0", 0, 0xFF));
   regDataMap["shim_performance_ctrl2"].push_back(RegData("Cnt2_Stop_Event", "15:8", 8, 0xFF));
   regDataMap["shim_performance_ctrl2"].push_back(RegData("Cnt3_Start_Event", "23:16", 16, 0xFF));
   regDataMap["shim_performance_ctrl2"].push_back(RegData("Cnt3_Stop_Event", "31:24", 24, 0xFF));
   regDataMap["shim_performance_ctrl2"].push_back(RegData("Cnt2_Start_Event", "7:0", 0, 0xFF));
   regDataMap["shim_performance_ctrl3"].push_back(RegData("Cnt3_Reset_Event", "15:8", 8, 0xFF));
   regDataMap["shim_performance_ctrl3"].push_back(RegData("Cnt2_Reset_Event", "7:0", 0, 0xFF));
   regDataMap["shim_performance_ctrl4"].push_back(RegData("Cnt4_Stop_Event", "15:8", 8, 0xFF));
   regDataMap["shim_performance_ctrl4"].push_back(RegData("Cnt5_Start_Event", "23:16", 16, 0xFF));
   regDataMap["shim_performance_ctrl4"].push_back(RegData("Cnt5_Stop_Event", "31:24", 24, 0xFF));
   regDataMap["shim_performance_ctrl4"].push_back(RegData("Cnt4_Start_Event", "7:0", 0, 0xFF));
   regDataMap["shim_performance_ctrl5"].push_back(RegData("Cnt5_Reset_Event", "15:8", 8, 0xFF));
   regDataMap["shim_performance_ctrl5"].push_back(RegData("Cnt4_Reset_Event", "7:0", 0, 0xFF));
   regDataMap["shim_smid"].push_back(RegData("SMID", "9:0", 0, 0x3FF));
   regDataMap["shim_spare_reg"].push_back(RegData("Spare_Reg", "15:0", 0, 0xFFFF));
   regDataMap["shim_spare_reg"].push_back(RegData("Spare_Reg", "15:0", 0, 0xFFFF));
   regDataMap["shim_spare_reg_privileged"].push_back(RegData("Spare_Reg", "15:0", 0, 0xFFFF));
   regDataMap["shim_stream_switch_adaptive_clock_gate_abort_period"].push_back(RegData("Abort_Period", "3:0", 0, 0xF));
   regDataMap["shim_stream_switch_adaptive_clock_gate_status"].push_back(RegData("Active", "0", 0, 0x1));
   regDataMap["shim_stream_switch_deterministic_merge_arb0_ctrl"].push_back(RegData("Enable", "0", 0, 0x1));
   regDataMap["shim_stream_switch_deterministic_merge_arb0_slave0_1"].push_back(RegData("Packet_Count_0", "13:8", 8, 0x3F));
   regDataMap["shim_stream_switch_deterministic_merge_arb0_slave0_1"].push_back(RegData("Slave_ID_1", "20:16", 16, 0x1F));
   regDataMap["shim_stream_switch_deterministic_merge_arb0_slave0_1"].push_back(RegData("Packet_Count_1", "29:24", 24, 0x3F));
   regDataMap["shim_stream_switch_deterministic_merge_arb0_slave0_1"].push_back(RegData("Slave_ID_0", "4:0", 0, 0x1F));
   regDataMap["shim_stream_switch_deterministic_merge_arb0_slave2_3"].push_back(RegData("Packet_Count_2", "13:8", 8, 0x3F));
   regDataMap["shim_stream_switch_deterministic_merge_arb0_slave2_3"].push_back(RegData("Slave_ID_3", "20:16", 16, 0x1F));
   regDataMap["shim_stream_switch_deterministic_merge_arb0_slave2_3"].push_back(RegData("Packet_Count_3", "29:24", 24, 0x3F));
   regDataMap["shim_stream_switch_deterministic_merge_arb0_slave2_3"].push_back(RegData("Slave_ID_2", "4:0", 0, 0x1F));
   regDataMap["shim_stream_switch_deterministic_merge_arb1_ctrl"].push_back(RegData("Enable", "0", 0, 0x1));
   regDataMap["shim_stream_switch_deterministic_merge_arb1_slave0_1"].push_back(RegData("Packet_Count_0", "13:8", 8, 0x3F));
   regDataMap["shim_stream_switch_deterministic_merge_arb1_slave0_1"].push_back(RegData("Slave_ID_1", "20:16", 16, 0x1F));
   regDataMap["shim_stream_switch_deterministic_merge_arb1_slave0_1"].push_back(RegData("Packet_Count_1", "29:24", 24, 0x3F));
   regDataMap["shim_stream_switch_deterministic_merge_arb1_slave0_1"].push_back(RegData("Slave_ID_0", "4:0", 0, 0x1F));
   regDataMap["shim_stream_switch_deterministic_merge_arb1_slave2_3"].push_back(RegData("Packet_Count_2", "13:8", 8, 0x3F));
   regDataMap["shim_stream_switch_deterministic_merge_arb1_slave2_3"].push_back(RegData("Slave_ID_3", "20:16", 16, 0x1F));
   regDataMap["shim_stream_switch_deterministic_merge_arb1_slave2_3"].push_back(RegData("Packet_Count_3", "29:24", 24, 0x3F));
   regDataMap["shim_stream_switch_deterministic_merge_arb1_slave2_3"].push_back(RegData("Slave_ID_2", "4:0", 0, 0x1F));
   regDataMap["shim_stream_switch_event_port_selection_0"].push_back(RegData("Port_1_ID", "12:8", 8, 0x1F));
   regDataMap["shim_stream_switch_event_port_selection_0"].push_back(RegData("Port_1_Master_Slave", "13", 13, 0x1));
   regDataMap["shim_stream_switch_event_port_selection_0"].push_back(RegData("Port_2_ID", "20:16", 16, 0x1F));
   regDataMap["shim_stream_switch_event_port_selection_0"].push_back(RegData("Port_2_Master_Slave", "21", 21, 0x1));
   regDataMap["shim_stream_switch_event_port_selection_0"].push_back(RegData("Port_3_ID", "28:24", 24, 0x1F));
   regDataMap["shim_stream_switch_event_port_selection_0"].push_back(RegData("Port_3_Master_Slave", "29", 29, 0x1));
   regDataMap["shim_stream_switch_event_port_selection_0"].push_back(RegData("Port_0_ID", "4:0", 0, 0x1F));
   regDataMap["shim_stream_switch_event_port_selection_0"].push_back(RegData("Port_0_Master_Slave", "5", 5, 0x1));
   regDataMap["shim_stream_switch_event_port_selection_1"].push_back(RegData("Port_5_ID", "12:8", 8, 0x1F));
   regDataMap["shim_stream_switch_event_port_selection_1"].push_back(RegData("Port_5_Master_Slave", "13", 13, 0x1));
   regDataMap["shim_stream_switch_event_port_selection_1"].push_back(RegData("Port_6_ID", "20:16", 16, 0x1F));
   regDataMap["shim_stream_switch_event_port_selection_1"].push_back(RegData("Port_6_Master_Slave", "21", 21, 0x1));
   regDataMap["shim_stream_switch_event_port_selection_1"].push_back(RegData("Port_7_ID", "28:24", 24, 0x1F));
   regDataMap["shim_stream_switch_event_port_selection_1"].push_back(RegData("Port_7_Master_Slave", "29", 29, 0x1));
   regDataMap["shim_stream_switch_event_port_selection_1"].push_back(RegData("Port_4_ID", "4:0", 0, 0x1F));
   regDataMap["shim_stream_switch_event_port_selection_1"].push_back(RegData("Port_4_Master_Slave", "5", 5, 0x1));
   regDataMap["shim_stream_switch_parity_injection"].push_back(RegData("South_0_lower", "0", 0, 0x1));
   regDataMap["shim_stream_switch_parity_injection"].push_back(RegData("South_1_lower", "1", 1, 0x1));
   regDataMap["shim_stream_switch_parity_injection"].push_back(RegData("uController_lower", "10", 10, 0x1));
   regDataMap["shim_stream_switch_parity_injection"].push_back(RegData("South_0_upper", "16", 16, 0x1));
   regDataMap["shim_stream_switch_parity_injection"].push_back(RegData("South_1_upper", "17", 17, 0x1));
   regDataMap["shim_stream_switch_parity_injection"].push_back(RegData("South_2_upper", "18", 18, 0x1));
   regDataMap["shim_stream_switch_parity_injection"].push_back(RegData("South_3_upper", "19", 19, 0x1));
   regDataMap["shim_stream_switch_parity_injection"].push_back(RegData("South_2_lower", "2", 2, 0x1));
   regDataMap["shim_stream_switch_parity_injection"].push_back(RegData("South_4_upper", "20", 20, 0x1));
   regDataMap["shim_stream_switch_parity_injection"].push_back(RegData("South_5_upper", "21", 21, 0x1));
   regDataMap["shim_stream_switch_parity_injection"].push_back(RegData("South_6_upper", "22", 22, 0x1));
   regDataMap["shim_stream_switch_parity_injection"].push_back(RegData("South_7_upper", "23", 23, 0x1));
   regDataMap["shim_stream_switch_parity_injection"].push_back(RegData("Tile_Control_upper", "24", 24, 0x1));
   regDataMap["shim_stream_switch_parity_injection"].push_back(RegData("Shim_trace_upper", "25", 25, 0x1));
   regDataMap["shim_stream_switch_parity_injection"].push_back(RegData("uController_upper", "26", 26, 0x1));
   regDataMap["shim_stream_switch_parity_injection"].push_back(RegData("South_3_lower", "3", 3, 0x1));
   regDataMap["shim_stream_switch_parity_injection"].push_back(RegData("South_4_lower", "4", 4, 0x1));
   regDataMap["shim_stream_switch_parity_injection"].push_back(RegData("South_5_lower", "5", 5, 0x1));
   regDataMap["shim_stream_switch_parity_injection"].push_back(RegData("South_6_lower", "6", 6, 0x1));
   regDataMap["shim_stream_switch_parity_injection"].push_back(RegData("South_7_lower", "7", 7, 0x1));
   regDataMap["shim_stream_switch_parity_injection"].push_back(RegData("Tile_Control_lower", "8", 8, 0x1));
   regDataMap["shim_stream_switch_parity_injection"].push_back(RegData("Shim_trace_lower", "9", 9, 0x1));
   regDataMap["shim_stream_switch_parity_status"].push_back(RegData("South_0", "0", 0, 0x1));
   regDataMap["shim_stream_switch_parity_status"].push_back(RegData("South_1", "1", 1, 0x1));
   regDataMap["shim_stream_switch_parity_status"].push_back(RegData("South_2", "2", 2, 0x1));
   regDataMap["shim_stream_switch_parity_status"].push_back(RegData("South_3", "3", 3, 0x1));
   regDataMap["shim_stream_switch_parity_status"].push_back(RegData("South_4", "4", 4, 0x1));
   regDataMap["shim_stream_switch_parity_status"].push_back(RegData("South_5", "5", 5, 0x1));
   regDataMap["shim_stream_switch_parity_status"].push_back(RegData("Tile_Control", "6", 6, 0x1));
   regDataMap["shim_stream_switch_parity_status"].push_back(RegData("uController", "7", 7, 0x1));
   regDataMap["shim_tile_control"].push_back(RegData("Isolate_From_South", "0", 0, 0x1));
   regDataMap["shim_tile_control"].push_back(RegData("Isolate_From_West", "1", 1, 0x1));
   regDataMap["shim_tile_control"].push_back(RegData("Isolate_From_North", "2", 2, 0x1));
   regDataMap["shim_tile_control"].push_back(RegData("Isolate_From_East", "3", 3, 0x1));
   regDataMap["shim_tile_control_axi_mm"].push_back(RegData("Isolate_From_West", "1", 1, 0x1));
   regDataMap["shim_tile_control_axi_mm"].push_back(RegData("Isolate_From_East", "3", 3, 0x1));
   regDataMap["shim_timer_control"].push_back(RegData("Reset_Event", "15:8", 8, 0xFF));
   regDataMap["shim_timer_control"].push_back(RegData("Reset", "31", 31, 0x1));
   regDataMap["shim_timer_high"].push_back(RegData("TimerHigh", "31:0", 0, 0xFFFFFFFF));
   regDataMap["shim_timer_low"].push_back(RegData("TimerLow", "31:0", 0, 0xFFFFFFFF));
   regDataMap["shim_timer_trig_event_high_value"].push_back(RegData("TimerTrigHigh", "31:0", 0, 0xFFFFFFFF));
   regDataMap["shim_timer_trig_event_low_value"].push_back(RegData("TimerTrigLow", "31:0", 0, 0xFFFFFFFF));
   regDataMap["shim_trace_control0"].push_back(RegData("Trace_Start_Event", "23:16", 16, 0xFF));
   regDataMap["shim_trace_control0"].push_back(RegData("Trace_Stop_Event", "31:24", 24, 0xFF));
   regDataMap["shim_trace_control1"].push_back(RegData("Packet_Type", "14:12", 12, 0x7));
   regDataMap["shim_trace_control1"].push_back(RegData("ID", "4:0", 0, 0x1F));
   regDataMap["shim_trace_event0"].push_back(RegData("Trace_Event1", "15:8", 8, 0xFF));
   regDataMap["shim_trace_event0"].push_back(RegData("Trace_Event2", "23:16", 16, 0xFF));
   regDataMap["shim_trace_event0"].push_back(RegData("Trace_Event3", "31:24", 24, 0xFF));
   regDataMap["shim_trace_event0"].push_back(RegData("Trace_Event0", "7:0", 0, 0xFF));
   regDataMap["shim_trace_event1"].push_back(RegData("Trace_Event5", "15:8", 8, 0xFF));
   regDataMap["shim_trace_event1"].push_back(RegData("Trace_Event6", "23:16", 16, 0xFF));
   regDataMap["shim_trace_event1"].push_back(RegData("Trace_Event7", "31:24", 24, 0xFF));
   regDataMap["shim_trace_event1"].push_back(RegData("Trace_Event4", "7:0", 0, 0xFF));
   regDataMap["shim_trace_status"].push_back(RegData("Mode", "2:0", 0, 0x7));
   regDataMap["shim_trace_status"].push_back(RegData("State", "9:8", 8, 0x3));
   regDataMap["shim_uc_core_interrupt_event"].push_back(RegData("Event", "7:0", 0, 0xFF));
}

} // end namespace xdp
