!= Subroutine BasicEnv
!
! Authors::   SUGIYAMA Koichiro, ODAKA Masatsugu
! Version::   $Id: basicenv_old.f90,v 1.1 2009-03-05 05:39:40 yamasita Exp $
! Tag Name::  $Name: arare4-20100306 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview 
!
!ǥեȤδܾꤹ뤿ѿȷ⥸塼
!   * BasicEnvFile_init: ܾͤ netCDF ե뤫
!   * BasicEnvCalc_Init: ܾξ Namelist ͤ׻
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!== Future Plans
!

subroutine BasicEnv()
  !
  !ǥեȤδܾꤹ뤿Υ֥롼. 
  !ܾ׻, BasicSet ⥸塼ͤ. 
  !
  !ѥν꤫, ܾ(hogeBasicZ ѿ)
  !׻ʬBasicSet ⥸塼뤫ڤΥƤ. 
  !ECCM Ϥ, BasicSet Τ˰¸뤬 hogeBasicZ  use ʤ
  !֥롼Ѥ뤿Ǥ. 
  !

  !⥸塼ɤ߹
  use dc_message, only: MessageNotify

  use gridset,  only: DimXMin,       &! X β
    &                 DimXMax,       &! X ξ
    &                 DimZMin,       &! Z β
    &                 RegZMin,       &! Z β
    &                 DimZMax,       &! Z ξ
    &                 SpcNum,        &!Žʬο
    &                 s_Z,           &!顼ʻǤι
    &                 DelZ            !Z γʻֳ
  use basicset, only: BasicSetArray_Init, &!
    &                 PressBasis,    &!̤δవ
    &                 GasRDry,       &!ʬ갵Ǯ
    &                 CpDry,         &!ʬ갵Ǯ
    &                 CvDry,         &!ʬǮ
    &                 MolWtDry,      &!ʬʬ
    &                 Grav,          &!ϲ®
    &                 SpcWetMolFr,   &!Žʬν
    &                 MolWtWet,      &!Žʬʬ
    &                 EnvType,       &!ܾ
    &                 Tropopause,    &!ή̹
    &                 GasRUniv,      &!
    &                 Humidity,      &!ܾм
    &                 TempStrat,     &!طβ [k]
    &                 Dhight          !ŤߴؿΥѥ᡼ [m]
  use Boundary, only: BoundaryXCyc_xz,  &!
    &                 BoundaryZSym_xz,  &!  
    &                 BoundaryXCyc_xza, &!
    &                 BoundaryZSym_xza   !  
  use ECCM,     only: ECCM_Dry,         &!
    &                 ECCM_Wet
  
  !ۤηػ
  implicit none

  !ѿ
  real(8) :: xz_DensBasicZ(DimXMin:DimXMax, DimZMin:DimZMax)
  real(8) :: xz_PressBasicZ(DimXMin:DimXMax, DimZMin:DimZMax)
  real(8) :: xz_ExnerBasicZ(DimXMin:DimXMax, DimZMin:DimZMax)
  real(8) :: xz_TempBasicZ(DimXMin:DimXMax, DimZMin:DimZMax)
  real(8) :: xz_PotTempBasicZ(DimXMin:DimXMax, DimZMin:DimZMax)
  real(8) :: xz_VelSoundBasicZ(DimXMin:DimXMax, DimZMin:DimZMax)
  real(8) :: xza_MixRtBasicZ(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
  real(8) :: xz_EffMolWtBasicZ(DimXMin:DimXMax, DimZMin:DimZMax)
  real(8) :: z_TempBasicZ(DimZMin:DimZMax)
  real(8) :: z_PressBasicZ(DimZMin:DimZMax)
  real(8) :: MolFrIni(SpcNum)
  real(8) :: xza_MolFr(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
  real(8) :: za_MolFr(DimZMin:DimZMax, SpcNum)
  real(8) :: xza_MixRtDivMolWt(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
  real(8) :: z_DTempDZ(DimZMin:DimZMax)
  real(8) :: z_MolWtMean(DimZMin:DimZMax)
  real(8) :: DTempDZ
  real(8) :: Weight
  integer :: i, k, s

  !---------------------------------------------------------------
  ! ν
  !---------------------------------------------------------------
  xz_PressBasicZ    = 0.0d0
  xz_ExnerBasicZ    = 0.0d0
  xz_TempBasicZ     = 0.0d0
  xz_PotTempBasicZ  = 0.0d0
  xz_VelSoundBasicZ = 0.0d0
  xza_MixRtBasicZ   = 0.0d0
  xz_EffMolWtBasicZ = 0.0d0
  z_TempBasicZ      = 0.0d0
  z_PressBasicZ     = 0.0d0
  za_MolFr          = 0.0d0


  !---------------------------------------------------------------
  ! EnvType 򸵤, , , 
  !---------------------------------------------------------------
  MolFrIni = SpcWetMolFr(1:SpcNum) 

  !ʬ. Dry ʤ鴥ǮŪ, Wet ʤ鼾ǮŪʽ
  select case(EnvType)
  case("Dry")
    call ECCM_Dry( MolFrIni, Humidity, z_TempBasicZ, &
      &         z_PressBasicZ, z_MolWtMean, za_MolFr )
  case("Wet")
    call ECCM_Wet( MolFrIni, Humidity, z_TempBasicZ, &
      &         z_PressBasicZ, z_MolWtMean, za_MolFr )
  end select

  do k = RegZMin+1, DimZMax-1     
    z_DTempDZ(k) = (z_TempBasicZ(k) - z_TempBasicZ(k-1)) / DelZ
  end do
  
  ! ή̤ΰ
  !   ̤絤Ȥ. 絤絤ؤܤ 
  !   tanh ѤƤʤ餫ˤĤʤ
  do k = RegZMin+1, DimZMax
    
    !ŤߤĤδؿѰ. tanh Ѥ
    Weight = ( tanh( (s_Z(k) - tropopause ) / Dhight ) + 1.0d0 ) * 5.0d-1
    
    !ͤȤƲ٤׻. ̤Ǥ TempStrat 絤˶Ť
    z_TempBasicZ(k) = z_TempBasicZ(k) * ( 1.0d0 - Weight ) + TempStrat * Weight
    
    !ٸΨǮٸΨ꾮ʤʤ褦
    DTempDZ = &
      & max( z_DTempDZ(k), (z_TempBasicZ(k) - z_TempBasicZ(k-1)) / DelZ )

    !ܾβ٤
    z_TempBasicZ(k) = z_TempBasicZ(k-1) + DTempDZ * DelZ 
    
    !Ϥſ尵ʿդ׻
    z_PressBasicZ(k) =                                                    &
      &  z_PressBasicZ(k-1) * ( ( z_TempBasicZ(k-1) / z_TempBasicZ(k) )   &
      &    ** (Grav * z_MolWtMean(k) / ( DTempDZ * GasRUniv ) ) )
  end do

  !ǧΤ
  call MessageNotify( "M", "BasicEnv", "Basic State Atmospheric Profiles." )
  do k = RegZMin+1, DimZMax-1     
    write(*,*) "temp", k, s_Z(k), z_TempBasicZ(k), z_PressBasicZ(k)
  end do

  ! 2 ˳Ǽ
  do i = DimXMin, DimXMax
    xz_TempBasicZ(i,:)  = z_TempBasicZ  
    xz_PressBasicZ(i,:) = z_PressBasicZ  
  end do

  !
  call BoundaryXCyc_xz( xz_TempBasicZ )
  call BoundaryZSym_xz( xz_TempBasicZ )
  call BoundaryXCyc_xz( xz_PressBasicZ )
  call BoundaryZSym_xz( xz_PressBasicZ )
  
  !---------------------------------------------------------------
  ! 
  !---------------------------------------------------------------
  !ʿˤϰ
  do i = DimXMin, DimXMax      
    xza_MolFr(i,:,:) = za_MolFr
  end do    

  !Υ򺮹Ѵ
  do s = 1, SpcNum
    xza_MixRtBasicZ(:,:,s) = xza_MolFr(:,:,s) * MolWtWet(s) / MolWtDry
  end do

!  !ͤʤꤹʤ褦˺ͤͿ
!  where (xza_MixRtBasicZ <= 1.0d-20 )
!    xza_MixRtBasicZ = 1.0d-20
!  end where
  
  !
  call BoundaryXCyc_xza( xza_MixRtBasicZ )
  call BoundaryZSym_xza( xza_MixRtBasicZ )
      
  !---------------------------------------------------------------
  ! ʬ̤θ
  !---------------------------------------------------------------
  do s = 1, SpcNum
    xza_MixRtDivMolWt(:,:,s) = xza_MixRtBasicZ(:,:,s) / MolWtWet(s)
  end do
  
  xz_EffMolWtBasicZ = &
    & (1.0d0 + sum(xza_MixRtBasicZ,3) ) &
    & / ( MolWtDry * ((1.0d0 / MolWtDry) + sum(xza_MixRtDivMolWt,3)) )

  !  
  call BoundaryXCyc_xz( xz_EffMolWtBasicZ )
  call BoundaryZSym_xz( xz_EffMolWtBasicZ )  

  !---------------------------------------------------------------    
  ! 
  !---------------------------------------------------------------
  xz_PotTempBasicZ = &
    & xz_TempBasicZ * (PressBasis / xz_PressBasicZ) ** (GasRDry / CpDry) 

  !  
  call BoundaryXCyc_xz( xz_PotTempBasicZ )
  call BoundaryZSym_xz( xz_PotTempBasicZ )

  !---------------------------------------------------------------    
  ! ʡؿ
  !---------------------------------------------------------------
  xz_ExnerBasicZ = xz_TempBasicZ / xz_PotTempBasicZ    

  !
  call BoundaryXCyc_xz( xz_ExnerBasicZ )
  call BoundaryZSym_xz( xz_ExnerBasicZ )
  
  !---------------------------------------------------------------    
  ! ̩
  !---------------------------------------------------------------
  xz_DensBasicZ = &
    & PressBasis * (xz_ExnerBasicZ ** (CvDry / GasRDry)) &
    &  / (GasRDry * xz_PotTempBasicZ / xz_EffMolWtBasicZ)

  !
  call BoundaryXCyc_xz( xz_DensBasicZ )
  call BoundaryZSym_xz( xz_DensBasicZ )

  !---------------------------------------------------------------    
  ! ®
  !---------------------------------------------------------------
  xz_VelSoundBasicZ = &
    & sqrt ( &
    &   CpDry * GasRDry * xz_ExnerBasicZ * xz_PotTempBasicZ &
    &   / (CvDry * xz_EffMolWtBasicZ) &
    & )

  !
  call BoundaryXCyc_xz( xz_VelSoundBasicZ )
  call BoundaryZSym_xz( xz_VelSoundBasicZ )
 
  !----------------------------------------------------------
  ! BasicSet ⥸塼ͤ
  !----------------------------------------------------------
  call BasicSetArray_Init(                                  &
    & xz_PressBasicZ,    xz_ExnerBasicZ, xz_TempBasicZ,     &
    & xz_PotTempBasicZ,  xz_DensBasicZ,  xz_VelSoundBasicZ, &
    & xza_MixRtBasicZ, xz_EffMolWtBasicZ )


end subroutine BasicEnv
