!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2004, 2005. All rights reserved.
!---------------------------------------------------------------------
!= Subroutine DisturbEnvMPI
!
!   * Developer: SUGIYAMA Ko-ichiro, ODAKA Masatsugu
!   * Version: $Id: disturbenvmpi.f90,v 1.1 2009-03-05 05:39:40 yamasita Exp $ 
!   * Tag Name: $Name: arare4-20100306 $
!   * Change History: 
!
!== Overview 
!
!ΥǥեͤͿ뤿Υ롼. 
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!== Future Plans
!
!  * ǽʾΥפ䤹
!  * 顼 gf4f90io 
!

subroutine DisturbEnvMPI(                                            &
  &    cfgfile, xz_PotTemp, xz_Exner, pz_VelX, xr_VelZ, xza_MixRt,&
  &    xz_Km, xz_Kh                                               &
  &  )
  !
  !ΥǥեͤͿ뤿Υ롼. 
  !
  
  !⥸塼ɤ߹
  use dc_message, only: MessageNotify

  use gridset,    only:DimXMin,         &!  X β
    &                  DimXMax,         &!  X ξ
    &                  RegXMin,         &!  X β
    &                  RegXMax,         &!  X ξ
    &                  DimZMin,         &!  Z β
    &                  DimZMax,         &!  Z ξ
    &                  MarginX,         &! ׻ΰΥޡ
    &                  MarginZ,         &! ׻ΰΥޡ
    &                  DelZ,            &! Z ι
    &                  SpcNum,          &! Žؼο
    &                  XMin, XMax,      &! 
    &                  ZMin, ZMax,      &! 
    &                  s_X,             &! X ɸ(顼ʻ)
    &                  s_Z               ! Z ɸ(顼ʻ)
  use filesetMPI, only:RandomFile        ! ե
  use basicset,   only:                 &
    &                  SpcWetMolFr,     &!Žʬν
    &                  MolWtWet,        &!Žʬʬ
    &                  MolWtDry,        &!ʬʬ
    &                  xz_TempBasicZ,   &! ܾβ
    &                  xz_PressBasicZ,  &! ܾΰ
    &                  xz_ExnerBasicZ,  &! ̵
    &                  xza_MixRtBasicZ   ! ܾκ
  use BoundaryMPI, only:  BoundaryXCyc_xza , &!
    &                  BoundaryZSym_xza 
  use ECCM,     only:  ECCM_MolFr
  use mpiset,   only:  nprocs, myrank


  !ۤηػ
  implicit none
  
  !ѿ
  character(*), intent(in) :: cfgfile
  real(8), intent(out)  :: pz_VelX(DimXMin:DimXMax,DimZMin:DimZMax)  
                                    !ʿ®ξʬ
  real(8), intent(out)  :: xr_VelZ(DimXMin:DimXMax,DimZMin:DimZMax) 
                                    !ľ®ξʬ 
  real(8), intent(out)  :: xz_Exner(DimXMin:DimXMax,DimZMin:DimZMax)  
                                    !ʡؿξʬ 
  real(8), intent(out)  :: xz_PotTemp(DimXMin:DimXMax,DimZMin:DimZMax)  
                                    !̤ξʬ 
  real(8), intent(out)  :: xza_MixRt(DimXMin:DimXMax,DimZMin:DimZMax, SpcNum)  
                                    !Žʬκ(ʬ)
  real(8), intent(out)  :: xz_Km(DimXMin:DimXMax,DimZMin:DimZMax)
                                    !ư̤ФȻ
  real(8), intent(out)  :: xz_Kh(DimXMin:DimXMax,DimZMin:DimZMax)
                                    !ǮФȻ
  real(8), parameter         :: Pi = 3.1415926535897932385d0 
                                    !߼Ψ
  real(8)       :: Humidity         !м
  real(8)       :: XcRate           !濴(ʿ)ΰФ
  real(8)       :: XrRate           !Ⱦ(ʿ)ΰФ
  real(8)       :: ZcRate           !濴(ľ)ΰФ
  real(8)       :: ZrRate           !Ⱦ(ľ)ΰФ
  real(8)       :: Xc               !濴(ʿ)
  real(8)       :: Xr               !Ⱦ(ʿ)
  real(8)       :: Zc               !濴(ľ)
  real(8)       :: Zr               !Ⱦ(ľ)
  real(8)       :: Xpos             ! X ɸ [m] (Therma-Random )
  real(8)       :: Zpos             ! Z ɸ [m] (Therma-Random )
  real(8)       :: beta(DimXMin:DimXMax, DimZMin:DimZMax)
                                    !κͤФ
  real(8)       :: DelMax           !̾κ
  real(8)       :: Random           !ե뤫
!  real(8)       :: RandomNum(DimXMin:DimXMax)
  real(8), allocatable :: RandomNum(:)
  real(8), allocatable :: RandomNum2(:)
  character(20) :: Type             !̾Υ
  real(8)       :: xz_MolFr(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
                                    !
  real(8)       :: XMaxMPI, XMinMPI
  integer       :: RegXMaxMPI, RegXMinMPI
  integer       :: DimXMaxMPI, DimXMinMPI
  real(8)       :: s_Xmpi(DimXMin:DimXMax)
  integer       :: i, k, s, n       ! DO 롼ѿ



  !-------------------------------------------------------------
  ! 
  !-------------------------------------------------------------
  !NAMELIST եɤ߹
  NAMELIST /disturbset/ &
    & Type, DelMax, XrRate, XcRate, ZrRate, ZcRate, &
    & Humidity, Xpos, Zpos

  open (10, FILE=cfgfile)
  read(10, NML=disturbset)
  close(10)
  
  !
  pz_VelX    = 0.0d0
  xr_VelZ    = 0.0d0
  xz_Exner   = 0.0d0
  xz_PotTemp = 0.0d0
  xza_MixRt  = 0.0d0
  xz_Km      = 0.0d0
  xz_Kh      = 0.0d0

  XMinMPI = XMin
  XMaxMPI = nprocs * (Xmax - Xmin) + XMinMPI
  s_Xmpi = s_X + myrank * (Xmax - Xmin) 

  RegXMinMPI = RegXMin
  RegXMaxMPI = nprocs * (RegXMax - RegXMin) + RegXMinMPI
  DimXMinMPI = RegXMinMPI - MarginX 
  DimXMaxMPI = RegXMaxMPI + MarginX
  allocate(RandomNum(DimXMinMPI:DimXmaxMPI))
  allocate(RandomNum2(DimXMinMPI:DimXmaxMPI))

  Xr = XMaxMPI * XrRate
  Xc = XMaxMPI * XcRate 
!  Xr = minval( s_X, 1, s_X > (XMax - XMin) * XrRate )
!  Xc = minval( s_X, 1, s_X > (XMax - XMin) * XcRate )
  Zr = minval( s_Z, 1, s_Z > (ZMax - ZMin) * ZrRate )
  Zc = minval( s_Z, 1, s_Z > (ZMax - ZMin) * ZcRate )

  write(*,*) "DisturbEnvMPI: ", minval(s_Xmpi), maxval(s_Xmpi)
  write(*,*) "DisturbEnvMPI: ", nprocs, XmaxMPI
  write(*,*) "DisturbEnvMPI: ", Xr, Xc
  !-------------------------------------------------------------
  ! ̤ξ
  !-------------------------------------------------------------
  select case(Type)

  case ("Thermal-KW1978")
    ! ꤵ줿ΰ˲̾Ϳ (Klemp and Wilhelmson, 1978) 
    
    do k = DimZMin, DimZMax
      do i = DimXMin, DimXMax
        beta(i,k) =                                 &
          & (                                       &
          &      ( ( s_Xmpi(i) - Xc ) / Xr ) ** 2.0d0  &
          &    + ( ( s_Z(k) - Zc ) / Zr ) ** 2.0d0  &
          &  ) ** 5.0d-1
      end do
    end do
    
    where ( beta < 1.0d0 )
      xz_PotTemp = DelMax * ( dcos( Pi * 5.0d-1 * beta ) ** 2.0d0 ) &
        &          / xz_ExnerBasicZ
    end where
    

  case ("Thermal-Gauss")
    ! ꤵ줿ɸ濴Ȥʬۤβ̾Ϳ. 

    do k = DimZMin, DimZMax
      do i = DimXMin, DimXMax
        xz_PotTemp(i,k) = &
          & DelMax * dexp( - ( (s_Xmpi(i) - Xc) / Xr )**2.0d0 * 5.0d-1   &
          &                - ( (s_Z(k) - Zc) / Zr )**2.0d0 * 5.0d-1 ) &
          & / xz_ExnerBasicZ(i,k)
      end do
    end do

    where ( sign(1.0d0, DelMax) * xz_PotTemp < DelMax * 1.0d-4 )
      xz_PotTemp = 0.0d0 
    end where
    
  case ("Thermal-MixRt-Gauss")
    ! ꤵ줿ɸ濴Ȥʬۤβ̾ȺͿ. 
    ! , κͤ, ܾκ 0.01 ܤȤ.
    
    do k = DimZMin, DimZMax
      do i = DimXMin, DimXMax
        xz_PotTemp(i,k) =                                             &
          & DelMax * dexp( - ( (s_X(i) - Xc) / Xr )**3.0d0 * 5.0d-1   &
          &                - ( (s_Z(k) - Zc) / Zr )**2.0d0 * 5.0d-1 ) & 
          & / xz_ExnerBasicZ(i,k)

        do s = 1, SpcNum
          xza_MixRt(i,:,s) =                                     &
            & maxval( xza_MixRtBasicZ(:,:,s) ) * 1.0d-1          &
            & * dexp( - ( (s_X(i) - Xc) / Xr )**2.0d0 * 5.0d-1   &
            &         - ( (s_Z(k) - Zc) / Zr )**2.0d0 * 5.0d-1 ) &
            & / xz_ExnerBasicZ(i,:)
        end do
      end do
    end do
    
!    where ( sign(1.0d0, DelMax) * xz_PotTemp < DelMax * 1.0d-4 )
!      xz_PotTemp = 0.0d0 
!    end where
    
  case ("Exner-Gauss")
    ! ꤵ줿, ʲ̤ξͿ. 

    do k = DimZMin, DimZMax
      do i = DimXMin, DimXMax
        xz_Exner(i,k) = &
          & DelMax * dexp( - ( (s_X(i) - Xc) / Xr )**2.0d0 * 5.0d-1 &
          &                - ( (s_Z(k) - Zc) / Zr )**2.0d0 * 5.0d-1 ) 
      end do
    end do

    where ( xz_Exner < DelMax * 1.0d-4)
      xz_Exner = 0.0d0 
    end where
    
  case ("Thermal-Random")
    ! ؤ˥ʾͿ

    open(20,file=RandomFile)
    do i = DimXMinMPI, DimXmaxMPI 
      read(20,*) random
      RandomNum(i) = random
    end do
    close(20)

    do i = DimXMinMPI, DimXmaxMPI 
      !ΤȤƤϥȤʤ褦Ĵ
      RandomNum2(i) = RandomNum(i)  &
        & - sum( RandomNum(RegXMinMPI+1:RegXMaxMPI) ) / real(RegXMaxMPI - RegXMinMPI, 8) 
    end do	

    do i = DimXMin, DimXMax
      k = i + (RegXMax - RegXMin) * myrank
      xz_PotTemp(i, maxloc(s_Z, s_Z <= Zpos) - MarginZ - 1) = &
         & DelMax * RandomNum2(k) / xz_ExnerBasicZ(i, maxloc(s_Z, s_Z <= Zpos) - MarginZ - 1)
      write(*,*) "myrank", myrank, i, RandomNum2(k)
    end do

  case ("HS2001")
    ! Hueso and Sanchez-Lavega Ϥ

    i = ( DimXMax - DimXMin - 10) / 2 
    k = minloc( s_Z, 1, s_Z > 2.5d4 ) - MarginZ
    n = int( 5.0d3 / DelZ )

    xz_PotTemp(i-n:i,k-n:k) = DelMax


  case ("SK1989")
    ! Skamarock and Klemp (1989)  Cold-bubble ¸
    
    xz_PotTemp = 0.0d0

    do k = DimZMin, DimZMax
      do i = DimXMin, DimXMax

        beta(i,k) =                                 &
          & sqrt(                                   &
          &      ( ( s_X(i) - Xc ) / Xr ) ** 2.0d0  &
          &    + ( ( s_Z(k) - Zc ) / Zr ) ** 2.0d0  &
          &  )
      end do
    end do

    where ( beta < 1.0d0 )
      xz_PotTemp = 0.5d0*DelMax*(cos(pi*beta) + 1.0d0)
    end where

  end select

  !-------------------------------------------------------------
  ! . 
  !-------------------------------------------------------------
  if (Humidity /= 0.0d0) then 
    do i = DimXMin, DimXMax      
      call ECCM_MolFr( SpcWetMolFr(1:SpcNum), Humidity, xz_TempBasicZ(i,:), &
        &              xz_PressBasicZ(i,:), xz_MolFr(i,:,:) )
    end do
    
    !Υ򺮹Ѵ
    do s = 1, SpcNum
      xza_MixRt(:,:,s) =                                                    &
        & xz_MolFr(:,:,s) * MolWtWet(s) / MolWtDry - xza_MixRtBasicZ(:,:,s)
    end do
  end if
  
  
  !ͤʤꤹʤ褦˺ͤͿ
!  where (xza_MixRt <= 1.0d-20 )
!    xza_MixRt = 1.0d-20
!  end where
  
  !
  call BoundaryXCyc_xza( xza_MixRt )
  call BoundaryZSym_xza( xza_MixRt )
!  xza_MixRt = xza_BoundaryXCyc_xza( xza_MixRt )
!  xza_MixRt = xza_BoundaryZSym_xza( xza_MixRt )
  

end subroutine DisturbEnvMPI
