!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2004. All rights reserved.
!---------------------------------------------------------------------
                                                                 !=begin
!= Subroutine LatentHeat
!
!   * Developer: KITAMORI Taichi 
!   * Version: $Id: latentheat.f90,v 1.1 2009-03-05 05:39:42 yamasita Exp $
!   * Tag Name: $Name: arare4-20100306 $
!   * Change History: 
!
!== Overview 
!
!ή׻. 
!ŷ̤ŷǮ׻. 
!ŷǮϤ. 
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!
!
!== Future Plans
!
                                                                 !=end
subroutine LatentHeat(xz_Masscond,         & !(in) ŷ
  &                   xz_LatHeatPerMass,   & !(in) ñ̼̤Ǯ
  &                   xz_Qcond)              !(out) ŷǮˤ벹ѲΨ
                                                                 !=begin
  !==Dependency
  use dc_trace, only: BeginSub, EndSub  
  use gridset,  only: DimXMin, DimXMax, DimZMin, DimZMax
!  use physset,  only: GasR              ! 
!  use cloudset, only: SatPressB         ! Antoine μη B
  use ChemData, only: ChemData_SVapPress_AntoineB, & ! Antoine μη B
    &                 ChemData_Cp        ! ʬ갵Ǯ
  use basicset, only: xz_DensBasicZ,  &  ! ̩ٴܾ 
    &                 xz_ExnerBasicZ, &  ! ̵ϴܾ
!    &                 ss_CpBasicZ, &    ! 갵Ǯ
    &                 GasRDry, &         ! 
    &                 CpDry              ! 갵Ǯ
  use StorePotTemp, only: StorePotTempCond
                                                                 !=end
  !==ۤηػ
  implicit none
  
  !==Input
  real(8)                :: xz_LatHeatPerMass(DimXMin:DimXMax, DimZMin:DimZMax)
                                           ! ñ̼̤Ǯ [J/kg]
  real(8)                :: xz_Masscond(DimXMin:DimXMax, DimZMin:DimZMax) 
                                           ! ŷ [kg/m^3 s]

  !==Output
  real(8), intent(out)   :: xz_Qcond(DimXMin:DimXMax, DimZMin:DimZMax) 
                                           ! ŷǮˤ벹ѲΨ [K/s]
  
  !==Work

  call BeginSub("LatentHeat", &
&           fmt="%c",        &
&           c1="Calculate potential temperature tendency bylatent heating.")

  xz_Qcond = xz_LatHeatPerMass * xz_Masscond &
    & / (CpDry * xz_DensBasicZ * xz_ExnerBasicZ)  
!    & / (ss_CpBasicZ * xz_DensBasicZ * xz_ExnerBasicZ)  

  call StorePotTempCond( xz_QCond )

  call EndSub("LatentHeat")

end subroutine LatentHeat
