!= Subroutine BasicEnv_3d
!
! Authors::   SUGIYAMA Koichiro, ODAKA Masatsugu
! Version::   $Id: basicenv_3d.f90,v 1.3 2008-06-19 17:01:10 odakker Exp $
! Tag Name::  $Name: arare4-20100306 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview 
!
!ǥեȤδܾꤹ뤿ѿȷ⥸塼
!   * BasicEnvFile_init: ܾͤ netCDF ե뤫
!   * BasicEnvCalc_Init: ܾξ Namelist ͤ׻
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!== Future Plans
!

subroutine BasicEnv_3d()
  !
  !ǥեȤδܾꤹ뤿Υ֥롼. 
  !ܾ׻, BasicSet ⥸塼ͤ. 
  !
  !ѥν꤫, ܾ(hogeBasicZ ѿ)
  !׻ʬBasicSet ⥸塼뤫ڤΥƤ. 
  !ECCM Ϥ, BasicSet Τ˰¸뤬 hogeBasicZ  use ʤ
  !֥롼Ѥ뤿Ǥ. 
  !

  !⥸塼ɤ߹
  use dc_types, only : DP
  use dc_message, only: MessageNotify

  use gridset_3d,only: DimXMin,       &! X β
    &                 DimXMax,       &! X ξ
    &                 DimYMax,       &! Y ξ
    &                 DimYMin,       &! Y β
    &                 DimZMax,       &! Z ξ
    &                 DimZMin,       &! Z β
    &                 RegZMax,       &! Z ξ
    &                 RegZMin,       &! Z β
    &                 SpcNum,        &!Žʬο
    &                 z_Z,           &!顼ʻǤι
    &                 r_dz           !Z γʻֳ
  use basicset_3d,only: BasicSetArray_Init, &!
    &                 PressBasis,    &!̤δవ
    &                 GasRDry,       &!ʬ갵Ǯ
    &                 CpDry,         &!ʬ갵Ǯ
    &                 CvDry,         &!ʬǮ
    &                 MolWtDry,      &!ʬʬ
    &                 Grav,          &!ϲ®
    &                 SpcWetMolFr,   &!Žʬν
    &                 MolWtWet,      &!Žʬʬ
    &                 EnvType,       &!ܾ
    &                 Tropopause,    &!ή̹
    &                 GasRUniv,      &!
    &                 Humidity,      &!ܾм
    &                 TempStrat,     &!طβ [k]
!    &                 TempSfc,       &!ɽ̲ [k]
!    &                 PressSfc,      &!ɽ̵ [Pa]
    &                 Dhight          !ŤߴؿΥѥ᡼ [m]
  use xyz_module, only: BoundaryXCyc_xyz, &
    &                   BoundaryYCyc_xyz, &
    &                   BoundaryZSym_xyz 

  use ECCM_3d,    only: ECCM_Dry,    &     
    &                   ECCM_Wet
  
  !ۤηػ
  implicit none

  !ѿ
  real(DP) :: xyz_DensBasicZ(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
  real(DP) :: xyz_PressBasicZ(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
  real(DP) :: xyz_ExnerBasicZ(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
  real(DP) :: xyz_TempBasicZ(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
  real(DP) :: xyz_PotTempBasicZ(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
  real(DP) :: xyz_VelSoundBasicZ(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
  real(DP) :: xyza_MixRtBasicZ(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax,SpcNum)
  real(DP) :: xyz_EffMolWtBasicZ(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
  real(DP) :: z_TempBasicZ(DimZMin:DimZMax)
  real(DP) :: z_PressBasicZ(DimZMin:DimZMax)
  real(DP) :: MolFrIni(SpcNum)
  real(DP) :: xyza_MolFr(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax,SpcNum)
  real(DP) :: za_MolFr(DimZMin:DimZMax, SpcNum)
  real(DP) :: xyza_MixRtDivMolWt(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax, SpcNum)
  real(DP) :: z_DTempDZ(DimZMin:DimZMax)
  real(DP) :: z_MolWtMean(DimZMin:DimZMax)
  real(DP) :: DTempDZ
  real(DP) :: Weight
  integer  :: i, j, k, s

  !---------------------------------------------------------------
  ! ν
  !---------------------------------------------------------------
  xyz_ExnerBasicZ    = 0.0d0
  xyz_PressBasicZ    = 0.0d0
  xyz_TempBasicZ     = 0.0d0
  xyz_PotTempBasicZ  = 0.0d0
  xyz_VelSoundBasicZ = 0.0d0
  xyza_MixRtBasicZ   = 0.0d0
  xyz_EffMolWtBasicZ = 0.0d0
  z_TempBasicZ      = 0.0d0
  z_PressBasicZ     = 0.0d0
  za_MolFr          = 0.0d0


  !---------------------------------------------------------------
  ! EnvType 򸵤, , , 
  !---------------------------------------------------------------
  MolFrIni = SpcWetMolFr(1:SpcNum) 

  !ʬ. Dry ʤ鴥ǮŪ, Wet ʤ鼾ǮŪʽ
  select case(EnvType)
  case("Dry")
    call ECCM_Dry( MolFrIni, Humidity, z_TempBasicZ, &
      &         z_PressBasicZ, z_MolWtMean, za_MolFr )
  case("Wet")
    call ECCM_Wet( MolFrIni, Humidity, z_TempBasicZ, &
      &         z_PressBasicZ, z_MolWtMean, za_MolFr )
  end select

  do k = RegZMin+1, DimZMax     
    z_DTempDZ(k) = (z_TempBasicZ(k) - z_TempBasicZ(k-1)) / r_dz(k-1)
  end do
  
  ! ή̤ΰ
  !   ̤絤Ȥ. 絤絤ؤܤ 
  !   tanh ѤƤʤ餫ˤĤʤ
  do k = RegZMin+1, DimZMax
    
    !ŤߤĤδؿѰ. tanh Ѥ
    Weight = ( tanh( (z_Z(k) - tropopause ) / Dhight ) + 1.0d0 ) * 5.0d-1
    
    !ͤȤƲ٤׻. ̤Ǥ TempStrat 絤˶Ť
    z_TempBasicZ(k) = z_TempBasicZ(k) * ( 1.0d0 - Weight ) + TempStrat * Weight
    
    !ٸΨǮٸΨ꾮ʤʤ褦
    DTempDZ = &
      & max( z_DTempDZ(k), (z_TempBasicZ(k) - z_TempBasicZ(k-1)) / r_dz(k-1) )

    !ܾβ٤
    z_TempBasicZ(k) = z_TempBasicZ(k-1) + DTempDZ * r_dz(k-1)
    
    !Ϥſ尵ʿդ׻
    z_PressBasicZ(k) =                                                    &
      &  z_PressBasicZ(k-1) * ( ( z_TempBasicZ(k-1) / z_TempBasicZ(k) )   &
      &    ** (Grav * z_MolWtMean(k) / ( DTempDZ * GasRUniv ) ) )
  end do

  !ǧΤ
  call MessageNotify( "M", "BasicEnv", "Basic State Atmospheric Profiles." )
  do k = RegZMin, DimZMax-1     
    write(*,*) "temp", k, z_Z(k), z_TempBasicZ(k), z_PressBasicZ(k)
  end do

  ! 3 ˳Ǽ
  do j = DimYMin, DimYMax
    do i = DimXMin, DimXMax
      xyz_TempBasicZ(i,j,:)  = z_TempBasicZ(:)  
      xyz_PressBasicZ(i,j,:) = z_PressBasicZ(:)
    end do
  end do

  !
  call BoundaryXCyc_xyz( xyz_TempBasicZ )
  call BoundaryYCyc_xyz( xyz_TempBasicZ )
  call BoundaryZSym_xyz( xyz_TempBasicZ )

  call BoundaryXCyc_xyz( xyz_PressBasicZ)
  call BoundaryYCyc_xyz( xyz_PressBasicZ )
  call BoundaryZSym_xyz( xyz_PressBasicZ )


!  case("IsoThermal")
!    z_TempBasicZ  = TempSfc
!
!    z_PressBasicZ = PressSfc * exp ( - Grav / z_TempBasicZ / GasRDry * z_Z)
!
!  end select

  !---------------------------------------------------------------
  ! 
  !---------------------------------------------------------------
  !ʿˤϰ
  do i = DimXMin, DimXMax      
    do j = DimYMin, DimYMax
      xyza_MolFr(i,j,:,:) = za_MolFr
    end do
  end do

  !Υ򺮹Ѵ
  do s = 1, SpcNum
    xyza_MixRtBasicZ(:,:,:,s) = xyza_MolFr(:,:,:,s) * MolWtWet(s) / MolWtDry
  end do

!  !ͤʤꤹʤ褦˺ͤͿ
!  where (xyza_MixRtBasicZ <= 1.0d-20 )
!    xyza_MixRtBasicZ = 1.0d-20
!  end where
  
  !
  do s = 1, SpcNum
    call BoundaryXCyc_xyz( xyza_MixRtBasicZ(:,:,:,s) )
    call BoundaryYCyc_xyz( xyza_MixRtBasicZ(:,:,:,s) )
    call BoundaryZSym_xyz( xyza_MixRtBasicZ(:,:,:,s) )
  end do

  !---------------------------------------------------------------
  ! ʬ̤θ
  !---------------------------------------------------------------
  do s = 1, SpcNum
    xyza_MixRtDivMolWt(:,:,:,s) = xyza_MixRtBasicZ(:,:,:,s) / MolWtWet(s)
  end do
  
  xyz_EffMolWtBasicZ = &
    & (1.0d0 + sum(xyza_MixRtBasicZ,4) ) &
    & / ( MolWtDry * ((1.0d0 / MolWtDry) + sum(xyza_MixRtDivMolWt,4)) )

  !  
  call BoundaryXCyc_xyz( xyz_EffMolWtBasicZ )
  call BoundaryYCyc_xyz( xyz_EffMolWtBasicZ )
  call BoundaryZSym_xyz( xyz_EffMolWtBasicZ )

  !---------------------------------------------------------------    
  ! 
  !---------------------------------------------------------------
  xyz_PotTempBasicZ = &
    & xyz_TempBasicZ * (PressBasis / xyz_PressBasicZ) ** (GasRDry / CpDry) 


  !  
  call BoundaryXCyc_xyz( xyz_PotTempBasicZ )
  call BoundaryYCyc_xyz( xyz_PotTempBasicZ )
  call BoundaryZSym_xyz( xyz_PotTempBasicZ )

  !---------------------------------------------------------------    
  ! ʡؿ
  !---------------------------------------------------------------
  xyz_ExnerBasicZ = xyz_TempBasicZ / xyz_PotTempBasicZ    

  !
  call BoundaryXCyc_xyz( xyz_ExnerBasicZ )
  call BoundaryYCyc_xyz( xyz_ExnerBasicZ )
  call BoundaryZSym_xyz( xyz_ExnerBasicZ )
  
  !---------------------------------------------------------------    
  ! ̩
  !---------------------------------------------------------------
!  xyz_DensBasicZ = &
!    & PressBasis * (xyz_ExnerBasicZ ** (CvDry / GasRDry)) &
!    &  / (GasRDry * xyz_PotTempBasicZ )

  xyz_DensBasicZ = &
    & PressBasis * (xyz_ExnerBasicZ ** (CvDry / GasRDry)) &
    &  / (GasRDry * xyz_PotTempBasicZ / xyz_EffMolWtBasicZ)


  !
  call BoundaryXCyc_xyz( xyz_DensBasicZ )
  call BoundaryYCyc_xyz( xyz_DensBasicZ )
  call BoundaryZSym_xyz( xyz_DensBasicZ )

  !---------------------------------------------------------------    
  ! ®
  !---------------------------------------------------------------
!  xyz_VelSoundBasicZ = &
!    & sqrt ( &
!    &   CpDry * GasRDry * xyz_ExnerBasicZ * xyz_PotTempBasicZ &
!    &   / CvDry &
!    & )

  xyz_VelSoundBasicZ = &
    & sqrt ( &
    &   CpDry * GasRDry * xyz_ExnerBasicZ * xyz_PotTempBasicZ &
    &   / (CvDry * xyz_EffMolWtBasicZ) &
    & )

  !
  call BoundaryXCyc_xyz( xyz_VelSoundBasicZ )
  call BoundaryYCyc_xyz( xyz_VelSoundBasicZ )
  call BoundaryZSym_xyz( xyz_VelSoundBasicZ )

  !----------------------------------------------------------
  ! BasicSet ⥸塼ͤ
  !----------------------------------------------------------
!  call BasicSetArray_Init(                                  &
!    & xyz_PressBasicZ,    xyz_ExnerBasicZ, xyz_TempBasicZ,     &
!    & xyz_PotTempBasicZ,  xyz_DensBasicZ,  xyz_VelSoundBasicZ &
!    & )

  call BasicSetArray_Init(                                  &
    & xyz_PressBasicZ,    xyz_ExnerBasicZ, xyz_TempBasicZ,     &
    & xyz_PotTempBasicZ,  xyz_DensBasicZ,  xyz_VelSoundBasicZ, &
    & xyza_MixRtBasicZ, xyz_EffMolWtBasicZ )


end subroutine BasicEnv_3d
