!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2004, 2005. All rights reserved.
!---------------------------------------------------------------------
!= Subroutine DisturbEnv_3d
!
!   * Developer: SUGIYAMA Ko-ichiro, ODAKA Masatsugu
!   * Version: $Id: disturbenv_3d.f90,v 1.6 2008-06-24 20:16:40 odakker2 Exp $ 
!   * Tag Name: $Name: arare4-20100306 $
!   * Change History: 
!
!== Overview 
!
!ΥǥեͤͿ뤿Υ롼. 
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!== Future Plans
!
!  * ǽʾΥפ䤹
!  * 顼 gf4f90io 
!

subroutine DisturbEnv_3d(                        &
  &    cfgfile, xyz_PotTemp, xyz_Exner,          &
  &    pyz_VelX, xqz_VelY, xyr_VelZ,             &
  &    xyza_MixRt, xyz_Km, xyz_Kh                &
  &  )
  !
  !ΥǥեͤͿ뤿Υ롼. 
  !
  
  !⥸塼ɤ߹
  use dc_types, only : DP
  use dc_iounit,  only: FileOpen
  use dc_message, only: MessageNotify

  use gridset_3d, only:DimXMin,         &!  X β
    &                  DimXMax,         &!  X ξ
    &                  DimYMin,         &!  Y β
    &                  DimYMax,         &!  Y ξ
    &                  DimZMin,         &!  Z β
    &                  DimZMax,         &!  Z ξ
    &                  Zmargin,         &!  
    &                  SpcNum,          &! Žؼο
    &                  XMin, XMax,      &! 
    &                  YMin, YMax,      &! 
    &                  ZMin, ZMax,      &! 
    &                  x_X,             &! X ɸ(顼ʻ)
    &                  y_Y,             &! X ɸ(顼ʻ)
    &                  z_Z,             &! Z ɸ(顼ʻ)
    &                  xyz_X, xyz_Y, xyz_Z, &
    &                  x_dx, y_dy, z_dz
  use fileset_3d, only:RandomFile        ! ե
  use basicset_3d,only:                 &
    &                  SpcWetMolFr,     &!Žʬν
    &                  MolWtWet,        &!Žʬʬ
    &                  MolWtDry,        &!ʬʬ
    &                  xyz_TempBasicZ,  &! ܾβ
    &                  xyz_PressBasicZ, &! ܾΰ
    &                  xyz_ExnerBasicZ   ! ̵
!    &                  xyza_MixRtBasicZ  ! ܾκ

  use xyz_module, only: BoundaryXCyc_xyz, &
    &                   BoundaryYCyc_xyz, &
    &                   BoundaryZSym_xyz 
!  use ECCM_3d,     only:  ECCM_MolFr


  !ۤηػ
  implicit none
  
  !ѿ
  character(*), intent(in) :: cfgfile
  real(DP), intent(out)  :: pyz_VelX(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)  
                                    !ʿ®ξʬ
  real(DP), intent(out)  :: xqz_VelY(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)  
                                    !ʿ®ξʬ
  real(DP), intent(out)  :: xyr_VelZ(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax) 
                                    !ľ®ξʬ 
  real(DP), intent(out)  :: xyz_Exner(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)  
                                    !ʡؿξʬ 
  real(DP), intent(out)  :: xyz_PotTemp(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)  
                                    !̤ξʬ 
  real(DP), intent(out)  :: xyza_MixRt(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax,SpcNum)  
                                    !Žʬκ(ʬ)
  real(DP), intent(out)  :: xyz_Km(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                    !ư̤ФȻ
  real(DP), intent(out)  :: xyz_Kh(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                    !ǮФȻ
  real(DP), parameter         :: Pi = 3.1415926535897932385d0 
                                    !߼Ψ
  real(DP)       :: Humidity        !м
  real(DP)       :: XcRate          !濴(ʿ)ΰФ
  real(DP)       :: XrRate          !Ⱦ(ʿ)ΰФ
  real(DP)       :: YcRate          !濴(ʿ)ΰФ
  real(DP)       :: YrRate          !Ⱦ(ʿ)ΰФ
  real(DP)       :: ZcRate          !濴(ľ)ΰФ
  real(DP)       :: ZrRate          !Ⱦ(ľ)ΰФ
  real(DP)       :: Xc              !濴(ʿ)
  real(DP)       :: Xr              !Ⱦ(ʿ)
  real(DP)       :: Yc              !濴(ʿ)
  real(DP)       :: Yr              !Ⱦ(ʿ)
  real(DP)       :: Zc              !濴(ľ)
  real(DP)       :: Zr              !Ⱦ(ľ)
  real(DP)       :: Xpos            ! X ɸ [m] (Therma-Random )
  real(DP)       :: Ypos            ! Y ɸ [m] (Therma-Random )
  real(DP)       :: Zpos            ! Z ɸ [m] (Therma-Random )
  real(DP)       :: beta(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                    !κͤФ
  real(DP)       :: DelMax          !̾κ
  real(DP)       :: Random          !ե뤫
  real(DP)       :: RandomNum(DimXMin:DimXMax,DimYMin:DimYMax)
  real(DP)       :: RandomNum2(DimXMin:DimXMax,DimYMin:DimYMax)
  real(DP)       :: RandomMean       
  character(20)  :: Type            !̾Υ
!  real(DP)       :: xyza_MolFr(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax, SpcNum)
                                    !

  integer       :: i, j, k, s, n    ! DO 롼ѿ
  integer       :: unit             ! ֹ

  !-------------------------------------------------------------
  ! 
  !-------------------------------------------------------------
  !NAMELIST եɤ߹
  NAMELIST /disturbset/ &
    & Type, DelMax, XrRate, XcRate, YrRate, YcRate, ZrRate, ZcRate, &
    & Humidity, Xpos, Ypos, Zpos

  call FileOpen(unit, file=cfgfile, mode='r')
  read(unit, NML=disturbset)
  close(unit)

  !
  pyz_VelX    = 0.0d0
  xqz_VelY    = 0.0d0
  xyr_VelZ    = 0.0d0
  xyz_Exner   = 0.0d0
  xyz_PotTemp = 0.0d0
  xyza_MixRt  = 0.0d0
  xyz_Km      = 0.0d0
  xyz_Kh      = 0.0d0

  Xr = minval( x_X, 1, x_X > (XMax - XMin) * XrRate )
  Xc = minval( x_X, 1, x_X > (XMax - XMin) * XcRate )
  Yr = minval( y_Y, 1, y_Y > (YMax - YMin) * YrRate )
  Yc = minval( y_Y, 1, y_Y > (YMax - YMin) * YcRate )
  Zr = minval( z_Z, 1, z_Z > (ZMax - ZMin) * ZrRate )
  Zc = minval( z_Z, 1, z_Z > (ZMax - ZMin) * ZcRate )

  !-------------------------------------------------------------
  ! ̤ξ
  !-------------------------------------------------------------
  select case(Type)

  case ("Thermal-KW1978")
    ! ꤵ줿ΰ˲̾Ϳ (Klemp and Wilhelmson, 1978) 
    
    beta =                               &
      & (                                       &
      &      ( ( xyz_X - Xc ) / Xr ) ** 2.0d0  &
      &    + ( ( xyz_Y - Yc ) / Yr ) ** 2.0d0  &
      &    + ( ( xyz_Z - Zc ) / Zr ) ** 2.0d0  &
      &  ) ** 5.0d-1
    
    where ( beta < 1.0d0 )
      xyz_PotTemp = DelMax * ( dcos( Pi * 5.0d-1 * beta ) ** 2.0d0 ) &
        &          / xyz_ExnerBasicZ
    end where
    

  case ("Thermal-Gauss")
    ! ꤵ줿ɸ濴Ȥʬۤβ̾Ϳ. 

    xyz_PotTemp = &
      & DelMax    &
      & * dexp( - ( (xyz_X - Xc) / Xr )**2.0d0 * 5.0d-1   &
      &         - ( (xyz_Y - Yc) / Yr )**2.0d0 * 5.0d-1   &
      &         - ( (xyz_Z - Zc) / Yr )**2.0d0 * 5.0d-1 ) &
      & / xyz_ExnerBasicZ

    where ( sign(1.0d0, DelMax) * xyz_PotTemp < DelMax * 1.0d-4 )
      xyz_PotTemp = 0.0d0 
    end where

  case ("Thermal-GaussXZ")
    ! ꤵ줿ɸ濴Ȥʬۤβ̾Ϳ. 

    xyz_PotTemp = &
      & DelMax    &
      & * dexp( - ( (xyz_X - Xc) / Xr )**2.0d0 * 5.0d-1   &
      &         - ( (xyz_Z - Zc) / Zr )**2.0d0 * 5.0d-1 ) &
      & / xyz_ExnerBasicZ

    where ( sign(1.0d0, DelMax) * xyz_PotTemp < DelMax * 1.0d-4 )
      xyz_PotTemp = 0.0d0 
    end where
  
  case ("Thermal-GaussYZ")
    ! ꤵ줿ɸ濴Ȥʬۤβ̾Ϳ. 

    xyz_PotTemp = &
      & DelMax    &
      & * dexp( - ( (xyz_Y - Yc) / Yr )**2.0d0 * 5.0d-1   &
      &         - ( (xyz_Z - Zc) / Zr )**2.0d0 * 5.0d-1 ) &
      & / xyz_ExnerBasicZ

    where ( sign(1.0d0, DelMax) * xyz_PotTemp < DelMax * 1.0d-4 )
      xyz_PotTemp = 0.0d0 
    end where
 
  case ("Adv-XZ-X")
    ! X ήΥƥ
    ! ꤵ줿ɸ濴Ȥʬۤβ̾Ϳ. 

    xyz_PotTemp = &
      & DelMax    &
      & * dexp( - ( (xyz_X - Xc) / Xr )**2.0d0 * 5.0d-1   & 
      &         - ( (xyz_Z - Zc) / Zr )**2.0d0 * 5.0d-1 ) 

    where ( sign(1.0d0, DelMax) * xyz_PotTemp < DelMax * 1.0d-4 )
      xyz_PotTemp = 0.0d0 
    end where

    where ( xyz_PotTemp > DelMax  )
      xyz_PotTemp = DelMax
    end where

    pyz_VelX = 20.0d0

  case ("Adv-XZ-Z")
    ! Z ήΥƥ
    ! ꤵ줿ɸ濴Ȥʬۤβ̾Ϳ. 

    xyz_PotTemp = &
      & DelMax    &
      & * dexp( - ( (xyz_X - Xc) / Xr )**2.0d0 * 5.0d-1   & 
      &         - ( (xyz_Z - Zc) / Zr )**2.0d0 * 5.0d-1 ) 

    where ( sign(1.0d0, DelMax) * xyz_PotTemp < DelMax * 1.0d-4 )
      xyz_PotTemp = 0.0d0 
    end where

    where ( xyz_PotTemp > DelMax  )
      xyz_PotTemp = DelMax
    end where

    xyr_VelZ = 20.0d0

  case ("Adv-YZ-Y")
    ! Y ήΥƥ
    ! ꤵ줿ɸ濴Ȥʬۤβ̾Ϳ. 

    xyz_PotTemp = &
      & DelMax    &
      & * dexp( - ( (xyz_Y - Yc) / Yr )**2.0d0 * 5.0d-1   & 
      &         - ( (xyz_Z - Zc) / Zr )**2.0d0 * 5.0d-1 ) 

    where ( sign(1.0d0, DelMax) * xyz_PotTemp < DelMax * 1.0d-4 )
      xyz_PotTemp = 0.0d0 
    end where

    where ( xyz_PotTemp > DelMax  )
      xyz_PotTemp = DelMax
    end where

    xqz_VelY = 20.0d0

  case ("Adv-YZ-Z")
    ! Z ήΥƥ
    ! ꤵ줿ɸ濴Ȥʬۤβ̾Ϳ. 

    xyz_PotTemp = &
      & DelMax    &
      & * dexp( - ( (xyz_Y - Yc) / Yr )**2.0d0 * 5.0d-1   & 
      &         - ( (xyz_Z - Zc) / Zr )**2.0d0 * 5.0d-1 ) 

    where ( sign(1.0d0, DelMax) * xyz_PotTemp < DelMax * 1.0d-4 )
      xyz_PotTemp = 0.0d0 
    end where

    where ( xyz_PotTemp > DelMax  )
      xyz_PotTemp = DelMax
    end where

    xyr_VelZ = 20.0d0

  case ("Adv-XZ-XZ")
    ! XZ ήΥƥ
    ! ꤵ줿ɸ濴Ȥʬۤβ̾Ϳ. 

    xyz_PotTemp = &
      & DelMax    &
      & * dexp( - ( (xyz_X - Xc) / Xr )**2.0d0 * 5.0d-1   & 
      &         - ( (xyz_Z - Zc) / Zr )**2.0d0 * 5.0d-1 ) 

    where ( sign(1.0d0, DelMax) * xyz_PotTemp < DelMax * 1.0d-4 )
      xyz_PotTemp = 0.0d0 
    end where

    where ( xyz_PotTemp > DelMax  )
      xyz_PotTemp = DelMax
    end where

    pyz_VelX = 20.0d0
    xyr_VelZ = 20.0d0

  case ("Adv-YZ-YZ")
    ! YZ ήΥƥ
    ! ꤵ줿ɸ濴Ȥʬۤβ̾Ϳ. 

    xyz_PotTemp = &
      & DelMax    &
      & * dexp( - ( (xyz_Y - Yc) / Yr )**2.0d0 * 5.0d-1   & 
      &         - ( (xyz_Z - Zc) / Zr )**2.0d0 * 5.0d-1 ) 

    where ( sign(1.0d0, DelMax) * xyz_PotTemp < DelMax * 1.0d-4 )
      xyz_PotTemp = 0.0d0 
    end where

    where ( xyz_PotTemp > DelMax  )
      xyz_PotTemp = DelMax
    end where

    xqz_VelY = 20.0d0
    xyr_VelZ = 20.0d0

  case ("Exner-Gauss")
    ! ꤵ줿, ʰϤξͿ. 

    xyz_Exner = &
      & DelMax  &
      & * dexp( - ( (xyz_X - Xc) / Xr )**2.0d0 * 5.0d-1 ) &
      & * dexp( - ( (xyz_Y - Yc) / Yr )**2.0d0 * 5.0d-1 ) &
      & * dexp( - ( (xyz_Z - Zc) / Zr )**2.0d0 * 5.0d-1 ) 

    where ( xyz_Exner < DelMax * 1.0d-4)
      xyz_Exner = 0.0d0 
    end where
    
  case ("Exner-GaussX")
    ! ꤵ줿, ʰϤξͿ. 
    ! (X )

    xyz_Exner = &
      & DelMax  &
      & * dexp( - ( (xyz_Y - Yc) / Yr )**2.0d0 * 5.0d-1 ) &
      & * dexp( - ( (xyz_Z - Zc) / Zr )**2.0d0 * 5.0d-1 ) 

    where ( xyz_Exner < DelMax * 1.0d-4)
      xyz_Exner = 0.0d0 
    end where

  case ("Exner-GaussY")
    ! ꤵ줿, ʰϤξͿ. 
    ! (Y )

    xyz_Exner = &
      & DelMax  &
      & * dexp( - ( (xyz_X - Xc) / Xr )**2.0d0 * 5.0d-1 ) &
      & * dexp( - ( (xyz_Z - Zc) / Zr )**2.0d0 * 5.0d-1 ) 

    where ( xyz_Exner < DelMax * 1.0d-4)
      xyz_Exner = 0.0d0 
    end where

  case ("Exner-GaussZ")
    ! ꤵ줿, ʰϤξͿ. 
    ! (Z )

    xyz_Exner = &
      & DelMax  &
      & * dexp( - ( (xyz_X - Xc) / Xr )**2.0d0 * 5.0d-1 ) &
      & * dexp( - ( (xyz_Y - Yc) / Yr )**2.0d0 * 5.0d-1 ) 

    where ( xyz_Exner < DelMax * 1.0d-4)
      xyz_Exner = 0.0d0 
    end where
    
  case ("Thermal-Random")
    ! ؤ˥ʾͿ

    call FileOpen(unit, file=RandomFile, mode='r')
    do j = DimYMin, DimYMax
      do i = DimXMin, DimXMax
        read(unit,*) random
        RandomNum(i,j) = random
    end do
    end do
    close(unit)

    ! ʿͤ׻
    RandomMean = 0.0d0

    do j = DimYMin, DimYMax
      do i = DimXMin, DimXMax
        RandomMean = RandomMean + &
          & (RandomNum(i,j)*x_dx(i)*y_dy(j))/((XMax-Xmin)*(YMax-YMin))
      end do
    end do

    do j = DimYMin, DimYMax
      do i = DimXMin, DimXMax
        !ΤȤƤϥȤʤ褦Ĵ
        RandomNum2(i,j) = RandomNum(i,j)  - RandomMean

        xyz_PotTemp(i,j,maxloc(z_Z, z_Z <= Zpos) - Zmargin ) = &
          & DelMax * RandomNum2(i,j) / xyz_ExnerBasicZ(i,j,maxloc(z_Z, z_Z <= Zpos) - Zmargin - 1)
        
      end do
    end do

  case ("HS2001")
    ! Hueso and Sanchez-Lavega Ϥ

    i = ( DimXMax - DimXMin - 10) / 2 
    j = ( DimYMax - DimYMin - 10) / 2 
    k = minloc( z_Z, 1, z_Z > 2.5d4 ) - Zmargin
    n = int( 5.0d3 / z_dz(1) )

    xyz_PotTemp(i-n:i,j-n:j,k-n:k) = DelMax


  case ("SK1989")
    ! Skamarock and Klemp (1989)  Cold-bubble ¸
    
    xyz_PotTemp = 0.0d0

    beta =                                 &
      & sqrt(                                   &
      &      ( ( xyz_X - Xc ) / Xr ) ** 2.0d0  &
      &    + ( ( xyz_Y - Yc ) / Yr ) ** 2.0d0  &
      &    + ( ( xyz_Z - Zc ) / Zr ) ** 2.0d0  &
      &  )

    where ( beta < 1.0d0 )
      xyz_PotTemp = 0.5d0*DelMax*(cos(pi*beta) + 1.0d0)
    end where

  end select

  !-------------------------------------------------------------
  ! . 
  !-------------------------------------------------------------
!  if (Humidity /= 0.0d0) then 
!    do i = DimXMin, DimXMax      
!      do j = DimYMin, DimYMax      
!        call ECCM_MolFr( SpcWetMolFr(1:SpcNum), Humidity, &
!          &              xyz_TempBasicZ(i,j,:),           &
!          &              xyz_PressBasicZ(i,j,:), xyza_MolFr(i,j,:,:) )
!      end do
!    end do
    
    !Υ򺮹Ѵ
!    do s = 1, SpcNum
!      xyza_MixRt(:,:,:,s) =  &
!        & xyza_MolFr(:,:,:,s) &
!        & * MolWtWet(s) / MolWtDry - xyza_MixRtBasicZ(:,:,:,s)
!    end do
!  end if
  
  
  !ͤʤꤹʤ褦˺ͤͿ
!  where (xza_MixRt <= 1.0d-20 )
!    xza_MixRt = 1.0d-20
!  end where
  
  !
!  do s =1, SpcNum
!    call BoundaryXCyc_xyz( xyza_MixRt(:,:,:,s) )
!    call BoundaryYCyc_xyz( xyza_MixRt(:,:,:,s) )
!    call BoundaryZSym_xyz( xyza_MixRt(:,:,:,s) )
!  end do

end subroutine DisturbEnv_3d
