!= Program ArareAnal
!
! Authors::   SUGIYAMA Ko-ichiro, ODAKA Masatsugu
! Version::   $Id: arare-analysis.f90,v 1.2 2010-03-05 03:54:28 sugiyama Exp $
! Tag Name::  $Name: arare4-20100306 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview 
!
! ϳإǥ deepconv/arare 2 ǡץ
!
!
program ArareAnal

  !----- ⥸塼ɤ߹ ------

  !-----   , ʸ   ----
  use dc_types,       only : STRING
  use dc_string,      only : StoA

  !-----   å   -----
  use dc_message,     only: MessageNotify

  !  ޥɥ饤
  use argset,        only : argset_init  

  !-----    ⥸塼   -----
  !  ̷׻⥸塼
  use chemcalc, only: chemcalc_init, xz_SvapPress, xz_LatentHeat, ReactHeatNH4SH
  use chemdata, only: chemdata_init

  !  ϥե̾⥸塼
  use fileset,       only : fileset_init

  !  ǥХåϴ⥸塼
  use debugset,      only : debugset_init

  !  ִ⥸塼
  use timeset,       only : timeset_init, TimeDisp, TImeInt

  !  ʻ⥸塼 
  use gridset,       only : gridset_init, DelX, DelZ, &
    &                       DimXMin, DimXMax, DimZMin, DimZMax, SpcNum, &
    &                       RegXMax, RegZMax, RegXMin, RegZMin

  !  ܾ⥸塼
  use basicset,      only : basicset_init, SpcWetSymbol, &
    &                       MolWtDry, MolWtWet, CpDry, PressBasis, GasRDry,    &
    &                       SpcWetID, SpcWetMolfr,    &
    &                       xza_MixRtBasicZ, xz_PotTempBasicZ, xz_ExnerBasicZ, &
    &                       xz_TempBasicZ, xz_PressBasicZ, Grav, xz_EffMolWtBasicZ

  !  롼⥸塼
  use moistset,      only: moistset_init,   &
    &                      GasNum, CloudNum, RainNum, CondNum, RactNum, &
    &                      IdxG,   IdxC,   IdxR,                        &
    &                      IdxCG,  IdxCC,  IdxCR,                       &
    &                      IdxNH3, IdxH2S, IdxNH4SHc, IdxNH4SHr         

  use ChemCalc, only: xz_LatentHeat,    &!Ǯ
    &                 ReactHeatNH4SH     !NH4SH ȿǮ

  !  ѻʹ⥸塼
  use StorePotTemp,      only : StorePotTemp_init
  use StoreMixRt,        only : StoreMixRt_init
  use StoreBuoy,         only : StoreBuoy_init
  use StoreStab,         only : StoreStab_init

  !-----    ⥸塼   -----
  !ʬʿѱ黻
  use average

  !  Ǯ徺βٸΨ׻ѥ⥸塼
  use ECCM,         only : eccm_molfr, eccm_stab
  
  ! 
  use boundary,      only : BoundaryXCyc_xz, BoundaryZSym_xz

  !  ᵤϷ׻ѥ⥸塼
  use MoistBuoyancy,only : MoistBuoy_Init, xr_BuoyMolWt, xr_BuoyDrag
  use DynFunc,       only : xr_Buoy
  
  use average, only:  xz_avr_xr
  use differentiate_center2, only: xr_dz_xz

  !ۤηػ
  implicit none
  
  !ѿ
  real(8), allocatable :: xz_PotTemp(:,:)
  real(8), allocatable :: xz_PotTempAll(:,:)
  real(8), allocatable :: xz_VTempAll(:,:)
  real(8), allocatable :: xz_Exner(:,:)
  real(8), allocatable :: pz_VelX(:,:)
  real(8), allocatable :: xr_VelZ(:,:)
  real(8), allocatable :: xza_MixRt(:,:,:)
  real(8), allocatable :: xza_MixRtAll(:,:,:)
  real(8), allocatable :: xza_MixRtAll2(:,:,:)
  real(8), allocatable :: xza_MixRtSat(:,:,:)
  real(8), allocatable :: xza_MixRtEq(:,:,:)
  real(8), allocatable :: xza_Humidity(:,:,:)
  real(8), allocatable :: za_MolFrEq(:,:)
  real(8), allocatable :: xz_VPotTempAll(:,:)
  real(8), allocatable :: xz_EqPotTempAll(:,:)
  real(8), allocatable :: xz_Dens(:,:)
  real(8)              :: AnalTime
  real(8)              :: Hum

  real(8), allocatable :: xz_TempAll(:,:)
  real(8), allocatable :: xz_PressAll(:,:)
  real(8), allocatable :: xz_EffMolWt(:,:)
  real(8), allocatable :: xza_MixRtDivMolWt(:,:,:)
  real(8), allocatable :: xza_LatentHeat(:,:,:)

  real(8), allocatable :: xz_EqConst(:,:)
  real(8), allocatable :: xz_EqConstSat(:,:)

  real(8), allocatable :: xza_MolFrAll(:,:,:)
  real(8), allocatable :: xz_MolWtWet(:,:)
  real(8), allocatable :: xz_Stab(:,:)
  real(8), allocatable :: xz_StabTemp(:,:)
  real(8), allocatable :: xz_StabMolWt(:,:)

  real(8), allocatable :: xz_StrmFunc(:,:)
  real(8), allocatable :: pq_StrmFunc(:,:)
  real(8), allocatable :: xr_Dens(:,:)
  real(8), allocatable :: pz_Dens(:,:)
  real(8), allocatable :: MolFrIni(:)
  real(8)             :: Humidity
  integer             :: t, s, i, k, tt, step
  character(100)       :: cfgfile


  !ޥɥ饤β
  !  NAMELIST ե̾ɤ߹
  call argset_init(cfgfile)

  !ʪν
  call chemdata_init()

  !˴ؤν
  !  NAMELIST ɬפʾɤ߼, ִϢѿԤ. 
  call timeset_init(cfgfile)

  !ʻν
  !  NAMELIST , ʻ׻
  call gridset_init(cfgfile)
  
  !ط׻롼ν
  call chemcalc_init()

  !ܾξν
  !  NAMELIST , ܾꤹ.
  call basicset_init(cfgfile)
  
  !I/O ե̾ν
  !  NAMELIST ե̾ꤷ, deepconv/arare 
  !  ϥե̾ NAMELIST 
  call fileset_init(cfgfile)
  
  !ܾμ
  call AnalFile_BasicZ_Get( )

  !롼ζͭѿν
  call moistset_init()

  !ѻͤݴɤ뤿Υ⥸塼ν
  !  NAMELIST , ܾꤹ.
  call StorePotTemp_init( )
  call StoreMixRt_init( )
  call StoreBuoy_init( )  
  call StoreStab_init( )  

  !ѿν. ȤꤢͤꤵƤ. 
  call ArareAlloc

  !ʬ̤ФϷ׻롼ν
  call MoistBuoy_Init()             
  
  !NetCDF եκȴܾμ  
  call AnalFile_Open( )
    
  !----------------------------------------------------------------------
  ! ͤη׻
  !   ʤʤ, եͤ
  !   Ŭǡְ (ǽΥǡϽϤʤ,  500 ƥåʬ). 
  !----------------------------------------------------------------------
!  do t = 1, int( TimeInt / TimeDisp ) + 1
  step = int( TimeInt / TimeDisp )
!!  STEPS: do while (step >= 500)
!!   write(*,*) step
!!   if (mod(step, 2) == 1) then 
!!       exit STEPS
!!    end if
!!    step = step / 2 
!!  end do STEPS
  write(*,*) "**** STEPS ***** ", int( TimeInt / TimeDisp ), " ==> ", step

  TIMESTEP: do tt = 0, int( TimeInt / TimeDisp) -1
     if ( mod(tt, int(TimeInt / TimeDisp / step)) /= 0 ) then 
        cycle TIMESTEP
     end if
     t = tt + 1
    
    !----------------------------------------------------------------
    ! ҥȥե򳫤ͤ. 
    !----------------------------------------------------------------
    call AnalFile_Get(                                           &
      &       t,  AnalTime,                                      &
      &       xz_PotTemp, xz_Exner, pz_VelX, xr_VelZ, xza_MixRt )
    write(*,*) t, AnalTime    
  
    !----------------------------------------------------------------
    ! 
    !----------------------------------------------------------------
    xza_MixRtAll = xza_MixRt + xza_MixRtBasicZ

    !----------------------------------------------------------------
    ! ١Ϥη׻
    !----------------------------------------------------------------
    xz_PressAll = &
      & PressBasis * ((xz_Exner + xz_ExnerBasicZ ) ** (CpDry / GasRDry))
    
    xz_PotTempAll  = xz_PotTemp + xz_PotTempBasicZ
    xz_TempAll = ( xz_Exner + xz_ExnerBasicZ ) * xz_PotTempAll

    !----------------------------------------------------------------
    ! ̩, ̤η׻
    !----------------------------------------------------------------
    xza_MixRtDivMolWt = 0.0d0
    do s = 1, GasNum
      xza_MixRtDivMolWt(:,:,IdxG(s)) = xza_MixRtAll(:,:,IdxG(s)) / MolWtWet(IdxG(s))
    end do

    xz_EffMolWt = &
      & (1.0d0 + sum(xza_MixRtAll,3)) &
      & / (MolWtDry * ((1.0d0 / MolWtDry) + sum(xza_MixRtDivMolWt,3))) 

    xz_Dens = xz_PressAll * xz_EffMolWt / (GasRDry * xz_TempAll)
    xz_VPotTempAll = xz_PotTempAll / xz_EffMolWt
    xz_VTempAll = xz_TempAll / xz_EffMolWt

    !----------------------------------------------------------------
    ! ήؿ
    !----------------------------------------------------------------
    xr_Dens = xr_avr_xz( xz_Dens )
    pz_Dens = pz_avr_xz( xz_Dens )
    pq_StrmFunc = 0.0d0
    xz_StrmFunc = 0.0d0

    do i = RegXMax, DimXMin+1, -1    
      pq_StrmFunc(i-1,:) = pq_StrmFunc(i,:) - DelX * xr_Dens(i,:) * xr_VelZ(i,:)
    end do
    do k = RegZMax, DimZMin+1, -1
      pq_StrmFunc(:,k-1) = pq_StrmFunc(:,k) + DelZ * pz_Dens(:,k) * pz_VelX(:,k)
    end do

    xz_StrmFunc = pq_StrmFunc 
    xz_StrmFunc(DimXMin+1 : DimXMax, DimZMin+1 : DimZMax) =           &
      &  (                                                            &
      &     pq_StrmFunc(DimXMin   : DimXMax-1, DimZMin   : DimZMax-1) &
      &   + pq_StrmFunc(DimXMin+1 : DimXMax,   DimZMin   : DimZMax-1) &
      &   + pq_StrmFunc(DimXMin   : DimXMax-1, DimZMin+1 : DimZMax)   &
      &   + pq_StrmFunc(DimXMin+1 : DimXMax,   DimZMin+1 : DimZMax)   &
      &   ) * 2.5d-1

    call BoundaryXCyc_xz( xz_StrmFunc )
    call BoundaryZSym_xz( xz_StrmFunc )

    where (xz_StrmFunc < 1.0d-20 .AND. xz_StrmFunc > - 1.0d-20) 
      xz_StrmFunc = 1.0d-20
    end where

    !----------------------------------------------------------------
    ! ˰¾ʿ
    !----------------------------------------------------------------
    do s = 1, CondNum
      !˰¾
      xza_MixRtSat(:,:,IdxCG(s)) =                        &
        & xz_SvapPress(SpcWetID(IdxCC(s)), xz_TempAll)    &
        &  * MolWtWet(IdxCC(s))                           &
        &  / (MolWtDry * xz_PressAll)                     

      !м
      xza_Humidity(:,:,IdxCG(s)) =                        &
        & xza_MixRtAll(:,:,IdxCG(s)) / xza_MixRtSat(:,:,IdxCG(s)) * 100.0d0
    end do
    
    !ʿ
    if ( IdxNH3 /= 0 ) then     
      xz_EqConstSat = 61.781d0 - 10834.0d0 / xz_TempAll - dlog(1.0d2)
      
      xz_EqConst =                                        &
        & dlog(                                           &
        &   ( xz_PressAll ** 2.0d0 )                      &
        &   * max( xza_MixRtAll(:,:,IdxNH3), 1.0d-20 )    &
        &   * max( xza_MixRtAll(:,:,IdxH2S), 1.0d-20 )    &
        &   * ( MolWtDry ** 2.0d0)                        &
        &   / ( MolWtWet(IdxNH3) )                        &
        &   / ( MolWtWet(IdxH2S) )                        &
        & )
    end if

    !ܾͤФƼ 100 % λκ
    !ܾʪ̤ϻѲʤ, Ȥꤢΰ֤Ƿ׻.
    do i = DimXMin, DimXMax
       Hum = 1.0d0
       call ECCM_MolFr( SpcWetMolFr(1:SpcNum), Hum, xz_TempBasicZ(i,:), &
            &              xz_PressBasicZ(i,:), za_MolFrEq )
       
       do s = 1, SpcNum
          xza_MixRtEq(i,:,s) = za_MolFrEq(:,s) * MolWtWet(s) / MolWtDry
       end do
    end do

    !----------------------------------------------------------------
    ! 
    !----------------------------------------------------------------
    ! Ǯ徺˼¸벹١ʪʬۤ. 
!    MolFrIni = SpcWetMolFr(1:SpcNum) 
!    Humidity = 1.0
!    call ECCM_Wet( MolFrIni, Humidity, z_Temp, z_Press, z_MolWtMean, za_MolFr )
    
!    xz_EqPotTempAll = xz_PotTempAll * dexp( xz_LatentHeat * xz_MixRt / (CpDry * xz_TempAll))    
!    xa_SatEqPotTempAll = xz_PotTempAll * dexp( xz_LatentHeat * xz_MixRt / (CpDry * xz_TempAll))



    !----------------------------------------------------------------
    ! 
    !----------------------------------------------------------------
    do s = 1, SpcNum
      xza_MolFrAll(:,:,s) = xza_MixRtAll(:,:,s) * MolWtDry / MolWtWet(s) 
    end do
    
    do k = DimZMin, DimZMax
      do i = DimXMin, DimXMax
        xz_MolWtWet(i,k) = dot_product( MolWtWet(1:GasNum), xza_MolFrAll(i,k,1:GasNum) )
      end do
    end do
    
    xz_StabTemp =                                           &
      &         Grav / xz_TempAll                           &
      &           * (   xz_avr_xr( xr_dz_xz( xz_TempAll ) ) &
      &               + Grav * xz_EffMolWtBasicZ / CpDry ) 
    xz_StabMolWt =                                          &
      &       - Grav * xz_avr_xr( xr_dz_xz( xz_MolWtWet ) ) &
      &         / ( MolWtDry * xz_EffMolWtBasicZ )   
    xz_Stab = xz_StabTemp + xz_StabMolWt

    where (xz_Stab < 1.0d-7) 
      xz_Stab = 1.0d-7
    end where

    !----------------------------------------------------------------    
    ! ե
    !----------------------------------------------------------------
    call AnalFile_OutPut( AnalTime )    
 end do TIMESTEP
 
    
  !----------------------------------------------------------------    
  ! եĤ
  !----------------------------------------------------------------    
  call AnalFile_Close
 
contains
  
  subroutine AnalFile_Open( )
    !
    !ϥե
    !
    use gtool_history, only: HistoryCreate, HistoryPut, HistoryAddVariable
    use fileset, only: exptitle, expsrc, expinst, HistoryFilePrefix    
    use gridset, only: FileNX, FileNZ, s_X, s_Z, &
      &                FileXMin, FileXMax, FileZMin, FileZMax, SpcNum
    use basicset, only: SpcWetSymbol
    
    !ۤηػ
    implicit none

    !ѿ
    character(150)  :: File
    integer        :: s
    
    File = trim(HistoryFilePrefix)// '_Analysis.nc'

    !-----------------------------------------------------------
    ! ҥȥ꡼
    !-----------------------------------------------------------
    call HistoryCreate(                              &
      & file = trim(File),                           &
      & title = exptitle,                            &
      & source = expsrc,                             &
      & institution = expinst,                       &
      & dims=(/'x','z','t'/),                        &
      & dimsizes=(/FileNX, FileNZ, 0/),              &
      & longnames=(/'X-coordinate',                  &
      &             'Z-coordinate',                  &
      &             'Time        '/),                &
      & units=(/'m','m','s'/), origin=0.0,           &
      & interval=0.0)

    !-----------------------------------------------------------  
    ! ν
    !-----------------------------------------------------------
    call HistoryPut('x', s_X( FileXMin: FileXMax ))
    call HistoryPut('z', s_Z( FileZMin: FileZMax ))

    !-----------------------------------------------------------  
    ! Ѥѿν
    !-----------------------------------------------------------  
    !
    call HistoryAddVariable(                          &
      & varname='TempAll', dims=(/'x','z','t'/),      &
      & longname='temperature',                       &
      & units='K', xtype='double' )

    !
    call HistoryAddVariable(                         &
      & varname='VTempAll', dims=(/'x','z','t'/),    &
      & longname='virtual temperature',              &
      & units='K', xtype='double')

    !
    call HistoryAddVariable(                         &
      & varname='PotTempAll', dims=(/'x','z','t'/),  &
      & longname='potential temperature',            &
      & units='K', xtype='double' )

    !
    call HistoryAddVariable(                         &
      & varname='VPotTempAll', dims=(/'x','z','t'/), &
      & longname='virtual potential temperature',    &
      & units='K', xtype='double')

    !
    call HistoryAddVariable(                          &
      & varname='PressAll', dims=(/'x','z','t'/),     &
      & longname='Pressure',                          &
      & units='Pa', xtype='double' )
    
    !̩
    call HistoryAddVariable(                          &
      & varname='Dens', dims=(/'x','z','t'/),         &
      & longname='Density',                           &
      & units='kg/m/m"', xtype='double' )

    !Ū
    call HistoryAddVariable(                          &
      & varname='Stab', dims=(/'x','z','t'/),         &
      & longname='Stability',                         &
      & units='1/s/s"', xtype='double' )

    !Ū
    call HistoryAddVariable(                          &
      & varname='StabTemp', dims=(/'x','z','t'/),     &
      & longname='Stability (Temp)',                  &
      & units='1/s/s"', xtype='double' )

    !Ū
    call HistoryAddVariable(                          &
      & varname='StabMolWt', dims=(/'x','z','t'/),    &
      & longname='Stability (MolWt)',                 &
      & units='1/s/s"', xtype='double' )

    ! NH4SH ΰʿ (˰)
    call HistoryAddVariable(                          &
      & varname='EqConstSat',                         &
      & dims=(/'x','z','t'/),                         &
      & longname='Saturated Equilibrium Constant',    &
      & units='1', xtype='double' )

    ! NH4SH ΰʿ 
    call HistoryAddVariable(                          &
      & varname='EqConst',                            &
      & dims=(/'x','z','t'/),                         &
      & longname='Equibrium Constant',      &
      & units='1', xtype='double' )

    !ήؿ 
    call HistoryAddVariable(                              &
      & varname='StrmFunc', dims=(/'x','z','t'/),         &
      & longname='Stream Function',                       &
      & units='kg/m/m', xtype='double')

    do s = 1, SpcNum
      !Ǯʿվ֤Ǥκ
      call HistoryAddVariable(                               &
        & varname=trim(SpcWetSymbol(s))//'_All',             &
        & dims=(/'x','z', 't'/),                             &
        & longname= trim(SpcWetSymbol(s))//' Mixing Ratio',  &
        & units='kg/kg', xtype='double')
    end do
    
    do s = 1, GasNum
      !Ǯʿվ֤Ǥκ
      call HistoryAddVariable(                                    &
        & varname=trim(SpcWetSymbol(IdxG(s)))//'_Eq',             &
        & dims=(/'x','z', 't'/),                                       &
        & longname='Equilibrium '//trim(SpcWetSymbol(IdxG(s)))//' Mixing Ratio',&
        & units='kg/kg', xtype='double' )
    end do

    do s = 1, CondNum
      !˰º
      call HistoryAddVariable(                          &
        & varname=trim(SpcWetSymbol(IdxCG(s))) // '_Sat',      &
        & dims=(/'x','z','t'/),                         &
        & longname='Saturated vapor pressure',          &
        & units='kg/kg', xtype='double')
      
      !м
      call HistoryAddVariable(                          &
        & varname=trim(SpcWetSymbol(IdxCG(s))) // '_Hum',      &
        & dims=(/'x','z','t'/),                         &
        & longname='Humidity',                          &
        & units='%', xtype='double')
    end do
    
  end subroutine AnalFile_Open


  subroutine AnalFile_Close( )
    !
    !ϥեΥ
    !
    use gtool_history, only: HistoryClose

    call HistoryClose
    
  end subroutine AnalFile_Close
  
  
  subroutine AnalFile_OutPut( Time )

    use gtool_history, only: HistoryPut
    use gridset, only: FileXMin, FileXMax, FileZMin, FileZMax

    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(in) :: Time    
 
    !----------------------------------------------------------------
    ! ͤ
    !----------------------------------------------------------------
    call HistoryPut( 't', Time )

    call HistoryPut( 'TempAll',       &
      &            xz_TempAll(FileXMin:FileXMax, FileZMin:FileZMax) )

    call HistoryPut( 'VTempAll',       &
      &            xz_VTempAll(FileXMin:FileXMax, FileZMin:FileZMax) )
    
    call HistoryPut( 'PotTempAll',    &
      &            xz_PotTempAll(FileXMin:FileXMax, FileZMin:FileZMax))
   
    call HistoryPut( 'VPotTempAll',   &
      &            xz_VPotTempAll(FileXMin:FileXMax, FileZMin:FileZMax))

    call HistoryPut( 'PressAll',      &
      &            xz_PressAll(FileXMin:FileXMax, FileZMin:FileZMax))
    
    call HistoryPut( 'Stab',          &
      &            xz_Stab(FileXMin:FileXMax, FileZMin:FileZMax))

    call HistoryPut( 'StabTemp',          &
      &            xz_StabTemp(FileXMin:FileXMax, FileZMin:FileZMax))

    call HistoryPut( 'StabMolWt',          &
      &            xz_StabMolWt(FileXMin:FileXMax, FileZMin:FileZMax))

    call HistoryPut( 'Dens',          &
      &            xz_Dens(FileXMin:FileXMax, FileZMin:FileZMax))

    call HistoryPut(  'EqConstSat',   &
      & xz_EqConstSat(FileXMin:FileXMax, FileZMin:FileZMax))

    call HistoryPut( 'EqConst',       &
      & xz_EqConst(FileXMin:FileXMax, FileZMin:FileZMax))

    call HistoryPut( 'StrmFunc',      &
      &            xz_StrmFunc(FileXMin:FileXMax, FileZMin:FileZMax))

    do s = 1, SpcNum
      call HistoryPut( trim(SpcWetSymbol(s))//'_All',  &
        &           xza_MixRtAll(FileXMin:FileXMax, FileZMin:FileZMax, s))
    end do

    do s = 1, GasNum
      call HistoryPut( trim(SpcWetSymbol(IdxG(s)))//'_Eq',  &
        &           xza_MixRtEq(FileXMin:FileXMax, FileZMin:FileZMax, IdxG(s)))
    end do

    do s = 1, CondNum
      call HistoryPut(     &
        & trim(SpcWetSymbol(IdxCG(s))) // '_Sat', &
        & xza_MixRtSat(FileXMin:FileXMax, FileZMin:FileZMax, IdxCG(s)))

      call HistoryPut(     &
        & trim(SpcWetSymbol(IdxCG(s))) // '_Hum', &
        & xza_Humidity(FileXMin:FileXMax, FileZMin:FileZMax, IdxCG(s)))
    end do

  end subroutine AnalFile_OutPut
  


!!!------------------------------------------------------------------------------!!!
  subroutine AnalFile_Get(                                      &
    &       i, AnalTime,                                        &
    &       xz_PotTemp, xz_Exner, pz_VelX, xr_VelZ, xza_MixRt )
 
    use dc_string
    use gtool_history,   only : HistoryGet
    use fileset,       only : HistoryFile
    use gridset,       only : DimXMin, DimXMax, DimZMin, DimZMax, SpcNum, &
      &                       FileXMin, FileXMax, FileZMin, FileZMax
    use basicset,      only : SpcWetSymbol
    use boundary,      only : BoundaryXCyc_xz, BoundaryZSym_xz,   &
      &                       BoundaryXCyc_xza, BoundaryZSym_xza, &
      &                       BoundaryXCyc_pz, BoundaryZSym_pz,   &
      &                       BoundaryXCyc_xr, BoundaryZAntiSym_xr

    !ۤηػ
    implicit none

    !ѿ
    integer, intent(in)  :: i    
    real(8), intent(out) :: AnalTime
    real(8), intent(out) :: pz_VelX(DimXMin:DimXMax,DimZMin:DimZMax)
    real(8), intent(out) :: xr_VelZ(DimXMin:DimXMax,DimZMin:DimZMax)
    real(8), intent(out) :: xz_Exner(DimXMin:DimXMax,DimZMin:DimZMax)
    real(8), intent(out) :: xz_PotTemp(DimXMin:DimXMax,DimZMin:DimZMax)
    real(8), intent(out) :: xza_MixRt(DimXMin:DimXMax,DimZMin:DimZMax,1:SpcNum)
    character(30)        :: name               !ѿ̾
    character(10)        :: step
    
    step = 't=^' // adjustl(toChar(i))

    !-------------------------------------------------------------
    !Get a Value from netCDF File
    !-------------------------------------------------------------
    name = "t"
    call HistoryGet( HistoryFile(1), name, AnalTime, step )

    !-------------------------------------------------------------    
    ! Get a Value from netCDF File 
    !-------------------------------------------------------------
    name = "Exner"
    call HistoryGet( HistoryFile(1), name, xz_Exner(FileXMin:FileXMax, FileZMin:FileZMax), range=step )
    call BoundaryXCyc_xz( xz_Exner )
    call BoundaryZSym_xz( xz_Exner )
    
    name = "PotTemp"
    call HistoryGet( HistoryFile(2), name, xz_PotTemp(FileXMin:FileXMax, FileZMin:FileZMax), range=step )
    call BoundaryXCyc_xz( xz_PotTemp )
    call BoundaryZSym_xz( xz_PotTemp )

    name = "VelX"
    call HistoryGet( HistoryFile(3), name, pz_VelX(FileXMin:FileXMax, FileZMin:FileZMax), range=step )    
    call BoundaryXCyc_pz( pz_VelX )
    call BoundaryZSym_pz( pz_VelX )
    
    name = "VelZ"
    call HistoryGet( HistoryFile(4), name, xr_VelZ(FileXMin:FileXMax, FileZMin:FileZMax), range=step )
    call BoundaryXCyc_xr( xr_VelZ )
    call BoundaryZAntiSym_xr( xr_VelZ )

!    name = "Km"
!    call HistoryGet( HistoryFile(5), name, xz_Km(FileXMin:FileXMax, FileZMin:FileZMax), range=step )
!    xz_Km = xz_BoundaryXCyc_xz( xz_Km )
!    xz_Km = xz_BoundaryZSym_xz( xz_Km )

    do s = 1, SpcNum
      name = trim(SpcWetSymbol(s))
      call HistoryGet( HistoryFile(8+s), name, xza_MixRt(FileXMin:FileXMax, FileZMin:FileZMax, s), range=step )
    end do

    call BoundaryXCyc_xza( xza_MixRt )
    call BoundaryZSym_xza( xza_MixRt )

  end subroutine AnalFile_Get



  subroutine AnalFile_BasicZ_Get( )

    use dc_string
    use gtool_history,   only: HistoryGet
    use fileset,       only: HistoryFile
    use basicset,      only: BasicSetArray_Init, SpcWetSymbol
    use gridset,       only: DimXMin, DimXMax, DimZMin, DimZMax, SpcNum, &
      &                      FileXMin, FileXMax, FileZMin, FileZMax
    use boundary,      only: BoundaryXCyc_xz, BoundaryZSym_xz,     &
      &                      BoundaryXCyc_xza,BoundaryZSym_xza, &
      &                      BoundaryXCyc_pz, BoundaryZSym_pz,     &
      &                      BoundaryXCyc_xr, BoundaryZAntiSym_xr

    !ۤηػ
    implicit none

    !ѿ
    real(8) :: xz_DensBZ(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8) :: xz_PotTempBZ(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8) :: xz_ExnerBZ(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8) :: xza_MixRtBZ(DimXMin:DimXMax, DimZMin:DimZMax,1:SpcNum)
    real(8) :: xz_EffMolWtBZ(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8) :: xz_PressBZ(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8) :: xz_TempBZ(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8) :: xz_VelSoundBZ(DimXMin:DimXMax, DimZMin:DimZMax)
    character(30)        :: name               !ѿ̾
    

    !-------------------------------------------------------------
    ! ܾμ
    !-------------------------------------------------------------
    name = "TempBasicZ"
    call HistoryGet( HistoryFile(7), name, xz_TempBZ(FileXMin:FileXMax, FileZMin:FileZMax) )
    call BoundaryXCyc_xz( xz_TempBZ )
    call BoundaryZSym_xz( xz_TempBZ )

    name = "PressBasicZ"
    call HistoryGet( HistoryFile(7), name, xz_PressBZ(FileXMin:FileXMax, FileZMin:FileZMax) )
    call BoundaryXCyc_xz( xz_PressBZ )
    call BoundaryZSym_xz( xz_PressBZ )

    name = "ExnerBasicZ"
    call HistoryGet( HistoryFile(7), name, xz_ExnerBZ(FileXMin:FileXMax, FileZMin:FileZMax) )
    call BoundaryXCyc_xz( xz_ExnerBZ )
    call BoundaryZSym_xz( xz_ExnerBZ )

    name = "PotTempBasicZ"
    call HistoryGet( HistoryFile(7), name, xz_PotTempBZ(FileXMin:FileXMax, FileZMin:FileZMax) )
    call BoundaryXCyc_xz( xz_PotTempBZ )
    call BoundaryZSym_xz( xz_PotTempBZ )

    name = "DensBasicZ"
    call HistoryGet( HistoryFile(7), name, xz_DensBZ(FileXMin:FileXMax, FileZMin:FileZMax) )
    call BoundaryXCyc_xz( xz_DensBZ )
    call BoundaryZSym_xz( xz_DensBZ )

    name = "VelSoundBasicZ"
    call HistoryGet( HistoryFile(7), name, xz_VelSoundBZ(FileXMin:FileXMax, FileZMin:FileZMax) )
    call BoundaryXCyc_xz( xz_VelSoundBZ )
    call BoundaryZSym_xz( xz_VelSoundBZ )

    name = "EffMolWtBasicZ"
    call HistoryGet( HistoryFile(7), name, xz_EffMolWtBZ(FileXMin:FileXMax, FileZMin:FileZMax) )
    call BoundaryXCyc_xz( xz_EffMolWtBZ )
    call BoundaryZSym_xz( xz_EffMolWtBZ )

    do s = 1, SpcNum
      name = trim(SpcWetSymbol(s))//'BasicZ'
      call HistoryGet( HistoryFile(7), name, xza_MixRtBZ(FileXMin:FileXMax, FileZMin:FileZMax, s) )
    end do

    call BoundaryXCyc_xza( xza_MixRtBZ )
    call BoundaryZSym_xza( xza_MixRtBZ )

    !----------------------------------------------------------
    ! BasicSet ⥸塼ͤ
    !----------------------------------------------------------
    call BasicSetArray_Init(                       &
      & xz_PressBZ,   xz_ExnerBZ,   xz_TempBZ,     &
      & xz_PotTempBZ, xz_DensBZ,    xz_VelSoundBZ, &
      & xza_MixRtBZ,  xz_EffMolWtBZ )

  end subroutine AnalFile_BasicZ_Get


  subroutine ArareAlloc

    use gridset,       only: DimXMin, DimXMax, DimZMin, DimZMax, SpcNum

    !ܾ, μ.
    allocate( &
      &       xz_PotTemp(DimXMin:DimXMax, DimZMin:DimZMax ),             &
      &       xz_PotTempAll(DimXMin:DimXMax, DimZMin:DimZMax ),          &
      &       xz_Exner(DimXMin:DimXMax, DimZMin:DimZMax ),               &
      &       pz_VelX(DimXMin:DimXMax, DimZMin:DimZMax ),                &
      &       xr_VelZ(DimXMin:DimXMax, DimZMin:DimZMax ),                &
      &       xza_MixRt(DimXMin:DimXMax, DimZMin:DimZMax, 1:SpcNum ),    &
      &       xza_MixRtAll(DimXMin:DimXMax, DimZMin:DimZMax, 1:SpcNum ), &
      &       xza_MixRtAll2(DimXMin:DimXMax, DimZMin:DimZMax, 1:SpcNum ), &
      &       xza_MixRtSat(DimXMin:DimXMax, DimZMin:DimZMax, 1:SpcNum ), &
      &       xza_MixRtEq(DimXMin:DimXMax, DimZMin:DimZMax, 1:SpcNum ),  &
      &       xza_Humidity(DimXMin:DimXMax, DimZMin:DimZMax, 1:SpcNum ), &
      &       za_MolFrEq(DimZMin:DimZMax, 1:SpcNum ),                    &
      &       xz_VTempAll(DimXMin:DimXMax, DimZMin:DimZMax ),            &
      &       xz_VPotTempAll(DimXMin:DimXMax, DimZMin:DimZMax ),         &
      &       xz_EqPotTempAll(DimXMin:DimXMax, DimZMin:DimZMax ),        &
      &       xz_Dens(DimXMin:DimXMax, DimZMin:DimZMax),                 &
      &       xz_TempAll(DimXMin:DimXMax, DimZMin:DimZMax ),            &
      &       xz_PressAll(DimXMin:DimXMax, DimZMin:DimZMax ),           &
      &       xz_EqConstSat(DimXMin:DimXMax, DimZMin:DimZMax ),         &
      &       xz_EqConst(DimXMin:DimXMax, DimZMin:DimZMax ),            &
      !
      &       xz_EffMolWt(DimXMin:DimXMax, DimZMin:DimZMax ),           &
      &       xza_MixRtDivMolWt(DimXMin:DimXMax,DimZMin:DimZMax,SpcNum),&
      &       xza_LatentHeat(DimXMin:DimXMax,DimZMin:DimZMax,SpcNum),   &
      !
      &       xza_MolFrAll(DimXMin:DimXMax,DimZMin:DimZMax,SpcNum), &
      &       xz_MolWtWet(DimXMin:DimXMax,DimZMin:DimZMax),   &
      &       xz_Stab(DimXMin:DimXMax,DimZMin:DimZMax),       &
      &       xz_StabTemp(DimXMin:DimXMax,DimZMin:DimZMax),   &
      &       xz_StabMolWt(DimXMin:DimXMax,DimZMin:DimZMax),  &
      !
      &       MolFrIni(SpcNum), &
      &       xz_StrmFunc(DimXMin:DimXMax, DimZMin:DimZMax ),           &
      &       pq_StrmFunc(DimXMin:DimXMax, DimZMin:DimZMax ),           &
      &       xr_Dens(DimXMin:DimXMax, DimZMin:DimZMax ),           &
      &       pz_Dens(DimXMin:DimXMax, DimZMin:DimZMax )       )

    xz_StrmFunc = 0.0d0
    xza_MixRtSat = 0.0d0
    xza_MixRtDivMolWt = 0.0d0

  end subroutine ArareAlloc

end program ArareAnal
