!= deepconv/arare 絤ή׻Ѽץ
!
!= deepconv/arare main program for moist atmospheric convection
!
! Authors::   SUGIYAMA Ko-ichiro, ODAKA Masatsugu
! Version::   $Id: arare.f90,v 1.56 2010-03-05 03:09:05 sugiyama Exp $
! Tag Name::  $Name: arare4-20100306 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!

program arare
  !
  ! ϳإǥ deepconv/arare 絤ή׻Ѽץ.
  !

  ! ⥸塼 ; use statement 
  !

  ! gtool5 Ϣ 
  ! gtool5 modules
  !
  use dc_types,      only: STRING
  use dc_string,     only: StoA
  use dc_message,    only: MessageNotify

  ! ⥸塼
  ! Initialize module
  !
  use argset,        only: argset_init  
  use fileset,       only: fileset_init, InitFile
  use debugset,      only: debugset_init
  use timeset,       only: timeset_init, DelTimeLong, DelTimeShort,  &
    &                      NstepDisp, NstepLong, NstepShort    
  use gridset,       only: gridset_init, DimXMin, DimXMax, DimZMin, DimZMax, &
    &                      SpcNum
  use basicset,      only: basicset_init, xza_MixRtBasicZ, xz_DensBasicZ, &
    &                      xz_PotTempBasicZ, xz_VelSoundBasicZ

  ! ̷׻⥸塼 
  ! Chemical calculation modules
  !
  use ChemCalc,      only: ChemCalc_init
  use chemdata,      only: chemdata_init

  ! ϳز׻Ѵؿ⥸塼
  ! Dynamical processes module
  !
  use DynFunc,       only: xz_AdvScalar, xz_AdvKm, xza_AdvScalar, &
    &                      pz_AdvVelX, xr_Buoy, xr_AdvVelZ, pz_GradPi
  use DynImpFunc,    only: xz_Exner_init, xz_Exner, xr_GradPi
  
  ! ήȻ׻ѥ⥸塼
  ! Turbulent diffusion module
  !
  use Turbulence,    only: Turbulence_Init, xz_TurbScalar, xza_TurbScalar,  &
    &                      pz_TurbVelX, xr_TurbVelZ, xz_ShearKm, xz_DispKm, &
    &                      xz_DispHeat
  
  ! Υեå׻ѥ⥸塼
  ! Surface flux module
  !
  use HeatFlux, only: &
!   &                 xz_HeatFluxBulk, xz_MixRtFluxBulk, &
    &                 xz_HeatFluxDiff,  xza_MixRtFluxDiff

  ! Ͷ׻ѥ⥸塼
  ! Radiative forceing module
  !
  use Radiation,     only: Radiation_init, xz_RadHeatConst  

  ! ׻ѥ⥸塼
  ! Moist processes modules
  !
  use moistset,      only: moistset_init
  use MoistAdjust,   only: MoistAdjustSvapPress
  use WarmRainPrm,   only: WarmRainPrm_Init, xz_Rain2GasHeat,   &
    &                      xza_Rain2Gas, xza_Cloud2Rain, xza_FallRain, FillNegative1
  use MoistBuoyancy, only: MoistBuoy_Init, xz_BuoyMoistKm, xr_BuoyMolWt, &
    &                      xr_BuoyDrag
!  use fillnegative,  only: FillNegative_init, xza_FillNegative_xza

  ! ٤η׻
  ! Static stability calculation module
  !
  use ECCM,          only: ECCM_Stab

  ! ͳȻ/໤׻ѥ⥸塼
  ! Numerical diffussion /dumping module
  !
  use NumDiffusion,  only: NumDiffusion_Init, xz_NumDiffScalar, &
    &                      xz_NumDiffKm, xza_NumDiffScalar,     &
    &                      pz_NumDiffVelX, xr_NumDiffVelZ
  use damping,       only: damping_init, DampSponge_xz, DampSponge_pz, &
    &                      DampSponge_xr

  ! ѻʹ⥸塼
  ! Monitor variables setup modules
  !
  use StorePotTemp,  only: StorePotTemp_init, StorePotTempClean, &
    &                      StorePotTempCond
  use StoreMixRt,    only: StoreMixRt_init, StoreMixRtClean, StoreMixRtCond, &
    &                      StoreMixRtFill1
  use StoreBuoy,     only: StoreBuoy_init, StoreBuoyClean
  use StoreStab,     only: StoreStab_init, StoreStabClean

  ! եϥ⥸塼
  ! File I/O module
  !
  use RestartFileIO, only: ReStartFile_Open, ReStartFile_OutPut, &
    &                      ReStartFile_Close, ReStartFile_Get
  use HistoryFileIO, only: HistoryFile_Open, HistoryFile_OutPut, &
    &                      HistoryFile_Close

  ! ⥸塼
  ! Utility modules
  !
  use cflcheck,      only: CFLCheckTimeShort, CFLCheckTimeLongVelX, &
    &                      CFLCheckTimeLongVelZ
  use timefilter,    only: AsselinFilter_xz, AsselinFilter_xr, &
    &                      AsselinFilter_pz, AsselinFilter_xza
  use boundary,      only: BoundaryXCyc_xz, BoundaryZSym_xz,  &
    &                      BoundaryXCyc_xza, BoundaryZSym_xza, BoundaryXCyc_pz,  &
    &                      BoundaryZSym_pz, BoundaryXCyc_xr, BoundaryZAntiSym_xr

  ! ѿ ; Variables definition 
  !

  implicit none

  ! ѿ
  ! Internal variables
  !
  character(80) :: cfgfile  ! NAMELIST ե̾ NAMELIST file name
  real(8), allocatable :: pz_VelXBl(:,:) 
                            ! $ u(t-\Delta t) $ ʿ Horizontal wind
  real(8), allocatable :: pz_VelXNl(:,:) 
                            ! $ u(t) $ ʿ Horizontal wind
  real(8), allocatable :: pz_VelXAl(:,:) 
                            ! $ u (t+\Delta t)a $ ʿ Horizontal wind
  real(8), allocatable :: pz_VelXNs(:,:) 
                            ! $ u (\tau) $ ʿ Horizontal wind
  real(8), allocatable :: pz_VelXAs(:,:) 
                            ! $ u (\tau +\Delta \tau) ʿ Horizontal wind
  real(8), allocatable :: xr_VelZBl(:,:) 
                            ! $ w (t-\Delta t) ľ Vertical wind
  real(8), allocatable :: xr_VelZNl(:,:) 
                            ! $ w (t) ľ Vertical wind
  real(8), allocatable :: xr_VelZAl(:,:) 
                            ! $ w (t+\Delta t) ľ Vertical wind
  real(8), allocatable :: xr_VelZNs(:,:) 
                            ! $ w (\tau) ľ Vertical wind
  real(8), allocatable :: xr_VelZAs(:,:) 
                            ! $ w (\tau +\Delta \tau) $ ľ Vertical wind
  real(8), allocatable :: xz_ExnerBl(:,:)
                            ! $ \pi (t-\Delta t) $ ϴؿ Exner function
  real(8), allocatable :: xz_ExnerNl(:,:)
                            ! $ \pi (t) $ ϴؿ Exner function
  real(8), allocatable :: xz_ExnerAl(:,:)
                            ! $ \pi (t+\Delta t) $ ϴؿ Exner function
  real(8), allocatable :: xz_ExnerNs(:,:)
                            ! $ \pi (\tau) $ ϴؿ Exner function
  real(8), allocatable :: xz_ExnerAs(:,:)
                            ! $ \pi (\tau +\Delta \tau) $ ϴؿ Exner function
  real(8), allocatable :: xz_PotTempBl(:,:) 
                            ! $ \theta (t-\Delta t) $  Potential temp.
  real(8), allocatable :: xz_PotTempNl(:,:) 
                            ! $ \theta (t) $  Potential temp.
  real(8), allocatable :: xz_PotTempAl(:,:) 
                            ! $ \theta (t+\Delta t) $  Potential temp.
  real(8), allocatable :: xz_PotTempWork(:,:)
                            ! ̤κ Work array for potential temp.
  real(8), allocatable :: xz_KmBl(:,:)
                            ! $ Km (t-\Delta t) $ ήȻ 
                            ! Turbulent diffusion coeff. 
  real(8), allocatable :: xz_KmNl(:,:)         
                            ! $ K_m (t) ήȻ 
                            ! Turbulent diffusion coeff. 
  real(8), allocatable :: xz_KmAl(:,:)
                            ! $ K_m (t+\Delta t) $ ήȻ 
                            ! Turbulent diffusion coeff. 
  real(8), allocatable :: xz_KhBl(:,:)
                            ! $ K_h (t-\Delta t) $ ήȻ 
                            ! Turbulent diffusion coeff. 
  real(8), allocatable :: xz_KhNl(:,:)
                            ! $ K_h (t) $ ήȻ 
                            ! Turbulent diffusion coeff. 
  real(8), allocatable :: xz_KhAl(:,:)
                            ! $ K_h (t+\Delta t) $ ήȻ 
                            ! Turbulent diffusion coeff.
  real(8), allocatable :: xza_MixRtBl(:,:,:)
                            ! $ q (t-\Delta t) $ ̤κ 
                            ! Mixing ratio of moist variables.
  real(8), allocatable :: xza_MixRtNl(:,:,:) 
                            ! $ q (t) $ ̤κ 
                            ! Mixing ratio of moist variables.
  real(8), allocatable :: xza_MixRtAl(:,:,:)
                            ! $ q (t+\Delta t) $ ̤κ 
                            ! Mixing ratio of moist variables.
  real(8), allocatable :: xza_MixRtWork(:,:,:) 
                            ! ̤κ
                            ! Work array for mixing ratio.
  real(8), allocatable :: pz_AccelVelXNl(:,:)  
                            ! Ϥ $u$ ѲΨ
                            ! Tendency of $u$ except for pressure gradient term
  real(8), allocatable :: xr_AccelVelZNl(:,:)  
                            ! Ϥ $w$ ѲΨ
                            ! Tendency of $w$ except for pressure gradient term
  real(8), allocatable :: xza_DelMixRt(:,:,:)  
                            ! ̤κ $ q $ ʬ
                            ! Mixing ratio variation.
  real(8) :: Time           !  Time 
  real(8) :: ReStartTime(2) ! ꥹȥեϻ
                            ! Output time array for restart file
  real(8), allocatable :: DelTimeLFrog(:)
                            ! ꡼ץեåѻֳʻҴֳ
                            ! Time interval for Leap-frog scheme
  real(8) :: DelTimeEular   ! 顼ѻֳʻ
                            ! Time interval for Eular scheme
  integer :: NStepLFrog     ! ꡼ץեåѻ֥ƥå׿
                            ! The number of time step for Leap-frog scheme
  integer, allocatable :: NStepEular(:)
                            ! 顼ѻ֥ƥå׿
                            ! The number of time step for Eular scheme

  integer :: & 
    & t,     & 
    & tau,   & ! do 롼ѿ ; do loop variable  
    & t1,    & ! do 롼ѿ ; do loop variable  
    & t2       ! do 롼ѿ ; do loop variable 


  ! ³ Initialize procedure 
  !

  ! NAMELIST ե̾ɤ߹
  ! Loading NAMELIST file.
  !
  call argset_init( &
    & cfgfile       & ! (out) 
    & )

  ! ǥХåν
  ! Initialization of debug output control.
  !
  call debugset_init( &
    & cfgfile         & ! (in)
    & )

  ! ν
  ! Initialization of chemical constatns.
  !
  call chemdata_init( )

  ! ʬν
  ! Initialization of time integration.
  !
  call timeset_init( &
    & cfgfile        & ! (in)
    & )
    
  ! ʻν
  ! Initialization of grid arrangement.
  !
  call gridset_init( &
    & cfgfile        & ! (in)
    & )

  ! ط׻롼ν
  ! Initialization of chemical routines.
  !
  call chemcalc_init()
  
  ! ܾѿν
  ! Initialization of basic state variables.
  !
  call basicset_init( &
    & cfgfile         & ! (in)
    & )
  
  ! I/O ե̾ν
  ! Initialization of output file name. 
  !
  call fileset_init( &
    & cfgfile        & ! (in)
    & )

  ! ͭѿν
  ! Initialization of common variables for moist process.
  !
  call moistset_init( )
  
  ! ѻݴѿν
  ! Initialization of monitor variables.
  !
  call StorePotTemp_init( )
  call StoreMixRt_init( )
  call StoreBuoy_init( )  
  call StoreStab_init( )  

  ! ѿν
  ! Initialization of internal variables.
  !
  call ArareAlloc

  ! ͤ 
  ! * ReStartFile ꤵƤˤϥեɤ߹. 
  !   ꤵƤʤˤϥǥեȤδܾȾ. 
  !
  ! Initial value set up.
  ! * Read restartfile if it is specified. If not, make default basic
  !   state and disturbance.
  !
  call MessageNotify( "M", "main", "Initial value setup." )

  if (trim(InitFile) /= '') then    

    call MessageNotify( &
      & "M", "main", "Restart file is %c", c1=trim(Initfile) )

    call ReStartFile_Get( &
      & ReStartTime,      & ! (out)
      & xz_PotTempBl,     & ! (out)
      & xz_ExnerBl,       & ! (out)
      & pz_VelXBl,        & ! (out)
      & xr_VelZBl,        & ! (out)
      & xza_MixRtBl,      & ! (out)
      & xz_KmBl,          & ! (out)
      & xz_KhBl,          & ! (out)
      & xz_PotTempNl,     & ! (out)
      & xz_ExnerNl,       & ! (out)
      & pz_VelXNl,        & ! (out)
      & xr_VelZNl,        & ! (out)
      & xza_MixRtNl,      & ! (out)
      & xz_KmNl,          & ! (out)
      & xz_KhNl           & ! (out)
      & )
  else

    call MessageNotify( &
      & "W", "main", "Restart file is not specified." )

    call BasicEnv( )
    call DisturbEnv(  &
      & cfgfile,      & ! (out)
      & xz_PotTempBl, & ! (out)
      & xz_ExnerBl,   & ! (out)
      & pz_VelXBl,    & ! (out)
      & xr_VelZBl,    & ! (out)
      & xza_MixRtBl,  & ! (out)
      & xz_KmBl,      & ! (out)
      & xz_KhBl       & ! (out)
      & )
   
    call BoundaryXCyc_pz( pz_VelXBl )     ! (inout)
    call BoundaryZSym_pz( pz_VelXBl )     ! (inout)

    call BoundaryXCyc_xr( xr_VelZBl )     ! (inout)
    call BoundaryZAntiSym_xr( xr_VelZBl ) ! (inout)

    call BoundaryXCyc_xz( xz_PotTempBl )  ! (inout)
    call BoundaryZSym_xz( xz_PotTempBl )  ! (inout)

    call BoundaryXCyc_xza( xza_MixRtBl )  ! (inout)
    call BoundaryZSym_xza( xza_MixRtBl )  ! (inout)

    
    !  $ t $ ѿͤνͤ
    ! * 1 롼ܤ $ t $ ͤ $ t-\Delta t$ ͤƱˤ. 
    !   1 ƥåܤϥ顼ˡǲɬפ뤬, 1 ƥåܤ
    !   ʳΥƥåפ̡˥ǥ󥰤ʤ
    !
    ! Set up initial value of time = "t" variables.
    !  
    xz_PotTempNl = xz_PotTempBl
    xz_ExnerNl   = xz_ExnerBl
    pz_VelXNl    = pz_VelXBl
    xr_VelZNl    = xr_VelZBl
    xza_MixRtNl  = xza_MixRtBl
    xz_KmNl      = xz_KmBl
    xz_KhNl      = xz_KhBl

  end if

  ! ໤ν
  ! Initialization of numerical friction coefficient.
  !
  call Damping_Init( &
    & cfgfile        & ! (in)
    & )      
  
  ! ͳȻν
  ! Initialization of numerical diffusion term.
  !
  call NumDiffusion_Init( )          

  ! ήȻν
  ! Initialization of turbulent diffusion term.
  !
  call Turbulence_Init( )            

  ! ȤΥѥ᥿ꥼν 
  ! Initialization of warmrain parameterization.
  !
  call WarmRainPrm_Init( &
    & cfgfile            & ! (in)
    & )  

  ! Ͷν
  !  Initialization of radiative forcing.
  !
  call Radiation_Init( &
    & cfgfile          & ! (in)    
    & )

  ! ᵤϷ׻ν
  ! Initialization of moist buoyancy calculation.
  !
  call MoistBuoy_Init( ) 

  ! Ϸ׻ѷν 
  ! Initialization of coefficient matrix for exner function calculation.
  !
  call xz_Exner_Init( )              
       
  ! ȥ롼ײν
  ! Initialization of time integration.
  !
  NstepLFrog   = NstepLong 
  NstepEular   = NstepShort 
  DelTimeLFrog = DelTimeLong * 2.0d0 
  DelTimeEular = DelTimeShort

  ! ׻ϻȻֳʻҴֳ֤ν
  ! * ReStartFile ꤵƤ, ե뤫ɤ߹ͤ.
  ! * ReStartFile ꤵƤʤ
  !   * ϻ 0.0
  !   * 1 ƥåܤλֳʻҴֳ֤ۤ˻
  !
  ! Setup restart time and time interval. 
  ! * Read restartfile if it is specified.
  ! * If not, 
  !   * "t" is set to be 0.
  !   * Time intervals for 1st step are specified explicitly.
  !
  if ( trim(InitFile) /= '') then    
    Time = ReStartTime(2)               
  else
    Time = 0.0d0                    
    NstepEular(1)   = NstepShort /2 
    DelTimeLFrog(1) = DelTimeLong   
  end if

  ! ҥȥ꡼եؤν
  ! Out put to history file.
  !
  call HistoryFile_Open( )

  if ( trim(InitFile) /= '') then    
    call HistoryFile_Output( &
      & ReStartTime(2),      & ! (in)
      & xz_PotTempNl,        & ! (in)
      & xz_ExnerNl,          & ! (in)
      & pz_VelXNl,           & ! (in)
      & xr_VelZNl,           & ! (in)
      & xza_MixRtNl,         & ! (in)
      & xz_KmNl,             & ! (in)
      & xz_KhNl              & ! (in)
      & )
  end if

  if ( Time == 0 ) then
    call HistoryFile_Output( & ! (in)
      & Time,                & ! (in)
      & xz_PotTempNl,        & ! (in)
      & xz_ExnerNl,          & ! (in)
      & pz_VelXNl,           & ! (in)
      & xr_VelZNl,           & ! (in)
      & xza_MixRtNl,         & ! (in)
      & xz_KmNl,             & ! (in)
      & xz_KhNl              & ! (in)
      & )
  end if
  
  ! ȤФ CFL Υå
  ! CFL condtion check for sound wave.
  !
  call CFLCheckTimeShort( &
    & xz_VelSoundBasicZ   & ! (in)
    & )


  ! ʬ time integration 
  !
  do t1 = 1, NstepLFrog / NstepDisp
    do t2 = 1, NstepDisp

      !  
      ! Time setting.
      !
      Time = Time + DelTimeLong
      t = (t1 - 1) * NstepDisp + t2

      ! ȻΰήȻ
      ! Advection and diffusion of turbulent diffusion coefficient.
      !
      xz_KmAl =                                                       &
        & xz_KmBl                                                     &
        & + DelTimeLFrog(t)                                           &
        &   * (                                                       &
        &     + xz_AdvKm(xz_KmNl, pz_VelXNl, xr_VelZNl)               &
        &     + xz_BuoyMoistKm(xz_PotTempBl, xz_ExnerBl, xza_MixRtBl) &
        &     + xz_ShearKm(xz_KmBl, pz_VelXBl, xr_VelZBl)             &   
        &     + xz_NumDiffKm(xz_KmBl)                                 &
        &     + xz_DispKm(xz_KmBl)                                    &
        &    )
      
      ! ͤξ²¤
      ! * ͤˤʤ뤳Ȥݾڤ
      ! * ͤξ¤ 800 Ȥ. (1994, ذʸ)
      !
      ! Upper and lower bound value are specified.
      !
      xz_KmAl = max( 0.0d0, min( xz_KmAl, 800.0d0 ) )
      

      !  Boundary condition
      !
      call BoundaryXCyc_xz( xz_KmAl )  ! (inout)
      call BoundaryZSym_xz( xz_KmAl )  ! (inout)

      ! 顼Ф뱲Ȼη׻ 
      ! Specify turbulent diffusion coefficient for scalar variables.
      !
      xz_KhAl = 3.0d0 * xz_KmAl
      
      ! ̤ΰήȻη׻ 
      ! Advection and diffusion of potential temperature.
      !
      xz_PotTempAl =                                                  &
        &   xz_PotTempBl                                              &
        & + DelTimeLFrog(t)                                           &
        &   * (                                                       &
        &     + xz_AdvScalar( xz_PotTempNl,     pz_VelXNl, xr_VelZNl) &
        &     + xz_AdvScalar( xz_PotTempBasicZ, pz_VelXNl, xr_VelZNl) &
        &     + xz_TurbScalar(xz_PotTempBl,     xz_KhBl)              &
        &     + xz_TurbScalar(xz_PotTempBasicZ, xz_KhBl)              &
        &     + xz_NumDiffScalar(xz_PotTempBl)                        &
        &     + xz_DispHeat( xz_KmBl )                                &
!        &     + xz_RadHeatConst( xz_ExnerBl )                         &
!        &     + xz_HeatFluxDiff( xz_PotTempNl )                       &
!!      &     + xz_HeatFluxBulk( xz_PotTempNl )                     &
!!      &     + xz_NewtonCool( xz_PotTempBl )                       &
        &      )

      !  Boundary condition
      !
      call BoundaryXCyc_xz( xz_PotTempAl ) ! (inout)
      call BoundaryZSym_xz( xz_PotTempAl ) ! (inout)
      
      ! ŽʬΰήȻ 
      ! Advection and diffusion of vapor, cloud and rain mixing ratios.
      !
      xza_MixRtAl =                                                & 
        &   xza_MixRtBl                                            &
        & + DelTimeLFrog(t)                                        &
        &   * (                                                    &
        &    + xza_AdvScalar(xza_MixRtNl,     pz_VelXNl, xr_VelZNl)&
        &    + xza_AdvScalar(xza_MixRtBasicZ, pz_VelXNl, xr_VelZNl)& 
        &    + xza_TurbScalar(xza_MixRtBl,    xz_KhBl)             &
        &    + xza_TurbScalar(xza_MixRtBasicZ,xz_KhBl)             &
        &    + xza_NumDiffScalar(xza_MixRtBl)                      &
        &    + xza_FallRain(xza_MixRtBl)                           &
        &    + xza_MixRtFluxDiff(xza_MixRtNl)                      &
!!      &    + xza_MixRtFluxBulk(xza_MixRtNl)                      &
        &   )

      !  Boundary condition
      !
      call BoundaryXCyc_xza( xza_MixRtAl ) ! (inout)
      call BoundaryZSym_xza( xza_MixRtAl ) ! (inout)

      ! ήˤäˤʤäʬ
      ! Negative values due to advection are corrected.
      !
      xza_MixRtWork = xza_MixRtAl
      call FillNegative1(xz_ExnerAl, xz_PotTempAl, xza_MixRtAl) 
      
      ! ᤿/ä̤ݴ
      ! Correction value is stored.
      !
      call StoreMixRtFill1( &
        & (xza_MixRtAl - xza_MixRtWork) / DelTimeLFrog(t) & ! (in)
        & )    
      
      !  Boundary condition
      !
      call BoundaryXCyc_xza( xza_MixRtAl ) ! (inout)
      call BoundaryZSym_xza( xza_MixRtAl ) ! (inout)

      ! ȤΥѥ᥿ꥼ.
      ! * <--> ѴԤ.
      !
      ! Warm rain parameterization.
      ! * Conversion from cloud to rain.

      ! ޤǤͤݴ
      ! Previous values are stored to work area.
      !
      xza_MixRtWork = xza_MixRtAl
      
      ! ؤѲ̤׻
      ! Conversion values are calculated.
      !
      xza_MixRtAl = &
        & xza_MixRtWork + xza_Cloud2Rain( xza_MixRtAl, DelTimeLFrog(t) )
      
      ! 鱫ؤѴ̤ݴ
      ! Conversion values are sotred.
      !
      call StoreMixRtCond( &
        & (xza_MixRtAl - xza_MixRtWork) / DelTimeLFrog(t) & ! (in)
        & )
      
      !  Boundary condition
      !
      call BoundaryXCyc_xza( xza_MixRtAl ) ! (inout)
      call BoundaryZSym_xza( xza_MixRtAl ) ! (inout)
      
      ! ˰Ĵ
      ! * <-->ѴԤ.
      !
      ! Moist adjustment.
      ! * Conversion from vapor to cloud.

      ! ޤǤͤݴ
      ! Previous values are stored to work area.
      !
      xz_PotTempWork = xz_PotTempAl
      xza_MixRtWork  = xza_MixRtAl
      
      ! ĴˡŬ
      ! Moist adjustment is applied.
      !
      call MoistAdjustSvapPress( &
        & xz_ExnerNl,            & ! (in)
        & xz_PotTempAl,          & ! (inout)
        & xza_MixRtAl            & ! (inout)
        & )
      
      ! Ĵˡˤ벹̤ȺѲ̤ݴ
      ! Adjustment values are stored.
      !
      call StorePotTempCond( &
        & (xz_PotTempAl - xz_PotTempWork) / DelTimeLFrog(t)  & ! (in)
        & )
      call StoreMixRtCond( &
        & (xza_MixRtAl - xza_MixRtWork) / DelTimeLFrog(t) & ! (in)
        & )
      
      !  Boundary condition
      !
      call BoundaryXCyc_xza( xza_MixRtAl ) ! (inout)
      call BoundaryZSym_xza( xza_MixRtAl ) ! (inout)

      ! ȤΥѥ᥿ꥼ.
      ! * <--> ѴԤ
      !
      ! Warm rain parameterization.
      ! * Conversion from rain to vapor.

      ! ޤǤͤݴ
      ! Previous values are stored to work area.
      !
      xz_PotTempWork = xz_PotTempAl
      xza_MixRtWork = xza_MixRtAl
      
      ! ؤκѲ
      ! * ̤η׻ˤ, ѲɬפȤʤ뤿, 
      !   Ѳ 1 ĤȤѰդ.
      !
      ! Conversion values are calculated.
      !
      xza_DelMixRt = 0.0d0
      xza_DelMixRt =                                                   &
        & (                                                            &
        &   + xza_Rain2Gas(                                            &
        &       xz_ExnerNl, xz_PotTempAl, xza_MixRtAl, DelTimeLFrog(t) &
        &       )                                                      &
        &  )    
      
      ! ̤η׻. ؤѴȼǮȿǮɲ.
      !
      !
      xz_PotTempAl =                                                    &   
        & xz_PotTempWork                                                &
        & + (                                                           &
        &     xz_Rain2GasHeat( xz_PotTempAl, xz_ExnerNl, xza_DelMixRt ) & 
        &    )
      
      ! η׻. ؤѴʬɲ
      !
      !
      xza_MixRtAl   = xza_MixRtWork + xza_DelMixRt
      
      ! ͤݴ
      !
      !
      call StorePotTempCond( &
        & (xz_PotTempAl - xz_PotTempWork) / DelTimeLFrog(t) & ! (in)
        & ) 
      call StoreMixRtCond( &
        & xza_DelMixRt / DelTimeLFrog(t) & ! (in)
        & ) 
 
      !  Boundary condition
      !
      call BoundaryXCyc_xz( xz_PotTempAl ) ! (inout)
      call BoundaryZSym_xz( xz_PotTempAl ) ! (inout)
      call BoundaryXCyc_xza( xza_MixRtAl ) ! (inout)
      call BoundaryZSym_xza( xza_MixRtAl ) ! (inout)
      
      ! ®٤ΰήȻ.
      ! Advection and diffusion of velocity components.
      !
      pz_AccelVelXNl =                                    &
        & + pz_AdvVelX(pz_VelXNl, xr_VelZNl)              &
        & + pz_TurbVelX(xz_KmBl,   pz_VelXBl, xr_VelZBl)  &
        & + pz_NumDiffVelX(pz_VelXBl)

     
      xr_AccelVelZNl =                                    &
        & + xr_AdvVelZ(xr_VelZNl, pz_VelXNl)              &
        & + xr_Buoy(xz_PotTempNl)                         &    
        & + xr_BuoyMolWt(xza_MixRtNl)                     &
        & + xr_BuoyDrag(xza_MixRtNl)                      &
        & + xr_TurbVelZ(xz_KmBl,   pz_VelXBl, xr_VelZBl)  &
        & + xr_NumDiffVelZ(xr_VelZBl)                        


      ! û֥ƥåפνͺ.
      ! Initial values set up for time integration with short time step.
      !
      pz_VelXNs  = pz_VelXBl
      xr_VelZNs  = xr_VelZBl
      xz_ExnerNs = xz_ExnerBl
      
      ! û֥ƥåפλʬ. 顼ˡ.
      ! Time integration with short time step.
      !
      Eular: do tau = 1, NstepEular(t)
        
        ! ® u η׻.
        ! Time integration horizontal velocity (u).
        !
        pz_VelXAs = &
          & pz_VelXNs                                          &
          &  + DelTimeEular                                    &
          &    * (                                             &
          &     - pz_GradPi(xz_ExnerNs, pz_VelXNs, xr_VelZNs)  &
          &     + pz_AccelVelXNl                               &
          &     )
        
        !  Boundary condition
        !
        call BoundaryXCyc_pz( pz_VelXAs ) ! (inout)
        call BoundaryZSym_pz( pz_VelXAs ) ! (inout)
        
        ! ʡؿη׻.
        ! Time integration exner function.
        !
        xz_ExnerAs = xz_Exner( &
          & xr_AccelVelZNl,    &
          & pz_VelXNs,         &
          & pz_VelXAs,         &
          & xr_VelZNs,         &
          & xz_ExnerNs)
        
        !  Boundary condition
        !
        call BoundaryXCyc_xz( xz_ExnerAs ) ! (inout)
        call BoundaryZSym_xz( xz_ExnerAs ) ! (inout)
        
        ! ® w η׻
        ! Time integration vertical velocity.
        !
        xr_VelZAs =                                                    &
          & xr_VelZNs                                                  &
          &  + DelTimeEular                                            &
          &    * (                                                     &
          &     - xr_GradPi(xz_ExnerAs,xz_ExnerNs,pz_VelXNs,xr_VelZNs) &
          &     + xr_AccelVelZNl                                       &
          &     )
        
        !  Boundary condition
        !
        call BoundaryXCyc_xr( xr_VelZAs ) ! (iuout)
        call BoundaryZAntiSym_xr( xr_VelZAs ) ! (inout)
        
        ! û֥ƥåפΥ롼פ󤹤ν
        ! Renew prognostic variables for next short time step integration.
        !
        xz_ExnerNs  = xz_ExnerAs
        pz_VelXNs   = pz_VelXAs
        xr_VelZNs   = xr_VelZAs
        
      end do Eular
      
      ! ǽŪû֥ƥåפǤͤĹ֥ƥåפǤͤȤߤʤ
      ! Renew prognostic variables for next long time step integration.
      !
      xz_ExnerAl  = xz_ExnerAs
      pz_VelXAl   = pz_VelXAs
      xr_VelZAl   = xr_VelZAs
      
      ! ֥ե륿. 
      ! Time filter. 
      !
      call AsselinFilter_xz( &
        &  xz_ExnerAl,       & ! (in)
        &  xz_ExnerNl,       & ! (inout)
        &  xz_ExnerBl        & ! (in)
        & )         
      call AsselinFilter_pz( &
        & pz_VelXAl,         & ! (in)
        & pz_VelXNl,         & ! (inout)
        & pz_VelXBl          & ! (in)
        & )
      call AsselinFilter_xr( &
        & xr_VelZAl,         & ! (in)
        & xr_VelZNl,         & ! (inout)
        & xr_VelZBl          & ! (in)
        & )
      call AsselinFilter_xz( &
        & xz_PotTempAl,      & ! (in)
        & xz_PotTempNl,      & ! (inout)
        & xz_PotTempBl       & ! (in)
        & )
      call AsselinFilter_xz( &
        & xz_KmAl,           & ! (in)
        & xz_KmNl,           & ! (inout)
        & xz_KmBl            & ! (in)
        & )
      call AsselinFilter_xza( &
        & xza_MixRtAl,        & ! (in)
        & xza_MixRtNl,        & ! (inout)
        & xza_MixRtBl         & ! (in)
        & )
    
      ! ݥ.
      ! Numerical dumping.
      !
      call DampSponge_pz( &
        & pz_VelXAl,      & ! (inout)
        & pz_VelXBl,      & ! (inout)
        & DelTimeLFrog(t) & ! (in)
        & )
      call DampSponge_xr( &
        & xr_VelZAl,      & ! (inout)
        & xr_VelZBl,      & ! (inout)
        & DelTimeLFrog(t) & ! (in)
        & )

      ! ٤η׻.
      ! Calculation static stability.
      !
      call ECCM_Stab(   & 
        & xz_PotTempAl, & ! (in)
        & xz_ExnerAl,   & ! (in)
        & xza_MixRtAl   & ! (in)
        & )
      
      ! Ĺ֥ƥåפΥ롼פ󤹤ν.
      ! Renew prognostic variables for next long time step integration.
      !
      xz_PotTempBl = xz_PotTempNl
      xza_MixRtBl  = xza_MixRtNl
      xz_ExnerBl   = xz_ExnerNl
      pz_VelXBl    = pz_VelXNl
      xr_VelZBl    = xr_VelZNl
      xz_KmBl      = xz_KmNl
      xz_KhBl      = xz_KhNl
      
      xz_PotTempNl = xz_PotTempAl
      xza_MixRtNl  = xza_MixRtAl
      xz_ExnerNl   = xz_ExnerAl
      pz_VelXNl    = pz_VelXAl
      xr_VelZNl    = xr_VelZAl
      xz_KmNl      = xz_KmAl
      xz_KhNl      = xz_KhAl
      
    end do
    
    ! ҥȥ꡼եؤν.
    ! Out put to history file.
    !
    call MessageNotify( "M", "main", "Time = %f", d=(/Time/) )

    ! ήФ CFL Υå 
    ! CFL condtion check for advection
    !
    call CFLCheckTimeLongVelX( &
      & pz_VelXNl              & ! (in)
      & )
    call CFLCheckTimeLongVelZ( &
      & xr_VelZNl              & ! (in)
      & )
    
    ! ҥȥե.
    ! Out put to history file.
    !
    call HistoryFile_Output( &
      & Time,                & ! (in)
      & xz_PotTempNl,        & ! (in) 
      & xz_ExnerNl,          & ! (in)
      & pz_VelXNl,           & ! (in)
      & xr_VelZNl,           & ! (in)
      & xza_MixRtNl,         & ! (in)
      & xz_KmNl,             & ! (in)
      & xz_KhNl              & ! (in)
      & )
    
    ! ѻͤΥꥢ.
    ! Clear monitor variables.
    !
    call StorePotTempClean
    call StoreMixRtClean
    call StoreBuoyClean
    call StoreStabClean
    
  end do
  
  ! ϥեΥ
  ! Close out put files.
  !
  call HistoryFile_Close

  ! ꥹȥեκ
  ! Make restartfile.
  !
  call ReStartFile_Open( )
  call ReStartFile_OutPut( &
    & Time - DelTimeLong,  & ! (in)
    & xz_PotTempBl,        & ! (in)
    & xz_ExnerBl,          & ! (in)
    & pz_VelXBl,           & ! (in)
    & xr_VelZBl,           & ! (in)
    & xza_MixRtBl,         & ! (in)
    & xz_KmBl,             & ! (in)
    & xz_KhBl              & ! (in)
    & )
  call ReStartFile_OutPut(                            &
    & Time,                                           &
    & xz_PotTempNl,        & ! (in)
    & xz_ExnerNl,          & ! (in)
    & pz_VelXNl,           & ! (in)
    & xr_VelZNl,           & ! (in)
    & xza_MixRtNl,         & ! (in)
    & xz_KmNl,             & ! (in)
    & xz_KhNl              & ! (in)
    & )
  call ReStartFile_Close
  
contains
!-----------------------------------------------------------------------
  subroutine ArareAlloc
    !
    !Ȥ, , ͤȤƥ.
    !

    !ۤηػ
    implicit none

    !
    allocate(                                                  &
      & pz_VelXBl(DimXMin:DimXMax, DimZMin:DimZMax),           &
      & pz_VelXNl(DimXMin:DimXMax, DimZMin:DimZMax),           &
      & pz_VelXAl(DimXMin:DimXMax, DimZMin:DimZMax),           &
      & pz_VelXNs(DimXMin:DimXMax, DimZMin:DimZMax),           &
      & pz_VelXAs(DimXMin:DimXMax, DimZMin:DimZMax),           &
!
      & xr_VelZBl(DimXMin:DimXMax, DimZMin:DimZMax),           &
      & xr_VelZNl(DimXMin:DimXMax, DimZMin:DimZMax),           &
      & xr_VelZAl(DimXMin:DimXMax, DimZMin:DimZMax),           &
      & xr_VelZNs(DimXMin:DimXMax, DimZMin:DimZMax),           &
      & xr_VelZAs(DimXMin:DimXMax, DimZMin:DimZMax),           &
!
      & xz_ExnerBl(DimXMin:DimXMax, DimZMin:DimZMax),          &
      & xz_ExnerNl(DimXMin:DimXMax, DimZMin:DimZMax),          &
      & xz_ExnerAl(DimXMin:DimXMax, DimZMin:DimZMax),          &
      & xz_ExnerNs(DimXMin:DimXMax, DimZMin:DimZMax),          &
      & xz_ExnerAs(DimXMin:DimXMax, DimZMin:DimZMax),          &
!
      & xz_PotTempWork(DimXMin:DimXMax, DimZMin:DimZMax),      &
      & xz_PotTempBl(DimXMin:DimXMax, DimZMin:DimZMax),        &
      & xz_PotTempNl(DimXMin:DimXMax, DimZMin:DimZMax),        &
      & xz_PotTempAl(DimXMin:DimXMax, DimZMin:DimZMax),        &
!
      & xz_KmBl(DimXMin:DimXMax, DimZMin:DimZMax),             &
      & xz_KmNl(DimXMin:DimXMax, DimZMin:DimZMax),             &
      & xz_KmAl(DimXMin:DimXMax, DimZMin:DimZMax),             &
!
      & xz_KhBl(DimXMin:DimXMax, DimZMin:DimZMax),             &
      & xz_KhNl(DimXMin:DimXMax, DimZMin:DimZMax),             &
      & xz_KhAl(DimXMin:DimXMax, DimZMin:DimZMax),             &
!
      & xza_MixRtWork(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum), &
      & xza_MixRtBl(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum),   &
      & xza_MixRtNl(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum),   &
      & xza_MixRtAl(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum),   &
!
      & pz_AccelVelXNl(DimXMin:DimXMax, DimZMin:DimZMax),        &
      & xr_AccelVelZNl(DimXMin:DimXMax, DimZMin:DimZMax),        & 
!
      & xza_DelMixRt(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum),  &
!
      & DelTimeLFrog(NstepLong), NStepEular(NStepLong)         &
      & ) 

    pz_VelXNs = 0.0d0;     pz_VelXAs = 0.0d0    
    xr_VelZNs = 0.0d0;     xr_VelZAs = 0.0d0
    xz_ExnerNs = 0.0d0;    xz_ExnerAs = 0.0d0

    pz_VelXBl = 0.0d0;     pz_VelXNl = 0.0d0;     pz_VelXAl = 0.0d0
    xr_VelZBl = 0.0d0;     xr_VelZNl = 0.0d0;     xr_VelZAl = 0.0d0
    xz_ExnerBl = 0.0d0;    xz_ExnerNl = 0.0d0;    xz_ExnerAl = 0.0d0
    xz_KmBl = 0.0d0;       xz_KmNl = 0.0d0;       xz_KmAl = 0.0d0
    xz_KhBl = 0.0d0;       xz_KhNl = 0.0d0;       xz_KhAl = 0.0d0
    xz_PotTempBl = 0.0d0;  xz_PotTempNl = 0.0d0;  xz_PotTempAl = 0.0d0
    xza_MixRtBl = 0.0d0;    xza_MixRtNl = 0.0d0;    xza_MixRtAl = 0.0d0

    pz_AccelVelXNl = 0.0d0
    xr_AccelVelZNl = 0.0d0

    xza_DelMixRt = 0.0d0

    DelTimeEular = 0.0d0
    DelTimeLFrog = 0.0d0; 
    NStepEular = 0.0d0
    NstepLFrog = 0.0d0
    
  end subroutine ArareAlloc
!-----------------------------------------------------------------------
end program arare
