!= Module MoistBuoyancy
!
! Authors::   SUGIYAMA Ko-ichiro
! Version::   $Id: moistbuoyancy.f90,v 1.17 2007-08-24 07:41:16 sugiyama Exp $
! Tag Name::  $Name: arare4-20100306 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview
!
!
!== Error Handling
!
!== Bugs
!
!== Note
!
!
!== Future Plans
!
!

module MoistBuoyancy
  !
  !
  !

  !⥸塼ɤ߹ 
  use dc_message, only: MessageNotify

  use gridset, only:  SpcNum,            &! ؼο
    &                 DimXMin,           &! x β
    &                 DimXMax,           &! x ξ
    &                 DimZMin,           &! z β
    &                 DimZMax,           &! z ξ
    &                 DelX,              &! x γʻֳ
    &                 DelZ                ! z γʻֳ
  use basicset, only: MolWtDry,          &!ʬʬ
    &                 Grav,              &!ϲ®
    &                 SpcWetID,          &!ŽʬID
    &                 MolWtWet,          &!Žʬʬ
    &                 CpDry,             &!ʬʿ갵Ǯ [J/K kg]
    &                 xz_PotTempBasicZ,  &!ܾβ
    &                 xz_EffMolWtBasicZ, &!ܾʬ̸
    &                 xz_ExnerBasicZ,    &!̵ܾ
    &                 xza_MixRtBasicZ     !ܾκ
  use moistset, only: CondNum,          &!ŷο
    &                 IdxCG,            &!ŷ()ź
    &                 IdxCC,            &!ŷ()ź
    &                 GasNum,           &!Το
    &                 IdxG,             &!Τź
    &                 IdxNH3,           &!NH3()ź
    &                 IdxH2S             !H2S()ź
  use ChemCalc, only: xz_LatentHeat,    &!Ǯ
    &                 ReactHeatNH4SH     !NH4SH ȿǮ
  use average,  only: xr_avr_xz, xz_avr_xr
  use differentiate_center2, only: xr_dz_xz
  use StoreBuoy,    only: StoreBuoyMolWt, StoreBuoyDrag

  !ۤηػ
  implicit none
  
  !°λ
  private
  
  !ؿ public 
  public MoistBuoy_Init
  public xz_BuoyMoistKm
  public xr_BuoyMolWt
  public xr_BuoyDrag

  !ѿ
  real(8)     :: Cm           = 2.0d-1
  real(8)     :: MixLen       = 0.0d0
  real(8), allocatable :: xz_MixRtBasicZPerMolWt(:,:)
                              !ܾκ / ʬ 
  real(8), allocatable :: xr_MixRtBasicZPerMolWt(:,:)
                              !ܾκ / ʬ 
  real(8), allocatable :: xz_MixRtBasicZ(:,:)
                              !ܾκ
  real(8), allocatable :: xr_MixRtBasicZ(:,:)
                              !ܾκ
  
  save Cm, MixLen
  save xz_MixRtBasicZPerMolWt
  save xr_MixRtBasicZPerMolWt
  save xz_MixRtBasicZ
  save xr_MixRtBasicZ 

contains

!!!------------------------------------------------------------------!!!
  subroutine MoistBuoy_Init( )

    !ۤηػ
    implicit none

    !ѿ
    integer              :: s
    real(8), allocatable :: xza_MixRtBasicZPerMolWt(:,:,:)
                                  !ܾκ / ʬ

    !-----------------------------------------------------------
    ! Υ
    !-----------------------------------------------------------
    MixLen = sqrt(DelX * DelZ) 
    

    !-----------------------------------------------------------
    ! ν. 
    !-----------------------------------------------------------
    allocate( &
      & xza_MixRtBasicZPerMolWt(DimXMin:DimXMax, DimZMin:DimZMax, GasNum),  &
      & xr_MixRtBasicZPerMolWt(DimXMin:DimXMax, DimZMin:DimZMax),           &
      & xz_MixRtBasicZPerMolWt(DimXMin:DimXMax, DimZMin:DimZMax),           &
      & xr_MixRtBasicZ(DimXMin:DimXMax, DimZMin:DimZMax),                   &
      & xz_MixRtBasicZ(DimXMin:DimXMax, DimZMin:DimZMax)                    &
      & )

    xza_MixRtBasicZPerMolWt = 0.0d0
    xr_MixRtBasicZPerMolWt = 0.0d0
    xz_MixRtBasicZPerMolWt = 0.0d0
    xr_MixRtBasicZ = 0.0d0
    xz_MixRtBasicZ = 0.0d0

    call MessageNotify( "M", &
      & "MoistBuoy_Init", "MolWtWet = %f", d=(/pack(MolWtWet(:), .true.) /) )

    do s = 1, GasNum
      xza_MixRtBasicZPerMolWt(:,:,s) = &
        & xza_MixRtBasicZ(:,:,IdxG(s)) / MolWtWet(IdxG(s))
    end do
    xz_MixRtBasicZPerMolWt = sum(xza_MixRtBasicZPerMolWt, 3) 
    xr_MixRtBasicZPerMolWt = xr_avr_xz( sum(xza_MixRtBasicZPerMolWt, 3) )
    xz_MixRtBasicZ         =  sum(xza_MixRtBasicZ, 3) 
    xr_MixRtBasicZ         = xr_avr_xz( sum(xza_MixRtBasicZ, 3) )     
    
  end subroutine MoistBuoy_Init


!!!------------------------------------------------------------------------!!!
  function xz_BuoyMoistKm(xz_PotTemp, xz_Exner, xza_MixRt)
    !

    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(in)  :: xz_PotTemp(DimXMin:DimXMax, DimZMin:DimZMax)
                                               !
    real(8), intent(in)  :: xz_Exner(DimXMin:DimXMax, DimZMin:DimZMax)
                                               !̵
    real(8), intent(in)  :: xza_MixRt(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
                                               !Žʬκ
    real(8)              :: xza_MixRtAll(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
                                               !Žʬκ
    real(8)              :: xza_MixRtAll2(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
                                               !Žʬκ
    real(8)              :: xz_BuoyMoistKm(DimXMin:DimXMax, DimZMin:DimZMax)
                                               !
    real(8)              :: xza_LatentHeat(DimXMin:DimXMax, DimZMin:DimZMax, GasNum)
                                               !Ǯ
    real(8)              :: xz_TempAll(DimXMin:DimXMax, DimZMin:DimZMax)
                                               !
    real(8)              :: xz_EffHeat(DimXMin:DimXMax, DimZMin:DimZMax)
                                               !
    real(8)              :: xz_EffPotTemp(DimXMin:DimXMax, DimZMin:DimZMax)    
    real(8)              :: xz_EffMolWt(DimXMin:DimXMax, DimZMin:DimZMax)    
                                               !
    real(8)              :: xza_MixRtPerMolWt(DimXMin:DimXMax, DimZMin:DimZMax, GasNum)
                                               !/ʬ
    integer              :: s
    
    
    !, , ̤
    !ʬʿʬ­
    xz_TempAll = ( xz_PotTemp + xz_PotTempBasicZ ) * ( xz_Exner + xz_ExnerBasicZ )
    xza_MixRtAll = xza_MixRtBasicZ + xza_MixRt
    xza_LatentHeat = 0.0d0
    
    !ν. ΤΤ
    do s = 1, GasNum
      xza_MixRtPerMolWt(:,:,s) = xza_MixRt(:,:,IdxG(s)) / MolWtWet(IdxG(s))
    end do
    
    !٤θ
    xz_EffPotTemp = xz_PotTemp / xz_PotTempBasicZ 
    
    !ʬ̸ + Ťθ
    xz_EffMolWt =                                           &
      & + sum(xza_MixRtPerMolWt, 3)                         &
      &    / ( 1.0d0 / MolWtDry + xz_MixRtBasicZPerMolWt )  &
      & - sum(xza_MixRt, 3) / ( 1.0d0 + xz_MixRtBasicZ )
    
    !ȯǮ׻
    !  ʬ̤ʬϤĤǤǮ˰¤ƤʤȸʤΤ, 
    !  κ椬λˤ, ǮδͿϥȤʤ褦ĴᤷƤ
    xza_MixRtAll2 = xza_MixRtAll
!    xza_MixRtAll2(:,:,IdxNH3) = xza_MixRtAll(:,:,IdxNH3) - xza_MixRtAll(:,:,IdxH2S) 

    do s = 1, CondNum
      xza_LatentHeat(:,:,s) =                                 &
        & xz_LatentHeat( SpcWetID(IdxCC(s)), xz_TempAll )  &
        &  * xza_MixRtAll2(:,:,IdxCG(s))                      &
!        &  * ( 5.0d-1 + sign( 5.0d-1, (xza_MixRtAll2(:,:,IdxCC(s)) - 1.0d-8) ) )
        &  * ( 5.0d-1 + sign( 5.0d-1, (xza_MixRtAll2(:,:,IdxCC(s)) - 1.0d-4) ) )
    end do
    xz_EffHeat = (   sum( xza_LatentHeat, 3 ) * xz_EffMolWtBasicZ &
!      &            + ReactHeatNH4SH * (xza_MixRtAll(:,:,IdxH2S) + xza_MixRtAll(:,:,IdxH2S)) &
      &              ) / ( CpDry * xz_ExnerBasicZ ) 
    
    !ήȻλȯŸϹ
    xz_BuoyMoistKm = &
      &  - 3.0d0 * Grav * ( Cm ** 2.0d0 ) * ( MixLen ** 2.0d0 )     &
      &    * xz_avr_xr(                                             &
      &        xr_dz_xz(                                            &
      &           xz_EffHeat                                        &
      &         + xz_PotTempBasicZ / xz_EffMolWtBasicZ              &
      &           * ( 1.0d0 + xz_EffPotTemp + xz_EffMolWt )         &
      &         )                                                   &
      &      )                                                      &
      &    / ( 2.0d0 * xz_PotTempBasicZ / xz_EffMolWtBasicZ)                   

  end function xz_BuoyMoistKm
    

!!!------------------------------------------------------------------------!!!
  function xr_BuoyMolWt(xza_MixRt)
    !
    ! ľαư˸ϹΤ, 
    ! ʬ̤θ̤
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(in)  :: xza_MixRt(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
                                               !Žʬκ
    real(8)              :: xr_BuoyMolWt(DimXMin:DimXMax, DimZMin:DimZMax)
                                               !Ϲ(ʬ̸)
    real(8)              :: xza_MixRtPerMolWt(DimXMin:DimXMax, DimZMin:DimZMax, GasNum)
                                               !/ʬ
    integer              :: s
    
    !
    xr_BuoyMolWt           = 0.0d0
    
    !ν. ΤΤ
    do s = 1, GasNum
      xza_MixRtPerMolWt(:,:,s) = xza_MixRt(:,:,IdxG(s)) / MolWtWet(IdxG(s))
    end do
    
    !Ϲη׻
    xr_BuoyMolWt =                                             &
      & + Grav * xr_avr_xz( sum(xza_MixRtPerMolWt, 3) )        &
      &    / ( 1.0d0 / MolWtDry + xr_MixRtBasicZPerMolWt )     &
      & - Grav * xr_avr_xz( sum(xza_MixRt(:,:,1:GasNum), 3) ) &
      &    / ( 1.0d0 + xr_MixRtBasicZ )

    call StoreBuoyMolWt(xz_avr_xr(xr_BuoyMolWt))

  end function xr_BuoyMolWt


!!!------------------------------------------------------------------------!!!
  function xr_BuoyDrag(xza_MixRt) 
    !
    ! ľαư˸ϹΤ, 
    ! ŤΤθ̤
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(in)  :: xza_MixRt(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
                                               !Žʬκ
    real(8)              :: xr_BuoyDrag(DimXMin:DimXMax, DimZMin:DimZMax)
                                               !Ϲ(ʬ̸)
    !
    xr_BuoyDrag           = 0.0d0

    !Ϲη׻
    xr_BuoyDrag =                                                     &
      & - Grav * xr_avr_xz( sum(xza_MixRt(:,:,GasNum+1:SpcNum), 3) ) &
      &    / ( 1.0d0 + xr_MixRtBasicZ )

    call StoreBuoyDrag(xz_avr_xr(xr_BuoyDrag))
    
  end function xr_BuoyDrag
  
end module MoistBuoyancy
