!= Module Turbulence_3d
!
! Authors::   SUGIYAMA Ko-ichiro, ODAKA, Masatsugu
! Version::   $Id: turbulence_3d.f90,v 1.3 2008-06-04 04:51:28 odakker Exp $
! Tag Name::  $Name: arare4-20100306 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview
!
!ǥʪ׻뤿ɬפȤʤؿ«ͤ⥸塼
!Ūˤϰʲι׻뤿δؿǼ.  
!  * ήȻ
!  * ήͥ륮λȯŸ˴ޤޤƹ
!  * Ǯ
!
!== Error Handling
!
!== Bugs
!
!== Note
!
!  * 1.5 Υ㡼Ѥ
!  * 꼰 CReSS Υޥ˥奢򻲾Ȥ
!
!== Future Plans
!
!

module Turbulence_3d
  !
  !ǥʪ׻뤿ɬפȤʤؿ«ͤ⥸塼
  !Ūˤϰʲι׻뤿δؿǼ.  
  !  * ήȻ
  !  * ήͥ륮λȯŸ˴ޤޤƹ
  !  * Ǯ
  !

  !⥸塼ɤ߹ 
  use dc_types, only : DP

  use gridset_3d, only:  DimXMin,        &! x β
    &                 DimXMax,           &! x ξ
    &                 DimYMin,           &! y β
    &                 DimYMax,           &! y ξ
    &                 DimZMin,           &! z β
    &                 DimZMax,           &! z ξ
    &                 SpcNum,            &! z ξ
    &                 x_dx,              &! x γʻֳ
    &                 y_dy,              &! y γʻֳ
    &                 z_dz                ! z γʻֳ
  use basicset_3d, only: CpDry,             &!ʬǮ
    &                 Grav,              &!ϲ®
    &                 xyz_PotTempBasicZ, &!ܾβ
    &                 xyz_ExnerBasicZ     !ʡؿδܾ
  use xyz_module, only: &
    &                xyz_avr_pyz, xyr_avr_pyr, xqz_avr_pqz, &
    &                pyz_avr_xyz, pyr_avr_xyr, pqz_avr_xqz, &
    &                xyz_avr_xqz, pyz_avr_pqz, xyr_avr_xqr, &
    &                xqz_avr_xyz, pqz_avr_pyz, xqr_avr_xyr, &
    &                xyz_avr_xyr, pyz_avr_pyr, xqz_avr_xqr, &
    &                xyr_avr_xyz, pyr_avr_pyz, xqr_avr_xqz, &
    &                pqz_avr_xyz, pyr_avr_xyz, xqr_avr_xyz, &
    &                xyz_avr_pqz, xyz_avr_pyr, xyz_avr_xqr
  use xyz_deriv_module, only: xyz_dx_pyz, xyz_dy_xqz, xyz_dz_xyr, &
    &                         pyz_dx_xyz, xqz_dy_xyz, xyr_dz_xyz, &
    &                         pqz_dx_xqz, pqz_dy_pyz, pyz_dy_pqz, &
    &                         pyr_dx_xyr, pyz_dz_pyr, pyr_dz_pyz, &
    &                         pyr_dz_pyz, pyr_dx_xyr, xyr_dx_pyr, &
    &                         xqr_dz_xqz, xqr_dy_xyr, xyr_dy_xqr, &
    &                         pqz_dy_pyz, pqz_dx_xqz, xqz_dx_pqz, &
    &                         xqr_dy_xyr, xqr_dz_xqz, xqz_dz_xqr  
  use StorePotTemp_3d, only: StorePotTempDisp, StorePotTempTurb
!  use StoreMixRt,   only: StoreMixRtTurb


  !ۤηػ
  implicit none

  !°λ
  private

  !ؿ public 
  public Turbulence_Init
  public xyz_TurbScalar
  public xyza_TurbScalar
  public pyz_TurbVelX
  public xqz_TurbVelY
  public xyr_TurbVelZ
  public xyz_ShearKm
  public xyz_DispKm
  public xyz_DispHeat
  public xyz_BuoyKm
  public EddyViscosity


  !ѿ
  real(DP) :: Cm     = 2.0d-1    !ήͥ륮Ǽη 
  real(DP) :: MixLen = 0.0d0     !ʿѺΥ

  !ͤ¸
  save Cm, MixLen

contains

!!!------------------------------------------------------------------------!!!
  subroutine turbulence_init()
    !
    ! Turbulence ⥸塼ν롼
    ! 

    !ۤηػ
    implicit none

    real(DP):: MinDelX
    real(DP):: MinDelY
    real(DP):: MinDelZ

    !Υ
    MinDelX = minval(x_dx)
    MinDelY = minval(y_dy)
    MinDelZ = minval(z_dz)

!    MixLen = ( MinDelX * MinDelY * MinDelZ ) ** (1.0d0/3.0d0)

    MixLen = min( MinDelZ, min( MinDelX, MinDelY ) )

  end subroutine turbulence_init
  
!!!------------------------------------------------------------------------!!!
  function xyz_TurbScalar(xyz_Var, xyz_Kh)
    !
    ! x, y, z ȾʻҤ줿ǤήȻ
    !
    
    !ۤηػ
    implicit none

    !ѿ
    real(DP),intent(in) :: xyz_Var(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                                    !顼
    real(DP),intent(in) :: xyz_Kh(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                                    !ήȻ
    real(DP)            :: xyz_TurbScalar(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                                    !顼̤οʿήȻ
  
!    xyz_TurbScalar = 0.0d0  !
    xyz_TurbScalar =                                                   &
      &   xyz_dx_pyz( pyz_avr_xyz( xyz_Kh ) * pyz_dx_xyz( xyz_Var ) )  &
      & + xyz_dy_xqz( xqz_avr_xyz( xyz_Kh ) * xqz_dy_xyz( xyz_Var ) )  &
      & + xyz_dz_xyr( xyr_avr_xyz( xyz_Kh ) * xyr_dz_xyz( xyz_Var ) )

    call StorePotTempTurb( xyz_TurbScalar )    
    
  end function xyz_TurbScalar


!!!------------------------------------------------------------------------!!!
  function xyza_TurbScalar(xyza_Var, xyz_Kh)
    !
    ! x, z ȾʻҤ줿ǤήȻ
    !
    
    !ۤηػ
    implicit none

    !ѿ
    real(DP),intent(in) :: xyza_Var(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax, SpcNum)
                                                    !顼
    real(DP),intent(in) :: xyz_Kh(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                                    !ήȻ
    real(DP)            :: xyza_TurbScalar(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax, SpcNum)
                                                    !顼̤οʿήȻ
    integer             :: s
  
    do s = 1, SpcNum
      xyza_TurbScalar(:,:,:,s) = xyz_TurbScalar( xyza_Var(:,:,:,s), xyz_Kh )  
    end do

!    call StoreMixRtTurb( xyza_TurbScalar )    
    
  end function xyza_TurbScalar


!!!------------------------------------------------------------------------!!!
  function pyz_TurbVelX(xyz_Km, pyz_VelX, xqz_VelY, xyr_VelZ)
    !
    ! ʿ®٤ФήȻ
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(DP),intent(in) :: pyz_VelX(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                                    !ʿ®
    real(DP),intent(in) :: xqz_VelY(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                                    !ʿ®
    real(DP),intent(in) :: xyr_VelZ(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                                    !ľ®
    real(DP),intent(in) :: xyz_Km(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                                    !ήȻ
    real(DP)            :: pyz_TurbVelX(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                                    !顼̤οʿήȻ
  
!    pyz_TurbVelX = 0.0d0  !  
    pyz_TurbVelX = &
      &   2.0d0 * pyz_dx_xyz( xyz_Km * xyz_dx_pyz( pyz_VelX ) ) &
      & + pyz_dy_pqz(                                           &
      &       pqz_avr_xyz( xyz_Km ) * pqz_dx_xqz( xqz_VelY )    &
      &     + pqz_avr_xyz( xyz_Km ) * pqz_dy_pyz( pyz_VelX )    &
      &   )                                                     &
      & + pyz_dz_pyr(                                           &
      &       pyr_avr_xyz( xyz_Km ) * pyr_dx_xyr( xyr_VelZ )    &
      &     + pyr_avr_xyz( xyz_Km ) * pyr_dz_pyz( pyz_VelX )    &
      &   )                                                     &
      & - 2.0d0 * pyz_dx_xyz( ( xyz_Km ** 2.0d0 ) )             &
      &   / ( 3.0d0 * ( Cm ** 2.0d0 ) * ( MixLen ** 2.0d0 ) )

    
  end function pyz_TurbVelX


!!!------------------------------------------------------------------------!!!
  function xqz_TurbVelY(xyz_Km, pyz_VelX, xqz_VelY, xyr_VelZ)
    !
    ! ʿ®٤ФήȻ
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(DP),intent(in) :: pyz_VelX(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                                    !ʿ®
    real(DP),intent(in) :: xqz_VelY(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                                    !ʿ®
    real(DP),intent(in) :: xyr_VelZ(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                                    !ľ®
    real(DP),intent(in) :: xyz_Km(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                                    !ήȻ
    real(DP)            :: xqz_TurbVelY(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                                    !顼̤οʿήȻ
  
!    xqz_TurbVelY = 0.0d0  !  
    xqz_TurbVelY = &
      &   2.0d0 * xqz_dy_xyz( xyz_Km * xyz_dy_xqz( xqz_VelY ) ) &
      & + xqz_dx_pqz(                                           &
      &       pqz_avr_xyz( xyz_Km ) * pqz_dy_pyz( pyz_VelX )    &
      &     + pqz_avr_xyz( xyz_Km ) * pqz_dx_xqz( xqz_VelY )    &
      &   )                                                     &
      & + xqz_dz_xqr(                                           &
      &       xqr_avr_xyz( xyz_Km ) * xqr_dy_xyr( xyr_VelZ )    &
      &     + xqr_avr_xyz( xyz_Km ) * xqr_dz_xqz( xqz_VelY )    &
      &   )                                                     &
      & - 2.0d0 * xqz_dy_xyz( ( xyz_Km ** 2.0d0 ) )             &
      &   / ( 3.0d0 * ( Cm ** 2.0d0 ) * ( MixLen ** 2.0d0 ) )
    
  end function xqz_TurbVelY


!!!------------------------------------------------------------------------!!!
  function xyr_TurbVelZ(xyz_Km, pyz_VelX, xqz_VelY, xyr_VelZ)
    !
    !ľ®٤ФήȻ
    !

    !ۤηػ
    implicit none
    
    !ѿ
    real(DP),intent(in) :: pyz_VelX(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                                    !ʿ®
    real(DP),intent(in) :: xqz_VelY(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                                    !ʿ®
    real(DP),intent(in) :: xyr_VelZ(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                                    !ľ®
    real(DP),intent(in) :: xyz_Km(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                                    !ήȻ
    real(DP)            :: xyr_TurbVelZ(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                                    !顼̤οʿήȻ
  
!    xyr_TurbVelZ = 0.0d0  !
    xyr_TurbVelZ = &
      & + 2.0d0 * xyr_dz_xyz( xyz_Km * xyz_dz_xyr( xyr_VelZ ) )  &
      & + xyr_dx_pyr(                                            &
      &      pyr_avr_xyz( xyz_Km ) * pyr_dz_pyz( pyz_VelX )      &
      &    + pyr_avr_xyz( xyz_Km ) * pyr_dx_xyr( xyr_VelZ )      &
      &   )                                                     &
      & + xyr_dy_xqr(                                            &
      &      xqr_avr_xyz( xyz_Km ) * xqr_dz_xqz( xqz_VelY )      &
      &    + xqr_avr_xyz( xyz_Km ) * xqr_dy_xyr( xyr_VelZ )      &
      &   )                                                      &
      & - 2.0d0 * xyr_dz_xyz( ( xyz_Km ** 2.0d0 ) )                 &
      &   / ( 3.0d0 * ( Cm ** 2.0d0 ) * ( MixLen ** 2.0d0 ) )
    
  end function xyr_TurbVelZ

!!!------------------------------------------------------------------------!!!
  function xyz_ShearKm(xyz_Km, pyz_VelX, xqz_VelY, xyr_VelZ)
    !
    !®٥ˤήͥ륮
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(DP)            :: xyz_ShearKm(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                                        !Ǵΰή
    real(DP),intent(in) :: xyz_Km(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                                        !Ǵ
    real(DP),intent(in) :: pyz_VelX(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                                        !ʿ®
    real(DP),intent(in) :: xqz_VelY(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                                        !ʿ®
    real(DP),intent(in) :: xyr_VelZ(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                                        !ľ®
  
!    xyz_ShearKm = 0.0d0
    xyz_ShearKm = &
      &   ( Cm ** 2.0d0 ) * ( MixLen ** 2.0d0 )                    &
      & * (                                                        &
      &      ( xyz_dx_pyz( pyz_VelX ) ) ** 2.0d0                   &
      &    + ( xyz_dy_xqz( xqz_VelY ) ) ** 2.0d0                   &
      &    + ( xyz_dz_xyr( xyr_VelZ ) ) ** 2.0d0                   &
      &    + 5.0d-1                                                &
      &      * (                                                   &
      &          (                                                 &
      &              xyz_avr_pyr( pyr_dz_pyz( pyz_VelX ) )         &
      &            + xyz_avr_pyr( pyr_dx_xyr( xyr_VelZ ) )         &
      &           ) ** 2.0d0                                       &
      &        + (                                                 &
      &              xyz_avr_xqr( xqr_dy_xyr( xyr_VelZ ) )         &
      &            + xyz_avr_xqr( xqr_dz_xqz( xqz_VelY ) )         &
      &           ) ** 2.0d0                                       &
      &        + (                                                 &
      &              xyz_avr_pqz( pqz_dx_xqz( xqz_VelY ) )         &
      &            + xyz_avr_pqz( pqz_dy_pyz( pyz_VelX ) )         &
      &           ) ** 2.0d0                                       &
      &        )                                                   &
      &   )                                                        &
      & - xyz_Km * (  xyz_dx_pyz( pyz_VelX ) &
      &             + xyz_dy_xqz( xqz_VelY ) &
      &             + xyz_dz_xyr( xyr_VelZ ) ) / 3.0d0
 
   
  end function xyz_ShearKm


!!!------------------------------------------------------------------------!!!
  function xyz_TurbKm(xyz_Km)
    !
    ! ήͥ륮γȻ
    !

    !ۤηػ
    implicit none
    
    !ѿ
    real(DP)            :: xyz_TurbKm(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                               ! ήͥ륮γȻ
    real(DP),intent(in) :: xyz_Km(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                               !Ǵ

!    xz_TurbKm = 0.0d0
    xyz_TurbKm =                                       &
      &   xyz_dx_pyz( pyz_dx_xyz( xyz_Km ** 2.0d0 ) )  &
      & + xyz_dy_xqz( xqz_dy_xyz( xyz_Km ** 2.0d0 ) )  &
      & + xyz_dz_xyr( xyr_dz_xyz( xyz_Km ** 2.0d0 ) )  &
      & + (xyz_avr_pyz( pyz_dx_xyz( xyz_Km ) ) ) ** 2.0d0 & 
      & + (xyz_avr_xqz( xqz_dy_xyz( xyz_Km ) ) ) ** 2.0d0 & 
      & + (xyz_avr_xyr( xyr_dz_xyz( xyz_Km ) ) ) ** 2.0d0
    
  end function xyz_TurbKm


!!!------------------------------------------------------------------------!!!
  function xyz_DispKm(xyz_Km)
    !
    !ήͥ륮ξû
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(DP)            :: xyz_DispKm(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                                    !ήͥ륮ξû
    real(DP),intent(in) :: xyz_Km(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                                    !Ǵ

!    xz_DispKm = 0.0d0
    xyz_DispKm = - (xyz_Km ** 2.0d0) * 5.0d-1 / (MixLen ** 2.0d0)
    
  end function xyz_DispKm


!!!------------------------------------------------------------------------!!!
  function xyz_DispHeat(xyz_Km)
    !
    !̤λǮ
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(DP)            :: xyz_DispHeat(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                                    !ήͥ륮ξû
    real(DP),intent(in) :: xyz_Km(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                                    !Ǵ

!    xz_DispHeat = 0.0d0
!    xyz_DispHeat = (xyz_Km ** 3.0d0) * xyz_EffMolWtBasicZ &
!      &        / (xyz_ExnerBasicZ * CpDry * (Cm ** 2.0d0) * (MixLen ** 4.0d0))

    xyz_DispHeat = (xyz_Km ** 3.0d0) &
      &        / (xyz_ExnerBasicZ * CpDry * (Cm ** 2.0d0) * (MixLen ** 4.0d0))

    !ͤݴ
    call StorePotTempDisp( xyz_DispHeat )
    
  end function xyz_DispHeat


!!!------------------------------------------------------------------------!!!
  function xyz_BuoyKm(xyz_PotTemp)
    !
    !ήͥ륮Ϲ׻. 絤. 
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(DP),intent(in)  :: xyz_PotTemp(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                               !̾
    real(DP)             :: xyz_BuoyKm(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                               !Ϲ

    !Ϲη׻
!    xz_BuoyKm = 0.0d0
    xyz_BuoyKm = &
      &  - 3.0d0 * Grav * ( Cm ** 2.0d0 ) * ( MixLen ** 2.0d0 ) &
      &       * xyz_avr_xyr( xyr_dz_xyz( xyz_PotTemp + xyz_PotTempBasicZ ) ) &
      &       / ( 2.0d0 * xyz_PotTempBasicZ )
    
  end function xyz_BuoyKm

!!!------------------------------------------------------------------------!!!
  subroutine EddyViscosity(pyz_VelX, xqz_VelY, xyr_VelZ, xyz_PotTemp, xyz_Km, xyz_KmA)
    !
    ! ήͥ륮ȤαȻ, Ǵ. 
    ! ήѥ᥿ꥼ, Mellor and Yamada (1974) 
    ! Level 1 Closure б뤬, Level1 Closure ¸ߤ 
    ! \bar{\theta^2} ̵뤵Ƥ. 

    !--- ۤηػ
    implicit none

    real(DP),intent(in)  :: pyz_VelX(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax) 
    real(DP),intent(in)  :: xqz_VelY(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax) 
    real(DP),intent(in)  :: xyr_VelZ(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax) 
    real(DP),intent(in)  :: xyz_PotTemp(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP),intent(in)  :: xyz_Km(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax) 
    real(DP),intent(out) :: xyz_KmA(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax) 

    xyz_KmA = &
      & sqrt ( &
      &   max( 0.0d0, &
      &        ( xyz_ShearKm( xyz_Km, pyz_VelX, xqz_VelY, xyr_VelZ ) + &
      &          xyz_BuoyKm( xyz_PotTemp ) ) * MixLen ** 2.0d0 ))


  end subroutine EddyViscosity

end module Turbulence_3d
