!= Module GridSet_3D
!
! Authors::   SUGIYAMA Ko-ichiro, ODAKA Masatsugu
! Version::   $Id: gridset_3d.f90,v 1.2 2007-08-06 15:47:07 odakker Exp $ 
! Tag Name::  $Name: arare4-20100306 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview 
!
!Ϳ줿 NAMELIST ե뤫, ʻ, 
!ݴɤ뤿ѿ⥸塼
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!== Future Plans
!

module gridset_3d
  !
  !Ϳ줿 NAMELIST ե뤫, ʻ, 
  !ݴɤ뤿ѿ⥸塼
  !

  !⥸塼ɤ߹
  use dc_types,   only: DP
  use dc_iounit,  only: FileOpen
  use dc_trace,   only: Debug
  use dc_message, only: MessageNotify
  use xyz_base_module, only: DimXmin => imin, DimXMax => imax, &
    &                   DimYmin => jmin, DimYMax => jmax, &
    &                   DimZmin => kmin, DimZMax => kmax, &
    &                   xyz_axis_init, x_X, p_X, y_Y, q_Y, z_Z, r_Z, &
    &                   x_dx, p_dx, y_dy, q_dy, z_dz, r_dz, &
    &                   xyz_X, xyz_Y, xyz_Z,       &
    &                   xyz_dX, xyz_dY, xyz_dZ,    &
    &                   xmargin, ymargin, zmargin
  
  !ۤηػ
  implicit none

  !save °
  save

  !ѿ
  real(DP)              :: Xmin, Xmax    ! x ɸλ
  real(DP)              :: Ymin, Ymax    ! x ɸλ
  real(DP)              :: Zmin, Zmax    ! z ɸλ
  integer               :: NX, NY, NZ    ! ʻ
  integer               :: Xmg, Ymg, Zmg ! ʻ
  integer               :: SpcNum        ! ؼο
  integer               :: RegXMin       ! x ʪΰβ
  integer               :: RegXMax       ! x ʪΰξ
  integer               :: RegYMin       ! x ʪΰβ
  integer               :: RegYMax       ! x ʪΰξ
  integer               :: RegZMin       ! z ʪΰβ
  integer               :: RegZMax       ! z ʪΰξ
  integer               :: FileNX        !ե
  integer               :: FileNY        !ե
  integer               :: FileNZ        !ե
  integer               :: FileXMin      !ե
  integer               :: FileXMax      !ե
  integer               :: FileYMin      !ե
  integer               :: FileYMax      !ե
  integer               :: FileZMin      !ե
  integer               :: FileZMax      !ե

contains

  subroutine gridset_init(cfgfile)
    !
    !NAMELIST , ʻ׻
    !

    !ۤηػ
    implicit none

    !⥸塼ɤ߹

    !ѿ
    character(*), intent(in) :: cfgfile

    !ѿ
    integer            :: i, k, unit
    integer, parameter :: kind = 8      !٤ɽ
    logical            :: DebugOn

    !-----------------------------------------------------------------
    ! NAMELIST 
    !-----------------------------------------------------------------
    NAMELIST /gridset/ &
      & NX, NY, NZ, Xmin, Xmax, Ymin, Ymax, Zmin, Zmax, Xmg, Ymg, Zmg, &
      & SpcNum

    call FileOpen(unit, file=cfgfile, mode='r')
    read(unit, NML=gridset)
    close(unit)

    if ( NX < xmg ) then
      call MessageNotify( "E", "gridset_init", "NX < Xmg" )
    end if

    if ( NY < ymg ) then
      call MessageNotify( "E", "gridset_init", "NY < Ymg" )
    end if

    if ( NZ < zmg ) then
      call MessageNotify( "E", "gridset_init", "NZ < Zmg" )
    end if

    !-----------------------------------------------------------------
    ! ʻֳַ׻
    !-----------------------------------------------------------------

    call xyz_axis_init(NX, NY, NZ, xmg, ymg, zmg, &
      &                Xmin, Xmax, Ymin, Ymax, Zmin, Zmax)

    !-----------------------------------------------------------------
    ! ʪŪ˰̣Τΰξ¡¤
    !-----------------------------------------------------------------;
    RegXMin = 1
    RegXMax = NX
    RegYMin = 1
    RegYMax = NY
    RegZMin = 1
    RegZMax = NZ

    !-----------------------------------------------------------------
    ! ǥХå⡼ɤݤ, եϤѤѿ礭Ѥ
    !-----------------------------------------------------------------

    DebugOn= Debug()
    if (DebugOn) then
      FileNX   = size(p_X, 1)
      FileNY   = size(q_Y, 1)
      FileNZ   = size(r_Z, 1)
      FileXMin = DimXMin
      FileXMax = DimXMax
      FileYmin = DimYMin
      FileYMax = DimYMax
      FileZMin = DimZMin
      FileZMax = DimZMax
    else
      FileNX   = NX
      FileNY   = NY
      FileNZ   = NZ
      FileXMin = RegXMin
      FileXMax = RegXMax
      FileYMin = RegYMin
      FileYMax = RegYMax
      FileZMin = RegZMin
      FileZMax = RegZMax
    end if

    !-----------------------------------------------------------------    
    ! ǧ
    !-----------------------------------------------------------------
    call MessageNotify( "M", "gridset_init", "XMin = %f", d=(/XMin/)    )
    call MessageNotify( "M", "gridset_init", "XMax = %f", d=(/XMax/)    )
    call MessageNotify( "M", "gridset_init", "YMin = %f", d=(/YMin/)    )
    call MessageNotify( "M", "gridset_init", "YMax = %f", d=(/YMax/)    )
    call MessageNotify( "M", "gridset_init", "ZMin = %f", d=(/ZMin/)    )
    call MessageNotify( "M", "gridset_init", "ZMax = %f", d=(/ZMax/)    )
    call MessageNotify( "M", "gridset_init", "NX = %d",   i=(/NX/)      )
    call MessageNotify( "M", "gridset_init", "NY = %d",   i=(/NY/)      )
    call MessageNotify( "M", "gridset_init", "NZ = %d",   i=(/NZ/)      )
    call MessageNotify( "M", "gridset_init", "Xmargin = %d", i=(/Xmg/) )
    call MessageNotify( "M", "gridset_init", "Ymargin = %d", i=(/Ymg/) )
    call MessageNotify( "M", "gridset_init", "Zmargin = %d", i=(/Zmg/) )
    call MessageNotify( "M", "gridset_init", "DimXMin = %d", i=(/DimXMin/) )
    call MessageNotify( "M", "gridset_init", "DimXMax = %d", i=(/DimXMax/) )
    call MessageNotify( "M", "gridset_init", "DimYMin = %d", i=(/DimYMin/) )
    call MessageNotify( "M", "gridset_init", "DimYMax = %d", i=(/DimYMax/) )
    call MessageNotify( "M", "gridset_init", "DimZMin = %d", i=(/DimZMin/) )
    call MessageNotify( "M", "gridset_init", "DimZMax = %d", i=(/DimZMax/) )

  end subroutine gridset_init
  
end module gridset_3d
