!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2006. All rights reserved.
!---------------------------------------------------------------------
!
!= 1  (x ) ֳָ߳ʻ ͭºʬǥ ܥ⥸塼
!
!* 
!  * 2007/07/15 () : 3D deepconv ذܿ, dc_types  Use.
!  * 2006/12/26 () : p_X , x_p, p_x ̾򸵤᤹
!  * 2006/06/17 () : IntX_*, AvrX_* ɲ
!  * 2006/05/26 () : ⥸塼̾ѹ
!  * 2006/02/02 () : 
!
module x_base_module
  != 1  (x ) ֳָ߳ʻ ͭºʬǥ ܥ⥸塼
  !
  !== 
  !
  ! x_base_module , 1  (x ) ֳָ߳ʻҤѤͭºʬ
  ! ˡ˴ŤͥǥΤ, Ū Fortran90 ץप
  ! ؿ󶡤. 
  !
  ! Υ⥸塼 x_module β̥⥸塼Ǥ. ⥸塼
  ! Ȥ data_type ⥸塼ѤƤ. 
  ! 
  !== 
  !
  ! * 㳰ʤ
  ! * ξΥåɽʤ
  ! * ͤϥޥ󥤥ץͤȤƤ٤

  use dc_types, only : DBKIND => DP
  implicit none

  private
  public :: im, xmargin, imin, imax, x_X, p_X, x_dx, p_dx
  public :: x_axis_init, x_avr_p, p_avr_x, IntX_p, IntX_x, AvrX_p, AvrX_x

  integer         :: im      = 10 ! ʻ
  integer         :: xmargin = 2  ! ʻ
  integer         :: imin         ! źβ
  integer         :: imax         ! źξ

  real(DBKIND),allocatable :: x_X(:)       ! Ⱦʻɸ
  real(DBKIND),allocatable :: p_X(:)       ! ʻɸ
  real(DBKIND),allocatable :: x_dx(:)       ! Ⱦʻɸ
  real(DBKIND),allocatable :: p_dx(:)       ! ʻɸ

  save im, xmargin, imin, imax, x_X, p_X, x_dx, p_dx

  contains
!--------------------------------------------------------------------
    subroutine x_axis_init(i, xmg, xmin, xmax)
      ! ξ岼¤ͤȳʻɸ, ʻֳ֤ꤹ

      integer,intent(in)  :: i    ! x ʻ
      integer,intent(in)  :: xmg  ! x ʻ
      real(DBKIND),intent(in) :: xmin ! x ɸǾ     
      real(DBKIND),intent(in) :: xmax ! x ɸ  
      integer             :: ix   ! do 롼ź
      real(DBKIND)            :: dx   ! ʻҴֳ

      im = i
      xmargin = xmg

      imin = 1  - xmargin
      imax = im + xmargin

      allocate(x_X(imin:imax))
      allocate(p_X(imin:imax))
      allocate(x_dx(imin:imax))
      allocate(p_dx(imin:imax))

      dx = (xmax - xmin)/im

      do ix = imin, imax
        p_X(ix) = dx * ix
        x_X(ix) = dx * (ix - 0.5)
        x_dx(ix) = dx
        p_dx(ix) = dx
      end do

    end subroutine x_axis_init  
!--------------------------------------------------------------------
    function x_avr_p(p_Var)
      ! ʿԤʻͤȾʻ֤
  
      real(DBKIND),intent(in) :: p_Var(imin:imax)  ! 
      real(DBKIND)            :: x_avr_p(imin:imax) ! 
      integer             :: ix                ! 롼ź

      ! 
      ! * 0 ɤˤϥޥ󥤥ץͤѤ٤
      !
      x_avr_p = 0.0d0

      ! ʿ
      ! * ʿѤȤʤ imin ʻҾͤϷ׻ʤ.
      !
      do ix = imin+1, imax
        x_avr_p(ix) = (p_Var(ix) + p_Var(ix-1))*0.5d0 
      end do

      ! imin ʻҾ
      x_avr_p(imin) = x_avr_p(imin+1)

    end function x_avr_p

!--------------------------------------------------------------------
    function p_avr_x(x_Var)
      ! ʿԤȾʻͤʻ֤
  
      real(DBKIND),intent(in) :: x_Var(imin:imax)  ! 
      real(DBKIND)            :: p_avr_x(imin:imax) ! 
      integer             :: ix                ! 롼ź

      ! 
      ! * 0 ɤˤϥޥ󥤥ץͤѤ٤
      !
      p_avr_x = 0.0d0

      ! ʿ
      ! * ʿѤȤʤ imax ʻҾͤϷ׻ʤ.
      ! * ֳֳʻҤʤΤǽŤߤĤʿѤ.
      !    P, Q  a:b ʬ X ͤ, a*X(Q) + b*X(P) 
      !   (a+b=1 ) Ǥ뤳Ȥ, 
      !
      !     p_Var(ix) = [0.5*x_dx(ix)  /p_dx(ix)]*x_Var(ix+1) +    
      !                 [0.5*x_dx(ix+1)/p_dx(ix)]*x_Var(ix)     
      !   
      !   ѷ
      !
      !     p_Var(ix) = [x_dx(ix)*x_Var(ix+1) + x_dx(ix+1)*x_Var(ix)]
      !                 *0.5/p_dx(ix)
      ! 
      do ix = imin, imax-1
        p_avr_x(ix) = &
          &  (x_dx(ix)*x_Var(ix+1) + x_dx(ix+1)*x_Var(ix))*0.5d0/p_dx(ix)
      end do

      ! imax ʻ
      p_avr_x(imax) = p_avr_x(imax-1)

    end function p_avr_x
!--------------------------------------------------------------------
    function IntX_p(p_Var)
      ! ʻҾФ x ˽ŤդʬԤ

      real(DBKIND), intent(in) :: p_Var(imin:imax)  ! 
      real(DBKIND)             :: IntX_p            ! 

      ! 
      IntX_p = 0.0d0

      ! ʬ
      IntX_p = sum(p_Var(1:im)*p_dx(1:im))

    end function IntX_p
!--------------------------------------------------------------------
    function IntX_x(x_Var)
      ! ȾʻҾФ x ˽ŤդʬԤ

      real(DBKIND), intent(in) :: x_Var(imin:imax)  ! 
      real(DBKIND)             :: IntX_x            ! 
      real(DBKIND), allocatable:: work(:)

      ! 
      IntX_x = 0.0d0
      allocate(work(imin:imax))

      ! ʬ
      work = x_Var*x_dx

      IntX_x = sum(work(1:im))
      
      deallocate(work)

    end function IntX_x
!--------------------------------------------------------------------
    function AvrX_p(p_Var)
      ! ʻҾФ x ʿԤ

      real(DBKIND), intent(in) :: p_Var(imin:imax)  ! 
      real(DBKIND)             :: AvrX_p            ! 

      AvrX_p = IntX_p(p_Var)/sum(p_dx(1:im))

    end function AvrX_p
!--------------------------------------------------------------------
    function AvrX_x(x_Var)
      ! ȾʻҾФ x ʿԤ

      real(DBKIND), intent(in) :: x_Var(imin:imax)  ! 
      real(DBKIND)             :: AvrX_x            ! 

      AvrX_x = IntX_x(x_Var)/sum(x_dx(1:im))

    end function AvrX_x
!--------------------------------------------------------------------
end module x_base_module
