!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2006. All rights reserved.
!---------------------------------------------------------------------
!
!= 1  (y ) ֳָ߳ʻ ͭºʬǥ ܥ⥸塼
!
!* 
!  * 2007/07/15 () : 3D deepconv ذܿ, dc_types  Use.
!  * 2006/12/26 () : p_Y , y_q, q_y ̾򸵤᤹
!  * 2006/06/17 () : IntY_*, AvrY_* ɲ
!  * 2006/06/02 () : x_base_module 
!
module y_base_module
  != 1  (y ) ֳָ߳ʻ ͭºʬǥ ܥ⥸塼
  !
  !== 
  !
  ! y_base_module , 1  (y ) ֳָ߳ʻҤѤͭºʬ
  ! ˡ˴ŤͥǥΤδŪ Fortran90 ץप
  ! ؿ󶡤. Υ⥸塼 y_module β̥⥸塼Ǥ.
  ! 
  !== 
  !
  ! * 㳰ʤ
  ! * ξΥåɽʤ
  ! * ͤϥޥ󥤥ץͤȤƤ٤

  use dc_types, only : DBKIND => DP
  implicit none

  private
  public :: jm, ymargin, jmin, jmax, y_Y, q_Y, y_dy, q_dy
  public :: y_axis_init, y_avr_q, q_avr_y, IntY_q, IntY_y, AvrY_q, AvrY_y

  integer         :: jm      = 10 ! ʻ
  integer         :: ymargin = 2  ! ʻ
  integer         :: jmin         ! źβ
  integer         :: jmax         ! źξ

  real(DBKIND),allocatable :: y_Y(:)       ! Ⱦʻɸ
  real(DBKIND),allocatable :: q_Y(:)       ! ʻɸ
  real(DBKIND),allocatable :: y_dy(:)       ! Ⱦʻɸ
  real(DBKIND),allocatable :: q_dy(:)       ! ʻɸ

  save jm, ymargin, jmin, jmax, y_Y, q_Y, y_dy, q_dy

  contains
!--------------------------------------------------------------------
    subroutine y_axis_init(j, ymg, ymin, ymax)
      ! y κɸͤȳʻֳ֤ꤹ

      integer,intent(in)      :: j    ! y ʻ
      integer,intent(in)      :: ymg  ! y ʻ
      real(DBKIND),intent(in) :: ymin ! y ɸǾ     
      real(DBKIND),intent(in) :: ymax ! y ɸ  
      integer                 :: jy   ! 롼ź
      real(DBKIND)            :: dy

      jm = j
      ymargin = ymg

      jmin = 1  - ymargin
      jmax = jm + ymargin

      allocate(y_Y(jmin:jmax))
      allocate(q_Y(jmin:jmax))
      allocate(y_dy(jmin:jmax))
      allocate(q_dy(jmin:jmax))

      dy = (ymax - ymin)/jm

      do jy = jmin, jmax
        q_Y(jy) = dy * jy
        y_Y(jy) = dy * (jy - 0.5)
        y_dy(jy) = dy
        q_dy(jy) = dy
      end do

    end subroutine y_axis_init  
!--------------------------------------------------------------------
    function y_avr_q(q_Var)
      ! ʿԤʻͤȾʻ֤
  
      real(DBKIND),intent(in) :: q_Var(jmin:jmax)  ! 
      real(DBKIND)            :: y_avr_q(jmin:jmax) ! 
      integer                 :: jy                ! 롼ź

      ! 
      ! * 0 ɤˤϥޥ󥤥ץͤѤ٤
      !
      y_avr_q = 0.0d0

      ! ʿ
      ! * ʿѤȤʤ jmin ʻҾͤϷ׻ʤ.
      !
      do jy = jmin+1, jmax
        y_avr_q(jy) = (q_Var(jy) + q_Var(jy-1))*0.5d0 
      end do

      ! jmin ʻ
      y_avr_q(jmin) = y_avr_q(jmin+1)

    end function y_avr_q

!--------------------------------------------------------------------
    function q_avr_y(y_Var)
      ! ʿԤȾʻͤʻ֤
  
      real(DBKIND),intent(in) :: y_Var(jmin:jmax)  ! 
      real(DBKIND)            :: q_avr_y(jmin:jmax) ! 
      integer                 :: jy                ! 롼ź

      ! 
      ! * 0 ɤˤϥޥ󥤥ץͤѤ٤
      !
      q_avr_y = 0.0d0

      ! ʿ
      ! * ʿѤȤʤ jmax ʻҾͤϷ׻ʤ.
      ! * ֳֳʻҤʤΤǽŤߤĤʿѤ.
      !    P, Q  a:b ʬ X ͤ, a*X(Q) + b*X(P) 
      !   (a+b=1 ) Ǥ뤳Ȥ, 
      !
      !     q_Var(jy) = [0.5*y_dy(jy)  /q_dy(jy)]*y_Var(jy+1) +    
      !                 [0.5*y_dy(jy+1)/q_dy(jy)]*y_Var(jy)     
      !   
      !   ѷ
      !
      !     q_Var(jy) = [y_dy(jy)*y_Var(jy+1) + y_dy(jy+1)*y_Var(jy)]
      !                 *0.5/q_dy(jy)
      ! 
      do jy = jmin, jmax-1
        q_avr_y(jy) = &
          &  (y_dy(jy)*y_Var(jy+1) + y_dy(jy+1)*y_Var(jy))*0.5d0/q_dy(jy)
      end do

      ! jmax ʻ
      q_avr_y(jmax) = q_avr_y(jmax-1)

    end function q_avr_y
!--------------------------------------------------------------------
    function IntY_q(q_Var)
      ! ʻҾФ y ˽ŤդʬԤ

      real(DBKIND), intent(in) :: q_Var(jmin:jmax)  ! 
      real(DBKIND)             :: IntY_q            ! 

      ! 
      IntY_q = 0.0d0

      ! ʬ
      IntY_q = sum(q_Var(1:jm)*q_dy(1:jm))

    end function IntY_q
!--------------------------------------------------------------------
    function IntY_y(y_Var)
      ! ȾʻҾФ y ˽ŤդʬԤ

      real(DBKIND), intent(in) :: y_Var(jmin:jmax)  ! 
      real(DBKIND)             :: IntY_y            ! 

      ! 
      IntY_y = 0.0d0

      ! ʬ
      IntY_y = sum(y_Var(1:jm)*y_dy(1:jm))

    end function IntY_y
!--------------------------------------------------------------------
    function AvrY_q(q_Var)
      ! ʻҾФ y ʿԤ

      real(DBKIND), intent(in) :: q_Var(jmin:jmax)  ! 
      real(DBKIND)             :: AvrY_q            ! 

      AvrY_q = IntY_q(q_Var)/sum(q_dy(1:jm))

    end function AvrY_q
!--------------------------------------------------------------------
    function AvrY_y(y_Var)
      ! ȾʻҾФ y ʿԤ

      real(DBKIND), intent(in) :: y_Var(jmin:jmax)  ! 
      real(DBKIND)             :: AvrY_y            ! 

      AvrY_y = IntY_y(y_Var)/sum(y_dy(1:jm))

    end function AvrY_y
!--------------------------------------------------------------------
end module y_base_module
