!= Module FillNegative
!
! Authors::   SUGIYAMA Ko-ichiro, ODAKA Masatsugu
! Version::   $Id: fillnegative_3d.f90,v 1.1 2008-06-20 07:42:14 odakker Exp $
! Tag Name::  $Name: arare4-20100306 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview
!
!α̤ʤɤ᤹뤿Υ롼
!  * Ȥʤäˤ, Ϥ 8 ʻͤäƷ᤹.
! 
!== Error Handling
!
!== Bugs
!
!== Note
!
!  *  deepconv  QFILL.f 
!
!== Future Plans
!
!

module FillNegative_3d
  !
  !α̤ʤɤ᤹뤿Υ롼
  !  * Ȥʤäˤ, Ϥ 8 ʻͤäƷ᤹.
  ! 

  !⥸塼ɤ߹
  use dc_types,   only: DP
  use dc_message, only: MessageNotify

  use gridset_3d, only: DimXMin,  &!  X β
    &                   DimXMax,  &!  X ξ
    &                   DimYMin,  &!  Y β
    &                   DimYMax,  &!  Y ξ
    &                   DimZMin,  &!  Z β
    &                   DimZMax,  &!  Z ξ
    &                   SpcNum     ! ؼο
  
  implicit none

  public FillNegative_Init
  public xyza_FillNegative_xyza

  real(DP), allocatable  :: xyza_Basic(:,:,:,:)
  real(DP), allocatable  :: xyz_Dens(:,:,:)

  save xyza_Basic, xyz_Dens

contains

  subroutine FillNegative_Init( xyza_VarBasic, xyz_DensBasic )
    !
    ! ͤ. 
    ! ܾȾʬ¤⾮ʤ뤳ȤϵƤʤ
    !

    implicit none

    !ѿ
    real(DP), intent(in) :: xyza_VarBasic(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax, SpcNum)
    real(DP), intent(in) :: xyz_DensBasic(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)

    !
    allocate( xyza_Basic(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax, SpcNum), &
      &       xyz_Dens  (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax )          )
    
    !ͤ
    xyza_Basic = xyza_VarBasic
    xyz_Dens   = xyz_DensBasic

  end subroutine FillNegative_Init
  

  function xyza_FillNegative_xyza( xyza_Var )
    
    implicit none

    real(DP), intent(inout) :: xyza_Var(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax, SpcNum)
    real(DP) :: xyza_FillNegative_xyza(DimXMin:DimXMax,DimYMin:DImYMax,DimZMin:DimZMax, SpcNum)
    real(DP) :: xyza_DQFILL(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax, SpcNum)
    real(DP) :: xyza_QSUMPN(DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax, SpcNum)
    real(DP), parameter     :: EPS = 1.0d-60  !Ǥγ껻ɤ
    integer                :: i, j, k
    
    !
    xyza_QSUMPN = 0.0d0
    xyza_DQFILL = 0.0d0


    do k = DimZMin+2, DimZMax-2
      do j = DimYMin+2, DimYMax-2
        do i = DimXMin+2, DimXMax-2
          xyza_QSUMPN(i,j,k,:) = 1.0d0 /                                       &
            & ( (    MAX( 0.0d0, xyza_Basic(i-1,j,k,:) + xyza_Var(i-1,j,k,:) ) &
            &         * xyz_Dens(i-1,j,k)                                      &
            &      + MAX( 0.0d0, xyza_Basic(i+1,j,k,:) + xyza_Var(i+1,j,k,:) ) &
            &         * xyz_Dens(i+1,j,k)                                      &
            &      + MAX( 0.0d0, xyza_Basic(i,j-1,k,:) + xyza_Var(i,j-1,k,:) ) &
            &         * xyz_Dens(i,j-1,k)                                      &
            &      + MAX( 0.0d0, xyza_Basic(i,j+1,k,:) + xyza_Var(i,j+1,k,:) ) &
            &         * xyz_Dens(i,j+1,k)                                      &
            &      + MAX( 0.0d0, xyza_Basic(i,j,k-1,:) + xyza_Var(i,j,k-1,:) ) &
            &         * xyz_Dens(i,j,k-1)                                      &
            &      + MAX( 0.0d0, xyza_Basic(i,j,k+1,:) + xyza_Var(i,j,k+1,:) ) &
            &         * xyz_Dens(i,j,k+1)                                      &
            &     ) * 0.75d0                                                   &
            &  + (   MAX( 0.0d0, xyza_Basic(i-2,j,k,:) + xyza_Var(i-2,j,k,:) ) &
            &         * xyz_Dens(i-2,j,k)                                      &
            &      + MAX( 0.0d0, xyza_Basic(i+2,j,k,:) + xyza_Var(i+2,j,k,:) ) &
            &         * xyz_Dens(i+2,j,k)                                      &
            &      + MAX( 0.0d0, xyza_Basic(i,j-2,k,:) + xyza_Var(i,j-2,k,:) ) &
            &         * xyz_Dens(i,j-2,k)                                      &
            &      + MAX( 0.0d0, xyza_Basic(i,j+2,k,:) + xyza_Var(i,j+2,k,:) ) &
            &         * xyz_Dens(i,j+2,k)                                      &
            &      + MAX( 0.0d0, xyza_Basic(i,j,k-2,:) + xyza_Var(i,j,k-2,:) ) &
            &         * xyz_Dens(i,j,k-2)                                      &
            &      + MAX( 0.0d0, xyza_Basic(i,j,k+2,:) + xyza_Var(i,j,k+2,:) ) &
            &         * xyz_Dens(i,j,k+2)                                      &
            &     ) * 0.25d0                                              &
            &  + EPS ) 
        end do
      end do
    end do

    do k = DimZMin+2, DimZMax-2
      do j = DimYMin+2, DimYMax-2
         do i = DimXMin+2, DimXMax-2
          xyza_DQFILL(i,j,k,:) =                                              &
            &  - MIN( 0.0d0, xyza_Basic(i,j,k,:) + xyza_Var(i,j,k,:) )        &
            &  + MAX( 0.0d0, xyza_Basic(i,j,k,:) + xyza_Var(i,j,k,:) )        &
            &    * ( ( MIN( 0.0d0, xyza_Basic(i-1,j,k,:) + xyza_Var(i-1,j,k,:) ) &
            &           * xyza_QSUMPN(i-1,j,k,:)                               &
            &           * xyz_Dens(i-1,j,k)                                    &
            &        + MIN( 0.0d0, xyza_Basic(i+1,j,k,:) + xyza_Var(i+1,j,k,:) ) &
            &           * xyza_QSUMPN(i+1,j,k,:)                               &
            &           * xyz_Dens(i+1,j,k)                                    &
            &        + MIN( 0.0d0, xyza_Basic(i,j-1,k,:) + xyza_Var(i,j-1,k,:) ) &
            &           * xyza_QSUMPN(i,j-1,k,:)                               &
            &           * xyz_Dens(i,j-1,k)                                    &
            &        + MIN( 0.0d0, xyza_Basic(i,j+1,k,:) + xyza_Var(i,j+1,k,:) ) &
            &           * xyza_QSUMPN(i,k+1,k,:)                               &
            &           * xyz_Dens(i,j+1,k)                                    &  
            &        + MIN( 0.0d0, xyza_Basic(i,j,k-1,:) + xyza_Var(i,j,k-1,:) ) &
            &           * xyza_QSUMPN(i,j,k-1,:)                               &
            &           * xyz_Dens(i,j,k-1)                                    &
            &        + MIN( 0.0d0, xyza_Basic(i,j,k+1,:) + xyza_Var(i,j,k+1,:) ) &
            &           * xyza_QSUMPN(i,j,k+1,:)                               &
            &           * xyz_Dens(i,j,k+1)                                    &  
            &       ) * 0.75d0                                                 &
            &      + ( MIN( 0.0d0, xyza_Basic(i-2,j,k,:) + xyza_Var(i-2,j,k,:) ) &
            &           * xyza_QSUMPN(i-2,j,k,:)                               &
            &           * xyz_Dens(i-2,j,k)                                    &
            &        + MIN( 0.0d0, xyza_Basic(i+2,j,k,:) + xyza_Var(i+2,j,k,:) ) &
            &           * xyza_QSUMPN(i+2,j,k,:)                               &
            &           * xyz_Dens(i+2,j,k)                                    &
            &        + MIN( 0.0d0, xyza_Basic(i,j-2,k,:) + xyza_Var(i,j-2,k,:) ) &
            &           * xyza_QSUMPN(i,j-2,k,:)                               &
            &           * xyz_Dens(i,j-2,k)                                    &
            &        + MIN( 0.0d0, xyza_Basic(i,j+2,k,:) + xyza_Var(i,j+2,k,:) ) &
            &           * xyza_QSUMPN(i,j+2,k,:)                               &
            &           * xyz_Dens(i,j+2,k)                                    &
            &        + MIN( 0.0d0, xyza_Basic(i,j,k-2,:) + xyza_Var(i,j,k-2,:) ) &
            &           * xyza_QSUMPN(i,j,k-2,:)                               &
            &           * xyz_Dens(i,j,k-2)                                    &
            &        + MIN( 0.0d0, xyza_Basic(i,j,k+2,:) + xyza_Var(i,j,k+2,:) ) &
            &           * xyza_QSUMPN(i,j,k+2,:)                                &
            &           * xyz_Dens(i,j,k+2)                                    &
            &       ) * 0.25d0                                                 &
            &     )
        end do
      end do
    end do
   

    !
    xyza_FillNegative_xyza = xyza_Var + xyza_DQFILL
    
  end function xyza_FillNegative_xyza

end module FillNegative_3d
