!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2006. All rights reserved.
!---------------------------------------------------------------------
!
!= 1  (z ) ֳָ߳ʻ ͭºʬǥ ⥸塼
!
!* 
!  * 2007/07/15 () : 3D deepconv ذܿ, dc_types  Use.
!  * 2006/06/02 () : x_bc_module 
!

module z_bc_module
  != 1  (z ) ֳָ߳ʻ ͭºʬǥ ⥸塼
  !
  !== 
  !
  ! z_bc_module , 1  (z ) ֳָ߳ʻҤѤͭºʬˡ
  ! ŤͥǥΤ,  Fortran 90 ץ
  ! .
  !
  ! Υ⥸塼 z_module β̥⥸塼Ǥ. ⥸塼
  ! Ȥ data_type, z_base_module ⥸塼ѤƤ. 
  !
  !
  !== ³̿̾ˡ
  !
  ! ꤹץ
  !
  !   Boundary[򼨤ʸ]_(μ)
  !
  ! Τ褦̿̾Ƥ. 򼨤ʸϰʲ 3 ĤǤ.
  !
  !   Sym  : о
  !   Asym : ȿо
  !   Cyc :  
  ! 

  use dc_types,      only : DBKIND => DP
  use z_base_module, only : km, zmargin, kmin, kmax
  implicit none

  private
  public :: BoundarySym_z, BoundaryAsym_z, BoundaryCyc_z
  public :: BoundarySym_r, BoundaryAsym_r, BoundaryCyc_r

  interface BoundaryCyc_z
    module procedure BoundaryCyc
  end interface 

  interface BoundaryCyc_r
    module procedure BoundaryCyc
  end interface 

  contains
!--------------------------------------------------------------------
    subroutine BoundarySym_z(z_Var)
      ! 1  (z ) оζŬѤ.

      real(DBKIND),intent(inout) :: z_Var(kmin:kmax) !  
      integer                    :: kz               ! 롼ź

      ! оζŬѤ
      ! 
      !   ex.) km=5, zmargin=2 ξ (kmin=-1, kmax=7)
      !
      !   r    -1   0   1   2   3   4   5   6   7 
      !     |-:-|-:-|-:-|-:-|-:-|-:-|-:-|-:-|-:-|
      !   z  -1   0   1   2   3   4   5   6   7
      !     <------->                   <------->  
      !    z_Var(kmin:0)          z_Var(km+1,kmax) ͤ򹹿
      !     
      !   z_Var(0)  = z_Var(1)
      !   z_Var(-1) = z_Var(2)
      !   z_Var(6)  = z_Var(5)
      !   z_Var(7)  = z_Var(4)
      !
      do kz = 1, zmargin
        z_Var(1-kz)  = z_Var(kz)
        z_Var(km+kz) = z_Var(km+1-kz)
      end do

    end subroutine BoundarySym_z
!--------------------------------------------------------------------
    subroutine BoundaryAsym_z(z_Var)
      ! 1  (z ) ȿоζŬѤ.

      real(DBKIND),intent(inout) :: z_Var(kmin:kmax) !  
      integer                    :: kz               ! 롼ź

      ! ȿоζŬѤ
      ! 
      !   ex.) km=5, zmargin=2 ξ (kmin=-1, kmax=7)
      !
      !   r    -1   0   1   2   3   4   5   6   7 
      !     |-:-|-:-|-:-|-:-|-:-|-:-|-:-|-:-|-:-|
      !   z  -1   0   1   2   3   4   5   6   7
      !     <------->                   <------->  
      !    z_Var(kmin:0)          z_Var(km+1,kmax) ͤ򹹿
      !     
      !   z_Var(0)  = - z_Var(1)
      !   z_Var(-1) = - z_Var(2)
      !   z_Var(6)  = - z_Var(5)
      !   z_Var(7)  = - z_Var(4)
      !
      do kz = 1, zmargin
        z_Var(1-kz)  = - z_Var(kz)
        z_Var(km+kz) = - z_Var(km+1-kz)
      end do

    end subroutine BoundaryAsym_z
!--------------------------------------------------------------------
    subroutine BoundarySym_r(r_Var)
      ! 1  (z ) оζŬѤ.

      real(DBKIND),intent(inout) :: r_Var(kmin:kmax) !  
      integer                    :: kz               ! 롼ź

      ! оζŬѤ
      ! 
      !   ex.) km=5, zmargin=2 ξ (kmin=-1, kmax=7)
      !
      !   r    -1   0   1   2   3   4   5   6   7 
      !     |-:-|-:-|-:-|-:-|-:-|-:-|-:-|-:-|-:-|
      !   z  -1   0   1   2   3   4   5   6   7
      !     <------->                   <------->  
      !    r_Var(kmin:-1)         r_Var(km+1:kmax) ͤ򹹿
      !     
      !   r_Var(-1) = z_Var(1)
      !   r_Var(6)  = z_Var(4)
      !   r_Var(7)  = z_Var(3)
      !
      do kz = 1, zmargin-1
        r_Var(-kz)   = r_Var(kz)      
      end do

      do kz = 1, zmargin
        r_Var(km+kz) = r_Var(km+1-kz)
      end do

    end subroutine BoundarySym_r
!--------------------------------------------------------------------
    subroutine BoundaryAsym_r(r_Var)
      ! 1  (z ) ȿоζŬѤ.

      real(DBKIND),intent(inout) :: r_Var(kmin:kmax) !  
      integer                    :: kz               ! 롼ź

      ! ȿоζŬѤ
      ! 
      !   ex.) km=5, zmargin=2 ξ (kmin=-1, kmax=7)
      !
      !   r    -1   0   1   2   3   4   5   6   7 
      !     |-:-|-:-|-:-|-:-|-:-|-:-|-:-|-:-|-:-|
      !   z  -1   0   1   2   3   4   5   6   7
      !     <------->                   <------->  
      !    r_Var(kmin:0)           r_Var(km,kmax) ͤ򹹿
      !     
      !   z_Var(0)  = 0
      !   z_Var(-1) = - z_Var(1)
      !   z_Var(5)  = 0
      !   z_Var(6)  = - z_Var(4)
      !   z_Var(7)  = - z_Var(3)
      !
      r_Var(0) = 0.0d0
      r_Var(km) = 0.0d0
          
      do kz = 1, zmargin-1
        r_Var(-kz) = - r_Var(kz)
      end do

      do kz = 1, zmargin
        r_Var(km+kz) = - r_Var(km-kz)
      end do

    end subroutine BoundaryAsym_r
!--------------------------------------------------------------------
    subroutine BoundaryCyc(Var)
      ! 1  (z ) ˼ŬѤ.

      real(DBKIND),intent(inout) :: Var(kmin:kmax) !  
      integer                    :: kz             ! 롼ź

      ! ŬѤ
      ! 
      !   ex.) km=5, zmargin=2 ξ (kmin=-1, kmax=7)
      !
      !   r    -1   0   1   2   3   4   5   6   7 
      !     |-:-|-:-|-:-|-:-|-:-|-:-|-:-|-:-|-:-|
      !   z  -1   0   1   2   3   4   5   6   7
      !     <------->                   <------->  
      !    z_Var(kmin:0)         z_Var(km+1,kmax) ͤ򹹿
      !    r_Var(kmin:0)         r_Var(km+1,kmax) ͤ򹹿
      !     
      !   z_Var(0)  = z_Var(5)
      !   z_Var(-1) = z_Var(4)
      !   z_Var(6)  = z_Var(1)
      !   z_Var(7)  = z_Var(2)
      !     
      !   r_Var(0)  = r_Var(5)
      !   r_Var(-1) = r_Var(4)
      !   r_Var(6)  = r_Var(1)
      !   r_Var(7)  = r_Var(2)
      !
      do kz = 1, zmargin
        Var(1-kz)  = Var(km+1-kz)
        Var(km+kz) = Var(kz)
      end do

    end subroutine BoundaryCyc
!--------------------------------------------------------------------
end module z_bc_module
